!--
!----------------------------------------------------------------------
!     Copyright (c) 2008 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  ͭꥵ֥롼 (SSL2TP)
!
!  2005/01/25  ݹ
!      2006/03/08  ݹ Ȥ RDoc Ѥѹ
!      2008/08/14  ݹ å ssl2 ֥롼
!      2009/01/29  ʿ Ȥ RDoc Ѥѹ
!
!++
module ssl2tp_eigen
  !
  != ssl2tp_eigen
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: ssl2tp_eigen.f90 590 2013-08-19 08:48:21Z uwabami $
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  ! 
  !== 
  !
  ! spml/ssl2tp_eigen  eigmatrix ⥸塼θ֥롼 eigen
  ! Ѥθͭͷ׻Ѷ̥󥿡եͿ.
  !
  !   *  AMAT  i ܸͭͤ eigen_r(i), eigen_i(i) ˳Ǽ
  !   * бͭ٥ȥ eigvec_r(:,i), eigvec_i(:,i) ˳Ǽ
  !   * Ǽͭͤοϰ eigen_r 礭Ƿޤ
  !   * ͭͤν֤ sort  order . 
  !   * sort ˤäƽ֤뤿Ѥ̤ꤹ. 
  !     (R), (RA), (I), (IA)
  !   * reverse ˤäƾ(.false.), 礭(.true.)Ǥ.
  !   * ǥեȤ sort='R', reverse=.false.
  !
  ! Ǥ DM_EIG1/SSL2TP 롼ˤ¹θͭ/ͭ٥ȥ׻
  ! ԤäƤ. , 桼ѤƤ饤֥ȥ֥롼ռ
  ! 뤳ȤʤȤȤǤ. 
  !
  use dc_message, only : MessageNotify

  implicit none
  private
  public dm_eig1_ssl2tp

contains
  subroutine dm_eig1_ssl2tp(amat,eigen_r,eigen_i,eigvec_r,eigvec_i,&
                          info,sort,reverse )
    !
    ! Υ֥롼ϸͭͷ׻Ѷ̥󥿡եͿ
    ! eigmatrix ⥸塼θ֥롼 eigen ȤѤ. 
    !
    !   *  AMAT  i ܸͭͤ eigen_r(i), eigen_i(i) ˳Ǽ
    !   * бͭ٥ȥ eigvec_r(:,i), eigvec_i(:,i) ˳Ǽ
    !   * Ǽͭͤοϰ eigen_r 礭Ƿޤ
    !
    !   * ͭͤν֤ sort  order . 
    !   * sort ˤäƽ֤뤿Ѥ̤ꤹ. 
    !     (R), (RA), (I), (IA)
    !   * reverse ˤäƾ(.false.), 礭(.true.)Ǥ.
    !   * ǥեȤ sort='R', reverse=.false.
    !
    ! Ǥ DM_EIG1/SSL2TP 롼ˤ¹θͭ/ͭ٥ȥ׻
    ! ԤäƤ. , 桼ѤƤ饤֥ȥ֥롼ռ
    ! 뤳ȤʤȤȤǤ. 
    !
    interface 
       function indexx(arrin)
         implicit none
         real(8), dimension(:), intent(in)  :: arrin
         integer, dimension(size(arrin))    :: indexx
       end function indexx
    end interface

   !------------  ------------
    real(8), dimension(:,:)                   :: amat      ! 
    real(8), intent(out), dimension(:)        :: eigen_r   ! ͭͼ¿
    real(8), intent(out), dimension(:)        :: eigen_i   ! ͭ͵
    real(8), intent(out), &
      dimension(size(amat,1),size(eigen_r))   :: eigvec_r  ! ͭ٥ȥ
    real(8), intent(out), &
      dimension(size(amat,1),size(eigen_i))   :: eigvec_i  ! ͭ٥ȥ
    integer, intent(out)                      :: info      ! ơ
    character(len=2), intent(in), optional    :: sort      ! ¤Ѥ
    logical, intent(in), optional             :: reverse   ! ¤Ѥå

   !------------ ѿ ------------
    real(8), dimension(size(amat,1))              :: wr    ! ͭͼ¿
    real(8), dimension(size(amat,1))              :: wi    ! ͭ͵
    real(8), dimension(size(amat,1),size(amat,1)) :: vec   ! ͭ٥ȥ
    real(8), dimension(size(amat,1))              :: work  ! ѿ
    integer, dimension(size(amat,1))              :: index ! ¤Ѥ
    integer, parameter :: mode=0! DM_EIG1Ϥå

    integer :: nm, i, j

    !------- å ------
    if (size(amat,1) /= size(amat,2))then
       call MessageNotify('E','DM_EIG1_SSL2','Input matrix not square')
    else
       nm = size(amat,1)
    endif

    !------- DM_EIG1/SSL2TP ˤ׻ ------
    call dm_eig1(amat,nm,nm,mode,wr,wi,vec,work,info)

    !------- ֥롼󥨥顼 -------
    if ( info /= 0 ) then
       call MessageNotify('W','DM_EIG1_SSL2',&
            'Error in calculating eigenvalues/vectors...',i=(/info/) )
       return
    endif

    !------- ͭ٥ȥ촹 -------
    if ( present(sort) ) then
       if ( sort == 'RA' ) then          ! ͭͼ
          index=indexx(abs(wr))
       elseif ( trim(sort) == 'I' ) then ! ͭ͵
          index=indexx(wi)
       elseif ( sort == 'IA' ) then      ! ͭ͵
          index=indexx(abs(wi))
       else
          index=indexx(wr)               ! defaultϸͭͼ
       endif
    else
       index=indexx(wr)                  ! defaultϸͭͼ
    endif

    if ( present(reverse) )then
       if ( reverse ) then               ! 礭
          index=index(size(index):1:-1)
       endif
    endif

    do i=1,size(eigen_r)
       j = index(i)
       eigen_r(i) = wr(j)
       eigen_i(i) = wi(j)

       if ( wi(j) == 0 ) then
          eigvec_r(:,i) = vec(:,j)
          eigvec_i(:,i) = 0.0
       else if ( wi(j) == -wi(j+1) ) then
          eigvec_r(:,i) = vec(:,j)
          eigvec_i(:,i) = vec(:,j+1)
       else
          eigvec_r(:,i) = vec(:,j-1)
          eigvec_i(:,i) = -vec(:,j)
       endif
    enddo

  end subroutine dm_eig1_ssl2tp

end module ssl2tp_eigen
