!--
!----------------------------------------------------------------------
!     Copyright (c) 2011 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  ʣǸͭꥵ֥롼 (LAPACK)
!
!  2011/11/05  ݹ
!
!      Debian/GNU Linux + Fujitsu frt ʤ
!      lapack, lapack-deb ѥå򥤥󥹥ȡ뤷, 
!         -llapack -lblas -L/usr/lib/gcc-lib/i386-linux/2.95.4 -lg2c
!      ȤäץĤ٤. 
!++
module lapack_ceigen
  !
  != lapack_ceigen
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: 
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  ! 
  !== 
  !
  ! spml/lapack_ceigen  eigmatrix ⥸塼θ֥롼 
  ! ceigen Ѥθͭͷ׻Ѷ̥󥿡եͿ.
  !
  !   *  CMAT  i ܸͭͤ eigen(i) ˳Ǽ
  !   * бͭ٥ȥ eigvec(:,i) ˳Ǽ
  !   * Ǽͭͤοϰ eigen 礭Ƿޤ
  !   * ͭͤν֤ sort  order . 
  !   * sort ˤäƽ֤뤿Ѥ̤ꤹ. 
  !     (R), (RA), (I), (IA)
  !   * reverse ˤäƾ(.false.), 礭(.true.)Ǥ.
  !   * ǥեȤ sort='R', reverse=.false.
  !   *  CMAT ¸ʤ.
  !
  ! Ǥ ZGEEV/LAPACK 롼ˤ¹θͭ/ͭ٥ȥ׻
  ! ԤäƤ. , 桼ѤƤ饤֥ȥ֥롼ռ
  ! 뤳ȤʤȤȤǤ. 
  !
  use dc_message, only : MessageNotify

  implicit none
  private
  public dceigen_lapack

contains
  subroutine dceigen_lapack(cmat,eigen,eigvec,info,sort,reverse)
    !
    ! Υ֥롼ϸͭͷ׻Ѷ̥󥿡եͿ
    ! eigmatrix ⥸塼θ֥롼 ceigen ȤѤ. 
    !
    !   *  CMAT  i ܸͭͤ eigen(i) ˳Ǽ
    !   * бͭ٥ȥ eigvec(:,i) ˳Ǽ
    !   * Ǽͭͤοϰ eigen 礭Ƿޤ
    !   * ͭͤν֤ sort  order . 
    !   * sort ˤäƽ֤뤿Ѥ̤ꤹ. 
    !     (R), (RA), (I), (IA)
    !   * reverse ˤäƾ(.false.), 礭(.true.)Ǥ.
    !   * ǥեȤ sort='R', reverse=.false.
    !   *  CMAT ¸ʤ.
    !
    ! Ǥ ZGEEV/LAPACK 롼ˤ¹θͭ/ͭ٥ȥ׻
    ! ԤäƤ. , 桼ѤƤ饤֥ȥ֥롼ռ
    ! 뤳ȤʤȤȤǤ. 
    !
    interface 
       function indexx(arrin)
         implicit none
         real(8), dimension(:), intent(in)  :: arrin
         integer, dimension(size(arrin))    :: indexx
       end function indexx
    end interface

   !------------  ------------
    complex(8), dimension(:,:)                :: cmat      ! 
    complex(8), intent(out), dimension(:)     :: eigen     ! ͭͼ¿
    complex(8), intent(out), &
      dimension(size(cmat,1),size(eigen))     :: eigvec    ! ͭ٥ȥ
    integer, intent(out)                      :: info      ! ơ
    character(len=2), intent(in), optional    :: sort      ! ¤Ѥ
    logical, intent(in), optional             :: reverse   ! ¤Ѥå

   !------------ ѿ ------------
    complex(8), dimension(size(cmat,1))              :: ceig  ! ͭ
    complex(8), dimension(size(cmat,1),size(cmat,1)) :: vl    ! ͭ٥ȥ
    complex(8), dimension(size(cmat,1),size(cmat,1)) :: vr    ! ͭ٥ȥ
    complex(8), dimension(size(cmat,1)*2)            :: work  ! ѿ
    real(8), dimension(size(cmat,1)*2)               :: rwork ! ѿ
    integer, dimension(size(cmat,1))                 :: index ! ¤Ѥ
    character(len=1), parameter :: jobvl='N', jobvr='V'  ! ZEGGV Ϥå

    integer :: nm, i, j

    !------- å ------
    if (size(cmat,1) /= size(cmat,2))then
       call MessageNotify('E','DCEIGEN_LAPACK','Input matrix not square')
    else
       nm = size(cmat,1)
    endif

    !------- DGEEV/LAPACK ˤ׻ ------
    call ZGEEV( jobvl, jobvr, nm, cmat, nm, ceig,   &
                vl, nm, vr, nm, work, nm*2, rwork, info )

    !------- ֥롼󥨥顼 -------
    if ( info /= 0 ) then
       call MessageNotify('W','DCEIGEN_LAPACK',&
            'Error in calculating eigenvalues/vectors...',i=(/info/) )
       return
    endif

    !------- ͭ٥ȥ촹 -------
    if ( present(sort) ) then
       if ( sort == 'RA' ) then          ! ͭͼ
          index=indexx(abs(dble(ceig)))
       elseif ( trim(sort) == 'I' ) then ! ͭ͵
          index=indexx(dimag(ceig))
       elseif ( sort == 'IA' ) then      ! ͭ͵
          index=indexx(abs(dimag(ceig)))
       else
          index=indexx(dble(ceig))       ! defaultϸͭͼ
       endif
    else
       index=indexx(dble(ceig))          ! defaultϸͭͼ
    endif

    if ( present(reverse) )then
       if ( reverse ) then               ! 礭
          index=index(size(index):1:-1)
       endif
    endif

    do i=1,size(eigen)
       j = index(i)
       eigen(i)    = ceig(j)
       eigvec(:,i) = vr(:,j)
    enddo

  end subroutine dceigen_lapack

end module lapack_ceigen
