*-----------------------------------------------------------------------
*     TMSLCL : MAIN SOLVER ROUTINE FOR CALCULATING STREAM LINES (RK4)
*-----------------------------------------------------------------------
*     COPYRIGHT (C) 2000-2017 GFD DENNOU CLUB. ALL RIGHTS RESERVED.
*-----------------------------------------------------------------------
      SUBROUTINE TMSLCL( INI_X, INI_Y, NX, NY, X, Y, U, V, 
     &                   TRAJX, TRAJY, TRAJN, GRID_FLAG )


      IMPLICIT NONE


      REAL    INI_X                ! STARTING POINT (X) [UNIT:LENGTH]
      REAL    INI_Y                ! STARTING POINT (Y) [UNIT:LENGTH]
      INTEGER NX                   ! GRID NUMBER OF X-DIRECTION
      INTEGER NY                   ! GRID NUMBER OF Y-DIRECTION
      REAL    X(NX)                ! X-COORDINATE [UNIT:LENGTH]
      REAL    Y(NY)                ! Y-COORDINATE [UNIT:LENGTH]
      REAL    U(NX,NY)             ! VECTOR COMPONENT OF X-DIRECTION
      REAL    V(NX,NY)             ! VECTOR COMPONENT OF Y-DIRECTION
      REAL    TRAJX(NX*NY)         ! POSITIONS OF STREAM LINE (X) [UNIT:LENGTH]
      REAL    TRAJY(NX*NY)         ! POSITIONS OF STREAM LINE (Y) [UNIT:LENGTH]
      INTEGER TRAJN                ! RANGE OF DRAWING STREAM LINE (STEP>=TRAJN)
      INTEGER GRID_FLAG(NX,NY)     ! NUMBER OF PASSING STREAM LINES IN EACH GRID.

      INTEGER NXZ
      PARAMETER (NXZ=10)
      INTEGER NYZ
      PARAMETER (NYZ=10)


*-- INTERNAL VALUES
      LOGICAL CONTINU_FLAG(NXZ,NYZ)  ! FLAG VALUE TO PREVENT THE IDENTICAL 
                                   ! STREAM LINE FROM CONTINUOUS COUNTING
                                   ! IN EACH GRID.
                                   ! ƥåפƱʻˤΤ
                                   ! Ȥ뤳ȤɤΥե饰.

      CALL TMZLCL( INI_X, INI_Y, NX, NY, X, Y, U, V, 
     &                   TRAJX, TRAJY, TRAJN, GRID_FLAG,CONTINU_FLAG )

      END SUBROUTINE TMSLCL
