#-----------------------------------------------------------------------
#     Copyright (C) 2000-2004 GFD Dennou Club. All rights reserved.
#-----------------------------------------------------------------------

require "numru/dcl"

include NumRu
include NMath

raise "This program is for DCL 5.3 or later" unless DCL::DCLVERSION >= '5.3'

# / SET PARAMETERS /

nx = 15
ny = 15
ux = NArray.sfloat(nx).indgen!/(nx-1) - 0.5
terrain = 0.1 * exp(-24*ux**2)
uy = NArray.sfloat(ny).indgen!/(nx-1)
cx = NArray.sfloat(nx,ny)
cy = NArray.sfloat(nx,ny)

cx[0,0] = DCL::glrget('rundef')
for j in 0...ny
  for i in 0...nx
    cy[i,j] = uy[j]*(1.0-terrain[i]) + terrain[i]
  end
end

# / GRAPHIC /

iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn(iws)
DCL::grfrm
DCL::grsvpt(0.15,0.85,0.15,0.85)
DCL::grswnd(ux[0],ux[-1],uy[0],uy[-1])
DCL::g2sctr(ux,uy,cx,cy)
DCL::grstrn(51)
DCL::grstrf

# / TONE /

z = NArray.sfloat(nx,ny)
for j in 0...ny
  for i in 0...nx
    z[i,j] = ux[i] * (1-uy[j])
  end
end

DCL::uelset('ltone',true)
DCL::uwsgxa(ux)
DCL::uwsgya(uy)
DCL::uetone(z)

# / GRID LINES /

for j in 0...ny
  uyw = NArray.sfloat(nx).fill!(uy[j])
  DCL::sgplu(ux,uyw)
end

for i in 0...nx
  uxw = NArray.sfloat(ny).fill!(ux[i])
  DCL::sgplu(uxw,uy)
end

#  / AXES  (Switch to ITR==1) /

cxmin, cxmax, cymin, cymax = DCL::g2qctm
p cxmin, cxmax, cymin, cymax
DCL::grswnd(cxmin,cxmax,cymin,cymax)
DCL::grstrn(1)
DCL::grstrf
DCL::usdaxs
DCL::uxsttl('t','TERRAIN FOLLOWING',0.0)
DCL::grcls
