#!/usr/bin/python3
"""
Driver for dh-fortran

Copyright (C) 2025 Alastair McKinstry <mckinstry@debian.org>
Released under the GPL-3 Gnu Public License.
"""


import click
import os
import sys
import dhfortran.compilers


from contextlib import contextmanager


@contextmanager
def errhandler(*args, **kwargs):
    try:
        # print(*args, **kwargs)
        # breakpoint() here, or maybe dump on DH_VERBOSE?
        yield
    except Exception as ex:
        print(f"Error: {ex}")
        sys.exit(1)


@click.group()
def dh_fortran():
    pass


@click.command("get_fc_flags")
@click.option("--fc")
def get_fc_flags(fc):
    print(fc)


@click.command("get_fc_default")
def get_fc_default():
    pass


@click.command("get_fc_optional")
def get_fc_optional():
    pass


@click.command("get_fc_exe")
@click.option("--flavor")
def get_fc_exe(flavor):
    pass


@click.command("get_fc_vendor")
@click.option("--flavor")
def get_fc_vendor(flavor):
    pass
