/****
DIAMOND protein aligner
Copyright (C) 2020 Max Planck Society for the Advancement of Science e.V.

Code developed by Benjamin Buchfink <benjamin.buchfink@tue.mpg.de>

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
****/

#include "../standard_matrix.h"

namespace Stats {

const StandardMatrix blosum62{

    11, 1, 

	{{ (double)INT2_MAX, (double)INT2_MAX, (double)INT2_MAX, 0.3176, 0.134, 0.4012, 0.7916, -3.2, 0.623757, 4.964660, 4.964660 },
	{ 11, 2, (double)INT2_MAX, 0.297, 0.082, 0.27, 1.1, -10, 0.641766, 12.673800, 12.757600 },
	{ 10, 2, (double)INT2_MAX, 0.291, 0.075, 0.23, 1.3, -15, 0.649362, 16.474000, 16.602600 },
	{ 9, 2, (double)INT2_MAX, 0.279, 0.058, 0.19, 1.5, -19, 0.659245, 22.751900, 22.950000 },
	{ 8, 2, (double)INT2_MAX, 0.264, 0.045, 0.15, 1.8, -26, 0.672692, 35.483800, 35.821300 },
	{ 7, 2, (double)INT2_MAX, 0.239, 0.027, 0.10, 2.5, -46, 0.702056, 61.238300, 61.886000 },
	{ 6, 2, (double)INT2_MAX, 0.201, 0.012, 0.061, 3.3, -58, 0.740802, 140.417000, 141.882000 },
	{ 13, 1, (double)INT2_MAX, 0.292, 0.071, 0.23, 1.2, -11, 0.647715, 19.506300, 19.893100 },
	{ 12, 1, (double)INT2_MAX, 0.283, 0.059, 0.19, 1.5, -19, 0.656391, 27.856200, 28.469900 },
	{ 11, 1, (double)INT2_MAX, 0.267, 0.041, 0.14, 1.9, -30, 0.669720, 42.602800, 43.636200 },
	{ 10, 1, (double)INT2_MAX, 0.243, 0.024, 0.10, 2.5, -44, 0.693267, 83.178700, 85.065600 },
	{ 9, 1, (double)INT2_MAX, 0.206, 0.010, 0.052, 4.0, -87, 0.731887, 210.333000, 214.842000 }},

{
    /*       A,  R,  N,  D,  C,  Q,  E,  G,  H,  I,  L,  K,  M,
             F,  P,  S,  T,  W,  Y,  V,  B,  J,  Z,  X,  *        */ 
    /*A*/    4, -1, -2, -2,  0, -1, -1,  0, -2, -1, -1, -1, -1,
            -2, -1,  1,  0, -3, -2,  0, -2, -1, -1, -1, -4, -12,
    /*R*/   -1,  5,  0, -2, -3,  1,  0, -2,  0, -3, -2,  2, -1,
            -3, -2, -1, -1, -3, -2, -3, -1, -2,  0, -1, -4, -12,
    /*N*/   -2,  0,  6,  1, -3,  0,  0,  0,  1, -3, -3,  0, -2,
            -3, -2,  1,  0, -4, -2, -3,  4, -3,  0, -1, -4, -12,
    /*D*/   -2, -2,  1,  6, -3,  0,  2, -1, -1, -3, -4, -1, -3,
            -3, -1,  0, -1, -4, -3, -3,  4, -3,  1, -1, -4, -12,
    /*C*/    0, -3, -3, -3,  9, -3, -4, -3, -3, -1, -1, -3, -1,
            -2, -3, -1, -1, -2, -2, -1, -3, -1, -3, -1, -4, -12,
    /*Q*/   -1,  1,  0,  0, -3,  5,  2, -2,  0, -3, -2,  1,  0,
            -3, -1,  0, -1, -2, -1, -2,  0, -2,  4, -1, -4, -12,
    /*E*/   -1,  0,  0,  2, -4,  2,  5, -2,  0, -3, -3,  1, -2,
            -3, -1,  0, -1, -3, -2, -2,  1, -3,  4, -1, -4, -12,
    /*G*/    0, -2,  0, -1, -3, -2, -2,  6, -2, -4, -4, -2, -3,
            -3, -2,  0, -2, -2, -3, -3, -1, -4, -2, -1, -4, -12,
    /*H*/   -2,  0,  1, -1, -3,  0,  0, -2,  8, -3, -3, -1, -2,
            -1, -2, -1, -2, -2,  2, -3,  0, -3,  0, -1, -4, -12,
    /*I*/   -1, -3, -3, -3, -1, -3, -3, -4, -3,  4,  2, -3,  1,
             0, -3, -2, -1, -3, -1,  3, -3,  3, -3, -1, -4, -12,
    /*L*/   -1, -2, -3, -4, -1, -2, -3, -4, -3,  2,  4, -2,  2,
             0, -3, -2, -1, -2, -1,  1, -4,  3, -3, -1, -4, -12,
    /*K*/   -1,  2,  0, -1, -3,  1,  1, -2, -1, -3, -2,  5, -1,
            -3, -1,  0, -1, -3, -2, -2,  0, -3,  1, -1, -4, -12,
    /*M*/   -1, -1, -2, -3, -1,  0, -2, -3, -2,  1,  2, -1,  5,
             0, -2, -1, -1, -1, -1,  1, -3,  2, -1, -1, -4, -12,
    /*F*/   -2, -3, -3, -3, -2, -3, -3, -3, -1,  0,  0, -3,  0,
             6, -4, -2, -2,  1,  3, -1, -3,  0, -3, -1, -4, -12,
    /*P*/   -1, -2, -2, -1, -3, -1, -1, -2, -2, -3, -3, -1, -2,
            -4,  7, -1, -1, -4, -3, -2, -2, -3, -1, -1, -4, -12,
    /*S*/    1, -1,  1,  0, -1,  0,  0,  0, -1, -2, -2,  0, -1,
            -2, -1,  4,  1, -3, -2, -2,  0, -2,  0, -1, -4, -12,
    /*T*/    0, -1,  0, -1, -1, -1, -1, -2, -2, -1, -1, -1, -1,
            -2, -1,  1,  5, -2, -2,  0, -1, -1, -1, -1, -4, -12,
    /*W*/   -3, -3, -4, -4, -2, -2, -3, -2, -2, -3, -2, -3, -1,
             1, -4, -3, -2, 11,  2, -3, -4, -2, -2, -1, -4, -12,
    /*Y*/   -2, -2, -2, -3, -2, -1, -2, -3,  2, -1, -1, -2, -1,
             3, -3, -2, -2,  2,  7, -1, -3, -1, -2, -1, -4, -12,
    /*V*/    0, -3, -3, -3, -1, -2, -2, -3, -3,  3,  1, -2,  1,
            -1, -2, -2,  0, -3, -1,  4, -3,  2, -2, -1, -4, -12,
    /*B*/   -2, -1,  4,  4, -3,  0,  1, -1,  0, -3, -4,  0, -3,
            -3, -2,  0, -1, -4, -3, -3,  4, -3,  0, -1, -4, -12,
    /*J*/   -1, -2, -3, -3, -1, -2, -3, -4, -3,  3,  3, -3,  2,
             0, -3, -2, -1, -2, -1,  2, -3,  3, -3, -1, -4, -12,
    /*Z*/   -1,  0,  0,  1, -3,  4,  4, -2,  0, -3, -3,  1, -1,
            -3, -1,  0, -1, -2, -2, -2,  0, -3,  4, -1, -4, -12,
    /*X*/   -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
            -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -4, -12,
    /***/   -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4,
            -4, -4, -4, -4, -4, -4, -4, -4, -4, -4, -4,  1, -12,
			-12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12,
			-12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12, -12
},

	{{2.1497573378347484e-02, 2.3470224274721213e-03, 1.9493235258876179e-03,
   2.1674844853066858e-03, 1.5903351423026848e-03, 1.9242657898716525e-03,
   2.9879059292799641e-03, 5.8158526388051033e-03, 1.1076584657559144e-03,
   3.1880644746334580e-03, 4.4186245468471547e-03, 3.3466571942021082e-03,
   1.3412107617355408e-03, 1.6360627863999076e-03, 2.1568959784943114e-03,
   6.2524987419815400e-03, 3.7180506975672363e-03, 4.0281679108936688e-04,
   1.2999956675626666e-03, 5.0679056444508912e-03},
  {2.3470224274721213e-03, 1.7757465118386322e-02, 1.9786027128591904e-03,
   1.5865480081162602e-03, 3.9365984789376245e-04, 2.4858611089731411e-03,
   2.6933867548771758e-03, 1.7221140903704937e-03, 1.2407382229440791e-03,
   1.2435878276496955e-03, 2.4193952633248727e-03, 6.2339060289407083e-03,
   8.0309461712520876e-04, 9.3181986323789834e-04, 9.5783034332718700e-04,
   2.2660898636037261e-03, 1.7802796534180537e-03, 2.6571979312581875e-04,
   9.2634607111251918e-04, 1.5810185245264004e-03},
  {1.9493235258876179e-03, 1.9786027128591904e-03, 1.4140291972553610e-02,
   3.7201973506001745e-03, 4.3845466068066216e-04, 1.5304436972610567e-03,
   2.2097156829738759e-03, 2.8591871815612977e-03, 1.4301072616183181e-03,
   9.9437221166923172e-04, 1.3690958423974782e-03, 2.4402105140841090e-03,
   5.2943633069226512e-04, 7.5004227978192801e-04, 8.6016459857770028e-04,
   3.1466019144814608e-03, 2.2360795375444384e-03, 1.6159545671597605e-04,
   7.0048422794024819e-04, 1.2014015528772706e-03},
  {2.1674844853066858e-03, 1.5865480081162602e-03, 3.7201973506001745e-03,
   2.1274574617480089e-02, 3.9909227141697264e-04, 1.6481246723433428e-03,
   4.9158017471929655e-03, 2.5221102126636373e-03, 9.5384849402143984e-04,
   1.2347404942429857e-03, 1.5202051791453383e-03, 2.4453087721980561e-03,
   4.6429229320514104e-04, 7.6023722413111566e-04, 1.2373315413524663e-03,
   2.8035127901697272e-03, 1.8961512776990257e-03, 1.6218020183662784e-04,
   5.9842263937853702e-04, 1.3158365660538270e-03},
  {1.5903351423026848e-03, 3.9365984789376245e-04, 4.3845466068066216e-04,
   3.9909227141697264e-04, 1.1931352277704348e-02, 3.0937204045913537e-04,
   3.8338775043186374e-04, 7.6951976030099293e-04, 2.2976387481074697e-04,
   1.0956590131781735e-03, 1.5682982157153873e-03, 5.0124929379033781e-04,
   3.7717165634097634e-04, 5.1389991547056834e-04, 3.6111795849154795e-04,
   1.0432626586831986e-03, 9.3041313726939057e-04, 1.4474923964368156e-04,
   3.4603772624580643e-04, 1.3606607271146112e-03},
  {1.9242657898716525e-03, 2.4858611089731411e-03, 1.5304436972610567e-03,
   1.6481246723433428e-03, 3.0937204045913537e-04, 7.3292255467189687e-03,
   3.5385780499965817e-03, 1.3683038039160171e-03, 1.0489026828741754e-03,
   8.9102936026571569e-04, 1.6174411456311808e-03, 3.0968229715707327e-03,
   7.3993258722701268e-04, 5.4255147972143906e-04, 8.4668181752066874e-04,
   1.8931125300036275e-03, 1.3796838284921874e-03, 2.2737931366728891e-04,
   6.7584155312457842e-04, 1.1660966117775285e-03},
  {2.9879059292799641e-03, 2.6933867548771758e-03, 2.2097156829738759e-03,
   4.9158017471929655e-03, 3.8338775043186374e-04, 3.5385780499965817e-03,
   1.6133927472163669e-02, 1.9380952488713059e-03, 1.3667885452189439e-03,
   1.2192061706431622e-03, 2.0030316026648431e-03, 4.1322603720305197e-03,
   6.7909745467514783e-04, 8.5179405867513139e-04, 1.4216207127018586e-03,
   2.9539180653600089e-03, 2.0493063257644955e-03, 2.6488552587183780e-04,
   8.7044186256788659e-04, 1.6987763526262680e-03},
  {5.8158526388051033e-03, 1.7221140903704937e-03, 2.8591871815612977e-03,
   2.5221102126636373e-03, 7.6951976030099293e-04, 1.3683038039160171e-03,
   1.9380952488713059e-03, 3.7804346453413303e-02, 9.5813607255887238e-04,
   1.3849118546156933e-03, 2.0864716056392773e-03, 2.5392537741810947e-03,
   7.3281559749652399e-04, 1.1976708695723554e-03, 1.3641171883713547e-03,
   3.8342830901664762e-03, 2.1858459940987062e-03, 4.0740829083805248e-04,
   8.3467413018106177e-04, 1.8218235950233687e-03},
  {1.1076584657559144e-03, 1.2407382229440791e-03, 1.4301072616183181e-03,
   9.5384849402143984e-04, 2.2976387481074697e-04, 1.0489026828741754e-03,
   1.3667885452189439e-03, 9.5813607255887238e-04, 9.2802502369336622e-03,
   5.8089627083019206e-04, 9.8696608463236094e-04, 1.1873625842258938e-03,
   3.8264639620910225e-04, 8.1041076335565583e-04, 4.7770135861914477e-04,
   1.1052034635193162e-03, 7.4371746073077327e-04, 1.5168037757411286e-04,
   1.5213771111755425e-03, 6.4882907765797669e-04},
  {3.1880644746334580e-03, 1.2435878276496955e-03, 9.9437221166923172e-04,
   1.2347404942429857e-03, 1.0956590131781735e-03, 8.9102936026571569e-04,
   1.2192061706431622e-03, 1.3849118546156933e-03, 5.8089627083019206e-04,
   1.8441526588740136e-02, 1.1382470627796603e-02, 1.5655862274689192e-03,
   2.5081290988482057e-03, 3.0458868657559346e-03, 1.0068164685944146e-03,
   1.7225081689171561e-03, 2.6953622613315018e-03, 3.6183761166072852e-04,
   1.3821121844492116e-03, 1.1972663837662637e-02},
  {4.4186245468471547e-03, 2.4193952633248727e-03, 1.3690958423974782e-03,
   1.5202051791453383e-03, 1.5682982157153873e-03, 1.6174411456311808e-03,
   2.0030316026648431e-03, 2.0864716056392773e-03, 9.8696608463236094e-04,
   1.1382470627796603e-02, 3.7141460156350926e-02, 2.4634345023228079e-03,
   4.9293545515183088e-03, 5.4151301166464015e-03, 1.4146090399381900e-03,
   2.4277107072013821e-03, 3.3238031308707055e-03, 7.3206640617832933e-04,
   2.2096734692836624e-03, 9.4786263030457313e-03},
  {3.3466571942021082e-03, 6.2339060289407083e-03, 2.4402105140841090e-03,
   2.4453087721980561e-03, 5.0124929379033781e-04, 3.0968229715707327e-03,
   4.1322603720305197e-03, 2.5392537741810947e-03, 1.1873625842258938e-03,
   1.5655862274689192e-03, 2.4634345023228079e-03, 1.6113385590544604e-02,
   9.0876633395557617e-04, 9.4875149773685364e-04, 1.5773020912564391e-03,
   3.1016069999481111e-03, 2.3467014804084987e-03, 2.7198500003555514e-04,
   9.9908866586876396e-04, 1.9360424083099779e-03},
  {1.3412107617355408e-03, 8.0309461712520876e-04, 5.2943633069226512e-04,
   4.6429229320514104e-04, 3.7717165634097634e-04, 7.3993258722701268e-04,
   6.7909745467514783e-04, 7.3281559749652399e-04, 3.8264639620910225e-04,
   2.5081290988482057e-03, 4.9293545515183088e-03, 9.0876633395557617e-04,
   4.0477309321969848e-03, 1.1901770463553603e-03, 4.0824445213456919e-04,
   8.5603787638552766e-04, 1.0095451907679563e-03, 1.9872537223131380e-04,
   5.7145288352831449e-04, 2.3123361470140736e-03},
  {1.6360627863999076e-03, 9.3181986323789834e-04, 7.5004227978192801e-04,
   7.6023722413111566e-04, 5.1389991547056834e-04, 5.4255147972143906e-04,
   8.5179405867513139e-04, 1.1976708695723554e-03, 8.1041076335565583e-04,
   3.0458868657559346e-03, 5.4151301166464015e-03, 9.4875149773685364e-04,
   1.1901770463553603e-03, 1.8277684015431908e-02, 5.2528021756783813e-04,
   1.1939618185901600e-03, 1.1624184369750680e-03, 8.4917468952377874e-04,
   4.2392005745634370e-03, 2.5763052227920180e-03},
  {2.1568959784943114e-03, 9.5783034332718700e-04, 8.6016459857770028e-04,
   1.2373315413524663e-03, 3.6111795849154795e-04, 8.4668181752066874e-04,
   1.4216207127018586e-03, 1.3641171883713547e-03, 4.7770135861914477e-04,
   1.0068164685944146e-03, 1.4146090399381900e-03, 1.5773020912564391e-03,
   4.0824445213456919e-04, 5.2528021756783813e-04, 1.9066033679132538e-02,
   1.6662567934883051e-03, 1.3511005665728870e-03, 1.4152209821874487e-04,
   4.5224391125285910e-04, 1.2451325046931832e-03},
	{ 6.2524987419815400e-03, 2.2660898636037261e-03, 3.1466019144814608e-03,
	 2.8035127901697272e-03, 1.0432626586831986e-03, 1.8931125300036275e-03,
	 2.9539180653600089e-03, 3.8342830901664762e-03, 1.1052034635193162e-03,
	 1.7225081689171561e-03, 2.4277107072013821e-03, 3.1016069999481111e-03,
	 8.5603787638552766e-04, 1.1939618185901600e-03, 1.6662567934883051e-03,
	 1.2585947097159817e-02, 4.7004857686835334e-03, 2.8731729176487776e-04,
	 1.0299846310599138e-03, 2.3587292053265561e-03 },
	{ 3.7180506975672363e-03, 1.7802796534180537e-03, 2.2360795375444384e-03,
	 1.8961512776990257e-03, 9.3041313726939057e-04, 1.3796838284921874e-03,
	 2.0493063257644955e-03, 2.1858459940987062e-03, 7.4371746073077327e-04,
	 2.6953622613315018e-03, 3.3238031308707055e-03, 2.3467014804084987e-03,
	 1.0095451907679563e-03, 1.1624184369750680e-03, 1.3511005665728870e-03,
	 4.7004857686835334e-03, 1.2514818886617953e-02, 2.8575770858467209e-04,
	 9.4161039895612720e-04, 3.6402328079338207e-03 },
	{ 4.0281679108936688e-04, 2.6571979312581875e-04, 1.6159545671597605e-04,
	 1.6218020183662784e-04, 1.4474923964368156e-04, 2.2737931366728891e-04,
	 2.6488552587183780e-04, 4.0740829083805248e-04, 1.5168037757411286e-04,
	 3.6183761166072852e-04, 7.3206640617832933e-04, 2.7198500003555514e-04,
	 1.9872537223131380e-04, 8.4917468952377874e-04, 1.4152209821874487e-04,
	 2.8731729176487776e-04, 2.8575770858467209e-04, 6.4699301717154852e-03,
	 8.8744160259272527e-04, 3.5578318710317554e-04 },
	{ 1.2999956675626666e-03, 9.2634607111251918e-04, 7.0048422794024819e-04,
	 5.9842263937853702e-04, 3.4603772624580643e-04, 6.7584155312457842e-04,
	 8.7044186256788659e-04, 8.3467413018106177e-04, 1.5213771111755425e-03,
	 1.3821121844492116e-03, 2.2096734692836624e-03, 9.9908866586876396e-04,
	 5.7145288352831449e-04, 4.2392005745634370e-03, 4.5224391125285910e-04,
	 1.0299846310599138e-03, 9.4161039895612720e-04, 8.8744160259272527e-04,
	 1.0246100213822419e-02, 1.5489827890922993e-03 },
	{ 5.0679056444508912e-03, 1.5810185245264004e-03, 1.2014015528772706e-03,
	 1.3158365660538270e-03, 1.3606607271146112e-03, 1.1660966117775285e-03,
	 1.6987763526262680e-03, 1.8218235950233687e-03, 6.4882907765797669e-04,
	 1.1972663837662637e-02, 9.4786263030457313e-03, 1.9360424083099779e-03,
	 2.3123361470140736e-03, 2.5763052227920180e-03, 1.2451325046931832e-03,
	 2.3587292053265561e-03, 3.6402328079338207e-03, 3.5578318710317554e-04,
	 1.5489827890922993e-03, 1.9631915140537640e-02 } },

   { 7.4216205067993410e-02, 5.1614486141284638e-02, 4.4645808512757915e-02,
5.3626000838554413e-02, 2.4687457167944848e-02, 3.4259650591416023e-02,
5.4311925684587502e-02, 7.4146941452644999e-02, 2.6212984805266227e-02,
6.7917367618953756e-02, 9.8907868497150955e-02, 5.8155682303079680e-02,
2.4990197579643110e-02, 4.7418459742284751e-02, 3.8538003320306206e-02,
5.7229029476494421e-02, 5.0891364550287033e-02, 1.3029956129972148e-02,
3.2281512313758580e-02, 7.2919098205619245e-02 },

  { {0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
    0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
    0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
    0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
    0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
    0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00,
    0.00000000e+00, 0.00000000e+00, 0.00000000e+00, 0.00000000e+00},
   {0.00000000e+00, 3.90294070e+00, 5.64459671e-01, 8.67987664e-01,
    5.44605275e-01, 7.41264113e-01, 4.64893827e-01, 1.05686961e+00,
    5.69364849e-01, 6.32481035e-01, 7.75390239e-01, 6.01945975e-01,
    7.23150342e-01, 5.88307640e-01, 7.54121369e-01, 7.56803943e-01,
    6.12698600e-01, 1.47210399e+00, 9.84401956e-01, 9.36458396e-01,
    4.16548781e-01, 7.50000000e-01, 5.42611869e-01, 7.47274948e-01,
    7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 6.14377313e-01},
   {0.00000000e+00, 5.64459671e-01, 4.43758048e+00, 3.45226274e-01,
    4.74290926e+00, 1.33503378e+00, 3.24101420e-01, 7.38524318e-01,
    9.25449581e-01, 3.33981361e-01, 8.54849426e-01, 2.97257620e-01,
    4.04640322e-01, 4.07083696e+00, 5.53838329e-01, 9.44103648e-01,
    7.02873767e-01, 1.05798620e+00, 8.26250098e-01, 3.51280513e-01,
    2.52855433e-01, 7.50000000e-01, 4.09444638e-01, 1.18382127e+00,
    7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 3.12208474e-01},
   {0.00000000e+00, 8.67987664e-01, 3.45226274e-01, 1.95765857e+01,
    3.01454345e-01, 2.85934574e-01, 4.38990118e-01, 4.20387870e-01,
    3.55049505e-01, 6.53458801e-01, 3.49128465e-01, 6.42275633e-01,
    6.11354340e-01, 3.97802620e-01, 3.79562691e-01, 3.65781531e-01,
    3.08939296e-01, 7.38415701e-01, 7.40551692e-01, 7.55844055e-01,
    4.49983903e-01, 7.50000000e-01, 4.34203398e-01, 3.16819526e-01,
    7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 6.46828489e-01},
   {0.00000000e+00, 5.44605275e-01, 4.74290926e+00, 3.01454345e-01,
    7.39792738e+00, 1.68781075e+00, 2.98969081e-01, 6.34301019e-01,
    6.78558839e-01, 3.39015407e-01, 7.84090406e-01, 2.86613046e-01,
    3.46454634e-01, 1.55385281e+00, 5.98716826e-01, 8.97081129e-01,
    5.73200024e-01, 9.13504624e-01, 6.94789868e-01, 3.36500142e-01,
    2.32102315e-01, 7.50000000e-01, 3.45683565e-01, 1.38195506e+00,
    7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 3.07946931e-01},
   {0.00000000e+00, 7.41264113e-01, 1.33503378e+00, 2.85934574e-01,
    1.68781075e+00, 5.46952608e+00, 3.30743991e-01, 4.81267655e-01,
    9.60040718e-01, 3.30522558e-01, 1.30827885e+00, 3.72873704e-01,
    5.00342289e-01, 9.11298183e-01, 6.79202587e-01, 1.90173784e+00,
    9.60797602e-01, 9.50357185e-01, 7.41425610e-01, 4.28943130e-01,
    3.74300212e-01, 7.50000000e-01, 4.96467354e-01, 4.08949895e+00,
    7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 3.55631838e-01},
   {0.00000000e+00, 4.64893827e-01, 3.24101420e-01, 4.38990118e-01,
    2.98969081e-01, 3.30743991e-01, 8.12879702e+00, 3.40640908e-01,
    6.51990521e-01, 9.45769883e-01, 3.44043119e-01, 1.15459749e+00,
    1.00437163e+00, 3.54288952e-01, 2.87444758e-01, 3.33972402e-01,
    3.80726330e-01, 4.39973597e-01, 4.81693683e-01, 7.45089738e-01,
    1.37437942e+00, 7.50000000e-01, 2.76938063e+00, 3.31992746e-01,
    7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 1.06958025e+00},
   {0.00000000e+00, 1.05686961e+00, 7.38524318e-01, 4.20387870e-01,
    6.34301019e-01, 4.81267655e-01, 3.40640908e-01, 6.87630691e+00,
    4.92966576e-01, 2.75009722e-01, 5.88871736e-01, 2.84504012e-01,
    3.95486600e-01, 8.63711406e-01, 4.77385507e-01, 5.38649627e-01,
    4.49983999e-01, 9.03596525e-01, 5.79271582e-01, 3.36954912e-01,
    4.21690355e-01, 7.50000000e-01, 3.48714366e-01, 5.03463109e-01,
    7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 2.80638726e-01},
   {0.00000000e+00, 5.69364849e-01, 9.25449581e-01, 3.55049505e-01,
    6.78558839e-01, 9.60040718e-01, 6.51990521e-01, 4.92966576e-01,
    1.35059997e+01, 3.26288125e-01, 7.78887490e-01, 3.80675486e-01,
    5.84132623e-01, 1.22200067e+00, 4.72879831e-01, 1.16798104e+00,
    9.17048021e-01, 7.36731740e-01, 5.57503254e-01, 3.39447442e-01,
    4.44088955e-01, 7.50000000e-01, 1.79790413e+00, 1.04047242e+00,
    7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 3.58533474e-01},
   {0.00000000e+00, 6.32481035e-01, 3.33981361e-01, 6.53458801e-01,
    3.39015407e-01, 3.30522558e-01, 9.45769883e-01, 2.75009722e-01,
    3.26288125e-01, 3.99792994e+00, 3.96372934e-01, 1.69443475e+00,
    1.47774450e+00, 3.27934752e-01, 3.84662860e-01, 3.82937802e-01,
    3.54751311e-01, 4.43163582e-01, 7.79816110e-01, 2.41751209e+00,
    4.08874390e-01, 7.50000000e-01, 6.30388931e-01, 3.50796872e-01,
    7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 2.63222650e+00},
   {0.00000000e+00, 7.75390239e-01, 8.54849426e-01, 3.49128465e-01,
    7.84090406e-01, 1.30827885e+00, 3.44043119e-01, 5.88871736e-01,
    7.78887490e-01, 3.96372934e-01, 4.76433717e+00, 4.28270363e-01,
    6.25302816e-01, 9.39841129e-01, 7.03774479e-01, 1.55432308e+00,
    2.07680867e+00, 9.31919141e-01, 7.92905803e-01, 4.56542720e-01,
    3.58930071e-01, 7.50000000e-01, 5.32179333e-01, 1.40344922e+00,
    7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 4.15284382e-01},
   {0.00000000e+00, 6.01945975e-01, 2.97257620e-01, 6.42275633e-01,
    2.86613046e-01, 3.72873704e-01, 1.15459749e+00, 2.84504012e-01,
    3.80675486e-01, 1.69443475e+00, 4.28270363e-01, 3.79662137e+00,
    1.99429557e+00, 3.10043276e-01, 3.71121724e-01, 4.77325586e-01,
    4.73919278e-01, 4.28893743e-01, 6.60328975e-01, 1.31423573e+00,
    5.68037074e-01, 7.50000000e-01, 6.92059423e-01, 4.13275887e-01,
    7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 2.94078574e+00},
   {0.00000000e+00, 7.23150342e-01, 4.04640322e-01, 6.11354340e-01,
    3.46454634e-01, 5.00342289e-01, 1.00437163e+00, 3.95486600e-01,
    5.84132623e-01, 1.47774450e+00, 6.25302816e-01, 1.99429557e+00,
    6.48145121e+00, 4.74529655e-01, 4.23898024e-01, 8.64250293e-01,
    6.22623369e-01, 5.98558924e-01, 7.93801616e-01, 1.26893679e+00,
    6.10296214e-01, 7.50000000e-01, 7.08364628e-01, 6.41102583e-01,
    7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 1.78399892e+00},
   {0.00000000e+00, 5.88307640e-01, 4.07083696e+00, 3.97802620e-01,
    1.55385281e+00, 9.11298183e-01, 3.54288952e-01, 8.63711406e-01,
    1.22200067e+00, 3.27934752e-01, 9.39841129e-01, 3.10043276e-01,
    4.74529655e-01, 7.09409488e+00, 4.99932836e-01, 1.00058442e+00,
    8.58630478e-01, 1.23152924e+00, 9.84152635e-01, 3.69033853e-01,
    2.77782896e-01, 7.50000000e-01, 4.86030806e-01, 9.45834265e-01,
    7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 3.17327197e-01},
   {0.00000000e+00, 7.54121369e-01, 5.53838329e-01, 3.79562691e-01,
    5.98716826e-01, 6.79202587e-01, 2.87444758e-01, 4.77385507e-01,
    4.72879831e-01, 3.84662860e-01, 7.03774479e-01, 3.71121724e-01,
    4.23898024e-01, 4.99932836e-01, 1.28375437e+01, 6.41280589e-01,
    4.81534905e-01, 7.55503259e-01, 6.88897122e-01, 4.43082984e-01,
    2.81833164e-01, 7.50000000e-01, 3.63521119e-01, 6.64534287e-01,
    7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 3.76634549e-01},
   {0.00000000e+00, 7.56803943e-01, 9.44103648e-01, 3.65781531e-01,
    8.97081129e-01, 1.90173784e+00, 3.33972402e-01, 5.38649627e-01,
    1.16798104e+00, 3.82937802e-01, 1.55432308e+00, 4.77325586e-01,
    8.64250293e-01, 1.00058442e+00, 6.41280589e-01, 6.24442175e+00,
    1.40579606e+00, 9.65555228e-01, 7.91320741e-01, 4.66777931e-01,
    5.09360272e-01, 7.50000000e-01, 6.11094097e-01, 3.58149606e+00,
    7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 4.38898727e-01},
   {0.00000000e+00, 6.12698600e-01, 7.02873767e-01, 3.08939296e-01,
    5.73200024e-01, 9.60797602e-01, 3.80726330e-01, 4.49983999e-01,
    9.17048021e-01, 3.54751311e-01, 2.07680867e+00, 4.73919278e-01,
    6.22623369e-01, 8.58630478e-01, 4.81534905e-01, 1.40579606e+00,
    6.66557707e+00, 7.67165633e-01, 6.77754679e-01, 4.20072316e-01,
    3.95102106e-01, 7.50000000e-01, 5.55965425e-01, 1.13292384e+00,
    7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 4.25403989e-01},
   {0.00000000e+00, 1.47210399e+00, 1.05798620e+00, 7.38415701e-01,
    9.13504624e-01, 9.50357185e-01, 4.39973597e-01, 9.03596525e-01,
    7.36731740e-01, 4.43163582e-01, 9.31919141e-01, 4.28893743e-01,
    5.98558924e-01, 1.23152924e+00, 7.55503259e-01, 9.65555228e-01,
    7.67165633e-01, 3.84284741e+00, 1.61392097e+00, 5.65223766e-01,
    3.85303035e-01, 7.50000000e-01, 5.57520051e-01, 9.56235816e-01,
    7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 4.34703235e-01},
   {0.00000000e+00, 9.84401956e-01, 8.26250098e-01, 7.40551692e-01,
    6.94789868e-01, 7.41425610e-01, 4.81693683e-01, 5.79271582e-01,
    5.57503254e-01, 7.79816110e-01, 7.92905803e-01, 6.60328975e-01,
    7.93801616e-01, 9.84152635e-01, 6.88897122e-01, 7.91320741e-01,
    6.77754679e-01, 1.61392097e+00, 4.83210516e+00, 9.80943005e-01,
    4.30934144e-01, 7.50000000e-01, 5.73156574e-01, 7.60725140e-01,
    7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 7.08974203e-01},
   {0.00000000e+00, 9.36458396e-01, 3.51280513e-01, 7.55844055e-01,
    3.36500142e-01, 4.28943130e-01, 7.45089738e-01, 3.36954912e-01,
    3.39447442e-01, 2.41751209e+00, 4.56542720e-01, 1.31423573e+00,
    1.26893679e+00, 3.69033853e-01, 4.43082984e-01, 4.66777931e-01,
    4.20072316e-01, 5.65223766e-01, 9.80943005e-01, 3.69215640e+00,
    3.74456332e-01, 7.50000000e-01, 6.58038693e-01, 4.43577702e-01,
    7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 1.76339815e+00},
   {0.00000000e+00, 4.16548781e-01, 2.52855433e-01, 4.49983903e-01,
    2.32102315e-01, 3.74300212e-01, 1.37437942e+00, 4.21690355e-01,
    4.44088955e-01, 4.08874390e-01, 3.58930071e-01, 5.68037074e-01,
    6.10296214e-01, 2.77782896e-01, 2.81833164e-01, 5.09360272e-01,
    3.95102106e-01, 3.85303035e-01, 4.30934144e-01, 3.74456332e-01,
    3.81077833e+01, 7.50000000e-01, 2.10980812e+00, 4.26541694e-01,
    7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 5.03239261e-01},
   {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 7.50000000e-01},
   {0.00000000e+00, 5.42611869e-01, 4.09444638e-01, 4.34203398e-01,
    3.45683565e-01, 4.96467354e-01, 2.76938063e+00, 3.48714366e-01,
    1.79790413e+00, 6.30388931e-01, 5.32179333e-01, 6.92059423e-01,
    7.08364628e-01, 4.86030806e-01, 3.63521119e-01, 6.11094097e-01,
    5.55965425e-01, 5.57520051e-01, 5.73156574e-01, 6.58038693e-01,
    2.10980812e+00, 7.50000000e-01, 9.83220341e+00, 5.40805192e-01,
    7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 6.66952325e-01},
   {0.00000000e+00, 7.47274948e-01, 1.18382127e+00, 3.16819526e-01,
    1.38195506e+00, 4.08949895e+00, 3.31992746e-01, 5.03463109e-01,
    1.04047242e+00, 3.50796872e-01, 1.40344922e+00, 4.13275887e-01,
    6.41102583e-01, 9.45834265e-01, 6.64534287e-01, 3.58149606e+00,
    1.13292384e+00, 9.56235816e-01, 7.60725140e-01, 4.43577702e-01,
    4.26541694e-01, 7.50000000e-01, 5.40805192e-01, 3.89300249e+00,
    7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 3.87839626e-01},
   {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 7.50000000e-01},
   {0.00000000e+00, 2.50000000e-01, 2.50000000e-01, 2.50000000e-01,
    2.50000000e-01, 2.50000000e-01, 2.50000000e-01, 2.50000000e-01,
    2.50000000e-01, 2.50000000e-01, 2.50000000e-01, 2.50000000e-01,
    2.50000000e-01, 2.50000000e-01, 2.50000000e-01, 2.50000000e-01,
    2.50000000e-01, 2.50000000e-01, 2.50000000e-01, 2.50000000e-01,
    2.50000000e-01, 2.50000000e-01, 2.50000000e-01, 2.50000000e-01,
    2.50000000e-01, 1.33300000e+00, 2.50000000e-01, 2.50000000e-01},
   {0.00000000e+00, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 7.50000000e-01, 7.50000000e-01, 7.50000000e-01,
    7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 7.50000000e-01},
   {0.00000000e+00, 6.14377313e-01, 3.12208474e-01, 6.46828489e-01,
    3.07946931e-01, 3.55631838e-01, 1.06958025e+00, 2.80638726e-01,
    3.58533474e-01, 2.63222650e+00, 4.15284382e-01, 2.94078574e+00,
    1.78399892e+00, 3.17327197e-01, 3.76634549e-01, 4.38898727e-01,
    4.25403989e-01, 4.34703235e-01, 7.08974203e-01, 1.76339815e+00,
    5.03239261e-01, 7.50000000e-01, 6.66952325e-01, 3.87839626e-01,
    7.50000000e-01, 2.50000000e-01, 7.50000000e-01, 2.81516607e+00} }

};

}