// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/securitycenter/v2/attack_exposure.proto

package securitycenterpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This enum defines the various states an AttackExposure can be in.
type AttackExposure_State int32

const (
	// The state is not specified.
	AttackExposure_STATE_UNSPECIFIED AttackExposure_State = 0
	// The attack exposure has been calculated.
	AttackExposure_CALCULATED AttackExposure_State = 1
	// The attack exposure has not been calculated.
	AttackExposure_NOT_CALCULATED AttackExposure_State = 2
)

// Enum value maps for AttackExposure_State.
var (
	AttackExposure_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CALCULATED",
		2: "NOT_CALCULATED",
	}
	AttackExposure_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CALCULATED":        1,
		"NOT_CALCULATED":    2,
	}
)

func (x AttackExposure_State) Enum() *AttackExposure_State {
	p := new(AttackExposure_State)
	*p = x
	return p
}

func (x AttackExposure_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AttackExposure_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_securitycenter_v2_attack_exposure_proto_enumTypes[0].Descriptor()
}

func (AttackExposure_State) Type() protoreflect.EnumType {
	return &file_google_cloud_securitycenter_v2_attack_exposure_proto_enumTypes[0]
}

func (x AttackExposure_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AttackExposure_State.Descriptor instead.
func (AttackExposure_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_attack_exposure_proto_rawDescGZIP(), []int{0, 0}
}

// An attack exposure contains the results of an attack path simulation run.
type AttackExposure struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A number between 0 (inclusive) and infinity that represents how important
	// this finding is to remediate. The higher the score, the more important it
	// is to remediate.
	Score float64 `protobuf:"fixed64,1,opt,name=score,proto3" json:"score,omitempty"`
	// The most recent time the attack exposure was updated on this finding.
	LatestCalculationTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=latest_calculation_time,json=latestCalculationTime,proto3" json:"latest_calculation_time,omitempty"`
	// The resource name of the attack path simulation result that contains the
	// details regarding this attack exposure score.
	// Example: organizations/123/simulations/456/attackExposureResults/789
	AttackExposureResult string `protobuf:"bytes,3,opt,name=attack_exposure_result,json=attackExposureResult,proto3" json:"attack_exposure_result,omitempty"`
	// Output only. What state this AttackExposure is in. This captures whether or
	// not an attack exposure has been calculated or not.
	State AttackExposure_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.securitycenter.v2.AttackExposure_State" json:"state,omitempty"`
	// The number of high value resources that are exposed as a result of this
	// finding.
	ExposedHighValueResourcesCount int32 `protobuf:"varint,5,opt,name=exposed_high_value_resources_count,json=exposedHighValueResourcesCount,proto3" json:"exposed_high_value_resources_count,omitempty"`
	// The number of medium value resources that are exposed as a result of this
	// finding.
	ExposedMediumValueResourcesCount int32 `protobuf:"varint,6,opt,name=exposed_medium_value_resources_count,json=exposedMediumValueResourcesCount,proto3" json:"exposed_medium_value_resources_count,omitempty"`
	// The number of high value resources that are exposed as a result of this
	// finding.
	ExposedLowValueResourcesCount int32 `protobuf:"varint,7,opt,name=exposed_low_value_resources_count,json=exposedLowValueResourcesCount,proto3" json:"exposed_low_value_resources_count,omitempty"`
}

func (x *AttackExposure) Reset() {
	*x = AttackExposure{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_securitycenter_v2_attack_exposure_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AttackExposure) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AttackExposure) ProtoMessage() {}

func (x *AttackExposure) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_securitycenter_v2_attack_exposure_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AttackExposure.ProtoReflect.Descriptor instead.
func (*AttackExposure) Descriptor() ([]byte, []int) {
	return file_google_cloud_securitycenter_v2_attack_exposure_proto_rawDescGZIP(), []int{0}
}

func (x *AttackExposure) GetScore() float64 {
	if x != nil {
		return x.Score
	}
	return 0
}

func (x *AttackExposure) GetLatestCalculationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LatestCalculationTime
	}
	return nil
}

func (x *AttackExposure) GetAttackExposureResult() string {
	if x != nil {
		return x.AttackExposureResult
	}
	return ""
}

func (x *AttackExposure) GetState() AttackExposure_State {
	if x != nil {
		return x.State
	}
	return AttackExposure_STATE_UNSPECIFIED
}

func (x *AttackExposure) GetExposedHighValueResourcesCount() int32 {
	if x != nil {
		return x.ExposedHighValueResourcesCount
	}
	return 0
}

func (x *AttackExposure) GetExposedMediumValueResourcesCount() int32 {
	if x != nil {
		return x.ExposedMediumValueResourcesCount
	}
	return 0
}

func (x *AttackExposure) GetExposedLowValueResourcesCount() int32 {
	if x != nil {
		return x.ExposedLowValueResourcesCount
	}
	return 0
}

var File_google_cloud_securitycenter_v2_attack_exposure_proto protoreflect.FileDescriptor

var file_google_cloud_securitycenter_v2_attack_exposure_proto_rawDesc = []byte{
	0x0a, 0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x76, 0x32,
	0x2f, 0x61, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x5f, 0x65, 0x78, 0x70, 0x6f, 0x73, 0x75, 0x72, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xab, 0x04, 0x0a, 0x0e, 0x41, 0x74, 0x74,
	0x61, 0x63, 0x6b, 0x45, 0x78, 0x70, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73,
	0x63, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72,
	0x65, 0x12, 0x52, 0x0a, 0x17, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x63, 0x61, 0x6c, 0x63,
	0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x15,
	0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x43, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x34, 0x0a, 0x16, 0x61, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x5f,
	0x65, 0x78, 0x70, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x61, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x45, 0x78, 0x70,
	0x6f, 0x73, 0x75, 0x72, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x4f, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x2e, 0x41, 0x74, 0x74, 0x61,
	0x63, 0x6b, 0x45, 0x78, 0x70, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x4a, 0x0a, 0x22,
	0x65, 0x78, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x5f, 0x68, 0x69, 0x67, 0x68, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x1e, 0x65, 0x78, 0x70, 0x6f, 0x73, 0x65,
	0x64, 0x48, 0x69, 0x67, 0x68, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x4e, 0x0a, 0x24, 0x65, 0x78, 0x70, 0x6f,
	0x73, 0x65, 0x64, 0x5f, 0x6d, 0x65, 0x64, 0x69, 0x75, 0x6d, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x20, 0x65, 0x78, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x4d,
	0x65, 0x64, 0x69, 0x75, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x48, 0x0a, 0x21, 0x65, 0x78, 0x70, 0x6f,
	0x73, 0x65, 0x64, 0x5f, 0x6c, 0x6f, 0x77, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x1d, 0x65, 0x78, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x4c, 0x6f, 0x77, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x22, 0x42, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x41, 0x4c, 0x43, 0x55, 0x4c, 0x41, 0x54, 0x45, 0x44,
	0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x4e, 0x4f, 0x54, 0x5f, 0x43, 0x41, 0x4c, 0x43, 0x55, 0x4c,
	0x41, 0x54, 0x45, 0x44, 0x10, 0x02, 0x42, 0xed, 0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x73, 0x65, 0x63, 0x75,
	0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x76, 0x32, 0x42, 0x13, 0x41,
	0x74, 0x74, 0x61, 0x63, 0x6b, 0x45, 0x78, 0x70, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69,
	0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x62, 0x3b,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x62,
	0xaa, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x2e, 0x56,
	0x32, 0xca, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x5c, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5c,
	0x56, 0x32, 0xea, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x3a, 0x3a, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x43, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_securitycenter_v2_attack_exposure_proto_rawDescOnce sync.Once
	file_google_cloud_securitycenter_v2_attack_exposure_proto_rawDescData = file_google_cloud_securitycenter_v2_attack_exposure_proto_rawDesc
)

func file_google_cloud_securitycenter_v2_attack_exposure_proto_rawDescGZIP() []byte {
	file_google_cloud_securitycenter_v2_attack_exposure_proto_rawDescOnce.Do(func() {
		file_google_cloud_securitycenter_v2_attack_exposure_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_securitycenter_v2_attack_exposure_proto_rawDescData)
	})
	return file_google_cloud_securitycenter_v2_attack_exposure_proto_rawDescData
}

var file_google_cloud_securitycenter_v2_attack_exposure_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_securitycenter_v2_attack_exposure_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_cloud_securitycenter_v2_attack_exposure_proto_goTypes = []interface{}{
	(AttackExposure_State)(0),     // 0: google.cloud.securitycenter.v2.AttackExposure.State
	(*AttackExposure)(nil),        // 1: google.cloud.securitycenter.v2.AttackExposure
	(*timestamppb.Timestamp)(nil), // 2: google.protobuf.Timestamp
}
var file_google_cloud_securitycenter_v2_attack_exposure_proto_depIdxs = []int32{
	2, // 0: google.cloud.securitycenter.v2.AttackExposure.latest_calculation_time:type_name -> google.protobuf.Timestamp
	0, // 1: google.cloud.securitycenter.v2.AttackExposure.state:type_name -> google.cloud.securitycenter.v2.AttackExposure.State
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_google_cloud_securitycenter_v2_attack_exposure_proto_init() }
func file_google_cloud_securitycenter_v2_attack_exposure_proto_init() {
	if File_google_cloud_securitycenter_v2_attack_exposure_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_securitycenter_v2_attack_exposure_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AttackExposure); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_securitycenter_v2_attack_exposure_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_securitycenter_v2_attack_exposure_proto_goTypes,
		DependencyIndexes: file_google_cloud_securitycenter_v2_attack_exposure_proto_depIdxs,
		EnumInfos:         file_google_cloud_securitycenter_v2_attack_exposure_proto_enumTypes,
		MessageInfos:      file_google_cloud_securitycenter_v2_attack_exposure_proto_msgTypes,
	}.Build()
	File_google_cloud_securitycenter_v2_attack_exposure_proto = out.File
	file_google_cloud_securitycenter_v2_attack_exposure_proto_rawDesc = nil
	file_google_cloud_securitycenter_v2_attack_exposure_proto_goTypes = nil
	file_google_cloud_securitycenter_v2_attack_exposure_proto_depIdxs = nil
}
