;;; GNU Guix --- Functional package management for GNU
;;; Copyright © 2013 Nikita Karetnikov <nikita@karetnikov.org>
;;; Copyright © 2013-2024 Ludovic Courtès <ludo@gnu.org>
;;; Copyright © 2013, 2014, 2015, 2016, 2019, 2023 Andreas Enge <andreas@enge.fr>
;;; Copyright © 2014, 2015 Mark H Weaver <mhw@netris.org>
;;; Copyright © 2014, 2017, 2021, 2022, 2024 Eric Bavier <bavier@posteo.net>
;;; Copyright © 2014, 2015 Federico Beffa <beffa@fbengineering.ch>
;;; Copyright © 2015 Omar Radwan <toxemicsquire4@gmail.com>
;;; Copyright © 2015 Pierre-Antoine Rault <par@rigelk.eu>
;;; Copyright © 2015-2025 Ricardo Wurmus <rekado@elephly.net>
;;; Copyright © 2015, 2016, 2020 Christine Lemmer-Webber <cwebber@dustycloud.org>
;;; Copyright © 2015 Eric Dvorsak <eric@dvorsak.fr>
;;; Copyright © 2015, 2016 David Thompson <davet@gnu.org>
;;; Copyright © 2015, 2016, 2017, 2019, 2022 Leo Famulari <leo@famulari.name>
;;; Copyright © 2015, 2017 Ben Woodcroft <donttrustben@gmail.com>
;;; Copyright © 2015, 2016 Erik Edrosa <erik.edrosa@gmail.com>
;;; Copyright © 2015-2025 Efraim Flashner <efraim@flashner.co.il>
;;; Copyright © 2015, 2017, 2020 Kyle Meyer <kyle@kyleam.com>
;;; Copyright © 2015, 2016 Chris Marusich <cmmarusich@gmail.com>
;;; Copyright © 2016 Danny Milosavljevic <dannym+a@scratchpost.org>
;;; Copyright © 2016 Lukas Gradl <lgradl@openmailbox.org>
;;; Copyright © 2016, 2018, 2019, 2021 Hartmut Goebel <h.goebel@crazy-compilers.com>
;;; Copyright © 2016 Daniel Pimentel <d4n1@d4n1.org>
;;; Copyright © 2016 Sou Bunnbu <iyzsong@gmail.com>
;;; Copyright © 2016, 2017 Troy Sankey <sankeytms@gmail.com>
;;; Copyright © 2016, 2017 Nikita <nikita@n0.is>
;;; Copyright © 2016 Dylan Jeffers <sapientech@sapientech@openmailbox.org>
;;; Copyright © 2016 David Craven <david@craven.ch>
;;; Copyright © 2016-2023 Marius Bakke <marius@gnu.org>
;;; Copyright © 2016, 2017, 2021, 2022 Stefan Reichör <stefan@xsteve.at>
;;; Copyright © 2016, 2017, 2019 Alex Vong <alexvong1995@gmail.com>
;;; Copyright © 2016–2018, 2021–2024 Arun Isaac <arunisaac@systemreboot.net>
;;; Copyright © 2016, 2017, 2018, 2020, 2021 Julien Lepiller <julien@lepiller.eu>
;;; Copyright © 2016–2022 Tobias Geerinckx-Rice <me@tobias.gr>
;;; Copyright © 2016, 2017 Thomas Danckaert <post@thomasdanckaert.be>
;;; Copyright © 2017 Carlo Zancanaro <carlo@zancanaro.id.au>
;;; Copyright © 2017 Frederick M. Muriithi <fredmanglis@gmail.com>
;;; Copyright © 2017, 2018 Adriano Peluso <catonano@gmail.com>
;;; Copyright © 2017 Ben Sturmfels <ben@sturm.com.au>
;;; Copyright © 2017, 2018, 2019, 2021, 2022 Mathieu Othacehe <m.othacehe@gmail.com>
;;; Copyright © 2017 José Miguel Sánchez García <jmi2k@openmailbox.org>
;;; Copyright © 2017, 2020, 2021 Roel Janssen <roel@gnu.org>
;;; Copyright © 2017, 2018, 2019 Kei Kebreau <kkebreau@posteo.net>
;;; Copyright © 2017 Rutger Helling <rhelling@mykolab.com>
;;; Copyright © 2017, 2019, 2021 Brendan Tildesley <mail@brendan.scot>
;;; Copyright © 2018 Ethan R. Jones <ethanrjones97@gmail.com
;;; Copyright © 2018 Fis Trivial <ybbs.daans@hotmail.com>
;;; Copyright © 2018 Vijayalakshmi Vedantham <vijimay12@gmail.com>
;;; Copyright © 2018 Mathieu Lirzin <mthl@gnu.org>
;;; Copyright © 2018 Adam Massmann <massmannak@gmail.com>
;;; Copyright © 2016, 2018 Tomáš Čech <sleep_walker@gnu.org>
;;; Copyright © 2018-2024 Nicolas Goaziou <mail@nicolasgoaziou.fr>
;;; Copyright © 2018 Oleg Pykhalov <go.wigust@gmail.com>
;;; Copyright © 2018, 2019, 2021, 2023 Clément Lassieur <clement@lassieur.org>
;;; Copyright © 2018-2024 Maxim Cournoyer <maxim.cournoyer@gmail.com>
;;; Copyright © 2018 Luther Thompson <lutheroto@gmail.com>
;;; Copyright © 2018 Vagrant Cascadian <vagrant@debian.org>
;;; Copyright © 2015, 2018 Pjotr Prins <pjotr.guix@thebird.nl>
;;; Copyright © 2019, 2020 Brett Gilio <brettg@gnu.org>
;;; Copyright © 2019 Sam <smbaines8@gmail.com>
;;; Copyright © 2019, 2023 Jack Hill <jackhill@jackhill.us>
;;; Copyright © 2019-2023, Guillaume Le Vaillant <glv@posteo.net>
;;; Copyright © 2019, 2020 Alex Griffin <a@ajgrf.com>
;;; Copyright © 2019, 2020, 2021, 2022, 2023 Pierre Langlois <pierre.langlois@gmx.com>
;;; Copyright © 2019 Jacob MacDonald <jaccarmac@gmail.com>
;;; Copyright © 2019-2021, 2023, 2024 Giacomo Leidi <goodoldpaul@autistici.org>
;;; Copyright © 2019 Wiktor Żelazny <wzelazny@vurv.cz>
;;; Copyright © 2019, 2020, 2021, 2022 Tanguy Le Carrour <tanguy@bioneland.org>
;;; Copyright © 2019, 2021-2023 Mădălin Ionel Patrașcu <madalinionel.patrascu@mdc-berlin.de>
;;; Copyright © 2020 Riku Viitanen <riku.viitanen@protonmail.com>
;;; Copyright © 2020 Jakub Kądziołka <kuba@kadziolka.net>
;;; Copyright © 2020 sirgazil <sirgazil@zoho.com>
;;; Copyright © 2020 Sebastian Schott <sschott@mailbox.org>
;;; Copyright © 2020, 2021 Alexandros Theodotou <alex@zrythm.org>
;;; Copyright © 2020 Josh Marshall <joshua.r.marshall.1991@gmail.com>
;;; Copyright © 2020 Lars-Dominik Braun <ldb@leibniz-psychology.org>
;;; Copyright © 2020 Alex ter Weele <alex.ter.weele@gmail.com>
;;; Copyright © 2020, 2022 Matthew James Kraai <kraai@ftbfs.org>
;;; Copyright © 2020 Ryan Prior <rprior@protonmail.com>
;;; Copyright © 2020 Josh Holland <josh@inv.alid.pw>
;;; Copyright © 2020 Yuval Kogman <nothingmuch@woobling.org>
;;; Copyright © 2020, 2022 Michael Rohleder <mike@rohleder.de>
;;; Copyright © 2020, 2021, 2022, 2023, 2024 Vinicius Monego <monego@posteo.net>
;;; Copyright © 2020 Guy Fleury Iteriteka <gfleury@disroot.org>
;;; Copyright © 2020 Hendursaga <hendursaga@yahoo.com>
;;; Copyright © 2020 Malte Frank Gerdes <malte.f.gerdes@gmail.com>
;;; Copyright © 2020 Joseph LaFreniere <joseph@lafreniere.xyz>
;;; Copyright © 2020 Tim Gesthuizen <tim.gesthuizen@yahoo.de>
;;; Copyright © 2020, 2021 Bonface Munyoki Kilyungi <me@bonfacemunyoki.com>
;;; Copyright © 2020 Ekaitz Zarraga <ekaitz@elenq.tech>
;;; Copyright © 2020 Diego N. Barbato <dnbarbato@posteo.de>
;;; Copyright © 2020 Liliana Marie Prikler <liliana.prikler@gmail.com>
;;; Copyright © 2019 Kristian Trandem <kristian@devup.no>
;;; Copyright © 2020, 2021, 2024 Zheng Junjie <873216071@qq.com>
;;; Copyright © 2020 EuAndreh <eu@euandre.org>
;;; Copyright © 2021, 2022 Morgan Smith <Morgan.J.Smith@outlook.com>
;;; Copyright © 2021-2025 Sharlatan Hellseher <sharlatanus@gmail.com>
;;; Copyright © 2021 Ellis Kenyő <me@elken.dev>
;;; Copyright © 2021 LibreMiami <packaging-guix@libremiami.org>
;;; Copyright © 2021 Xinglu Chen <public@yoctocell.xyz>
;;; Copyright © 2021 Raghav Gururajan <rg@raghavgururajan.name>
;;; Copyright © 2021, 2023-2024 jgart <jgart@dismail.de>
;;; Copyright © 2021 Danial Behzadi <dani.behzi@ubuntu.com>
;;; Copyright © 2021 Maxime Devos <maximedevos@telenet.be>
;;; Copyright © 2021 Hugo Lecomte <hugo.lecomte@inria.fr>
;;; Copyright © 2021 Franck Pérignon <franck.perignon@univ-grenoble-alpes.fr>
;;; Copyright © 2021, 2022 Petr Hodina <phodina@protonmail.com>
;;; Copyright © 2021 Simon Streit <simon@netpanic.org>
;;; Copyright © 2021, 2022, 2023 Daniel Meißner <daniel.meissner-i4k@ruhr-uni-bochum.de>
;;; Copyright © 2021, 2022 Pradana Aumars <paumars@courrier.dev>
;;; Copyright © 2021–2024 Felix Gruber <felgru@posteo.net>
;;; Copyright © 2021 Sébastien Lerique <sl@eauchat.org>
;;; Copyright © 2021 Raphaël Mélotte <raphael.melotte@mind.be>
;;; Copyright © 2021 ZmnSCPxj <ZmnSCPxj@protonmail.com>
;;; Copyright © 2021 Filip Lajszczak <filip@lajszczak.dev>
;;; Copyright © 2021 Greg Hogan <code@greghogan.com>
;;; Copyright © 2022, 2023 John Kehayias <john.kehayias@protonmail.com>
;;; Copyright © 2022 Aleksandr Vityazev <avityazev@posteo.org>
;;; Copyright © 2022, 2024, 2025 Evgeny Pisemsky <mail@pisemsky.site>
;;; Copyright © 2022 drozdov <drozdov@portalenergy.tech>
;;; Copyright © 2022 Peter Polidoro <peter@polidoro.io>
;;; Copyright © 2022, 2023 Wamm K. D. <jaft.r@outlook.com>
;;; Copyright © 2022 Jai Vetrivelan <jaivetrivelan@gmail.com>
;;; Copyright © 2022-2025 Artyom V. Poptsov <poptsov.artyom@gmail.com>
;;; Copyright © 2022 Paul A. Patience <paul@apatience.com>
;;; Copyright © 2022 Jean-Pierre De Jesus DIAZ <me@jeandudey.tech>
;;; Copyright © 2022 Philip McGrath <philip@philipmcgrath.com>
;;; Copyright © 2022 Marek Felšöci <marek@felsoci.sk>
;;; Copyright © 2022 Hilton Chain <hako@ultrarare.space>
;;; Copyright © 2022 Tomasz Jeneralczyk <tj@schwi.pl>
;;; Copyright © 2022 Mathieu Laparie <mlaparie@disr.it>
;;; Copyright © 2022 Garek Dyszel <garekdyszel@disroot.org>
;;; Copyright © 2022 Baptiste Strazzulla <bstrazzull@hotmail.fr>
;;; Copyright © 2022 Nicolas Graves <ngraves@ngraves.fr>
;;; Copyright © 2023 Gabriel Wicki <gabriel@erlikon.ch>
;;; Copyright © 2023 Amade Nemes <nemesamade@gmail.com>
;;; Copyright © 2023 Bruno Victal <mirai@makinata.eu>
;;; Copyright © 2023 Lu Hui <luhux76@gmail.com>
;;; Copyright © 2023 Kaelyn Takata <kaelyn.alexi@protonmail.com>
;;; Copyright © 2023 dan <i@dan.games>
;;; Copyright © 2023 Dominik Delgado Steuter <d@delgado.nrw>
;;; Copyright © 2023 Ivan Vilata-i-Balaguer <ivan@selidor.net>
;;; Copyright © 2023 Ontje Lünsdorf <ontje.luensdorf@dlr.de>
;;; Copyright © 2023 gemmaro <gemmaro.dev@gmail.com>
;;; Copyright © 2023 Parnikkapore <poomklao@yahoo.com>
;;; Copyright © 2023 Foundation Devices, Inc. <hello@foundationdevices.com>
;;; Copyright © c4droid <c4droid@foxmail.com>
;;; Copyright © 2023, 2024 Janneke Nieuwenhuizen <janneke@gnu.org>
;;; Copyright © 2023 Attila Lendvai <attila@lendvai.name>
;;; Copyright © 2023, 2024 Troy Figiel <troy@troyfigiel.com>
;;; Copyright © 2023 Adam Faiz <adam.faiz@disroot.org>
;;; Copyright © 2024 Timothee Mathieu <timothee.mathieu@inria.fr>
;;; Copyright © 2024 Ian Eure <ian@retrospec.tv>
;;; Copyright © 2024 Adriel Dumas--Jondeau <leirda@disroot.org>
;;; Copyright © 2024 Navid Afkhami <navid.afkhami@mdc-berlin.de>
;;; Copyright © 2024 TakeV <takev@disroot.org>
;;; Copyright © 2024, 2025 David Elsing <david.elsing@posteo.net>
;;; Copyright © 2024 Rick Huijzer <ikbenrickhuyzer@gmail.com>
;;; Copyright © 2024 Peter Kannewitz <petre-vps@posteo.net>
;;; Copyright © 2024 Aaron Covrig <aaron.covrig.us@ieee.org>
;;; Copyright © 2024 Markku Korkeala <markku.korkeala@iki.fi>
;;; Copyright © 2025 Jordan Moore <lockbox@struct.foo>
;;; Copyright © 2025 Dariqq <dariqq@posteo.net>
;;; Copyright © 2025 Nguyễn Gia Phong <mcsinyx@disroot.org>
;;;
;;; This file is part of GNU Guix.
;;;
;;; GNU Guix is free software; you can redistribute it and/or modify it
;;; under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 3 of the License, or (at
;;; your option) any later version.
;;;
;;; GNU Guix is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Guix.  If not, see <http://www.gnu.org/licenses/>.

(define-module (gnu packages python-xyz)
  #:use-module ((guix licenses) #:prefix license:)
  #:use-module (gnu packages)
  #:use-module (gnu packages adns)
  #:use-module (gnu packages aidc)
  #:use-module (gnu packages algebra)
  #:use-module (gnu packages astronomy)
  #:use-module (gnu packages attr)
  #:use-module (gnu packages audio)
  #:use-module (gnu packages autotools)
  #:use-module (gnu packages backup)
  #:use-module (gnu packages base)
  #:use-module (gnu packages bash)
  #:use-module (gnu packages bdw-gc)
  #:use-module (gnu packages bioinformatics)
  #:use-module (gnu packages build-tools)
  #:use-module (gnu packages certs)
  #:use-module (gnu packages check)
  #:use-module (gnu packages cmake)
  #:use-module (gnu packages compression)
  #:use-module (gnu packages cpp)
  #:use-module (gnu packages crates-check)
  #:use-module (gnu packages crates-io)
  #:use-module (gnu packages crates-windows)
  #:use-module (gnu packages crypto)
  #:use-module (gnu packages databases)
  #:use-module (gnu packages dbm)
  #:use-module (gnu packages digest)
  #:use-module (gnu packages django)
  #:use-module (gnu packages djvu)
  #:use-module (gnu packages docker)
  #:use-module (gnu packages documentation)
  #:use-module (gnu packages elf)
  #:use-module (gnu packages emulators)
  #:use-module (gnu packages enchant)
  #:use-module (gnu packages file)
  #:use-module (gnu packages fonts)
  #:use-module (gnu packages fontutils)
  #:use-module (gnu packages freedesktop)
  #:use-module (gnu packages game-development)
  #:use-module (gnu packages gcc)
  #:use-module (gnu packages gdb)
  #:use-module (gnu packages geo)
  #:use-module (gnu packages ghostscript)
  #:use-module (gnu packages gl)
  #:use-module (gnu packages glib)
  #:use-module (gnu packages gnome)
  #:use-module (gnu packages gnupg)
  #:use-module (gnu packages graphics)
  #:use-module (gnu packages graphviz)
  #:use-module (gnu packages gsasl)
  #:use-module (gnu packages gstreamer)
  #:use-module (gnu packages gtk)
  #:use-module (gnu packages haskell-xyz)
  #:use-module (gnu packages icu4c)
  #:use-module (gnu packages image)
  #:use-module (gnu packages image-processing)
  #:use-module (gnu packages imagemagick)
  #:use-module (gnu packages inkscape)
  #:use-module (gnu packages java)
  #:use-module (gnu packages jupyter)
  #:use-module (gnu packages kerberos)
  #:use-module (gnu packages libevent)
  #:use-module (gnu packages libffi)
  #:use-module (gnu packages libidn)
  #:use-module (gnu packages libusb)
  #:use-module (gnu packages linux)
  #:use-module (gnu packages llvm)
  #:use-module (gnu packages machine-learning)
  #:use-module (gnu packages man)
  #:use-module (gnu packages markup)
  #:use-module (gnu packages maths)
  #:use-module (gnu packages messaging)
  #:use-module (gnu packages monitoring)
  #:use-module (gnu packages multiprecision)
  #:use-module (gnu packages ncurses)
  #:use-module (gnu packages networking)
  #:use-module (gnu packages ninja)
  #:use-module (gnu packages node)
  #:use-module (gnu packages openstack)
  #:use-module (gnu packages pcre)
  #:use-module (gnu packages pdf)
  #:use-module (gnu packages perl)
  #:use-module (gnu packages photo)
  #:use-module (gnu packages pkg-config)
  #:use-module (gnu packages protobuf)
  #:use-module (gnu packages pulseaudio)
  #:use-module (gnu packages python)
  #:use-module (gnu packages python-build)
  #:use-module (gnu packages python-check)
  #:use-module (gnu packages python-compression)
  #:use-module (gnu packages python-crypto)
  #:use-module (gnu packages python-science)
  #:use-module (gnu packages python-web)
  #:use-module (gnu packages qt)
  #:use-module (gnu packages rdf)
  #:use-module (gnu packages readline)
  #:use-module (gnu packages regex)
  #:use-module (gnu packages rust-apps)
  #:use-module (gnu packages scanner)
  #:use-module (gnu packages sdl)
  #:use-module (gnu packages search)
  #:use-module (gnu packages serialization)
  #:use-module (gnu packages shells)
  #:use-module (gnu packages sphinx)
  #:use-module (gnu packages ssh)
  #:use-module (gnu packages statistics)
  #:use-module (gnu packages swig)
  #:use-module (gnu packages tcl)
  #:use-module (gnu packages terminals)
  #:use-module (gnu packages tex)
  #:use-module (gnu packages texinfo)
  #:use-module (gnu packages textutils)
  #:use-module (gnu packages time)
  #:use-module (gnu packages tls)
  #:use-module (gnu packages tree-sitter)
  #:use-module (gnu packages version-control)
  #:use-module (gnu packages video)
  #:use-module (gnu packages web)
  #:use-module (gnu packages wxwidgets)
  #:use-module (gnu packages xml)
  #:use-module (gnu packages xdisorg)
  #:use-module (gnu packages xorg)
  #:use-module (guix packages)
  #:use-module (guix build-system cargo)
  #:use-module (guix build-system cmake)
  #:use-module (guix build-system gnu)
  #:use-module (guix build-system meson)
  #:use-module (guix build-system pyproject)
  #:use-module (guix build-system python)
  #:use-module (guix download)
  #:use-module (guix hg-download)
  #:use-module (guix git-download)
  #:use-module (guix gexp)
  #:use-module (guix utils)
  #:use-module (srfi srfi-1)
  #:use-module (srfi srfi-26))

(define-public python-apprise
  (package
    (name "python-apprise")
    (version "1.9.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "apprise" version))
       (sha256
        (base32 "1a3kzpjdp29l4ryafd36gs8apg61f16ljw93h1051p98f0hv23i9"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "--numprocesses" (number->string (parallel-job-count))
              "--ignore=test/test_plugin_macosx.py"
              "-k" (string-append "not test_plugin_mqtt_tls_connect_success"
                                  " and not test_plugin_mqtt_tls_no_verify_success"
                                  ;; AssertionError: assert False
                                  " and not test_plugin_wxpusher_edge_cases"))))
    (propagated-inputs (list python-certifi
                             python-click
                             python-markdown
                             python-pyyaml
                             python-requests
                             python-requests-oauthlib))
    (native-inputs
     (list python-babel
           python-pytest
           python-pytest-cov
           python-pytest-mock
           python-pytest-xdist
           python-setuptools
           python-wheel))
    (home-page "https://github.com/caronc/apprise")
    (synopsis
     "Push notification Python library that works with many platforms")
    (description
     "Apprise is a Python library that allows sending push notifications to a broad
range of notification services, such as Telegram, Discord, Slack, Amazon SNS,
Gotify, etc.")
    (license license:bsd-2)))

(define-public python-archspec
  (package
    (name "python-archspec")
    (version "0.2.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/archspec/archspec")
             (commit (string-append "v" version))
             (recursive? #t)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "03yfn4b9xg41pd7vls2cils77wkkb9si1h2qqvnkds661fdankqj"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; Numba needs a writable dir to cache functions.
         (add-before 'build 'set-numba-cache-dir
           (lambda _
             (setenv "NUMBA_CACHE_DIR" "/tmp"))))))
    (propagated-inputs (list python-boltons
                             python-cooler
                             python-ctxcore
                             python-interlap
                             python-intervaltree
                             python-jsonschema
                             python-networkx
                             python-numba
                             python-poetry-core
                             pyscenic
                             python-scikit-learn
                             python-tables
                             python-typing-extensions))
    (native-inputs (list python-black
                         python-flake8
                         python-isort
                         python-poetry-core
                         python-pylint
                         python-pytest
                         python-pytest-cov))
    (home-page "https://github.com/archspec/archspec")
    (synopsis "Library to query system architecture")
    (description
     "Archspec offers human-readable labels for system architecture aspects.
These aspects include CPU, network fabrics, etc.  In addition, it offers
APIs to detect, query, and compare them.")
    (license license:expat)))

(define-public python-asyncstdlib
  (package
    (name "python-asyncstdlib")
    (version "3.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "asyncstdlib" version))
       (sha256
        (base32 "0cxms50gygrvp4n4rk5xxhnl6k7nsrhhixdyk6xk70hi9ysgz9pj"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-flit-core python-pytest))
    (home-page "https://asyncstdlib.readthedocs.io")
    (synopsis "Compatibility layer between the Python stdlib and @code{async}
callables")
    (description
     "The @code{asyncstdlib} library re-implements functions and classes of
the Python standard library to make them compatible with @code{async}
callables, iterables and context managers.  It is fully agnostic to
@code{async} event loops and seamlessly works with @code{asyncio}, third-party
libraries such as @code{trio}, as well as any custom @code{async} event
loop.")
    (license license:expat)))

(define-public python-awesomeversion
  (package
    (name "python-awesomeversion")
    (version "24.6.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ludeeus/awesomeversion")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1kvzhhd2ah0sadlsp5xs3qbiknixq4xwhk3yb6kmhcdl2zcbi4cn"))
       (modules '((guix build utils)))
       (snippet #~(substitute* "pyproject.toml"
                    (("version = \"0\"")
                     (format #f "version = \"~a\"" #$version))))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-poetry-core
           python-pytest
           python-pytest-snapshot))
    (home-page "https://github.com/ludeeus/awesomeversion")
    (synopsis "Create and compare version objects")
    (description
     "This package provides a way to make anything a version object, and
compare against a vast section of other version formats.")
    (license license:expat)))

(define-public python-awkward-cpp
  (package
    (name "python-awkward-cpp")
    (version "43")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "awkward_cpp" version))
       (sha256
        (base32 "1bays82mjyg0clmms0rdaf1jrdyr0pw5njq8v9kgcan8drcpbvf1"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; TODO: Remove this on python-team branch.
         (add-after 'unpack 'relax-requirements
           (lambda _
             (substitute* "pyproject.toml"
               (("scikit-build-core..0.10")
                "scikit-build-core")
               (("^minimum-version =.*") "")))))))
    (propagated-inputs (list python-numpy))
    (native-inputs
     (list cmake pybind11 python-pytest python-scikit-build-core))
    (home-page "https://github.com/scikit-hep/awkward-1.0")
    (synopsis "CPU kernels and compiled extensions for Awkward Array")
    (description "Awkward CPP provides precompiled routines for the awkward
package.  It is not useful on its own, only as a dependency for awkward.")
    (license license:bsd-3)))

(define-public python-awkward
  (package
    (name "python-awkward")
    (version "2.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "awkward" version))
       (sha256
        (base32 "1bfg4pggahnfvq4n71ydkb1pwzc89plfdgp9wcv7ky4dss37y1ay"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; CUDA is and requires proprietary software.
      '(list "--ignore-glob=tests-cuda**"
             "-k"
             (string-append
              ;; BrokenProcessPool
              "not test_noop_pickler"
              " and not test_non_packing_pickler"
              ;; Regex pattern did not match.
              " and not test_malformed_pickler"))))
    (propagated-inputs (list python-awkward-cpp
                             python-fsspec
                             python-importlib-metadata
                             python-numpy
                             python-packaging
                             python-typing-extensions))
    (native-inputs
     (list python-hatch-fancy-pypi-readme
           python-hatchling
           python-pytest))
    (home-page "https://github.com/scikit-hep/awkward-1.0")
    (synopsis "Manipulate JSON-like data with NumPy-like idioms")
    (description "Awkward Array is a library for nested, variable-sized data,
including arbitrary-length lists, records, mixed types, and missing data,
using NumPy-like idioms.")
    (license license:bsd-3)))

(define-public python-bresenham
  (package
    (name "python-bresenham")
    (version "0.2.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/encukou/bresenham")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "07h04l50y35rhp13mqis61d1dkd7426q1gdfy5hd6rcgcfv15kxd"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (home-page "https://github.com/encukou/bresenham")
    (synopsis "Implementation of Bresenham's line drawing algorithm")
    (description
     "This package provides a Python implementation of
@url{https://en.wikipedia.org/wiki/Bresenham's_line_algorithm, Bresenham's
line drawing algorithm}.")
    (license license:expat)))

(define-public python-distance
  (package
    (name "python-distance")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "Distance" version))
       (sha256
        (base32 "0la51nzzqrkisshwbk2wpviisqqzylwkz9qsa9f3y05nyn27b030"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-setuptools
           python-wheel))
    (home-page "https://github.com/doukremt/distance")
    (synopsis "Utilities for comparing sequences")
    (description
     "This package provides helpers for computing similarities between
arbitrary sequences. Included metrics are Levenshtein, Hamming, Jaccard, and
Sorensen distance, plus some bonuses.  All distance computations are
implemented in pure Python, and most of them are also implemented in C.")
    (license license:gpl2+)))

(define-public python-jsonpath-ng
  (package
    (name "python-jsonpath-ng")
    (version "1.7.0" )
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jsonpath-ng" version))
       (sha256
        (base32 "0g5bpq02pl9mv7mbqixvnagq8f9v0jab6wqmbxw9rxsz9vyzgxgn"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-ply))
    (home-page "https://github.com/h2non/jsonpath-ng")
    (synopsis "JSONPath Next-Generation")
    (description
     "This package provides a final implementation of @code{JSONPath} for
Python that aims to be standard compliant, including arithmetic and binary
comparison operators, as defined in the original
@url{http://goessner.net/articles/JsonPath/, JSONPath} proposal.")
    (license license:asl2.0)))

(define-public python-multiplex
  (package
    (name "python-multiplex")
    (version "0.6.1")
    (source
     (origin
       (method git-fetch)               ;no tests in PyPI archive
       (uri (git-reference
             (url "https://github.com/dankilman/multiplex")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1a662liqhiya47i6vrz3q03w08viqg3wj5j3g58mz175hcdcmmmv"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-poetry-core
           python-pytest
           python-pytest-asyncio))
    (propagated-inputs
     (list python-aiofiles
           python-aiostream
           python-click
           python-easy-ansi
           python-pyte))
    (home-page "https://github.com/dankilman/multiplex")
    (synopsis "Parallel stream of outputs from multiple processes")
    (description
     "This package provides a functionality to view output of multiple
processes, in parallel, in the console, with an interactive TUI.")
    (license license:expat)))

(define-public python-pyxdameraulevenshtein
  (package
    (name "python-pyxdameraulevenshtein")
    (version "1.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyxdameraulevenshtein" version))
       (sha256
        (base32 "07nhds44ry9mchqjqjdnq2asp13y9pqc8003pkydvb3dah7wrvhv"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-cython
           python-setuptools
           python-wheel))
    (home-page "https://github.com/lanl/pyxDamerauLevenshtein")
    (synopsis "Damerau-Levenshtein edit distance algorithm")
    (description
     "@code{pyxDamerauLevenshtein} implements the Damerau-Levenshtein (DL)
edit distance algorithm for Python in Cython for high performance.")
    (license license:bsd-3)))

(define-public python-takethetime
  (package
    (name "python-takethetime")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "TakeTheTime" version))
       (sha256
        (base32 "1y9gzqb9l1f2smx8783ccjzjvby5mphshgrfks7s75mml59h9qyv"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f)) ; tests are time dependent and not provided in PyPI
    (native-inputs
     (list python-setuptools
           python-wheel))
    (home-page "https://github.com/ErikBjare/TakeTheTime")
    (synopsis "Timing chunks of code")
    (description
     "This package implements a functionality for time taking using context
managers.")
    (license license:expat)))

(define-public python-trubar
  (package
    (name "python-trubar")
    (version "0.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "trubar" version))
       (sha256
        (base32 "149l5wid1b41gmfzsrhapcigcbcsflviz8p1pfa937443fxw1dkd"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "-k" (string-join
                    ;; AttributeError: module 'libcst' has no attribute
                    ;; 'FlattenSentinel'. Did you mean: 'MaybeSentinel'?
                    (list "not test_import_from_future"
                          "test_inport_after_docstring"
                          ;; AssertionError: Items in the second set but not
                          ;; the first
                          "test_walk_files")
                    " and not "))))
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-libcst
           python-pyyaml))
    (home-page "https://github.com/janezd/trubar")
    (synopsis "Utility for translation of Python sources")
    (description
     "This package provides a tool for translation and localization of Python
programs via modification of source files. Trubar supports f-strings and does
not require any changes to the original source code, such as marking strings
for translation.")
    (license license:expat)))

(define-public python-xmldiff
  (package
    (name "python-xmldiff")
    (version "2.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "xmldiff" version))
       (sha256
        (base32 "18k8kiml9wpl4wf9lmi0j6ys21lbdv8fa8r9qrzdsrh3h0ghp4f0"))))
    (build-system python-build-system)
    (propagated-inputs (list python-lxml))
    (home-page "https://github.com/Shoobx/xmldiff")
    (synopsis "Creates diffs of XML files")
    (description "This Python tool figures out the differences between two
similar XML files, in the same way the @command{diff} utility does it.")
    (license license:expat)))

(define-public python-xmlsec
  (package
    (name "python-xmlsec")
    (version "1.3.14")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "xmlsec" version))
       (sha256
        (base32 "1nd2jbrfbmnd566i1v39xrh3a0b1nqvf5bhydywcsnw95x7q0kwk"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; See https://github.com/xmlsec/python-xmlsec/issues/210
      #:test-flags '(list "-n" "1"
                          ;; This causes other tests to segfault.
                          "-k" "not test_reinitialize_module")
      #:phases
      #~(modify-phases %standard-phases
          ;; FIXME: This is very unfortunate.  I can't seem to find a way to
          ;; hardcode the location of this library, so users will also need to
          ;; set LD_LIBRARY_PATH.
          (add-before 'check 'pre-check
            (lambda* (#:key inputs #:allow-other-keys)
              (setenv "LD_LIBRARY_PATH"
                      (dirname (search-input-file inputs "lib/libxmlsec1-openssl.so.1.2.37"))))))))
    (inputs (list openssl libltdl libxslt libxml2))
    (propagated-inputs (list python-lxml xmlsec-openssl))
    (native-inputs (list pkg-config
                         python-lxml
                         python-pkgconfig
                         python-pytest
                         python-pytest-xdist
                         python-setuptools
                         python-setuptools-scm
                         python-wheel))
    (home-page "https://github.com/mehcode/python-xmlsec")
    (synopsis "Python bindings for the XML Security Library")
    (description "This package provides Python bindings for the XML Security
Library.")
    (license license:expat)))

(define-public python-janus
  (package
    (name "python-janus")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "janus" version))
       (sha256
        (base32 "04hnrdcf03g1s0x3sr72sh9gnszz6kyfsl9dg8a4n0zvvhn6z5yz"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest python-pytest-cov python-pytest-asyncio
           python-setuptools python-wheel))
    (propagated-inputs (list python-typing-extensions))
    (home-page "https://github.com/aio-libs/janus/")
    (synopsis
     "Sync-async queue to interoperate between asyncio tasks and classic threads")
    (description
     "Mixed sync-async queue, supposed to be used for communicating between
classic synchronous (threaded) code and asynchronous (in terms of
@url{https://docs.python.org/3/library/asyncio.html,asyncio}) one.  Like
@url{https://en.wikipedia.org/wiki/Janus,Janus god} the queue object from the
library has two faces: synchronous and asynchronous interface.  Synchronous is
fully compatible with
@url{https://docs.python.org/3/library/queue.html,standard queue},
asynchronous one follows
@url{https://docs.python.org/3/library/asyncio-queue.html,asyncio queue
design}.")
    (license license:asl2.0)))

(define-public python-jupytext
  (package
    (name "python-jupytext")
    (version "1.15.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/mwouts/jupytext")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0bgf0c4py22ip7qfla8mrmypfh3bg151c8awsr1gvcbw7m4ni01k"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "--ignore-glob=tests/test_pre_commit_*.py"
              "-k" (string-join
                    (list "not test_create_header_with_set_formats"
                          "test_pre_commit_hook"
                          "test_sync_with_pre_commit_hook")
                    " and not "))
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'pre-check
            (lambda _
              ;; some tests fail when HOME=/homeless-shelter.
              (setenv "HOME" "/tmp")
              ;; OSError: [Errno 18] Invalid cross-device link
              (setenv "TMPDIR" "/tmp"))))))
    (native-inputs
     (list git-minimal/pinned
           python-gitpython
           python-ipython-genutils
           python-jupyter-server
           python-pyaml
           python-toml
           python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-markdown-it-py
           python-mdit-py-plugins
           python-nbformat))
    (home-page "https://github.com/mwouts/jupytext")
    (synopsis
     "Jupyter notebooks as Markdown documents, Julia, Python or R scripts")
    (description
     "Jupytext is a plugin for Jupyter that can save Jupyter notebooks as
either Markdown files or scripts in many languages.  Common use cases for
Jupytext are:

@itemize
@item version control on Jupyter Notebooks
@item editing, merging or refactoring notebooks in your favorite text editor
@item applying Q&A checks on notebooks.
@end itemize
")
    (license license:expat)))

(define-public python-concurrent-log-handler
  (package
    (name "python-concurrent-log-handler")
    (version "0.9.25")
    ;; No tests in the PyPI tarball.
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Preston-Landers/concurrent-log-handler")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0jp4zkm0idfdsrq3jzb52iqfkh6xzm7sacz1sa34ffnkyqdk3xzh"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-portalocker))
    (native-inputs (list python-hatchling python-pytest))
    (home-page "https://github.com/Preston-Landers/concurrent-log-handler")
    (synopsis
     "Additional log handler for Python's standard @code{logging} package")
    (description
     "This package provides an additional log handler for Python's standard
@code{logging} package (PEP 282).  This handler will write log events to a log
file which is rotated when the log file reaches a certain size.  Multiple
processes can safely write to the same log file concurrently and rotated logs
can be gzipped if desired.  An optional threaded queue logging handler is
provided to perform logging in the background.")
    (license license:asl2.0)))

(define-public python-lazy
  (package
    (name "python-lazy")
    (version "1.6")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "lazy" version))
       (sha256
        (base32 "1sfk1v54dyjxvilcxf9vlnypc5z0mg0i2inb117k5s09qx7349vi"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/stefanholek/lazy")
    (synopsis "Lazy attributes for Python objects")
    (description "This package provides a decorator to create lazy
attributes.")
    (license license:bsd-2)))

(define-public python-logzero
  (package
    (name "python-logzero")
    (version "1.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "logzero" version))
       (sha256
        (base32 "10nh186vk6hpnpfycym44gja4fja0jyzw7q8dwimfd1rmv9xswvz"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest python-pytest-runner))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? inputs outputs #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               (invoke "pytest")))))))
    (home-page "https://github.com/metachris/logzero")
    (synopsis "Robust and effective logging for Python")
    (description
     "@code{logzero} provides a fully configured Python logger object for
easy logging and rotating to a console or a file.")
    (license license:expat)))

(define-public python-logbook
  (package
    (name "python-logbook")
    (version "1.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "Logbook" version))
       (sha256
        (base32 "1s1gyfw621vid7qqvhddq6c3z2895ci4lq3g0r1swvpml2nm9x36"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'build 'cythonize-sources
           (lambda _
             (with-directory-excursion "logbook"
               (invoke "cython" "_speedups.pyx"))))
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               ;; Check cython build also
               (setenv "CYBUILD" "True")
               (invoke "pytest" "--cov=logbook" "-r" "s" "tests")))))))
    (native-inputs
     (list python-cython python-mock python-pytest python-pytest-cov
           python-brotli))
    (home-page "https://github.com/getlogbook/logbook")
    (synopsis "Logbook is a logging replacement for Python")
    (description
     "Logbook is a logging system for Python that replaces the standard
library’s logging module.  It was designed with both complex and simple
applications in mind and the idea to make logging fun.")
    (license license:bsd-3)))

(define-public python-ubelt
  (package
    (name "python-ubelt")
    (version "1.0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Erotemic/ubelt")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0hac9nqqvqfbca2s4g0mp1fnj0ah60bg9fb8234ibna3jww8qs33"))))
    (build-system python-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (replace 'check
                 (lambda* (#:key tests? #:allow-other-keys)
                   (when tests?
                     (setenv "HOME" "/tmp") ;else the test suite hangs
                     (invoke "pytest" "-vv" "-k"
                             (string-append
                              ;; The builder user home doesn't match HOME,
                              ;; which causes this test to fail.
                              "not userhome "
                              ;; This one pointlessly tries
                              ;; locating various binaries on
                              ;; the path.
                              "and not find_exe"))))))))
    (propagated-inputs (list python-ordered-set))
    (native-inputs
     (list python-pytest
           python-requests
           python-xdoctest))
    (home-page "https://github.com/Erotemic/ubelt")
    (synopsis "Python library for hashing, caching, timing and more")
    (description "Ubelt is a small library of simple functions that extend the
Python standard library.  It includes an @acronym{API, Application Programming
Interface} to simplify common problems such as caching, timing, computing
progress, among other things.")
    (license license:asl2.0)))

(define-public python-ueberzug
  (package
    (name "python-ueberzug")
    (version "18.1.9")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ueberzug" version))
       (sha256
        (base32
         "1hxd45dnwa9yv908acarr98n2drmar66wzq9z2qd3irj24srzr3w"))))
    (build-system python-build-system)
    (inputs
     (list libx11 libxext))
    (propagated-inputs
     (list python-attrs python-docopt python-pillow python-xlib))
    (home-page "https://github.com/seebye/ueberzug")
    (synopsis "Command line util to display images in combination with X11")
    (description "Überzug is a command line util which draws images on
terminals by using child windows.  The advantages of using Überzug are:
@itemize
@item No race conditions as a new window is created to display images.
@item Expose events will be processed, so images will be redrawn on switch
workspaces.
@item Tmux support (excluding multi pane windows).
@item Terminals without the WINDOWID environment variable are supported.
@item Chars are used as position - and size unit.
@item No memory leak (/ unlimited cache).
@end itemize")
    (license license:gpl3+)))

(define-public python-databind-core
  (package
    (name "python-databind-core")
    (version "4.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "databind.core" version))
       (sha256
        (base32 "130hr19kbzizx9n2q7cwfzfk20ii3cqmqjrzb16psnafll303k2d"))
       (snippet
        #~(begin (use-modules (guix build utils))
                 ;; The problem with python-typing-extensions >= 4.7 is only
                 ;; with python-3.7.
                 (substitute* "pyproject.toml"
                   ((",<4.7.*") "\"\n"))))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'install 'fix-name
            (lambda* (#:key inputs outputs #:allow-other-keys)
              (let* ((sitedir (site-packages inputs outputs))
                     (dist-info
                      (string-append sitedir "/databind_core-" #$version ".dist-info")))
                (substitute* (string-append dist-info "/METADATA")
                  (("Name: databind-core")
                   "Name: databind.core"))
                (substitute* (string-append dist-info "/RECORD")
                  (("databind_core") "databind.core"))
                (rename-file dist-info
                             (string-append sitedir
                                            "/databind.core-"
                                            #$version ".dist-info"))))))))
    (propagated-inputs
     (list python-deprecated
           python-nr-date
           python-nr-stream
           python-typeapi
           python-typing-extensions))
    (native-inputs
     (list python-poetry-core python-pytest))
    (home-page "https://niklasrosenstein.github.io/python-databind/core/")
    (synopsis
     "Library for de-/serializing Python dataclasses")
    (description
     "Databind is a library inspired by jackson-databind to de-/serialize
Python dataclasses.")
    (license license:expat)))

(define-public python-databind-json
  (package
    (name "python-databind-json")
    (version "4.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "databind.json" version))
       (sha256
        (base32 "1lm864d7arfq0pw64hyc83bwn1z94wjg7a22q1xf0qkjynqs70gg"))
       (snippet
        #~(begin (use-modules (guix build utils))
                 ;; The problem with python-typing-extensions >= 4.7 is only
                 ;; with python-3.7.
                 (substitute* "pyproject.toml"
                   ((",<4.7.*") "\"\n"))))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'install 'fix-name
            (lambda* (#:key inputs outputs #:allow-other-keys)
              (let* ((sitedir (site-packages inputs outputs))
                     (dist-info
                      (string-append sitedir "/databind_json-" #$version ".dist-info")))
                (substitute* (string-append dist-info "/METADATA")
                  (("Name: databind-json")
                   "Name: databind.json"))
                (substitute* (string-append dist-info "/RECORD")
                  (("databind_json") "databind.json"))
                (rename-file dist-info
                             (string-append sitedir
                                            "/databind.json-"
                                            #$version ".dist-info"))))))))
    (propagated-inputs
     (list python-databind-core python-nr-date
           python-typeapi python-typing-extensions))
    (native-inputs (list python-poetry-core python-pytest))
    (home-page "https://niklasrosenstein.github.io/python-databind/json/")
    (synopsis
     "De-/serialize Python dataclasses to or from JSON payloads")
    (description
     "The @code{databind.json} package implements the de-/serialization to or
from JSON payloads using the @code{databind.core} framework.")
    (license license:expat)))

(define-public python-docspec
  (package
    (name "python-docspec")
    (version "2.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "docspec" version))
       (sha256
        (base32 "1zqmdrc6k8pprra8p3wpzq2ml2gph1cfjmsyg07f8b8fvizffm28"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #false))  ;there are none
    (propagated-inputs
     (list python-databind-core
           python-databind-json
           python-deprecated))
    (native-inputs
     (list python-poetry-core))
    (home-page "https://github.com/NiklasRosenstein/python-docspec")
    (synopsis "Represent API documentation of programming languages")
    (description
     "Docspec is a JSON object specification for representing API
documentation of programming languages.")
    (license license:expat)))

(define-public python-docspec-python
  (package
    (name "python-docspec-python")
    (version "2.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "docspec_python" version))
       (sha256
        (base32 "0n8m52vxmlvkj7p5jmd4rfdks65rrp4q4vzak44y6kbg9l5qa6y4"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #false))  ;there are none
    (propagated-inputs (list python-docspec python-nr-util))
    (native-inputs (list python-poetry-core))
    (home-page "https://github.com/NiklasRosenstein/docspec/")
    (synopsis "Produce docspec data from Python source code")
    (description
     "This package provides a parser based on @code{lib2to3} producing
@code{docspec} data from Python source code.")
    (license license:expat)))

(define-public python-fqdn
  (package
    (name "python-fqdn")
    (version "1.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "fqdn" version))
       (sha256
        (base32 "17yqckhymnamszhg06751c83rg3fnr5iy33a135bazvngrkx6phh"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #false)) ;there are none
    (propagated-inputs (list python-cached-property))
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/ypcrts/fqdn")
    (synopsis "Validate domain names against RFC 1123")
    (description
     "This package validates fully-qualified domain names against RFC 1123, so
that they are acceptable to modern bowsers")
    (license license:mpl2.0)))

(define-public python-fire
  (package
    (name "python-fire")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "fire" version))
       (sha256
        (base32
         "0rmaw26xjndr7makpiqv4h9aav9xf2h280w0khqc1lyddscmpv2l"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest")))))))
    (propagated-inputs
     (list python-six python-termcolor))
    (native-inputs
     (list python-mock python-pytest))
    (synopsis "Library for automatically generating command line interfaces")
    (description
     "Fire is a library for automatically generating command line interfaces
from absolutely any Python object.  The following are the advantages:
@itemize
@item A simple way to create a CLI in Python.
@item A helpful tool for developing and debugging Python code.
@item Helps with exploring existing code or turning other people's code into a
command line interface.
@item Makes transitioning between Bash and Python easier.
@item Makes using a Python REPL easier by setting up the REPL with the modules
and variables you'll need already imported and created.
@end itemize")
    (home-page "https://github.com/google/python-fire")
    (license license:asl2.0)))

(define-public python-fit-nbinom
  (package
    (name "python-fit-nbinom")
    (version "1.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "fit_nbinom" version))
              (sha256
               (base32
                "12v8l5i35vjbpvh5i4lw29ys6vpr3z7pysyrx33hxaq09zr015mx"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #false ;there are none
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'remove-invalid-syntax
           (lambda _
             (substitute* "setup.py"
               ((".\\*\"") "\"")))))))
    (propagated-inputs (list python-numpy python-scipy))
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/joachimwolff/fit_nbinom")
    (synopsis "Negative binomial maximum likelihood estimator")
    (description "This package provides an implementation in Python using
scipy and numpy of negative binomial maximum likelihood estimation.")
    (license license:gpl3+)))

(define-public python-docrep
  (package
    (name "python-docrep")
    (version "0.3.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "docrep" version))
              (sha256
               (base32
                "0523jrzjj29kxpdllmfhrfj9kysi9mphp2m7ippjkn5b07i1g2pd"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-six))
    (native-inputs (list python-pytest python-pytest-runner
                         python-setuptools python-wheel))
    (home-page "https://github.com/Chilipp/docrep")
    (synopsis "Python package for docstring repetition")
    (description "Docrep is the documentation repetition module.  This module
targets developers that develop complex and nested Python APIs and helps them
to create a well-documented piece of software.")
    (license license:asl2.0)))

(define-public python-dotmap
  (package
    (name "python-dotmap")
    (version "1.3.30")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "dotmap" version))
              (sha256
               (base32
                "0s5kb2v7jd0narz6m6jcicak3h5pw290wz21cdsv8pq77y9sf8aq"))))
    (build-system python-build-system)
    (home-page "https://github.com/drgrib/dotmap")
    (synopsis "Ordered, dynamically-expandable dot-access dictionary")
    (description
     "DotMap is a dot-access dictionary subclass that has dynamic
hierarchy creation, can be initialized with keys, can be initialized from a
dictionary, can be convert to a dictionary, and is ordered by insertion.")
    (license license:expat)))

(define-public python-dotty-dict
  (package
    (name "python-dotty-dict")
    (version "1.3.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "dotty_dict" version))
              (sha256
               (base32
                "058sah2nyg44xq5wxywlzc3abzcv9fifnlvsflwma9mfp01nw0ab"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-poetry-core python-setuptools))
    (home-page "https://github.com/pawelzny/dotty_dict")
    (synopsis "Python library for accessing dictionaries using a dot syntax")
    (description "This package provides a library that wraps the traditional
Python dictionaries and provides a syntax to access nested dictionaries values
using a dot syntax, for example: @code{dictionary['deeply.nested.key']}.")
    (license license:expat)))

(define-public python-adjusttext
  (package
    (name "python-adjusttext")
    (version "0.8")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "adjustText" version))
              (sha256
               (base32
                "05zf0xn7ab40dan213fwbp1z4rybih8dphf9mzb2ddmbafxq41mv"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #false)) ;there are none
    (propagated-inputs (list python-matplotlib python-numpy))
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/Phlya/adjustText")
    (synopsis "Adjust text position in matplotlib plots to minimize overlaps")
    (description
     "Often when we want to label multiple points on a graph the text will
start heavily overlapping with both other labels and data points.  This can be
a major problem requiring manual solution.  However this can be largely
automated by smart placing of the labels (difficult) or iterative adjustment
of their positions to minimize overlaps (relatively easy).  This library
implements the latter option to help with matplotlib graphs.")
    (license license:expat)))

(define-public python-affine
  (package
    (name "python-affine")
    (version "2.4.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "affine" version))
              (sha256
               (base32
                "1shyvajayyzbkp9dihb4mz835jnkp0kqqbyjfqci6v43da6q2kd2"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-coveralls python-flake8 python-pydocstyle
                             python-pytest python-pytest-cov))
    (native-inputs (list python-flit-core))
    (home-page "https://github.com/rasterio/affine")
    (synopsis "Matrices describing affine transformation of the plane")
    (description "This is a package for matrices describing the affine
transformation of the plane.")
    (license license:bsd-3)))

(define-public python-argopt
  (package
   (name "python-argopt")
   (version "0.7.0")
   (source (origin
            (method url-fetch)
            (uri (pypi-uri "argopt" version))
            (sha256
             (base32
              "0ybs7kkp0cpl8zn1lvf7481xhssg1bbhh5la2cjzdm5yibashyxa"))))
   (build-system python-build-system)
   (native-inputs
    (list python-coverage python-nose python-setuptools ; Won't build without this.
          python-setuptools-scm))
   (propagated-inputs
    (list python-toml python-flake8))
   (home-page "https://github.com/casperdcl/argopt")
   (synopsis "Generate a command-line interface from a docstring")
   (description "This package provides tools to define a command line interface
from a docstring rather than the other way around.")
   (license license:mpl2.0)))

(define-public python-array-api-compat
  (package
    (name "python-array-api-compat")
    (version "1.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "array_api_compat" version))
       (sha256
        (base32 "1a4y6ph3gx5fc2q74mkwc239d26b3yvlawc6ifxsay9wr4lbifhp"))))
    (build-system pyproject-build-system)
    ;; Tests would require all supported array libraries, including pytorch
    (arguments (list #:tests? #false))
    (native-inputs
     (list python-setuptools python-wheel))
    (propagated-inputs (list python-numpy))
    (home-page "https://data-apis.org/array-api-compat/")
    (synopsis "Array API compatibility wrapper for NumPy et al")
    (description
     "This package provides a wrapper around @code{NumPy} and other array
libraries to make them compatible with the Array API standard")
    (license license:expat)))

(define-public python-cachetools
  (package
    (name "python-cachetools")
    (version "5.5.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "cachetools" version))
              (sha256
               (base32
                "0ahg0mfp2ijsf92z5599kinpcp99lsfdpnddggxk75p3rfs4zhic"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/tkem/cachetools/")
    (synopsis "Extensible memoizing collections and decorators")
    (description "This module provides various memoizing collections and
decorators, including variants of the Python standard library's
@code{lru_cache} function decorator.")
    (license license:expat)))

(define-public python-cobib
  (package
    (name "python-cobib")
    (version "3.5.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "cobib" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "16nbrbvascbf6cb7yvn9q793dy8zx703pqrmk3mswib9a19mnx3n"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-beautifulsoup4
           python-bibtexparser
           python-pylatexenc
           python-requests
           python-requests-oauthlib
           python-ruamel.yaml))
    (native-inputs
     (list python-future
           python-pyte
           python-pytest))
    (home-page "https://gitlab.com/mrossinek/cobib")
    (synopsis "Terminal-based bibliography management tool")
    (description
     "@command{cobib} is a command-line based bibliography management tool.
It uses a plain-text database, a location-independent library, and features
git integration, command-line support, and a curses-based TUI.")
    (license license:expat)))

(define-public python-colorcet
  (package
    (name "python-colorcet")
    (version "3.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "colorcet" version))
       (sha256
        (base32 "1sx4m5xbz1k8bm8cr2f3x21dip167k7c1nv35npqla52h76v6899"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-nbval
                         python-packaging
                         python-pytest
                         python-pytest-cov
                         python-pytest-mpl
                         python-setuptools
                         python-wheel))
    (home-page "https://colorcet.holoviz.org/")
    (synopsis "Collection of perceptually uniform colormaps")
    (description "Colorcet is a collection of perceptually accurate 256-color
colormaps for use with Python plotting programs like Bokeh, Matplotlib,
HoloViews, and Datashader.")
    (license license:cc-by4.0)))

(define-public python-colored
  (package
    (name "python-colored")
    (version "1.4.4")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://gitlab.com/dslackw/colored")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "196ins0m7f90xz5dw764dlx060ziqbcydqzzq40b4ir5858baf3r"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #false)) ;the tests are not run automatically
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://gitlab.com/dslackw/colored")
    (synopsis "Simple library for color and formatting to terminal")
    (description "This is a very simple Python library for color and
formatting in the terminal.  It comes with a collection of color codes and
names for 256 color terminal setups.")
    (license license:expat)))

(define-public python-colorful
  (package
    (name "python-colorful")
    (version "0.5.5")
    (source
     (origin
       (method git-fetch)   ; no tests data in PyPi package
       (uri (git-reference
             (url "https://github.com/timofurrer/colorful")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0kyy9qhvrb5m9h8xmri7c88i0k1g5qc7017anw39gx44an7mn33y"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-coverage python-flake8 python-pytest python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-colorama))
    (home-page "http://github.com/timofurrer/colorful")
    (synopsis "Terminal string styling")
    (description "Colorful provides an array of text styles, that can be used
as functions or string constants to form colored terminal output.")
    (license license:expat)))

(define-public python-colorthief
  (package
    (name "python-colorthief")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "colorthief" version))
       (sha256
        (base32 "08bjsmmkihyksms2vgndslln02rvw56lkxz28d39qrnxbg4v1707"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-setuptools python-wheel))
    (propagated-inputs (list python-pillow))
    (home-page "https://github.com/fengsp/color-thief-py")
    (synopsis "Grab the color palette of an image")
    (description
     "This package provides methods to determine the dominant color
of an image, as well as constructing a representative color palette.")
    (license license:bsd-3)))

(define-public python-construct-classes
  (package
    (name "python-construct-classes")
    (version "0.1.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/matejcik/construct-classes")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0fmr8nfg543lyqk4164a52jb6lwpq98radicbkhhdfckq9lib2wp"))))
    (build-system pyproject-build-system)
    (propagated-inputs
     (list python-construct))
    (native-inputs
     (list python-poetry-core
           python-pytest))
    (home-page "https://github.com/matejcik/construct-classes")
    (synopsis "Parse binary structs into dataclasses")
    (description "This package provides a parser to parse binary structs
into dataclasses.")
    (license license:expat)))

(define-public python-contourpy
  (package
    (name "python-contourpy")
    (version "1.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "contourpy" version))
       (sha256
        (base32 "1az80zv067rcybm5x93j7rfiakbwiv1h8l58gnki4wjbwb13gfln"))))
    (build-system pyproject-build-system)
    (arguments
     ;; Image tests require matplotlib and create a circular dependency.
     (list #:test-flags
           #~(list "-m" "not image")))
    (propagated-inputs
     (list python-numpy))
    (native-inputs
     (list cmake-minimal
           meson-python
           pkg-config
           pybind11
           python-pytest
           python-pytest-cov
           python-wurlitzer))
    (home-page "https://contourpy.readthedocs.io/")
    (synopsis
     "Python library for calculating contours of 2D quadrilateral grids")
    (description
     "ContourPy is a Python library for calculating contours of 2D
quadrilateral grids.  It is written in C++11 and wrapped using pybind11.")
    (license license:bsd-3)))

(define-public python-yaspin
  (package
    (name "python-yaspin")
    (version "1.5.0")
    (source
     (origin
       (method url-fetch)
       (uri
        (pypi-uri "yaspin" version))
       (sha256
        (base32 "1iirah0kydrdp505qnjj6gi54avcr7z0hbkfx9vmh8myr30rpz6q"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/pavdmyt/yaspin")
    (synopsis "Yet Another Terminal Spinner")
    (description "Yaspin provides a terminal spinner to indicate the progress
during long operations.")
    (license license:expat)))

(define-public python-lunr
  (package
    (name "python-lunr")
    (version "0.7.0.post1")
    (source
     (origin
       (method url-fetch)
       (uri
        (pypi-uri "lunr" version))
       (sha256
        (base32 "1njb23lw619ppidqdzygdrscna4z15n9xjc4cc7yxiskkgsriz00"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      '(list "-k" "not TestLanguageSupport"
             "--ignore-glob=tests/acceptance_tests/*")))
    (native-inputs
     (list python-coverage
           python-hatch-fancy-pypi-readme
           python-hatchling
           python-pytest
           python-pytest-timeout
           python-tox))
    (propagated-inputs
     (list python-importlib-metadata python-typing-extensions))
    (home-page
     "https://github.com/yeraydiazdiaz/lunr.py")
    (synopsis "Full-text search library")
    (description "This package provides python library for full-text search.
It indexes documents and provides a search interface for retrieving documents
that best match text queries.")
    (license license:expat)))

(define-public python-mdit-py-plugins
  (package
    (name "python-mdit-py-plugins")
    (version "0.4.0")
    (source (origin
              (method git-fetch)        ;for tests
              (uri (git-reference
                    (url "https://github.com/executablebooks/mdit-py-plugins")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1790fcf3nd9c5j37fx87x3ivfyihk6l74jxj1qxvw3qfyb96w4k0"))))
    (build-system pyproject-build-system)
    (propagated-inputs
     (list python-markdown-it-py
           python-attrs))
    (native-inputs
     (list python-coverage
           python-flit-core
           python-pytest
           python-pytest-cov
           python-pytest-regressions))
    (home-page "https://github.com/executablebooks/mdit-py-plugins")
    (synopsis "Collection of plugins for markdown-it-py")
    (description "This package contains a collection of plugins for
@code{markdown-it-py} like:
@enumerate
@item amsmath,
@item attrs,
@item container,
@item definition list,
@item dollarmath,
@item field list,
@item footnote,
@item textmath, and
@item wordcount.
@end enumerate")
    (license license:expat)))

(define-public python-mdurl
  (package
    (name "python-mdurl")
    (version "0.1.2")
    (source
     (origin
       (method git-fetch)   ; no tests data in PyPi package
       (uri (git-reference
             (url "https://github.com/executablebooks/mdurl")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0csc777q42jzv4zgdzxmwp8xqlb92ws1jvj09m2smh4klw67q5f3"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-flit python-pytest))
    (home-page "https://github.com/executablebooks/mdurl")
    (synopsis "Markdown URL utilities")
    (description
     "This package implements a Python port of the JavaScript @code{mdurl}.")
    (license license:expat)))

(define-public python-mkdocs
  (package
    (name "python-mkdocs")
    (version "1.3.0")
    (source
     (origin
       ;; The tests suite appears to be incomplete in the PyPI archive.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/mkdocs/mkdocs")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1n5rdllrxvhnxmdrddf55p3s86dakx0rq2gg6bj6pr6jg2pn932b"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         ;; Requirements refer to a specific version of dependencies,
         ;; which are too old. So we patch to refer to any later version.
         (add-after 'unpack 'patch-requirements
           (lambda _
             (substitute* "setup.py"
               (("==") ">="))))
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "python" "-m" "unittest"
                       "discover" "-p" "*tests.py" "mkdocs"
                       "--top-level-directory" ".")))))))
    (propagated-inputs
     (list python-babel
           python-click
           python-ghp-import
           python-importlib-metadata
           python-jinja2
           python-markdown
           python-markupsafe
           python-mdx-gh-links
           python-mergedeep
           python-packaging
           python-pyyaml
           python-pyyaml-env-tag
           python-watchdog))
    (home-page "https://www.mkdocs.org")
    (synopsis "Project documentation with Markdown")
    (description "MkDocs is a static site generator geared towards building
project documentation.  Documentation source files are written in Markdown, and
configured with a single YAML configuration file.")
    (license license:bsd-3)))

(define-public python-mkdocs-markdownextradata-plugin
  (package
    (name "python-mkdocs-markdownextradata-plugin")
    (version "0.2.5")
    (source (origin
       ;; Use git, as there are some test files missing from the PyPI release,
       ;; see https://github.com/rosscdh/mkdocs-markdownextradata-plugin/issues/41.
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/rosscdh/mkdocs-markdownextradata-plugin")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1a3868s9m7pzyfncpjbjsa9vw5nihssl2v47pxj7h6qa67kvlk3g"))))
    (build-system python-build-system)
    (native-inputs (list python-pytest))
    (propagated-inputs (list python-mkdocs python-pyyaml))
    (home-page "https://github.com/rosscdh/mkdocs-markdownextradata-plugin/")
    (synopsis "Inject mkdocs.yml extra variables into the MkDocs markdown
template")
    (description
     "This package provides a MkDocs plugin that injects the mkdocs.yml extra
variables into the markdown template")
    (license license:expat)))

(define-public python-docstring-to-markdown
  (package
    (name "python-docstring-to-markdown")
    (version "0.15")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "docstring-to-markdown" version))
       (sha256
        (base32 "0gdpabnyl1kyy0cjrnph6xl4fyhgim50a1amsaqq3hahki6i2ip1"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'reduce-test-coverage-since-failing
            (lambda _
              (substitute* "setup.cfg"
                (("(^.*cov.*$|^.*flake8.*$)") "")))))))
    (native-inputs
     (list python-pytest
           python-pytest-cov
           python-pytest-flake8
           python-setuptools
           python-wheel))
    (home-page "https://github.com/python-lsp/docstring-to-markdown")
    (synopsis "On the fly conversion of Python docstrings to markdown")
    (description
     "This module can convert Python docstrings to Markdown.  It can recognise
reStructuredText inside docstrings and convert multiple of its features to
Markdown.  It also includes initial support for Google-formatted docstrings.")
    (license license:lgpl2.1+)))

(define-public python-mysql-connector-python
  (package
    (name "python-mysql-connector-python")
    (version "8.0.33")
    ;; The archive on PyPi does not contain a build system
    (source (origin
              (method url-fetch)
              (uri (string-append "https://cdn.mysql.com/Downloads/"
                                  "Connector-Python/mysql-connector-python-"
                                  version "-src.tar.gz"))
              (sha256
               (base32
                "00j9xgd43yzx5yiijnlmpaqpa58m5lscjglsgzg48dibhr69br0l"))))
    (build-system python-build-system)
    (arguments
     (list
      #:configure-flags
      #~(list (string-append "--with-mysql-capi="
                             #$(this-package-input "mysql"))
              (string-append "--with-protobuf-include-dir="
                             #$(this-package-input "protobuf")
                             "/include/google/protobuf")
              (string-append "--with-protobuf-lib-dir="
                             #$(this-package-input "protobuf")
                             "/lib")
              (string-append "--with-protoc="
                             #$(this-package-input "protobuf")
                             "/bin/protoc"))
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'compatibility
            (lambda _
              (substitute* "src/mysql_capi.c"
                (("res = mysql_options\\(&self->session, MYSQL_OPT_LOAD_DATA_LOCAL_DIR.*")
                 "res = 0;")
                (("mysql_options\\(&self->session, MYSQL_OPT_LOAD_DATA_LOCAL_DIR.*")
                 "")
                (("mysql_options\\(&self->session, MYSQL_OPT_TLS_CIPHERSUITES.*")
                 "")
                ;; The C API does not have mysql_bind_param, so we produce an
                ;; error here.
                (("status = mysql_bind_param.*") "status = 1;"))
              ;; See https://github.com/protocolbuffers/protobuf/issues/9943
              (substitute* "src/mysqlxpb/mysqlxpb.cc"
                (("google::protobuf::string") "std::string"))))
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                ;; Some of these tests might be failing due to the build
                ;; container's restrictions, others are due to the version
                ;; mismatch.
                (substitute* "tests/cext/test_cext_api.py"
                  (("def test_change_user") "def _do_not_test_change_user")
                  (("def test_get_character_set_info")
                   "def _do_not_test_get_character_set_info"))
                (substitute* "tests/test_bugs.py"
                  (("def test_change_user") "def _do_not_test_change_user")
                  (("def test_lost_connection") "def _do_not_test_lost_connection")
                  (("def test_kill_query") "def _do_not_test_kill_query")
                  ;; These all fail because of expired certificates.
                  (("def test_cext_verify_server_certificate")
                   "def _do_not_test_cext_verify_server_certificate")
                  (("def test_pure_verify_server_certificate")
                   "def _do_not_test_pure_verify_server_certificate")
                  (("def test_verify_server_name_cext_cnx")
                   "def _do_not_test_verify_server_name_cext_cnx")
                  (("def test_verify_server_name_pure_cnx")
                   "def _do_not_test_verify_server_name_pure_cnx"))
                (substitute* "tests/test_connection.py"
                  (("def test_allow_local_infile_in_path")
                   "def _do_not_test_allow_local_infile_in_path")
                  ;; This fails because of expired certificates.
                  (("def test_connect_with_unix_socket")
                   "def _do_not_test_connect_with_unix_socket"))
                (substitute* "tests/test_mysqlx_connection.py"
                  ;; This fails because of expired certificates.
                  (("def test_ssl_connection")
                   "def _do_not_test_ssl_connection"))
                (substitute* "tests/test_constants.py"
                  (("def test_deprecated")
                   "def _do_not_test_deprecated"))
                (mkdir-p "/tmp/datadir")
                (invoke "python3" "unittests.py"
                        "--verbosity=3"
                        (string-append "--with-mysql=" #$(this-package-input "mysql"))
                        "--keep"
                        "--mysql-topdir=/tmp/datadir"
                        "--unix-socket=/tmp/datadir")))))))
    (propagated-inputs (list python-protobuf))
    (inputs (list mysql protobuf-3.20 openssl-1.1 zlib))
    (home-page "https://dev.mysql.com/doc/connector-python/en/index.html")
    (synopsis "MySQL driver written in Python")
    (description "MySQL Connector/Python enables Python programs to access
MySQL databases, using an API that is compliant with the Python Database API
Specification v2.0 (PEP 249).")
    (license license:gpl2)))

(define-public python-pdoc
  (package
    (name "python-pdoc")
    (version "13.0.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/mitmproxy/pdoc")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0gxkw607nrd67ck4w8jri9vfrm5g60qvp8b134m8zkiphbxjnx0l"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-jinja2 python-pygments
                         python-setuptools python-wheel))
    (arguments
     (list
      ;; Some tests fail, presumably because of slight version mismatches of
      ;; the dependencies.
      #:test-flags
      '(list "-k" (string-append "not test_var_with_raising_repr and "
                                 "not test_smoke[mock] and "
                                 "not test_snapshots[html"))))
    (home-page "https://pdoc.dev/")
    (synopsis "API documentation for Python projects")
    (description "pdoc auto-generates API documentation that follows your
project's Python module hierarchy.  It requires no configuration, has
first-class support for type annotations, cross-links between identifiers,
comes with an integrated live-reloading web server, uses customizable HTML
templates, understands numpydoc and Google-style docstrings.")
    (license license:unlicense)))

(define-public python-py4j
  (package
    (name "python-py4j")
    (version "0.10.9.7")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "py4j" version))
              (sha256
               (base32
                "1fwdx92cdaiviradksfyygg05g1fpc3x2lf65bv5rnispcam6vhb"))))
    (build-system python-build-system)
    (home-page "https://www.py4j.org/")
    (synopsis "Dynamically access arbitrary Java objects from Python")
    (description
     "This package enables Python programs to dynamically access arbitrary
Java objects.")
    (license license:bsd-3)))

(define-public python-pymdown-extensions
  (package
    (name "python-pymdown-extensions")
    (version "8.1.1")
    (source
     (origin
       (method url-fetch)
       (uri
        (pypi-uri "pymdown-extensions" version))
       (sha256
        (base32 "0d8pdndrl1kj105lq7r6kw2dnhcvll6h2qs07w71mcpi7gx728v3"))))
    (build-system python-build-system)
    ;; FIXME: "AssertionError: False is not true"
    (arguments
     `(#:tests? #f))
    (propagated-inputs
     (list python-markdown))
    (home-page "https://github.com/facelessuser/pymdown-extensions")
    (synopsis "Extension pack for Python Markdown")
    (description "PyMdown Extensions is a collection of extensions for Python
Markdown.  All extensions are found under the module namespace of pymdownx.")
    (license license:expat)))

(define-public python-pint
  (package
    (name "python-pint")
    (version "0.23")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "Pint" version))
              (sha256
               (base32
                "1d69dqs0j907x4hgz2k8f3zjzhgs9zvlw2k0gi955g3dc28rnl71"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      '(list "--ignore=pint/testsuite/benchmarks"
             "-k" (string-append
                   ;; This test tries to write to $HOME/.cache/pint.
                   "not test_auto"
                   ;; Our pytest can't match RuntimeWarning for some reason.
                   ;; Note: python-pint@0.24.4 would work around this, too.
                   " and not test_nonnumeric_magnitudes"
                   ;; Fails with "Group USCSLengthInternational already
                   ;; present in registry"
                   " and not test_load_definitions_stage_2"))))
    (native-inputs
     (list python-pytest python-pytest-benchmark python-pytest-cov
           python-pytest-mpl python-pytest-subtests
           python-setuptools python-setuptools-scm python-wheel))
    (propagated-inputs
     (list python-typing-extensions
           python-uncertainties))
    (home-page "https://github.com/hgrecco/pint")
    (synopsis "Physical quantities module")
    (description
     "Pint is a Python package to define, operate and manipulate physical
quantities: the product of a numerical value and a unit of measurement.  It
allows arithmetic operations between them and conversions from and to
different units.")
    (license license:bsd-3)))

(define-public python-plotext
  (package
    (name "python-plotext")
    (version "5.2.8")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "plotext" version))
              (sha256
               (base32
                "1gpy1z2i4vq1mcrhysxahz4339pbl9rzk58rf5m5gf5ym9xji6ii"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #false)) ;there are none
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/piccolomo/plotext")
    (synopsis "Plots in the terminal")
    (description "Plotext lets you plot directly to the terminal.")
    (license license:expat)))

(define-public python-plotille
  (package
    (name "python-plotille")
    (version "4.0.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "plotille" version))
              (sha256
               (base32
                "0fvsk6glxfphhqy405h05rj3v95jd1byl5hv2fyd5l31wln23shj"))))
    (build-system python-build-system)
    (native-inputs (list python-six))
    (home-page "https://github.com/tammoippen/plotille")
    (synopsis "Plot in the terminal using braille dots")
    (description
     "Plotille provides a figure class and graphing functions to create plots,
scatter plots, histograms and heatmaps in the terminal using braille dots.")
    (license license:expat)))

(define-public python-poetry-dynamic-versioning
  (package
    (name "python-poetry-dynamic-versioning")
    (version "1.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "poetry_dynamic_versioning" version))
       (sha256
        (base32 "19v9jrawbx1nwnwrd6giyzwfq50y2mjzkrsx0ga2sbx2a2yphlbj"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "--ignore=tests/test_integration.py"
              ;; E RuntimeError: Unable to detect version control system. Not
              ;; installed: Git, Mercurial, Darcs, Subversion, Bazaar, Fossil,
              ;; Pijul.
              "-k"
              (string-append
               "not test__get_version__defaults"
               " and not test__get_version__format_jinja"
               " and not test__get_version__format_jinja_with_enforced_style"
               " and not test__get_version__format_jinja_imports_with_module_only"
               " and not test__get_version__format_jinja_imports_with_module_and_item"))))
    (native-inputs
     (list python-poetry-core
           python-pytest))
    (propagated-inputs
     (list poetry
           python-dunamai
           python-jinja2
           python-tomlkit))
    (home-page "https://github.com/mtkennerly/poetry-dynamic-versioning")
    (synopsis "Poetry plugin enabling VCS tags dynamic versioning")
    (description
     "This package provides a build backend that patches Poetry Core to enable
the versioning system in PEP 517 build frontends.")
    (license license:expat)))

(define-public python-poetry-plugin-export
  (package
    (name "python-poetry-plugin-export")
    (version "1.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "poetry_plugin_export" version))
       (sha256
        (base32 "0qgw6w4xaw7cz9ykw376c5hcg9v2k30lnmna6pc9b4ymhn51d9hz"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #f)) ;tests cycle with poetry
    (native-inputs
     (list python-poetry-core))
    (propagated-inputs
     (list python-pendulum))
    (home-page "https://python-poetry.org/")
    (synopsis "Poetry plugin to export the dependencies to various formats")
    (description
     "Poetry plugin to export the dependencies to various formats.")
    (license license:expat)))

(define-public python-portpicker
  (package
    (name "python-portpicker")
    (version "1.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "portpicker" version))
       (sha256
        (base32 "1yiisk4h8qliwf99khz3lszrpjf6km76fbhzg01fwrbgz7b7yl5x"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; This fails because portserver ends up in bin, not site-packages
      '(list "--ignore=src/tests/portserver_test.py")))
    (propagated-inputs (list python-psutil))
    (native-inputs (list python-pytest python-setuptools python-wheel
                         net-tools))
    (home-page "https://github.com/google/python_portpicker")
    (synopsis "Choose unique available network ports")
    (description
     "This package provides a library to choose unique available network
ports.")
    (license license:asl2.0)))

(define-public python-mdx-gh-links
  (package
    (name "python-mdx-gh-links")
    (version "0.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "mdx_gh_links" version))
       (sha256
        (base32 "167k1jbp3jifxbnlpi6wy0z1skam7gqv2sixb5bhggb2vypqvysr"))))
    (build-system python-build-system)
    (arguments (list #:tests? #f))      ;tests connect github
    (propagated-inputs (list python-markdown))
    (home-page "https://github.com/Python-Markdown/github-links/")
    (synopsis "Python-Markdown extension adding support for shorthand links")
    (description "This package is an extension to Python-Markdown which adds
support for shorthand links to GitHub users, repositories, issues and
commits.")
    (license license:bsd-3)))

(define-public python-mkdocs-material
  (package
    (name "python-mkdocs-material")
    (version "7.1.3")
    (source
     (origin
       (method url-fetch)
       (uri
        (pypi-uri "mkdocs-material" version))
       (sha256
        (base32 "0ci9xiasq9nfn09v11m7p49vzazdbgslw7rpzjd6y3hsmn9vljz3"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         ;; Requirement mkdocs-material-extensions
         ;; in-turn requires mkdocs-material. This causes
         ;; circular dependency, so we remove this requirement.
         (add-after 'unpack 'patch-requirements
           (lambda _
             (substitute* "requirements.txt"
               (("mkdocs-material-extensions.*$") "")))))))
    (propagated-inputs
     (list python-markdown python-mkdocs python-pygments
           python-pymdown-extensions))
    (home-page "https://squidfunk.github.io/mkdocs-material/")
    (synopsis "Material Design theme for MkDocs")
    (description "This package provides a theme plugin for the static site
generator MkDocs.")
    (license license:expat)))

(define-public python-skranger
  (package
    (name "python-skranger")
    (version "0.8.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/crflynn/skranger")
                    (commit version)
                    (recursive? #true)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0njy4xbc98l295k92nyk93njv1348vd1il5pdyrnk8nnzc2anzf0"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:modules '((guix build pyproject-build-system)
                  (guix build utils)
                  (ice-9 match))
      #:test-flags
      ;; "from sklearn.datasets import load_boston" fails because it has been
      ;; removed from scikit-learn since version 1.2.
      '(list "--ignore=tests/conftest.py"
             "--ignore=tests/test_tools.py"
             "--ignore=tests/tree/test_regressor.py"
             "--ignore=tests/ensemble/test_regressor.py")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-tests
            (lambda _
              (substitute* "tests/conftest.py"
                (("from sklearn.datasets import load_boston") "")
                (("^_boston_X.*") "_boston_X, _boston_Y = (True, True)\n"))))
          (add-before 'check 'build-extensions
            (lambda _
              ;; Cython extensions have to be built before running the tests.
              (invoke "python" "buildpre.py")
              (invoke "python" "build.py" "build_ext" "--inplace")
              (let ((site (string-append #$output "/lib/python"
                                         #$(version-major+minor
                                            (package-version python))
                                         "/site-packages/skranger"))
                    (lib (match (find-files "build" "\\.so")
                           ((the-lib) the-lib)
                           (_ (error "could not find .so")))))
                (mkdir-p site)
                (install-file lib site)))))))
    (propagated-inputs (list python-scikit-learn))
    (native-inputs
     (list python-cython
           python-matplotlib
           python-pandas
           python-poetry-core
           python-setuptools
           python-wheel
           python-pytest))
    (home-page "https://github.com/crflynn/skranger")
    (synopsis "Python bindings for C++ ranger random forests")
    (description "This package provides scikit-learn compatible Python
bindings to the C++ random forest implementation, ranger, using Cython.")
    (license license:gpl3+)))

(define-public python-nanobind
  (package
    (name "python-nanobind")
    (version "2.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "nanobind" version))
       (sha256
        (base32 "15hw9r0znv7pz8mlgcb892m8ahppaf7gx2xcna2i122qbzp2sfd0"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'configure-cmake
            (lambda _
              (invoke "cmake" "-S" "." "-B" "build" "-DNB_TEST_STABLE_ABI=ON")))
          (add-after 'configure-cmake 'build-c++
            (lambda _
              (invoke "cmake" "--build" "build" "-j" "2")))
          (add-before 'check 'pre-check
            (lambda _ (chdir "build"))))))
    (inputs (list eigen))
    (native-inputs (list cmake-minimal
                         python-pytest
                         python-scikit-build-core))
    (home-page "https://github.com/wjakob/nanobind/")
    (synopsis "nanobind: tiny and efficient C++/Python bindings")
    (description "Nanobind is a small binding library that exposes C++ types
in Python and vice versa.  It is reminiscent of @code{Boost.Python} and
@code{pybind11} and uses near-identical syntax.  In contrast to these existing
tools, @code{nanobind} is more efficient: bindings compile in a shorter amount
of time, produce smaller binaries, and have better runtime performance.")
    (license license:bsd-3)))

(define-public python-nr-date
  (package
    (name "python-nr-date")
    (version "2.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "nr_date" version))
       (sha256
        (base32 "1rnjyykjp41mqz6h1vx18jblq97gi5m5x7dgasyaihnd7fhswhq6"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #false)) ;there are none
    (native-inputs (list python-poetry-core))
    (home-page "https://github.com/NiklasRosenstein/python-nr.date")
    (synopsis "Fast, regex-based date parsing library in plain Python")
    (description "This package provides a fast, regex-based date parsing
library in pure Python.")
    (license license:expat)))

(define-public python-nr-stream
  (package
    (name "python-nr-stream")
    (version "1.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "nr_stream" version))
       (sha256
        (base32 "0rag4vbjnalkyfcarx6yipn11ih2hmc3pfldava4c6n6pz31c0pb"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #false))  ;there are none
    (native-inputs (list python-poetry-core))
    (home-page "https://github.com/NiklasRosenstein/python-nr.stream")
    (synopsis "Stream and Optional classes for Python")
    (description "This package provides a @code{Stream} and @code{Optional}
class.")
    (license license:expat)))

(define-public python-nr-util
  (package
    (name "python-nr-util")
    (version "0.8.12")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "nr.util" version))
       (sha256
        (base32 "1x0l4811dskwrk83l2xzdcldx2iazlrx5wxkg41jz7fr6ch9qm54"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #false                   ;there are none
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-build-system
            (lambda _
              (substitute* "pyproject.toml"
                (("^config =.*") "config = []\n"))))
          (add-after 'install 'fix-name
            (lambda* (#:key inputs outputs #:allow-other-keys)
              (let* ((sitedir (site-packages inputs outputs))
                     (dist-info
                      (string-append sitedir "/nr_util-" #$version ".dist-info")))
                (substitute* (string-append dist-info "/METADATA")
                  (("Name: nr-util")
                   "Name: nr.util"))
                (substitute* (string-append dist-info "/RECORD")
                  (("nr_util") "nr.util"))
                (rename-file dist-info
                             (string-append sitedir
                                            "/nr.util-"
                                            #$version ".dist-info"))))))))
    (propagated-inputs (list python-deprecated python-typing-extensions))
    (native-inputs (list python-poetry-core))
    (home-page "https://github.com/NiklasRosenstein/python-nr.util")
    (synopsis "General purpose Python utility library")
    (description "This package provides a general purpose Python utility
library.")
    (license license:expat)))

(define-public python-slicerator
  (package
    (name "python-slicerator")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "slicerator" version))
       (sha256
        (base32 "0ik0bmh18zgffd9kx53254jp3yyih6zcmd8kfb080xnqbizhl0a4"))))
    (build-system python-build-system)
    (home-page "https://github.com/soft-matter/slicerator")
    (synopsis "Lazy-loading, fancy-sliceable iterable")
    (description
     "This package provides a lazy-loading, fancy-sliceable iterable.  Think
of it like a generator that is \"reusable\" and has a length.")
    (license license:bsd-3)))

(define-public python-slixmpp
  (package
    (name "python-slixmpp")
    (version "1.8.3")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://lab.louiz.org/poezio/slixmpp.git")
         (commit
          (string-append "slix-" version))))
       (file-name
        (git-file-name name version))
       (sha256
        (base32 "0cvr037qhf0fpby5dci6ckqngaly1mnjs2zpndwgmvr3dyvrd8l8"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch
           (lambda _
             (substitute* "setup.py"
               (("'CC', 'cc'")
                "'CC', 'gcc'"))
             #t)))))
    (native-inputs
     `(("cython" ,python-cython)
       ("gnupg" ,gnupg)
       ("pkg-config" ,pkg-config)))
    (propagated-inputs
     (list python-aiodns
           python-aiohttp
           python-cryptography
           python-defusedxml
           python-emoji
           python-pyasn1
           python-pyasn1-modules))
    (inputs
     (list libidn python)) ; We are building a Python extension.
    (synopsis "XMPP library without threads")
    (description "Slixmpp is a XMPP library for Python 3.7+.  It is a fork of
SleekXMPP.  Its goal is to only rewrite the core of the library (the low level
socket handling, the timers, the events dispatching) in order to remove all
threads.")
    (home-page "https://lab.louiz.org/poezio/slixmpp")
    (license license:expat)))

(define-public python-tenacity
  (package
    (name "python-tenacity")
    (version "9.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "tenacity" version))
       (sha256
        (base32 "0fyp421r038naskvyhj90hkq0az96477njad4rhs6annjz53fzw0"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-setuptools-scm
           python-tornado-6
           python-typeguard
           python-wheel))
    (home-page "https://github.com/jd/tenacity")
    (synopsis "Retrying library for python")
    (description
     "Tenacity is a general-purpose python library to simplify the task of
adding retry behavior to just about anything.")
    (license license:asl2.0)))

(define-public python-pytelegrambotapi
  (package
    (name "python-pytelegrambotapi")
    (version "4.22.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/eternnoir/pyTelegramBotAPI")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0mic9wk6xg7p2ca7b03fc19l86yc9bkciq7kp8l9xvzzzmg4rzw4"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (with-directory-excursion "tests"
                  (invoke "py.test"))))))))
    (propagated-inputs
     (list python-requests))
    (native-inputs
     (list python-hatchling python-pytest))
    (home-page "https://github.com/eternnoir/pyTelegramBotAPI")
    (synopsis "Python Telegram bot api")
    (description "This package provides a simple, but extensible Python
implementation for the Telegram Bot API.")
    (license license:gpl2)))

(define-public python-pytoolconfig
  (package
    (name "python-pytoolconfig")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pytoolconfig" version))
       (sha256
        (base32 "1bnvg9yiwp2fn0lvzhp1dd2mvrymxvjnasmbdap3i0hhdwdbvrji"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-packaging
                             python-platformdirs
                             python-pydantic-2
                             python-sphinx
                             python-sphinx-autodoc-typehints
                             python-sphinx-rtd-theme
                             python-tabulate
                             python-tomli))
    (native-inputs (list python-pdm-backend python-pytest))
    (home-page "https://pypi.org/project/pytoolconfig/")
    (synopsis "Python tool configuration")
    (description "The goal of this project is to manage configuration for
Python tools, such as rope and add support for a @file{pyproject.toml}
configuration file.")
    (license license:lgpl3+)))

(define-public python-pytooling
  (package
    (name "python-pytooling")
    (version "8.1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/pyTooling/pyTooling/")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "07mca75d2zd6xl0isf0vrcblsc2niyqi7941dgjpiafnsgiygfzf"))))
    (build-system pyproject-build-system)
    (arguments
     `(#:tests? #f)) ; requires recent versions of mypy and lxml
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://pytooling.github.io/pyTooling/")
    (synopsis "Miscellaneous Python tools")
    (description
     "pyTooling is a collection of (abstract) data models, lacking classes,
decorators, a new performance boosting meta-class, and enhanced exceptions.
It also provides lots of helper functions---e.g., to ease the handling of
package descriptions or to unify multiple existing APIs into a single API.")
    (license license:asl2.0)))

(define-public python-colorlog
  (package
    (name "python-colorlog")
    (version "6.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "colorlog" version))
       (sha256
        (base32 "1s7x0v872h8aks8xp01wmv6hzisxqjrh1svbbcycir0980h76krl"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key inputs outputs tests? #:allow-other-keys)
              (when tests?
                (add-installed-pythonpath inputs outputs)
                (invoke "python" "-m" "pytest")))))))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/borntyping/python-colorlog")
    (synopsis "Log formatting with colors for python")
    (description "The @code{colorlog.ColoredFormatter} is a formatter for use
with Python's logging module that outputs records using terminal colors.")
    (license license:expat)))

(define-public python-pyprind
  (package
    (name "python-pyprind")
    (version "2.11.3")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "PyPrind" version))
              (sha256
               (base32
                "1gscnlvj37m421ch3akm3kddxqkrgbg5zrpwy2ky1j59w6vclzg3"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-psutil))
    (home-page "https://github.com/rasbt/pyprind")
    (synopsis "Python Progress Bar and Percent Indicator Utility")
    (description "The PyPrind (Python Progress Indicator) module provides a
progress bar and a percentage indicator object that let you track the progress
of a loop structure or other iterative computation.")
    (license license:bsd-3)))

(define-public python-gh-md-to-html
  (package
    (name "python-gh-md-to-html")
    (version "1.21.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "gh_md_to_html" version))
       (sha256
        (base32 "1cnaqnckpcrpc4b8ba18s5ds05w1yfiszcp7ql7pmx0jnrj25qax"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #false))  ;there are none
    (propagated-inputs
     (list python-beautifulsoup4
           python-emoji-for-gh-md-to-html
           python-pillow
           python-requests
           python-shellescape
           python-webcolors))
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/phseiff/github-flavored-markdown-to-html/")
    (synopsis "Github-flavored Markdown")
    (description
     "This package provides a feature-rich Github-flavored Markdown to HTML
Python library and command line interface.")
    (license license:expat)))

(define-public python-glymur
  (package
    (name "python-glymur")
    (version "0.13.6")
    (source
     (origin
       (method git-fetch)   ; no tests data in PyPi package
       (uri (git-reference
             (url "https://github.com/quintusdias/glymur")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "06v6g0fwzmy2imhrvy0q4zrhrlrp24yhs098vi13r92ga63c72xl"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "--numprocesses" (number->string (parallel-job-count))
              ;; Failing test due to inability of ctypes.util.find_library()
              ;; to determine library path, which is patched above.
              "--ignore=tests/test_config.py")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-library-locations
            (lambda* (#:key inputs #:allow-other-keys)
              ;; XXX: It's a workaround for Python inability to find the
              ;; .so libraries with ctypes.util.find_library()
              (substitute* '("glymur/config.py")
                (("path = find_library\\(libname\\)")
                 (string-append
                  "if libname == \"openjp2\":\n"
                  "        path = \""
                  (search-input-file inputs "/lib/libopenjp2.so") "\"\n"
                  "    elif libname == \"tiff\":\n"
                  "        path = \""
                  (search-input-file inputs "/lib/libtiff.so") "\"\n"
                  "    elif libname == \"c\":\n"
                  "        path = \""
                  (search-input-file inputs "/lib/libc.so.6") "\"\n"))))))))
    (native-inputs
     (list python-pytest
           python-pytest-xdist
           python-scikit-image
           python-setuptools
           python-wheel))
    (inputs
     (list openjpeg  ; glymur/lib/openjp2.py
           libtiff)) ; glymur/lib/tiff.py
    (propagated-inputs
     (list python-lxml
           python-numpy
           python-packaging))
    (home-page "https://github.com/quintusdias/glymur")
    (synopsis "Python interface to OpenJPEG and LibTIFF")
    (description
     "This package provides Python interface to the OpenJPEG library which
allows one to read and write JPEG 2000 files")
    (license license:expat)))

(define-public python-gphoto2
  (package
    (name "python-gphoto2")
    (version "2.5.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "gphoto2" version))
              (sha256
               (base32
                "104yb4g427rqjkaw3i0w30x3sssvmpna802nabjclzq688y7ml4p"))))
    (build-system python-build-system)
    (native-inputs
     (list pkg-config))
    (inputs
     (list libgphoto2))
    (home-page "https://github.com/jim-easterbrook/python-gphoto2")
    (synopsis "Python interface to libgphoto2")
    (description "@code{python-gphoto2} is a comprehensive Python interface
(or binding) to @code{libgphoto2}.  It is built using @code{SWIG} to
automatically generate the interface code.")
    (license license:lgpl3+)))

(define-public python-colour
  (package
    (name "python-colour")
    (version "0.1.5")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "colour" version))
              (sha256
               (base32
                "1visbisfini5j14bdzgs95yssw6sm4pfzyq1n3lfvbyjxw7i485g"))))
    (build-system python-build-system)
    (native-inputs
     (list python-d2to1))
    (home-page "https://github.com/vaab/colour")
    (synopsis "Convert and manipulate various color representations")
    (description "Pythonic way to manipulate color representations (HSL, RVB,
web, X11, ...).")
    (license license:expat)))

(define-public python-d2to1
  (package
    (name "python-d2to1")
    (version "0.2.12.post1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "d2to1" version))
              (sha256
               (base32
                "09fq7pq1z8d006xh5z75rm2lk61v6yn2xhy53z4gsgibhqb2vvs9"))))
    (build-system python-build-system)
    (native-inputs
     (list python-nose))
    (home-page "https://github.com/embray/d2to1")
    (synopsis "Allows for distutils2-like setup.cfg files as package metadata
in python")
    (description "The python package d2to1 (the d is for distutils) allows
using distutils2-like setup.cfg files for a package's metadata with a
distribute/setuptools setup.py script.")
    (license license:bsd-2)))

(define-public python-rapidfuzz
  (package
    (name "python-rapidfuzz")
    (version "3.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "rapidfuzz" version))
       (sha256
        (base32 "1rrx043zqqql31pcp92k61digibymp3l382gaxr4h8717kp0nrim"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-packaging
           python-pytest
           python-scikit-build
           python-setuptools))
    (home-page "https://github.com/rapidfuzz/RapidFuzz")
    (synopsis "Rapid fuzzy string matching")
    (description "RapidFuzz is a fast string matching library for Python and
C++, which is using the string similarity calculations from FuzzyWuzzy.")
    (license license:expat)))

(define-public python-rawkit
  (package
    (name "python-rawkit")
    (version "0.6.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "rawkit" version))
              (sha256
               (base32
                "0vrhrpr70i61y5q5ysk341x1539ff1q1k82g59zq69lv16s0f76s"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest python-mock))
    (inputs
     (list libraw))
    (home-page "https://rawkit.readthedocs.io")
    (synopsis "Ctypes-based LibRaw binding for Python")
    (description "The rawkit package provides two modules:  rawkit and libraw.
The rawkit module provides a high-level Pythonic interface for developing raw
photos, while the libraw module provides a CTypes based interface for
interacting with the low-level LibRaw C APIs.")
    (license license:expat)))

(define-public python-easygui
  (package
    (name "python-easygui")
    (version "0.98.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "easygui" version))
              (sha256
               (base32
                "1zmvmwgxyzvm83818skhn8b4wrci4kmnixaax8q3ia5cn7xrmj6v"))))
    (build-system python-build-system)
    (propagated-inputs
     (list `(,python "tk")))
    (home-page "https://github.com/robertlugg/easygui")
    (synopsis "GUI programming module for Python")
    (description "EasyGUI is a module for very simple, very easy GUI
programming in Python.  EasyGUI is different from other GUI generators in that
EasyGUI is NOT event-driven.  Instead, all GUI interactions are invoked by
simple function calls.")
    (license license:bsd-3)))

(define-public python-echo
  (package
    (name "python-echo")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "echo" version))
       (sha256
        (base32 "1hr2kgjmf5gcjbg1mry03ca1dayfwy8mi8as42jfg0apsa3bfvvj"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'start-xorg-server
            (lambda _
              ;; The test suite requires a running X server.
              (system "Xvfb :99 -screen 0 1024x768x24 &")
              (setenv "DISPLAY" ":99.0"))))))
    (propagated-inputs
     (list python-numpy
           python-qtpy
           python-pyqt-6))
    (native-inputs
     (list python-pytest
           python-pytest-cov
           python-setuptools-scm
           xorg-server-for-tests))
    (home-page "https://github.com/glue-viz/echo")
    (synopsis "Callback Properties in Python")
    (description
     "Echo is a small library for attaching callback functions to property
state changes.")
    (license license:expat)))

(define-public python-pymd4c
  (package
    (name "python-pymd4c")
    (version "0.4.6.0b1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pymd4c" version))
       (sha256
        (base32 "07s3arn85ri92im6x3ipljdmrxmpik7irs06i6lm17j1x6j9841d"))))
    (build-system python-build-system)
    (inputs
     (list md4c))
    (native-inputs
     (list python-flake8 python-pkgconfig pkg-config))
    (home-page "https://github.com/dominickpastore/pymd4c")
    (synopsis "Python bindings for MD4C")
    (description
     "PyMD4C provides Python bindings for MD4c, a C Markdown parser, compliant
to CommonMark.")
    (license license:expat)))

(define-public python-pymediainfo
  (package
    (name "python-pymediainfo")
    (version "4.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pymediainfo" version))
       (sha256
        (base32
         "0mhpxs7vlqx8w75z93dy7nnvx89kwfdjkla03l19an15rlyqyspd"))))
    (build-system python-build-system)
    (native-inputs
     (list python-setuptools-scm python-pytest))
    (inputs
     (list libmediainfo))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-libmediainfo
           (lambda _
             (substitute* "pymediainfo/__init__.py"
               (("libmediainfo.so.0")
                (search-input-file %build-inputs
                                   "/lib/libmediainfo.so.0")))))
         (replace 'check
           (lambda* (#:key tests? inputs outputs #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               ;; Skip the only failing test "test_parse_url" because it tries
               ;; to access the internet.
               (invoke "pytest" "-vv" "-k" "not test_parse_url")))))))
    (home-page
     "https://github.com/sbraz/pymediainfo")
    (synopsis
     "Python wrapper for the mediainfo library")
    (description
     "This package provides a Python wrapper for the mediainfo library to
access the technical and tag data for video and audio files.")
    (license license:expat)))

(define-public python-psutil
  (package
    (name "python-psutil")
    (version "5.9.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "psutil" version))
       (sha256
        (base32 "0p1bf6ndcssqh0ic828ggwhzhm67mzj3ffq6043v0fvc1fhn3f7y"))))
    (build-system python-build-system)
    (arguments
     ;; FIXME: some tests do not return and time out.  Some tests fail because
     ;; some processes survive kill().
     '(#:tests? #f))
    (home-page "https://github.com/giampaolo/psutil")
    (synopsis "Library for retrieving information on running processes")
    (description
     "@code{psutil} (Python system and process utilities) is a library for
retrieving information on running processes and system utilization (CPU,
memory, disks, network) in Python.  It is useful mainly for system monitoring,
profiling and limiting process resources and management of running processes.
It implements many functionalities offered by command line tools such as: ps,
top, lsof, netstat, ifconfig, who, df, kill, free, nice, ionice, iostat,
iotop, uptime, pidof, tty, taskset, pmap.")
    (license license:bsd-3)))

(define-public python-scapy
  (package
    (name "python-scapy")
    (version "2.5.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "scapy" version))
              (sha256
               (base32
                "1hpbbmpcn4dwj3z7i7sz4cnbpkaf57p7mvl3p84x9n2gflmhq9jv"))))
    (arguments
     '(#:tests? #f)) ; There is a test directory, but apparently no
                     ; automatic testing framework.
    ;; The package has more optional dependencies such as ipython and
    ;; matplotlib. If functionality is missing, these should be added.
    ;; See
    ;; https://scapy.readthedocs.io/en/latest/installation.html#optional-dependencies
    (build-system python-build-system)
    (home-page "https://scapy.net")
    (synopsis "Python network packet crafting library")
    (description
     "Scapy is a Python library and executable for interactively
manipulating network packets.  It can forge or decode packets of a number
of protocols, send them on the wire, capture them, store or read them
using pcap files, match requests and replies, and so on.
It can handle tasks such as scanning, tracerouting, probing, unit tests,
attacks or network discovery.")
    (license license:gpl2)))

(define-public python-icmplib
  (package
    (name "python-icmplib")
    (version "3.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "icmplib" version))
       (sha256
        (base32 "1phnlgbb5di79ijm55pyd5jj1ggss4b6nn6mw701h501vcn8z1jp"))))
    (arguments
     '(#:tests? #f)) ;test data not present
    (build-system python-build-system)
    (home-page "https://github.com/ValentinBELYN/icmplib")
    (synopsis
     "Python implementation of the Internet Control Message Protocol (ICMP)")
    (description
     "@code{icmplib} is a supporting library for both IPv4 and IPv6 networks.
ICMP is typically used for diagnostic or control purposes - well known from
utilities such as ping(1).")
    (license license:lgpl3)))

(define-public python-iron-core
  (package
    (name "python-iron-core")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "iron-core" version))
       (sha256
        (base32 "158vdymq6nbym0v1f9l5gz42j1gsq09b9yw9hgd70m5ymy30n6dp"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-dateutil python-requests))
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://www.github.com/iron-io/iron_core_python")
    (synopsis "Universal classes and methods for Iron.io API wrappers")
    (description
     "This package provides universal classes and methods for the Iron.io API
wrappers to build on.")
    (license license:bsd-2)))

(define-public python-iron-mq
  (package
    (name "python-iron-mq")
    (version "0.9")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "iron-mq" version))
       (sha256
        (base32 "1ypc71xppidy5lx3mbfj1zc685na3jns441q6il8kh6rfbc42169"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-iron-core))
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/iron-io/iron_mq_python")
    (synopsis "Client library for IronMQ, a message queue in the cloud")
    (description
     "This package provides Python language bindings for IronMQ.  IronMQ is an
elastic message queue for managing data and event flow within cloud
applications and between systems.")
    (license license:bsd-2)))

(define-public python-rasterio
  (package
    (name "python-rasterio")
    (version "1.3.7")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "rasterio" version))
              (sha256
               (base32
                "012341c1rlcdr9rkg97lbhxrwzn4sr2xah4zjfnqy2r1227wpzdb"))))
    (properties
     '((updater-ignored-native-inputs . ("gdal" "python-cython"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #false                   ;test data not present
      #:phases
      '(modify-phases %standard-phases
         (add-before 'check 'build-extensions
           (lambda _
             ;; Cython extensions have to be built before running the tests.
             (invoke "python" "setup.py" "build_ext" "--inplace"))))))
    (propagated-inputs (list python-affine
                             python-attrs
                             python-certifi
                             python-click
                             python-click-plugins
                             python-cligj
                             python-numpy
                             python-setuptools ; For pkg_resources.
                             python-snuggs))
    (native-inputs (list gdal
                         python-boto3
                         python-cython
                         python-hypothesis
                         python-packaging
                         python-pytest
                         python-pytest-cov
                         python-shapely
                         python-wheel))
    (home-page "https://github.com/rasterio/rasterio")
    (synopsis "Fast and direct raster I/O for use with Numpy and SciPy")
    (description "This package implements fast and direct raster I/O for use
with Numpy and SciPy.")
    (license license:bsd-3)))

(define-public python-rich-tables
  (package
    (name "python-rich-tables")
    (version "0.6.1")
    (source
     (origin
       (method git-fetch)   ; no tests data in PyPi package
       (uri (git-reference
             (url "https://github.com/snejus/rich-tables")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1wqr6sldf97ycs4gfvsqhbh1ki2kgsaicsy44g9lspvlda5nfcp1"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-freezegun
           python-poetry-core
           python-pytest
           python-pytest-cov))
    (propagated-inputs
     (list python-funcy
           python-multimethod
           python-platformdirs
           python-rgbxy
           python-rich
           python-sqlparse))
    (home-page "https://github.com/snejus/rich-tables")
    (synopsis "Ready-made rich tables for various purposes")
    (description
     "This package implements rich tables for various purposes, it's JSON
human-prettifier based on the @code{rich} Python library.")
    (license license:expat)))

(define-public python-rich-toolkit
  (package
    (name "python-rich-toolkit")
    (version "0.12.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "rich_toolkit" version))
       (sha256
        (base32 "0h3cda068xc0v8jqcp7fyrb6d4xlhcjlxm5bfygk04408500pjzs"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-click python-rich python-typing-extensions))
    (native-inputs (list python-hatchling python-inline-snapshot python-pytest))
    (home-page "https://pypi.org/project/rich-toolkit/")
    (synopsis "Rich toolkit for building command-line applications")
    (description "This package provides the Rich toolkit for building
command-line applications.")
    (license license:expat)))

(define-public python-shapely
  (package
    (name "python-shapely")
    (version "2.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "shapely" version))
       (sha256
        (base32 "0cpyziixzdj7xqkya4k6fwr0qmrw8k84fsrx6p5sdgw6qxmkdwmz"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-before 'check 'build-extensions
           (lambda _
             ;; Cython extensions have to be built before running the tests.
             (invoke "python" "setup.py" "build_ext" "--inplace"))))))
    (native-inputs
     (list python-cython python-matplotlib python-pytest python-setuptools python-wheel))
    (inputs
     (list geos))
    (propagated-inputs
     (list python-numpy))
    (home-page "https://github.com/shapely/shapely")
    (synopsis "Library for the manipulation and analysis of geometric objects")
    (description "Shapely is a Python package for manipulation and analysis of
planar geometric objects.  It is based on the @code{GEOS} library.")
    (license license:bsd-3)))

(define-public python-shortuuid
  (package
    (name "python-shortuuid")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "shortuuid" version))
       (sha256
        (base32
         "1f8i4zwj5vmpzbz6b17bljy4399gx5aq7vsyw63sz2qgyjcd73yh"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pep8))
    (home-page "https://github.com/skorokithakis/shortuuid")
    (synopsis "Generator library for concise, unambiguous and URL-safe UUIDs")
    (description
     "@code{shortuuid} is a Python library for generating concise, unambiguous
and URL-safe UUIDs.  UUIDs are generated using the built-in Python @code{uuid}
module and then similar looking characters are removed.")
    (license license:bsd-3)))

(define-public python-logwrap
  (package
    (name "python-logwrap")
    (version "8.2.0.post0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "logwrap" version))
       (sha256
        (base32
         "1dv7gny3rfci5cal2ipr6d0pcz3yhka7af96dfsd3ir1mxy8p1j9"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f  ; Tests not included in pypi release.
       #:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest"))
             #t)))))
    (native-inputs
     (list python-cython python-pytest python-setuptools-scm python-toml
           python-wheel))
    (home-page "https://github.com/python-useful-helpers/logwrap")
    (synopsis "Decorator for logging function arguments")
    (description "This package provides a decorator to log function arguments
and function call return values in a human-readable way.")
    (license license:asl2.0)))

(define-public python-clyent
  (package
    (name "python-clyent")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "clyent" version))
       (sha256
        (base32
         "1r9987qmy1pz3hq54160bapqsywpq14waw4w9x3ly8hmq7kpgfbj"))))
    (build-system python-build-system)
    (native-inputs
     (list python-mock))
    (home-page "https://github.com/Anaconda-Platform/clyent")
    (synopsis "Command line client library")
    (description "Clyent is a Python command line utility library.  It is used
by @code{binstar}, @code{binstar-build}, and @code{chalmers}.")
    (license license:bsd-3)))

(define-public python-babel
  (package
    (name "python-babel")
    (version "2.16.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "babel" version))
       (sha256
        (base32 "05p3k0i5h8v4vqsg36s94kwl4nhgfmgwdq1x7wbzw1b6l965bwyi"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-freezegun
           python-pytest
           python-pytest-cov
           python-setuptools
           python-wheel
           tzdata-for-tests))
    (propagated-inputs
     (list python-pytz))
    (home-page "https://babel.pocoo.org/")
    (synopsis
     "Tools for internationalizing Python applications")
    (description
     "Babel is composed of two major parts:
- tools to build and work with gettext message catalogs
- a Python interface to the CLDR (Common Locale Data Repository), providing
access to various locale display names, localized number and date formatting,
etc.")
    (license license:bsd-3)))

(define-public python-bidict
  (package
    (name "python-bidict")
    (version "0.21.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "bidict" version))
       (sha256
        (base32
         "02dy0b1k7qlhn7ajyzkrvxhyhjj0hzcq6ws3zjml9hkdz5znz92g"))))
    (build-system python-build-system)
    (native-inputs
     (list python-coverage
           python-hypothesis
           python-py
           python-pytest
           python-pytest-benchmark
           python-pytest-cov
           python-setuptools-scm
           python-sortedcollections
           python-sortedcontainers
           python-sphinx
           python-sphinx-autodoc-typehints
           python-tox))
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (add-after 'unpack 'relax-reqs
                    (lambda _
                      (substitute* "setup.py"
                        (("sortedcollections < 2") "sortedcollections"))
                      #t))
                  (replace 'check
                    (lambda _ (invoke "./run_tests.py"))))))
    (home-page "https://bidict.readthedocs.io")
    (synopsis "Bidirectional mapping library")
    (description "The @code{bidict} library provides several data structures
for working with bidirectional mappings in Python.")
    (license license:mpl2.0)))

(define-public python-bip39
  (package
    (name "python-bip39")
    (version "0.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "bip39" version))
       (sha256
        (base32 "18m7d3gi7vj2zi0bl1z7m0nhcj6i8j9vj4vil276siagnpkv64ry"))))
    (build-system python-build-system)
    (native-inputs (list python-pytest))
    (home-page "https://github.com/de-centralized-systems/python-bip39/")
    (synopsis "Self-contained and simple BIP39 implementation in Python")
    (description
     "This package provides a self-contained and simple BIP39
implementation written in Python.  It includes a @code{bip39.py} executable.

BIP39 is a standardized mapping between binary data (the @emph{entropy}),
and a list of words that are easier to remember for humans (the
@emph{mnemonic}).")
    (license license:expat)))

(define-public python-bitarray
  (package
    (name "python-bitarray")
    (version "2.8.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "bitarray" version))
              (sha256
               (base32
                "1wy80bmhg33bpzn28g1n7s8r8f4drj7pcl4m2qb5sql8bbryx376"))))
    (build-system python-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (replace 'check
                 (lambda* (#:key tests? #:allow-other-keys)
                   (when tests?
                     ;; Step out of the source directory to avoid interference.
                     (with-directory-excursion "/tmp"
                       (invoke "python" "-c"
                               "import bitarray; bitarray.test()"))))))))
    (home-page "https://github.com/ilanschnell/bitarray")
    (synopsis "Efficient arrays of booleans")
    (description "This package provides an object type which efficiently
represents an array of booleans.  Bitarrays are sequence types and behave very
much like usual lists.  Eight bits are represented by one byte in a contiguous
block of memory.  The user can select between two representations:
little-endian and big-endian.  All of the functionality is implemented in C.
Methods for accessing the machine representation are provided.  This can be
useful when bit level access to binary files is required, such as portable
bitmap image files.  Also, when dealing with compressed data which uses
variable bit length encoding, you may find this module useful.")
    (license license:psfl)))

(define-public python-boolean.py
  (package
    (name "python-boolean.py")
    (version "4.0")
    (source
     (origin
       ;; There's no source tarball on PyPI.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/bastikr/boolean.py")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1s4mrgqf1phwvda81dpnlkdadcbjgpl8mjvmc1yjlrp1c368v9lb"))))
    (build-system python-build-system)
    (home-page "https://github.com/bastikr/boolean.py")
    (synopsis "Boolean algebra in one Python module")
    (description
     "This is a small Python library that implements boolean algebra.
It defines two base elements, @code{TRUE} and @code{FALSE}, and a
@code{Symbol} class that can take on one of these two values.  Calculations
are done only in terms of @code{AND}, @code{OR}, and @code{NOT}---other
compositions like @code{XOR} and @code{NAND} are emulated on top of them.
Expressions are constructed from parsed strings or directly in Python.")
    (license license:bsd-2)))

(define-public python-hdf4
  (package
   (name "python-hdf4")
   (version "0.9.2")
   (source
    (origin
      (method url-fetch)
      (uri (pypi-uri name version))
      (sha256
       (base32
        "00sxppysk3w620g1jdskjzkybvpf8dkpzjfj3wlw5khpzw1g0hq5"))))
   (build-system pyproject-build-system)
   (arguments
    (list
     #:phases
     '(modify-phases %standard-phases
        (add-before 'check 'build-extensions
          (lambda _
            ;; Extensions have to be built before running the tests.
            (invoke "python" "setup.py" "build_ext" "--inplace"))))))
   (native-inputs (list python-pytest python-setuptools python-wheel))
   (propagated-inputs (list python-numpy))
   (inputs
    (list hdf4 libjpeg-turbo zlib))
   (home-page "https://github.com/fhs/python-hdf4")
   (synopsis "Python interface to the NCSA HDF4 library")
   (description
    "Python-HDF4 is a python wrapper around the NCSA HDF version 4 library,
which implements the SD (Scientific Dataset), VS (Vdata) and V (Vgroup) API’s.
NetCDF files can also be read and modified.  Python-HDF4 is a fork of
@url{http://hdfeos.org/software/pyhdf.php,pyhdf}.")
   (license license:expat)))

(define-public python-h5netcdf
  (package
    (name "python-h5netcdf")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "h5netcdf" version))
       (sha256
        (base32 "1kw3cf01kziwxmb84x0cy6vbpsmqjm0k1dm34i6b4d7bv8kw0wd1"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-netcdf4
           python-pytest
           python-setuptools
           python-setuptools-scm
           python-wheel))
    (propagated-inputs
     (list python-h5py python-packaging))
    (home-page "https://h5netcdf.org")
    (synopsis "Python interface for the netCDF4 file-format based on h5py")
    (description "This package provides a Python interface for the netCDF4
file-format that reads and writes local or remote HDF5 files directly via
@url{h5py, https://www.h5py.org/} or @url{h5pyd,
https://github.com/HDFGroup/h5pyd}, without relying on the Unidata netCDF
library.")
    (license license:bsd-3)))

(define-public python-h5py
  (package
    (name "python-h5py")
    (version "3.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "h5py" version))
       (sha256
        (base32 "0pyr6z4h2xqbp49yx2i1401gl6yqh03h771zslwcy0201hpxiskg"))))
    (build-system python-build-system)
    (arguments
     '(#:phases (modify-phases %standard-phases
                  (add-after 'unpack 'fix-hdf5-paths
                    (lambda* (#:key inputs #:allow-other-keys)
                      (setenv "HDF5_DIR"
                              (assoc-ref inputs "hdf5")))))))
    (propagated-inputs (list python-six python-numpy))
    (inputs (list hdf5-1.10))
    (native-inputs (list pkg-config python-cython python-ipython
                         python-pkgconfig python-pytest))
    (home-page "https://www.h5py.org/")
    (synopsis "Read and write HDF5 files from Python")
    (description
     "The h5py package provides both a high- and low-level interface to the
HDF5 library from Python.  The low-level interface is intended to be a
complete wrapping of the HDF5 API, while the high-level component supports
access to HDF5 files, datasets and groups using established Python and NumPy
concepts.")
    (license license:bsd-3)))

(define-public python-hdf5storage
  (package
    (name "python-hdf5storage")
    (version "0.1.19")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "hdf5storage" version))
       (sha256
        (base32 "11pgxsqap9l7jsf52649q9mpj8a0w6p9im929lpr9s26ynnnn6ks"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-h5py python-numpy))
    (native-inputs (list python-nose python-setuptools python-wheel))
    (home-page "https://github.com/frejanordsiek/hdf5storage")
    (synopsis "Read and write Python data types from and to HDF5 files")
    (description
     "This Python package provides high-level utilities to read and write a
variety of Python types from and to @acronym{HDF5, Hierarchical Data Format}
formatted files.  This package also provides support for MATLAB MAT v7.3
formatted files, which are HDF5 files with a different extension and some
extra metadata.  Because HDF5 and MAT files might need to be read from
untrusted sources, pickling is avoided in this package.")
    (license license:bsd-2)))

(define-public python-hjson
  ;; Using commit from master branch as the PyPI version does not contain
  ;; the hjson/tests/ directory.
  (let ((revision "0")
        (commit "1687b811fcbbc54b5ac71cfbaa99f805e406fbcb"))
    (package
      (name "python-hjson")
      (version (git-version "3.1.0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                       (url "https://github.com/hjson/hjson-py")
                       (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1qfqnhvfx5mm7bdajjnnagmvns1zxyksjzh3k5la2ag6a8bp5gki"))))
      (build-system pyproject-build-system)
      (native-inputs (list python-setuptools python-wheel))
      (home-page "https://github.com/hjson/hjson-py")
      (synopsis "Python package to parse HJSON documents")
      (description "This package provides a Python library and a command-line
interface utility to parse @url{https://hjson.github.io/, HJSON}) documents.")
      (license license:expat))))

(define-public python-hnswlib
  (package
    (name "python-hnswlib")
    (version "0.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "hnswlib" version))
       (sha256
        (base32 "0wf1cwmxmdzfqmfhrkqdxb5spf21ylgl2bidswhzjrqhwf35c9qf"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'disable-native-optimization
           (lambda _
             (substitute* "setup.py"
               ((", '-march=native'") "")))))))
    (propagated-inputs
     (list python-numpy))
    (native-inputs
     (list pybind11))
    (home-page "https://github.com/nmslib/hnswlib")
    (synopsis "Fast approximate nearest neighbor search")
    (description "Hnswlib is a header-only C++ implementation of fast
approximate nearest neighbor search with Python bindings.")
    (license license:asl2.0)))

(define-public python-pylatexenc
  (package
    (name "python-pylatexenc")
    (version "2.10")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pylatexenc" version))
              (file-name (string-append name "-" version ".tar.gz"))
              (sha256
               (base32
                "1ls09z47b5md71gkxcj7fd87ynpvv2walgp2w6z31p26xf2gvn1x"))))
    (build-system python-build-system)
    (home-page "https://github.com/phfaist/pylatexenc")
    (synopsis "LaTeX parser for Unicode/LaTeX conversion")
    (description
     "@code{python-pylatexenc} is a LaTeX parser providing LaTeX-to-Unicode and
Unicode-to-LaTeX conversion.")
    (license license:expat)))

(define-public python-lsp-black
  (package
    (name "python-lsp-black")
    (version "2.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/python-lsp/python-lsp-black")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0ilh6nx15kzrp29nkrpx03vx6dw3n7wq65qwv7bg7kcnyiwacplx"))))
    (build-system pyproject-build-system)
    (arguments
     ;; The python version is too old for these tests to pass properly.
     (list #:test-flags
           `'("-k" ,(string-append
                     "not test_pylsp_format_document_syntax_error"
                     " and not test_pylsp_format_range_syntax_error"
                     " and not test_load_config_defaults"
                     " and not test_load_config_with_skip_options"))))
    (propagated-inputs
     (list python-black python-lsp-server python-tomli))
    (native-inputs
     (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/python-lsp/python-lsp-black")
    (synopsis "Black plugin for the Python LSP Server")
    (description "This package provides a plugin with support for the
@code{python-black} formatter for the Python LSP Server.")
    (license license:expat)))

(define-public python-pylsp-mypy
  (package
    (name "python-pylsp-mypy")
    (version "0.6.9")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pylsp_mypy" version))
       (sha256
        (base32 "1amvqzb5lhhw2011003mwm88chb8sz5aax1jrqc3jg0jpak992fj"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (propagated-inputs (list python-mypy python-lsp-server))
    (home-page "https://github.com/python-lsp/pylsp-mypy")
    (synopsis "Mypy linter for the Python LSP Server")
    (description
     "Mypy linter integration for use with @code{python-lsp-server}.")
    (license license:expat)))

(define-public python-sh
  (package
    (name "python-sh")
    (version "1.14.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "sh" version))
       (sha256
        (base32
         "03gyss1rhj4in7pgysg4q0hxp3230whinlpy1532ljs99lrx0ywx"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             ;; XXX: A Python 2 test fails when HOME=/homeless-shelter.
             (setenv "HOME" "/tmp")
             (invoke "python" "sh.py" "test"))))))
    (native-inputs
     (list python-coverage))
    (home-page "https://github.com/amoffat/sh")
    (synopsis "Python subprocess replacement")
    (description "This package provides a replacement for Python's
@code{subprocess} feature.")
    (license license:expat)))

(define-public python-cftime
  (package
    (name "python-cftime")
    (version "1.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "cftime" version))
       (sha256
        (base32 "1lp6jrjjgl18csn4bcnphn0l16ag4aynvn7x0kins155p07w0546"))))
    (build-system pyproject-build-system)
    (propagated-inputs
     (list python-numpy))
    (native-inputs
     (list python-check-manifest
           python-coverage
           python-coveralls
           python-cython
           python-pytest-cov
           python-sphinx
           python-twine
           python-wheel))
    (home-page "https://unidata.github.io/cftime/")
    (synopsis "Library for time handling")
    (description
     "This package provides time-handling functionality that used to be part
of the netcdf4 package before.")
    (license license:expat)))

(define-public python-netcdf4
  (package
    (name "python-netcdf4")
    (version "1.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "netCDF4" version))
       (sha256
        (base32
         "0qxs8r1qmsmg760wm5q0wqlcm7hdd3k7cghryw6wvqd3v5rs7vwm"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'configure-locations
           (lambda* (#:key inputs #:allow-other-keys)
             (setenv "HDF5_DIR" (assoc-ref inputs "hdf5"))
             #t)))))
    (native-inputs
     (list python-cython))
    (propagated-inputs
     (list python-numpy python-cftime))
    (inputs
     (list netcdf hdf4 hdf5))
    (home-page "https://github.com/Unidata/netcdf4-python")
    (synopsis "Python/numpy interface to the netCDF library")
    (description "Netcdf4-python is a Python interface to the netCDF C
library.  netCDF version 4 has many features not found in earlier
versions of the library and is implemented on top of HDF5.  This module
can read and write files in both the new netCDF 4 and the old netCDF 3
format, and can create files that are readable by HDF5 clients.  The
API is modelled after @code{Scientific.IO.NetCDF}, and should be familiar
to users of that module.")
    ;; The software is mainly ISC, but includes some files covered
    ;; by the Expat license.
    (license (list license:isc license:expat))))

(define-public python-ncclient
  (package
    (name "python-ncclient")
    (version "0.6.12")
    (source
     (origin
       (method git-fetch)               ;no tests in PyPI release
       (uri (git-reference
             (url "https://github.com/ncclient/ncclient")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0cb568z5syg6hh0dv813bw7s1mjy7ga5xzxbm9naf4zz2qfdg4js"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (when tests?
                        (invoke "pytest")))))))
    (native-inputs
     (list python-pytest))
    (propagated-inputs
     (list python-lxml python-paramiko))
    (home-page "https://github.com/ncclient/ncclient")
    (synopsis "Python library for NETCONF clients")
    (description "@code{ncclient} is a Python library that facilitates
client-side scripting and application development around the NETCONF
protocol.")
    (license license:asl2.0)))

(define-public python-ncls
  (package
    (name "python-ncls")
    (version "0.0.65")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "ncls" version))
              (sha256
               (base32
                "1wx06xqknd2r98w8z93f47g5dpxzn92kamhj8vkq0nj569hf7cg1"))))
    (build-system python-build-system)
    (propagated-inputs (list python-numpy))
    (home-page "https://github.com/endrebak/ncls")
    (synopsis "Nested containment list data structure")
    (description
     "This package provides a wrapper for the nested containment list data
structure.  It is a static interval-tree that is fast for both construction
and lookups.")
    (license license:bsd-3)))

(define-public python-license-expression
  (package
    (name "python-license-expression")
    (version "30.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "license-expression" version))
       (sha256
        (base32 "0lvshl2fhwa568d3y3vmx45hdp8gk5w9yl3b2q5d66r5vqn1sfwl"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-setuptools-scm python-pytest python-setuptools python-wheel))
    (propagated-inputs
     (list python-boolean.py))
    (home-page "https://github.com/nexB/license-expression")
    (synopsis "Apply boolean logic to license expressions")
    (description
     "This Python module defines a tiny language to evaluate and compare
license expressions using boolean logic.  Logical combinations of licenses can
be tested for equality, containment, and equivalence.  They can be normalised
and simplified.  It supports SPDX license expressions as well as other naming
conventions and aliases in the same expression.")
    (license license:gpl2+)))

(define-public python-limits
  (package
    (name "python-limits")
    (version "4.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "limits" version))
       (sha256
        (base32 "0nkdwkvn2rs5swnd4ihv6yg6b5124apqzrrymqcm75pwil2mqkx5"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-deprecated python-packaging
                             python-typing-extensions))
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://limits.readthedocs.io/")
    (synopsis "Rate limiting utilities")
    (description "This package provides a Python library to perform rate
limiting with commonly used storage backends.")
    (license license:expat)))

(define-public python-wand
  (package
    (name "python-wand")
    (version "0.6.13")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "Wand" version))
       (sha256
        (base32 "1jpwm956vm35hmgjndr2jwrcql0bwvpsl88q5nr0x8ppxa2380gm"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; These two tests fail even though the signatures are identical.
      '(list "-k" "not fourier_transform")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'hardcode-lib-path
            (lambda _
              (substitute* "wand/api.py"
                (("os\\.environ\\.get\\('MAGICK_HOME'\\)")
                 (string-append "\"" #$(this-package-input "imagemagick") "\""))
                (("os\\.environ\\.get\\('WAND_MAGICK_LIBRARY_SUFFIX'\\)")
                 "\".Q16\"")))))))
    (native-inputs
     (list python-setuptools python-pytest python-wheel))
    (inputs
     (list imagemagick))
    (home-page "https://docs.wand-py.org/")
    (synopsis "MagickWand API binding for Python")
    (description
     "Wand is a ctypes-based binding for ImageMagick's MagickWand library.")
    (license license:expat)))

(define-public python-lockfile
  (package
    (name "python-lockfile")
    (version "0.12.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "lockfile" version))
       (sha256
        (base32
         "16gpx5hm73ah5n1079ng0vy381hl802v606npkx4x8nb0gg05vba"))))
    (build-system python-build-system)
    (arguments '(#:test-target "check"))
    (native-inputs
     (list python-pbr))
    (home-page "https://launchpad.net/pylockfile")
    (synopsis "Platform-independent file locking module")
    (description
     "The lockfile package exports a LockFile class which provides a simple
API for locking files.")
    (license license:expat)))

(define-public python-fb-re2
  (package
    (name "python-fb-re2")
    (version "1.0.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/facebook/pyre2")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0snprxdnh3m45r3b0az4v0l28h90ycmfbybzla6xg1qviwv9w1ak"))))
    (build-system python-build-system)
    (inputs
     (list re2))
    (home-page "https://github.com/facebook/pyre2")
    (synopsis "Python wrapper for RE2")
    (description "This package provides a Python extension that wraps Google's
RE2 regular expression library.  It implements many of the features of
Python's built-in @code{re} module with compatible interfaces.")
    (license license:bsd-3)))

(define-public python-filelock
  (package
    (name "python-filelock")
    (version "3.16.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "filelock" version))
       (sha256
        (base32
         "0d8ljvmsfgriiqf5dqii91gfcpj7cpjrh8fnsvifaiyvspygnjf2"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; Break cycle with virtualenv.
      #:test-flags #~(list "--ignore=tests/test_virtualenv.py")))
    (native-inputs
     (list python-hatch-vcs
           python-hatchling
           python-pytest
           python-pytest-asyncio
           python-pytest-mock
           python-setuptools-scm))
    (home-page "https://github.com/tox-dev/py-filelock")
    (synopsis "Platform independent file lock")
    (description "@code{filelock} contains a single module implementing
a platform independent file lock in Python, which provides a simple way of
inter-process communication.")
    (license license:unlicense)))

(define-public python-seedir
  (package
    (name "python-seedir")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "seedir" version))
       (sha256
        (base32 "1ibgzji9ijm37vgwmg37s2hsqmpqd793z4q41w816x5m6nahzy76"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-natsort))
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/earnestt1234/seedir")
    (synopsis
     "Package for creating, editing, and reading folder tree diagrams.")
    (description
     "This is a package for creating, editing, and reading folder tree
diagrams.")
    (license license:expat)))

(define-public python-semantic-version
  (package
    (name "python-semantic-version")
    (version "2.8.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "semantic_version" version))
       (sha256
        (base32
         "0m4avx8zdkzc7qglv5zlr54g8yna5vl098drg5396ql7aph2vjyj"))))
    (build-system python-build-system)
    (home-page "https://github.com/rbarrois/python-semanticversion")
    (synopsis "Semantic versioning module for Python")
    (description
     "The @code{semantic_version} class is a small library for handling
@uref{https://semver.org/, semantic versioning} (@dfn{SemVer}) in Python.

It can compare versions, generate a new version that represents a bump in one of
the version levels, and check whether any given string is a proper semantic
version identifier.")
    (license license:bsd-3)))

(define-public python-serpent
  (package
    (name "python-serpent")
    (version "1.28")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "serpent" version))
       (sha256
        (base32 "1arnckykpkvv2qrp49l1k7q5mr5pisswl0rvdx98x8wsl1n361pk"))))
    (build-system python-build-system)
    (native-inputs
     (list python-attrs python-pytz))
    (home-page "https://github.com/irmen/Serpent")
    (synopsis "Serializer for literal Python expressions")
    (description
     "Serpent provides @code{ast.literal_eval()}-compatible object tree
serialization.  It serializes an object tree into bytes (an utf-8 encoded
string) that can be decoded and then passed as-is to @code{ast.literal_eval()}
to rebuild the original object tree.

Because only safe literals are encoded, it is safe to send serpent data to
other machines, such as over the network.")
    (license license:expat)))

(define-public python-setuptools-declarative-requirements
  (package
    (name "python-setuptools-declarative-requirements")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri
             "setuptools-declarative-requirements"
             version))
       (sha256
        (base32
         "1l8zmcnp9h8sp8hsw7b81djaa1a9yig0y7i4phh5pihqz1gdn7yi"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest python-setuptools-scm))
    (propagated-inputs
     (list python-toml python-wheel))
    (home-page
     "https://github.com/s0undt3ch/setuptools-declarative-requirements")
    (synopsis "File support for setuptools declarative setup.cfg")
    (description
     "This package provides file support for setuptools declarative
@code{setup.cfg}.")
    (license license:asl2.0)))

;; The setuptools provided by Python 3.9 is too new for Tensorflow.
(define-public python-setuptools-for-tensorflow
  (hidden-package
   (package
     (inherit python-setuptools)
     (version "39.1.0")
     (source (origin
               (inherit (package-source python-setuptools))
               (uri (pypi-uri "setuptools" version ".zip"))
               (sha256
                (base32
                 "1mzdhvfhnv4lggxa8rjl0dzqxvfx377gg5sqs57v89wrp09lwj65"))))
     (arguments
      `(#:tests? #f                     ; tests require vendored resources
        #:phases
        (modify-phases %standard-phases
          (add-after 'unpack 'compatibility-fixes
            (lambda _
              ;; Python 3.9 no longer has HTMLParser
              (substitute* "setuptools/py33compat.py"
                (("html_parser.HTMLParser\\(\\).unescape")
                 "html.unescape"))
              ;; collections classes have moved in Python 3.10
              (substitute* "pkg_resources/_vendor/pyparsing.py"
                (("collections.MutableMapping")
                 "collections.abc.MutableMapping")
                (("collections.Iterable")
                 "collections.abc.Iterable"))
              ;; This needs distutils.msvc9compiler
              (delete-file "setuptools/tests/test_msvc.py")
              ;; See https://github.com/pypa/setuptools/issues/2558
              (delete-file "setuptools/command/bdist_wininst.py")
              (substitute* "setuptools/command/install_scripts.py"
                (("bw_cmd =.*") "\n")
                (("is_wininst =.*")
                 "is_wininst = False\n")))))))
     (native-inputs
      (list python-pytest python-mock python-six)))))

(define-public python-uniseg
  (package
    (name "python-uniseg")
    (version "0.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "uniseg" version ".zip"))
       (sha256
        (base32
         "05jsazvz6nbmh6l3v1rph5ydkqn1hzx1pyggdyvgp2qgmgrnmiz2"))))
    (build-system python-build-system)
    (arguments
     '(#:tests? #f)) ; The test suite requires network access.
    (native-inputs
     (list unzip))
    (home-page
     "https://bitbucket.org/emptypage/uniseg-python")
    (synopsis
     "Python library to determine Unicode text segmentations")
    (description
     "Uniseg is a Python package used to determine Unicode text segmentations.
Supported segmentations include:
@enumerate
@item @dfn{Code point} (any value in the Unicode codespace)
@item @dfn{Grapheme cluster} (user-perceived character made of a single or
multiple Unicode code points, e.g. \"G\" + acute-accent)
@item Word break
@item Sentence break
@item Line break
@end enumerate")
    (license license:expat)))

(define-public python-humanfriendly
  (package
    (name "python-humanfriendly")
    (version "8.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "humanfriendly" version))
       (sha256
        (base32
         "04ixg8b7p6xc8x8lffhi7wfl77xhszakhd0s6j0cf6a84j8yqlmz"))))
    (build-system python-build-system)
    (arguments
     `(;; XXX: Tests depend on coloredlogs, which in turn depends on humanfriendly.
       #:tests? #f))
    (home-page "https://humanfriendly.readthedocs.io")
    (synopsis "Human-friendly input and output in Python")
    (description
     "The functions and classes in @code{humanfriendly} can be used to make
text interfaces more user-friendly.  It includes tools to parse and format
numbers, file sizes, and timespans, timers for long-running operations, menus
to allow the user to choose from a list of options, and terminal interaction
helpers.")
    (license license:expat)))

(define-public python-textparser
  (package
    (name "python-textparser")
    (version "0.23.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "textparser" version))
       (sha256
        (base32
         "0w5lyhrsvzs5a9q1l3sjgxgljrvd3ybf796w93kc39wayzvd02gh"))))
    (build-system python-build-system)
    (home-page "https://github.com/eerimoq/textparser")
    (synopsis "Fast text parser for Python")
    (description "This library provides a text parser written in the Python
language.  It aims to be fast.")
    (license license:expat)))

(define-public python-aenum
  (package
    (name "python-aenum")
    (version "3.1.12")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "aenum" version))
       (sha256
        (base32 "1w1ffkcxgnimi5w8802qk6w2qxz9k8hpvsg6yy2zi08ahs8iqlry"))
       (modules '((guix build utils)))
       (snippet
        ;; Delete the Python 2 specific files which won't compile
        ;; in Python 3.
        '(for-each delete-file (find-files "." "_py2.py$")))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda _
                      ;; We must run the test suite module directly, as it
                      ;; fails to define the 'tempdir' variable in scope for
                      ;; the tests otherwise
                      ;; (see:https://bitbucket.org/stoneleaf/aenum/\
                      ;; issues/32/running-tests-with-python-setuppy-test).
                      (invoke "python3" "aenum/test.py")
                      ;; This one fails with "NameError: name
                      ;; 'test_pickle_dump_load' is not defined" (see:
                      ;; https://bitbucket.org/stoneleaf/aenum/issues/33
                      ;; /error-running-the-test_v3py-test-suite).
                      ;; (invoke "python3" "aenum/test_v3.py")
                      #t)))))
    (home-page "https://bitbucket.org/stoneleaf/aenum")
    (synopsis "Advanced enumerations, namedtuples and constants for Python")
    (description "The aenum library includes an @code{Enum} base class, a
metaclass-based @code{NamedTuple} implementation and a @code{NamedConstant}
class.")
    (license license:bsd-3)))

(define-public python-calver
  (package
    (name "python-calver")
    (version "2022.06.26")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/di/calver")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "14l9kv9igcmp5k6d2ahnx6z4dn6zy5kykz95hkh0rkqswn8x79b1"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pretend
           python-pytest
           python-setuptools
           python-wheel))
    (home-page "https://github.com/di/calver")
    (synopsis "Setuptools extension for CalVer package versions")
    (description
     "The calver package is a setuptools extension for automatically defining
your Python package version as a calendar version.")
    (license license:asl2.0)))

(define-public python-can
  (package
    (name "python-can")
    (version "4.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "python-can" version))
       (sha256
        (base32
         "1w5sdzxivpd3pw4pypwnjlksvfimdb93qnlddbrh5f13flhsgg8g"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list
         ;; TODO: Check if it could be packed:
         ;; https://github.com/projectgus/python-canalystii
         ;;
         ;; Disable tests which require specific CAN drivers we have no
         ;; package for in Guix.
         "--ignore" "test/test_interface_canalystii.py"
         ;; These tests fail with "OSError: [Errno 19] No such device".
         "-k" "not BasicTestUdpMulticastBusIPv")))
    (propagated-inputs
     (list python-msgpack python-typing-extensions python-wrapt
           python-setuptools))
    (native-inputs
     (list ;; python-canalystii ; Not packed yet
           python-codecov
           python-coverage
           python-future
           python-hypothesis
           python-mock
           python-parameterized
           python-pyserial
           python-pytest
           python-pytest-cov
           python-pytest-runner
           python-pytest-timeout
           python-wheel))
    (home-page "https://github.com/hardbyte/python-can")
    (synopsis "Controller Area Network (CAN) interface module for Python")
    (description "This package defines the @code{can} module, which provides
controller area network (CAN) support for Python developers; providing common
abstractions to different hardware devices, and a suite of utilities for
sending and receiving messages on a CAN bus.")
    (license license:lgpl3+)))

(define-public python-canmatrix
  (package
    (name "python-canmatrix")
    (version "1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "canmatrix" version))
       (sha256
        (base32 "046dzmggfm6h0fvfvwrblvih0blhc70ma0pqxzry3cphc08jvsrg"))
       ;; The test suite uder ./test is a legacy test suite. The new test
       ;; suite is defined under src/canmatrix/tests.
       (modules '((guix build utils)))
       (snippet '(delete-file-recursively "test"))))
    (build-system python-build-system)
    (arguments
     '(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (when tests?
                        (invoke "pytest")))))))
    (propagated-inputs (list python-attrs python-click python-future
                             python-six))
    (native-inputs (list python-lxml python-pytest python-xlrd python-xlwt))
    (home-page "https://github.com/ebroecker/canmatrix")
    (synopsis "@acronym{CAN, Controller Area Network} matrices in Python")
    (description
     "This package implements a @acronym{CAN, Controller Area Network} matrix
object in Python which describes the CAN-communication and its needed objects
such as board units, frames, signals, and values.  It also includes two
command-line tools (@command{canconvert} and @command{cancompare}) for
converting and comparing CAN databases.")
    (license license:bsd-2)))

(define-public python-canopen
  (package
    (name "python-canopen")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "canopen" version))
       (sha256
        (base32 "1nb543wb37kj95v6bhh272lm5gkpi41q3pnsl1fxlyizm2gamj5w"))))
    (build-system python-build-system)
    (native-inputs (list python-packaging))
    (propagated-inputs (list python-can))
    (home-page "https://github.com/christiansandberg/canopen")
    (synopsis "CANopen stack implementation")
    (description
     "This package provides a Python implementation of the
@uref{https://www.can-cia.org/canopen/,CANopen standard} for
@acronym{CANs, controller-area networks}.  The aim of the project is to
support the most common parts of the CiA 301 standard in a simple
Pythonic interface.  It is mainly targeted for testing and automation
tasks rather than a standard compliant master implementation.")
    (license license:expat)))

(define-public python-caniusepython3
  (package
    (name "python-caniusepython3")
    (version "7.2.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "caniusepython3" version))
        (sha256
          (base32
            "0a755444ln38j8d7xb3yw0wzpd0mjrzfn6zqvsh06nw1vdaq4l28"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (add-after 'unpack 'relax-requirements
                    (lambda _
                      (substitute* "setup.py"
                        ;; These are for compatibility with Python 2.
                        ((".*'argparse', 'backports.functools_lru_cache',.*")
                         ""))
                      (substitute* "dev_requirements.txt"
                        ((".*pylint.*") "")) ;not actually required
                      #t))
                  (replace 'check
                    (lambda _
                      (invoke "py.test" "-k" "not NetworkTests"))))))
    (propagated-inputs
      (list python-distlib python-packaging python-requests))
    (native-inputs
     (list python-mock python-pytest))
    (home-page "https://github.com/brettcannon/caniusepython3")
    (synopsis "Check for Python 3-incompatible Python libraries")
    (description "The @command{caniusepython3} command scans your project and
reports the Python 3-incompatible libraries it found.  It can also be used as
a library.")
    (license license:asl2.0)))

(define-public python-diskcache
  (package
    (name "python-diskcache")
    (version "4.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "diskcache" version))
       (sha256
        (base32
         "1q2wz5sj16zgyy1zpq516qgbnfwsavk1pl2qks0f4r62z5cmmvmw"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))                   ;test suite not included in the release
    (home-page "https://www.grantjenks.com/docs/diskcache/")
    (synopsis "Disk and file backed cache library")
    (description "DiskCache is a disk and file backed persistent cache.")
    (license license:asl2.0)))

(define-public python-optparse-pretty
  (package
    (name "python-optparse-pretty")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "optparse-pretty" version))
       (sha256
        (base32 "1920wbh2b7a8qn7zx2iiqbcdaax335l81a73x9pp8h11yzs2jdmh"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #false))  ;There are none
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/gvalkov/optparse-pretty")
    (synopsis "Compact help formatter for optparse")
    (description
     "This module provides two help formatters for optparse.  They provide
terser and more customizable option formatting in comparison to the default
help formatter.")
    (license license:bsd-3)))

(define-public python-orjson
  (package
    (name "python-orjson")
    (version "3.9.7")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "orjson" version))
              (sha256
               (base32
                "0hh1j7akxgx1nvsnwx1p4f4h4pkgr7v9aqr99l2pwbwfyyc93qw5"))))
    (build-system cargo-build-system)
    (arguments
     (list
      #:imported-modules `(,@%cargo-build-system-modules
                           ,@%pyproject-build-system-modules)
      #:modules '((guix build cargo-build-system)
                  ((guix build pyproject-build-system) #:prefix py:)
                  (guix build utils))
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'build 'build-python-module
            (assoc-ref py:%standard-phases 'build))
          (add-after 'build-python-module 'install-python-module
            (assoc-ref py:%standard-phases 'install)))
      #:cargo-inputs
      `(("rust-ahash" ,rust-ahash-0.8)
        ("rust-arrayvec" ,rust-arrayvec-0.7)
        ("rust-associative-cache" ,rust-associative-cache-1)
        ("rust-beef" ,rust-beef-0.5)
        ("rust-bytecount" ,rust-bytecount-0.6)
        ("rust-chrono" ,rust-chrono-0.4)
        ("rust-compact-str" ,rust-compact-str-0.7)
        ("rust-encoding-rs" ,rust-encoding-rs-0.8)
        ("rust-itoa" ,rust-itoa-1)
        ("rust-itoap" ,rust-itoap-1)
        ("rust-once-cell" ,rust-once-cell-1)
        ("rust-pyo3-ffi" ,rust-pyo3-ffi-0.19)
        ("rust-ryu" ,rust-ryu-1)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-simdutf8" ,rust-simdutf8-0.1)
        ("rust-smallvec" ,rust-smallvec-1)
        ("rust-cc" ,rust-cc-1)
        ("rust-pyo3-build-config" ,rust-pyo3-build-config-0.19)
        ("rust-version-check" ,rust-version-check-0.9))
      #:install-source? #false))
    (inputs
     (list maturin))
    (native-inputs
     (list python-wrapper))
    (home-page "https://github.com/ijl/orjson")
    (synopsis "Python JSON library supporting dataclasses, datetimes, and numpy")
    (description "Orjson is a fast, correct JSON library for Python.  It
benchmarks as the fastest Python library for JSON and is more correct than the
standard @code{json} library or other third-party libraries.  It serializes
dataclass, datetime, numpy, and UUID instances natively.")
    ;; Either of these licenses
    (license (list license:asl2.0 license:expat))))

(define-public python-overrides
  (package
    (name "python-overrides")
    (version "7.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "overrides" version))
       (sha256
        (base32 "02l2j5pnsxn0q5i63is5g6i3q06ri83nf7lv55swr61vv6iqy5am"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/mkorpela/overrides")
    (synopsis "Decorator to detect mismatch when overriding a method")
    (description
     "This package provides a decorator to automatically detect mismatch when
overriding a method.")
    (license license:asl2.0)))

(define-public python-argparse-addons
  (package
    (name "python-argparse-addons")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "argparse_addons" version))
       (sha256
        (base32 "1yx54dmnr3xggjcjk6bbdafvzp6cynrakl56wyz3jglmfvk0znpm"))))
    (build-system python-build-system)
    (home-page "https://github.com/eerimoq/argparse_addons")
    (synopsis "Extensions for Python's @code{argparse} library")
    (description "This Python library provides additional types and actions
for the standard @code{argparse} library.")
    (license license:expat)))

(define-public python-bitstruct
  (package
    (name "python-bitstruct")
    (version "8.14.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "bitstruct" version))
       (sha256
        (base32
         "149c73yrqbph71bbyf925r2mbh2jdymqxc6d49lnylpiflf1j313"))))
    (build-system python-build-system)
    (home-page "https://github.com/eerimoq/bitstruct")
    (synopsis "Python values to and C bit field structs converter")
    (description "This module performs conversions between Python values and C
bit field structs represented as Python byte strings.  It is intended to have
a similar interface as the @code{struct} module from Python, but working on
bits instead of primitive data types like @code{char}, @code{int}, etc.")
    (license license:expat)))

(define-public python-cantools
  (package
    (name "python-cantools")
    (version "37.0.7")
    (source
     (origin
       ;; We take the sources from the Git repository as the documentation is
       ;; not included with the PyPI archive.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/eerimoq/cantools")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1qcf1fcwif7w70qmhxw2b8kqh420igbinq60p1chzf98xcb0ansx"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'build 'build-doc
            (lambda _
              ;; See: https://github.com/eerimoq/cantools/issues/190.
              (substitute* "README.rst"
                (("https://github.com/eerimoq/cantools/raw/master\
/docs/monitor.png")
                 "monitor.png"))
              (invoke "make" "-C" "docs" "man" "info")))
          (add-after 'install 'install-doc
            (lambda* (#:key outputs #:allow-other-keys)
              (let* ((info (string-append #$output "/share/info"))
                     (man1 (string-append #$output "/share/man/man1")))
                (install-file "docs/_build/texinfo/cantools.info" info)
                (install-file "docs/_build/man/cantools.1" man1)))))))
    (native-inputs (list python-sphinx texinfo))
    (propagated-inputs
     (list python-argparse-addons
           python-bitstruct
           python-can
           python-crccheck
           python-diskcache
           python-matplotlib
           python-parameterized
           python-textparser))
    (home-page "https://github.com/eerimoq/cantools")
    (synopsis "Tools for the Controller Area Network (CAN) bus protocol")
    (description "This package includes Controller Area Network (CAN) related
tools that can be used to:
@itemize
@item parse DBC, KCD, SYM, ARXML 4 and CDD files
@item encode and decode CAN messages
@item multiplex simple and extended signals
@item diagnose DID encoding and decoding
@item dump the CAN decoder output
@item test CAN nodes
@item generate C source code
@item monitor the CAN bus
@end itemize")
    (license license:expat)))

(define-public python-capturer
  (package
    (name "python-capturer")
    (version "2.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "capturer" version))
       (sha256
        (base32
         "05d6ji4j8ipiq0br7bwam38qc6hd9l1djmfxlzrxx19ziyjl4089"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))
    (propagated-inputs
     (list python-humanfriendly))
    (home-page "https://capturer.readthedocs.io")
    (synopsis "Capture stdout and stderr streams of the current process")
    (description
     "The capturer package makes it easy to capture the stdout and stderr
streams of the current process and subprocesses.  Output can be relayed
to the terminal in real time but is also available to the Python program
for additional processing.")
    (license license:expat)))

(define-public python-fastprogress
  (package
    (name "python-fastprogress")
    (version "1.0.3")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/fastai/fastprogress")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "01h8f786wgmmd3fj98wk1n5id67nsp19gs8bbgims04aciwhvj21"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f                  ;there are no tests
           #:phases #~(modify-phases %standard-phases
                        ;; XXX: Fails with: "In procedure utime: No such file
                        ;; or directory".
                        (delete 'ensure-no-mtimes-pre-1980))))
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/fastai/fastprogress")
    (synopsis "Progress bar for Jupyter Notebook and console")
    (description
     "Fastprogress is a progress bar for Jupyter Notebook and console.")
    (license license:asl2.0)))

(define-public python-case
  (package
    (name "python-case")
    (version "1.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "case" version))
       (sha256
        (base32
         "1cagg06vfph864s6l5jb0zqliwxh647bki8j6lf4a4qrv40jnhs8"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-mock python-nose python-six))
    (native-inputs
     (list python-coverage))
    (home-page "https://github.com/celery/case")
    (synopsis "Unittest utilities and convenience methods")
    (description
     "The @code{case} package provides utilities on top of unittest, including
some helpful Python 2 compatibility convenience methods.")
    (license license:bsd-3)))

(define-public python-verboselogs
  (package
    (name "python-verboselogs")
    (version "1.7")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "verboselogs" version))
       (sha256
        (base32
         "09z4d1jiasn7k1hs5af2ckmnrd0i1d1m04bhfjhv7z6svzfdwgg3"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             ;; Do not run pylint plugin test, as astroid is an old
             ;; unsupported version.
             (invoke "pytest" "-v" "-k" "not test_pylint_plugin"
                     "verboselogs/tests.py"))))))
    (native-inputs
     (list python-mock python-pytest))
    (home-page "https://verboselogs.readthedocs.io")
    (synopsis "Verbose logging level for Python's logging module")
    (description
     "The @code{verboselogs} package extends Python's @code{logging} module to
add the log levels NOTICE, SPAM, SUCCESS and VERBOSE.")
    (license license:expat)))

(define-public python-coloredlogs
  (package
    (name "python-coloredlogs")
    (version "10.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "coloredlogs" version))
       (sha256
        (base32
         "0dkw6xp0r1dwgz4s2f58npx5nxfq51wf4l6qkm5ib27slgfs4sdq"))))
    (build-system python-build-system)
    (arguments
     `(;Tests require some updated modules
       #:tests? #f))
    (propagated-inputs
     (list python-capturer))
    (home-page "https://coloredlogs.readthedocs.io")
    (synopsis "Colored stream handler for Python's logging module")
    (description
     "The @code{coloredlogs} package enables colored terminal output for
Python's logging module.  The @code{ColoredFormatter} class inherits from
@code{logging.Formatter} and uses ANSI escape sequences to render your logging
messages in color.")
    (license license:expat)))

(define-public python-editorconfig
  (package
    (name "python-editorconfig")
    (version "0.12.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "EditorConfig" version))
       (sha256
        (base32
         "0v55z351p9qkyp3bbspwywwn28sbcknhirngjbj779n3z52z63hv"))))
    (build-system python-build-system)
    (home-page "https://editorconfig.org/")
    (synopsis "EditorConfig bindings for python")
    (description "The EditorConfig project consists of a file format for
defining coding styles and a collection of text editor plugins that enable
editors to read the file format and adhere to defined styles.  EditorConfig
files are easily readable and they work nicely with version control systems.")
    ;; "fnmatch.py" and "ini.py" are licensed under psfl, the rest is bsd-2.
    (license (list license:bsd-2 license:psfl))))

(define-public dosage
  (package
    (name "dosage")
    (version "2.17")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "dosage" version))
       (sha256
        (base32
         "0vmxgn9wd3j80hp4gr5iq06jrl4gryz5zgfdd2ah30d12sfcfig0"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-cached-property
           python-colorama
           python-imagesize
           python-importlib-metadata
           python-lxml
           python-requests
           python-six))
    (native-inputs
     (list python-pytest-cov python-pytest-xdist python-responses
           python-setuptools-scm))
    (home-page "https://github.com/webcomics/dosage")
    (synopsis "Comic strip downloader and archiver")
    (description "Dosage is designed to keep a local copy of specific webcomics and other
picture-based content such as Picture of the Day sites.  With the @command{dosage}
command-line script you can get the latest strip of a webcomic, catch-up to the last strip
downloaded, or download a strip for a particular date or index, if possible.")
    (license license:expat)))

(define-public python-et-xmlfile
  (package
    (name "python-et-xmlfile")
    (version "1.1")
    (source
     (origin
       ;; Use a checkout because the PyPI archive does not contain tests.
       (method hg-fetch)
       (uri (hg-reference
             (url "https://foss.heptapod.net/openpyxl/et_xmlfile")
             (changeset version)))
       (file-name (string-append name "-" version "-checkout"))
       (sha256
        (base32 "09r8rjc5bhkqrm5c4n9jrlvad8vrvbyswl9g0wrc1qc7nzh9mpw7"))))
    (build-system python-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (replace 'check
                 (lambda* (#:key tests? #:allow-other-keys)
                   (when tests?
                     (invoke "pytest" "-vv")))))))
    (native-inputs
     (list python-pytest python-lxml))   ;used for the tests
    (home-page "https://bitbucket.org/openpyxl/et_xmlfile")
    (synopsis "Low memory implementation of @code{lxml.xmlfile}")
    (description "This Python library is based upon the @code{xmlfile} module
from @code{lxml}.  It aims to provide a low memory, compatible implementation
of @code{xmlfile}.")
    (license license:expat)))

(define-public python-omero-py
  (package
    (name "python-omero-py")
    (version "5.13.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/ome/omero-py")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0n94v5dpmh873hjqd9k9ky85iab4xh37ibmi13rqpclv01ibvvxa"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      '(list "-m" "not broken" "-rf" "test" "-s"
             ;; TestImport tries to download Java things; TestSessions
             ;; and TestBuildQuery require networking.
             "-k" "not TestImport and not TestSessions and not TestBuildQuery")
      #:modules '((guix build pyproject-build-system)
                  (guix build utils)
                  (ice-9 match)
                  (srfi srfi-1)
                  (srfi srfi-26))
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'find-artifacts
            (lambda* (#:key inputs #:allow-other-keys)
              (let ((zip-file
                     (match inputs
                       (((labels . files) ...)
                        (find (cut string-suffix? "omero-blitz-5.5.5-python.zip" <>)
                              files)))))
                (setenv "ZIP_FILE"
                        (or zip-file (error "failed to find artifact file"))))))
          ;; Some tests need this, such as TestTempFileManager
          (add-after 'build 'set-HOME
            (lambda _ (setenv "HOME" "/tmp")))
          ;; The sanity check mistakes omero_model_TypeAnnotationI.py for a
          ;; module to load.
          (delete 'sanity-check)
          ;; The argument parser is picky and interprets the "-real" part as
          ;; the first argument.
          (add-after 'wrap 'rename-executable
            (lambda _
              (with-directory-excursion (string-append #$output "/bin")
                (rename-file ".omero-real" ".omero")
                (substitute* "omero"
                  (("bin/.omero-real") "bin/.omero"))))))))
    (propagated-inputs
     (list python-appdirs
           python-future
           python-numpy
           python-pillow
           python-pyyaml
           python-requests
           python-tables
           python-zeroc-ice-3.6))
    (native-inputs
     (list python-mox3
           python-pytest
           python-pytest-rerunfailures
           python-pytest-xdist
           python-setuptools
           python-wheel
           unzip
           (origin
             (method url-fetch)
             (uri "https://artifacts.openmicroscopy.org/artifactory/\
ome.releases/org/openmicroscopy/omero-blitz/5.5.5/omero-blitz-5.5.5-python.zip")
             (sha256
              (base32 "0wyja1zv19c1r3m31gsp555jzj3cg2v2pl00zlybpw3qd36yffwc")))))
    (home-page "https://github.com/ome/omero-py")
    (synopsis "Python bindings to the OMERO.blitz server")
    (description "This package provides Python bindings to the OMERO.blitz
server.")
    (license license:gpl2)))

(define-public python-openpyxl
  (package
    (name "python-openpyxl")
    (version "3.1.5")
    (source
     (origin
       ;; We use the upstream repository, as the tests are not included in the
       ;; PyPI releases.
       (method hg-fetch)
       (uri (hg-reference
             (url "https://foss.heptapod.net/openpyxl/openpyxl")
             (changeset version)))
       (file-name (string-append name "-" version "-checkout"))
       (sha256
        (base32 "17z6rrvv3q1axy9r13c2hln2pazfn9n5bhkzrbjcjakgbfjl6mss"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-lxml
                         python-pillow
                         python-pytest
                         python-setuptools
                         python-wheel))
    (propagated-inputs (list python-et-xmlfile python-jdcal))
    (home-page "https://openpyxl.readthedocs.io")
    (synopsis "Python library to read/write Excel 2010 XLSX/XLSM files")
    (description
     "This Python library allows reading and writing to the Excel XLSX, XLSM,
XLTX and XLTM file formats that are defined by the Office Open XML (OOXML)
standard.")
    (license license:expat)))

(define-public python-sinfo
  (package
    (name "python-sinfo")
    (version "0.3.4")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "sinfo" version))
              (sha256
               (base32
                "0kdsp883mx0lfyykv0p12bvs203kdm3skb8bw5wf2pc7kb393sl1"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-stdlib-list))
    (home-page "https://gitlab.com/joelostblom/session_info")
    (synopsis "Output module version information loaded in a Python session")
    (description "This package outputs version information for modules loaded
in the current session, Python, and the OS.")
    (license license:bsd-3)))

(define-public python-six
  (package/inherit python-six-bootstrap
    (name "python-six")
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "pytest" "-v"))))))
    (native-inputs
     `(("python-pytest" ,python-pytest-bootstrap)))))

(define-public python2-six
  (let ((base (package-with-python2 python-six)))
    (package
      (inherit base)
      ;; Reduce Python 2 closure by disabling tests and removing the native
      ;; inputs.
      (arguments (substitute-keyword-arguments (package-arguments base)
                   ((#:phases phases)
                    `(modify-phases ,phases
                       (delete 'check)))))
      (native-inputs '()))))

(define-public python-schedule
  (package
    (name "python-schedule")
    (version "0.4.3")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "schedule" version))
      (sha256
       (base32
        "0vplyjcbfrq50sphlwya749z8p2pcyi2nycw3518i0qpd9a6189i"))
      (snippet
       #~(begin (use-modules (guix build utils))
                (substitute* "schedule/__init__.py"
                  (("collections\\.Hashable")
                   "collections.abc.Hashable"))))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest python-mock))
    (home-page "https://github.com/dbader/schedule")
    (synopsis "Schedule periodic function calls in Python")
    (description
     "Schedule is an in-process scheduler for periodic jobs that uses the
builder pattern for configuration.  Schedule lets you run Python functions (or
any other callable) periodically at pre-determined intervals using a simple,
human-friendly syntax.")
    (license license:expat)))

(define-public python-scour
  (package
    (name "python-scour")
    (version "0.38.2")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/scour-project/scour")
         (commit
          (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0mmfvx4wqp8gkpv0kbih89zfs9njvmd3v4dxfqii62xddpxq0f1k"))))
    (propagated-inputs
     (list python-six))
    (build-system python-build-system)
    (home-page "https://github.com/scour-project/scour")
    (synopsis "Scour is an SVG optimizer/cleaner written in Python")
    (description "The goal of Scour is to output a file that renders
identically at a fraction of the size by removing a lot of redundant
information created by most SVG editors.  Optimization options are typically
lossless but can be tweaked for more aggressive cleaning.")
    (license license:asl2.0)))

(define-public python-mechanize
  (package
    (name "python-mechanize")
    (version "0.4.7")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "mechanize" version))
      (sha256
       (base32
        "02b845y85ka5sl2cj93lll3v326d8bww07bq1q0y1643h7sshwqp"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-html5lib))
    (home-page "https://github.com/python-mechanize/mechanize")
    (synopsis
     "Stateful programmatic web browsing in Python")
    (description
     "Mechanize implements stateful programmatic web browsing in Python,
after Andy Lester’s Perl module WWW::Mechanize.")
    (license license:bsd-3)))

(define-public python-mediapy
  (package
    (name "python-mediapy")
    (version "1.2.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/google/mediapy")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "08dj0h7xkpaj552pzjln1chshxsfxbwhv29p2npsmscy907s322l"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'fix-references
           (lambda _
             (substitute* "mediapy_test.py"
               (("'/bin/bash")
                (string-append "'" (which "bash")))))))))
    (inputs (list ffmpeg-5))
    (propagated-inputs (list python-absl-py
                             python-ipython
                             python-matplotlib
                             python-numpy
                             python-pillow))
    (native-inputs
     (list python-flit-core
           python-pylint
           python-pytest
           python-pytest-xdist))
    (home-page "https://github.com/google/mediapy")
    (synopsis "Read/write/show images and videos in an IPython notebook")
    (description "This Python library makes it easy to display images and
videos in a notebook.")
    (license license:asl2.0)))

(define-public python-simpleaudio
  (package
    (name "python-simpleaudio")
    (version "1.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "simpleaudio" version))
       (sha256
        (base32
         "07glihg0fpca0gvbbvqs9q815w8xhflzdvg72yvlsm23j9j8h739"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))
    (inputs
      (list alsa-lib))
    (home-page
     "https://github.com/hamiltron/py-simple-audio")
    (synopsis "Simple, asynchronous audio playback for Python 3")
    (description
     "The @code{simplaudio} package provides cross-platform, dependency-free
audio playback capability for Python 3 on OSX, Windows, and Linux.")
    (license license:expat))) ; MIT license

(define-public python-wavefile
  (package
    (name "python-wavefile")
    (version "1.6.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "wavefile" version))
              (sha256
               (base32
                "04mdcxq7n1vnwb9y65j0cwpy91ik5rh9vki1f45xqnh4ygz91n75"))))
    (build-system python-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (add-after 'unpack 'patch-libsndfile-path
                 (lambda* (#:key inputs #:allow-other-keys)
                   (substitute* "wavefile/libsndfile.py"
                     (("'libsndfile")
                      (string-append "'" (assoc-ref inputs "libsndfile")
                                     "/lib/libsndfile"))))))))
    (inputs
     (list libsndfile portaudio))
    (propagated-inputs (list python-numpy python-pyaudio))
    (home-page "https://github.com/vokimon/python-wavefile")
    (synopsis "Pythonic audio file reader and writer")
    (description
     "This package provides pythonic libsndfile wrapper to read and write audio
files.")
    (license license:gpl3+)))

(define-public python-jsonalias
  (package
    (name "python-jsonalias")
    (version "0.1.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "jsonalias" version))
              (sha256
               (base32
                "0sd7c3vyvfhhpnan77ax4f0x1whjcb5iz7jhjky7kmcpaf9lvw34"))))
    (build-system python-build-system)
    (arguments (list #:tests? #f)) ; There are no tests.
    (home-page "https://github.com/kevinheavey/jsonalias/")
    (synopsis "JSON type alias for Python")
    (description
     "This package provides a microlibrary that defines a JSON type alias for
Python.")
    (license license:expat)))

(define-public python-jsonargparse
  (package
    (name "python-jsonargparse")
    (version "4.21.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "jsonargparse" version))
              (sha256
               (base32
                "1k3b60x0zf86fh50y2jyby30gksqriyvvpfnf5mqq0qn7jih01y7"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      '(list "-k" (string-append "not test_env_prefix"
                                 " and not test_basemodel"
                                 " and not test_field_default_factory"
                                 " and not test_field_description"
                                 " and not test_get_param_relative_import_from_init"
                                 ;; Strangely, the arguments are interpreted
                                 ;; as arguments to pytest.
                                 " and not test_pydantic_types"))))
    (propagated-inputs
     (list python-contextvars
           python-docstring-parser
           python-pyyaml
           python-typeshed-client))
    (native-inputs
     (list python-attrs
           python-coverage
           python-pycodestyle
           python-pydantic
           python-pytest
           python-pytest-subtests
           python-responses
           python-tox
           python-types-requests
           python-setuptools
           python-wheel))
    (home-page "https://github.com/omni-us/jsonargparse/")
    (synopsis "Implement minimal boilerplate CLIs derived from type hints")
    (description
     "This package lets you implement minimal boilerplate CLIs derived from
type hints and parse from command line, config files and environment
variables.")
    (license license:expat)))

(define-public python-pymarshal
  (package
    (name "python-pymarshal")
    (version "2.2.3")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pymarshal" version))
              (sha256
               (base32
                "1lhb7yim60pvclbd440zd4n50xs1d2rvmnrhhvib3hyv0dxil5j3"))))
    (build-system pyproject-build-system)
    (arguments
     ;; Test fails with this error:
     ;; "CovReportWarning: Failed to generate report: No data to report."
     (list #:tests? #f))
    (native-inputs
     (list python-pytest python-pytest-cov python-setuptools python-wheel))
    (propagated-inputs (list python-bson python-pyyaml))
    (home-page "https://gitlab.com/d3v-t00lz/pymarshal")
    (synopsis "Pythonic implementation of Golang struct (un)marshalling")
    (description "PyMarshal replicates the feature of (un)marshalling structs
in Golang.")
    (license license:bsd-2)))

(define-public python-simplejson
  (package
    (name "python-simplejson")
    (version "3.17.6")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "simplejson" version))
      (sha256
       (base32
        "19pqqn01y6qmhhv8q6dh4p1acav49kl923kklnns2qxz5a6h766g"))))
    (build-system python-build-system)
    (native-inputs
     (list python-toml))
    (home-page "https://simplejson.readthedocs.io/en/latest")
    (synopsis
     "Json library for Python")
    (description
     "JSON (JavaScript Object Notation) is a subset of JavaScript
syntax (ECMA-262 3rd edition) used as a lightweight data interchange
format.

Simplejson exposes an API familiar to users of the standard library marshal
and pickle modules.  It is the externally maintained version of the json
library contained in Python 2.6, but maintains compatibility with Python 2.5
and (currently) has significant performance advantages, even without using
the optional C extension for speedups.  Simplejson is also supported on
Python 3.3+.")
    (license license:x11)))

(define-public python-simple-rlp
  (package
    (name "python-simple-rlp")
    (version "0.1.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/SamuelHaidu/simple-rlp")
             ;; Upstream doesn't tag the git repo.
             (commit "342ea269d84da1ddc4a7630cdebc90159261391c")))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1nv92sphpkyrncak4qgj50qmgkmj4ycl2szbnv9c7ihgl5df4div"))))
    (build-system python-build-system)
    (home-page "https://github.com/SamuelHaidu/simple-rlp")
    (synopsis
     "Python implementation of RLP (Recursive Length Prefix) encoding")
    (description
     "@code{simple-rlp} is a python implementation of RLP (Recursive Length \
Prefix) - Encode and decode data structures.")
    (license license:expat)))

(define-public python-pyicu
  (package
    (name "python-pyicu")
    (version "2.9")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "PyICU" version))
      (sha256
       (base32
        "0y2qhh443vydi3y7kmhyb6kz3z6d7qq7ld0sg88mfqalcp7dca9w"))))
    (build-system python-build-system)
    (inputs
     (list icu4c))
    (native-inputs
     (list python-pytest python-six))
    (home-page "https://gitlab.pyicu.org/main/pyicu")
    (synopsis "Python extension wrapping the ICU C++ API")
    (description
     "PyICU is a python extension wrapping the ICU C++ API.")
    (license license:x11)))

(define-public python-dogtail
  (package
    (name "python-dogtail")
    (version "0.9.11")
    (source (origin
             (method url-fetch)
             (uri
              (string-append
               "https://gitlab.com/dogtail/dogtail/-/raw/released/"
               "dogtail-" version ".tar.gz"))
             (sha256
              (base32
               "0sr38z7b2n12bvfd4xw4b5dnnhkn5zl3h0ymmnnzavcihfqia6l0"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f                      ; TODO Launching dbus for the tests
                                        ; fails
       #:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (system "Xvfb :1 &")
               (setenv "DISPLAY" ":1")
               (invoke "dbus-run-session" "--" "nosetests" "-v" "tests/"))
             #t)))))
    (propagated-inputs
     (list python-pygobject python-pycairo python-pyatspi))
    (native-inputs
     (list python-nose
           gtk+
           xorg-server-for-tests
           dbus
           gsettings-desktop-schemas
           gobject-introspection))
    (home-page "https://gitlab.com/dogtail/dogtail/")
    (synopsis "GUI test tool and automation framework written in Python")
    (description
     "Dogtail is a GUI test tool and automation framework written in Python.
It uses Accessibility (a11y) technologies to communicate with desktop
applications. dogtail scripts are written in Python and executed like any
other Python program.")
    (license license:gpl2+)))

(define-public python-doxyqml
  (package
    (name "python-doxyqml")
    (version "0.5.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "doxyqml" version))
              (sha256
               (base32
                "1f0jjqvamly4hn7f1palvq27z6yr694rfzyxrb6g0ysbbawxkvq9"))))
    (build-system python-build-system)
    (home-page "https://agateau.com/projects/doxyqml")
    (synopsis "Doxygen input filter for QML files")
    (description
     "This package provides a Doxygen input filter for QML files.")
    (license license:bsd-3)))

(define-public python-doxypypy
  (package
    (name "python-doxypypy")
    (version "0.8.8.6")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "doxypypy" version))
              (sha256
               (base32
                "06z0vbh975g42z5szbfvn9i3bif3xwr5pncqd4fvjzjkbi2p2xb2"))))
    (build-system python-build-system)
    (arguments '(#:tests? #f))          ;no test suite
    (home-page "https://github.com/Feneric/doxypypy")
    (synopsis "Doxygen filter for Python")
    (description
     "This package provides a Doxygen filter for Python.")
    (license license:gpl2+)))

(define-public python-empy
  (package
    (name "python-empy")
    (version "3.3.3")
    (source (origin
             (method url-fetch)
             (uri (string-append "http://www.alcyone.com/software/empy/empy-"
                                 version ".tar.gz"))
             (sha256
              (base32
               "1mxfy5mgp473ga1pgz2nvm8ds6z4g3hdky8523z6jzvcs9ny6hcq"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))                    ; python2 only
    (home-page "http://www.alcyone.com/software/empy/")
    (synopsis "Templating system for Python")
    (description
     "EmPy is a system for embedding Python expressions and statements in
template text; it takes an EmPy source file, processes it, and produces
output.  This is accomplished via expansions, which are special signals to the
EmPy system and are set off by a special prefix (by default the at sign, @@).
EmPy can expand arbitrary Python expressions and statements in this way, as
well as a variety of special forms.  Textual data not explicitly delimited in
this way is sent unaffected to the output, allowing Python to be used in
effect as a markup language.  Also supported are callbacks via hooks,
recording and playback via diversions, and dynamic, chainable filters.  The
system is highly configurable via command line options and embedded
commands.")
    (license license:lgpl2.1+)))

(define-public python-palettable
  (package
    (name "python-palettable")
    (version "3.3.3")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "palettable" version))
              (sha256
               (base32
                "1a4h0jpsr3wjciqg9a5kslxv65d3qqgmqgkpai4cl77wlpcxfk89"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://jiffyclub.github.io/palettable/")
    (synopsis "Color palettes for Python")
    (description "Palettable (formerly brewer2mpl) is a library of color
palettes for Python.  It’s written in pure Python with no dependencies, but it
can supply color maps for matplotlib.  You can use Palettable to customize
matplotlib plots or supply colors for a web application.")
    (license license:expat)))

(define-public python-parse-type
  (package
    (name "python-parse-type")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "parse_type" version))
       (sha256
        (base32
         "07smqnzc9km7sbvxfyx4gdm9njrx58x8grdw6gs4gva81rk3rd10"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-pytest-html
           python-setuptools
           python-wheel))
    (propagated-inputs (list python-six python-parse))
    (home-page "https://github.com/jenisys/parse_type")
    (synopsis "Extended parse module")
    (description "Parse_type extends the python parse module.")
    (license license:bsd-3)))

(define-public python-parse
  (package
    (name "python-parse")
    (version "1.18.0")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "parse" version))
      (sha256
       (base32
        "19063x4xdjpaf7rfxai6jpgm2k4yvkq7wha8aa8cagbjsqr60rli"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _ (invoke "python" "test_parse.py"))))))
    (home-page "https://github.com/r1chardj0n3s/parse")
    (synopsis "Parse strings")
    (description
     "Parse strings using a specification based on the Python @code{format()}
syntax.")
    (license license:x11)))

(define-public python-parsley
  (package
    (name "python-parsley")
    (version "1.3")
    (source (origin
              ;; The source distributed on PyPI is outdated.
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/pyga/parsley")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0550rw65ygqzbjc8a66hs355pzbx727kbn20dssdb6ls846gw2qs"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags #~(list "ometa/test" "terml/test")))
    (native-inputs
     (list python-pytest
           python-twisted
           python-setuptools
           python-wheel))
    (home-page "https://launchpad.net/parsley")
    (synopsis "Parsing and pattern matching Python library")
    (description
     "Parsley is a parsing library using PEG algorithm, so each expression in
the grammar rules works like a Python expression.  In particular, alternatives
are evaluated in order, unlike table-driven parsers such as yacc, bison or PLY.
Parsley is an implementation of OMeta, an object-oriented pattern-matching
language.")
    (license license:expat)))

(define-public python-polib
  (package
    (name "python-polib")
    (version "1.1.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "polib" version))
               (sha256
                (base32
                  "0aikb8gcarhifn3sadrbbs5czagih9hjv250gsrgy9v1d49pvn7s"))))
    (build-system python-build-system)
    (home-page "https://bitbucket.org/izi/polib/wiki/Home")
    (synopsis "Manipulate, create and modify gettext files")
    (description "Polib can manipulate any gettext format (po, pot and mo)
files.  It can be used to create po files from scratch or to modify
existing ones.")
    (license license:expat)))

(define-public python-polling2
  (package
    (name "python-polling2")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "polling2" version))
       (sha256
        (base32 "0hp3238fv6k1qk43gv4jwnv1mwlkmx33akbj560b9nvsry1dmdwh"))))
    (build-system python-build-system)
    (arguments '(#:tests? #false)) ; no tests included
    (native-inputs
     (list python-mock python-pytest python-pytest-runner))
    (home-page "https://github.com/ddmee/polling2")
    (synopsis "Polling utility with many configurable options")
    (description "Polling2 is a utility used to wait for a function to return
a certain expected condition.")
    (license license:expat)))

(define-public python-pomegranate
  (package
    (name "python-pomegranate")
    (version "0.14.8")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pomegranate" version))
              (sha256
               (base32
                "0gb9srkbxzlkjyfizvxkw5y0bvnfcyiaxapz0hrdaba8j096b5i2"))
              (modules '((guix build utils)))
              ;; Delete generated Cython C files.
              (snippet
               '(for-each delete-file (find-files "." "\\.c$")))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "python" "setup.py" "test")))))))
    (propagated-inputs
     (list python-joblib
           python-networkx
           python-numpy
           python-pyyaml
           python-scipy))
    (native-inputs
     (list python-cython
           python-nose
           python-pandas))
    (home-page "https://pypi.python.org/pypi/pomegranate/")
    (synopsis "Graphical models library for Python")
    (description
     "Pomegranate is a graphical models library for Python, implemented in
Cython for speed.")
    (license license:expat)))

(define-public python-daft
  (package
    (name "python-daft")
    (version "0.1.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "daft" version))
              (sha256
               (base32
                "1r8jsfavd624q2q61f863lk6has6mv5csswh39saafd5khwf0xry"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      '(list "-k"
             (string-append
               ;; The following tests compare matplotlib output with
               ;; previously generated images.  They fail due to minor
               ;; differences in where matplotlib places labels.
               "not test_bca[png]"
               " and not test_classic[png]"
               " and not test_deconvolution[png]"
               " and not test_exoplanets[png]"
               " and not test_fixed[png]"
               " and not test_gaia[png]"
               " and not test_galex[png]"
               " and not test_huey_p_newton[png]"
               " and not test_logo[png]"
               " and not test_no_circles[png]"
               " and not test_no_gray[png]"
               " and not test_recursive[png]"
               " and not test_thick_lines[png]"
               " and not test_weaklensing[png]"
               " and not test_wordy[png]"))))
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs (list python-matplotlib python-numpy))
    (home-page "https://docs.daft-pgm.org/")
    (synopsis "PGM rendering library")
    (description "Daft is a Python package that uses matplotlib to
render pixel-perfect probabilistic graphical models for publication in
a journal or on the internet.  With a short Python script and an
intuitive model-building syntax you can design directed (Bayesian
Networks, directed acyclic graphs) and undirected (Markov random fields)
models and save them in any formats that matplotlib supports (including
PDF, PNG, EPS and SVG).")
    (license license:expat)))

(define-public python-portalocker
  (package
    (name "python-portalocker")
    (version "2.7.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "portalocker" version))
              (sha256
               (base32
                "0lawjm736vs86wlnxc3qqh37l11z0yx81xq3dmrw33m86kaq2bh3"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest
                         python-pytest-cov
                         python-pytest-mypy
                         python-pytest-timeout
                         python-redis
                         python-setuptools
                         python-wheel))
    (home-page "https://github.com/WoLpH/portalocker")
    (synopsis "Python library for file locking")
    (description "Portalocker is a library to provide an easy API to file
locking..")
    (license license:bsd-3)))

(define-public python-poyo
  (package
    (name "python-poyo")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "poyo" version))
       (sha256
        (base32
         "1pflivs6j22frz0v3dqxnvc8yb8fb52g11lqr88z0i8cg2m5csg2"))))
    (build-system python-build-system)
    (home-page "https://github.com/hackebrot/poyo")
    (synopsis "Lightweight YAML Parser for Python")
    (description
     "This package provides a lightweight YAML Parser for Python.  It supports
only a chosen subset of the YAML format that is required to parse cookiecutter
user configuration files.  It does not have support for serializing into YAML
and is not compatible with JSON.")
    (license license:expat)))

(define-public python-expandvars
  (package
    (name "python-expandvars")
    (version "0.12.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "expandvars" version))
       (sha256
        (base32 "0i6q4i8dzsax85w1l2hc7saymyh3fw43vkifh5flpkr8ayjxy6kx"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-hatchling python-pytest python-pytest-cov))
    (home-page "https://pypi.org/project/expandvars/")
    (synopsis "Expand system variables Unix style")
    (description "This module is inspired by GNU bash's variable expansion
features.  It can be used as an alternative to Python's
@code{os.path.expandvars} function.  A good use case is reading config files
with the flexibility of reading values from environment variables using
advanced features like returning a default value if some variable is not
defined.")
    (license license:expat)))

(define-public python-extension-helpers
  (package
    (name "python-extension-helpers")
    (version "1.2.0")
    (source
     (origin
       (method git-fetch) ; no tests in the PyPI tarball
       (uri (git-reference
             (url "https://github.com/astropy/extension-helpers")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1cfzh3ijjp18as2qnmm1nnw6a3daqd7a2q17i0c6h1wq2jbawxxa"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; It tries to install it via pip: E ModuleNotFoundError: No module named
      ;; 'helpers_test_package_fd9cc3a9_11fa_4a1a_b80e_c5b043949604'
      #:test-flags #~(list "-k" "not test_only_pyproject and not test_no_setup_py")
      #:phases
      #~(modify-phases %standard-phases
          ;; LookupError: setuptools-scm was unable to detect version for
          ;; /tmp/guix-build-python-extension-helpers-1.2.0.drv-0/source.
          (add-before 'build 'set-version
            (lambda _
              (setenv "SETUPTOOLS_SCM_PRETEND_VERSION" #$version)))
          (replace 'check
            (lambda* (#:key tests? test-flags #:allow-other-keys)
              (when tests?
                (setenv "HOME" "/tmp")
                (with-directory-excursion "/tmp"
                  (apply invoke "pytest" "-v" test-flags))))))))
    (native-inputs
     (list python-pytest
           python-pytest-astropy
           python-pytest-cov
           python-setuptools-scm
           python-tomli
           python-setuptools
           python-wheel
           python-pip))
    (home-page "https://extension-helpers.readthedocs.io")
    (synopsis "Astropy ecosystem utilities for building and installing packages")
    (description
     "The extension-helpers package includes convenience helpers to assist
with building Python packages with compiled C/Cython extensions.  It is
developed by the Astropy project but is intended to be general and usable by
any Python package.")
    (license license:bsd-3)))

(define-public python-extras
  (package
    (name "python-extras")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "extras" version))
       (sha256
        (base32
         "0khvm08rcwm62wc47j8niyl6h13f8w51c8669ifivjdr23g3cbhk"))))
    (build-system python-build-system)
    (arguments
     ;; FIXME: Circular dependency on testtools.
     '(#:tests? #f))
    (home-page "https://github.com/testing-cabal/extras")
    (synopsis "Useful extensions to the Python standard library")
    (description
     "Extras is a set of extensions to the Python standard library.")
    (license license:expat)))

(define-public python-milc
  (package
    (name "python-milc")
    (version "1.6.8")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "milc" version))
              (sha256
               (base32
                "1pnwdg2653lc82qsv6c0kv9qcydh2f6w5mx5l4227zy1f6kr7b52"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-appdirs python-argcomplete python-colorama
                             python-halo python-spinners))
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/clueboard/milc")
    (synopsis "Python library for command line interface programs")
    (description "MILC is a Python library for developing command line
interface programs.  This library provides features to parse arguments,
automatic tab-completion, color support, logging to @code{std}, etc.")
    (license license:expat)))

(define-public python-extract-dtb
  (package
    (name "python-extract-dtb")
    (version "1.2.3")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "extract-dtb" version))
              (sha256
               (base32
                "1a7rfvwisgri8b00pch6d9pfrl8s93w8g09yzxf4xh0qvmsxmh43"))))
    (build-system python-build-system)
    (home-page "https://github.com/PabloCastellano/extract-dtb/")
    (synopsis "Extract device tree blobs (DTB) from kernel images")
    (description
     "This package provides a tool to split a kernel image with appended
@acronym{DTB, Device Tree Blobs} into separated kernel and DTB files.")
    (license license:gpl3+)))

(define-public python-mimeparse
  (package
    (name "python-mimeparse")
    (version "1.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "python-mimeparse" version))
       (sha256
        (base32
         "0y2g6cl660bpz11srgqyvvm8gmywpgyx8g0xfvbiyr0af0yv1r3n"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "./mimeparse_test.py"))))))
    (home-page
     "https://github.com/dbtsai/python-mimeparse")
    (synopsis "Python library for parsing MIME types")
    (description
     "Mimeparse provides basic functions for parsing MIME type names and
matching them against a list of media-ranges.")
    (license license:expat)))

(define-public python-miniboa
  (package
    (name "python-miniboa")
    (version "1.0.8")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "miniboa" version))
       (sha256
        (base32
         "002c1aki9hsrwj5plrwdrf3sk8rn95fqylqyjx2arrjfpsih4dgs"))))
    (build-system python-build-system)
    (home-page "https://github.com/shmup/miniboa")
    (synopsis "Simple, single-threaded Telnet server")
    (description
     "Miniboa is a simple, asynchronous, single-threaded, poll-based Telnet
server.")
    (license license:asl2.0)))

(define-public python-mir-eval
  (package
    (name "python-mir-eval")
    (version "0.7")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "mir_eval" version))
              (sha256
               (base32
                "0pp6xdflqhj2czhb2w3kk2c7mx4h2hj0n5rabiaafrbcfsjvmzp1"))))
    (build-system python-build-system)
    (propagated-inputs (list python-future python-numpy python-scipy
                             python-six))
    (native-inputs (list python-matplotlib))
    (home-page "https://github.com/craffel/mir_eval")
    (synopsis "Common metrics for common audio/music processing tasks")
    (description "This is a Python library for computing common heuristic
accuracy scores for various music/audio information retrieval/signal
processing tasks.")
    (license license:expat)))

(define-public python-mizani
  (package
    (name "python-mizani")
    (version "0.13.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/has2k1/mizani")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0ij0fk4w0jyyj44ij3i2j1nfa0d7dk783w9r25cpwjkpn690xqfx"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'pretend-version
            ;; The version string is usually derived via setuptools-scm, but
            ;; without the git metadata available, the version string is set to
            ;; '999'.
            (lambda _
              (setenv "SETUPTOOLS_SCM_PRETEND_VERSION" #$version))))))
    (propagated-inputs
     (list python-matplotlib python-numpy python-pandas python-scipy))
    (native-inputs
     (list python-setuptools python-setuptools-scm
           python-pytest python-pytest-cov python-wheel tzdata))
    (home-page "https://github.com/has2k1/mizani")
    (synopsis "Create data visualizations in Python")
    (description
     "Mizani is a Python package for creating data visualizations.  It
provides functions and tools to help with the creation of visually appealing
and informative visualizations, including scales, transformations and color
palettes.")
    (license license:bsd-3)))

(define-public python-pafy
  (package
    (name "python-pafy")
    (version "0.5.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pafy" version))
       (sha256
        (base32
         "1a7dxi95m1043rxx1r5x3ngb66nwlq6aqcasyqqjzmmmjps4zrim"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f)) ; Currently pafy can not find itself in the tests
    (propagated-inputs
     ;; Youtube-dl is a python package which is imported in the file
     ;; "backend_youtube_dl.py", therefore it needs to be propagated.
     (list youtube-dl))
    (home-page "https://np1.github.io/pafy/")
    (synopsis "Retrieve YouTube content and metadata")
    (description
     "@code{pafy} is a python library to retrieve YouTube content and metadata.")
    (license license:lgpl3+)))

(define-public python-miniupnpc
  (package
    (name "python-miniupnpc")
    (version "2.2.3")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/miniupnp/miniupnp")
         (commit
          (string-append
           "miniupnpc_" (string-replace-substring version "." "_")))))
       (file-name
        (git-file-name name version))
       (sha256
        (base32 "03q1rlzvfzm15g1bfw2zqzavlsyaypnaf2k3cz6ha7k5rirkdy0l"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'subdir
            (lambda* (#:key inputs #:allow-other-keys)
              (chdir "miniupnpc")
              (setenv "CC" #$(cc-for-target))
              (substitute* "Makefile"
                (("/bin/sh") (search-input-file inputs "/bin/sh")))))
          (add-before 'subdir 'remove-kernel-version
            ;; Avoid embedding the running kernel version for reproducible builds
            (lambda _
              (substitute*
                  "miniupnpc/updateminiupnpcstrings.sh"
                (("^OS_VERSION=`uname -r`") "OS_VERSION=Guix")))))))
    (inputs (list python))              ;we are building a Python extension
    (synopsis "UPnP client for Python")
    (description "Miniupnpc is a client library for Python programs to set up
port forwards using @acronym{UPnP, Universal Plug and Play}.")
    (home-page "http://miniupnp.free.fr")
    (license license:bsd-3)))

;; NOTE: As taken from upstram: "this library is in maintenance mode and
;; should not be used in new code."
(define-public python-py
  (package
    (name "python-py")
    (version "1.11.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "py" version))
       (sha256
        (base32
         "06c7m7sfcn7587xd4s2bng8m6q1gsfd3j93afhplfjq74r0mrisi"))))
    (build-system pyproject-build-system)
    (arguments
     '(#:tests? #f)) ;cycle with python-pytest
    (native-inputs
     (list python-setuptools
           python-setuptools-scm
           python-wheel))
    (home-page "https://github.com/pytest-dev/py")
    (synopsis "Python library for parsing, I/O, introspection, and logging")
    (description
     "Py is a Python library for file name parsing, .ini file parsing, I/O,
code introspection, and logging.")
    (license license:expat)))

;; Recent versions of python-fixtures and python-testrepository need
;; python-pbr for packaging, which itself needs these two packages for
;; testing.
;; To fix this circular dependency, we use a build of python-pbr, based on the
;; same source, just without any test dependencies and with tests disabled.
;; python-pbr-minmal is then used to package python-fixtures and
;; python-testrepository.
;; Strictly speaking we currently could remove the test-requirements from the
;; normal python-pbr package (and save this package) since test are disabled
;; there anyway. But this may change in future.
(define-public python-pbr-minimal
  (package
    (name "python-pbr-minimal")
    (version "5.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pbr" version))
       (sha256
        (base32
         "1j8k5d4rdhy5bw5ai1vkjzln2albah94in3vvyvxa0n42fv81baz"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))
    (home-page "https://docs.openstack.org/pbr/latest/")
    (synopsis "Minimal build of python-pbr used for bootstrapping")
    (description
     "Used only for bootstrapping python2-pbr, you should not need this.")
    (license license:asl2.0)))

(define-public python-pbr
  (package
    (inherit python-pbr-minimal)
    (name "python-pbr")
    (arguments
     `(#:tests? #f)) ;; Most tests seem to use the Internet.
    (propagated-inputs
      (list git-minimal/pinned)) ;; pbr actually uses the "git" binary.
    (native-inputs
      `(("python-fixtures" ,python-fixtures-bootstrap)
        ;; discover, coverage, hacking, subunit
        ("python-mock" ,python-mock)
        ("python-six" ,python-six)
        ("python-sphinx" ,python-sphinx)
        ("python-testrepository" ,python-testrepository-bootstrap)
        ("python-testresources" ,python-testresources-bootstrap)
        ("python-testscenarios" ,python-testscenarios-bootstrap)
        ("python-testtools" ,python-testtools-bootstrap)
        ("python-virtualenv" ,python-virtualenv)))
    (synopsis "Enhance the default behavior of Python’s setuptools")
    (description
      "Python Build Reasonableness (PBR) is a library that injects some useful
and sensible default behaviors into your setuptools run.  It will set
versions, process requirements files and generate AUTHORS and ChangeLog file
from git information.
")))

(define-public python-pyrsistent
  (package
    (name "python-pyrsistent")
    (version "0.16.0")
    (home-page "https://github.com/tobgu/pyrsistent")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pyrsistent" version))
              (sha256
               (base32
                "1lrsjgblnapfimd0alsi1as5nz2lfqv97131l7d6anbjzq2rjri8"))))
    (build-system python-build-system)
    (arguments
     '(#:phases (modify-phases %standard-phases
                  ;; The package works fine with newer Pytest and Hypothesis, but
                  ;; has pinned older versions to stay compatible with Python 2.
                  (add-before 'check 'loosen-pytest-requirement
                    (lambda _
                      (substitute* "setup.py"
                        (("pytest<5") "pytest")
                        (("hypothesis<5") "hypothesis"))
                      #t)))))
    (native-inputs
     (list python-hypothesis python-pytest python-pytest-runner))
    (propagated-inputs
     (list python-six))
    (synopsis "Persistent data structures for Python")
    (description
     "Pyrsistent is a number of persistent collections (by some referred to as
functional data structures).  Persistent in the sense that they are immutable.

All methods on a data structure that would normally mutate it instead return a
new copy of the structure containing the requested updates.  The original
structure is left untouched.")
    (license license:expat)))

(define-public python-exif-read
  (package
    (name "python-exif-read")
    (version "3.0.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "ExifRead" version))
              (sha256
               (base32
                "191c7sa0rca8wkspfq8nlfa6davh743mqkzrcayz5gcx2rja7i8a"))))
    (build-system python-build-system)
    (arguments `(#:tests? #f)) ; no tests
    (home-page "https://github.com/ianare/exif-py")
    (synopsis "Python library to extract EXIF data from image files")
    (description
     "ExifRead is a Python library to extract EXIF data from tiff and jpeg
files.")
    (license license:bsd-3)))

(define-public python-pyld
  (package
    (name "python-pyld")
    (version "2.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "PyLD" version))
       (sha256
        (base32 "1k7ars8n6kramkvadxgy0qfsi5g1hipyha4wqw8l75mw1l7ka7ii"))))
    (build-system python-build-system)
    (native-inputs (list python-lxml))
    (propagated-inputs (list python-cachetools python-frozendict))
    (home-page "https://github.com/digitalbazaar/pyld")
    (synopsis "Python implementation of the JSON-LD specification")
    (description "PyLD is an implementation of the JSON-LD specification.")
    (license license:bsd-3)))

(define-public python-cli-helpers
  (package
    (name "python-cli-helpers")
    (version "2.2.1")
    (source
     (origin
       ;; There's no source tarball on PyPI.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/dbcli/cli_helpers")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1hzavh9v9lkd1dn9f0nvg80f7v4banxvcrj10zy72przqz51k1sb"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest))
    (propagated-inputs
     (list python-wcwidth python-configobj python-tabulate))
    (home-page "https://github.com/dbcli/cli_helpers")
    (synopsis "Helpers for building command-line apps")
    (description
     "CLI Helpers is a Python package that makes it easy to perform common
tasks when building command-line apps.  It's a helper library for command-line
interfaces.")
    (license license:bsd-3)))

(define-public python-click
  (package
    (name "python-click")
    (version "8.1.7")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "click" version))
       (sha256
        (base32
         "1pm6khdv88h764scik67jki98xbyj367h591j8hpwy4y8nnm766a"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest" "-vv")))))))
    (native-inputs (list python-pytest))
    (home-page "https://palletsprojects.com/p/click/")
    (synopsis "Command line library for Python")
    (description
     "Click is a Python package for creating command line interfaces in a
composable way with as little code as necessary.  Its name stands for
\"Command Line Interface Creation Kit\".  It's highly configurable but comes
with sensible defaults out of the box.")
    (license license:bsd-3)))

(define-public python-click-7
  (package (inherit python-click)
    (name "python-click")
    (version "7.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "click" version))
       (sha256
        (base32 "06kbzd6sjfkqan3miwj9wqyddfxc2b6hi7p5s4dvqjb3gif2bdfj"))))
    (arguments `())))

(define-public python-clickgen
  (package
    (name "python-clickgen")
    (version "2.1.3")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "clickgen" version))
              (sha256
               (base32
                "010j9zz0gd2za5l4hibicypnfw721x0gxp3rr0329bc97vw5maha"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-pillow python-toml python-numpy python-attrs))
    (inputs (list libx11 libpng libxcursor))
    (native-inputs (list python-wheel))
    (home-page "https://github.com/ful1e5/clickgen")
    (synopsis "The hassle-free cursor building toolbox")
    (description
     "Clickgen is an API for building X11 and Windows cursors from .png files.
clickgen is using @code{anicursorgen} and @code{xcursorgen} under the hood.")
    (license license:expat)))

(define-public python-clickhouse-connect
  (package
    (name "python-clickhouse-connect")
    (version "0.6.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/ClickHouse/clickhouse-connect")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1s0lk7xdq8f351cmpbp6jidqi5zdazrdba7w7fxph0w8sd74amry"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; All these tests require docker-compose
      '(list "--ignore-glob=tests/integration_tests/*")
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'patch-pyproject
           (lambda _
             ;; Our version of pytest is confused by this field.
             (substitute* "pyproject.toml"
               (("^env_files.*") ""))))
         (add-before 'check 'build-extensions
           (lambda _
             ;; Cython extensions have to be built before running the tests.
             (invoke "python" "setup.py" "build_ext" "--inplace"))))))
    (propagated-inputs
     (list python-arrow
           python-certifi
           python-lz4
           python-numpy
           python-orjson
           python-pandas
           python-pytz
           python-setuptools ; For pkg_resources.
           python-sqlalchemy
           python-urllib3
           python-zstandard))
    (native-inputs
     (list python-cython
           python-pytest
           python-wheel))
    (home-page "https://github.com/ClickHouse/clickhouse-connect")
    (synopsis
     "ClickHouse database core driver for Python, Pandas, and Superset")
    (description
     "This package provides a high performance core database driver for
connecting ClickHouse to Python, Pandas, and Superset.")
    (license license:asl2.0)))

(define-public python-cligj
  (package
    (name "python-cligj")
    (version "0.7.2")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "cligj" version))
        (sha256
          (base32
            "09vbkik6kyn6yrqzl2r74vaybjk8kjykvi975hy3fsrm4gb17g54"))))
    (build-system python-build-system)
    (propagated-inputs
      (list python-click))
    (native-inputs
      (list python-pytest-cov))
    (home-page "https://github.com/mapbox/cligj")
    (synopsis "Click params for command line interfaces to GeoJSON")
    (description
      "cligj is for Python developers who create command line interfaces
for geospatial data.  cligj allows you to quickly build consistent,
well-tested and interoperable CLIs for handling GeoJSON.")
    (license license:bsd-3)))

(define-public python-cloup
  (package
    (name "python-cloup")
    (version "2.1.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "cloup" version))
              (sha256
               (base32
                "05c6cjpnf9s72gyn5dckxbmd8rf2kgdzfsl7pqzrnc1lcdl13zmv"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-click))
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/janLuke/cloup")
    (synopsis "Extension library for python-click")
    (description
     "Cloup enriches Click with several features that make it more expressive
and configurable such as option groups, constraints, subcommand aliases,
subcommands sections and a themeable HelpFormatter.")
    (license license:bsd-3)))

(define-public python-vcversioner
  (package
    (name "python-vcversioner")
    (version "2.16.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "vcversioner" version))
       (sha256
        (base32
         "16z10sm78jd7ca3jbkgc3q5i8a8q7y1h21q1li21yy3rlhbhrrns"))))
    (build-system python-build-system)
    (synopsis "Python library for version number discovery")
    (description "Vcversioner is a Python library that inspects tagging
information in a variety of version control systems in order to discover
version numbers.")
    (home-page "https://github.com/habnabit/vcversioner")
    (license license:isc)))

(define-public python-jdcal
  (package
    (name "python-jdcal")
    (version "1.4.1")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "jdcal" version))
        (sha256
          (base32
            "1j6g19jf21qprjsr8h0r7nsbss366gy8j9izq8cz53gbjvh74a27"))))
    (build-system python-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (replace 'check
                 (lambda* (#:key tests? #:allow-other-keys)
                   (when tests?
                     (invoke "pytest" "-vv")))))))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/phn/jdcal")
    (synopsis "Functions to convert between Julian dates Gregorian dates")
    (description "This Python library provides functions for converting
between Julian dates and Gregorian dates.")
    (license license:bsd-2)))

(define-public python-jsondiff
  (package
   (name "python-jsondiff")
   (version "1.2.0")
   (source
    (origin
     (method url-fetch)
     (uri (pypi-uri "jsondiff" version))
     (sha256
      (base32
       "00v3689175aqzdscrxpffm712ylp8jvcpqdg51ca22ni6721p51l"))))
   (build-system python-build-system)
   (native-inputs
    (list python-nose python-nose-random))
   (home-page
    "https://github.com/fzumstein/jsondiff")
   (synopsis "Compare JSON and JSON-like structures in Python")
   (description "@code{jsondiff} is a Python library which lets you
compare, diff, and patch JSON and JSON-like structures in Python.")
   (license license:expat)))

(define-public python-ddlparse
  (package
    (name "python-ddlparse")
    (version "1.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ddlparse" version))
       (sha256
        (base32 "1nh8m6rxslwk05daxshxmgk41qfp18yynydba49b13l4m8dnh634"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-codecov
           python-coveralls
           python-pytest
           python-pytest-cov
           python-setuptools
           python-tox
           python-wheel))
    (propagated-inputs (list python-pyparsing))
    (home-page "https://github.com/shinichi-takii/ddlparse")
    (synopsis "Parses and converts DDL to BigQuery JSON schema")
    (description "This package provides @{ddlparse}, a Python library to parse
and convert DDL to BigQuery JSON schema.")
    (license license:bsd-3)))

(define-public python-jsonschema
  (package
    (name "python-jsonschema")
    (version "4.23.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jsonschema" version))
       (sha256
        (base32 "1i3b4sckkc3v8vckqa11xbrj695qzrzsfzrkclra6lb3ybz9f56p"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'pre-check
            (lambda _
              (setenv "JSON_SCHEMA_TEST_SUITE" "json"))))))
    (native-inputs
     (list python-hatchling
           python-hatch-fancy-pypi-readme
           python-hatch-vcs
           ;; For <tests/test_cli.py::TestCLIIntegration::test_license>.
           python-pip
           python-pytest))
    (propagated-inputs
     (list python-attrs
           python-fqdn
           python-idna
           python-importlib-resources
           python-isoduration
           python-jsonpointer
           python-jsonschema-specifications
           python-rfc3339-validator
           python-rfc3986-validator
           python-referencing-bootstrap
           python-rpds-py
           python-uri-template
           python-webcolors-24))
    (home-page "https://github.com/Julian/jsonschema")
    (synopsis "Implementation of JSON Schema for Python")
    (description
     "Jsonschema is an implementation of JSON Schema for Python.")
    (license license:expat)))

;; For docker-compose 1.29.2, remove when its updated to the latest 2.x
;; version.
(define-public python-jsonschema-3
  (package
    (inherit python-jsonschema)
    (version "3.2.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "jsonschema" version))
              (sha256
               (base32
                "0ykr61yiiizgvm3bzipa3l73rvj49wmrybbfwhvpgk3pscl5pa68"))))
    (arguments
     (substitute-keyword-arguments (package-arguments python-jsonschema)
       ((#:tests? _ #t) #f)))
    (propagated-inputs
     (list python-attrs
           python-importlib-metadata
           python-pyrsistent
           python-typing-extensions))
    (native-inputs
     (list python-setuptools-scm python-twisted
           python-setuptools python-wheel))))

(define-public python-jsonschema-path
  (package
    (name "python-jsonschema-path")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jsonschema_path" version))
       (sha256
        (base32 "129rb8y2bj2wwps8vs3z1qav006k7wz2myx5j6dnxqs1yfmsn3ad"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #false  ;there are none
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'relax-requirements
           (lambda _
             (substitute* "pyproject.toml"
               (("referencing = \">=0.28.0,<0.32.0\"")
                "referencing = \">=0.28.0\"")))))))
    (propagated-inputs (list python-pathable python-pyyaml python-referencing
                             python-requests))
    (native-inputs (list python-poetry-core))
    (home-page "https://github.com/p1c2u/jsonschema-path")
    (synopsis "JSONSchema Spec with object-oriented paths")
    (description "This package implements object-oriented JSONSchema.  It lets
you traverse a schema like paths and access a schema on demand with separate
dereferencing accessor layer.")
    (license license:asl2.0)))

(define-public python-jsonschema-specifications
  (package
    (name "python-jsonschema-specifications")
    (version "2024.10.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jsonschema_specifications" version))
       (sha256
        (base32 "0wp2g90jsaa48g1v0n6m43ywhh9cj1ig19q25lay334m74vbhf0g"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-hatch-vcs
           python-hatchling
           python-pytest))
    (propagated-inputs
     (list python-importlib-resources
           python-referencing-bootstrap))
    (home-page "https://github.com/python-jsonschema/jsonschema-specifications")
    (synopsis
     "JSON Schema meta-schemas and vocabularies, exposed as a Registry")
    (description
     "This package provides JSON support files from the JSON Schema
Specifications (metaschemas, vocabularies, etc.), packaged for runtime access
from Python as a referencing-based Schema Registry.")
    (license license:expat)))

(define-public python-schema
  (package
    (name "python-schema")
    (version "0.6.6")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "schema" version))
       (sha256
        (base32
         "1lw28j9w9vxyigg7vkfkvi6ic9lgjkdnfvnxdr7pklslqvzmk2vm"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/keleshev/schema")
    (synopsis "Simple data validation library")
    (description
     "@code{python-schema} is a library for validating Python data
structures, such as those obtained from config-files, forms, external
services or command-line parsing, converted from JSON/YAML (or
something else) to Python data-types.")
    (license license:psfl)))

(define-public python-schema-0.5
  (package (inherit python-schema)
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "schema" version))
       (sha256
        (base32
         "10zqvpaky51kgb8nd42bk7jwl8cn2zvayxjpdc1wwmpybj92x67s"))))))

(define-public python-kitchen
  (package
    (name "python-kitchen")
    (version "1.2.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "kitchen" version))
       (sha256
        (base32
         "1zakh6l0yjvwic9p0nkvmbidpnkygkxbigh2skmb5gccyrhbp7xg"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-chardet))
    (home-page "https://github.com/fedora-infra/kitchen")
    (synopsis "Python API for snippets")
    (description "@code{kitchen} module provides a python API for all sorts of
little useful snippets of code that everybody ends up writing for their projects
but never seem big enough to build an independent release.  Use kitchen and stop
cutting and pasting that code over and over.")
    (license (list license:lgpl2.1+
                   ;; subprocess.py, test_subprocess.py,
                   ;; kitchen/pycompat25/defaultdict.py:
                   license:psfl))))

(define-public python-roman
  (package
    (name "python-roman")
    (version "3.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "roman" version))
       (sha256
        (base32
         "0gyp2bmw47jgpm8j64gydzqq838bgxz5gh6cm57lxlr7p26sqiic"))))
    (build-system python-build-system)
    (home-page "https://github.com/zopefoundation/roman")
    (synopsis "Integer to Roman numerals converter")
    (description
     "This package provides a small helper library to convert Arabic Numbers
to Roman Numerals.")
    (license license:psfl)))

(define-public python-rollbar
  (package
    (name "python-rollbar")
    (version "1.0.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "rollbar" version))
              (sha256
               (base32
                "1bzkgp4r79d789q15vnjji2gcb34bnksx9l7q9pjkw12kzjbfiv3"))))
    (build-system python-build-system)
    (native-inputs (list python-pytest-runner python-unittest2))
    (inputs (list python-requests python-six python-httpx python-blinker
                  python-webob))
    (home-page "https://github.com/rollbar/pyrollbar")
    (synopsis "Notifier for exceptions, errors, and log messages to Rollbar")
    (description
     "Python SDK for reporting exceptions, errors, and log messages
to @url{https://rollbar.com/, Rollbar}.

Capabilities include:

@itemize @bullet
@item Sending messages and exceptions with arbitrary context
@item Getting back aggregates
@item Debugging production issues
@end itemize")
    (license license:expat)))

(define-public python-unidecode
  (package
    (name "python-unidecode")
    (version "1.3.8")
    (source (origin
             (method url-fetch)
             (uri (pypi-uri "Unidecode" version))
             (sha256
              (base32
               "1x620s4dk4d501pivhlfzbi2d1r5fnm9cssqwkn76f7d8sfk9nyg"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://pypi.org/project/Unidecode/")
    (synopsis "ASCII transliterations of Unicode text")
    (description
     "Unidecode provides ASCII transliterations of Unicode text.  Unidecode is
useful when integrating with legacy code that doesn't support Unicode, or for
ease of entry of non-Roman names on a US keyboard, or when constructing ASCII
machine identifiers from human-readable Unicode strings that should still be
somewhat intelligible.")
    (license license:gpl2+)))

(define-public python-text-unidecode
  (package
    (name "python-text-unidecode")
    (version "1.3")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "text-unidecode" version))
              (sha256
               (base32
                "14xb99fdv52j21dsljgsbmbaqv10ps4b453p229r29sdn4xn1mms"))))
    (build-system python-build-system)
    (arguments
     '(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda _
                      (invoke "pytest" "-vv"))))))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/kmike/text-unidecode/")
    (synopsis "Decode Unicode data")
    (description
     "@code{text-unidecode} is a basic Python port of the @code{Text::Unidecode}
Perl library.  It can create ASCII representations of Unicode data.  In general
users should prefer the @code{python-unidecode} package which offers better
memory usage and transliteration quality.")
    ;; The user can choose either license.
    (license (list license:clarified-artistic license:gpl2+))))

(define-public python-pyjwt
  (package
    (name "python-pyjwt")
    (version "2.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "PyJWT" version))
       (sha256
        (base32
         "1z85kwr945rbzrn5wabrsmck5x8disa9wc7b3y5gci7w65z5qa39"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-coverage
           python-cryptography
           python-pytest
           python-sphinx
           python-sphinx-rtd-theme
           python-setuptools
           python-wheel))
    (home-page "https://github.com/progrium/pyjwt")
    (synopsis "JSON Web Token implementation in Python")
    (description
     "PyJWT is a JSON Web Token implementation written in Python.")
    (license license:expat)))

(define-public python-pymsgbox
  (package
    (name "python-pymsgbox")
    (version "1.0.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              ;; LICENSE.txt is not present on pypi
              (url "https://github.com/asweigart/PyMsgBox")
              (commit "55926b55f46caa969c5ddb87990ebea2737bd66f")))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0zy7rjfpwlrd8b64j7jk2lb8m2npc21rnpwakpfvwgl4nxdy80rg"))))
    (arguments
     ;; Circular dependency to run tests:
     ;; Tests need pyautogui, which depends on pymsgbox.
     '(#:tests? #f))
    (build-system python-build-system)
    (home-page "https://github.com/asweigart/PyMsgBox")
    (synopsis "Python module for JavaScript-like message boxes")
    (description
     "PyMsgBox is a simple, cross-platform, pure Python module for
JavaScript-like message boxes.  Types of dialog boxes include:
@enumerate
@item alert
@item confirm
@item prompt
@item password
@end enumerate
")
    (license license:bsd-3)))

(define-public python-pympler
  (package
    (name "python-pympler")
    (home-page "https://pythonhosted.org/Pympler/")
    (version "1.0.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "Pympler" version))
              (sha256
               (base32
                "1ynkqpv2akldmvkll5vh5zhwj433s1d59iv0f76lygyak4silgwr"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'skip-broken-test
            (lambda _
              ;; FIXME: This test fails for no good reason:
              ;; https://github.com/pympler/pympler/issues/153
              (substitute* "test/muppy/test_tracker.py"
                (("^([[:blank:]]+)def test_stracker_create_summary" all indent)
                 (string-append indent "@unittest.skipIf(True, \
'Fails on Guix too for unknown reasons')\n" all))))))))
    (synopsis "Measure, monitor and analyze memory behavior")
    (description
     "Pympler is a development tool to measure, monitor and analyze
the memory behavior of Python objects in a running Python application.

By pympling a Python application, detailed insight in the size and the
lifetime of Python objects can be obtained.  Undesirable or unexpected
runtime behavior like memory bloat and other @samp{pymples} can easily
be identified.

A web profiling frontend exposes process statistics, garbage
visualisation and class tracker statistics.")
    (license license:asl2.0)))

(define-public python-itsdangerous
  (package
    (name "python-itsdangerous")
    (version "2.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "itsdangerous" version))
       (sha256
        (base32 "0wv1bwzbfvpsh4ng5gn4d4mjwvjwpg7w0jgiz8zsbvm1gl5hq1g0"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-flit-core
           python-freezegun
           python-pytest))
    (home-page "https://palletsprojects.com/p/itsdangerous/")
    (synopsis "Python library for passing data to/from untrusted environments")
    (description
     "Itsdangerous provides various helpers to pass trusted data to untrusted
environments and back.")
    (license license:bsd-3)))

;; WARNING: This package is a dependency of mesa.
(define-public python-pyyaml
  (package
    (name "python-pyyaml")
    (version "6.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "PyYAML" version))
       (sha256
        (base32
         "0hsa7g6ddynifrwdgadqcx80khhblfy94slzpbr7birn2w5ldpxz"))))
    (build-system python-build-system)
    (inputs
     (list libyaml python-cython))
    (home-page "https://pyyaml.org")
    (synopsis "YAML parser and emitter for Python")
    (description
     "PyYAML is a YAML parser and emitter for Python.  PyYAML features a
complete YAML 1.1 parser, Unicode support, pickle support, capable extension
API, and sensible error messages.  PyYAML supports standard YAML tags and
provides Python-specific tags that represent an arbitrary Python object.")
    (license license:expat)))

(define-public python-pyyaml-5
  (package
    (inherit python-pyyaml)
    (version "5.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "PyYAML" version))
       (sha256
        (base32
         "0pm440pmpvgv5rbbnm8hk4qga5a292kvlm1bh3x2nwr8pb5p8xv0"))))))

(define-public python-vine
  (package
    (name "python-vine")
    (version "5.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "vine" version))
       (sha256
        (base32 "1q31krwxdvwawdn1kfqmpplix31d4jhs0qng26908hawsf0yjqlb"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; AttributeError: 'test_barrier' object has no attribute 'ps'.
      #~(list "-k" (string-join
                    (list "not test_evaluate"
                          "test_reverse"
                          "test_cancel"
                          "test_throw")
                    " and not "))))
    (native-inputs
     (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/celery/vine")
    (synopsis "Promises for Python")
    (description
     "@code{vine} provides a special implementation of promises in that it can
be used both for \"promise of a value\" and lazy evaluation.  The biggest
upside for this is that everything in a promise can also be a promise,
e.g. filters, callbacks and errbacks can all be promises.")
    (license license:bsd-3)))

(define-public python-virtualenv
  (package
    (name "python-virtualenv")
    (version "20.28.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "virtualenv" version))
       (sha256
        (base32
         "1aj980vffl4mpq4j67f7a0j07rlm8jp5yw8xh3m8fywfpdi3571c"))))
    (build-system pyproject-build-system)
    (arguments
     ;; These tests require Internet access.
     (list #:test-flags '(list "-k" "not test_seed_link_via_app_data")))
    (native-inputs
     (list python-covdefaults
           python-coverage
           python-flaky
           python-hatch-vcs
           python-hatchling
           python-packaging
           python-pytest
           python-pytest-env
           python-pytest-mock
           python-pytest-timeout
           python-setuptools
           python-time-machine))
    (propagated-inputs
     (list python-distlib python-filelock python-importlib-metadata
           python-platformdirs))
    (home-page "https://virtualenv.pypa.io/")
    (synopsis "Virtual Python environment builder")
    (description
     "Virtualenv is a tool to create isolated Python environments.")
    (license license:expat)))

(define-public python-crossenv
  (package
    (name "python-crossenv")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "crossenv" version))
       (sha256
        (base32
         "07rv4650n19740ixmnsf4qbxyqlgi7f5m1cy8cq0gl01q3r6hps4"))))
    (build-system python-build-system)
    (arguments
     (list #:tests? #f)) ; tests not distributed on pypi
    (home-page "https://github.com/benfogle/crossenv")
    (synopsis "Cross-compiling virtualenv for Python")
    (description "This package is a tool for cross-compiling extension
modules.  It creates a special virtual environment such that @command{pip} or
@file{setup.py} will cross compile packages for you, usually with no further
work on your part.")
    (license license:expat)))

(define-public python-virtualenv-clone
  (package
    (name "python-virtualenv-clone")
    (version "0.5.7")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/edwardgeorge/virtualenv-clone")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0p0d1y3axvjfnxlgwjx2374gikc8bmc82g0m7yashihbikh7pcxa"))))
    (build-system python-build-system)
    (arguments
     (list #:phases #~(modify-phases %standard-phases
                        (replace 'check
                          (lambda* (#:key tests? #:allow-other-keys)
                            (when tests?
                              (delete-file "tox.ini")
                              (invoke "pytest" "-vvv" "tests")))))))
    (native-inputs (list python-pytest
                         python-tox
                         python-virtualenv
                         python-coverage
                         python-wheel
                         python-tomli
                         python-hypothesis))
    (home-page "https://github.com/edwardgeorge/virtualenv-clone")
    (synopsis "Clone a non-relocatable virtualenv cleanly")
    (description
     "Clone non-relocatable virtualenvs without breaking site-packages.")
    (license license:expat)))

(define-public python-uc-micro-py
  (package
    (name "python-uc-micro-py")
    (version "1.0.1")
    (source (origin
              (method git-fetch)        ;for tests
              (uri (git-reference
                    (url "https://github.com/tsutsu3/uc.micro-py")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "17f55gi55rg47nm88fn3f8851ph03dgykdp011lxr3j6hk18lyfv"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/tsutsu3/uc.micro-py")
    (synopsis "Unicode data files for linkify-it-py projects")
    (description "This package contains a micro subset of Unicode data files
for linkify-it-py projects.")
    (license license:expat)))

(define-public python-linkify-it-py
  (package
    (name "python-linkify-it-py")
    (version "2.0.0")
    (source (origin
              (method git-fetch)        ;for tests
              (uri (git-reference
                    (url "https://github.com/tsutsu3/linkify-it-py")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0fg0a1lc8xbb62y9krxcp708ll58dxcwm8i7rrwpkd5sh2229f6x"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-uc-micro-py))
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/tsutsu3/linkify-it-py")
    (synopsis "Links recognition library with full Unicode support")
    (description "This is Python port of
@url{https://github.com/markdown-it/linkify-it, linkify-it}, which is a links
recognition library with full Unicode support.  It has features like:
@itemize
@item Full unicode support, with @i{astral} characters
@item International domains support
@item Allows rules extension and custom normalizers.
@end itemize")
    (license license:expat)))

(define-public python-makefun
  (package
    (name "python-makefun")
    (version "1.15.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "makefun" version))
              (sha256
               (base32
                "19a8dga8rnmjn5gy1cy1wdi28swbkdkypwbqikbxil6ynqcg3c20"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest python-setuptools python-setuptools-scm python-wheel))
    (home-page "https://github.com/smarie/python-makefun")
    (synopsis "Library to dynamically create python functions")
    (description "@code{makefun} helps create functions dynamically with a
given signature.  It was largely inspired by @code{python-decorator} and
@code{functools}.")
    (license license:bsd-3)))

(define-public python-markdown-it-py
  (package
    (name "python-markdown-it-py")
    (version "3.0.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "markdown-it-py" version))
              (sha256
               (base32
                "1swgvyiavak0nmfb31lq5zck5chwhmyf6qb6qwpcav86zaa0mxp3"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #f))      ;pypi source does not contains tests
    (native-inputs (list python-flit-core))
    (propagated-inputs
     (list python-commonmark
           python-linkify-it-py
           python-markdown
           python-mdurl
           python-mistletoe
           python-mistune
           python-panflute
           python-psutil
           python-pyyaml))
    (home-page "https://github.com/executablebooks/markdown-it-py")
    (synopsis "Python port of markdown-it")
    (description
     "This is a Python port of @code{markdown-it}, and some of its associated
plugins.  The driving design philosophy of the port has been to change as
little of the fundamental code structure (file names, function name, etc) as
possible.")
    (license license:expat)))

(define-public python-markupsafe
  (package
    (name "python-markupsafe")
    (version "2.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "MarkupSafe" version))
       (sha256
        (base32
         "0jqxp5sfrc0byp6bk0gwdmildi4mck2gprp42afri3z4r5y1k4bz"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (when tests?
                        (invoke "pytest" "-vv")))))))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/mitsuhiko/markupsafe")
    (synopsis "XML/HTML/XHTML markup safe string implementation for Python")
    (description
     "Markupsafe provides an XML/HTML/XHTML markup safe string implementation
for Python.")
    (license license:bsd-3)))

(define-public python-jinja2
  (package
    (name "python-jinja2")
    (version "3.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "Jinja2" version))
       (sha256
        (base32 "0lp86yadzf8dph67f6g3yxmvnhrzzi863z58jmsrx2j059q1ld9i"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (propagated-inputs (list python-markupsafe))
    (home-page "https://jinja.palletsprojects.com/")
    (synopsis "Python template engine")
    (description
     "Jinja2 is a small but fast and easy to use stand-alone template engine
written in pure Python.")
    (license license:bsd-3)))

(define-public python-jinja2-time
  (package
    (name "python-jinja2-time")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jinja2-time" version))
       (sha256
        (base32
         "0h0dr7cfpjnjj8bgl2vk9063a53649pn37wnlkd8hxjy656slkni"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-arrow python-jinja2))
    (home-page
     "https://github.com/hackebrot/jinja2-time")
    (synopsis "Jinja2 Extension for Dates and Times")
    (description
     "This package provides an extension for the template engine Jinja2.  It
adds a 'now' tag providing a convenient access to the arrow.now() API from
templates.  A format string can be provided to control the output.")
    (license license:expat)))

(define-public python-pypugjs
  (package
    (name "python-pypugjs")
    (version "5.9.12")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/kakulukia/pypugjs")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0zj7a560h973cl7brfw1nmyhgm8rp8j80wnih0shvhmw4ql23lpa"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags '(list "pypugjs/testsuite/")
      #:phases #~(modify-phases %standard-phases
                   (add-after 'unpack 'disable-pyramid
                     (lambda _
                       ;; pyramid is outdated and pyramid-mako is unpackaged.
                       (substitute* "setup.cfg"
                         (("'(pyramid|pyramid-mako)[^']*',") "")))))))
    (native-inputs (list python-coverage
                         python-django
                         python-jinja2
                         python-flake8
                         python-flask
                         python-mako
                         python-nose
                         python-poetry-core
                         python-pytest
                         python-tornado-6
                         python-wheel))
    (propagated-inputs (list python-charset-normalizer python-six))
    (home-page "https://github.com/kakulukia/pypugjs")
    (synopsis "Convert Pug source files into different template languages")
    (description
     "PyPugJS is a high-performance port of PugJS for Python, that converts
any @file{.pug} source into different template languages: Django, Jinja2,
Mako, and Tornado.")
    (license license:expat))) ;; MIT

(define-public python-pysdl2
  (package
    (name "python-pysdl2")
    (version "0.9.11")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "PySDL2" version))
              (sha256
               (base32
                "19id1qswgcj4v4j5kn49shq1xxx3slhjpm0102w87mczsdbi1rck"))))
    (build-system python-build-system)
    (arguments
      (list #:tests? #f ;; Requires /dev/dri, OpenGL module, etc.
            #:phases
            #~(modify-phases %standard-phases
                (add-after 'unpack 'patch-paths
                  (lambda* (#:key inputs #:allow-other-keys)
                    (substitute* "sdl2/dll.py"
                    ;; Disable pysdl2-dll. It can't be packaged on GNU Guix
                    ;; as it duplicates an existing package (sdl2).
                    (("prepath = os\\.getenv\\('PYSDL2_DLL_PATH'\\)")
                     "prepath = \"system\"")
                    (("^import sdl2dll$") "")
                    (("postpath = os\\.getenv\\('PYSDL2_DLL_PATH'\\)")
                     "postpath = \"system\"")
                    (("DLL\\(.*, os\\.getenv\\(\"PYSDL2_DLL_PATH\"\\)\\)")
                     (string-append
                       "DLL(\"SDL2\", [\"SDL2\", \"SDL2-2.0\", \"SDL2-2.0.0\"], \""
                       (dirname (search-input-file inputs "/lib/libSDL2.so"))
                       "\")")))
              (substitute* "sdl2/sdlimage.py"
                (("os\\.getenv\\(\"PYSDL2_DLL_PATH\"\\)")
                 (string-append
                   "\""
                   (dirname (search-input-file inputs "/lib/libSDL2_image.so"))
                   "\"")))
              (substitute* "sdl2/sdlgfx.py"
                (("os\\.getenv\\(\"PYSDL2_DLL_PATH\"\\)")
                 (string-append
                   "\""
                   (dirname (search-input-file inputs "/lib/libSDL2_gfx.so"))
                   "\"")))
              (substitute* "sdl2/sdlmixer.py"
                (("os\\.getenv\\(\"PYSDL2_DLL_PATH\"\\)")
                 (string-append
                   "\""
                   (dirname (search-input-file inputs "/lib/libSDL2_mixer.so"))
                   "\"")))
              (substitute* "sdl2/sdlttf.py"
                (("os\\.getenv\\(\"PYSDL2_DLL_PATH\"\\)")
                 (string-append
                   "\""
                   (dirname (search-input-file inputs "/lib/libSDL2_ttf.so"))
                   "\""))))))))
    (inputs
      (list sdl2 sdl2-image sdl2-gfx sdl2-mixer sdl2-ttf))
    (home-page "https://github.com/py-sdl/py-sdl2")
    (synopsis "Python bindings around the SDL2 game development library")
    (description "PySDL2 is a pure Python wrapper around the @code{SDL2},
@code{SDL2_mixer}, @code{SDL2_image}, @code{SDL2_ttf}, and @code{SDL2_gfx}
libraries.  Instead of relying on C code, it uses the built-in ctypes module
to interface with SDL2, and provides simple Python classes and wrappers for
common SDL2 functionality.")
    (license license:cc0)))

(define-public python-pystache
  (package
    (name "python-pystache")
    (version "0.6.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pystache" version))
              (sha256
               (base32
                "03a73ppf5vxnsk6az5ackvc0hp6xqv2f4hi1s5c4nk4s2jr95gwk"))))
    (build-system python-build-system)
    (arguments
     '(#:tests? #f)) ; FIXME: Python 3 tests are failing.
    (home-page "http://defunkt.io/pystache/")
    (synopsis "Python logic-less template engine")
    (description
     "Pystache is a Python implementation of the framework agnostic,
logic-free templating system Mustache.")
    (license license:expat)))

(define-public python-pystitcher
  (package
    (name "python-pystitcher")
    (version "1.0.4")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/captn3m0/pystitcher")
         (commit
          (string-append "v" version))))
       (file-name
        (git-file-name name version))
       (sha256
        (base32 "03yrzqhcsjdj5zprrk3bh5bbyqfy3vfhxra9974vmkir3m121394"))))
    (build-system python-build-system)
    (inputs
     (list python-html5lib python-importlib-metadata python-markdown
           python-pypdf3 python-validators))
    (home-page "https://github.com/captn3m0/pystitcher")
    (synopsis "Declaratively stitch together a PDF file from multiple sources")
    (description
     "This package stitches your PDF files together, generating customizable
bookmarks using a declarative input in the form of a markdown file.")
    (license license:expat)))

(define-public python-joblib
  (package
    (name "python-joblib")
    (version "1.4.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "joblib" version))
              (sha256
               (base32
                "03izdcvc3fa355cclzgvzmjnfwylvblz9q091b9gndi6df0wb0i3"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags  ; disabled to avoid having to depend on ipython/jupyter
      #~(list
         "--numprocesses" (number->string (parallel-job-count))
         "-k"
         (string-append
          "not test_parallel_call_cached_function_defined_in_jupyter"
          ;; XXX This test times out.
          " and not test_no_resource_tracker_on_import"))))
    (native-inputs
     (list python-pytest python-pytest-xdist python-setuptools python-wheel))
    (propagated-inputs (list python-psutil))
    (home-page "https://joblib.readthedocs.io/")
    (synopsis "Using Python functions as pipeline jobs")
    (description
     "Joblib is a set of tools to provide lightweight pipelining in Python.
In particular, joblib offers: transparent disk-caching of the output values
and lazy re-evaluation (memoize pattern), easy simple parallel computing
logging and tracing of the execution.")
    (license license:bsd-3)))

(define-public python-daemon
  (package
    (name "python-daemon")
    (version "3.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "python-daemon" version))
       (sha256
        (base32
         "1rfsnij687hk97ppzs2q6mwmxgr632nh672ajd0gzsppf8ilamvc"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'check 'adjust-tests
           (lambda _
             ;; FIXME: Determine why test fails
             (substitute* "test/test_daemon.py"
               (("test_detaches_process_context")
                "skip_test_detaches_process_context"))
             (substitute* "test/scaffold.py"
               (("test_exception_instance")
                "skip_test_exception_instance")
               (("test_exception_types")
                "skip_test_exception_types")))))))
    (propagated-inputs
     (list python-lockfile python-packaging python-setuptools))
    (native-inputs
     (list python-docutils
           python-testscenarios
           python-testtools))
    (home-page "https://pagure.io/python-daemon/")
    (synopsis "Python library for making a Unix daemon process")
    (description "Python-daemon is a library that assists a Python program to
turn itself into a well-behaved Unix daemon process, as specified in PEP 3143.

This library provides a @code{DaemonContext} class that manages the following
important tasks for becoming a daemon process:
@enumerate
@item Detach the process into its own process group.
@item Set process environment appropriate for running inside a chroot.
@item Renounce suid and sgid privileges.
@item Close all open file descriptors.
@item Change the working directory, uid, gid, and umask.
@item Set appropriate signal handlers.
@item Open new file descriptors for stdin, stdout, and stderr.
@item Manage a specified PID lock file.
@item Register cleanup functions for at-exit processing.
@end enumerate")
    ;; Only setup.py is gpl3+, everything else is apache 2.0 licensed.
    (license (list license:asl2.0 license:gpl3+))))

(define-public python-elevate
  (package
    (name "python-elevate")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "elevate" version))
       (sha256
        (base32 "02g23lxzzl64j1b4fsnrdxqiahl9lnrqyxpqwcfzn0g33px1kbak"))))
    (build-system pyproject-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'clean-up
           (lambda _
             ;; Uses stuff we don't have.
             (delete-file "elevate/windows.py"))))))
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/barneygale/elevate")
    (synopsis "Python library for requesting root privileges")
    (description "This package provides a Python library for requesting
root privileges.")
    (license license:expat)))

(define-public python-annotated-types
  (package
    (name "python-annotated-types")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "annotated_types" version))
       (sha256
        (base32 "12ff8j1l0hrmfa8dfa1pyaka5a8sbyq8b76bzj6bq21sll4prw5g"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-hatchling
           python-pytest))
    (propagated-inputs (list python-typing-extensions))
    (home-page "https://github.com/annotated-types/annotated-types")
    (synopsis "Reusable constraint types to use with typing.Annotated")
    (description "This package provides metadata objects which can be used to
represent common constraints such as upper and lower bounds on scalar values and
collection sizes, a Predicate marker for runtime checks, and descriptions of how
we intend these metadata to be interpreted.  In some cases, we also note
alternative representations which do not require this package.")
    (license license:expat)))

(define-public python-anytree
  (package
    (name "python-anytree")
    (version "2.12.0")
    (source
     (origin
       (method git-fetch)   ; no tests data in PyPi package
       (uri (git-reference
             (url "https://github.com/c0fec0de/anytree")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0fagd6h6nixvzf3ps8pbfkxvp9xnpq8hpmzaaq1zab4dzqnpsrgj"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'pre-check
            (lambda _
              ;; Tests need to write to that direcroty.
              (mkdir-p "tests/dotexport/"))))))
    (native-inputs
     (list graphviz ;for 'dot'
           python-poetry-core
           python-pytest))
    (propagated-inputs
     (list python-six))
    (home-page "https://github.com/c0fec0de/anytree")
    (synopsis "Lightweight tree data library")
    (description
     "@code{anytree} is a simple, lightweight, and extensible tree data
structure for Python.")
    (license license:asl2.0)))

(define-public autokey
  (package
    (name "autokey")
    (version "0.96.0")
    (source (origin
             (method git-fetch)
             (uri (git-reference
                   (url "https://github.com/autokey/autokey")
                   (commit (string-append "v" version))))
             (file-name (git-file-name name version))
             (sha256
              (base32
               "1v19196swihc12bcg0d9s07gfc3a44b9y7g6rqhb82qxm4p8jmbp"))
             (modules '((guix build utils)))
             (snippet
              #~(begin
                  ;; XXX: skip test depending on .git/
                  (delete-file "tests/test_common.py")))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          ;; Use 'prefix' instead of '=' to allow the user to use additional
          ;; GI paths from their autokey scripts.  GUIX_PYTHONPATH is already
          ;; wrapped with prefix in python-build-system's wrap.
          (add-before 'wrap 'wrap-autokey
            (lambda* (#:key inputs #:allow-other-keys)
              (let ((gi-typelib-path (getenv "GI_TYPELIB_PATH"))
                    (path (map dirname
                               ;; see lib/autokey/UI_common_functions.py
                               (list (search-input-file inputs "/bin/wmctrl")
                                     (search-input-file inputs "/bin/zenity")
                                     (search-input-file inputs "/bin/ipython3")
                                     (search-input-file inputs "/bin/python3")))))
                (for-each
                 (lambda (program)
                   (wrap-program program
                     `("PATH" ":" prefix ,path)
                     `("GI_TYPELIB_PATH" ":" prefix (,gi-typelib-path))))
                 (map (lambda (name)
                        (string-append #$output "/bin/" name))
                      '("autokey-gtk"
                        "autokey-shell"))))))
          (add-before 'check 'setup-env-vars
            (lambda _
              ;; tests/test_macro.py wants LANG set
              (setenv "LANG" "")
              ;; required for tests/test_configmanager.py
              (setenv "HOME" "/tmp"))))))
    (native-inputs (list python-pytest python-pytest-cov python-pyhamcrest))
    (inputs
     (list bash-minimal ; for wrap-program
           gtksourceview-3
           libappindicator
           libnotify
           python-dbus
           python-ipython
           python-pygobject
           python-pyinotify
           python-pyqt+qscintilla
           python-xlib
           wmctrl
           zenity))
    (home-page "https://github.com/autokey/autokey")
    (synopsis
      "Keyboard and GUI automation utility")
    (description
      "AutoKey is a desktop automation utility for X11.  It allows the automation of
virtually any task by responding to typed abbreviations and hotkeys.  It
offers a full-featured GUI (GTK and QT versions) that makes it highly
accessible for novices, as well as a scripting interface offering the full
flexibility and power of the Python language.")
    (license license:gpl3+)))

(define-public kalamine
  (package
    (name "kalamine")
    (version "0.38")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "kalamine" version))
       (sha256
        (base32 "0dj0v4in6jngh7f5ypvxyadjsilbiwxj3rx6yxxmh5zab6dxzyhz"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'make-test-layouts
            (lambda _
              (apply invoke
                     (cons* "python" "-m" "kalamine.cli" "build"
                            (find-files "layouts" "\\.toml")))
              (invoke "python" "-m" "kalamine.cli" "new" "test.toml"))))))
    (propagated-inputs
     (list python-click
           python-livereload
           python-lxml
           python-progress
           python-pyyaml
           python-tomli))
    ;; TODO: Add python-pytest-ruff to native-inputs once it has been
    ;; packaged.
    (native-inputs
     (list python-hatchling python-mypy python-pytest))
    (home-page "https://github.com/OneDeadKey/kalamine")
    (synopsis "Keyboard layout maker")
    (description
     "Kalamine provides a CLI to create advanced keyboard layout from a
textual portable description.  It also supports layout emulation via web
browser.")
    (license license:expat)))

(define-public python-dm-tree
  (package
    (name "python-dm-tree")
    (version "0.1.8")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "dm-tree" version))
              (sha256
               (base32 "0c4l9gpaqd7j34qwnpjibv53j9sm0nyl0wcy8dvh76772jxspjhg"))))
    (build-system pyproject-build-system)
    ;; We link the static abseil libraries here to avoid problems in
    ;; downstream libraries using potentially different variants of
    ;; abseil-cpp.  This is also what's done in the upstream CMake build.
    (inputs (list pybind11 static-abseil-cpp python))
    (propagated-inputs (list python-wheel
                             python-absl-py
                             python-attrs
                             python-numpy
                             python-wrapt))
    (arguments
     (list #:tests? #f
           #:phases
           #~(modify-phases %standard-phases
               (add-before 'build 'build-shared-lib
                 (lambda _
                   (let* ((pybind11   #$(this-package-input "pybind11"))
                          (python     #$(this-package-input "python"))
                          (version    (python-version python))
                          (abseil-cpp #$(this-package-input "abseil-cpp")))
                     ;; Delete default cmake build.
                     (substitute* "setup.py"
                       (("ext_modules.*") "")
                       (("cmdclass.*") ""))
                     ;; Actual build phase.
                     (mkdir-p "build/temp/tree/")
                     (invoke
                      "gcc" "-pthread" "-Wno-unused-result" "-Wsign-compare"
                      "-DNDEBUG" "-g" "-fwrapv" "-O3" "-Wall"
                      "-fno-semantic-interposition" "-fPIC"
                      "-I" (string-append pybind11
                                          "/lib/python" version
                                          "/site-packages/pybind11/include")
                      "-I" (string-append python "/include/python"
                                          version)
                      "-I" (string-append abseil-cpp "/include")
                      "-c" "tree/tree.cc"
                      "-o" "build/temp/tree/tree.o"
                      "-fvisibility=hidden" "-g0")
                     (mkdir-p "build/lib/tree")
                     (invoke
                      "g++" "-pthread" "-shared"
                      (string-append "-Wl," "-rpath=" python "/lib")
                      "-fno-semantic-interposition"
                      "build/temp/tree/tree.o"
                      "-L" (string-append python "/lib")
                      (string-append abseil-cpp "/lib/libabsl_int128.a")
                      (string-append abseil-cpp "/lib/libabsl_raw_hash_set.a")
                      (string-append abseil-cpp "/lib/libabsl_raw_logging_internal.a")
                      (string-append abseil-cpp "/lib/libabsl_strings.a")
                      (string-append abseil-cpp "/lib/libabsl_strings_internal.a")
                      (string-append abseil-cpp "/lib/libabsl_throw_delegate.a")
                      "-o" "build/lib/tree/_tree.so")))))))
    (home-page "https://github.com/deepmind/tree")
    (synopsis "Work with nested data structures in Python")
    (description "Tree is a python library for working with nested data
structures.  In a way, @code{tree} generalizes the builtin @code{map} function
which only supports flat sequences, and allows you to apply a function to each
leaf preserving the overall structure.")
    (license license:asl2.0)))

(define-public python-pyment
  (package
    (name "python-pyment")
    (version "0.3.4")
    (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://github.com/dadadel/pyment")
           (commit (string-append "v" version))))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0gbx9wmqsxdx85v5sg79lv2zxmy16j5dwi8bip07i1nyvzc5gvn0"))))
    (build-system python-build-system)
    (native-inputs (list python-pytest))
    (home-page "https://github.com/dadadel/pyment/")
    (synopsis "Convert Python docstrings automatically")
    (description "Pyment is a command line tool and library that can be
used to convert between several docstring styles.")
    (license license:gpl3+)))

(define-public python-docstring-parser
  (package
    (name "python-docstring-parser")
    (version "0.15")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "docstring_parser" version))
              (sha256
               (base32
                "10pnbg2q0ic1h6pwbyhhqd075fv67sq07k3gjncmi1mix29w1pa8"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-poetry-core python-pytest))
    (home-page "https://github.com/rr-/docstring_parser")
    (synopsis "Parse Python docstrings in reST, Google and Numpydoc format")
    (description "This package lets you parse Python docstrings in reST,
Google and Numpydoc format.")
    (license license:expat)))

(define-public python-docutils
  (package
    (name "python-docutils")
    (version "0.19")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "docutils" version))
              (sha256
               (base32
                "1rprvir116g5rz2bgzkzgyn6mv0z8582rz7bgxbpy2y3adkmm69k"))))
    (build-system python-build-system)
    (arguments
     '(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (if tests?
                          (invoke "python" "test/alltests.py")
                          (format #t "test suite not run~%")))))))
    (home-page "https://docutils.sourceforge.net/")
    (synopsis "Python Documentation Utilities")
    (description
     "Docutils is a modular system for processing documentation into useful
formats, such as HTML, XML, and LaTeX.  It uses @dfn{reStructuredText}, an
easy to use markup language, for input.

This package provides tools for converting @file{.rst} files to other formats
via commands such as @command{rst2man}, as well as supporting Python code.")
    ;; Most of the source code is public domain, but some source files are
    ;; licensed under the PFSL, BSD 2-clause, and GPLv3+ licenses.
    (license (list license:public-domain license:psfl license:bsd-2 license:gpl3+))))

;; awscli refuses to be built with docutils < 0.16.
(define-public python-docutils-0.15
  (package
    (inherit python-docutils)
    (version "0.15")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "docutils" version))
              (sha256
               (base32
                "0ja8q6mdj6xv62jjw3phv8j5nfqi5x8hnfy4pqfcjcgz4b34k8sl"))))
    ;; tests contain Python 2 syntax.
    (arguments '(#:tests? #false))
    (native-inputs
     (list python-setuptools-57))))

(define-public python-docx
  (package
    (name "python-docx")
    (version "1.1.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "python_docx" version))
              (sha256
               (base32
                "1z9ffsvksaaxr90ijzq4k3adzb6p5ipy2j3rrbfjl05rjlpg5w8c"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list behave
           python-pyparsing
           python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-lxml python-typing-extensions))
    (home-page "https://github.com/python-openxml/python-docx/")
    (synopsis "Python library to create and modify Microsoft Word documents")
    (description "This Python library can be used to create and update
Microsoft Word (.docx) documents.")
    (license license:expat)))

(define-public python-repoze-lru
  (package
    (name "python-repoze-lru")
    (version "0.7")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "repoze.lru" version))
       (sha256
        (base32 "0xzz1aw2smy8hdszrq8yhnklx6w1r1mf55061kalw3iq35gafa84"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-coverage python-nose python-setuptools python-wheel))
    (home-page "https://www.repoze.org")
    (synopsis "Tiny LRU cache implementation and decorator")
    (description
     "This package provides a tiny LRU cache implementation and decorator.")
    (license license:bsd-4)))

(define-public python-restructuredtext-lint
  (package
    (name "python-restructuredtext-lint")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "restructuredtext-lint" version))
       (sha256
        (base32
         "026rdy5h82ng4vqxk8fnprii9d6qxf7hkygiv0a8afjvdlsxmcwp"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (delete 'check)
         (add-after 'install 'check
           (lambda* (#:key inputs outputs tests? #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               (invoke "nosetests" "-v"))
             #t)))))
    (propagated-inputs
     (list python-docutils))
    (native-inputs
     (list python-nose))
    (home-page "https://github.com/twolfson/restructuredtext-lint")
    (synopsis "Linter")
    (description "This package provides a linter for the reStructuredText
format.")
    (license license:unlicense)))

(define-public python-click-repl
  (package
    (name "python-click-repl")
    (version "0.2.0")
    (source
     (origin
       (method git-fetch)               ; no tests in PyPI release
       (uri (git-reference
             (url "https://github.com/click-contrib/click-repl")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "16ybsnwlj2jlqcfxflky8jz7i3nhrd3f6mvkpgs95618l8lx994i"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key inputs outputs tests? #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               (invoke "python" "-m" "pytest")))))))
    (native-inputs
     (list python-pytest))
    (propagated-inputs
     (list python-click python-prompt-toolkit python-six))
    (home-page "https://github.com/untitaker/click-repl")
    (synopsis "REPL plugin for Click")
    (description "This package provides a REPL plugin for Click.")
    (license license:expat)))

(define-public python-pygdbmi
  (package
    (name "python-pygdbmi")
    (version "0.11.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pygdbmi" version))
       (sha256
        (base32 "1c0z4snkjiyl1iq4m1k6liwg0b4pdv2as4bfyvcm0mpjzki6na3s"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/cs01/pygdbmi")
    (synopsis "Parse gdb machine interface output with Python")
    (description "This package provides a parse gdb machine interface output
with Python.")
    (license license:expat)))

(define-public python-pygments
  (package
    (name "python-pygments")
    (version "2.15.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "Pygments" version))
       (sha256
        (base32
         "0p3p28fif7m2w5mkd0z99zk9xwgrs3m61x85415qk0fl3ly4vkla"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; Some tests require sphinx, which depends on this, so we only run
      ;; basic tests.
      '(list "--ignore-glob=tests/*/*")))
    (native-inputs
     (list python-pytest python-setuptools python-wheel))
    (home-page "https://pygments.org/")
    (synopsis "Syntax highlighting")
    (description
     "Pygments is a syntax highlighting package written in Python.")
    (license license:bsd-2)))

(define-public python-vdf
  (package
    (name "python-vdf")
    (version "3.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "vdf" version))
       (sha256
        (base32
         "1bz2gn04pl6rj2mawlzlirz1ygg4rdypq0pxbyg018873vs1jm7x"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-setuptools python-wheel))
    (home-page "https://github.com/ValvePython/vdf")
    (synopsis "Work with Valve's VDF text format")
    (description "This package provides @code{python-vdf}, a library for
working with Valve's VDF text format.")
    (license license:expat)))

(define-public python-pygments-github-lexers
  (package
    (name "python-pygments-github-lexers")
    (version "0.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pygments-github-lexers" version))
       (sha256
        (base32
         "0cz14clcc9z4pn79ll8hp3xzgsrfjscak5zfsvlgrz6ngkkmgjma"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-pygments))
    (home-page "https://github.com/liluo/pygments-github-lexers")
    (synopsis "Pygments Github custom lexers")
    (description "This package installs Github custom lexers to Pygments.")
    (license license:bsd-3)))

(define-public python-pygtrie
  (package
    (name "python-pygtrie")
    (version "2.5.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pygtrie" version))
              (sha256
               (base32
                "1qm4xdmzd4q5pc9h5gjdpr5m7lg06k8dvqnjn7d07d3fhani8d90"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/mina86/pygtrie")
    (synopsis "Pure Python trie data structure implementation")
    (description
     "This package provides a pure Python trie data structure implementation.")
    (license license:asl2.0)))

(define-public python-bump2version
  (package
    (name "python-bump2version")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "bump2version" version))
       (sha256
        (base32 "1rinm4gv1fyh7xjv3v6r1p3zh5kl4ry2qifz5f7frx31mnzv4b3n"))))
    (build-system python-build-system)
    (arguments
     ;; XXX: Tests fail with "bumpversion: error: the following arguments are
     ;; required: --new-version".
     `(#:tests? #false))
    (home-page "https://github.com/c4urself/bump2version")
    (synopsis "Version-bump your software with a single command!")
    (description
     "This package provides a small command line tool to simplify releasing
software by updating all version strings in your source code by the correct
increment.  It also creates commits and tags.")
    (license license:expat)))

(define-public python-bumpversion
  (package
    (name "python-bumpversion")
    (version "0.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "bumpversion" version))
       (sha256
        (base32
         "0zn7694yfipxg35ikkfh7kvgl2fissha3dnqad2c5bvsvmrwhi37"))))
    (build-system python-build-system)
    (home-page "https://github.com/peritus/bumpversion")
    (synopsis "Tool to bump software version")
    (description "This tool provides a command-line interface (CLI) to bump a
software version simply.")
    (license license:expat)))

(define-public python-deprecated
  (package
    (name "python-deprecated")
    (version "1.2.14")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tantale/deprecated")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0knjsacv0r4gyz6ngjn3ih6352yz05r63ll73y2cg162bzcak48z"))))
    (build-system pyproject-build-system)
    (propagated-inputs
     (list python-wrapt))
    (native-inputs
     (list python-bumpversion python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/tantale/deprecated")
    (synopsis "Python decorator to deprecate classes, functions or methods")
    (description "The @code{deprecated} decorator provides a convenient way to deprecate
to deprecate classes, functions or methods.")
    (license license:expat)))

(define-public python-pygithub
  (package
    (name "python-pygithub")
    (version "1.55")
    (source
     ;; We fetch from the Git repo because there are no tests in the PyPI
     ;; archive.
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/PyGithub/PyGithub")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "082bxffpy4h97dsay3l75cpgfjj10kywkvicnm6xscwvah285q9y"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest"))
             #t)))))
    (propagated-inputs
     (list python-cryptography python-deprecated python-pyjwt
           python-pynacl python-requests))
    (native-inputs
     (list nss-certs-for-test python-httpretty python-pytest))
    (home-page "https://pygithub.readthedocs.io/en/latest/")
    (synopsis "Python library for the GitHub API")
    (description "This library allows managing GitHub resources such as
repositories, user profiles, and organizations in your Python applications,
using version 3 of the GitHub application programming interface (API).")
    (license license:lgpl3+)))

(define-public python-rellu
  (package
    (name "python-rellu")
    (version "0.7")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "rellu" version))
       (sha256
        (base32
         "1w0arpj1sm7vh29nrbnca4pnp8sx42l07r17inwqcjjf9bhng66x"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-invoke python-pygithub))
    (home-page "https://github.com/robotframework/rellu")
    (synopsis "Utilities to create PyPI releases")
    (description "This collection of utilities contains tooling and templates
to assist in creating releases on GitHub and publishing them on PyPI.  It is
designed to be used by Robot Framework and tools and libraries in its
ecosystem, but can naturally be used also by other projects.")
    (license license:asl2.0)))

(define-public python-robotframework
  (package
    (name "python-robotframework")
    (version "5.0.1")
    ;; There are no tests in the PyPI archive.
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/robotframework/robotframework")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0jjr71npzrm5mv16pya3m2dqaqgf6sc45yca5kfmc5lfislig5b8"))
       (patches (search-patches
                 "python-robotframework-atest.patch"
                 "python-robotframework-source-date-epoch.patch"))))
    (build-system python-build-system)
    (arguments
     (list
      #:modules '((guix build python-build-system)
                  (guix build utils)
                  (ice-9 ftw)
                  (ice-9 match)
                  (srfi srfi-26))
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'delete-problematic-tests
            (lambda _
              ;; Tests such as 'Tilde and username in path' rely on HOME and
              ;; USER being set, on top of the user's /etc/passwd home
              ;; directory not being '/', as is the case in the Guix build
              ;; container.
              (delete-file "atest/robot/standard_libraries/\
operating_system/path_expansion.robot")))
          (add-before 'build 'build-and-install-doc
            (lambda* (#:key outputs #:allow-other-keys)
              (let ((doc (string-append (assoc-ref outputs "doc")
                                        "/share/doc/robotframework")))
                (invoke "invoke" "library-docs" "all")
                (invoke "doc/userguide/ug2html.py" "dist") ;user guide
                (mkdir-p doc)
                (with-directory-excursion "dist"
                  (define user-guide-dir
                    (match (scandir "." (cut string-prefix?
                                             "robotframework-userguide-" <>))
                      ((dir) dir)
                      (_ (error "could not find the user guide directory"))))
                  (copy-recursively user-guide-dir doc)))))
          (replace 'check
            (lambda* (#:key native-inputs inputs tests?
                      #:allow-other-keys)
              (when tests?
                ;; Some tests require timezone data.  Otherwise, they
                ;; look up /etc/localtime, which doesn't exist, and
                ;; fail with:
                ;;
                ;; OverflowError: mktime argument out of range
                (setenv "TZDIR"
                        (search-input-directory
                         (or native-inputs inputs) "share/zoneinfo"))
                (setenv "TZ" "Europe/Paris")

                (format #t "Running unit tests...~%")
                (invoke "utest/run.py")

                (format #t "Running acceptance tests...~%")
                (invoke "xvfb-run" "atest/run.py")))))))
    (native-inputs
     (list python-docutils
           python-jsonschema
           python-invoke
           python-lxml
           python-pygments
           python-pyyaml
           python-rellu
           `(,python "tk")              ;used when building the HTML doc
           python-xmlschema
           scrot                        ;for taking screenshots
           tzdata-for-tests
           xvfb-run))
    (outputs '("out" "doc"))
    (home-page "https://robotframework.org")
    (synopsis "Generic automation framework")
    (description "Robot Framework is a generic automation framework for
acceptance testing, acceptance test driven development (ATDD), and robotic
process automation (RPA).")
    (license license:asl2.0)))

(define-public python-robotframework-datadriver
  (package
    (name "python-robotframework-datadriver")
    (version "1.11.2")
    (source
     (origin
       (method git-fetch)               ; no tests in PyPI release
       (uri (git-reference
             (url "https://github.com/Snooz82/robotframework-datadriver")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0fq6ykbnypirw1wrgigsfzg8lv8g7j9gs46v0n814ycw8906n43x"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'skip-problematic-tests
            (lambda _
              (for-each delete-file-recursively
                        (list
                            ;; The test file 'tab-csv-file-name.tsv' contains
                            ;; special characters for which there is no locale
                            ;; in the build environment, causing one test to
                            ;; fail.
                            "atest/TestCases/csv_reader_config"
                            ;; Error in file on line 6: Non-existing setting
                            ;; 'Test Tags'.
                            "atest/TestCases/DataTypes/Types_in_dicts.robot"))))
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (with-directory-excursion "atest"
                  (invoke "sh" "run_atest.sh"))))))))
    (native-inputs
     (list python-docutils
           python-robotframework-stacktrace
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-openpyxl
           python-pandas
           python-pygments
           python-robotframework))
    (home-page "https://github.com/Snooz82/robotframework-datadriver")
    (synopsis "Data-driven test extension for Robot Framework")
    (description "DataDriver is a data-driven extension for Robot Framework.
DataDriver uses the Listener Interface of Robot Framework to create new test
cases based on a data file that contains the test data.  DataDriver supports
data files in the CSV, XLS or XLSX formats.")
    (license license:asl2.0)))

(define-public python-robotframework-lint
  ;; There is no properly tagged release; the commit below seems to correspond
  ;; to the 0.9 stable release available from PyPI.  The tests are not
  ;; included in the PyPI archive, so we fetch the sources from the upstream
  ;; Git repo.
  (let ((commit "b0619ac58a8b1be125f9c98856a664594614570f")
        (revision "0"))
    (package
      (name "python-robotframework-lint")
      (version (git-version "1.1"      ;version taken from 'rflint/version.py'
                            revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/boakley/robotframework-lint")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "180npmvzqync25b2scs878gv8q4y17dsinxyjcc10bw22msfap6b"))))
      (build-system python-build-system)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (replace 'check
             (lambda _
               (invoke "python" "-m" "robot" "-A"
                       "tests/conf/default.args" "tests"))))))
      (propagated-inputs
       (list python-robotframework))
      (home-page "https://github.com/boakley/robotframework-lint/")
      (synopsis "Static analysis tool (linter) for Robot Framework")
      (description "This package provides the @code{rflint} command-line
utility, a static analysis tool (linter) for Robot Framework source files.")
      (license license:asl2.0))))

(define-public python-robotframework-pabot
  (package
    (name "python-robotframework-pabot")
    (version "2.7.0")
    (source
     (origin
       ;; There are no tests in the PyPI archive.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/mkorpela/pabot")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0246vvyaxax0nzlrffvp9vg6mh5jmvbbm87azignf0gakjidr7nn"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases #~(modify-phases %standard-phases
                   (replace 'check
                     (lambda* (#:key tests? #:allow-other-keys)
                       (when tests?
                         (invoke "pytest" "-vv" "tests")))))))
    (propagated-inputs
     (list python-robotframework python-robotframework-stacktrace))
    (native-inputs
     (list python-pytest))
    (home-page "https://pabot.org")
    (synopsis "Parallel test runner for Robot Framework")
    (description "Pabot is a parallel executor for Robot Framework tests.")
    (license license:asl2.0)))

(define-public python-sshtunnel
  (package
    (name "python-sshtunnel")
    (version "0.4.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "sshtunnel" version))
              (sha256
               (base32
                "1z7rdgpp9m36ysh9pfzrn3vyiaj05bkjvcjdhj8vz0fvfjkhxjz7"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests? (invoke "pytest" "-vv" "tests")))))))
    (propagated-inputs (list python-paramiko))
    (native-inputs (list openssh python-pytest python-mock))
    (home-page "https://github.com/pahaz/sshtunnel")
    (synopsis "Python SSH tunnels library")
    (description "@code{sshtunnel} is a Python module for easily creating SSH
tunnels in the background, using Python.")
    (license license:expat)))

(define-public python-robotframework-sshtunnellibrary
  (package
    (name "python-robotframework-sshtunnellibrary")
    (version "1.0.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/C-Squad/robotframework-sshtunnellibrary")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1vkkmkb8iql13xpbyj4hvnnmfgzqlr8rffgryp2082cadb3w7xrd"))))
    (build-system python-build-system)
    (arguments
     (list #:phases #~(modify-phases %standard-phases
                        (replace 'check
                          (lambda* (#:key tests? #:allow-other-keys)
                            (when tests?
                              (invoke "python" "-m" "unittest"
                                      "discover" "-s" "test")))))))
    (propagated-inputs (list python-robotframework python-sshtunnel))
    (home-page "https://github.com/C-Squad/robotframework-sshtunnellibrary")
    (synopsis "Alternative RobotFramework library for SSH tunnels")
    (description "SSHTunnelLibrary is an alternative RobotFramework
library (to the more official one that comes from the
@code{robotframework-sshlibrary} package) to support SSH tunnels.")
    (license license:asl2.0)))

(define-public python-robotframework-stacktrace
  (package
    (name "python-robotframework-stacktrace")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "robotframework-stacktrace" version))
       (sha256
        (base32 "19gnwr7da1zz9clhwsmvqfjf02d195i61lzpq4253dcsgrpb6v79"))))
    (build-system python-build-system)
    (arguments
     ;; The test suite fails (see:
     ;; https://github.com/MarketSquare/robotframework-stacktrace/issues/4).
     `(#:tests? #f
       #:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (with-directory-excursion "tests"
                 (invoke "python" "-m" "robot" "."))))))))
    (propagated-inputs (list python-robotframework))
    (home-page "https://github.com/MarketSquare/robotframework-stacktrace")
    (synopsis "Robot Framework listener to print a stack trace on error")
    (description "StackTrace is a Robot Framework listener that prints a stack
trace directly to the terminal to ease debugging.")
    (license license:asl2.0)))

(define-public python-robotframework-sshlibrary
  (package
    (name "python-robotframework-sshlibrary")
    (version "3.8.0")
    ;; There are no tests in the PyPI archive.
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/robotframework/SSHLibrary")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1fn72hw7xacjjpl4dd6wynh2x63i9rk8iqhj3v640db21qpcnbkw"))
       (patches (search-patches
                 "python-robotframework-sshlibrary-rf5-compat.patch"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'build 'build-and-install-doc
           (lambda* (#:key outputs #:allow-other-keys)
             (let ((doc (string-append
                         (assoc-ref outputs "doc")
                         "/share/doc/robotframework-sshlibrary")))
               (invoke "chmod" "-R" "+w" "docs")
               (invoke "invoke" "kw-docs" "project-docs")
               (mkdir-p doc)
               (for-each delete-file (find-files "docs" "\\.rst"))
               (copy-recursively "docs" doc))))
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               ;; Some tests require an SSH server; we remove them.
               (delete-file "utest/test_client_api.py")
               (delete-file "utest/test_scp.py")
               (invoke "python" "utest/run.py")))))))
    (propagated-inputs
     (list python-robotframework python-paramiko python-scp))
    (native-inputs
     (list openssh
           which
           ;; To generate the documentation
           python-docutils
           python-invoke
           python-pygments
           python-rellu))
    (outputs '("out" "doc"))
    (home-page "https://github.com/robotframework/SSHLibrary")
    (synopsis "Robot Framework library for SSH and SFTP")
    (description "SSHLibrary is a Robot Framework library providing support
for SSH and SFTP.  It has the following main usages:
@itemize @bullet
@item Executing commands on the remote machine, either blocking or non-blocking.
@item Writing and reading in an interactive shell.
@item Transferring files and directories over SFTP.
@item Ensuring that files and directories exist on the remote machine.
@end itemize")
    (license license:asl2.0)))

(define-public python-robotframework-pythonlibcore
  (package
    (name "python-robotframework-pythonlibcore")
    (version "3.0.0")
    (source
     (origin
       (method git-fetch)               ;no tests in pypi archive
       (uri (git-reference
             (url "https://github.com/robotframework/PythonLibCore")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0v89v8va65l6inh0fb34qgxawx6p29pnrmw4n5941yzdi3804rc4"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (when tests?
                        (invoke "utest/run.py")))))))
    (native-inputs
     (list python-pytest python-pytest-cov python-pytest-mockito
           python-robotframework))
    (home-page "https://github.com/robotframework/PythonLibCore")
    (synopsis "Robot Framework Python library tools")
    (description "PythonLibCore provides tools for creating larger test
libraries for Robot Framework using Python.  The Robot Framework hybrid and
dynamic library APIs give more flexibility for library than the static library
API, but they also set requirements for libraries which need to be implemented
in the library side.  PythonLibCore eases the problem by providing a simpler
interface and by handling all the requirements towards the Robot Framework
library APIs.")
    (license license:asl2.0)))

(define-public python-robotframework-seleniumlibrary
  (package
    (name "python-robotframework-seleniumlibrary")
    (version "5.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "robotframework-seleniumlibrary" version))
       (sha256
        (base32 "1dihrbcid9i7daw2qy6h3xsvwaxzmyip820jw5z11n60qrl006pm"))))
    (build-system python-build-system)
    ;; XXX: Tests require ungoogled-chromium, but the chromium module would
    ;; introduce a cycle if imported here.
    (propagated-inputs
     (list python-robotframework python-robotframework-pythonlibcore
           python-selenium))
    (home-page "https://github.com/robotframework/SeleniumLibrary")
    (synopsis "Web testing library for Robot Framework")
    (description "SeleniumLibrary is a web testing library for Robot Framework
that utilizes the Selenium tool internally.")
    (license license:asl2.0)))

(define-public python-robotframework-seleniumscreenshots
  (package
    (name "python-robotframework-seleniumscreenshots")
    (version "0.9.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "robotframework-seleniumscreenshots" version))
       (sha256
        (base32 "05qv323hvjmy62h33ryrjaa9k1hyvp8hq5qnj8j1x3ap2ci3q3s0"))))
    (build-system python-build-system)
    (arguments
    ;; XXX: The tests require a relatively complicated setup configured in
    ;; their CI with Nix (!).
     `(#:tests? #f))
    (propagated-inputs
     (list python-robotframework python-robotframework-seleniumlibrary))
    (home-page "https://github.com/MarketSquare/robotframework-seleniumscreenshots")
    (synopsis "Robot Framework library for annotating and cropping screenshots")
    (description "The SeleniumScreenshots library for Robot Framework provides
keywords for annotating and cropping screenshots taken with SeleniumLibrary.
It is useful for scripting automatically updated screenshots for documentation
or for visual regression testing purposes.")
    (license license:bsd-3)))

(define-public python-rstr
  (package
   (name "python-rstr")
   (version "2.2.6")
   (source
    (origin
     (method url-fetch)
     (uri (pypi-uri "rstr" version))
     (sha256
      (base32
       "197dw8mbq0pjjz1l6h1ksi62vgn7x55d373ch74y06744qiq5sjx"))))
   (build-system python-build-system)
   (home-page "https://github.com/leapfrogonline/rstr")
   (synopsis "Generate random strings in Python")
   (description "This package provides a python module for generating
random strings of various types.  It could be useful for fuzz testing,
generating dummy data, or other applications.  It has no dependencies
outside the standard library.")
   (license license:bsd-3)))

(define-public python-scp
  (package
    (name "python-scp")
    (version "0.13.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "scp" version))
       (sha256
        (base32 "1m2v09m407p097cy3xy5rxicqfzrqjwf8v5rd4qhfqkk7lllimwb"))))
    (build-system python-build-system)
    (arguments
     '(#:tests? #f))                     ;tests require an SSH server
    (propagated-inputs
     (list python-paramiko))
    (home-page "https://github.com/jbardin/scp.py")
    (synopsis "SCP protocol module for Python and Paramiko")
    (description "The scp module extends the Paramiko library to send and
receive files via the SCP1 protocol, as implemented by the OpenSSH
@command{scp} program.")
    (license license:gpl2+)))

(define-public python-rst.linker
  (package
    (name "python-rst.linker")
    (version "1.11")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "rst.linker" version))
       (sha256
        (base32 "0pqsfqqx8h0pq21k8l3k62kznrgaj2ala93c64s4d9rpbr4mgkd2"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-dateutil python-six))
    (native-inputs
     (list python-setuptools-scm))
    ;; Test would require path.py, which would introduce a cyclic dependence.
    (arguments `(#:tests? #f))
    ;; Note: As of version 1.7 the documentation is not worth building.
    (home-page "https://github.com/jaraco/rst.linker")
    (synopsis "Sphinx plugin to add links and timestamps")
    (description "rst.linker automatically replaces text by a
reStructuredText external reference or timestamps.  It's primary purpose is to
augment the changelog, but it can be used for other documents, too.")
    (license license:expat)))

(define-public python-sshpubkeys
  (package
    (name "python-sshpubkeys")
    (version "3.1.0")
    (home-page "https://github.com/ojarva/python-sshpubkeys")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url home-page)
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1h4gwmcfn84kkqh83km1vfz8sc5kr2g4gzgzmr8gz704jmqiv7nq"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-cryptography python-ecdsa))
    (synopsis "OpenSSH public key parser")
    (description
     "This package provides a library for parsing and validating OpenSSH
public key files.")
    (license license:bsd-3)))

(define-public python-feedgenerator
  (package
    (name "python-feedgenerator")
    (version "1.9")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "feedgenerator" version))
       (sha256
        (base32
         "01mirwkm7xfx539hmvj7g9da1j51gw5lsx74dr0glizskjm5vq2s"))
       (modules '((guix build utils)))
       (snippet
        '(begin
           ;; Remove pre-compiled .pyc files from source.
           (for-each delete-file-recursively
                     (find-files "." "__pycache__" #:directories? #t))
           (for-each delete-file (find-files "." "\\.pyc$"))
           #t))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-pytz python-six))
    (home-page "https://github.com/getpelican/feedgenerator")
    (synopsis
     "Standalone version of Django's Atom/RSS feed generator")
    (description
     "Feedgenerator-py3k is a standalone version of Django's feedgenerator,
which can produce feeds in RSS 2.0, RSS 0.91, and Atom formats.")
    (license license:bsd-3)))

(define-public python-lsp-jsonrpc
  (package
    (name "python-lsp-jsonrpc")
    (version "1.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "python-lsp-jsonrpc" version))
       (sha256
        (base32
         "04n95h0cqnsrdyh1gv0abh2i5ynyrq2wfqpppx9djp7mxr9y9226"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-coverage
           python-pycodestyle
           python-pyflakes
           python-pylint
           python-pytest
           python-pytest-cov
           python-setuptools
           python-setuptools-scm
           python-wheel))
    (propagated-inputs
     (list python-ujson))
    (home-page "https://github.com/python-lsp/python-lsp-jsonrpc")
    (synopsis "JSON RPC 2.0 server library")
    (description
     "This package provides a JSON RPC 2.0 server library for Python.")
    (license license:expat)))

(define-public python-jsonrpc-server
  (deprecated-package "python-jsonrpc-server" python-lsp-jsonrpc))

(define-public python-pydantic
  (package
    (name "python-pydantic")
    (version "1.10.19")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/samuelcolvin/pydantic")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0swcpfq1y0h5dcj82idls8k5la4xh4c0vz47y7jci2qass8gjffc"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; One test fails with  not equal assertion.
      #~(list "--deselect=tests/test_validators.py::test_assert_raises_validation_error")))
    (native-inputs
     (list python-pytest
           python-pytest-mock
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-typing-extensions))
    (home-page "https://github.com/samuelcolvin/pydantic")
    (synopsis "Python data validation and settings management")
    (description
     "Pydantic enforces type hints at runtime, and provides user friendly
errors when data is invalid.")
    (license license:expat)))

(define-public python-pydantic-2
  (package
    (inherit python-pydantic)
    (name "python-pydantic")
    (version "2.10.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pydantic" version))
       (sha256
        (base32 "01jg4ll2py05izm7s9hlv5xbxcsp26bvb2585gzf8vfs4fbjxwc2"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "--ignore=tests/test_docs.py"   ; no pytest_examples
              ;; These tests include hashes that keep changing depending on
              ;; package versions.
              "--ignore=tests/benchmarks/test_north_star.py"
              ;; Unimportant difference in one test's error message.
              "--ignore=tests/test_networks.py")
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'pre-check
            (lambda _
              ;; Remove the addopts from pyproject.toml, it breaks the 'check
              ;; phase.
              (substitute* "pyproject.toml"
                (("'--benchmark") "#'--benchmark")
                ;; Do not fail on deprecation warnings.
                (("ignore:path is deprecated.*:DeprecationWarning:")
                 "ignore::DeprecationWarning")))))))
    (native-inputs
     (list tzdata-for-tests
           python-dirty-equals
           python-hatch-fancy-pypi-readme
           python-hatchling
           python-jsonschema
           python-pytest
           python-pytest-benchmark
           python-pytest-mock))
    (propagated-inputs
     (list python-annotated-types
           python-pydantic-core
           python-rich
           python-typing-extensions))))

(define-public python-pydantic-core
  (package
    (name "python-pydantic-core")
    (version "2.27.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pydantic_core" version))
       (sha256
        (base32 "0fgv3xdn4n7a606sjz8b15cnzyqy3pspycvjc1r0bvhz9id6w0pb"))))
    (build-system cargo-build-system)
    (arguments
     (list
      #:imported-modules `(,@%cargo-build-system-modules
                           ,@%pyproject-build-system-modules)
      #:modules '((guix build cargo-build-system)
                  ((guix build pyproject-build-system) #:prefix py:)
                  (guix build utils))
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'build 'build-python-module
            (assoc-ref py:%standard-phases 'build))
          (add-after 'build-python-module 'install-python-module
            (assoc-ref py:%standard-phases 'install)))
      #:cargo-inputs
      `(("rust-ahash" ,rust-ahash-0.8)
        ("rust-base64" ,rust-base64-0.21)
        ("rust-enum-dispatch" ,rust-enum-dispatch-0.3)
        ("rust-idna" ,rust-idna-0.5)
        ("rust-jiter" ,rust-jiter-0.7)
        ("rust-num-bigint" ,rust-num-bigint-0.4)
        ("rust-python3-dll-a" ,rust-python3-dll-a-0.2)
        ("rust-pyo3" ,rust-pyo3-0.20)
        ("rust-pyo3-build-config" ,rust-pyo3-build-config-0.20)
        ("rust-regex" ,rust-regex-1)
        ("rust-strum" ,rust-strum-0.25)
        ("rust-strum-macros" ,rust-strum-macros-0.25)
        ("rust-serde" ,rust-serde-1)
        ("rust-serde-json" ,rust-serde-json-1)
        ("rust-smallvec" ,rust-smallvec-1)
        ("rust-speedate" ,rust-speedate-0.15)
        ("rust-url" ,rust-url-2)
        ("rust-uuid" ,rust-uuid-1)
        ("rust-version-check" ,rust-version-check-0.9))
      #:cargo-development-inputs
      `(("rust-pyo3" ,rust-pyo3-0.20))
      #:install-source? #false))
    (native-inputs
     (list maturin python-typing-extensions python-wrapper))
    (propagated-inputs
     (list python-typing-extensions))
    (home-page "https://github.com/pydantic/pydantic-core")
    (synopsis "Core validation logic for pydantic")
    (description "This package provides the core functionality for pydantic
validation and serialization.")
    (license license:expat)))

(define-public python-pydantic-cli
  (package
    (name "python-pydantic-cli")
    (version "4.3.0")
    (source
     (origin
       (method git-fetch)               ;for tests
       (uri (git-reference
             (url "https://github.com/mpkocher/pydantic-cli")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1v4dx6n60rbsan5zpw2rgdih7lb3h0xclagn1p6zfwl0r9l9cvym"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-pydantic))
    (native-inputs
     (list python-black
           python-mypy
           python-pytest))
    (home-page "https://github.com/mpkocher/pydantic-cli")
    (synopsis "Turn Pydantic defined data models into CLI tools")
    (description
     "@code{python-pydantic} enables specifying @acronym{CLI, Command Line
Interfaces} via data models provided in the JSON format.")
    (license license:expat)))

(define-public python-pydantic-settings
  (package
    (name "python-pydantic-settings")
    (version "2.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pydantic_settings" version))
       (sha256
        (base32 "14zcbl32m53zfh054bkqk4jcjp72q1wa0w5z5wygnjz66nnwmj8h"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "-k" (string-append
                    ;; Disable tests requiring python-ruff.
                    "not test_docs_examples[docs/index.md:24-83]"
                    " and not test_docs_examples[docs/index.md:113-137]"
                    " and not test_docs_examples[docs/index.md:148-156]"
                    " and not test_docs_examples[docs/index.md:173-183]"
                    " and not test_docs_examples[docs/index.md:193-201]"
                    " and not test_docs_examples[docs/index.md:212-243]"
                    " and not test_docs_examples[docs/index.md:286-317]"
                    " and not test_docs_examples[docs/index.md:331-372]"
                    " and not test_docs_examples[docs/index.md:430-439]"
                    " and not test_docs_examples[docs/index.md:453-459]"
                    " and not test_docs_examples[docs/index.md:514-522]"
                    " and not test_docs_examples[docs/index.md:547-549]"
                    " and not test_docs_examples[docs/index.md:553-585]"
                    " and not test_docs_examples[docs/index.md:620-645]"
                    " and not test_docs_examples[docs/index.md:654-732]"
                    " and not test_docs_examples[docs/index.md:738-772]")
              "--ignore=tests/test_docs.py")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'relax-requirements
            (lambda _
              (substitute* "pyproject.toml"
                ;; hatchling.build failed on this line with error:
                ;; ValueError: Unknown classifier in field
                ;; `project.classifiers`: Framework :: Pydantic :: 2
                (("'Framework :: Pydantic :: 2',") "")
                ;; python-dotenv>=0.21.0
                ((">=0.21.0") ">=0.20.0"))))
          (add-before 'check 'set-home
            (lambda _
              ;; FileNotFoundError: [Errno 2] No such file or directory:
              ;; '/homeless-shelter/
              (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list python-dotenv python-pydantic-2))
    (native-inputs
     (list python-hatchling
           python-pytest
           python-pytest-examples
           python-pytest-mock))
    (home-page "https://docs.pydantic.dev/latest/usage/pydantic_settings/")
    (synopsis "Settings management using Pydantic")
    (description
     "Pydantic Settings provides optional Pydantic features for loading a
settings or config class from environment variables or secrets files.")
    (license license:expat)))

(define-public python-pydoc-markdown
  (package
    (name "python-pydoc-markdown")
    (version "4.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pydoc_markdown" version))
       (sha256
        (base32 "02vzlrd18r8wi0b64vq2gnbhaadysg9rnbylf9sf2v9q65z94v7v"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #false ;there are none
      #:phases
      '(modify-phases %standard-phases
         ;; This is probably not a good idea, but it wants a rather old
         ;; version of docstring-parser.
         (add-after 'unpack 'relax-requirements
           (lambda _
             (substitute* "pyproject.toml"
               (("docstring-parser = .*")
                "docstring-parser = \"^0\"\n")))))))
    (propagated-inputs (list python-click
                             python-databind-core
                             python-databind-json
                             python-docspec
                             python-docspec-python
                             python-docstring-parser
                             python-jinja2
                             python-nr-util
                             python-pyyaml
                             python-requests
                             python-tomli
                             python-tomli-w
                             python-watchdog
                             python-yapf))
    (native-inputs (list python-poetry-core))
    (home-page "https://pypi.org/project/pydoc-markdown/")
    (synopsis "Create Python API documentation in Markdown format")
    (description "Pydoc-Markdown is a tool to create Python API documentation
in Markdown format.  Instead of executing your Python code like so many other
documentation tools, it parses it using docspec instead.")
    (license license:expat)))

;; XXX: The project is deprecated upstream, still in use by some packages,
;; consider to remove when nothing depends on it.
(define-public python-pydocstyle
  (package
    (name "python-pydocstyle")
    (version "6.3.0")
    (source
     (origin
       (method git-fetch)               ;no tests in PyPI archive
       (uri (git-reference
             (url "https://github.com/PyCQA/pydocstyle")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1aabvnxmy939y5b7jpnygpnkgbi4id9j461v7bwzxwdmdffnnd1j"))
       (patches (search-patches
                 "python-pydocstyle-add-support-for-pep701.patch"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; It tries to install with pip.
      #:test-flags #~(list "--ignore=src/tests/test_integration.py")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'set-version
            (lambda _
              (substitute* "pyproject.toml"
                (("0.0.0-dev") #$version)))))))
    (native-inputs
     (list python-poetry-core
           python-pytest
           python-tomli))
    (propagated-inputs
     (list python-six
           python-snowballstemmer))
    (home-page "https://github.com/PyCQA/pydocstyle/")
    (synopsis "Python docstring style checker")
    (description
     "This package provides a style checker for the Python Language
Server (PLS).")
    (license license:expat)))

(define-public python-lsp-server
  (package
    (name "python-lsp-server")
    (version "1.12.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "python_lsp_server" version))
       (sha256
        (base32
         "0fq5vkwkvn29rwf5l19iicmj913franc6q8ymjdvs0ys53qkd8xn"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      '(list "-c" "/dev/null"           ;avoid coverage
             "-k"
             (string-append
              "not test_pyqt_completion " ;avoid pyqt5
              ;; This test fails with "AssertionError: assert 'isabs(s)' ==
              ;; 'commonprefix(m)'" (see:
              ;; https://github.com/python-lsp/python-lsp-server/issues/602).
              "and not test_jedi_completion_with_fuzzy_enabled"))
      #:phases
      '(modify-phases %standard-phases
         (add-before 'check 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list python-docstring-to-markdown
           python-importlib-metadata
           python-jedi
           python-lsp-jsonrpc
           python-pluggy
           python-pycodestyle
           python-pydocstyle
           python-ujson
           python-whatthepatch
           python-yapf))
    (native-inputs
     (list python-autopep8
           python-flake8
           python-flaky
           python-matplotlib
           python-numpy
           python-pandas
           python-pylint
           python-pytest
           python-rope
           python-setuptools
           python-setuptools-scm
           python-wheel))
    (home-page "https://github.com/python-lsp/python-lsp-server")
    (synopsis "Python implementation of the Language Server Protocol")
    (description
     "The Python Language Server @command{pylsp} is an implementation of the
Python 3 language specification for the Language Server Protocol (LSP).
This tool is used in text editing environments to provide a complete
and integrated feature-set for programming Python effectively.")
    (license license:expat)))

(define-public python-language-server
  (deprecated-package "python-language-server" python-lsp-server))

(define-public python-black
  (package
    (name "python-black")
    (version "24.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "black" version))
       (sha256
        (base32
         "0xa8vkgbvmkdh4vsk967xh81i6g47fcqf5vngdkvrqxgjx6acvl4"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; On the build farm we run out of resources if we let the build system
      ;; autodetect the number of parallel processes.
      '(list "--numprocesses" (number->string (min (parallel-job-count) 8)))
      #:phases
      '(modify-phases %standard-phases
         (add-after 'patch-source-shebangs 'use-absolute-file-names
           (lambda* (#:key inputs #:allow-other-keys)
             (substitute* (find-files "tests" "\\.py$")
               (("#!/usr/bin/env python3")
                (string-append
                 "#!" (search-input-file inputs "/bin/python3")))))))))
    (propagated-inputs
     (list python-click
           python-mypy-extensions
           python-packaging
           python-pathspec
           python-platformdirs
           python-tomli
           python-typing-extensions))
    (native-inputs
     (list python-pytest
           python-pytest-aiohttp
           python-pytest-xdist
           python-hatch-fancy-pypi-readme
           python-hatch-vcs
           python-hatchling))
    (home-page "https://github.com/psf/black")
    (synopsis "The uncompromising code formatter")
    (description "Black is the uncompromising Python code formatter.")
    (license license:expat)))

(define-public python-black-macchiato
  (package
    (name "python-black-macchiato")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "black-macchiato" version))
       (sha256
        (base32
         "1drp5p697ni1xn5y2lbjpalgpkzy2i4cyxjj5pk4dxr0vk97dd7i"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-black))
    (home-page "https://github.com/wbolster/black-macchiato")
    (synopsis "Partial @code{python-black} formatting")
    (description
     "This package is built on top the @{python-black} code formatter to
enable formatting of partial files.")
    (license license:bsd-3)))

(define-public python-blinker
  (package
    (name "python-blinker")
    (version "1.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "blinker" version))
       (sha256
        (base32
         "1gs5aigi8v8k4cymm06gdgaylv5yps6yk5n8gigf9v5blxjj5kml"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-flit-core
           python-pytest
           python-pytest-asyncio))
    (home-page "https://pythonhosted.org/blinker/")
    (synopsis "Fast, simple object-to-object and broadcast signaling")
    (description
     "Blinker provides a fast dispatching system that allows any number of
interested parties to subscribe to events, or \"signals\".")
    (license license:expat)))

(define-public pelican
  (package
    (name "pelican")
    (version "4.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pelican" version))
       (sha256
        (base32 "0m1kndc98hhnlq0yl05f4lzccw555pkxnrajj6lks18yh491kw8w"))))
    (build-system python-build-system)
    (inputs
     (list python-blinker
           python-dateutil
           ;; Ignoring `guix lint` warning as python-docutils is used to support
           ;; reStructuredText processing at runtime.
           python-docutils
           python-feedgenerator
           python-jinja2
           python-markdown
           python-pygments
           python-pytz
           python-rich
           python-unidecode))
    (home-page "https://blog.getpelican.com/")
    (arguments
     `(;; XXX Requires a lot more packages to do unit tests :P
       #:tests? #f))
    (synopsis "Python-based static site publishing system")
    (description
     "Pelican is a tool to generate a static blog from reStructuredText,
Markdown input files, and more.  Pelican uses Jinja2 for templating
and is very extensible.")
    (license license:agpl3+)))

(define-public mallard-ducktype
  (package
    (name "mallard-ducktype")
    (version "1.0.2")
    (source
     (origin
       (method git-fetch)
       ;; git-reference because tests are not included in pypi source tarball
       ;; https://issues.guix.gnu.org/issue/36755#2
       (uri (git-reference
             (url "https://github.com/projectmallard/mallard-ducktype")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1jk9bfz7g04ip78s03b0xak6d54rj4h9zpgadkziy1ji216g6y4c"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (with-directory-excursion "tests"
               (invoke "sh" "runtests")))))))
    (home-page "http://projectmallard.org")
    (synopsis "Convert Ducktype to Mallard documentation markup")
    (description
     "Ducktype is a lightweight syntax that can represent all the semantics
of the Mallard XML documentation system.  Ducktype files can be converted to
Mallard using the @command{ducktype} tool.  The yelp-tools package
provides additional functionality on the produced Mallard documents.")
    (license license:expat)))

(define-public python-cykhash
  (package
    (name "python-cykhash")
    (version "2.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "cykhash" version))
       (sha256
        (base32 "1xwpxff4whfvkwvcyhzhdcj5zzq89vvdjmnqy664s4a9yp4lnydl"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-cython
                         python-setuptools
                         python-wheel))
    (home-page "https://github.com/realead/cykhash")
    (synopsis "Khash-sets and maps")
    (description
     "This package is a Cython wrapper for khash-sets/maps.  It brings
functionality of
@url{https://github.com/attractivechaos/klib/blob/master/khash.h, khash} to
Python and Cython and can be used seamlessly in numpy or pandas.  Numpy's
world is lacking the concept of a (hash-)set.  This shortcoming is fixed and
efficient (memory- and speedwise compared to pandas) @code{unique} and
@code{isin} are implemented.  Python-set/dict have a big memory-footprint.
For some datatypes the overhead can be reduced by using khash by factor 4-8.")
    (license license:expat)))

(define-public python-cython
  (package
    (name "python-cython")
    (version "0.29.32")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "Cython" version))
       (sha256
        (base32 "1xqsihpqnfal29nb5kmw8z71nd4jbsnbz7p3lkr094xpb13wycw7"))))
    (build-system python-build-system)
    ;; we need the full python package and not just the python-wrapper
    ;; because we need libpython3.3m.so
    (inputs
     (list python))
    (native-inputs
     ;; Needed for some tests that link against it.
     (list libxcrypt))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'check 'set-HOME
           ;; some tests require access to "$HOME/.cython"
           (lambda _ (setenv "HOME" "/tmp")))
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             ;; Disable compiler optimizations to greatly reduce the running
             ;; time of the test suite.
             (setenv "CFLAGS" "-O0")

             (when tests?
               (invoke "python" "runtests.py" "-vv"
                       "-j" (number->string (parallel-job-count))
                       ;; XXX: On 32-bit architectures, running the parallel tests
                       ;; fails on many-core systems, see
                       ;; <https://github.com/cython/cython/issues/2807>.
                       ,@(if (not (target-64bit?))
                             '("-x" "run.parallel")
                             '())
                       ,@(if (system-hurd?)
                             '("-x" "test_class_ref"
                               "-x" "test_compiler_directives"
                               "-x" "test_lang_version")
                             '())
                       ;; This test fails when running on 24 cores.
                       "-x" "cpp_stl_conversion")))))))
    (home-page "https://cython.org/")
    (synopsis "C extensions for Python")
    (description "Cython is an optimising static compiler for both the Python
programming language and the extended Cython programming language.  It makes
writing C extensions for Python as easy as Python itself.")
    (license license:asl2.0)))

;; Needed for scipy
(define-public python-cython-0.29.35
  (package
    (inherit python-cython)
    (name "python-cython")
    (version "0.29.35")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "Cython" version))
              (sha256
               (base32
                "09y5r22nyswqpwc02agla1bnzh2jx2db25pnq9pc5cq8pyh1yf3f"))))
    (properties '())))

(define-public python-cython-3
  (package
    (inherit python-cython)
    ;; Cython 3 is not officially released yet, so distinguish the name
    ;; for now.
    (name "python-cython-next")
    (version "3.0.11")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "cython" version))
              (sha256
               (base32
                "1zzsn60cl1qcz11h6c3miqayb7yfxdm1x19i2fk4qav8z0mdsiki"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "-vv"
              "-j" (number->string (parallel-job-count))
              "-x" (string-join
                    (list "annotate_html"
                          "Debugger"
                          ;; It introduces cycle.
                          "numpy_test"
                          ;; It fails with AssertionError: Failed doctest test
                          ;; for complex_numbers_cpp.double_abs.
                          "complex_numbers_cpp"
                          ;; This test fails when running on 24 cores.
                          "cpp_stl_conversion"
                          ;; XXX: On 32-bit architectures, running the
                          ;; parallel tests fails on many-core systems, see
                          ;; <https://github.com/cython/cython/issues/2807>.
                          #$@(if (not (target-64bit?))
                                 '("run.parallel")
                                 '())
                          #$@(if (system-hurd?)
                                 '("test_class_ref"
                                   "test_compiler_directives"
                                   "test_lang_version")
                                 '()))
                    "|"))
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? test-flags #:allow-other-keys)
              ;; Disable compiler optimizations to greatly reduce the running
              ;; time of the test suite.
              (setenv "CFLAGS" "-O0")
              ;; Some tests require access to "$HOME/.cython".
              (setenv "HOME" "/tmp")
              (when tests?
                (apply invoke "python" "runtests.py" test-flags)))))))
    (native-inputs
     (list libxcrypt
           python-setuptools
           python-wheel))
    (properties '())))

;; NOTE: when upgrading numpy please make sure that python-numba,
;; python-pandas and python-scipy still build, as these three packages are
;; often used together.
(define-public python-numpy
  (package
    (name "python-numpy")
    ;; XXX: Any other versions up to 1.26.4 failed to build with error similar
    ;; to: 'fenv_t' has not been declared in '::' 58 | using ::fenv_t;
    ;; See <https://github.com/numpy/numpy/issues/21075#issuecomment-1047976197>,
    ;; <https://github.com/numpy/numpy/issues/24318>.
    (version "1.24.4")
    (source
     (origin
       (method url-fetch)
       (uri (string-append
             "https://github.com/numpy/numpy/releases/download/v"
             version "/numpy-" version ".tar.gz"))
       (sha256
        (base32
         "0qwldmkq5bns561ppkz7psphc4jqfj5j1x4dhq0i8r4qwjjf7xc0"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:modules '((guix build utils)
                  (guix build pyproject-build-system)
                  (ice-9 format))
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'parallelize-build
            (lambda _
              (setenv "NPY_NUM_BUILD_JOBS"
                      (number->string (parallel-job-count)))))
          (add-before 'build 'configure-blas
            (lambda* (#:key inputs #:allow-other-keys)
              (call-with-output-file "site.cfg"
                (lambda (port)
                  (format port
                          "\
[openblas]
libraries = openblas
library_dirs = ~a/lib
include_dirs = ~:*~a/include~%"
                          (dirname (dirname
                                    (search-input-file
                                     inputs "include/openblas_config.h"))))))))
          (add-before 'build 'fix-executable-paths
            (lambda* (#:key inputs #:allow-other-keys)
              ;; Make /gnu/store/...-bash-.../bin/sh the default shell,
              ;; instead of /bin/sh.
              (substitute* "numpy/distutils/exec_command.py"
                (("'/bin/sh'")
                 (format #f "~s" (search-input-file inputs "bin/bash"))))
              ;; Don't try to call '/bin/true' specifically.
              (substitute* "numpy/core/tests/test_cpu_features.py"
                (("/bin/true") (search-input-file inputs "bin/true")))))
          (replace 'check
            (lambda* (#:key tests? outputs inputs #:allow-other-keys)
              (when tests?
                (invoke "./runtests.py" "-vv" "--no-build" "--mode=fast"
                        "-j" (number->string (parallel-job-count))
                        ;; Contrary to scipy, the runtests.py script of numpy
                        ;; does *not* automatically provide -n when -j is used
                        ;; (see: https://github.com/numpy/numpy/issues/21359).
                        "--" "-n" (number->string (parallel-job-count))
                        ;; Disable Pytest Warnings, they are resolved in the
                        ;; latest 1.x.x: pytest.PytestRemovedIn9Warning: Marks
                        ;; applied to fixtures have no effect,
                        ;; DeprecationWarning.
                        "-p" "no:warnings"
                        "-k" (string-append
                              ;; These tests may fail on 32-bit systems (see:
                              ;; https://github.com/numpy/numpy/issues/18387).
                              "not test_float_remainder_overflow "
                              "and not test_pareto "
                              ;; The 'test_rint_big_int' test fails on older
                              ;; x86_64 CPUs such as the Core 2 Duo (see:
                              ;; https://github.com/numpy/numpy/issues/22170).
                              "and not test_rint_big_int "
                              ;; They fail to detect compiler.
                              "and not test_compile1 "
                              "and not test_compile2 "
                              ;; Due to disabled warnings
                              "and not test_getattr_warning "
                              "and not test_integer_signs "
                              "and not test_implicit_cast_float_to_int_fails "
                              "and not test_integer_signs "
                              ;; The huge_array test is too large for 32-bit (see:
                              ;; https://bugs.gentoo.org/843599 and
                              ;; https://bugs.gentoo.org/846548).
                              ;; TestKind.test_all is a Fortran type failure
                              ;; that may be toolchain or environment related.
                              #$@(if (or (target-x86?) (target-arm32?))
                                     `(" and not test_identityless_reduction_huge_array"
                                       " and not (TestKind and test_all)")
                                   '())
                              ;; This test fails when building from aarch64-linux.
                              #$@(if (target-arm32?)
                                   `(" and not test_features")
                                   '())
                              ;; These tests seem to fail on machines without
                              ;; an FPU is still under investigation upstream.
                              ;; https://github.com/numpy/numpy/issues/20635
                              #$@(if (target-riscv64?)
                                   `(" and not test_float"
                                     " and not test_fpclass")
                                   '())))))))))
    (native-inputs
     (list gfortran
           meson-python
           pkg-config
           python-cython ;; overwrite Cython from meson-python
           python-hypothesis
           python-mypy
           python-pytest
           python-pytest-xdist
           python-setuptools
           python-typing-extensions
           python-wheel))
    (inputs (list bash openblas))
    (home-page "https://numpy.org")
    (synopsis "Fundamental package for scientific computing with Python")
    (description "NumPy is the fundamental package for scientific computing
with Python.  It contains among other things: a powerful N-dimensional array
object, sophisticated (broadcasting) functions, tools for integrating C/C++
and Fortran code, useful linear algebra, Fourier transform, and random number
capabilities.")
    (properties
     '((upstream-name . "numpy")))
    (license license:bsd-3)))

(define-public python-numpy-2
  (package
    (inherit python-numpy)
    (name "python-numpy")
    (version "2.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (string-append
             "https://github.com/numpy/numpy/releases/download/v"
             version "/numpy-" version ".tar.gz"))
       (sha256
        (base32
         "13sdvwiqn85vw1dn1k1nd5ihadv82zhqm615imrqgmil33v0csgd"))))
    (arguments
     (list
      ;; TODO: Tests fail on setup, there is some issue with vendored-meson.
      #:tests? #f 
      #:modules '((guix build utils)
                  (guix build pyproject-build-system)
                  (ice-9 format))
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-executable-paths
            (lambda _
              (substitute* "numpy/distutils/exec_command.py"
                (("'/bin/sh'")
                 (format #f "~s" (which "bash"))))))
          (add-before 'build 'parallelize-build
            (lambda _
              (setenv "OMP_NUM_THREAD"
                      (number->string (parallel-job-count)))
              (setenv "NPY_NUM_BUILD_JOBS"
                      (number->string (parallel-job-count)))))
          ;; XXX: It fails with an issue "'fenv_t' has not been declared..."
          ;; when the gfortran header is used.  Remove gfortran from
          ;; CPLUS_INCLUDE_PATH as a workaround.  Taken from
          ;; <https://issues.guix.gnu.org/73439#45>.
          (add-after 'set-paths 'hide-gfortran
            (lambda* (#:key inputs #:allow-other-keys)
              (let ((gfortran (assoc-ref inputs "gfortran")))
                (setenv "CPLUS_INCLUDE_PATH"
                        (string-join
                         (delete (string-append gfortran "/include/c++")
                                 (string-split (getenv "CPLUS_INCLUDE_PATH") #\:))
                         ":")))))
          (add-before 'build 'configure-blas
            (lambda* (#:key inputs #:allow-other-keys)
              (call-with-output-file "site.cfg"
                (lambda (port)
                  (format port
                          "[openblas]
libraries = openblas
library_dirs = ~a/lib
include_dirs = ~:*~a/include~%" #$(this-package-input "openblas")))))))))
    (native-inputs
     (list gfortran
           meson-python
           ninja
           pkg-config
           python-hypothesis
           python-mypy
           python-pytest
           python-pytest-xdist
           python-setuptools
           python-setuptools
           python-typing-extensions
           python-wheel))))

(define-public python-numpy-documentation
  (package
    (inherit python-numpy)
    (name "python-numpy-documentation")
    (arguments
     (list
      #:tests? #f                     ;we're only generating the documentation
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'add-gnu-freefont-to-texmf
            (lambda _
              ;; XXX: The Sphinx-generated tex output specifies the GNU
              ;; FreeFont font to be searched via its extension, which uses
              ;; kpathsea instead of fontconfig and fail (see:
              ;; https://github.com/sphinx-doc/sphinx/issues/10347).  Create a
              ;; symlink to GNU FreeFont and add it to the TEXMF tree via
              ;; GUIX_TEXMF.
              (mkdir-p "texmf-dist/fonts/opentype/public")
              (symlink (string-append
                        #$(this-package-native-input "font-gnu-freefont")
                        "/share/fonts/opentype")
                       (string-append
                        (getcwd) "/"
                        "texmf-dist/fonts/opentype/public/gnu-freefont"))
              (setenv "GUIX_TEXMF" (string-append (getenv "GUIX_TEXMF") ":"
                                                  (getcwd) "/texmf-dist"))))
          (delete 'build)
          (replace 'install
            (lambda _
              (let* ((data (string-append #$output "/share"))
                     (doc (string-append data "/doc/numpy"))
                     (html (string-append doc "/html"))
                     (info (string-append data "/info"))
                     (sphinxopts (string-append
                                  "SPHINXOPTS=-j"
                                  (number->string (parallel-job-count)))))
                (with-directory-excursion "doc"
                  ;; Do not treat warnings as errors.
                  (substitute* "Makefile"
                    ((" -WT ") " -T "))
                  (setenv "HOME" "/tmp")
                  ;; Build the PDF documentation.
                  (invoke "make" "latex-build" sphinxopts)
                  (invoke "make" "-C" "build/latex" "all-pdf" sphinxopts)
                  ;; Build the HTML documentation
                  (invoke "make" "html" sphinxopts)
                  ;; Build the Info documentation.  The issues worked around
                  ;; below can be tracked at
                  ;; https://github.com/numpy/numpy/issues/12278.
                  (substitute* "source/conf.py"
                    ;; The root document should be "index", not "contents".
                    (("\"contents\"") "'index'")
                    ;; Disable Sphinx extensions that produce broken Texinfo.
                    ((".*'numpydoc'.*") "")
                    ((".*'sphinx.ext.autosummary'.*") ""))
                  (invoke "make" "info" sphinxopts)
                  ;; Install the HTML documentation.
                  (mkdir-p html)
                  (copy-recursively "build/html" html)
                  ;; Install the PDF reference and user manuals.
                  (install-file "build/latex/numpy-ref.pdf" doc)
                  (install-file "build/latex/numpy-user.pdf" doc)
                  ;; Install the info manual.
                  (install-file "build/texinfo/numpy.info" info)
                  (symlink (string-append html "/_images")
                           (string-append info "/numpy-figures")))))))))
    (native-inputs
     (list font-gnu-freefont
           perl
           python-breathe
           python-ipython
           python-matplotlib
           python-numpy
           python-numpydoc
           python-pandas
           python-pydata-sphinx-theme
           python-scipy                 ;used by matplotlib
           python-sphinx-4
           python-sphinx-panels
           texinfo
           (texlive-updmap.cfg
            (list texlive-cbfonts
                  texlive-cm-super
                  texlive-expdlist
                  texlive-greek-fontenc
                  texlive-latexmk
                  texlive-polyglossia
                  texlive-xetex
                  texlive-xindy))))
    (inputs '())
    (propagated-inputs '())
    (synopsis "Documentation for the @code{python-numpy} package")
    (description "This package provides the complete NumPy documentation in
the Texinfo, HTML, and PDF formats.")))

(define-public python-npx
  (package
    (name "python-npx")
    (version "0.1.6")
    (source
     (origin
       (method git-fetch)               ; no source archive in PyPI
       (uri (git-reference
             (url "https://github.com/sigma-py/npx")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0a3rb3ydl13m1r48kdvnbi31566jxm10p36argkz5kjr2ilkrx8v"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-networkx
           python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-numpy))
    (home-page "https://github.com/nschloe/npx")
    (synopsis "Extensions for NumPy")
    (description "NumPy is a large library used everywhere in scientific
computing.  That's why breaking backwards-compatibility comes at a
significant cost and is almost always avoided, even if the API of some
methods is arguably lacking.  This package provides drop-in wrappers
\"fixing\" those.")
    (license license:bsd-3)))

(define-public python-munch
  (package
    (name "python-munch")
    (version "4.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "munch" version))
       (sha256
        (base32
         "0d928bdzm0d9s9f058xa72pywps2zjdgvhrp9rm22qqj8r8v2b2l"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-astroid
           python-pytest
           python-setuptools
           python-wheel))
    (home-page "https://github.com/Infinidat/munch")
    (synopsis "Dot-accessible dictionary")
    (description "Munch is a dot-accessible dictionary similar to JavaScript
objects.")
    (license license:expat)))

(define-public python-colormath
  (package
    (name "python-colormath")
    (version "3.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "colormath" version))
       (sha256
        (base32
         "05qjycgxp3p2f9n6lmic68sxmsyvgnnlyl4z9w7dl9s56jphaiix"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-networkx python-numpy))
    (home-page "https://github.com/gtaylor/python-colormath")
    (synopsis "Color math and conversion library")
    (description
     "This is a Python library for color math and conversions.")
    (license license:bsd-3)))

(define-public python-sparse
  (package
    (name "python-sparse")
    (version "0.15.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "sparse" version))
       (sha256
        (base32
         "0rp29gp82qwwkq210pzh2qmlqhi2007nb7p7nwqmrkgmjq6cwxjc"))))
    (build-system pyproject-build-system)
    (propagated-inputs
     (list python-numba python-numpy python-scipy))
    (native-inputs
     (list python-dask
           python-pytest
           python-pytest-cov
           python-setuptools
           python-setuptools-scm-next
           python-wheel))
    (home-page "https://github.com/pydata/sparse/")
    (synopsis "Library for multi-dimensional sparse arrays")
    (description
     "This package implements sparse arrays of arbitrary dimension on top of
@code{numpy} and @code{scipy.sparse}.  Sparse array is a matrix in which most
of the elements are zero.  @code{python-sparse} generalizes the
@code{scipy.sparse.coo_matrix} and @code{scipy.sparse.dok_matrix} layouts, but
extends beyond just rows and columns to an arbitrary number of dimensions.
Additionally, this project maintains compatibility with the
@code{numpy.ndarray} interface rather than the @code{numpy.matrix} interface
used in @code{scipy.sparse}.  These differences make this project useful in
certain situations where @code{scipy.sparse} matrices are not well suited, but
it should not be considered a full replacement.  It lacks layouts that are not
easily generalized like @dfn{compressed sparse row/column}(CSR/CSC) and
depends on @code{scipy.sparse} for some computations.")
    (license license:bsd-3)))

(define-public python-multiscale-spatial-image
  (package
    (name "python-multiscale-spatial-image")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "multiscale_spatial_image" version))
       (sha256
        (base32 "01kcagjy797hbz5an9cp8wcl5krgp21yb7ibfimvpidb3jp5lfhb"))))
    (build-system pyproject-build-system)
    ;; All interesting tests require file downloads over IPFS.
    (arguments (list #:tests? #false))
    (propagated-inputs
     (list `(,insight-toolkit "python")
           python-dask
           python-dask-image
           python-numpy
           python-spatial-image
           python-xarray
           python-xarray-datatree))
    (native-inputs
     (list python-fsspec
           python-hatchling
           python-ipfsspec
           python-jsonschema
           python-nbmake
           python-pooch
           python-pytest
           python-pytest-mypy
           python-urllib3
           python-zarr))
    (home-page "https://github.com/spatial-image/multiscale-spatial-image")
    (synopsis "Multi-dimensional spatial image data structure")
    (description
     "This package lets you generate a multiscale, chunked, multi-dimensional
spatial image data structure that can serialized to OME-NGFF.  Each scale is a
scientific Python Xarray spatial-image Dataset, organized into nodes of an
Xarray Datatree.")
    (license license:asl2.0)))

(define-public python-spectra
  (package
    (name "python-spectra")
    (version "0.0.11")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "spectra" version))
       (sha256
        (base32
         "1f322x914bhkg6r5gv1vmnir3iy0k5kih0fd2gp3rdkw32jn5cwf"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _ (invoke "nosetests" "-v"))))))
    (propagated-inputs
     (list python-colormath))
    (native-inputs
     (list python-nose))
    (home-page "https://github.com/jsvine/spectra")
    (synopsis "Color scales and color conversion")
    (description
     "This package provides a Python library intended to make color math,
color scales, and color space conversion easy.  It has support for:

@enumerate
@item Color scales
@item Color ranges
@item Color blending
@item Brightening/darkening colors
@item Saturating/desaturating colors
@item Conversion to/from multiple color spaces.
@end enumerate\n")
    (license license:expat)))

(define-public python-pyspnego
  (package
    (name "python-pyspnego")
    (version "0.8.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pyspnego" version))
              (sha256
               (base32
                "1ps34laa0kvvp33az173hp5l0hnk8cr0bfqmlgw64ry5cv09qjg0"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest python-pytest-mock python-setuptools python-wheel))
    (propagated-inputs
     (list python-cryptography python-gssapi python-krb5 python-ruamel.yaml))
    (home-page "https://github.com/jborean93/pyspnego")
    (synopsis "Python SPNEGO library")
    (description "The @code{pyspnego} Python library handles Negotiate, NTLM,
Kerberos (SPNEGO) and CredSSP authentication.  It also includes a packet
parser that can be used to decode raw NTLM/SPNEGO/Kerberos tokens into a human
readable format.")
    (license license:expat)))

(define-public python-pygit2
  (package
    (name "python-pygit2")
    (version "1.11.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pygit2" version))
       (sha256
        (base32 "1v34xdvh6i5cn5srwicvp0i2kvv8fzsv0v9p72ng081nsczmhgvr"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-cffi libgit2))
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/libgit2/pygit2")
    (synopsis "Python bindings for libgit2")
    (description "Pygit2 is a set of Python bindings to the libgit2 shared library.")
    ;; GPL2.0 only, with linking exception.
    (license license:gpl2)))

(define-public python-patiencediff
  (package
    (name "python-patiencediff")
    (version "0.2.15")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "patiencediff" version))
        (sha256
         (base32
          "012jjgkkpk563l1mgj2ax4z32h0l558adhr2qa3chfrfsgpi22fh"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases #~(modify-phases %standard-phases
                   ;; Fails because bin/patiencediff expects two files to diff
                   (delete 'sanity-check))))
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://www.breezy-vcs.org/")
    (synopsis "Python implementation of the patiencediff algorithm")
    (description
     "This package contains a Python implementation of the @code{patiencediff}
algorithm.  Patiencediff provides a good balance of performance, nice output for
humans, and implementation simplicity.")
    (license license:gpl2+)))

(define-public python-merge3
  (package
    (name "python-merge3")
    (version "0.0.15")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "merge3" version))
       (sha256
        (base32 "1brb97v24i5ym3cfxsv416a0m1n78s1aqllmwg4xymjdv09w5snk"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/breezy-team/merge3")
    (synopsis "Python implementation of 3-way merge")
    (description
     "This Python library implements 3-way merge for text.")
    (license license:gpl2+)))

(define-public python-wmctrl
  (package
    (name "python-wmctrl")
    (version "0.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "wmctrl" version))
       (sha256
        (base32
         "1q0l1sqnj5wma87k3dsgmsyph464syjc6fl8qcpa41nan1rgzjv6"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (add-after 'unpack 'patch-paths
                    (lambda* (#:key inputs #:allow-other-keys)
                      (let ((wmctrl (assoc-ref inputs "wmctrl")))
                        (substitute* "wmctrl.py"
                          (("'wmctrl")
                           (string-append "'" wmctrl "/bin/wmctrl")))))))))
    (inputs (list wmctrl))
    (propagated-inputs (list python-attrs))
    (home-page "https://github.com/antocuni/wmctrl")
    (synopsis "Tool to programmatically control Xorg windows")
    (description "This package provides a library for programmatically
controlling Xorg windows using Python.  The library relies on the
@command{wmctrl} to do so.")
    (license license:expat)))

(define-public python-fancycompleter
  (package
    (name "python-fancycompleter")
    (version "0.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "fancycompleter" version))
       (sha256
        (base32 "0wkj4h01pxa8prv59zl09a0i3w26k835bfpjgvyvsai4mswgxq09"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (add-after 'unpack 'fix-setup.py
                    (lambda _
                      (substitute* "setup.py"
                        ((".*setupmeta.*")
                         "")
                        (("versioning=.*")
                         (string-append "version='" ,version "',"))
                        ((".*pyrepl.*") ;broken on Python 3
                         "")))))))
    (home-page "https://github.com/pdbpp/fancycompleter")
    (synopsis "TAB completion library for Python")
    (description "@code{fancycompleter} is a module that adds TAB completion
to the interactive prompt.  It is an extension of the @code{rlcompleter}
module from the standard Python library.")
    (license license:bsd-3)))

(define-public python-ipdb
  (package
    (name "python-ipdb")
    (version "0.13.9")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ipdb" version))
       (sha256
        (base32 "1ibql99agjf2gj7y0svzd5m0h81hailf4p3sj3yl9i1i8ykdj6wm"))))
    (build-system python-build-system)
    (arguments
     (list #:phases #~(modify-phases %standard-phases
                        (replace 'check
                          (lambda* (#:key tests? #:allow-other-keys)
                            (when tests?
                              (invoke "python" "-m" "unittest" "discover")))))))
    (propagated-inputs (list python-ipython python-toml python-decorator))
    (home-page "https://github.com/gotcha/ipdb")
    (synopsis "IPython-enhanced Python debugger (pdb)")
    (description "@code{ipdb} exports functions to access the IPython
debugger, which features tab completion, syntax highlighting, better
tracebacks and better introspection than Python's standard @command{pdb}
debugger, with which it shares the same interface.")
    (license license:bsd-3)))

(define-public python-ipfsspec
  (package
    (name "python-ipfsspec")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ipfsspec" version))
       (sha256
        (base32 "1y4ad9schc76j2lynm7vpwi4q4jzi9vv843zfpisbp8zqgm0rr7l"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      '(list "-m not local_gw"
             ;; Require local gateway
             "--ignore=test/test_gateway.py"
             ;; Require internet
             "--ignore=test/test_async.py"
             "--ignore=test/test_ipfs.py")))
    (propagated-inputs (list python-aiohttp python-fsspec python-requests))
    (native-inputs
     (list python-pytest
           python-pytest-asyncio
           python-setuptools
           python-wheel))
    (home-page "https://github.com/fsspec/ipfsspec")
    (synopsis "Read-only implementation of fsspec for IPFS")
    (description "This package provides a read-only implementation of
@code{fsspec} for IPFS.")
    (license license:expat)))

(define-public python-pdftotext
  (package
    (name "python-pdftotext")
    (version "2.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pdftotext" version))
       (sha256
        (base32 "1555wbgr5spj8xflrs4mwsrdmba2f9s72nk50xzqk9ghxaxdvy6a"))))
    (build-system python-build-system)
    (inputs
     (list poppler))
    (home-page "https://github.com/jalan/pdftotext")
    (synopsis "Simple PDF text extraction")
    (description "Pdftotext is a Python library of PDF text extraction.")
    (license license:expat)))

(define-public python-pluginbase
  (package
    (name "python-pluginbase")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pluginbase" version))
       (sha256
        (base32
         "11z2vvbp13828y0x3w39f29p9r9xcix7h7c4fff2w8yfiylk6v7z"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (when tests?
                        (invoke "make" "test")))))))
    (native-inputs (list python-pytest))
    (home-page "https://github.com/mitsuhiko/pluginbase")
    (synopsis "Simple but flexible plugin system for Python")
    (description "PluginBase is a library useful in the development of
flexible plugin systems in Python.")
    (license license:bsd-3)))

(define-public python-node-semver
  (package
    (name "python-node-semver")
    (version "0.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "node-semver" version))
       (sha256
        (base32
         "000ypfns5x72b41w5f9pk6k3jnr35scliqfbvmilyvv0178005i8"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/podhmo/python-node-semver")
    (synopsis "Python port of node-semver")
    (description "This module provides a Python version of node-semver, a
semantic version parser for Node.js.")
    (license license:expat)))

(define-public python-norns
  (package
    (name "python-norns")
    (version "0.1.6")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "norns" version))
              (sha256
               (base32
                "1r1lcq59v6l75wkbp7mypanr69a6fv6m58v6dw3v6b4vwz5nqg0z"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-appdirs python-nose python-pyyaml
                             python-setuptools))
    (native-inputs (list python-wheel))
    (home-page "https://github.com/simonvh/norns")
    (synopsis "Simple YAML-based config module")
    (description "This package provides a simple YAML-based config module.")
    (license license:expat)))

(define-public python-patch-ng
  (package
    (name "python-patch-ng")
    (version "1.17.4")
    (source
     (origin
       (method git-fetch)               ;no tests in PyPI archive
       (uri (git-reference
             (url "https://github.com/conan-io/python-patch-ng")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0qxn4ss2s54qy87xrpcybz26kp2fwlaq41x4k9jcmp6d7p0w569m"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (when tests?
                        (invoke "tests/run_tests.py" "-v")))))))
    (home-page "https://github.com/conan-io/python-patch-ng")
    (synopsis "Python library to parse and apply unified diffs")
    (description "Patch NG (New Generation) is a command and Python library to
parse and apply unified diffs.  It has features such as:
@itemize
@item automatic correction of common patch formatting corruption
@item patch format detection (SVN, Hg, Git)
@item nice diffstat histogram.
@end itemize")
    (license license:expat)))

(define-public python-numpydoc
  (package
    (name "python-numpydoc")
    (version "1.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "numpydoc" version))
       (sha256
        (base32
         "0k2z3g4s3w39h1nd293542hl9qv55j29gcr3bkia0rr3ldsppnxh"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:test-flags
           '(list "numpydoc/tests"
                  ;; TODO: unclear why these fail.
                  "-k" "not test_MyClass and not test_my_function")))
    (propagated-inputs (list python-jinja2 python-sphinx))
    (native-inputs
     (list python-matplotlib
           python-pytest
           python-pytest-cov
           python-setuptools
           python-wheel))
    (home-page "https://pypi.org/project/numpydoc/")
    (synopsis "Numpy's Sphinx extensions")
    (description "Sphinx extension to support docstrings in Numpy format.")
    (license license:bsd-2)))

(define-public python-numexpr
  (package
    (name "python-numexpr")
    (version "2.9.0") ; starting from 2.10.0, NumPy 2+ is required
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "numexpr" version))
       (sha256
        (base32 "1w5ampdamlwj8ix1ipzxngmrlqpnmcmk95gbi6839kijqkv147gj"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'build-extensions
            (lambda _
              (invoke "python" "setup.py" "build_ext" "--inplace"))))))
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-numpy))
    (home-page "https://github.com/pydata/numexpr")
    (synopsis "Fast numerical expression evaluator for NumPy")
    (description
     "Numexpr is a fast numerical expression evaluator for NumPy.  With it,
expressions that operate on arrays are accelerated and use less memory than
doing the same calculation in Python.  In addition, its multi-threaded
capabilities can make use of all your cores, which may accelerate
computations, most specially if they are not memory-bounded (e.g. those using
transcendental functions).")
    (license license:expat)))

(define-public python-cycler
  (package
    (name "python-cycler")
    (version "0.10.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "cycler" version))
              (sha256
               (base32
                "1n69n23fak1gjxlrbhqisi2b9pv3ckrfj98llx3p53953082syyd"))))
    (build-system python-build-system)
    (arguments
     ;; XXX: The current version requires 'coveralls' which we don't have.
     ;; Enable this for the next release which uses 'python-pytest'.
     '(#:tests? #f))
    (propagated-inputs
     (list python-six))
    (home-page "https://matplotlib.org/cycler/")
    (synopsis "Composable keyword argument iterator")
    (description
     "When using @code{matplotlib} and plotting more than one line, it is
common to want to be able to want to be able to cycle over one or more artist
styles; but the plotting logic can quickly become involved.
To address this and enable easy cycling over arbitrary @code{kwargs}, the
@code{Cycler} class was developed.")
    (license license:bsd-3)))

(define-public python-colorspacious
  (package
    (name "python-colorspacious")
    (version "1.1.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/njsmith/colorspacious")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0x7nkphr6g5ql5fvgss8l56rgiyjgh6fm8zzs73i94ci9wzlm63w"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-numpy))
    (native-inputs
     (list python-nose))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "nosetests" "--all-modules" "-v" "colorspacious"))))))
    (home-page "https://github.com/njsmith/colorspacious")
    (synopsis "Python library for colorspace conversions")
    (description "@code{colorspacious} is a Python library that lets you
convert between colorspaces like sRGB, XYZ, CIEL*a*b*, CIECAM02, CAM02-UCS, etc.")
    (license license:expat)))

(define-public python-propcache
  (package
    (name "python-propcache")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "propcache" version))
       (sha256
        (base32 "0r4sq2j6s63wziw8fhnrx0lxlg8ch3z2i6a92ivm7jqridrcwxrz"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags '(list "--ignore=tests/test_benchmarks.py")
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'patch-build-system
           (lambda _
             ;; XXX: I don't know how to tell it to build the extensions in
             ;; place.
             (substitute* "packaging/pep517_backend/_backend.py"
               (("build_inplace=False") "build_inplace=True")))))))
    (native-inputs
     (list python-covdefaults
           python-cython-3
           python-expandvars
           python-pytest
           python-pytest-cov
           python-pytest-xdist
           python-setuptools
           python-tomli
           python-wheel))
    (home-page "https://github.com/aio-libs/propcache")
    (synopsis "Accelerated property cache")
    (description "The module provides a fast implementation of cached
properties for Python 3.9+.")
    (license license:asl2.0)))

(define-public python-proto-matcher
  (package
    (name "python-proto-matcher")
    (version "0.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "proto_matcher" version))
       (sha256
        (base32 "1644x0hrl398ji3281n44ymfgc3cspzfagjckhqjn4nja5nlikxg"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))                    ;no test suite
    (propagated-inputs
     (list python-protobuf python-pyhamcrest))
    (home-page "https://github.com/dayfine/proto-matcher")
    (synopsis "PyHamcrest test matchers for protocol buffers")
    (description "This package provides the following PyHamcrest test
matchers, that enable matching a protocol buffer message:
@table @code
@item equals_proto
Test the argument equals the given protobuf message.
@item approximately
Test the argument equals the given protobuf message, while comparing any float
field using approximation.
@item ignoring_field_paths
Test the argument equals the given protobuf message, while ignoring those
fields specified in the field paths.
@item ignoring_repeated_field_ordering
Test the argument equals the given protobuf message, ignoring the ordering of
any repeated field.
@item partially
Test the argument partially equals the given protobuf message, i.e. if a field
is in the argument but not in the expected message, it's ignored in the
comparison.
@end table")
    (license license:asl2.0)))

(define-public python-matplotlib
  (package
    (name "python-matplotlib")
    (version "3.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "matplotlib" version))
       (sha256
        (base32 "18amhxyxa6yzy1nwky4ggdgvvxnbl3qz2lki05vfx0dqf6w7ia81"))
       (patches (search-patches "python-matplotlib-fix-legend-loc-best-test.patch"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      '(list "-m" "not network"
        "-k" (string-join
              (list
               ;; This one fails with a small difference in the upper left.
               "not test_figure_legend_outside"
               "test_warn_big_data_best_loc"
               ;; The 'test_lazy_auto_backend_selection' fails because it
               ;; would require an X server; skip it.
               "test_lazy_auto_backend_selection"
               ;; It fails with deprecation warning The register_cmap function
               ;; was deprecated in Matplotlib 3.7 and will be removed two
               ;; minor releases later.
               "test_double_register_builtin_cmap"
               ;; Failed: DID NOT WARN. No warnings of type (<class
               ;; 'UserWarning'>,) were emitted.
               "test_rcparams_update"
               "test_rcparams_init"
               ;; ResourceWarning: unclosed file <_io.BufferedWriter
               ;; name='a.pdf'>
               "test_multipage_keep_empty"
               ;; UserWarning: Glyph 8722 (\N{MINUS SIGN}) missing from
               ;; current font.
               "test_mathtext_ticks")
              " and not "))
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'pretend-version
            ;; The version string is usually derived via setuptools-scm, but
            ;; without the git metadata available, the version string is set to
            ;; '0.0.0'.
            (lambda _
              (setenv "SETUPTOOLS_SCM_PRETEND_VERSION" #$version)))
          (add-after 'unpack 'fix-and-disable-failing-tests
            ;; XXX: Disable all image comparison tests because we're using a
            ;; newer version of FreeType than matplotlib expects.  This leads
            ;; to minor differences throughout the tests.
            (lambda _
              (substitute* (append (find-files "lib/matplotlib/tests/"
                                               "test_.*\\.py$")
                                   (find-files "lib/mpl_toolkits/tests"
                                               "test_.*\\.py$"))
                (("^from matplotlib" match)
                 (string-append "import pytest\n" match))
                (("( *)@([^_]+_)*(image_comparison|check_figures_equal)" match
                  indent)
                 (string-append indent "@pytest.mark.skip(\
reason=\"unknown minor image differences\")\n" match)))
              (substitute* "lib/matplotlib/tests/test_animation.py"
                (("/bin/sh") (which "sh")))
              (for-each delete-file
                        ;; test_normal_axes, test_get_tightbbox_polar
                        '("lib/matplotlib/tests/test_axes.py"
                          "lib/matplotlib/tests/test_polar.py"
                          ;; We don't use the webagg backend and this test
                          ;; forces it.
                          "lib/matplotlib/tests/test_backend_webagg.py"
                          ;; test_outward_ticks
                          "lib/matplotlib/tests/test_tightlayout.py"
                          ;; test_hidden_axes fails with minor extent
                          ;; differences, possibly due to the use of a
                          ;; different version of FreeType.
                          "lib/matplotlib/tests/test_constrainedlayout.py"
                          ;; Fontconfig returns no fonts.
                          "lib/matplotlib/tests/test_font_manager.py"
                          ;; The images comparison test fails
                          ;; non-deterministically when run in parallel (see:
                          ;; https://github.com/matplotlib/matplotlib/issues/22992).
                          "lib/matplotlib/tests/test_compare_images.py"))))
          (add-before 'build 'configure-environment
            (lambda* (#:key inputs #:allow-other-keys)
              ;; Fix rounding errors when using the x87 FPU.
              (when (string-prefix? "i686" #$(%current-system))
                (setenv "CFLAGS" "-ffloat-store"))
              (call-with-output-file "mplsetup.cfg"
                (lambda (port)
                  (format port "\
[libs]
system_freetype = true
system_qhull = true

[rc_options]
backend=Agg

[directories]
basedirlist = ~a,~a

[packages]
tests = True~%" #$(this-package-input "tcl") #$(this-package-input "tk"))))))
          (replace 'check
            (lambda* (#:key tests? test-flags #:allow-other-keys)
              (when tests?
                ;; Step out of the source directory to avoid interference.
                (with-directory-excursion "/tmp"
                  ;; Run the installed tests, which is what we want since not
                  ;; everything gets built in the source directory.
                  (apply invoke "pytest"
                         "-n" (number->string (parallel-job-count))
                         "--pyargs" "matplotlib"
                         test-flags))))))))
    (propagated-inputs
     (list python-contourpy
           python-cycler
           python-dateutil
           python-fonttools-minimal
           python-importlib-resources
           python-kiwisolver
           python-numpy
           python-packaging
           python-pillow
           python-pyparsing
           `(,python "tk")))
    (inputs
     (list cairo
           freetype
           glib
           libpng
           qhull
           tcl
           tk))
    (native-inputs
     (list pkg-config
           pybind11
           python-pytest
           python-pytest-timeout
           python-pytest-xdist
           python-setuptools
           python-setuptools-scm
           python-setuptools-scm-git-archive
           python-wheel))
    (home-page "https://matplotlib.org/")
    (synopsis "2D plotting library for Python")
    (description
     "Matplotlib is a Python 2D plotting library which produces publication
quality figures in a variety of hardcopy formats and interactive environments
across platforms.  Matplotlib can be used in Python scripts, the python and
ipython shell, web application servers, and six graphical user interface
toolkits.")
    (license license:psfl)))

(define-public python-matplotlib-documentation
  (package
    (inherit python-matplotlib)
    (name "python-matplotlib-documentation")
    (arguments
     (list
      #:tests? #f                       ;we're only generating documentation
      #:phases
      #~(modify-phases %standard-phases
          (replace 'build
            (lambda _
              (setenv "HOME" "/tmp")
              (chdir "doc")
              (substitute* "conf.py"
                ;; The sphinx_panels extension causes a "TypeError: first
                ;; argument must be callable" to be raised when generating the
                ;; info target; remove it (see:
                ;; https://github.com/executablebooks/sphinx-panels/issues/74).
                ((".*'sphinx_panels',.*") ""))
              (invoke "make" "html" "info"
                      ;; Don't abort on warnings; build in parallel.
                      (format #f "SPHINXOPTS=-j~a" (parallel-job-count)))))
          (replace 'install
            (lambda _
              (let* ((data (string-append #$output "/share"))
                     (doc (string-append data "/doc/matplotlib"))
                     (info (string-append data "/info"))
                     (html (string-append doc "/html")))
                (mkdir-p html)
                (copy-recursively "build/html" html)
                (install-file "build/texinfo/matplotlib.info" info)
                ;; The "matplotlib-figures" directory contains are a subset of
                ;; the images produced for the html target; simply create a
                ;; symlink to it, saving about 11 MiB.
                (symlink (string-append html "/_images")
                         (string-append info "/matplotlib-figures"))))))))
    (native-inputs
     (list graphviz
           inkscape/stable
           python-colorspacious
           python-ipython
           python-ipywidgets
           python-mpl-sphinx-theme
           python-numpydoc
           python-scipy
           python-sphinx
           python-sphinx-copybutton
           python-sphinx-gallery
           python-sphinxcontrib-svg2pdfconverter
           texinfo
           texlive-amsfonts
           texlive-amsmath
           texlive-babel
           texlive-etoolbox
           texlive-expdlist
           texlive-fontspec
           texlive-times
           texlive-type1cm
           texlive-underscore
           texlive-unicode-math))
    (synopsis "Documentation for the @code{python-matplotlib} package")))

(define-public python-matplotlib-inline
  (package
    (name "python-matplotlib-inline")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "matplotlib-inline" version))
       (sha256
        (base32 "1vilzwj3xp00mxprmmn1hlafm3p23vn56s46kx3ra4qd5signjx0"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-matplotlib python-traitlets))
    (arguments
     ;; Tests disabled because of a circular dependency with ipython.
     `(#:tests? #f))
    (home-page "https://github.com/ipython/matplotlib-inline")
    (synopsis "Inline Matplotlib backend for Jupyter")
    (description
     "This package provides a Matplotlib inline back-end for IPython and
Jupyter.")
    (license license:bsd-3)))

(define-public python-matplotlib-venn
  (package
    (name "python-matplotlib-venn")
    (version "0.11.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "matplotlib-venn" version ".zip"))
       (sha256
        (base32
         "13w3i1wih0mij08hrgppzg0g9z50y54rc28l6gdi1r5w45l7l0dy"))))
    (build-system python-build-system)
    (arguments '(#:tests? #f)) ; tests are not included
    (propagated-inputs
     (list python-matplotlib python-numpy python-scipy))
    (native-inputs
     (list unzip))
    (home-page "https://github.com/konstantint/matplotlib-venn")
    (synopsis "Plot area-proportional Venn diagrams")
    (description
     "This package provides tools for plotting area-proportional two- and
three-way Venn diagrams in @code{matplotlib}.")
    (license license:expat)))

(define-public python-matplotx
  (package
    (name "python-matplotx")
    (version "0.3.10")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/nschloe/matplotx")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1j301mr7ai2jmbm5mkva0jd99fzxhyq585pqzqfmrf5pil8j4q8i"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; This test fails with ValueError: not enough values to unpack.
      #~(list "--deselect" "tests/test_spy.py::test_cli"
              ;; XXX: unknown failure
              "--deselect" "tests/test_spy.py::test_png")))
    (propagated-inputs
     (list python-matplotlib
           python-numpy
           ;; optional dependencies
           python-networkx
           python-pypng
           python-scipy))
    (native-inputs (list python-imageio
                         python-meshzoo
                         python-pytest
                         python-scikit-fem
                         python-setuptools
                         python-wheel))
    (home-page "https://github.com/nschloe/matplotx")
    (synopsis "Minimal matplotlib styles")
    (description
      "This package includes some extensions for Matplotlib to create
clean plots with a minimalistic style.")
    (license license:expat)))

(define-public python-cplot
  (package
    (name "python-cplot")
    (version "0.9.3")
    (source
     (origin
       (method git-fetch)   ;for tests
       (uri (git-reference
             (url "https://github.com/nschloe/cplot")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0zk7hpq358sbympmkms7w2wjs7nw8mdfvkvdasblg2nhqayv42qz"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-matplotlib
           python-matplotx
           python-npx
           python-numpy))
    (home-page "https://github.com/nschloe/cplot")
    (synopsis "Plot complex-valued functions")
    (description "@code{cplot} is a Python library for plotting
complex-valued functions.")
    (license license:gpl3+)))

(define-public python-cppheaderparser
  (package
    (name "python-cppheaderparser")
    (version "2.7.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "CppHeaderParser" version))
       (sha256
        (base32 "0hncwd9y5ayk8wa6bqhp551mcamcvh84h89ba3labc4mdm0k0arq"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #f))     ; no tests
    (propagated-inputs (list python-ply))
    (native-inputs (list python-setuptools python-wheel))
    (home-page "http://senexcanis.com/open-source/cppheaderparser/")
    (synopsis
     "Parse C++ header files and generate a data structure representing the class")
    (description
     "CppHeaderParser is a pure python module that will parse C++ header files
and generate a data structure representing the class﻿.")
    (license license:bsd-3)))

(define-public python-cppy
  (package
    (name "python-cppy")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "cppy" version))
       (sha256
        (base32 "06zysv86j7wqb1rl88ab4clbjf7iahhv9gfyqlasr18hggqkpd43"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/nucleic/cppy")
    (synopsis "C++ header library for Python extension modules")
    (description "This package is a small C++ header library which makes it
easier to write Python extension modules.  The primary feature is a
@code{PyObject} smart pointer which automatically handles reference counting
and provides convenience methods for performing common object operations.")
    (license license:bsd-3)))

(define-public python-perfplot
  (package
    (name "python-perfplot")
    (version "0.10.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "perfplot" version))
              (sha256
               (base32
                "0hbyv17f9ra6l6albcrqx4rylmfv2m6z4qsnhb4bar256dralvfp"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-matplotlib
                             python-matplotx
                             python-numpy
                             python-rich))
    (native-inputs (list python-flit-core
                         python-pytest))
    (home-page "https://github.com/nschloe/perfplot")
    (synopsis "Performance plots for Python code snippets")
    (description "@code{perfplot} extends Python's timeit by testing
snippets with input parameters (e.g., the size of an array) and plotting
the results.")
    (license license:gpl3+)))

(define-public python-pykdtree
  (package
    (name "python-pykdtree")
    (version "1.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pykdtree" version))
       (sha256
        (base32 "0p8n2ljdacfixkiw092974dmhy4s1c0h032ii1z9kwi9h5h5rgmy"))))
    (build-system python-build-system)
    (native-inputs
     (list python-nose))
    (propagated-inputs
     (list python-numpy))
    (home-page "https://github.com/storpipfugl/pykdtree")
    (synopsis "Fast kd-tree implementation with OpenMP-enabled queries")
    (description
     "@code{pykdtree} is a kd-tree implementation for fast nearest neighbour
search in Python.")
    (license license:lgpl3+)))

(define-public python-wurlitzer
  (package
    (name "python-wurlitzer")
    (version "2.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "wurlitzer" version))
       (sha256
        (base32 "0hvmbc41kdwrjns8z1s4a59a4azdvzb8q3vs7nn1li4qm4l0g3yh"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "pytest" "-vv" "test.py"))))))
    (native-inputs
     (list python-mock python-pytest))
    (home-page "https://github.com/minrk/wurlitzer")
    (synopsis "Capture C-level output in context managers")
    (description
     "This library helps to redirect @code{sys.stdout} to a stream or a file
while executing some piece of code, including C code running within a Python
process.")
    (license license:expat)))

(define-public python-socksipy-branch
  (package
    (name "python-socksipy-branch")
    (version "1.01")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "SocksiPy-branch" version))
       (sha256
        (base32
         "01l41v4g7fy9fzvinmjxy6zcbhgqaif8dhdqm4w90fwcw9h51a8p"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f)) ; There are no tests
    (home-page "https://code.google.com/archive/p/socksipy-branch/")
    (synopsis "Python SOCKS module")
    (description
     "SocksiPy - A Python SOCKS client module.  It provides a
socket-like interface that supports connections to any TCP
service through the use of a SOCKS4, SOCKS5 or HTTP proxy.
The original version was developed by Dan Haim, this is a
branch created by Mario Vilas to address some open issues,
as the original project seems to have been abandoned circa 2007.")
    (license license:bsd-3)))

(define-public python-socksipychain
  (package
    (name "python-socksipychain")
    (version "2.1.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/pagekite/PySocksipyChain")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "02pp994qmiivkdx4y6az5q80l6rzy8g6d2ipvp7kns7lsxvmc2y7"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))                  ; Tests try to access the network.
    (propagated-inputs
     (list python-six))
    (home-page "http://pagekite.net/wiki/Floss/PySocksipyChain/")
    (synopsis "Python SOCKS module with chained proxies support")
    (description
     "SocksiPyChain is a modified version of the SocksiPy SOCKS module, which
adds support for arbitrary chaining of proxy servers and various modes of
TLS/SSL encryption.  It was developed for use in PageKite, and also includes
a simple netcat replacement with chaining support.")
    (license license:bsd-3)))

(define-public python-pycodestyle
  (package
    (name "python-pycodestyle")
    (version "2.12.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pycodestyle" version))
       (sha256
        (base32 "089mszv65gwnz4nq8vryxqanlqk3bh3p4maxrnngdr5wighflf38"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags #~(list "-m" "pycodestyle" "--statistics" "pycodestyle.py")
      #:phases
      #~(modify-phases %standard-phases
          ;; Taken from Tox config
          ;; <https://github.com/PyCQA/pycodestyle/blob/2.11.0/tox.ini#L16>.
          (replace 'check
            (lambda* (#:key tests? test-flags #:allow-other-keys)
              (when tests?
                  (apply invoke "python" "-v" test-flags)))))))
    (native-inputs
     (list python-setuptools
           python-wheel))
    (home-page "https://pycodestyle.readthedocs.io/")
    (synopsis "Python style guide checker")
    (description "@code{pycodestyle} (formerly pep8) is a tool to check
Python code against some of the style conventions in
@url{http://www.python.org/dev/peps/pep-0008/,PEP 8}.")
    (license license:expat)))

(define-public python-pycollada
  (package
    (name "python-pycollada")
    (version "0.8")
    (source
     (origin
       (method git-fetch)   ; no tests data in PyPi package
       (uri (git-reference
             (url "https://github.com/pycollada/pycollada")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0by8b46gji9npsgnx91cvzjrfcsm7r4d23gvn7h2h9ninaxlv7zw"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-numpy
           python-dateutil))
    (home-page "https://pycollada.readthedocs.io")
    (synopsis "Reading and writing collada documents library")
    (description
     "This package implements a functionality for creating, editing and
loading @url{https://www.khronos.org/collada/,COLLADA},which is a
COLLAborative Design Activity for establishing an interchange file format for
interactive 3D applications.

The library allows you to load a COLLADA file and interact with it as a python
object.  In addition, it supports creating a collada python object from
scratch, as well as in-place editing.")
    (license license:bsd-3)))

(define-public python-pyct
  (package
    (name "python-pyct")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyct" version))
       (sha256
        (base32 "1856dbrcpc0nxxhlfh3dqzz7xxn5sdi600q45hsprqyqrg2lm7yx"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; These tests want to download example data from the internet.
      '(list "-k" (string-append
                   "not test_examples_with_use_test_data"
                   " and not test_examples_using_test_data_and_force_with_prexisting_content_in_target"
                   " and not test_fetch_data_using_test_data_with_no_file_in_data_copies_from_stubs"
                   " and not test_fetch_data_using_test_data_and_force_with_file_in_data_over_writes"))))
    (propagated-inputs (list python-param python-pyyaml))
    (native-inputs (list python-flake8 python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/holoviz-dev/pyct")
    (synopsis "Common packaging tasks")
    (description
     "This Python package provides utilities to run common packaging tasks,
e.g. copy examples, fetch data, etc.")
    (license license:bsd-3)))

(define-public python-multidict
  (package
    (name "python-multidict")
    (version "6.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "multidict" version))
       (sha256
        (base32
         "0jlgjpclkh5g6vr1danl6alz0cza2jlzdqh3q03d4s8ckfzjxbi2"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-typing-extensions))
    (native-inputs
     (list python-pytest python-pytest-cov python-setuptools python-wheel))
    (home-page "https://github.com/aio-libs/multidict/")
    (synopsis "Multidict implementation")
    (description "Multidict is dict-like collection of key-value pairs
where key might be occurred more than once in the container.")
    (license license:asl2.0)))

(define-public python-orderedmultidict
  (package
    (name "python-orderedmultidict")
    (version "1.0.1")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "orderedmultidict" version))
        (sha256
          (base32 "1bc2v0yflsxjyyjx4q9wqx0j3bvzcw9z87d5pz4iqac7bsxhn1q4"))))
    (build-system pyproject-build-system)
    (propagated-inputs
     (list python-six))
    (native-inputs
     (list python-flake8 python-pycodestyle python-setuptools python-wheel))
    (home-page "https://github.com/gruns/orderedmultidict")
    (synopsis "Python Ordered Multivalue Dictionary - omdict")
    (description "This package contains a library for ordered multivalue
dictionaries.  A multivalue dictionary is a dictionary that can store
multiple values for the same key.  An ordered multivalue dictionary is a
multivalue dictionary that retains the order of insertions and deletions.")
    (license license:unlicense)))

(define-public python-autocommand
  (package
    (name "python-autocommand")
    (version "2.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "autocommand" version))
       (sha256
        (base32 "03qp9xx4dq81ljhf56r21gp5j0lpqs1vaw99g0d84i97s3lj1m7y"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                ;; This test fails with an invalid syntax error on 'task1 =
                ;; asyncio.async(coro_1())' (see:
                ;; https://github.com/Lucretiel/autocommand/issues/20).
                (delete-file "test/test_autoasync.py")
                (invoke "pytest" "-vv")))))))
    (native-inputs (list python-pytest python-pytest-asyncio))
    (home-page "https://github.com/Lucretiel/autocommand")
    (synopsis "Python library to build a command-line from a function")
    (description "@code{autocommand} is library to automatically generate and
run simple @code{argparse} parsers from function signatures.")
    (license license:lgpl3+)))

(define-public python-autopage
  (package
    (name "python-autopage")
    (version "0.5.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "autopage" version))
              (sha256
               (base32
                "169ixll1ncm2a2pcc86665ikjv2lrzs10p6c1w4yj55p3gk3xgh1"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'disable-e2e-tests
            (lambda _
              ;; These tests rely on KeyboardInterrupts which do not
              ;; work in the build container.
              (delete-file "autopage/tests/test_end_to_end.py"))))))
    (native-inputs
     (list python-pypa-build
           python-setuptools
           python-wheel
           ;; For tests.
           python-fixtures
           python-pytest
           python-testtools))
    (home-page "https://github.com/zaneb/autopage")
    (synopsis "Automatic paging for console output")
    (description
     "Autopage is a Python library to automatically display terminal output
from a program in a @dfn{pager} such as @command{less}.")
    (license license:asl2.0)))

(define-public python-autopep8
  (package
    (name "python-autopep8")
    (version "2.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "autopep8" version))
       (sha256
        (base32
         "037yhzmc9lssmn6cifa5gvw23f1c0hgsfgn83jfl3cwppm50c4r9"))))
    (build-system pyproject-build-system)
    (propagated-inputs
     (list python-pycodestyle python-tomli))
    (native-inputs
     (list python-setuptools python-wheel))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'check 'prepare-check
           (lambda _
             (setenv "HOME" "/tmp"))))))
    (home-page "https://github.com/hhatto/autopep8")
    (synopsis "Format Python code according to the PEP 8 style guide")
    (description
     "@code{autopep8} automatically formats Python code to conform to
the PEP 8 style guide.  It uses the pycodestyle utility to determine
what parts of the code needs to be formatted.  @code{autopep8} is
capable of fixing most of the formatting issues that can be reported
by pycodestyle.")
    (license (license:non-copyleft
              "https://github.com/hhatto/autopep8/blob/master/LICENSE"))))

(define-public python-dirty-equals
  (package
    (name "python-dirty-equals")
    (version "0.8.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/samuelcolvin/dirty-equals")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1jp9jbfs90m8jkpcvi798zxxx49a94rzn8gki9fraqhbqxkv76qd"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; This test requires pytest-examples, which in turn requires
      ;; python-ruff, which is difficult to package because it is written in
      ;; Rust (TODO: Enable when Ruff is in Guix!).
      #~(list "--ignore=tests/test_docs.py"
              ;; Optional typing check with Pydantic.
              "--ignore=tests/test_other.py"
              ;; TODO: Some timezones are missing in PyTZ, remove constrain
              ;; when updated.
              "-k" (string-append "not test_is_datetime_zoneinfo"
                                  " and not test_is_now_tz"
                                  " and not test_tz"))))
    (native-inputs
     (list python-hatchling
           ;; python-pydantic ; introduces cycle, optinoal
           python-pytest))
    (propagated-inputs
     (list python-pytz))
    (home-page "https://dirty-equals.helpmanual.io/")
    (synopsis "Do dirty (but useful) things with equals")
    (description
     "@code{dirty-equals} is a Python library that (mis)uses the
@code{__eq__} method to make code (generally unit tests) more declarative
and therefore easier to read and write.")
    (license license:expat)))

(define-public python-distlib
  (package
    (name "python-distlib")
    (version "0.3.7")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "distlib" version))
       (sha256
        (base32
         "1a27f5p93j9i1l3324qgahs3g8ai91fmx783jpyyla506i5ybbwx"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'no-/bin/sh
            (lambda* (#:key inputs #:allow-other-keys)
              (let ((/bin/sh (search-input-file inputs "bin/sh")))
                (substitute* '("distlib/scripts.py" "tests/test_scripts.py")
                  (("/bin/sh") /bin/sh)))))
          (add-before 'check 'prepare-test-environment
            (lambda _
              (setenv "HOME" "/tmp")
              ;; NOTE: Any value works, the variable just has to be present.
              (setenv "SKIP_ONLINE" "1"))))))
    (native-inputs
     (list python-pytest python-setuptools python-wheel))
    (inputs
     (list bash-minimal))
    (home-page "https://github.com/pypa/distlib")
    (synopsis "Distribution utilities")
    (description "Distlib is a library which implements low-level functions that
relate to packaging and distribution of Python software.  It is intended to be
used as the basis for third-party packaging tools.")
    (license license:psfl)))

(define-public python-distutils-extra
  (package
    (name "python-distutils-extra")
    (version "2.38")
    (source
     (origin
      (method url-fetch)
      (uri (string-append "https://launchpad.net/python-distutils-extra/trunk/"
                          version "/+download/python-distutils-extra-"
                          version ".tar.gz"))
      (sha256
       (base32
        "0lx15kcbby9zisx33p2h5hgakgwh2bvh0ibag8z0px4j6ifhs41x"))))
    (build-system python-build-system)
    (home-page "https://launchpad.net/python-distutils-extra/")
    (synopsis "Enhancements to Python's distutils")
    (description
     "The python-distutils-extra module enables you to easily integrate
gettext support, themed icons, and scrollkeeper-based documentation into
Python's distutils.")
    (license license:gpl2)))

(define-public python-olefile
  (package
    (name "python-olefile")
    (version "0.46")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://github.com/decalage2/olefile/releases/"
                           "download/v" version "/olefile-" version ".tar.gz"))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1kjxh4gr651hpqkjfv89cfzr40hyvf3vjlda7mifiail83j7j07m"))))
    (build-system python-build-system)
    (home-page "https://www.decalage.info/python/olefileio")
    (synopsis "Read and write Microsoft OLE2 files")
    (description
     "@code{olefile} can parse, read and write Microsoft OLE2 files (Structured
Storage or Compound Document, Microsoft Office).  It is an improved version of
the OleFileIO module from PIL, the Python Image Library.")
    (license license:bsd-3)))

(define-public python-property-cached
  (package
    (name "python-property-cached")
    (version "1.6.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "property-cached" version ".zip"))
       (sha256
        (base32 "0wxv5sdx1p7ils36j6j6hfscz8v2vzbq212i8y8r0lrnxpqlx71y"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; AssertionError.
      #:test-flags #~(list "-k" "not test_threads_ttl_expiry")))
    (native-inputs (list python-freezegun python-pytest unzip
                         python-setuptools python-wheel))
    (home-page "https://github.com/althonos/property-cached/")
    (synopsis "Decorator for caching properties in classes")
    (description "This package provides a decorator for caching properties in
classes.  It is forked from @code{cached-property}.")
    (license license:bsd-3)))

(define-public python-pypdf3
  (package
    (name "python-pypdf3")
    (version "1.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "PyPDF3" version))
       (sha256
        (base32 "018hlq9q2qa96vw4j7ppq352znykldwy98h2w9qcpkvpi93sjqhc"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-tqdm))
    (home-page "https://github.com/sfneal/PyPDF3")
    (synopsis "Utility to read and write PDFs with Python")
    (description "PyPDF3 is a pure-python PDF library capable of splitting,
merging together, cropping, and transforming the pages of PDF files.  It can
also add custom data, viewing options, and passwords to PDF files.  It can
retrieve text and metadata from PDFs as well as merge entire files together.")
    (license license:bsd-3)))

(define-public python-pdf2image
  (package
    (name "python-pdf2image")
    (version "1.17.0")
    ;; No tests in the PyPI tarball.
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Belval/pdf2image")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0xd8q939zqa8flfcdhbgyadiwqb8sgnd42cbr6n1l2jl9fnix45v"))))
    (build-system pyproject-build-system)
    (arguments
     ;; The following excluded tests assume hardcoded binary paths to
     ;; /usr/bin/pdftoppm and /usr/bin/pdftocairo.
     '(#:test-flags '("--exclude=^test_use_poppler_path$"
                      "--exclude=^test_use_poppler_path_with_trailing_slash$")))
    (propagated-inputs (list python-pillow))
    (inputs (list poppler))
    (native-inputs (list python-nose which python-setuptools python-wheel))
    (home-page "https://github.com/Belval/pdf2image")
    (synopsis
     "Python wrapper around @command{pdftoppm} and @command{pdftocairo}")
    (description
     "This package provides a Python API wrapping the @command{pdftoppm} and
@command{pdftocairo} command line tools.  It can convert @file{PDF} files to a
Python list with elements of type @code{PIL.Image} (from the
@code{python-pillow} library).")
    (license license:expat)))

(define-public python-pikepdf
  (package
    (name "python-pikepdf")
    (version "7.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pikepdf" version))
       (sha256
        (base32 "1vp3q85l2w7wpc8kqs26ijg3ivvvgj50z7g14p3pc0zdz8vbi0md"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #false))                ;require python-xmp-toolkit
    (native-inputs
     (list pybind11
           python-attrs
           python-coverage
           python-hypothesis
           python-setuptools-scm
           python-psutil
           python-pytest
           python-pytest-cov
           python-pytest-timeout
           python-pytest-xdist
           python-dateutil
           ;; python-xmp-toolkit
           python-tomli))
    (inputs
     (list qpdf))
    (propagated-inputs
     (list python-deprecation python-lxml python-packaging python-pillow))
    (home-page "https://github.com/pikepdf/pikepdf")
    (synopsis "Read and write PDFs with Python")
    (description
     "pikepdf is a Python library for reading and writing PDF files.")
    (license license:mpl2.0)))

(define-public python-pillow
  (package
    (name "python-pillow")
    (version "11.1.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pillow" version))
              (sha256
               (base32
                "081abgpz7g013cgzz7pjhmf8m7q626ngza4hnfs76vdk104ag39n"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'patch-ldconfig
           (lambda _
             (substitute* "setup.py"
               (("\\['/sbin/ldconfig', '-p'\\]") "['true']"))))
         (replace 'check
           (lambda* (#:key outputs inputs tests? #:allow-other-keys)
             (when tests?
               (setenv "HOME"
                       (getcwd))
               (add-installed-pythonpath inputs outputs)
               (invoke "python" "selftest.py" "--installed")
               (invoke "python" "-m" "pytest" "-vv")))))))
    (native-inputs (list python-check-manifest
                         python-coverage
                         python-defusedxml
                         python-markdown2
                         python-olefile
                         python-packaging
                         python-pytest
                         python-pytest-cov
                         python-pytest-timeout
                         python-setuptools
                         python-trove-classifiers
                         python-wheel))
    (inputs (list freetype
                  lcms
                  libjpeg-turbo
                  libtiff
                  libwebp
                  openjpeg
                  zlib))
    (home-page "https://python-pillow.org")
    (synopsis "Fork of the Python Imaging Library")
    (description
     "The Python Imaging Library adds image processing capabilities to your
Python interpreter.  This library provides extensive file format support, an
efficient internal representation, and fairly powerful image processing
capabilities.  The core image library is designed for fast access to data
stored in a few basic pixel formats.  It should provide a solid foundation for
a general image processing tool.")
    (properties `((cpe-name . "pillow")))
    (license (license:x11-style
              "http://www.pythonware.com/products/pil/license.htm"
              "The PIL Software License"))))

(define-public python-pillow-heif
  (package
    (name "python-pillow-heif")
    (version "0.21.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pillow_heif" version))
       (sha256
        (base32 "16xl2a51z4rjfy7y8vnn3w0ngcr1mr2sgsl9p7z62payy2zy3bh7"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "-k"                      ; XXX: 10/12 bit tests fail
              (string-append
               "not test_save_bgr_16bit_to_10_12_bit"
               " and not test_save_bgra_16bit_to_10_12_bit"
               " and not test_open_heif_compare_non_standard_modes_data"
               " and not test_open_save_disable_16bit"
               " and not test_heif_read_images[image_path16]"
               " and not test_heif_read_images[image_path43]"
               " and not test_premultiplied_alpha"
               " and not test_hdr_save"
               " and not test_I_color_modes_to_10_12_bit"))))
    (inputs (list libheif))
    (propagated-inputs (list python-pillow))
    (native-inputs (list opencv         ; for opencv-python
                         python-coverage
                         python-defusedxml
                         python-numpy
                         python-packaging
                         python-pre-commit
                         python-pylint
                         python-pympler
                         python-setuptools
                         python-pytest
                         python-wheel))
    (home-page "https://github.com/bigcat88/pillow_heif")
    (synopsis "Python interface for libheif library")
    (description "This package provides Python bindings for the libheif library
and a plugin for Pillow.")
    (license license:bsd-3)))

(define-public python-pillow-2.9
  (package
    (inherit python-pillow)
    (version "2.9.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "Pillow" version))
        (sha256
         (base32
           "0ada7lf3lmbdsqm3b7ja920p1pllyfhmqndr85ikpj77fmz9s5qg"))))
    (arguments
     (substitute-keyword-arguments (package-arguments python-pillow)
       ((#:tests? _ #f) #f)))
    (properties '((hidden? #t)))))

(define-public python-pillow-simd
  (package
    (inherit python-pillow)
    (name "python-pillow-simd")
    (version "10.0.1.post0")
    ;; The PyPI tarball does not include test files.
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/uploadcare/pillow-simd")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "16pr4qifb661spf58b7g2lyraask9wf944v4kwk3llg32djvb09b"))))
    (arguments
     (list
      #:test-flags
      ;; Got different content.
      '(list "-k" (string-append "not test_open"
                                 " and not test_consistency_3x3"
                                 " and not test_consistency_5x5"))
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'patch-ldconfig
           (lambda _
             (substitute* "setup.py"
               (("\\['/sbin/ldconfig', '-p'\\]") "['true']")))))))
    (inputs
     (modify-inputs (package-inputs python-pillow)
       (prepend libraqm libimagequant)))
    (home-page "https://github.com/uploadcare/pillow-simd")
    (synopsis "Fork of the Python Imaging Library (Pillow)")
    (description "This package is a fork of Pillow which adds support for SIMD
parallelism.")))

(define-public python-pixelmatch
  (package
    (name "python-pixelmatch")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pixelmatch" version))
       (sha256
        (base32 "16b0cz136dcmj4dbr505igpql8dmqmr9vni5nbaa5kygjfjkdynh"))))
    (build-system python-build-system)
    (native-inputs (list python-pillow))
    (home-page "https://github.com/whtsky/pixelmatch-py")
    (synopsis "Pixel-level image comparison library")
    (description "This package provides a pixel-level image comparison library
for Python, originally created to compare screenshots in tests.  Its features
include accurate anti-aliased pixels detection and perceptual color difference
metrics.")
    (license license:isc)))

(define-public python-imagecodecs
  (package
    (name "python-imagecodecs")
    (version "2021.3.31")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "imagecodecs" version))
        (sha256
          (base32
            "0q7pslb6wd56vbcq2mdxwsiha32mxjr7mgqqfbq5w42q601p9pi0"))
        (modules '((guix build utils)))
        (snippet
         '(begin
            ;; Unbundle 3rd party modules.
            (delete-file-recursively "3rdparty")
            ;; Delete pre-generated Cython files.
            (for-each delete-file (find-files "imagecodecs" "_.*\\.c$"))
            #t))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f ; Tests are disabled, because dependencies are missing.
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'create-configuration
           (lambda* (#:key inputs #:allow-other-keys)
             ;; By default everything is enabled. We can selectively disable
             ;; extensions (and thus dependencies) by deleting them from the
             ;; EXTENSIONS dictionary.  This is upstream’s preferred way.
             (call-with-output-file "imagecodecs_distributor_setup.py"
               (lambda (port)
                 (format port "\
def customize_build(EXTENSIONS, OPTIONS):
    del EXTENSIONS['aec']
    del EXTENSIONS['avif']
    del EXTENSIONS['bitshuffle']
    del EXTENSIONS['deflate']
    del EXTENSIONS['jpeg2k']
    del EXTENSIONS['jpeg12']
    del EXTENSIONS['jpegls']
    del EXTENSIONS['jpegxl']
    del EXTENSIONS['jpegxr']
    del EXTENSIONS['lerc']
    del EXTENSIONS['ljpeg']
    del EXTENSIONS['lzf']
    del EXTENSIONS['zfp']
    del EXTENSIONS['zopfli']
    OPTIONS['cythonize']
")))))
         ;; XXX: The installed scripts import packages that depend on
         ;; this package; disable import check to avoid the cycle.
         (delete 'sanity-check))))
    (inputs
      (list c-blosc
            giflib
            brotli
            libjpeg-turbo
            libpng
            libtiff
            libwebp
            lz4
            snappy
            xz
            zlib
            `(,zstd "lib")))
    (propagated-inputs
      ;; For the Python library.
      (list python-numpy))
    (native-inputs
      ;; For building.
      (list python-cython
            ;; For testing. Incomplete.
            ;("python-numcodecs" ,python-numcodecs)
            ;("python-zarr" ,python-zarr)
            ;("python-pytest" ,python-pytest)
            ))
    (home-page "https://www.lfd.uci.edu/~gohlke/")
    (synopsis
      "Image transformation, compression, and decompression codecs")
    (description
      "Imagecodecs is a Python library that provides block-oriented, in-memory
buffer transformation, compression, and decompression functions for use in the
tifffile, czifile, and other scientific image input/output modules.")
    (license license:bsd-3)))

(define-public python-property-manager
  (package
    (name "python-property-manager")
    (version "3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "property-manager" version))
       (sha256
        (base32 "0m3w4spr8f39xnm65naw29ncal4r453kn7ndqb63rwbsmslnvrwk"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest-cov))
    (propagated-inputs
     (list python-verboselogs
           python-humanfriendly
           python-coloredlogs))
    (home-page "https://github.com/xolox/python-property-manager")
    (synopsis "Useful property variants for Python programming")
    (description "The @code{property-manager} package defines several custom
property variants for Python programming including required properties,
writable properties, cached properties, etc.")
    (license license:expat))) ; MIT license

(define-public python-executing
  (package
    (name "python-executing")
    (version "2.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "executing" version))
       (sha256
        (base32 "1axrwh7kr7nshzjw6vj9w9hn3rqh9af2c257ll7iba0d4vfpv8lf"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; AssertionError: assert 'test failure' in ''
      #:test-flags #~(list "-k" "not test_two_statement_lookups")))
    (native-inputs
     (list python-asttokens
           python-littleutils
           python-pytest
           python-setuptools
           python-setuptools-scm
           python-toml
           python-wheel))
    (home-page "https://github.com/alexmojaki/executing")
    (synopsis "Get information about what a Python frame is currently doing")
    (description "This package lets you get information about what a frame is
currently doing, particularly the AST node being executed.")
    (license license:expat)))

(define-public python-executor
  (package
    (name "python-executor")
    (version "23.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "executor" version))
       (sha256
        (base32 "0g83yr54j0vcwhy6h7n0jsd7q0q630kwa6v9kqzlzrm9xj6c3ip1"))))
    (build-system python-build-system)
    (arguments
    `(#:tests? #f)) ; TODO: tests require root/sudo
    (propagated-inputs
     (list python-six
           python-property-manager
           python-fasteners
           python-virtualenv))
    (home-page "https://github.com/xolox/python-executor")
    (synopsis "Programmer friendly subprocess wrapper")
    (description "The @code{executor} package is a simple wrapper for Python’s
subprocess module that makes it very easy to handle subprocesses on UNIX
systems with proper escaping of arguments and error checking currently doing,
particularly the AST node being executed.")
    (license license:expat))) ; MIT license

(define-public python-roifile
  (package
    (name "python-roifile")
    (version "2020.11.28")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "roifile" version))
        (sha256
          (base32
            "04argnc7qccybkrj9ww18bf81ghsghhh93hnqy3p111rcdlyn66p"))))
    (build-system python-build-system)
    (arguments `(#:tests? #f)) ; there are none
    (propagated-inputs
      (list python-numpy))
    (home-page "https://www.lfd.uci.edu/~gohlke/")
    (synopsis "Read and write ImageJ ROI format")
    (description "Roifile is a Python library to read, write, create, and plot
ImageJ ROIs, an undocumented and ImageJ application specific format to store
regions of interest, geometric shapes, paths, text, etc for image overlays.")
    (license license:bsd-3)))

(define-public python-tifffile
  (package
    (name "python-tifffile")
    (version "2023.12.9")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "tifffile" version))
       (sha256
        (base32
         "1f6d8qdlq0zlksfdhp1mhj9icpwhw4cz47r4i80m6r0a328xmlcx"))))
    (build-system python-build-system)
    ;; Tests require lfdfiles, which depends on tifffile
    (arguments `(#:tests? #f))
    (propagated-inputs
     (list python-numpy))
    (native-inputs
     (list python-pytest))
    (home-page "https://www.lfd.uci.edu/~gohlke/")
    (synopsis "Read and write TIFF(r) files")
    (description "This package lets you read image and metadata from many
bio-scientific formats such as plain TIFF, BigTIFF, OME-TIFF, STK, LSM, SGI,
NIH, ImageJ, MicroManager, MD GEL, and FluoView files.  It also lets you write
numpy arrays to TIFF, BigTIFF, and ImageJ hyperstack compatible files.")
    (license license:bsd-3)))

(define-public python-lfdfiles
  (package
    (name "python-lfdfiles")
    (version "2021.2.22")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "lfdfiles" version))
       (sha256
        (base32
         "12fxm4v805dgjrih7x6jnl1wd7y7jw1rkhjs3d4am8s6qk1cbar2"))
        (modules '((guix build utils)))
        (snippet
         '(begin
            ;; Delete pre-generated Cython files.
            (for-each delete-file (find-files "lfdfiles" "_.*\\.c$"))
            #t))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f)) ; No tests exist, despite a test dependency on pytest.
    (propagated-inputs
     (list python-click python-numpy python-tifffile))
    (native-inputs (list python-cython))
    (home-page "https://www.lfd.uci.edu/~gohlke/")
    (synopsis "Work with LFD data files")
    (description
     "Lfdfiles is a Python library and console script for reading, writing,
converting, and viewing many of the proprietary file formats used to store
experimental data and metadata at the Laboratory for Fluorescence Dynamics.")
    (license license:bsd-3)))

(define-public python-av
  (package
    (name "python-av")
    (version "10.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "av" version))
       (sha256
        (base32 "01byqsjclkg65mhr6b4i2r2n4y7af9kdd2c35lxny27121b3vzca"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list
         ;; Tests require outbound access to download data samples from
         ;; http://fate.ffmpeg.org/fate-suite:
         ;;
         ;; E urllib.error.URLError: <urlopen error [Errno -3]
         ;; Temporary failure in name resolution>
         ;;
         "--ignore=tests/test_doctests.py"
         "--ignore=tests/test_timeout.py"
         "-k"
         (string-append
          "not test_data"
          " and not test_container_probing"
          " and not test_stream_probing"
          " and not test_transcode"
          " and not test_codec_tag"
          " and not test_parse"
          " and not test_decode_audio_sample_count"
          " and not test_decoded_motion_vectors"
          " and not test_decoded_motion_vectors_no_flag"
          " and not test_decoded_time_base"
          " and not test_decoded_video_frame_count"
          " and not test_encoding_aac"
          " and not test_encoding_dnxhd"
          " and not test_encoding_dvvideo"
          " and not test_encoding_h264"
          " and not test_encoding_mjpeg"
          " and not test_encoding_mp2"
          " and not test_encoding_mpeg1video"
          " and not test_encoding_mpeg4"
          " and not test_encoding_pcm_s24le"
          " and not test_encoding_png"
          " and not test_encoding_tiff"
          " and not test_encoding_xvid"
          " and not test_reading_from_buffer"
          " and not test_reading_from_buffer_no_seek"
          " and not test_reading_from_file"
          " and not test_reading_from_pipe_readonly"
          " and not test_reading_from_write_readonly"
          " and not test_writing_to_custom_io_dash"
          " and not test_writing_to_custom_io_image2"
          " and not test_decode_half"
          " and not test_seek_end"
          " and not test_seek_float"
          " and not test_seek_int64"
          " and not test_seek_middle"
          " and not test_seek_start"
          " and not test_stream_seek"
          " and not test_selection"
          " and not test_stream_tuples"
          " and not test_movtext"
          " and not test_vobsub"
          " and not test_roundtrip"
          " and not test_stream_probing"))
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'build-extensions
            (lambda _
              (invoke "python" "setup.py" "build_ext" "--inplace"))))))
    (native-inputs
     (list pkg-config
           python-cython
           python-editorconfig
           python-numpy
           python-pillow
           python-pytest
           python-setuptools
           python-wheel))
    (inputs
     ;; XXX: Build is failing with FFmpeg 6.0, unresolved upstream.
     ;; See https://github.com/PyAV-Org/PyAV/issues/1106
     (list ffmpeg-5))
    (home-page "https://github.com/PyAV-Org/PyAV")
    (synopsis "Pythonic bindings for FFmpeg's libraries")
    (description
     "PyAV is a Python library that allows for direct and precise manipulation
of media through containers, streams, packets, codecs, and frames.  It provides
access to the powerful FFmpeg libraries while managing the complex details as
much as possible.
PyAV also facilitates data transformation and integration with
other packages such as Numpy and Pillow.  However, working with media is a
challenging task and PyAV cannot abstract it away or make all the best decisions
for you.  If you can accomplish your tasks with the ffmpeg command, PyAV may not
be necessary.  Nonetheless, PyAV is an essential tool when working with media
that requires its specific capabilities.")
    (license license:bsd-3)))

(define-public python-ffmpeg-python
  ;; The latest release (0.2.0) is old and its test suite crashs on Python 3.10.
  (let ((commit "df129c7ba30aaa9ffffb81a48f53aa7253b0b4e6") (revision "0"))
    (package
      (name "python-ffmpeg-python")
      (version (git-version "0.2.0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/kkroening/ffmpeg-python.git")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1zj4ac37n4igfj21zy405mdlvbpv6jyb12wfpszf8zkhhj2qby4c"))))
      (build-system python-build-system)
      (arguments
       (list
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'hardcode-ffmpeg
              (lambda* (#:key inputs #:allow-other-keys)
                (define ffmpeg (search-input-file inputs "bin/ffmpeg"))
                (substitute* "ffmpeg/_run.py"
                  (("cmd='ffmpeg'")
                   (string-append "cmd='" ffmpeg "'")))
                (substitute* "ffmpeg/tests/test_ffmpeg.py"
                  (("out_file.compile\\(\\) == \\['ffmpeg'")
                   (string-append "out_file.compile() == ['" ffmpeg "'")))))
            ;; Some tests fail with ffmpeg 5+
            (replace 'check
              (lambda* (#:key tests? #:allow-other-keys)
                (when tests?
                  (invoke "pytest" "-vv"
                          "-k" "not test_pipe and not test__probe")))))))
      (inputs (list ffmpeg))
      (propagated-inputs (list python-future))
      (native-inputs (list python-future python-numpy python-pytest
                           python-pytest-mock python-pytest-runner))
      (home-page "https://github.com/kkroening/ffmpeg-python")
      (synopsis "Python bindings for FFmpeg with complex filtering support")
      (description
       "ffmpeg-python allows you to write FFmpeg filtergraphs in familiar
Python terms, taking care of running ffmpeg with the correct command-line
arguments.  It handles arbitrarily large (directed-acyclic) signal graphs.")
      (license license:asl2.0))))

(define-public python-imageio-ffmpeg
  (package
   (name "python-imageio-ffmpeg")
   (version "0.5.1")
   (source (origin
            (method url-fetch)
            (uri (pypi-uri "imageio-ffmpeg" version))
            (sha256
             (base32
              "0k284r1xsdp5h1s4k6nfsfzbkphf8g6r2llwjafhq2sn3yrskmqf"))))
   (arguments
    (list #:phases
          #~(modify-phases %standard-phases
              (add-after 'unpack 'hardcode-ffmpeg
                (lambda* (#:key inputs #:allow-other-keys)
                  (substitute* "imageio_ffmpeg/_utils.py"
                    (("os\\.getenv\\(\"IMAGEIO_FFMPEG_EXE\".*\\)" all)
                     (string-append "(" all " or \""
                                    (search-input-file inputs "bin/ffmpeg")
                                    "\")"))))))))
   (inputs (list ffmpeg))
   (native-inputs (list python-setuptools python-wheel))
   (build-system python-build-system)
   (home-page "https://github.com/imageio/imageio-ffmpeg")
   (synopsis "FFMPEG wrapper for Python")
   (description "This package provides an FFMPEG wrapper for working with video
files.  It implements generator functions for reading and writing data to and
from FFMPEG, reliably terminating the process when done.")
   (license license:bsd-2)))

(define-public python-imageio
  (package
    (name "python-imageio")
    (version "2.36.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "imageio" version))
       (sha256
        (base32
         "0qmy8qbnycas6v2a43qw9pxmd23fm3hpq3qb20b9x6kzyhqx5qg4"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags #~(list "-m" "not needs_internet")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-source
            (lambda* (#:key inputs #:allow-other-keys)
              (substitute* "imageio/plugins/_freeimage.py"
                (("os\\.getenv\\(\"IMAGEIO_FREEIMAGE_LIB\".*\\)" all)
                 (string-append
                  "(" all " or \""
                  (search-input-file inputs "lib/libfreeimage.so")
                  "\")")))
              (substitute* "imageio/core/util.py"
                (("\"/var/tmp\"")
                 "os.getenv(\"TMPDIR\", \"/tmp\")"))))
          (add-after 'unpack 'fix-failing-tests
            (lambda _
              (substitute* "tests/test_core.py"
                (("(core\\.load_lib)\\((\\[gllib\\], \\[\\])\\)"
                  all fun args)
                 (string-append "raises(ValueError, " fun ", " args ")")))
              (delete-file "tests/test_freeimage.py"))))))
    (inputs (list freeimage))
    (propagated-inputs
     (list python-imageio-ffmpeg python-numpy python-pillow python-tifffile))
    (native-inputs
     (list python-black
           python-flake8
           python-fsspec
           python-pytest
           python-pytest-cov
           python-setuptools
           python-wheel))
    (home-page "https://imageio.github.io/")
    (synopsis "Library for reading and writing a wide range of image data")
    (description
     "Imageio is a Python library that provides an easy interface to read and
write a wide range of image data, including animated images, video, volumetric
data, and scientific formats.")
    (license license:bsd-2)))

(define-public python-pyvips
  (package
    (name "python-pyvips")
    (version "2.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyvips" version))
       (sha256
        (base32 "1dfbwwvnnsk4g2kj1pw654z9jq3mb72l1m8ma29858jpn12vn7dm"))))
    (build-system python-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               ;; Maybe switch to API mode (i.e., build the C extension)?
               ;; It is advertised as faster to start up and run.
               ;; However, even with ‘pkg-config’ and ‘python-pkgconfig’ in
               ;; ‘native-inputs’, the API mode build fails with:
               ;;
               ;;   Falling back to ABI mode. Details: unable to find pkg-config package "vips"
               ;;
               ;; The build doesn't actually fail without the below
               ;; substitution, it's just slower because ‘setup.py’ tries
               ;; (unsuccessfully) to download the Python ‘pkgconfig’ module.
               (add-after 'unpack 'fix-build
                 (lambda _
                   (substitute* "setup.py"
                     (("^( +setup_)API\\(\\)\n" _ prefix)
                      (string-append prefix "ABI()\n")))))
               (add-after 'unpack 'fix-paths
                 (lambda _
                   (substitute* "pyvips/__init__.py"
                     (("^( +_vips_libname) = '(libvips.so.42)'"
                       _ var libname)
                      (format #f "~a = '~a/lib/~a'"
                              var #$(this-package-input "vips") libname))
                     (("^( +_gobject_libname) = '(libgobject-2.0.so.0)'"
                       _ var libname)
                      (format #f "~a = '~a/lib/~a'"
                              var #$(this-package-input "glib") libname)))))
               (replace 'check
                 (lambda* (#:key tests? #:allow-other-keys)
                   (when tests?
                     (invoke "python" "setup.py" "test")))))))
    (native-inputs
     (list python-pyperf
           python-pytest
           python-pytest-flake8
           python-pytest-runner))
    (inputs
     (list glib vips))
    (propagated-inputs
     (list python-cffi))
    (home-page "https://github.com/libvips/pyvips")
    (synopsis "Python bindings for VIPS")
    (description "The @code{pyvips} package provides Python bindings for VIPS,
a multithreaded image-processing system with low memory needs.")
    (license license:expat)))

;; WARNING: This package is a dependency of mesa.
(define-public python-pycparser
  (package
    (name "python-pycparser")
    (version "2.21")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "pycparser" version))
      (sha256
       (base32
        "01kjlyn5w2nn2saj8w1rhq7v26328pd91xwgqn32z1zp2bngsi76"))))
    (outputs '("out" "doc"))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "python" "-m" "unittest" "discover")))
         (add-after 'install 'install-doc
           (lambda* (#:key outputs #:allow-other-keys)
             (let* ((data (string-append (assoc-ref outputs "doc") "/share"))
                    (doc (string-append data "/doc/" ,name "-" ,version))
                    (examples (string-append doc "/examples")))
               (mkdir-p examples)
               (for-each (lambda (file)
                           (copy-file (string-append "." file)
                                      (string-append doc file)))
                         '("/README.rst" "/CHANGES" "/LICENSE"))
               (copy-recursively "examples" examples)))))))
    (home-page "https://github.com/eliben/pycparser")
    (synopsis "C parser in Python")
    (description
     "Pycparser is a complete parser of the C language, written in pure Python
using the PLY parsing library.  It parses C code into an AST and can serve as
a front-end for C compilers or analysis tools.")
    (license license:bsd-3)))

(define-public python2-pycparser
  (package-with-python2 python-pycparser))

(define-public python-xlsxwriter
  (package
    (name "python-xlsxwriter")
    (version "3.2.0")
    (source
     (origin
       ;; There are no tests in the PyPI tarball.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jmcnamara/XlsxWriter")
             (commit (string-append "RELEASE_" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1g16xb4nsjd807qcm8756ixlxxvdjmbr2v7r6wxkajw1h4m8id0w"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-setuptools
           python-wheel))
    (home-page "https://github.com/jmcnamara/XlsxWriter")
    (synopsis "Python module for creating Excel XLSX files")
    (description
     "XlsxWriter is a Python module that can be used to write text, numbers,
formulas and hyperlinks to multiple worksheets in an Excel 2007+ XLSX file.")
    (license license:bsd-2)))

(define-public python-pywavelets
  (package
    (name "python-pywavelets")
    (version "1.2.0")
    (home-page "https://github.com/PyWavelets/pywt")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "PyWavelets" version))
              (sha256
               (base32
                "13csbr6ls9q9ww53z2xwwsj0hpsz88rj2iwp623h0kmv8yq6kgbc"))
              (snippet
               #~(begin
                   (use-modules ((guix build utils)))
                   (for-each delete-file
                             (list
                               "pywt/_extensions/_cwt.c"
                               "pywt/_extensions/_dwt.c"
                               "pywt/_extensions/_pywt.c"
                               "pywt/_extensions/_pywt.h"
                               "pywt/_extensions/_swt.c"))))))
    (build-system python-build-system)
    (arguments
     '(#:modules ((ice-9 ftw)
                  (srfi srfi-1)
                  (srfi srfi-26)
                  (guix build utils)
                  (guix build python-build-system))
       #:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (let ((cwd (getcwd))
                   (libdir (find (cut string-prefix? "lib." <>)
                                 (scandir "build"))))
               (with-directory-excursion (string-append cwd "/build/" libdir)
                 (invoke "pytest" "-vv"))))))))
    (native-inputs
     (list python-cython
           python-matplotlib ;for tests
           python-pytest))
    (propagated-inputs
     (list python-numpy))
    (synopsis "Wavelet transforms in Python")
    (description
     "PyWavelets is a library for wavelet transforms in Python.  Wavelets are
mathematical basis functions that are localized in both time and frequency.
Wavelet transforms are time-frequency transforms employing wavelets.  They are
similar to Fourier transforms, the difference being that Fourier transforms are
localized only in frequency instead of in time and frequency.")
    (license license:expat)))

(define-public python-pywal
  (package
    (name "python-pywal")
    (version "3.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/dylanaraps/pywal")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "039m7dch479hlwddynacdrr0klz6a5bdly5swqbs94hfimficiyf"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'check 'fix-home-directory
           (lambda _
             ;; Tests fail with "Permission denied: '/homeless-shelter'".
             (setenv "HOME" "/tmp")
             #t)))))
    (inputs
     (list imagemagick))
    (home-page "https://github.com/dylanaraps/pywal")
    (synopsis "Color palette generator and applicator")
    (description
     "Pywal is a tool that generates a color palette from the dominant colors
in an image.  It then applies the colors system-wide and on-the-fly in all of
your favourite programs.")
    (license license:expat)))

(define-public python-click-didyoumean
  (package
    (name "python-click-didyoumean")
    (version "0.3.1")
    (source
     (origin
       (method git-fetch)               ;no tests in PyPI archive
       (uri (git-reference
             (url "https://github.com/click-contrib/click-didyoumean")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1byfqs3m87zfpvssm1al9dvq94gjd0iddpwrzk6205n18wjsphqb"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-poetry-core python-pytest))
    (propagated-inputs
     (list python-click))
    (home-page "https://github.com/timofurrer/click-didyoumean")
    (synopsis "Git-like did-you-mean feature in Click")
    (description
     "This plugin enables git-like did-you-mean feature in Click.")
    (license license:expat)))

(define-public python-pywinrm
  (package
    (name "python-pywinrm")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pywinrm" version))
       (sha256
        (base32
         "10gabhhg3rgacd5ahmi2r128z99fzbrbx6mz1nnq0dxmhmn5rpjf"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-six python-requests_ntlm python-xmltodict
           python-kerberos))
    (native-inputs
     (list python-mock python-pytest))
    (home-page "https://github.com/diyan/pywinrm/")
    (synopsis
     "Python library for Windows Remote Management (WinRM)")
    (description
     "pywinrm is a Python client for the Windows Remote Management (WinRM)
service.  It allows you to invoke commands on target Windows machines from
any machine that can run Python.")
    (license license:expat)))

(define-public python-manimpango
  (package
    (name "python-manimpango")
    (version "0.5.0")
    (source
     (origin
       (method git-fetch) ; no tests data in PyPi package
       (uri (git-reference
             (url "https://github.com/ManimCommunity/ManimPango")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "00mrvswk8yly0m13jq0f432pr19sy3j6w37lrv78ah1j6jz9n50h"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'build-extensions
            (lambda _
              (invoke "python" "setup.py" "build_ext" "--inplace"))))))
    (native-inputs
      (list pkg-config
            python-cython
            python-pytest
            python-pytest-cov
            python-setuptools
            python-wheel))
    (inputs
     (list pango))
    (home-page "https://manimpango.manim.community/")
    (synopsis "Bindings for Pango for using with Manim")
    (description
     "Python bindings for ManimPango which is a C binding for Pango,
using Cython.

ManimPango is internally used in Manim to render (non-LaTeX) text.")
    (license license:expat)))

(define-public python-cairocffi
  (package
    (name "python-cairocffi")
    (version "1.6.1")
    (source
     (origin
       ;; The PyPI archive does not include the documentation, so use Git.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Kozea/cairocffi")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "161z2bsp0ai4311mz9n0h6vmz80690jbijxx2gqkknygwm2ynjgd"))))
    (build-system pyproject-build-system)
    (outputs '("out" "doc"))
    (inputs
     (list glib gtk+ gdk-pixbuf cairo))
    (native-inputs
     (list python-flit-core
           python-numpy
           python-pikepdf
           python-pytest
           python-pytest-cov
           python-pytest-runner
           python-sphinx
           python-sphinx-rtd-theme))
    (propagated-inputs
     (list python-xcffib)) ; used at run time
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-paths
           (lambda* (#:key inputs #:allow-other-keys)
             (substitute* "cairocffi/__init__.py"
               ;; Hack the dynamic library loading mechanism.
               (("find_library\\(library_name\\)")
                "\"found\"")
               (("filenames = \\(library_filename,\\) \\+ filenames")
                "pass")
               (("libcairo.so.2")
                (search-input-file inputs "/lib/libcairo.so.2")))
             (substitute* "cairocffi/pixbuf.py"
               (("libgdk_pixbuf-2.0.so.0")
                (search-input-file inputs "/lib/libgdk_pixbuf-2.0.so.0"))
               (("libgobject-2.0.so.0")
                (search-input-file inputs "/lib/libgobject-2.0.so.0"))
               (("libglib-2.0.so.0")
                (search-input-file inputs "/lib/libglib-2.0.so.0"))
               (("libgdk-3.so.0")
                (search-input-file inputs "/lib/libgdk-3.so.0")))))
         (add-after 'install 'install-doc
           (lambda* (#:key inputs outputs #:allow-other-keys)
             (let* ((data (string-append (assoc-ref outputs "doc") "/share"))
                    (doc (string-append data "/doc/" ,name "-" ,version))
                    (html (string-append doc "/html")))
               (setenv "LD_LIBRARY_PATH"
                       (string-append (assoc-ref inputs "cairo") "/lib" ":"
                                      (assoc-ref inputs "gdk-pixbuf") "/lib"))
               (setenv "LANG" "en_US.UTF-8")
               (mkdir-p html)
               (for-each (lambda (file)
                           (copy-file (string-append "." file)
                                      (string-append doc file)))
                         '("/README.rst" "/NEWS.rst"))
               (system* "python" "setup.py" "build_sphinx")
               (copy-recursively "docs/_build/html" html)
               #t))))))
    (home-page "https://github.com/Kozea/cairocffi")
    (synopsis "Python bindings and object-oriented API for Cairo")
    (description
     "Cairocffi is a CFFI-based drop-in replacement for Pycairo, a set of
Python bindings and object-oriented API for cairo.  Cairo is a 2D vector
graphics library with support for multiple backends including image buffers,
PNG, PostScript, PDF, and SVG file output.")
    (license license:bsd-3)))

(define-public python-decorator
  (package
    (name "python-decorator")
    (version "5.0.9")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "decorator" version))
       (sha256
        (base32 "1mcy64hllgm938v8k1x2a4g0q9swsnrfnsvhz59kr28a6ajgpv3j"))))
    (build-system python-build-system)
    (home-page "https://pypi.org/project/decorator/")
    (synopsis "Python module to simplify usage of decorators")
    (description
      "The aim of the decorator module is to simplify the usage of decorators
for the average programmer, and to popularize decorators usage giving examples
of useful decorators, such as memoize, tracing, redirecting_stdout, locked,
etc.  The core of this module is a decorator factory.")
    (license license:expat)))


(define-public python-drmaa
  (package
    (name "python-drmaa")
    (version "0.7.7")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "drmaa" version))
       (sha256
        (base32 "0xzqriqyvk5b8hszbavsyxd29wm3sxirm8zvvdm73rs2iq7w4hkx"))))
    (build-system python-build-system)
    ;; The test suite requires libdrmaa which is provided by the cluster
    ;; environment.  At runtime the environment variable DRMAA_LIBRARY_PATH
    ;; should be set to the path of the libdrmaa library.
    (arguments
     '(#:tests? #f
       #:phases (modify-phases %standard-phases
                  ;; Loading the library fails because DRMAA_LIBRARY_PATH
                  ;; is not configured.
                  (delete 'sanity-check))))
    (home-page "https://pypi.org/project/drmaa/")
    (synopsis "Python bindings for the DRMAA library")
    (description
      "A Python package for Distributed Resource Management (DRM) job
submission and control.  This package is an implementation of the DRMAA 1.0
Python language binding specification.")
    (license license:bsd-3)))

(define-public python-grako
  (package
    (name "python-grako")
    (version "3.99.9")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "grako" version ".zip"))
       (sha256
        (base32 "0r63i68wcnv63rfjkasq1ah81frz61a6mzbcnaxhrkdpx84p7hzw"))
       (snippet
        #~(begin (use-modules (guix build utils))
                 (substitute* "grako/grammars.py"
                   (("from collections import defaultdict, Mapping")
                    (string-append "from collections import defaultdict\n"
                                   "from collections.abc import Mapping")))
                 (substitute* '("grako/util.py"
                                "grako/walkers.py")
                   (("collections\\.Mapping") "collections.abc.Mapping"))))))
    (build-system python-build-system)
    (arguments '(#:tests? #f)) ; Test file 'grako.ebnf' is missing from archive.
    (native-inputs
     (list unzip python-pytest python-pytest-runner))
    (home-page "https://bitbucket.org/neogeny/grako")
    (synopsis "EBNF parser generator")
    (description
     "Grako takes a grammar in a variation of EBNF as input, and outputs a
memoizing PEG/Packrat parser in Python.")
    (license license:bsd-3)))

(define-public python-grandalf
  (package
    (name "python-grandalf")
    (version "0.7")
    (source
     (origin
       ;; There's no source tarball on PyPI.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/bdcht/grandalf")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "03p8w8ljpb87qbyldm3s6b7qi30hfcn43h33iwlgqcf31fjsyr4g"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "python" "setup.py" "pytest"))))))
    (native-inputs
     (list python-pytest python-pytest-runner))
    (propagated-inputs
     (list python-numpy python-ply))
    (home-page "https://github.com/bdcht/grandalf")
    (synopsis "Graph and drawing algorithms framework")
    (description
     "Grandalf is a Python package made for experimentations with graphs
drawing algorithms.  It is written in pure Python, and currently implements
two layouts: the Sugiyama hierarchical layout and the force-driven or energy
minimization approach.  While not as fast or featured as graphviz or other
libraries like OGDF (C++), it provides a way to walk and draw graphs no larger
than thousands of nodes, while keeping the source code simple enough to tweak
and hack any part of it for experimental purpose.  With a total of about 1500
lines of Python, the code involved in drawing the Sugiyama (dot) layout fits
in less than 600 lines.  The energy minimization approach is comprised of only
250 lines!

Grandalf does only 2 not-so-simple things:
@itemize
@item computing the nodes (x,y) coordinates (based on provided nodes
dimensions, and a chosen layout)
@item routing the edges with lines or nurbs
@end itemize

It doesn’t depend on any GTK/Qt/whatever graphics toolkit.  This means that it
will help you find where to draw things like nodes and edges, but it’s up to
you to actually draw things with your favorite toolkit.")
    ;; The user can choose either license.
    (license (list license:gpl2 license:epl1.0))))

(define-public python-gridmap
  (package
    (name "python-gridmap")
    (version "0.14.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/pygridtools/gridmap")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0v0sgpg6pz8h61f9aqjf5xk0ipr512bbz8dxzjjylksj135qr19l"))))
    (build-system python-build-system)
    (arguments
     '(#:tests? #f    ;FIXME: Requires python-cherrypy.
       #:phases (modify-phases %standard-phases
                  ;; Importing the web server module requires cherrypy, too.
                  (delete 'sanity-check))))
    (propagated-inputs
     (list python-psutil python-drmaa python-pyzmq))
    (home-page "https://github.com/pygridtools/gridmap")
    (synopsis "Create jobs on a cluster directly from Python")
    (description
      "Gridmap is a Python package to allow you to easily create jobs on the
cluster directly from Python.  You can directly map Python functions onto the
cluster without needing to write any wrapper code yourself.")
    (license license:gpl3+)))

(define-public python-honcho
  (package
    (name "python-honcho")
    (version "1.1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/nickstenning/honcho")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1y0r8dw4pqcq7r4n58ixjdg1iy60lp0gxsd7d2jmhals16ij71rj"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest python-mock python-tox which)) ;for tests
    (propagated-inputs
     (list python-jinja2))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (delete 'check)
         (add-after 'install 'check
           (lambda* (#:key outputs inputs #:allow-other-keys)
             ;; fix honcho path in testsuite
             (substitute* "tests/conftest.py"
               (("'honcho'") (string-append "'" (assoc-ref outputs "out")
                                            "/bin/honcho" "'")))
             ;; It's easier to run tests after install.
             ;; Make installed package available for running the tests
             (add-installed-pythonpath inputs outputs)
             ;; Skip failing test_export
             (invoke "py.test" "-v" "-k" "not test_export"))))))
    (home-page "https://github.com/nickstenning/honcho")
    (synopsis "Manage Procfile-based applications")
    (description
      "A Procfile is a file which describes how to run an application
consisting of several processes. honcho starts all listed processes.
The output of all running processes is collected by honcho and
displayed.")
    (license license:expat)))

(define-public python-hsluv
  (package
    (name "python-hsluv")
    (version "5.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "hsluv" version))
       (sha256
        (base32 "0bmpd7qxcvin8szblilxmw50v7mygf6a6i180h82123s893gk092"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-setuptools python-wheel))
    (home-page "https://www.hsluv.org")
    (synopsis "Human-friendly HSL colour space implemented in Python")
    (description
     "Human-friendly @acronym{Hue Saturation Lightness,HSL}.  HSLuv extends
@url{http://en.wikipedia.org/wiki/CIELUV,CIELUV} with a new saturation
component that allows you to span all the available chroma as a neat
percentage.")
    (license license:expat)))

(define-public python-pebble
  (package
    (name "python-pebble")
    (version "4.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "Pebble" version))
       (sha256
        (base32 "16siqc3brbk7dp4d9sg48bjl6a8wyy24aib3il1hf4y2624draxh"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _ (invoke "python" "-m" "pytest" "-sv"))))))
    (home-page "https://github.com/noxdafox/pebble")
    (synopsis "Threading and multiprocessing for Python")
    (description
     "Pebble aims to help manage threads and processes in an easier way.  It
wraps Python's standard library threading and multiprocessing objects.")
    (license license:lgpl3+)))

(define-public python-pexpect
  (package
    (name "python-pexpect")
    (version "4.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pexpect" version))
       (sha256
        (base32 "03ykxacc64ijldbpa31v5lxw93an0z0xmhm21q2i369w7w942zgf"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "-k" (string-join
                    (list
                     ;; Disable failing test, see
                     ;; <https://github.com/pexpect/pexpect/issues/568>.
                     "not test_bash"
                     ;; Fails with attempt to find OpenSSL.
                     "test_large_stdout_stream"
                     ;; Tests fail while trying to find
                     ;; tmp-pexpect-xxxxxxxxxxxx directories.
                     "test_run_uses_env"
                     "test_run_uses_env_path"
                     "test_run_uses_env_path_over_path"
                     "test_spawn_uses_env"
                     ;; Fails with assertion error: assert 0 == 500
                     "test_before_across_chunks"
                     ;; Bash is enough for tests.
                     "test_zsh")
                    " and not "))
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'prepare-tests
            (lambda _
              (substitute* (find-files "tests")
                (("/bin/bash") (which "bash"))
                (("/bin/echo") (which "echo"))
                (("/bin/ls") (which "ls"))
                (("/bin/which") (which "which"))
                ;; Many tests try to use the /bin directory which is not
                ;; present in the build environment.  Use one that's non-empty
                ;; and unlikely to change.
                (("/bin'") "/dev'")))))))
    (native-inputs
     (list bash    ;full Bash for 'test_replwrap.py'
           man-db
           python-pytest
           python-setuptools
           python-wheel
           which))
    (propagated-inputs
     (list python-ptyprocess))
    (home-page "https://pexpect.readthedocs.org/")
    (synopsis "Controlling interactive console applications")
    (description
     "Pexpect is a pure Python module for spawning child applications;
controlling them; and responding to expected patterns in their output. Pexpect
works like Don Libes’ Expect.  Pexpect allows your script to spawn a child
application and control it as if a human were typing commands.")
    (license license:isc)))

(define-public python-sexpdata
  (package
    (name "python-sexpdata")
    (version "0.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "sexpdata" version))
       (sha256
        (base32
         "1q4lsjyzzqrdv64l0pv4ij9nd8gqhvxqcrpxc2xpxs652sk2gj0s"))))
    (build-system python-build-system)
    (home-page "https://github.com/jd-boyd/sexpdata")
    (synopsis "S-expression parser for Python")
    (description
     "Sexpdata is an S-expression parser/serializer.  It has load and dump
functions like pickle, json or PyYAML module.")
    (license license:bsd-3)))

(define-public python-pathable
  (package
    (name "python-pathable")
    (version "0.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pathable" version))
       (sha256
        (base32 "1ayw9jzlw0qrz51rcfbba00xqq0c7vs3lgwrib67c1z5bcqrv1jw"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #false)) ;there are none
    (native-inputs (list python-poetry-core))
    (home-page "https://github.com/p1c2u/pathable")
    (synopsis "Object-oriented paths")
    (description "With this package you can traverse resources like paths and
access resources on demand with separate accessor layer.")
    (license license:asl2.0)))

(define-public python-pathlib2
  (package
    (name "python-pathlib2")
    (version "2.3.7.post1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pathlib2" version))
       (sha256
        (base32
         "0hf62d0lsf37vnr5fxqp5rfn85njgsr45j4rw71w10wbi6nyvq4z"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-scandir python-six))
    (home-page "https://pypi.org/project/pathlib2/")
    (synopsis "Object-oriented file system paths")
    (description "The goal of pathlib2 is to provide a backport of the
standard @code{pathlib} module which tracks the standard library module, so
all the newest features of the standard @code{pathlib} can be used also on
older Python versions.")
    (license license:expat)))

(define-public python-pathy
  (package
    (name "python-pathy")
    (version "0.10.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pathy" version))
              (sha256
               (base32
                "12v196q3rai33cfzrmb9pqfqv7ailngssjdrzdf8gzym9hdygmjc"))))
    (build-system pyproject-build-system)
    (propagated-inputs
     (list python-smart-open python-typer))
    (native-inputs (list python-mock python-pytest python-setuptools
                         python-wheel))
    (home-page "https://github.com/justindujardin/pathy")
    (synopsis "Path interface for local and cloud bucket storage")
    (description "Pathy is a python package (with type annotations) for
working with Cloud Bucket storage providers using a @code{pathlib} interface.
It provides @code{pathlib.Path} subclasses for local and cloud bucket
storage.")
    (license license:asl2.0)))

(define-public python-importlib-resources
  (package
    (name "python-importlib-resources")
    (version "5.12.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "importlib_resources" version))
              (sha256
               (base32
                "1xi2ggdfdj1bg7w728lvy6j3rjqhklalaanzmscpj7awpy4jbs2b"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; The build system insists on ignoring the existing environment and
         ;; running "pip install".
         (add-after 'unpack 'do-not-use-pip-install
           (lambda _
             (substitute* "pyproject.toml"
               (("^build-backend.*") "\
build-backend = \"backend\"
backend_path = [\"_custom_build\"]\n")
               (("requires = .*") "requires = []\n"))
             (mkdir-p "_custom_build")
             (with-output-to-file "_custom_build/backend.py"
               (lambda _
                 (display "\
from setuptools import build_meta as _orig
from setuptools.build_meta import *
def get_requires_for_build_wheel(config_settings=None):
    return []
def get_requires_for_build_sdist(config_settings=None):
    return []
")))
             (setenv "PYTHONPATH"
                     (string-append (getcwd) "/_custom_build")))))))
    (native-inputs
     (list python-flake8
           python-pytest
           python-pytest-black
           python-pytest-checkdocs
           python-pytest-cov
           python-pytest-enabler
           python-pytest-flake8
           python-pytest-mypy
           python-setuptools-57
           python-setuptools-scm))
    (propagated-inputs
     (list python-zipp))
    (home-page "https://importlib-resources.readthedocs.io/")
    (synopsis "Read resources from Python packages")
    (description
     "@code{importlib_resources} is a backport of Python 3's standard library
@code{importlib.resources} module for Python 2.7, and Python 3.")
    (license license:asl2.0)))

(define-public python-importlib-metadata
  (package
    (name "python-importlib-metadata")
    (version "5.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "importlib_metadata" version))
       (sha256
        (base32
         "1kf7qclcz820xl5wwjpzcwpfy6shj7ymwh4xzxvpl2xs5gb4hka0"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          ;; XXX: PEP 517 manual build/install procedures copied from
          ;; python-isort.
          (replace 'build
            (lambda _
              ;; ZIP does not support timestamps before 1980.
              (setenv "SOURCE_DATE_EPOCH" "315532800")
              (invoke "python" "-m" "build" "--wheel" "--no-isolation" ".")))
          (replace 'install
            (lambda* (#:key outputs #:allow-other-keys)
              (let ((whl (car (find-files "dist" "\\.whl$"))))
                (invoke "pip" "--no-cache-dir" "--no-input"
                        "install" "--no-deps" "--prefix" #$output whl))))
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (invoke "pytest" "-vv" "tests")))))))
    (propagated-inputs (list python-zipp))
    (native-inputs
     (list python-pypa-build
           python-pyfakefs
           python-pytest
           python-setuptools-scm))
    (home-page "https://importlib-metadata.readthedocs.io/")
    (synopsis "Read metadata from Python packages")
    (description
     "@code{importlib_metadata} is a library which provides an API for
accessing an installed Python package's metadata, such as its entry points or
its top-level name.  This functionality intends to replace most uses of
@code{pkg_resources} entry point API and metadata API.  Along with
@code{importlib.resources} in Python 3.7 and newer, this can eliminate the
need to use the older and less efficient @code{pkg_resources} package.")
    (license license:asl2.0)))

(define-public python-importmagic
  (package
    (name "python-importmagic")
    (version "0.1.7")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "importmagic" version))
       (sha256
        (base32
         "1n7qxa1snj06aw45mcfz7bxc46zp7fxj687140g2k6jcnyjmfxrz"))))
    (build-system python-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (replace 'check
                 (lambda* (#:key tests? #:allow-other-keys)
                   (when tests?
                     (invoke "pytest" "-v")))))))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/alecthomas/importmagic")
    (synopsis "Library for adding, removing and managing Python imports")
    (description
     "Importmagic is a Python library for automatically managing imports by
finding unresolved symbols in Python code and their corresponding imports.")
    (license license:bsd-3)))

(define-public python-inotify-simple
  (package
    (name "python-inotify-simple")
    (version "1.3.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/chrisjbillington/inotify_simple")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1dv9svrcz31acyq9smjlnw75xv3x5wpn5h6s8j8h0vrqyl3d7l05"))))
    (build-system python-build-system)
    (home-page
     "https://github.com/chrisjbillington/inotify_simple")
    (synopsis "Simple wrapper around inotify library")
    (description
     "@code{inotify-simple} is a simple wrapper around inotify library.")
    (license license:bsd-3)))

(define-public python-interface-meta
  (package
    (name "python-interface-meta")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "interface_meta" version))
       (sha256
        (base32 "18brkmz2ssjikkrkb23cwccp683yi6y1alfdbmjvjgxpppw96i4a"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-poetry-core python-pytest))
    (home-page "https://github.com/matthewwardrop/interface_meta")
    (synopsis
     "API for enforced method signatures and consistent documentation")
    (description
     "This package provides a convenient way to expose an extensible API with
enforced method signatures and consistent documentation.")
    (license license:expat)))

(define-public python-jaraco-classes
  (package
    (name "python-jaraco-classes")
    (version "3.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jaraco.classes" version))
       (sha256
        (base32 "0d6g7qvfv1jlzbzh6asprqdblqd59grvlvr3nwbdqdqrmwlbfm7d"))))
    (build-system pyproject-build-system)
    (arguments
     (list  ; Do not test the myproject.toml build as it pulls dependencies.
      #:test-flags '(list "-k" "not project")))
    (native-inputs
     (list python-pytest
           python-pytest-black
           python-pytest-checkdocs
           python-pytest-cov
           python-pytest-flake8
           python-pytest-mypy
           python-setuptools
           python-setuptools-scm
           python-wheel))
    (propagated-inputs (list python-more-itertools))
    (home-page "https://github.com/jaraco/jaraco.classes")
    (synopsis "Utility functions for Python class constructs")
    (description "This Python library contains utility functions for Python
class constructs.")
    (license license:expat)))

(define-public python-jaraco-collections
  (package
    (name "python-jaraco-collections")
    (version "5.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jaraco.collections" version))
       (sha256
        (base32 "0s7y3jr7c173k38pck1b17kxnvx2fl0qh9m9gdf64pr9kz8fi00n"))))
    (build-system pyproject-build-system)
    ;; Do not test pyproject.toml with python-pytest-checkdocs as it tries to
    ;; download dependencies.
    (arguments
     '(#:test-flags '("-k" "not project")))
    (propagated-inputs (list python-jaraco-text))
    ;; TODO: Add python-pytest-ruff to native-inputs once it has been
    ;; packaged.
    (native-inputs (list python-pytest
                         python-pytest-black
                         python-pytest-checkdocs
                         python-pytest-cov
                         python-pytest-enabler
                         python-pytest-mypy
                         python-setuptools
                         python-wheel))
    (home-page "https://github.com/jaraco/jaraco.collections")
    (synopsis "Provides various collection objects")
    (description
     "This package provides models and classes to supplement the
standard library @code{collections} module.  Examples include
@itemize
@item
RangeMap: A mapping that accepts a range of values for keys.
@item
Projection: A subset over an existing mapping.
@item
KeyTransformingDict: Generalized mapping with keys transformed by a function.
@item
FoldedCaseKeyedDict: A dict whose string keys are case-insensitive.
@item
BijectiveMap: A map where keys map to values and values back to their keys.
@item
ItemsAsAttributes: A mapping mix-in exposing items as attributes.
@item
IdentityOverrideMap: A map whose keys map by default to themselves unless overridden.
@item
FrozenDict: A hashable, immutable map.
@item
Enumeration: An object whose keys are enumerated.
@item
Everything: A container that contains all things.
@item
Least, Greatest: Objects that are always less than or greater than any other.
@item
pop_all: Return all items from the mutable sequence and remove them from that sequence.
@item
DictStack: A stack of dicts, great for sharing scopes.
@item
WeightedLookup: A specialized RangeMap for selecting an item by weights.
@end itemize")
    (license license:expat)))

(define-public python-jaraco-context
  (package
    (name "python-jaraco-context")
    (version "4.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jaraco.context" version))
       (sha256
        (base32 "0hbjm1rpxf4pzmbdp9rh3ali4zqnlcr8m97bhh1nizxvzcpxim7h"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? (not (%current-target-system))
           ;; Do not test the myproject.toml build as it pulls dependencies.
           #:test-flags '(list "-k" "not project")))
    (native-inputs
     (list python-pytest
           python-pytest-black
           python-pytest-checkdocs
           python-pytest-cov
           python-pytest-flake8
           python-pytest-mypy
           python-setuptools
           python-setuptools-scm
           python-wheel))
    (home-page "https://github.com/jaraco/jaraco.context")
    (synopsis "Context managers Python library")
    (description "This Python library provides context managers-related
procedures.")
    (license license:expat)))

(define-public python-jaraco-functools
  (package
    (name "python-jaraco-functools")
    (version "3.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jaraco.functools" version))
       (sha256
        (base32 "186xqzs3bqhjwajnprxy3sc3h0w5vdld8spc1dxjnn9720yykq1i"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? (not (%current-target-system))
           ;; Do not test the myproject.toml build as it pulls dependencies.
           ;; Do not run a test that tries to emulate a broken proprietary
           ;; CI set-up, fails to do so correctly, and then throws an error.
           #:test-flags
           '(list "-k" "not project and not test_function_throttled")))
    (native-inputs
     (list python-jaraco-classes
           python-pytest
           python-pytest-black
           python-pytest-checkdocs
           python-pytest-cov
           python-pytest-flake8
           python-pytest-mypy
           python-setuptools
           python-setuptools-scm
           python-wheel))
    (propagated-inputs (list python-more-itertools))
    (home-page "https://github.com/jaraco/jaraco.functools")
    (synopsis "Python library extending Python's @code{functools}")
    (description "This library extends the standard @code{functools} Python
module with a few extra procedures.")
    (license license:expat)))

(define-public python-jaraco-packaging
  (package
    (name "python-jaraco-packaging")
    (version "6.1")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "jaraco.packaging" version))
        (sha256
          (base32
            "0zimrnkh33b9g8ffw11mjh6kvs54cy5gcjw1h5cl1r7dc833dmkm"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:test-flags
           '(list "-k" "not project and not test_revived_distribution")))
    (propagated-inputs
     (list python-pytest
           python-pytest-checkdocs
           python-pytest-flake8
           python-rst.linker
           python-setuptools
           python-setuptools-scm
           python-six
           python-sphinx))
    (home-page "https://github.com/jaraco/jaraco.packaging")
    (synopsis "Tools to supplement packaging Python releases")
    (description
     "This package provides various tools to supplement packaging Python
releases.")
    (license license:expat)))

(define-public python-jaraco-test
  (package
    (name "python-jaraco-test")
    (version "5.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jaraco_test" version))
       (sha256
        (base32 "0xfkly5w4i4npi4pq1g32y8q8iijkq4pfcfs8wcjhfn4amj6212c"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:test-flags '(list "-k" "http")))
    (native-inputs
     (list python-jaraco-collections
           python-pytest
           python-pytest-checkdocs
           python-pytest-enabler
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-jaraco-context
           python-jaraco-functools))
    (home-page "https://github.com/jaraco/jaraco.test")
    (synopsis "Testing support by jaraco")
    (description "This package provides testing support by jaraco.")
    (license license:expat)))

(define-public python-jaraco-text
  (package
    (name "python-jaraco-text")
    (version "3.12.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jaraco.text" version))
       (sha256
        (base32 "0b2rmx0sa61f75lkkr4nfaj3mkgmn3x9c1akpwarfbmksk42b7iq"))))
    (build-system pyproject-build-system)
    ;; Do not test pyproject.toml with python-pytest-checkdocs as it tries to
    ;; download dependencies.
    (arguments
     '(#:test-flags '("-k" "not project")))
    (propagated-inputs (list python-autocommand python-inflect
                             python-jaraco-context python-jaraco-functools
                             python-more-itertools))
    ;; TODO: Add python-pytest-ruff to native-inputs once it has been
    ;; packaged.
    (native-inputs (list python-pytest
                         python-pytest-black
                         python-pytest-checkdocs
                         python-pytest-cov
                         python-pytest-enabler
                         python-pytest-mypy
                         python-setuptools
                         python-wheel))
    (home-page "https://github.com/jaraco/jaraco.text")
    (synopsis "Provides various routines for text manipulation")
    (description
     "This package provides handy routines for dealing with text,
such as wrapping, substitution, trimming, stripping, prefix and suffix
removal, line continuation, indentation, comment processing, identifier
processing, values parsing, case insensitive comparison, and more.")
    (license license:expat)))

(define-public python-pypytools
  (package
    (name "python-pypytools")
    (version "0.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pypytools" version))
       (sha256
        (base32 "0ag5xyzagprji0m2pkqsfy8539s003mn41pl6plbmh6iwi9w0h51"))))
    (build-system python-build-system)
    (arguments (list #:tests? #f)) ; no tests
    (propagated-inputs (list python-py))
    (home-page "https://github.com/antocuni/pypytools/")
    (synopsis
     "Tools to use PyPy-specific features, with CPython fallbacks")
    (description
     "This package provides a collection of useful tools to use PyPy-specific
features, with CPython fallbacks.")
    (license license:x11)))

(define-public python-simplegeneric
  (package
    (name "python-simplegeneric")
    (version "0.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "simplegeneric" version ".zip"))
       (sha256
        (base32 "0wwi1c6md4vkbcsfsf8dklf3vr4mcdj4mpxkanwgb6jb1432x5yw"))))
    (build-system python-build-system)
    (native-inputs
     (list unzip))
    (home-page "https://cheeseshop.python.org/pypi/simplegeneric")
    (synopsis "Python module for simple generic functions")
    (description
     "The simplegeneric module lets you define simple single-dispatch generic
functions, akin to Python’s built-in generic functions like @code{len()},
@code{iter()} and so on.  However, instead of using specially-named methods,
these generic functions use simple lookup tables, akin to those used by
e.g. @code{pickle.dump()} and other generic functions found in the Python
standard library.")
    (license license:zpl2.1)))

(define-public python-ipython-genutils
  ;; TODO: This package is retired, check if can be removed, see description.
  (package
    (name "python-ipython-genutils")
    (version "0.1.0")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "ipython_genutils" version))
      (sha256
       (base32 "19l2pp1c64ansr89l3cqh19jdi2ixhssdzx0vz4n6r52a6i281is"))))
    (build-system python-build-system)
    (arguments `(#:tests? #f)) ; no tests
    (home-page "https://ipython.org")
    (synopsis "Vestigial utilities from IPython")
    (description
     "This package provides retired utilities from IPython.  No packages
outside IPython/Jupyter should depend on it.

This package shouldn't exist.  It contains some common utilities shared by
Jupyter and IPython projects during The Big Split.  As soon as possible, those
packages will remove their dependency on this, and this package will go
away.")
    (license license:bsd-3)))

;;; Variant used to break a cycle with python-ipykernel.
(define-public python-ipyparallel-bootstrap
  (hidden-package
   (package
     (name "python-ipyparallel-bootstrap")
     (version "8.2.1")
     (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "ipyparallel" version))
        (sha256
         (base32
          "0wiwfd7870zbmczzn96jqxxjf2zcbcaxnsl1ddn8hspwa8y4frzj"))))
     (build-system python-build-system)
     (arguments
      (list
       #:tests? #f
       #:phases #~(modify-phases %standard-phases
                    ;; The python-ipykernel is normally propagated but is
                    ;; removed from this package to break the cycle.
                    (delete 'sanity-check))))
     (propagated-inputs
      (list python-dateutil
            python-decorator
            python-entrypoints
            python-ipython
            ;; python-ipykernel is omitted here to break a cycle.
            python-jupyter-client-bootstrap
            python-psutil
            python-pyzmq
            python-tornado-6
            python-tqdm
            python-traitlets))
     (home-page "https://ipython.org/")
     (synopsis "Interactive Parallel Computing with IPython")
     (description
      "@code{ipyparallel} is a Python package and collection of CLI scripts for
controlling clusters for Jupyter.  @code{ipyparallel} contains the following
CLI scripts:
@enumerate
@item ipcluster - start/stop a cluster
@item ipcontroller - start a scheduler
@item ipengine - start an engine
@end enumerate")
     (license license:bsd-3))))

(define-public python-ipyparallel
  (package
    (inherit python-ipyparallel-bootstrap)
    (name "python-ipyparallel")
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda _
              (invoke "pytest" "-vv"))))))
    (native-inputs
     (list python-ipython
           python-pytest
           python-pytest-asyncio
           python-pytest-cov
           python-pytest-tornado
           python-testpath))
    (propagated-inputs
     (modify-inputs (package-propagated-inputs python-ipyparallel-bootstrap)
       (replace "python-jupyter-client-bootstrap" python-jupyter-client)
       (append python-ipykernel)))
    (properties (alist-delete 'hidden? (package-properties
                                        python-ipyparallel-bootstrap)))))

(define-public python-ipython-cluster-helper
  (package
    (name "python-ipython-cluster-helper")
    (version "0.6.4")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "ipython-cluster-helper" version))
        (sha256
         (base32
          "1l6mlwxlkxpbvawfwk6qffich7ahg9hq2bxfissgz6144p3k4arj"))
        (modules '((guix build utils)))
        (snippet
         '(begin (substitute* "requirements.txt"
                   (("ipython.*") "ipython\n"))
                 #t))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f      ; Test suite can't find IPython.
       #:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key inputs outputs tests? #:allow-other-keys)
             (if tests?
               (begin
                 (setenv "HOME" (getcwd))
                 (add-installed-pythonpath inputs outputs)
                 (invoke "python" "example/example.py" "--local"))
               #t))))))
    (propagated-inputs
     (list python-ipyparallel
           python-ipython
           python-netifaces
           python-pyzmq
           python-setuptools
           python-six))
    (home-page "https://github.com/roryk/ipython-cluster-helper")
    (synopsis
     "Simplify IPython cluster start up and use for multiple schedulers")
    (description
     "@code{ipython-cluster-helper} creates a throwaway parallel IPython
profile, launches a cluster and returns a view.  On program exit it shuts the
cluster down and deletes the throwaway profile.")
    (license license:expat)))

(define-public python-ipython-sql
  (package
    (name "python-ipython-sql")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ipython-sql" version))
       (sha256
        (base32 "1r6rz8jgrqzhkf2flwjw75d96g8l7kykmx5wli3q1988w96391ip"))))
    (build-system python-build-system)
    (arguments
     (list #:tests? #f                  ;must run under IPython
           #:phases
           #~(modify-phases %standard-phases
               (add-after 'unpack 'permit-newer-prettytable
                 ;; See https://github.com/catherinedevlin/ipython-sql/issues/202
                 (lambda _
                   (substitute* "setup.py"
                     (("prettytable<1")
                      "prettytable")))))))
    (propagated-inputs
     (list python-ipython
           python-ipython-genutils
           python-prettytable
           python-six
           python-sqlalchemy
           python-sqlparse))
    (home-page "https://github.com/catherinedevlin/ipython-sql")
    (synopsis "RDBMS access via IPython")
    (description "This library connects to a database, using SQLAlchemy URL
connect strings, then issue SQL commands within IPython or IPython Notebook.")
    (license license:expat)))

(define-public python-traitlets
  (package
    (name "python-traitlets")
    (version "5.14.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "traitlets" version))
       (sha256
        (base32
         "0zjj8ha4z5lbhhmvcl3q8wp5qmwqq0lwxma3d8qvh10s6xdi11c5"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      '(list "-k" "not mypy_list_typing and not mypy_dict_typing")))
    (native-inputs
     (list python-argcomplete
           python-hatchling
           python-mypy
           python-pytest
           python-pytest-mock
           python-pytest-mypy-testing))
    (home-page "https://ipython.org")
    (synopsis "Configuration system for Python applications")
    (description
     "Traitlets is a framework that lets Python classes have attributes with
type checking, dynamically calculated default values, and ‘on change’
callbacks.  The package also includes a mechanism to use traitlets for
configuration, loading values from files or from command line arguments.  This
is a distinct layer on top of traitlets, so you can use traitlets in your code
without using the configuration machinery.")
    (license license:bsd-3)))

(define-public python-treelib
  (package
    (name "python-treelib")
    (version "1.7.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "treelib" version))
              (sha256
               (base32
                "0qgv61g1p06kzf5fd2hcim5s49nzbv8k210frnk45rmr2vs1mzwv"))))
    (build-system python-build-system)
    (propagated-inputs (list python-six))
    (home-page "https://github.com/caesar0301/treelib")
    (synopsis "Implementation of a tree structure in Python")
    (description
     "This package provides a Python implementation of a tree structure.")
    (license license:asl2.0)))

(define-public python-optree
  (package
    (name "python-optree")
    (version "0.14.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/metaopt/optree")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "17zph1jgzk0zaanj7057qj8x5cml8j66ip0xmlbwmq4396hmdlbs"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; These tests fails due to a circular import
      '`("-k" ,(string-append "not test_treespec_pickle_missing_registration"
                              " and not test_import_no_warnings"))))
    (propagated-inputs (list python-typing-extensions))
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel
           cmake-minimal
           pybind11-2.13))
    (home-page "https://github.com/metaopt/optree")
    (synopsis "Optimized PyTree Utilities")
    (description "This package contains operations on PyTrees (a tree made of
container data structures in Python).")
    (license license:asl2.0)))

(define-public python-jupyter-core
  (package
    (name "python-jupyter-core")
    (version "5.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (string-append (pypi-uri "jupyter_core" version)))
       (sha256
        (base32
         "1n9nyp1skljbbkqp4j7mnihnyp83j9rxm5h4hfn33d7npcr8spxa"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      '(list "-k"
             (string-append
              ;; XXX: These tests fail with "ModuleNotFoundError: No
              ;; module named 'jupyter_core'".
              "not test_argv0"
              " and not test_path_priority "
              " and not test_not_on_path"

              ;; These fail with: An incompatible sibling of 'AsyncTornadoApp'
              ;; is already instantiated as singleton: SyncTornadoApp
              " and not test_async_app"
              " and not test_async_tornado_app"

              ;; Fails with a deprecation warning
              " and not test_sync_tornado_run"))
      #:phases
      '(modify-phases %standard-phases
         (add-before 'check 'pre-check
           ;;  Some tests write to $HOME.
           (lambda _ (setenv "HOME" "/tmp")))
         ;; Migration is running whenever etc/jupyter exists, but the
         ;; Guix-managed directory will never contain any migratable IPython
         ;; config files and cannot be written to anyway, so just pretend we
         ;; already did that.
         (add-after 'install 'disable-migration
           (lambda* (#:key outputs #:allow-other-keys)
             (mkdir-p (string-append (assoc-ref outputs "out") "/etc/jupyter"))
             (invoke "touch"
                     (string-append
                      (assoc-ref outputs "out")
                      "/etc/jupyter/migrated")))))))
    (propagated-inputs (list python-platformdirs python-traitlets))
    (native-inputs (list python-hatchling
                         python-pip
                         python-pre-commit
                         python-pytest
                         python-pytest-cov
                         python-pytest-timeout))
    ;; This package provides the `jupyter` binary and thus also exports the
    ;; search paths.
    (native-search-paths
     (list (search-path-specification
            (variable "JUPYTER_CONFIG_PATH")
            (files '("etc/jupyter")))
           (search-path-specification
            (variable "JUPYTER_PATH")
            (files '("share/jupyter")))))
    (home-page "https://jupyter.org/")
    (synopsis "Jupyter base package")
    (description
     "Jupyter core is the base package on which Jupyter projects rely.")
    (license license:bsd-3)))

;; Bootstrap variant of jupyter-client, which breaks the loop between ipykernel
;; and jupyter-client by removing the former from its native-inputs and
;; disabling tests.
(define-public python-jupyter-client-bootstrap
  (hidden-package
   (package
     (name "python-jupyter-client-bootstrap")
     (version "7.4.4")
     (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "jupyter_client" version))
        (sha256
         (base32
          "0ck8fb0d582r8izkcn7087zmbmmqf9jkv2abd8p44867k9hdn5jn"))))
     (build-system pyproject-build-system)
     (arguments
      (list
       #:tests? #f
       #:phases
       #~(modify-phases %standard-phases
           ;; The deprecation warnings break the tests.
           (add-after 'unpack 'hide-zmq-deprecation-warnings
             (lambda _
               (substitute* "pyproject.toml"
                 (("\"ignore:There is no current event loop:DeprecationWarning:zmq\"," m)
                  (string-append m "
\"ignore:zmq.eventloop.ioloop.*:DeprecationWarning\",
\"ignore:zmq.tests.BaseZMQTestCase.*:DeprecationWarning\"")))))
           (add-after 'unpack 'set-tool-file-names
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "jupyter_client/localinterfaces.py"
                 (("'ip'")
                  (format #f "'~a'" (search-input-file inputs "sbin/ip")))))))))
     (inputs (list iproute))
     (propagated-inputs
      (list python-dateutil
            python-entrypoints
            python-jupyter-core
            python-nest-asyncio
            python-pyzmq
            python-tornado-6
            python-traitlets))
     (native-inputs
      (list python-hatchling))
     (home-page "https://jupyter.org/")
     (synopsis "Jupyter protocol implementation and client libraries")
     (description
      "The @code{jupyter_client} package contains the reference implementation
of the Jupyter protocol.  It also provides client and kernel management APIs
for working with kernels, and the @code{jupyter kernelspec} entrypoint for
installing @code{kernelspec}s for use with Jupyter frontends.")
     (license license:bsd-3))))

(define-public python-jupyter-client
  (let ((base python-jupyter-client-bootstrap))
    (package
      (inherit base)
      (name "python-jupyter-client")
      (arguments
       (substitute-keyword-arguments (package-arguments base)
         ((#:tests? _ #f)
          (not (%current-target-system)))
         ((#:phases phases #~%standard-phases)
          #~(modify-phases #$phases
              (replace 'check
                (lambda* (#:key tests? #:allow-other-keys)
                  (when tests?
                    ;; Some tests try to write to $HOME.
                    (setenv "HOME" "/tmp")
                    ;; jupyter-core demands this be set.
                    (setenv "JUPYTER_PLATFORM_DIRS" "1")
                    (invoke "pytest" "-vv" "-Wignore::DeprecationWarning"
                            "-k"
                            ;; XXX "RuntimeError: Kernel died before replying
                            ;; to kernel_info", but there's no more
                            ;; information.
                            "not test_start_parallel_process_kernels"))))))))
      (native-inputs
       (list python-hatchling
             python-pytest
             python-pytest-asyncio
             python-pytest-timeout
             python-async-generator
             python-ipython
             python-ipykernel-bootstrap))
      (properties (alist-delete 'hidden? (package-properties base))))))

(define-public python-ipykernel
  (package
    (name "python-ipykernel")
    (version "6.29.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ipykernel" version))
       (sha256
        (base32 "0p5g897pq6k9nr44ihlk4hp5s46zz8ih2xib1715lizrc000fi1x"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:modules '((guix build pyproject-build-system)
                  (guix build utils)
                  (ice-9 match))
      #:test-flags
      ;; XXX: probably not good that this fails
      '(list "-k" "not test_copy_to_globals" "-Wignore::DeprecationWarning")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'relax-a-bit
            (lambda _
              ;; I'm sure nobody will notice.
              (substitute* "pyproject.toml"
                (("debugpy>=1.6.5") "debugpy>=1.6.0"))))
          ;; The deprecation warnings break the tests.
          (add-after 'unpack 'hide-deprecation-warnings
            (lambda _
              (substitute* "pyproject.toml"
                (("\"ignore:There is no current event loop:DeprecationWarning\"" m)
                 (string-append m ",
\"ignore:the imp module is deprecated:DeprecationWarning\",
\"ignore:pytest-asyncio detected an unclosed event loop:DeprecationWarning\",
\"ignore:make_current is deprecated.*:DeprecationWarning\",
\"ignore:zmq.eventloop.ioloop.*:DeprecationWarning\",
\"ignore:zmq.tests.BaseZMQTestCase.*:DeprecationWarning\"")))))
           (add-before 'check 'pre-check
             (lambda _
               ;; jupyter-core demands this be set.
               (setenv "JUPYTER_PLATFORM_DIRS" "1")
               (setenv "HOME" "/tmp")))
          (add-after 'install 'set-python-file-name
            (lambda* (#:key inputs #:allow-other-keys)
              ;; Record the absolute file name of the 'python' executable in
              ;; 'kernel.json'.
              (substitute* (string-append #$output "/share/jupyter"
                                          "/kernels/python3/kernel.json")
                (("\"python\"")
                 (format #f "~s" (search-input-file inputs
                                                    "/bin/python3")))))))))
    (propagated-inputs
     (list python-comm
           python-debugpy
           python-ipython
           python-jupyter-client
           python-jupyter-core
           python-matplotlib-inline
           python-nest-asyncio
           python-packaging
           python-psutil
           python-pyzmq
           python-tornado-6
           python-traitlets))
    (inputs (list python))              ;for cross compilation
    (native-inputs
     (list python-flaky
           python-hatchling
           python-ipyparallel-bootstrap
           python-pytest
           python-pytest-asyncio
           python-pytest-cov
           python-pytest-timeout))
    (home-page "https://ipython.org")
    (synopsis "IPython Kernel for Jupyter")
    (description "This package provides the IPython kernel for Jupyter.")
    (license license:bsd-3)))

;; Bootstrap variant of ipykernel, which uses the bootstrap jupyter-client to
;; break the cycle between ipykernel and jupyter-client.
(define-public python-ipykernel-bootstrap
  (let ((parent python-ipykernel))
    (hidden-package
      (package
        (inherit parent)
        (name "python-ipykernel-bootstrap")
        (arguments (list #:tests? #f
                         ;; The package should normally propagate ipykernel,
                         ;; left out here to break the cycle.
                         #:phases #~(modify-phases %standard-phases
                                      (delete 'sanity-check))))
        (native-inputs (list python-hatchling))
        (propagated-inputs
         (modify-inputs (package-propagated-inputs parent)
           (replace "python-jupyter-client" python-jupyter-client-bootstrap)))))))

(define-public python-pari-jupyter
  (package
    (name "python-pari-jupyter")
    (version "1.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pari-jupyter" version))
       (sha256
        (base32
         "1ikqvv335qfrhmlji0iclci6pnm2c3fvnxf031jr1d68j79g6ypd"))))
    (build-system python-build-system)
    (arguments '(#:tests? #f))          ;no test suite
    (inputs
     (list pari-gp readline python-ipykernel))
    (home-page "https://github.com/sagemath/pari-jupyter")
    (synopsis "Jupyter kernel for PARI/GP")
    (description "The package provides a PARI/GP kernel for Jupyter.")
    (license license:gpl3+)))

(define-public python-backcall
  (package
    (name "python-backcall")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "backcall" version))
       (sha256
        (base32
         "07jy4562lvnhkk6kfr3cphmizy88anlhmbwb8kdzlz2ypqkvzgaw"))))
    (build-system python-build-system)
    (home-page "https://github.com/takluyver/backcall/")
    (synopsis "Specifications for callback functions passed in to an API")
    (description
     "If your code lets other people supply callback functions, it's important
to specify the function signature you expect, and check that functions support
that.  Adding extra parameters later would break other peoples code unless
you're careful.  The @code{backcall} package provides a way of specifying the
callback signature using a prototype function.")
    (license license:bsd-3)))

(define-public python-pubmed-parser
  (package
    (name "python-pubmed-parser")
    (version "0.3.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/titipata/pubmed_parser")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "195cmjjg7xdwjj5455h78q7jnxnccia07a19xwndhlkxv7vk9v60"))))
    (build-system pyproject-build-system)
    (propagated-inputs
     (list python-lxml
           python-numpy
           python-requests
           python-six
           python-unidecode))
    (native-inputs
     (list python-pytest
           python-pytest-cov
           python-setuptools
           python-wheel))
    (home-page "https://github.com/titipata/pubmed_parser")
    (synopsis "Parser for Pubmed Open-Access Subset and MEDLINE XML repository")
    (description
     "This package provides a Python parser for Pubmed Open-Access Subset and
MEDLINE XML repository.")
    (license license:expat)))

(define-public python-pure-eval
  (package
    (name "python-pure-eval")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pure_eval" version))
       (sha256
        (base32 "0hmg1qcv1h5k0dyj7sfp54ibnmjrvf4awdc6gin5fk2n80zrhkjz"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-setuptools-scm
           python-wheel))
    (home-page "https://github.com/alexmojaki/pure_eval")
    (synopsis "Python library to evaluate abstract syntax tree nodes")
    (description "The @code{pure_eval} Python library can safely evaluate
abstract syntax tree (AST) nodes without side effects.")
    (license license:expat)))

(define-public python-puremagic
  (package
    (name "python-puremagic")
    (version "1.28")
    (source
     (origin
       (method git-fetch)               ;no tests in PyPI archive
       (uri (git-reference
             (url "https://github.com/cdgriffith/puremagic")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0sffrjjqh37ijwnggyvs2rfm4iwaz2m395wqg0x727wv8i0x3f3b"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/cdgriffith/puremagic")
    (synopsis "Pure Python implementation of magic file detection")
    (description
     "This package implements a functionality that will identify a file based
off it's magic numbers.")
    (license license:expat)))

(define-public python-ast-decompiler
  (package
    (name "python-ast-decompiler")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ast_decompiler" version))
       (sha256
        (base32 "0dw3fck4ajilphqw4hdpa8pmqxg3jfk2xkmjnk3kx5pqwl3sbhzg"))
       ;; We need to manually create an __init__.py file under the tests/
       ;; directory, since it is not included in the distributed
       ;; version. (See:
       ;; https://github.com/JelleZijlstra/ast_decompiler/issues/52).
       (modules '((guix build utils)))
       (snippet '(call-with-output-file "tests/__init__.py"
                   (const #t)))))
    (build-system pyproject-build-system)
    (native-inputs (list python-flit-core python-pytest))
    (home-page "https://github.com/JelleZijlstra/ast_decompiler")
    (synopsis
     "Decompile an @acronym{AST, Abstract Syntax Tree} to Python code")
    (description
     "This library provides functionality to decompile @acronym{AST, Abstract
Syntax Tree} objects, as generated by the standard library @code{ast} module,
to Python code.")
    (license license:asl2.0)))

(define-public python-asttokens
  (package
    (name "python-asttokens")
    (version "2.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "asttokens" version))
       (sha256
        (base32 "182b4l8sys07a46icg68h7b3d8iqkzvgsjqkgq1fp9m9idqnjf5h"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-astroid
           python-pytest
           python-setuptools
           python-setuptools-scm
           python-wheel))
    (propagated-inputs
     (list python-six))
    (home-page "https://github.com/gristlabs/asttokens")
    (synopsis "Python library to annotate abstract syntax trees")
    (description "The @code{asttokens} module annotates Python abstract syntax
trees (ASTs) with the positions of tokens and text in the source code that
generated them.  It makes it possible for tools that work with logical AST
nodes to find the particular text that resulted in those nodes, for example
for automated refactoring or highlighting.")
    (license license:asl2.0)))

(define-public python-littleutils
  (package
    (name "python-littleutils")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "littleutils" version))
       (sha256
        (base32 "0vwijrylppmk0nbddqvn527r9cg3zw8d6zk6r58hslry42jf7jp6"))))
    (build-system python-build-system)
    (home-page "https://github.com/alexmojaki/littleutils")
    (synopsis "Python utility function collection")
    (description "@code{littleutils} is a small collection of Python utility
functions, useful in the context of writing unit tests among other uses.")
    (license license:expat)))

(define-public python-stack-data
  (package
    (name "python-stack-data")
    (version "0.6.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "stack_data" version))
       (sha256
        (base32 "1fgh900z6g1amb2f2ql461c1y8lazymxi7nqvk8xri7ywj6pfsl3"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'set-home-env
            (lambda _
              (setenv "HOME" "/tmp"))))))
    (native-inputs
     (list python-cython
           python-littleutils
           python-pygments
           python-pytest
           python-setuptools
           python-setuptools-scm
           python-typeguard
           python-wheel))
    (propagated-inputs
     (list python-asttokens
           python-executing
           python-pure-eval))
    (home-page "https://github.com/alexmojaki/stack_data")
    (synopsis "Python stack frame and traceback manipulation library")
    (description "The @code{stack_data} Python library extracts data from
stack frames and tracebacks.  Is can be used to display more useful tracebacks
than the default.")
    (license license:expat)))

(define-public python-ipython
  (package
    (name "python-ipython")
    (version "8.29.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ipython/ipython")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "03yrq0wsi98y1v3rf7ai013xhv46i7167dccp1244sfvrsrs4962"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      '(list "-k"
             ;; These need git.
             "not test_json_getsysinfo and not IPython.utils.sysinfo.sys_info")
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'make-docs-reproducible
           (lambda _
             (substitute* "IPython/sphinxext/ipython_directive.py"
               ((".*import datetime") "")
               ((".*datetime.datetime.now\\(\\)") "")
               (("%timeit") "# %timeit"))))
         (replace 'check
           (lambda* (#:key tests? test-flags #:allow-other-keys)
             (when tests?
               (setenv "HOME" "/tmp/")  ;required by some tests
               (apply invoke "python" "-m" "pytest" "-vv"
                      test-flags)))))))
    (inputs (list readline which))
    (propagated-inputs
     (list python-colorama
           python-decorator
           python-exceptiongroup
           python-jedi
           python-matplotlib-inline
           python-pexpect
           python-prompt-toolkit
           python-pygments
           python-stack-data
           python-traitlets
           python-typing-extensions))
    (native-inputs
     (list python-curio
           python-matplotlib
           python-nbformat
           python-numpy
           python-pandas
           python-pickleshare
           python-pytest
           python-pytest-asyncio
           python-setuptools
           python-testpath
           python-wheel))
    (home-page "https://ipython.org")
    (synopsis "IPython is a tool for interactive computing in Python")
    (description
     "IPython provides a rich architecture for interactive computing with:
Powerful interactive shells, a browser-based notebook, support for interactive
data visualization, embeddable interpreters and tools for parallel
computing.")
    (properties '((cpe-name . "ipython")))
    (license license:bsd-3)))

(define-public python-ipython-documentation
  (package
    (inherit python-ipython)
    (name "python-ipython-documentation")
    (version (package-version python-ipython))
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'set-pythonpath
            (lambda _
              ;; Ensure this fixed (via the
              ;; "python-ipython-documentation-chars.patch" patch) copy of
              ;; IPython gets used.
              (setenv "PYTHONPATH" (string-append (getcwd)))))
          (add-before 'build 'configure-sphinx-for-xelatex
            (lambda _
              ;; Use XeLaTeX instead of PDFLaTeX, as it can
              ;; cope with the Unicode characters present in the
              ;; contributors page, for example.
              (substitute* "docs/source/conf.py"
                (("project = 'IPython'.*" all)
                 (string-append all "latex_engine = 'xelatex'\n")))
              ;; XXX: The Sphinx-generated ipython.tex specifies the GNU
              ;; FreeFont font to be searched via its extension, which uses
              ;; kpathsea instead of fontconfig and fail (see:
              ;; https://github.com/sphinx-doc/sphinx/issues/10347).  Create a
              ;; symlink to GNU FreeFont and add it to the TEXMF tree via
              ;; GUIX_TEXMF.
              (mkdir-p "texmf-dist/fonts/opentype/public")
              (symlink (string-append
                        #$(this-package-native-input "font-gnu-freefont")
                        "/share/fonts/opentype")
                       (string-append
                        (getcwd) "/"
                        "texmf-dist/fonts/opentype/public/gnu-freefont"))
              (setenv "GUIX_TEXMF" (string-append (getenv "GUIX_TEXMF") ":"
                                                  (getcwd) "/texmf-dist"))))
          (delete 'build)
          (delete 'check)
          (replace 'install
            (lambda* (#:key outputs #:allow-other-keys)
              (let* ((data (string-append #$output "/share"))
                     (doc (string-append data "/doc/" #$name "-" #$version))
                     (html (string-append doc "/html"))
                     (info (string-append data "/info")))
                (invoke "make" "-C" "docs" "info" "html" "pdf"
                        (string-append "SPHINXOPTS=-j"
                                       (number->string (parallel-job-count))))
                (install-file "COPYING.rst" doc)
                (copy-recursively "examples" (string-append doc "/examples"))
                ;; Install HTML documentation.
                (copy-recursively "docs/build/html" html)
                ;; Likewise for the PDF.
                (install-file "docs/build/latex/ipython.pdf" doc)
                ;; Likewise for the info manual.
                (install-file "docs/build/texinfo/ipython.info" info)
                (symlink (string-append html "/_images")
                         (string-append info "/ipython-figures"))))))))
    (native-inputs
     (list fontconfig                   ;for XDG_DATA_DIRS to locate fonts
           font-gnu-freefont
           graphviz
           python-docrepr
           python-ipykernel
           python-sphinx
           python-sphinx-rtd-theme
           texinfo
           (texlive-updmap.cfg
            (list texlive-latexmk
                  texlive-polyglossia
                  texlive-xetex
                  texlive-xindy))))))

(define-public python-uri-template
  (package
    (name "python-uri-template")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "uri-template" version))
       (sha256
        (base32 "1ixczlgnsjv2850r6w0cb2npwcwzdqri8njr1pi7v371cpmzh00f"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "python3" "test.py")))))))
    (native-inputs
     (list python-setuptools
           python-setuptools-scm
           python-wheel))
    (home-page "https://gitlab.linss.com/open-source/python/uri-template")
    (synopsis "RFC 6570 URI Template Processor")
    (description "This package implements URI Template expansion in strict
adherence to RFC 6570, but adds a few extensions.")
    (license license:expat)))

(define-public python-urwid
  (package
    (name "python-urwid")
    (version "2.6.16")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "urwid" version))
       (sha256
        (base32
         "18ijvgf1l7jvmg45x1cysn3c9rdrg1w0405acig3hk7476cj7bck"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "tests"
              ;; According to Debian these tests are cursed.
              ;; https://salsa.debian.org/python-team/packages/urwid/-/blob/debian/2.1.2-2/debian/changelog#L141
               "--ignore=tests/test_vterm.py")))
    (native-inputs
     (list python-pytest
           python-pytest-cov
           python-setuptools
           python-setuptools-scm
           python-wheel))
    (propagated-inputs
     (list python-typing-extensions
           python-wcwidth

           ;; Optional, but tests need them.
           python-pygobject
           python-tornado
           python-trio
           python-pyzmq
           python-twisted))
    (home-page "https://urwid.org")
    (synopsis "Console user interface library for Python")
    (description
     "Urwid is a curses-based UI/widget library for Python.  It includes many
features useful for text console applications.")
    (license license:lgpl2.1+)))

(define-public python-urwid-readline
  (package
    (name "python-urwid-readline")
    (version "0.13")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/rr-/urwid_readline")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0y9k86p31mlr9rwnrbljvfgl183r5j60yaj0r3scljn1m0mlg8qg"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest" "-vv")))))))
    (propagated-inputs (list python-urwid))
    (native-inputs (list python-pytest))
    (home-page "https://github.com/rr-/urwid_readline")
    (synopsis "Text input widget for urwid that supports readline shortcuts")
    (description
     "This package provides a textbox edit widget for @code{python-urwid} that
supports @code{readline} shortcuts.")
    (license license:expat)))

(define-public python-urwidgets
  (package
    (name "python-urwidgets")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "urwidgets" version))
       (sha256
        (base32 "1vrydw9h8c5gi89dnv12a9cdyyxaffvxl1kq51f118cxjk9brwpr"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-urwid))
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/AnonymouX47/urwidgets")
    (synopsis "Collection of widgets for urwid")
    (description
     "This package provides a collection of widgets for urwid.")
    (license license:expat)))

(define-public python-textdistance
  (package
    (name "python-textdistance")
    (version "4.6.3")
    (source
     (origin
       ;; There are no tests in the PyPI tarball.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/life4/textdistance")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1qaplikab46p38jqr93bxd26vvxcnvib15fjxmmp4cbsiy5196sg"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "--numprocesses" (number->string (parallel-job-count)))))
    (native-inputs
     (list python-numpy
           python-pytest
           python-pytest-xdist
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-jellyfish
           python-distance
           python-levenshtein
           python-pylev
           python-pyxdameraulevenshtein
           python-rapidfuzz))
    (home-page "https://github.com/life4/textdistance")
    (synopsis "Compute distance between the two texts")
    (description "@code{textdistance} is a pure Python library for comparing
distance between two or more sequences by many algorithms.")
    (license license:expat)))

(define-public python-urwidtrees
  (package
    (name "python-urwidtrees")
    (version "1.0.3")
    (source
      (origin
        (method git-fetch)
        ;; package author intends on distributing via github rather than pypi:
        ;; https://github.com/pazz/alot/issues/877#issuecomment-230173331
        (uri (git-reference
               (url "https://github.com/pazz/urwidtrees")
               (commit version)))
        (file-name (git-file-name name version))
        (sha256
          (base32
           "1y1vysx7jg0vbrarlsykhf7nmr8fc6k1fva1q3i98xq2m30s6r68"))))
    (build-system python-build-system)
    (arguments
     '(#:tests? #f)) ; no tests
    (propagated-inputs (list python-urwid))
    (native-inputs (list python-mock))
    (home-page "https://github.com/pazz/urwidtrees")
    (synopsis "Tree widgets for urwid")
    (description "Urwidtrees is a Widget Container API for the @code{urwid}
toolkit.  Use it to build trees of widgets.")
    (license license:gpl3+)))

(define-public python-ua-parser
  (package
    (name "python-ua-parser")
    (version "0.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ua-parser" version))
       (sha256
        (base32
         "0csh307zfz666kkk5idrw3crj1x8q8vsqgwqil0r1n1hs4p7ica7"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))                    ;no test suite in release
    (native-inputs
     (list python-pyyaml))
    (home-page "https://github.com/ua-parser/uap-python")
    (synopsis "User agent parser")
    (description
     "@code{ua-parser} is a Python port of Browserscope's user agent parser.")
    (license license:asl2.0)))

(define-public python-user-agents
  (package
    (name "python-user-agents")
    (version "2.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "user-agents" version))
       (sha256
        (base32
         "09mddriffm9rkwr30081fy9n3cn976ms8pwc8p8hhlxnilbjavfk"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))                  ;missing devices.json test file in release
    (propagated-inputs
     (list python-ua-parser))
    (home-page "https://github.com/selwin/python-user-agents")
    (synopsis "User Agent strings parsing library")
  (description
   "A library to identify devices (phones, tablets) and their capabilities by
parsing (browser/HTTP) user agent strings.")
  (license license:expat)))

(define-public python-pydbus
  (package
    (name "python-pydbus")
    (version "0.6.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "pydbus" version))
        (sha256
          (base32 "0b0gipvz7vcfa9ddmwq2jrx16d4apb0hdnl5q4i3h8jlzwp1c1s2"))))
    (build-system python-build-system)
    (propagated-inputs (list python-pygobject))
    (home-page "https://github.com/LEW21/pydbus")
    (synopsis "Pythonic D-Bus library")
    (description "Pydbus provides a pythonic interface to the D-Bus
message bus system.  Pydbus can be used to access remote objects and
also for object publication.  It is based on PyGI, the Python GObject
Introspection bindings, which is the recommended way to use GLib from Python.")
    (license license:lgpl2.1+)))

(define-public python-dbus
  (package
    (name "python-dbus")
    (version "1.2.18")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://dbus.freedesktop.org/releases/dbus-python/"
                           "dbus-python-" version ".tar.gz"))
       (sha256
        (base32 "0q3jrw515z98mqdk9x822nd95rky455zz9876f1nqna5igkd3gcj"))))
    (build-system gnu-build-system)
    (native-inputs
     (list pkg-config))
    (inputs
     `(("python" ,python-wrapper)
       ("dbus-glib" ,dbus-glib)))
    (synopsis "Python bindings for D-bus")
    (description "python-dbus provides bindings for libdbus, the reference
implementation of D-Bus.")
    (home-page "https://www.freedesktop.org/wiki/Software/DBusBindings/")
    (properties `((python2-variant . ,(delay python2-dbus))))
    (license license:expat)))

(define-public python2-dbus
  (package/inherit python-dbus
    (name "python2-dbus")
    (inputs `(("python" ,python-2)
              ("libxcrypt" ,libxcrypt)  ;required by Python.h
              ,@(alist-delete "python"
                              (package-inputs python-dbus))))
    (arguments
     `(#:configure-flags '("PYTHON_VERSION=2")))))

(define-public python-dbus-next
  (package
    (name "python-dbus-next")
    (version "0.2.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/altdesktop/python-dbus-next")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1ahaz52kny1p9xxv6phvk4iq56rg8li390wywlxf2yslaij1188h"))))
    (build-system python-build-system)
    (native-inputs
      (list python-pytest))
    (home-page "https://github.com/altdesktop/python-dbus-next")
    (synopsis "Zero-dependency DBus library for Python with asyncio support")
    (description
     "This DBus library for Python aims to be a fully-featured high-level
library primarily geared towards integration of applications into desktop and
mobile environments.")
    (license license:expat)))

(define-public python-notify2
  (package
    (name "python-notify2")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "notify2" version))
       (sha256
        (base32
         "0z8rrv9rsg1r2qgh2dxj3dfj5xnki98kgi3w839kqby4a26i1yik"))))
    (build-system python-build-system)
    (arguments `(#:tests? #f))                    ; tests depend on system state
    (propagated-inputs
     (list python-dbus))
    (home-page "https://bitbucket.org/takluyver/pynotify2")
    (synopsis "Python interface to D-Bus notifications")
    (description
     "Pynotify2 provides a Python interface for sending D-Bus notifications.
It is a reimplementation of pynotify in pure Python, and an alternative to
the GObject Introspection bindings to libnotify for non-GTK applications.")
    (license (list license:bsd-2
                   license:lgpl2.1+))))

;; beautifulsoup4 has a totally different namespace than 3.x,
;; and pypi seems to put it under its own name, so I guess we should too
(define-public python-beautifulsoup4
  (package
    (name "python-beautifulsoup4")
    (version "4.12.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "beautifulsoup4" version))
       (sha256
        (base32
         "0l8hg3vz9q5fx7gav8sj5zr90d5k7xpc91c1fhhhs1ywis9d3qvl"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-hatchling
           python-pytest))
    (propagated-inputs
     (list python-soupsieve python-html5lib python-lxml))
    (home-page
     "https://www.crummy.com/software/BeautifulSoup/bs4/")
    (synopsis
     "Python screen-scraping library")
    (description
     "Beautiful Soup is a Python library designed for rapidly setting up
screen-scraping projects.  It offers Pythonic idioms for navigating,
searching, and modifying a parse tree, providing a toolkit for
dissecting a document and extracting what you need.  It automatically
converts incoming documents to Unicode and outgoing documents to UTF-8.")
    (license license:expat)))

(define-public python-soupsieve
  (package
    (name "python-soupsieve")
    (version "2.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "soupsieve" version))
       (sha256
        (base32
         "1k70gpn2d3vgdyxbdy536dgm4kchcraxz6lmgsfg3324iy2789q5"))))
    (build-system python-build-system)
    (arguments
      ;;XXX: 2 tests fail currently despite claming they were to be
      ;;skipped. Also, beautifulsoup4 may depend on this in the future, so we
      ;;don't want to create a circular dependency.
      (list #:tests? #f
            #:phases
            #~(modify-phases %standard-phases
                ;; Circular dependency with python-beautifulsoup4.
                (delete 'sanity-check))))
    (home-page "https://github.com/facelessuser/soupsieve")
    (synopsis "CSS selector library")
    (description
     "Soup Sieve is a CSS selector library designed to be used with Beautiful
Soup 4.  It aims to provide selecting, matching, and filtering using modern
CSS selectors.  Soup Sieve currently provides selectors from the CSS level 1
specifications up through the latest CSS level 4 drafts and beyond (though
some are not yet implemented).")
    (license license:expat)))


(define-public python-netifaces
  (package
    (name "python-netifaces")
    (version "0.11.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "netifaces" version))
        (sha256
          (base32
            "0cnajf5rl4w1sa72j921scbigr6zndig56cq8ggpx45jdqa7jfh4"))))
    (build-system python-build-system)
    (home-page "https://github.com/al45tair/netifaces")
    (synopsis
      "Python module for portable network interface information")
    (description
      "Netifaces is a Python module providing information on network
interfaces in an easy and portable manner.")
    (license license:expat)))

(define-public python-networkx
  (package
    (name "python-networkx")
    (version "3.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "networkx" version))
       (sha256
        (base32 "1qaks3c3h5qlw25z949q3plw8iwgm9h152kwnam64lwc89lkcz1h"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "--numprocesses" (number->string (parallel-job-count)))))
    (native-inputs
     (list python-pytest
           python-pytest-xdist
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-decorator))
    (home-page "https://networkx.github.io/")
    (synopsis "Python module for creating and manipulating graphs and networks")
    (description
     "NetworkX is a Python package for the creation, manipulation, and study
of the structure, dynamics, and functions of complex networks.")
    (license license:bsd-3)))

(define-public python-networkx-next
  (package
    (inherit python-networkx)
    (name "python-networkx")
    (version "3.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "networkx" version))
       (sha256
        (base32 "1qaks3c3h5qlw25z949q3plw8iwgm9h152kwnam64lwc89lkcz1h"))))
    (build-system pyproject-build-system)))

(define-public python-datrie
  (package
    (name "python-datrie")
    (version "0.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "datrie" version))
       (sha256
        (base32
         "0pbn32flkrpjiwfcknmj6398qa81ba783kbcvwan3kym73v0hnsj"))))
    (build-system python-build-system)
    (native-inputs
     (list python-cython python-hypothesis python-pytest
           python-pytest-runner))
    (home-page "https://github.com/kmike/datrie")
    (synopsis "Fast, efficiently stored trie for Python")
    (description
     "This package provides a fast, efficiently stored trie implementation for
Python.")
    (license license:lgpl2.1+)))

(define-public python-amply
  (package
    (name "python-amply")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "amply" version))
       (sha256
        (base32
         "0f1db9zp0rsfzxvaz55xwh8h5rfdgr9a2a715g06ic8nknsdq4nb"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-docutils python-pyparsing))
    (native-inputs
     (list python-setuptools-scm))
    (home-page "https://github.com/willu47/amply")
    (synopsis "Load and manipulate AMPL/GLPK data as Python data structures")
    (description
     "Amply allows you to load and manipulate AMPL/GLPK data as Python data
structures.")
    (license license:epl1.0)))

(define-public python-pulp
  (package
    (name "python-pulp")
    (version "2.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "PuLP" version))
       (sha256
        (base32
         "1dammrg0f1v0r028i3rpxbf2bsyxmjq0q6ihb4x2wsdki44z3bxj"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-amply))
    (home-page "https://github.com/coin-or/pulp")
    (synopsis "Linear Programming modeler")
    (description
     "PuLP is a Linear Programming modeler written in Python.  PuLP can
generate MPS or LP files and call GLPK, COIN CLP/CBC, CPLEX, and GUROBI to
solve linear problems.")
    (license license:expat)))

(define-public python-py-partiql-parser
  (package
    (name "python-py-partiql-parser")
    (version "0.6.1")
    (source
     (origin
       (method git-fetch)   ; no tests data in PyPi package
       (uri (git-reference
             (url "https://github.com/getmoto/py-partiql-parser")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "008vj0f09gzk6pijwvxs6m860rmszm85is7wgjwifc8y38sqd86s"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-hatchling
           python-pytest))
    (home-page "https://pypi.org/project/py-partiql-parser/")
    (synopsis "Pure Python PartiQL Parser")
    (description
     "This package provides a tokenizer/parser/executor for the PartiQL
language, in Python.")
    (license license:expat)))

(define-public python-py-tes
  (package
    (name "python-py-tes")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "py-tes" version))
       (sha256
        (base32 "0b272y392v0mnq0f3sm5kgcx8fn4qwfbym89hhvqxz3xkganr4pn"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-attrs python-dateutil python-future python-requests))
    (home-page "https://github.com/ohsu-comp-bio/py-tes")
    (synopsis "Library for communicating with the GA4GH Task Execution API")
    (description "This package provides a library for communicating with the
GA4GH Task Execution API.")
    (license license:expat)))

(define-public python-toposort
  (package
    (name "python-toposort")
    (version "1.6")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "toposort" version))
       (sha256
        (base32
         "1b2hppzjg3p006qya3yfdnp76dwq8frl97lypdam0kw4xxb8yhm7"))))
    (build-system python-build-system)
    (home-page "https://gitlab.com/ericvsmith/toposort")
    (synopsis "Topological sort algorithm")
    (description
     "This package provides an implementation of a topological sort
algorithm.")
    (license license:asl2.0)))

(define-public python-altgraph
  (package
    (name "python-altgraph")
    (version "0.17.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "altgraph" version))
       (sha256
        (base32 "01j48np3g50g6insjkszsz0vifwlm6gspria5vdwlkbciywznnhv"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://altgraph.readthedocs.io")
    (synopsis "Python graph network package")
    (description
"This package provides tools for constructing graphs, BFS and DFS
traversals, topological sort, shortest paths, and more with graphviz
output.")
    (license license:expat)))

(define-public python-three-merge
  (package
    (name "python-three-merge")
    (version "0.1.1")
    (source
     (origin
       ;; There are no tests in the PyPI tarball.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/spyder-ide/three-merge")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1fw28swh6jq4myr09j7gv68l241b8vwg470ak5xv0x4xwh2a1m86"))))
    (build-system python-build-system)
    (arguments
     `(#:test-target "pytest"))
    (propagated-inputs
     (list python-diff-match-patch))
    (native-inputs
     (list python-flaky python-pytest python-pytest-cov
           python-pytest-runner python-pytest-timeout))
    (home-page "https://github.com/spyder-ide/three-merge")
    (synopsis "Library for merging two strings with respect to a base one")
    (description
     "This package provides a Python library to perform a 3-way merge between
strings, based on @code{diff-match-patch}.  This library performs merges at a
character level, as opposed to most VCS systems, which opt for a line-based
approach.")
    (license license:expat)))

(define-public snakemake
  (package
    (name "snakemake")
    (version "5.32.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/snakemake/snakemake")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0nxp4z81vykv07kv2b6zrwk7ns8s10zqsb7vcignp8695yq3nlcm"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      '(list
        ;; We have no TES support.
        "--ignore=tests/test_tes.py"
        ;; This test attempts to change S3 buckets on AWS and fails
        ;; because there are no AWS credentials.
        "--ignore=tests/test_tibanna.py"
        ;; It's a similar story with this test, which requires access
        ;; to the Google Storage service.
        "--ignore=tests/test_google_lifesciences.py")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'tabulate-compatibility
            (lambda _
              (substitute* "snakemake/dag.py"
                (("\"job\": rule,")
                 "\"job\": rule.name,"))))
          (add-after 'unpack 'patch-version
            (lambda _
              (substitute* "setup.py"
                (("version=versioneer.get_version\\(\\)")
                 (format #f "version=~s" #$version)))
              (substitute* '("snakemake/_version.py"
                             "versioneer.py")
                (("0\\+unknown") #$version))))
          ;; For cluster execution Snakemake will call Python.  Since there is
          ;; no suitable PYTHONPATH set, cluster execution will fail.  We fix
          ;; this by calling the snakemake wrapper instead.
          (add-after 'unpack 'call-wrapper-not-wrapped-snakemake
            (lambda _
              (substitute* "snakemake/executors/__init__.py"
                (("\\{sys.executable\\} -m snakemake")
                 (string-append #$output "/bin/snakemake")))))
          (add-before 'check 'pre-check
            (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list python-appdirs
           python-configargparse
           python-datrie
           python-docutils
           python-gitpython
           python-jinja2
           python-jsonschema
           python-nbformat
           python-networkx
           python-psutil
           python-pulp
           python-pyyaml
           python-ratelimiter
           python-requests
           python-toposort
           python-wrapt))
    (native-inputs
     (list git-minimal
           python-wrapper
           python-pytest
           python-pandas
           python-requests-mock
           python-setuptools
           python-wheel))
    (home-page "https://snakemake.readthedocs.io")
    (synopsis "Python-based execution environment for make-like workflows")
    (description
      "Snakemake aims to reduce the complexity of creating workflows by
providing a clean and modern domain specific specification language (DSL) in
Python style, together with a fast and comfortable execution environment.")
    (license license:expat)))

(define-public snakemake-6
  (package
    (inherit snakemake)
    (name "snakemake")
    (version "6.15.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/snakemake/snakemake")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "09yrpi9f86r9yvcm2dfjs5zy87c4j31bxama77kfd6y8yfrrjlai"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          ;; For cluster execution Snakemake will call Python.  Since there is
          ;; no suitable GUIX_PYTHONPATH set, cluster execution will fail.  We
          ;; fix this by calling the snakemake wrapper instead.

          ;; XXX: There is another instance of sys.executable on line 692, but
          ;; it is not clear how to patch it.
          (add-after 'unpack 'call-wrapper-not-wrapped-snakemake
            (lambda* (#:key outputs #:allow-other-keys)
              (substitute* "snakemake/executors/__init__.py"
                (("\\{sys.executable\\} -m snakemake")
                 (string-append #$output "/bin/snakemake")))))
          (add-after 'unpack 'tabulate-compatibility
            (lambda _
              (substitute* "snakemake/dag.py"
                (("\"job\": rule,")
                 "\"job\": rule.name,"))))
          (add-after 'unpack 'patch-version
            (lambda _
              (substitute* "setup.py"
                (("version=versioneer.get_version\\(\\)")
                 (format #f "version=~s" #$version)))
              (substitute* '("snakemake/_version.py"
                             "versioneer.py")
                (("0\\+unknown") #$version))))
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (setenv "HOME" "/tmp")
                ;; This test attempts to change S3 buckets on AWS and fails
                ;; because there are no AWS credentials.
                (delete-file "tests/test_tibanna.py")
                (invoke "pytest")))))))
    (propagated-inputs
     (list python-appdirs
           python-configargparse
           python-connection-pool
           python-datrie
           python-docutils
           python-filelock
           python-gitpython
           python-jinja2
           python-jsonschema
           python-nbformat
           python-networkx
           python-psutil
           python-pulp
           python-pyyaml
           python-py-tes
           python-ratelimiter
           python-requests
           python-smart-open
           python-stopit
           python-tabulate
           python-toposort
           python-wrapt))
    (native-inputs
     (list git-minimal
           python-wrapper
           python-pytest
           python-pandas
           python-requests-mock
           python-setuptools
           python-wheel))))

(define-public snakemake-7
  (package
    (inherit snakemake-6)
    (name "snakemake")
    (version "7.7.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/snakemake/snakemake")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1qrqbmx4cbis0wxr6dl2rdjv9v627sbirsz6v5c31vlbqwkvs04q"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          ;; For cluster execution Snakemake will call Python.  Since there is
          ;; no suitable GUIX_PYTHONPATH set, cluster execution will fail.  We
          ;; fix this by calling the snakemake wrapper instead.
          (add-after 'unpack 'call-wrapper-not-wrapped-snakemake
            (lambda* (#:key outputs #:allow-other-keys)
              (substitute* "snakemake/executors/__init__.py"
                (("self\\.get_python_executable\\(\\),")
                 "")
                (("\"-m snakemake\"")
                 (string-append "\"" #$output
                                "/bin/snakemake" "\""))
                ;; The snakemake command produced by format_job_exec contains
                ;; references to /gnu/store.  Prior to patching above that's
                ;; just a reference to Python; after patching it's a reference
                ;; to the snakemake executable.
                ;;
                ;; In Tibanna execution mode Snakemake arranges for a certain
                ;; Docker image to be deployed to AWS.  It then passes its own
                ;; command line to Tibanna.  This is misguided because it only
                ;; ever works if the local Snakemake command was run inside
                ;; the same Docker image.  In the case of using Guix this is
                ;; never correct, so we need to replace the store reference.
                (("tibanna_args.command = command")
                 (string-append
                  "tibanna_args.command = command.replace('"
                  #$output "/bin/snakemake', 'python3 -m snakemake')")))))
          ;; No longer needed with 7.15.2+
          (add-after 'unpack 'tabulate-compatibility
            (lambda _
              (substitute* "snakemake/dag.py"
                (("\"job\": rule,")
                 "\"job\": rule.name,"))))
          (add-after 'unpack 'patch-version
            (lambda _
              (substitute* "setup.py"
                (("version=versioneer.get_version\\(\\)")
                 (format #f "version=~s" #$version)))
              (substitute* '("snakemake/_version.py"
                             "versioneer.py")
                (("0\\+unknown") #$version))))
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (setenv "HOME" "/tmp")
                ;; This test attempts to change S3 buckets on AWS and fails
                ;; because there are no AWS credentials.
                (delete-file "tests/test_tibanna.py")
                ;; It's a similar story with this test, which requires access
                ;; to the Google Storage service.
                (delete-file "tests/test_google_lifesciences.py")
                (invoke "pytest")))))))
    (propagated-inputs
     (list python-appdirs
           python-configargparse
           python-connection-pool
           python-datrie
           python-docutils
           python-filelock
           python-gitpython
           python-jinja2
           python-jsonschema
           python-nbformat
           python-networkx
           python-psutil
           python-pulp
           python-pyyaml
           python-py-tes
           python-ratelimiter
           python-requests
           python-retry
           python-smart-open
           python-stopit
           python-tabulate
           python-toposort
           python-wrapt
           python-yte))
    (native-inputs
     (list git-minimal
           python-wrapper
           python-pytest
           python-pandas
           python-requests-mock
           python-setuptools
           python-wheel))))

(define-public python-pyqrcode
  (package
    (name "python-pyqrcode")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "PyQRCode" version))
       (sha256
        (base32
         "1m9ln8k9v7dfbh1i81225hx5mdsh8mpf9g7r4wpbfmiyfcs7dgzx"))))
    (build-system python-build-system)
    (home-page
     "https://github.com/mnooner256/pyqrcode")
    (synopsis "QR code generator")
    (description
     "Pyqrcode is a QR code generator written purely in Python with
SVG, EPS, PNG and terminal output.")
    (license license:bsd-3)))

(define-public python-seaborn
  (package
    (name "python-seaborn")
    (version "0.13.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "seaborn" version))
              (sha256
               (base32
                "0ycibcs6kvd3xi4zsxna81claqifyb9dn6z6jwc5x7lqqplnbbdz"))))
    (build-system pyproject-build-system)
    (propagated-inputs
     (list python-matplotlib
           python-numpy
           python-pandas
           python-scipy
           python-statsmodels))
    (native-inputs
     (list python-flake8
           python-flit-core
           python-ipykernel
           python-nbconvert
           python-numpydoc
           python-mypy
           python-pytest
           python-pytest-cov
           python-pytest-xdist
           python-pyyaml))
    (home-page "https://seaborn.pydata.org/")
    (synopsis "Statistical data visualization")
    (description
     "Seaborn is a library for making attractive and informative statistical
graphics in Python.  It is built on top of matplotlib and tightly integrated
with the PyData stack, including support for numpy and pandas data structures
and statistical routines from scipy and statsmodels.")
    (license license:bsd-3)))

(define-public python-session-info
  (package
    (name "python-session-info")
    (version "1.0.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "session_info" version))
              (sha256
               (base32
                "1dxnrgaxd2nb44n423mnrx119hmnh2yxdnzaw8mg60x7rh1mxniw"))))
    (build-system python-build-system)
    (propagated-inputs (list python-stdlib-list))
    (home-page "https://gitlab.com/joelostblom/session_info")
    (synopsis "Output version information for modules currently loaded")
    (description
     "This package outputs version information for modules loaded in the current
session, Python, and the OS.")
    (license license:bsd-3)))

(define-public python-mpmath
  (package
    (name "python-mpmath")
    (version "1.2.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/fredrik-johansson/mpmath")
                    (commit "c6a35f9ee7c294bcf4e0517bc76b268843db9499")))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0ifw59fjjls3mas104rh0frilvab2fhk1dkjraxlqni5n9l676im"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'build 'set-version
           (lambda _
             (setenv "SETUPTOOLS_SCM_PRETEND_VERSION" ,version)
             ;; ZIP does not support timestamps before 1980.
             (setenv "SOURCE_DATE_EPOCH" "315532800")))
         (replace 'check
           (lambda* (#:key tests? inputs outputs #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               (invoke "pytest" "-vv")))))))
    (native-inputs
     (list python-pytest python-setuptools-scm))
    (home-page "https://mpmath.org")
    (synopsis "Arbitrary-precision floating-point arithmetic in python")
    (description
     "@code{mpmath} can be used as an arbitrary-precision substitute for
Python's float/complex types and math/cmath modules, but also does much
more advanced mathematics.")
    (license license:bsd-3)))

(define-public python-bigfloat
  (package
    (name "python-bigfloat")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "bigfloat" version))
       (sha256
        (base32 "1f0c1hdr39bbl5rds5r1waa1papjmjiyp0ixs64mkjiahzg6pfaq"))
       (snippet '(delete-file "mpfr.c"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; This one fails with AssertionError: 0 != 8796082524191.  Not good,
      ;; but I don't know what to do about it.
      '(list "-k" "not test_hash")
      #:phases
      '(modify-phases %standard-phases
         (add-before 'build 'cythonize
           (lambda _ (invoke "cython" "mpfr.pyx"))))))
    (inputs (list mpfr))
    (native-inputs
     (list python-cython python-pytest python-setuptools python-wheel))
    (propagated-inputs
     (list python-six))
    (home-page "https://github.com/mdickinson/bigfloat")
    (synopsis "Arbitrary precision floating-point arithmetic for Python")
    (description
     "This package provides a Python interface to the MPFR library for
multiprecision arithmetic.")
    (license license:lgpl3+)))

(define-public python-plac
  (package
    (name "python-plac")
    (version "1.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "plac" version))
       (sha256
        (base32 "1410h6jw1ksi24kb55xzkwqzba2qqjwiga1s354bf3s5s1jdig9q"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'fix-tkinter
           (lambda _
             (substitute* "plac_tk.py"
               (("from Tkinter import Tk")
                "from tkinter import Tk")
               (("from ScrolledText import ScrolledText")
                "from tkinter.scrolledtext import ScrolledText")))))))
    (native-inputs
     `(("python-tkinter" ,python "tk")))
    (home-page "https://github.com/ialbert/plac")
    (synopsis "Command line arguments parser")
    (description "This package can generate command line parameters from
function signatures.")
    (license license:bsd-3)))

(define-public python-yte
  (package
    (name "python-yte")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "yte" version))
       (sha256
        (base32 "07hm1warpqi4ifqgkaz5sg887x4a44yhxafmpf835ywnpchg4s03"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs (list python-plac python-pyyaml))
    (home-page "https://github.com/koesterlab/yte")
    (synopsis "YAML template engine with Python expressions")
    (description
     "This package provides a YAML template engine with Python expressions.")
    (license license:expat)))

(define-public python-syllables
  (package
    (name "python-syllables")
    (version "1.0.3")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "syllables" version))
              (sha256
               (base32
                "0wkl6h0rg6fbsxfp0a8fnibf3l4l6lbh6z12cvcilgb6qhxzpmv3"))))
    (build-system python-build-system)
    (home-page "https://github.com/prosegrinder/python-syllables")
    (synopsis "Package for estimating the number of syllables in a word")
    (description
     "This package provides a Python package for estimating the number of
syllables in a word.")
    (license license:gpl3)))

(define-public python-sympy
  (package
    (name "python-sympy")
    (version "1.13.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "sympy" version))
       (sha256
        (base32 "1nf4zrjjbnv47n6sl6x9blfyarski61vdjaz4ygb62hfag3d4zxj"))))
    (build-system pyproject-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (if tests?
                 (invoke "python3" "-c"
                         "import sympy; sympy.test(\"/core\")")))))))
    (propagated-inputs (list python-mpmath))
    (native-inputs
     (list python-hypothesis
           python-pytest
           python-setuptools
           python-wheel))
    (home-page "https://www.sympy.org/")
    (synopsis "Python library for symbolic mathematics")
    (description
     "SymPy is a Python library for symbolic mathematics.  It aims to become a
full-featured computer algebra system (CAS) while keeping the code as simple
as possible in order to be comprehensible and easily extensible.")
    (license license:bsd-3)))

(define-public python-q
  (package
    (name "python-q")
    (version "2.6")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "q" version))
       (sha256
        (base32
         "1mgfazh8fkizh6walra2zv885f3lcgr3nb02v1frfm4p8ddcy3yy"))))
    (build-system python-build-system)
    (home-page "https://github.com/zestyping/q")
    (synopsis "Quick-and-dirty debugging output for tired programmers")
    (description
     "q is a Python module for \"print\" style of debugging Python code.  It
provides convenient short API for print out of values, tracebacks, and
falling into the Python interpreter.")
    (license license:asl2.0)))

(define-public python-qnorm
  (package
    (name "python-qnorm")
    (version "0.8.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "qnorm" version))
              (sha256
               (base32
                "1iykxrvlg32h78d3cr0137x93w8krcwc8gdqyfj55id917pz7ck1"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #false ;there are none
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-pyproject-format
            (lambda _
              (substitute* "pyproject.toml"
                (("url = .*") (string-append "version = \"" #$version "\""))
                (("python_requires.*") "")
                (("packages =.*") "")
                (("install_requires") "dependencies")
                (("\"Maarten van der Sande <maartenvandersande@hotmail.com>\"")
                 "{ name = \"Maarten van der Sande\", email = \"maartenvandersande@hotmail.com\"}")
                (("license = \"MIT\"") "license = { file = \"LICENSE\"}")))))))
    (propagated-inputs (list python-numba python-numpy python-pandas))
    (native-inputs (list python-setuptools python-wheel python-toml))
    (home-page "https://github.com/Maarten-vd-Sande/qnorm")
    (synopsis "Quantile normalization")
    (description "This tool implements quantile normalization.  It properly
resolves rank ties, which is important when ties happen frequently, such as
when working with discrete numbers (integers) in count tables.  This
implementation should be relatively fast, and can use multiple cores to sort
the columns and tie-resolvement is accelerated by numba.")
    (license license:expat)))

(define-public python-xlib
  (package
    (name "python-xlib")
    (version "0.29")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/python-xlib/python-xlib")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "17cwd2knqm2vwrii3kqii9abwsnydhpg4byqx1vy7rjs6i1vbqfc"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'check 'start-xserver
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((xorg-server (assoc-ref inputs "xorg-server")))
               ;; There must be a running X server and make check doesn't
               ;; start one.  Therefore we must do it.
               (system (format #f "~a/bin/Xvfb :1 &" xorg-server))
               (setenv "DISPLAY" ":1")
               #t))))))
    (native-inputs
     (list python-mock python-setuptools-scm xorg-server))
    (propagated-inputs
     (list python-six))
    (home-page "https://github.com/python-xlib/python-xlib")
    (synopsis "Python X11 client library")
    (description
     "The Python X Library is intended to be a fully functional
X client library for Python programs.  It is useful to implement
low-level X clients.  It is written entirely in Python.")
    (license license:gpl2+)))

(define-public python-singledispatch
  (package
    (name "python-singledispatch")
    (version "4.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "singledispatch" version))
       (sha256
        (base32
         "1z5qbbvvjvh3cwcjv57p7vzhayx0j1ysnvjq0d5py6k5d2ljghzk"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-six ; required for conversion, not at run-time
           python-wheel))
    (home-page
     "https://docs.python.org/3/library/functools.html#functools.singledispatch")
    (synopsis "Backport of singledispatch feature from Python 3.4")
    (description
     "This library brings functools.singledispatch from Python 3.4 to Python
2.6-3.3.")
    (license license:expat)))

;; the python- version can be removed with python-3.5
(define-public python-backports-abc
  (package
    (name "python-backports-abc")
      (version "0.5")
      (source
        (origin
          (method url-fetch)
          (uri (pypi-uri "backports_abc" version))
          (sha256
           (base32
            "1pkv8d1zxj5f9i227dxbjczncbv7ks7ywnjwyxfjagm02i2yafq3"))))
    (build-system python-build-system)
    (home-page "https://github.com/cython/backports_abc")
    (synopsis "Backport of additions to the 'collections.abc' module")
    (description
     "Python-backports-abc provides a backport of additions to the
@code{collections.abc} module in Python-3.5.")
    (license license:psfl)))

(define-public python-backports-csv
  (package
    (name "python-backports-csv")
    (version "1.0.7")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "backports.csv" version))
       (sha256
        (base32 "0vdx5jlhs91iizc8j8l8811nqprwvdx39pgkdc82w2qkfgzxyxqj"))))
    (build-system python-build-system)
    (home-page "https://github.com/ryanhiebert/backports.csv")
    (synopsis "Backport of Python 3's csv module for Python 2")
    (description
     "Provides a  backport of Python 3's @code{csv} module for parsing
comma separated values.  The API of the @code{csv} module in Python 2
is drastically different from the @code{csv} module in Python 3.
This is due, for the most part, to the difference between str in
Python 2 and Python 3.")
    (license license:psfl)))

(define-public python-waf
  (package
    (name "python-waf")
    (version "2.0.19")
    (source (origin
              (method url-fetch)
              (uri (string-append "https://waf.io/"
                                  "waf-" version ".tar.bz2"))
              (sha256
               (base32
                "19dvqbsvxz7ch03dh1v0znklrwxlz6yzddc3k9smzrrgny4jch6q"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'build
           (lambda _
             ;; XXX: Find a way to add all extra tools.
             (let ((tools '("gccdeps"
                            "clang_compilation_database")))
               (invoke "python" "waf-light" "configure" "build"
                       (string-append "--tools="
                                      (string-join tools ","))))))
         (replace 'check
           (lambda _
             (invoke "python" "waf" "--version")))
         (replace 'install
           (lambda* (#:key outputs #:allow-other-keys)
             (let ((out (assoc-ref outputs "out")))
               (install-file "waf" (string-append out "/bin")))
             #t))
         ;; waf breaks when it is wrapped.
         (delete 'wrap))))
    (home-page "https://waf.io/")
    (synopsis "Python-based build system")
    (description
     "Waf is a Python-based framework for configuring, compiling and installing
applications.")
    (license license:bsd-3)))

(define-public python-pyzmq
  (package
    (name "python-pyzmq")
    (version "25.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyzmq" version))
       (sha256
        (base32 "0mw9zf0h9sgn2cchw24vyxgyi2nfpyfacr0mh072hdjx8qii1i40"))
       (snippet
        #~(begin
            (use-modules (guix build utils))
            ;; The bundled zeromq source code.
            (delete-file-recursively "bundled")
            ;; Delete cythonized files.
            (for-each delete-file
                      (list "zmq/backend/cython/context.c"
                            "zmq/backend/cython/_device.c"
                            "zmq/backend/cython/error.c"
                            "zmq/backend/cython/message.c"
                            "zmq/backend/cython/_poll.c"
                            "zmq/backend/cython/_proxy_steerable.c"
                            "zmq/backend/cython/socket.c"
                            "zmq/backend/cython/utils.c"
                            "zmq/backend/cython/_version.c"
                            "zmq/devices/monitoredqueue.c"))))))
    (build-system python-build-system)
    (arguments
     `(#:configure-flags
       (list (string-append "--zmq=" (assoc-ref %build-inputs "zeromq")))
       #:phases
       (modify-phases %standard-phases
         (add-before 'build 'configure
           (lambda _
             ;; Our zeromq package is built with '--enable-drafts'; also
             ;; enable draft support for pyzmq so the draft test passes.
             (setenv "ZMQ_DRAFT_API" "1")))
         (add-before 'check 'build-extensions
           (lambda _
             ;; Cython extensions have to be built before running the tests.
             (invoke "python" "setup.py" "build_ext" "--inplace")))
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest" "-vv")))))))
    (inputs (list zeromq))
    (native-inputs
     (list pkg-config
           python-cython
           python-pytest
           python-pytest-asyncio
           python-tornado-6))
    (home-page "https://github.com/zeromq/pyzmq")
    (synopsis "Python bindings for 0MQ")
    (description
     "PyZMQ is the official Python binding for the ZeroMQ messaging library.")
    (license license:bsd-4)))

(define-public python-immutabledict
  (package
    (name "python-immutabledict")
    (version "4.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "immutabledict" version))
       (sha256
        (base32 "0pvwfasa5l78pi32zk55x5ihpdzkdh4f3xwbfmd7ldyjma0zs0z0"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-poetry-core python-pytest))
    (home-page "https://github.com/corenting/immutabledict")
    (synopsis "Immutable wrapper around dictionaries")
    (description
     "@dfn{immutabledict} is an immutable wrapper around dictionaries.
It implements the complete mapping interface and can be used as a drop-in
replacement for dictionaries where immutability is desired.")
    (license license:expat)))

(define-public python-emoji
  (package
    (name "python-emoji")
    (version "2.12.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "emoji" version))
       (sha256
        (base32 "1svk94pad8gcvjwd329zmfrw09wakwh6qjvnhf6sa6k92y44i82a"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-typing-extensions))
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (home-page "https://github.com/carpedm20/emoji/")
    (synopsis "Emoji terminal output for Python")
    (description
     "This package provides Emoji terminal output for Python.  The
entire set of Emoji codes as defined by the Unicode Consortium is supported in
addition to a bunch of aliases.")
    (license license:bsd-3)))

;; TODO: Remove this package when upgrading python-gh-md-to-html to the
;; latest version. The latest gh-md-to-html does not build successfully from
;; the PyPI distribution. Let's resolve #72102 while keeping gh-md-to-html at
;; version 1.21.2 from failing.
;; https://issues.guix.gnu.org/72102
;; https://github.com/phseiff/github-flavored-markdown-to-html/issues/73
(define-public python-emoji-for-gh-md-to-html
  (package
    (inherit python-emoji)
    (version "1.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "emoji" version))
       (sha256
        (base32 "0923mpixwq6hdpkgvi4r46alfvf608iq975rb8lnqpq29j71mmjk"))))))

(define-public python-sarge
  (package
    (name "python-sarge")
    (version "0.1.7.post1") ; post release only to correct errors in metadata
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "sarge" version))
       (sha256
        (base32 "0g9a53mfnp96877n1yq2jdk1mcv3xm0d93iisvgcn2prdsp45zv4"))))
    (build-system python-build-system)
    (home-page "https://docs.red-dove.com/sarge/")
    (synopsis "Subprocess wrapper with command pipeline functionality")
    (description "@code{sarge} is a wrapper for subprocess which provides
command pipeline functionality.")
    (license license:bsd-3)))

(define-public python-zipfly
  (package
    (name "python-zipfly")
    (version "6.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "zipfly" version))
       (sha256
        (base32
         "1h7g922a8lsqd69j8blgcgg0lcd8kz51b2p4glfqmgx4vi1nkick"))))
    (build-system python-build-system)
    (home-page "http://github.com/sandes/zipfly")
    (synopsis "Zip archive generator")
    (description "ZipFly is a zip archive generator.  It was created to
generate very large zip archives for immediate sending out to clients, or
for writing large zip archives without memory inflation.")
    (license license:bsd-2)))

(define-public python-zipstream-new
  (package
    (name "python-zipstream-new")
    (version "1.1.8")
    (source
     (origin
       (method git-fetch)               ; no tests in PyPI release
       (uri (git-reference
             (url "https://github.com/arjan-s/python-zipstream")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "14vhgg8mcjqi8cpzrw8qzbij2fr2a63l2a8fhil21k2r8vzv92cv"))))
    (build-system python-build-system)
    (native-inputs
     (list python-nose))
    (home-page "https://github.com/arjan-s/python-zipstream")
    (synopsis "Zipfile generator that takes input files as well as streams")
    (description "@code{zipstream.py} is a zip archive generator based on
@code{zipfile.py}.  It was created to generate a zip file generator for
streaming.  This is beneficial for when you want to provide a downloadable
archive of a large collection of regular files, which would be infeasible
to generate the archive prior to downloading or of a very large file that
you do not want to store entirely on disk or on memory.")
    ;; No copyright headers in the source.  The LICENSE file indicates GPL3.
    (license license:gpl3)))

(define-public python-sentry-sdk
  (package
    (name "python-sentry-sdk")
    (version "1.5.5")
    (source
     (origin
       (method git-fetch)               ; no tests in PyPI release
       (uri (git-reference
             (url "https://github.com/getsentry/sentry-python")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0dygfaapvznpj2j7cfjb0vlwhsn5qa5kf0kq488xbhjg06n8rrc4"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; See <https://github.com/pytest-dev/pytest-forked/issues/88>.
      ;; AttributeError: module 'py' has no attribute 'process'
      '(list "--ignore=tests/integrations/django/test_basic.py"
             "--ignore=tests/utils/test_contextvars.py"
             ;; These try to use pip to install packages.
             "--ignore=tests/integrations/gcp/test_gcp.py"
             "-k"
             (string-append
              ;; This test requires extra dependencies.
              "not test_auto_enabling_integrations"
              ;; AttributeError: module 'py' has no attribute 'process'
              " and not test_threading"
              " and not test_transport"
              ;; Tests below require network.
              " and not test_crumb_capture"
              " and not test_crumb_capture_hint"
              " and not test_httplib_misuse"
              ;; Unclear assert error
              " and not test_auto_session_tracking_with_aggregates"
              ;; Fails with IndexError.
              " and not test_session_mode_defaults_to"
              "_request_mode_in_wsgi_handler"))
       #:phases
       '(modify-phases %standard-phases
          (add-before 'check 'fix-test
            ;; See https://github.com/getsentry/sentry-python/pull/2712
            (lambda _
              (substitute* "tests/__init__.py"
                (("import pytest")
                 "import warnings")
                (("pytest.warns\\(None\\)")
                 "warnings.catch_warnings(record=True)"))))
          (replace 'check
            (lambda* (#:key tests? test-flags #:allow-other-keys)
              (when tests?
                (apply invoke "python" "-m" "pytest" test-flags)))))))
    (native-inputs
     (list nss-certs-for-test
           python-django
           python-executing
           python-gevent
           python-jsonschema
           python-mock
           python-pyrsistent
           python-pytest
           python-pytest-cov
           python-pytest-django
           python-pytest-forked
           python-pytest-localserver
           python-setuptools
           python-werkzeug
           python-wheel))
    (propagated-inputs
     (list python-certifi python-urllib3))
    (home-page "https://github.com/getsentry/sentry-python")
    (synopsis "Python SDK for Sentry")
    (description "This package provides a Python SDK for the Sentry
application monitoring and error tracking software.")
    (license license:bsd-2)))

(define-public python-pep8
  ;; This package has been renamed to ‘pycodestyle’ and is no longer updated.
  ;; Its last release (1.7.1) adds only a scary warning to this effect, breaking
  ;; some dependents' test suites, and nothing more.
  (package
    (name "python-pep8")
    (version "1.7.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "pep8" version))
        (sha256
          (base32
           "002rkl4lsn6x2mxmf8ar00l0m8i3mzrc6pnzz77blyksmpsxa4x1"))
        (patches (search-patches "python-pep8-stdlib-tokenize-compat.patch"))))
    (build-system python-build-system)
    (home-page "https://pep8.readthedocs.org/")
    (synopsis "Python style guide checker")
    (description
     "This tools checks Python code against some of the style conventions in
PEP 8.")
    (license license:expat)))

(define-public python-pep8-naming
  (package
    (name "python-pep8-naming")
    (version "0.14.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pep8-naming" version))
       (sha256
        (base32 "0dlapswhvzkkyw9gmjngc4rbzasdxnpxwj8mdkmmfmc7h2p2iwhy"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (invoke "python" "run_tests.py")))))))
    (native-inputs
     (list python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-flake8))
    (home-page "https://github.com/PyCQA/pep8-naming")
    (synopsis "Check PEP-8 naming conventions")
    (description
     "This package provides the @code{pep8-naming} Python module, a plugin for
flake8 to check PEP-8 naming conventions.")
    (license license:expat)))

(define-public python-pep440
  (package
    (name "python-pep440")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pep440" version))
       (sha256
        (base32 "0kfhysbyci4f2sxvv991yvn22kbhncn0jg1arbhzw4rbri375csq"))))
    (build-system pyproject-build-system)
    (arguments
     ;; This checks for "pep440" in the output, but we actually print
     ;; ".pep440-real" due to wrapping.
     (list #:test-flags '(list "-k" "not test_cli_help")))
    (propagated-inputs (list python-check-manifest python-mypy python-pytest
                             python-pytest-console-scripts python-pytest-cov))
    (native-inputs (list python-flit-core))
    (home-page "https://pypi.org/project/pep440/")
    (synopsis "Utils to check whether versions number match PEP 440")
    (description
     "This package provides a simple package with utils to check whether
versions number match PEP 440.")
    (license license:expat)))

(define-public python-pep517
  (package
    (inherit python-pep517-bootstrap)
    (name "python-pep517")
    (arguments
     '(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (delete-file "pytest.ini")
                      (delete-file "tests/test_meta.py")
                      (if tests?
                          (invoke "pytest") #t))))))
    (native-inputs (list python-mock python-pytest python-testpath))))

(define-public python-pyproject-metadata
  (package
    (name "python-pyproject-metadata")
    (version "0.7.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/FFY00/python-pyproject-metadata")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0yvs59ymz5gdix34a95wxlxvk9bnvjgrzsnmnc3ws7whpfv3yasm"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; Two tests fail because the error message slightly changed, so the
      ;; tests' regular expressions no longer match.
      '(list "--ignore=tests/test_standard_metadata.py")))
    (propagated-inputs (list python-packaging))
    (native-inputs (list python-pypa-build python-pytest python-setuptools
                         python-tomli python-wheel))
    (home-page "https://github.com/FFY00/python-pyproject-metadata")
    (synopsis "Dataclass for PEP 621 metadata")
    (description "This project does not implement the parsing of
@file{pyproject.toml} containing PEP 621 metadata.  Instead, given a Python
data structure representing PEP 621 metadata (already parsed), it will
validate this input and generate a PEP 643-compliant metadata
file (e.g. @file{PKG-INFO}).")
    (license license:expat)))

;; pep621 was renamed to pyproject-metadata.
(define-public python-pep621
  (deprecated-package "python-pep621" python-pyproject-metadata))

(define-public python-meson-python
  (package
    (name "python-meson-python")
    (version "0.15.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "meson_python" version))
       (sha256
        (base32 "0vyjhjabvm41hqijifk33idbdl62i76kfyf884f9rs29rpp77nzx"))))
    (build-system meson-build-system)
    (propagated-inputs (list python-pyproject-metadata python-tomli))
    (home-page "https://github.com/mesonbuild/meson-python")
    (synopsis "Meson Python build backend (PEP 517)")
    (description "This package provides a PEP 517 build backend that makes
use of the Meson build system.")
    (license license:expat)))

(define-public python-pyflakes
  (package
    (name "python-pyflakes")
    (version "3.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyflakes" version))
       (sha256
        (base32 "0gxgz0kg008pgmjk1dn8z3g00dfa9pc3f80pm6r1yqjly4zn0q8w"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (home-page "https://github.com/PyCQA/pyflakes")
    (synopsis "Passive checker of Python programs")
    (description
     "Pyflakes statically checks Python source code for common errors.")
    (license license:expat)))

(define-public python-mccabe
  (package
    (name "python-mccabe")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "mccabe" version))
       (sha256
        (base32 "09b34c7jj2a0yya7fp3x7lncna4zj7pr4caj9vgvnq1vqd0053il"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; Test fixtures are not released yet, see
      ;; <https://github.com/PyCQA/mccabe/issues/93>
      #:tests? #f))
    (native-inputs
     (list python-toml
           python-setuptools
           python-wheel))
    (home-page "https://github.com/PyCQA/mccabe")
    (synopsis "McCabe checker, plugin for flake8")
    (description
     "This package provides a Flake8 plug-in to compute the McCabe cyclomatic
complexity of Python source code.")
    (license license:expat)))

(define-public python-autoflake8
  (package
    (name "python-autoflake8")
    (version "0.4.0")
    (source (origin
              (method git-fetch)        ;for tests
              (uri (git-reference
                    (url "https://github.com/fsouza/autoflake8")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0jx7bkslbhr24yvq60pl39faz2r6g93f1zm1gygswl0rzr5zmgnh"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-aiofiles
           python-poetry-core
           python-pytest
           python-pytest-xdist))
    (propagated-inputs (list python-pyflakes))
    (home-page "https://github.com/fsouza/autoflake8")
    (synopsis "Automatically fix issues reported by flake8")
    (description "Tool to automatically fix some issues reported by
@command{flake8}.")
    (license license:expat)))

(define-public python-flake8
  (package
    (name "python-flake8")
    (version "7.1.1")
    (source
     (origin
       (method git-fetch)   ; no tests data in PyPi package
       (uri (git-reference
             (url "https://github.com/pycqa/flake8")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0qbj2m1ljyvpnncnkbm1cscy726c1if4n2c9ysfpmd2zm88rj87a"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-mccabe
           python-pycodestyle
           python-pyflakes))
    (home-page "https://flake8.pycqa.org/en/latest/")
    (synopsis "The modular source code checker: pep8, pyflakes and co")
    (description
     "Flake8 is a wrapper around PyFlakes, pep8 and python-mccabe.")
    (license license:expat)))

(define-public python-flake8-blind-except
  (package
    (name "python-flake8-blind-except")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "flake8-blind-except" version))
       (sha256
        (base32 "05nxsxfzfhwsm8gys90228imm2qbnqnw5y8bfqyfngnbkmd5fnpj"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))                    ; no tests
    (native-inputs (list python-pycodestyle))
    (home-page "https://github.com/elijahandrews/flake8-blind-except")
    (synopsis "Check for blind @code{except:} statements")
    (description "This package provides a flake8 extension that checks for
blind @code{except:} statements.")
    (license license:expat)))

(define-public python-flake8-bugbear
  (package
    (name "python-flake8-bugbear")
    (version "24.10.31")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "flake8_bugbear" version))
       (sha256
        (base32 "1nrrwhfmk49riflmng26qqjzvfang5lij14ripzqwzxjf8f56ns3"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-hypothesmith
           python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-attrs
           python-flake8))
    (home-page "https://github.com/PyCQA/flake8-bugbear")
    (synopsis "Flake8 plugin for finding likely bugs and design problems in your program")
    (description
     "This package contains a plugin for Flake8 finding likely bugs and design
problems in your program.  It contains warnings that don't belong in pyflakes
and pycodestyle.")
    (license license:expat)))

(define-public python-flake8-continuation
  (package
    (name "python-flake8-continuation")
    (version "1.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "flake8-continuation" version))
       (sha256
        (base32
         "0dzaw8jr7yhlabxhrblnrizxx17xa9ngjnbr1kidg5lapq6b9q1y"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-flake8 python-pycodestyle python-six))
    (home-page "https://github.com/planetlabs/flake8-continuation")
    (synopsis "Flake8 Line Continuation Plugin")
    (description "A Flake8 plugin that checks for the line continuation
style to be in the preferred method according to PEP-8, specifically:
@quotation
The preferred way of wrapping long lines is by using Python's implied
line continuation inside parentheses, brackets and braces.  Long lines
can be broken over multiple lines by wrapping expressions in parentheses.
These should be used in preference to using a backslash for line continuation.
@end quotation")
    (license license:asl2.0)))

(define-public python-flake8-debugger
  (package
    (name "python-flake8-debugger")
    (version "4.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "flake8-debugger" version))
       (sha256
        (base32 "0h1qlzbxxhjsw6kg3mcml9h8byy77m9a5z06z2dnvqs115b05c2j"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))              ; no tests in PyPI and no setup.py in GitHub
    (propagated-inputs
     (list python-flake8 python-pycodestyle))
    (home-page "https://github.com/jbkahn/flake8-debugger")
    (synopsis "@code{ipdb} and @code{pdb} statement checker plugin for flake8")
    (description "This package provides a Flake8 plugin that checks for
@code{ipdb} and @code{pdb} imports and set traces, as well as
@code{from IPython.terminal.embed}, @code{import InteractiveShellEmbed}
and @code{InteractiveShellEmbed()()}.")
    (license license:expat)))

(define-public python-flake8-implicit-str-concat
  (package
    (name "python-flake8-implicit-str-concat")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "flake8_implicit_str_concat" version))
       (sha256
        (base32 "1s59w4x053j4794n6h9c7hafa8jjjymx6aar5q23pjw4vrdis7hh"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #f)) ; no tests in PiPY or git checkout
    (native-inputs
     (list python-hatchling))
    (propagated-inputs
     (list python-attrs
           python-more-itertools))
    (home-page "https://github.com/keisheiled/flake8-implicit-str-concat")
    (synopsis "Flake8 plugin to encourage correct string literal concatenation")
    (description
     "This is a plugin for the Python code checking tool Flake8 to encourage
correct string literal concatenation.

It looks for style problems like implicitly concatenated string literals on
the same line (which can be introduced by the code formatting tool Black), or
unnecessary plus operators for explicit string literal concatenation.")
    (license license:expat)))

(define-public python-flake8-print
  (package
    (name "python-flake8-print")
    (version "5.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "flake8-print" version))
       (sha256
        (base32 "1ydx92xck090ajp8vk2378fm0f4wj3mikhinjs3w1hcw70m5m4bn"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #f)) ; no tests in PiPY or git checkout
    (native-inputs
     (list python-poetry-core))
    (propagated-inputs
     (list python-flake8
           python-pycodestyle))
    (home-page "https://github.com/jbkahn/flake8-print")
    (synopsis "Print statement checker plugin for Flake8")
    (description
     "This plugin for Flake8 checks for @code{print} statements in Python
files.")
    (license license:expat)))

(define-public python-flake8-pyi
  (package
    (name "python-flake8-pyi")
    (version "24.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "flake8_pyi" version))
       (sha256
        (base32 "1n8cqbqq9cfyn952kwqqs4s7lcyycgr829ymxnplg0cm49877yv4"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-pytest-config
            (lambda _
              ;; Prevent full threads utilization.
              (substitute* "pyproject.toml"
                (("-nauto") "")))))))
    (native-inputs
     (list python-hatchling
           python-pytest))
    (propagated-inputs
     (list python-attrs
           python-flake8
           python-pyflakes))
    (home-page "https://github.com/ambv/flake8-pyi")
    (synopsis "Flake8 plugin that provides specializations for type hinting stub files")
    (description
     "This package contains a plugin that provides specializations for type
hinting stub files, especially interesting for linting typeshed.  It adds the
@file{.pyi} extension to the default value of the @code{--filename}
command-line argument to Flake8.  This means stubs are linted by default with
this plugin enabled, without needing to explicitly list every file.  It
modifies PyFlakes runs for @file{.pyi} files to defer checking type annotation
expressions after the entire file has been read.  This enables support for
first-class forward references that stub files use.")
    (license license:expat)))

;; XXX: Deprecated in upstream: This repository has been archived by the owner
;; on Nov 30, 2024. It is now read-only.
;; Consider to remove when nothing is depend on it.
(define-public python-flake8-pie
  (package
    (name "python-flake8-pie")
    (version "0.16.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "flake8-pie" version))
       (sha256
        (base32 "1fhmwm8blimnfmi1cj8q0kqd77vskgjb794jbp837yh64ywvgp5q"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "-k" "not test_examples and not test_prefer_simple_any_all")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'use-poetry-core
            (lambda _
              ;; Patch to use the core poetry API.
              (substitute* "pyproject.toml"
                (("poetry.masonry.api") "poetry.core.masonry.api")))))))
    (native-inputs
     (list python-poetry-core
           python-pytest))
    (home-page "https://github.com/sbdchd/flake8-pie")
    (synopsis "Flake8 extension that implements lints")
    (description
     "This package provides a flake8 extension that implements miscellaneous
lints.")
    (license license:bsd-2)))

(define-public python-flake8-quotes
  (package
    (name "python-flake8-quotes")
    (version "3.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "flake8-quotes" version))
       (sha256
        (base32 "0v1762x0819xqha7w4l4hh66bpi82imgiib8pvmd78hhnwplkn5a"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-flake8))
    (home-page "https://github.com/zheller/flake8-quotes/")
    (synopsis "Flake8 lint for quotes")
    (description "This package provides a Flake8 lint for quotes.")
    (license license:expat)))

(define-public python-flake8-todo
  (package
    (name "python-flake8-todo")
    (version "0.7")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "flake8-todo" version))
       (sha256
        (base32
         "05arm0sch3r8248035kilmf01z0mxsahw6vpbbz0d343zy8m8k3f"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-pycodestyle))
    (home-page "https://github.com/schlamar/flake8-todo")
    (synopsis "TODO notes checker, plugin for flake8")
    (description
     "This package provides the @code{flake8-todo} Python module, a
TODO notes checker plugin for flake8.")
    (license license:expat)))

(define-public python-flake8-isort
  (package
    (name "python-flake8-isort")
    (version "6.1.1")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "flake8_isort" version))
        (sha256
          (base32 "1cvh0d18scgq36gqa2vqbifjarln1r3axgq93lzc303ay0y2zy61"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #f)) ; no tests in PiPY or git checkout
    (native-inputs
     (list python-hatchling))
    (propagated-inputs
     (list python-flake8
           python-isort))
    (home-page "https://github.com/gforcada/flake8-isort")
    (synopsis "Flake8 plugin integrating isort")
    (description
     "This package provides a flake8 plugin that integrates isort,
extending flake8 so that it can warn about badly sorted Python import
directives.")
    (license license:gpl2+)))

(define-public python-autoflake
  (package
    (name "python-autoflake")
    (version "2.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "autoflake" version))
       (sha256
        (base32 "17lhrmz6h7pz2nald90p8gn3hhzbqwmd78819yf4b1habgf7b2y9"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda _
              (invoke "python" "test_autoflake.py"))))))
    (native-inputs
     (list python-hatchling))
    (propagated-inputs
     (list python-pyflakes))
    (home-page "https://github.com/myint/autoflake")
    (synopsis "Removes unused imports and unused variables")
    (description
     "@code{autoflake} removes unused imports and unused variables from Python
code as reported by @code{pyflakes}.

By default, it only removes unused imports for modules that are part of the
standard library.  Removal of unused variables is also disabled by default.
It also removes useless @code{pass} statements.")
    (license license:expat)))

(define-public python-mistune
  (package
    (name "python-mistune")
    (version "3.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "mistune" version))
       (sha256
        (base32
         "1s4ba1m69yldrhnyfj8lm4bl3axbi95g1dicxya27j9hv7g96zzw"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-setuptools
           python-wheel))
    (home-page "https://github.com/lepture/mistune")
    (synopsis "Markdown parser in pure Python")
    (description "This package provides a fast markdown parser in pure
Python.")
    (license license:bsd-3)))

(define-public python-markdown
  (package
    (name "python-markdown")
    (version "3.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "Markdown" version))
       (sha256
        (base32
         "0jbs73nincha8fkfxx267sfxac6pl0ckszjbqbb8gk4dhs8v9d9i"))))
    (build-system python-build-system)
    (native-inputs
     (list python-nose python-pyyaml))
    (home-page "https://python-markdown.github.io/")
    (synopsis "Python implementation of Markdown")
    (description
     "This package provides a Python implementation of John Gruber's
Markdown.  The library features international input, various Markdown
extensions, and several HTML output formats.  A command line wrapper
markdown_py is also provided to convert Markdown files to HTML.")
    (license license:bsd-3)))

(define-public python-markdown2
  (package
    (name "python-markdown2")
    (version "2.5.2")
    (source
     (origin
       (method git-fetch) ; no tests data in PyPi package
       (uri (git-reference
             (url "https://github.com/trentm/python-markdown2")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "01ll612yq7kjmj5p2zi9sf4l2wg6rm1ldcr6h0m2d9j180j7ggs8"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pygments
           python-pytest
           python-setuptools
           python-wheel))
    (home-page "https://github.com/trentm/python-markdown2")
    (synopsis "Fast and complete Python implementation of Markdown")
    (description
     "This package provides a fast and complete Python implementation of
Markdown.  It was written to closely match the behaviour of the original
Perl-implemented Markdown.pl.  It also comes with a number of
extensions (called @code{extras}) for things like syntax coloring, tables,
header-ids.")
    (license license:expat)))

(define-public python-mdx-include
  (package
    (name "python-mdx-include")
    (version "1.4.1")
    (source (origin
              ;; Use git, as there are some test files missing from the PyPI
              ;; release, see https://github.com/neurobin/mdx_include/issues/9
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/neurobin/mdx_include")
                    ;; Releases are not tagged on github, see
                    ;; https://github.com/neurobin/mdx_include/issues/10
                    (commit "683e6be7a00a1ef4d673ad0294458fa61bc97286")))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0qpzgln4ybd7pl0m9s19dv60aq9cvwrk7x3yz96kjhcywaa5w386"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-before 'check 'disable-test-requiring-network
           (lambda _
             (substitute* "mdx_include/test/test.py"
               (("(\\s+def )test_(cache|config|default)\\(" _ pre post)
                (string-append pre "__off__test_" post "("))))))))
    (propagated-inputs (list python-cyclic python-markdown python-rcslice))
    (home-page "https://github.com/neurobin/mdx_include")
    (synopsis "Python Markdown extension to include local or remote files")
    (description "Include extension for Python Markdown.  It lets you include
local or remote (downloadable) files into your markdown at arbitrary
positions.

This project is motivated by markdown-include and provides the same
functionalities with some extras.")
    (license license:bsd-3)))

(define-public python-ptyprocess
  (package
    (name "python-ptyprocess")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ptyprocess" version))
       (sha256
        (base32
         "081j893x6c9qrfszp8swfqlpvk8agh1jc32y9140pvnf90xhlpaw"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-flit-core
           python-pytest))
    (home-page "https://github.com/pexpect/ptyprocess")
    (synopsis "Run a subprocess in a pseudo terminal")
    (description
     "This package provides a Python library used to launch a subprocess in a
pseudo terminal (pty), and interact with both the process and its pty.")
    (license license:isc)))

(define-public python-cram
  (package
    (name "python-cram")
    (version "0.7")
    (home-page "https://bitheap.org/cram/")
    (source (origin
              (method url-fetch)
              (uri (list (string-append home-page "cram-"
                                        version ".tar.gz")
                         (pypi-uri "cram" version)))
              (sha256
               (base32
                "0bvz6fwdi55rkrz3f50zsy35gvvwhlppki2yml5bj5ffy9d499vx"))))
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-source
           (lambda _
             (substitute* (find-files "cram" ".*\\.py$")
               ;; Replace default shell path.
               (("/bin/sh") (which "sh")))
             (substitute* (find-files "tests" ".*\\.t$")
               (("md5") "md5sum")
               (("/bin/bash") (which "bash"))
               (("/bin/sh") (which "sh")))
             (substitute* "cram/_test.py"
               ;; This hack works around a bug triggered by substituting
               ;; the /bin/sh paths. "tests/usage.t" compares the output of
               ;; "cram -h", which breaks the output at 80 characters. This
               ;; causes the line showing the default shell to break into two
               ;; lines, but the test expects a single line...
               (("env\\['COLUMNS'\\] = '80'")
                "env['COLUMNS'] = '160'"))

             (substitute* "Makefile"
               ;; Recent versions of python-coverage have caused the test
               ;; coverage to decrease (as of version 0.7).  Allow that.
               (("--fail-under=100")
                "--fail-under=90"))

             #t))
         (replace 'check
           ;; The test phase uses the built library and executable.
           (lambda* (#:key inputs outputs #:allow-other-keys)
             (add-installed-pythonpath inputs outputs)
             (setenv "PATH" (string-append (getenv "PATH") ":"
                                           (assoc-ref outputs "out") "/bin"))
             (invoke "make" "test"))))))
    (build-system python-build-system)
    (native-inputs
     (list python-coverage python-setuptools python-wheel which))
    (synopsis "Simple testing framework for command line applications")
    (description
     "Cram is a functional testing framework for command line applications.
Cram tests look like snippets of interactive shell sessions.  Cram runs each
command and compares the command output in the test with the command’s actual
output.")
    (license license:gpl2+)))

(define-public python-crccheck
  (package
    (name "python-crccheck")
    (version "1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "crccheck" version))
       (sha256
        (base32 "15psg7wjfbpmmry54ffwg6pg63mnv7mkwmb0a7884axnr8qj55j5"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (invoke "pytest" "-vv")))))))
    (native-inputs (list python-pytest))
    (home-page "https://sourceforge.net/projects/crccheck/")
    (synopsis "Calculation library for CRCs and checksums")
    (description "@code{crccheck} is a calculation library for CRCs and
checksums.  It implement more than a hundred checksum routines.")
    (license license:gpl3+)))

(define-public python-crashtest
  (package
    (name "python-crashtest")
    (version "0.3.1")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "crashtest" version))
        (sha256
          (base32 "1p9p7mn8x2j9psc4jxab98897v4i9s4fliyfw8rp8v4bx1n7pjj2"))))
    (build-system python-build-system)
    (home-page "https://github.com/sdispater/crashtest")
    (synopsis "Manage Python errors with ease")
    (description
     "Python library that makes exceptions handling and inspection easier.")
    (license license:expat)))

(define-public python-stdio-mgr
  (package
    (name "python-stdio-mgr")
    (version "1.0.1")
    (source
     (origin
       (method git-fetch) ; no tests data in PyPi package
       (uri (git-reference
             (url "https://github.com/bskinn/stdio-mgr")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0xb6779s7j162xhig6vc63f9nn3v406fvjh1zqbqbf8zcl17ific"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; Do not run doctests requiring sphinx.
      #:test-flags #~(list "--ignore=README.rst")))
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-attrs))
    (home-page "https://github.com/bskinn/stdio-mgr")
    (synopsis "Context manager for mocking/wrapping stdin/stdout/stderr")
    (description
     "This package contains a context manager for mocking/wrapping
stdin/stdout/stderr.")
    (license license:expat)))

(define-public python-stdlib-list
  (package
    (name "python-stdlib-list")
    (version "0.8.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "stdlib-list" version))
              (sha256
               (base32
                "17vdn4q0sdlndc2fr9svapxx6366hnrhkn0fswp1xmr0jxqh7rd1"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f)) ; Tests require more dependencies.
    (native-inputs
     (list python-sphinx))
    (home-page "https://github.com/jackmaney/python-stdlib-list")
    (synopsis "Python Standard Libraries")
    (description "This package contains a list of Python Standard Libraries.")
    (license license:expat)))

(define-public python-stopit
  (package
    (name "python-stopit")
    (version "1.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "stopit" version))
       (sha256
        (base32 "0vcrcvky249q4rbgmwf18mwmnypfk8jpn4h6knyjf86r7xc9rwzp"))))
    (build-system python-build-system)
    (arguments '(#:tests? #f)) ;there are none
    (home-page "https://pypi.python.org/pypi/stopit")
    (synopsis "Timeout control decorator and context managers")
    (description
     "Raise asynchronous exceptions in other threads, control the timeout of
blocks or callables with two context managers and two decorators.")
    (license license:expat)))

(define-public python-timeout-decorator
  (package
    (name "python-timeout-decorator")
    (version "0.5.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "timeout-decorator" version))
              (sha256
               (base32
                "1mxk2qyydhzncm93z08kvj5ssxq3fr2n7pkrrji28nqwvdc2ybva"))))
    (build-system python-build-system)
    (home-page "https://github.com/pnpnpn/timeout-decorator")
    (synopsis "Timeout decorator")
    (description "This package provides a decorator that raises an error
when an operation takes longer than expected.")
    (license license:expat)))

(define-public python-straight-plugin
  (package
    (name "python-straight-plugin")
    (version "1.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "straight.plugin" version))
       (sha256
        (base32
         "069pjll4383p4kkgvcc40hgyvf79j2wdbpgwz77yigzxksh1gj62"))))
    (build-system python-build-system)
    (home-page "https://github.com/ironfroggy/straight.plugin")
    (synopsis "Simple namespaced plugin facility")
    (description "Straight Plugin provides a type of plugin you can create from
almost any existing Python modules, and an easy way for outside developers to
add functionality and customization to your projects with their own plugins.")
    (license license:expat)))

(define-public python-strenum
  (package
    (name "python-strenum")
    (version "0.4.15")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "StrEnum" version))
       (sha256
        (base32 "1zrfr1shin5wyfnfxc7jpk013594wasrp4ni9l70fhjlf2mvb3w7"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #false)) ;there are none.
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/irgeek/StrEnum")
    (synopsis "Enum that inherits from str")
    (description "StrEnum is a Python @code{enum.Enum} that inherits from
@code{str} to complement @code{enum.IntEnum} in the standard library.")
    (license license:expat)))

(define-public python-pysendfile
  (package
    (name "python-pysendfile")
    (version "2.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pysendfile" version))
       (sha256
        (base32 "05qf0m32isflln1zjgxlpw0wf469lj86vdwwqyizp1h94x5l22ji"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases #~(modify-phases %standard-phases
                   (replace 'check
                     (lambda* (#:key tests? #:allow-other-keys)
                       (when tests?
                         (setenv "HOME" "/tmp")
                         (invoke "make" "test")))))))
    (home-page "https://github.com/giampaolo/pysendfile")
    (synopsis "Python interface to sendfile(2)")
    (description "The @{pysendfile} Python library provides an interface to
the @code{sendfile(2)} system call.")
    (license license:expat)))

(define-public python-pyftpdlib
  (package
    (name "python-pyftpdlib")
    (version "1.5.7")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyftpdlib" version))
       (sha256
        (base32 "0vk5gcx4svjrpm014ykwxmijqihgb4ha17kb3yphk0nv6x0wx8vy"))))
    (build-system pyproject-build-system)
    ;; Using Pytest instead of the Makefile causes the command line tests to
    ;; fail on unknown Pytest arguments.
    (arguments (list #:test-flags #~(list "-k" "not TestCommandLineParser")))
    (native-inputs (list python-psutil python-pytest python-setuptools
                         python-wheel))
    (propagated-inputs (list python-pyopenssl python-pysendfile))
    (home-page "https://github.com/giampaolo/pyftpdlib/")
    (synopsis "Asynchronous and scalable Python FTP server library")
    (description "The Python FTP server library provides a high-level
interface to write efficient, scalable and asynchronous FTP servers with
Python.  It is the most complete @url{http://www.faqs.org/rfcs/rfc959.html,
RFC-959} FTP server implementation available for Python, and has the following
traits:
@itemize
@item
It is lightweight, fast and scalable.
@item
It uses the @code{sendfile(2)} system call for uploads.
@item
It uses @code{epoll}, @code{kqueue} and @code{select} to handle concurrency
asynchronously.
@item
It supports FTPS (@url{http://tools.ietf.org/html/rfc4217, RFC-4217}),
IPv6 (RFC-2428), Unicode file names (@url{http://tools.ietf.org/html/rfc2640,
RFC-2640}) and MLSD/MLST commands (RFC-3659).
@item
It has a flexible system of @samp{authorizers} able to manage both
@samp{virtual} and @samp{real} users.
@end itemize")
    (license license:expat)))

(define-public python-fs
  (package
    (name "python-fs")
    (version "2.4.16")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "fs" version))
       (sha256
        (base32 "04ykd7q49qgv13hl2n71lzihs2c9099r50lmd85vgx0k2bawg5xf"))))
    (build-system python-build-system)
    (arguments
     (list
      #:tests? (and (not (%current-target-system))
                    (->bool (this-package-native-input "python-pytest")))
      #:phases #~(modify-phases %standard-phases
                   (replace 'check
                     (lambda* (#:key tests? #:allow-other-keys)
                       (when tests?
                         (setenv "HOME" "/tmp")
                         (invoke "pytest" "-m" "not slow")))))))
    (propagated-inputs
     (list python-appdirs python-pytz python-six))
    (native-inputs
     ;; 'python-pyftpdlib' is needed for tests but it indirectly depends Rust,
     ;; which is currently unavailable on aarch64-linux.  Remove all the test
     ;; dependencies in that case.
     (if (and (not (%current-target-system))
              (supported-package? python-pyftpdlib))
         (list python-mock python-parameterized python-pyftpdlib
               python-pytest)
         '()))
    (home-page "https://github.com/PyFilesystem/pyfilesystem2/")
    (synopsis "File system abstraction layer for Python")
    (description "PyFilesystem's @code{FS} object is a file system abstraction
sharing similarities with Python's own @code{file} object for single files.
It allows opening all the files under a given directory recursively, as a
single @code{FS} object.  This enables, for example, counting the combined
number of lines in the contained files easily.")
    (license license:expat)))

;;; Tests are left out in the main package to avoid cycles.
(define-public python-fonttools-minimal
  (hidden-package
   (package
     (name "python-fonttools-minimal")
     (version "4.39.3")
     (source (origin
               (method url-fetch)
               (uri (pypi-uri "fonttools" version ".zip"))
               (sha256
                (base32
                 "1msibi5cmi5znykkg66dq7xshl07lkqjxhrz5hcipqvlggsvjd4j"))))
     (build-system python-build-system)
     (native-inputs
      (list unzip))
     (arguments '(#:tests? #f))
     (home-page "https://github.com/fonttools/fonttools")
     (synopsis "Tools to manipulate font files")
     (description
      "FontTools/TTX is a library to manipulate font files from Python.  It
supports reading and writing of TrueType/OpenType fonts, reading and writing
of AFM files, reading (and partially writing) of PS Type 1 fonts.  The package
also contains a tool called “TTX” which converts TrueType/OpenType fonts to and
from an XML-based format.")
     (license license:expat))))

(define-public python-fonttools
  (let ((base python-fonttools-minimal))
    (package/inherit base
      (name "python-fonttools")
      (arguments
       (substitute-keyword-arguments (package-arguments base)
         ((#:tests? _ #f)
          (not (%current-target-system)))
         ((#:phases phases '%standard-phases)
          `(modify-phases ,phases
             (replace 'check
               (lambda* (#:key tests? #:allow-other-keys)
                 (when tests?
                   (invoke "pytest" "-vv"
                           "-k"
                           ;; XXX: These tests need .trm files that are
                           ;; not shipped with the PyPI release.
                           (format #f "not ~a"
                                   (string-join
                                    '("test_read_fontdimens_mathsy"
                                      "test_read_fontdimens_mathex"
                                      "test_read_fontdimens_vanilla"
                                      "test_read_boundary_char"
                                      "fontTools.tfmLib"
                                      ;; The MtiTest tests fail for unknown
                                      ;; reasons (see:
                                      ;; https://github.com/fonttools/
                                      ;; fonttools/issues/3078)
                                      "MtiTest")
                                    " and not "))))))))))
      (native-inputs
       (modify-inputs (package-native-inputs base)
         (append python-pytest)))
      (propagated-inputs
       (list python-brotli
             python-fs
             python-lxml
             python-lz4
             python-scipy
             python-unicodedata2
             python-zopfli))
      (properties (alist-delete 'hidden? (package-properties base))))))

(define-public python-ly
  (package
    (name "python-ly")
    (version "0.9.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri name version))
       (sha256
        (base32
         "0x98dv7p8mg26p4816yy8hz4f34zf6hpnnfmr56msgh9jnsm2qfl"))))
    (build-system python-build-system)
    (arguments
     ;; FIXME: Some tests need network access.
     '(#:tests? #f))
    (synopsis "Tool and library for manipulating LilyPond files")
    (description "This package provides a Python library to parse, manipulate
or create documents in LilyPond format.  A command line program ly is also
provided that can be used to do various manipulations with LilyPond files.")
    (home-page "https://pypi.org/project/python-ly/")
    (license license:gpl2+)))

(define-public python-appdirs
  (package
    (name "python-appdirs")
    (version "1.4.4")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "appdirs" version))
        (sha256
          (base32
            "0hfzmwknxqhg20aj83fx80vna74xfimg8sk18wb85fmin9kh2pbx"))))
    (build-system python-build-system)
    (home-page "https://github.com/ActiveState/appdirs")
    (synopsis
      "Determine platform-specific dirs, e.g. a \"user data dir\"")
    (description
      "This module provides a portable way of finding out where user data
should be stored on various operating systems.")
    (license license:expat)))

(define-public python-google-pasta
  (package
    (name "python-google-pasta")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "google-pasta" version))
       (sha256
        (base32 "0vm1r1jlaiagj0l9yf7j6zn9w3733dr2169911c0svgrr3gwiwn9"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-six))
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/google/pasta")
    (synopsis "AST-based Python refactoring library")
    (description "This package provides \"pasta\", an AST-based Python
refactoring library.")
    (license license:asl2.0)))

(define-public python-gorilla
  (package
    (name "python-gorilla")
    (version "0.3.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "gorilla" version))
              (sha256
               (base32
                "0b40blcp6fih4nvqbilra4qw1dfccv1ahjmr41ac4d9rjadqkcpy"))))
    (build-system python-build-system)
    (home-page "https://github.com/christophercrouzet/gorilla")
    (synopsis "Convenient monkey patching with Python")
    (description
     "Gorilla is a Python library that provides a convenient approach to
monkey patching.  Monkey patching is the process of modifying module and
class attributes at runtime with the purpose of replacing or extending
third-party code.")
    (license license:expat)))

(define-public python-llfuse
  (package
    (name "python-llfuse")
    (version "1.4.4")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "llfuse" version))
              (sha256
               (base32
                "1jb4c9avvb0v3830xlbj1r9kj05i98vv6nq05105ppg57y7lq14j"))))
    (build-system python-build-system)
    (inputs
     (list fuse-2 attr))
    (native-inputs
     (list pkg-config python-pytest))
    (synopsis "Python bindings for FUSE")
    (description
     "Python-LLFUSE is a set of Python bindings for the low level FUSE API.")
    (home-page "https://bitbucket.org/nikratio/python-llfuse/")
    (license license:lgpl2.0+)))

(define-public python-msgpack
  (package
    (name "python-msgpack")
    (version "1.0.4")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "msgpack" version))
              (sha256
               (base32
                "0pqzy1zclyhd42gfibhkcqymbspy5a6v421g87mh40h3iz0nkn7m"))))
    (build-system python-build-system)
    (arguments
     `(#:modules ((guix build utils)
                  (guix build python-build-system)
                  (ice-9 ftw)
                  (srfi srfi-1)
                  (srfi srfi-26))
       #:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "pytest" "-v" "test"))))))
    (native-inputs
     (list python-pytest))
    (synopsis "MessagePack (de)serializer")
    (description "MessagePack is a fast, compact binary serialization format,
suitable for similar data to JSON.  This package provides CPython bindings for
reading and writing MessagePack data.")
    (home-page "https://pypi.org/project/msgpack/")
    (license license:asl2.0)))

;; This msgpack library's name changed from "python-msgpack" to "msgpack" with
;; release 0.5. Some packages like poetry still call it by the old name for now.
;; <https://bugs.gnu.org/30662>
(define-public python-msgpack-transitional
  (package
    (inherit python-msgpack)
    (name "python-msgpack-transitional")
    (version "0.5.6")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "msgpack" version))
              (sha256
               (base32
                "1hz2dba1nvvn52afg34liijsm7kn65cmn06dl0xbwld6bb4cis0f"))))
    (arguments
     (substitute-keyword-arguments (package-arguments python-msgpack)
       ((#:phases phases)
        `(modify-phases ,phases
           (add-after 'unpack 'configure-transitional
             (lambda _
               ;; Keep using the old name.
               (substitute* "setup.py"
                 (("TRANSITIONAL = False")
                   "TRANSITIONAL = 1"))
               ;; This old version is not compatible with Python 3.9
               (substitute* '("test/test_buffer.py" "test/test_extension.py")
                 ((".tostring\\(") ".tobytes("))
               (substitute* '("test/test_buffer.py" "test/test_extension.py")
                 ((".fromstring\\(") ".frombytes("))
               #t))))))))

(define-public python-netaddr
  (package
    (name "python-netaddr")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "netaddr" version))
       (sha256
         (base32
          "0hx2npi0wnhwlcybilgwlddw6qffx1mb7a3sj4p9s7bvl33mgk6n"))))
    (build-system python-build-system)
    (arguments `(#:tests? #f)) ;; No tests.
    (home-page "https://github.com/drkjam/netaddr/")
    (synopsis "Pythonic manipulation of  network addresses")
    (description
      "A Python library for representing and manipulating IPv4, IPv6, CIDR, EUI
and MAC network addresses.")
    (license license:bsd-3)))

(define-public python-openstep-plist
 (package
  (name "python-openstep-plist")
  (version "0.3.0")
  (home-page "https://github.com/fonttools/openstep-plist")
  (source (origin
            (method git-fetch)
            (uri (git-reference
                  (url home-page)
                  (commit (string-append "v" version))))
            (file-name (git-file-name name version))
            (sha256
             (base32
              "1rxjgzh0p069ncsr2986rn32vhdqyq35irbqg2559jh18456mkca"))))
  (build-system python-build-system)
  (arguments
   (list #:phases
         #~(modify-phases %standard-phases
             (add-after 'unpack 'pretend-version
               (lambda _
                 (setenv "SETUPTOOLS_SCM_PRETEND_VERSION"
                         #$(package-version this-package))))
             (replace 'check
               (lambda* (#:key tests? #:allow-other-keys)
                 (when tests?
                   (invoke "pytest" "-vv")))))))
  (native-inputs
   (list python-cython python-pytest python-setuptools-scm))
  (synopsis "OpenStep plist parser and writer")
  (description
   "This package provides a parser for the \"old style\" OpenStep property
list format (also known as ASCII plist), written in Cython.")
  (license license:expat)))

(define-public python-wrapt
  (package
    (name "python-wrapt")
    (version "1.17.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "wrapt" version))
       (sha256
        (base32
         "00886b7ry1vdbvpc2wi880y563xf6y4mxwwfm1q12wvw66i7l60n"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/GrahamDumpleton/wrapt")
    (synopsis "Module for decorators, wrappers and monkey patching")
    (description
     "The aim of the wrapt module is to provide a transparent object proxy for
  Python, which can be used as the basis for the construction of function
  wrappers and decorator functions.")
    (license license:bsd-2)))

(define-public python-commentjson
  (package
    (name "python-commentjson")
    (version "0.9.0")
    (source (origin
              ;; The PyPI release is missing some test files.
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/vaidik/commentjson")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "01iscgrc6bkyrxbzmf46csbf9c0n7g6dygdmxs3fq8fkzrrciybl"))))
    (build-system python-build-system)
    (arguments
     `(#:modules ((guix build python-build-system)
                  (guix build utils)
                  (ice-9 ftw)
                  (ice-9 textual-ports))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'relax-requirements
           (lambda _
             (substitute* "setup.py"
               (("lark-parser>=0.7.1,<0.8.0")
                "lark-parser>=0.7.1"))))
         (add-after 'unpack 'delete-unspported-tests
           ;; Some tests rely on the 'test' module of Python itself,
           ;; which is not available with the Python package in Guix;
           ;; remove them.
           (lambda _
             ;; XXX: Copied from (guix build dub-build-system).
             (define (grep string file-name)
               (string-contains (call-with-input-file file-name get-string-all)
                                string))

             (with-directory-excursion "commentjson/tests/test_json"
               (let* ((dot? (lambda (x) (member x '("." ".."))))
                      (test-files (scandir "." (negate dot?))))
                 (for-each delete-file
                           (filter (lambda (f) (grep "from test." f))
                                   test-files)))))))))
    (propagated-inputs
     (list python-lark-parser))
    (native-inputs
     (list python-six))
    (home-page "https://github.com/vaidik/commentjson")
    (synopsis "Python library for adding comments to JSON files")
    (description "Comment JSON is a Python package that helps you create JSON
files with Python and JavaScript style inline comments.  Its API is very
similar to the Python standard library's @code{json} module.")
    (license license:expat)))

(define-public python-resolvelib
  (package
    (name "python-resolvelib")
    (version "1.1.0b1")
    (source
     (origin
       ;; Tests are missing from the PyPI release.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/sarugaku/resolvelib")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0y0b4qd1aai50w33szz34kqj8ls42k9shkpp3lvy0jrvzgackp9p"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-commentjson python-packaging python-pytest
           python-setuptools python-wheel))
    (home-page "https://github.com/sarugaku/resolvelib")
    (synopsis "Abstract dependencies resolver")
    (description "The ResolveLib library provides a @code{Resolver} class that
includes dependency resolution logic.")
    (license license:isc)))

(define-public python-commonmark
  (package
    (name "python-commonmark")
    (version "0.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "commonmark" version))
       (sha256
        (base32 "0q7d39lm8kcingpmykk5r959hrwwj6v2icyw3mihczxyb749sbs5"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key inputs outputs #:allow-other-keys)
             (add-installed-pythonpath inputs outputs)
             (invoke "python" "setup.py" "test"))))))
    (home-page "https://github.com/readthedocs/commonmark.py")
    (synopsis "Python parser for the CommonMark Markdown spec")
    (description
     "This module is a pure Python port of jgm's @code{commonmark.js}, a
Markdown parser and renderer for the CommonMark specification, using only
native modules.")
    (license license:bsd-3)))

(define-public python-xlrd
  (package
    (name "python-xlrd")
    (version "2.0.1")
    (source (origin
              ;; The tests are not included in the PyPI archive.
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/python-excel/xlrd")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "170asszffvf6rh5w169ic4h5kxgjkmdl3060vw737d4g1qfifvzz"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest))
    (home-page "https://www.python-excel.org/")
    (synopsis "Library for extracting data from Excel files")
    (description "This package provides a library to extract data from
spreadsheets using Microsoft Excel proprietary file formats @samp{.xls} and
@samp{.xlsx} (versions 2.0 onwards).  It has support for Excel dates and is
Unicode-aware.  It is not intended as an end-user tool.")
    (license license:bsd-3)))

;;; Note: this package is unmaintained since 2018 (archived on GitHub).
(define-public python-xlwt
  (package
    (name "python-xlwt")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "xlwt" version))
       (sha256
        (base32 "123c2pdamshkq75wwvck8fq0cjq1843xd3x9qaiz2a4vg9qi56f5"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (setenv "GUIX_PYTHONPATH"
                       (string-append (getcwd) "/build/lib:"
                                      (getenv "GUIX_PYTHONPATH")))
               (invoke "nosetests" "-v")))))))
    (native-inputs
     `(("nose" ,python-nose)))
    (home-page "https://www.python-excel.org/")
    (synopsis "Library for creating spreadsheet Excel files")
    (description "@code{xlwt} is a library for writing data and formatting
information to older Excel files (i.e. .xls).  The package itself is pure
Python with no dependencies on modules or packages outside the standard Python
distribution.  It is not intended as an end-user tool.")
    (license license:bsd-3)))

(define-public python-immutables
  (package
    (name "python-immutables")
    (version "0.21")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "immutables" version))
       (sha256
        (base32 "0jpw9nr2mbzqykigjhqa3a095bx7krwsnmjcxcpj944p8kqglpxm"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-mypy python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/MagicStack/immutables")
    (synopsis "High-performance immutable mapping type for Python")
    (description
     "An immutable mapping type for Python.  The underlying datastructure is a
Hash Array Mapped Trie (HAMT) used in Clojure, Scala, Haskell, and other
functional languages.")
    (license license:asl2.0)))

(define-public python-prettytable
  (package
    (name "python-prettytable")
    (version "3.12.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "prettytable" version))
       (sha256
        (base32 "0168xqdr0i9r4p3a3hjd4n7f133lp4xkxhvfx63aqisplcdkwjzh"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-hatchling
           python-hatch-vcs
           python-pytest
           python-pytest-cov
           python-pytest-lazy-fixtures
           python-setuptools-scm))
    (propagated-inputs
     (list python-wcwidth))
    (home-page "https://github.com/jazzband/prettytable")
    (synopsis "Display tabular data in an ASCII table format")
    (description
      "A library designed to represent tabular data in visually appealing ASCII
tables.  PrettyTable allows for selection of which columns are to be printed,
independent alignment of columns (left or right justified or centred) and
printing of sub-tables by specifying a row range.")
    (license license:bsd-3)))

(define-public python-rtf-tokenize
  (package
    (name "python-rtf-tokenize")
    (version "1.0.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "rtf_tokenize" version))
              (sha256
               (base32
                "026njb9iwznycda83bln3gfivcnzdz6vy8y86xvbsy84s28g6gaw"))))
    (build-system python-build-system)
    (native-inputs (list python-pytest))
    (home-page "https://github.com/benoit-pierre/rtf_tokenize")
    (synopsis "Simple RTF tokenizer")
    (description "This package is a simple RTF tokenizer.")
    (license license:gpl2+)))

(define-public python-curio
  (package
    (name "python-curio")
    (version "1.6")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "curio" version))
       (sha256
        (base32 "0isj3jl5mx6m25nr1f7r91hfaydhkvmks9p85dyvl5h2n9nmhajn"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list ;; AttributeError: 'NoneType' object has no attribute
              ;; 'terminate'
              "--deselect=tests/test_workers.py::test_exception"
              ;; Tries to open an outgoing connection.
              "--deselect=tests/test_network.py::test_ssl_outgoing"
              ;; This test fails since Python 3.9.9, see
              ;; <https://github.com/dabeaz/curio/issues/347>.
              ;; AttributeError: 'NoneType' object has no attribute
              ;; 'terminate'
              "--deselect=tests/test_workers.py::test_worker_timeout"
              ;; AttributeError: 'NoneType' object has no attribute
              ;; 'terminate'
              "--deselect=tests/test_workers.py::test_bad_cpu"
              "--deselect=tests/test_workers.py::test_cpu"
              "--deselect=tests/test_workers.py::test_worker_cancel")))
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (home-page "https://github.com/dabeaz/curio")
    (synopsis "Coroutine-based library for concurrent Python")
    (description
     "Curio is a coroutine-based library for concurrent Python systems
programming.  It provides standard programming abstractions such as as
tasks, sockets, files, locks, and queues.")
    (license license:bsd-3)))

(define-public python-tables
  (package
    (name "python-tables")
    (version "3.10.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "tables" version))
       (sha256
        (base32
         "1kr6y4qivqy462gva4bqym3x4alhxijfqjplxax3gh5r6k3pm82a"))
       (snippet '(begin
                   (use-modules (guix build utils))
                   (delete-file-recursively "c-blosc")))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'disable-tuning
            (lambda _
              (substitute* "setup.py"
                (("cpu_flags = .*")
                 "cpu_flags = ['sse2']\n"))))
          (add-after 'unpack 'fix-reference-to-blosc2
            (lambda* (#:key inputs #:allow-other-keys)
              (substitute* "tables/__init__.py"
                (("( +)os.path.join\\(current_dir, blosc2_lib_hardcoded\\),"
                  m indent)
                 (string-append indent
                                "\""
                                (search-input-file inputs "/lib/libblosc2.so")
                                "\",\n" m)))))
          (add-before 'build 'set-LD_LIBRARY_PATH
            (lambda _
              ;; The setup.py build system makes use of ctypes.CDLL, which
              ;; uses dlopen, which looks up library names from standard
              ;; locations or LD_LIBRARY_PATH.
              (setenv "LD_LIBRARY_PATH" (getenv "LIBRARY_PATH"))))
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (invoke "python" "setup.py" "check")))))))
    (propagated-inputs
     (list python-blosc2
           python-numpy
           python-numexpr
           python-packaging
           python-py-cpuinfo
           python-typing-extensions))
    (native-inputs (list pkg-config python-cython))
    (inputs (list c-blosc c-blosc2 hdf5-1.10 bzip2 lzo zlib))
    (home-page "https://www.pytables.org/")
    (synopsis "Hierarchical datasets for Python")
    (description "PyTables is a package for managing hierarchical datasets and
designed to efficiently cope with extremely large amounts of data.")
    (license license:bsd-3)))

(define-public python-tasklogger
  (package
    (name "python-tasklogger")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "tasklogger" version))
       (sha256
        (base32 "1901mibcp6aiyjy8afnybrxnb0dkbdxlbvjqbr3gginlw7dr18xh"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-deprecated))
    (native-inputs (list python-coverage python-coveralls python-nose2
                         python-numpy python-setuptools python-wheel))
    (home-page "https://github.com/scottgigante/tasklogger")
    (synopsis "Extension to the core Python logging library")
    (description "This package provides an extension to the core Python
logging library for logging the beginning and completion of tasks and
subtasks.")
    (license license:gpl2)))

(define-public python-sniffio
  (package
    (name "python-sniffio")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "sniffio" version))
       (sha256
        (base32 "1p496yran6zwg47m7w26r8y89nrsbkrrbf4119slj3qaczf4wcpl"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-curio
           python-pytest
           python-pytest-cov
           python-setuptools
           python-wheel))
    (home-page "https://github.com/python-trio/sniffio")
    (synopsis "Detect which async library a program is running under")
    (description "This package detects which async library a program is
running under.  It supports multiple async I/O packages, like Trio, and
asyncio.")
    ;; Either license applies.
    (license (list license:expat license:asl2.0))))

(define-public python-snuggs
  (package
    (name "python-snuggs")
    (version "1.4.7")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "snuggs" version))
              (sha256
               (base32
                "0yv1wayrw9g6k0c2f721kha7wsv0s1fdlxpf5x7f34iqzq9z272h"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-numpy python-pyparsing))
    (native-inputs (list python-hypothesis python-pytest python-setuptools
                         python-wheel))
    (home-page "https://github.com/mapbox/snuggs")
    (synopsis "Snuggs are S-expressions for Numpy")
    (description "Snuggs are S-expressions for Numpy.")
    (license license:expat)))

(define-public python-pytest-black
  (package
    (name "python-pytest-black")
    (version "0.3.12")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pytest-black" version))
       (sha256
        (base32
         "19bmbcnaq02md8nnj6pywri3vps8sxnhysbfy386qkbn9w09ncqx"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-pytest python-black python-toml))
    (native-inputs
     (list python-setuptools-scm))
    (home-page "https://github.com/shopkeep/pytest-black")
    (synopsis "Pytest plugin to enable format checking with black")
    (description
     "This package provides a pytest plugin to enable format checking with the
Python code formatter \"black\".")
    (license license:expat)))

(define-public python-geojson
  (package
    (name "python-geojson")
    (version "3.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "geojson" version))
       (sha256
        (base32 "1b5df7skx3906046j12yjv8gdbcy17q9y3lbqbpmi83yf90gm9sq"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/jazzband/geojson")
    (synopsis "Python bindings and utilities for GeoJSON")
    (description
     "This package provides Python bindings and utilities for
@uref{http://geojson.org/, GeoJSON}, a format for encoding geographic data
structures.")
    (license license:bsd-3)))

;; pyowm only accepts a version less than version 3.
(define-public python-geojson-for-pyowm
  (package
    (inherit python-geojson)
    (version "2.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "geojson" version))
       (sha256
        (base32 "12k5bzqskvq3gqzkryarhdjl0df47y5k9cf8r3clasi2wjnbfjvf"))))
    (arguments
     ;; https://github.com/jazzband/geojson/issues/175
     (list #:tests? #f))))

(define-public python-gpxpy
  (package
    (name "python-gpxpy")
    (version "1.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "gpxpy" version))
       (sha256
        (base32 "1bh1dkrbmcqb46r7j4fazzq7j6zfr2f04frm6h4bhhpcjx5lhb57"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-setuptools python-wheel))
    (home-page "https://github.com/tkrajina/gpxpy")
    (synopsis "Python GPX parser")
    (description "GPX file parser and GPS track manipulation library.")
    (license license:asl2.0)))

(define-public wfetch
  (let ((commit "e1cfa37814aebc9eb56ce994ebe877b6a6f9a715")
        (revision "2"))
    (package
      (name "wfetch")
      (version (git-version "0.1-pre" revision commit))
      (home-page "https://github.com/Gcat101/Wfetch")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference (url home-page)
                             (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1dmr85plx8zr6s14ym3r32g6crwxghkval5a24ah90ijx4dbn5q5"))))
      (build-system python-build-system)
      (arguments
       `(#:use-setuptools? #f           ; no setup.py
         #:tests? #f                    ; no test suite
         #:phases
         (modify-phases %standard-phases
           (delete 'build)
           (replace 'install
             (lambda* (#:key outputs #:allow-other-keys)
               (let* ((out (assoc-ref outputs "out"))
                      (bin (string-append out "/bin"))
                      (share (string-append out "/share")))
                 (mkdir-p share)
                 (substitute* "wfetch/wfetch.py"
                   (("os.sep, 'opt', 'wfetch'") (string-append "'" share "'")))
                 ; The documentation expects the executable to be named
                 ; 'wfetch', not 'wfetch.py'.
                 (rename-file "wfetch/wfetch.py" "wfetch/wfetch")
                 (install-file "wfetch/wfetch" bin)
                 (copy-recursively "wfetch/icons" share)))))))
      (inputs (list python-pyowm python-fire python-termcolor python-requests))
      (synopsis "Command-line tool to display weather info")
      (description
       "This package provides a tool similar to Neofetch/pfetch, but for
weather: it can display the weather condition, temperature, humidity, etc.

To use it, you must first run:

@example
export WEATHER_CLI_API=@var{your OpenWeatherMap API key}
@end example\n")
      (license license:gpl3+))))

(define-public python-get-version
  (package
    (name "python-get-version")
    (version "2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "get_version" version))
       (sha256
        (base32
         "1g15jyx33vkxavv9hwv275cs4g9bp2i1y942raw3fxamq8kbaml1"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-pygments
           python-pytest
           python-pytest-black
           python-pytest-cov
           python-setuptools
           python-testpath))
    (home-page "https://github.com/flying-sheep/get_version")
    (synopsis "Version helper in the spirit of versioneer")
    (description
     "This package provides a version helper that lets you automatically use
the latest @code{vX.X.X} Git tag as the version in your Python package.  It
also supports getting the version from Python source distributions or, once
your package is installed, via @code{pkg_resources} (part of
@code{setuptools}).")
    (license license:gpl3+)))

(define-public python-filetype
  (package
    (name "python-filetype")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "filetype" version))
       (sha256
        (base32 "1nxa91szfbhhbhvdwj06jz8zghzwgb9lf0v6aj61vx2b8zb6rdb6"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key inputs outputs tests? #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               (invoke "python" "-m" "pytest" "-k"
                       (string-append
                        ;; Both tests fail with FileNotFoundError.
                        "not test_infer_zip_from_disk"
                        " and not test_infer_tar_from_disk"))))))))
    (native-inputs
     (list python-pytest python-pytest-benchmark))
    (home-page "https://github.com/h2non/filetype.py")
    (synopsis "Infer file type and MIME type of any file/buffer")
    (description "@code{filetype} is a small and dependency free Python
package to infer file type and MIME type checking the magic numbers
signature of a file or buffer.")
    (license license:expat)))

(define-public python-cachelib
  (package
    (name "python-cachelib")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "cachelib" version))
       (sha256
        (base32 "0p4chkvbvffcllsny5rpzmsq2vyr24ql3kzif4ha0fxp3fp7vqk8"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? inputs outputs #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               (invoke "pytest")))))))
    (native-inputs
     (list python-pytest python-pytest-xprocess))
    (home-page "https://github.com/pallets/cachelib")
    (synopsis "Collection of cache libraries")
    (description "Cachelib is a library extracted from @code{werkzeug} which
provides a collection of cache libraries in the same API interface.")
    (license license:bsd-3)))

(define-public python-pylru
  (package
    (name "python-pylru")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pylru" version))
       (sha256
        (base32 "15yj46307sw703vjfkgnr04dqvaicmfcj0hc6yrciildp55r6bs9"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key inputs outputs tests? #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               (invoke "python" "test.py")))))))
    (home-page "https://github.com/jlhutch/pylru")
    (synopsis "Least recently used (LRU) cache implementation")
    (description
     "Pylru implements a true LRU cache along with several support classes.
Pylru provides a cache class with a simple dict interface.  It also provides
classes to wrap any object that has a dict interface with a cache.  Both
write-through and write-back semantics are supported.  Pylru also provides
classes to wrap functions in a similar way, including a function decorator.")
    (license license:gpl2+)))

(define-public python-legacy-api-wrap
  (package
    (name "python-legacy-api-wrap")
    (version "1.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "legacy_api_wrap" version))
       (sha256
        (base32
         "1d5jyd8d2wxm6y0s39wwqw87gdm4zqlbyz78cf3yqbrim1xdch4w"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-coverage
           python-hatch-vcs
           python-hatchling
           python-pytest))
    (home-page "https://github.com/flying-sheep/legacy-api-wrap")
    (synopsis "Legacy API wrapper")
    (description "This module defines a decorator to wrap legacy APIs.  The
primary use case is APIs defined before keyword-only parameters existed.")
    (license license:gpl3+)))

(define-public python-langdetect
  (package
    (name "python-langdetect")
    (version "1.0.9")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "langdetect" version))
       (sha256
        (base32 "1805svvb7xjm4sf1j7b6nc3409x37pd1xmabfwwjf1ldkzwgxhfb"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-six))
    (home-page "https://github.com/Mimino666/langdetect")
    (synopsis "Language detection library")
    (description
     "This library is a port of Nakatani Shuyo's language-detection library
(version from 03/03/2014) to Python.")
    (license license:expat)))

(define-public python-pyasn1
  (package
    (name "python-pyasn1")
    (version "0.4.8")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyasn1" version))
       (sha256
        (base32
         "1fnhbi3rmk47l9851gbik0flfr64vs5j0hbqx24cafjap6gprxxf"))))
    (build-system python-build-system)
    (home-page "https://pyasn1.sourceforge.net/")
    (synopsis "ASN.1 types and codecs")
    (description
     "This is an implementation of ASN.1 types and codecs in Python.  It is
suitable for a wide range of protocols based on the ASN.1 specification.")
    (license license:bsd-2)))

(define-public python-pyasn1-modules
  (package
    (name "python-pyasn1-modules")
    (version "0.2.8")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "pyasn1-modules" version))
        (sha256
         (base32
          "0pp6dcagd8c2c9qx3lahc1rdwlnmm0y0siqr5icjq2r32b3q8pwh"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-pyasn1))
    (home-page "https://sourceforge.net/projects/pyasn1/")
    (synopsis "ASN.1 codec implementations")
    (description
     "Pyasn1-modules is a collection of Python modules providing ASN.1 types and
implementations of ASN.1-based codecs and protocols.")
    (license license:bsd-3)))

(define-public python-ipaddress
  (package
    (name "python-ipaddress")
    (version "1.0.23")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "ipaddress" version))
              (sha256
               (base32
                "1qp743h30s04m3cg3yk3fycad930jv17q7dsslj4mfw0jlvf1y5p"))))
    (build-system python-build-system)
    (home-page "https://github.com/phihag/ipaddress")
    (synopsis "IP address manipulation library")
    (description
      "This package provides a fast, lightweight IPv4/IPv6 manipulation library
 in Python.  This library is used to create, poke at, and manipulate IPv4 and
 IPv6 addresses and networks.")
    (license license:psfl)))

(define-public python-asn1tools
  (package
    (name "python-asn1tools")
    (version "0.166.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "asn1tools" version))
       (sha256
        (base32 "1hragm8dsm10rlyz67xslj01bycprlnimdmq1i2acns6kl6difpn"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-bitstruct python-diskcache python-prompt-toolkit
           python-pyparsing))
    (home-page "https://github.com/eerimoq/asn1tools")
    (synopsis  "ASN.1 parsing, encoding and decoding")
    (description "This package provides ASN.1 parsing, encoding and decoding
for Python, including constraints checking.  It supports several
codecs (e.g. BER, PER, UPER, XER) as well as limited C source code generating
for OER and UPER.")
    (license license:expat)))

(define-public python-idna
  (package
    (name "python-idna")
    (version "3.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "idna" version))
       (sha256
        (base32
         "0v8f6qjfi5i7qc5icsbv2pi24qy6k6m8wjqjvdf2sxjvlpq3yr4x"))))
    (build-system python-build-system)
    (home-page "https://github.com/kjd/idna")
    (synopsis "Internationalized domain names in applications")
    (description
     "This is a library to support the Internationalised Domain Names in
Applications (IDNA) protocol as specified in RFC 5891.  This version of the
protocol is often referred to as “IDNA2008” and can produce different results
from the earlier standard from 2003.  The library is also intended to act as a
suitable drop-in replacement for the “encodings.idna” module that comes with
the Python standard library but currently only supports the older 2003
specification.")
    (license license:bsd-4)))

(define-public python-libsass
  (package
    (name "python-libsass")
    (version "0.22.0")
    (source
     (origin
       ;; PyPI tarball is missing some test files.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/sass/libsass-python")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0j6c7jb1bnpmz76gs5za41qwgrs7v1yd1jkgvsy5ql6dg2ph9vp4"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         ;; Use Guix package of libsass instead of compiling from a checkout.
         (add-before 'build 'set-libsass
           (lambda _ (setenv "SYSTEM_SASS" "indeed")))
         ;; XXX: Silent 2 failing tests, reported to upstream (closed), see
         ;; https://github.com/sass/libsass-python/issues/440.  It passed with
         ;; libsass@3.6.5 which requires rebuild the world (1200+ packages),
         ;; remove when v3.6.5 is available.
         (add-before 'check 'silent-failing-tests
           (lambda _
             (substitute* "sasstests.py"
               (("def test_build_one")
                "def __off_test_build_one")
               (("def test_stack_trace_formatting")
                "def __off_test_stack_trace_formatting"))))
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest" "sasstests.py"))))
         (add-after 'install 'delete-test
           (lambda* (#:key inputs outputs #:allow-other-keys)
             ;; Delete sasstests.py because it attempts to open a file
             ;; that is not installed when loaded, which breaks the sanity
             ;; check.
             (delete-file (string-append
                           (assoc-ref outputs "out")
                           "/lib/python"
                           (python-version
                            (dirname (dirname
                                      (search-input-file inputs "bin/python"))))
                           "/site-packages/sasstests.py")))))))
    (native-inputs
     (list python-pytest python-werkzeug))
    (inputs
     (list libsass))
    (propagated-inputs
     (list python-six))
    (home-page "https://sass.github.io/libsass-python/")
    (synopsis "Straightforward binding of libsass for Python")
    (description
     "This package provides a simple Python extension module @code{sass} which
is binding LibSass.")
    (license license:expat)))

(define-public python-idna-ssl
  (package
    (name "python-idna-ssl")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "idna-ssl" version))
       (sha256
        (base32
         "0ydrc8hpg9mdr5hqq1lqfsfbn6sjq69slwpfrnlrm3k0phqg14qj"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))          ;circular dependency with python-aiohttp
    (propagated-inputs (list python-idna))
    (home-page "https://github.com/aio-libs/idna-ssl")
    (synopsis "Patch @code{ssl.match_hostname} for Unicode(idna) domains support")
    (description "Patch @code{ssl.match_hostname} for Unicode(idna)
domains support.")
    (license license:expat)))

;;; Variant used to break a cycle with python-pip-run-bootstrap.
(define-public python-path-bootstrap
  (hidden-package
   (package
     (name "python-path-bootstrap")
     (version "17.1.0")
     (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "path" version))
        (sha256
         (base32 "1scqbwgcbisx8mb28hw789a7np953851wg6z0bbzdm519znha7nl"))))
     (build-system pyproject-build-system)
     (arguments
      (list #:tests? #f))
     (native-inputs (list python-setuptools python-setuptools-scm python-wheel))
     (home-page "https://github.com/jaraco/path")
     (synopsis "Object-oriented file system path manipulation library")
     (description "@code{path} (formerly @code{path.py}) implements path
objects as first-class entities, allowing common operations on files to be
invoked on those path objects directly.")
     (license license:expat))))

(define-public python-path
  (package/inherit python-path-bootstrap
    (name "python-path")
    (arguments
     (substitute-keyword-arguments
         (package-arguments python-path-bootstrap)
       ((#:tests? _ #f)
        (not (%current-target-system)))
       ((#:test-flags flags #~'())
        #~(append (list "-k"
                        (string-append
                         ;; Do not test the myproject.toml build as it tries
                         ;; to pull dependencies from the Internet.
                         "not project "
                         ;; This tests assumes a root user exists.
                         "and not test_get_owner"))
                  #$flags))))
    (native-inputs
     (modify-inputs (package-native-inputs python-path-bootstrap)
       (append python-appdirs
               python-packaging
               python-pygments
               python-pytest
               python-pytest-black
               python-pytest-checkdocs
               python-pytest-cov
               python-pytest-enabler
               python-pytest-flake8
               python-pytest-mypy)))
    (properties (alist-delete 'hidden?
                              (package-properties
                               python-path-bootstrap)))))

(define-public python-pathpy
  (deprecated-package "python-pathpy" python-path))

(define-public python-pretend
  (package
    (name "python-pretend")
    (version "1.0.9")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pretend" version))
       (sha256
        (base32
         "040vm94lcbscg5p81g1icmwwwa2jm7wrd1ybmxnv1sz8rl8bh3n9"))))
    (build-system python-build-system)
    (home-page "https://github.com/alex/pretend")
    (synopsis "Library for stubbing in Python")
    (description
     "Pretend is a library to make stubbing with Python easier.  Stubbing is a
technique for writing tests.  You may hear the term mixed up with mocks,
fakes, or doubles.  Basically, a stub is an object that returns pre-canned
responses, rather than doing any computation.")
    (license license:bsd-3)))

;;; Variant used to break a dependency cycle with
;;; python-pytest-perf-bootstrap.
(define-public python-pip-run-bootstrap
  (hidden-package
   (package
     (name "python-pip-run-bootstrap")
     (version "8.8.0")
     (source (origin
               (method git-fetch)
               (uri (git-reference
                     (url "https://github.com/jaraco/pip-run")
                     (commit (string-append "v" version))))
               (file-name (git-file-name name version))
               (sha256
                (base32
                 "0ycrjj3jgqcr9c2k7y8vprq65iblg0q0hvwz8zwi13gmb0ffds0c"))))
     (build-system python-build-system)
     (arguments
      (list
       #:tests? #f
       #:phases
       #~(modify-phases %standard-phases
           (add-before 'build 'pretend-version
             ;; The version string is usually derived via setuptools-scm, but
             ;; without the git metadata available this fails.
             (lambda _
               (setenv "SETUPTOOLS_SCM_PRETEND_VERSION" #$version))))))
     (native-inputs (list python-setuptools-scm))
     (propagated-inputs (list python-autocommand python-path-bootstrap
                              python-packaging))
     (home-page "https://github.com/jaraco/pip-run")
     (synopsis "Dynamic dependency loader for Python")
     (description "The @command{pip-run} command provides on-demand temporary
package installation for a single interpreter run.  It replaces this series of
commands:
@example
$ virtualenv --python pythonX.X --system-site-packages /tmp/env
$ /tmp/env/bin/pip install pkg1 pkg2 -r reqs.txt
$ /tmp/env/bin/python ...
$ rm -rf /tmp/env
@end example")
     (license license:expat))))

(define-public python-pip-run
  (package/inherit python-pip-run-bootstrap
    (name "python-pip-run")
    (arguments
     (substitute-keyword-arguments (package-arguments python-pip-run-bootstrap)
       ((#:tests? _ #f)
        (not (%current-target-system)))
       ((#:phases phases #~%standard-phases)
        #~(modify-phases #$phases
            (replace 'check
              (lambda* (#:key tests? #:allow-other-keys)
                (when tests?
                  (invoke "pytest" "-k"
                          (string-append
                           ;; Do not test the myproject.toml build as it tries
                           ;; to pull dependencies from the internet.
                           "not project "
                           ;; These tests attempt to install dependencies from
                           ;; the network and fail.
                           "and not test_pkg_imported "
                           "and not test_pkg_loaded_from_alternate_index ")))))))))
    (propagated-inputs
     (modify-inputs (package-propagated-inputs python-pip-run-bootstrap)
       (replace "python-path-bootstrap" python-path)))
    (native-inputs
     (modify-inputs (package-native-inputs python-pip-run-bootstrap)
       (append python-nbformat
               python-pygments
               python-pytest
               python-pytest-black
               python-pytest-checkdocs
               python-pytest-cov
               python-pytest-enabler
               python-pytest-flake8
               python-pytest-mypy)))
    (properties (alist-delete 'hidden? (package-properties
                                        python-pip-run-bootstrap)))))

(define-public python-tlsh
  (package
    (name "python-tlsh")
    (version "4.11.2")
    (home-page "https://github.com/trendmicro/tlsh")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference (url home-page) (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1gb5j73nw3nmx030rf8pm75rns5syxhv44zxr6i74kjicyly1i9w"))))
    (build-system python-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (add-before 'build 'configure
                 (lambda _
                   (invoke "cmake" ".")))      ;to generate tlsh_version.h
               (add-after 'configure 'chdir
                 (lambda _
                   (chdir "py_ext")))
               (replace 'check
                 (lambda* (#:key tests? #:allow-other-keys)
                   (when tests?
                     (with-directory-excursion "../Testing"
                       (invoke "./python_test.sh"))))))))
    (native-inputs (list cmake-minimal))
    (synopsis "Fuzzy matching library for Python")
    (description
     "Trend Micro Locality Sensitive Hash (TLSH) is a fuzzy matching library.
Given a byte stream with a minimum length of 256 bytes, TLSH generates a hash
value which can be used for similarity comparisons.  Similar objects have
similar hash values, which allows for the detection of similar objects by
comparing their hash values.  The byte stream should have a sufficient amount
of complexity; for example, a byte stream of identical bytes will not generate
a hash value.")
    (license license:asl2.0)))

(define-public python-termcolor
  (package
    (name "python-termcolor")
    (version "2.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "termcolor" version))
       (sha256
        (base32 "0vwaxyr2vk8gi7s1slq74nb0ssbb0wcn208ziqp48j3dv8kqv3cr"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-hatch-vcs
           python-hatchling
           python-pytest
           python-pytest-cov))
    (home-page "https://pypi.org/project/termcolor/")
    (synopsis "ANSII Color formatting for terminal output")
    (description
     "This package provides ANSII Color formatting for output in terminals.")
    (license license:expat)))

(define-public python-termcolor-1
  (package
    (inherit python-termcolor)
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "termcolor" version))
       (sha256
        (base32
         "0fv1vq14rpqwgazxg4981904lfyp84mnammw7y046491cv76jv8x"))))
    ;; There are no tests
    (arguments (list #:tests? #false))
    (native-inputs
     (list python-setuptools
           python-wheel))))

(define-public python-terminaltables
  (package
    (name "python-terminaltables")
    (version "3.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "terminaltables" version))
        (sha256
         (base32
          "109vhldk6nv1z3hzp4dyqf6rjvlhl0y2k5k7qcm9fcrq5swhxszk"))))
    (build-system python-build-system)
    (home-page "https://github.com/Robpol86/terminaltables")
    (synopsis
     "Generate simple tables in terminals from a nested list of strings")
    (description
     "This package makes it easy to draw tables in terminal/console
applications from a list of lists of strings.  It supports multi-line rows.")
    (license license:expat)))

(define-public python-term-background
  (package
    (name "python-term-background")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "term_background" version))
       (sha256
        (base32 "0p674silrwc3jncncmdnj1lr6pl2q5qbx0xi3mzjq9sgcs5vmp4n"))))
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'fix-build
           (lambda _ (delete-file "setup.py"))))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-setuptools-scm
           python-wrapper
           python-wheel))
    (home-page "http://github.com/rocky/shell-term-background")
    (synopsis "Determine if shell has a light or dark background")
    (description "This package determines if shell has a light or dark
background.")
    (license license:gpl2+)))

(define-public python-libarchive-c
  (package
    (name "python-libarchive-c")
    (version "2.9")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "libarchive-c" version))
              (sha256
               (base32
                "0q7g6a97110bk0j5x81555kajyxh4sybaabab6v5sgr0xi6386cr"))))
    (build-system python-build-system)
    (arguments
     '(#:phases (modify-phases %standard-phases
                  (add-before
                   'build 'reference-libarchive
                   (lambda* (#:key inputs #:allow-other-keys)
                     ;; Retain the absolute file name of libarchive.so.
                     (let ((libarchive (assoc-ref inputs "libarchive")))
                       (substitute* "libarchive/ffi.py"
                         (("find_library\\('archive'\\)")
                          (string-append "'" libarchive
                                         "/lib/libarchive.so'"))))))
                  (replace 'check
                    (lambda _ (invoke "pytest" "-vv"))))))
    (native-inputs
     (list python-mock python-pytest))
    (inputs
     (list libarchive))
    (home-page "https://github.com/Changaco/python-libarchive-c")
    (synopsis "Python interface to libarchive")
    (description
     "This package provides Python bindings to libarchive, a C library to
access possibly compressed archives in many different formats.  It uses
Python's @code{ctypes} foreign function interface (FFI).")
    (license license:lgpl2.0+)))

(define-public python-file
  (package/inherit file
    (name "python-file")
    (build-system python-build-system)
    (arguments
     '(#:tests? #f                                ;no tests
       #:configure-flags '("--single-version-externally-managed" "--root=/")
       #:phases (modify-phases %standard-phases
                  (add-before 'build 'change-directory
                    (lambda _
                      (chdir "python")
                      #t))
                  (add-before 'build 'set-library-file-name
                    (lambda* (#:key inputs #:allow-other-keys)
                      (let ((file (assoc-ref inputs "file")))
                        (substitute* "magic.py"
                          (("find_library\\('magic'\\)")
                           (string-append "'" file "/lib/libmagic.so'")))
                        #t))))))
    (inputs `(("file" ,file)))
    (native-inputs (if (%current-target-system)
                       `(("self" ,this-package))
                       '()))
    (synopsis "Python bindings to the libmagic file type guesser")
    (description "This package provides Python bindings to the libmagic file
type guesser.

Note that this module and the @code{python-magic} module both provide a
@file{magic.py} file; these two modules, which are different and were
developed separately, both serve the same purpose: provide Python bindings for
libmagic.")))

(define-public python-pydevd
  (package
    (name "python-pydevd")
    (version "3.2.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/fabioz/PyDev.Debugger")
             (commit (string-append
                      "pydev_debugger_"
                      (string-join (string-split version #\.) "_")))))
       (modules '((guix build utils)))
       (snippet '(begin
                   ;; Delete pre-built binaries.
                   (for-each delete-file (find-files "." "\\.(so|dylib|dll)"))
                   ;; This source is generated via Cython.
                   (delete-file "_pydevd_bundle/pydevd_cython.c")))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0a40574f0rx23gissxmrpjq9cimhjxqsq9wbv5l7620h3blb5510"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "-n" (number->string (parallel-job-count))
              "-m" "not flaky"
              "-k"
              (string-append
               ;; The two "break_01" tests have been failing on
               ;; Python 3.10:
               ;; <https://github.com/fabioz/PyDev.Debugger/issues/222>.
               "not test_set_pydevd_break_01 "
               ;; the GUI event loop requires an X server.
               "and not test_gui_event_loop_custom "
               ;; This test validates that 'pydevd' is not in the
               ;; exception message, but it is due to being part
               ;; of the build file name present in the message.
               "and not test_evaluate_exception_trace "
               ;; This test fail with TimeoutError, no message on stderr.
               "and not test_soft_terminate "
               "and not test_debugger_case_deadlock_interrupt_thread"))
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-tests
            (lambda _
              (substitute* "tests_python/test_convert_utilities.py"
                ;; Add missing trailing '/'.
                (("\"\\\\\\\\usr\\\\\\\\bin\\\\\\\\\") == \"/usr/bin" all)
                 (string-append all "/")))))
          (add-after 'unpack 'patch-command-paths
            (lambda* (#:key inputs #:allow-other-keys)
              (substitute* "_pydevd_bundle/pydevd_api.py"
                (("'kill'")
                 (format #f "~s" (search-input-file inputs "bin/kill")))
                (("'pgrep'")
                 (format #f "~s" (search-input-file inputs "bin/pgrep"))))))
          (add-after 'unpack 'generate-sources
            (lambda _
              (setenv "PYTHONPATH" (getcwd))
              (invoke "python" "build_tools/build.py")))
          (add-after 'unpack 'adjust-attach-binary-name
            (lambda _
              (substitute*
                  '("pydevd_tracing.py"
                    "pydevd_attach_to_process/add_code_to_python_process.py")
                (("def get_(target|python_helper_lib)_filename.*" all)
                 (format #f "~a    return ~s~%" all
                         (string-append #$output "/lib/attach.so"))))))
          (add-after 'unpack 'patch-gdb
            (lambda* (#:key inputs #:allow-other-keys)
              (substitute*
                  "pydevd_attach_to_process/add_code_to_python_process.py"
                (("'gdb',")
                 (format #f "~s," (search-input-file inputs "bin/gdb"))))))
          (add-after 'build 'build-attach-linux-binary
            (lambda _
              (invoke #+(cxx-for-target) "-shared" "-o" "attach.so"
                      "-fPIC" "-nostartfiles"
                      "pydevd_attach_to_process/linux_and_mac/attach.cpp")))
          (add-before 'check 'pre-check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                ;; Without this we get this error: type object 'GreenSocket'
                ;; has no attribute 'sendmsg'.
                (setenv "EVENTLET_NO_GREENDNS" "YES")
                (setenv "PYDEVD_USE_CYTHON" "YES"))))
          (add-after 'install 'install-attach-binary
            (lambda _
              (install-file "attach.so"
                            (string-append #$output "/lib"))))
          ;; Some modules aren't designed to be loadable by themselves, such
          ;; as 'pydev_app_engine_debug_startup' and fail.
          (delete 'sanity-check))))
    (native-inputs
     (list python-cython
           python-numpy
           python-psutil
           python-pytest
           python-pytest-xdist
           python-setuptools
           python-trio
           python-untangle
           python-wheel))
    (inputs (list coreutils gdb/pinned procps))
    (home-page "https://github.com/fabioz/PyDev.Debugger/")
    (synopsis "Python debugger")
    (description "PyDev.Debugger is a capable Python debugger used in PyDev
and other @acronym{IDEs, Integrated Development Environments}.")
    (license license:epl1.0)))

(define-public python-debugpy
  (package
    (name "python-debugpy")
    (version "1.8.9")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference              ;no tests in PyPI archive
             (url "https://github.com/microsoft/debugpy")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (modules '((guix build utils)))
       ;; Remove the bundled PyDev-Debugger copy, including its pre-built
       ;; attach binary.
       (snippet '(delete-file-recursively "src/debugpy/_vendored"))
       (patches (search-patches "python-debugpy-unbundle-pydevd.patch"))
       (sha256
        (base32
         "0rq9ndsg4za0np5lnlkdwaqlizay8ndm8ki2m7r7awji262dzzlx"))))
    (build-system python-build-system)
    (arguments
     (list
      #:tests? #f ; Fail on systems with YAMA LSM’s ptrace scope > 0.
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-sh-in-tests
            (lambda _
              (substitute* "tests/debugpy/test_run.py"
                (("#!/bin/sh")
                 (string-append "#!" (which "sh"))))))
          (add-after 'unpack 'fix-version
            ;; Versioneer is useless when there is no git metadata.
            (lambda _
              (substitute* "setup.py"
                (("version=versioneer.get_version\\(),")
                 (format #f "version=~s," #$version)))))
          (add-before 'build 'configure
            (lambda _
              ;; This adjusts the behavior of debugpy to load pydevd from
              ;; Python site packages.
              (setenv "DEBUGPY_BUNDLING_DISABLED" "1")))
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (invoke "pytest" "-vv"
                        "-n" (number->string (parallel-job-count))
                        "-k"
                        (string-append
                         ;; These tests cannot be run in parallel because their
                         ;; test data would not be copied by xdist and lead to
                         ;; import errors. (see:
                         ;; https://github.com/microsoft/debugpy/issues/342 and
                         ;; https://github.com/microsoft/debugpy/issues/880).
                         "not test_custom_python_args "
                         "and not test_autokill "))))))))
    (native-inputs
     ;; See: https://raw.githubusercontent.com/microsoft/debugpy/
     ;;      main/tests/requirements.txt.
     (list python-django
           python-gevent
           python-flask
           python-psutil
           python-pytest
           python-pytest-cov
           python-pytest-timeout
           python-pytest-xdist
           python-requests))
    (propagated-inputs (list python-pydevd))
    (home-page "https://aka.ms/debugpy")
    (synopsis "Debug Adapter Protocol Python implementation")
    (description "An implementation of the Debug Adapter Protocol for
Python.")
    (license license:expat)))

(define-public python-debian
  (package
    (name "python-debian")
    (home-page "https://salsa.debian.org/python-debian-team/python-debian")
    (version "0.1.49")
    (source
     (origin
       ;; Use git-fetch, as pypi doesn't include test suite.
       (method git-fetch)
       (uri (git-reference
             (url home-page)
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "190vy2ns0650icpwvv4qp6kr3c3i9jszy1vkdwpigxb96fs1bqf3"))
       (modules '((guix build utils)))
       (snippet
        #~(begin
            ;; python-apt, apt and dpkg are not yet available in guix,
            ;; and these tests heavily depend on them.
            (for-each delete-file
                      '("lib/debian/tests/test_deb822.py"
                        "lib/debian/tests/test_debfile.py"))

            ;; for reproducible builds, otherwise python-debian
            ;; generates a _version.py including the date
            (copy-file "lib/debian/_version.py.in" "lib/debian/_version.py")
            (substitute* "lib/debian/_version.py"
              (("__CHANGELOG_VERSION__") #$version))))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest))
    (propagated-inputs
     (list python-six python-chardet))
    (synopsis "Debian package related modules")
    (description
     "This package provides Python modules that abstract many formats of
Debian-related files, such as:
@itemize
@item Debtags information;
@item @file{debian/changelog} files;
@item packages files, pdiffs;
@item control files of single or multiple RFC822-style paragraphs---e.g.
   @file{debian/control}, @file{.changes}, @file{.dsc};
@item Raw @file{.deb} and @file{.ar} files, with (read-only) access to
   contained files and meta-information.
@end itemize")
    ;; Modules are either GPLv2+ or GPLv3+.
    (license license:gpl3+)))

(define-public python-json-spec
  (package
    (name "python-json-spec")
    (version "0.11.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "json_spec" version))
        (sha256
          (base32
            "0fwxirzxx5s9l0lwnjl6ki39xw1fsjm0vr6cm67ws27fkmcxcry7"))))
    (build-system python-build-system)
    (propagated-inputs
      (list python-importlib-metadata
            python-termcolor))
    (native-inputs
      (list python-pytest))
    (home-page "https://json-spec.readthedocs.io/")
    (synopsis
      "JSON Schema, JSON Pointer and JSON Reference for Python")
    (description
      "This Python library implements several JSON specs, like JSON Schema,
JSON Reference and JSON Pointer.")
    (license license:bsd-3)))

(define-public python-fastbencode
  (package
    (name "python-fastbencode")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "fastbencode" version))
       (modules '((guix build utils)))
       ;; Delete pre-generated Cython C files.
       (snippet '(for-each delete-file (find-files "." "\\.c$")))
       (sha256
        (base32 "15x1in22gwam7wwga5lbj1pd8hc9jk741pia3pv1m29n2xywpq2z"))))
    (build-system python-build-system)
    (native-inputs (list python-cython-3))
    (home-page "https://github.com/breezy-team/fastbencode")
    (synopsis "Python Bencode (de)serializer with optional fast C extensions")
    (description
     "The fastbencode Python package implements the bencode serialization
format for storing and transmitting loosely structured data, originally used
by BitTorrent.

The format can encode four different types of values: byte strings, integers,
lists, and dictionaries (associative arrays).  It's simple and unaffected by
endianness,

This package includes both a pure-Python version and an optional C extension
based on Cython.  Both provide the same functionality, but the C version has
significantly better performance.")
    (license (list license:expat        ; _bencode_py.py
                   license:gpl2+))))    ; __init__.py

(define-public python-fastjsonschema
  (package
    (name "python-fastjsonschema")
    (version "2.20.0")
    (source
     (origin
       (method git-fetch)               ; no tests in PyPI release
       (uri (git-reference
             (url "https://github.com/horejsek/python-fastjsonschema")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0aqj7hf1fgana9hh9la475wiyivcr46fra1bvigp00805g14k599"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-colorama
           python-json-spec
           python-jsonschema
           python-pytest
           python-pytest-benchmark
           python-pytest-cache
           python-setuptools
           python-wheel))
    (home-page "https://github.com/horejsek/python-fastjsonschema")
    (synopsis "Fast Python implementation of JSON schema")
    (description
     "This library implements validation of JSON documents by JSON schema for
drafts 04, 06 and 07.")
    (license license:bsd-3)))

(define-public python-nbformat
  (package
    (name "python-nbformat")
    (version "5.10.4")
    ;; The PyPi release tarball lacks some test cases and test data.
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/jupyter/nbformat")
                    (commit (string-append "v" version))))
              (sha256
               (base32
                "0abd1d8iq21dwh17m72na2f3kr6a5p6ji1gnykf06jshikalj2x3"))
              (file-name (git-file-name name version))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          ;; We don't want to use hatch-nodejs just to get a version string.
          (add-after 'unpack 'patch-pyproject
            (lambda _
              (substitute* "pyproject.toml"
                ((", \"hatch-nodejs-version\"") "")
                (("dynamic = \\[\"version\"\\]")
                 (string-append "version = \"" #$version "\""))))))))
    (propagated-inputs
     (list python-fastjsonschema python-jsonschema python-jupyter-core
           python-traitlets))
    (native-inputs
     (list python-hatchling
           python-pep440
           python-pytest
           python-testpath))
    (home-page "https://jupyter.org")
    (synopsis "Jupyter Notebook format")
    (description "This package provides the reference implementation of the
Jupyter Notebook format and Python APIs for working with notebooks.")
    (license license:bsd-3)))

(define-public python-nb-clean
  (package
    (name "python-nb-clean")
    (version "2.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "nb-clean" version))
        (sha256
          (base32 "01qvk9n7rx15dhc23m8bj9bw5wdyxh6y18c5fm8hllmrd3ndsx14"))))
    (build-system python-build-system)
    (propagated-inputs (list python-nbformat))
    (home-page "https://github.com/srstevenson/nb-clean")
    (synopsis "Clean Jupyter notebooks for versioning")
    (description "This package cleans Jupyter notebooks of cell execution
counts, metadata, outputs, and empty cells, preparing them for committing to
version control.  It provides a Git filter to automatically clean notebooks
before they're staged, and can also be used with other version control
systems, as a command line tool, and as a Python library.")
    (license license:isc)))

(define-public python-bleach
  (package
    (name "python-bleach")
    (version "6.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "bleach" version))
       (sha256
        (base32 "054lp46iymchq3np0nar3k2h4da3wq4rzw652kdxh1syb70qa6hs"))
       (snippet
        #~(begin
            (use-modules (guix build utils))
            (substitute* (find-files "." "\\.py$")
              (("bleach\\._vendor\\.html5lib") "html5lib"))
            (delete-file-recursively "bleach/_vendor/html5lib")))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-html5lib python-tinycss2))
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/mozilla/bleach")
    (synopsis "Whitelist-based HTML-sanitizing tool")
    (description "Bleach is an easy whitelist-based HTML-sanitizing tool.")
    (license license:asl2.0)))

(define-public python-entrypoints
  (package
    (name "python-entrypoints")
    (version "0.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "entrypoints" version))
       (sha256
        (base32
         "0lc4si3xb7hza424414rdqdc3vng3kcrph8jbvjqb32spqddf3f7"))))
    (build-system python-build-system)
    ;; The package does not come with a setup.py file, so we have to generate
    ;; one ourselves.
    (arguments
     `(#:tests? #f
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'create-setup.py
           (lambda _
             (call-with-output-file "setup.py"
               (lambda (port)
                 (format port "\
from setuptools import setup
setup(name='entrypoints', version='~a', py_modules=['entrypoints'])
" ,version))))))))
    (home-page "https://github.com/takluyver/entrypoints")
    (synopsis "Discover and load entry points from installed Python packages")
    (description "Entry points are a way for Python packages to advertise
objects with some common interface.  The most common examples are
@code{console_scripts} entry points, which define shell commands by
identifying a Python function to run.  The @code{entrypoints} module contains
functions to find and load entry points.")
    (license license:expat)))

(define-public python-epc
  (package
    (name "python-epc")
    (version "0.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "epc" version))
       (sha256
        (base32
         "09bx1ln1bwa00917dndlgs4k589h8qx2x080xch5m58p92kjwkd1"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-sexpdata))
    (native-inputs
     (list python-nose))
    (home-page "https://github.com/tkf/python-epc")
    (synopsis "Remote procedure call (RPC) stack for Emacs Lisp and Python")
    (description
     "Python-EPC can call elisp functions from Python and Python functions
from elisp.")
    (license license:gpl3)))

(define-public python-forex-python
  (package
    (name "python-forex-python")
    (version "1.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "forex-python" version))
       (sha256
        (base32 "1ma8cl1i2dh8aa99pifnlilyy4d1gd1s07fj0yd17wcbpsh532cj"))))
    (build-system python-build-system)
    (arguments
     ;; Tests are not included in the PyPI tarball.  Also, the tests in the
     ;; repository require online data.
     `(#:tests? #f))
    (propagated-inputs
     (list python-requests python-simplejson))
    (home-page "https://github.com/MicroPyramid/forex-python")
    (synopsis "Foreign exchange rates and currency conversion")
    (description
     "@code{python-forex-python} can be used to manipulate foreign
exchange rates and to operate currency conversions.

Features:
@itemize
@item List all currency rates.
@item BitCoin price for all currencies.
@item Converting amount to BitCoins.
@item Get historical rates for any day since 1999.
@item Conversion rate for one currency(ex; USD to INR).
@item Convert amount from one currency to other.('USD 10$' to INR).
@item Currency symbols.
@item Currency names.
@end itemize")
    (license license:expat)))

(define-public python-simpleeval
  (package
    (name "python-simpleeval")
    (version "0.9.12")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "simpleeval" version))
       (sha256
        (base32 "0diysdzvx865yy2rjfah75ha2qfxaxz7r108kp7j2kkd903ya2ry"))))
    (build-system python-build-system)
    (home-page "https://github.com/danthedeckie/simpleeval")
    (synopsis "Simple, safe single expression evaluator library")
    (description
     "This package provides a quick single file library for easily adding
evaluatable expressions into python projects.  Say you want to allow a user
to set an alarm volume, which could depend on the time of day, alarm level,
how many previous alarms had gone off, and if there is music playing at the
time.")
    (license license:expat)))

(define-public python-nbconvert
  (package
    (name "python-nbconvert")
    (version "7.16.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "nbconvert" version))
       (sha256
        (base32
         "1x7pz43nhlq3hwjn7cv753gapzwav6wwb9kgr66l82kb4sx93jl6"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      '(list "-k"
             (string-append
              ;; These tests require pyppeteer, not yet
              ;; available in Guix.
              "not test_webpdf_with_chromium"
              " and not test_webpdf.py"
              ;; These tests require ipywidgets, which would
              ;; introduce a dependency cycle.
              " and not test_execute_widgets_from_nbconvert"
              " and not test_execute_multiple_notebooks"

              ;; This test calls nbconvert itself via "sys.executable -m
              ;; nbconvert".  It's probably harmless.
              " and not test_default_config"))
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-paths
            (lambda* (#:key inputs #:allow-other-keys)
              ;; Use pandoc binary from input.
              (substitute* "nbconvert/utils/pandoc.py"
                (("'pandoc'")
                 (format #f "~s" (search-input-file inputs "bin/pandoc"))))
              ;; Same for LaTeX.
              (substitute* "nbconvert/exporters/pdf.py"
                (("\"xelatex\"")
                 (format #f "~s" (search-input-file inputs "bin/xelatex")))
                (("\"bibtex\"")
                 (format #f "~s" (search-input-file inputs "bin/bibtex"))))
              ;; Likewise for Inkscape.
              (substitute* "nbconvert/preprocessors/svg2pdf.py"
                (("inkscape_path = which\\(\"inkscape\")")
                 (format #f "inkscape_path = ~s"
                         (search-input-file inputs "bin/inkscape"))))))
          (add-after 'unpack 'ignore-deprecation-warnings
            (lambda _
              (substitute* "pyproject.toml"
                (("\"ignore:nbconvert.utils" m)
                 (string-append "\"ignore:zmq.eventloop.ioloop is deprecated:DeprecationWarning\",\n"
                                m)))))
          (add-before 'check 'pre-check
            (lambda _
              ;; Tests depend on templates installed to output.
              (setenv "JUPYTER_PATH"
                      (string-append #$output "/share/jupyter:"
                                     (getenv "JUPYTER_PATH")))
              ;; jupyter-core demands this
              (setenv "JUPYTER_PLATFORM_DIRS" "1")
              ;; Tests need a writable HOME.
              (setenv "HOME" "/tmp"))))))
    (inputs
     (list inkscape/stable pandoc))
    (native-inputs
     (list python-flaky
           python-hatchling
           python-ipykernel
           ;; Adding ipywidgets would create a cycle.
           ;;python-ipywidgets
           python-pytest
           python-pytest-xdist))
    (propagated-inputs
     (list python-beautifulsoup4
           python-bleach
           python-defusedxml
           python-importlib-metadata
           python-jinja2
           python-jupyter-core
           python-jupyterlab-pygments
           python-markupsafe
           python-mistune
           python-nbclient
           python-nbformat
           python-packaging
           python-pandocfilters
           python-pygments
           python-tinycss2
           python-traitlets
           ;; Required, even if [serve] is not used.
           python-tornado-6
           ;; Required at runtime for `jupyter nbconvert --to=pdf`.
           texlive-adjustbox
           texlive-amsmath
           texlive-booktabs
           texlive-caption
           texlive-collection-basic
           texlive-enumitem
           texlive-environ
           texlive-etoolbox
           texlive-eurosym
           texlive-etoolbox
           texlive-fancyvrb
           texlive-float
           texlive-fontspec
           texlive-geometry
           texlive-grffile
           texlive-hyperref
           texlive-infwarerr
           texlive-jknapltx
           texlive-kvoptions
           texlive-lm
           texlive-lm-math
           texlive-mathpazo
           texlive-ms
           texlive-parskip
           texlive-pdfcol
           texlive-pgf
           texlive-rsfs
           texlive-soul
           texlive-stringenc
           texlive-tcolorbox
           texlive-titling
           texlive-tools
           texlive-trimspaces
           texlive-ucs
           texlive-ulem
           texlive-unicode-math
           texlive-upquote
           texlive-xcolor
           texlive-xetex
           texlive-zapfding))
    (home-page "https://jupyter.org")
    (synopsis "Converting Jupyter Notebooks")
    (description "The @code{nbconvert} tool, @code{jupyter nbconvert}, converts
notebooks to various other formats via Jinja templates.  It allows you to
convert an @code{.ipynb} notebook file into various static formats including:

@enumerate
@item HTML
@item LaTeX
@item PDF
@item Reveal JS
@item Markdown (md)
@item ReStructured Text (rst)
@item executable script
@end enumerate\n")
    (license license:bsd-3)))

(define-public python-notebook
  (package
    (name "python-notebook")
    (version "6.5.7")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "notebook" version))
              (sha256
               (base32
                "1r38fwr0r4xgkz8y27w3xyz2dk97ih5azba28jylyqxcvw8r1sq4"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      '(list "-k" (string-append
                   ;; TODO: This tests fails because nbconvert does not
                   ;; list "python" as a format.
                   "not test_list_formats"
                   ;; AssertionError: Lists differ:
                   " and not test_disable"
                   " and not test_enable"
                   " and not test_merge_config"
                   " and not test_load_ordered"
                   " and not test_list_running_sock_servers"
                   " and not test_run")
        ;; These tests require a browser.
        "--ignore=notebook/tests/selenium")
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'use-our-home-for-tests
           (lambda _
             ;; The 'get_patch_env' function in this file reads:
             ;;   'HOME': cls.home_dir
             ;; but for some reason, that definition of HOME is not what the
             ;; GLib/GIO trash mechanism honors, which would cause test
             ;; failures.  Instead, set 'HOME' here to an existing directory
             ;; and let the tests honor it.
             (substitute* "notebook/tests/launchnotebook.py"
               (("'HOME': .*," all)
                (string-append "# " all "\n")))
             (setenv "HOME" (getcwd))))
         ;; Because python-jsonschema has an old python-webcolor.  Remove this
         ;; when python-team branch is merged.
         (delete 'sanity-check)
         (add-before 'check 'pre-check
           (lambda _
             ;; Interferes with test expectations.
             (unsetenv "JUPYTER_CONFIG_PATH")
             ;; Some tests do not expect all files to be installed in the
             ;; same directory, but JUPYTER_PATH contains multiple entries.
             (unsetenv "JUPYTER_PATH"))))))
    (propagated-inputs
     (list python-argon2-cffi
           python-ipykernel
           python-ipython-genutils
           python-jinja2
           python-jupyter-client
           python-jupyter-core
           python-nest-asyncio
           python-nbclassic
           python-nbconvert
           python-nbformat
           python-prometheus-client
           python-pyzmq
           python-send2trash
           python-terminado
           python-tornado-6
           python-traitlets))
    (native-inputs
     (list python-coverage
           python-jupyter-server
           python-nbval
           python-pytest
           python-pytest-cov
           python-requests
           python-requests-unixsocket
           python-setuptools
           python-wheel))
    (home-page "https://jupyter.org/")
    (synopsis "Web-based notebook environment for interactive computing")
    (description
     "The Jupyter HTML notebook is a web-based notebook environment for
interactive computing.")
    (license license:bsd-3)))

(define-public python-widgetsnbextension
  (package
    (name "python-widgetsnbextension")
    (version "4.0.10")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "widgetsnbextension" version))
       (sha256
        (base32
         "13v88h3cvlf4cs70j568abr04w0bzckl56k9iqx1iadrydgnq6b4"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-jupyter-packaging
           python-setuptools
           python-wheel))
    (home-page "https://ipython.org")
    (synopsis "IPython HTML widgets for Jupyter")
    (description "This package provides interactive HTML widgets for Jupyter
notebooks.")
    (license license:bsd-3)))

(define-public python-ipywidgets
  (package
    (name "python-ipywidgets")
    (version "8.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ipywidgets" version))
       (sha256
        (base32
         "1ja2xibll6v40va3s7wz5dfp95q01yds64z6csl2dsds94gb9ffh"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-comm python-ipython python-jupyterlab-widgets
           python-traitlets python-widgetsnbextension))
    (native-inputs
     (list python-ipykernel python-jsonschema python-pytest python-pytest-cov
           python-pytz))
    (home-page "https://ipython.org")
    (synopsis "IPython HTML widgets for Jupyter")
    (description "Ipywidgets are interactive HTML widgets for Jupyter
notebooks and the IPython kernel.  Notebooks come alive when interactive
widgets are used.  Users gain control of their data and can visualize changes
in the data.")
    (license license:bsd-3)))

(define-public python-jupyter-console
  (package
    (name "python-jupyter-console")
    (version "6.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jupyter_console" version))
       (sha256
        (base32
         "1iqrxhd8hvlyf8cqbc731ssnwm61wrycnbiczy5wsfahd3hlh8i4"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-ipykernel python-jupyter-client python-prompt-toolkit
           python-pygments))
    (native-inputs
     (list python-nose python-pytest))
    (home-page "https://jupyter.org")
    (synopsis "Jupyter terminal console")
    (description "This package provides a terminal-based console frontend for
Jupyter kernels.  It also allows for console-based interaction with non-Python
Jupyter kernels such as IJulia and IRKernel.")
    (license license:bsd-3)))

;; The python-ipython and python-jupyter-console require each other. To get
;; the functionality in both packages working, strip down the
;; python-jupyter-console package when using it as an input to python-ipython.
(define python-jupyter-console-minimal
  (package/inherit python-jupyter-console
    (name "python-jupyter-console-minimal")
    (arguments
     (substitute-keyword-arguments
         (package-arguments python-jupyter-console)
       ((#:phases phases)
        `(modify-phases ,phases
           (add-after 'install 'delete-bin
             (lambda* (#:key outputs #:allow-other-keys)
               ;; Delete the bin files, to avoid conflicts in profiles
               ;; where python-ipython and python-jupyter-console are
               ;; both present.
               (delete-file-recursively
                (string-append
                 (assoc-ref outputs "out") "/bin"))))))))
    ;; Remove the python-ipython propagated input, to avoid the cycle
    (propagated-inputs
     (modify-inputs (package-propagated-inputs python-jupyter-console)
       (delete "python-ipython")))))

(define-public python-qtconsole
  (package
    (name "python-qtconsole")
    (version "5.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "qtconsole" version))
       (sha256
        (base32 "09anp8g7vqi8z8wyi2lv21a2frd2dyhyrzvcrk2anijyqzyj0dcf"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'check 'pre-check
           (lambda _
             (setenv "QT_QPA_PLATFORM" "offscreen")
             (setenv "HOME" "/tmp")
             ;; FIXME: skip a failing test.
             (substitute* "qtconsole/tests/test_jupyter_widget.py"
               (("def test_other_output") "def _test_other_output")))))))
    (propagated-inputs
     (list python-ipykernel python-ipython-genutils python-jupyter-client
           python-jupyter-core python-pygments python-pyqt
           python-pyzmq python-qtpy python-traitlets))
    (native-inputs
     (list python-flaky python-pytest python-pytest-qt))
    (home-page "https://jupyter.org")
    (synopsis "Jupyter Qt console")
    (description "This package provides a Qt-based console for Jupyter with
support for rich media output.")
    (license license:bsd-3)))

(define-public python-jsbeautifier
  (package
    (name "python-jsbeautifier")
    (version "1.10.2")
    (home-page "https://github.com/beautify-web/js-beautify")
    (source (origin
             (method git-fetch)
             (uri (git-reference
                   (url home-page)
                   (commit (string-append "v" version))))
             (file-name (git-file-name name version))
             (sha256
              (base32
               "0wawb070ki1axb3jc9xvsrgpji52vcfif3zmjzc3z4g98m5xw4kg"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (add-after 'unpack 'chdir
                    (lambda _
                      ;; The upstream Git repository contains all the code,
                      ;; but this package only builds the python code.
                      (chdir "python")
                      #t))
                  (add-after 'unpack 'patch-python-six-requirements
                    (lambda _
                      (substitute* "python/setup.py"
                        (("six>=1.12.0")
                         "six>=1.11.0"))
                      #t)))))
    (propagated-inputs
     (list python-editorconfig python-six))
    (native-inputs
     (list python-pytest))
    (synopsis "JavaScript unobfuscator and beautifier")
    (description "Beautify, unpack or deobfuscate JavaScript, leveraging
popular online obfuscators.")
    (license license:expat)))

(define-public jupyter
  (package
    (name "jupyter")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jupyter" version))
       (sha256
        (base32
         "0pwf3pminkzyzgx5kcplvvbvwrrzd3baa7lmh96f647k30rlpp6r"))))
    (build-system python-build-system)
    (arguments
     (list
      #:tests? #f                       ;there are none.
      #:phases
      ;; Because python-jsonschema has an old python-webcolor.  Remove this
      ;; when python-team branch is merged.
      '(modify-phases %standard-phases
         (delete 'sanity-check))))
    (propagated-inputs
     (list python-ipykernel
           python-ipywidgets
           python-jupyter-console
           python-nbconvert
           python-notebook
           python-qtconsole))
    (home-page "https://jupyter.org")
    (synopsis "Web application for interactive documents")
    (description
     "The Jupyter Notebook is a web application that allows you to create and
share documents that contain live code, equations, visualizations and
explanatory text.  Uses include: data cleaning and transformation, numerical
simulation, statistical modeling, machine learning and much more.")
    (license license:bsd-3)))

(define-public python-chardet
  (package
    (name "python-chardet")
    (version "5.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "chardet" version))
       (sha256
        (base32
         "1xqwkjijq2fxn8rhcvfddl14lp39jllqbh527yy19i58g7s6yfqv"))))
    (native-inputs
     (list python-pytest python-setuptools python-wheel))
    (build-system pyproject-build-system)
    (arguments
     (list #:test-flags
           ;; Disable test that fails sporadically:
           ;; https://github.com/chardet/chardet/issues/256
           #~'("-k" "not test_detect_all_and_detect_one_should_agree")
           #:phases
           #~(modify-phases %standard-phases
               ;; This package provides a 'chardetect' executable that only
               ;; depends on Python, so customize the wrap phase to avoid
               ;; adding pytest and friends in order to save size.
               ;; (See also <https://bugs.gnu.org/25235>.)
               (replace 'wrap
                 (lambda* (#:key inputs outputs #:allow-other-keys)
                   (let* ((sitedir (site-packages inputs outputs))
                          (python (dirname (dirname
                                            (search-input-file
                                             inputs "bin/python"))))
                          (python-sitedir
                           (string-append python "/lib/python"
                                          (python-version python)
                                          "/site-packages")))
                     (wrap-program (string-append #$output "/bin/chardetect")
                       `("GUIX_PYTHONPATH" ":" suffix
                         ,(list sitedir python-sitedir)))))))))
    (home-page "https://github.com/chardet/chardet")
    (synopsis "Universal encoding detector for Python 2 and 3")
    (description
     "This package provides @code{chardet}, a Python module that can
automatically detect a wide range of file encodings.")
    (license license:lgpl2.1+)))

(define-public python-charset-normalizer
  (package
    (name "python-charset-normalizer")
    (version "2.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "charset-normalizer" version))
       (sha256
        (base32 "04zlajr77f6c7ai59l46as1idi0jjgbvj72lh4v5wfpz2s070pjp"))))
    (build-system python-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               ;; This package provides a 'normalizer' executable that only
               ;; depends on Python, so customize the wrap phase to avoid
               ;; adding pytest and friends in order to save size.
               ;; (See also <https://bugs.gnu.org/25235>.)
               (replace 'wrap
                 (lambda* (#:key inputs outputs #:allow-other-keys)
                   (let* ((sitedir (site-packages inputs outputs))
                          (python (dirname (dirname
                                            (search-input-file
                                             inputs "bin/python"))))
                          (python-sitedir
                           (string-append python "/lib/python"
                                          (python-version python)
                                          "/site-packages")))
                     (wrap-program (string-append #$output "/bin/normalizer")
                       `("GUIX_PYTHONPATH" ":" suffix
                         ,(list sitedir python-sitedir)))))))))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/ousret/charset_normalizer")
    (synopsis "Universal Charset Detector, alternative to Chardet")
    (description "This library helps you read text from an unknown charset
encoding.  Motivated by @code{chardet}, it tries to resolve the issue by
taking a new approach.  All IANA character set names for which the Python core
library provides codecs are supported.")
    (license license:expat)))

(define-public python-charset-normalizer-3
  (package
    (inherit python-charset-normalizer)
    (name "python-charset-normalizer")
    (version "3.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "charset-normalizer" version))
       (sha256
        (base32 "1m9g0f513ng4dp2vd3smi4g2nmhqkjqh3bzcza14li947frkq37k"))))))

(define-public python-docopt
  (package
    (name "python-docopt")
    (version "0.6.2")
    (source
     (origin
       (method git-fetch)
       ;; The release on PyPI does not include tests.
       (uri (git-reference
              (url "https://github.com/docopt/docopt")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0aad9gbswnnhssin2q0m5lmpm0ahyf80ahs2zjigbn5y7fvljnd0"))
       (patches (search-patches "python-docopt-pytest6-compat.patch"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "py.test")))))))
    (home-page "http://docopt.org")
    (synopsis "Command-line interface description language for Python")
    (description "This library allows the user to define a command-line
interface from a program's help message rather than specifying it
programmatically with command-line parsers like @code{getopt} and
@code{argparse}.")
    (license license:expat)))

(define-public python-pythonanywhere
  (package
    (name "python-pythonanywhere")
    (version "0.12.1")
    (source
      (origin
        (method git-fetch)
        (uri (git-reference
               (url "https://github.com/pythonanywhere/helper_scripts")
               (commit (string-append "v" version))))
        (file-name (git-file-name name version))
        (sha256
          (base32
           "12898jrq8bi90s5v3wirj7zprk08smwzwdx09y07x770frqd80vl"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'check 'change-home
           (lambda _
             (setenv "HOME" "/tmp")))
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               ;; Exclude tests marked as slowtest that assume running
               ;; inside Git repository on system with virtualenvwrapper
               ;; installed.
               (invoke "pytest" "-m" "not slowtest")))))))
    (native-inputs
      (list python-pytest
            python-psutil
            python-responses
            python-pytest-mock))
    (propagated-inputs
      (list python-dateutil
            python-docopt
            python-packaging
            python-requests
            python-schema
            python-tabulate
            python-typer))
    (home-page "https://github.com/pythonanywhere/helper_scripts/")
    (synopsis "PythonAnywhere helper tools for users")
    (description "PythonAnywhere provides a command-line interface and an
application programming interface that allows managing files Web apps, scheduled
tasks and students.  It includes single-command deployment for the Django Girls
tutorial.")
    (license license:expat)))

(define-public python-pythondialog
  (package
    (name "python-pythondialog")
    (version "3.4.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pythondialog" version))
              (sha256
               (base32
                "1728ghsran47jczn9bhlnkvk5bvqmmbihabgif5h705b84r1272c"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (add-after 'unpack 'patch-path
                    (lambda* (#:key inputs #:allow-other-keys)
                      (let* ((dialog (assoc-ref inputs "dialog")))
                        (substitute* "dialog.py"
                          (("os.getenv\\(\"PATH\", \":/bin:/usr/bin\"\\)") (string-append
                                                                            "os.getenv(\"PATH\")  + \":"
                                                                            dialog
                                                                            "/bin\"")))
                        #t))))
       #:tests? #f))
    (propagated-inputs (list dialog))
    (home-page "https://pythondialog.sourceforge.net/")
    (synopsis "Python interface to the UNIX dialog utility")
    (description
     "A Python wrapper for the dialog utility.  Its purpose is to
provide an easy to use, pythonic and comprehensive Python interface to dialog.
This allows one to make simple text-mode user interfaces on Unix-like systems")
    (license license:lgpl2.1)))

(define-public python-confection
  (package
    (name "python-confection")
    (version "0.1.5")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "confection" version))
              (sha256
               (base32
                "03hgb6601mx6iip4nr8i0is8x5vmh85z286j7j8lhkxxlqydswlf"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-pydantic-2 python-srsly))
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/explosion/confection")
    (synopsis "Config system for Python")
    (description "Confection is a lightweight library that offers a
configuration system letting you conveniently describe arbitrary trees of
objects.")
    (license license:expat)))

(define-public python-configobj
  (package
    (name "python-configobj")
    (version "5.0.6")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "configobj" version))
              (sha256
               (base32
                "00h9rcmws03xvdlfni11yb60bz3kxfvsj6dg6nrpzj71f03nbxd2"))
              ;; Patch setup.py so it looks for python-setuptools, which is
              ;; required to parse the keyword 'install_requires' in setup.py.
              (patches (search-patches "python-configobj-setuptools.patch"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-six))
    (synopsis "Config file reading, writing and validation")
    (description "ConfigObj is a simple but powerful config file reader and
writer: an ini file round tripper.  Its main feature is that it is very easy to
use, with a straightforward programmer’s interface and a simple syntax for
config files.")
    (home-page "https://github.com/DiffSK/configobj")
    (license license:bsd-3)))

(define-public python-omegaconf
  (package
    (name "python-omegaconf")
    (version "2.2.3")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/omry/omegaconf")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (modules '((guix build utils)))
              (snippet #~(begin
                           (delete-file-recursively "build_helpers/bin")
                           (substitute* "build_helpers/build_helpers.py"
                             (("java") "antlr4")
                             (("\"-jar\",") "")
                             (("str\\(build_dir / \"bin\" / \"antlr.*\"\\),") ""))))
              (sha256
               (base32
                "00rw1rkjycn0jdg3jmar6jdxb1pcb21jclm5g1921s9z8f5ii5dh"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (add-after 'unpack 'loosen-requirements
                 (lambda _
                   (substitute* "requirements/base.txt"
                     (("antlr4-python3-runtime==.*")
                      "antlr4-python3-runtime >=4.9\n"))
                   ;; Ignore deprecation warnings.
                   (substitute* "pyproject.toml"
                     (("-Werror") "")))))))
    (propagated-inputs (list java-antlr4-runtime-python
                             python-pydevd
                             python-pyyaml))
    (native-inputs (list icedtea antlr4 python-pytest python-pytest-mock
                         python-setuptools python-wheel))
    (home-page "https://github.com/omry/omegaconf")
    (synopsis "Flexible configuration system")
    (description "OmegaConf is a hierarchical configuration system and
supports merging configurations from multiple sources.  It provides a
consistent API regardless of how the configuration was created.")
    (license license:bsd-3)))

(define-public python-configargparse
  (package
    (name "python-configargparse")
    (version "1.7")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "ConfigArgParse" version))
              (sha256
               (base32
                "1l866g1dcf2ljf8fl7ggpxk1rggry0lya4d5b264gradi1qp81p7"))))
    (build-system pyproject-build-system)
    (propagated-inputs
     (list python-pyyaml))
    (native-inputs
     (list python-mock python-pytest python-setuptools python-wheel))
    (synopsis "Replacement for argparse")
    (description "A drop-in replacement for argparse that allows options to also
be set via config files and/or environment variables.")
    (home-page "https://github.com/bw2/ConfigArgParse")
    (license license:expat)))

(define-public python-connection-pool
  (package
    (name "python-connection-pool")
    (version "0.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "connection_pool" version))
       (sha256
        (base32 "1p6hfkcl4n3hhhcgjbaxn21i7b1yipag6j7dnilir4k5xxx9whmz"))))
    (build-system python-build-system)
    (home-page "https://github.com/zhouyl/ConnectionPool")
    (synopsis "Thread-safe connection pool")
    (description "This package provides a library implementing a thread-safe
connection pool.")
    (license license:expat)))

(define-public python-argparse-manpage
  (package
    (name "python-argparse-manpage")
    (version "4.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "argparse-manpage" version))
       (sha256
        (base32
         "1nq4sq1zk1xzdsqq61hd27jhj978ys136aba1zjg02x1g0c0cg11"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pip python-pytest python-setuptools python-tomli
           python-wheel))
    (home-page "https://github.com/praiskup/argparse-manpage")
    (synopsis "Build manual page from Python's ArgumentParser object")
    (description
     "This package provides tools to build manual pages from Python's
@code{ArgumentParser} object.")
    (license license:asl2.0)))

(define-public python-contextlib2
  (package
    (name "python-contextlib2")
    (version "0.6.0.post1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "contextlib2" version))
       (sha256
        (base32
         "0bhnr2ac7wy5l85ji909gyljyk85n92w8pdvslmrvc8qih4r1x01"))))
    (build-system python-build-system)
    (home-page "https://contextlib2.readthedocs.org/")
    (synopsis "Tools for decorators and context managers")
    (description "This module is primarily a backport of the Python
3.2 contextlib to earlier Python versions.  Like contextlib, it
provides utilities for common tasks involving decorators and context
managers.  It also contains additional features that are not part of
the standard library.")
    (license license:psfl)))

(define-public python-contexttimer
  (package
    (name "python-contexttimer")
    (version "0.3.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/brouberol/contexttimer")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "00a9h06a1wj66935n863qlk4jpl9gvdvzkkhl8xmgqwdkwv0js54"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-decorator python-unittest2))
    (native-inputs (list python-mock python-setuptools python-wheel))
    (home-page "https://github.com/brouberol/contexttimer")
    (synopsis "Timer as a context manager")
    (description
     "This package offers utilities to measure code block or function
execution time.")
    (license license:gpl3)))

(define-public python-texttable
  (package
    (name "python-texttable")
    (version "1.6.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "texttable" version))
       (sha256
        (base32
         "1sbn821394rix6xgj3zqk743pj6nqm1qz81zgis2bcpp2ng7pvj2"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests? (invoke "pytest" "-vv" "tests.py")))))))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/foutaise/texttable/")
    (synopsis "Python module for creating simple ASCII tables")
    (description "Texttable is a Python module for creating simple ASCII
tables.")
    (license license:expat)))

(define-public python-atomicwrites
  (package
    (name "python-atomicwrites")
    (version "1.4.0")
    (source (origin
             (method url-fetch)
             (uri (pypi-uri "atomicwrites" version))
             (sha256
              (base32
               "0yla2svfhfqrcj8qbyqzx7wi4jy0dwcxvlkg0k3zjd54s5m3jw5f"))))
    (build-system python-build-system)
    (arguments `(#:tests? #f))          ;avoid circular dependency with pytest
    (synopsis "Atomic file writes in Python")
    (description "Library for atomic file writes using platform dependent tools
for atomic file system operations.")
    (home-page "https://github.com/untitaker/python-atomicwrites")
    (license license:expat)))

(define-public python-qstylizer
  (package
    (name "python-qstylizer")
    (version "0.2.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/blambright/qstylizer")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0413msw23kv87fgs14ajp9wb2qxkcw6ydvwjzabz7xcp8iif9kr2"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'set-pbr-version
            (lambda _
              (setenv "PBR_VERSION" "3.0.1"))))))
    (native-inputs
     (list python-pbr
           python-pytest
           python-pytest-mock
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-inflection
           python-tinycss2))
    (home-page "https://github.com/blambright/qstylizer")
    (synopsis "Qt stylesheet generation utility for PyQt/PySide")
    (description "@code{qstylizer} is a Python package designed to help with
the construction of PyQt/PySide stylesheets.")
    (license license:expat)))

(define-public python-click-threading
  (package
    (name "python-click-threading")
    (version "0.5.0")
    (source (origin
             (method url-fetch)
             (uri (pypi-uri "click-threading" version))
             (sha256
              (base32
               "0f9lmxwcq0y9lb8w0whbni7gwy12gbv74h1igh85qn9aq0iydkxd"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-click))
    (synopsis "Utilities for multithreading in Click")
    (description "This package provides utilities for multithreading in Click
applications.")
    (home-page "https://github.com/click-contrib/click-threading")
    (license license:expat)))

(define-public python-click-log
  (package
    (name "python-click-log")
    (version "0.3.2")
    (source (origin
             (method url-fetch)
             (uri (pypi-uri "click-log" version))
             (sha256
              (base32
               "091i03bhxyzsdbc6kilxhivfda2f8ymz3b33xa6cj5kbzjiirz8n"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-click))
    (synopsis "Logging for click applications")
    (description "This package provides a Python library for logging Click
applications.")
    (home-page "https://github.com/click-contrib/click-log")
    (license license:expat)))

(define-public python-click-default-group
  (package
    (name "python-click-default-group")
    (version "1.2.4")
    (source
     (origin
       (method git-fetch)               ; no tests in PyPI release
       (uri (git-reference
             (url "https://github.com/click-contrib/click-default-group")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "06h12qwg0lhvxlgfm9768afibwp8j6r3r440v630a30bv0nkhngm"))))
    (build-system pyproject-build-system)
    (propagated-inputs
     (list python-click))
    (native-inputs
     (list python-flit-core python-pytest))
    (synopsis "Extends click.Group")
    (description "This package extends click.Group to invoke a command without
explicit subcommand name.")
    (home-page "https://github.com/click-contrib/click-default-group")
    (license license:bsd-3)))

(define-public python-structlog
  (package
    (name "python-structlog")
    (version "23.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "structlog" version))
        (sha256
         (base32
          "0swh5wxghpzdkncsl3zhiq5bblkj4i5r3g00lldw2qyiswfnh397"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list ;; For the build
           python-hatch-fancy-pypi-readme
           python-hatch-vcs
           python-hatchling
           ;; For the tests
           python-coverage
           python-freezegun
           python-pretend
           python-pytest
           python-pytest-asyncio
           python-simplejson
           python-twisted))
    (home-page "https://www.structlog.org/")
    (synopsis "Structured Logging for Python")
    (description "@code{structlog} changes logging in Python by adding structure
to your log entries.")
    (license (list license:asl2.0 license:expat))))

(define-public python-apipkg
  (package
    (name "python-apipkg")
    (version "1.5")
    (source (origin
             (method url-fetch)
             (uri (pypi-uri "apipkg" version))
             (sha256
              (base32
               "1xhak74yj3lqflvpijg15rnkklrigvsp5q7s4as4h6a157d8q8ip"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest python-setuptools-scm))
    (synopsis "Namespace control and lazy-import mechanism")
    (description "With apipkg you can control the exported namespace of a Python
package and greatly reduce the number of imports for your users.  It is a small
pure Python module that works on virtually all Python versions.")
    (home-page "https://github.com/pytest-dev/apipkg")
    (license license:expat)))

(define-public python-execnet
    (package
      (name "python-execnet")
      (version "2.1.1")
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/pytest-dev/execnet")
                      (commit (string-append "v" version))))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0xlfd0h9sjl0jpc2fc689a497chwbagali7qr364k75hdyax3jfq"))))
      (build-system pyproject-build-system)
      (arguments
       (list
        ;; ;; This test hasn't been updated for the latest Pytest yet:
        ;; #:test-flags #~(list "--ignore" "testing/test_rsync.py")
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'adjust-for-pytest-7.2+
              (lambda _
                ;; This test fails with an error because @py.test has been
                ;; deprecated for @pytest in recent Pytest.
                (substitute* "testing/test_rsync.py"
                  (("@py.test")
                   "@pytest"))))
            (add-before 'build 'pretend-version
              ;; The version string is usually derived via setuptools-scm, but
              ;; without the git metadata available this fails.
              (lambda _
                ;; hatch-vcs uses setuptools under the hood.
                (setenv "SETUPTOOLS_SCM_PRETEND_VERSION"
                        ;; Massage the version string to a PEP-0440 compatible
                        ;; one.
                        #$(car (string-split version #\-)))))
            (add-before 'check 'prepare-for-tests
              (lambda _
                ;; Unset PYTHONDONTWRITEBYTECODE to match the
                ;; expectations of a test in
                ;; 'testing/test_gateway.py'.
                (unsetenv "PYTHONDONTWRITEBYTECODE"))))))
      (native-inputs
       (list python-hatchling
             python-hatch-vcs
             python-pytest-bootstrap))
      (synopsis "Rapid multi-Python deployment")
      (description "Execnet provides a share-nothing model with
channel-send/receive communication for distributing execution across many
Python interpreters across version, platform and network barriers.  It has a
minimal and fast API targeting the following uses:
@enumerate
@item distribute tasks to (many) local or remote CPUs
@item write and deploy hybrid multi-process applications
@item write scripts to administer multiple environments
@end enumerate")
      (home-page "https://codespeak.net/execnet/")
      (license license:expat)))

(define-public python-icalendar
  (package
    (name "python-icalendar")
    (version "5.0.13")
    (source (origin
             (method url-fetch)
             (uri (pypi-uri "icalendar" version))
             (sha256
              (base32
               "01lp0advx60z8wgng8aga1p1668ydn1r6d9qm3d622yfikg9yycj"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (invoke "pytest" "-vv" "src/icalendar/tests")))))))
    (propagated-inputs
     (list python-dateutil python-pytz python-tzdata))
    (native-inputs
     (list python-pytest python-pytz python-setuptools python-wheel))
    (synopsis "Python library for parsing and generating iCalendar files")
    (description
     "@code{icalendar} is a Python library for parsing and generating iCalendar files.")
    (home-page "https://github.com/collective/icalendar")
    (license license:bsd-2)))

(define-public python-args
  (let ((commit "9460f1a35eb3055e9e4de1f0a6932e0883c72d65") (revision "0"))
    (package
      (name "python-args")
      (version (git-version "0.1.0" revision commit))
      (home-page "https://github.com/kennethreitz-archive/args")
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url home-page)
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1zfxpbp9vldqdrjmd0c6y3wisl35mx5v8zlyp3nhwpy1730wrc9j"))))
      (build-system python-build-system)
      (arguments
       `(#:phases (modify-phases %standard-phases
                    (add-after 'unpack 'patch-args.py
                      (lambda _
                        (substitute* "args.py"
                          (("basestring") "str"))))
                    (replace 'check
                      (lambda* (#:key tests? #:allow-other-keys)
                        (when tests?
                          (invoke "nosetests" "-v")))))))
      (native-inputs (list python-nose))
      (synopsis "Command-line argument parser")
      (description
       "This library provides a Python module to parse command-line arguments.")
      (license license:bsd-3))))

(define-public python-clint
  (package
    (name "python-clint")
    (version "0.5.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "clint" version))
              (sha256
               (base32
                "1an5lkkqk1zha47198p42ji3m94xmzx1a03dn7866m87n4r4q8h5"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _ (invoke "py.test" "-v"))))))
    (native-inputs
     (list python-pytest))
    (propagated-inputs
     (list python-args))
    (home-page "https://github.com/kennethreitz/clint")
    (synopsis "Command-line interface tools")
    (description
     "Clint is a Python module filled with a set of tools for developing
command-line applications, including tools for colored and indented
output, progress bar display, and pipes.")
    (license license:isc)))

(define-public python-rply
  (package
    (name "python-rply")
    (version "0.7.8")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "rply" version))
              (sha256
               (base32
                "1j81nddvnb145x4p81bnfpyai6g26i2dc1633ycsk025bb18m01a"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-appdirs))
    (home-page "https://github.com/alex/rply")
    (synopsis "Parser generator for Python")
    (description
     "This package provides a pure Python based parser generator, that also
works with RPython.  It is a more-or-less direct port of David Bazzley's PLY,
with a new public API, and RPython support.")
    (license license:bsd-3)))

(define-public python-hy
  (package
    (name "python-hy")
    (version "1.0.0")
    (source
     (origin
       (method git-fetch) ;no tests in PyPI release
       (uri (git-reference
             (url "https://github.com/hylang/hy")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1msv3027krv223a4dhx6kzp7r7l4q2qg8kq25j4dcf8k5xs73ax3"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; This test expects the hy executable to be called 'hy', but in Guix
      ;; it's .hy-real.
      #:test-flags #~(list "-k" "not test_sys_executable")))
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (propagated-inputs (list python-funcparserlib))
    (home-page "https://docs.hylang.org/en/stable/")
    (synopsis "Lisp frontend to Python")
    (description
     "Hy is a dialect of Lisp that's embedded in Python.  Since Hy transforms
its Lisp code into the Python Abstract Syntax Tree, you have the whole world of
Python at your fingertips, in Lisp form.")
    (license license:expat)))

(define-public python-hissp
  (package
    (name "python-hissp")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "hissp" version))
       (sha256
        (base32
         "0yns7f0q699zn2ziagyas2nkndl7mp1hhssv9x9mpl7jxj2p5myw"))))
    (build-system python-build-system)
    (home-page "https://github.com/gilch/hissp")
    (synopsis "It's Python with a Lissp")
    (description "Hissp is a modular Lisp implementation that compiles to a
functional subset of Python—Syntactic macro metaprogramming with full access
to the Python ecosystem.")
    (license license:asl2.0)))

(define-public python-promise
  (package
    (name "python-promise")
    (version "0.4.2")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "promise" version))
        (sha256
         (base32
          "1k19ms8l3d5jzjh557rgkxb5sg4mqgfc315rn4hx1z3n8qq6lr3h"))))
    (build-system python-build-system)
    ;; Tests wants python-futures, which is a python2 only program, and
    ;; can't be found by python-promise at test time.
    (arguments `(#:tests? #f))
    (home-page "https://github.com/syrusakbary/promise")
    (synopsis "Promises/A+ implementation for Python")
    (description
     "Promises/A+ implementation for Python")
    (license license:expat)))

(define-public python-progress
  (package
    (name "python-progress")
    (version "1.6")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "progress" version))
       (sha256
        (base32 "1k9lpb7lqr6mywpnqcz71y6qny54xlgprdp327za2gy0nnc6xj69"))))
    (build-system python-build-system)
    (home-page "http://github.com/verigak/progress/")
    (synopsis "Progress reporting bars for Python")
    (description "This Python package provides progress reporting for visual
of progress of long running operations.  There are multiple choices of
progress bars and spinners, with customizable options, such as width, fill
character, and suffix.")
    (license license:isc)))

(define-public python-progressbar2
  (package
    (name "python-progressbar2")
    (version "4.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "progressbar2" version))
       (sha256
        (base32 "1yw8j3sz9y3nw2x1ffiqqzml8l9vb0kixxnsjkmk3vc691icnqk6"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags #~(list "--pyargs" "progressbar" "tests")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-pytest-config
            (lambda _
              ;; Drop test coverage requirements.
              (substitute* "pytest.ini"
                ((".*-cov.*") "")))))))
    (native-inputs
     (list python-dill
           python-pytest
           python-freezegun
           python-setuptools
           python-setuptools-scm
           python-wheel))
    (propagated-inputs
     (list python-utils))
    (home-page "https://github.com/WoLpH/python-progressbar")
    (synopsis "Text progress bar library for Python")
    (description
     "This package provides a Python progressbar library to provide
visual (yet text based) progress to long running operations.")
    (license license:bsd-3)))

(define-public python-progressbar33
  (package
    (name "python-progressbar33")
    (version "2.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "progressbar33" version))
       (sha256
        (base32
         "1zvf6zs5hzrc03p9nfs4p16vhilqikycvv1yk0pxn8s07fdhvzji"))))
    (build-system python-build-system)
    (home-page "https://github.com/germangh/python-progressbar")
    (synopsis "Text progress bar library for Python")
    (description
     "This package provides a text progress bar library for Python.  This
version only differs from the original @code{progressbar} package in that it
uses relative package imports instead of absolute imports, which is necessary
for the module to work under Python 3.3.")
    ;; Either or both of these licenses may be selected.
    (license (list license:lgpl2.1+ license:bsd-3))))

(define-public python-colorama
  (package
   (name "python-colorama")
   (version "0.4.6")
   (source
    (origin
     (method url-fetch)
     (uri (pypi-uri "colorama" version))
     (sha256
      (base32 "0i3fpq0w5mbfdpy3z9p5raw4fg17jxr6jwh5l8qhavpdnxf5ys88"))))
   (build-system pyproject-build-system)
   (native-inputs (list python-hatchling python-pytest))
   (home-page "https://pypi.org/project/colorama/")
   (synopsis "Colored terminal text rendering for Python")
   (description "Colorama is a Python library for rendering colored terminal
text.")
   (license license:bsd-3)))

(define-public python-monthdelta
  (package
    (name "python-monthdelta")
    (version "0.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "MonthDelta" version))
       (sha256
        (base32 "0iwcsk7ryjw5h1wp10ykwd01f3am8gdlga6461q1v1njsk0rxh41"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-setuptools python-wheel))
    (home-page "http://packages.python.org/MonthDelta")
    (synopsis "Date computations with months")
    (description
     "MonthDelta provides functionality to do date computations with months.")
    (license license:expat)))

(define-public python-moto
  (package
    (name "python-moto")
    (version "5.0.25")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "moto" version))
              (sha256
               (base32 "1cp61k745dxyzck543lamh8mnwwxazsgzqascg4nanpcihaqpsny"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      '(list "-m" "not network and not requires_docker"
             ;; This needs pycognito.
             "--ignore-glob=tests/test_cognitoidp/*"
             ;; This needs Internet access.
             "--ignore=tests/test_core/test_request_passthrough.py"
             "-k"
             (string-append
              ;; XXX: This test is timing sensitive and may
              ;; fail non-deterministically.
              "not test_cancel_pending_job"

              ;; The error message is more detailed than expected.
              " and not test_list_queue_tags_errors"

              ;; Unknown failure: invalid length for parameter IpAdresses.
              " and not test_route53resolver_bad_create_endpoint_subnets"
              " and not test_route53resolver_invalid_create_endpoint_args"

              ;; These tests require Docker.
              " and not test_terminate_job"
              " and not test_invoke_function_from_sqs_exception"
              " and not test_create_custom_lambda_resource__verify_cfnresponse_failed"
              " and not test_lambda_function"
              " and not test_invoke_local_lambda_layers"

              ;; These tests also require the network.
              " and not test_s3_server_post_cors_multiple_origins"
              " and not test_put_record_batch_http_destination"
              " and not test_put_record_http_destination"
              " and not test_with_custom_request_header"
              " and not test_dependencies"
              " and not test_cancel_running_job"
              " and not test_container_overrides"))
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'compatibility
           (lambda _
             ;; pyparsing 3.0.6 does not support the "min" argument for
             ;; DelimitedList.
             (substitute* "moto/glue/utils.py"
               (("DelimitedList\\(literal, min=1\\)")
                "DelimitedList(literal)"))))
         (add-after 'unpack 'patch-hardcoded-executable-names
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((bash-exec (search-input-file inputs "/bin/sh")))
               (substitute* "moto/batch/models.py"
                 (("/bin/sh") bash-exec))
               (substitute* (find-files "tests" "\\.py$")
                 (("#!/bin/bash") (string-append "#!" bash-exec)))))))))
    (native-inputs
     (list python-flask
           python-flask-cors
           python-freezegun
           python-pytest
           python-setuptools
           python-wheel))
    (inputs
     (list bash-minimal))
    (propagated-inputs
     (list java-antlr4-runtime-python
           python-aws-xray-sdk
           python-boto3
           python-botocore
           python-cfn-lint
           python-cryptography
           python-dateutil
           python-graphql-core
           python-jinja2
           python-joserfc
           python-jsonpath-ng
           python-multipart
           python-openapi-spec-validator
           python-py-partiql-parser
           python-requests
           python-responses
           python-werkzeug
           python-xmltodict))
    (home-page "https://github.com/spulec/moto")
    (synopsis "Mock out the boto library")
    (description
     "@code{moto} is a library designed to easily mock out the
@code{boto} library.")
    (license license:asl2.0)))

(define-public python-rsa
  (package
   (name "python-rsa")
   (version "3.4.2")
   (source
    (origin
     (method url-fetch)
     (uri (pypi-uri "rsa" version))
     (sha256
      (base32
       "1dcxvszbikgzh99ybdc7jq0zb9wspy2ds8z9mjsqiyv3q884xpr5"))))
   (build-system python-build-system)
   (propagated-inputs
    (list python-pyasn1))
   (synopsis "Pure-Python RSA implementation")
   (description "Python-RSA is a pure-Python RSA implementation.  It supports
encryption and decryption, signing and verifying signatures, and key
generation according to PKCS#1 version 1.5.  It can be used as a Python
library as well as on the command line.")
   (home-page "https://stuvel.eu/rsa")
   (license license:asl2.0)))

(define-public python-plumbum
  (package
    (name "python-plumbum")
    (version "1.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "plumbum" version))
       (sha256
        (base32 "1kidj821k79dw064rlxh84xamb9h79ychg3pgj81jlvm5hs48xri"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))                    ;no tests
    (native-inputs
     ;; XXX: Not actually used since there are no tests but required for
     ;; build.
     (list python-pytest))
    (home-page "https://plumbum.readthedocs.io")
    (synopsis "Python shell combinators library")
    (description
     "Plumbum is a library of tools for replacing shell scripts with Python
code.")
    (license license:expat)))

(define-public python-deprecation
  (package
    (name "python-deprecation")
    (version "2.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "deprecation" version))
       (sha256
        (base32
         "1zqqjlgmhgkpzg9ss5ki8wamxl83xn51fs6gn2a8cxsx9vkbvcvj"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-packaging))
    (native-inputs
     (list python-unittest2))
    (home-page "https://deprecation.readthedocs.io/")
    (synopsis "Python library to handle automated deprecations")
    (description
     "This is a library that enables automated deprecations.  It offers the
@code{deprecated()} decorator to wrap functions, providing proper warnings
both in documentation and via Python’s warnings system, as well as the
@code{deprecation.fail_if_not_removed()} decorator for test methods to ensure
that deprecated code is eventually removed.")
    (license license:asl2.0)))

(define-public python-jmespath
  (package
   (name "python-jmespath")
   (version "1.0.1")
   (source
    (origin
     (method url-fetch)
     (uri (pypi-uri "jmespath" version))
     (sha256
      (base32
       "1gpdc1f0q5c9scmbw1l9g40jjfk3pxwg91ayvn7xbvvddlh1n9lh"))))
   (build-system python-build-system)
   (native-inputs
    (list python-pytest))
   (synopsis "JSON Matching Expressions")
   (description "JMESPath (pronounced “james path”) is a Python library that
allows one to declaratively specify how to extract elements from a JSON
document.")
   (home-page "https://github.com/jmespath/jmespath.py")
   (license license:expat)))

(define-public python-symengine
  (package
    (name "python-symengine")
    (version "0.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "symengine" version))
       (sha256
        (base32 "0k61j333kpxf23c92hnc0svjywylffx72arcf1wjbwgbjy4a10xb"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (if tests?
                  ;; Run tests against installed package.
                  (with-directory-excursion "/tmp"
                    (invoke "nosetests" "-v" "symengine.tests"))
                  (format #t "test suite not run~%")))))))
    (native-inputs
     (list cmake python-cython-3 python-nose))
    (inputs
     (list symengine))
    (home-page "https://github.com/symengine/symengine.py")
    (synopsis "Python library providing wrappers to SymEngine")
    (description
     "This library provides a Python wrapper to SymEngine, a fast C++ symbolic
manipulation library.")
    (license license:expat)))

(define-public python-uncertainties
  (package
    (name "python-uncertainties")
    (version "3.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "uncertainties" version))
       (sha256
        (base32
         "00z9xl40czmqk0vmxjvmjvwb41r893l4dad7nj1nh6blw3kw28li"))))
    (build-system python-build-system)
    ;; While there are test files, there is no "tests" directory, so the tests
    ;; fail.
    (arguments '(#:tests? #false))
    (propagated-inputs
     (list python-future))
    (native-inputs
     (list python-nose python-numpy))
    (home-page "https://uncertainties-python-package.readthedocs.io/")
    (synopsis "Calculations with uncertainties")
    (description
     "The uncertainties package transparently handles calculations with
numbers with uncertainties.  It can also yield the derivatives of any
expression.")
    (license license:bsd-3)))

(define-public python-unicodedata2
  (package
    (name "python-unicodedata2")
    (version "15.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "unicodedata2" version))
       (sha256
        (base32 "0bcgls7m2zndpd8whgznnd5908jbsa50si2bh88wsn0agcznhv7d"))))
    (build-system python-build-system)
    (home-page "https://github.com/fonttools/unicodedata2")
    (synopsis "Python unicodedata backport")
    (description "This package corresponds to the latest @code{unicodedata}
standard Python module.")
    (license license:asl2.0)))

(define-public python-asteval
  (package
    (name "python-asteval")
    (version "0.9.23")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "asteval" version))
       (sha256
        (base32
         "0f54sd4w1a72ij1bcxs2x7dk9xf8bzclawijf1z18bqx9f96l2gm"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/newville/asteval")
    (synopsis "Minimalistic evaluator of Python expressions")
    (description
     "This package provides a minimalistic evaluator of Python expression
using the @code{ast} module")
    (license license:expat)))

(define-public python-lmfit
  (package
    (name "python-lmfit")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "lmfit" version))
       (sha256
        (base32
         "0iab33jjb60f8kn0k0cqb0vjp1mdskks2n3kpn97zkw5cvjhq2b7"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-asteval python-numpy python-scipy python-uncertainties))
    (native-inputs
     (list python-pytest))
    (home-page "https://lmfit.github.io/lmfit-py/")
    (synopsis "Least-Squares minimization with bounds and constraints")
    (description
     "Lmfit provides a high-level interface to non-linear optimization and
curve fitting problems for Python.  It builds on and extends many of the
optimization methods of @code{scipy.optimize}.  Initially inspired by (and
named for) extending the Levenberg-Marquardt method from
@code{scipy.optimize.leastsq}, lmfit now provides a number of useful
enhancements to optimization and data fitting problems.")
    (license license:bsd-3)))

(define-public python-bokeh
  (package
    (name "python-bokeh")
    (version "2.4.3")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "bokeh" version))
              (sha256
               (base32
                "00sbhya9vfdv3yi07j6mxwx1x1h9497nhd3smdjrcdxgc48q0czg"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      '(list
        ;; These require selenium.
        "--ignore=tests/unit/bokeh/io/test_export.py"
        "--ignore=tests/unit/bokeh/io/test_webdriver.py"
        "--ignore=tests/unit/bokeh/embed/test_standalone.py"

        ;; Doesn't find ManagedServerLoop fixture
        "--ignore=tests/unit/bokeh/test_client_server.py"

        ;; This fails because of the Guix wrapper around pytest
        "--ignore=tests/unit/bokeh/io/test_util__io.py"

        ;; Fixture ipython not found.
        "--ignore=tests/unit/bokeh/application/handlers/test_notebook__handlers.py"
        "--ignore=tests/unit/bokeh/command/subcommands/test_info.py"

        ;; pd fixture not found.
        "--ignore=tests/unit/bokeh/models/test_mappers.py"
        "--ignore=tests/unit/bokeh/models/util/test_structure.py"
        "--ignore=tests/unit/bokeh/plotting/test__plot.py"
        "--ignore=tests/unit/bokeh/plotting/test__graph.py"
        "--ignore=tests/unit/bokeh/plotting/test_figure.py"
        "--ignore=tests/unit/bokeh/core/test_json_encoder.py"
        "--ignore=tests/unit/bokeh/core/property/test_bases.py"
        "--ignore=tests/unit/bokeh/core/property/test_container.py"
        "--ignore=tests/unit/bokeh/core/property/test_dataspec.py"
        "--ignore=tests/unit/bokeh/core/property/test_datetime.py"
        "--ignore=tests/unit/bokeh/core/property/test_pandas.py"

        ;; nx fixture not found.
        "--ignore=tests/unit/bokeh/plotting/test_graph.py"
        "--ignore=tests/unit/bokeh/models/test_graphs.py"
        "--ignore=tests/unit/bokeh/io/test_showing.py"
        "--ignore=tests/unit/bokeh/document/test_events__document.py"

        ;; These tests need external sample data
        "--ignore-glob=tests/unit/bokeh/sampledata/*"

        ;; Attempts to install something via npm.
        "--ignore=tests/unit/bokeh/test_ext.py"

        ;; More failures due to set up problems.
        "--ignore=tests/unit/bokeh/server/test_server__server.py"
        "--ignore=tests/unit/bokeh/server/test_tornado__server.py"
        "--ignore=tests/unit/bokeh/util/test_serialization.py"
        "--ignore=tests/unit/bokeh/util/test_hex.py"
        "--ignore=tests/unit/bokeh/models/test_sources.py"
        "--ignore=tests/unit/bokeh/embed/test_bundle.py"

        "-k"
        (string-append
         ;; Fails with: 'called_once_with' is not a valid assertion. [...]
         ;; Did you mean: 'assert_called_once_with'?
         "not test_set_from_json"

         ;; XXX: This one test transforms a gif of a red box.  It transforms
         ;; it all right but the base64 doesn't look as expected, probably
         ;; because of a change in pillow.
         " and not test_transform_PIL"))))
    (propagated-inputs
     (list node-lts
           python-jinja2
           python-numpy
           python-packaging
           python-pillow
           python-pyyaml
           python-tornado-6
           python-typing-extensions))
    (native-inputs
     (list python-beautifulsoup4
           python-dateutil
           python-flaky
           python-mock
           python-nbconvert
           python-pandas
           python-pytest
           python-pytz
           python-requests
           python-setuptools
           python-wheel))
    (home-page "https://github.com/bokeh/bokeh")
    (synopsis "Interactive plots and applications in the browser from Python")
    (description
     "This package provides tools for interactive plots and applications in the
browser from Python.")
    (license license:bsd-3)))

(define-public python-botocore
  ;; Note: When updating botocore, also make sure that boto3 and awscli
  ;; are compatible.
  (package
    (name "python-botocore")
    (version "1.35.91")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "botocore" version))
       (sha256
        (base32
         "0822q7w802vwngsxkfwjrbs4zc21avs1hsai5i6zy7vhaicrq2vv"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "--numprocesses" (number->string (min (parallel-job-count) 8))
              ;; It strugles to find 'botocore'.
              "--ignore" "tests/functional/leak/test_resource_leaks.py"
              ;; Tests require networking.
              "--ignore" "tests/integration")))
    (native-inputs
     (list python-jsonschema
           python-pytest
           python-pytest-xdist
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-dateutil
           python-jmespath
           python-urllib3))
    (home-page "https://github.com/boto/botocore")
    (synopsis "Low-level interface to AWS")
    (description
     "Botocore is a Python library that provides a low-level interface to the
Amazon Web Services (AWS) API.")
    (license license:asl2.0)))

(define-public python-boto3
  (package
    (name "python-boto3")
    (version "1.35.59")
    (source
     (origin
       (method git-fetch)               ; no tests in PyPI release
       (uri (git-reference
             (url "https://github.com/boto/boto3")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "10bdzdaw7qg2m5n5ivb2zzsdl7wgjmz05xyxajd4cmk629ick95m"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "--numprocesses" (number->string (parallel-job-count))
              ;; Integration tests are trying to connect to AWS.
              "--ignore" "tests/integration")))
    (native-inputs
     (list python-mock
           python-pytest
           python-pytest-xdist
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-botocore
           python-jmespath
           python-s3transfer))
    (home-page "https://github.com/boto/boto3")
    (synopsis "AWS SDK for Python")
    (description
     "Boto3 is a Python library for writing programs that interact with
@acronym{AWS,Amazon Web Services}.")
    (license license:asl2.0)))

(define-public python-pyfiglet
  (package
    (name "python-pyfiglet")
    (version "0.8.post1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyfiglet" version))
       (sha256
        (base32
         "0f9n2076ga2ccsg174k2d7n0z4d44ml96yzc72s6g4nhalbk5hn6"))))
    (build-system python-build-system)
    (home-page "https://github.com/pwaller/pyfiglet")
    (synopsis "Draw ASCII art big letters in Python")
    (description "This module lets you draw large letter from ordinary characters
in pure Python.")
    (license license:expat)))

(define-public python-xdg
  (package
    (name "python-xdg")
    (version "6.0.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "xdg" version))
              (sha256
               (base32
                "14hwk9j5zjc8rvirw95mrb07zdnpjaxjx2mj3rnq8pnlyaa809r4"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #f)) ; No tests in PyPi tarball.
    (native-inputs
     (list python-poetry-core))
    (home-page "https://github.com/srstevenson/xdg-base-dirs")
    (synopsis "Variables defined by the XDG Base Directory Specification")
    (description "xdg-base-dirs is a Python module that provides functions to
return paths to the directories defined by the XDG Base Directory
Specification, to save you from duplicating the same snippet of logic in every
Python utility you write that deals with user cache, configuration, or data
files.")
    (license license:isc)))

(define-public python-xdo
  (package
    (name "python-xdo")
    (version "0.3")
    (source (origin
              (method url-fetch)
              (uri (string-append
                    "http://http.debian.net/debian/pool/main/p/python-xdo/"
                    "python-xdo_" version ".orig.tar.gz"))
              (sha256
               (base32
                "1vqh1n5yy5dhnq312kwrl90fnck4v26is3lq3lxdvcn60vv19da0"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-before 'install 'patch-libxdo-path
           ;; Hardcode the path of dynamically loaded libxdo library.
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((libxdo (string-append
                            (assoc-ref inputs "xdotool")
                            "/lib/libxdo.so"))
                   (libc (string-append
                          (assoc-ref inputs "libc")
                          "/lib/libc.so.6")))
               (substitute* "xdo/_xdo.py"
                 (("find_library\\(\"xdo\"\\)")
                  (simple-format #f "\"~a\"" libxdo))
                 (("ctypes\\.util\\.find_library\\('libc'\\)")
                  (simple-format #f "\"~a\"" libc)))
               #t))))
       #:tests? #f))  ; no tests provided
    (propagated-inputs
     (list python-six))
    (inputs
     `(("xdotool" ,xdotool)
       ("libX11" ,libx11)))
    (home-page "https://tracker.debian.org/pkg/python-xdo")
    (synopsis "Python library for simulating X11 keyboard/mouse input")
    (description "Provides bindings to libxdo for manipulating X11 via simulated
input.  (Note that this is mostly a legacy library; you may wish to look at
python-xdo for newer bindings.)")
    (license license:bsd-3)))

(define-public python-xdoctest
  (package
    (name "python-xdoctest")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "xdoctest" version))
       (sha256
        (base32 "0qsqxp9bpjzg8kb4k8n3sppzbzdr6l6n0vkm7z9qir4ii5nwmkyq"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'pre-check
            (lambda _
              ;; A writable HOME is needed by the 'import_module_from_path'
              ;; test.
              (setenv "HOME" "/tmp"))))))
    (native-inputs (list cmake-minimal
                         ninja
                         pybind11
                         python-pytest
                         python-pytest-cov
                         python-scikit-build
                         python-setuptools
                         python-wheel))
    (home-page "https://github.com/Erotemic/xdoctest")
    (synopsis "Rewrite of the Python builtin doctest module")
    (description "This package provides a rewrite of the builtin doctest
module which leverages the Python @acronym{AST, Abstract Syntax Tree} instead
of @acronym{REGEXPs, regular expressions}.")
    (license license:asl2.0)))

(define-public python-mako
  (package
    (name "python-mako")
    (version "1.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "Mako" version))
       (sha256
        (base32
         "0gqnv9py1dqp01jmf5zxp0vj2dbhq1l9zy55fai319iv6sdqc91p"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (if tests?
                          (invoke "pytest" "-vv")
                          (format #t "test suite not run~%"))
                      #t)))))
    (propagated-inputs
     (list python-markupsafe))
    (native-inputs
     (list python-mock python-pytest))
    (home-page "https://www.makotemplates.org/")
    (synopsis "Templating language for Python")
    (description "Mako is a templating language for Python that compiles
templates into Python modules.")
    (license license:expat)))

(define-public python-waitress
  (package
    (name "python-waitress")
    (version "3.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "waitress" version))
       (sha256
        (base32
         "07y3xyx2006f2ni5d55byh3y7w4kcg9xww7vmfjasi0cmzralak8"))))
    (build-system pyproject-build-system)
    (arguments
     ;; https://github.com/Pylons/waitress/issues/443
     (list #:test-flags #~(list "-k" "not test_service_port")))
    (native-inputs
     (list python-coverage python-pytest python-pytest-cov
           python-setuptools python-wheel))
    (home-page "https://github.com/Pylons/waitress")
    (synopsis "Waitress WSGI server")
    (description
     "Waitress is meant to be a production-quality pure-Python WSGI server
with very acceptable performance.")
    (license license:zpl2.1)))

(define-public python-whatthepatch
  (package
    (name "python-whatthepatch")
    (version "1.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "whatthepatch" version))
       (sha256
        (base32 "024grf30vkpcfr3bq822zv3slhx12ifm51rmfv1inn0j50blqdvz"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/cscorley/whatthepatch")
    (synopsis "Patch parsing and application library")
    (description
     "This package provides a patch parsing and application library.")
    (license license:expat)))

(define-public python-whichcraft
  (package
    (name "python-whichcraft")
    (version "0.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "whichcraft" version))
       (sha256
        (base32
         "11yfkzyplizdgndy34vyd5qlmr1n5mxis3a3svxmx8fnccdvknxc"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/pydanny/whichcraft")
    (synopsis "Cross-platform cross-python shutil.which functionality")
    (description
     "This package provides a shim of the shutil.which function that's
designed to work across multiple versions of Python.")
    (license license:bsd-3)))

(define-public python-cookiecutter
  (package
    (name "python-cookiecutter")
    (version "2.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "cookiecutter" version))
       (sha256
        (base32 "0762882zrvf3sslr9r7v8wkdwjckhm2clj4d831gvx54kqbgh8fv"))))
    (build-system python-build-system)
    (arguments
     (list
      #:phases #~(modify-phases %standard-phases
                   (add-before 'check 'pre-check
                     (lambda _
                       ;; test_get_user_config.py requires a writable home
                       ;; directory.
                       (setenv "HOME"
                               (getcwd))
                       ;; test_hooks.py dynamically creates shell scripts
                       ;; with a /bin/bash shebang. We have to patch these.
                       (substitute* "tests/test_hooks.py"
                         (("/bin/bash")
                          (string-append #$(this-package-native-input
                                            "bash-minimal") "/bin/bash")))))
                   (replace 'check
                     (lambda* (#:key tests? #:allow-other-keys)
                       (when tests?
                         (invoke "pytest")))))))
    (native-inputs (list bash-minimal
                         git
                         python-freezegun
                         python-pytest
                         python-pytest-cov
                         python-pytest-mock))
    (propagated-inputs (list python-arrow
                             python-binaryornot
                             python-click
                             python-jinja2
                             python-pyyaml
                             python-requests
                             python-rich
                             python-slugify))
    (home-page "https://github.com/cookiecutter/cookiecutter")
    (synopsis
     "Command-line utility that creates projects from project templates")
    (description
     "This package provides a command-line utility that creates projects from
project templates, e.g. creating a Python package project from a Python package
project template.")
    (license license:bsd-3)))

(define-public python-pyquery
  (package
    (name "python-pyquery")
    (version "1.2.17")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyquery" version))
       (sha256
        (base32
         "1xia20wm0vx5dk85kcwgh13bylz8qh47ffjxssd2586r60xi783a"))))
    (build-system python-build-system)
    (native-inputs
     (list python-webob python-webtest))
    (propagated-inputs
     (list python-lxml python-cssselect))
    (home-page "https://github.com/gawel/pyquery")
    (synopsis "Make jQuery-like queries on xml documents")
    (description "pyquery allows you to make jQuery queries on xml documents.
The API is as much as possible the similar to jQuery.  pyquery uses lxml for
fast xml and html manipulation.")
    (license license:bsd-3)))

(define-public python-anyjson
  (package
    (name "python-anyjson")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "anyjson" version))
       (sha256
        (base32
         "1fjph4alvcscsl5d4b6qpv1yh31jy05jxi1l0xff7lws7j32v09p"))))
    (build-system python-build-system)
    (arguments
     `(;; We could possibly get tests working, but on Python 3 it's not so easy.
       ;; Very strangely, 2to3 is run *during setup.py install* (or bdist, or
       ;; whatever) so this transformation needs to be done before the tests
       ;; can be run.  Maybe we could add a build step to transform beforehand
       ;; but it could be annoying/difficult.
       #:tests? #f))
    (native-inputs (list python-setuptools-57)) ;for use_2to3 support
    (home-page "https://bitbucket.org/runeh/anyjson/")
    (synopsis
     "Wraps best available JSON implementation in a common interface")
    (description
     "Anyjson loads whichever is the fastest JSON module installed
and provides a uniform API regardless of which JSON implementation is used.")
    (license license:bsd-3)))

(define-public python-amqp
  (package
    (name "python-amqp")
    (version "5.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "amqp" version))
       (sha256
        (base32 "1qmmffiy48nady7is8529vxcyqbq88v5zgawqr3fk4q8rkz166rc"))))
    (build-system pyproject-build-system)
    (arguments
     (list  ; Integration tests require network connectivity.
      #:test-flags '(list "--ignore=t/integration/test_rmq.py")))
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (propagated-inputs (list python-vine))
    (home-page "https://github.com/celery/py-amqp")
    (synopsis "Low-level AMQP client for Python (fork of amqplib)")
    (description
     "This is a fork of amqplib which was originally written by Barry Pederson.
It is maintained by the Celery project, and used by kombu as a pure python
alternative when librabbitmq is not available.")
    (license license:lgpl2.1+)))

(define-public python-benchmark-4dn
  (package
    (name "python-benchmark-4dn")
    (version "0.5.24")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "benchmark_4dn" version))
              (sha256
               (base32
                "1cjin99p8mrh4nkbr4hsdfks9c22dfw3gk5ad80b4rxngs8mwj0s"))))
    (properties '(("upstream-name" . "benchmark_4dn")))
    (build-system pyproject-build-system)
    ;; There are none.
    (arguments (list #:tests? #false))
    (native-inputs
     (list python-poetry-core))
    (home-page "https://github.com/SooLee/Benchmark/")
    (synopsis "Benchmark functions for CWL workflows")
    (description
     "This package provides benchmark functions that return total space, memory,
CPUs required per given input size, and parameters for CWL workflows.")
    (license license:expat)))

(define-public python-beniget
  (package
    (name "python-beniget")
    (version "0.4.2.post1")
    (home-page "https://github.com/serge-sans-paille/beniget")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "beniget" version))
       (sha256
        (base32 "1bjjl12pqbz4amnn8wvcpd4zjrx6cpw04s586gn18zjywqvqa9d0"))))
    (build-system pyproject-build-system)
    (propagated-inputs
     (list python-gast))
    (native-inputs (list python-setuptools python-wheel))
    (synopsis "Extract semantic information about static Python code")
    (description
     "Beniget is a collection of analyzers for Python @acronym{AST,
Abstract Syntax Tree}.  It is a building block for writing a static analyzer
or compiler for Python.")
    (license license:bsd-3)))

(define-public python-txamqp
  (package
    (name "python-txamqp")
    (version "0.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "txAMQP" version))
       (sha256
        (base32
         "0jd9864k3csc06kipiwzjlk9mq4054s8kzk5q1cfnxj8572s4iv4"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-six python-twisted))
    (home-page "https://github.com/txamqp/txamqp")
    (synopsis "Communicate with AMQP peers and brokers using Twisted")
    (description
     "This package provides a Python library for communicating with AMQP peers
and brokers using the asynchronous networking framework Twisted.  It contains
all the necessary code to connect, send and receive messages to/from an
AMQP-compliant peer or broker (Qpid, OpenAMQ, RabbitMQ) using Twisted.  It
also includes support for using Thrift RPC over AMQP in Twisted
applications.")
    (license license:asl2.0)))

(define-public python-kombu
  (package
    (name "python-kombu")
    (version "5.3.7")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "kombu" version))
       (sha256
        (base32 "1gwp3b7w7jhsas40655pa9nlblm12irjapfkx0flmhamlgclq701"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:test-flags
           ;; TODO: Package azure-identity (required for this file)
           #~(list "--ignore" "t/unit/transport/test_azurestoragequeues.py")))
    (native-inputs
     (list python-botocore
           python-case
           python-pyro4
           python-pytest
           python-pytest-sugar
           python-setuptools
           python-tzdata
           python-wheel))
    (propagated-inputs
     (list python-amqp python-typing-extensions python-vine))
    (home-page "https://kombu.readthedocs.io")
    (synopsis "Message passing library for Python")
    (description "The aim of Kombu is to make messaging in Python as easy as
possible by providing an idiomatic high-level interface for the AMQ protocol,
and also provide proven and tested solutions to common messaging problems.
AMQP is the Advanced Message Queuing Protocol, an open standard protocol for
message orientation, queuing, routing, reliability and security, for which the
RabbitMQ messaging server is the most popular implementation.")
    (license license:bsd-3)))

(define-public python-billiard
  (package
    (name "python-billiard")
    (version "4.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "billiard" version))
       (sha256
        (base32 "0b2svqx81511m0k2swjkybcx69f541dzd4rgfdxa2ni7rf232g4s"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:phases #~(modify-phases %standard-phases
                        (add-after 'unpack 'remove-win-files
                          (lambda _
                            (for-each delete-file-recursively
                                      '("billiard/popen_spawn_win32.py"
                                        "billiard/_win.py")))))))
    (native-inputs
     (list python-case python-psutil python-pytest python-setuptools
           python-wheel))
    (home-page "https://github.com/celery/billiard")
    (synopsis "Python multiprocessing fork with improvements and bugfixes")
    (description
     "Billiard is a fork of the Python 2.7 multiprocessing package.  The
multiprocessing package itself is a renamed and updated version of R Oudkerk's
pyprocessing package.  This standalone variant is intended to be compatible with
Python 2.4 and 2.5, and will draw its fixes/improvements from python-trunk.")
    (license license:bsd-3)))

(define-public python-celery
  (package
    (name "python-celery")
    (version "5.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "celery" version))
       (sha256
        (base32 "01p7lyydhqk7fna5zn49qxj3yk0xah63725dmkajjc4d1qa1jjjh"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; The MongoDB backend test appears to expect an older
      ;; version of MongoDB which provided its own bson
      ;; module, fails with " AttributeError: module 'bson'
      ;; has no attribute 'encode'".
      #:test-flags #~(list "--ignore" "t/unit/backends/test_mongodb.py"
                           ;; AssertionError.
                           "-k" "not test_check_privileges_no_fchown")
      #:phases #~(modify-phases %standard-phases
                   ;; Celery requires tzdata >= 2022.7, we have 2022.1.
                   (add-after 'unpack 'relax-requirements
                     (lambda _
                       (substitute* "requirements/default.txt"
                         (("tzdata.*")
                          "tzdata\n")))))))
    (native-inputs
     (list python-case
           python-dnspython
           python-flaky
           python-google-cloud-storage
           python-iniconfig
           python-moto
           python-msgpack
           python-pytest                ;for pytest-subtests
           python-pytest-celery
           python-pytest-click
           python-pytest-subtests
           python-pytest-timeout
           python-toml
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-billiard
           python-click
           python-click-didyoumean
           python-click-plugins
           python-click-repl
           python-kombu
           python-tzdata
           python-vine))
    (home-page "https://celeryproject.org")
    (synopsis "Distributed Task Queue")
    (description "Celery is an asynchronous task queue/job queue based on
distributed message passing.  It is focused on real-time operation, but
supports scheduling as well.  The execution units, called tasks, are executed
concurrently on a single or more worker servers using multiprocessing,
Eventlet, or gevent.  Tasks can execute asynchronously (in the background) or
synchronously (wait until ready).")
    (license license:bsd-3)))

(define-public python-cesium
  (package
    (name "python-cesium")
    (version "0.12.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "cesium" version))
              (sha256
               (base32
                "0jr0ycqz9ns6mcskm4sxx92k40fj3v0x9knjaw5ac9f3mpqxsfbv"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          ;; The installed test files contain the /gnu/store location, not the
          ;; location of the discovered test files from the build directory.
          ;; The test framework doesn't like this.  The easiest way around
          ;; this mismatch is to jump to the output directory.
          (add-before 'check 'check-chdir
            (lambda _ (chdir #$output))))))
    (propagated-inputs
     (list python-click ;XXX required by python-dask
           python-cloudpickle
           python-dask
           python-gatspy
           python-joblib
           python-numpy
           python-pandas
           python-scikit-learn
           python-scipy
           python-toolz))
    (native-inputs (list python-cython python-pytest python-setuptools-scm
                         python-setuptools python-wheel))
    (home-page "https://pypi.org/project/cesium/")
    (synopsis "Library for time-series feature extraction and processing")
    (description
     "Cesium is a library for time-series feature extraction and processing.")
    (license license:bsd-3)))

(define-public python-translitcodec
  (package
    (name "python-translitcodec")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "translitcodec" version))
       (sha256
        (base32
         "10x6pvblkzky1zhjs8nmx64nb9jdzxad4bxhq4iwv0j4z2aqjnki"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))  ; no tests provided
    (home-page
     "https://github.com/claudep/translitcodec")
    (synopsis
     "Unicode to 8-bit charset transliteration codec")
    (description
     "This package contains codecs for transliterating ISO 10646 texts into
best-effort representations using smaller coded character sets (ASCII,
ISO 8859, etc.).")
    (license license:expat)))

(define-public python-anyqt
  (package
    (name "python-anyqt")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "AnyQt" version))
       (sha256
        (base32 "0fvnhdk0nzhlm1xydisvdq1w7lwaakdkbwb1rkyz4vd232wji4jb"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f ;there are no tests
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'delete-files
           ;; Delete files related to other operating systems.
           (lambda _
             (delete-file "AnyQt/QtMacExtras.py")
             (delete-file "AnyQt/QtWinExtras.py"))))))
    (home-page "https://github.com/ales-erjavec/anyqt")
    (synopsis "PyQt4/PyQt5 compatibility layer")
    (description "AnyQt is a PyQt4/PyQt5 compatibility layer.")
    (license license:gpl3)))

(define-public python-pyqtgraph
  (package
    (name "python-pyqtgraph")
    (version "0.13.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyqtgraph" version))
       (sha256
        (base32 "1kiazyc8mqyx0479qdcvdclzq0g1hpp93dyq8444w1f72628s42q"))))
    (build-system pyproject-build-system)
    (arguments
     ;; This test fails.  It suggests to disable assert rewriting in Pytest,
     ;; but it still doesn't pass.
     (list #:test-flags #~'("-k" "not test_reload")
           #:phases
           #~(modify-phases %standard-phases
               (add-before 'check 'set-qpa
                 (lambda _
                   (setenv "QT_QPA_PLATFORM" "offscreen"))))))
    (native-inputs
     (list python-pytest python-pytest-cov python-pytest-xdist
           python-setuptools python-wheel))
    (inputs
     (list qtbase-5))
    (propagated-inputs
     (list python-h5py python-numpy python-pyopengl python-scipy
           python-pyqt))
    (home-page "https://www.pyqtgraph.org")
    (synopsis "Scientific graphics and GUI library for Python")
    (description
     "PyQtGraph is a Pure-python graphics library for PyQt5, PyQt6, PySide2
and PySide6.  It is intended for use in mathematics, scientific or engineering
applications.")
    (license license:expat)))

(define-public python-qasync
  (package
    (name "python-qasync")
    (version "0.27.1")
    (source
     (origin
       ;; There are no tests in the PyPI tarball.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/CabbageDevelopment/qasync/")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0j6ksfnq9qfjdfppbkdz7jh6w0gnslwnckhafmlgim29b25g0z51"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (add-before 'check 'set-qpa
                 (lambda _
                   (setenv "QT_QPA_PLATFORM" "offscreen"))))))
    (native-inputs
     (list python-poetry-core python-pytest))
    (propagated-inputs
     (list python-pyqt))
    (home-page "https://github.com/CabbageDevelopment/qasync")
    (synopsis "Implementation of the PEP 3156 Event-Loop with Qt")
    (description
     "@code{qasync} allows coroutines to be used in PyQt/PySide applications
by providing an implementation of the PEP 3156 event-loop.")
    (license license:bsd-2)))

(define-public python-editor
  (package
  (name "python-editor")
  (version "1.0.4")
  (source
    (origin
      (method url-fetch)
      (uri (pypi-uri "python-editor" version))
      (sha256
        (base32
          "0yrjh8w72ivqxi4i7xsg5b1vz15x8fg51xra7c3bgfyxqnyadzai"))))
  (build-system python-build-system)
  (arguments
   '(#:tests? #f))   ;XXX: needs a TTY and an editor
  (home-page "https://github.com/fmoo/python-editor")
  (synopsis "Programmatically open an editor, capture the result")
  (description
    "python-editor is a library that provides the editor module for
programmatically interfacing with your system's $EDITOR.")
  (license license:asl2.0)))

(define-public python-multiprocessing-logging
  (package
    (name "python-multiprocessing-logging")
    (version "0.3.1")
    (home-page "https://github.com/jruere/multiprocessing-logging")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url home-page)
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1625wy3djlr3b2fpd3vi822f8gw6b75mnls5a4318dbi9za5pf0y"))))
    (build-system python-build-system)
    (synopsis "Manage logs from multiple processes")
    (description
     "This Python module implements a multiprocessing-aware @code{Handler}
that, when set on the root @code{Logger}, will tunnel log records to the
main process so that they are handled correctly.")
    (license license:lgpl3+)))

(define-public python-vobject
  (package
    (name "python-vobject")
    (version "0.9.6.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "vobject" version))
              (sha256
               (base32
                "0081g4gngw28j7vw8101jk600wz4gzfrhf5myrqvn2mrfkn2llcn"))))
    (build-system python-build-system)
    (arguments
     '(;; The test suite relies on some non-portable Windows interfaces.
       #:tests? #f))
    (propagated-inputs
     (list python-dateutil python-pyicu))
    (synopsis "Parse and generate vCard and vCalendar files")
    (description "Vobject is intended to be a full featured Python package for
parsing and generating vCard and vCalendar files.  Currently, iCalendar files
are supported and well tested.  vCard 3.0 files are supported, and all data
should be imported, but only a few components are understood in a sophisticated
way.")
    (home-page "https://eventable.github.io/vobject/")
    (license license:asl2.0)))

(define-public python-munkres
  (package
    (name "python-munkres")
    (version "1.1.4")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "munkres" version))
              (sha256
               (base32
                "00yvj8bxmhhhhd74v7j0x673is7vizmxwgb3dd5xmnkr74ybyi7w"))))
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'disable-test
           (lambda _
             ;; See https://github.com/bmc/munkres/issues/40
             (substitute* "test/test_munkres.py"
               (("^def test_profit_float" m)
                (string-append "\
import platform
@pytest.mark.skipif(platform.architecture()[0] == \"32bit\",
  reason=\"Fails on 32 bit architectures\")
" m))))))))
    (build-system python-build-system)
    (native-inputs (list python-pytest))
    (home-page "https://software.clapper.org/munkres/")
    (synopsis "Implementation of the Munkres algorithm")
    (description "The Munkres module provides an implementation of the Munkres
algorithm (also called the Hungarian algorithm or the Kuhn-Munkres algorithm),
useful for solving the Assignment Problem.")
    (license license:bsd-3)))

(define-public python-whoosh
  (package
    (name "python-whoosh")
    (version "2.7.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "Whoosh" version))
       (sha256
        (base32
         "10qsqdjpbc85fykc1vgcs8xwbgn4l2l52c8d83xf1q59pwyn79bw"))))
    (build-system python-build-system)
    (arguments '(#:tests? #f)) ; Test invocation is no longer supported by Python.
    (native-inputs
     (list python-pytest))
    (home-page "https://bitbucket.org/mchaput/whoosh")
    (synopsis "Full text indexing, search, and spell checking library")
    (description
     "Whoosh is a fast, pure-Python full text indexing, search, and spell
checking library.")
    (license license:bsd-2)))

(define-public python-codespell
  (package
    (name "python-codespell")
    (version "2.3.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "codespell" version))
        (sha256
          (base32 "07s72zfxkznigqdc23k7jp9saq0hgq0gf2kjmmxzcrayyw87s31n"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-pytest-config
            (lambda _
              ;; Drop test coverage requirements.
              (substitute* "pyproject.toml"
                (("\"--cov=codespell_lib\",") "")
                (("\"--cov-report=\",") "")))))))
    (native-inputs
      (list python-pygments
            python-pytest
            python-pytest-dependency
            python-tomli
            python-setuptools
            python-wheel))
    (propagated-inputs
      (list python-chardet))
    (home-page "https://github.com/codespell-project/codespell/")
    (synopsis "Spellchecker for code")
    (description
     "Codespell fixes common misspellings in text files.  It's designed
primarily for checking misspelled words in source code, but it can be used
with other files as well.  It does not check for word membership in a complete
dictionary, but instead looks for a set of common misspellings. Therefore it
should catch errors like \"adn\", but it will not catch \"adnasdfasdf\".  This
also means it shouldn't generate false-positives when you use a niche term it
doesn't know about.")
    (license
      (list
        ; for codespell and codespell_lib
        license:gpl2
        ; for dictionary*.txt
        license:cc-by-sa3.0))))

(define-public python-jellyfish
  (package
    (name "python-jellyfish")
    (version "0.8.8")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "jellyfish" version))
              (sha256
               (base32
                "0p2s6b30sfffx8sya2i8kz0i0riw9fq1fi0k89s8kdgrmjf0h1h5"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f ; XXX: Tests cannot find C coded version.
       #:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key inputs outputs tests? #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               (invoke "pytest" "-vv" "jellyfish/test.py")))))))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/jamesturk/jellyfish")
    (synopsis "Approximate and phonetic matching of strings")
    (description "Jellyfish uses a variety of string comparison and phonetic
encoding algorithms to do fuzzy string matching.")
    (license license:bsd-2)))

(define-public python-pdfminer-six
  (package
    (name "python-pdfminer-six")
    (version "20240706")
    ;; There are no tests in the PyPI tarball.
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/pdfminer/pdfminer.six")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0vdwps38q2414lwjz266rabxrcw2a5s1pgxyjsffiifi010cd3k9"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               ;; Tests write to the source tree.
               (add-after 'unpack 'make-git-checkout-writable
                 (lambda _
                   (for-each make-file-writable (find-files ".")))))))
    (propagated-inputs
     (list python-charset-normalizer python-cryptography))
    (native-inputs
     (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/pdfminer/pdfminer.six")
    (synopsis "PDF parser and analyzer")
    (description "@code{pdfminer.six} is a community maintained fork of
the original PDFMiner.  It is a tool for extracting information from PDF
documents.  It focuses on getting and analyzing text data.  Pdfminer.six
extracts the text from a page directly from the sourcecode of the PDF.  It
can also be used to get the exact location, font or color of the text.")
    (license license:expat)))

(define-public python-rarfile
  (package
    (name "python-rarfile")
    (version "4.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "rarfile" version))
              (sha256
               (base32
                "1882wv9szcm29mnyhjmspyflyr2l7z73srn14w4dlnww49lqfm37"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f ;; The bsdtar utility is very limited and most tests fail.
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch
           (lambda* (#:key inputs #:allow-other-keys)
             (substitute* "rarfile.py"
               ;; Disable unrar and unar, which are unavailable on Guix.
               (("(unrar|unar)=True" all tool) (string-append tool "=False"))
               ;; Hardcode path to bsdtar
               (("\"bsdtar\"")
                (string-append "\"" (assoc-ref inputs "libarchive") "/bin/bsdtar\"")))
             #t))
         (replace 'check
           (lambda* (#:key inputs tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest" "-vv")))))))
    (native-inputs (list python-pytest))
    (inputs (list libarchive))
    (home-page "https://github.com/markokr/rarfile")
    (synopsis "RAR archive reader for Python")
    (description "This is Python module for RAR archive reading.  The interface
is made as zipfile like as possible.")
    (license license:isc)))

(define-public python-slugid
  (package
    (name "python-slugid")
    (version "2.0.0")
    (source
      (origin
        (method git-fetch)
        (uri (git-reference
              (url "https://github.com/taskcluster/slugid.py")
              (commit (string-append "v" version))))
        (file-name (git-file-name name version))
        (sha256
         (base32 "1h64p2jlqv6lsmw8h2j203kx3bhv72cwzpk5gdhsaamw30cp3h1i"))))
    (build-system python-build-system)
    (native-inputs (list python-nose))
    (arguments
      (list #:phases
        #~(modify-phases %standard-phases
            (replace 'check
              (lambda* (#:key inputs tests? #:allow-other-keys)
                (when tests?
                  ;; The project uses tox to run the tests via nose.
                  (invoke "nosetests" "-v" "test.py")))))))
    (home-page "http://taskcluster.github.io/slugid.py")
    (synopsis "Module for Base64 encoded UUID v4 slugs")
    (description "This package provides a module for generating v4
UUIDs and encoding them into 22 character URL-safe base64 slug
representation.")
    (license license:mpl2.0)))

(define-public python-rich
  (package
    (name "python-rich")
    (version "13.7.1")
    (source
      (origin
        ;; There are no tests in the PyPI tarball.
        (method git-fetch)
        (uri (git-reference
              (url "https://github.com/willmcgugan/rich")
              (commit (string-append "v" version))))
        (file-name (git-file-name name version))
        (sha256
         (base32
          "0jvkcp473c0icbb8md3grc3285j2cy0z0swxgk2g67d9n0zfdfzc"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; These fail for unknown reasons, but the results look identical.
      ;; Perhaps only the terminal escape sequences are superficially
      ;; different?
      '(list "-k" (string-append "not test_card_render"
                                 " and not test_markdown_render"
                                 " and not test_python_render"
                                 " and not test_python_render_simple"
                                 " and not test_python_render_simple_passing_lexer_instance"
                                 " and not test_python_render_indent_guides"
                                 " and not test_option_no_wrap"
                                 " and not test_syntax_highlight_ranges"))))
    (propagated-inputs
     (list python-markdown-it-py python-pygments))
    (native-inputs
     (list python-poetry-core python-pytest))
    (home-page "https://github.com/willmcgugan/rich")
    (synopsis "Render rich text and more to the terminal")
    (description
     "This is a Python package for rendering rich text, tables, progress bars,
syntax highlighting, markdown and more to the terminal.")
    (license license:expat)))

(define-public python-rich-click
  (package
    (name "python-rich-click")
    (version "1.6.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "rich-click" version))
              (sha256
               (base32
                "0zkp2sn0vz1hhjbv9bf8fifyzi8ib2d7v7sfak8n3qn67rlrdzzq"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-click python-importlib-metadata python-rich))
    (home-page "https://github.com/ewels/rich-click")
    (synopsis "Format click help output nicely with rich")
    (description "Click is a \"Python package for creating beautiful command
line interfaces\".  Rich is a \"Python library for rich text and beautiful
formatting in the terminal\".  The intention of rich-click is to provide
attractive help output from click, formatted with rich, with minimal
customization required.")
    (license license:expat)))

(define-public python-textual
  (package
    (name "python-textual")
    (version "0.50.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/Textualize/textual")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "10mmmgsq5pblr9ijgyln79p3hc7sah56k2hkzlvm2abrr9gwgpcf"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:test-flags
           ;; Snapshot tests require python-pytest-textual-snapshot which
           ;; in turn depends on python-textual.
           '(list "--ignore=tests/snapshot_tests/test_snapshots.py"
             "-k" (string-append
                   ;; Broken for unknown reason.
                   "not test_textual_env_var"
                   ;; Tests that require python-treesitter-languages.
                   " and not test_language_binary_missing"
                   " and not test_register_language"
                   " and not test_register_language_existing_language"))))
    (propagated-inputs
     (list python-markdown-it-py
           python-mdit-py-plugins
           python-rich
           python-tree-sitter
           ;; python-tree-sitter-languages ; optional, not packed yet
           python-typing-extensions))
    (native-inputs
     (list python-poetry-core python-pytest python-pytest-asyncio))
    (home-page "https://github.com/Textualize/textual")
    (synopsis "Build text user interfaces in Python")
    (description "Textual is a @acronym{TUI, Text User Interface} framework
for Python inspired by modern web development.")
    (license license:expat)))

(define-public python-magic
  (package
    (name "python-magic")
    (version "0.4.27")
    (home-page "https://github.com/ahupp/python-magic")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference (url home-page) (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1x11kfn4g244fia9a7y4ly8dqv5zsxfg3l5azc54dl6gkp2bk7vx"))
       (modules '((guix build utils)))
       ;; Adjust expected output for file@5.45.
       (snippet #~(substitute* "test/libmagic_test.py"
                    (("PDF document, version 1\\.2, 2 pages")
                     "PDF document, version 1.2, 2 page(s)")))))
    (build-system python-build-system)
    (arguments
     '(#:phases (modify-phases %standard-phases
                  ;; Replace a specific method call with a hard-coded
                  ;; path to the necessary libmagic.so file in the
                  ;; store.  If we don't do this, then the method call
                  ;; will fail to find the libmagic.so file, which in
                  ;; turn will cause any application using
                  ;; python-magic to fail.
                  (add-before 'build 'hard-code-path-to-libmagic
                    (lambda* (#:key inputs #:allow-other-keys)
                      (let ((magic (search-input-file inputs "/lib/libmagic.so")))
                        (substitute* "magic/loader.py"
                          (("find_library\\('magic'\\)")
                           (string-append "'" magic "'"))))))
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      ;; The test suite mandates this variable.
                      (setenv "LC_ALL" "C.UTF-8")
                      (if tests?
                          (with-directory-excursion "test"
                            (invoke "python" "./libmagic_test.py"))
                          (format #t "test suite not run~%")))))))
    (native-inputs
     (list which))
    (inputs
     ;; python-magic needs to be able to find libmagic.so.
     (list file))
    (synopsis "File type identification using libmagic")
    (description
     "This module uses ctypes to access the libmagic file type
identification library.  It makes use of the local magic database and
supports both textual and MIME-type output.  Note that this module and
the python-file module both provide a \"magic.py\" file; these two
modules, which are different and were developed separately, both serve
the same purpose: to provide Python bindings for libmagic.")
    (license license:expat)))

(define-public s3cmd
  (package
    (name "s3cmd")
    (version "2.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/s3tools/s3cmd")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0rdgwwmmp8mdxc84bxq6k9a7v7z2qgc3df47djzs2b84gw81dglx"))))
    (build-system python-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (add-after 'unpack 'hide-wrapping
                 (lambda _
                   (substitute* "S3/MultiPart.py"
                     (("sys\\.argv\\[0\\]") "\"s3cmd\""))
                   (substitute* "s3cmd"
                     (("optparser\\.get_prog_name\\(\\)") "\"s3cmd\"")))))))
    (inputs
     (list python-dateutil
           python-magic))
    (home-page "https://s3tools.org/s3cmd")
    (synopsis "Command line tool for S3-compatible storage services")
    (description
     "S3cmd is a command line tool for uploading, retrieving and managing data
in storage services that are compatible with the Amazon Simple Storage
Service (S3) protocol, including S3 itself.  It supports rsync-like backup,
GnuPG encryption, and more.  It also supports management of Amazon's
CloudFront content delivery network.")
    (license license:gpl2+)))

(define-public python-securetar
  (package
    (name "python-securetar")
    (version "2025.1.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/pvizeli/securetar")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1b9m29j4mjiv7925wrbiyj6vyx7m9qmdz40zqd4vgxhz4pq6x3xw"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-setuptools python-wheel python-pytest))
    (propagated-inputs (list python-cryptography))
    (home-page "https://github.com/pvizeli/securetar")
    (synopsis "Python module to handle tarfile backups")
    (description
     "This library provides a streaming wrapper around python tarfile and allow
secure handling files and support encryption.")
    (license license:asl2.0)))

(define-public python-pkgconfig
  (package
    (name "python-pkgconfig")
    (version "1.5.5")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "pkgconfig" version))
        (sha256
          (base32
            "16dqm2g7b2c6s09vf6wv62s629s63xf51n92v0hbax8zy4z1dd6y"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #false                   ;there are none
      #:phases
      '(modify-phases %standard-phases
         (add-before 'build 'patch
           ;; Hard-code the path to pkg-config.
           (lambda _
             (substitute* "pkgconfig/pkgconfig.py"
               (("'pkg-config'")
                (string-append "'" (which "pkg-config") "'"))))))))
    (native-inputs (list python-poetry-core))
    (inputs (list pkg-config))
    (home-page "https://github.com/matze/pkgconfig")
    (synopsis "Python interface for pkg-config")
    (description "This module provides a Python interface to pkg-config.  It
can be used to find all pkg-config packages, check if a package exists,
check if a package meets certain version requirements, query CFLAGS and
LDFLAGS and parse the output to build extensions with setup.py.")
    (license license:expat)))

(define-public python-bz2file
  (package
    (name "python-bz2file")
    (version "0.98")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "bz2file" version))
       (sha256
        (base32
         "126s53fkpx04f33a829yqqk8fj4png3qwg4m66cvlmhmwc8zihb4"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f)) ; Tests use deprecated python modules.
    (home-page "https://github.com/nvawda/bz2file")
    (synopsis "Read and write bzip2-compressed files")
    (description
     "Bz2file is a Python library for reading and writing bzip2-compressed
files.  It contains a drop-in replacement for the I/O interface in the
standard library's @code{bz2} module, including features from the latest
development version of CPython that are not available in older releases.")
    (license license:asl2.0)))

(define-public python-future
  (package
    (name "python-future")
    (version "0.18.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "future" version))
       (sha256
        (base32
         "0zakvfj87gy6mn1nba06sdha63rn4njm7bhh0wzyrxhcny8avgmi"))))
    (build-system python-build-system)
    ;; Many tests connect to the network or are otherwise flawed.
    ;; https://github.com/PythonCharmers/python-future/issues/210
    (arguments
     `(#:tests? #f
       #:phases
       (modify-phases %standard-phases
         (replace 'sanity-check
           (let ((sanity-check (assoc-ref %standard-phases 'sanity-check)))
             (lambda* (#:key inputs outputs #:allow-other-keys #:rest args)
               (let* ((files (find-files (site-packages inputs outputs)
                                         "top_level\\.txt"))
                      (backups (map (lambda (f) (string-append f ".bak"))
                                    files)))
                 (for-each copy-file files backups)
                 (substitute* files
                   ;; Nobody be usin' winreg on Guix
                   ;; Also, don't force users to have tkinter when they don't
                   ;; need it
                   (("(winreg|tkinter)") ""))
                 (apply sanity-check args)
                 (for-each rename-file backups files))))))))
    (home-page "https://python-future.org")
    (synopsis "Single-source support for Python 3 and 2")
    (description
     "@code{python-future} is the missing compatibility layer between Python 2 and
Python 3.  It allows you to use a single, clean Python 3.x-compatible codebase
to support both Python 2 and Python 3 with minimal overhead.")
    (license license:expat)))

(define-public python-cysignals
  (package
    (name "python-cysignals")
    (version "1.11.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "cysignals" version))
       (sha256
        (base32 "1hrqn976xhrq189x1086f3z9vzznjx21wsm3hqf90zx0alg347hg"))))
    (build-system python-build-system)
    (arguments
     `(#:modules ((guix build python-build-system)
                  ((guix build gnu-build-system) #:prefix gnu:)
                  (guix build utils))
       ;; FIXME: Tests are executed after installation and currently fail
       ;; when not installing into standard locations; the author is working
       ;; on a fix.
       #:tests? #f
       #:phases (modify-phases %standard-phases
                  (add-before 'build 'configure
                    (assoc-ref gnu:%standard-phases 'configure)))))
    (native-inputs (list python-cython-3 python-sphinx))
    (inputs (list pari-gp))
    (home-page "https://github.com/sagemath/cysignals")
    (synopsis "Handling of interrupts and signals for Cython")
    (description
     "The cysignals package provides mechanisms to handle interrupts (and
other signals and errors) in Cython code, using two related approaches,
for mixed Cython/Python code or external C libraries and pure Cython code,
respectively.")
    (license license:lgpl3+)))

(define-public python-rope
  (package
    (name "python-rope")
    (version "1.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "rope" version))
       (sha256
        (base32
         "1078mkzivz45my8x2y5gxisr0vba630xj7yxx7anr068xhnpshsi"))))
    (build-system pyproject-build-system)
    (propagated-inputs
     (list python-pytoolconfig))
    (native-inputs
     (list python-pip
           python-pre-commit
           python-pytest
           python-pytest-cov
           python-pytest-timeout
           python-setuptools
           python-wheel))
    (home-page "https://github.com/python-rope/rope")
    (synopsis "Refactoring library for Python")
    (description "Rope is a refactoring library for Python.  It facilitates
the renaming, moving and extracting of attributes, functions, modules, fields
and parameters in Python source code.  These refactorings can also be applied
to occurrences in strings and comments.")
    (license license:lgpl3+)))

(define-public python-py3status
  (package
    (name "python-py3status")
    (version "3.50")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "py3status" version))
       (sha256
        (base32 "0j2dx9lzpic15r8p0r0s3jmcskxpacahxl640b4864ldn5rlnh9d"))))
    (build-system python-build-system)
    (inputs
     (list file))
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         ;; 'file' is used for detection of configuration file encoding
         ;; let's make link the dependency to particular input
         (add-before 'build 'patch-file-path
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((file-path (assoc-ref inputs "file")))
               (substitute* "py3status/parse_config.py"
                 (("\\[\"file\", \"-b\"")
                  (string-append "['" file-path "/bin/file', '-b'")))
               #t))))
       #:tests? #f)) ; TODO: Requires many libraries not in Guix.
    (home-page "https://github.com/ultrabug/py3status")
    (synopsis "Extensible i3status wrapper written in Python")
    (description "py3status is an i3status wrapper which extends i3status
functionality in a modular way, allowing you to extend your panel with your
own code, responding to click events and updating clock every second.")
    (license license:bsd-3)))

(define-public python-tblib
  (package
    (name "python-tblib")
    (version "1.6.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "tblib" version))
              (sha256
               (base32
                "0i136n5pydmd202254wzrdbspkw0br0c9mbxhfs9hpfbahvyx6r2"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "py.test" "-vv" "tests" "README.rst"))))))
    (native-inputs
     (list python-pytest python-six))
    (home-page "https://github.com/ionelmc/python-tblib")
    (synopsis "Traceback serialization library")
    (description
     "Traceback serialization allows you to:

@enumerate
@item Pickle tracebacks and raise exceptions with pickled tracebacks in
different processes.  This allows better error handling when running code over
multiple processes (imagine multiprocessing, billiard, futures, celery etc).

@item Parse traceback strings and raise with the parsed tracebacks.
@end enumerate\n")
    (license license:bsd-3)))

(define-public python-tftpy
  (package
    (name "python-tftpy")
    (version "0.8.2")
    (source
     (origin
       (method git-fetch)               ;no tests in PyPI archive
       (uri (git-reference
             (url "https://github.com/msoulier/tftpy")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1gl04ps8h8r7av3h0zbm8gwmkqs9rkk5vf7n8mv2bzrkwvy9hacc"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? inputs outputs #:allow-other-keys)
                      (when tests?
                        ;; The default DEBUG logging level is way too verbose.
                        (substitute* "t/test.py"
                          (("logging\\.DEBUG")
                           "logging.INFO"))
                        (invoke "python" "-m" "unittest" "t/test.py")))))))
    (home-page "https://tftpy.sourceforge.net/")
    (synopsis "Python trivial file transfer protocol (TFTP) library")
    (description "TFTPy is a trivial file transfer protocol (TFTP) Python
library.  It can be used to act both as a TFTP client or TFTP server.")
    (license license:expat)))

(define-public python-greenlet
  (package
    (name "python-greenlet")
    (version "3.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "greenlet" version))
       (sha256
        (base32 "0rsla5f2vgc6g450fziprjy98vf2fwbz6zjx8x37kpvavdnarqsc"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; AssertionError: 'Exception' not found in ''
      #:test-flags
      #~(list (string-join
               (list "--deselect=src/greenlet/tests/test_greenlet.py"
                     "TestGreenlet"
                     "test_dealloc_catches_GreenletExit_throws_other")
               "::"))
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'build-extensions
            (lambda _
              (invoke "python" "setup.py" "build_ext" "--inplace"))))))
    (native-inputs
     (list python-objgraph
           python-pytest
           python-psutil
           python-setuptools
           python-wheel))
    (home-page "https://greenlet.readthedocs.io/")
    (synopsis "Lightweight in-process concurrent programming")
    (description
     "Greenlet package is a spin-off of Stackless, a version of CPython
that supports micro-threads called \"tasklets\".  Tasklets run
pseudo-concurrently (typically in a single or a few OS-level threads) and
are synchronized with data exchanges on \"channels\".")
    (license (list license:psfl license:expat))))

(define-public python-greenlet-2
  (hidden-package
   (package
     (inherit python-greenlet)
     (version "2.0.2")
     (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "greenlet" version))
        (sha256
         (base32 "1h1l1mll5s4y1b09asf2jps0m7wyshnis1aassz9gc3xmw9xrj77")))))))

(define-public python-objgraph
  (package
    (name "python-objgraph")
    (version "3.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "objgraph" version))
       (sha256
        (base32
         "19qmqsh984zq1rzzjy4vqnmviaqnymcyl8h7z99pnicbgwnm2adz"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-graphviz))
    (native-inputs
     (list python-mock graphviz))
    (home-page "https://mg.pov.lt/objgraph/")
    (synopsis "Draw Python object reference graphs with graphviz")
    (description
     "This package provides tools to draw Python object reference graphs with
graphviz.")
    (license license:expat)))

(define-public python-gevent
  (package
    (name "python-gevent")
    (version "24.11.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "gevent" version))
              (sha256
               (base32
                "1jhs1k49nfhv59c0li6bcpvkr6pzmxkdgfm56gns7r792j8l3lcb"))
              (modules '((guix build utils)))
              (snippet
               '(begin
                  ;; unbunding libev and c-ares
                  (delete-file-recursively "deps")
                  ;; Remove cythonized files.
                  (with-directory-excursion "src/gevent"
                    (for-each delete-file
                              (append (list "resolver/cares.c"
                                            "queue.c"
                                            "local.c"
                                            "libev/corecext.h"
                                            "libev/corecext.c"
                                            "greenlet.c"
                                            "event.c"
                                            "_waiter.c"
                                            "_tracer.c"
                                            "_semaphore.c"
                                            "_imap.c"
                                            "_ident.c"
                                            "_hub_primitives.c"
                                            "_hub_local.c"
                                            "_greenlet_primitives.c"
                                            "_abstract_linkable.c")
                                      (find-files "." "\\.html$"))))))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      '(list
        ;; These tests relies on networking which is
        ;; not available in the build container.
        "test__getaddrinfo_import.py"
        ;; These tests rely on KeyboardInterrupts which do not
        ;; work inside the build container for some reason
        ;; (lack of controlling terminal?).
        "test__issues461_471.py"
        ;; TODO: Patch out the tests that use getprotobyname, etc
        ;; instead of disabling all the tests from these files.
        "test__resolver_dnspython.py"
        ;; This test contains 'test_unlink', which
        ;; fails on i686 (see: https://github.com/gevent/gevent/issues/1558).
        "test__core_stat.py")
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'patch-source-shebangs 'patch-hard-coded-paths
            (lambda _
              (substitute* "src/gevent/subprocess.py"
                (("/bin/sh") (which "sh")))
              (for-each (lambda (file)
                          (substitute* file
                            (("/bin/sh") (which "sh"))
                            (("/bin/true") (which "true"))))
                        (find-files "src/greentest" "\\.py$"))))
          (add-before 'build 'do-not-use-bundled-sources
            (lambda _
              (setenv "GEVENTSETUP_EMBED" "0")

              ;; Prevent building bundled libev.
              (substitute* "setup.py"
                (("run_make=_BUILDING")
                 "run_make=False"))))
          (add-before 'build 'augment-C_INCLUDE_PATH
            (lambda* (#:key inputs #:allow-other-keys)
              (let* ((python (dirname (dirname
                                       (search-input-file
                                        inputs "bin/python"))))
                     (version (python-version python))
                     (greenlet (string-append
                                #$(this-package-input "python-greenlet")
                                "/include/python" version)))
                (setenv "C_INCLUDE_PATH"
                        (string-append greenlet "/:"
                                       (or (getenv "C_INCLUDE_PATH")
                                           ""))))))
          (add-before 'check 'pretend-to-be-CI
            (lambda _
              ;; A few tests are skipped due to network constraints or
              ;; get longer timeouts when running in a CI environment.
              ;; Piggy-back on that, as we need the same adjustments.
              (setenv "TRAVIS" "1")
              (setenv "APPVEYOR" "1")))
          (add-before 'check 'adjust-tests
            (lambda*  (#:key test-flags #:allow-other-keys)
              (call-with-output-file "skipped_tests.txt"
                (lambda (port)
                  (format port "~a~%" (string-join test-flags "\n"))))))
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                ;; Use the build daemons configured number of workers.
                (setenv "NWORKERS" (number->string (parallel-job-count)))
                (invoke "python" "-m" "gevent.tests" "-unone" "--config"
                        "known_failures.py" "--ignore" "skipped_tests.txt")))))))
    (propagated-inputs
     (list python-greenlet python-zope-event python-zope-interface))
    (native-inputs
     (list python-cffi
           python-coverage
           python-cython
           python-dnspython
           python-idna
           python-objgraph
           python-psutil
           python-requests
           python-setuptools
           python-wheel))
    (inputs
     (list c-ares libev libuv))
    (home-page "https://www.gevent.org/")
    (synopsis "Coroutine-based network library")
    (description
     "@code{gevent} is a coroutine-based Python networking library that uses
@code{greenlet} to provide a high-level synchronous API on top of the
@code{libev} event loop.")
    (license license:expat)))

(define-public python-fastimport
  (package
    (name "python-fastimport")
    (version "0.9.9")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "fastimport" version))
        (sha256
          (base32 "06gk14qgm9dxx3pzjn0ckdbywc8ial2bjfzddqwlr4bn1nnqkbll"))))
    (build-system python-build-system)
    (home-page "https://github.com/jelmer/python-fastimport")
    (synopsis "VCS fastimport parser and generator in Python")
    (description "This package provides a parser for and generator of the Git
@url{https://www.kernel.org/pub/software/scm/git/docs/git-fast-import.html,fastimport}
format.")
    (license license:gpl2+)))

(define-public python-twisted
  (package
    (name "python-twisted")
    (version "24.11.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/twisted/twisted")
                    (commit (string-append "twisted-" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0k4rd5bpx40j1k0mgbhzqa35dyni0kk7pxjr8x3pm1iaka1718rh"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-build-system
            (lambda _
              (substitute* "pyproject.toml"
                (("    \"version\",") "")
                (("name = \"Twisted\".*" m)
                 (string-append m "version = \"" #$version "\"\n"))
                (("\\[tool.hatch.version\\]") "")
                (("source = \"incremental\"") ""))))
          (add-after 'unpack 'disable-broken-tests
            (lambda _
              (for-each delete-file
                        (list
                         ;; No idea why they fail
                         "src/twisted/test/test_log.py"
                         ;; Network tests
                         "src/twisted/conch/test/test_cftp.py"
                         "src/twisted/internet/test/test_endpoints.py"
                         "src/twisted/protocols/test/test_tls.py"
                         "src/twisted/test/test_sslverify.py"
                         "src/twisted/web/test/test_agent.py"
                         "src/twisted/web/test/test_tap.py"
                         ;; These need a git executable
                         "src/twisted/python/test/test_release.py"
                         ;; These leave behind a socket file, which breaks the
                         ;; build with "...has an unsupported type"
                         "src/twisted/internet/test/test_unix.py"
                         "src/twisted/test/test_unix.py"
                         ;; These complain about missing test modules.
                         "src/twisted/test/test_failure.py"
                         "src/twisted/web/test/test_http2.py"
                         "src/twisted/conch/test/test_forwarding.py"))))
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (with-directory-excursion #$output
                  (setenv "HOME" (getcwd))
                  (invoke "python3" "-m" "twisted.trial" "twisted"))))))))
    (propagated-inputs
     (list python-attrs
           python-automat
           python-bcrypt
           python-constantly
           python-hyperlink
           python-incremental
           python-typing-extensions
           python-zope-interface))
    (native-inputs
     (list glibc-utf8-locales ;for OpenTestLogTests.test_utf8
           python-coverage
           python-hatch-fancy-pypi-readme
           python-hatchling
           python-httpx
           python-hypothesis
           python-pyflakes
           python-pyhamcrest
           python-pytest
           python-sphinx
           python-sphinx-rtd-theme))
    (home-page "https://twistedmatrix.com/")
    (synopsis "Asynchronous networking framework written in Python")
    (description
     "Twisted is an extensible framework for Python programming, with special
focus on event-based network programming and multiprotocol integration.")
    (license license:expat)))

(define-public python-pika
  (package
    (name "python-pika")
    (version "1.2.1")
    (source
      (origin
        (method git-fetch)
        (uri (git-reference
              (url "https://github.com/pika/pika")
              (commit version)))
        (file-name (git-file-name name version))
        (sha256
         (base32
          "0sqj3bg6jwign8vwvn337fbwy69sm684ns1vh5kbfnskq4him9i2"))))
    (build-system python-build-system)
    (arguments
     '(#:phases (modify-phases %standard-phases
                  (add-after 'unpack 'disable-live-tests
                    (lambda _
                      ;; Disable tests that require RabbitMQ, which is not
                      ;; yet available in Guix.
                      (substitute* "nose2.cfg"
                        (("tests=tests/unit,tests/acceptance")
                         "start-dir=tests/unit"))
                      (with-directory-excursion "tests"
                        (for-each delete-file
                                '("unit/base_connection_tests.py"
                                  "unit/threaded_test_wrapper_test.py")))))
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (when tests?
                        (setenv "PYTHONPATH" (getcwd))
                        (invoke "nose2" "-v")))))))
    (native-inputs
     (list python-mock
           python-nose2
           ;; These are optional at runtime, and provided here for tests.
           python-gevent
           python-tornado
           python-twisted))
    (home-page "https://pika.readthedocs.org")
    (synopsis "Pure Python AMQP Client Library")
    (description
     "Pika is a pure-Python implementation of the AMQP (Advanced Message Queuing
Protocol) 0-9-1 protocol that tries to stay fairly independent of the underlying
network support library.")
    (license license:bsd-3)))

;; WARNING: This package is a dependency of mesa.
(define-public python-ply
  (package
    (name "python-ply")
    (version "3.11")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "ply" version))
        (sha256
          (base32
            "18qx113g9bi1ac4indd5phma82zcdq601lxncp3vjn43m2mc3iq0"))))
    (build-system python-build-system)
    (home-page "http://www.dabeaz.com/ply/")
    (synopsis "Python Lex & Yacc")
    (description "PLY is a @code{lex}/@code{yacc} implemented purely in Python.
It uses LR parsing and does extensive error checking.")
    (license license:bsd-3)))

(define-public python-tabulate
  (package
    (name "python-tabulate")
    (version "0.9.0")
    (source (origin
             (method url-fetch)
             (uri (pypi-uri "tabulate" version))
             (sha256
              (base32
               "0g4b0qnbw55igbpxfxzciqvb6w8ncw4gmcgyq0lyavcnylmv3580"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools-scm
           python-setuptools
           python-wheel))
    (home-page "https://bitbucket.org/astanin/python-tabulate")
    (synopsis "Pretty-print tabular data")
    (description
     "Tabulate is a library and command-line utility to pretty-print tabular
data in Python.")
    (license license:expat)))

(define-public python-kazoo
  (package
    (name "python-kazoo")
    (version "2.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "kazoo" version))
       (sha256
        (base32
         "1zpj5cc8624w6i0pxgcxqkjwbkm4pkrv19d7wh5df3jais32g3jq"))))
    (build-system python-build-system)
    (arguments '(#:tests? #f)) ; XXX: needs zookeeper
    (propagated-inputs
     (list python-six))
    (home-page "https://kazoo.readthedocs.org")
    (synopsis "High-level Zookeeper client library")
    (description
     "Kazoo is a Python client library for the Apache Zookeeper distributed
application service.  It is designed to be easy to use and to avoid common
programming errors.")
    (license license:asl2.0)))

(define-public python-pykafka
  (package
    (name "python-pykafka")
    (version "2.4.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pykafka" version))
              (sha256
               (base32
                "1id6sr159p6aa13bxcqyr9gln8sqg1l0ddzns5iws8kk5q1p5cfv"))))
    (build-system python-build-system)
    (arguments '(#:tests? #f)) ; XXX: needs zookeeper, kafka, etc.
    (propagated-inputs
     (list python-gevent python-kazoo python-tabulate))
    (inputs
     (list librdkafka))
    (home-page "https://pykafka.readthedocs.io/")
    (synopsis "Apache Kafka client for Python")
    (description
     "PyKafka is a client for the Apache Kafka distributed messaging system.
It includes Python implementations of Kafka producers and consumers, which
are optionally backed by a C extension built on librdkafka.")
    (license license:asl2.0)))

(define-public python-wcwidth
  (package
    (name "python-wcwidth")
    (version "0.1.8")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "wcwidth" version))
              (sha256
               (base32
                "1a1pzds3xzfylm5mnc5f6c1p8kiig0daqjc9gygd9rc3cj53x2zj"))))
    (build-system python-build-system)
    (home-page "https://github.com/jquast/wcwidth")
    (synopsis "Measure number of terminal column cells of wide-character codes")
    (description "Wcwidth measures the number of terminal column cells of
wide-character codes.  It is useful for those implementing a terminal emulator,
or programs that carefully produce output to be interpreted by one.  It is a
Python implementation of the @code{wcwidth} and @code{wcswidth} C functions
specified in POSIX.1-2001 and POSIX.1-2008.")
    (license license:expat)))

(define-public python-columnize
  (package
    (name "python-columnize")
    (version "0.3.11")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "columnize" version))
       (sha256
        (base32 "1clb3lfw694crq8m767q0yjaazkplcrbzdr9fr2w39hhndivhcd6"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/rocky/pycolumnize")
    (synopsis "Format a simple (i.e. not nested) list into aligned columns.")
    (description
     "This package provides a way to format a simple (i.e. not nested) list
into aligned columns.")
    (license license:expat)))

(define-public python-chai
  (package
    (name "python-chai")
    (version "1.1.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "chai" version))
              (sha256
               (base32
                "1k6n6zbgrrs83crp6mr3yqj9zlv40b8rpisyrliwsq7naml2p3gz"))
              (patches (search-patches "python-chai-drop-python2.patch"))))
    (build-system python-build-system)
    (home-page "https://github.com/agoragames/chai")
    (synopsis "Mocking framework for Python")
    (description
     "Chai provides an api for mocking, stubbing and spying your python
objects, patterned after the Mocha library for Ruby.")
    (license license:bsd-3)))

(define-public python-inflect
  (package
    (name "python-inflect")
    (version "7.5.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "inflect" version))
              (sha256
               (base32
                "07spmlkmskwhxc0j5j4ms3w0f6pyv3h8iqwcbahdabklqc0riwgs"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-more-itertools python-typeguard
                             python-typing-extensions))
    (native-inputs (list python-pygments python-pytest python-setuptools
                         python-setuptools-scm python-wheel))
    (home-page "https://github.com/jaraco/inflect")
    (synopsis "Correctly generate plurals, singular nouns, ordinals, indefinite articles")
    (description
     "This Python module lets you correctly generate plurals, singular nouns,
ordinals, indefinite articles; it also can convert numbers to words.")
    (license license:expat)))

(define-public python-inflection
  (package
    (name "python-inflection")
    (version "0.3.1")
    (source
     (origin (method url-fetch)
             (uri (pypi-uri "inflection" version))
             (sha256
              (base32
               "1jhnxgnw8y3mbzjssixh6qkc7a3afc4fygajhqrqalnilyvpzshq"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/jpvanhal/inflection")
    (synopsis "Python string transformation library")
    (description
     "Inflection is a string transformation library.  It singularizes
and pluralizes English words, and transforms strings from CamelCase to
underscored string.")
    (license license:expat)))

(define-public python-krb5
  (package
    (name "python-krb5")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "krb5" version))
       (sha256
        (base32 "1jivws8dsscsmyqngbc71r4qw8qmn98pqmhylz01r5dd1ljfw9bi"))))
    (build-system pyproject-build-system)
    (inputs (list mit-krb5))
    (native-inputs (list python-cython python-k5test python-pytest
                         python-setuptools python-wheel))
    (home-page "https://github.com/jborean93/pykrb5")
    (synopsis "Kerberos API bindings for Python")
    (description "This library provides Python functions that wraps the
Kerberos 5 C API.")
    (license license:expat)))

(define-public python-pylev
  (package
    (name "python-pylev")
    (version "1.3.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pylev" version))
              (sha256
               (base32
                "1hz1x9blsbxya1y9nnhnwwdnqmakxi9mc0jkwj0rn6b1h44i0f86"))))
    (build-system python-build-system)
    (home-page "https://github.com/toastdriven/pylev")
    (synopsis "Levenshtein distance implementation in Python")
    (description "Pure Python Levenshtein implementation, based off the
Wikipedia code samples at
@url{http://en.wikipedia.org/wiki/Levenshtein_distance}.")
    (license license:bsd-3)))

(define-public python-cleo
  (package
    (name "python-cleo")
    (version "2.1.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "cleo" version))
              (sha256
               (base32
                "08ym7xaalxzka3k9wp7i05n6j9xmmjs1y02ilrz0lrhkbl5qhb0b"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-poetry-core
           python-mock
           python-pytest-mock
           python-pytest))
    (propagated-inputs
     (list python-crashtest python-rapidfuzz))
    (home-page "https://github.com/sdispater/cleo")
    (synopsis "Command-line arguments library for Python")
    (description
     "Cleo allows you to create command-line commands with signature in
docstring and colored output.")
    (license license:expat)))

(define-public python-tomlkit
  (package
    (name "python-tomlkit")
    (version "0.11.6")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "tomlkit" version))
       (sha256
        (base32 "0wsxnv9bs7jk8ig8blj9c438a1ygvdad7y9cn1zr720nfbjm5fbi"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest python-pyyaml))
    (home-page "https://github.com/sdispater/tomlkit")
    (synopsis "Style-preserving TOML library")
    (description
     "TOML Kit is a 1.0.0rc1-compliant TOML library.  It includes a parser that
preserves all comments, indentations, whitespace and internal element ordering,
and makes them accessible and editable via an intuitive API.  It can also
create new TOML documents from scratch using the provided helpers.  Part of the
implementation has been adapted, improved, and fixed from Molten.")
    (license license:expat)))

(define-public python-shellingham
  (package
    (name "python-shellingham")
    (version "1.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "shellingham" version))
       (sha256
        (base32 "0iawv24xx6vhwbhqlxyyg901f8pf6abqyfg0711v1bvlipx83g21"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "python" "-m" "pytest" "-v")))))))
    (native-inputs
     (list python-pytest python-pytest-mock))
    (home-page "https://github.com/sarugaku/shellingham")
    (synopsis "Tool to detect surrounding shell")
    (description
     "Shellingham detects what shell the current Python executable is
running in.")
    (license license:isc)))

(define-public python-shshsh
  (package
    (name "python-shshsh")
    (version "1.0.5")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/zqqqqz2000/shshsh")
         (commit
          "fd21c8696aebaae04507760c16cb45979291fef5")))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1wzqyj1a6jj6cyv5ymzy834qm2lyq80yy1kfz0q0zayq9gm1cj7f"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-poetry-core
           python-pytest
           python-tox))
    (home-page "https://github.com/zqqqqz2000/shshsh")
    (synopsis "Write Shell commands simply and safely within Python")
    (description "This package provides a way to write Shell commands from
within Python.  Python functions can be chained together to process input
Bash control characters are escapted so that parameters can be passed
without worrying about command injection.")
    (license license:expat)))

(define-public python-memcached
  (package
    (name "python-memcached")
    (version "1.59")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "python-memcached" version))
       (sha256
        (base32
         "0kvyapavbirk2x3n1jx4yb9nyigrj1s3x15nm3qhpvhkpqvqdqm2"))
       (patches (search-patches "python-memcached-syntax-warnings.patch"))))
    (build-system python-build-system)
    (propagated-inputs (list python-six))
    (home-page
     "https://github.com/linsomniac/python-memcached")
    (synopsis "Pure python memcached client")
    (description
     "This software is a pure Python interface to the memcached memory cache
daemon.  It is the client side software which allows storing values in one or
more, possibly remote, memcached servers.")
    (license license:psfl)))

(define-public python-mergedeep
  (package
    (name "python-mergedeep")
    (version "1.3.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/clarketm/mergedeep")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1msvvdzk33sxzgyvs4fs8dlsrsi7fjj038z83s0yw5h8m8d78469"))))
    (build-system python-build-system)
    (native-inputs (list python-pytest))
    (home-page "https://github.com/clarketm/mergedeep")
    (synopsis "Deep merge function for Python")
    (description "This package provides a deep merge function for Python,
useful to combine multiple data objects as one.")
    (license license:expat)))

(define-public python-clikit
  (package
    (name "python-clikit")
    (version "0.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "clikit" version))
       (sha256
        (base32
         "0ngdkmb73gkp5y00q7r9k1cdlfn0wyzws2wrqlshc4hlkbdyabj4"))))
    (build-system python-build-system)
    (arguments '(#:tests? #f))  ; no test in the PyPI tarball
    (propagated-inputs
     (list python-crashtest python-pastel python-pylev))
    (home-page "https://github.com/sdispater/clikit")
    (synopsis "Group of utilities to build command line interfaces")
    (description
     "CliKit is a group of utilities to build testable command line
interfaces.")
    (license license:expat)))

(define-public python-msgpack-python
  (package
    (name "python-msgpack-python")
    (version "0.5.6")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "msgpack-python" version))
       (sha256
        (base32
         "16wh8qgybmfh4pjp8vfv78mdlkxfmcasg78lzlnm6nslsfkci31p"))))
    (build-system python-build-system)
    (home-page "https://msgpack.org/")
    (synopsis "Package to deserialize messages in MessagePack binary format")
    (description
     "MessagePack is an efficient binary serialization format.  It lets you
exchange data among multiple languages like JSON.  But it's faster and
smaller.  Small integers are encoded into a single byte, and typical short
strings require only one extra byte in addition to the strings themselves.")
    (license license:asl2.0)))

(define-public python-cattrs
  (package
    (name "python-cattrs")
    (version "24.1.2")
    (source (origin
              (method git-fetch)        ;for tests
              (uri (git-reference
                    (url "https://github.com/python-attrs/cattrs")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0l806xs0insnvnd1c2l6f6bcaa7wgfrpvbbcyhhsvf2xy9mzq8rd"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      '(list "--numprocesses" (number->string (parallel-job-count))
              ;; Skip all benchmark tests.
              "--ignore=bench/test_attrs_collections.py"
              "--ignore=bench/test_attrs_nested.py"
              "--ignore=bench/test_attrs_primitives.py"
              "--ignore=bench/test_primitives.py"
              "-k"
              (string-join
               ;; XXX: Tests fail with error: AssertionError: assert ...,
               ;; check why.
               (list "not test_msgspec_json_converter"
                     "test_structure_simple_from_dict_default"
                     "test_310_optional_field_roundtrip"
                     "test_310_union_field_roundtrip"
                     "test_individual_overrides"
                     "test_nested_roundtrip"
                     "test_nested_roundtrip_tuple"
                     "test_omit_default_roundtrip"
                     "test_optional_field_roundtrip"
                     "test_renaming"
                     ;; This test fails with an assertion error on the build
                     ;; farm, but not on my laptop.
                     "test_nodefs_generated_unstructuring_cl"
                     ;; See https://github.com/python-attrs/cattrs/issues/575
                     "test_simple_roundtrip"
                     "test_simple_roundtrip_defaults"
                     "test_simple_roundtrip_defaults_tuple"
                     "test_simple_roundtrip_tuple"
                     "test_simple_roundtrip_with_extra_keys_forbidden"
                     "test_structure_simple_from_dict_default"
                     "test_union_field_roundtrip"
                     "test_unmodified_generated_structuring")
               " and not "))
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-pyproject
            (lambda _
              (substitute* "pyproject.toml"
                ;; Fix version string
                (("dynamic = \\[\"version\"\\]")
                 (string-append "version = \"" #$version "\""))
                ;; Just run pytest with no frills
                (("addopts = \"-l.*") ""))))
          ;; XXX Our python-hypothesis package is too old.
          (add-after 'unpack 'compatibility
            (lambda _
              (substitute* "tests/typed.py"
                (("characters\\(codec=codec\\)")
                 "characters()")))))))
    (native-inputs
     (list python-hatchling
           python-hatch-vcs
           python-hypothesis
           python-immutables
           python-msgpack
           python-msgspec
           python-poetry-core
           python-pymongo               ;for the bson module
           python-pytest
           python-pytest-benchmark
           python-pytest-xdist))
    (propagated-inputs
     (list python-attrs
           python-cbor2
           python-exceptiongroup
           python-orjson
           python-pyyaml
           python-tomlkit
           python-typing-extensions
           python-ujson))
    (home-page "https://github.com/python-attrs/cattrs")
    (synopsis "Python library for structuring and unstructuring data")
    (description "@code{cattrs} is an Python library for structuring and
unstructuring data.  @code{cattrs} works best with @code{attrs} classes,
@code{dataclasses} and the usual Python collections, but other kinds of
classes can also be supported by manually registering converters.")
    (license license:expat)))

(define-public python-cachy
  (package
    (name "python-cachy")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "cachy" version))
       (sha256
        (base32
         "1cb9naly8ampzlky7h74n5wj628l7jkpsh0c0jz0namlrvs82r8q"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             ;; Make it compatible with python-flexmock 0.12.
             (substitute* (find-files "tests" "\\.py$")
              (("from flexmock import flexmock, flexmock_teardown")
               "from flexmock import flexmock; from flexmock._api import flexmock_teardown"))
             (invoke "pifpaf" "run" "memcached" "--port" "11211" "--"
                     "pytest"))))))
    (native-inputs
     (list memcached python-fakeredis python-flexmock python-pifpaf
           python-pytest))
    (propagated-inputs
     (list python-memcached python-msgpack-python python-redis))
    (home-page "https://github.com/sdispater/cachy")
    (synopsis "Simple yet effective caching library")
    (description
     "Cachy provides a simple yet effective caching library.  A simple but
powerful API: thread-safety; decorator syntax; support for memcached, redis,
database, file, dict stores.  Cachy supports python versions 2.7+ and 3.2+.")
    (license license:expat)))

(define-public poetry
  (package
    (name "poetry")
    (version "1.8.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "poetry" version))
       (sha256
        (base32 "00ljr5r9h93wh68h4m242qw58mdai8gji4g0c3bfqznicvdgi42l"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "--ignore=tests/installation/test_executor.py"
              "--ignore=tests/installation/test_chef.py"
              "-k" (string-join
                    (list "not test_builder_setup_generation_runs_with_pip_editable"
                          "test_check_invalid"
                          "test_create_poetry_fails_on_invalid_configuration"
                          "test_installer_with_pypi_repository"
                          "test_shell"
                          ;; RuntimeError: No lockfile found. Unable to read
                          ;; locked packages
                          "test_not_fresh_lock"
                          ;; assert False is True
                          "test_env_system_packages_are_relative_to_lib"
                          ;; poetry.inspection.info.PackageInfoError: Unable
                          ;; to determine package info for path
                          "test_info_setup_complex_calls_script")
                    " and not "))
      #:phases
      #~(modify-phases %standard-phases
          ;; Almost every dependency is pinned too strictly.
          (delete 'sanity-check))))
    (native-inputs
     (list nss-certs-for-test
           python-deepdiff
           python-httpretty
           python-pytest
           python-pytest-mock
           python-pytest-randomly
           python-pytest-xdist))
    (propagated-inputs
     (list python-cachecontrol
           python-cleo
           python-crashtest
           python-dulwich
           python-entrypoints
           python-fastjsonschema
           python-importlib-metadata
           python-installer
           python-keyring
           python-packaging
           python-pexpect
           python-pip
           python-pkginfo
           python-platformdirs
           python-poetry-core
           python-poetry-plugin-export
           python-pypa-build
           python-pyproject-hooks
           python-requests
           python-requests-toolbelt
           python-shellingham
           python-tomli
           python-tomlkit
           python-trove-classifiers
           python-virtualenv
           python-xattr))
    (home-page "https://python-poetry.org")
    (synopsis "Python dependency management and packaging made easy")
    (description
     "Poetry is a tool for dependency management and packaging in Python.  It
allows you to declare the libraries your project depends on and it will
manage (install/update) them for you.")
    (license license:expat)))

(define-public python-pyproject-api
  (package
    (name "python-pyproject-api")
    (version "1.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyproject_api" version))
       (sha256
        (base32 "15l4fx1v4dqhhysxd2mcm1vn4qvrwbqmf6y2zkp36pgb5ygh9f3p"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      '(list "-k" (string-append
                   ;; This fails because of extraneous parentheses
                   "not test_setuptools_prepare_metadata_for_build_wheel"
                   ;; This fails because wheel shows up in requirements
                   " and not test_setuptools_get_requires_for_build_wheel"))))
    (native-inputs
     (list python-covdefaults
           python-hatch-vcs
           python-hatchling
           python-pytest
           python-pytest-cov
           python-pytest-mock
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-packaging python-tomli))
    (home-page "https://pyproject-api.readthedocs.io/latest/")
    (synopsis "API to interact with the Python pyproject.toml based projects")
    (description
     "@code{pyproject-api} aims to abstract away interaction with
@code{pyproject.toml} style projects in a flexible way.")
    (license license:expat)))

(define-public python-pyproject-hooks
  (package
    (name "python-pyproject-hooks")
    (version "1.0.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pyproject_hooks" version))
              (sha256
               (base32
                "1xaf4sharvacqlav6w3b38nc4j0rzg0p4axi7zamanbzp6cb4wgj"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-flit-core
           python-testpath
           python-pytest))
    (propagated-inputs (list python-tomli))
    (home-page "https://github.com/pypa/pyproject-hooks")
    (synopsis "Low-level library for calling @file{pyproject.toml} backends")
    (description
     "@code{pyproject-hooks} is a low-level library for calling build backends
in @file{pyproject.toml}-based projects.  It provides basic functionality to
write tooling that generates distribution files from Python projects.")
    (license license:expat)))

(define-public python-lark-parser
  (package
    (name "python-lark-parser")
    (version "0.9.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "lark-parser" version))
              (sha256
               (base32
                "1kd61asrb3h9spgsj4bslfbgp8q4271sw3hblk6f2vbbblv8jxcy"))))
    (build-system python-build-system)
    (home-page "https://github.com/lark-parser/lark")
    (synopsis "Multi-language parser for Python")
    (description
     "Lark is a parser built with a focus on ergonomics, performance and
resilience.  Lark can parse all context-free languages.  That means it is
capable of parsing almost any programming language out there, and to
some degree most natural languages too.")
    (license license:expat)))

(define-public python-libcst
  (package
    (name "python-libcst")
    (version "1.6.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "libcst" version))
              (sha256
               (base32
                "1nzhvg52whpmfv8fkrnv7rlrmgc5m43hpyp8ra9kffx47yzcs3p8"))
              (snippet
               #~(begin (use-modules (guix build utils))
                        ;; This is mostly to keep the cargo-build-system happy
                        (with-output-to-file "Cargo.toml"
                          (lambda ()
                            (format #t "\
[workspace]

members = [
    \"native\",]")))))))
    (build-system cargo-build-system)
    (arguments
     (list
      #:install-source? #false
      #:cargo-test-flags
      ;; According to .github/workflows/ci.yml
      '(list "--manifest-path=native/Cargo.toml"
             "--release"
             "--no-default-features")
      #:cargo-inputs
      (list rust-chic-1
            rust-memchr-2
            rust-paste-1
            rust-peg-0.8
            rust-pyo3-0.22
            rust-quote-1
            rust-regex-1
            rust-syn-2
            rust-thiserror-1)
      #:cargo-development-inputs
      (list rust-criterion-0.5
            rust-difference-2
            rust-itertools-0.13
            rust-rayon-1
            rust-trybuild-1)
      #:imported-modules `(,@%pyproject-build-system-modules
                           ,@%cargo-build-system-modules)
      #:modules `((guix build cargo-build-system)
                  ((guix build pyproject-build-system) #:prefix py:)
                  (guix build utils))
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'prepare-source
            (lambda _
              (delete-file "native/Cargo.lock")))
          (add-after 'configure 'dont-vendor-self
            (lambda* (#:key vendor-dir #:allow-other-keys)
              ;; Don't keep the whole tarball in the vendor directory
              (delete-file-recursively
                (string-append vendor-dir "/libcst-" #$version ".tar.zst"))))
          (replace 'build
            (assoc-ref py:%standard-phases 'build))
          (add-after 'install 'wrap
            (lambda _
              ;; Collection of python- and pyproject-build-system phases
              ;; between 'install and 'check.
              (assoc-ref py:%standard-phases 'add-install-to-pythonpath)
              (assoc-ref py:%standard-phases 'add-install-to-path)
              (assoc-ref py:%standard-phases 'wrap)
              (assoc-ref py:%standard-phases 'create-entrypoints)
              (assoc-ref py:%standard-phases 'compile-bytecode)))
          ;; We are not the only ones who cannot load libcst.native
          ;; during the 'check phase
          ;; https://github.com/Instagram/LibCST/issues/1176
          ;(add-after 'wrap 'python-check
          ;  (lambda args
          ;    (apply (assoc-ref py:%standard-phases 'check)
          ;           #:test-flags '()
          ;           args)))
          (replace 'install
            (assoc-ref py:%standard-phases 'install)))))
    (native-inputs
     (list python-minimal-wrapper
           python-hypothesmith
           python-pytest
           python-setuptools
           python-setuptools-rust
           python-setuptools-scm
           python-wheel))
    (inputs (list maturin))
    (propagated-inputs
     (list python-pyyaml))
    (home-page "https://github.com/Instagram/LibCST")
    (synopsis "Concrete Syntax Tree (CST) parser and serializer library for Python")
    (description
     "LibCST parses Python source code as a CST tree that keeps all
formatting details (comments, whitespaces, parentheses, etc).  It's useful
for building automated refactoring (codemod) applications and linters.
LibCST creates a compromise between an Abstract Syntax Tree (AST) and
a traditional Concrete Syntax Tree (CST).  By carefully reorganizing and
naming node types and fields, LibCST creates a lossless CST that looks and
feels like an AST.")
    (license (list license:expat
                   ;; Some files unde libcst/_parser/ are under Python Software
                   ;; Foundation license (see LICENSE file for details)
                   license:psfl
                   ;; libcst/_add_slots.py
                   license:asl2.0))))

(define-public python-libcst-minimal
  (hidden-package
   (package
     (inherit python-libcst)
     (name "python-libcst-minimal")
     (arguments
      (substitute-keyword-arguments (package-arguments python-libcst)
        ((#:tests? _ #t) #f)))
    (native-inputs
     (list python-minimal-wrapper
           python-setuptools
           python-setuptools-rust
           python-setuptools-scm
           python-wheel)))))

(define-public python-typeapi
  (package
    (name "python-typeapi")
    (version "2.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "typeapi" version))
       (sha256
        (base32 "1652fc04gn6nkw8izim0g7v586f64fla6clinp5xq9rf739w3cs9"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #false                   ;there are none
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'patch-build-system
           (lambda _
             (substitute* "pyproject.toml"
               (("^docs =.*") "docs = []\n")))))))
    (propagated-inputs (list python-typing-extensions))
    (native-inputs (list python-poetry-core))
    (home-page "https://pypi.org/project/typeapi/")
    (synopsis "Type hints")
    (description "The typeapi package provides an object-oriented interface
for introspecting PEP484 type hints at runtime, including forward references
that make use of the more recent PEP585 and PEP604 type hint features in
Python versions that don't natively support them.")
    (license license:expat)))

(define-public python-typing-inspect
  (package
    (name "python-typing-inspect")
    (version "0.9.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "typing_inspect" version))
              (sha256
               (base32
                "0y0z8v4wr5bahlgzjd1il2z8vlfd2asiyb45wia6kvznyqpw8gxj"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-mypy-extensions
           python-typing-extensions))
    (home-page "https://github.com/ilevkivskyi/typing_inspect")
    (synopsis "API for inspection of types in the Python @code{typing} module")
    (description
     "The @code{typing_inspect} module defines experimental API for runtime
inspection of types defined in the Python standard typing module.")
    (license license:expat)))

(define-public python-lazy-loader
  (package
    (name "python-lazy-loader")
    (version "0.4")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "lazy_loader" version))
              (sha256
               (base32
                "1lacaz292qxpgw6kxiirkx6sv9c5883nq4ssm3hs94cvb2153is7"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-numpy python-pytest python-setuptools))
    (propagated-inputs
     (list python-flit-core
           python-setuptools
           python-wheel))
    (home-page "https://scientific-python.org/specs/spec-0001/")
    (synopsis "Load subpackages and functions on demand")
    (description "@code{python-lazy-loader} makes it easy to load subpackages
and functions on demand.  Its main features are:

@itemize
@item Allow subpackages to be made visible to users without incurring import
costs.
@item Allow external libraries to be imported only when used, improving import
times.
@end itemize")
    (license license:bsd-3)))

(define-public python-lazy-object-proxy
  (package
    (name "python-lazy-object-proxy")
    (version "1.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "lazy-object-proxy" version))
       (sha256
        (base32 "0sdc92bbzy6slcl432j04mr131cy8n0many26ppm4fpl8mnpn93q"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pip
           python-setuptools
           python-setuptools-scm
           python-wheel))
    (home-page "https://github.com/ionelmc/python-lazy-object-proxy")
    (synopsis "Lazy object proxy for Python")
    (description
     "Lazy object proxy is an object that wraps a callable but defers the call
until the object is actually required, and caches the result of said call.")
    (license license:bsd-2)))

(define-public python-dnspython
  (package
    (name "python-dnspython")
    (version "2.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "dnspython" version))
       (sha256
        (base32 "1wgsbiz90npdi47cilmwdccm29hl9qddzkm533v1rj8dv8p4776f"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list
         ;; AssertionError: assert False
         "--deselect=tests/test_features.py::test_have"
         ;; dns.exception.SyntaxError: protocol not found
         "--deselect=tests/test_rdata.py::RdataTestCase::test_misc_good_WKS_text"
         ;; ECDSA with deterministic signature (RFC 6979) is not supported by
         ;; this version of OpenSSL.
         "-k" (string-append "not testDeterministicSignatureECDSAP256SHA256"
                             " and not testSignatureECDSAP256SHA256"
                             " and not testSignatureECDSAP384SHA384"
                             " and not test_ecdsa"))
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-getprotobyname-calls
            ;; These calls are problematic in the build environment as there is
            ;; no /etc/protocols.  This breaks the sanity-check phase of any
            ;; package depending on this one.
            (lambda _
              (substitute* "dns/rdtypes/IN/WKS.py"
                (("socket.getprotobyname\\('tcp'\\)")
                 "6")
                (("socket.getprotobyname\\('udp'\\)")
                 "17")))))))
    (native-inputs
     (list python-hatchling
           python-pytest))
    (propagated-inputs
     (append
       (if (supported-package? python-cryptography)
           (list ;; DNSSEC
                 python-cryptography
                 ;; DNS over Quic
                 python-aioquic
                 ;; DNS over HTTPS
                 python-h2
                 python-httpcore
                 python-httpx)
           '())
       (list python-idna
             python-trio)))
    (home-page "https://www.dnspython.org")
    (synopsis "DNS toolkit for Python")
    (description
     "dnspython is a DNS toolkit for Python.  It supports almost all record
types.  It can be used for queries, zone transfers, and dynamic updates.
It supports TSIG authenticated messages and EDNS0.")
    (license license:expat)))

(define-public python-dnspython-1.16
  (package
    (inherit python-dnspython)
    (version "1.16.0")
    (source (origin
              (method url-fetch)
              (uri (string-append "http://www.dnspython.org/kits/"
                                  version "/dnspython-" version ".tar.gz"))
              (sha256
               (base32
                "1yaw7irazy42n0kdhlk7wyg8ki34rxcnc5xbc1wfwy245b0wbxab"))))
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'compatibility
            (lambda _
              (substitute* "dns/namedict.py"
                (("collections.MutableMapping")
                 "collections.abc.MutableMapping"))))
          (add-after 'unpack 'patch-getprotobyname-calls
            ;; These calls are problematic in the build environment as there is
            ;; no /etc/protocols.  This breaks the sanity-check phase of any
            ;; package depending on this one.
            (lambda _
              (substitute* "dns/rdtypes/IN/WKS.py"
                (("socket.getprotobyname\\('tcp'\\)")
                 "6")
                (("socket.getprotobyname\\('udp'\\)")
                 "17")))))))
    (native-inputs (list python-pytest python-setuptools python-wheel))))

(define-public python-py3dns
  (package
    (name "python-py3dns")
    (version "3.2.1")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "py3dns" version))
        (sha256
         (base32
          "1r25f0ys5p37bhld7m7n4gb0lrysaym3w318w2f8bncq7r3d81qz"))))
    (build-system python-build-system)
    ;; This package wants to read /etc/resolv.conf. We can't patch it without
    ;; removing functionality so we copy from Nix and "just don't build it".
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-source
           (lambda _
             (substitute* "setup.py"
               (("import DNS") "")
               (("DNS.__version__") (string-append "\"" ,version "\"")))))
         ;; For the same reason, drop the sanity check because the library
         ;; fails to load without /etc/resolv.conf.
         (delete 'sanity-check))
       #:tests? #f)) ; Also skip the tests.
    (home-page "https://launchpad.net/py3dns")
    (synopsis "Python 3 DNS library")
    (description "This Python 3 module provides a DNS API for looking up DNS
entries from within Python 3 modules and applications.  This module is a
simple, lightweight implementation.")
    (license license:psfl)))

(define-public python-email-validator
  (package
    (name "python-email-validator")
    (version "2.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "email_validator" version))
       (sha256
        (base32 "1dw28lv9lpsw2s7dylhih93fn72s8iqyfsp6497p2yk19hs0ysfb"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; dns.resolver.NoResolverConfiguration: cannot open /etc/resolv.conf
      #~(list "-k" "not test_caching_dns_resolver")))
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-dnspython
           python-idna))
    (home-page "https://github.com/JoshData/python-email-validator")
    (synopsis "Email address validation library for Python")
    (description
     "This library validates email address syntax and deliverability.")
    (license license:cc0)))

(define-public python-ukpostcodeparser
  (package
    (name "python-ukpostcodeparser")
    (version "1.1.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "UkPostcodeParser" version))
              (sha256
               (base32
                "03jkf1ygbwq3akzbcjyjk1akc1hv2sfgx90306pq1nwklbpn80lk"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               ;; Tests for lowercase postcodes fail.
               (invoke "pytest" "-vv" "ukpostcodeparser/test/parser.py" "-k"
                       (string-append "not test_091 "
                                      "and not test_097 "
                                      "and not test_098 "
                                      "and not test_125 "
                                      "and not test_131"))))))))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/hamstah/ukpostcodeparser")
    (synopsis "UK Postcode parser for Python")
    (description
     "This library provides the @code{parse_uk_postcode} function for
parsing UK postcodes.")
    (license license:expat)))

(define-public python-faker
  (package
    (name "python-faker")
    (version "33.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "faker" version))
       (sha256
        (base32 "1r518fmir10jwz29a9fsl66x834dr1w40l4bci3gqlbax305z4hw"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-freezegun
           python-pytest
           python-random2
           python-ukpostcodeparser
           python-setuptools
           python-validators
           python-wheel))
    (propagated-inputs
     (list python-dateutil
           python-typing-extensions))
    (home-page "https://github.com/joke2k/faker")
    (synopsis "Python package that generates fake data")
    (description
     "Faker is a Python package that generates fake data such as names,
addresses, and phone numbers.")
    (license license:expat)))

(define-public python-pyaml
  (package
    (name "python-pyaml")
    (version "21.10.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pyaml" version))
              (sha256
               (base32
                "10w3frzqir5sbpglc9bwb8w414dsivmcvji07yxy61mz2gp9ylf6"))))
    (build-system python-build-system)
    (native-inputs
     (list python-unidecode))
    (propagated-inputs
     (list python-pyyaml))
    (home-page "https://github.com/mk-fg/pretty-yaml")
    (synopsis "YAML pretty-print library for Python")
    (description
     "pyaml is a PyYAML based python module to produce pretty and readable
YAML-serialized data.")
    (license license:wtfpl2)))

(define-public python-pyyaml-env-tag
  (package
    (name "python-pyyaml-env-tag")
    (version "0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyyaml_env_tag" version))
       (sha256
        (base32 "1nsva88jsmwn0cb9jnrfiz4dvs9xakkpgfii7g1xwkx1pmsjc2bh"))))
    (build-system python-build-system)
    (propagated-inputs (list python-pyyaml))
    (home-page "https://github.com/waylan/pyyaml-env-tag")
    (synopsis "Custom YAML tag for environment variables")
    (description "This package provides a custom YAML tag for referencing
environment variables in YAML files.")
    (license license:expat)))

(define-public python-backpack
  (package
    (name "python-backpack")
    (version "0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "backpack" version))
       (sha256
        (base32
         "14rq1mvm0jda90lcx9gyyby9dvq4x3js2cmxvd6vl4686ixwyqh1"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest python-nose python-toml))
    (propagated-inputs
     (list python-simplejson))
    (home-page "https://github.com/sdispater/backpack")
    (synopsis "Utilities for working with Python collections")
    (description "Backpack provides some useful utilities for working with
collections of data.")
    (license license:expat)))

(define-public python-prompt-toolkit
  (package
    (name "python-prompt-toolkit")
    (version "3.0.43")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "prompt_toolkit" version))
       (sha256
        (base32 "0zgzn02ffc9njpz0pfsin30nwmm3754cig20l1jvqv0h4spvf9rm"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               ;; HOME is needed for the test
               ;; "test_pathcompleter_can_expanduser".
               (setenv "HOME" "/tmp")
               (invoke "pytest" "-vv")))))))
    (propagated-inputs
     (list python-wcwidth))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/prompt-toolkit/python-prompt-toolkit")
    (synopsis "Library for building command line interfaces in Python")
    (description
     "Prompt-Toolkit is a library for building interactive command line
interfaces in Python.  It's like GNU Readline but it also features syntax
highlighting while typing, out-of-the-box multi-line input editing, advanced
code completion, incremental search, support for Chinese double-width
characters, mouse support, and auto suggestions.")
    (license license:bsd-3)))

(define-public python-proselint
  (package
    (name "python-proselint")
    (version "0.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "proselint" version))
       (sha256
        (base32
         "0n1ahnq2mkgvh94g05xhc3l1fs3hh0ycskqlqivhhfdaq8ybdlkx"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'set-home-directory
           (lambda _
             (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list python-click python-future python-six))
    (home-page "http://proselint.com/")
    (synopsis "Linter for prose")
    (description "@code{python-proselint} is a linter for English prose, that
scans through a file and detects issues.")
    (license license:bsd-3)))

(define-public python-jedi
  (package
    (name "python-jedi")
    (version "0.19.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/davidhalter/jedi")
             (commit (string-append "v" version))
             (recursive? #true)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0w8rrw6s4bzr5csds8bhasrmzh9q77zh5dzisjysl8cb5qjx0w6s"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-before 'check 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (native-inputs
     (list python-docopt
           python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-parso))
    (home-page "https://github.com/davidhalter/jedi")
    (synopsis "Autocompletion and static analysis library for Python")
    (description
     "Jedi is a static analysis tool for Python that can be used in Integrated
Development Environments (@dfn{IDE}s) and text editors.  It understands Python
on a deeper level than many other static analysis frameworks for Python.

Jedi understands docstrings and you can use Jedi autocompletion in your REPL
as well.")
    (license license:expat)))

(define-public ptpython
  (package
    (name "ptpython")
    (version "3.0.20")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "ptpython" version))
              (sha256
               (base32
                "1mjfyr5gwrs1qbizh6nki0nv6hahmg8mhhqxi1qc6pfa4znlrzga"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f)) ;there are no tests
    (propagated-inputs
     (list python-appdirs python-black python-jedi python-prompt-toolkit
           python-pygments))
    (home-page "https://github.com/jonathanslenders/ptpython")
    (synopsis "Python Read-Eval-Print-Loop with nice IDE-like features")
    (description
     "ptpython is a Python read-eval-print loop with IDE-like features.
It supports syntax highlighting, multiline editing, autocompletion, mouse,
color schemes, bracketed paste, Vi and Emacs keybindings, Chinese characters
etc.")
    (license license:bsd-3)))

(define-public python-easyprocess
  (package
    (name "python-easyprocess")
    (version "0.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "EasyProcess" version))
       (sha256
        (base32 "115rzzr0hx4af4m6krf7dxn8851n4l8jfxahjzjc2r0zq2m8v57v"))))
    (build-system python-build-system)
    (arguments
     ;; Tests require pyvirtualdisplay, which requires this package.
     `(#:tests? #f))
    (home-page "https://github.com/ponty/easyprocess")
    (synopsis "Python subprocess interface")
    (description
     "@code{easyprocess} is an easy to use Python subprocess interface.")
    (license license:bsd-3)))

(define-public python-entrypoint2
  (package
    (name "python-entrypoint2")
    (version "0.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "entrypoint2" version))
       (sha256
        (base32 "1qyxq54r2fbh09ab5sffbxajy8arbk6czxz5lq3ccr9qrypw6w27"))))
    (build-system python-build-system)
    (arguments
     `(#:test-target "pytest"))
    (native-inputs
     (list python-easyprocess python-pytest python-pytest-runner))
    (home-page "https://github.com/ponty/entrypoint2")
    (synopsis "Command-line interface for Python modules")
    (description
     "@code{entrypoint2} is an easy to use command-line interface for Python
     modules based on @code{argparse}.  It translates function signature and
     documentation to argparse configuration.")
    (license license:bsd-3)))

(define-public python-pyvirtualdisplay
  (package
    (name "python-pyvirtualdisplay")
    (version "3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "PyVirtualDisplay" version))
       (sha256
        (base32 "0nb1s7nilakrkcm0vq08pz9mh8rzyhjm9jkyn1gp5sxnrv1mnx89"))))
    (build-system python-build-system)
    (arguments
     ;; Tests fail with:
     ;; FileNotFoundError: [Errno 2] No such file or directory: 'Xvnc'.
     `(#:tests? #f))
    (native-inputs
     (list python-entrypoint2 python-psutil python-pytest
           python-pytest-runner))
    (propagated-inputs
     (list python-easyprocess python-pillow))
    (home-page "https://github.com/ponty/pyvirtualdisplay")
    (synopsis "Python wrapper for Xvfb, Xephyr and Xvnc")
    (description
     "@code{pyvirtualdisplay} is a Python wrapper for Xvfb, Xephyr and Xvnc.")
    (license license:bsd-3)))

(define-public python-stem
  (package
    (name "python-stem")
    (version "1.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "stem" version))
       (sha256
        (base32
         "1hk8alc0r4m669ggngdfvryndd0fbx0w62sclcmg55af4ak8xd50"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'fix-tests
           ;; See https://github.com/torproject/stem/issues/56
           (lambda _
             (substitute* "run_tests.py"
               (("test\\.task\\.MOCK_VERSION,")
                ""))))
         (replace 'check
           (lambda _
             (invoke "./run_tests.py" "--unit")
             #t)))))
    (native-inputs
     (list python-mock python-pycodestyle python-pyflakes))
    (home-page "https://stem.torproject.org/")
    (synopsis
     "Python controller library that allows applications to interact with Tor")
    (description
     "Stem is a Python controller library for Tor.  With it you can use Tor's
     control protocol to script against the Tor process and read descriptor data
     relays publish about themselves.")
    (license license:lgpl3)))

(define-public python-pyserial
  (package
    (name "python-pyserial")
    (version "3.5")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "pyserial" version))
        (sha256
          (base32
            "1nyd4m4mnrz8scbfqn4zpq8gnbl4x42w5zz62vcgpzqd2waf0xrw"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (home-page "https://github.com/pyserial/pyserial")
    (synopsis "Python Serial Port Bindings")
    (description
     "@code{pyserial} provide serial port bindings for Python.  It supports
different byte sizes, stop bits, parity and flow control with RTS/CTS and/or
Xon/Xoff.  The port is accessed in RAW mode.")
    (license license:bsd-3)))

(define-public python-pyserial-asyncio
  (package
    (name "python-pyserial-asyncio")
    (version "0.6")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyserial-asyncio" version))
       (sha256
        (base32 "0bx3syngmq2j9mh81byzka1x4ilw8ac9mbx52zn7b7ayw0ijj0xn"))))
    (build-system python-build-system)
    (propagated-inputs (list python-pyserial))
    (home-page "https://github.com/pyserial/pyserial-asyncio")
    (synopsis "Pyserial asynchronous I/O extension")
    (description "This package extends Pyserial with asynchronous I/O
     support.")
    (license license:bsd-3)))

(define-public python-pymemcache
  (package
    (name "python-pymemcache")
    (version "4.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pymemcache" version))
       (sha256
        (base32 "157z9blr8pjg9x84jph5hm0z2l6yaq6n421jcf1hzqn1pg8rpgr7"))))
    (build-system pyproject-build-system)
    (arguments
     ;; We don't have the zstd module.
     (list
      #:test-flags
      '(list "--ignore=pymemcache/test/test_compression.py")))
    (native-inputs
     (list python-faker python-pytest python-pytest-cov python-setuptools
           python-wheel))
    (home-page "https://github.com/pinterest/pymemcache")
    (synopsis "Comprehensive, fast, pure Python memcached client")
    (description
     "This package provides a comprehensive, fast, pure Python memcached
client.")
    (license license:asl2.0)))

(define-public python-pymodbus
  (package
    (name "python-pymodbus")
    (version "2.5.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/riptideio/pymodbus")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0kjjrx7xrlx0pf3y67hhr4xvqrly3xzmvf6ic5as61m6z19m7zd5"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (add-after 'unpack 'disable-problematic-tests
                    (lambda _
                      ;; The following test modules rely on Python's own
                      ;; 'test' module, which is not distributed in the Python
                      ;; package of Guix.
                      (delete-file "test/test_client_async_asyncio.py")
                      (delete-file "test/test_client_sync_diag.py")
                      ;; The following test module requires the asynctest
                      ;; library, abandoned without support for Python 3.9+
                      ;; (see:
                      ;; https://github.com/riptideio/pymodbus/issues/681).
                      (delete-file "test/test_server_asyncio.py")))
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (when tests?
                        (invoke "python" "-m" "pytest")))))))
    (native-inputs
     (list python-mock
           python-pytest
           python-redis
           python-sqlalchemy
           python-tornado
           python-twisted))
    (propagated-inputs
     (list python-pyserial
           python-six
           ;; For the REPL.
           python-aiohttp
           python-click
           python-prompt-toolkit
           python-pygments
           python-pyserial-asyncio))
    (home-page "https://github.com/riptideio/pymodbus/")
    (synopsis "Modbus protocol stack in Python")
    (description "Pymodbus is a full Modbus protocol implementation using
     @code{asyncio}, @code{tornado} or @code{twisted} for its asynchronous
     communications core.  It includes the following @emph{client} features:
     @itemize
     @item full read/write protocol on discrete and register
     @item most of the extended protocol (diagnostic/file/pipe/setting/information)
     @item TCP, UDP, Serial ASCII, Serial RTU, and Serial Binary
     @item asynchronous and synchronous versions
     @item payload builder/decoder utilities
     @item pymodbus read eval print loop (REPL).
     @end itemize
     It also includes the following @emph{server} features:
     @itemize
     @item can function as a fully implemented Modbus server
     @item TCP, UDP, Serial ASCII, Serial RTU, and Serial Binary
     @item asynchronous and synchronous versions
     @item full server control context (device information, counters, etc)
     @item a number of backing contexts (database, redis, sqlite, a slave device).
     @end itemize")
    (license license:bsd-3)))

(define-public python-exodriver
  (package
    (name "python-exodriver")
    (version "2.6.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/labjack/exodriver")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1ikjz8147p14s814yabdq821y691klnr2yg54zgsymcc97kvwp2q"))))
    (outputs (list "out"
                   "doc"))              ;544 KiB of examples
    (build-system gnu-build-system)
    (arguments
     (list
      #:tests? #f                       ;no test suite
      #:make-flags #~(list (string-append "CC=" #$(cc-for-target))
                           (string-append "PREFIX=" #$output)
                           "RUN_LDCONFIG=0"
                           "LINK_SO=1")
      #:phases
      #~(modify-phases %standard-phases
          (delete 'configure)
          (replace 'build
            (lambda* (#:key make-flags #:allow-other-keys #:rest args)
              (with-directory-excursion "liblabjackusb"
                (apply (assoc-ref %standard-phases 'build)
                       `(,@args #:make-flags ,make-flags)))))
          (replace 'install
            (lambda* (#:key make-flags #:allow-other-keys #:rest args)
              (with-directory-excursion "liblabjackusb"
                (apply (assoc-ref %standard-phases 'install)
                       `(,@args #:make-flags ,make-flags)))
              ;; Install udev rules.
              (install-file "90-labjack.rules"
                            (string-append #$output "/lib/udev/rules.d"))
              ;; Install examples.
              (let ((doc (string-append #$output:doc "/share/doc/" #$name)))
                (mkdir-p doc)
                (copy-recursively "examples"
                                  (string-append doc "/examples"))))))))
    (inputs (list libusb))
    (home-page "https://github.com/labjack/exodriver")
    (synopsis "USB driver for LabJack data acquisition instruments")
    (description "This package provides @code{liblabjackusb}, a USB library for low-level
communication with the U3, U6, UE9, Digit, T4 and T7 LabJack data acquisition
instruments.  A udev rule is also included to allow unprivileged users to
communicate with the instruments via USB.")
    (license license:expat)))           ;see README

(define-public python-labjack
  (package
    (name "python-labjack")
    (version "2.0.4")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "LabJackPython" version))
              (sha256
               (base32
                "013bjqdi05vlbdqprr6kqi8gs4qhqc7rnyp1klw8k6fng77rpdzz"))))
    (build-system python-build-system)
    (arguments
     (list
      #:tests? #f                       ;no test suite
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-liblabjackusb.so
            (lambda* (#:key inputs #:allow-other-keys)
              (substitute* (find-files "." "\\.py$")
                (("ctypes.CDLL\\(\"liblabjackusb.so\"")
                 (format #f "ctypes.CDLL(~s"
                         (search-input-file inputs
                                            "lib/liblabjackusb.so")))))))))
    ;; exodriver is provided as a regular input, as only its shared object is
    ;; used, not its Python API.
    (inputs (list python-exodriver))
    (home-page "https://labjack.com/support/software/examples/ud/labjackpython")
    (synopsis "Python library for LabJack U3, U6, UE9 and U12")
    (description "This Python library allows communicating with the U3, U6,
UE9 and U12 LabJack data acquisition (DAQ) modules.")
    (license license:expat)))          ;see setup.py

(define-public python-kivy-garden
  (package
    (name "python-kivy-garden")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "kivy-garden" version))
       (sha256
        (base32 "0wkcpr2zc1q5jb0bi7v2dgc0vs5h1y7j42mviyh764j2i0kz8mn2"))))
    (build-system python-build-system)
    (arguments
     '(#:phases (modify-phases %standard-phases
                  (add-after 'install 'remove-bat-file
                    (lambda* (#:key outputs #:allow-other-keys)
                      (let ((out (assoc-ref outputs "out")))
                        (delete-file
                         (string-append out "/bin/garden.bat"))))))))
    (propagated-inputs
     (list python-requests))
    (home-page "https://github.com/kivy-garden/garden")
    (synopsis "Garden tool for Kivy flowers")
    (description
     "This package provides the @command{garden} command to install packages
for Kivy, the multitouch application platform.")
    (license license:expat)))

(define-public python-kivy
  (package
    (name "python-kivy")
    (version "2.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "Kivy" version))
       (file-name (string-append name "-" version ".tar.gz"))
       (sha256
        (base32
         "1cq4djfn7h8560mvz94dydsldg2jpp5w9rby7nafgmbh7fxg65is"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f              ; Tests require many optional packages
       #:phases
       (modify-phases %standard-phases
         (add-after 'patch-generated-file-shebangs 'set-sdl-paths
           (lambda* (#:key inputs #:allow-other-keys)
             (setenv "KIVY_SDL2_PATH"
                     (search-input-directory inputs "/include/SDL2"))))
         (add-before 'build 'set-home
           (lambda _
             ;; 'kivy/__init__.py' wants to create $HOME/.kivy.
             (setenv "HOME" (getcwd)))))))
    (native-inputs
     (list pkg-config python-cython))
    (inputs
     (list gstreamer
           mesa
           (sdl-union (list sdl2 sdl2-image sdl2-mixer sdl2-ttf))
           python-docutils
           python-kivy-garden
           python-pygments))
    (home-page "https://kivy.org")
    (synopsis "Multitouch application framework")
    (description
     "Kivy is a software library for rapid development of hardware-accelerated
multitouch applications.")
    (license license:expat)))

(define-public python-kivymd
  (package
    (name "python-kivymd")
    (version "0.104.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "kivymd" version))
       (sha256
        (base32 "04lwy6j0agrdwa4a6dl6qs97nx9ysmscmm8psvdzjpyj8aa1zg4p"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f                                ;tests require network
       #:phases
       (modify-phases %standard-phases
         (add-before 'sanity-check 'set-home
           (lambda _
             ;; 'kivy/__init__.py' wants to create $HOME/.kivy.
             (setenv "HOME" (getcwd)))))))
    (native-inputs (list python-docutils))
    (propagated-inputs
     (list python-kivy python-pillow python-pygments python-kivy-garden))
    (home-page "https://github.com/kivymd/KivyMD")
    (synopsis "Material Design compliant widgets for use with Kivy")
    (description
     "This package provides Kivy widgets that approximate Google's Material
Design spec without sacrificing ease of use or application performance.")
    (license license:expat)))

(define-public python-async-lru
  (package
    (name "python-async-lru")
    (version "2.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "async-lru" version))
       (sha256
        (base32 "09sn3bc3gc2flijm9k8kn4hmbnlkaddhqahb49izy188yrfrm9dq"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-pytest-asyncio
           python-pytest-cov
           python-pytest-timeout
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-typing-extensions))
    (home-page "https://github.com/aio-libs/async-lru")
    (synopsis "Simple LRU cache for asyncio")
    (description
     "This package is a port of Python's built-in @code{functools.lru_cache}
function for @code{asyncio}.  To better handle async behaviour, it also
ensures multiple concurrent calls will only result in 1 call to the wrapped
function, with all awaits receiving the result of that call when it
completes.")
    (license license:expat)))

(define-public python-asyncinject
  (package
    (name "python-asyncinject")
    (version "0.6")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "asyncinject" version))
       (sha256
        (base32 "0x57idiy19lzyn32klgm06r223z8gr2aqqk91gysbshq7jg8g3pf"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-pytest-asyncio
                         python-setuptools python-wheel))
    (home-page "https://github.com/simonw/asyncinject")
    (synopsis
     "Run async workflows using pytest-fixtures-style dependency injection")
    (description
     "This package lets you run asynchronous workflows using
pytest-fixtures-style dependency injection.")
    (license license:asl2.0)))

(define-public python-asynckivy
  (package
    (name "python-asynckivy")
    (version "0.5.3")
    (source
     (origin
       (method url-fetch)
       (uri
        (pypi-uri "asynckivy" version))
       (sha256
        (base32 "0ivjvch8yn3k1ybfp7c1nm8mhc0ymg7d04mq54lly7yjvg0jvcni"))))
    (build-system python-build-system)
    (arguments
       `(#:phases
         (modify-phases %standard-phases
           (add-before 'check 'set-home
             (lambda _
               ;; 'kivy/__init__.py' wants to create $HOME/.kivy.
               (setenv "HOME" (getcwd)))))))
    (propagated-inputs (list python-kivy python-asyncgui))
    (home-page "https://github.com/gottadiveintopython/asynckivy")
    (synopsis "Async library for Kivy")
    (description
     "This package provides async versions of Kivy functions to avoid the
callback-heavy mode of interaction typical in some Kivy applications.")
    (license license:expat)))

(define-public python-asyncgui
  (package
    (name "python-asyncgui")
    (version "0.5.3")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "asyncgui" version))
              (sha256
               (base32
                "0614130afg2qc1qq4p82piskvvx6lpjl4nlsakbjzdyd78xywnb7"))))
    (build-system python-build-system)
    (home-page "https://github.com/gottadiveintopython/asyncgui")
    (synopsis "Enables async/await without an event loop")
    (description "This package provides support for async/await applications
without requiring an event loop, useful for creative responsive GUIs.")
    (license license:expat)))

(define-public python-asynctest
  (package
    (name "python-asynctest")
    (version "0.13.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "asynctest" version))
              (sha256
               (base32
                "1b3zsy7p84gag6q8ai2ylyrhx213qdk2h2zb6im3xn0m5n264y62"))))
    (build-system python-build-system)
    (arguments
     ;; The test suite appears to be incompatible with Python 3.9+, completes
     ;; with 25 failures and 41 errors out of 220 tests (see:
     ;; https://github.com/Martiusweb/asynctest/issues/149).
     (list #:tests? #f
           #:phases #~(modify-phases %standard-phases
                        (replace 'check
                          (lambda* (#:key tests? #:allow-other-keys)
                            (when tests?
                              (invoke "python" "-m" "unittest" "test")))))))
    (home-page "https://github.com/Martiusweb/asynctest/")
    (synopsis "Unittest extensions for testing asyncio libraries")
    (description
     "The @code{asynctest} Python package is built on top of the standard
@code{unittest} module and cuts down boilerplate code when testing libraries
for @code{asyncio}.")
    (license license:asl2.0)))

(define-public python-binaryornot
  (package
    (name "python-binaryornot")
    (version "0.4.4")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "binaryornot" version))
              (sha256
               (base32
                "0qc006986rb6bcbmiymwgcl1mns2jphr1j7sr7nk41nlr7gh359m"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-tests
           (lambda _
             ;; TypeError: binary() got an unexpected keyword argument
             ;; 'average_size'.
             (substitute* "tests/test_check.py"
              (("average_size=512") ""))
             #t)))))
    (propagated-inputs
     (list python-chardet python-hypothesis))
    (home-page "https://github.com/audreyr/binaryornot")
    (synopsis "Package to check if a file is binary or text")
    (description "Ultra-lightweight pure Python package to check if a file is
     binary or text.")
    (license license:bsd-3)))

(define-public binwalk
  (package
    (name "binwalk")
    (version "2.3.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ReFirmLabs/binwalk")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0cfm1khckq986l0q68kmfyfagc6zmb94hgjjm847fjcil77dnlw6"))
       (modules '((guix build utils)))
       (snippet
        #~(begin
            (for-each delete-file
                      (list "testing/tests/input-vectors/firmware.zip"
                            "testing/tests/test_firmware_zip.py"))))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'check 'set-home
           (lambda _
             (setenv "HOME" ""))))))
    (native-inputs
     (list python-coverage python-nose))
    (home-page "https://github.com/ReFirmLabs/binwalk")
    (synopsis "Firmware analysis tool")
    (description "Binwalk is a tool for analyzing, reverse engineering, and
     extracting firmware images")
    (license license:expat)))

(define-public python-binwalk
  (deprecated-package "python-binwalk" binwalk))

(define-public python-bson
  (package
    (name "python-bson")
    (version "0.5.10")
    (source
     (origin
       (method git-fetch)               ;for tests
       (uri (git-reference
             (url "https://github.com/py-bson/bson")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1vpy4rsvm3hhawvbg9rbw4j36ck8qylkhm8cjy0q6imvinkd2als"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "./test.py")))))))
    (propagated-inputs (list python-dateutil python-six))
    (home-page "https://github.com/py-bson/bson")
    (synopsis "BSON (Binary JSON) codec for Python")
    (description "@code{bson} is a Python library implementing a BSON (Binary
JSON) codec.")
    (license license:asl2.0)))

(define-public python-nltk
  (package
    (name "python-nltk")
    (version "3.6.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "nltk" version ".zip"))
              (sha256
               (base32
                "1sq32lwgij9h8rsksymnxxr7bqfw3vgx5ijw4azbj6k2xnmmdmap"))))
    (build-system python-build-system)
    (arguments
     '(;; The tests require some extra resources to be downloaded.
       ;; TODO Try packaging these resources.
       #:tests? #f))
    (propagated-inputs
     (list python-click python-joblib python-regex python-tqdm))
    (native-inputs
     (list unzip))
    (home-page "http://nltk.org/")
    (synopsis "Natural Language Toolkit")
    (description "It provides interfaces to over 50 corpora and lexical
     resources such as WordNet, along with a suite of text processing libraries
     for classification, tokenization, stemming, tagging, parsing, and semantic
     reasoning, wrappers for natural language processing libraries.")
    (license license:asl2.0)))

(define-public python-pymongo
  (package
    (name "python-pymongo")
    (version "4.1.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pymongo" version))
              (sha256
               (base32
                "1m9hc2a4kgg10xy3g5x00z4a7rrk9s0rbf5qfypwnhq0kdfg5f6p"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-certifi))
    (home-page "https://github.com/mongodb/mongo-python-driver")
    (synopsis "Python driver for MongoDB")
    (description "Python driver for MongoDB.")
    (license license:asl2.0)))

(define-public python-consul
  (package
    (name "python-consul")
    (version "0.6.1")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "python-consul" version))
        (sha256
         (base32
          "0rfyxcy4cr3x848vhx876ifalxd5ghq6l5x813m49h4vq2d4jiq8"))))
    (build-system python-build-system)
    (arguments
     '(#:tests? #f)) ; The tests are not distributed
    (propagated-inputs
     (list python-requests python-six))
    (home-page "https://github.com/cablehead/python-consul")
    (synopsis "Python client for Consul")
    (description
     "Python client for @url{http://www.consul.io/,Consul}, a tool for service
     discovery, monitoring and configuration.")
    (license license:expat)))

(define-public python-schematics
  (package
    (name "python-schematics")
    (version "1.1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/schematics/schematics")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0xdqskycznqc7mfp60bhw1zq8wx7yx1dvmbq3brnm1dx3xnqa0zd"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-six))
    (arguments
     ;; The tests require a bunch of not very nice packages with fixed
     ;; version requirements (e.g. python-coveralls).
     `(#:tests? #f))
    (home-page "https://github.com/schematics/schematics")
    (synopsis "Python Data Structures for Humans")
    (description "Python Data Structures for Humans.")
    (license license:bsd-3)))

(define-public python-odfpy
  (package
    (name "python-odfpy")
    (version "1.4.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "odfpy" version))
              (sha256
               (base32
                "1v1qqk9p12qla85yscq2g413l3qasn6yr4ncyc934465b5p6lxnv"))))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "pytest" "-vv"))))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest))
    (propagated-inputs
     (list python-defusedxml))
    (home-page "https://github.com/eea/odfpy")
    (synopsis "Python API and tools to manipulate OpenDocument files")
    (description "Collection of libraries and utility programs written in
     Python to manipulate OpenDocument 1.2 files.")
    (license
     ;; The software is mainly dual GPL2+ and ASL2.0, but includes a
     ;; number of files with other licenses.
     (list license:gpl2+ license:asl2.0 license:lgpl2.1+ license:cc-by-sa3.0))))

(define-public python-namex
  (package
    (name "python-namex")
    (version "0.0.7")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "namex" version))
       (sha256
        (base32 "16ynrq245c3nywv476izrc4bcacm9gxjzgr67ng91g929ny6bfl4"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #false))  ;there are none
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/fchollet/namex")
    (synopsis
     "Separate implementation and public API surface of Python packages")
    (description
     "This package provides a simple utility to separate the
implementation of your Python package and its public API surface.")
    (license license:asl2.0)))

(define-public python-natsort
  (package
    (name "python-natsort")
    (version "7.1.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "natsort" version))
              (sha256
               (base32
                "00y49bfsi7rrsd1s42gc2w95a6arl9ipdsx2493hr0v54fj07ih0"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'remove-test-hypothesis-deadlines
           (lambda _
             (substitute* "tests/test_utils.py"
               (("from hypothesis import given")
                "from hypothesis import given, settings")
               (("( +)@given" all spaces)
                (string-append spaces "@settings(deadline=None)\n" all)))))
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest" "-v")))))))
    (native-inputs
     (list glibc-utf8-locales ;; Tests want en_US.UTF-8
           python-hypothesis
           python-pytest-cov
           python-pytest-mock
           python-pytest))
    (propagated-inputs ; TODO: Add python-fastnumbers.
     (list python-pyicu))
    (home-page "https://github.com/SethMMorton/natsort")
    (synopsis "Natural sorting for python and shell")
    (description
     "Natsort lets you apply natural sorting on lists instead of
lexicographical.  If you use the built-in @code{sorted} method in python on a
list such as @code{[@code{a20}, @code{a9}, @code{a1}, @code{a4}, @code{a10}]},
it would be returned as @code{[@code{a1}, @code{a10}, @code{a20}, @code{a4},
@code{a9}]}.  Natsort provides a function @code{natsorted} that identifies
numbers and sorts them separately from strings.  It can also sort version
numbers, real numbers, mixed types and more, and comes with a shell command
@command{natsort} that exposes this functionality in the command line.")
    (license license:expat)))

(define-public glances
  (package
  (name "glances")
  (version "4.1.1")
  (source
    (origin
      (method url-fetch)
      (uri (pypi-uri "glances" version))
      (sha256
        (base32 "10yjwbmwv2x4x1n3hr1631m8l6l9w8fa7rnvfz1vmzkjs199ihib"))
      (modules '((guix build utils)))
      (snippet
       '(begin
          ;; Glances phones PyPI for weekly update checks by default.
          ;; Disable these.  The user can re-enable them if desired.
          (substitute* "glances/outdated.py"
            (("^(.*)self\\.load_config\\(config\\)\n" line indentation)
             (string-append indentation
                            "self.args.disable_check_update = True\n"
                            line)))
          #t))))
  (build-system python-build-system)
  (propagated-inputs
   (list python-defusedxml python-orjson python-packaging python-psutil))
  (home-page "https://github.com/nicolargo/glances")
  (synopsis "Cross-platform curses-based monitoring tool")
  (description
    "Glances is a curses-based monitoring tool for a wide variety of platforms.
     Glances uses the PsUtil library to get information from your system.  It
     monitors CPU, load, memory, network bandwidth, disk I/O, disk use, and more.")
  (license license:lgpl3+)))

(define-public python-graphql-core
  (package
    (name "python-graphql-core")
    (version "3.1.2")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "graphql-core" version))
        (sha256
         (base32
          "0fjv5w2wvgdr8gb27v241bavliipyir9fdz48rsgc3xapm644mn0"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'use-poetry-core
           (lambda _
             ;; Patch to use the core poetry API.
             (substitute* "pyproject.toml"
               (("poetry.masonry.api")
                "poetry.core.masonry.api")
               ;; Poetry does not like line breaks.
               (("description = \"\"\"")
                "description = \"GraphQL-core is a Python port of GraphQL.js.\"\n")
               (("^GraphQL-core is a Python.*") "")
               (("^ the JavaScript reference.*") ""))))
         (add-after 'unpack 'patch-setup.py
           (lambda _
             (substitute* "setup.py"
               ;; Relax hardcoded version
               (("'gevent==1.1rc1'") "'gevent'")
               ;; Poetry complains about this line break.
               (("a port of GraphQL.js,\"")
                (string-append "a port of GraphQL.js, "
                               "the JavaScript reference implementation for GraphQL."))
               (("    \" the JavaScript reference.*") "")))))))
    (native-inputs
     (list python-gevent
           python-mock
           python-poetry-core
           python-pytest
           python-pytest-benchmark
           python-pytest-mock))
    (propagated-inputs
     (list python-promise python-six))
    (home-page "https://github.com/graphql-python/graphql-core")
    (synopsis "GraphQL implementation for Python")
    (description
     "GraphQL implementation for Python.  GraphQL is a data query language and
     runtime designed and used to request and deliver data to mobile and web apps.
     This library is a port of @url{https://github.com/graphql/graphql-js,graphql-js}
     to Python.")
    (license license:expat)))

(define-public python-graphql-relay
  (package
    (name "python-graphql-relay")
    (version "3.1.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "graphql-relay" version))
        (sha256
         (base32
          "1d70vwam9gjhx7fqzsa03x7lc6ivcqki5r9pk8m7rslmb7pagmbh"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest" "tests")))))))
    (native-inputs
     (list
       python-pytest
       python-pytest-asyncio))
    (propagated-inputs
     (list python-graphql-core))
    (home-page "https://github.com/graphql-python/graphql-relay-py")
    (synopsis "Relay implementation for Python")
    (description
     "This is a library to allow the easy creation of Relay-compliant servers
     using the GraphQL Python reference implementation of a GraphQL server.  It
     should be noted that the code is a exact port of the original
     @url{https://github.com/graphql/graphql-relay-js,graphql-relay js implementation}
     from Facebook.")
    (license license:expat)))

(define-public python-graphene
  (package
    (name "python-graphene")
    (version "3.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "graphene" version))
        (sha256
         (base32
          "08m1n2ydk48c18cvl8474v3pwwacjl1vgq61m9qs00122mp0cj5g"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-graphql-core python-graphql-relay python-aniso8601
           python-promise python-six))
    (arguments
     `(#:tests? #f))                    ; no tests/ in the PyPI tarball
    (home-page "https://graphene-python.org/")
    (synopsis "GraphQL Framework for Python")
    (description
     "Graphene is a Python library for building GraphQL schemas/types.
     A GraphQL schema describes your data model, and provides a GraphQL server
     with an associated set of resolve methods that know how to fetch data.")
    (license license:expat)))

(define-public python-random2
  (package
    (name "python-random2")
    (version "1.0.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "random2" version ".zip"))
              (sha256
               (base32
                "01y0s4747plsx8fdnxy0nz83dp69naddz58m81r9h0s1qfm31b9l"))
              (patches
               (search-patches "python-random2-getrandbits-test.patch"))))
    (build-system python-build-system)
    (native-inputs (list unzip))
    (home-page "https://pypi.python.org/pypi/random2")
    (synopsis "Python 3 version of the Python 2 @code{random} module")
    (description
     "This package provides a Python 3 ported version of Python 2.7’s
     @code{random} module.  It has also been back-ported to work in Python 2.6.

     In Python 3, the implementation of @code{randrange()} was changed, so that
     even with the same seed you get different sequences in Python 2 and 3.

     This package closes that gap, allowing stable random number generation
     between the different Python versions.")
    (license license:psfl)))

;; XXX: The last time updated in 2015, consider to remove it when nothing is
;; depend on it.
(define-public python-snowballstemmer
  (package
    (name "python-snowballstemmer")
    (version "2.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "snowballstemmer" version))
       (sha256
        (base32 "1ccwy75i0f5yi1vy6fyvr1gf43ydhjani45mswm43ls7hpmnvc89"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #f)) ; no tests
    (native-inputs
     (list python-setuptools
           python-wheel))
    (home-page "https://github.com/shibukawa/snowball_py")
    (synopsis "Snowball stemming library collection for Python")
    (description
     "This package provides 16 word stemmer algorithms generated from Snowball
algorithms.  It includes the 15 original ones plus the Poerter English
stemmer.")
    (license license:bsd-3)))

(define-public python-setproctitle
  (package
    (name "python-setproctitle")
    (version "1.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "setproctitle" version))
       (sha256
        (base32
         "1zbp6kyzfbrmbh9j3idai0mnpa28zn5db3k5l07jc3c3gj89gyxr"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (setenv "PYTHON" (or (which "python3") (which "python")))
             (setenv "PYCONFIG" (if (which "python3-config")
                                    "python3-config --embed"
                                    "python-config"))
             (substitute* "tests/conftest.py"
               (("cc") "gcc"))
             (when tests?
               (invoke "pytest" "tests/")))))))
    (native-inputs
     (list procps python-pytest))   ; required for tests
    (home-page "https://github.com/dvarrazzo/py-setproctitle")
    (synopsis
     "Setproctitle implementation for Python to customize the process title")
    (description "The library allows a process to change its title (as displayed
by system tools such as @code{ps} and @code{top}).

Changing the title is mostly useful in multi-process systems, for example when a
master process is forked: changing the children's title allows identifying the
task each process is busy with.  The technique is used by PostgreSQL and the
OpenSSH Server for example.")
    (license license:bsd-3)))

(define-public python-pyelftools
  (package
    (name "python-pyelftools")
    (version "0.30")
    (home-page "https://github.com/eliben/pyelftools")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference (url home-page)
                           (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0gk47mq5cqv6qz35aydn67wma5m70gv5f9f6pg38zny6vsfavmq3"))
       (snippet
        ;; Delete bundled readelf executable.
        '(delete-file "test/external_tools/readelf"))))
    (build-system python-build-system)
    (arguments
     '(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (when tests?
                        ;; Taken from tox.ini.
                        (invoke "python" "test/run_all_unittests.py")
                        (invoke "python" "test/run_examples_test.py")
                        (invoke "python" "test/run_readelf_tests.py")))))))
    (synopsis
     "Analyze binary and library file information")
    (description "This Python library provides interfaces for parsing and
analyzing two binary and library file formats ; the Executable and Linking
Format (ELF), and debugging information in the Debugging With Attributed
Record Format (DWARF).")
    (license license:public-domain)))

(define-public python-pefile
  (package
    (name "python-pefile")
    (version "2022.5.30")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/erocarrera/pefile")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1qj90a0s2gd5hn2zggypqc1077inid5dcl1fp5973b04kf2b9z8a"))))
    (build-system python-build-system)
    (propagated-inputs (list python-future))
    (home-page "https://github.com/erocarrera/pefile")
    (synopsis "Portable Executable (PE) file parser")
    (description "This python library provides interfaces for parsing and
working with Portable Executable (PE) files.  It makes to most information
from the header, as well as section details and data available.")
    (license license:expat)))

(define-public python-imagesize
  (package
    (name "python-imagesize")
    (version "1.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "imagesize" version))
       (sha256
        (base32
         "0jndjx26p8qibrx997p3kb6vfbqbdxkv74jsrkav177vmx2085b9"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/shibukawa/imagesize_py")
    (synopsis "Gets image size of files in various formats in Python")
    (description
     "This package allows determination of image size from PNG, JPEG,
JPEG2000 and GIF files in pure Python.")
    (license license:expat)))

(define-public python-termstyle
  (package
    (name "python-termstyle")
    (version "0.1.11")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "termstyle" version))
        (sha256
          (base32
            "17wzkkcqy5zc0g68xlad3kcv66iw14d2pwqc0h9420gak0vbhx7g"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "python" "test3.py"))))))
    (home-page "https://github.com/gfxmonk/termstyle")
    (synopsis "Console text coloring for Python")
    (description "This package provides console text coloring for Python.")
    (license license:bsd-3)))

(define-public python-argcomplete
  (package
    (name "python-argcomplete")
    (version "3.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "argcomplete" version))
       (sha256
        (base32
         "18h023ma2m2gw8w8dm2pvv4k0vpli94293jl57p2ch4vln79xr7k"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               ;; pip: command not found
               (substitute* "test/test.py"
                 (("def test_console_script")
                  "def __disable_test_console_script"))
               (invoke "python3" "./test/test.py" "-v")))))))
    (native-inputs
     (list python-coverage
           python-mypy
           python-pexpect
           python-setuptools
           python-setuptools-scm
           python-wheel
           tcsh
           fish
           bash  ;full Bash for 'test_file_completion'
           zsh))
    (home-page "https://github.com/kislyuk/argcomplete")
    (synopsis "Shell tab completion for Python argparse")
    (description "argcomplete provides extensible command line tab completion
of arguments and options for Python scripts using @code{argparse}.  It's
particularly useful for programs with many options or sub-parsers that can
dynamically suggest completions ; for example, when browsing resources over
the network.")
    (license license:asl2.0)))

(define-public python-csscompressor
  (package
    (name "python-csscompressor")
    (version "0.9.5")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "csscompressor" version))
        (sha256
         (base32
          "018ssffvlpnc1salmnpyl52c11glzzwj4k9f757hl4pkpjnjp8mg"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "py.test"))))))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/sprymix/csscompressor")
    (synopsis "Python port of YUI CSS Compressor")
    (description
     "This package provides a python port of YUI CSS Compressor.")
    (license license:bsd-3)))

(define-public python-rcssmin
  (package
    (name "python-rcssmin")
    (version "1.2.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "rcssmin" version))
        (sha256
         (base32
          "0k68sw163vc36nb3nck0kwwal4vb4hi6634rzx7z19ng28j8fdpl"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "http://opensource.perlig.de/rcssmin/")
    (synopsis "CSS Minifier")
    (description "The minifier is based on the semantics of the YUI compressor,
     which itself is based on the rule list by Isaac Schlueter.")
    (license license:asl2.0)))

(define-public python-rjsmin
  (package
    (name "python-rjsmin")
    (version "1.2.3")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "rjsmin" version))
        (sha256
         (base32
          "1ihcff58vz4xrv1180v46wy5m80z61y7ab8ajyy4zh54jcjbb20k"))
        (modules '((guix build utils)))
        (snippet
         '(for-each delete-file (find-files "bench" "\\.js$")))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest python-setuptools python-wheel))
    (home-page "http://opensource.perlig.de/rjsmin/")
    (synopsis "Javascript Minifier")
    (description "@code{rJSmin} is a javascript minifier written in Python.
The minifier is based on the semantics of jsmin.c by Douglas Crockford.  The
module is a re-implementation aiming for speed, so it can be used at
runtime (rather than during a preprocessing step).")
    (license license:asl2.0)))

(define-public python-xopen
  (package
    (name "python-xopen")
    (version "1.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "xopen" version))
       (sha256
        (base32
         "17qda88irg77qdm2kkxq4zgdhwfgykcpdgd4cx3xfpp9k219q7wh"))))
    (build-system pyproject-build-system)
    (propagated-inputs
     (list pigz python-isal python-typing-extensions))
    (native-inputs
     (list python-pytest python-pytest-timeout python-setuptools-scm
           python-setuptools python-wheel))
    (home-page "https://github.com/marcelm/xopen/")
    (synopsis "Open compressed files transparently")
    (description "This module provides an @code{xopen} function that works
like Python's built-in @code{open} function, but can also deal with compressed
files.  Supported compression formats are gzip, bzip2 and, xz, and are
automatically recognized by their file extensions.  The focus is on being as
efficient as possible on all supported Python versions.")
    (license license:expat)))

(define-public python-cheetah
  (package
    (name "python-cheetah")
    (version "3.3.1")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "CT3" version))
        (sha256
          (base32
           "1j36vampqip18jx0jzngb9rnkhhhl8hqnscg117y0d6cgrgm57qw"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (add-after 'unpack 'use-absolute-python
                    (lambda _
                      (substitute* "Cheetah/CheetahWrapper.py"
                        (("#!/usr/bin/env python")
                         (string-append "#!" (which "python"))))))
                  (add-after 'unpack 'fix-tests
                    (lambda _
                      (substitute* "Cheetah/Tests/ImportHooks.py"
                        (("os.path.dirname\\(__file__\\)")
                         (string-append "'" (getcwd) "/Cheetah/Tests'")))))
                  (replace 'check
                    (lambda _
                      (setenv "TMPDIR" "/tmp")
                      (substitute* "Cheetah/Tests/Test.py"
                        (("unittest.TextTestRunner\\(\\)")
                         "unittest.TextTestRunner(verbosity=2)"))

                      (invoke "python" "Cheetah/Tests/Test.py"))))))
    (propagated-inputs
     (list python-markdown))    ;optional
    (home-page "https://cheetahtemplate.org/")
    (synopsis "Template engine")
    (description "Cheetah is a text-based template engine and Python code
     generator.

     Cheetah can be used as a standalone templating utility or referenced as
     a library from other Python applications.  It has many potential uses,
     but web developers looking for a viable alternative to ASP, JSP, PHP and
     PSP are expected to be its principle user group.

     Features:
     @enumerate
     @item Generates HTML, SGML, XML, SQL, Postscript, form email, LaTeX, or any other
     text-based format.
     @item Cleanly separates content, graphic design, and program code.
     @item Blends the power and flexibility of Python with a simple template language
     that non-programmers can understand.
     @item Gives template writers full access to any Python data structure, module,
     function, object, or method in their templates.
     @item Makes code reuse easy by providing an object-orientated interface to
     templates that is accessible from Python code or other Cheetah templates.
     One template can subclass another and selectively reimplement sections of it.
     @item Provides a simple, yet powerful, caching mechanism that can dramatically
     improve the performance of a dynamic website.
     @item Compiles templates into optimized, yet readable, Python code.
     @end enumerate")
    (license (license:x11-style "file://LICENSE"))))

(define-public python-chevron
  (package
    (name "python-chevron")
    (version "0.14.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "chevron" version))
              (sha256
               (base32
                "1gqfh00ics2k1sm5g46l3bi8cl5fc5d1cwzh1ylvcxvdvypklqc7"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #false)) ;there are none
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/noahmorrison/chevron")
    (synopsis "Mustache templating language renderer")
    (description "This package provides a Python implementation of the
Mustache templating language renderer.")
    (license license:expat)))

;; XXX: Try to inherit from duckdb and build from source with all extensions.
(define-public python-duckdb
  (package
    (name "python-duckdb")
    (version "1.0.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "duckdb" version))
              (sha256
               (base32
                "0lyl6di1c7j31i2mk384j711kzyyf9rjd3nqx5mbgmf7gfvmk852"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "--ignore=tests/slow/test_h2oai_arrow.py"
              ;; Do not relay on mypy.
              "--ignore=tests/stubs/test_stubs.py"
              "-k" (string-append
                    ;; Don't install anything, thank you.
                    "not test_install_non_existent_extension"
                    ;; See <https://github.com/duckdb/duckdb/issues/11961>.
                    " and not test_fetchmany"
                    ;; See <https://github.com/duckdb/duckdb/issues/10702>.
                    " and not test_connection_interrupt"
                    " and not test_query_interruption"))
      #:phases
      #~(modify-phases %standard-phases
          ;; Tests need this
          (add-before 'check 'set-HOME
            (lambda _ (setenv "HOME" "/tmp")))
          (add-before 'build 'set-version
            (lambda _
              (setenv "SETUPTOOLS_SCM_PRETEND_VERSION" #$version)
              (substitute* "setup.py"
                (("\"setuptools_scm<7.0.0\",") ""))))
          ;; Later versions of pybind replace "_" with "const_name".
          (add-after 'unpack 'pybind-compatibility
            (lambda _
              (with-directory-excursion "src/include/duckdb_python"
                (substitute* '("python_objects.hpp"
                               "pyfilesystem.hpp"
                               "pybind11/conversions/pyconnection_default.hpp")
                  (("const_name") "_"))))))))
    (propagated-inputs
     (list python-adbc-driver-manager))
    (native-inputs
     (list pybind11
           python-fsspec
           python-google-cloud-storage
           python-numpy
           python-pandas
           python-psutil
           python-pyarrow
           python-pytest
           python-pytest-runner
           python-setuptools-scm
           python-setuptools
           python-wheel))
    (home-page "https://www.duckdb.org")
    (synopsis "DuckDB embedded database")
    (description "DuckDB is an in-process SQL OLAP database management
system.")
    (license license:expat)))

(define-public python-dulwich
  (package
    (name "python-dulwich")
    (version "0.21.7")
    (source
     (origin
       (method url-fetch)
       (uri (list (string-append "https://www.dulwich.io/releases/"
                                 "dulwich-" version ".tar.gz")
                  (pypi-uri "dulwich" version)))
       (sha256
        (base32
         "0s79c3g19m052jbxm66amxv5v60ijx5px4hjmk1q19ff6dlcdsd9"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; DULWICH_SWIFT_CFG is not set.
      '(list "--ignore=dulwich/contrib/test_swift_smoke.py"
             "-k"
             ;; 'HTTPClient' object has no attribute 'get_base_url'
             "not test_init_connector")
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'fix-tests
           (lambda* (#:key inputs #:allow-other-keys)
             (substitute* '("dulwich/tests/test_repository.py"
                            "dulwich/tests/test_porcelain.py"
                            "dulwich/tests/test_hooks.py")
               (("/bin/sh") (search-input-file inputs "/bin/sh")))))
         (add-before 'check 'pre-check
           (lambda _ (setenv "PYTHONHASHSEED" "random"))))))
    (propagated-inputs
     (list python-fastimport python-urllib3))
    (native-inputs
     (list gnupg
           git-minimal/pinned
           python-geventhttpclient
           python-mypy
           python-paramiko
           python-pytest
           python-requests
           python-setuptools
           python-wheel))
    (home-page "https://www.dulwich.io/")
    (synopsis "Git implementation in Python")
    (description "Dulwich is an implementation of the Git file formats and
protocols written in pure Python.")
    ;; Can be used with either license.
    (license (list license:asl2.0 license:gpl2+))))

(define-public python-dunamai
  (package
    (name "python-dunamai")
    (version "1.21.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "dunamai" version))
       (sha256
        (base32 "1i35i8ym6n8mpgrq31hivrvfciy12gv26jwlzimmkx9jy2spz0h5"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "-k" "not test__version__from_git__shallow")
      #:phases
      #~(modify-phases %standard-phases
          ;; These steps are taked from NixOS package definition:
          ;; nixpkgs/pkgs/development/python-modules/dunamai/default.nix
          (add-before 'check 'pre-check
            (lambda _
              (setenv "PATH" (string-append #$output "/bin:" (getenv "PATH")))
              (setenv "HOME" "/tmp")
              (invoke "git" "config" "--global" "user.email" "nobody@example.com")
              (invoke "git" "config" "--global" "user.name" "Nobody"))))))
    (propagated-inputs
     (list python-packaging))
    (native-inputs
     (list git-minimal
           python-poetry-core
           python-pytest))
    (home-page "https://github.com/mtkennerly/dunamai")
    (synopsis "Dynamic version generation")
    (description
     "Dunamai is Python library and command line tool for producing dynamic,
standards-compliant version strings, derived from tags in your version control
system.  This facilitates uniquely identifying nightly or per-commit builds in
continuous integration and releasing new versions of your software simply by
creating a tag.")
    (license license:expat)))

(define-public python-pbkdf2
  (package
    (name "python-pbkdf2")
    (version "1.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pbkdf2" version))
       (sha256
        (base32
         "0yb99rl2mbsaamj571s1mf6vgniqh23v98k4632150hjkwv9fqxc"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             (invoke "python" "test/test_pbkdf2.py"))))))
    (home-page "https://www.dlitz.net/software/python-pbkdf2/")
    (synopsis "Password-based key derivation")
    (description "This module implements the password-based key derivation
     function, PBKDF2, specified in RSA PKCS#5 v2.0.

     PKCS#5 v2.0 Password-Based Key Derivation is a key derivation function which
     is part of the RSA Public Key Cryptography Standards series.  The provided
     implementation takes a password or a passphrase and a salt value (and
                                                                       optionally a iteration count, a digest module, and a MAC module) and provides
     a file-like object from which an arbitrarily-sized key can be read.")
    (license license:expat)))

(define-public python-qrcode
  (package
    (name "python-qrcode")
    (version "7.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "qrcode" version))
       (sha256
        (base32 "0y35jlwfvkgn9341lzshyaqgpp61vysjh107vhdd96ya83r6ynip"))))
    (build-system python-build-system)
    (arguments
     ;; FIXME: Tests require packaging 'pymaging'.
     '(#:tests? #f))
    (propagated-inputs
     (list python-lxml ; for SVG output
           python-pillow)) ; for PNG output
    (home-page "https://github.com/lincolnloop/python-qrcode")
    (synopsis "QR Code image generator")
    (description "This package provides a pure Python QR Code generator
     module.  It uses the Python Imaging Library (PIL) to allow for the generation
     of QR Codes.

     In addition this package provides a command line tool to generate QR codes and
     either write these QR codes to a file or do the output as ascii art at the
     console.")
    (license license:bsd-3)))

(define-public python-rst2ansi
  (package
    (name "python-rst2ansi")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "rst2ansi" version))
       (sha256
        (base32
         "0vzy6gd60l79ff750scl0sz48r1laalkl6md6dwzah4dcadgn5qv"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-docutils))
    (home-page "https://github.com/Snaipe/python-rst-to-ansi")
    (synopsis "Convert RST to ANSI-decorated console output")
    (description
     "Python module dedicated to rendering RST (reStructuredText) documents
     to ansi-escaped strings suitable for display in a terminal.")
    (license license:expat)))

(define-public python-ansi2html
  (package
    (name "python-ansi2html")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ansi2html" version))
       (sha256
        (base32
         "1wa00zffprb78w1mqq90dk47czz1knanys2a40zbw2vyapd5lp9y"))))
    (build-system python-build-system)
    (native-inputs
     (list python-mock python-nose))
    (propagated-inputs
     (list python-six))
    (home-page "https://github.com/ralphbean/ansi2html")
    (synopsis "Convert ANSI-decorated console output to HTML")
    (description
     "@command{ansi2html} is a Python library and command line utility for
     converting text with ANSI color codes to HTML or LaTeX.")
    (license license:gpl3+)))

(define-public python-easy-ansi
  (package
    (name "python-easy-ansi")
    (version "0.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.com/joeysbytes/easy-ansi")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0albh55ynzs98qy9pln4qaxw5qhhh3lk09jy9bx19gycrp1c3lc3"))))
    (build-system python-build-system)
    (home-page "https://gitlab.com/joeysbytes/easy-ansi")
    (synopsis "Terminal framework API")
    (description
     "Easy ANSI is a terminal framework API to give you an easy way to use
     colors, cursor control movements, and line/box drawing.  It is not meant as a
     replacement to more full-featured frameworks (such as curses or urwid), but as
     a tool to quickly create nice-looking screens in your terminal window.  You
     can even create animations with the cursor controls.")
    (license license:expat)))

(define-public python-ddt
  (package
    (name "python-ddt")
    (version "1.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ddt" version))
       (sha256
        (base32 "0jz0lglz5z5clsbralbpmd1hxs4ndb6ls7lvl7216c4nhfqdc5fj"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-aiounittest
           python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-pyyaml))
    (home-page "https://github.com/datadriventests/ddt")
    (synopsis "Data-Driven Tests")
    (description
     "Data-Driven Tests (@dfn{DDT}) allow you to multiply one test case by
running it with different test data, and make it appear as multiple test
cases.")
    (license license:expat)))

(define-public python-pycountry
  (package
    (name "python-pycountry")
    (version "22.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pycountry" version))
       (sha256
        (base32
         "0ihnkh86zz01vi46gcwgq6h71jrpj7hq71zi13c98n2qdhj3l5mj"))))
    (build-system python-build-system)
    (home-page "https://bitbucket.org/flyingcircus/pycountry")
    (synopsis "ISO databases for languages, countries, currencies, etc.")
    (description
     "@code{pycountry} provides the ISO databases for the standards:
     @enumerate
     @item 639-3 (Languages)
     @item 3166 (Countries)
     @item 3166-3 (Deleted Countries)
     @item 3166-2 (Subdivisions of countries)
     @item 4217 (Currencies)
     @item 15924 (Scripts)
     @end enumerate
     It includes a copy from Debian’s pkg-isocodes and makes the data accessible
     through a Python API.")
    (license license:lgpl2.1+)))

(define-public python-pycountry@20.7.3
  (package
    (inherit python-pycountry)
    (name "python-pycountry")
    (version "20.7.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pycountry" version))
       (sha256
        (base32 "0hnbabsmqimx5hqh0jbd2f64i8fhzhhbrvid57048hs5sd9ll241"))))))

(define-public python-pycosat
  (package
    (name "python-pycosat")
    (version "0.6.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pycosat" version ".zip"))
       (sha256
        (base32
         "1vg0f2fwcybpdqv92z0hwdl603n2safh3fqvjjxkksd78r4qg6ac"))))
    ;; TODO: Unundle picosat. http://fmv.jku.at/picosat/
    (build-system python-build-system)
    (native-inputs
     (list unzip))
    (home-page "https://github.com/ContinuumIO/pycosat")
    (synopsis "Bindings to picosat (a SAT solver)")
    (description
     "This package provides efficient Python bindings to @code{picosat} on
     the C level.  When importing pycosat, the @code{picosat} solver becomes part
     of the Python process itself.  @code{picosat} is a @dfn{Boolean Satisfiability
                                                                     Problem} (SAT) solver.")
    (license license:expat)))

(define-public python-pypeg2
  (package
    (name "python-pypeg2")
    (version "2.15.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyPEG2" version))
       (sha256
        (base32
         "0v8ziaam2r637v94ra4dbjw6jzxz99gs5x4i585kgag1v204yb9b"))))
    (build-system python-build-system)
    (propagated-inputs (list python-lxml))
    (arguments
     ;;https://bitbucket.org/fdik/pypeg/issues/36/test-failures-on-py35
     '(#:tests? #f))
    (home-page "https://fdik.org/pyPEG/")
    (synopsis "Parsing Expression Grammars in Python")
    (description "PyPEG is an intrinsic parser interpreter framework for
     Python.  It is based on Parsing Expression Grammars, PEG.  With pyPEG you can
     parse many formal languages.")
    (license license:gpl2)))

(define-public python-pyformlang
  (package
    (name "python-pyformlang")
    (version "1.0.10")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyformlang" version))
       (sha256
        (base32 "0szgy4pqfixmswjs37qgma4qa3bsadpp3l1xflrpfi10aa8hh2sp"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-networkx
           python-numpy
           python-pydot))
    (home-page "https://github.com/Aunsiels/pyformlang")
    (synopsis "Framework for interacting with formal grammars")
    (description
     "This package provides a framework for working with formal
language grammars.  The library was originally developed for educational
purposes and therefore implements many textbook algorithms regarding the
manipulation and interaction with formal grammars.")
    (license license:expat)))

(define-public python-incremental
  (package
    (name "python-incremental")
    (version "24.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "incremental" version))
       (sha256
        (base32
         "1jb4skmy8awix345jk2pnar0sxmrf1gvn3kg9xyyivv0xr3iskzv"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; Tests require twisted, which needs this package.
      #:tests? #false
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'patch-build-system
           (lambda _
             (substitute* "pyproject.toml"
               (("^backend-path.*") "")
               (("^build-backend.*")
                "build-backend = 'setuptools.build_meta'\n")))))))
    (native-inputs (list python-pytest
                         python-setuptools
                         python-wheel))
    (propagated-inputs (list python-tomli))
    (home-page "https://github.com/hawkowl/incremental")
    (synopsis "Library for versioning Python projects")
    (description "Incremental is a small library that versions your Python
     projects.")
    (license license:expat)))

(define-public python-invoke
  (package
    (name "python-invoke")
    (home-page "https://www.pyinvoke.org/")
    (version "1.6.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "invoke" version))
              (sha256
               (base32
                "1lsql9daabfr31c7syva5myc5bka45k57ygs9fliv63qrwp1wk9p"))))
    (build-system python-build-system)
    (arguments
     ;; XXX: Requires many dependencies that are not yet in Guix.
     `(#:tests? #f
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'delete-python2-code
           (lambda _
             (delete-file-recursively "invoke/vendor/yaml2")))
         (add-after 'unpack 'fix-bash-path
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((bash (assoc-ref inputs "bash")))
               (substitute* "invoke/config.py"
                 (("shell = \"/bin/bash\"")
                  (string-append "shell = \"" bash "/bin/bash\"")))))))))
    (inputs
     `(("bash" ,bash-minimal)))
    (synopsis "Pythonic task execution")
    (description
     "Invoke is a Python task execution tool and library, drawing inspiration
     from various sources to arrive at a powerful and clean feature set.  It is
     evolved from the Fabric project, but focuses on local and abstract concerns
     instead of servers and network commands.")
    (license license:bsd-3)))

(define-public python-automat
  (package
    (name "python-automat")
    (version "24.8.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "Automat" version))
              (sha256
               (base32
                "123d63k8wg9pfv9j7hr0kd1kw23m0rwdx7irsa55ncpncg7jfhmk"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? test-flags #:allow-other-keys)
              (with-directory-excursion #$output
                (apply invoke "pytest" "-vv" test-flags))))
          ;; Remove script, because it depends on python-twisted.
          (add-after 'unpack 'remove-entrypoint
            (lambda _
              (substitute* "pyproject.toml"
                (("automat-visualize = \"automat._visualize:tool\"") "")))))))
    (native-inputs
     (list python-pytest python-setuptools python-setuptools-scm python-wheel))
    (propagated-inputs
     (list python-graphviz python-typing-extensions))
    (home-page "https://github.com/glyph/Automat")
    (synopsis "Self-service finite-state machines")
    (description "Automat is a library for concise, idiomatic Python
     expression of finite-state automata (particularly deterministic finite-state
                                                       transducers).")
    (license license:expat)))

(define-public python-constantly
  (package
    (name "python-constantly")
    (version "15.1.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "constantly" version))
              (sha256
               (base32
                "0dgwdla5kfpqz83hfril716inm41hgn9skxskvi77605jbmp4qsq"))))
    (build-system python-build-system)
    (home-page "https://github.com/twisted/constantly")
    (synopsis "Symbolic constants in Python")
    (description "Constantly is a Python library that provides symbolic
     constant support.  It includes collections and constants with text, numeric,
     and bit flag values.")
    (license license:expat)))

(define-public python-attrdict3
  (package
    (name "python-attrdict3")
    (version "2.0.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "attrdict3" version))
              (sha256
               (base32
                "1s2z6c9jam5azm746l49wsqsyi29zbbrknq1axsw230jl4f1fk00"))))
    (build-system python-build-system)
    ;; The package is no longer maintained and tests need some work.
    (arguments '(#:tests? #f))
    (propagated-inputs (list python-six))
    (home-page "https://github.com/pirofti/AttrDict3")
    (synopsis "Attribute-style access dictionaries")
    (description
     "This package provides mapping objects whose elements can be accessed
both as keys and as attributes.")
    (license license:expat)))

(define-public python-attrs
  (package
    (name "python-attrs")
    (version "24.2.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "attrs" version))
              (sha256
               (base32
                "0ik35wvcmapzhyzvwhlsrk53pgxnswh3zh5fkdb8dc5m928ipysw"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'remove-test-hypothesis-deadlines
           (lambda _
             (substitute* "tests/test_make.py"
               (("assume, given") "assume, given, settings")
               (("( +)@given" all spaces)
                (string-append spaces "@settings(deadline=None)\n" all))))))))
    (native-inputs
     (list python-hatchling
           python-hatch-fancy-pypi-readme
           python-hatch-vcs
           python-pympler
           python-pytest
           python-pytest-xdist
           python-zope-interface))
    (home-page "https://github.com/python-attrs/attrs/")
    (synopsis "Attributes without boilerplate")
    (description "@code{attrs} is a Python package with class decorators that
     ease the chores of implementing the most common attribute-related object
     protocols.")
    (license license:expat)))

(define-public python-attrs-bootstrap
  (package
    (inherit python-attrs)
    (name "python-attrs-bootstrap")
    (native-inputs (list python-hatchling
                         python-hatch-fancy-pypi-readme
                         python-hatch-vcs))
    (arguments `(#:tests? #f))))

(define-public python-cliapp
  (package
    (name "python-cliapp")
    (version "1.20180812.1")
    (source
     (origin
       (method url-fetch)
       (uri (string-append
             "http://git.liw.fi/cgi-bin/cgit/cgit.cgi/cliapp/snapshot/cliapp-"
             version ".tar.gz"))
       (sha256
        (base32
         "1c1jlblbns8qhiaqjpg4xi6lip8xwfc5w643p43rg543havaj45x"))))
    (build-system python-build-system)
    (arguments
     `(;; XXX: The tests only do style and coverage checks, which
       ;; fails due to deprecation warnings, etc.
       #:tests? #f))
    (native-inputs
     (list python-coverage-test-runner python-pep8))
    (propagated-inputs
     (list python-pyaml))
    (home-page "https://liw.fi/cliapp/")
    (synopsis "Python framework for command line programs")
    (description "@code{cliapp} is a Python framework for command line
     programs.  It contains the typical stuff such programs need to do, such
     as parsing the command line for options, and iterating over input files.")
    (license license:gpl2+)))

(define-public python-ttystatus
  (package
    (name "python-ttystatus")
    (version "0.38")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "http://git.liw.fi/ttystatus")
             ;; There are no tags after ttystatus-0.36.
             (commit "e9fc573326c5d1348f5fe56263b4f7a8c32f58c9")))
       (sha256
        (base32 "0v49q839nrwdm19c83wfmj6n2kw80xslwq9k0n5509r2h7wzjiqj"))
       (file-name (git-file-name name version))))
    (build-system python-build-system)
    (native-inputs
     (list python-coverage-test-runner python-pep8))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         ;; check phase needs to be run before the build phase. If not,
         ;; coverage-test-runner looks for tests for the built source files,
         ;; and fails.
         (delete 'check)
         (add-before 'build 'check
           (lambda _ (invoke "make" "check"))))))
    (home-page "https://liw.fi/ttystatus/")
    (synopsis "Python library for progress reporting and
     status updates on terminals")
    (description "@code{ttystatus} is a Python library for showing progress
     reporting and status updates on terminals, for command line programs.
     Output is automatically adapted to the width of the terminal: truncated
     if it does not fit, and resized if the terminal size changes.")
    (license license:gpl3+)))

(define-public python-astroid
  (package
    (name "python-astroid")
    (version "3.3.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/PyCQA/astroid")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "16cnfis2d0cyqxxx7iqi3n7ljhd55yv9v9yl1kl59k4a5jg4cnpx"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-lazy-object-proxy
           python-typing-extensions
           python-wrapt))
    (home-page "https://github.com/PyCQA/astroid")
    (synopsis "Python source code base representation")
    (description "@code{python-astroid} provides a common base representation
of Python source code for projects such as pychecker, pyreverse, pylint, etc.
It provides a compatible representation which comes from the _ast module.  It
rebuilds the tree generated by the builtin _ast module by recursively walking
down the AST and building an extended ast.  The new node classes have
additional methods and attributes for different usages.  They include some
support for static inference and local name scopes.  Furthermore, astroid
builds partial trees by inspecting living objects.")
    (license license:lgpl2.1+)))

(define-public python-isbnlib
  (package
    (name "python-isbnlib")
    (version "3.10.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "isbnlib" version))
       (sha256
        (base32
         "0iin0x2xqwyphyyzd0mzrq5v5xm7b6dlbb294k4dywra5qvbrgzm"))))
    (build-system python-build-system)
    (arguments '(#:tests? #f))  ; No test
    (home-page "https://github.com/xlcnd/isbnlib")
    (synopsis "Python library to work with ISBN strings")
    (description "@code{python-isbnlib} is a (pure) python library that provides
     several useful methods and functions to validate, clean, transform, hyphenate and
     get metadata for ISBN strings.  Its origin was as the core of isbntools.  This short
     version, is suitable to be include as a dependency in other projects.")
    (license license:lgpl3+)))

(define-public python-isoduration
  (package
    (name "python-isoduration")
    (version "20.11.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "isoduration" version))
       (sha256
        (base32 "1n8vpa9fckhc5934kp7m83wq81dhkvw987v7mjg2fdbr2car0bxc"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-arrow))
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/bolsote/isoduration")
    (synopsis "Operations with ISO 8601 durations")
    (description "ISO 8601 is most commonly known as a way to exchange
datetimes in textual format.  A lesser known aspect of the standard is the
representation of durations.  The state of the art of ISO 8601 duration
handling in Python is more or less limited to what's offered by isodate. This
package attempts to address the shortcomings of @code{isodate}.")
    (license license:isc)))

(define-public python-isort
  (package
    (name "python-isort")
    (version "5.13.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             ;; Tests pass only from the Github sources
             (url "https://github.com/timothycrosley/isort")
             (commit version)))
       (file-name (git-file-name name version))
       (modules '((guix build utils)))
       (snippet '(for-each delete-file (find-files "." "\\.whl$")))
       (sha256
        (base32
         "1d9cg5ms1qilhvpk2925zh87xgzd2ly29wywwxp0yisdddi8ln7z"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "tests/unit/"
              "-k" (string-join
                    (list
                     "not test_gitignore"
                     ;; See <https://github.com/PyCQA/isort/issues/2234>.
                     "test_isort_should_warn_on_empty_custom_config_issue_1433"
                     ;; Fails because of an unexpected linebreak.
                     "test_black_pyi_file")
                    " and not ")
              "--ignore=tests/unit/test_deprecated_finders.py")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'install 'install-example-plugins
            (lambda _
              (for-each (lambda (source-directory)
                          (invoke "python" "-m" "build" "--wheel"
                                  "--no-isolation" "--outdir=dist"
                                  source-directory))
                        '("example_isort_formatting_plugin"
                          "example_isort_sorting_plugin"
                          "example_shared_isort_profile"))
              ;; Install them to temporary storage, for the test.
              (setenv "HOME" (getcwd))
              (let ((example-whls (find-files "dist" "^example.*\\.whl$")))
                (apply invoke "pip" "--no-cache-dir" "--no-input"
                       "install"  "--user" "--no-deps" example-whls)))))))
    (native-inputs
     (list python-colorama
           python-black
           python-hypothesmith
           python-libcst-minimal
           python-natsort
           python-pip
           python-poetry-core
           python-pylama
           python-pypa-build
           python-pytest
           python-pytest-mock))
    (home-page "https://github.com/PyCQA/isort")
    (synopsis "Python utility/library to sort python imports")
    (description "@code{python-isort} is a python utility/library to sort
     imports alphabetically, and automatically separated into sections.  It
     provides a command line utility, a python library and plugins for various
     editors.")
    (license license:expat)))

(define-public python-configparser
  (package
    (name "python-configparser")
    (version "4.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "configparser" version))
       (sha256
        (base32
         "1priacxym85yjcf68hh38w55nqswaxp71ryjyfdk222kg9l85ln7"))))
    (native-inputs
     (list python-setuptools-scm))
    (build-system python-build-system)
    (home-page "https://github.com/jaraco/configparser/")
    (synopsis "Backport of configparser from python 3.5")
    (description "@code{python-configparser} is a backport of
     @code{configparser} from Python 3.5 so that it can be used directly
     in other versions.")
    (license license:expat)))

(define-public python-iniconfig
  (package
    (name "python-iniconfig")
    (version "1.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "iniconfig" version))
       (sha256
        (base32
         "0ckzngs3scaa1mcfmsi1w40a1l8cxxnncscrxzjjwjyisx8z0fmw"))))
    (build-system python-build-system)
    (home-page "https://github.com/RonnyPfannschmidt/iniconfig")
    (synopsis "Simple INI-file parser")
    (description "The @code{iniconfig} package provides a small and simple
     INI-file parser module having a unique set of features ; @code{iniconfig}
     @itemize
     @item maintains the order of sections and entries              ;
     @item supports multi-line values with or without line-continuations ;
     @item supports \"#\" comments everywhere                            ;
     @item raises errors with proper line-numbers                        ;
     @item raises an error when two sections have the same name.
     @end itemize")
    (license license:expat)))

(define-public python-mamba
  (package
    (name "python-mamba")
    (version "0.11.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "mamba" version))
              (sha256
               (base32
                "15m4dpnpv9m60pdaygvwgi43fwqaivs3qxfxhspwrp47sbgwdkvm"))))
    (build-system python-build-system)
    (arguments `(#:tests? #f))  ; No test
    (propagated-inputs
     (list python-clint python-coverage))
    (home-page "https://nestorsalceda.com/mamba/")
    (synopsis "Test runner for Python")
    (description
     "Mamba is a Behaviour-Driven Development tool for Python developers.
     Is heavily influenced from RSpec, Mocha, Jasmine or Ginkgo.")
    (license license:expat)))

(define-public python-mando
  (package
    (name "python-mando")
    (version "0.7.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "mando" version))
              (sha256
               (base32
                "001mikga36i811pbc95rb45m2kzivkx4xb0fn3pzl4xnnjcskfhq"))))
    (build-system python-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (replace 'check
                 (lambda* (#:key tests? #:allow-other-keys)
                   (when tests?
                     (invoke "pytest" "-vv")))))))
    (propagated-inputs
     (list python-rst2ansi python-six))
    (native-inputs
     (list python-pytest))
    (home-page "https://mando.readthedocs.org/")
    (synopsis
     "Wrapper around argparse, allowing creation of complete CLI applications")
    (description
     "This package is a wrapper around argparse, allowing you to write complete CLI
     applications in seconds while maintaining all the flexibility.")
    (license license:expat)))

(define-public python-mwclient
  (package
    (name "python-mwclient")
    (version "0.10.1")
    (source
     (origin
       (method git-fetch)
       ;; The PyPI version wouldn't contain tests.
       (uri (git-reference
              (url "https://github.com/mwclient/mwclient")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "120snnsh9n5svfwkyj1w9jrxf99jnqm0jk282yypd3lpyca1l9hj"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-requests-oauthlib python-six))
    (native-inputs
     (list python-mock python-pytest python-pytest-cov
           python-pytest-runner python-responses))
    (home-page "https://github.com/btongminh/mwclient")
    (synopsis "MediaWiki API client")
    (description "This package provides a MediaWiki API client.")
    (license license:expat)))

(define-public python-kneed
  (package
    (name "python-kneed")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "kneed" version))
       (sha256
        (base32 "0vkwi0pr7nfkp3c46hnmx0275yx68v96v10rmspv0wis33x6f39l"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-matplotlib python-numpy python-scipy))
    (home-page "https://github.com/arvkevi/kneed")
    (synopsis "Knee-point detection in Python")
    (description "This package implements the kneedle algorithm.  Given a set
of x and y values, kneed will return the knee point of the function.  The knee
point is the point of maximum curvature.")
    (license license:bsd-3)))

(define-public python-utils
  (package
    (name "python-utils")
    (version "3.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "python_utils" version))
       (sha256
        (base32 "18292j4p1bvlpbrfj2cgkdby6dpgnl5gbjwly0qb4pj1j914nmzb"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-pytest-config
            (lambda _
              ;; Drop test coverage requirements.
              (substitute* "pytest.ini"
                ((".*--cov.*") "")))))))
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-loguru
           python-typing-extensions))
    (home-page "https://github.com/WoLpH/python-utils")
    (synopsis "Convenient utilities not included with the standard Python install")
    (description
     "Python Utils is a collection of small Python functions and classes
which make common patterns shorter and easier.")
    (license license:bsd-2)))

(define-public python-diff-cover
  (package
    (name "python-diff-cover")
    (version "9.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "diff_cover" version))
       (sha256
        (base32 "0dms5f3axwkjpcck4mlglfn0pga5nmskyc7ahyg8yrxvxd9v7845"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; Dropp check of flake8 in tests.
      #~(list "-k" "not test_file_does_not_exist")))
    (native-inputs
     (list python-pycodestyle
           python-poetry-core
           python-pyflakes
           python-pylint
           python-pytest
           python-pytest-datadir
           python-pytest-mock))
    (propagated-inputs
     (list python-chardet
           python-jinja2
           python-pluggy
           python-pygments
           python-setuptools ; For pkg_resources.
           python-tomli))
    (home-page "https://github.com/Bachmann1234/diff-cover")
    (synopsis "Run coverage and linting reports on diffs")
    (description
     "Automatically find diff lines that need test coverage.  It also finds
diff lines that have violations (according to tools such as pycodestyle,
pyflakes, flake8, or pylint).  This is used as a code quality metric during
code reviews.")
    (license license:asl2.0)))

(define-public python-diff-match-patch
  (package
    (name "python-diff-match-patch")
    (version "20200713")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "diff-match-patch" version))
        (sha256
         (base32
          "063s8zcxz787xfg7d1wxpqh59fxg3iz85ww9zhyz4vaqm80mlvys"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (when tests?
                        (invoke "python" "-m" "unittest"
                                "diff_match_patch.tests")))))))
    (home-page "https://github.com/diff-match-patch-python/diff-match-patch")
    (synopsis "Synchronize plain text")
    (description "Diff Match and Patch libraries offer robust algorithms to
     perform the operations required for synchronizing plain text.")
    (license license:asl2.0)))

(define-public python-icdiff
  (package
    (name "python-icdiff")
    (version "2.0.5")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/jeffkaufman/icdiff")
                    (commit (string-append "release-" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "14gr9j2h7sfw47pwfzspm4zinywhqmzm4a0qz5c2k9wbixz120a4"))))
    (build-system python-build-system)
    (home-page "https://www.jefftk.com/icdiff")
    (synopsis "Improved colored diff")
    (description "This package provides colored diff functions that highlight
parts of the lines that were modified.")
    (license license:psfl)))

(define-public python-dirsync
  (package
    (name "python-dirsync")
    (version "2.2.5")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "dirsync" version))
        (sha256
         (base32
          "1gm82jddm1lkazdi8lfsl1b3vi1z0252ng60mzjym8irnv94qfhy"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-six))
    (home-page "https://github.com/tkhyn/dirsync")
    (synopsis "Advanced directory tree synchronisation tool")
    (description "Advanced directory tree synchronisation tool.")
    (license license:expat)))

(define-public python-levenshtein
  (package
    (name "python-levenshtein")
    (version "0.12.2")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "python-Levenshtein" version))
      (sha256
       (base32
        "1xj60gymwx1jl2ra9razx2wk8nb9cv1i7l8d14qsp8a8s7xra8yw"))))
    (build-system python-build-system)
    (home-page "https://github.com/ztane/python-Levenshtein")
    (synopsis "Fast computation of Levenshtein distance and string similarity")
    (description
     "The Levenshtein Python C extension module contains functions for fast computation of
     @enumerate
     @item Levenshtein (edit) distance, and edit operations
     @item string similarity
     @item approximate median strings, and generally string averaging
     @item string sequence and set similarity
     @end enumerate
     It supports both normal and Unicode strings.")
    (license license:gpl2+)))

(define-public python-scandir
  (package
    (name "python-scandir")
    (version "1.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "scandir" version))
       (sha256
        (base32 "1bkqwmf056pkchf05ywbnf659wqlp6lljcdb0y88wr9f0vv32ijd"))))
    (build-system python-build-system)
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda _
                      (invoke "python" "test/run_tests.py"))))))
    (home-page "https://github.com/benhoyt/scandir")
    (synopsis "Directory iteration function")
    (description
     "Directory iteration function like os.listdir(), except that instead of
     returning a list of bare filenames, it yields DirEntry objects that include
     file type and stat information along with the name.  Using scandir() increases
     the speed of os.walk() by 2-20 times (depending on the platform and file
                                                     system) by avoiding unnecessary calls to os.stat() in most cases.

     This package is part of the Python standard library since version 3.5.")
    (license license:bsd-3)))

(define-public python-factory-boy
  (package
    (name "python-factory-boy")
    (version "3.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "factory_boy" version))
       (sha256
        (base32 "0pm5lbvnwm0kg5i6z611rg907yw1gy551f2advmpaz041ixjg3d9"))))
    (build-system python-build-system)
    (arguments
     ;; Tests are not included in the tarball.
     `(#:tests? #f))
    (propagated-inputs (list python-faker))
    (home-page "https://github.com/benhoyt/scandir")
    (synopsis "Versatile test fixtures replacement")
    (description "Factory_boy is a fixtures replacement based on thoughtbot’s
factory_girl.  As a fixtures replacement tool, it aims to replace static, hard
to maintain fixtures with easy-to-use factories for complex object.  Instead
of building an exhaustive test setup with every possible combination of corner
cases, factory_boy allows you to use objects customized for the current test,
while only declaring the test-specific fields.")
    (license license:expat)))

(define-public python-translate-toolkit
  (package
    (name "python-translate-toolkit")
    (version "3.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "translate-toolkit" version ".tar.gz"))
       (sha256
        (base32 "0m4cpsp7x7h5m5agg4ybscf7y86wla46q2lvxpi2myplb6qlgcli"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest python-sphinx))
    (propagated-inputs
     (list python-babel
           python-beautifulsoup4
           python-chardet
           python-diff-match-patch
           python-levenshtein
           python-lxml
           python-six
           python-vobject
           python-pyyaml))
    (arguments
     ;; TODO: tests are not run, because they end with
     ;; TypeError: parse() missing 2 required positional arguments: 'tree' and
     ;; 'parse_funcs'
     ;; during test setup.
     (list #:tests? #f
           #:phases
           #~(modify-phases %standard-phases
               ;; translate-toolkit has many optional dependencies (see
               ;; optional.txt), which the sanity check does not understand.
               (delete 'sanity-check))))
    (home-page "https://toolkit.translatehouse.org")
    (synopsis "Tools and API for translation and localization engineering")
    (description
     "Tools and API for translation and localization engineering.  It contains
     several utilities, as well as an API for building localization tools.")
    (license license:gpl2+)))

(define-public python-gtts
  (package
    (name "python-gtts")
    (version "2.3.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "gTTS" version))
              (sha256
               (base32
                "1jsg1prpzr7gj5sn385mkv2v1i8xfc83ycm87hvsi2j0y366plps"))))
    (build-system pyproject-build-system)
    (arguments
     ;; Disable tests that require internet.
     (list #:test-flags '(list "-k" "not net")))
    (native-inputs
     (list python-pytest python-testfixtures python-click python-requests
           python-setuptools python-wheel))
    (home-page "https://github.com/pndurette/gTTS")
    (synopsis "Google Translate text-to-speech interface")
    (description
     "Google Text-to-Speech (gTTS) is a Python library and CLI tool to
interface with the Google Translate text-to-speech API.  It lets you write
spoken MP3 data to a file, a file-like object (bytestring) for further audio
manipulation, or @code{stdout}.")
    (license license:expat)))

(define-public python-packaging
  (package/inherit python-packaging-bootstrap
    (name "python-packaging")
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (if tests?
                          (invoke "pytest" "-vv")
                          (format #t "test suite not run~%")))))))
    (native-inputs
     (list python-flit-core
           python-pretend python-pytest))
    (propagated-inputs (list python-pyparsing python-six))
    (home-page "https://github.com/pypa/packaging")
    (synopsis "Core utilities for Python packages")
    (description "Packaging is a Python module for dealing with Python packages.
     It offers an interface for working with package versions, names, and dependency
     information.")
    ;; From 'LICENSE': This software is made available under the terms of
    ;; *either* of the licenses found in LICENSE.APACHE or LICENSE.BSD.
    ;; Contributions to this software is made under the terms of *both* these
    ;; licenses.
    (license (list license:asl2.0 license:bsd-2))))

(define-public python-packaging-legacy
  (package
    (name "python-packaging-legacy")
    (version "23.0.post0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "packaging_legacy" version))
       (sha256
        (base32 "1nyryxlc7fd4c0jmfp99az1s61vfv5xbi6017wqi4wd7j4ia8x69"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-packaging))
    (native-inputs
     (list python-pretend
           python-pytest
           python-setuptools
           python-wheel))
    (home-page "https://pypi.org/project/packaging-legacy/")
    (synopsis "Core utilities for legacy Python packages")
    (description "This library provides support for legacy Python Packaging
functionality removed from @code{packaging}.")
    (license license:asl2.0)))

(define-public python-relatorio
  (package
    (name "python-relatorio")
    (version "0.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "relatorio" version))
       (sha256
        (base32
         "09nhrz80dfm60nssbvjgz4czzy4yzfa8gxczcdlzbgcnnvm914vb"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-lxml python-genshi))
    (native-inputs
     (list python-magic))
    (home-page "https://relatorio.tryton.org/")
    (synopsis "Templating library able to output ODT and PDF files")
    (description "Relatorio is a templating library which provides a