-- Copyright 2004-2023 H2 Group. Multiple-Licensed under the MPL 2.0,
-- and the EPL 1.0 (https://h2database.com/html/license.html).
-- Initial Developer: H2 Group
--

select bitand(null, 1) vn, bitand(1, null) vn1, bitand(null, null) vn2, bitand(3, 6) e2;
> VN   VN1  VN2  E2
> ---- ---- ---- --
> null null null 2
> rows: 1

SELECT BITAND(10, 12);
>> 8

SELECT BITNAND(10, 12);
>> -9

CREATE TABLE TEST(A BIGINT, B BIGINT);
> ok

EXPLAIN SELECT BITNOT(BITAND(A, B)), BITNOT(BITNAND(A, B)) FROM TEST;
>> SELECT BITNAND("A", "B"), BITAND("A", "B") FROM "PUBLIC"."TEST" /* PUBLIC.TEST.tableScan */

DROP TABLE TEST;
> ok

EXPLAIN SELECT
    BITAND(CAST((0xC5 - 0x100) AS TINYINT), CAST(0x63 AS TINYINT)),
    BITAND(CAST(0xC5 AS SMALLINT), CAST(0x63 AS SMALLINT)),
    BITAND(CAST(0xC5 AS INTEGER), CAST(0x63 AS INTEGER)),
    BITAND(CAST(0xC5 AS BIGINT), CAST(0x63 AS BIGINT)),
    BITAND(CAST(X'C5' AS VARBINARY), CAST(X'63' AS VARBINARY)),
    BITAND(CAST(X'C5' AS BINARY), CAST(X'63' AS BINARY));
>> SELECT CAST(65 AS TINYINT), CAST(65 AS SMALLINT), 65, CAST(65 AS BIGINT), X'41', CAST(X'41' AS BINARY(1))

EXPLAIN SELECT
    BITAND(CAST(X'C501' AS VARBINARY), CAST(X'63' AS VARBINARY)),
    BITAND(CAST(X'63' AS VARBINARY), CAST(X'C501' AS VARBINARY)),
    BITAND(CAST(X'C501' AS BINARY(2)), CAST(X'63' AS BINARY)),
    BITAND(CAST(X'63' AS BINARY), CAST(X'C501' AS BINARY(2)));
>> SELECT X'4100', X'4100', CAST(X'4100' AS BINARY(2)), CAST(X'4100' AS BINARY(2))

EXPLAIN SELECT
    BITAND(CAST(X'C501' AS VARBINARY), CAST(X'63' AS BINARY)),
    BITAND(CAST(X'63' AS BINARY), CAST(X'C501' AS VARBINARY));
>> SELECT CAST(X'41' AS BINARY(1)), CAST(X'41' AS BINARY(1))

EXPLAIN SELECT
    BITNAND(CAST((0xC5 - 0x100) AS TINYINT), CAST(0x63 AS TINYINT)),
    BITNAND(CAST(0xC5 AS SMALLINT), CAST(0x63 AS SMALLINT)),
    BITNAND(CAST(0xC5 AS INTEGER), CAST(0x63 AS INTEGER)),
    BITNAND(CAST(0xC5 AS BIGINT), CAST(0x63 AS BIGINT)),
    BITNAND(CAST(X'C5' AS VARBINARY), CAST(X'63' AS VARBINARY)),
    BITNAND(CAST(X'C5' AS BINARY), CAST(X'63' AS BINARY));
>> SELECT CAST(-66 AS TINYINT), CAST(-66 AS SMALLINT), -66, CAST(-66 AS BIGINT), X'be', CAST(X'be' AS BINARY(1))

EXPLAIN SELECT
    BITNAND(CAST(X'C501' AS VARBINARY), CAST(X'63' AS VARBINARY)),
    BITNAND(CAST(X'63' AS VARBINARY), CAST(X'C501' AS VARBINARY)),
    BITNAND(CAST(X'C501' AS BINARY(2)), CAST(X'63' AS BINARY)),
    BITNAND(CAST(X'63' AS BINARY), CAST(X'C501' AS BINARY(2)));
>> SELECT X'beff', X'beff', CAST(X'beff' AS BINARY(2)), CAST(X'beff' AS BINARY(2))

EXPLAIN SELECT
    BITNAND(CAST(X'C501' AS VARBINARY), CAST(X'63' AS BINARY)),
    BITNAND(CAST(X'63' AS BINARY), CAST(X'C501' AS VARBINARY));
>> SELECT CAST(X'be' AS BINARY(1)), CAST(X'be' AS BINARY(1))

SELECT BITAND('AA', 'BB');
> exception INVALID_VALUE_2

SELECT BITAND(1, X'AA');
> exception INVALID_VALUE_2

SELECT BITNAND('AA', 'BB');
> exception INVALID_VALUE_2

SELECT BITNAND(1, X'AA');
> exception INVALID_VALUE_2
