"""
List of registered IEEE 24-bit Organizationally Unique IDentifiers.

Original data file:
http://standards.ieee.org/regauth/oui/oui.txt
"""

REGISTERED_OUID = {  # noqa
   0x000000: u'XEROX CORPORATION',
   0x000001: u'XEROX CORPORATION',
   0x000002: u'XEROX CORPORATION',
   0x000003: u'XEROX CORPORATION',
   0x000004: u'XEROX CORPORATION',
   0x000005: u'XEROX CORPORATION',
   0x000006: u'XEROX CORPORATION',
   0x000007: u'XEROX CORPORATION',
   0x000008: u'XEROX CORPORATION',
   0x000009: u'XEROX CORPORATION',
   0x00000A: u'OMRON TATEISI ELECTRONICS CO.',
   0x00000B: u'MATRIX CORPORATION',
   0x00000C: u'CISCO SYSTEMS, INC.',
   0x00000D: u'FIBRONICS LTD.',
   0x00000E: u'FUJITSU LIMITED',
   0x00000F: u'NEXT, INC.',
   0x000010: u'SYTEK INC.',
   0x000011: u'NORMEREL SYSTEMES',
   0x000012: u'INFORMATION TECHNOLOGY LIMITED',
   0x000013: u'CAMEX',
   0x000014: u'NETRONIX',
   0x000015: u'DATAPOINT CORPORATION',
   0x000016: u'DU PONT PIXEL SYSTEMS.',
   0x000017: u'TEKELEC',
   0x000018: u'WEBSTER COMPUTER CORPORATION',
   0x000019: u'APPLIED DYNAMICS INTERNATIONAL',
   0x00001A: u'ADVANCED MICRO DEVICES',
   0x00001B: u'NOVELL INC.',
   0x00001C: u'BELL TECHNOLOGIES',
   0x00001D: u'CABLETRON SYSTEMS, INC.',
   0x00001E: u'TELSIST INDUSTRIA ELECTRONICA',
   0x00001F: u'Telco Systems, Inc.',
   0x000020: u'DATAINDUSTRIER DIAB AB',
   0x000021: u'SUREMAN COMP. & COMMUN. CORP.',
   0x000022: u'VISUAL TECHNOLOGY INC.',
   0x000023: u'ABB INDUSTRIAL SYSTEMS AB',
   0x000024: u'CONNECT AS',
   0x000025: u'RAMTEK CORP.',
   0x000026: u'SHA-KEN CO., LTD.',
   0x000027: u'JAPAN RADIO COMPANY',
   0x000028: u'PRODIGY SYSTEMS CORPORATION',
   0x000029: u'IMC NETWORKS CORP.',
   0x00002A: u'TRW - SEDD/INP',
   0x00002B: u'CRISP AUTOMATION, INC',
   0x00002C: u'AUTOTOTE LIMITED',
   0x00002D: u'CHROMATICS INC',
   0x00002E: u'SOCIETE EVIRA',
   0x00002F: u'TIMEPLEX INC.',
   0x000030: u'VG LABORATORY SYSTEMS LTD',
   0x000031: u'QPSX COMMUNICATIONS PTY LTD',
   0x000032: u'Marconi plc',
   0x000033: u'EGAN MACHINERY COMPANY',
   0x000034: u'NETWORK RESOURCES CORPORATION',
   0x000035: u'SPECTRAGRAPHICS CORPORATION',
   0x000036: u'ATARI CORPORATION',
   0x000037: u'OXFORD METRICS LIMITED',
   0x000038: u'CSS LABS',
   0x000039: u'TOSHIBA CORPORATION',
   0x00003A: u'CHYRON CORPORATION',
   0x00003B: u'i Controls, Inc.',
   0x00003C: u'AUSPEX SYSTEMS INC.',
   0x00003D: u'UNISYS',
   0x00003E: u'SIMPACT',
   0x00003F: u'SYNTREX, INC.',
   0x000040: u'APPLICON, INC.',
   0x000041: u'ICE CORPORATION',
   0x000042: u'METIER MANAGEMENT SYSTEMS LTD.',
   0x000043: u'MICRO TECHNOLOGY',
   0x000044: u'CASTELLE CORPORATION',
   0x000045: u'FORD AEROSPACE & COMM. CORP.',
   0x000046: u'OLIVETTI NORTH AMERICA',
   0x000047: u'NICOLET INSTRUMENTS CORP.',
   0x000048: u'SEIKO EPSON CORPORATION',
   0x000049: u'APRICOT COMPUTERS, LTD',
   0x00004A: u'ADC CODENOLL TECHNOLOGY CORP.',
   0x00004B: u'ICL DATA OY',
   0x00004C: u'NEC CORPORATION',
   0x00004D: u'DCI CORPORATION',
   0x00004E: u'AMPEX CORPORATION',
   0x00004F: u'LOGICRAFT, INC.',
   0x000050: u'RADISYS CORPORATION',
   0x000051: u'HOB ELECTRONIC GMBH & CO. KG',
   0x000052: u'Intrusion.com, Inc.',
   0x000053: u'COMPUCORP',
   0x000054: u'MODICON, INC.',
   0x000055: u'COMMISSARIAT A L`ENERGIE ATOM.',
   0x000056: u'DR. B. STRUCK',
   0x000057: u'SCITEX CORPORATION LTD.',
   0x000058: u'RACORE COMPUTER PRODUCTS INC.',
   0x000059: u'HELLIGE GMBH',
   0x00005A: u'SysKonnect GmbH',
   0x00005B: u'ELTEC ELEKTRONIK AG',
   0x00005C: u'TELEMATICS INTERNATIONAL INC.',
   0x00005D: u'CS TELECOM',
   0x00005E: u'USC INFORMATION SCIENCES INST',
   0x00005F: u'SUMITOMO ELECTRIC IND., LTD.',
   0x000060: u'KONTRON ELEKTRONIK GMBH',
   0x000061: u'GATEWAY COMMUNICATIONS',
   0x000062: u'BULL HN INFORMATION SYSTEMS',
   0x000063: u'BARCO CONTROL ROOMS GMBH',
   0x000064: u'YOKOGAWA DIGITAL COMPUTER CORP',
   0x000065: u'Network General Corporation',
   0x000066: u'TALARIS SYSTEMS, INC.',
   0x000067: u'SOFT * RITE, INC.',
   0x000068: u'ROSEMOUNT CONTROLS',
   0x000069: u'CONCORD COMMUNICATIONS INC',
   0x00006A: u'COMPUTER CONSOLES INC.',
   0x00006B: u'SILICON GRAPHICS INC./MIPS',
   0x00006C: u'PRIVATE',
   0x00006D: u'CRAY COMMUNICATIONS, LTD.',
   0x00006E: u'ARTISOFT, INC.',
   0x00006F: u'Madge Ltd.',
   0x000070: u'HCL LIMITED',
   0x000071: u'ADRA SYSTEMS INC.',
   0x000072: u'MINIWARE TECHNOLOGY',
   0x000073: u'SIECOR CORPORATION',
   0x000074: u'RICOH COMPANY LTD.',
   0x000075: u'Nortel Networks',
   0x000076: u'ABEKAS VIDEO SYSTEM',
   0x000077: u'INTERPHASE CORPORATION',
   0x000078: u'LABTAM LIMITED',
   0x000079: u'NETWORTH INCORPORATED',
   0x00007A: u'DANA COMPUTER INC.',
   0x00007B: u'RESEARCH MACHINES',
   0x00007C: u'AMPERE INCORPORATED',
   0x00007D: u'SUN MICROSYSTEMS, INC.',
   0x00007E: u'CLUSTRIX CORPORATION',
   0x00007F: u'LINOTYPE-HELL AG',
   0x000080: u'CRAY COMMUNICATIONS A/S',
   0x000081: u'BAY NETWORKS',
   0x000082: u'LECTRA SYSTEMES SA',
   0x000083: u'TADPOLE TECHNOLOGY PLC',
   0x000084: u'SUPERNET',
   0x000085: u'CANON INC.',
   0x000086: u'MEGAHERTZ CORPORATION',
   0x000087: u'HITACHI, LTD.',
   0x000088: u'COMPUTER NETWORK TECH. CORP.',
   0x000089: u'CAYMAN SYSTEMS INC.',
   0x00008A: u'DATAHOUSE INFORMATION SYSTEMS',
   0x00008B: u'INFOTRON',
   0x00008C: u'Alloy Computer Products (Australia) Pty Ltd',
   0x00008D: u'VERDIX CORPORATION',
   0x00008E: u'SOLBOURNE COMPUTER, INC.',
   0x00008F: u'RAYTHEON COMPANY',
   0x000090: u'MICROCOM',
   0x000091: u'ANRITSU CORPORATION',
   0x000092: u'COGENT DATA TECHNOLOGIES',
   0x000093: u'PROTEON INC.',
   0x000094: u'ASANTE TECHNOLOGIES',
   0x000095: u'SONY TEKTRONIX CORP.',
   0x000096: u'MARCONI ELECTRONICS LTD.',
   0x000097: u'EPOCH SYSTEMS',
   0x000098: u'CROSSCOMM CORPORATION',
   0x000099: u'MTX, INC.',
   0x00009A: u'RC COMPUTER A/S',
   0x00009B: u'INFORMATION INTERNATIONAL, INC',
   0x00009C: u'ROLM MIL-SPEC COMPUTERS',
   0x00009D: u'LOCUS COMPUTING CORPORATION',
   0x00009E: u'MARLI S.A.',
   0x00009F: u'AMERISTAR TECHNOLOGIES INC.',
   0x0000A0: u'SANYO Electric Co., Ltd.',
   0x0000A1: u'MARQUETTE ELECTRIC CO.',
   0x0000A2: u'BAY NETWORKS',
   0x0000A3: u'NETWORK APPLICATION TECHNOLOGY',
   0x0000A4: u'ACORN COMPUTERS LIMITED',
   0x0000A5: u'COMPATIBLE SYSTEMS CORP.',
   0x0000A6: u'NETWORK GENERAL CORPORATION',
   0x0000A7: u'NETWORK COMPUTING DEVICES INC.',
   0x0000A8: u'STRATUS COMPUTER INC.',
   0x0000A9: u'NETWORK SYSTEMS CORP.',
   0x0000AA: u'XEROX CORPORATION',
   0x0000AB: u'LOGIC MODELING CORPORATION',
   0x0000AC: u'CONWARE COMPUTER CONSULTING',
   0x0000AD: u'BRUKER INSTRUMENTS INC.',
   0x0000AE: u'DASSAULT ELECTRONIQUE',
   0x0000AF: u'NUCLEAR DATA INSTRUMENTATION',
   0x0000B0: u'RND-RAD NETWORK DEVICES',
   0x0000B1: u'ALPHA MICROSYSTEMS INC.',
   0x0000B2: u'TELEVIDEO SYSTEMS, INC.',
   0x0000B3: u'CIMLINC INCORPORATED',
   0x0000B4: u'EDIMAX COMPUTER COMPANY',
   0x0000B5: u'DATABILITY SOFTWARE SYS. INC.',
   0x0000B6: u'MICRO-MATIC RESEARCH',
   0x0000B7: u'DOVE COMPUTER CORPORATION',
   0x0000B8: u'SEIKOSHA CO., LTD.',
   0x0000B9: u'MCDONNELL DOUGLAS COMPUTER SYS',
   0x0000BA: u'SIIG, INC.',
   0x0000BB: u'TRI-DATA',
   0x0000BC: u'ALLEN-BRADLEY CO. INC.',
   0x0000BD: u'MITSUBISHI CABLE COMPANY',
   0x0000BE: u'THE NTI GROUP',
   0x0000BF: u'SYMMETRIC COMPUTER SYSTEMS',
   0x0000C0: u'WESTERN DIGITAL CORPORATION',
   0x0000C1: u'Madge Ltd.',
   0x0000C2: u'INFORMATION PRESENTATION TECH.',
   0x0000C3: u'HARRIS CORP COMPUTER SYS DIV',
   0x0000C4: u'WATERS DIV. OF MILLIPORE',
   0x0000C5: u'FARALLON COMPUTING/NETOPIA',
   0x0000C6: u'EON SYSTEMS',
   0x0000C7: u'ARIX CORPORATION',
   0x0000C8: u'ALTOS COMPUTER SYSTEMS',
   0x0000C9: u'EMULEX CORPORATION',
   0x0000CA: u'ARRIS International',
   0x0000CB: u'COMPU-SHACK ELECTRONIC GMBH',
   0x0000CC: u'DENSAN CO., LTD.',
   0x0000CD: u'Allied Telesyn Research Ltd.',
   0x0000CE: u'MEGADATA CORP.',
   0x0000CF: u'HAYES MICROCOMPUTER PRODUCTS',
   0x0000D0: u'DEVELCON ELECTRONICS LTD.',
   0x0000D1: u'ADAPTEC INCORPORATED',
   0x0000D2: u'SBE, INC.',
   0x0000D3: u'WANG LABORATORIES INC.',
   0x0000D4: u'PURE DATA LTD.',
   0x0000D5: u'MICROGNOSIS INTERNATIONAL',
   0x0000D6: u'PUNCH LINE HOLDING',
   0x0000D7: u'DARTMOUTH COLLEGE',
   0x0000D8: u'NOVELL, INC.',
   0x0000D9: u'NIPPON TELEGRAPH & TELEPHONE',
   0x0000DA: u'ATEX',
   0x0000DB: u'BRITISH TELECOMMUNICATIONS PLC',
   0x0000DC: u'HAYES MICROCOMPUTER PRODUCTS',
   0x0000DD: u'TCL INCORPORATED',
   0x0000DE: u'CETIA',
   0x0000DF: u'BELL & HOWELL PUB SYS DIV',
   0x0000E0: u'QUADRAM CORP.',
   0x0000E1: u'GRID SYSTEMS',
   0x0000E2: u'ACER TECHNOLOGIES CORP.',
   0x0000E3: u'INTEGRATED MICRO PRODUCTS LTD',
   0x0000E4: u'IN2 GROUPE INTERTECHNIQUE',
   0x0000E5: u'SIGMEX LTD.',
   0x0000E6: u'APTOR PRODUITS DE COMM INDUST',
   0x0000E7: u'STAR GATE TECHNOLOGIES',
   0x0000E8: u'ACCTON TECHNOLOGY CORP.',
   0x0000E9: u'ISICAD, INC.',
   0x0000EA: u'UPNOD AB',
   0x0000EB: u'MATSUSHITA COMM. IND. CO. LTD.',
   0x0000EC: u'MICROPROCESS',
   0x0000ED: u'APRIL',
   0x0000EE: u'NETWORK DESIGNERS, LTD.',
   0x0000EF: u'KTI',
   0x0000F0: u'SAMSUNG ELECTRONICS CO., LTD.',
   0x0000F1: u'MAGNA COMPUTER CORPORATION',
   0x0000F2: u'SPIDER COMMUNICATIONS',
   0x0000F3: u'GANDALF DATA LIMITED',
   0x0000F4: u'ALLIED TELESYN INTERNATIONAL',
   0x0000F5: u'DIAMOND SALES LIMITED',
   0x0000F6: u'APPLIED MICROSYSTEMS CORP.',
   0x0000F7: u'YOUTH KEEP ENTERPRISE CO LTD',
   0x0000F8: u'DIGITAL EQUIPMENT CORPORATION',
   0x0000F9: u'QUOTRON SYSTEMS INC.',
   0x0000FA: u'MICROSAGE COMPUTER SYSTEMS INC',
   0x0000FB: u'RECHNER ZUR KOMMUNIKATION',
   0x0000FC: u'MEIKO',
   0x0000FD: u'HIGH LEVEL HARDWARE',
   0x0000FE: u'ANNAPOLIS MICRO SYSTEMS',
   0x0000FF: u'CAMTEC ELECTRONICS LTD.',
   0x000100: u'EQUIP\'TRANS',
   0x000101: u'PRIVATE',
   0x000102: u'3COM CORPORATION',
   0x000103: u'3COM CORPORATION',
   0x000104: u'DVICO Co., Ltd.',
   0x000105: u'BECKHOFF GmbH',
   0x000106: u'Tews Datentechnik GmbH',
   0x000107: u'Leiser GmbH',
   0x000108: u'AVLAB Technology, Inc.',
   0x000109: u'Nagano Japan Radio Co., Ltd.',
   0x00010A: u'CIS TECHNOLOGY INC.',
   0x00010B: u'Space CyberLink, Inc.',
   0x00010C: u'System Talks Inc.',
   0x00010D: u'CORECO, INC.',
   0x00010E: u'Bri-Link Technologies Co., Ltd',
   0x00010F: u'McDATA Corporation',
   0x000110: u'Gotham Networks',
   0x000111: u'iDigm Inc.',
   0x000112: u'Shark Multimedia Inc.',
   0x000113: u'OLYMPUS CORPORATION',
   0x000114: u'KANDA TSUSHIN KOGYO CO., LTD.',
   0x000115: u'EXTRATECH CORPORATION',
   0x000116: u'Netspect Technologies, Inc.',
   0x000117: u'CANAL +',
   0x000118: u'EZ Digital Co., Ltd.',
   0x000119: u'RTUnet (Australia)',
   0x00011A: u'EEH DataLink GmbH',
   0x00011B: u'Unizone Technologies, Inc.',
   0x00011C: u'Universal Talkware Corporation',
   0x00011D: u'Centillium Communications',
   0x00011E: u'Precidia Technologies, Inc.',
   0x00011F: u'RC Networks, Inc.',
   0x000120: u'OSCILLOQUARTZ S.A.',
   0x000121: u'Watchguard Technologies, Inc.',
   0x000122: u'Trend Communications, Ltd.',
   0x000123: u'DIGITAL ELECTRONICS CORP.',
   0x000124: u'Acer Incorporated',
   0x000125: u'YAESU MUSEN CO., LTD.',
   0x000126: u'PAC Labs',
   0x000127: u'OPEN Networks Pty Ltd',
   0x000128: u'EnjoyWeb, Inc.',
   0x000129: u'DFI Inc.',
   0x00012A: u'Telematica Sistems Inteligente',
   0x00012B: u'TELENET Co., Ltd.',
   0x00012C: u'Aravox Technologies, Inc.',
   0x00012D: u'Komodo Technology',
   0x00012E: u'PC Partner Ltd.',
   0x00012F: u'Twinhead International Corp',
   0x000130: u'Extreme Networks',
   0x000131: u'Detection Systems, Inc.',
   0x000132: u'Dranetz - BMI',
   0x000133: u'KYOWA Electronic Instruments C',
   0x000134: u'SIG Positec Systems AG',
   0x000135: u'KDC Corp.',
   0x000136: u'CyberTAN Technology, Inc.',
   0x000137: u'IT Farm Corporation',
   0x000138: u'XAVi Technologies Corp.',
   0x000139: u'Point Multimedia Systems',
   0x00013A: u'SHELCAD COMMUNICATIONS, LTD.',
   0x00013B: u'BNA SYSTEMS',
   0x00013C: u'TIW SYSTEMS',
   0x00013D: u'RiscStation Ltd.',
   0x00013E: u'Ascom Tateco AB',
   0x00013F: u'Neighbor World Co., Ltd.',
   0x000140: u'Sendtek Corporation',
   0x000141: u'CABLE PRINT',
   0x000142: u'Cisco Systems, Inc.',
   0x000143: u'Cisco Systems, Inc.',
   0x000144: u'EMC Corporation',
   0x000145: u'WINSYSTEMS, INC.',
   0x000146: u'Tesco Controls, Inc.',
   0x000147: u'Zhone Technologies',
   0x000148: u'X-traWeb Inc.',
   0x000149: u'T.D.T. Transfer Data Test GmbH',
   0x00014A: u'Sony Corporation',
   0x00014B: u'Ennovate Networks, Inc.',
   0x00014C: u'Berkeley Process Control',
   0x00014D: u'Shin Kin Enterprises Co., Ltd',
   0x00014E: u'WIN Enterprises, Inc.',
   0x00014F: u'ADTRAN INC',
   0x000150: u'GILAT COMMUNICATIONS, LTD.',
   0x000151: u'Ensemble Communications',
   0x000152: u'CHROMATEK INC.',
   0x000153: u'ARCHTEK TELECOM CORPORATION',
   0x000154: u'G3M Corporation',
   0x000155: u'Promise Technology, Inc.',
   0x000156: u'FIREWIREDIRECT.COM, INC.',
   0x000157: u'SYSWAVE CO., LTD',
   0x000158: u'Electro Industries/Gauge Tech',
   0x000159: u'S1 Corporation',
   0x00015A: u'Digital Video Broadcasting',
   0x00015B: u'ITALTEL S.p.A/RF-UP-I',
   0x00015C: u'CADANT INC.',
   0x00015D: u'Sun Microsystems, Inc',
   0x00015E: u'BEST TECHNOLOGY CO., LTD.',
   0x00015F: u'DIGITAL DESIGN GmbH',
   0x000160: u'ELMEX Co., LTD.',
   0x000161: u'Meta Machine Technology',
   0x000162: u'Cygnet Technologies, Inc.',
   0x000163: u'Cisco Systems, Inc.',
   0x000164: u'Cisco Systems, Inc.',
   0x000165: u'AirSwitch Corporation',
   0x000166: u'TC GROUP A/S',
   0x000167: u'HIOKI E.E. CORPORATION',
   0x000168: u'VITANA CORPORATION',
   0x000169: u'Celestix Networks Pte Ltd.',
   0x00016A: u'ALITEC',
   0x00016B: u'LightChip, Inc.',
   0x00016C: u'FOXCONN',
   0x00016D: u'CarrierComm Inc.',
   0x00016E: u'Conklin Corporation',
   0x00016F: u'HAITAI ELECTRONICS CO., LTD.',
   0x000170: u'ESE Embedded System Engineer\'g',
   0x000171: u'Allied Data Technologies',
   0x000172: u'TechnoLand Co., LTD.',
   0x000173: u'AMCC',
   0x000174: u'CyberOptics Corporation',
   0x000175: u'Radiant Communications Corp.',
   0x000176: u'Orient Silver Enterprises',
   0x000177: u'EDSL',
   0x000178: u'MARGI Systems, Inc.',
   0x000179: u'WIRELESS TECHNOLOGY, INC.',
   0x00017A: u'Chengdu Maipu Electric Industrial Co., Ltd.',
   0x00017B: u'Heidelberger Druckmaschinen AG',
   0x00017C: u'AG-E GmbH',
   0x00017D: u'ThermoQuest',
   0x00017E: u'ADTEK System Science Co., Ltd.',
   0x00017F: u'Experience Music Project',
   0x000180: u'AOpen, Inc.',
   0x000181: u'Nortel Networks',
   0x000182: u'DICA TECHNOLOGIES AG',
   0x000183: u'ANITE TELECOMS',
   0x000184: u'SIEB & MEYER AG',
   0x000185: u'Aloka Co., Ltd.',
   0x000186: u'Uwe Disch',
   0x000187: u'i2SE GmbH',
   0x000188: u'LXCO Technologies ag',
   0x000189: u'Refraction Technology, Inc.',
   0x00018A: u'ROI COMPUTER AG',
   0x00018B: u'NetLinks Co., Ltd.',
   0x00018C: u'Mega Vision',
   0x00018D: u'AudeSi Technologies',
   0x00018E: u'Logitec Corporation',
   0x00018F: u'Kenetec, Inc.',
   0x000190: u'SMK-M',
   0x000191: u'SYRED Data Systems',
   0x000192: u'Texas Digital Systems',
   0x000193: u'Hanbyul Telecom Co., Ltd.',
   0x000194: u'Capital Equipment Corporation',
   0x000195: u'Sena Technologies, Inc.',
   0x000196: u'Cisco Systems, Inc.',
   0x000197: u'Cisco Systems, Inc.',
   0x000198: u'Darim Vision',
   0x000199: u'HeiSei Electronics',
   0x00019A: u'LEUNIG GmbH',
   0x00019B: u'Kyoto Microcomputer Co., Ltd.',
   0x00019C: u'JDS Uniphase Inc.',
   0x00019D: u'E-Control Systems, Inc.',
   0x00019E: u'ESS Technology, Inc.',
   0x00019F: u'Phonex Broadband',
   0x0001A0: u'Infinilink Corporation',
   0x0001A1: u'Mag-Tek, Inc.',
   0x0001A2: u'Logical Co., Ltd.',
   0x0001A3: u'GENESYS LOGIC, INC.',
   0x0001A4: u'Microlink Corporation',
   0x0001A5: u'Nextcomm, Inc.',
   0x0001A6: u'Scientific-Atlanta Arcodan A/S',
   0x0001A7: u'UNEX TECHNOLOGY CORPORATION',
   0x0001A8: u'Welltech Computer Co., Ltd.',
   0x0001A9: u'BMW AG',
   0x0001AA: u'Airspan Communications, Ltd.',
   0x0001AB: u'Main Street Networks',
   0x0001AC: u'Sitara Networks, Inc.',
   0x0001AD: u'Coach Master International  d.b.a. CMI Worldwide, Inc.',
   0x0001AE: u'Trex Enterprises',
   0x0001AF: u'Motorola Computer Group',
   0x0001B0: u'Fulltek Technology Co., Ltd.',
   0x0001B1: u'General Bandwidth',
   0x0001B2: u'Digital Processing Systems, Inc.',
   0x0001B3: u'Precision Electronic Manufacturing',
   0x0001B4: u'Wayport, Inc.',
   0x0001B5: u'Turin Networks, Inc.',
   0x0001B6: u'SAEJIN T&M Co., Ltd.',
   0x0001B7: u'Centos, Inc.',
   0x0001B8: u'Netsensity, Inc.',
   0x0001B9: u'SKF Condition Monitoring',
   0x0001BA: u'IC-Net, Inc.',
   0x0001BB: u'Frequentis',
   0x0001BC: u'Brains Corporation',
   0x0001BD: u'Peterson Electro-Musical Products, Inc.',
   0x0001BE: u'Gigalink Co., Ltd.',
   0x0001BF: u'Teleforce Co., Ltd.',
   0x0001C0: u'CompuLab, Ltd.',
   0x0001C1: u'Vitesse Semiconductor Corporation',
   0x0001C2: u'ARK Research Corp.',
   0x0001C3: u'Acromag, Inc.',
   0x0001C4: u'NeoWave, Inc.',
   0x0001C5: u'Simpler Networks',
   0x0001C6: u'Quarry Technologies',
   0x0001C7: u'Cisco Systems, Inc.',
   0x0001C8: u'THOMAS CONRAD CORP.',
   0x0001C9: u'Cisco Systems, Inc.',
   0x0001CA: u'Geocast Network Systems, Inc.',
   0x0001CB: u'EVR',
   0x0001CC: u'Japan Total Design Communication Co., Ltd.',
   0x0001CD: u'ARtem',
   0x0001CE: u'Custom Micro Products, Ltd.',
   0x0001CF: u'Alpha Data Parallel Systems, Ltd.',
   0x0001D0: u'VitalPoint, Inc.',
   0x0001D1: u'CoNet Communications, Inc.',
   0x0001D2: u'MacPower Peripherals, Ltd.',
   0x0001D3: u'PAXCOMM, Inc.',
   0x0001D4: u'Leisure Time, Inc.',
   0x0001D5: u'HAEDONG INFO & COMM CO., LTD',
   0x0001D6: u'MAN Roland Druckmaschinen AG',
   0x0001D7: u'F5 Networks, Inc.',
   0x0001D8: u'Teltronics, Inc.',
   0x0001D9: u'Sigma, Inc.',
   0x0001DA: u'WINCOMM Corporation',
   0x0001DB: u'Freecom Technologies GmbH',
   0x0001DC: u'Activetelco',
   0x0001DD: u'Avail Networks',
   0x0001DE: u'Trango Systems, Inc.',
   0x0001DF: u'ISDN Communications, Ltd.',
   0x0001E0: u'Fast Systems, Inc.',
   0x0001E1: u'Kinpo Electronics, Inc.',
   0x0001E2: u'Ando Electric Corporation',
   0x0001E3: u'Siemens AG',
   0x0001E4: u'Sitera, Inc.',
   0x0001E5: u'Supernet, Inc.',
   0x0001E6: u'Hewlett-Packard Company',
   0x0001E7: u'Hewlett-Packard Company',
   0x0001E8: u'Force10 Networks, Inc.',
   0x0001E9: u'Litton Marine Systems B.V.',
   0x0001EA: u'Cirilium Corp.',
   0x0001EB: u'C-COM Corporation',
   0x0001EC: u'Ericsson Group',
   0x0001ED: u'SETA Corp.',
   0x0001EE: u'Comtrol Europe, Ltd.',
   0x0001EF: u'Camtel Technology Corp.',
   0x0001F0: u'Tridium, Inc.',
   0x0001F1: u'Innovative Concepts, Inc.',
   0x0001F2: u'Mark of the Unicorn, Inc.',
   0x0001F3: u'QPS, Inc.',
   0x0001F4: u'Enterasys Networks',
   0x0001F5: u'ERIM S.A.',
   0x0001F6: u'Association of Musical Electronics Industry',
   0x0001F7: u'Image Display Systems, Inc.',
   0x0001F8: u'Adherent Systems, Ltd.',
   0x0001F9: u'TeraGlobal Communications Corp.',
   0x0001FA: u'HOROSCAS',
   0x0001FB: u'DoTop Technology, Inc.',
   0x0001FC: u'Keyence Corporation',
   0x0001FD: u'Digital Voice Systems, Inc.',
   0x0001FE: u'DIGITAL EQUIPMENT CORPORATION',
   0x0001FF: u'Data Direct Networks, Inc.',
   0x000200: u'Net & Sys Co., Ltd.',
   0x000201: u'IFM Electronic gmbh',
   0x000202: u'Amino Communications, Ltd.',
   0x000203: u'Woonsang Telecom, Inc.',
   0x000204: u'Bodmann Industries Elektronik GmbH',
   0x000205: u'Hitachi Denshi, Ltd.',
   0x000206: u'Telital R&D Denmark A/S',
   0x000207: u'VisionGlobal Network Corp.',
   0x000208: u'Unify Networks, Inc.',
   0x000209: u'Shenzhen SED Information Technology Co., Ltd.',
   0x00020A: u'Gefran Spa',
   0x00020B: u'Native Networks, Inc.',
   0x00020C: u'Metro-Optix',
   0x00020D: u'Micronpc.com',
   0x00020E: u'Laurel Networks, Inc.',
   0x00020F: u'AATR',
   0x000210: u'Fenecom',
   0x000211: u'Nature Worldwide Technology Corp.',
   0x000212: u'SierraCom',
   0x000213: u'S.D.E.L.',
   0x000214: u'DTVRO',
   0x000215: u'Cotas Computer Technology A/B',
   0x000216: u'Cisco Systems, Inc.',
   0x000217: u'Cisco Systems, Inc.',
   0x000218: u'Advanced Scientific Corp',
   0x000219: u'Paralon Technologies',
   0x00021A: u'Zuma Networks',
   0x00021B: u'Kollmorgen-Servotronix',
   0x00021C: u'Network Elements, Inc.',
   0x00021D: u'Data General Communication Ltd.',
   0x00021E: u'SIMTEL S.R.L.',
   0x00021F: u'Aculab PLC',
   0x000220: u'Canon Aptex, Inc.',
   0x000221: u'DSP Application, Ltd.',
   0x000222: u'Chromisys, Inc.',
   0x000223: u'ClickTV',
   0x000224: u'C-COR',
   0x000225: u'Certus Technology, Inc.',
   0x000226: u'XESystems, Inc.',
   0x000227: u'ESD GmbH',
   0x000228: u'Necsom, Ltd.',
   0x000229: u'Adtec Corporation',
   0x00022A: u'Asound Electronic',
   0x00022B: u'SAXA, Inc.',
   0x00022C: u'ABB Bomem, Inc.',
   0x00022D: u'Agere Systems',
   0x00022E: u'TEAC Corp. R& D',
   0x00022F: u'P-Cube, Ltd.',
   0x000230: u'Intersoft Electronics',
   0x000231: u'Ingersoll-Rand',
   0x000232: u'Avision, Inc.',
   0x000233: u'Mantra Communications, Inc.',
   0x000234: u'Imperial Technology, Inc.',
   0x000235: u'Paragon Networks International',
   0x000236: u'INIT GmbH',
   0x000237: u'Cosmo Research Corp.',
   0x000238: u'Serome Technology, Inc.',
   0x000239: u'Visicom',
   0x00023A: u'ZSK Stickmaschinen GmbH',
   0x00023B: u'Redback Networks',
   0x00023C: u'Creative Technology, Ltd.',
   0x00023D: u'NuSpeed, Inc.',
   0x00023E: u'Selta Telematica S.p.a',
   0x00023F: u'Compal Electronics, Inc.',
   0x000240: u'Seedek Co., Ltd.',
   0x000241: u'Amer.com',
   0x000242: u'Videoframe Systems',
   0x000243: u'Raysis Co., Ltd.',
   0x000244: u'SURECOM Technology Co.',
   0x000245: u'Lampus Co, Ltd.',
   0x000246: u'All-Win Tech Co., Ltd.',
   0x000247: u'Great Dragon Information Technology (Group) Co., Ltd.',
   0x000248: u'Pilz GmbH & Co.',
   0x000249: u'Aviv Infocom Co, Ltd.',
   0x00024A: u'Cisco Systems, Inc.',
   0x00024B: u'Cisco Systems, Inc.',
   0x00024C: u'SiByte, Inc.',
   0x00024D: u'Mannesman Dematic Colby Pty. Ltd.',
   0x00024E: u'Datacard Group',
   0x00024F: u'IPM Datacom S.R.L.',
   0x000250: u'Geyser Networks, Inc.',
   0x000251: u'Soma Networks, Inc.',
   0x000252: u'Carrier Corporation',
   0x000253: u'Televideo, Inc.',
   0x000254: u'WorldGate',
   0x000255: u'IBM Corporation',
   0x000256: u'Alpha Processor, Inc.',
   0x000257: u'Microcom Corp.',
   0x000258: u'Flying Packets Communications',
   0x000259: u'Tsann Kuen China (Shanghai)Enterprise Co., Ltd. IT Group',
   0x00025A: u'Catena Networks',
   0x00025B: u'Cambridge Silicon Radio',
   0x00025C: u'SCI Systems (Kunshan) Co., Ltd.',
   0x00025D: u'Calix Networks',
   0x00025E: u'High Technology Ltd',
   0x00025F: u'Nortel Networks',
   0x000260: u'Accordion Networks, Inc.',
   0x000261: u'Tilgin AB',
   0x000262: u'Soyo Group Soyo Com Tech Co., Ltd',
   0x000263: u'UPS Manufacturing SRL',
   0x000264: u'AudioRamp.com',
   0x000265: u'Virditech Co. Ltd.',
   0x000266: u'Thermalogic Corporation',
   0x000267: u'NODE RUNNER, INC.',
   0x000268: u'Harris Government Communications',
   0x000269: u'Nadatel Co., Ltd',
   0x00026A: u'Cocess Telecom Co., Ltd.',
   0x00026B: u'BCM Computers Co., Ltd.',
   0x00026C: u'Philips CFT',
   0x00026D: u'Adept Telecom',
   0x00026E: u'NeGeN Access, Inc.',
   0x00026F: u'Senao International Co., Ltd.',
   0x000270: u'Crewave Co., Ltd.',
   0x000271: u'Vpacket Communications',
   0x000272: u'CC&C Technologies, Inc.',
   0x000273: u'Coriolis Networks',
   0x000274: u'Tommy Technologies Corp.',
   0x000275: u'SMART Technologies, Inc.',
   0x000276: u'Primax Electronics Ltd.',
   0x000277: u'Cash Systemes Industrie',
   0x000278: u'Samsung Electro-Mechanics Co., Ltd.',
   0x000279: u'Control Applications, Ltd.',
   0x00027A: u'IOI Technology Corporation',
   0x00027B: u'Amplify Net, Inc.',
   0x00027C: u'Trilithic, Inc.',
   0x00027D: u'Cisco Systems, Inc.',
   0x00027E: u'Cisco Systems, Inc.',
   0x00027F: u'ask-technologies.com',
   0x000280: u'Mu Net, Inc.',
   0x000281: u'Madge Ltd.',
   0x000282: u'ViaClix, Inc.',
   0x000283: u'Spectrum Controls, Inc.',
   0x000284: u'AREVA T&D',
   0x000285: u'Riverstone Networks',
   0x000286: u'Occam Networks',
   0x000287: u'Adapcom',
   0x000288: u'GLOBAL VILLAGE COMMUNICATION',
   0x000289: u'DNE Technologies',
   0x00028A: u'Ambit Microsystems Corporation',
   0x00028B: u'VDSL Systems OY',
   0x00028C: u'Micrel-Synergy Semiconductor',
   0x00028D: u'Movita Technologies, Inc.',
   0x00028E: u'Rapid 5 Networks, Inc.',
   0x00028F: u'Globetek, Inc.',
   0x000290: u'Woorigisool, Inc.',
   0x000291: u'Open Network Co., Ltd.',
   0x000292: u'Logic Innovations, Inc.',
   0x000293: u'Solid Data Systems',
   0x000294: u'Tokyo Sokushin Co., Ltd.',
   0x000295: u'IP.Access Limited',
   0x000296: u'Lectron Co,. Ltd.',
   0x000297: u'C-COR.net',
   0x000298: u'Broadframe Corporation',
   0x000299: u'Apex, Inc.',
   0x00029A: u'Storage Apps',
   0x00029B: u'Kreatel Communications AB',
   0x00029C: u'3COM',
   0x00029D: u'Merix Corp.',
   0x00029E: u'Information Equipment Co., Ltd.',
   0x00029F: u'L-3 Communication Aviation Recorders',
   0x0002A0: u'Flatstack Ltd.',
   0x0002A1: u'World Wide Packets',
   0x0002A2: u'Hilscher GmbH',
   0x0002A3: u'ABB Power Automation',
   0x0002A4: u'AddPac Technology Co., Ltd.',
   0x0002A5: u'Compaq Computer Corporation',
   0x0002A6: u'Effinet Systems Co., Ltd.',
   0x0002A7: u'Vivace Networks',
   0x0002A8: u'Air Link Technology',
   0x0002A9: u'RACOM, s.r.o.',
   0x0002AA: u'PLcom Co., Ltd.',
   0x0002AB: u'CTC Union Technologies Co., Ltd.',
   0x0002AC: u'3PAR data',
   0x0002AD: u'Pentax Corpotation',
   0x0002AE: u'Scannex Electronics Ltd.',
   0x0002AF: u'TeleCruz Technology, Inc.',
   0x0002B0: u'Hokubu Communication & Industrial Co., Ltd.',
   0x0002B1: u'Anritsu, Ltd.',
   0x0002B2: u'Cablevision',
   0x0002B3: u'Intel Corporation',
   0x0002B4: u'DAPHNE',
   0x0002B5: u'Avnet, Inc.',
   0x0002B6: u'Acrosser Technology Co., Ltd.',
   0x0002B7: u'Watanabe Electric Industry Co., Ltd.',
   0x0002B8: u'WHI KONSULT AB',
   0x0002B9: u'Cisco Systems, Inc.',
   0x0002BA: u'Cisco Systems, Inc.',
   0x0002BB: u'Continuous Computing',
   0x0002BC: u'LVL 7 Systems, Inc.',
   0x0002BD: u'Bionet Co., Ltd.',
   0x0002BE: u'Totsu Engineering, Inc.',
   0x0002BF: u'dotRocket, Inc.',
   0x0002C0: u'Bencent Tzeng Industry Co., Ltd.',
   0x0002C1: u'Innovative Electronic Designs, Inc.',
   0x0002C2: u'Net Vision Telecom',
   0x0002C3: u'Arelnet Ltd.',
   0x0002C4: u'Vector International BUBA',
   0x0002C5: u'Evertz Microsystems Ltd.',
   0x0002C6: u'Data Track Technology PLC',
   0x0002C7: u'ALPS ELECTRIC Co., Ltd.',
   0x0002C8: u'Technocom Communications Technology (pte) Ltd',
   0x0002C9: u'Mellanox Technologies',
   0x0002CA: u'EndPoints, Inc.',
   0x0002CB: u'TriState Ltd.',
   0x0002CC: u'M.C.C.I',
   0x0002CD: u'TeleDream, Inc.',
   0x0002CE: u'FoxJet, Inc.',
   0x0002CF: u'ZyGate Communications, Inc.',
   0x0002D0: u'Comdial Corporation',
   0x0002D1: u'Vivotek, Inc.',
   0x0002D2: u'Workstation AG',
   0x0002D3: u'NetBotz, Inc.',
   0x0002D4: u'PDA Peripherals, Inc.',
   0x0002D5: u'ACR',
   0x0002D6: u'NICE Systems',
   0x0002D7: u'EMPEG Ltd',
   0x0002D8: u'BRECIS Communications Corporation',
   0x0002D9: u'Reliable Controls',
   0x0002DA: u'ExiO Communications, Inc.',
   0x0002DB: u'NETSEC',
   0x0002DC: u'Fujitsu General Limited',
   0x0002DD: u'Bromax Communications, Ltd.',
   0x0002DE: u'Astrodesign, Inc.',
   0x0002DF: u'Net Com Systems, Inc.',
   0x0002E0: u'ETAS GmbH',
   0x0002E1: u'Integrated Network Corporation',
   0x0002E2: u'NDC Infared Engineering',
   0x0002E3: u'LITE-ON Communications, Inc.',
   0x0002E4: u'JC HYUN Systems, Inc.',
   0x0002E5: u'Timeware Ltd.',
   0x0002E6: u'Gould Instrument Systems, Inc.',
   0x0002E7: u'CAB GmbH & Co KG',
   0x0002E8: u'E.D.&A.',
   0x0002E9: u'CS Systemes De Securite - C3S',
   0x0002EA: u'Focus Enhancements',
   0x0002EB: u'Pico Communications',
   0x0002EC: u'Maschoff Design Engineering',
   0x0002ED: u'DXO Telecom Co., Ltd.',
   0x0002EE: u'Nokia Danmark A/S',
   0x0002EF: u'CCC Network Systems Group Ltd.',
   0x0002F0: u'AME Optimedia Technology Co., Ltd.',
   0x0002F1: u'Pinetron Co., Ltd.',
   0x0002F2: u'eDevice, Inc.',
   0x0002F3: u'Media Serve Co., Ltd.',
   0x0002F4: u'PCTEL, Inc.',
   0x0002F5: u'VIVE Synergies, Inc.',
   0x0002F6: u'Equipe Communications',
   0x0002F7: u'ARM',
   0x0002F8: u'SEAKR Engineering, Inc.',
   0x0002F9: u'Mimos Semiconductor SDN BHD',
   0x0002FA: u'DX Antenna Co., Ltd.',
   0x0002FB: u'Baumuller Aulugen-Systemtechnik GmbH',
   0x0002FC: u'Cisco Systems, Inc.',
   0x0002FD: u'Cisco Systems, Inc.',
   0x0002FE: u'Viditec, Inc.',
   0x0002FF: u'Handan BroadInfoCom',
   0x000300: u'NetContinuum, Inc.',
   0x000301: u'Avantas Networks Corporation',
   0x000302: u'Charles Industries, Ltd.',
   0x000303: u'JAMA Electronics Co., Ltd.',
   0x000304: u'Pacific Broadband Communications',
   0x000305: u'Smart Network Devices GmbH',
   0x000306: u'Fusion In Tech Co., Ltd.',
   0x000307: u'Secure Works, Inc.',
   0x000308: u'AM Communications, Inc.',
   0x000309: u'Texcel Technology PLC',
   0x00030A: u'Argus Technologies',
   0x00030B: u'Hunter Technology, Inc.',
   0x00030C: u'Telesoft Technologies Ltd.',
   0x00030D: u'Uniwill Computer Corp.',
   0x00030E: u'Core Communications Co., Ltd.',
   0x00030F: u'Digital China (Shanghai) Networks Ltd.',
   0x000310: u'Link Evolution Corp.',
   0x000311: u'Micro Technology Co., Ltd.',
   0x000312: u'TR-Systemtechnik GmbH',
   0x000313: u'Access Media SPA',
   0x000314: u'Teleware Network Systems',
   0x000315: u'Cidco Incorporated',
   0x000316: u'Nobell Communications, Inc.',
   0x000317: u'Merlin Systems, Inc.',
   0x000318: u'Cyras Systems, Inc.',
   0x000319: u'Infineon AG',
   0x00031A: u'Beijing Broad Telecom Ltd., China',
   0x00031B: u'Cellvision Systems, Inc.',
   0x00031C: u'Svenska Hardvarufabriken AB',
   0x00031D: u'Taiwan Commate Computer, Inc.',
   0x00031E: u'Optranet, Inc.',
   0x00031F: u'Condev Ltd.',
   0x000320: u'Xpeed, Inc.',
   0x000321: u'Reco Research Co., Ltd.',
   0x000322: u'IDIS Co., Ltd.',
   0x000323: u'Cornet Technology, Inc.',
   0x000324: u'SANYO Multimedia Tottori Co., Ltd.',
   0x000325: u'Arima Computer Corp.',
   0x000326: u'Iwasaki Information Systems Co., Ltd.',
   0x000327: u'ACT\'L',
   0x000328: u'Mace Group, Inc.',
   0x000329: u'F3, Inc.',
   0x00032A: u'UniData Communication Systems, Inc.',
   0x00032B: u'GAI Datenfunksysteme GmbH',
   0x00032C: u'ABB Industrie AG',
   0x00032D: u'IBASE Technology, Inc.',
   0x00032E: u'Scope Information Management, Ltd.',
   0x00032F: u'Global Sun Technology, Inc.',
   0x000330: u'Imagenics, Co., Ltd.',
   0x000331: u'Cisco Systems, Inc.',
   0x000332: u'Cisco Systems, Inc.',
   0x000333: u'Digitel Co., Ltd.',
   0x000334: u'Newport Electronics',
   0x000335: u'Mirae Technology',
   0x000336: u'Zetes Technologies',
   0x000337: u'Vaone, Inc.',
   0x000338: u'Oak Technology',
   0x000339: u'Eurologic Systems, Ltd.',
   0x00033A: u'Silicon Wave, Inc.',
   0x00033B: u'TAMI Tech Co., Ltd.',
   0x00033C: u'Daiden Co., Ltd.',
   0x00033D: u'ILSHin Lab',
   0x00033E: u'Tateyama System Laboratory Co., Ltd.',
   0x00033F: u'BigBand Networks, Ltd.',
   0x000340: u'Floware Wireless Systems, Ltd.',
   0x000341: u'Axon Digital Design',
   0x000342: u'Nortel Networks',
   0x000343: u'Martin Professional A/S',
   0x000344: u'Tietech.Co., Ltd.',
   0x000345: u'Routrek Networks Corporation',
   0x000346: u'Hitachi Kokusai Electric, Inc.',
   0x000347: u'Intel Corporation',
   0x000348: u'Norscan Instruments, Ltd.',
   0x000349: u'Vidicode Datacommunicatie B.V.',
   0x00034A: u'RIAS Corporation',
   0x00034B: u'Nortel Networks',
   0x00034C: u'Shanghai DigiVision Technology Co., Ltd.',
   0x00034D: u'Chiaro Networks, Ltd.',
   0x00034E: u'Pos Data Company, Ltd.',
   0x00034F: u'Sur-Gard Security',
   0x000350: u'BTICINO SPA',
   0x000351: u'Diebold, Inc.',
   0x000352: u'Colubris Networks',
   0x000353: u'Mitac, Inc.',
   0x000354: u'Fiber Logic Communications',
   0x000355: u'TeraBeam Internet Systems',
   0x000356: u'Wincor Nixdorf GmbH & Co KG',
   0x000357: u'Intervoice-Brite, Inc.',
   0x000358: u'Hanyang Digitech Co., Ltd.',
   0x000359: u'DigitalSis',
   0x00035A: u'Photron Limited',
   0x00035B: u'BridgeWave Communications',
   0x00035C: u'Saint Song Corp.',
   0x00035D: u'Bosung Hi-Net Co., Ltd.',
   0x00035E: u'Metropolitan Area Networks, Inc.',
   0x00035F: u'Prueftechnik Condition Monitoring GmbH & Co. KG',
   0x000360: u'PAC Interactive Technology, Inc.',
   0x000361: u'Widcomm, Inc.',
   0x000362: u'Vodtel Communications, Inc.',
   0x000363: u'Miraesys Co., Ltd.',
   0x000364: u'Scenix Semiconductor, Inc.',
   0x000365: u'Kira Information & Communications, Ltd.',
   0x000366: u'ASM Pacific Technology',
   0x000367: u'Jasmine Networks, Inc.',
   0x000368: u'Embedone Co., Ltd.',
   0x000369: u'Nippon Antenna Co., Ltd.',
   0x00036A: u'Mainnet, Ltd.',
   0x00036B: u'Cisco Systems, Inc.',
   0x00036C: u'Cisco Systems, Inc.',
   0x00036D: u'Runtop, Inc.',
   0x00036E: u'Nicon Systems (Pty) Limited',
   0x00036F: u'Telsey SPA',
   0x000370: u'NXTV, Inc.',
   0x000371: u'Acomz Networks Corp.',
   0x000372: u'ULAN',
   0x000373: u'Aselsan A.S',
   0x000374: u'Hunter Watertech',
   0x000375: u'NetMedia, Inc.',
   0x000376: u'Graphtec Technology, Inc.',
   0x000377: u'Gigabit Wireless',
   0x000378: u'HUMAX Co., Ltd.',
   0x000379: u'Proscend Communications, Inc.',
   0x00037A: u'Taiyo Yuden Co., Ltd.',
   0x00037B: u'IDEC IZUMI Corporation',
   0x00037C: u'Coax Media',
   0x00037D: u'Stellcom',
   0x00037E: u'PORTech Communications, Inc.',
   0x00037F: u'Atheros Communications, Inc.',
   0x000380: u'SSH Communications Security Corp.',
   0x000381: u'Ingenico International',
   0x000382: u'A-One Co., Ltd.',
   0x000383: u'Metera Networks, Inc.',
   0x000384: u'AETA',
   0x000385: u'Actelis Networks, Inc.',
   0x000386: u'Ho Net, Inc.',
   0x000387: u'Blaze Network Products',
   0x000388: u'Fastfame Technology Co., Ltd.',
   0x000389: u'Plantronics',
   0x00038A: u'America Online, Inc.',
   0x00038B: u'PLUS-ONE I&T, Inc.',
   0x00038C: u'Total Impact',
   0x00038D: u'PCS Revenue Control Systems, Inc.',
   0x00038E: u'Atoga Systems, Inc.',
   0x00038F: u'Weinschel Corporation',
   0x000390: u'Digital Video Communications, Inc.',
   0x000391: u'Advanced Digital Broadcast, Ltd.',
   0x000392: u'Hyundai Teletek Co., Ltd.',
   0x000393: u'Apple Computer, Inc.',
   0x000394: u'Connect One',
   0x000395: u'California Amplifier',
   0x000396: u'EZ Cast Co., Ltd.',
   0x000397: u'Watchfront Electronics',
   0x000398: u'WISI',
   0x000399: u'Dongju Informations & Communications Co., Ltd.',
   0x00039A: u'SiConnect',
   0x00039B: u'NetChip Technology, Inc.',
   0x00039C: u'OptiMight Communications, Inc.',
   0x00039D: u'BENQ CORPORATION',
   0x00039E: u'Tera System Co., Ltd.',
   0x00039F: u'Cisco Systems, Inc.',
   0x0003A0: u'Cisco Systems, Inc.',
   0x0003A1: u'HIPER Information & Communication, Inc.',
   0x0003A2: u'Catapult Communications',
   0x0003A3: u'MAVIX, Ltd.',
   0x0003A4: u'Data Storage and Information Management',
   0x0003A5: u'Medea Corporation',
   0x0003A6: u'Traxit Technology, Inc.',
   0x0003A7: u'Unixtar Technology, Inc.',
   0x0003A8: u'IDOT Computers, Inc.',
   0x0003A9: u'AXCENT Media AG',
   0x0003AA: u'Watlow',
   0x0003AB: u'Bridge Information Systems',
   0x0003AC: u'Fronius Schweissmaschinen',
   0x0003AD: u'Emerson Energy Systems AB',
   0x0003AE: u'Allied Advanced Manufacturing Pte, Ltd.',
   0x0003AF: u'Paragea Communications',
   0x0003B0: u'Xsense Technology Corp.',
   0x0003B1: u'Hospira Inc.',
   0x0003B2: u'Radware',
   0x0003B3: u'IA Link Systems Co., Ltd.',
   0x0003B4: u'Macrotek International Corp.',
   0x0003B5: u'Entra Technology Co.',
   0x0003B6: u'QSI Corporation',
   0x0003B7: u'ZACCESS Systems',
   0x0003B8: u'NetKit Solutions, LLC',
   0x0003B9: u'Hualong Telecom Co., Ltd.',
   0x0003BA: u'Sun Microsystems',
   0x0003BB: u'Signal Communications Limited',
   0x0003BC: u'COT GmbH',
   0x0003BD: u'OmniCluster Technologies, Inc.',
   0x0003BE: u'Netility',
   0x0003BF: u'Centerpoint Broadband Technologies, Inc.',
   0x0003C0: u'RFTNC Co., Ltd.',
   0x0003C1: u'Packet Dynamics Ltd',
   0x0003C2: u'Solphone K.K.',
   0x0003C3: u'Micronik Multimedia',
   0x0003C4: u'Tomra Systems ASA',
   0x0003C5: u'Mobotix AG',
   0x0003C6: u'ICUE Systems, Inc.',
   0x0003C7: u'hopf Elektronik GmbH',
   0x0003C8: u'CML Emergency Services',
   0x0003C9: u'TECOM Co., Ltd.',
   0x0003CA: u'MTS Systems Corp.',
   0x0003CB: u'Nippon Systems Development Co., Ltd.',
   0x0003CC: u'Momentum Computer, Inc.',
   0x0003CD: u'Clovertech, Inc.',
   0x0003CE: u'ETEN Technologies, Inc.',
   0x0003CF: u'Muxcom, Inc.',
   0x0003D0: u'KOANKEISO Co., Ltd.',
   0x0003D1: u'Takaya Corporation',
   0x0003D2: u'Crossbeam Systems, Inc.',
   0x0003D3: u'Internet Energy Systems, Inc.',
   0x0003D4: u'Alloptic, Inc.',
   0x0003D5: u'Advanced Communications Co., Ltd.',
   0x0003D6: u'RADVision, Ltd.',
   0x0003D7: u'NextNet Wireless, Inc.',
   0x0003D8: u'iMPath Networks, Inc.',
   0x0003D9: u'Secheron SA',
   0x0003DA: u'Takamisawa Cybernetics Co., Ltd.',
   0x0003DB: u'Apogee Electronics Corp.',
   0x0003DC: u'Lexar Media, Inc.',
   0x0003DD: u'Comark Corp.',
   0x0003DE: u'OTC Wireless',
   0x0003DF: u'Desana Systems',
   0x0003E0: u'RadioFrame Networks, Inc.',
   0x0003E1: u'Winmate Communication, Inc.',
   0x0003E2: u'Comspace Corporation',
   0x0003E3: u'Cisco Systems, Inc.',
   0x0003E4: u'Cisco Systems, Inc.',
   0x0003E5: u'Hermstedt SG',
   0x0003E6: u'Entone Technologies, Inc.',
   0x0003E7: u'Logostek Co. Ltd.',
   0x0003E8: u'Wavelength Digital Limited',
   0x0003E9: u'Akara Canada, Inc.',
   0x0003EA: u'Mega System Technologies, Inc.',
   0x0003EB: u'Atrica',
   0x0003EC: u'ICG Research, Inc.',
   0x0003ED: u'Shinkawa Electric Co., Ltd.',
   0x0003EE: u'MKNet Corporation',
   0x0003EF: u'Oneline AG',
   0x0003F0: u'Redfern Broadband Networks',
   0x0003F1: u'Cicada Semiconductor, Inc.',
   0x0003F2: u'Seneca Networks',
   0x0003F3: u'Dazzle Multimedia, Inc.',
   0x0003F4: u'NetBurner',
   0x0003F5: u'Chip2Chip',
   0x0003F6: u'Allegro Networks, Inc.',
   0x0003F7: u'Plast-Control GmbH',
   0x0003F8: u'SanCastle Technologies, Inc.',
   0x0003F9: u'Pleiades Communications, Inc.',
   0x0003FA: u'TiMetra Networks',
   0x0003FB: u'Toko Seiki Company, Ltd.',
   0x0003FC: u'Intertex Data AB',
   0x0003FD: u'Cisco Systems, Inc.',
   0x0003FE: u'Cisco Systems, Inc.',
   0x0003FF: u'Microsoft Corporation',
   0x000400: u'LEXMARK INTERNATIONAL, INC.',
   0x000401: u'Osaki Electric Co., Ltd.',
   0x000402: u'Nexsan Technologies, Ltd.',
   0x000403: u'Nexsi Corporation',
   0x000404: u'Makino Milling Machine Co., Ltd.',
   0x000405: u'ACN Technologies',
   0x000406: u'Fa. Metabox AG',
   0x000407: u'Topcon Positioning Systems, Inc.',
   0x000408: u'Sanko Electronics Co., Ltd.',
   0x000409: u'Cratos Networks',
   0x00040A: u'Sage Systems',
   0x00040B: u'3com Europe Ltd.',
   0x00040C: u'KANNO Work\'s Ltd.',
   0x00040D: u'Avaya, Inc.',
   0x00040E: u'AVM GmbH',
   0x00040F: u'Asus Network Technologies, Inc.',
   0x000410: u'Spinnaker Networks, Inc.',
   0x000411: u'Inkra Networks, Inc.',
   0x000412: u'WaveSmith Networks, Inc.',
   0x000413: u'SNOM Technology AG',
   0x000414: u'Umezawa Musen Denki Co., Ltd.',
   0x000415: u'Rasteme Systems Co., Ltd.',
   0x000416: u'Parks S/A Comunicacoes Digitais',
   0x000417: u'ELAU AG',
   0x000418: u'Teltronic S.A.U.',
   0x000419: u'Fibercycle Networks, Inc.',
   0x00041A: u'ines GmbH',
   0x00041B: u'Digital Interfaces Ltd.',
   0x00041C: u'ipDialog, Inc.',
   0x00041D: u'Corega of America',
   0x00041E: u'Shikoku Instrumentation Co., Ltd.',
   0x00041F: u'Sony Computer Entertainment, Inc.',
   0x000420: u'Slim Devices, Inc.',
   0x000421: u'Ocular Networks',
   0x000422: u'Gordon Kapes, Inc.',
   0x000423: u'Intel Corporation',
   0x000424: u'TMC s.r.l.',
   0x000425: u'Atmel Corporation',
   0x000426: u'Autosys',
   0x000427: u'Cisco Systems, Inc.',
   0x000428: u'Cisco Systems, Inc.',
   0x000429: u'Pixord Corporation',
   0x00042A: u'Wireless Networks, Inc.',
   0x00042B: u'IT Access Co., Ltd.',
   0x00042C: u'Minet, Inc.',
   0x00042D: u'Sarian Systems, Ltd.',
   0x00042E: u'Netous Technologies, Ltd.',
   0x00042F: u'International Communications Products, Inc.',
   0x000430: u'Netgem',
   0x000431: u'GlobalStreams, Inc.',
   0x000432: u'Voyetra Turtle Beach, Inc.',
   0x000433: u'Cyberboard A/S',
   0x000434: u'Accelent Systems, Inc.',
   0x000435: u'Comptek International, Inc.',
   0x000436: u'ELANsat Technologies, Inc.',
   0x000437: u'Powin Information Technology, Inc.',
   0x000438: u'Nortel Networks',
   0x000439: u'Rosco Entertainment Technology, Inc.',
   0x00043A: u'Intelligent Telecommunications, Inc.',
   0x00043B: u'Lava Computer Mfg., Inc.',
   0x00043C: u'SONOS Co., Ltd.',
   0x00043D: u'INDEL AG',
   0x00043E: u'Telencomm',
   0x00043F: u'Electronic Systems Technology, Inc.',
   0x000440: u'cyberPIXIE, Inc.',
   0x000441: u'Half Dome Systems, Inc.',
   0x000442: u'NACT',
   0x000443: u'Agilent Technologies, Inc.',
   0x000444: u'Western Multiplex Corporation',
   0x000445: u'LMS Skalar Instruments GmbH',
   0x000446: u'CYZENTECH Co., Ltd.',
   0x000447: u'Acrowave Systems Co., Ltd.',
   0x000448: u'Polaroid Professional Imaging',
   0x000449: u'Mapletree Networks',
   0x00044A: u'iPolicy Networks, Inc.',
   0x00044B: u'NVIDIA',
   0x00044C: u'JENOPTIK',
   0x00044D: u'Cisco Systems, Inc.',
   0x00044E: u'Cisco Systems, Inc.',
   0x00044F: u'Leukhardt Systemelektronik GmbH',
   0x000450: u'DMD Computers SRL',
   0x000451: u'Medrad, Inc.',
   0x000452: u'RocketLogix, Inc.',
   0x000453: u'YottaYotta, Inc.',
   0x000454: u'Quadriga UK',
   0x000455: u'ANTARA.net',
   0x000456: u'PipingHot Networks',
   0x000457: u'Universal Access Technology, Inc.',
   0x000458: u'Fusion X Co., Ltd.',
   0x000459: u'Veristar Corporation',
   0x00045A: u'The Linksys Group, Inc.',
   0x00045B: u'Techsan Electronics Co., Ltd.',
   0x00045C: u'Mobiwave Pte Ltd',
   0x00045D: u'BEKA Elektronik',
   0x00045E: u'PolyTrax Information Technology AG',
   0x00045F: u'Evalue Technology, Inc.',
   0x000460: u'Knilink Technology, Inc.',
   0x000461: u'EPOX Computer Co., Ltd.',
   0x000462: u'DAKOS Data & Communication Co., Ltd.',
   0x000463: u'Bosch Security Systems',
   0x000464: u'Fantasma Networks, Inc.',
   0x000465: u'i.s.t isdn-support technik GmbH',
   0x000466: u'ARMITEL Co.',
   0x000467: u'Wuhan Research Institute of MII',
   0x000468: u'Vivity, Inc.',
   0x000469: u'Innocom, Inc.',
   0x00046A: u'Navini Networks',
   0x00046B: u'Palm Wireless, Inc.',
   0x00046C: u'Cyber Technology Co., Ltd.',
   0x00046D: u'Cisco Systems, Inc.',
   0x00046E: u'Cisco Systems, Inc.',
   0x00046F: u'Digitel S/A Industria Eletronica',
   0x000470: u'ipUnplugged AB',
   0x000471: u'IPrad',
   0x000472: u'Telelynx, Inc.',
   0x000473: u'Photonex Corporation',
   0x000474: u'LEGRAND',
   0x000475: u'3 Com Corporation',
   0x000476: u'3 Com Corporation',
   0x000477: u'Scalant Systems, Inc.',
   0x000478: u'G. Star Technology Corporation',
   0x000479: u'Radius Co., Ltd.',
   0x00047A: u'AXXESSIT ASA',
   0x00047B: u'Schlumberger',
   0x00047C: u'Skidata AG',
   0x00047D: u'Pelco',
   0x00047E: u'Optelecom=NKF',
   0x00047F: u'Chr. Mayr GmbH & Co. KG',
   0x000480: u'Foundry Networks, Inc.',
   0x000481: u'Econolite Control Products, Inc.',
   0x000482: u'Medialogic Corp.',
   0x000483: u'Deltron Technology, Inc.',
   0x000484: u'Amann GmbH',
   0x000485: u'PicoLight',
   0x000486: u'ITTC, University of Kansas',
   0x000487: u'Cogency Semiconductor, Inc.',
   0x000488: u'Eurotherm Controls',
   0x000489: u'YAFO Networks, Inc.',
   0x00048A: u'Temia Vertriebs GmbH',
   0x00048B: u'Poscon Corporation',
   0x00048C: u'Nayna Networks, Inc.',
   0x00048D: u'Tone Commander Systems, Inc.',
   0x00048E: u'Ohm Tech Labs, Inc.',
   0x00048F: u'TD Systems Corp.',
   0x000490: u'Optical Access',
   0x000491: u'Technovision, Inc.',
   0x000492: u'Hive Internet, Ltd.',
   0x000493: u'Tsinghua Unisplendour Co., Ltd.',
   0x000494: u'Breezecom, Ltd.',
   0x000495: u'Tejas Networks',
   0x000496: u'Extreme Networks',
   0x000497: u'MacroSystem Digital Video AG',
   0x000498: u'Mahi Networks',
   0x000499: u'Chino Corporation',
   0x00049A: u'Cisco Systems, Inc.',
   0x00049B: u'Cisco Systems, Inc.',
   0x00049C: u'Surgient Networks, Inc.',
   0x00049D: u'Ipanema Technologies',
   0x00049E: u'Wirelink Co., Ltd.',
   0x00049F: u'Freescale Semiconductor',
   0x0004A0: u'Verity Instruments, Inc.',
   0x0004A1: u'Pathway Connectivity',
   0x0004A2: u'L.S.I. Japan Co., Ltd.',
   0x0004A3: u'Microchip Technology, Inc.',
   0x0004A4: u'NetEnabled, Inc.',
   0x0004A5: u'Barco Projection Systems NV',
   0x0004A6: u'SAF Tehnika Ltd.',
   0x0004A7: u'FabiaTech Corporation',
   0x0004A8: u'Broadmax Technologies, Inc.',
   0x0004A9: u'SandStream Technologies, Inc.',
   0x0004AA: u'Jetstream Communications',
   0x0004AB: u'Comverse Network Systems, Inc.',
   0x0004AC: u'IBM CORP.',
   0x0004AD: u'Malibu Networks',
   0x0004AE: u'Liquid Metronics',
   0x0004AF: u'Digital Fountain, Inc.',
   0x0004B0: u'ELESIGN Co., Ltd.',
   0x0004B1: u'Signal Technology, Inc.',
   0x0004B2: u'ESSEGI SRL',
   0x0004B3: u'Videotek, Inc.',
   0x0004B4: u'CIAC',
   0x0004B5: u'Equitrac Corporation',
   0x0004B6: u'Stratex Networks, Inc.',
   0x0004B7: u'AMB i.t. Holding',
   0x0004B8: u'Kumahira Co., Ltd.',
   0x0004B9: u'S.I. Soubou, Inc.',
   0x0004BA: u'KDD Media Will Corporation',
   0x0004BB: u'Bardac Corporation',
   0x0004BC: u'Giantec, Inc.',
   0x0004BD: u'Motorola BCS',
   0x0004BE: u'OptXCon, Inc.',
   0x0004BF: u'VersaLogic Corp.',
   0x0004C0: u'Cisco Systems, Inc.',
   0x0004C1: u'Cisco Systems, Inc.',
   0x0004C2: u'Magnipix, Inc.',
   0x0004C3: u'CASTOR Informatique',
   0x0004C4: u'Allen & Heath Limited',
   0x0004C5: u'ASE Technologies, USA',
   0x0004C6: u'Yamaha Motor Co., Ltd.',
   0x0004C7: u'NetMount',
   0x0004C8: u'LIBA Maschinenfabrik GmbH',
   0x0004C9: u'Micro Electron Co., Ltd.',
   0x0004CA: u'FreeMs Corp.',
   0x0004CB: u'Tdsoft Communication, Ltd.',
   0x0004CC: u'Peek Traffic B.V.',
   0x0004CD: u'Informedia Research Group',
   0x0004CE: u'Patria Ailon',
   0x0004CF: u'Seagate Technology',
   0x0004D0: u'Softlink s.r.o.',
   0x0004D1: u'Drew Technologies, Inc.',
   0x0004D2: u'Adcon Telemetry GmbH',
   0x0004D3: u'Toyokeiki Co., Ltd.',
   0x0004D4: u'Proview Electronics Co., Ltd.',
   0x0004D5: u'Hitachi Communication Systems, Inc.',
   0x0004D6: u'Takagi Industrial Co., Ltd.',
   0x0004D7: u'Omitec Instrumentation Ltd.',
   0x0004D8: u'IPWireless, Inc.',
   0x0004D9: u'Titan Electronics, Inc.',
   0x0004DA: u'Relax Technology, Inc.',
   0x0004DB: u'Tellus Group Corp.',
   0x0004DC: u'Nortel Networks',
   0x0004DD: u'Cisco Systems, Inc.',
   0x0004DE: u'Cisco Systems, Inc.',
   0x0004DF: u'Teracom Telematica Ltda.',
   0x0004E0: u'Procket Networks',
   0x0004E1: u'Infinior Microsystems',
   0x0004E2: u'SMC Networks, Inc.',
   0x0004E3: u'Accton Technology Corp.',
   0x0004E4: u'Daeryung Ind., Inc.',
   0x0004E5: u'Glonet Systems, Inc.',
   0x0004E6: u'Banyan Network Private Limited',
   0x0004E7: u'Lightpointe Communications, Inc',
   0x0004E8: u'IER, Inc.',
   0x0004E9: u'Infiniswitch Corporation',
   0x0004EA: u'Hewlett-Packard Company',
   0x0004EB: u'Paxonet Communications, Inc.',
   0x0004EC: u'Memobox SA',
   0x0004ED: u'Billion Electric Co., Ltd.',
   0x0004EE: u'Lincoln Electric Company',
   0x0004EF: u'Polestar Corp.',
   0x0004F0: u'International Computers, Ltd',
   0x0004F1: u'WhereNet',
   0x0004F2: u'Polycom',
   0x0004F3: u'FS FORTH-SYSTEME GmbH',
   0x0004F4: u'Infinite Electronics Inc.',
   0x0004F5: u'SnowShore Networks, Inc.',
   0x0004F6: u'Amphus',
   0x0004F7: u'Omega Band, Inc.',
   0x0004F8: u'QUALICABLE TV Industria E Com., Ltda',
   0x0004F9: u'Xtera Communications, Inc.',
   0x0004FA: u'NBS Technologies Inc.',
   0x0004FB: u'Commtech, Inc.',
   0x0004FC: u'Stratus Computer (DE), Inc.',
   0x0004FD: u'Japan Control Engineering Co., Ltd.',
   0x0004FE: u'Pelago Networks',
   0x0004FF: u'Acronet Co., Ltd.',
   0x000500: u'Cisco Systems, Inc.',
   0x000501: u'Cisco Systems, Inc.',
   0x000502: u'APPLE COMPUTER',
   0x000503: u'ICONAG',
   0x000504: u'Naray Information & Communication Enterprise',
   0x000505: u'Systems Integration Solutions, Inc.',
   0x000506: u'Reddo Networks AB',
   0x000507: u'Fine Appliance Corp.',
   0x000508: u'Inetcam, Inc.',
   0x000509: u'AVOC Nishimura Ltd.',
   0x00050A: u'ICS Spa',
   0x00050B: u'SICOM Systems, Inc.',
   0x00050C: u'Network Photonics, Inc.',
   0x00050D: u'Midstream Technologies, Inc.',
   0x00050E: u'3ware, Inc.',
   0x00050F: u'Tanaka S/S Ltd.',
   0x000510: u'Infinite Shanghai Communication Terminals Ltd.',
   0x000511: u'Complementary Technologies Ltd',
   0x000512: u'MeshNetworks, Inc.',
   0x000513: u'VTLinx Multimedia Systems, Inc.',
   0x000514: u'KDT Systems Co., Ltd.',
   0x000515: u'Nuark Co., Ltd.',
   0x000516: u'SMART Modular Technologies',
   0x000517: u'Shellcomm, Inc.',
   0x000518: u'Jupiters Technology',
   0x000519: u'Siemens Building Technologies AG,',
   0x00051A: u'3Com Europe Ltd.',
   0x00051B: u'Magic Control Technology Corporation',
   0x00051C: u'Xnet Technology Corp.',
   0x00051D: u'Airocon, Inc.',
   0x00051E: u'Brocade Communications Systems, Inc.',
   0x00051F: u'Taijin Media Co., Ltd.',
   0x000520: u'Smartronix, Inc.',
   0x000521: u'Control Microsystems',
   0x000522: u'LEA*D Corporation, Inc.',
   0x000523: u'AVL List GmbH',
   0x000524: u'BTL System (HK) Limited',
   0x000525: u'Puretek Industrial Co., Ltd.',
   0x000526: u'IPAS GmbH',
   0x000527: u'SJ Tek Co. Ltd',
   0x000528: u'New Focus, Inc.',
   0x000529: u'Shanghai Broadan Communication Technology Co., Ltd',
   0x00052A: u'Ikegami Tsushinki Co., Ltd.',
   0x00052B: u'HORIBA, Ltd.',
   0x00052C: u'Supreme Magic Corporation',
   0x00052D: u'Zoltrix International Limited',
   0x00052E: u'Cinta Networks',
   0x00052F: u'Leviton Voice and Data',
   0x000530: u'Andiamo Systems, Inc.',
   0x000531: u'Cisco Systems, Inc.',
   0x000532: u'Cisco Systems, Inc.',
   0x000533: u'Sanera Systems, Inc.',
   0x000534: u'Northstar Engineering Ltd.',
   0x000535: u'Chip PC Ltd.',
   0x000536: u'Danam Communications, Inc.',
   0x000537: u'Nets Technology Co., Ltd.',
   0x000538: u'Merilus, Inc.',
   0x000539: u'A Brand New World in Sweden AB',
   0x00053A: u'Willowglen Services Pte Ltd',
   0x00053B: u'Harbour Networks Ltd., Co. Beijing',
   0x00053C: u'Xircom',
   0x00053D: u'Agere Systems',
   0x00053E: u'KID Systeme GmbH',
   0x00053F: u'VisionTek, Inc.',
   0x000540: u'FAST Corporation',
   0x000541: u'Advanced Systems Co., Ltd.',
   0x000542: u'Otari, Inc.',
   0x000543: u'IQ Wireless GmbH',
   0x000544: u'Valley Technologies, Inc.',
   0x000545: u'Internet Photonics',
   0x000546: u'KDDI Network & Solultions Inc.',
   0x000547: u'Starent Networks',
   0x000548: u'Disco Corporation',
   0x000549: u'Salira Optical Network Systems',
   0x00054A: u'Ario Data Networks, Inc.',
   0x00054B: u'Micro Innovation AG',
   0x00054C: u'RF Innovations Pty Ltd',
   0x00054D: u'Brans Technologies, Inc.',
   0x00054E: u'Philips Components',
   0x00054F: u'PRIVATE',
   0x000550: u'Vcomms Limited',
   0x000551: u'F & S Elektronik Systeme GmbH',
   0x000552: u'Xycotec Computer GmbH',
   0x000553: u'DVC Company, Inc.',
   0x000554: u'Rangestar Wireless',
   0x000555: u'Japan Cash Machine Co., Ltd.',
   0x000556: u'360 Systems',
   0x000557: u'Agile TV Corporation',
   0x000558: u'Synchronous, Inc.',
   0x000559: u'Intracom S.A.',
   0x00055A: u'Power Dsine Ltd.',
   0x00055B: u'Charles Industries, Ltd.',
   0x00055C: u'Kowa Company, Ltd.',
   0x00055D: u'D-Link Systems, Inc.',
   0x00055E: u'Cisco Systems, Inc.',
   0x00055F: u'Cisco Systems, Inc.',
   0x000560: u'LEADER COMM.CO., LTD',
   0x000561: u'nac Image Technology, Inc.',
   0x000562: u'Digital View Limited',
   0x000563: u'J-Works, Inc.',
   0x000564: u'Tsinghua Bitway Co., Ltd.',
   0x000565: u'Tailyn Communication Company Ltd.',
   0x000566: u'Secui.com Corporation',
   0x000567: u'Etymonic Design, Inc.',
   0x000568: u'Piltofish Networks AB',
   0x000569: u'VMWARE, Inc.',
   0x00056A: u'Heuft Systemtechnik GmbH',
   0x00056B: u'C.P. Technology Co., Ltd.',
   0x00056C: u'Hung Chang Co., Ltd.',
   0x00056D: u'Pacific Corporation',
   0x00056E: u'National Enhance Technology, Inc.',
   0x00056F: u'Innomedia Technologies Pvt. Ltd.',
   0x000570: u'Baydel Ltd.',
   0x000571: u'Seiwa Electronics Co.',
   0x000572: u'Deonet Co., Ltd.',
   0x000573: u'Cisco Systems, Inc.',
   0x000574: u'Cisco Systems, Inc.',
   0x000575: u'CDS-Electronics BV',
   0x000576: u'NSM Technology Ltd.',
   0x000577: u'SM Information & Communication',
   0x000578: u'PRIVATE',
   0x000579: u'Universal Control Solution Corp.',
   0x00057A: u'Hatteras Networks',
   0x00057B: u'Chung Nam Electronic Co., Ltd.',
   0x00057C: u'RCO Security AB',
   0x00057D: u'Sun Communications, Inc.',
   0x00057E: u'Eckelmann Steuerungstechnik GmbH',
   0x00057F: u'Acqis Technology',
   0x000580: u'Fibrolan Ltd.',
   0x000581: u'Snell & Wilcox Ltd.',
   0x000582: u'ClearCube Technology',
   0x000583: u'ImageCom Limited',
   0x000584: u'AbsoluteValue Systems, Inc.',
   0x000585: u'Juniper Networks, Inc.',
   0x000586: u'Lucent Technologies',
   0x000587: u'Locus, Incorporated',
   0x000588: u'Sensoria Corp.',
   0x000589: u'National Datacomputer',
   0x00058A: u'Netcom Co., Ltd.',
   0x00058B: u'IPmental, Inc.',
   0x00058C: u'Opentech Inc.',
   0x00058D: u'Lynx Photonic Networks, Inc.',
   0x00058E: u'Flextronics International GmbH & Co. Nfg. KG',
   0x00058F: u'CLCsoft co.',
   0x000590: u'Swissvoice Ltd.',
   0x000591: u'Active Silicon Ltd.',
   0x000592: u'Pultek Corp.',
   0x000593: u'Grammar Engine Inc.',
   0x000594: u'IXXAT Automation GmbH',
   0x000595: u'Alesis Corporation',
   0x000596: u'Genotech Co., Ltd.',
   0x000597: u'Eagle Traffic Control Systems',
   0x000598: u'CRONOS S.r.l.',
   0x000599: u'DRS Test and Energy Management or DRS-TEM',
   0x00059A: u'Cisco Systems, Inc.',
   0x00059B: u'Cisco Systems, Inc.',
   0x00059C: u'Kleinknecht GmbH, Ing. Buero',
   0x00059D: u'Daniel Computing Systems, Inc.',
   0x00059E: u'Zinwell Corporation',
   0x00059F: u'Yotta Networks, Inc.',
   0x0005A0: u'MOBILINE Kft.',
   0x0005A1: u'Zenocom',
   0x0005A2: u'CELOX Networks',
   0x0005A3: u'QEI, Inc.',
   0x0005A4: u'Lucid Voice Ltd.',
   0x0005A5: u'KOTT',
   0x0005A6: u'Extron Electronics',
   0x0005A7: u'Hyperchip, Inc.',
   0x0005A8: u'WYLE ELECTRONICS',
   0x0005A9: u'Princeton Networks, Inc.',
   0x0005AA: u'Moore Industries International Inc.',
   0x0005AB: u'Cyber Fone, Inc.',
   0x0005AC: u'Northern Digital, Inc.',
   0x0005AD: u'Topspin Communications, Inc.',
   0x0005AE: u'Mediaport USA',
   0x0005AF: u'InnoScan Computing A/S',
   0x0005B0: u'Korea Computer Technology Co., Ltd.',
   0x0005B1: u'ASB Technology BV',
   0x0005B2: u'Medison Co., Ltd.',
   0x0005B3: u'Asahi-Engineering Co., Ltd.',
   0x0005B4: u'Aceex Corporation',
   0x0005B5: u'Broadcom Technologies',
   0x0005B6: u'INSYS Microelectronics GmbH',
   0x0005B7: u'Arbor Technology Corp.',
   0x0005B8: u'Electronic Design Associates, Inc.',
   0x0005B9: u'Airvana, Inc.',
   0x0005BA: u'Area Netwoeks, Inc.',
   0x0005BB: u'Myspace AB',
   0x0005BC: u'Resorsys Ltd.',
   0x0005BD: u'ROAX BV',
   0x0005BE: u'Kongsberg Seatex AS',
   0x0005BF: u'JustEzy Technology, Inc.',
   0x0005C0: u'Digital Network Alacarte Co., Ltd.',
   0x0005C1: u'A-Kyung Motion, Inc.',
   0x0005C2: u'Soronti, Inc.',
   0x0005C3: u'Pacific Instruments, Inc.',
   0x0005C4: u'Telect, Inc.',
   0x0005C5: u'Flaga HF',
   0x0005C6: u'Triz Communications',
   0x0005C7: u'I/F-COM A/S',
   0x0005C8: u'VERYTECH',
   0x0005C9: u'LG Innotek',
   0x0005CA: u'Hitron Technology, Inc.',
   0x0005CB: u'ROIS Technologies, Inc.',
   0x0005CC: u'Sumtel Communications, Inc.',
   0x0005CD: u'Denon, Ltd.',
   0x0005CE: u'Prolink Microsystems Corporation',
   0x0005CF: u'Thunder River Technologies, Inc.',
   0x0005D0: u'Solinet Systems',
   0x0005D1: u'Metavector Technologies',
   0x0005D2: u'DAP Technologies',
   0x0005D3: u'eProduction Solutions, Inc.',
   0x0005D4: u'FutureSmart Networks, Inc.',
   0x0005D5: u'Speedcom Wireless',
   0x0005D6: u'Titan Wireless',
   0x0005D7: u'Vista Imaging, Inc.',
   0x0005D8: u'Arescom, Inc.',
   0x0005D9: u'Techno Valley, Inc.',
   0x0005DA: u'Apex Automationstechnik',
   0x0005DB: u'Nentec GmbH',
   0x0005DC: u'Cisco Systems, Inc.',
   0x0005DD: u'Cisco Systems, Inc.',
   0x0005DE: u'Gi Fone Korea, Inc.',
   0x0005DF: u'Electronic Innovation, Inc.',
   0x0005E0: u'Empirix Corp.',
   0x0005E1: u'Trellis Photonics, Ltd.',
   0x0005E2: u'Creativ Network Technologies',
   0x0005E3: u'LightSand Communications, Inc.',
   0x0005E4: u'Red Lion Controls L.P.',
   0x0005E5: u'Renishaw PLC',
   0x0005E6: u'Egenera, Inc.',
   0x0005E7: u'Netrake Corp.',
   0x0005E8: u'TurboWave, Inc.',
   0x0005E9: u'Unicess Network, Inc.',
   0x0005EA: u'Rednix',
   0x0005EB: u'Blue Ridge Networks, Inc.',
   0x0005EC: u'Mosaic Systems Inc.',
   0x0005ED: u'Technikum Joanneum GmbH',
   0x0005EE: u'BEWATOR Group',
   0x0005EF: u'ADOIR Digital Technology',
   0x0005F0: u'SATEC',
   0x0005F1: u'Vrcom, Inc.',
   0x0005F2: u'Power R, Inc.',
   0x0005F3: u'Weboyn',
   0x0005F4: u'System Base Co., Ltd.',
   0x0005F5: u'OYO Geospace Corp.',
   0x0005F6: u'Young Chang Co. Ltd.',
   0x0005F7: u'Analog Devices, Inc.',
   0x0005F8: u'Real Time Access, Inc.',
   0x0005F9: u'TOA Corporation',
   0x0005FA: u'IPOptical, Inc.',
   0x0005FB: u'ShareGate, Inc.',
   0x0005FC: u'Schenck Pegasus Corp.',
   0x0005FD: u'PacketLight Networks Ltd.',
   0x0005FE: u'Traficon N.V.',
   0x0005FF: u'SNS Solutions, Inc.',
   0x000600: u'Toshiba Teli Corporation',
   0x000601: u'Otanikeiki Co., Ltd.',
   0x000602: u'Cirkitech Electronics Co.',
   0x000603: u'Baker Hughes Inc.',
   0x000604: u'@Track Communications, Inc.',
   0x000605: u'Inncom International, Inc.',
   0x000606: u'RapidWAN, Inc.',
   0x000607: u'Omni Directional Control Technology Inc.',
   0x000608: u'At-Sky SAS',
   0x000609: u'Crossport Systems',
   0x00060A: u'Blue2space',
   0x00060B: u'Paceline Systems Corporation',
   0x00060C: u'Melco Industries, Inc.',
   0x00060D: u'Wave7 Optics',
   0x00060E: u'IGYS Systems, Inc.',
   0x00060F: u'Narad Networks Inc',
   0x000610: u'Abeona Networks Inc',
   0x000611: u'Zeus Wireless, Inc.',
   0x000612: u'Accusys, Inc.',
   0x000613: u'Kawasaki Microelectronics Incorporated',
   0x000614: u'Prism Holdings',
   0x000615: u'Kimoto Electric Co., Ltd.',
   0x000616: u'Tel Net Co., Ltd.',
   0x000617: u'Redswitch Inc.',
   0x000618: u'DigiPower Manufacturing Inc.',
   0x000619: u'Connection Technology Systems',
   0x00061A: u'Zetari Inc.',
   0x00061B: u'Portable Systems, IBM Japan Co, Ltd',
   0x00061C: u'Hoshino Metal Industries, Ltd.',
   0x00061D: u'MIP Telecom, Inc.',
   0x00061E: u'Maxan Systems',
   0x00061F: u'Vision Components GmbH',
   0x000620: u'Serial System Ltd.',
   0x000621: u'Hinox, Co., Ltd.',
   0x000622: u'Chung Fu Chen Yeh Enterprise Corp.',
   0x000623: u'MGE UPS Systems France',
   0x000624: u'Gentner Communications Corp.',
   0x000625: u'The Linksys Group, Inc.',
   0x000626: u'MWE GmbH',
   0x000627: u'Uniwide Technologies, Inc.',
   0x000628: u'Cisco Systems, Inc.',
   0x000629: u'IBM CORPORATION',
   0x00062A: u'Cisco Systems, Inc.',
   0x00062B: u'INTRASERVER TECHNOLOGY',
   0x00062C: u'Network Robots, Inc.',
   0x00062D: u'TouchStar Technologies, L.L.C.',
   0x00062E: u'Aristos Logic Corp.',
   0x00062F: u'Pivotech Systems Inc.',
   0x000630: u'Adtranz Sweden',
   0x000631: u'Optical Solutions, Inc.',
   0x000632: u'Mesco Engineering GmbH',
   0x000633: u'Smiths Heimann Biometric Systems',
   0x000634: u'GTE Airfone Inc.',
   0x000635: u'PacketAir Networks, Inc.',
   0x000636: u'Jedai Broadband Networks',
   0x000637: u'Toptrend-Meta Information (ShenZhen) Inc.',
   0x000638: u'Sungjin C&C Co., Ltd.',
   0x000639: u'Newtec',
   0x00063A: u'Dura Micro, Inc.',
   0x00063B: u'Arcturus Networks, Inc.',
   0x00063C: u'NMI Electronics Ltd',
   0x00063D: u'Microwave Data Systems Inc.',
   0x00063E: u'Opthos Inc.',
   0x00063F: u'Everex Communications Inc.',
   0x000640: u'White Rock Networks',
   0x000641: u'ITCN',
   0x000642: u'Genetel Systems Inc.',
   0x000643: u'SONO Computer Co., Ltd.',
   0x000644: u'NEIX Inc.',
   0x000645: u'Meisei Electric Co. Ltd.',
   0x000646: u'ShenZhen XunBao Network Technology Co Ltd',
   0x000647: u'Etrali S.A.',
   0x000648: u'Seedsware, Inc.',
   0x000649: u'Quante',
   0x00064A: u'Honeywell Co., Ltd. (KOREA)',
   0x00064B: u'Alexon Co., Ltd.',
   0x00064C: u'Invicta Networks, Inc.',
   0x00064D: u'Sencore',
   0x00064E: u'Broad Net Technology Inc.',
   0x00064F: u'PRO-NETS Technology Corporation',
   0x000650: u'Tiburon Networks, Inc.',
   0x000651: u'Aspen Networks Inc.',
   0x000652: u'Cisco Systems, Inc.',
   0x000653: u'Cisco Systems, Inc.',
   0x000654: u'Maxxio Technologies',
   0x000655: u'Yipee, Inc.',
   0x000656: u'Tactel AB',
   0x000657: u'Market Central, Inc.',
   0x000658: u'Helmut Fischer GmbH & Co. KG',
   0x000659: u'EAL (Apeldoorn) B.V.',
   0x00065A: u'Strix Systems',
   0x00065B: u'Dell Computer Corp.',
   0x00065C: u'Malachite Technologies, Inc.',
   0x00065D: u'Heidelberg Web Systems',
   0x00065E: u'Photuris, Inc.',
   0x00065F: u'ECI Telecom - NGTS Ltd.',
   0x000660: u'NADEX Co., Ltd.',
   0x000661: u'NIA Home Technologies Corp.',
   0x000662: u'MBM Technology Ltd.',
   0x000663: u'Human Technology Co., Ltd.',
   0x000664: u'Fostex Corporation',
   0x000665: u'Sunny Giken, Inc.',
   0x000666: u'Roving Networks',
   0x000667: u'Tripp Lite',
   0x000668: u'Vicon Industries Inc.',
   0x000669: u'Datasound Laboratories Ltd',
   0x00066A: u'InfiniCon Systems, Inc.',
   0x00066B: u'Sysmex Corporation',
   0x00066C: u'Robinson Corporation',
   0x00066D: u'Compuprint S.P.A.',
   0x00066E: u'Delta Electronics, Inc.',
   0x00066F: u'Korea Data Systems',
   0x000670: u'Upponetti Oy',
   0x000671: u'Softing AG',
   0x000672: u'Netezza',
   0x000673: u'Optelecom-nkf',
   0x000674: u'Spectrum Control, Inc.',
   0x000675: u'Banderacom, Inc.',
   0x000676: u'Novra Technologies Inc.',
   0x000677: u'SICK AG',
   0x000678: u'Marantz Japan, Inc.',
   0x000679: u'Konami Corporation',
   0x00067A: u'JMP Systems',
   0x00067B: u'Toplink C&C Corporation',
   0x00067C: u'CISCO SYSTEMS, INC.',
   0x00067D: u'Takasago Ltd.',
   0x00067E: u'WinCom Systems, Inc.',
   0x00067F: u'Rearden Steel Technologies',
   0x000680: u'Card Access, Inc.',
   0x000681: u'Goepel Electronic GmbH',
   0x000682: u'Convedia',
   0x000683: u'Bravara Communications, Inc.',
   0x000684: u'Biacore AB',
   0x000685: u'NetNearU Corporation',
   0x000686: u'ZARDCOM Co., Ltd.',
   0x000687: u'Omnitron Systems Technology, Inc.',
   0x000688: u'Telways Communication Co., Ltd.',
   0x000689: u'yLez Technologies Pte Ltd',
   0x00068A: u'NeuronNet Co. Ltd. R&D Center',
   0x00068B: u'AirRunner Technologies, Inc.',
   0x00068C: u'3Com Corporation',
   0x00068D: u'SEPATON, Inc.',
   0x00068E: u'HID Corporation',
   0x00068F: u'Telemonitor, Inc.',
   0x000690: u'Euracom Communication GmbH',
   0x000691: u'PT Inovacao',
   0x000692: u'Intruvert Networks, Inc.',
   0x000693: u'Flexus Computer Technology, Inc.',
   0x000694: u'Mobillian Corporation',
   0x000695: u'Ensure Technologies, Inc.',
   0x000696: u'Advent Networks',
   0x000697: u'R & D Center',
   0x000698: u'egnite Software GmbH',
   0x000699: u'Vida Design Co.',
   0x00069A: u'e & Tel',
   0x00069B: u'AVT Audio Video Technologies GmbH',
   0x00069C: u'Transmode Systems AB',
   0x00069D: u'Petards Mobile Intelligence',
   0x00069E: u'UNIQA, Inc.',
   0x00069F: u'Kuokoa Networks',
   0x0006A0: u'Mx Imaging',
   0x0006A1: u'Celsian Technologies, Inc.',
   0x0006A2: u'Microtune, Inc.',
   0x0006A3: u'Bitran Corporation',
   0x0006A4: u'INNOWELL Corp.',
   0x0006A5: u'PINON Corp.',
   0x0006A6: u'Artistic Licence (UK) Ltd',
   0x0006A7: u'Primarion',
   0x0006A8: u'KC Technology, Inc.',
   0x0006A9: u'Universal Instruments Corp.',
   0x0006AA: u'Miltope Corporation',
   0x0006AB: u'W-Link Systems, Inc.',
   0x0006AC: u'Intersoft Co.',
   0x0006AD: u'KB Electronics Ltd.',
   0x0006AE: u'Himachal Futuristic Communications Ltd',
   0x0006AF: u'PRIVATE',
   0x0006B0: u'Comtech EF Data Corp.',
   0x0006B1: u'Sonicwall',
   0x0006B2: u'Linxtek Co.',
   0x0006B3: u'Diagraph Corporation',
   0x0006B4: u'Vorne Industries, Inc.',
   0x0006B5: u'Luminent, Inc.',
   0x0006B6: u'Nir-Or Israel Ltd.',
   0x0006B7: u'TELEM GmbH',
   0x0006B8: u'Bandspeed Pty Ltd',
   0x0006B9: u'A5TEK Corp.',
   0x0006BA: u'Westwave Communications',
   0x0006BB: u'ATI Technologies Inc.',
   0x0006BC: u'Macrolink, Inc.',
   0x0006BD: u'BNTECHNOLOGY Co., Ltd.',
   0x0006BE: u'Baumer Optronic GmbH',
   0x0006BF: u'Accella Technologies Co., Ltd.',
   0x0006C0: u'United Internetworks, Inc.',
   0x0006C1: u'CISCO SYSTEMS, INC.',
   0x0006C2: u'Smartmatic Corporation',
   0x0006C3: u'Schindler Elevators Ltd.',
   0x0006C4: u'Piolink Inc.',
   0x0006C5: u'INNOVI Technologies Limited',
   0x0006C6: u'lesswire AG',
   0x0006C7: u'RFNET Technologies Pte Ltd (S)',
   0x0006C8: u'Sumitomo Metal Micro Devices, Inc.',
   0x0006C9: u'Technical Marketing Research, Inc.',
   0x0006CA: u'American Computer & Digital Components, Inc. (ACDC)',
   0x0006CB: u'Jotron Electronics A/S',
   0x0006CC: u'JMI Electronics Co., Ltd.',
   0x0006CD: u'Kodak IL Ltd.',
   0x0006CE: u'DATENO',
   0x0006CF: u'Thales Avionics In-Flight Systems, LLC',
   0x0006D0: u'Elgar Electronics Corp.',
   0x0006D1: u'Tahoe Networks, Inc.',
   0x0006D2: u'Tundra Semiconductor Corp.',
   0x0006D3: u'Alpha Telecom, Inc. U.S.A.',
   0x0006D4: u'Interactive Objects, Inc.',
   0x0006D5: u'Diamond Systems Corp.',
   0x0006D6: u'Cisco Systems, Inc.',
   0x0006D7: u'Cisco Systems, Inc.',
   0x0006D8: u'Maple Optical Systems',
   0x0006D9: u'IPM-Net S.p.A.',
   0x0006DA: u'ITRAN Communications Ltd.',
   0x0006DB: u'ICHIPS Co., Ltd.',
   0x0006DC: u'Syabas Technology (Amquest)',
   0x0006DD: u'AT & T Laboratories - Cambridge Ltd',
   0x0006DE: u'Flash Technology',
   0x0006DF: u'AIDONIC Corporation',
   0x0006E0: u'MAT Co., Ltd.',
   0x0006E1: u'Techno Trade s.a',
   0x0006E2: u'Ceemax Technology Co., Ltd.',
   0x0006E3: u'Quantitative Imaging Corporation',
   0x0006E4: u'Citel Technologies Ltd.',
   0x0006E5: u'Fujian Newland Computer Ltd. Co.',
   0x0006E6: u'DongYang Telecom Co., Ltd.',
   0x0006E7: u'Bit Blitz Communications Inc.',
   0x0006E8: u'Optical Network Testing, Inc.',
   0x0006E9: u'Intime Corp.',
   0x0006EA: u'ELZET80 Mikrocomputer GmbH&Co. KG',
   0x0006EB: u'Global Data',
   0x0006EC: u'M/A COM Private Radio System Inc.',
   0x0006ED: u'Inara Networks',
   0x0006EE: u'Shenyang Neu-era Information & Technology Stock Co., Ltd',
   0x0006EF: u'Maxxan Systems, Inc.',
   0x0006F0: u'Digeo, Inc.',
   0x0006F1: u'Optillion',
   0x0006F2: u'Platys Communications',
   0x0006F3: u'AcceLight Networks',
   0x0006F4: u'Prime Electronics & Satellitics Inc.',
   0x0006F8: u'CPU Technology, Inc.',
   0x0006F9: u'Mitsui Zosen Systems Research Inc.',
   0x0006FA: u'IP SQUARE Co, Ltd.',
   0x0006FB: u'Hitachi Printing Solutions, Ltd.',
   0x0006FC: u'Fnet Co., Ltd.',
   0x0006FD: u'Comjet Information Systems Corp.',
   0x0006FE: u'Celion Networks, Inc.',
   0x0006FF: u'Sheba Systems Co., Ltd.',
   0x000700: u'Zettamedia Korea',
   0x000701: u'RACAL-DATACOM',
   0x000702: u'Varian Medical Systems',
   0x000703: u'CSEE Transport',
   0x000705: u'Endress & Hauser GmbH & Co',
   0x000706: u'Sanritz Corporation',
   0x000707: u'Interalia Inc.',
   0x000708: u'Bitrage Inc.',
   0x000709: u'Westerstrand Urfabrik AB',
   0x00070A: u'Unicom Automation Co., Ltd.',
   0x00070B: u'Octal, SA',
   0x00070C: u'SVA-Intrusion.com Co. Ltd.',
   0x00070D: u'Cisco Systems Inc.',
   0x00070E: u'Cisco Systems Inc.',
   0x00070F: u'Fujant, Inc.',
   0x000710: u'Adax, Inc.',
   0x000711: u'Acterna',
   0x000712: u'JAL Information Technology',
   0x000713: u'IP One, Inc.',
   0x000714: u'Brightcom',
   0x000715: u'General Research of Electronics, Inc.',
   0x000716: u'J & S Marine Ltd.',
   0x000717: u'Wieland Electric GmbH',
   0x000718: u'iCanTek Co., Ltd.',
   0x000719: u'Mobiis Co., Ltd.',
   0x00071A: u'Finedigital Inc.',
   0x00071B: u'Position Technology Inc.',
   0x00071C: u'AT&T Fixed Wireless Services',
   0x00071D: u'Satelsa Sistemas Y Aplicaciones De Telecomunicaciones, S.A.',
   0x00071E: u'Tri-M Engineering / Nupak Dev. Corp.',
   0x00071F: u'European Systems Integration',
   0x000720: u'Trutzschler GmbH & Co. KG',
   0x000721: u'Formac Elektronik GmbH',
   0x000722: u'Nielsen Media Research',
   0x000723: u'ELCON Systemtechnik GmbH',
   0x000724: u'Telemax Co., Ltd.',
   0x000725: u'Bematech International Corp.',
   0x000727: u'Zi Corporation (HK) Ltd.',
   0x000728: u'Neo Telecom',
   0x000729: u'Kistler Instrumente AG',
   0x00072A: u'Innovance Networks',
   0x00072B: u'Jung Myung Telecom Co., Ltd.',
   0x00072C: u'Fabricom',
   0x00072D: u'CNSystems',
   0x00072E: u'North Node AB',
   0x00072F: u'Intransa, Inc.',
   0x000730: u'Hutchison OPTEL Telecom Technology Co., Ltd.',
   0x000731: u'Spiricon, Inc.',
   0x000732: u'AAEON Technology Inc.',
   0x000733: u'DANCONTROL Engineering',
   0x000734: u'ONStor, Inc.',
   0x000735: u'Flarion Technologies, Inc.',
   0x000736: u'Data Video Technologies Co., Ltd.',
   0x000737: u'Soriya Co. Ltd.',
   0x000738: u'Young Technology Co., Ltd.',
   0x000739: u'Motion Media Technology Ltd.',
   0x00073A: u'Inventel Systemes',
   0x00073B: u'Tenovis GmbH & Co KG',
   0x00073C: u'Telecom Design',
   0x00073D: u'Nanjing Postel Telecommunications Co., Ltd.',
   0x00073E: u'China Great-Wall Computer Shenzhen Co., Ltd.',
   0x00073F: u'Woojyun Systec Co., Ltd.',
   0x000740: u'Melco Inc.',
   0x000741: u'Sierra Automated Systems',
   0x000742: u'Current Technologies',
   0x000743: u'Chelsio Communications',
   0x000744: u'Unico, Inc.',
   0x000745: u'Radlan Computer Communications Ltd.',
   0x000746: u'TURCK, Inc.',
   0x000747: u'Mecalc',
   0x000748: u'The Imaging Source Europe',
   0x000749: u'CENiX Inc.',
   0x00074A: u'Carl Valentin GmbH',
   0x00074B: u'Daihen Corporation',
   0x00074C: u'Beicom Inc.',
   0x00074D: u'Zebra Technologies Corp.',
   0x00074E: u'Naughty boy co., Ltd.',
   0x00074F: u'Cisco Systems, Inc.',
   0x000750: u'Cisco Systems, Inc.',
   0x000751: u'm.u.t. - GmbH',
   0x000752: u'Rhythm Watch Co., Ltd.',
   0x000753: u'Beijing Qxcomm Technology Co., Ltd.',
   0x000754: u'Xyterra Computing, Inc.',
   0x000755: u'Lafon SA',
   0x000756: u'Juyoung Telecom',
   0x000757: u'Topcall International AG',
   0x000758: u'Dragonwave',
   0x000759: u'Boris Manufacturing Corp.',
   0x00075A: u'Air Products and Chemicals, Inc.',
   0x00075B: u'Gibson Guitars',
   0x00075C: u'Eastman Kodak Company',
   0x00075D: u'Celleritas Inc.',
   0x00075E: u'Ametek Power Instruments',
   0x00075F: u'VCS Video Communication Systems AG',
   0x000760: u'TOMIS Information & Telecom Corp.',
   0x000761: u'Logitech SA',
   0x000762: u'Group Sense Limited',
   0x000763: u'Sunniwell Cyber Tech. Co., Ltd.',
   0x000764: u'YoungWoo Telecom Co. Ltd.',
   0x000765: u'Jade Quantum Technologies, Inc.',
   0x000766: u'Chou Chin Industrial Co., Ltd.',
   0x000767: u'Yuxing Electronics Company Limited',
   0x000768: u'Danfoss A/S',
   0x000769: u'Italiana Macchi SpA',
   0x00076A: u'NEXTEYE Co., Ltd.',
   0x00076B: u'Stralfors AB',
   0x00076C: u'Daehanet, Inc.',
   0x00076D: u'Flexlight Networks',
   0x00076E: u'Sinetica Corporation Limited',
   0x00076F: u'Synoptics Limited',
   0x000770: u'Locusnetworks Corporation',
   0x000771: u'Embedded System Corporation',
   0x000772: u'Alcatel Shanghai Bell Co., Ltd.',
   0x000773: u'Ascom Powerline Communications Ltd.',
   0x000774: u'GuangZhou Thinker Technology Co. Ltd.',
   0x000775: u'Valence Semiconductor, Inc.',
   0x000776: u'Federal APD',
   0x000777: u'Motah Ltd.',
   0x000778: u'GERSTEL GmbH & Co. KG',
   0x000779: u'Sungil Telecom Co., Ltd.',
   0x00077A: u'Infoware System Co., Ltd.',
   0x00077B: u'Millimetrix Broadband Networks',
   0x00077C: u'OnTime Networks',
   0x00077E: u'Elrest GmbH',
   0x00077F: u'J Communications Co., Ltd.',
   0x000780: u'Bluegiga Technologies OY',
   0x000781: u'Itron Inc.',
   0x000782: u'Nauticus Networks, Inc.',
   0x000783: u'SynCom Network, Inc.',
   0x000784: u'Cisco Systems Inc.',
   0x000785: u'Cisco Systems Inc.',
   0x000786: u'Wireless Networks Inc.',
   0x000787: u'Idea System Co., Ltd.',
   0x000788: u'Clipcomm, Inc.',
   0x000789: u'Eastel Systems Corporation',
   0x00078A: u'Mentor Data System Inc.',
   0x00078B: u'Wegener Communications, Inc.',
   0x00078C: u'Elektronikspecialisten i Borlange AB',
   0x00078D: u'NetEngines Ltd.',
   0x00078E: u'Garz & Friche GmbH',
   0x00078F: u'Emkay Innovative Products',
   0x000790: u'Tri-M Technologies (s) Limited',
   0x000791: u'International Data Communications, Inc.',
   0x000792: u'Suetron Electronic GmbH',
   0x000793: u'Shin Satellite Public Company Limited',
   0x000794: u'Simple Devices, Inc.',
   0x000795: u'Elitegroup Computer System Co. (ECS)',
   0x000796: u'LSI Systems, Inc.',
   0x000797: u'Netpower Co., Ltd.',
   0x000798: u'Selea SRL',
   0x000799: u'Tipping Point Technologies, Inc.',
   0x00079A: u'SmartSight Networks Inc.',
   0x00079B: u'Aurora Networks',
   0x00079C: u'Golden Electronics Technology Co., Ltd.',
   0x00079D: u'Musashi Co., Ltd.',
   0x00079E: u'Ilinx Co., Ltd.',
   0x00079F: u'Action Digital Inc.',
   0x0007A0: u'e-Watch Inc.',
   0x0007A1: u'VIASYS Healthcare GmbH',
   0x0007A2: u'Opteon Corporation',
   0x0007A3: u'Ositis Software, Inc.',
   0x0007A4: u'GN Netcom Ltd.',
   0x0007A5: u'Y.D.K Co. Ltd.',
   0x0007A6: u'Home Automation, Inc.',
   0x0007A7: u'A-Z Inc.',
   0x0007A8: u'Haier Group Technologies Ltd.',
   0x0007A9: u'Novasonics',
   0x0007AA: u'Quantum Data Inc.',
   0x0007AC: u'Eolring',
   0x0007AD: u'Pentacon GmbH Foto-und Feinwerktechnik',
   0x0007AE: u'Britestream Networks, Inc.',
   0x0007AF: u'N-Tron Corp.',
   0x0007B0: u'Office Details, Inc.',
   0x0007B1: u'Equator Technologies',
   0x0007B2: u'Transaccess S.A.',
   0x0007B3: u'Cisco Systems Inc.',
   0x0007B4: u'Cisco Systems Inc.',
   0x0007B5: u'Any One Wireless Ltd.',
   0x0007B6: u'Telecom Technology Ltd.',
   0x0007B7: u'Samurai Ind. Prods Eletronicos Ltda',
   0x0007B8: u'American Predator Corp.',
   0x0007B9: u'Ginganet Corporation',
   0x0007BA: u'UTStarcom, Inc.',
   0x0007BB: u'Candera Inc.',
   0x0007BC: u'Identix Inc.',
   0x0007BD: u'Radionet Ltd.',
   0x0007BE: u'DataLogic SpA',
   0x0007BF: u'Armillaire Technologies, Inc.',
   0x0007C0: u'NetZerver Inc.',
   0x0007C1: u'Overture Networks, Inc.',
   0x0007C2: u'Netsys Telecom',
   0x0007C3: u'Cirpack',
   0x0007C4: u'JEAN Co. Ltd.',
   0x0007C5: u'Gcom, Inc.',
   0x0007C6: u'VDS Vosskuhler GmbH',
   0x0007C7: u'Synectics Systems Limited',
   0x0007C8: u'Brain21, Inc.',
   0x0007C9: u'Technol Seven Co., Ltd.',
   0x0007CA: u'Creatix Polymedia Ges Fur Kommunikaitonssysteme',
   0x0007CB: u'Freebox SA',
   0x0007CC: u'Kaba Benzing GmbH',
   0x0007CD: u'NMTEL Co., Ltd.',
   0x0007CE: u'Cabletime Limited',
   0x0007CF: u'Anoto AB',
   0x0007D0: u'Automat Engenharia de Automaoa Ltda.',
   0x0007D1: u'Spectrum Signal Processing Inc.',
   0x0007D2: u'Logopak Systeme',
   0x0007D3: u'Stork Digital Imaging B.V.',
   0x0007D4: u'Zhejiang Yutong Network Communication Co Ltd.',
   0x0007D5: u'3e Technologies Int;., Inc.',
   0x0007D6: u'Commil Ltd.',
   0x0007D7: u'Caporis Networks AG',
   0x0007D8: u'Hitron Systems Inc.',
   0x0007D9: u'Splicecom',
   0x0007DA: u'Neuro Telecom Co., Ltd.',
   0x0007DB: u'Kirana Networks, Inc.',
   0x0007DC: u'Atek Co, Ltd.',
   0x0007DD: u'Cradle Technologies',
   0x0007DE: u'eCopilt AB',
   0x0007DF: u'Vbrick Systems Inc.',
   0x0007E0: u'Palm Inc.',
   0x0007E1: u'WIS Communications Co. Ltd.',
   0x0007E2: u'Bitworks, Inc.',
   0x0007E3: u'Navcom Technology, Inc.',
   0x0007E4: u'SoftRadio Co., Ltd.',
   0x0007E5: u'Coup Corporation',
   0x0007E6: u'edgeflow Canada Inc.',
   0x0007E7: u'FreeWave Technologies',
   0x0007E8: u'St. Bernard Software',
   0x0007E9: u'Intel Corporation',
   0x0007EA: u'Massana, Inc.',
   0x0007EB: u'Cisco Systems Inc.',
   0x0007EC: u'Cisco Systems Inc.',
   0x0007ED: u'Altera Corporation',
   0x0007EE: u'telco Informationssysteme GmbH',
   0x0007EF: u'Lockheed Martin Tactical Systems',
   0x0007F0: u'LogiSync Corporation',
   0x0007F1: u'TeraBurst Networks Inc.',
   0x0007F2: u'IOA Corporation',
   0x0007F3: u'Thinkengine Networks',
   0x0007F4: u'Eletex Co., Ltd.',
   0x0007F5: u'Bridgeco Co AG',
   0x0007F6: u'Qqest Software Systems',
   0x0007F7: u'Galtronics',
   0x0007F8: u'ITDevices, Inc.',
   0x0007F9: u'Phonetics, Inc.',
   0x0007FA: u'ITT Co., Ltd.',
   0x0007FB: u'Giga Stream UMTS Technologies GmbH',
   0x0007FC: u'Adept Systems Inc.',
   0x0007FD: u'LANergy Ltd.',
   0x0007FE: u'Rigaku Corporation',
   0x0007FF: u'Gluon Networks',
   0x000800: u'MULTITECH SYSTEMS, INC.',
   0x000801: u'HighSpeed Surfing Inc.',
   0x000802: u'Compaq Computer Corporation',
   0x000803: u'Cos Tron',
   0x000804: u'ICA Inc.',
   0x000805: u'Techno-Holon Corporation',
   0x000806: u'Raonet Systems, Inc.',
   0x000807: u'Access Devices Limited',
   0x000808: u'PPT Vision, Inc.',
   0x000809: u'Systemonic AG',
   0x00080A: u'Espera-Werke GmbH',
   0x00080B: u'Birka BPA Informationssystem AB',
   0x00080C: u'VDA elettronica SrL',
   0x00080D: u'Toshiba',
   0x00080E: u'Motorola, BCS',
   0x00080F: u'Proximion Fiber Optics AB',
   0x000810: u'Key Technology, Inc.',
   0x000811: u'VOIX Corporation',
   0x000812: u'GM-2 Corporation',
   0x000813: u'Diskbank, Inc.',
   0x000814: u'TIL Technologies',
   0x000815: u'CATS Co., Ltd.',
   0x000816: u'Bluetags A/S',
   0x000817: u'EmergeCore Networks LLC',
   0x000818: u'Pixelworks, Inc.',
   0x000819: u'Banksys',
   0x00081A: u'Sanrad Intelligence Storage Communications (2000) Ltd.',
   0x00081B: u'Windigo Systems',
   0x00081C: u'@pos.com',
   0x00081D: u'Ipsil, Incorporated',
   0x00081E: u'Repeatit AB',
   0x00081F: u'Pou Yuen Tech Corp. Ltd.',
   0x000820: u'Cisco Systems Inc.',
   0x000821: u'Cisco Systems Inc.',
   0x000822: u'InPro Comm',
   0x000823: u'Texa Corp.',
   0x000824: u'Promatek Industries Ltd.',
   0x000825: u'Acme Packet',
   0x000826: u'Colorado Med Tech',
   0x000827: u'Pirelli Broadband Solutions',
   0x000828: u'Koei Engineering Ltd.',
   0x000829: u'Aval Nagasaki Corporation',
   0x00082A: u'Powerwallz Network Security',
   0x00082B: u'Wooksung Electronics, Inc.',
   0x00082C: u'Homag AG',
   0x00082D: u'Indus Teqsite Private Limited',
   0x00082E: u'Multitone Electronics PLC',
   0x00084E: u'DivergeNet, Inc.',
   0x00084F: u'Qualstar Corporation',
   0x000850: u'Arizona Instrument Corp.',
   0x000851: u'Canadian Bank Note Company, Ltd.',
   0x000852: u'Davolink Co. Inc.',
   0x000853: u'Schleicher GmbH & Co. Relaiswerke KG',
   0x000854: u'Netronix, Inc.',
   0x000855: u'NASA-Goddard Space Flight Center',
   0x000856: u'Gamatronic Electronic Industries Ltd.',
   0x000857: u'Polaris Networks, Inc.',
   0x000858: u'Novatechnology Inc.',
   0x000859: u'ShenZhen Unitone Electronics Co., Ltd.',
   0x00085A: u'IntiGate Inc.',
   0x00085B: u'Hanbit Electronics Co., Ltd.',
   0x00085C: u'Shanghai Dare Technologies Co. Ltd.',
   0x00085D: u'Aastra',
   0x00085E: u'PCO AG',
   0x00085F: u'Picanol N.V.',
   0x000860: u'LodgeNet Entertainment Corp.',
   0x000861: u'SoftEnergy Co., Ltd.',
   0x000862: u'NEC Eluminant Technologies, Inc.',
   0x000863: u'Entrisphere Inc.',
   0x000864: u'Fasy S.p.A.',
   0x000865: u'JASCOM CO., LTD',
   0x000866: u'DSX Access Systems, Inc.',
   0x000867: u'Uptime Devices',
   0x000868: u'PurOptix',
   0x000869: u'Command-e Technology Co.,Ltd.',
   0x00086A: u'Industrie Technik IPS GmbH',
   0x00086B: u'MIPSYS',
   0x00086C: u'Plasmon LMS',
   0x00086D: u'Missouri FreeNet',
   0x00086E: u'Hyglo AB',
   0x00086F: u'Resources Computer Network Ltd.',
   0x000870: u'Rasvia Systems, Inc.',
   0x000871: u'NORTHDATA Co., Ltd.',
   0x000872: u'Sorenson Technologies, Inc.',
   0x000873: u'DAP Design B.V.',
   0x000874: u'Dell Computer Corp.',
   0x000875: u'Acorp Electronics Corp.',
   0x000876: u'SDSystem',
   0x000877: u'Liebert HIROSS S.p.A.',
   0x000878: u'Benchmark Storage Innovations',
   0x000879: u'CEM Corporation',
   0x00087A: u'Wipotec GmbH',
   0x00087B: u'RTX Telecom A/S',
   0x00087C: u'Cisco Systems, Inc.',
   0x00087D: u'Cisco Systems Inc.',
   0x00087E: u'Bon Electro-Telecom Inc.',
   0x00087F: u'SPAUN electronic GmbH & Co. KG',
   0x000880: u'BroadTel Canada Communications inc.',
   0x000881: u'DIGITAL HANDS CO.,LTD.',
   0x000882: u'SIGMA CORPORATION',
   0x000883: u'Hewlett-Packard Company',
   0x000884: u'Index Braille AB',
   0x000885: u'EMS Dr. Thomas Wuensche',
   0x000886: u'Hansung Teliann, Inc.',
   0x000887: u'Maschinenfabrik Reinhausen GmbH',
   0x000888: u'OULLIM Information Technology Inc,.',
   0x000889: u'Echostar Technologies Corp',
   0x00088A: u'Minds@Work',
   0x00088B: u'Tropic Networks Inc.',
   0x00088C: u'Quanta Network Systems Inc.',
   0x00088D: u'Sigma-Links Inc.',
   0x00088E: u'Nihon Computer Co., Ltd.',
   0x00088F: u'ADVANCED DIGITAL TECHNOLOGY',
   0x000890: u'AVILINKS SA',
   0x000891: u'Lyan Inc.',
   0x000892: u'EM Solutions',
   0x000893: u'LE INFORMATION COMMUNICATION INC.',
   0x000894: u'InnoVISION Multimedia Ltd.',
   0x000895: u'DIRC Technologie GmbH & Co.KG',
   0x000896: u'Printronix, Inc.',
   0x000897: u'Quake Technologies',
   0x000898: u'Gigabit Optics Corporation',
   0x000899: u'Netbind, Inc.',
   0x00089A: u'Alcatel Microelectronics',
   0x00089B: u'ICP Electronics Inc.',
   0x00089C: u'Elecs Industry Co., Ltd.',
   0x00089D: u'UHD-Elektronik',
   0x00089E: u'Beijing Enter-Net co.LTD',
   0x00089F: u'EFM Networks',
   0x0008A0: u'Stotz Feinmesstechnik GmbH',
   0x0008A1: u'CNet Technology Inc.',
   0x0008A2: u'ADI Engineering, Inc.',
   0x0008A3: u'Cisco Systems',
   0x0008A4: u'Cisco Systems',
   0x0008A5: u'Peninsula Systems Inc.',
   0x0008A6: u'Multiware & Image Co., Ltd.',
   0x0008A7: u'iLogic Inc.',
   0x0008A8: u'Systec Co., Ltd.',
   0x0008A9: u'SangSang Technology, Inc.',
   0x0008AA: u'KARAM',
   0x0008AB: u'EnerLinx.com, Inc.',
   0x0008AC: u'PRIVATE',
   0x0008AD: u'Toyo-Linx Co., Ltd.',
   0x0008AE: u'PacketFront Sweden AB',
   0x0008AF: u'Novatec Corporation',
   0x0008B0: u'BKtel communications GmbH',
   0x0008B1: u'ProQuent Systems',
   0x0008B2: u'SHENZHEN COMPASS TECHNOLOGY DEVELOPMENT CO.,LTD',
   0x0008B3: u'Fastwel',
   0x0008B4: u'SYSPOL',
   0x0008B5: u'TAI GUEN ENTERPRISE CO., LTD',
   0x0008B6: u'RouteFree, Inc.',
   0x0008B7: u'HIT Incorporated',
   0x0008B8: u'E.F. Johnson',
   0x0008B9: u'KAON MEDIA Co., Ltd.',
   0x0008BA: u'Erskine Systems Ltd',
   0x0008BB: u'NetExcell',
   0x0008BC: u'Ilevo AB',
   0x0008BD: u'TEPG-US',
   0x0008BE: u'XENPAK MSA Group',
   0x0008BF: u'Aptus Elektronik AB',
   0x0008C0: u'ASA SYSTEMS',
   0x0008C1: u'Avistar Communications Corporation',
   0x0008C2: u'Cisco Systems',
   0x0008C3: u'Contex A/S',
   0x0008C4: u'Hikari Co.,Ltd.',
   0x0008C5: u'Liontech Co., Ltd.',
   0x0008C6: u'Philips Consumer Communications',
   0x0008C7: u'COMPAQ COMPUTER CORPORATION',
   0x0008C8: u'Soneticom, Inc.',
   0x0008C9: u'TechniSat Digital GmbH',
   0x0008CA: u'TwinHan Technology Co.,Ltd',
   0x0008CB: u'Zeta Broadband Inc.',
   0x0008CC: u'Remotec, Inc.',
   0x0008CD: u'With-Net Inc',
   0x0008CE: u'IPMobileNet Inc.',
   0x0008CF: u'Nippon Koei Power Systems Co., Ltd.',
   0x0008D0: u'Musashi Engineering Co., LTD.',
   0x0008D1: u'KAREL INC.',
   0x0008D2: u'ZOOM Networks Inc.',
   0x0008D3: u'Hercules Technologies S.A.',
   0x0008D4: u'IneoQuest Technologies, Inc',
   0x0008D5: u'Vanguard Managed Solutions',
   0x0008D6: u'HASSNET Inc.',
   0x0008D7: u'HOW CORPORATION',
   0x0008D8: u'Dowkey Microwave',
   0x0008D9: u'Mitadenshi Co.,LTD',
   0x0008DA: u'SofaWare Technologies Ltd.',
   0x0008DB: u'Corrigent Systems',
   0x0008DC: u'Wiznet',
   0x0008DD: u'Telena Communications, Inc.',
   0x0008DE: u'3UP Systems',
   0x0008DF: u'Alistel Inc.',
   0x0008E0: u'ATO Technology Ltd.',
   0x0008E1: u'Barix AG',
   0x0008E2: u'Cisco Systems',
   0x0008E3: u'Cisco Systems',
   0x0008E4: u'Envenergy Inc',
   0x0008E5: u'IDK Corporation',
   0x0008E6: u'Littlefeet',
   0x0008E7: u'SHI ControlSystems,Ltd.',
   0x0008E8: u'Excel Master Ltd.',
   0x0008E9: u'NextGig',
   0x0008EA: u'Motion Control Engineering, Inc',
   0x0008EB: u'ROMWin Co.,Ltd.',
   0x0008EC: u'Zonu, Inc.',
   0x0008ED: u'ST&T Instrument Corp.',
   0x0008EE: u'Logic Product Development',
   0x0008EF: u'DIBAL,S.A.',
   0x0008F0: u'Next Generation Systems, Inc.',
   0x0008F1: u'Voltaire',
   0x0008F2: u'C&S Technology',
   0x0008F3: u'WANY',
   0x0008F4: u'Bluetake Technology Co., Ltd.',
   0x0008F5: u'YESTECHNOLOGY Co.,Ltd.',
   0x0008F6: u'SUMITOMO ELECTRIC HIGHTECHS.co.,ltd.',
   0x0008F7: u'Hitachi Ltd, Semiconductor &amp; Integrated Circuits Gr',
   0x0008F8: u'Guardall Ltd',
   0x0008F9: u'Padcom, Inc.',
   0x0008FA: u'Karl E.Brinkmann GmbH',
   0x0008FB: u'SonoSite, Inc.',
   0x0008FC: u'Gigaphoton Inc.',
   0x0008FD: u'BlueKorea Co., Ltd.',
   0x0008FE: u'UNIK C&C Co.,Ltd.',
   0x0008FF: u'Trilogy Communications Ltd',
   0x000900: u'TMT',
   0x000901: u'Shenzhen Shixuntong Information & Technoligy Co',
   0x000902: u'Redline Communications Inc.',
   0x000903: u'Panasas, Inc',
   0x000904: u'MONDIAL electronic',
   0x000905: u'iTEC Technologies Ltd.',
   0x000906: u'Esteem Networks',
   0x000907: u'Chrysalis Development',
   0x000908: u'VTech Technology Corp.',
   0x000909: u'Telenor Connect A/S',
   0x00090A: u'SnedFar Technology Co., Ltd.',
   0x00090B: u'MTL  Instruments PLC',
   0x00090C: u'Mayekawa Mfg. Co. Ltd.',
   0x00090D: u'LEADER ELECTRONICS CORP.',
   0x00090E: u'Helix Technology Inc.',
   0x00090F: u'Fortinet Inc.',
   0x000910: u'Simple Access Inc.',
   0x000911: u'Cisco Systems',
   0x000912: u'Cisco Systems',
   0x000913: u'SystemK Corporation',
   0x000914: u'COMPUTROLS INC.',
   0x000915: u'CAS Corp.',
   0x000916: u'Listman Home Technologies, Inc.',
   0x000917: u'WEM Technology Inc',
   0x000918: u'SAMSUNG TECHWIN CO.,LTD',
   0x000919: u'MDS Gateways',
   0x00091A: u'Macat Optics & Electronics Co., Ltd.',
   0x00091B: u'Digital Generation Inc.',
   0x00091C: u'CacheVision, Inc',
   0x00091D: u'Proteam Computer Corporation',
   0x00091E: u'Firstech Technology Corp.',
   0x00091F: u'A&amp;D Co., Ltd.',
   0x000920: u'EpoX COMPUTER CO.,LTD.',
   0x000921: u'Planmeca Oy',
   0x000922: u'Touchless Sensor Technology AG',
   0x000923: u'Heaman System Co., Ltd',
   0x000924: u'Telebau GmbH',
   0x000925: u'VSN Systemen BV',
   0x000926: u'YODA COMMUNICATIONS, INC.',
   0x000927: u'TOYOKEIKI CO.,LTD.',
   0x000928: u'Telecore Inc',
   0x000929: u'Sanyo Industries (UK) Limited',
   0x00092A: u'MYTECS Co.,Ltd.',
   0x00092B: u'iQstor Networks, Inc.',
   0x00092C: u'Hitpoint Inc.',
   0x00092D: u'High Tech Computer, Corp.',
   0x00092E: u'B&Tech System Inc.',
   0x00092F: u'Akom Technology Corporation',
   0x000930: u'AeroConcierge Inc.',
   0x000931: u'Future Internet, Inc.',
   0x000932: u'Omnilux',
   0x000933: u'OPTOVALLEY Co. Ltd.',
   0x000934: u'Dream-Multimedia-Tv GmbH',
   0x000935: u'Sandvine Incorporated',
   0x000936: u'Ipetronik GmbH & Co.KG',
   0x000937: u'Inventec Appliance Corp',
   0x000938: u'Allot Communications',
   0x000939: u'ShibaSoku Co.,Ltd.',
   0x00093A: u'Molex Fiber Optics',
   0x00093B: u'HYUNDAI NETWORKS INC.',
   0x00093C: u'Jacques Technologies P/L',
   0x00093D: u'Newisys,Inc.',
   0x00093E: u'C&I Technologies',
   0x00093F: u'Double-Win Enterpirse CO., LTD',
   0x000940: u'AGFEO GmbH & Co. KG',
   0x000941: u'Allied Telesis K.K.',
   0x000942: u'CRESCO, LTD.',
   0x000943: u'Cisco Systems',
   0x000944: u'Cisco Systems',
   0x000945: u'Palmmicro Communications Inc',
   0x000946: u'Cluster Labs GmbH',
   0x000947: u'Aztek, Inc.',
   0x000948: u'Vista Control Systems, Corp.',
   0x000949: u'Glyph Technologies Inc.',
   0x00094A: u'Homenet Communications',
   0x00094B: u'FillFactory NV',
   0x00094C: u'Communication Weaver Co.,Ltd.',
   0x00094D: u'Braintree Communications Pty Ltd',
   0x00094E: u'BARTECH SYSTEMS INTERNATIONAL, INC',
   0x00094F: u'elmegt GmbH & Co. KG',
   0x000950: u'Independent Storage Corporation',
   0x000951: u'Apogee Instruments, Inc',
   0x000952: u'Auerswald GmbH & Co. KG',
   0x000953: u'Linkage System Integration Co.Ltd.',
   0x000954: u'AMiT spol. s. r. o.',
   0x000955: u'Young Generation International Corp.',
   0x000956: u'Network Systems Group, Ltd. (NSG)',
   0x000957: u'Supercaller, Inc.',
   0x000958: u'INTELNET S.A.',
   0x000959: u'Sitecsoft',
   0x00095A: u'RACEWOOD TECHNOLOGY',
   0x00095B: u'Netgear, Inc.',
   0x00095C: u'Philips Medical Systems - Cardiac and Monitoring Systems (CM',
   0x00095D: u'Dialogue Technology Corp.',
   0x00095E: u'Masstech Group Inc.',
   0x00095F: u'Telebyte, Inc.',
   0x000960: u'YOZAN Inc.',
   0x000961: u'Switchgear and Instrumentation Ltd',
   0x000962: u'Filetrac AS',
   0x000963: u'Dominion Lasercom Inc.',
   0x000964: u'Hi-Techniques',
   0x000965: u'PRIVATE',
   0x000966: u'Thales Navigation',
   0x000967: u'Tachyon, Inc',
   0x000968: u'TECHNOVENTURE, INC.',
   0x000969: u'Meret Optical Communications',
   0x00096A: u'Cloverleaf Communications Inc.',
   0x00096B: u'IBM Corporation',
   0x00096C: u'Imedia Semiconductor Corp.',
   0x00096D: u'Powernet Technologies Corp.',
   0x00096E: u'GIANT ELECTRONICS LTD.',
   0x00096F: u'Beijing Zhongqing Elegant Tech. Corp.,Limited',
   0x000970: u'Vibration Research Corporation',
   0x000971: u'Time Management, Inc.',
   0x000972: u'Securebase,Inc',
   0x000973: u'Lenten Technology Co., Ltd.',
   0x000974: u'Innopia Technologies, Inc.',
   0x000975: u'fSONA Communications Corporation',
   0x000976: u'Datasoft ISDN Systems GmbH',
   0x000977: u'Brunner Elektronik AG',
   0x000978: u'AIJI System Co., Ltd.',
   0x000979: u'Advanced Television Systems Committee, Inc.',
   0x00097A: u'Louis Design Labs.',
   0x00097B: u'Cisco Systems',
   0x00097C: u'Cisco Systems',
   0x00097D: u'SecWell Networks Oy',
   0x00097E: u'IMI TECHNOLOGY CO., LTD',
   0x00097F: u'Vsecure 2000 LTD.',
   0x000980: u'Power Zenith Inc.',
   0x000981: u'Newport Networks',
   0x000982: u'Loewe Opta GmbH',
   0x000983: u'Gvision Incorporated',
   0x000984: u'MyCasa Network Inc.',
   0x000985: u'Auto Telecom Company',
   0x000986: u'Metalink LTD.',
   0x000987: u'NISHI NIPPON ELECTRIC WIRE & CABLE CO.,LTD.',
   0x000988: u'Nudian Electron Co., Ltd.',
   0x000989: u'VividLogic Inc.',
   0x00098A: u'EqualLogic Inc',
   0x00098B: u'Entropic Communications, Inc.',
   0x00098C: u'Option Wireless Sweden',
   0x00098D: u'Velocity Semiconductor',
   0x00098E: u'ipcas GmbH',
   0x00098F: u'Cetacean Networks',
   0x000990: u'ACKSYS Communications & systems',
   0x000991: u'GE Fanuc Automation Manufacturing, Inc.',
   0x000992: u'InterEpoch Technology,INC.',
   0x000993: u'Visteon Corporation',
   0x000994: u'Cronyx Engineering',
   0x000995: u'Castle Technology Ltd',
   0x000996: u'RDI',
   0x000997: u'Nortel Networks',
   0x000998: u'Capinfo Company Limited',
   0x000999: u'CP GEORGES RENAULT',
   0x00099A: u'ELMO COMPANY, LIMITED',
   0x00099B: u'Western Telematic Inc.',
   0x00099C: u'Naval Research Laboratory',
   0x00099D: u'Haliplex Communications',
   0x00099E: u'Testech, Inc.',
   0x00099F: u'VIDEX INC.',
   0x0009A0: u'Microtechno Corporation',
   0x0009A1: u'Telewise Communications, Inc.',
   0x0009A2: u'Interface Co., Ltd.',
   0x0009A3: u'Leadfly Techologies Corp. Ltd.',
   0x0009A4: u'HARTEC Corporation',
   0x0009A5: u'HANSUNG ELETRONIC INDUSTRIES DEVELOPMENT CO., LTD',
   0x0009A6: u'Ignis Optics, Inc.',
   0x0009A7: u'Bang & Olufsen A/S',
   0x0009A8: u'Eastmode Pte Ltd',
   0x0009A9: u'Ikanos Communications',
   0x0009AA: u'Data Comm for Business, Inc.',
   0x0009AB: u'Netcontrol Oy',
   0x0009AC: u'LANVOICE',
   0x0009AD: u'HYUNDAI SYSCOMM, INC.',
   0x0009AE: u'OKANO ELECTRIC CO.,LTD',
   0x0009AF: u'e-generis',
   0x0009B0: u'Onkyo Corporation',
   0x0009B1: u'Kanematsu Electronics, Ltd.',
   0x0009B2: u'L&F Inc.',
   0x0009B3: u'MCM Systems Ltd',
   0x0009B4: u'KISAN TELECOM CO., LTD.',
   0x0009B5: u'3J Tech. Co., Ltd.',
   0x0009B6: u'Cisco Systems',
   0x0009B7: u'Cisco Systems',
   0x0009B8: u'Entise Systems',
   0x0009B9: u'Action Imaging Solutions',
   0x0009BA: u'MAKU Informationstechik GmbH',
   0x0009BB: u'MathStar, Inc.',
   0x0009BC: u'Integrian, Inc.',
   0x0009BD: u'Epygi Technologies, Ltd.',
   0x0009BE: u'Mamiya-OP Co.,Ltd.',
   0x0009BF: u'Nintendo Co.,Ltd.',
   0x0009C0: u'6WIND',
   0x0009C1: u'PROCES-DATA A/S',
   0x0009C2: u'PRIVATE',
   0x0009C3: u'NETAS',
   0x0009C4: u'Medicore Co., Ltd',
   0x0009C5: u'KINGENE Technology Corporation',
   0x0009C6: u'Visionics Corporation',
   0x0009C7: u'Movistec',
   0x0009C8: u'SINAGAWA TSUSHIN KEISOU SERVICE',
   0x0009C9: u'BlueWINC Co., Ltd.',
   0x0009CA: u'iMaxNetworks(Shenzhen)Limited.',
   0x0009CB: u'HBrain',
   0x0009CC: u'Moog GmbH',
   0x0009CD: u'HUDSON SOFT CO.,LTD.',
   0x0009CE: u'SpaceBridge Semiconductor Corp.',
   0x0009CF: u'iAd GmbH',
   0x0009D0: u'Versatel Networks',
   0x0009D1: u'SERANOA NETWORKS INC',
   0x0009D2: u'Mai Logic Inc.',
   0x0009D3: u'Western DataCom Co., Inc.',
   0x0009D4: u'Transtech Networks',
   0x0009D5: u'Signal Communication, Inc.',
   0x0009D6: u'KNC One GmbH',
   0x0009D7: u'DC Security Products',
   0x0009D8: u'PRIVATE',
   0x0009D9: u'Neoscale Systems, Inc',
   0x0009DA: u'Control Module Inc.',
   0x0009DB: u'eSpace',
   0x0009DC: u'Galaxis Technology AG',
   0x0009DD: u'Mavin Technology Inc.',
   0x0009DE: u'Samjin Information & Communications Co., Ltd.',
   0x0009DF: u'Vestel Komunikasyon Sanayi ve Ticaret A.S.',
   0x0009E0: u'XEMICS S.A.',
   0x0009E1: u'Gemtek Technology Co., Ltd.',
   0x0009E2: u'Sinbon Electronics Co., Ltd.',
   0x0009E3: u'Angel Iglesias S.A.',
   0x0009E4: u'K Tech Infosystem Inc.',
   0x0009E5: u'Hottinger Baldwin Messtechnik GmbH',
   0x0009E6: u'Cyber Switching Inc.',
   0x0009E7: u'ADC Techonology',
   0x0009E8: u'Cisco Systems',
   0x0009E9: u'Cisco Systems',
   0x0009EA: u'YEM Inc.',
   0x0009EB: u'HuMANDATA LTD.',
   0x0009EC: u'Daktronics, Inc.',
   0x0009ED: u'CipherOptics',
   0x0009EE: u'MEIKYO ELECTRIC CO.,LTD',
   0x0009EF: u'Vocera Communications',
   0x0009F0: u'Shimizu Technology Inc.',
   0x0009F1: u'Yamaki Electric Corporation',
   0x0009F2: u'Cohu, Inc., Electronics Division',
   0x0009F3: u'WELL Communication Corp.',
   0x0009F4: u'Alcon Laboratories, Inc.',
   0x0009F5: u'Emerson Network Power Co.,Ltd',
   0x0009F6: u'Shenzhen Eastern Digital Tech Ltd.',
   0x0009F7: u'SED, a division of Calian',
   0x0009F8: u'UNIMO TECHNOLOGY CO., LTD.',
   0x0009F9: u'ART JAPAN CO., LTD.',
   0x0009FB: u'Philips Medizinsysteme Boeblingen GmbH',
   0x0009FC: u'IPFLEX Inc.',
   0x0009FD: u'Ubinetics Limited',
   0x0009FE: u'Daisy Technologies, Inc.',
   0x0009FF: u'X.net 2000 GmbH',
   0x000A00: u'Mediatek Corp.',
   0x000A01: u'SOHOware, Inc.',
   0x000A02: u'ANNSO CO., LTD.',
   0x000A03: u'ENDESA SERVICIOS, S.L.',
   0x000A04: u'3Com Europe Ltd',
   0x000A05: u'Widax Corp.',
   0x000A06: u'Teledex LLC',
   0x000A07: u'WebWayOne Ltd',
   0x000A08: u'ALPINE ELECTRONICS, INC.',
   0x000A09: u'TaraCom Integrated Products, Inc.',
   0x000A0A: u'SUNIX Co., Ltd.',
   0x000A0B: u'Sealevel Systems, Inc.',
   0x000A0C: u'Scientific Research Corporation',
   0x000A0D: u'MergeOptics GmbH',
   0x000A0E: u'Invivo Research Inc.',
   0x000A0F: u'Ilryung Telesys, Inc',
   0x000A10: u'FAST media integrations AG',
   0x000A11: u'ExPet Technologies, Inc',
   0x000A12: u'Azylex Technology, Inc',
   0x000A13: u'Silent Witness',
   0x000A14: u'TECO a.s.',
   0x000A15: u'Silicon Data, Inc',
   0x000A16: u'Lassen Research',
   0x000A17: u'NESTAR COMMUNICATIONS, INC',
   0x000A18: u'Vichel Inc.',
   0x000A19: u'Valere Power, Inc.',
   0x000A1A: u'Imerge Ltd',
   0x000A1B: u'Stream Labs',
   0x000A1C: u'Bridge Information Co., Ltd.',
   0x000A1D: u'Optical Communications Products Inc.',
   0x000A1E: u'Red-M Products Limited',
   0x000A1F: u'ART WARE Telecommunication Co., Ltd.',
   0x000A20: u'SVA Networks, Inc.',
   0x000A21: u'Integra Telecom Co. Ltd',
   0x000A22: u'Amperion Inc',
   0x000A23: u'Parama Networks Inc',
   0x000A24: u'Octave Communications',
   0x000A25: u'CERAGON NETWORKS',
   0x000A26: u'CEIA S.p.A.',
   0x000A27: u'Apple Computer, Inc.',
   0x000A28: u'Motorola',
   0x000A29: u'Pan Dacom Networking AG',
   0x000A2A: u'QSI Systems Inc.',
   0x000A2B: u'Etherstuff',
   0x000A2C: u'Active Tchnology Corporation',
   0x000A2D: u'PRIVATE',
   0x000A2E: u'MAPLE NETWORKS CO., LTD',
   0x000A2F: u'Artnix Inc.',
   0x000A30: u'Johnson Controls-ASG',
   0x000A31: u'HCV Wireless',
   0x000A32: u'Xsido Corporation',
   0x000A33: u'Emulex Corporation',
   0x000A34: u'Identicard Systems Incorporated',
   0x000A35: u'Xilinx',
   0x000A36: u'Synelec Telecom Multimedia',
   0x000A37: u'Procera Networks, Inc.',
   0x000A38: u'Netlock Technologies, Inc.',
   0x000A39: u'LoPA Information Technology',
   0x000A3A: u'J-THREE INTERNATIONAL Holding Co., Ltd.',
   0x000A3B: u'GCT Semiconductor, Inc',
   0x000A3C: u'Enerpoint Ltd.',
   0x000A3D: u'Elo Sistemas Eletronicos S.A.',
   0x000A3E: u'EADS Telecom',
   0x000A3F: u'Data East Corporation',
   0x000A40: u'Crown Audio',
   0x000A41: u'Cisco Systems',
   0x000A42: u'Cisco Systems',
   0x000A43: u'Chunghwa Telecom Co., Ltd.',
   0x000A44: u'Avery Dennison Deutschland GmbH',
   0x000A45: u'Audio-Technica Corp.',
   0x000A46: u'ARO Controls SAS',
   0x000A47: u'Allied Vision Technologies',
   0x000A48: u'Albatron Technology',
   0x000A49: u'Acopia Networks',
   0x000A4A: u'Targa Systems Ltd.',
   0x000A4B: u'DataPower Technology, Inc.',
   0x000A4C: u'Molecular Devices Corporation',
   0x000A4D: u'Noritz Corporation',
   0x000A4E: u'UNITEK Electronics INC.',
   0x000A4F: u'Brain Boxes Limited',
   0x000A50: u'REMOTEK CORPORATION',
   0x000A51: u'GyroSignal Technology Co., Ltd.',
   0x000A52: u'AsiaRF Ltd.',
   0x000A53: u'Intronics, Incorporated',
   0x000A54: u'Laguna Hills, Inc.',
   0x000A55: u'MARKEM Corporation',
   0x000A56: u'HITACHI Maxell Ltd.',
   0x000A57: u'Hewlett-Packard Company - Standards',
   0x000A58: u'Ingenieur-Buero Freyer & Siegel',
   0x000A59: u'HW server',
   0x000A5A: u'GreenNET Technologies Co.,Ltd.',
   0x000A5B: u'Power-One as',
   0x000A5C: u'Carel s.p.a.',
   0x000A5D: u'PUC Founder (MSC) Berhad',
   0x000A5E: u'3COM Corporation',
   0x000A5F: u'almedio inc.',
   0x000A60: u'Autostar Technology Pte Ltd',
   0x000A61: u'Cellinx Systems Inc.',
   0x000A62: u'Crinis Networks, Inc.',
   0x000A63: u'DHD GmbH',
   0x000A64: u'Eracom Technologies',
   0x000A65: u'GentechMedia.co.,ltd.',
   0x000A66: u'MITSUBISHI ELECTRIC SYSTEM & SERVICE CO.,LTD.',
   0x000A67: u'OngCorp',
   0x000A68: u'SolarFlare Communications, Inc.',
   0x000A69: u'SUNNY bell Technology Co., Ltd.',
   0x000A6A: u'SVM Microwaves s.r.o.',
   0x000A6B: u'Tadiran Telecom Business Systems LTD',
   0x000A6C: u'Walchem Corporation',
   0x000A6D: u'EKS Elektronikservice GmbH',
   0x000A6E: u'Broadcast Technology Limited',
   0x000A6F: u'ZyFLEX Technologies Inc',
   0x000A70: u'MPLS Forum',
   0x000A71: u'Avrio Technologies, Inc',
   0x000A72: u'SimpleTech, Inc.',
   0x000A73: u'Scientific Atlanta',
   0x000A74: u'Manticom Networks Inc.',
   0x000A75: u'Cat Electronics',
   0x000A76: u'Beida Jade Bird Huaguang Technology Co.,Ltd',
   0x000A77: u'Bluewire Technologies LLC',
   0x000A78: u'OLITEC',
   0x000A79: u'corega K.K.',
   0x000A7A: u'Kyoritsu Electric Co., Ltd.',
   0x000A7B: u'Cornelius Consult',
   0x000A7C: u'Tecton Ltd',
   0x000A7D: u'Valo, Inc.',
   0x000A7E: u'The Advantage Group',
   0x000A7F: u'Teradon Industries, Inc',
   0x000A80: u'Telkonet Inc.',
   0x000A81: u'TEIMA Audiotex S.L.',
   0x000A82: u'TATSUTA SYSTEM ELECTRONICS CO.,LTD.',
   0x000A83: u'SALTO SYSTEMS S.L.',
   0x000A84: u'Rainsun Enterprise Co., Ltd.',
   0x000A85: u'PLAT\'C2,Inc',
   0x000A86: u'Lenze',
   0x000A87: u'Integrated Micromachines Inc.',
   0x000A88: u'InCypher S.A.',
   0x000A89: u'Creval Systems, Inc.',
   0x000A8A: u'Cisco Systems',
   0x000A8B: u'Cisco Systems',
   0x000A8C: u'Guardware Systems Ltd.',
   0x000A8D: u'EUROTHERM LIMITED',
   0x000A8E: u'Invacom Ltd',
   0x000A8F: u'Aska International Inc.',
   0x000A90: u'Bayside Interactive, Inc.',
   0x000A91: u'HemoCue AB',
   0x000A92: u'Presonus Corporation',
   0x000A93: u'W2 Networks, Inc.',
   0x000A94: u'ShangHai cellink CO., LTD',
   0x000A95: u'Apple Computer, Inc.',
   0x000A96: u'MEWTEL TECHNOLOGY INC.',
   0x000A97: u'SONICblue, Inc.',
   0x000A98: u'M+F Gwinner GmbH & Co',
   0x000A99: u'Dataradio Inc.',
   0x000A9A: u'Aiptek International Inc',
   0x000A9B: u'Towa Meccs Corporation',
   0x000A9C: u'Server Technology, Inc.',
   0x000A9D: u'King Young Technology Co. Ltd.',
   0x000A9E: u'BroadWeb Corportation',
   0x000A9F: u'Pannaway Technologies, Inc.',
   0x000AA0: u'Cedar Point Communications',
   0x000AA1: u'V V S Limited',
   0x000AA2: u'SYSTEK INC.',
   0x000AA3: u'SHIMAFUJI ELECTRIC CO.,LTD.',
   0x000AA4: u'SHANGHAI SURVEILLANCE TECHNOLOGY CO,LTD',
   0x000AA5: u'MAXLINK INDUSTRIES LIMITED',
   0x000AA6: u'Hochiki Corporation',
   0x000AA7: u'FEI Company',
   0x000AA8: u'ePipe Pty. Ltd.',
   0x000AA9: u'Brooks Automation GmbH',
   0x000AAA: u'AltiGen Communications Inc.',
   0x000AAB: u'TOYOTA MACS, INC.',
   0x000AAC: u'TerraTec Electronic GmbH',
   0x000AAD: u'Stargames Corporation',
   0x000AAE: u'Rosemount Process Analytical',
   0x000AAF: u'Pipal Systems',
   0x000AB0: u'LOYTEC electronics GmbH',
   0x000AB1: u'GENETEC Corporation',
   0x000AB2: u'Fresnel Wireless Systems',
   0x000AB3: u'Fa. GIRA',
   0x000AB4: u'ETIC Telecommunications',
   0x000AB5: u'Digital Electronic Network',
   0x000AB6: u'COMPUNETIX, INC',
   0x000AB7: u'Cisco Systems',
   0x000AB8: u'Cisco Systems',
   0x000AB9: u'Astera Technologies Corp.',
   0x000ABA: u'Arcon Technology Limited',
   0x000ABB: u'Taiwan Secom Co,. Ltd',
   0x000ABC: u'Seabridge Ltd.',
   0x000ABD: u'Rupprecht & Patashnick Co.',
   0x000ABE: u'OPNET Technologies CO., LTD.',
   0x000ABF: u'HIROTA SS',
   0x000AC0: u'Fuyoh Video Industry CO., LTD.',
   0x000AC1: u'Futuretel',
   0x000AC2: u'FiberHome Telecommunication Technologies CO.,LTD',
   0x000AC3: u'eM Technics Co., Ltd.',
   0x000AC4: u'Daewoo Teletech Co., Ltd',
   0x000AC5: u'Color Kinetics',
   0x000AC6: u'Ceterus Networks, Inc.',
   0x000AC7: u'Unication Group',
   0x000AC8: u'ZPSYS CO.,LTD. (Planning&Management)',
   0x000AC9: u'Zambeel Inc',
   0x000ACA: u'YOKOYAMA SHOKAI CO.,Ltd.',
   0x000ACB: u'XPAK MSA Group',
   0x000ACC: u'Winnow Networks, Inc.',
   0x000ACD: u'Sunrich Technology Limited',
   0x000ACE: u'RADIANTECH, INC.',
   0x000ACF: u'PROVIDEO Multimedia Co. Ltd.',
   0x000AD0: u'Niigata Develoment Center,  F.I.T. Co., Ltd.',
   0x000AD1: u'MWS',
   0x000AD2: u'JEPICO Corporation',
   0x000AD3: u'INITECH Co., Ltd',
   0x000AD4: u'CoreBell Systems Inc.',
   0x000AD5: u'Brainchild Electronic Co., Ltd.',
   0x000AD6: u'BeamReach Networks',
   0x000AD7: u'Origin ELECTRIC CO.,LTD.',
   0x000AD8: u'IPCserv Technology Corp.',
   0x000AD9: u'Sony Ericsson Mobile Communications AB',
   0x000ADA: u'PRIVATE',
   0x000ADB: u'SkyPilot Network, Inc',
   0x000ADC: u'RuggedCom Inc.',
   0x000ADD: u'InSciTek Microsystems, Inc.',
   0x000ADE: u'Happy Communication Co., Ltd.',
   0x000ADF: u'Gennum Corporation',
   0x000AE0: u'Fujitsu Softek',
   0x000AE1: u'EG Technology',
   0x000AE2: u'Binatone Electronics International, Ltd',
   0x000AE3: u'YANG MEI TECHNOLOGY CO., LTD',
   0x000AE4: u'Wistron Corp.',
   0x000AE5: u'ScottCare Corporation',
   0x000AE6: u'Elitegroup Computer System Co. (ECS)',
   0x000AE7: u'ELIOP S.A.',
   0x000AE8: u'Cathay Roxus Information Technology Co. LTD',
   0x000AE9: u'AirVast Technology Inc.',
   0x000AEA: u'ADAM ELEKTRONIK LTD.STI.',
   0x000AEB: u'Shenzhen Tp-Link Technology Co; Ltd.',
   0x000AEC: u'Koatsu Gas Kogyo Co., Ltd.',
   0x000AED: u'HARTING Vending G.m.b.H. & CO KG',
   0x000AEE: u'GCD Hard- & Software GmbH',
   0x000AEF: u'OTRUM ASA',
   0x000AF0: u'SHIN-OH ELECTRONICS CO., LTD. R&D',
   0x000AF1: u'Clarity Design, Inc.',
   0x000AF2: u'NeoAxiom Corp.',
   0x000AF3: u'Cisco Systems',
   0x000AF4: u'Cisco Systems',
   0x000AF5: u'Airgo Networks, Inc.',
   0x000AF6: u'Computer Process Controls',
   0x000AF7: u'Broadcom Corp.',
   0x000AF8: u'American Telecare Inc.',
   0x000AF9: u'HiConnect, Inc.',
   0x000AFA: u'Traverse Technologies Australia',
   0x000AFB: u'Ambri Limited',
   0x000AFC: u'Core Tec Communications, LLC',
   0x000AFD: u'Viking Electronic Services',
   0x000AFE: u'NovaPal Ltd',
   0x000AFF: u'Kilchherr Elektronik AG',
   0x000B00: u'FUJIAN START COMPUTER EQUIPMENT CO.,LTD',
   0x000B01: u'DAIICHI ELECTRONICS CO., LTD.',
   0x000B02: u'Dallmeier electronic',
   0x000B03: u'Taekwang Industrial Co., Ltd',
   0x000B04: u'Volktek Corporation',
   0x000B05: u'Pacific Broadband Networks',
   0x000B06: u'Motorola BCS',
   0x000B07: u'Voxpath Networks',
   0x000B08: u'Pillar Data Systems',
   0x000B09: u'Ifoundry Systems Singapore',
   0x000B0A: u'dBm Optics',
   0x000B0B: u'Corrent Corporation',
   0x000B0C: u'Agile Systems Inc.',
   0x000B0D: u'Air2U, Inc.',
   0x000B0E: u'Trapeze Networks',
   0x000B0F: u'Nyquist Industrial Control BV',
   0x000B10: u'11wave Technonlogy Co.,Ltd',
   0x000B11: u'HIMEJI ABC TRADING CO.,LTD.',
   0x000B12: u'NURI Telecom Co., Ltd.',
   0x000B13: u'ZETRON INC',
   0x000B14: u'ViewSonic Corporation',
   0x000B15: u'Platypus Technology',
   0x000B16: u'Communication Machinery Corporation',
   0x000B17: u'MKS Instruments',
   0x000B18: u'PRIVATE',
   0x000B19: u'Vernier Networks, Inc.',
   0x000B1A: u'Teltone Corporation',
   0x000B1B: u'Systronix, Inc.',
   0x000B1C: u'SIBCO bv',
   0x000B1D: u'LayerZero Power Systems, Inc.',
   0x000B1E: u'KAPPA opto-electronics GmbH',
   0x000B1F: u'I CON Computer Co.',
   0x000B20: u'Hirata corporation',
   0x000B21: u'G-Star Communications Inc.',
   0x000B22: u'Environmental Systems and Services',
   0x000B23: u'Siemens Subscriber Networks',
   0x000B24: u'AirLogic',
   0x000B25: u'Aeluros',
   0x000B26: u'Wetek Corporation',
   0x000B27: u'Scion Corporation',
   0x000B28: u'Quatech Inc.',
   0x000B29: u'LG Industrial Systems Co.,Ltd.',
   0x000B2A: u'HOWTEL Co., Ltd.',
   0x000B2B: u'HOSTNET CORPORATION',
   0x000B2C: u'Eiki Industrial Co. Ltd.',
   0x000B2D: u'Danfoss Inc.',
   0x000B2E: u'Cal-Comp Electronics (Thailand) Public Company Limited Taipe',
   0x000B2F: u'bplan GmbH',
   0x000B30: u'Beijing Gongye Science & Technology Co.,Ltd',
   0x000B31: u'Yantai ZhiYang Scientific and technology industry CO., LTD',
   0x000B32: u'VORMETRIC, INC.',
   0x000B33: u'Vivato',
   0x000B34: u'ShangHai Broadband Technologies CO.LTD',
   0x000B35: u'Quad Bit System co., Ltd.',
   0x000B36: u'Productivity Systems, Inc.',
   0x000B37: u'MANUFACTURE DES MONTRES ROLEX SA',
   0x000B38: u'Knuerr AG',
   0x000B39: u'Keisoku Giken Co.,Ltd.',
   0x000B3A: u'QuStream Corporation',
   0x000B3B: u'devolo AG',
   0x000B3C: u'Cygnal Integrated Products, Inc.',
   0x000B3D: u'CONTAL OK Ltd.',
   0x000B3E: u'BittWare, Inc',
   0x000B3F: u'Anthology Solutions Inc.',
   0x000B40: u'OpNext Inc.',
   0x000B41: u'Ing. Buero Dr. Beutlhauser',
   0x000B42: u'commax Co., Ltd.',
   0x000B43: u'Microscan Systems, Inc.',
   0x000B44: u'Concord IDea Corp.',
   0x000B45: u'Cisco',
   0x000B46: u'Cisco',
   0x000B47: u'Advanced Energy',
   0x000B48: u'sofrel',
   0x000B49: u'RF-Link System Inc.',
   0x000B4A: u'Visimetrics (UK) Ltd',
   0x000B4B: u'VISIOWAVE SA',
   0x000B4C: u'Clarion (M) Sdn Bhd',
   0x000B4D: u'Emuzed',
   0x000B4E: u'VertexRSI Antenna Products Division',
   0x000B4F: u'Verifone, INC.',
   0x000B50: u'Oxygnet',
   0x000B51: u'Micetek International Inc.',
   0x000B52: u'JOYMAX ELECTRONICS CORP.',
   0x000B53: u'INITIUM Co., Ltd.',
   0x000B54: u'BiTMICRO Networks, Inc.',
   0x000B55: u'ADInstruments',
   0x000B56: u'Cybernetics',
   0x000B57: u'Silicon Laboratories',
   0x000B58: u'Astronautics C.A  LTD',
   0x000B59: u'ScriptPro, LLC',
   0x000B5A: u'HyperEdge',
   0x000B5B: u'Rincon Research Corporation',
   0x000B5C: u'Newtech Co.,Ltd',
   0x000B5D: u'FUJITSU LIMITED',
   0x000B5E: u'Audio Engineering Society Inc.',
   0x000B5F: u'Cisco Systems',
   0x000B60: u'Cisco Systems',
   0x000B61: u'Friedrich Lütze GmbH &Co.',
   0x000B62: u'Ingenieurbüro Ingo Mohnen',
   0x000B63: u'Kaleidescape',
   0x000B64: u'Kieback & Peter GmbH & Co KG',
   0x000B65: u'Sy.A.C. srl',
   0x000B66: u'Teralink Communications',
   0x000B67: u'Topview Technology Corporation',
   0x000B68: u'Addvalue Communications Pte Ltd',
   0x000B69: u'Franke Finland Oy',
   0x000B6A: u'Asiarock Incorporation',
   0x000B6B: u'Wistron Neweb Corp.',
   0x000B6C: u'Sychip Inc.',
   0x000B6D: u'SOLECTRON JAPAN NAKANIIDA',
   0x000B6E: u'Neff Instrument Corp.',
   0x000B6F: u'Media Streaming Networks Inc',
   0x000B70: u'Load Technology, Inc.',
   0x000B71: u'Litchfield Communications Inc.',
   0x000B72: u'Lawo AG',
   0x000B73: u'Kodeos Communications',
   0x000B74: u'Kingwave Technology Co., Ltd.',
   0x000B75: u'Iosoft Ltd.',
   0x000B76: u'ET&T Co. Ltd.',
   0x000B77: u'Cogent Systems, Inc.',
   0x000B78: u'TAIFATECH INC.',
   0x000B79: u'X-COM, Inc.',
   0x000B7A: u'Wave Science Inc.',
   0x000B7B: u'Test-Um Inc.',
   0x000B7C: u'Telex Communications',
   0x000B7D: u'SOLOMON EXTREME INTERNATIONAL LTD.',
   0x000B7E: u'SAGINOMIYA Seisakusho Inc.',
   0x000B7F: u'OmniWerks',
   0x000B80: u'Lycium Networks',
   0x000B81: u'Kaparel Corporation',
   0x000B82: u'Grandstream Networks, Inc.',
   0x000B83: u'DATAWATT B.V.',
   0x000B84: u'BODET',
   0x000B85: u'Airespace, Inc.',
   0x000B86: u'Aruba Networks',
   0x000B87: u'American Reliance Inc.',
   0x000B88: u'Vidisco ltd.',
   0x000B89: u'Top Global Technology, Ltd.',
   0x000B8A: u'MITEQ Inc.',
   0x000B8B: u'KERAJET, S.A.',
   0x000B8C: u'flextronics israel',
   0x000B8D: u'Avvio Networks',
   0x000B8E: u'Ascent Corporation',
   0x000B8F: u'AKITA ELECTRONICS SYSTEMS CO.,LTD.',
   0x000B90: u'Covaro Networks, Inc.',
   0x000B91: u'Aglaia Gesellschaft für Bildverarbeitung und Kommunikation m',
   0x000B92: u'Ascom Danmark A/S',
   0x000B93: u'Barmag Electronic',
   0x000B94: u'Digital Monitoring Products, Inc.',
   0x000B95: u'eBet Gaming Systems Pty Ltd',
   0x000B96: u'Innotrac Diagnostics Oy',
   0x000B97: u'Matsushita Electric Industrial Co.,Ltd.',
   0x000B98: u'NiceTechVision',
   0x000B99: u'SensAble Technologies, Inc.',
   0x000B9A: u'Shanghai Ulink Telecom Equipment Co. Ltd.',
   0x000B9B: u'Sirius System Co, Ltd.',
   0x000B9C: u'TriBeam Technologies, Inc.',
   0x000B9D: u'TwinMOS Technologies Inc.',
   0x000B9E: u'Yasing Technology Corp.',
   0x000B9F: u'Neue ELSA GmbH',
   0x000BA0: u'T&L Information Inc.',
   0x000BA1: u'SYSCOM Ltd.',
   0x000BA2: u'Sumitomo Electric Networks, Inc',
   0x000BA3: u'Siemens AG, I&S',
   0x000BA4: u'Shiron Satellite Communications Ltd. (1996)',
   0x000BA5: u'Quasar Cipta Mandiri, PT',
   0x000BA6: u'Miyakawa Electric Works Ltd.',
   0x000BA7: u'Maranti Networks',
   0x000BA8: u'HANBACK ELECTRONICS CO., LTD.',
   0x000BA9: u'CloudShield Technologies, Inc.',
   0x000BAA: u'Aiphone co.,Ltd',
   0x000BAB: u'Advantech Technology (CHINA) Co., Ltd.',
   0x000BAC: u'3Com Europe Ltd.',
   0x000BAD: u'PC-PoS Inc.',
   0x000BAE: u'Vitals System Inc.',
   0x000BAF: u'WOOJU COMMUNICATIONS Co,.Ltd',
   0x000BB0: u'Sysnet Telematica srl',
   0x000BB1: u'Super Star Technology Co., Ltd.',
   0x000BB2: u'SMALLBIG TECHNOLOGY',
   0x000BB3: u'RiT technologies Ltd.',
   0x000BB4: u'RDC Semiconductor Inc.,',
   0x000BB5: u'nStor Technologies, Inc.',
   0x000BB6: u'Mototech Inc.',
   0x000BB7: u'Micro Systems Co.,Ltd.',
   0x000BB8: u'Kihoku Electronic Co.',
   0x000BB9: u'Imsys AB',
   0x000BBA: u'Harmonic Broadband Access Networks',
   0x000BBB: u'Etin Systems Co., Ltd',
   0x000BBC: u'En Garde Systems, Inc.',
   0x000BBD: u'Connexionz Limited',
   0x000BBE: u'Cisco Systems',
   0x000BBF: u'Cisco Systems',
   0x000BC0: u'China IWNComm Co., Ltd.',
   0x000BC1: u'Bay Microsystems, Inc.',
   0x000BC2: u'Corinex Communication Corp.',
   0x000BC3: u'Multiplex, Inc.',
   0x000BC4: u'BIOTRONIK GmbH & Co',
   0x000BC5: u'SMC Networks, Inc.',
   0x000BC6: u'ISAC, Inc.',
   0x000BC7: u'ICET S.p.A.',
   0x000BC8: u'AirFlow Networks',
   0x000BC9: u'Electroline Equipment',
   0x000BCA: u'DATAVAN International Corporation',
   0x000BCB: u'Fagor Automation , S. Coop',
   0x000BCC: u'JUSAN, S.A.',
   0x000BCD: u'Compaq (HP)',
   0x000BCE: u'Free2move AB',
   0x000BCF: u'AGFA NDT INC.',
   0x000BD0: u'XiMeta Technology Americas Inc.',
   0x000BD1: u'Aeronix, Inc.',
   0x000BD2: u'Remopro Technology Inc.',
   0x000BD3: u'cd3o',
   0x000BD4: u'Beijing Wise Technology & Science Development Co.Ltd',
   0x000BD5: u'Nvergence, Inc.',
   0x000BD6: u'Paxton Access Ltd',
   0x000BD7: u'MBB Gelma GmbH',
   0x000BD8: u'Industrial Scientific Corp.',
   0x000BD9: u'General Hydrogen',
   0x000BDA: u'EyeCross Co.,Inc.',
   0x000BDB: u'Dell ESG PCBA Test',
   0x000BDC: u'AKCP',
   0x000BDD: u'TOHOKU RICOH Co., LTD.',
   0x000BDE: u'TELDIX GmbH',
   0x000BDF: u'Shenzhen RouterD Networks Limited',
   0x000BE0: u'SercoNet Ltd.',
   0x000BE1: u'Nokia NET Product Operations',
   0x000BE2: u'Lumenera Corporation',
   0x000BE3: u'Key Stream Co., Ltd.',
   0x000BE4: u'Hosiden Corporation',
   0x000BE5: u'HIMS Korea Co., Ltd.',
   0x000BE6: u'Datel Electronics',
   0x000BE7: u'COMFLUX TECHNOLOGY INC.',
   0x000BE8: u'AOIP',
   0x000BE9: u'Actel Corporation',
   0x000BEA: u'Zultys Technologies',
   0x000BEB: u'Systegra AG',
   0x000BEC: u'NIPPON ELECTRIC INSTRUMENT, INC.',
   0x000BED: u'ELM Inc.',
   0x000BEE: u'inc.jet, Incorporated',
   0x000BEF: u'Code Corporation',
   0x000BF0: u'MoTEX Products Co., Ltd.',
   0x000BF1: u'LAP Laser Applikations',
   0x000BF2: u'Chih-Kan Technology Co., Ltd.',
   0x000BF3: u'BAE SYSTEMS',
   0x000BF4: u'PRIVATE',
   0x000BF5: u'Shanghai Sibo Telecom Technology Co.,Ltd',
   0x000BF6: u'Nitgen Co., Ltd',
   0x000BF7: u'NIDEK CO.,LTD',
   0x000BF8: u'Infinera',
   0x000BF9: u'Gemstone communications, Inc.',
   0x000BFA: u'EXEMYS SRL',
   0x000BFB: u'D-NET International Corporation',
   0x000BFC: u'Cisco Systems',
   0x000BFD: u'Cisco Systems',
   0x000BFE: u'CASTEL Broadband Limited',
   0x000BFF: u'Berkeley Camera Engineering',
   0x000C00: u'BEB Industrie-Elektronik AG',
   0x000C01: u'Abatron AG',
   0x000C02: u'ABB Oy',
   0x000C03: u'HDMI Licensing, LLC',
   0x000C04: u'Tecnova',
   0x000C05: u'RPA Reserch Co., Ltd.',
   0x000C06: u'Nixvue Systems  Pte Ltd',
   0x000C07: u'Iftest AG',
   0x000C08: u'HUMEX Technologies Corp.',
   0x000C09: u'Hitachi IE Systems Co., Ltd',
   0x000C0A: u'Guangdong Province Electronic Technology Research Institute',
   0x000C0B: u'Broadbus Technologies',
   0x000C0C: u'APPRO TECHNOLOGY INC.',
   0x000C0D: u'Communications & Power Industries / Satcom Division',
   0x000C0E: u'XtremeSpectrum, Inc.',
   0x000C0F: u'Techno-One Co., Ltd',
   0x000C10: u'PNI Corporation',
   0x000C11: u'NIPPON DEMPA CO.,LTD.',
   0x000C12: u'Micro-Optronic-Messtechnik GmbH',
   0x000C13: u'MediaQ',
   0x000C14: u'Diagnostic Instruments, Inc.',
   0x000C15: u'CyberPower Systems, Inc.',
   0x000C16: u'Concorde Microsystems Inc.',
   0x000C17: u'AJA Video Systems Inc',
   0x000C18: u'Zenisu Keisoku Inc.',
   0x000C19: u'Telio Communications GmbH',
   0x000C1A: u'Quest Technical Solutions Inc.',
   0x000C1B: u'ORACOM Co, Ltd.',
   0x000C1C: u'MicroWeb Co., Ltd.',
   0x000C1D: u'Mettler & Fuchs AG',
   0x000C1E: u'Global Cache',
   0x000C1F: u'Glimmerglass Networks',
   0x000C20: u'Fi WIn, Inc.',
   0x000C21: u'Faculty of Science and Technology, Keio University',
   0x000C22: u'Double D Electronics Ltd',
   0x000C23: u'Beijing Lanchuan Tech. Co., Ltd.',
   0x000C24: u'ANATOR',
   0x000C25: u'Allied Telesyn Networks',
   0x000C26: u'Weintek Labs. Inc.',
   0x000C27: u'Sammy Corporation',
   0x000C28: u'RIFATRON',
   0x000C29: u'VMware, Inc.',
   0x000C2A: u'OCTTEL Communication Co., Ltd.',
   0x000C2B: u'ELIAS Technology, Inc.',
   0x000C2C: u'Enwiser Inc.',
   0x000C2D: u'FullWave Technology Co., Ltd.',
   0x000C2E: u'Openet information technology(shenzhen) Co., Ltd.',
   0x000C2F: u'SeorimTechnology Co.,Ltd.',
   0x000C30: u'Cisco',
   0x000C31: u'Cisco',
   0x000C32: u'Avionic Design Development GmbH',
   0x000C33: u'Compucase Enterprise Co. Ltd.',
   0x000C34: u'Vixen Co., Ltd.',
   0x000C35: u'KaVo Dental GmbH & Co. KG',
   0x000C36: u'SHARP TAKAYA ELECTRONICS INDUSTRY CO.,LTD.',
   0x000C37: u'Geomation, Inc.',
   0x000C38: u'TelcoBridges Inc.',
   0x000C39: u'Sentinel Wireless Inc.',
   0x000C3A: u'Oxance',
   0x000C3B: u'Orion Electric Co., Ltd.',
   0x000C3C: u'MediaChorus, Inc.',
   0x000C3D: u'Glsystech Co., Ltd.',
   0x000C3E: u'Crest Audio',
   0x000C3F: u'Cogent Defence & Security Networks,',
   0x000C40: u'Altech Controls',
   0x000C41: u'The Linksys Group, Inc.',
   0x000C42: u'Routerboard.com',
   0x000C43: u'Ralink Technology, Corp.',
   0x000C44: u'Automated Interfaces, Inc.',
   0x000C45: u'Animation Technologies Inc.',
   0x000C46: u'Allied Telesyn Inc.',
   0x000C47: u'SK Teletech(R&D Planning Team)',
   0x000C48: u'QoStek Corporation',
   0x000C49: u'Dangaard Telecom RTC Division A/S',
   0x000C4A: u'Cygnus Microsystems Private Limited',
   0x000C4B: u'Cheops Elektronik',
   0x000C4C: u'Arcor AG&Co.',
   0x000C4D: u'ACRA CONTROL',
   0x000C4E: u'Winbest Technology CO,LT',
   0x000C4F: u'UDTech Japan Corporation',
   0x000C50: u'Seagate Technology',
   0x000C51: u'Scientific Technologies Inc.',
   0x000C52: u'Roll Systems Inc.',
   0x000C53: u'PRIVATE',
   0x000C54: u'Pedestal Networks, Inc',
   0x000C55: u'Microlink Communications Inc.',
   0x000C56: u'Megatel Computer (1986) Corp.',
   0x000C57: u'MACKIE Engineering Services Belgium BVBA',
   0x000C58: u'M&S Systems',
   0x000C59: u'Indyme Electronics, Inc.',
   0x000C5A: u'IBSmm Industrieelektronik Multimedia',
   0x000C5B: u'HANWANG TECHNOLOGY CO.,LTD',
   0x000C5C: u'GTN Systems B.V.',
   0x000C5D: u'CHIC TECHNOLOGY (CHINA) CORP.',
   0x000C5E: u'Calypso Medical',
   0x000C5F: u'Avtec, Inc.',
   0x000C60: u'ACM Systems',
   0x000C61: u'AC Tech corporation DBA Advanced Digital',
   0x000C62: u'ABB Automation Technology Products AB, Control',
   0x000C63: u'Zenith Electronics Corporation',
   0x000C64: u'X2 MSA Group',
   0x000C65: u'Sunin Telecom',
   0x000C66: u'Pronto Networks Inc',
   0x000C67: u'OYO ELECTRIC CO.,LTD',
   0x000C68: u'SigmaTel, Inc.',
   0x000C69: u'National Radio Astronomy Observatory',
   0x000C6A: u'MBARI',
   0x000C6B: u'Kurz Industrie-Elektronik GmbH',
   0x000C6C: u'Elgato Systems LLC',
   0x000C6D: u'BOC Edwards',
   0x000C6E: u'ASUSTEK COMPUTER INC.',
   0x000C6F: u'Amtek system co.,LTD.',
   0x000C70: u'ACC GmbH',
   0x000C71: u'Wybron, Inc',
   0x000C72: u'Tempearl Industrial Co., Ltd.',
   0x000C73: u'TELSON ELECTRONICS CO., LTD',
   0x000C74: u'RIVERTEC CORPORATION',
   0x000C75: u'Oriental integrated electronics. LTD',
   0x000C76: u'MICRO-STAR INTERNATIONAL CO., LTD.',
   0x000C77: u'Life Racing Ltd',
   0x000C78: u'In-Tech Electronics Limited',
   0x000C79: u'Extel Communications P/L',
   0x000C7A: u'DaTARIUS Technologies GmbH',
   0x000C7B: u'ALPHA PROJECT Co.,Ltd.',
   0x000C7C: u'Internet Information Image Inc.',
   0x000C7D: u'TEIKOKU ELECTRIC MFG. CO., LTD',
   0x000C7E: u'Tellium Incorporated',
   0x000C7F: u'synertronixx GmbH',
   0x000C80: u'Opelcomm Inc.',
   0x000C81: u'Nulec Industries Pty Ltd',
   0x000C82: u'NETWORK TECHNOLOGIES INC',
   0x000C83: u'Logical Solutions',
   0x000C84: u'Eazix, Inc.',
   0x000C85: u'Cisco Systems',
   0x000C86: u'Cisco Systems',
   0x000C87: u'ATI',
   0x000C88: u'Apache Micro Peripherals, Inc.',
   0x000C89: u'AC Electric Vehicles, Ltd.',
   0x000C8A: u'Bose Corporation',
   0x000C8B: u'Connect Tech Inc',
   0x000C8C: u'KODICOM CO.,LTD.',
   0x000C8D: u'MATRIX VISION GmbH',
   0x000C8E: u'Mentor Engineering Inc',
   0x000C8F: u'Nergal s.r.l.',
   0x000C90: u'Octasic Inc.',
   0x000C91: u'Riverhead Networks Inc.',
   0x000C92: u'WolfVision Gmbh',
   0x000C93: u'Xeline Co., Ltd.',
   0x000C94: u'United Electronic Industries, Inc.',
   0x000C95: u'PrimeNet',
   0x000C96: u'OQO, Inc.',
   0x000C97: u'NV ADB TTV Technologies SA',
   0x000C98: u'LETEK Communications Inc.',
   0x000C99: u'HITEL LINK Co.,Ltd',
   0x000C9A: u'Hitech Electronics Corp.',
   0x000C9B: u'EE Solutions, Inc',
   0x000C9C: u'Chongho information & communications',
   0x000C9D: u'AirWalk Communications, Inc.',
   0x000C9E: u'MemoryLink Corp.',
   0x000C9F: u'NKE Corporation',
   0x000CA0: u'StorCase Technology, Inc.',
   0x000CA1: u'SIGMACOM Co., LTD.',
   0x000CA2: u'Scopus Network Technologies Ltd',
   0x000CA3: u'Rancho Technology, Inc.',
   0x000CA4: u'Prompttec Product Management GmbH',
   0x000CA5: u'Naman NZ LTd',
   0x000CA6: u'Mintera Corporation',
   0x000CA7: u'Metro (Suzhou) Technologies Co., Ltd.',
   0x000CA8: u'Garuda Networks Corporation',
   0x000CA9: u'Ebtron Inc.',
   0x000CAA: u'Cubic Transportation Systems Inc',
   0x000CAB: u'COMMEND International',
   0x000CAC: u'Citizen Watch Co., Ltd.',
   0x000CAD: u'BTU International',
   0x000CAE: u'Ailocom Oy',
   0x000CAF: u'TRI TERM CO.,LTD.',
   0x000CB0: u'Star Semiconductor Corporation',
   0x000CB1: u'Salland Engineering (Europe) BV',
   0x000CB2: u'safei Co., Ltd.',
   0x000CB3: u'ROUND Co.,Ltd.',
   0x000CB4: u'AutoCell Laboratories, Inc.',
   0x000CB5: u'Premier Technolgies, Inc',
   0x000CB6: u'NANJING SEU MOBILE & INTERNET TECHNOLOGY CO.,LTD',
   0x000CB7: u'Nanjing Huazhuo Electronics Co., Ltd.',
   0x000CB8: u'MEDION AG',
   0x000CB9: u'LEA',
   0x000CBA: u'Jamex',
   0x000CBB: u'ISKRAEMECO',
   0x000CBC: u'Iscutum',
   0x000CBD: u'Interface Masters, Inc',
   0x000CBE: u'PRIVATE',
   0x000CBF: u'Holy Stone Ent. Co., Ltd.',
   0x000CC0: u'Genera Oy',
   0x000CC1: u'Cooper Industries Inc.',
   0x000CC2: u'PRIVATE',
   0x000CC3: u'BeWAN systems',
   0x000CC4: u'Tiptel AG',
   0x000CC5: u'Nextlink Co., Ltd.',
   0x000CC6: u'Ka-Ro electronics GmbH',
   0x000CC7: u'Intelligent Computer Solutions Inc.',
   0x000CC8: u'Xytronix Research & Design, Inc.',
   0x000CC9: u'ILWOO DATA & TECHNOLOGY CO.,LTD',
   0x000CCA: u'Hitachi Global Storage Technologies',
   0x000CCB: u'Design Combus Ltd',
   0x000CCC: u'Aeroscout Ltd.',
   0x000CCD: u'IEC - TC57',
   0x000CCE: u'Cisco Systems',
   0x000CCF: u'Cisco Systems',
   0x000CD0: u'Symetrix',
   0x000CD1: u'SFOM Technology Corp.',
   0x000CD2: u'Schaffner EMV AG',
   0x000CD3: u'Prettl Elektronik Radeberg GmbH',
   0x000CD4: u'Positron Public Safety Systems inc.',
   0x000CD5: u'Passave Inc.',
   0x000CD6: u'PARTNER TECH',
   0x000CD7: u'Nallatech Ltd',
   0x000CD8: u'M. K. Juchheim GmbH & Co',
   0x000CD9: u'Itcare Co., Ltd',
   0x000CDA: u'FreeHand Systems, Inc.',
   0x000CDB: u'Foundry Networks',
   0x000CDC: u'BECS Technology, Inc',
   0x000CDD: u'AOS Technologies AG',
   0x000CDE: u'ABB STOTZ-KONTAKT GmbH',
   0x000CDF: u'PULNiX America, Inc',
   0x000CE0: u'Trek Diagnostics Inc.',
   0x000CE1: u'The Open Group',
   0x000CE2: u'Rolls-Royce',
   0x000CE3: u'Option International N.V.',
   0x000CE4: u'NeuroCom International, Inc.',
   0x000CE5: u'Motorola BCS',
   0x000CE6: u'Meru Networks Inc',
   0x000CE7: u'MediaTek Inc.',
   0x000CE8: u'GuangZhou AnJuBao Co., Ltd',
   0x000CE9: u'BLOOMBERG L.P.',
   0x000CEA: u'aphona Kommunikationssysteme',
   0x000CEB: u'CNMP Networks, Inc.',
   0x000CEC: u'Spectracom Corp.',
   0x000CED: u'Real Digital Media',
   0x000CEE: u'jp-embedded',
   0x000CEF: u'Open Networks Engineering Ltd',
   0x000CF0: u'M & N GmbH',
   0x000CF1: u'Intel Corporation',
   0x000CF2: u'GAMESA EÓLICA',
   0x000CF3: u'CALL IMAGE SA',
   0x000CF4: u'AKATSUKI ELECTRIC MFG.CO.,LTD.',
   0x000CF5: u'InfoExpress',
   0x000CF6: u'Sitecom Europe BV',
   0x000CF7: u'Nortel Networks',
   0x000CF8: u'Nortel Networks',
   0x000CF9: u'ITT Flygt AB',
   0x000CFA: u'Digital Systems Corp',
   0x000CFB: u'Korea Network Systems',
   0x000CFC: u'S2io Technologies Corp',
   0x000CFD: u'PRIVATE',
   0x000CFE: u'Grand Electronic Co., Ltd',
   0x000CFF: u'MRO-TEK LIMITED',
   0x000D00: u'Seaway Networks Inc.',
   0x000D01: u'P&E Microcomputer Systems, Inc.',
   0x000D02: u'NEC AccessTechnica,Ltd',
   0x000D03: u'Matrics, Inc.',
   0x000D04: u'Foxboro Eckardt Development GmbH',
   0x000D05: u'cybernet manufacturing inc.',
   0x000D06: u'Compulogic Limited',
   0x000D07: u'Calrec Audio Ltd',
   0x000D08: u'AboveCable, Inc.',
   0x000D09: u'Yuehua(Zhuhai) Electronic CO. LTD',
   0x000D0A: u'Projectiondesign as',
   0x000D0B: u'Buffalo Inc.',
   0x000D0C: u'MDI Security Systems',
   0x000D0D: u'ITSupported, LLC',
   0x000D0E: u'Inqnet Systems, Inc.',
   0x000D0F: u'Finlux Ltd',
   0x000D10: u'Embedtronics Oy',
   0x000D11: u'DENTSPLY - Gendex',
   0x000D12: u'AXELL Corporation',
   0x000D13: u'Wilhelm Rutenbeck GmbH&Co.',
   0x000D14: u'Vtech Innovation LP dba Advanced American Telephones',
   0x000D15: u'Voipac s.r.o.',
   0x000D16: u'UHS Systems Pty Ltd',
   0x000D17: u'Turbo Networks Co.Ltd',
   0x000D18: u'Sunitec Enterprise Co., Ltd.',
   0x000D19: u'ROBE Show lighting',
   0x000D1A: u'Mustek System Inc.',
   0x000D1B: u'Kyoto Electronics Manufacturing Co., Ltd.',
   0x000D1C: u'I2E TELECOM',
   0x000D1D: u'HIGH-TEK HARNESS ENT. CO., LTD.',
   0x000D1E: u'Control Techniques',
   0x000D1F: u'AV Digital',
   0x000D20: u'ASAHIKASEI TECHNOSYSTEM CO.,LTD.',
   0x000D21: u'WISCORE Inc.',
   0x000D22: u'Unitronics',
   0x000D23: u'Smart Solution, Inc',
   0x000D24: u'SENTEC E&E CO., LTD.',
   0x000D25: u'SANDEN CORPORATION',
   0x000D26: u'Primagraphics Limited',
   0x000D27: u'MICROPLEX Printware AG',
   0x000D28: u'Cisco',
   0x000D29: u'Cisco',
   0x000D2A: u'Scanmatic AS',
   0x000D2B: u'Racal Instruments',
   0x000D2C: u'Patapsco Designs Ltd',
   0x000D2D: u'NCT Deutschland GmbH',
   0x000D2E: u'Matsushita Avionics Systems Corporation',
   0x000D2F: u'AIN Comm.Tech.Co., LTD',
   0x000D30: u'IceFyre Semiconductor',
   0x000D31: u'Compellent Technologies, Inc.',
   0x000D32: u'DispenseSource, Inc.',
   0x000D33: u'Prediwave Corp.',
   0x000D34: u'Shell International Exploration and Production, Inc.',
   0x000D35: u'PAC International Ltd',
   0x000D36: u'Wu Han Routon Electronic Co., Ltd',
   0x000D37: u'WIPLUG',
   0x000D38: u'NISSIN INC.',
   0x000D39: u'Network Electronics',
   0x000D3A: u'Microsoft Corp.',
   0x000D3B: u'Microelectronics Technology Inc.',
   0x000D3C: u'i.Tech Dynamic Ltd',
   0x000D3D: u'Hammerhead Systems, Inc.',
   0x000D3E: u'APLUX Communications Ltd.',
   0x000D3F: u'VXI Technology',
   0x000D40: u'Verint Loronix Video Solutions',
   0x000D41: u'Siemens AG ICM MP UC RD IT KLF1',
   0x000D42: u'Newbest Development Limited',
   0x000D43: u'DRS Tactical Systems Inc.',
   0x000D44: u'PRIVATE',
   0x000D45: u'Tottori SANYO Electric Co., Ltd.',
   0x000D46: u'SSD Drives, Inc.',
   0x000D47: u'Collex',
   0x000D48: u'AEWIN Technologies Co., Ltd.',
   0x000D49: u'Triton Systems of Delaware, Inc.',
   0x000D4A: u'Steag ETA-Optik',
   0x000D4B: u'Roku, LLC',
   0x000D4C: u'Outline Electronics Ltd.',
   0x000D4D: u'Ninelanes',
   0x000D4E: u'NDR Co.,LTD.',
   0x000D4F: u'Kenwood Corporation',
   0x000D50: u'Galazar Networks',
   0x000D51: u'DIVR Systems, Inc.',
   0x000D52: u'Comart system',
   0x000D53: u'Beijing 5w Communication Corp.',
   0x000D54: u'3Com Europe Ltd',
   0x000D55: u'SANYCOM Technology Co.,Ltd',
   0x000D56: u'Dell PCBA Test',
   0x000D57: u'Fujitsu I-Network Systems Limited.',
   0x000D58: u'PRIVATE',
   0x000D59: u'Amity Systems, Inc.',
   0x000D5A: u'Tiesse SpA',
   0x000D5B: u'Smart Empire Investments Limited',
   0x000D5C: u'Robert Bosch GmbH, VT-ATMO',
   0x000D5D: u'Raritan Computer, Inc',
   0x000D5E: u'NEC CustomTechnica, Ltd.',
   0x000D5F: u'Minds Inc',
   0x000D60: u'IBM Corporation',
   0x000D61: u'Giga-Byte Technology Co., Ltd.',
   0x000D62: u'Funkwerk Dabendorf GmbH',
   0x000D63: u'DENT Instruments, Inc.',
   0x000D64: u'COMAG Handels AG',
   0x000D65: u'Cisco Systems',
   0x000D66: u'Cisco Systems',
   0x000D67: u'BelAir Networks Inc.',
   0x000D68: u'Vinci Systems, Inc.',
   0x000D69: u'TMT&D Corporation',
   0x000D6A: u'Redwood Technologies LTD',
   0x000D6B: u'Mita-Teknik A/S',
   0x000D6C: u'M-Audio',
   0x000D6D: u'K-Tech Devices Corp.',
   0x000D6E: u'K-Patents Oy',
   0x000D6F: u'Ember Corporation',
   0x000D70: u'Datamax Corporation',
   0x000D71: u'boca systems',
   0x000D72: u'2Wire, Inc',
   0x000D73: u'Technical Support, Inc.',
   0x000D74: u'Sand Network Systems, Inc.',
   0x000D75: u'Kobian Pte Ltd - Taiwan Branch',
   0x000D76: u'Hokuto Denshi Co,. Ltd.',
   0x000D77: u'FalconStor Software',
   0x000D78: u'Engineering & Security',
   0x000D79: u'Dynamic Solutions Co,.Ltd.',
   0x000D7A: u'DiGATTO Asia Pacific Pte Ltd',
   0x000D7B: u'Consensys Computers Inc.',
   0x000D7C: u'Codian Ltd',
   0x000D7D: u'Afco Systems',
   0x000D7E: u'Axiowave Networks, Inc.',
   0x000D7F: u'MIDAS  COMMUNICATION TECHNOLOGIES PTE LTD ( Foreign Branch)',
   0x000D80: u'Online Development Inc',
   0x000D81: u'Pepperl+Fuchs GmbH',
   0x000D82: u'PHS srl',
   0x000D83: u'Sanmina-SCI Hungary  Ltd.',
   0x000D84: u'Makus Inc.',
   0x000D85: u'Tapwave, Inc.',
   0x000D86: u'Huber + Suhner AG',
   0x000D87: u'Elitegroup Computer System Co. (ECS)',
   0x000D88: u'D-Link Corporation',
   0x000D89: u'Bils Technology Inc',
   0x000D8A: u'Winners Electronics Co., Ltd.',
   0x000D8B: u'T&D Corporation',
   0x000D8C: u'Shanghai Wedone Digital Ltd. CO.',
   0x000D8D: u'ProLinx Communication Gateways, Inc.',
   0x000D8E: u'Koden Electronics Co., Ltd.',
   0x000D8F: u'King Tsushin Kogyo Co., LTD.',
   0x000D90: u'Factum Electronics AB',
   0x000D91: u'Eclipse (HQ Espana) S.L.',
   0x000D92: u'Arima Communication Corporation',
   0x000D93: u'Apple Computer',
   0x000D94: u'AFAR Communications,Inc',
   0x000D95: u'Opti-cell, Inc.',
   0x000D96: u'Vtera Technology Inc.',
   0x000D97: u'Tropos Networks, Inc.',
   0x000D98: u'S.W.A.C. Schmitt-Walter Automation Consult GmbH',
   0x000D99: u'Orbital Sciences Corp.; Launch Systems Group',
   0x000D9A: u'INFOTEC LTD',
   0x000D9B: u'Heraeus Electro-Nite International N.V.',
   0x000D9C: u'Elan GmbH & Co KG',
   0x000D9D: u'Hewlett Packard',
   0x000D9E: u'TOKUDEN OHIZUMI SEISAKUSYO Co.,Ltd.',
   0x000D9F: u'RF Micro Devices',
   0x000DA0: u'NEDAP N.V.',
   0x000DA1: u'MIRAE ITS Co.,LTD.',
   0x000DA2: u'Infrant Technologies, Inc.',
   0x000DA3: u'Emerging Technologies Limited',
   0x000DA4: u'DOSCH & AMAND SYSTEMS AG',
   0x000DA5: u'Fabric7 Systems, Inc',
   0x000DA6: u'Universal Switching Corporation',
   0x000DA7: u'PRIVATE',
   0x000DA8: u'Teletronics Technology Corporation',
   0x000DA9: u'T.E.A.M. S.L.',
   0x000DAA: u'S.A.Tehnology co.,Ltd.',
   0x000DAB: u'Parker Hannifin GmbH Electromechanical Division Europe',
   0x000DAC: u'Japan CBM Corporation',
   0x000DAD: u'Dataprobe Inc',
   0x000DAE: u'SAMSUNG HEAVY INDUSTRIES CO., LTD.',
   0x000DAF: u'Plexus Corp (UK) Ltd',
   0x000DB0: u'Olym-tech Co.,Ltd.',
   0x000DB1: u'Japan Network Service Co., Ltd.',
   0x000DB2: u'Ammasso, Inc.',
   0x000DB3: u'SDO Communication Corperation',
   0x000DB4: u'NETASQ',
   0x000DB5: u'GLOBALSAT TECHNOLOGY CORPORATION',
   0x000DB6: u'Teknovus, Inc.',
   0x000DB7: u'SANKO ELECTRIC CO,.LTD',
   0x000DB8: u'SCHILLER AG',
   0x000DB9: u'PC Engines GmbH',
   0x000DBA: u'Océ Document Technologies GmbH',
   0x000DBB: u'Nippon Dentsu Co.,Ltd.',
   0x000DBC: u'Cisco Systems',
   0x000DBD: u'Cisco Systems',
   0x000DBE: u'Bel Fuse Europe Ltd.,UK',
   0x000DBF: u'TekTone Sound & Signal Mfg., Inc.',
   0x000DC0: u'Spagat AS',
   0x000DC1: u'SafeWeb Inc',
   0x000DC2: u'PRIVATE',
   0x000DC3: u'First Communication, Inc.',
   0x000DC4: u'Emcore Corporation',
   0x000DC5: u'EchoStar International Corporation',
   0x000DC6: u'DigiRose Technology Co., Ltd.',
   0x000DC7: u'COSMIC ENGINEERING INC.',
   0x000DC8: u'AirMagnet, Inc',
   0x000DC9: u'THALES Elektronik Systeme GmbH',
   0x000DCA: u'Tait Electronics',
   0x000DCB: u'Petcomkorea Co., Ltd.',
   0x000DCC: u'NEOSMART Corp.',
   0x000DCD: u'GROUPE TXCOM',
   0x000DCE: u'Dynavac Technology Pte Ltd',
   0x000DCF: u'Cidra Corp.',
   0x000DD0: u'TetraTec Instruments GmbH',
   0x000DD1: u'Stryker Corporation',
   0x000DD2: u'Simrad Optronics ASA',
   0x000DD3: u'SAMWOO Telecommunication Co.,Ltd.',
   0x000DD4: u'Revivio Inc.',
   0x000DD5: u'O\'RITE TECHNOLOGY CO.,LTD',
   0x000DD6: u'ITI    LTD',
   0x000DD7: u'Bright',
   0x000DD8: u'BBN',
   0x000DD9: u'Anton Paar GmbH',
   0x000DDA: u'ALLIED TELESIS K.K.',
   0x000DDB: u'AIRWAVE TECHNOLOGIES INC.',
   0x000DDC: u'VAC',
   0x000DDD: u'PROFÝLO TELRA ELEKTRONÝK SANAYÝ VE TÝCARET A.Þ.',
   0x000DDE: u'Joyteck Co., Ltd.',
   0x000DDF: u'Japan Image & Network Inc.',
   0x000DE0: u'ICPDAS Co.,LTD',
   0x000DE1: u'Control Products, Inc.',
   0x000DE2: u'CMZ Sistemi Elettronici',
   0x000DE3: u'AT Sweden AB',
   0x000DE4: u'DIGINICS, Inc.',
   0x000DE5: u'Samsung Thales',
   0x000DE6: u'YOUNGBO ENGINEERING CO.,LTD',
   0x000DE7: u'Snap-on OEM Group',
   0x000DE8: u'Nasaco Electronics Pte. Ltd',
   0x000DE9: u'Napatech Aps',
   0x000DEA: u'Kingtel Telecommunication Corp.',
   0x000DEB: u'CompXs Limited',
   0x000DEC: u'Cisco Systems',
   0x000DED: u'Cisco Systems',
   0x000DEE: u'Andrew RF Power Amplifier Group',
   0x000DEF: u'Soc. Coop. Bilanciai',
   0x000DF0: u'QCOM TECHNOLOGY INC.',
   0x000DF1: u'IONIX INC.',
   0x000DF2: u'PRIVATE',
   0x000DF3: u'Asmax Solutions',
   0x000DF4: u'Watertek Co.',
   0x000DF5: u'Teletronics International Inc.',
   0x000DF6: u'Technology Thesaurus Corp.',
   0x000DF7: u'Space Dynamics Lab',
   0x000DF8: u'ORGA Kartensysteme GmbH',
   0x000DF9: u'NDS Limited',
   0x000DFA: u'Micro Control Systems Ltd.',
   0x000DFB: u'Komax AG',
   0x000DFC: u'ITFOR Inc. resarch and development',
   0x000DFD: u'Huges Hi-Tech Inc.,',
   0x000DFE: u'Hauppauge Computer Works, Inc.',
   0x000DFF: u'CHENMING MOLD INDUSTRY CORP.',
   0x000E00: u'Atrie',
   0x000E01: u'ASIP Technologies Inc.',
   0x000E02: u'Advantech AMT Inc.',
   0x000E03: u'Emulex',
   0x000E04: u'CMA/Microdialysis AB',
   0x000E05: u'WIRELESS MATRIX CORP.',
   0x000E06: u'Team Simoco Ltd',
   0x000E07: u'Sony Ericsson Mobile Communications AB',
   0x000E08: u'Sipura Technology, Inc.',
   0x000E09: u'Shenzhen Coship Software Co.,LTD.',
   0x000E0A: u'SAKUMA DESIGN OFFICE',
   0x000E0B: u'Netac Technology Co., Ltd.',
   0x000E0C: u'Intel Corporation',
   0x000E0D: u'HESCH Schröder GmbH',
   0x000E0E: u'ESA elettronica S.P.A.',
   0x000E0F: u'ERMME',
   0x000E10: u'PRIVATE',
   0x000E11: u'BDT Büro- und Datentechnik GmbH & Co. KG',
   0x000E12: u'Adaptive Micro Systems Inc.',
   0x000E13: u'Accu-Sort Systems inc.',
   0x000E14: u'Visionary Solutions, Inc.',
   0x000E15: u'Tadlys LTD',
   0x000E16: u'SouthWing',
   0x000E17: u'PRIVATE',
   0x000E18: u'MyA Technology',
   0x000E19: u'LogicaCMG Pty Ltd',
   0x000E1A: u'JPS Communications',
   0x000E1B: u'IAV GmbH',
   0x000E1C: u'Hach Company',
   0x000E1D: u'ARION Technology Inc.',
   0x000E1E: u'PRIVATE',
   0x000E1F: u'TCL Networks Equipment Co., Ltd.',
   0x000E20: u'PalmSource, Inc.',
   0x000E21: u'MTU Friedrichshafen GmbH',
   0x000E22: u'PRIVATE',
   0x000E23: u'Incipient, Inc.',
   0x000E24: u'Huwell Technology Inc.',
   0x000E25: u'Hannae Technology Co., Ltd',
   0x000E26: u'Gincom Technology Corp.',
   0x000E27: u'Crere Networks, Inc.',
   0x000E28: u'Dynamic Ratings P/L',
   0x000E29: u'Shester Communications Inc',
   0x000E2A: u'PRIVATE',
   0x000E2B: u'Safari Technologies',
   0x000E2C: u'Netcodec co.',
   0x000E2D: u'Hyundai Digital Technology Co.,Ltd.',
   0x000E2E: u'Edimax Technology Co., Ltd.',
   0x000E2F: u'Disetronic Medical Systems AG',
   0x000E30: u'AERAS Networks, Inc.',
   0x000E31: u'Olympus BioSystems GmbH',
   0x000E32: u'Kontron Medical',
   0x000E33: u'Shuko Electronics Co.,Ltd',
   0x000E34: u'NexGen City, LP',
   0x000E35: u'Intel Corp',
   0x000E36: u'HEINESYS, Inc.',
   0x000E37: u'Harms & Wende GmbH & Co.KG',
   0x000E38: u'Cisco Systems',
   0x000E39: u'Cisco Systems',
   0x000E3A: u'Cirrus Logic',
   0x000E3B: u'Hawking Technologies, Inc.',
   0x000E3C: u'TransAct Technoloiges Inc.',
   0x000E3D: u'Televic N.V.',
   0x000E3E: u'Sun Optronics Inc',
   0x000E3F: u'Soronti, Inc.',
   0x000E40: u'Nortel Networks',
   0x000E41: u'NIHON MECHATRONICS CO.,LTD.',
   0x000E42: u'Motic Incoporation Ltd.',
   0x000E43: u'G-Tek Electronics Sdn. Bhd.',
   0x000E44: u'Digital 5, Inc.',
   0x000E45: u'Beijing Newtry Electronic Technology Ltd',
   0x000E46: u'Niigata Seimitsu Co.,Ltd.',
   0x000E47: u'NCI System Co.,Ltd.',
   0x000E48: u'Lipman TransAction Solutions',
   0x000E49: u'Forsway Scandinavia AB',
   0x000E4A: u'Changchun Huayu WEBPAD Co.,LTD',
   0x000E4B: u'atrium c and i',
   0x000E4C: u'Bermai Inc.',
   0x000E4D: u'Numesa Inc.',
   0x000E4E: u'Waveplus Technology Co., Ltd.',
   0x000E4F: u'Trajet GmbH',
   0x000E50: u'Thomson Telecom Belgium',
   0x000E51: u'tecna elettronica srl',
   0x000E52: u'Optium Corporation',
   0x000E53: u'AV TECH CORPORATION',
   0x000E54: u'AlphaCell Wireless Ltd.',
   0x000E55: u'AUVITRAN',
   0x000E56: u'4G Systems GmbH',
   0x000E57: u'Iworld Networking, Inc.',
   0x000E58: u'Sonos, Inc.',
   0x000E59: u'SAGEM SA',
   0x000E5A: u'TELEFIELD inc.',
   0x000E5B: u'ParkerVision - Direct2Data',
   0x000E5C: u'Motorola BCS',
   0x000E5D: u'Triple Play Technologies A/S',
   0x000E5E: u'Beijing Raisecom Science & Technology Development Co.,Ltd',
   0x000E5F: u'activ-net GmbH & Co. KG',
   0x000E60: u'360SUN Digital Broadband Corporation',
   0x000E61: u'MICROTROL LIMITED',
   0x000E62: u'Nortel Networks',
   0x000E63: u'Lemke Diagnostics GmbH',
   0x000E64: u'Elphel, Inc',
   0x000E65: u'TransCore',
   0x000E66: u'Hitachi Advanced Digital, Inc.',
   0x000E67: u'Eltis Microelectronics Ltd.',
   0x000E68: u'E-TOP Network Technology Inc.',
   0x000E69: u'China Electric Power Research Institute',
   0x000E6A: u'3COM EUROPE LTD',
   0x000E6B: u'Janitza electronics GmbH',
   0x000E6C: u'Device Drivers Limited',
   0x000E6D: u'Murata Manufacturing Co., Ltd.',
   0x000E6E: u'MICRELEC  ELECTRONICS S.A',
   0x000E6F: u'IRIS Corporation Berhad',
   0x000E70: u'in2 Networks',
   0x000E71: u'Gemstar Technology Development Ltd.',
   0x000E72: u'CTS electronics',
   0x000E73: u'Tpack A/S',
   0x000E74: u'Solar Telecom. Tech',
   0x000E75: u'New York Air Brake Corp.',
   0x000E76: u'GEMSOC INNOVISION INC.',
   0x000E77: u'Decru, Inc.',
   0x000E78: u'Amtelco',
   0x000E79: u'Ample Communications Inc.',
   0x000E7A: u'GemWon Communications Co., Ltd.',
   0x000E7B: u'Toshiba',
   0x000E7C: u'Televes S.A.',
   0x000E7D: u'Electronics Line 3000 Ltd.',
   0x000E7E: u'Comprog Oy',
   0x000E7F: u'Hewlett Packard',
   0x000E80: u'Thomson Technology Inc',
   0x000E81: u'Devicescape Software, Inc.',
   0x000E82: u'Commtech Wireless',
   0x000E83: u'Cisco Systems',
   0x000E84: u'Cisco Systems',
   0x000E85: u'Catalyst Enterprises, Inc.',
   0x000E86: u'Alcatel North America',
   0x000E87: u'adp Gauselmann GmbH',
   0x000E88: u'VIDEOTRON CORP.',
   0x000E89: u'CLEMATIC',
   0x000E8A: u'Avara Technologies Pty. Ltd.',
   0x000E8B: u'Astarte Technology Co, Ltd.',
   0x000E8C: u'Siemens AG A&D ET',
   0x000E8D: u'Systems in Progress Holding GmbH',
   0x000E8E: u'SparkLAN Communications, Inc.',
   0x000E8F: u'Sercomm Corp.',
   0x000E90: u'PONICO CORP.',
   0x000E91: u'Northstar Technologies',
   0x000E92: u'Millinet Co., Ltd.',
   0x000E93: u'Milénio 3 Sistemas Electrónicos, Lda.',
   0x000E94: u'Maas International BV',
   0x000E95: u'Fujiya Denki Seisakusho Co.,Ltd.',
   0x000E96: u'Cubic Defense Applications, Inc.',
   0x000E97: u'Ultracker Technology CO., Inc',
   0x000E98: u'Vitec CC, INC.',
   0x000E99: u'Spectrum Digital, Inc',
   0x000E9A: u'BOE TECHNOLOGY GROUP CO.,LTD',
   0x000E9B: u'Ambit Microsystems Corporation',
   0x000E9C: u'Pemstar',
   0x000E9D: u'Video Networks Ltd',
   0x000E9E: u'Topfield Co., Ltd',
   0x000E9F: u'TEMIC SDS GmbH',
   0x000EA0: u'NetKlass Technology Inc.',
   0x000EA1: u'Formosa Teletek Corporation',
   0x000EA2: u'CyberGuard Corporation',
   0x000EA3: u'CNCR-IT CO.,LTD,HangZhou P.R.CHINA',
   0x000EA4: u'Certance Inc.',
   0x000EA5: u'BLIP Systems',
   0x000EA6: u'ASUSTEK COMPUTER INC.',
   0x000EA7: u'Endace Inc Ltd.',
   0x000EA8: u'United Technologists Europe Limited',
   0x000EA9: u'Shanghai Xun Shi Communications Equipment Ltd. Co.',
   0x000EAA: u'Scalent Systems, Inc.',
   0x000EAB: u'OctigaBay Systems Corporation',
   0x000EAC: u'MINTRON ENTERPRISE CO., LTD.',
   0x000EAD: u'Metanoia Technologies, Inc.',
   0x000EAE: u'GAWELL TECHNOLOGIES CORP.',
   0x000EAF: u'CASTEL',
   0x000EB0: u'Solutions Radio BV',
   0x000EB1: u'Newcotech,Ltd',
   0x000EB2: u'Micro-Research Finland Oy',
   0x000EB3: u'LeftHand Networks',
   0x000EB4: u'GUANGZHOU GAOKE COMMUNICATIONS TECHNOLOGY CO.LTD.',
   0x000EB5: u'Ecastle Electronics Co., Ltd.',
   0x000EB6: u'Riverbed Technology, Inc.',
   0x000EB7: u'Knovative, Inc.',
   0x000EB8: u'Iiga co.,Ltd',
   0x000EB9: u'HASHIMOTO Electronics Industry Co.,Ltd.',
   0x000EBA: u'HANMI SEMICONDUCTOR CO., LTD.',
   0x000EBB: u'Everbee Networks',
   0x000EBC: u'Cullmann GmbH',
   0x000EBD: u'Burdick, a Quinton Compny',
   0x000EBE: u'B&B Electronics Manufacturing Co.',
   0x000EBF: u'Remsdaq Limited',
   0x000EC0: u'Nortel Networks',
   0x000EC1: u'MYNAH Technologies',
   0x000EC2: u'Lowrance Electronics, Inc.',
   0x000EC3: u'Logic Controls, Inc.',
   0x000EC4: u'Iskra Transmission d.d.',
   0x000EC5: u'Digital Multitools Inc',
   0x000EC6: u'ASIX ELECTRONICS CORP.',
   0x000EC7: u'Motorola Korea',
   0x000EC8: u'Zoran Corporation',
   0x000EC9: u'YOKO Technology Corp.',
   0x000ECA: u'WTSS Inc',
   0x000ECB: u'VineSys Technology',
   0x000ECC: u'Tableau',
   0x000ECD: u'SKOV A/S',
   0x000ECE: u'S.I.T.T.I. S.p.A.',
   0x000ECF: u'PROFIBUS Nutzerorganisation e.V.',
   0x000ED0: u'Privaris, Inc.',
   0x000ED1: u'Osaka Micro Computer.',
   0x000ED2: u'Filtronic plc',
   0x000ED3: u'Epicenter, Inc.',
   0x000ED4: u'CRESITT INDUSTRIE',
   0x000ED5: u'COPAN Systems Inc.',
   0x000ED6: u'Cisco Systems',
   0x000ED7: u'Cisco Systems',
   0x000ED8: u'Aktino, Inc.',
   0x000ED9: u'Aksys, Ltd.',
   0x000EDA: u'C-TECH UNITED CORP.',
   0x000EDB: u'XiNCOM Corp.',
   0x000EDC: u'Tellion INC.',
   0x000EDD: u'SHURE INCORPORATED',
   0x000EDE: u'REMEC, Inc.',
   0x000EDF: u'PLX Technology',
   0x000EE0: u'Mcharge',
   0x000EE1: u'ExtremeSpeed Inc.',
   0x000EE2: u'Custom Engineering S.p.A.',
   0x000EE3: u'Chiyu Technology Co.,Ltd',
   0x000EE4: u'BOE TECHNOLOGY GROUP CO.,LTD',
   0x000EE5: u'bitWallet, Inc.',
   0x000EE6: u'Adimos Systems LTD',
   0x000EE7: u'AAC ELECTRONICS CORP.',
   0x000EE8: u'zioncom',
   0x000EE9: u'WayTech Development, Inc.',
   0x000EEA: u'Shadong Luneng Jicheng Electronics,Co.,Ltd',
   0x000EEB: u'Sandmartin(zhong shan)Electronics Co.,Ltd',
   0x000EEC: u'Orban',
   0x000EED: u'Nokia Danmark A/S',
   0x000EEE: u'Muco Industrie BV',
   0x000EEF: u'PRIVATE',
   0x000EF0: u'Festo AG & Co. KG',
   0x000EF1: u'EZQUEST INC.',
   0x000EF2: u'Infinico Corporation',
   0x000EF3: u'Smarthome',
   0x000EF4: u'Shenzhen Kasda Digital Technology Co.,Ltd',
   0x000EF5: u'iPAC Technology Co., Ltd.',
   0x000EF6: u'E-TEN Information Systems Co., Ltd.',
   0x000EF7: u'Vulcan Portals Inc',
   0x000EF8: u'SBC ASI',
   0x000EF9: u'REA Elektronik GmbH',
   0x000EFA: u'Optoway Technology Incorporation',
   0x000EFB: u'Macey Enterprises',
   0x000EFC: u'JTAG Technologies B.V.',
   0x000EFD: u'FUJI PHOTO OPTICAL CO., LTD.',
   0x000EFE: u'EndRun Technologies LLC',
   0x000EFF: u'Megasolution,Inc.',
   0x000F00: u'Legra Systems, Inc.',
   0x000F01: u'DIGITALKS INC',
   0x000F02: u'Digicube Technology Co., Ltd',
   0x000F03: u'COM&C CO., LTD',
   0x000F04: u'cim-usa inc',
   0x000F05: u'3B SYSTEM INC.',
   0x000F06: u'Nortel Networks',
   0x000F07: u'Mangrove Systems, Inc.',
   0x000F08: u'Indagon Oy',
   0x000F09: u'PRIVATE',
   0x000F0A: u'Clear Edge Networks',
   0x000F0B: u'Kentima Technologies AB',
   0x000F0C: u'SYNCHRONIC ENGINEERING',
   0x000F0D: u'Hunt Electronic Co., Ltd.',
   0x000F0E: u'WaveSplitter Technologies, Inc.',
   0x000F0F: u'Real ID Technology Co., Ltd.',
   0x000F10: u'RDM Corporation',
   0x000F11: u'Prodrive B.V.',
   0x000F12: u'Panasonic AVC Networks Germany GmbH',
   0x000F13: u'Nisca corporation',
   0x000F14: u'Mindray Co., Ltd.',
   0x000F15: u'Kjaerulff1 A/S',
   0x000F16: u'JAY HOW TECHNOLOGY CO.,',
   0x000F17: u'Insta Elektro GmbH',
   0x000F18: u'Industrial Control Systems',
   0x000F19: u'Guidant Corporation',
   0x000F1A: u'Gaming Support B.V.',
   0x000F1B: u'Ego Systems Inc.',
   0x000F1C: u'DigitAll World Co., Ltd',
   0x000F1D: u'Cosmo Techs Co., Ltd.',
   0x000F1E: u'Chengdu KT Electric Co.of High & New Technology',
   0x000F1F: u'WW PCBA Test',
   0x000F20: u'Hewlett Packard',
   0x000F21: u'Scientific Atlanta, Inc',
   0x000F22: u'Helius, Inc.',
   0x000F23: u'Cisco Systems',
   0x000F24: u'Cisco Systems',
   0x000F25: u'AimValley B.V.',
   0x000F26: u'WorldAccxx  LLC',
   0x000F27: u'TEAL Electronics, Inc.',
   0x000F28: u'Itronix Corporation',
   0x000F29: u'Augmentix Corporation',
   0x000F2A: u'Cableware Electronics',
   0x000F2B: u'GREENBELL SYSTEMS',
   0x000F2C: u'Uplogix, Inc.',
   0x000F2D: u'CHUNG-HSIN ELECTRIC & MACHINERY MFG.CORP.',
   0x000F2E: u'Megapower International Corp.',
   0x000F2F: u'W-LINX TECHNOLOGY CO., LTD.',
   0x000F30: u'Raza Microelectronics Inc',
   0x000F31: u'Prosilica',
   0x000F32: u'LuTong Electronic Technology Co.,Ltd',
   0x000F33: u'DUALi Inc.',
   0x000F34: u'Cisco Systems',
   0x000F35: u'Cisco Systems',
   0x000F36: u'Accurate Techhnologies, Inc.',
   0x000F37: u'Xambala Incorporated',
   0x000F38: u'Netstar',
   0x000F39: u'IRIS SENSORS',
   0x000F3A: u'HISHARP',
   0x000F3B: u'Fuji System Machines Co., Ltd.',
   0x000F3C: u'Endeleo Limited',
   0x000F3D: u'D-Link Corporation',
   0x000F3E: u'CardioNet, Inc',
   0x000F3F: u'Big Bear Networks',
   0x000F40: u'Optical Internetworking Forum',
   0x000F41: u'Zipher Ltd',
   0x000F42: u'Xalyo Systems',
   0x000F43: u'Wasabi Systems Inc.',
   0x000F44: u'Tivella Inc.',
   0x000F45: u'Stretch, Inc.',
   0x000F46: u'SINAR AG',
   0x000F47: u'ROBOX SPA',
   0x000F48: u'Polypix Inc.',
   0x000F49: u'Northover Solutions Limited',
   0x000F4A: u'Kyushu-kyohan co.,ltd',
   0x000F4B: u'Katana Technology',
   0x000F4C: u'Elextech INC',
   0x000F4D: u'Centrepoint Technologies Inc.',
   0x000F4E: u'Cellink',
   0x000F4F: u'Cadmus Technology Ltd',
   0x000F50: u'Baxall Limited',
   0x000F51: u'Azul Systems, Inc.',
   0x000F52: u'YORK Refrigeration, Marine & Controls',
   0x000F53: u'Solarflare Communications Inc',
   0x000F54: u'Entrelogic Corporation',
   0x000F55: u'Datawire Communication Networks Inc.',
   0x000F56: u'Continuum Photonics Inc',
   0x000F57: u'CABLELOGIC Co., Ltd.',
   0x000F58: u'Adder Technology Limited',
   0x000F59: u'Phonak Communications AG',
   0x000F5A: u'Peribit Networks',
   0x000F5B: u'Delta Information Systems, Inc.',
   0x000F5C: u'Day One Digital Media Limited',
   0x000F5D: u'42Networks AB',
   0x000F5E: u'Veo',
   0x000F5F: u'Nicety Technologies Inc. (NTS)',
   0x000F60: u'Lifetron Co.,Ltd',
   0x000F61: u'Kiwi Networks',
   0x000F62: u'Alcatel Bell Space N.V.',
   0x000F63: u'Obzerv Technologies',
   0x000F64: u'D&R Electronica Weesp BV',
   0x000F65: u'icube Corp.',
   0x000F66: u'Cisco-Linksys',
   0x000F67: u'West Instruments',
   0x000F68: u'Vavic Network Technology, Inc.',
   0x000F69: u'SEW Eurodrive GmbH & Co. KG',
   0x000F6A: u'Nortel Networks',
   0x000F6B: u'GateWare Communications GmbH',
   0x000F6C: u'ADDI-DATA GmbH',
   0x000F6D: u'Midas Engineering',
   0x000F6E: u'BBox',
   0x000F6F: u'FTA Communication Technologies',
   0x000F70: u'Wintec Industries, inc.',
   0x000F71: u'Sanmei Electronics Co.,Ltd',
   0x000F72: u'Sandburst',
   0x000F73: u'Rockwell Samsung Automation',
   0x000F74: u'Qamcom Technology AB',
   0x000F75: u'First Silicon Solutions',
   0x000F76: u'Digital Keystone, Inc.',
   0x000F77: u'DENTUM CO.,LTD',
   0x000F78: u'Datacap Systems Inc',
   0x000F79: u'Bluetooth Interest Group Inc.',
   0x000F7A: u'BeiJing NuQX Technology CO.,LTD',
   0x000F7B: u'Arce Sistemas, S.A.',
   0x000F7C: u'ACTi Corporation',
   0x000F7D: u'Xirrus',
   0x000F7E: u'Ablerex Electronics Co., LTD',
   0x000F7F: u'UBSTORAGE Co.,Ltd.',
   0x000F80: u'Trinity Security Systems,Inc.',
   0x000F81: u'Secure Info Imaging',
   0x000F82: u'Mortara Instrument, Inc.',
   0x000F83: u'Brainium Technologies Inc.',
   0x000F84: u'Astute Networks, Inc.',
   0x000F85: u'ADDO-Japan Corporation',
   0x000F86: u'Research In Motion Limited',
   0x000F87: u'Maxcess International',
   0x000F88: u'AMETEK, Inc.',
   0x000F89: u'Winnertec System Co., Ltd.',
   0x000F8A: u'WideView',
   0x000F8B: u'Orion MultiSystems Inc',
   0x000F8C: u'Gigawavetech Pte Ltd',
   0x000F8D: u'FAST TV-Server AG',
   0x000F8E: u'DONGYANG TELECOM CO.,LTD.',
   0x000F8F: u'Cisco Systems',
   0x000F90: u'Cisco Systems',
   0x000F91: u'Aerotelecom Co.,Ltd.',
   0x000F92: u'Microhard Systems Inc.',
   0x000F93: u'Landis+Gyr Ltd.',
   0x000F94: u'Genexis',
   0x000F95: u'ELECOM Co.,LTD Laneed Division',
   0x000F96: u'Critical Telecom Corp.',
   0x000F97: u'Avanex Corporation',
   0x000F98: u'Avamax Co. Ltd.',
   0x000F99: u'APAC opto Electronics Inc.',
   0x000F9A: u'Synchrony, Inc.',
   0x000F9B: u'Ross Video Limited',
   0x000F9C: u'Panduit Corp',
   0x000F9D: u'Newnham Research Ltd',
   0x000F9E: u'Murrelektronik GmbH',
   0x000F9F: u'Motorola BCS',
   0x000FA0: u'CANON KOREA BUSINESS SOLUTIONS INC.',
   0x000FA1: u'Gigabit Systems Inc.',
   0x000FA2: u'Digital Path Networks',
   0x000FA3: u'Alpha Networks Inc.',
   0x000FA4: u'Sprecher Automation GmbH',
   0x000FA5: u'SMP / BWA Technology GmbH',
   0x000FA6: u'S2 Security Corporation',
   0x000FA7: u'Raptor Networks Technology',
   0x000FA8: u'Photometrics, Inc.',
   0x000FA9: u'PC Fabrik',
   0x000FAA: u'Nexus Technologies',
   0x000FAB: u'Kyushu Electronics Systems Inc.',
   0x000FAC: u'IEEE 802.11',
   0x000FAD: u'FMN communications GmbH',
   0x000FAE: u'E2O Communications',
   0x000FAF: u'Dialog Inc.',
   0x000FB0: u'Compal Electronics,INC.',
   0x000FB1: u'Cognio Inc.',
   0x000FB2: u'Broadband Pacenet (India) Pvt. Ltd.',
   0x000FB3: u'Actiontec Electronics, Inc',
   0x000FB4: u'Timespace Technology',
   0x000FB5: u'NETGEAR Inc',
   0x000FB6: u'Europlex Technologies',
   0x000FB7: u'Cavium Networks',
   0x000FB8: u'CallURL Inc.',
   0x000FB9: u'Adaptive Instruments',
   0x000FBA: u'Tevebox AB',
   0x000FBB: u'Siemens Networks GmbH & Co. KG',
   0x000FBC: u'Onkey Technologies, Inc.',
   0x000FBD: u'MRV Communications (Networks) LTD',
   0x000FBE: u'e-w/you Inc.',
   0x000FBF: u'DGT Sp. z o.o.',
   0x000FC0: u'DELCOMp',
   0x000FC1: u'WAVE Corporation',
   0x000FC2: u'Uniwell Corporation',
   0x000FC3: u'PalmPalm Technology, Inc.',
   0x000FC4: u'NST co.,LTD.',
   0x000FC5: u'KeyMed Ltd',
   0x000FC6: u'Eurocom Industries A/S',
   0x000FC7: u'Dionica R&D Ltd.',
   0x000FC8: u'Chantry Networks',
   0x000FC9: u'Allnet GmbH',
   0x000FCA: u'A-JIN TECHLINE CO, LTD',
   0x000FCB: u'3COM EUROPE LTD',
   0x000FCC: u'Netopia, Inc.',
   0x000FCD: u'Nortel Networks',
   0x000FCE: u'Kikusui Electronics Corp.',
   0x000FCF: u'Datawind Research',
   0x000FD0: u'ASTRI',
   0x000FD1: u'Applied Wireless Identifications Group, Inc.',
   0x000FD2: u'EWA Technologies, Inc.',
   0x000FD3: u'Digium',
   0x000FD4: u'Soundcraft',
   0x000FD5: u'Schwechat - RISE',
   0x000FD6: u'Sarotech Co., Ltd',
   0x000FD7: u'Harman Music Group',
   0x000FD8: u'Force, Inc.',
   0x000FD9: u'FlexDSL Telecommunications AG',
   0x000FDA: u'YAZAKI CORPORATION',
   0x000FDB: u'Westell Technologies',
   0x000FDC: u'Ueda Japan  Radio Co., Ltd.',
   0x000FDD: u'SORDIN AB',
   0x000FDE: u'Sony Ericsson Mobile Communications AB',
   0x000FDF: u'SOLOMON Technology Corp.',
   0x000FE0: u'NComputing Co.,Ltd.',
   0x000FE1: u'ID DIGITAL CORPORATION',
   0x000FE2: u'Hangzhou Huawei-3Com Tech. Co., Ltd.',
   0x000FE3: u'Damm Cellular Systems A/S',
   0x000FE4: u'Pantech Co.,Ltd',
   0x000FE5: u'MERCURY SECURITY CORPORATION',
   0x000FE6: u'MBTech Systems, Inc.',
   0x000FE7: u'Lutron Electronics Co., Inc.',
   0x000FE8: u'Lobos, Inc.',
   0x000FE9: u'GW TECHNOLOGIES CO.,LTD.',
   0x000FEA: u'Giga-Byte Technology Co.,LTD.',
   0x000FEB: u'Cylon Controls',
   0x000FEC: u'Arkus Inc.',
   0x000FED: u'Anam Electronics Co., Ltd',
   0x000FEE: u'XTec, Incorporated',
   0x000FEF: u'Thales e-Transactions GmbH',
   0x000FF0: u'Sunray Enterprise',
   0x000FF1: u'nex-G Systems Pte.Ltd',
   0x000FF2: u'Loud Technologies Inc.',
   0x000FF3: u'Jung Myoung Communications&Technology',
   0x000FF4: u'Guntermann & Drunck GmbH',
   0x000FF5: u'GN&S company',
   0x000FF6: u'Darfon Electronics Corp.',
   0x000FF7: u'Cisco Systems',
   0x000FF8: u'Cisco  Systems',
   0x000FF9: u'Valcretec, Inc.',
   0x000FFA: u'Optinel Systems, Inc.',
   0x000FFB: u'Nippon Denso Industry Co., Ltd.',
   0x000FFC: u'Merit Li-Lin Ent.',
   0x000FFD: u'Glorytek Network Inc.',
   0x000FFE: u'G-PRO COMPUTER',
   0x000FFF: u'Control4',
   0x001000: u'CABLE TELEVISION LABORATORIES, INC.',
   0x001001: u'MCK COMMUNICATIONS',
   0x001002: u'ACTIA',
   0x001003: u'IMATRON, INC.',
   0x001004: u'THE BRANTLEY COILE COMPANY,INC',
   0x001005: u'UEC COMMERCIAL',
   0x001006: u'Thales Contact Solutions Ltd.',
   0x001007: u'CISCO SYSTEMS, INC.',
   0x001008: u'VIENNA SYSTEMS CORPORATION',
   0x001009: u'HORO QUARTZ',
   0x00100A: u'WILLIAMS COMMUNICATIONS GROUP',
   0x00100B: u'CISCO SYSTEMS, INC.',
   0x00100C: u'ITO CO., LTD.',
   0x00100D: u'CISCO SYSTEMS, INC.',
   0x00100E: u'MICRO LINEAR COPORATION',
   0x00100F: u'INDUSTRIAL CPU SYSTEMS',
   0x001010: u'INITIO CORPORATION',
   0x001011: u'CISCO SYSTEMS, INC.',
   0x001012: u'PROCESSOR SYSTEMS (I) PVT LTD',
   0x001013: u'Kontron',
   0x001014: u'CISCO SYSTEMS, INC.',
   0x001015: u'OOmon Inc.',
   0x001016: u'T.SQWARE',
   0x001017: u'MICOS GmbH',
   0x001018: u'BROADCOM CORPORATION',
   0x001019: u'SIRONA DENTAL SYSTEMS GmbH & Co. KG',
   0x00101A: u'PictureTel Corp.',
   0x00101B: u'CORNET TECHNOLOGY, INC.',
   0x00101C: u'OHM TECHNOLOGIES INTL, LLC',
   0x00101D: u'WINBOND ELECTRONICS CORP.',
   0x00101E: u'MATSUSHITA ELECTRONIC INSTRUMENTS CORP.',
   0x00101F: u'CISCO SYSTEMS, INC.',
   0x001020: u'WELCH ALLYN, DATA COLLECTION',
   0x001021: u'ENCANTO NETWORKS, INC.',
   0x001022: u'SatCom Media Corporation',
   0x001023: u'FLOWWISE NETWORKS, INC.',
   0x001024: u'NAGOYA ELECTRIC WORKS CO., LTD',
   0x001025: u'GRAYHILL INC.',
   0x001026: u'ACCELERATED NETWORKS, INC.',
   0x001027: u'L-3 COMMUNICATIONS EAST',
   0x001028: u'COMPUTER TECHNICA, INC.',
   0x001029: u'CISCO SYSTEMS, INC.',
   0x00102A: u'ZF MICROSYSTEMS, INC.',
   0x00102B: u'UMAX DATA SYSTEMS, INC.',
   0x00102C: u'Lasat Networks A/S',
   0x00102D: u'HITACHI SOFTWARE ENGINEERING',
   0x00102E: u'NETWORK SYSTEMS & TECHNOLOGIES PVT. LTD.',
   0x00102F: u'CISCO SYSTEMS, INC.',
   0x001030: u'EION Inc.',
   0x001031: u'OBJECTIVE COMMUNICATIONS, INC.',
   0x001032: u'ALTA TECHNOLOGY',
   0x001033: u'ACCESSLAN COMMUNICATIONS, INC.',
   0x001034: u'GNP Computers',
   0x001035: u'ELITEGROUP COMPUTER SYSTEMS CO., LTD',
   0x001036: u'INTER-TEL INTEGRATED SYSTEMS',
   0x001037: u'CYQ\'ve Technology Co., Ltd.',
   0x001038: u'MICRO RESEARCH INSTITUTE, INC.',
   0x001039: u'Vectron Systems AG',
   0x00103A: u'DIAMOND NETWORK TECH',
   0x00103B: u'HIPPI NETWORKING FORUM',
   0x00103C: u'IC ENSEMBLE, INC.',
   0x00103D: u'PHASECOM, LTD.',
   0x00103E: u'NETSCHOOLS CORPORATION',
   0x00103F: u'TOLLGRADE COMMUNICATIONS, INC.',
   0x001040: u'INTERMEC CORPORATION',
   0x001041: u'BRISTOL BABCOCK, INC.',
   0x001042: u'AlacriTech',
   0x001043: u'A2 CORPORATION',
   0x001044: u'InnoLabs Corporation',
   0x001045: u'Nortel Networks',
   0x001046: u'ALCORN MCBRIDE INC.',
   0x001047: u'ECHO ELETRIC CO. LTD.',
   0x001048: u'HTRC AUTOMATION, INC.',
   0x001049: u'SHORELINE TELEWORKS, INC.',
   0x00104A: u'THE PARVUC CORPORATION',
   0x00104B: u'3COM CORPORATION',
   0x00104C: u'COMPUTER ACCESS TECHNOLOGY',
   0x00104D: u'SURTEC INDUSTRIES, INC.',
   0x00104E: u'CEOLOGIC',
   0x00104F: u'STORAGE TECHNOLOGY CORPORATION',
   0x001050: u'RION CO., LTD.',
   0x001051: u'CMICRO CORPORATION',
   0x001052: u'METTLER-TOLEDO (ALBSTADT) GMBH',
   0x001053: u'COMPUTER TECHNOLOGY CORP.',
   0x001054: u'CISCO SYSTEMS, INC.',
   0x001055: u'FUJITSU MICROELECTRONICS, INC.',
   0x001056: u'SODICK CO., LTD.',
   0x001057: u'Rebel.com, Inc.',
   0x001058: u'ArrowPoint Communications',
   0x001059: u'DIABLO RESEARCH CO. LLC',
   0x00105A: u'3COM CORPORATION',
   0x00105B: u'NET INSIGHT AB',
   0x00105C: u'QUANTUM DESIGNS (H.K.) LTD.',
   0x00105D: u'Draeger Medical',
   0x00105E: u'HEKIMIAN LABORATORIES, INC.',
   0x00105F: u'IN-SNEC',
   0x001060: u'BILLIONTON SYSTEMS, INC.',
   0x001061: u'HOSTLINK CORP.',
   0x001062: u'NX SERVER, ILNC.',
   0x001063: u'STARGUIDE DIGITAL NETWORKS',
   0x001064: u'DNPG, LLC',
   0x001065: u'RADYNE CORPORATION',
   0x001066: u'ADVANCED CONTROL SYSTEMS, INC.',
   0x001067: u'REDBACK NETWORKS, INC.',
   0x001068: u'COMOS TELECOM',
   0x001069: u'HELIOSS COMMUNICATIONS, INC.',
   0x00106A: u'DIGITAL MICROWAVE CORPORATION',
   0x00106B: u'SONUS NETWORKS, INC.',
   0x00106C: u'INFRATEC PLUS GmbH',
   0x00106D: u'Axxcelera Broadband Wireless',
   0x00106E: u'TADIRAN COM. LTD.',
   0x00106F: u'TRENTON TECHNOLOGY INC.',
   0x001070: u'CARADON TREND LTD.',
   0x001071: u'ADVANET INC.',
   0x001072: u'GVN TECHNOLOGIES, INC.',
   0x001073: u'TECHNOBOX, INC.',
   0x001074: u'ATEN INTERNATIONAL CO., LTD.',
   0x001075: u'Maxtor Corporation',
   0x001076: u'EUREM GmbH',
   0x001077: u'SAF DRIVE SYSTEMS, LTD.',
   0x001078: u'NUERA COMMUNICATIONS, INC.',
   0x001079: u'CISCO SYSTEMS, INC.',
   0x00107A: u'AmbiCom, Inc.',
   0x00107B: u'CISCO SYSTEMS, INC.',
   0x00107C: u'P-COM, INC.',
   0x00107D: u'AURORA COMMUNICATIONS, LTD.',
   0x00107E: u'BACHMANN ELECTRONIC GmbH',
   0x00107F: u'CRESTRON ELECTRONICS, INC.',
   0x001080: u'METAWAVE COMMUNICATIONS',
   0x001081: u'DPS, INC.',
   0x001082: u'JNA TELECOMMUNICATIONS LIMITED',
   0x001083: u'HEWLETT-PACKARD COMPANY',
   0x001084: u'K-BOT COMMUNICATIONS',
   0x001085: u'POLARIS COMMUNICATIONS, INC.',
   0x001086: u'ATTO TECHNOLOGY, INC.',
   0x001087: u'Xstreamis PLC',
   0x001088: u'AMERICAN NETWORKS INC.',
   0x001089: u'WebSonic',
   0x00108A: u'TeraLogic, Inc.',
   0x00108B: u'LASERANIMATION SOLLINGER GmbH',
   0x00108C: u'FUJITSU TELECOMMUNICATIONS EUROPE, LTD.',
   0x00108D: u'JOHNSON CONTROLS, INC.',
   0x00108E: u'HUGH SYMONS CONCEPT Technologies Ltd.',
   0x00108F: u'RAPTOR SYSTEMS',
   0x001090: u'CIMETRICS, INC.',
   0x001091: u'NO WIRES NEEDED BV',
   0x001092: u'NETCORE INC.',
   0x001093: u'CMS COMPUTERS, LTD.',
   0x001094: u'Performance Analysis Broadband, Spirent plc',
   0x001095: u'Thomson Inc.',
   0x001096: u'TRACEWELL SYSTEMS, INC.',
   0x001097: u'WinNet Metropolitan Communications Systems, Inc.',
   0x001098: u'STARNET TECHNOLOGIES, INC.',
   0x001099: u'InnoMedia, Inc.',
   0x00109A: u'NETLINE',
   0x00109B: u'Emulex Corporation',
   0x00109C: u'M-SYSTEM CO., LTD.',
   0x00109D: u'CLARINET SYSTEMS, INC.',
   0x00109E: u'AWARE, INC.',
   0x00109F: u'PAVO, INC.',
   0x0010A0: u'INNOVEX TECHNOLOGIES, INC.',
   0x0010A1: u'KENDIN SEMICONDUCTOR, INC.',
   0x0010A2: u'TNS',
   0x0010A3: u'OMNITRONIX, INC.',
   0x0010A4: u'XIRCOM',
   0x0010A5: u'OXFORD INSTRUMENTS',
   0x0010A6: u'CISCO SYSTEMS, INC.',
   0x0010A7: u'UNEX TECHNOLOGY CORPORATION',
   0x0010A8: u'RELIANCE COMPUTER CORP.',
   0x0010A9: u'ADHOC TECHNOLOGIES',
   0x0010AA: u'MEDIA4, INC.',
   0x0010AB: u'KOITO INDUSTRIES, LTD.',
   0x0010AC: u'IMCI TECHNOLOGIES',
   0x0010AD: u'SOFTRONICS USB, INC.',
   0x0010AE: u'SHINKO ELECTRIC INDUSTRIES CO.',
   0x0010AF: u'TAC SYSTEMS, INC.',
   0x0010B0: u'MERIDIAN TECHNOLOGY CORP.',
   0x0010B1: u'FOR-A CO., LTD.',
   0x0010B2: u'COACTIVE AESTHETICS',
   0x0010B3: u'NOKIA MULTIMEDIA TERMINALS',
   0x0010B4: u'ATMOSPHERE NETWORKS',
   0x0010B5: u'ACCTON TECHNOLOGY CORPORATION',
   0x0010B6: u'ENTRATA COMMUNICATIONS CORP.',
   0x0010B7: u'COYOTE TECHNOLOGIES, LLC',
   0x0010B8: u'ISHIGAKI COMPUTER SYSTEM CO.',
   0x0010B9: u'MAXTOR CORP.',
   0x0010BA: u'MARTINHO-DAVIS SYSTEMS, INC.',
   0x0010BB: u'DATA & INFORMATION TECHNOLOGY',
   0x0010BC: u'Aastra Telecom',
   0x0010BD: u'THE TELECOMMUNICATION TECHNOLOGY COMMITTEE',
   0x0010BE: u'TELEXIS CORP.',
   0x0010BF: u'InterAir Wireless',
   0x0010C0: u'ARMA, INC.',
   0x0010C1: u'OI ELECTRIC CO., LTD.',
   0x0010C2: u'WILLNET, INC.',
   0x0010C3: u'CSI-CONTROL SYSTEMS',
   0x0010C4: u'MEDIA LINKS CO., LTD.',
   0x0010C5: u'PROTOCOL TECHNOLOGIES, INC.',
   0x0010C6: u'USI',
   0x0010C7: u'DATA TRANSMISSION NETWORK',
   0x0010C8: u'COMMUNICATIONS ELECTRONICS SECURITY GROUP',
   0x0010C9: u'MITSUBISHI ELECTRONICS LOGISTIC SUPPORT CO.',
   0x0010CA: u'INTEGRAL ACCESS',
   0x0010CB: u'FACIT K.K.',
   0x0010CC: u'CLP COMPUTER LOGISTIK PLANUNG GmbH',
   0x0010CD: u'INTERFACE CONCEPT',
   0x0010CE: u'VOLAMP, LTD.',
   0x0010CF: u'FIBERLANE COMMUNICATIONS',
   0x0010D0: u'WITCOM, LTD.',
   0x0010D1: u'Top Layer Networks, Inc.',
   0x0010D2: u'NITTO TSUSHINKI CO., LTD',
   0x0010D3: u'GRIPS ELECTRONIC GMBH',
   0x0010D4: u'STORAGE COMPUTER CORPORATION',
   0x0010D5: u'IMASDE CANARIAS, S.A.',
   0x0010D6: u'ITT - A/CD',
   0x0010D7: u'ARGOSY RESEARCH INC.',
   0x0010D8: u'CALISTA',
   0x0010D9: u'IBM JAPAN, FUJISAWA MT+D',
   0x0010DA: u'MOTION ENGINEERING, INC.',
   0x0010DB: u'Juniper Networks, Inc.',
   0x0010DC: u'MICRO-STAR INTERNATIONAL CO., LTD.',
   0x0010DD: u'ENABLE SEMICONDUCTOR, INC.',
   0x0010DE: u'INTERNATIONAL DATACASTING CORPORATION',
   0x0010DF: u'RISE COMPUTER INC.',
   0x0010E0: u'COBALT MICROSERVER, INC.',
   0x0010E1: u'S.I. TECH, INC.',
   0x0010E2: u'ArrayComm, Inc.',
   0x0010E3: u'COMPAQ COMPUTER CORPORATION',
   0x0010E4: u'NSI CORPORATION',
   0x0010E5: u'SOLECTRON TEXAS',
   0x0010E6: u'APPLIED INTELLIGENT SYSTEMS, INC.',
   0x0010E7: u'BreezeCom',
   0x0010E8: u'TELOCITY, INCORPORATED',
   0x0010E9: u'RAIDTEC LTD.',
   0x0010EA: u'ADEPT TECHNOLOGY',
   0x0010EB: u'SELSIUS SYSTEMS, INC.',
   0x0010EC: u'RPCG, LLC',
   0x0010ED: u'SUNDANCE TECHNOLOGY, INC.',
   0x0010EE: u'CTI PRODUCTS, INC.',
   0x0010EF: u'DBTEL INCORPORATED',
   0x0010F1: u'I-O CORPORATION',
   0x0010F2: u'ANTEC',
   0x0010F3: u'Nexcom International Co., Ltd.',
   0x0010F4: u'VERTICAL NETWORKS, INC.',
   0x0010F5: u'AMHERST SYSTEMS, INC.',
   0x0010F6: u'CISCO SYSTEMS, INC.',
   0x0010F7: u'IRIICHI TECHNOLOGIES Inc.',
   0x0010F8: u'TEXIO CORPORATION',
   0x0010F9: u'UNIQUE SYSTEMS, INC.',
   0x0010FA: u'ZAYANTE, INC.',
   0x0010FB: u'ZIDA TECHNOLOGIES LIMITED',
   0x0010FC: u'BROADBAND NETWORKS, INC.',
   0x0010FD: u'COCOM A/S',
   0x0010FE: u'DIGITAL EQUIPMENT CORPORATION',
   0x0010FF: u'CISCO SYSTEMS, INC.',
   0x001100: u'RAM Industries, LLC',
   0x001101: u'CET Technologies Pte Ltd',
   0x001102: u'Aurora Multimedia Corp.',
   0x001103: u'kawamura electric inc.',
   0x001104: u'TELEXY',
   0x001105: u'Sunplus Technology Co., Ltd.',
   0x001106: u'Siemens NV (Belgium)',
   0x001107: u'RGB Networks Inc.',
   0x001108: u'Orbital Data Corporation',
   0x001109: u'Micro-Star International',
   0x00110A: u'Hewlett Packard',
   0x00110B: u'Franklin Technology Systems',
   0x00110C: u'Atmark Techno, Inc.',
   0x00110D: u'SANBlaze Technology, Inc.',
   0x00110E: u'Tsurusaki Sealand Transportation Co. Ltd.',
   0x00110F: u'netplat,Inc.',
   0x001110: u'Maxanna Technology Co., Ltd.',
   0x001111: u'Intel Corporation',
   0x001112: u'Honeywell CMSS',
   0x001113: u'Fraunhofer FOKUS',
   0x001114: u'EverFocus Electronics Corp.',
   0x001115: u'EPIN Technologies, Inc.',
   0x001116: u'COTEAU VERT CO., LTD.',
   0x001117: u'CESNET',
   0x001118: u'BLX IC Design Corp., Ltd.',
   0x001119: u'Solteras, Inc.',
   0x00111A: u'Motorola BCS',
   0x00111B: u'Targa Systems Div L-3 Communications Canada',
   0x00111C: u'Pleora Technologies Inc.',
   0x00111D: u'Hectrix Limited',
   0x00111E: u'EPSG (Ethernet Powerlink Standardization Group)',
   0x00111F: u'Doremi Labs, Inc.',
   0x001120: u'Cisco Systems',
   0x001121: u'Cisco Systems',
   0x001122: u'CIMSYS Inc',
   0x001123: u'Appointech, Inc.',
   0x001124: u'Apple Computer',
   0x001125: u'IBM Corporation',
   0x001126: u'Venstar Inc.',
   0x001127: u'TASI, Inc',
   0x001128: u'Streamit',
   0x001129: u'Paradise Datacom Ltd.',
   0x00112A: u'Niko NV',
   0x00112B: u'NetModule',
   0x00112C: u'IZT GmbH',
   0x00112D: u'Guys Without Ties',
   0x00112E: u'CEICOM',
   0x00112F: u'ASUSTek Computer Inc.',
   0x001130: u'Allied Telesis (Hong Kong) Ltd.',
   0x001131: u'UNATECH. CO.,LTD',
   0x001132: u'Synology Incorporated',
   0x001133: u'Siemens Austria SIMEA',
   0x001134: u'MediaCell, Inc.',
   0x001135: u'Grandeye Ltd',
   0x001136: u'Goodrich Sensor Systems',
   0x001137: u'AICHI ELECTRIC CO., LTD.',
   0x001138: u'TAISHIN CO., LTD.',
   0x001139: u'STOEBER ANTRIEBSTECHNIK GmbH + Co. KG.',
   0x00113A: u'SHINBORAM',
   0x00113B: u'Micronet Communications Inc.',
   0x00113C: u'Micronas GmbH',
   0x00113D: u'KN SOLTEC CO.,LTD.',
   0x00113E: u'JL Corporation',
   0x00113F: u'Alcatel DI',
   0x001140: u'Nanometrics Inc.',
   0x001141: u'GoodMan Corporation',
   0x001142: u'e-SMARTCOM  INC.',
   0x001143: u'DELL INC.',
   0x001144: u'Assurance Technology Corp',
   0x001145: u'ValuePoint Networks',
   0x001146: u'Telecard-Pribor Ltd',
   0x001147: u'Secom-Industry co.LTD.',
   0x001148: u'Prolon Control Systems',
   0x001149: u'Proliphix LLC',
   0x00114A: u'KAYABA INDUSTRY Co,.Ltd.',
   0x00114B: u'Francotyp-Postalia AG & Co. KG',
   0x00114C: u'caffeina applied research ltd.',
   0x00114D: u'Atsumi Electric Co.,LTD.',
   0x00114E: u'690885 Ontario Inc.',
   0x00114F: u'US Digital Television, Inc',
   0x001150: u'Belkin Corporation',
   0x001151: u'Mykotronx',
   0x001152: u'Eidsvoll Electronics AS',
   0x001153: u'Trident Tek, Inc.',
   0x001154: u'Webpro Technologies Inc.',
   0x001155: u'Sevis Systems',
   0x001156: u'Pharos Systems NZ',
   0x001157: u'OF Networks Co., Ltd.',
   0x001158: u'Nortel Networks',
   0x001159: u'MATISSE NETWORKS INC',
   0x00115A: u'Ivoclar Vivadent AG',
   0x00115B: u'Elitegroup Computer System Co. (ECS)',
   0x00115C: u'Cisco',
   0x00115D: u'Cisco',
   0x00115E: u'ProMinent Dosiertechnik GmbH',
   0x00115F: u'Intellix Co., Ltd.',
   0x001160: u'ARTDIO Company Co., LTD',
   0x001161: u'NetStreams, LLC',
   0x001162: u'STAR MICRONICS CO.,LTD.',
   0x001163: u'SYSTEM SPA DEPT. ELECTRONICS',
   0x001164: u'ACARD Technology Corp.',
   0x001165: u'Znyx Networks',
   0x001166: u'Taelim Electronics Co., Ltd.',
   0x001167: u'Integrated System Solution Corp.',
   0x001168: u'HomeLogic LLC',
   0x001169: u'EMS Satcom',
   0x00116A: u'Domo Ltd',
   0x00116B: u'Digital Data Communications Asia Co.,Ltd',
   0x00116C: u'Nanwang Multimedia Inc.,Ltd',
   0x00116D: u'American Time and Signal',
   0x00116E: u'PePLink Ltd.',
   0x00116F: u'Netforyou Co., LTD.',
   0x001170: u'GSC SRL',
   0x001171: u'DEXTER Communications, Inc.',
   0x001172: u'COTRON CORPORATION',
   0x001173: u'Adtron Corporation',
   0x001174: u'Wibhu Technologies, Inc.',
   0x001175: u'PathScale, Inc.',
   0x001176: u'Intellambda Systems, Inc.',
   0x001177: u'COAXIAL NETWORKS, INC.',
   0x001178: u'Chiron Technology Ltd',
   0x001179: u'Singular Technology Co. Ltd.',
   0x00117A: u'Singim International Corp.',
   0x00117B: u'Büchi Labortechnik AG',
   0x00117C: u'e-zy.net',
   0x00117D: u'ZMD America, Inc.',
   0x00117E: u'Progeny Inc.',
   0x00117F: u'Neotune Information Technology Corporation,.LTD',
   0x001180: u'Motorola BCS',
   0x001181: u'InterEnergy Co.Ltd,',
   0x001182: u'IMI Norgren Ltd',
   0x001183: u'PSC Scanning, Inc',
   0x001184: u'Humo Laboratory,Ltd.',
   0x001185: u'Hewlett Packard',
   0x001186: u'Prime Systems, Inc.',
   0x001187: u'Category Solutions, Inc',
   0x001188: u'Enterasys',
   0x001189: u'Aerotech Inc',
   0x00118A: u'Viewtran Technology Limited',
   0x00118B: u'NetDevices Inc.',
   0x00118C: u'Missouri Department of Transportation',
   0x00118D: u'Hanchang System Corp.',
   0x00118E: u'Halytech Mace',
   0x00118F: u'EUTECH INSTRUMENTS PTE. LTD.',
   0x001190: u'Digital Design Corporation',
   0x001191: u'CTS-Clima Temperatur Systeme GmbH',
   0x001192: u'Cisco Systems',
   0x001193: u'Cisco Systems',
   0x001194: u'Chi Mei Communication Systems, Inc.',
   0x001195: u'D-Link Corporation',
   0x001196: u'Actuality Systems, Inc.',
   0x001197: u'Monitoring Technologies Limited',
   0x001198: u'Prism Media Products Limited',
   0x001199: u'2wcom GmbH',
   0x00119A: u'Alkeria srl',
   0x00119B: u'Telesynergy Research Inc.',
   0x00119C: u'EP&T Energy',
   0x00119D: u'Diginfo Technology Corporation',
   0x00119E: u'Solectron Brazil',
   0x00119F: u'Nokia Danmark A/S',
   0x0011A0: u'Vtech Engineering Canada Ltd',
   0x0011A1: u'VISION NETWARE CO.,LTD',
   0x0011A2: u'Manufacturing Technology Inc',
   0x0011A3: u'LanReady Technologies Inc.',
   0x0011A4: u'JStream Technologies Inc.',
   0x0011A5: u'Fortuna Electronic Corp.',
   0x0011A6: u'Sypixx Networks',
   0x0011A7: u'Infilco Degremont Inc.',
   0x0011A8: u'Quest Technologies',
   0x0011A9: u'MOIMSTONE Co., LTD',
   0x0011AA: u'Uniclass Technology, Co., LTD',
   0x0011AB: u'TRUSTABLE TECHNOLOGY CO.,LTD.',
   0x0011AC: u'Simtec Electronics',
   0x0011AD: u'Shanghai Ruijie Technology',
   0x0011AE: u'Motorola BCS',
   0x0011AF: u'Medialink-i,Inc',
   0x0011B0: u'Fortelink Inc.',
   0x0011B1: u'BlueExpert Technology Corp.',
   0x0011B2: u'2001 Technology Inc.',
   0x0011B3: u'YOSHIMIYA CO.,LTD.',
   0x0011B4: u'Westermo Teleindustri AB',
   0x0011B5: u'Shenzhen Powercom Co.,Ltd',
   0x0011B6: u'Open Systems International',
   0x0011B7: u'Melexis Nederland B.V.',
   0x0011B8: u'Liebherr - Elektronik GmbH',
   0x0011B9: u'Inner Range Pty. Ltd.',
   0x0011BA: u'Elexol Pty Ltd',
   0x0011BB: u'Cisco Systems',
   0x0011BC: u'Cisco Systems',
   0x0011BD: u'Bombardier Transportation',
   0x0011BE: u'AGP Telecom Co. Ltd',
   0x0011BF: u'AESYS S.p.A.',
   0x0011C0: u'Aday Technology Inc',
   0x0011C1: u'4P MOBILE DATA PROCESSING',
   0x0011C2: u'United Fiber Optic Communication',
   0x0011C3: u'Transceiving System Technology Corporation',
   0x0011C4: u'Terminales de Telecomunicacion Terrestre, S.L.',
   0x0011C5: u'TEN Technology',
   0x0011C6: u'Seagate Technology LLC',
   0x0011C7: u'RAYMARINE Group Ltd.',
   0x0011C8: u'Powercom Co., Ltd.',
   0x0011C9: u'MTT Corporation',
   0x0011CA: u'Long Range Systems, Inc.',
   0x0011CB: u'Jacobsons RKH AB',
   0x0011CC: u'Guangzhou Jinpeng Group Co.,Ltd.',
   0x0011CD: u'Axsun Technologies',
   0x0011CE: u'Ubisense Limited',
   0x0011CF: u'Thrane & Thrane A/S',
   0x0011D0: u'Tandberg Data ASA',
   0x0011D1: u'Soft Imaging System GmbH',
   0x0011D2: u'Perception Digital Ltd',
   0x0011D3: u'NextGenTel Holding ASA',
   0x0011D4: u'NetEnrich, Inc',
   0x0011D5: u'Hangzhou Sunyard System Engineering Co.,Ltd.',
   0x0011D6: u'HandEra, Inc.',
   0x0011D7: u'eWerks Inc',
   0x0011D8: u'ASUSTek Computer Inc.',
   0x0011D9: u'TiVo',
   0x0011DA: u'Vivaas Technology Inc.',
   0x0011DB: u'Land-Cellular Corporation',
   0x0011DC: u'Glunz & Jensen',
   0x0011DD: u'FROMUS TEC. Co., Ltd.',
   0x0011DE: u'EURILOGIC',
   0x0011DF: u'Arecont Systems',
   0x0011E0: u'U-MEDIA Communications, Inc.',
   0x0011E1: u'BEKO Electronics Co.',
   0x0011E2: u'Hua Jung Components Co., Ltd.',
   0x0011E3: u'Thomson, Inc.',
   0x0011E4: u'Danelec Electronics A/S',
   0x0011E5: u'KCodes Corporation',
   0x0011E6: u'Scientific Atlanta',
   0x0011E7: u'WORLDSAT - Texas de France',
   0x0011E8: u'Tixi.Com',
   0x0011E9: u'STARNEX CO., LTD.',
   0x0011EA: u'IWICS Inc.',
   0x0011EB: u'Innovative Integration',
   0x0011EC: u'AVIX INC.',
   0x0011ED: u'802 Global',
   0x0011EE: u'Estari, Inc.',
   0x0011EF: u'Conitec Datensysteme GmbH',
   0x0011F0: u'Wideful Limited',
   0x0011F1: u'QinetiQ Ltd',
   0x0011F2: u'Institute of Network Technologies',
   0x0011F3: u'Gavitec AG- mobile digit',
   0x0011F4: u'woori-net',
   0x0011F5: u'ASKEY COMPUTER CORP.',
   0x0011F6: u'Asia Pacific Microsystems , Inc.',
   0x0011F7: u'Shenzhen Forward Industry Co., Ltd',
   0x0011F8: u'AIRAYA Corp',
   0x0011F9: u'Nortel Networks',
   0x0011FA: u'Rane Corporation',
   0x0011FB: u'Heidelberg Engineering GmbH',
   0x0011FC: u'HARTING Electric Gmbh & Co.KG',
   0x0011FD: u'KORG INC.',
   0x0011FE: u'Keiyo System Research, Inc.',
   0x0011FF: u'Digitro Tecnologia Ltda',
   0x001200: u'Cisco',
   0x001201: u'Cisco',
   0x001202: u'Audio International Inc.',
   0x001203: u'Activ Networks',
   0x001204: u'u10 Networks, Inc.',
   0x001205: u'Terrasat Communications, Inc.',
   0x001206: u'iQuest (NZ) Ltd',
   0x001207: u'Head Strong International Limited',
   0x001208: u'Gantner Electronic GmbH',
   0x001209: u'Fastrax Ltd',
   0x00120A: u'Emerson Electric GmbH & Co. OHG',
   0x00120B: u'Chinasys Technologies Limited',
   0x00120C: u'CE-Infosys Pte Ltd',
   0x00120D: u'Advanced Telecommunication Technologies, Inc.',
   0x00120E: u'AboCom',
   0x00120F: u'IEEE 802.3',
   0x001210: u'WideRay Corp',
   0x001211: u'Protechna Herbst GmbH & Co. KG',
   0x001212: u'PLUS Vision Corporation',
   0x001213: u'Metrohm AG',
   0x001214: u'Koenig & Bauer AG',
   0x001215: u'iStor Networks, Inc.',
   0x001216: u'ICP Internet Communication Payment AG',
   0x001217: u'Cisco-Linksys, LLC',
   0x001218: u'ARUZE Corporation',
   0x001219: u'Ahead Communication Systems Inc',
   0x00121A: u'Techno Soft Systemnics Inc.',
   0x00121B: u'Sound Devices, LLC',
   0x00121C: u'PARROT S.A.',
   0x00121D: u'Netfabric Corporation',
   0x00121E: u'Juniper Networks, Inc.',
   0x00121F: u'Harding Intruments',
   0x001220: u'Cadco Systems',
   0x001221: u'B.Braun Melsungen AG',
   0x001222: u'Skardin (UK) Ltd',
   0x001223: u'Pixim',
   0x001224: u'NexQL Corporation',
   0x001225: u'Motorola BCS',
   0x001226: u'Japan Direx Corporation',
   0x001227: u'Franklin Electric Co., Inc.',
   0x001228: u'Data Ltd.',
   0x001229: u'BroadEasy Technologies Co.,Ltd',
   0x00122A: u'VTech Telecommunications Ltd.',
   0x00122B: u'Virbiage Pty Ltd',
   0x00122C: u'Soenen Controls N.V.',
   0x00122D: u'SiNett Corporation',
   0x00122E: u'Signal Technology - AISD',
   0x00122F: u'Sanei Electric Inc.',
   0x001230: u'Picaso Infocommunication CO., LTD.',
   0x001231: u'Motion Control Systems, Inc.',
   0x001232: u'LeWiz Communications Inc.',
   0x001233: u'JRC TOKKI Co.,Ltd.',
   0x001234: u'Camille Bauer',
   0x001235: u'Andrew Corporation',
   0x001236: u'ConSentry Networks',
   0x001237: u'Texas Instruments',
   0x001238: u'SetaBox Technology Co., Ltd.',
   0x001239: u'S Net Systems Inc.',
   0x00123A: u'Posystech Inc., Co.',
   0x00123B: u'KeRo Systems ApS',
   0x00123C: u'IP3 Networks, Inc.',
   0x00123D: u'GES',
   0x00123E: u'ERUNE technology Co., Ltd.',
   0x00123F: u'Dell Inc',
   0x001240: u'AMOI ELECTRONICS CO.,LTD',
   0x001241: u'a2i marketing center',
   0x001242: u'Millennial Net',
   0x001243: u'Cisco',
   0x001244: u'Cisco',
   0x001245: u'Zellweger Analytics, Inc.',
   0x001246: u'T.O.M TECHNOLOGY INC..',
   0x001247: u'Samsung Electronics Co., Ltd.',
   0x001248: u'Kashya Inc.',
   0x001249: u'Delta Elettronica S.p.A.',
   0x00124A: u'Dedicated Devices, Inc.',
   0x00124B: u'Chipcon AS',
   0x00124C: u'BBWM Corporation',
   0x00124D: u'Inducon BV',
   0x00124E: u'XAC AUTOMATION CORP.',
   0x00124F: u'Tyco Thermal Controls LLC.',
   0x001250: u'Tokyo Aircaft Instrument Co., Ltd.',
   0x001251: u'SILINK',
   0x001252: u'Citronix, LLC',
   0x001253: u'AudioDev AB',
   0x001254: u'Spectra Technologies Holdings Company Ltd',
   0x001255: u'NetEffect Incorporated',
   0x001256: u'LG INFORMATION & COMM.',
   0x001257: u'LeapComm Communication Technologies Inc.',
   0x001258: u'Activis Polska',
   0x001259: u'THERMO ELECTRON KARLSRUHE',
   0x00125A: u'Microsoft Corporation',
   0x00125B: u'KAIMEI ELECTRONI',
   0x00125C: u'Green Hills Software, Inc.',
   0x00125D: u'CyberNet Inc.',
   0x00125E: u'CAEN',
   0x00125F: u'AWIND Inc.',
   0x001260: u'Stanton Magnetics,inc.',
   0x001261: u'Adaptix, Inc',
   0x001262: u'Nokia Danmark A/S',
   0x001263: u'Data Voice Technologies GmbH',
   0x001264: u'daum electronic gmbh',
   0x001265: u'Enerdyne Technologies, Inc.',
   0x001266: u'PRIVATE',
   0x001267: u'Matsushita Electronic Components Co., Ltd.',
   0x001268: u'IPS d.o.o.',
   0x001269: u'Value Electronics',
   0x00126A: u'OPTOELECTRONICS Co., Ltd.',
   0x00126B: u'Ascalade Communications Limited',
   0x00126C: u'Visonic Ltd.',
   0x00126D: u'University of California, Berkeley',
   0x00126E: u'Seidel Elektronik GmbH Nfg.KG',
   0x00126F: u'Rayson Technology Co., Ltd.',
   0x001270: u'NGES Denro Systems',
   0x001271: u'Measurement Computing Corp',
   0x001272: u'Redux Communications Ltd.',
   0x001273: u'Stoke Inc',
   0x001274: u'NIT lab',
   0x001275: u'Moteiv Corporation',
   0x001276: u'Microsol Holdings Ltd.',
   0x001277: u'Korenix Technologies Co., Ltd.',
   0x001278: u'International Bar Code',
   0x001279: u'Hewlett Packard',
   0x00127A: u'Sanyu Industry Co.,Ltd.',
   0x00127B: u'VIA Networking Technologies, Inc.',
   0x00127C: u'SWEGON AB',
   0x00127D: u'MobileAria',
   0x00127E: u'Digital Lifestyles Group, Inc.',
   0x00127F: u'Cisco',
   0x001280: u'Cisco',
   0x001281: u'CIEFFE srl',
   0x001282: u'Qovia',
   0x001283: u'Nortel Networks',
   0x001284: u'Lab33 Srl',
   0x001285: u'Gizmondo Europe Ltd',
   0x001286: u'ENDEVCO CORP',
   0x001287: u'Digital Everywhere Unterhaltungselektronik GmbH',
   0x001288: u'2Wire, Inc',
   0x001289: u'Advance Sterilization Products',
   0x00128A: u'Motorola PCS',
   0x00128B: u'Sensory Networks Inc',
   0x00128C: u'Woodward Governor',
   0x00128D: u'STB Datenservice GmbH',
   0x00128E: u'Q-Free ASA',
   0x00128F: u'Montilio',
   0x001290: u'KYOWA Electric & Machinery Corp.',
   0x001291: u'KWS Computersysteme GmbH',
   0x001292: u'Griffin Technology',
   0x001293: u'GE Energy',
   0x001294: u'Eudyna Devices Inc.',
   0x001295: u'Aiware Inc.',
   0x001296: u'Addlogix',
   0x001297: u'O2Micro, Inc.',
   0x001298: u'MICO ELECTRIC(SHENZHEN) LIMITED',
   0x001299: u'Ktech Telecommunications Inc',
   0x00129A: u'IRT Electronics Pty Ltd',
   0x00129B: u'E2S Electronic Engineering Solutions, S.L.',
   0x00129C: u'Yulinet',
   0x00129D: u'FIRST INTERNATIONAL COMPUTER DO BRASIL LTDA',
   0x00129E: u'Surf Communications Inc.',
   0x00129F: u'RAE Systems, Inc.',
   0x0012A0: u'NeoMeridian Sdn Bhd',
   0x0012A1: u'BluePacket Communications Co., Ltd.',
   0x0012A2: u'VITA',
   0x0012A3: u'Trust International B.V.',
   0x0012A4: u'ThingMagic, LLC',
   0x0012A5: u'Stargen, Inc.',
   0x0012A6: u'Lake Technology Ltd',
   0x0012A7: u'ISR TECHNOLOGIES Inc',
   0x0012A8: u'intec GmbH',
   0x0012A9: u'3COM EUROPE LTD',
   0x0012AA: u'IEE, Inc.',
   0x0012AB: u'WiLife, Inc.',
   0x0012AC: u'ONTIMETEK INC.',
   0x0012AD: u'IDS GmbH',
   0x0012AE: u'HLS HARD-LINE Solutions Inc.',
   0x0012AF: u'ELPRO Technologies',
   0x0012B0: u'Efore Oyj   (Plc)',
   0x0012B1: u'Dai Nippon Printing Co., Ltd',
   0x0012B2: u'AVOLITES LTD.',
   0x0012B3: u'Advance Wireless Technology Corp.',
   0x0012B4: u'Work GmbH',
   0x0012B5: u'Vialta, Inc.',
   0x0012B6: u'Santa Barbara Infrared, Inc.',
   0x0012B7: u'PTW Freiburg',
   0x0012B8: u'G2 Microsystems',
   0x0012B9: u'Fusion Digital Technology',
   0x0012BA: u'FSI Systems, Inc.',
   0x0012BB: u'Telecommunications Industry Association TR-41 Committee',
   0x0012BC: u'Echolab LLC',
   0x0012BD: u'Avantec Manufacturing Limited',
   0x0012BE: u'Astek Corporation',
   0x0012BF: u'Arcadyan Technology Corporation',
   0x0012C0: u'HotLava Systems, Inc.',
   0x0012C1: u'Check Point Software Technologies',
   0x0012C2: u'Apex Electronics Factory',
   0x0012C3: u'WIT S.A.',
   0x0012C4: u'Viseon, Inc.',
   0x0012C5: u'V-Show Technology Co.Ltd',
   0x0012C6: u'TGC America, Inc',
   0x0012C7: u'SECURAY Technologies Ltd.Co.',
   0x0012C8: u'Perfect tech',
   0x0012C9: u'Motorola BCS',
   0x0012CA: u'Hansen Telecom',
   0x0012CB: u'CSS Inc.',
   0x0012CC: u'Bitatek CO., LTD',
   0x0012CD: u'ASEM SpA',
   0x0012CE: u'Advanced Cybernetics Group',
   0x0012CF: u'Accton Technology Corporation',
   0x0012D0: u'Gossen-Metrawatt-GmbH',
   0x0012D1: u'Texas Instruments Inc',
   0x0012D2: u'Texas Instruments',
   0x0012D3: u'Zetta Systems, Inc.',
   0x0012D4: u'Princeton Technology, Ltd',
   0x0012D5: u'Motion Reality Inc.',
   0x0012D6: u'Jiangsu Yitong High-Tech Co.,Ltd',
   0x0012D7: u'Invento Networks, Inc.',
   0x0012D8: u'International Games System Co., Ltd.',
   0x0012D9: u'Cisco Systems',
   0x0012DA: u'Cisco Systems',
   0x0012DB: u'ZIEHL industrie-elektronik GmbH + Co KG',
   0x0012DC: u'SunCorp Industrial Limited',
   0x0012DD: u'Shengqu Information Technology (Shanghai) Co., Ltd.',
   0x0012DE: u'Radio Components Sweden AB',
   0x0012DF: u'Novomatic AG',
   0x0012E0: u'Codan Limited',
   0x0012E1: u'Alliant Networks, Inc',
   0x0012E2: u'ALAXALA Networks Corporation',
   0x0012E3: u'Agat-RT, Ltd.',
   0x0012E4: u'ZIEHL industrie-electronik GmbH + Co KG',
   0x0012E5: u'Time America, Inc.',
   0x0012E6: u'SPECTEC COMPUTER CO., LTD.',
   0x0012E7: u'Projectek Networking Electronics Corp.',
   0x0012E8: u'Fraunhofer IMS',
   0x0012E9: u'Abbey Systems Ltd',
   0x0012EA: u'Trane',
   0x0012EB: u'R2DI, LLC',
   0x0012EC: u'Movacolor b.v.',
   0x0012ED: u'AVG Advanced Technologies',
   0x0012EE: u'Sony Ericsson Mobile Communications AB',
   0x0012EF: u'OneAccess SA',
   0x0012F0: u'Intel Corporate',
   0x0012F1: u'IFOTEC',
   0x0012F2: u'Foundry Networks',
   0x0012F3: u'connectBlue AB',
   0x0012F4: u'Belco International Co.,Ltd.',
   0x0012F5: u'Prolificx Ltd',
   0x0012F6: u'MDK CO.,LTD.',
   0x0012F7: u'Xiamen Xinglian Electronics Co., Ltd.',
   0x0012F8: u'WNI Resources, LLC',
   0x0012F9: u'URYU SEISAKU, LTD.',
   0x0012FA: u'THX LTD',
   0x0012FB: u'Samsung Electronics',
   0x0012FC: u'PLANET System Co.,LTD',
   0x0012FD: u'OPTIMUS IC S.A.',
   0x0012FE: u'Lenovo Mobile Communication Technology Ltd.',
   0x0012FF: u'Lely Industries N.V.',
   0x001300: u'IT-FACTORY, INC.',
   0x001301: u'IronGate S.L.',
   0x001302: u'Intel Corporate',
   0x001303: u'GateConnect Technologies GmbH',
   0x001304: u'Flaircomm Technologies Co. LTD',
   0x001305: u'Epicom, Inc.',
   0x001306: u'Always On Wireless',
   0x001307: u'Paravirtual Corporation',
   0x001308: u'Nuvera Fuel Cells',
   0x001309: u'Ocean Broadband Networks',
   0x00130A: u'Nortel',
   0x00130B: u'Mextal B.V.',
   0x00130C: u'HF System Corporation',
   0x00130D: u'GALILEO AVIONICA',
   0x00130E: u'Focusrite Audio Engineering Limited',
   0x00130F: u'EGEMEN Bilgisayar Muh San ve Tic LTD STI',
   0x001310: u'Cisco-Linksys, LLC',
   0x001311: u'ARRIS International',
   0x001312: u'Amedia Networks Inc.',
   0x001313: u'GuangZhou Post & Telecom Equipment ltd',
   0x001314: u'Asiamajor Inc.',
   0x001315: u'SONY Computer Entertainment inc,',
   0x001316: u'L-S-B GmbH',
   0x001317: u'GN Netcom as',
   0x001318: u'DGSTATION Co., Ltd.',
   0x001319: u'Cisco Systems',
   0x00131A: u'Cisco Systems',
   0x00131B: u'BeCell Innovations Corp.',
   0x00131C: u'LiteTouch, Inc.',
   0x00131D: u'Scanvaegt International A/S',
   0x00131E: u'Peiker acustic GmbH & Co. KG',
   0x00131F: u'NxtPhase T&D, Corp.',
   0x001320: u'Intel Corporate',
   0x001321: u'Hewlett Packard',
   0x001322: u'DAQ Electronics, Inc.',
   0x001323: u'Cap Co., Ltd.',
   0x001324: u'Schneider Electric Ultra Terminal',
   0x001325: u'ImmenStar Inc.',
   0x001326: u'ECM Systems Ltd',
   0x001327: u'Data Acquisitions limited',
   0x001328: u'Westech Korea Inc.,',
   0x001329: u'VSST Co., LTD',
   0x00132A: u'STROM telecom, s. r. o.',
   0x00132B: u'Phoenix Digital',
   0x00132C: u'MAZ Brandenburg GmbH',
   0x00132D: u'iWise Communications Pty Ltd',
   0x00132E: u'ITian Coporation',
   0x00132F: u'Interactek',
   0x001330: u'EURO PROTECTION SURVEILLANCE',
   0x001331: u'CellPoint Connect',
   0x001332: u'Beijing Topsec Network Security Technology Co., Ltd.',
   0x001333: u'Baud Technology Inc.',
   0x001334: u'Arkados, Inc.',
   0x001335: u'VS Industry Berhad',
   0x001336: u'Tianjin 712 Communication Broadcasting co., ltd.',
   0x001337: u'Orient Power Home Network Ltd.',
   0x001338: u'FRESENIUS-VIAL',
   0x001339: u'EL-ME AG',
   0x00133A: u'VadaTech Inc.',
   0x00133B: u'Speed Dragon Multimedia Limited',
   0x00133C: u'QUINTRON SYSTEMS INC.',
   0x00133D: u'Micro Memory LLC',
   0x00133E: u'MetaSwitch',
   0x00133F: u'Eppendorf Instrumente GmbH',
   0x001340: u'AD.EL s.r.l.',
   0x001341: u'Shandong New Beiyang Information Technology Co.,Ltd',
   0x001342: u'Vision Research, Inc.',
   0x001343: u'Matsushita Electronic Components (Europe) GmbH',
   0x001344: u'Fargo Electronics Inc.',
   0x001345: u'Eaton Corporation',
   0x001346: u'D-Link Corporation',
   0x001347: u'BlueTree Wireless Data Inc.',
   0x001348: u'Artila Electronics Co., Ltd.',
   0x001349: u'ZyXEL Communications Corporation',
   0x00134A: u'Engim, Inc.',
   0x00134B: u'ToGoldenNet Technology Inc.',
   0x00134C: u'YDT Technology International',
   0x00134D: u'IPC systems',
   0x00134E: u'Valox Systems, Inc.',
   0x00134F: u'Tranzeo Wireless Technologies Inc.',
   0x001350: u'Silver Spring Networks, Inc',
   0x001351: u'Niles Audio Corporation',
   0x001352: u'Naztec, Inc.',
   0x001353: u'HYDAC Filtertechnik GMBH',
   0x001354: u'Zcomax Technologies, Inc.',
   0x001355: u'TOMEN Cyber-business Solutions, Inc.',
   0x001356: u'target systemelectronic gmbh',
   0x001357: u'Soyal Technology Co., Ltd.',
   0x001358: u'Realm Systems, Inc.',
   0x001359: u'ProTelevision Technologies A/S',
   0x00135A: u'Project T&E Limited',
   0x00135B: u'PanelLink Cinema, LLC',
   0x00135C: u'OnSite Systems, Inc.',
   0x00135D: u'NTTPC Communications, Inc.',
   0x00135E: u'EAB/RWI/K',
   0x00135F: u'Cisco Systems',
   0x001360: u'Cisco Systems',
   0x001361: u'Biospace Co., Ltd.',
   0x001362: u'ShinHeung Precision Co., Ltd.',
   0x001363: u'Verascape, Inc.',
   0x001364: u'Paradigm Technology Inc..',
   0x001365: u'Nortel',
   0x001366: u'Neturity Technologies Inc.',
   0x001367: u'Narayon. Co., Ltd.',
   0x001368: u'Maersk Data Defence',
   0x001369: u'Honda Electron Co., LED.',
   0x00136A: u'Hach Ultra Analytics',
   0x00136B: u'E-TEC',
   0x00136C: u'PRIVATE',
   0x00136D: u'Tentaculus AB',
   0x00136E: u'Techmetro Corp.',
   0x00136F: u'PacketMotion, Inc.',
   0x001370: u'Nokia Danmark A/S',
   0x001371: u'Motorola CHS',
   0x001372: u'Dell Inc.',
   0x001373: u'BLwave Electronics Co., Ltd',
   0x001374: u'Attansic Technology Corp.',
   0x001375: u'American Security Products Co.',
   0x001376: u'Tabor Electronics Ltd.',
   0x001377: u'Samsung Electronics CO., LTD',
   0x001378: u'QSAN Technology, Inc.',
   0x001379: u'PONDER INFORMATION INDUSTRIES LTD.',
   0x00137A: u'Netvox Technology Co., Ltd.',
   0x00137B: u'Movon Corporation',
   0x00137C: u'Kaicom co., Ltd.',
   0x00137D: u'Dynalab, Inc.',
   0x00137E: u'CorEdge Networks, Inc.',
   0x00137F: u'Cisco Systems',
   0x001380: u'Cisco Systems',
   0x001381: u'CHIPS & Systems, Inc.',
   0x001382: u'Cetacea Networks Corporation',
   0x001383: u'Application Technologies and Engineering Research Laboratory',
   0x001384: u'Advanced Motion Controls',
   0x001385: u'Add-On Technology Co., LTD.',
   0x001386: u'ABB Inc./Totalflow',
   0x001387: u'27M Technologies AB',
   0x001388: u'WiMedia Alliance',
   0x001389: u'Redes de Telefonía Móvil S.A.',
   0x00138A: u'QINGDAO GOERTEK ELECTRONICS CO.,LTD.',
   0x00138B: u'Phantom Technologies LLC',
   0x00138C: u'Kumyoung.Co.Ltd',
   0x00138D: u'Kinghold',
   0x00138E: u'FOAB Elektronik AB',
   0x00138F: u'Asiarock Incorporation',
   0x001390: u'Termtek Computer Co., Ltd',
   0x001391: u'OUEN CO.,LTD.',
   0x001392: u'Ruckus Wireless',
   0x001393: u'Panta Systems, Inc.',
   0x001394: u'Infohand Co.,Ltd',
   0x001395: u'congatec AG',
   0x001396: u'Acbel Polytech Inc.',
   0x001397: u'Xsigo Systems, Inc.',
   0x001398: u'TrafficSim Co.,Ltd',
   0x001399: u'STAC Corporation.',
   0x00139A: u'K-ubique ID Corp.',
   0x00139B: u'ioIMAGE Ltd.',
   0x00139C: u'Exavera Technologies, Inc.',
   0x00139D: u'Design of Systems on Silicon S.A.',
   0x00139E: u'Ciara Technologies Inc.',
   0x00139F: u'Electronics Design Services, Co., Ltd.',
   0x0013A0: u'ALGOSYSTEM Co., Ltd.',
   0x0013A1: u'Crow Electronic Engeneering',
   0x0013A2: u'MaxStream, Inc',
   0x0013A3: u'Siemens Com CPE Devices',
   0x0013A4: u'KeyEye Communications',
   0x0013A5: u'General Solutions, LTD.',
   0x0013A6: u'Extricom Ltd',
   0x0013A7: u'BATTELLE MEMORIAL INSTITUTE',
   0x0013A8: u'Tanisys Technology',
   0x0013A9: u'Sony Corporation',
   0x0013AA: u'ALS  & TEC Ltd.',
   0x0013AB: u'Telemotive AG',
   0x0013AC: u'Sunmyung Electronics Co., LTD',
   0x0013AD: u'Sendo Ltd',
   0x0013AE: u'Radiance Technologies',
   0x0013AF: u'NUMA Technology,Inc.',
   0x0013B0: u'Jablotron',
   0x0013B1: u'Intelligent Control Systems (Asia) Pte Ltd',
   0x0013B2: u'Carallon Limited',
   0x0013B3: u'Beijing Ecom Communications Technology Co., Ltd.',
   0x0013B4: u'Appear TV',
   0x0013B5: u'Wavesat',
   0x0013B6: u'Sling Media, Inc.',
   0x0013B7: u'Scantech ID',
   0x0013B8: u'RyCo Electronic Systems Limited',
   0x0013B9: u'BM SPA',
   0x0013BA: u'ReadyLinks Inc',
   0x0013BB: u'PRIVATE',
   0x0013BC: u'Artimi Ltd',
   0x0013BD: u'HYMATOM SA',
   0x0013BE: u'Virtual Conexions',
   0x0013BF: u'Media System Planning Corp.',
   0x0013C0: u'Trix Tecnologia Ltda.',
   0x0013C1: u'Asoka USA Corporation',
   0x0013C2: u'WACOM Co.,Ltd',
   0x0013C3: u'Cisco Systems',
   0x0013C4: u'Cisco Systems',
   0x0013C5: u'LIGHTRON FIBER-OPTIC DEVICES INC.',
   0x0013C6: u'OpenGear, Inc',
   0x0013C7: u'IONOS Co.,Ltd.',
   0x0013C8: u'PIRELLI BROADBAND SOLUTIONS S.P.A.',
   0x0013C9: u'Beyond Achieve Enterprises Ltd.',
   0x0013CA: u'X-Digital Systems, Inc.',
   0x0013CB: u'Zenitel Norway AS',
   0x0013CC: u'Tall Maple Systems',
   0x0013CD: u'MTI co. LTD',
   0x0013CE: u'Intel Corporate',
   0x0013CF: u'4Access Communications',
   0x0013D0: u'e-San Limited',
   0x0013D1: u'KIRK telecom A/S',
   0x0013D2: u'PAGE IBERICA, S.A.',
   0x0013D3: u'MICRO-STAR INTERNATIONAL CO., LTD.',
   0x0013D4: u'ASUSTek COMPUTER INC.',
   0x0013D5: u'WiNetworks LTD',
   0x0013D6: u'TII NETWORK TECHNOLOGIES, INC.',
   0x0013D7: u'SPIDCOM Technologies SA',
   0x0013D8: u'Princeton Instruments',
   0x0013D9: u'Matrix Product Development, Inc.',
   0x0013DA: u'Diskware Co., Ltd',
   0x0013DB: u'SHOEI Electric Co.,Ltd',
   0x0013DC: u'IBTEK INC.',
   0x0013DD: u'Abbott Diagnostics',
   0x0013DE: u'Adapt4',
   0x0013DF: u'Ryvor Corp.',
   0x0013E0: u'Murata Manufacturing Co., Ltd.',
   0x0013E1: u'Iprobe',
   0x0013E2: u'GeoVision Inc.',
   0x0013E3: u'CoVi Technologies, Inc.',
   0x0013E4: u'YANGJAE SYSTEMS CORP.',
   0x0013E5: u'TENOSYS, INC.',
   0x0013E6: u'Technolution',
   0x0013E7: u'Minelab Electronics Pty Limited',
   0x0013E8: u'Intel Corporate',
   0x0013E9: u'VeriWave, Inc.',
   0x0013EA: u'Kamstrup A/S',
   0x0013EB: u'Sysmaster Corporation',
   0x0013EC: u'Sunbay Software AG',
   0x0013ED: u'PSIA',
   0x0013EE: u'JBX Designs Inc.',
   0x0013EF: u'Kingjon Digital Technology Co.,Ltd',
   0x0013F0: u'Wavefront Semiconductor',
   0x0013F1: u'AMOD Technology Co., Ltd.',
   0x0013F2: u'Klas Ltd',
   0x0013F3: u'Giga-byte Communications Inc.',
   0x0013F4: u'Psitek (Pty) Ltd',
   0x0013F5: u'Akimbi Systems',
   0x0013F6: u'Cintech',
   0x0013F7: u'SMC Networks, Inc.',
   0x0013F8: u'Dex Security Solutions',
   0x0013F9: u'Cavera Systems',
   0x0013FA: u'LifeSize Communications, Inc',
   0x0013FB: u'RKC INSTRUMENT INC.',
   0x0013FC: u'SiCortex, Inc',
   0x0013FD: u'Nokia Danmark A/S',
   0x0013FE: u'GRANDTEC ELECTRONIC CORP.',
   0x0013FF: u'Dage-MTI of MC, Inc.',
   0x001400: u'MINERVA KOREA CO., LTD',
   0x001401: u'Rivertree Networks Corp.',
   0x001402: u'kk-electronic a/s',
   0x001403: u'Renasis, LLC',
   0x001404: u'Motorola CHS',
   0x001405: u'OpenIB, Inc.',
   0x001406: u'Go Networks',
   0x001407: u'Biosystems',
   0x001408: u'Eka Systems Inc.',
   0x001409: u'MAGNETI MARELLI   S.E. S.p.A.',
   0x00140A: u'WEPIO Co., Ltd.',
   0x00140B: u'FIRST INTERNATIONAL COMPUTER, INC.',
   0x00140C: u'GKB CCTV CO., LTD.',
   0x00140D: u'Nortel',
   0x00140E: u'Nortel',
   0x00140F: u'Federal State Unitary Enterprise Leningrad R&D Institute of',
   0x001410: u'Suzhou Keda Technology CO.,Ltd',
   0x001411: u'Deutschmann Automation GmbH & Co. KG',
   0x001412: u'S-TEC electronics AG',
   0x001413: u'Trebing & Himstedt Prozessautomation GmbH & Co. KG',
   0x001414: u'Jumpnode Systems LLC.',
   0x001415: u'Intec Automation Inc.',
   0x001416: u'Scosche Industries, Inc.',
   0x001417: u'RSE Informations Technologie GmbH',
   0x001418: u'C4Line',
   0x001419: u'SIDSA',
   0x00141A: u'DEICY CORPORATION',
   0x00141B: u'Cisco Systems',
   0x00141C: u'Cisco Systems',
   0x00141D: u'Lust Antriebstechnik GmbH',
   0x00141E: u'P.A. Semi, Inc.',
   0x00141F: u'SunKwang Electronics Co., Ltd',
   0x001420: u'G-Links networking company',
   0x001421: u'Total Wireless Technologies Pte. Ltd.',
   0x001422: u'Dell Inc.',
   0x001423: u'J-S Co. NEUROCOM',
   0x001424: u'Merry Electrics CO., LTD.',
   0x001425: u'Galactic Computing Corp.',
   0x001426: u'NL Technology',
   0x001427: u'JazzMutant',
   0x001428: u'Vocollect, Inc',
   0x001429: u'V Center Technologies Co., Ltd.',
   0x00142A: u'Elitegroup Computer System Co., Ltd',
   0x00142B: u'Edata Technologies Inc.',
   0x00142C: u'Koncept International, Inc.',
   0x00142D: u'Toradex AG',
   0x00142E: u'77 Elektronika Kft.',
   0x00142F: u'WildPackets',
   0x001430: u'ViPowER, Inc',
   0x001431: u'PDL Electronics Ltd',
   0x001432: u'Tarallax Wireless, Inc.',
   0x001433: u'Empower Technologies(Canada) Inc.',
   0x001434: u'Keri Systems, Inc',
   0x001435: u'CityCom Corp.',
   0x001436: u'Qwerty Elektronik AB',
   0x001437: u'GSTeletech Co.,Ltd.',
   0x001438: u'Hewlett Packard',
   0x001439: u'Blonder Tongue Laboratories, Inc.',
   0x00143A: u'RAYTALK INTERNATIONAL SRL',
   0x00143B: u'Sensovation AG',
   0x00143C: u'Oerlikon Contraves Inc.',
   0x00143D: u'Aevoe Inc.',
   0x00143E: u'AirLink Communications, Inc.',
   0x00143F: u'Hotway Technology Corporation',
   0x001440: u'ATOMIC Corporation',
   0x001441: u'Innovation Sound Technology Co., LTD.',
   0x001442: u'ATTO CORPORATION',
   0x001443: u'Consultronics Europe Ltd',
   0x001444: u'Grundfos Electronics',
   0x001445: u'Telefon-Gradnja d.o.o.',
   0x001446: u'KidMapper, Inc.',
   0x001447: u'BOAZ Inc.',
   0x001448: u'Inventec Multimedia & Telecom Corporation',
   0x001449: u'Sichuan Changhong Electric Ltd.',
   0x00144A: u'Taiwan Thick-Film Ind. Corp.',
   0x00144B: u'Hifn, Inc.',
   0x00144C: u'General Meters Corp.',
   0x00144D: u'Intelligent Systems',
   0x00144E: u'SRISA',
   0x00144F: u'Sun Microsystems, Inc.',
   0x001450: u'Heim Systems GmbH',
   0x001451: u'Apple Computer Inc.',
   0x001452: u'CALCULEX,INC.',
   0x001453: u'ADVANTECH TECHNOLOGIES CO.,LTD',
   0x001454: u'Symwave',
   0x001455: u'Coder Electronics Corporation',
   0x001456: u'Edge Products',
   0x001457: u'T-VIPS AS',
   0x001458: u'HS Automatic ApS',
   0x001459: u'Moram Co., Ltd.',
   0x00145A: u'Elektrobit AG',
   0x00145B: u'SeekerNet Inc.',
   0x00145C: u'Intronics B.V.',
   0x00145D: u'WJ Communications, Inc.',
   0x00145E: u'IBM',
   0x00145F: u'ADITEC CO. LTD',
   0x001460: u'Kyocera Wireless Corp.',
   0x001461: u'CORONA CORPORATION',
   0x001462: u'Digiwell Technology, inc',
   0x001463: u'IDCS N.V.',
   0x001464: u'Cryptosoft',
   0x001465: u'Novo Nordisk A/S',
   0x001466: u'Kleinhenz Elektronik GmbH',
   0x001467: u'ArrowSpan Inc.',
   0x001468: u'CelPlan International, Inc.',
   0x001469: u'Cisco Systems',
   0x00146A: u'Cisco Systems',
   0x00146B: u'Anagran, Inc.',
   0x00146C: u'Netgear Inc.',
   0x00146D: u'RF Technologies',
   0x00146E: u'H. Stoll GmbH & Co. KG',
   0x00146F: u'Kohler Co',
   0x001470: u'Prokom Software SA',
   0x001471: u'Eastern Asia Technology Limited',
   0x001472: u'China Broadband Wireless IP Standard Group',
   0x001473: u'Bookham Inc',
   0x001474: u'K40 Electronics',
   0x001475: u'Wiline Networks, Inc.',
   0x001476: u'MultiCom Industries Limited',
   0x001477: u'Nertec  Inc.',
   0x001478: u'ShenZhen TP-LINK Technologies Co., Ltd.',
   0x001479: u'NEC Magnus Communications,Ltd.',
   0x00147A: u'Eubus GmbH',
   0x00147B: u'Iteris, Inc.',
   0x00147C: u'3Com Europe Ltd',
   0x00147D: u'Aeon Digital International',
   0x00147E: u'PanGo Networks, Inc.',
   0x00147F: u'Thomson Telecom Belgium',
   0x001480: u'Hitachi-LG Data Storage Korea, Inc',
   0x001481: u'Multilink Inc',
   0x001482: u'GoBackTV, Inc',
   0x001483: u'eXS Inc.',
   0x001484: u'CERMATE TECHNOLOGIES INC',
   0x001485: u'Giga-Byte',
   0x001486: u'Echo Digital Audio Corporation',
   0x001487: u'American Technology Integrators',
   0x001488: u'Akorri Networks',
   0x001489: u'B15402100 - JANDEI, S.L.',
   0x00148A: u'Elin Ebg Traction Gmbh',
   0x00148B: u'Globo Electronic GmbH & Co. KG',
   0x00148C: u'Fortress Technologies',
   0x00148D: u'Cubic Defense Simulation Systems',
   0x00148E: u'Tele Power Inc.',
   0x00148F: u'Protronic (Far East) Ltd.',
   0x001490: u'ASP Corporation',
   0x001491: u'Daniels Electronics Ltd.',
   0x001492: u'Liteon, Mobile Media Solution SBU',
   0x001493: u'Systimax Solutions',
   0x001494: u'ESU AG',
   0x001495: u'2Wire, Inc.',
   0x001496: u'Phonic Corp.',
   0x001497: u'ZHIYUAN Eletronics co.,ltd.',
   0x001498: u'Viking Design Technology',
   0x001499: u'Helicomm Inc',
   0x00149A: u'Motorola Mobile Devices Business',
   0x00149B: u'Nokota Communications, LLC',
   0x00149C: u'HF Company',
   0x00149D: u'Sound ID Inc.',
   0x00149E: u'UbONE Co., Ltd',
   0x00149F: u'System and Chips, Inc.',
   0x0014A0: u'RFID Asset Track, Inc.',
   0x0014A1: u'Synchronous Communication Corp',
   0x0014A2: u'Core Micro Systems Inc.',
   0x0014A3: u'Vitelec BV',
   0x0014A4: u'Hon Hai Precision Ind. Co., Ltd.',
   0x0014A5: u'Gemtek Technology Co., Ltd.',
   0x0014A6: u'Teranetics, Inc.',
   0x0014A7: u'Nokia Danmark A/S',
   0x0014A8: u'Cisco Systems',
   0x0014A9: u'Cisco Systems',
   0x0014AA: u'Ashly Audio, Inc.',
   0x0014AB: u'Senhai Electronic Technology Co., Ltd.',
   0x0014AC: u'Bountiful WiFi',
   0x0014AD: u'Gassner Wiege- u. Meßtechnik GmbH',
   0x0014AE: u'Wizlogics Co., Ltd.',
   0x0014AF: u'Datasym Inc.',
   0x0014B0: u'Naeil Community',
   0x0014B1: u'Avitec AB',
   0x0014B2: u'mCubelogics Corporation',
   0x0014B3: u'CoreStar International Corp',
   0x0014B4: u'General Dynamics United Kingdom Ltd',
   0x0014B5: u'PRIVATE',
   0x0014B6: u'Enswer Technology Inc.',
   0x0014B7: u'AR Infotek Inc.',
   0x0014B8: u'Hill-Rom',
   0x0014B9: u'STEPMIND',
   0x0014BA: u'Carvers SA de CV',
   0x0014BB: u'Open Interface North America',
   0x0014BC: u'SYNECTIC TELECOM EXPORTS PVT. LTD.',
   0x0014BD: u'incNETWORKS, Inc',
   0x0014BE: u'Wink communication technology CO.LTD',
   0x0014BF: u'Cisco-Linksys LLC',
   0x0014C0: u'Symstream Technology Group Ltd',
   0x0014C1: u'U.S. Robotics Corporation',
   0x0014C2: u'Hewlett Packard',
   0x0014C3: u'Seagate Technology LLC',
   0x0014C4: u'Vitelcom Mobile Technology',
   0x0014C5: u'Alive Technologies Pty Ltd',
   0x0014C6: u'Quixant Ltd',
   0x0014C7: u'Nortel',
   0x0014C8: u'Contemporary Research Corp',
   0x0014C9: u'Silverback Systems, Inc.',
   0x0014CA: u'Key Radio Systems Limited',
   0x0014CB: u'LifeSync Corporation',
   0x0014CC: u'Zetec, Inc.',
   0x0014CD: u'DigitalZone Co., Ltd.',
   0x0014CE: u'NF CORPORATION',
   0x0014CF: u'Nextlink.to A/S',
   0x0014D0: u'BTI Photonics',
   0x0014D1: u'TRENDware International, Inc.',
   0x0014D2: u'KYUKI CORPORATION',
   0x0014D3: u'SEPSA',
   0x0014D4: u'K Technology Corporation',
   0x0014D5: u'Datang Telecom Technology CO. , LCD,Optical Communication Br',
   0x0014D6: u'Jeongmin Electronics Co.,Ltd.',
   0x0014D7: u'DataStor Technology Inc.',
   0x0014D8: u'bio-logic SA',
   0x0014D9: u'IP Fabrics, Inc.',
   0x0014DA: u'Huntleigh Healthcare',
   0x0014DB: u'Elma Trenew Electronic GmbH',
   0x0014DC: u'Communication System Design & Manufacturing (CSDM)',
   0x0014DD: u'Covergence Inc.',
   0x0014DE: u'Sage Instruments Inc.',
   0x0014DF: u'HI-P Tech Corporation',
   0x0014E0: u'LET\'S Corporation',
   0x0014E1: u'Data Display AG',
   0x0014E2: u'datacom systems inc.',
   0x0014E3: u'mm-lab GmbH',
   0x0014E4: u'Integral Technologies',
   0x0014E5: u'Alticast',
   0x0014E6: u'AIM Infrarotmodule GmbH',
   0x0014E7: u'Stolinx,. Inc',
   0x0014E8: u'Motorola CHS',
   0x0014E9: u'Nortech International',
   0x0014EA: u'S Digm Inc. (Safe Paradigm Inc.)',
   0x0014EB: u'AwarePoint Corporation',
   0x0014EC: u'Acro Telecom',
   0x0014ED: u'Airak, Inc.',
   0x0014EE: u'Western Digital Technologies, Inc.',
   0x0014EF: u'TZero Technologies, Inc.',
   0x0014F0: u'Business Security OL AB',
   0x0014F1: u'Cisco Systems',
   0x0014F2: u'Cisco Systems',
   0x0014F3: u'ViXS Systems Inc',
   0x0014F4: u'DekTec Digital Video B.V.',
   0x0014F5: u'OSI Security Devices',
   0x0014F6: u'Juniper Networks, Inc.',
   0x0014F7: u'Crevis',
   0x0014F8: u'Scientific Atlanta',
   0x0014F9: u'Vantage Controls',
   0x0014FA: u'AsGa S.A.',
   0x0014FB: u'Technical Solutions Inc.',
   0x0014FC: u'Extandon, Inc.',
   0x0014FD: u'Thecus Technology Corp.',
   0x0014FE: u'Artech Electronics',
   0x0014FF: u'Precise Automation, LLC',
   0x001500: u'Intel Corporate',
   0x001501: u'LexBox',
   0x001502: u'BETA tech',
   0x001503: u'PROFIcomms s.r.o.',
   0x001504: u'GAME PLUS CO., LTD.',
   0x001505: u'Actiontec Electronics, Inc',
   0x001506: u'BeamExpress, Inc',
   0x001507: u'Renaissance Learning Inc',
   0x001508: u'Global Target Enterprise Inc',
   0x001509: u'Plus Technology Co., Ltd',
   0x00150A: u'Sonoa Systems, Inc',
   0x00150B: u'SAGE INFOTECH LTD.',
   0x00150C: u'AVM GmbH',
   0x00150D: u'Hoana Medical, Inc.',
   0x00150E: u'OPENBRAIN TECHNOLOGIES CO., LTD.',
   0x00150F: u'mingjong',
   0x001510: u'Techsphere Co., Ltd',
   0x001511: u'Data Center Systems',
   0x001512: u'Zurich University of Applied Sciences',
   0x001513: u'EFS sas',
   0x001514: u'Hu Zhou NAVA Networks&Electronics Ltd.',
   0x001515: u'Leipold+Co.GmbH',
   0x001516: u'URIEL SYSTEMS INC.',
   0x001517: u'Intel Corporate',
   0x001518: u'Shenzhen 10MOONS Technology Development CO.,Ltd',
   0x001519: u'StoreAge Networking Technologies',
   0x00151A: u'Hunter Engineering Company',
   0x00151B: u'Isilon Systems Inc.',
   0x00151C: u'LENECO',
   0x00151D: u'M2I CORPORATION',
   0x00151E: u'Metaware Co., Ltd.',
   0x00151F: u'Multivision Intelligent Surveillance (Hong Kong) Ltd',
   0x001520: u'Radiocrafts AS',
   0x001521: u'Horoquartz',
   0x001522: u'Dea Security',
   0x001523: u'Meteor Communications Corporation',
   0x001524: u'Numatics, Inc.',
   0x001525: u'PTI Integrated Systems, Inc.',
   0x001526: u'Remote Technologies Inc',
   0x001527: u'Balboa Instruments',
   0x001528: u'Beacon Medical Products LLC d.b.a. BeaconMedaes',
   0x001529: u'N3 Corporation',
   0x00152A: u'Nokia GmbH',
   0x00152B: u'Cisco Systems',
   0x00152C: u'Cisco Systems',
   0x00152D: u'TenX Networks, LLC',
   0x00152E: u'PacketHop, Inc.',
   0x00152F: u'Motorola CHS',
   0x001530: u'Bus-Tech, Inc.',
   0x001531: u'KOCOM',
   0x001532: u'Consumer Technologies Group, LLC',
   0x001533: u'NADAM.CO.,LTD',
   0x001534: u'A BELTRÓNICA, Companhia de Comunicações, Lda',
   0x001535: u'OTE Spa',
   0x001536: u'Powertech co.,Ltd',
   0x001537: u'Ventus Networks',
   0x001538: u'RFID, Inc.',
   0x001539: u'Technodrive SRL',
   0x00153A: u'Shenzhen Syscan Technology Co.,Ltd.',
   0x00153B: u'EMH Elektrizitätszähler GmbH & CoKG',
   0x00153C: u'Kprotech Co., Ltd.',
   0x00153D: u'ELIM PRODUCT CO.',
   0x00153E: u'Q-Matic Sweden AB',
   0x00153F: u'Alcatel Alenia Space Italia',
   0x001540: u'Nortel',
   0x001541: u'StrataLight Communications, Inc.',
   0x001542: u'MICROHARD S.R.L.',
   0x001543: u'Aberdeen Test Center',
   0x001544: u'coM.s.a.t. AG',
   0x001545: u'SEECODE Co., Ltd.',
   0x001546: u'ITG Worldwide Sdn Bhd',
   0x001547: u'AiZen Solutions Inc.',
   0x001548: u'CUBE TECHNOLOGIES',
   0x001549: u'Dixtal Biomedica Ind. Com. Ltda',
   0x00154A: u'WANSHIH ELECTRONIC CO., LTD',
   0x00154B: u'Wonde Proud Technology Co., Ltd',
   0x00154C: u'Saunders Electronics',
   0x00154D: u'Netronome Systems, Inc.',
   0x00154E: u'Hirschmann Automation and Control GmbH',
   0x00154F: u'one RF Technology',
   0x001550: u'Nits Technology Inc',
   0x001551: u'RadioPulse Inc.',
   0x001552: u'Wi-Gear Inc.',
   0x001553: u'Cytyc Corporation',
   0x001554: u'Atalum Wireless S.A.',
   0x001555: u'DFM GmbH',
   0x001556: u'SAGEM SA',
   0x001557: u'Olivetti',
   0x001558: u'FOXCONN',
   0x001559: u'Securaplane Technologies, Inc.',
   0x00155A: u'DAINIPPON PHARMACEUTICAL CO., LTD.',
   0x00155B: u'Sampo Corporation',
   0x00155C: u'Dresser Wayne',
   0x00155D: u'Microsoft Corporation',
   0x00155E: u'Morgan Stanley',
   0x00155F: u'Ubiwave',
   0x001560: u'Hewlett Packard',
   0x001561: u'JJPlus Corporation',
   0x001562: u'Cisco Systems',
   0x001563: u'Cisco Systems',
   0x001564: u'BEHRINGER Spezielle Studiotechnik GmbH',
   0x001565: u'XIAMEN YEALINK NETWORK TECHNOLOGY CO.,LTD',
   0x001566: u'A-First Technology Co., Ltd.',
   0x001567: u'RADWIN Inc.',
   0x001568: u'Dilithium Networks',
   0x001569: u'PECO II, Inc.',
   0x00156A: u'DG2L Technologies Pvt. Ltd.',
   0x00156B: u'Perfisans Networks Corp.',
   0x00156C: u'SANE SYSTEM CO., LTD',
   0x00156D: u'Ubiquiti Networks',
   0x00156E: u'A. W. Communication Systems Ltd',
   0x00156F: u'Xiranet Communications GmbH',
   0x001570: u'Symbol Technologies',
   0x001571: u'Nolan Systems',
   0x001572: u'Red-Lemon',
   0x001573: u'NewSoft  Technology Corporation',
   0x001574: u'Horizon Semiconductors Ltd.',
   0x001575: u'Nevis Networks Inc.',
   0x001576: u'scil animal care company GmbH',
   0x001577: u'Allied Telesyn, Inc.',
   0x001578: u'Audio / Video Innovations',
   0x001579: u'Lunatone Industrielle Elektronik GmbH',
   0x00157A: u'Telefin S.p.A.',
   0x00157B: u'Leuze electronic GmbH + Co. KG',
   0x00157C: u'Dave Networks, Inc.',
   0x00157D: u'POSDATA CO., LTD.',
   0x00157E: u'HEYFRA ELECTRONIC gmbH',
   0x00157F: u'ChuanG International Holding CO.,LTD.',
   0x001580: u'U-WAY CORPORATION',
   0x001581: u'MAKUS Inc.',
   0x001582: u'TVonics Ltd',
   0x001583: u'IVT corporation',
   0x001584: u'Schenck Process GmbH',
   0x001585: u'Aonvision Technolopy Corp.',
   0x001586: u'Xiamen Overseas Chinese Electronic Co., Ltd.',
   0x001587: u'Takenaka Seisakusho Co.,Ltd',
   0x001588: u'Balda-Thong Fook Solutions Sdn. Bhd.',
   0x001589: u'D-MAX Technology Co.,Ltd',
   0x00158A: u'SURECOM Technology Corp.',
   0x00158B: u'Park Air Systems Ltd',
   0x00158C: u'Liab ApS',
   0x00158D: u'Jennic Ltd',
   0x00158E: u'Plustek.INC',
   0x00158F: u'NTT Advanced Technology Corporation',
   0x001590: u'Hectronic GmbH',
   0x001591: u'RLW Inc.',
   0x001592: u'Facom UK Ltd (Melksham)',
   0x001593: u'U4EA Technologies Inc.',
   0x001594: u'BIXOLON CO.,LTD',
   0x001595: u'Quester Tangent Corporation',
   0x001596: u'ARRIS International',
   0x001597: u'AETA AUDIO SYSTEMS',
   0x001598: u'Kolektor group',
   0x001599: u'Samsung Electronics Co., LTD',
   0x00159A: u'Motorola CHS',
   0x00159B: u'Nortel',
   0x00159C: u'B-KYUNG SYSTEM Co.,Ltd.',
   0x00159D: u'Minicom Advanced Systems ltd',
   0x00159E: u'Saitek plc',
   0x00159F: u'Terascala, Inc.',
   0x0015A0: u'Nokia Danmark A/S',
   0x0015A1: u'SINTERS SAS',
   0x0015A2: u'ARRIS International',
   0x0015A3: u'ARRIS International',
   0x0015A4: u'ARRIS International',
   0x0015A5: u'DCI Co., Ltd.',
   0x0015A6: u'Digital Electronics Products Ltd.',
   0x0015A7: u'Robatech AG',
   0x0015A8: u'Motorola Mobile Devices',
   0x0015A9: u'KWANG WOO I&C CO.,LTD',
   0x0015AA: u'Rextechnik International Co.,',
   0x0015AB: u'PRO CO SOUND INC',
   0x0015AC: u'Capelon AB',
   0x0015AD: u'Accedian Networks',
   0x0015AE: u'kyung il',
   0x0015AF: u'AzureWave Technologies, Inc.',
   0x0015B0: u'AUTOTELENET CO.,LTD',
   0x0015B1: u'Ambient Corporation',
   0x0015B2: u'Advanced Industrial Computer, Inc.',
   0x0015B3: u'Caretech AB',
   0x0015B4: u'Polymap  Wireless LLC',
   0x0015B5: u'CI Network Corp.',
   0x0015B6: u'ShinMaywa Industries, Ltd.',
   0x0015B7: u'Toshiba',
   0x0015B8: u'Tahoe',
   0x0015B9: u'Samsung Electronics Co., Ltd.',
   0x0015BA: u'iba AG',
   0x0015BB: u'SMA Technologie AG',
   0x0015BC: u'Develco',
   0x0015BD: u'Group 4 Technology Ltd',
   0x0015BE: u'Iqua Ltd.',
   0x0015BF: u'technicob',
   0x0015C0: u'DIGITAL TELEMEDIA CO.,LTD.',
   0x0015C1: u'SONY Computer Entertainment inc,',
   0x0015C2: u'3M Germany',
   0x0015C3: u'Ruf Telematik AG',
   0x0015C4: u'FLOVEL CO., LTD.',
   0x0015C5: u'Dell Inc',
   0x0015C6: u'Cisco Systems',
   0x0015C7: u'Cisco Systems',
   0x0015C8: u'FlexiPanel Ltd',
   0x0015C9: u'Gumstix, Inc',
   0x0015CA: u'TeraRecon, Inc.',
   0x0015CB: u'Surf Communication Solutions Ltd.',
   0x0015CC: u'TEPCO UQUEST, LTD.',
   0x0015CD: u'Exartech International Corp.',
   0x0015CE: u'ARRIS International',
   0x0015CF: u'ARRIS International',
   0x0015D0: u'ARRIS International',
   0x0015D1: u'ARRIS International',
   0x0015D2: u'Xantech Corporation',
   0x0015D3: u'Pantech&Curitel Communications, Inc.',
   0x0015D4: u'Emitor AB',
   0x0015D5: u'NICEVT',
   0x0015D6: u'OSLiNK Sp. z o.o.',
   0x0015D7: u'Reti Corporation',
   0x0015D8: u'Interlink Electronics',
   0x0015D9: u'PKC Electronics Oy',
   0x0015DA: u'IRITEL A.D.',
   0x0015DB: u'Canesta Inc.',
   0x0015DC: u'KT&C Co., Ltd.',
   0x0015DD: u'IP Control Systems Ltd.',
   0x0015DE: u'Nokia Danmark A/S',
   0x0015DF: u'Clivet S.p.A.',
   0x0015E0: u'Ericsson Mobile Platforms',
   0x0015E1: u'picoChip Designs Ltd',
   0x0015E2: u'Wissenschaftliche Geraetebau Dr. Ing. H. Knauer GmbH',
   0x0015E3: u'Dream Technologies Corporation',
   0x0015E4: u'Zimmer Elektromedizin',
   0x0015E5: u'Cheertek Inc.',
   0x0015E6: u'MOBILE TECHNIKA Inc.',
   0x0015E7: u'Quantec ProAudio',
   0x0015E8: u'Nortel',
   0x0015E9: u'D-Link Corporation',
   0x0015EA: u'Tellumat (Pty) Ltd',
   0x0015EB: u'ZTE CORPORATION',
   0x0015EC: u'Boca Devices LLC',
   0x0015ED: u'Fulcrum Microsystems, Inc.',
   0x0015EE: u'Omnex Control Systems',
   0x0015EF: u'NEC TOKIN Corporation',
   0x0015F0: u'EGO BV',
   0x0015F1: u'KYLINK Communications Corp.',
   0x0015F2: u'ASUSTek COMPUTER INC.',
   0x0015F3: u'PELTOR AB',
   0x0015F4: u'Eventide',
   0x0015F5: u'Sustainable Energy Systems',
   0x0015F6: u'SCIENCE AND ENGINEERING SERVICES, INC.',
   0x0015F7: u'Wintecronics Ltd.',
   0x0015F8: u'Kingtronics Industrial Co. Ltd.',
   0x0015F9: u'Cisco Systems',
   0x0015FA: u'Cisco Systems',
   0x0015FB: u'setex schermuly textile computer gmbh',
   0x0015FC: u'Startco Engineering Ltd.',
   0x0015FD: u'Complete Media Systems',
   0x0015FE: u'SCHILLING ROBOTICS LLC',
   0x0015FF: u'Novatel Wireless, Inc.',
   0x001600: u'CelleBrite Mobile Synchronization',
   0x001601: u'Buffalo Inc.',
   0x001602: u'CEYON TECHNOLOGY CO.,LTD.',
   0x001603: u'PRIVATE',
   0x001604: u'Sigpro',
   0x001605: u'YORKVILLE SOUND INC.',
   0x001606: u'Ideal Industries',
   0x001607: u'Curves International Inc.',
   0x001608: u'Sequans Communications',
   0x001609: u'Unitech electronics co., ltd.',
   0x00160A: u'SWEEX Europe BV',
   0x00160B: u'TVWorks LLC',
   0x00160C: u'LPL  DEVELOPMENT S.A. DE C.V',
   0x00160D: u'Be Here Corporation',
   0x00160E: u'Optica Technologies Inc.',
   0x00160F: u'BADGER METER INC',
   0x001610: u'Carina Technology',
   0x001611: u'Altecon Srl',
   0x001612: u'Otsuka Electronics Co., Ltd.',
   0x001613: u'LibreStream Technologies Inc.',
   0x001614: u'Picosecond Pulse Labs',
   0x001615: u'Nittan Company, Limited',
   0x001616: u'BROWAN COMMUNICATION INC.',
   0x001617: u'MSI',
   0x001618: u'HIVION Co., Ltd.',
   0x001619: u'La Factoría de Comunicaciones Aplicadas,S.L.',
   0x00161A: u'Dametric AB',
   0x00161B: u'Micronet Corporation',
   0x00161C: u'e:cue',
   0x00161D: u'Innovative Wireless Technologies, Inc.',
   0x00161E: u'Woojinnet',
   0x00161F: u'SUNWAVETEC Co., Ltd.',
   0x001620: u'Sony Ericsson Mobile Communications AB',
   0x001621: u'Colorado Vnet',
   0x001622: u'BBH SYSTEMS GMBH',
   0x001623: u'Interval Media',
   0x001624: u'PRIVATE',
   0x001625: u'Impinj, Inc.',
   0x001626: u'Motorola CHS',
   0x001627: u'embedded-logic DESIGN AND MORE GmbH',
   0x001628: u'Ultra Electronics Manufacturing and Card Systems',
   0x001629: u'Nivus GmbH',
   0x00162A: u'Antik computers & communications s.r.o.',
   0x00162B: u'Togami Electric Mfg.co.,Ltd.',
   0x00162C: u'Xanboo',
   0x00162D: u'STNet Co., Ltd.',
   0x00162E: u'Space Shuttle Hi-Tech Co., Ltd.',
   0x00162F: u'Geutebrück GmbH',
   0x001630: u'Vativ Technologies',
   0x001631: u'Xteam',
   0x001632: u'SAMSUNG ELECTRONICS CO., LTD.',
   0x001633: u'Oxford Diagnostics Ltd.',
   0x001634: u'Mathtech, Inc.',
   0x001635: u'Hewlett Packard',
   0x001636: u'Quanta Computer Inc.',
   0x001637: u'Citel Srl',
   0x001638: u'TECOM Co., Ltd.',
   0x001639: u'UBIQUAM Co.,Ltd',
   0x00163A: u'YVES TECHNOLOGY CO., LTD.',
   0x00163B: u'VertexRSI/General Dynamics',
   0x00163C: u'Rebox B.V.',
   0x00163D: u'Tsinghua Tongfang Legend Silicon Tech. Co., Ltd.',
   0x00163E: u'Xensource, Inc.',
   0x00163F: u'CReTE SYSTEMS Inc.',
   0x001640: u'Asmobile Communication Inc.',
   0x001641: u'USI',
   0x001642: u'Pangolin',
   0x001643: u'Sunhillo Corproation',
   0x001644: u'LITE-ON Technology Corp.',
   0x001645: u'Power Distribution, Inc.',
   0x001646: u'Cisco Systems',
   0x001647: u'Cisco Systems',
   0x001648: u'SSD Company Limited',
   0x001649: u'SetOne GmbH',
   0x00164A: u'Vibration Technology Limited',
   0x00164B: u'Quorion Data Systems GmbH',
   0x00164C: u'PLANET INT Co., Ltd',
   0x00164D: u'Alcatel North America IP Division',
   0x00164E: u'Nokia Danmark A/S',
   0x00164F: u'World Ethnic Broadcastin Inc.',
   0x001650: u'EYAL MICROWAVE',
   0x001651: u'PRIVATE',
   0x001652: u'Hoatech Technologies, Inc.',
   0x001653: u'LEGO System A/S IE Electronics Division',
   0x001654: u'Flex-P Industries Sdn. Bhd.',
   0x001655: u'FUHO TECHNOLOGY Co., LTD',
   0x001656: u'Nintendo Co., Ltd.',
   0x001657: u'Aegate Ltd',
   0x001658: u'Fusiontech Technologies Inc.',
   0x001659: u'Z.M.P. RADWAG',
   0x00165A: u'Harman Specialty Group',
   0x00165B: u'Grip Audio',
   0x00165C: u'Trackflow Ltd',
   0x00165D: u'AirDefense, Inc.',
   0x00165E: u'Precision I/O',
   0x00165F: u'Fairmount Automation',
   0x001660: u'Nortel',
   0x001661: u'Novatium Solutions (P) Ltd',
   0x001662: u'Liyuh Technology Ltd.',
   0x001663: u'KBT Mobile',
   0x001664: u'Prod-El SpA',
   0x001665: u'Cellon France',
   0x001666: u'Quantier Communication Inc.',
   0x001667: u'A-TEC Subsystem INC.',
   0x001668: u'Eishin Electronics',
   0x001669: u'MRV Communication (Networks) LTD',
   0x00166A: u'TPS',
   0x00166B: u'Samsung Electronics',
   0x00166C: u'Samsung Electonics Digital Video System Division',
   0x00166D: u'Yulong Computer Telecommunication Scientific(shenzhen)Co.,Lt',
   0x00166E: u'Arbitron Inc.',
   0x00166F: u'Intel Corporation',
   0x001670: u'SKNET Corporation',
   0x001671: u'Symphox Information Co.',
   0x001672: u'Zenway enterprise ltd',
   0x001673: u'PRIVATE',
   0x001674: u'EuroCB (Phils.), Inc.',
   0x001675: u'Motorola MDb',
   0x001676: u'Intel Corporation',
   0x001677: u'Bihl+Wiedemann GmbH',
   0x001678: u'SHENZHEN BAOAN GAOKE ELECTRONICS CO., LTD',
   0x001679: u'eOn Communications',
   0x00167A: u'Skyworth Overseas Dvelopment Ltd.',
   0x00167B: u'Haver&Boecker',
   0x00167C: u'iRex Technologies BV',
   0x00167D: u'Sky-Line',
   0x00167E: u'DIBOSS.CO.,LTD',
   0x00167F: u'Bluebird Soft Inc.',
   0x001680: u'Bally Gaming + Systems',
   0x001681: u'Vector Informatik GmbH',
   0x001682: u'Pro Dex, Inc',
   0x001683: u'WEBIO International Co.,.Ltd.',
   0x001684: u'Donjin Co.,Ltd.',
   0x001685: u'FRWD Technologies Ltd.',
   0x001686: u'Karl Storz Imaging',
   0x001687: u'Chubb CSC-Vendor AP',
   0x001688: u'ServerEngines LLC',
   0x001689: u'Pilkor Electronics Co., Ltd',
   0x00168A: u'id-Confirm Inc',
   0x00168B: u'Paralan Corporation',
   0x00168C: u'DSL Partner AS',
   0x00168D: u'KORWIN CO., Ltd.',
   0x00168E: u'Vimicro corporation',
   0x00168F: u'GN Netcom as',
   0x001690: u'J-TEK INCORPORATION',
   0x001691: u'Moser-Baer AG',
   0x001692: u'Scientific-Atlanta, Inc.',
   0x001693: u'PowerLink Technology Inc.',
   0x001694: u'Sennheiser Communications A/S',
   0x001695: u'AVC Technology Limited',
   0x001696: u'QDI Technology (H.K.) Limited',
   0x001697: u'NEC Corporation',
   0x001698: u'T&A Mobile Phones SAS',
   0x001699: u'PRIVATE',
   0x00169A: u'Quadrics Ltd',
   0x00169B: u'Alstom Transport',
   0x00169C: u'Cisco Systems',
   0x00169D: u'Cisco Systems',
   0x00169E: u'TV One Ltd',
   0x00169F: u'Vimtron Electronics Co., Ltd.',
   0x0016A0: u'Auto-Maskin',
   0x0016A1: u'3Leaf Networks',
   0x0016A2: u'CentraLite Systems, Inc.',
   0x0016A3: u'TEAM ARTECHE, S.A.',
   0x0016A4: u'Ezurio Ltd',
   0x0016A5: u'Tandberg Storage ASA',
   0x0016A6: u'Dovado FZ-LLC',
   0x0016A7: u'AWETA G&P',
   0x0016A8: u'CWT CO., LTD.',
   0x0016A9: u'2EI',
   0x0016AA: u'Kei Communication Technology Inc.',
   0x0016AB: u'PBI-Dansensor A/S',
   0x0016AC: u'Toho Technology Corp.',
   0x0016AD: u'BT-Links Company Limited',
   0x0016AE: u'INVENTEL',
   0x0016AF: u'Shenzhen Union Networks Equipment Co.,Ltd.',
   0x0016B0: u'VK Corporation',
   0x0016B1: u'KBS',
   0x0016B2: u'DriveCam Inc',
   0x0016B3: u'Photonicbridges (China) Co., Ltd.',
   0x0016B4: u'PRIVATE',
   0x0016B5: u'Motorola CHS',
   0x0016B6: u'Cisco-Linksys',
   0x0016B7: u'Seoul Commtech',
   0x0016B8: u'Sony Ericsson Mobile Communications',
   0x0016B9: u'ProCurve Networking',
   0x0016BA: u'WEATHERNEWS INC.',
   0x0016BB: u'Law-Chain Computer Technology Co Ltd',
   0x0016BC: u'Nokia Danmark A/S',
   0x0016BD: u'ATI Industrial Automation',
   0x0016BE: u'INFRANET, Inc.',
   0x0016BF: u'PaloDEx Group Oy',
   0x0016C0: u'Semtech Corporation',
   0x0016C1: u'Eleksen Ltd',
   0x0016C2: u'Avtec Systems Inc',
   0x0016C3: u'BA Systems Inc',
   0x0016C4: u'SiRF Technology, Inc.',
   0x0016C5: u'Shenzhen Xing Feng Industry Co.,Ltd',
   0x0016C6: u'North Atlantic Industries',
   0x0016C7: u'Cisco Systems',
   0x0016C8: u'Cisco Systems',
   0x0016C9: u'NAT Seattle, Inc.',
   0x0016CA: u'Nortel',
   0x0016CB: u'Apple Computer',
   0x0016CC: u'Xcute Mobile Corp.',
   0x0016CD: u'HIJI HIGH-TECH CO., LTD.',
   0x0016CE: u'Hon Hai Precision Ind. Co., Ltd.',
   0x0016CF: u'Hon Hai Precision Ind. Co., Ltd.',
   0x0016D0: u'ATech elektronika d.o.o.',
   0x0016D1: u'ZAT a.s.',
   0x0016D2: u'Caspian',
   0x0016D3: u'Wistron Corporation',
   0x0016D4: u'Compal Communications, Inc.',
   0x0016D5: u'Synccom Co., Ltd',
   0x0016D6: u'TDA Tech Pty Ltd',
   0x0016D7: u'Sunways AG',
   0x0016D8: u'Senea AB',
   0x0016D9: u'NINGBO BIRD CO.,LTD.',
   0x0016DA: u'Futronic Technology Co. Ltd.',
   0x0016DB: u'Samsung Electronics Co., Ltd.',
   0x0016DC: u'ARCHOS',
   0x0016DD: u'Gigabeam Corporation',
   0x0016DE: u'FAST Inc',
   0x0016DF: u'Lundinova AB',
   0x0016E0: u'3Com Europe Ltd',
   0x0016E1: u'SiliconStor, Inc.',
   0x0016E2: u'American Fibertek, Inc.',
   0x0016E3: u'ASKEY COMPUTER CORP.',
   0x0016E4: u'VANGUARD SECURITY ENGINEERING CORP.',
   0x0016E5: u'FORDLEY DEVELOPMENT LIMITED',
   0x0016E6: u'GIGA-BYTE TECHNOLOGY CO.,LTD.',
   0x0016E7: u'Dynamix Promotions Limited',
   0x0016E8: u'Sigma Designs, Inc.',
   0x0016E9: u'Tiba Medical Inc',
   0x0016EA: u'Intel Corporation',
   0x0016EB: u'Intel Corporation',
   0x0016EC: u'Elitegroup Computer Systems Co., Ltd.',
   0x0016ED: u'Integrian, Inc.',
   0x0016EE: u'RoyalDigital Inc.',
   0x0016EF: u'Koko Fitness, Inc.',
   0x0016F0: u'Zermatt Systems, Inc',
   0x0016F1: u'OmniSense, LLC',
   0x0016F2: u'Dmobile System Co., Ltd.',
   0x0016F3: u'CAST Information Co., Ltd',
   0x0016F4: u'Eidicom Co., Ltd.',
   0x0016F5: u'Dalian Golden Hualu Digital Technology Co.,Ltd',
   0x0016F6: u'Video Products Group',
   0x0016F7: u'L-3 Communications, Electrodynamics, Inc.',
   0x0016F8: u'AVIQTECH TECHNOLOGY CO., LTD.',
   0x0016F9: u'CETRTA POT, d.o.o., Kranj',
   0x0016FA: u'ECI Telecom Ltd.',
   0x0016FB: u'SHENZHEN MTC CO.,LTD.',
   0x0016FC: u'TOHKEN CO.,LTD.',
   0x0016FD: u'Jaty Electronics',
   0x0016FE: u'Alps Electric Co., Ltd',
   0x0016FF: u'Wamin Optocomm Mfg Corp',
   0x001700: u'Motorola MDb',
   0x001701: u'KDE, Inc.',
   0x001702: u'Osung Midicom Co., Ltd',
   0x001703: u'MOSDAN Internation Co.,Ltd',
   0x001704: u'Shinco Electronics Group Co.,Ltd',
   0x001705: u'Methode Electronics',
   0x001706: u'Techfaith Wireless Communication Technology Limited.',
   0x001707: u'InGrid, Inc',
   0x001708: u'Hewlett Packard',
   0x001709: u'Exalt Communications',
   0x00170A: u'INEW DIGITAL COMPANY',
   0x00170B: u'Contela, Inc.',
   0x00170C: u'Benefon Oyj',
   0x00170D: u'Dust Networks Inc.',
   0x00170E: u'Cisco Systems',
   0x00170F: u'Cisco Systems',
   0x001710: u'Casa Systems Inc.',
   0x001711: u'GE Healthcare Bio-Sciences AB',
   0x001712: u'ISCO International',
   0x001713: u'Tiger NetCom',
   0x001714: u'BR Controls Nederland bv',
   0x001715: u'Qstik',
   0x001716: u'Qno Technology Inc.',
   0x001717: u'Leica Geosystems AG',
   0x001718: u'Vansco Electronics Oy',
   0x001719: u'AudioCodes USA, Inc',
   0x00171A: u'Winegard Company',
   0x00171B: u'Innovation Lab Corp.',
   0x00171C: u'NT MicroSystems, Inc.',
   0x00171D: u'DIGIT',
   0x00171E: u'Theo Benning GmbH & Co. KG',
   0x00171F: u'IMV Corporation',
   0x001720: u'Image Sensing Systems, Inc.',
   0x001721: u'FITRE S.p.A.',
   0x001722: u'Hanazeder Electronic GmbH',
   0x001723: u'Summit Data Communications',
   0x001724: u'Studer Professional Audio GmbH',
   0x001725: u'Liquid Computing',
   0x001726: u'm2c Electronic Technology Ltd.',
   0x001727: u'Thermo Ramsey Italia s.r.l.',
   0x001728: u'Selex Communications',
   0x001729: u'Ubicod Co.LTD',
   0x00172A: u'Proware Technology Corp.',
   0x00172B: u'Global Technologies Inc.',
   0x00172C: u'TAEJIN INFOTECH',
   0x00172D: u'Axcen Photonics Corporation',
   0x00172E: u'FXC Inc.',
   0x00172F: u'NeuLion Incorporated',
   0x001730: u'Automation Electronics',
   0x001731: u'ASUSTek COMPUTER INC.',
   0x001732: u'Science-Technical Center "RISSA"',
   0x001733: u'neuf cegetel',
   0x001734: u'LGC Wireless Inc.',
   0x001735: u'PRIVATE',
   0x001736: u'iiTron Inc.',
   0x001737: u'Industrie Dial Face S.p.A.',
   0x001738: u'XIV',
   0x001739: u'Bright Headphone Electronics Company',
   0x00173A: u'Edge Integration Systems Inc.',
   0x00173B: u'Arched Rock Corporation',
   0x00173C: u'Extreme Engineering Solutions',
   0x00173D: u'Neology',
   0x00173E: u'LeucotronEquipamentos Ltda.',
   0x00173F: u'Belkin Corporation',
   0x001740: u'Technologies Labtronix',
   0x001741: u'DEFIDEV',
   0x001742: u'FUJITSU LIMITED',
   0x001743: u'Deck Srl',
   0x001744: u'Araneo Ltd.',
   0x001745: u'INNOTZ CO., Ltd',
   0x001746: u'Freedom9 Inc.',
   0x001747: u'Trimble',
   0x001748: u'Neokoros Brasil Ltda',
   0x001749: u'HYUNDAE YONG-O-SA CO.,LTD',
   0x00174A: u'SOCOMEC',
   0x00174B: u'Nokia Danmark A/S',
   0x00174C: u'Millipore',
   0x00174D: u'DYNAMIC NETWORK FACTORY, INC.',
   0x00174E: u'Parama-tech Co.,Ltd.',
   0x00174F: u'iCatch Inc.',
   0x001750: u'GSI Group, MicroE Systems',
   0x001751: u'Online Corporation',
   0x001752: u'DAGS, Inc',
   0x001753: u'nFore Technology Inc.',
   0x001754: u'Arkino Corporation., Ltd',
   0x001755: u'GE Security',
   0x001756: u'Vinci Labs Oy',
   0x001757: u'RIX TECHNOLOGY LIMITED',
   0x001758: u'ThruVision Ltd',
   0x001759: u'Cisco Systems',
   0x00175A: u'Cisco Systems',
   0x00175B: u'ACS Solutions Switzerland Ltd.',
   0x00175C: u'SHARP CORPORATION',
   0x00175D: u'Dongseo system.',
   0x00175E: u'Anta Systems, Inc.',
   0x00175F: u'XENOLINK Communications Co., Ltd.',
   0x001760: u'Naito Densei Machida MFG.CO.,LTD',
   0x001761: u'ZKSoftware Inc.',
   0x001762: u'Solar Technology, Inc.',
   0x001763: u'Essentia S.p.A.',
   0x001764: u'ATMedia GmbH',
   0x001765: u'Nortel',
   0x001766: u'Accense Technology, Inc.',
   0x001767: u'Earforce AS',
   0x001768: u'Zinwave Ltd',
   0x001769: u'Cymphonix Corp',
   0x00176A: u'Avago Technologies',
   0x00176B: u'Kiyon, Inc.',
   0x00176C: u'Pivot3, Inc.',
   0x00176D: u'CORE CORPORATION',
   0x00176E: u'DUCATI SISTEMI',
   0x00176F: u'PAX Computer Technology(Shenzhen) Ltd.',
   0x001770: u'Arti Industrial Electronics Ltd.',
   0x001771: u'APD Communications Ltd',
   0x001772: u'ASTRO Strobel Kommunikationssysteme GmbH',
   0x001773: u'Laketune Technologies Co. Ltd',
   0x001774: u'Elesta GmbH',
   0x001775: u'TTE Germany GmbH',
   0x001776: u'Meso Scale Diagnostics, LLC',
   0x001777: u'Obsidian Research Corporation',
   0x001778: u'Central Music Co.',
   0x001779: u'QuickTel',
   0x00177A: u'ASSA ABLOY AB',
   0x00177B: u'Azalea Networks inc',
   0x00177C: u'D-Link India Ltd',
   0x00177D: u'IDT International Limited',
   0x00177E: u'Meshcom Technologies Inc.',
   0x00177F: u'Worldsmart Retech',
   0x001780: u'Applera Holding B.V. Singapore Operations',
   0x001781: u'Greystone Data System, Inc.',
   0x001782: u'LoBenn Inc.',
   0x001783: u'Texas Instruments',
   0x001784: u'Motorola Mobile Devices',
   0x001785: u'Sparr Electronics Ltd',
   0x001786: u'wisembed',
   0x001787: u'Brother, Brother & Sons ApS',
   0x001788: u'Philips Lighting BV',
   0x001789: u'Zenitron Corporation',
   0x00178A: u'DARTS TECHNOLOGIES CORP.',
   0x00178B: u'Teledyne Technologies Incorporated',
   0x00178C: u'Independent Witness, Inc',
   0x00178D: u'Checkpoint Systems, Inc.',
   0x00178E: u'Gunnebo Cash Automation AB',
   0x00178F: u'NINGBO YIDONG ELECTRONIC CO.,LTD.',
   0x001790: u'HYUNDAI DIGITECH Co, Ltd.',
   0x001791: u'LinTech GmbH',
   0x001792: u'Falcom Wireless Comunications Gmbh',
   0x001793: u'Tigi Corporation',
   0x001794: u'Cisco Systems',
   0x001795: u'Cisco Systems',
   0x001796: u'Rittmeyer AG',
   0x001797: u'Telsy Elettronica S.p.A.',
   0x001798: u'Azonic Technology Co., LTD',
   0x001799: u'SmarTire Systems Inc.',
   0x00179A: u'D-Link Corporation',
   0x00179B: u'Chant Sincere CO., LTD.',
   0x00179C: u'DEPRAG SCHULZ GMBH u. CO.',
   0x00179D: u'Kelman Limited',
   0x00179E: u'Sirit Inc',
   0x00179F: u'Apricorn',
   0x0017A0: u'RoboTech srl',
   0x0017A1: u'3soft inc.',
   0x0017A2: u'Camrivox Ltd.',
   0x0017A3: u'MIX s.r.l.',
   0x0017A4: u'Global Data Services',
   0x0017A5: u'TrendChip Technologies Corp.',
   0x0017A6: u'YOSIN ELECTRONICS CO., LTD.',
   0x0017A7: u'Mobile Computing Promotion Consortium',
   0x0017A8: u'EDM Corporation',
   0x0017A9: u'Sentivision',
   0x0017AA: u'elab-experience inc.',
   0x0017AB: u'Nintendo Co., Ltd.',
   0x0017AC: u'O\'Neil Product Development Inc.',
   0x0017AD: u'AceNet Corporation',
   0x0017AE: u'GAI-Tronics',
   0x0017AF: u'Enermet',
   0x0017B0: u'Nokia Danmark A/S',
   0x0017B1: u'ACIST Medical Systems, Inc.',
   0x0017B2: u'SK Telesys',
   0x0017B3: u'Aftek Infosys Limited',
   0x0017B4: u'Remote Security Systems, LLC',
   0x0017B5: u'Peerless Systems Corporation',
   0x0017B6: u'Aquantia',
   0x0017B7: u'Tonze Technology Co.',
   0x0017B8: u'NOVATRON CO., LTD.',
   0x0017B9: u'Gambro Lundia AB',
   0x0017BA: u'SEDO CO., LTD.',
   0x0017BB: u'Syrinx Industrial Electronics',
   0x0017BC: u'Touchtunes Music Corporation',
   0x0017BD: u'Tibetsystem',
   0x0017BE: u'Tratec Telecom B.V.',
   0x0017BF: u'Coherent Research Limited',
   0x0017C0: u'PureTech Systems, Inc.',
   0x0017C1: u'CM Precision Technology LTD.',
   0x0017C2: u'Pirelli Broadband Solutions',
   0x0017C3: u'KTF Technologies Inc.',
   0x0017C4: u'Quanta Microsystems, INC.',
   0x0017C5: u'SonicWALL',
   0x0017C6: u'Labcal Technologies',
   0x0017C7: u'MARA Systems Consulting AB',
   0x0017C8: u'Kyocera Mita Corporation',
   0x0017C9: u'Samsung Electronics Co., Ltd.',
   0x0017CA: u'BenQ Corporation',
   0x0017CB: u'Juniper Networks',
   0x0017CC: u'Alcatel USA Sourcing LP',
   0x0017CD: u'CEC Wireless R&D Ltd.',
   0x0017CE: u'MB International Telecom Labs srl',
   0x0017CF: u'iMCA-GmbH',
   0x0017D0: u'Opticom Communications, LLC',
   0x0017D1: u'Nortel',
   0x0017D2: u'THINLINX PTY LTD',
   0x0017D3: u'Etymotic Research, Inc.',
   0x0017D4: u'Monsoon Multimedia, Inc',
   0x0017D5: u'Samsung Electronics Co., Ltd.',
   0x0017D6: u'Bluechips Microhouse Co.,Ltd.',
   0x0017D7: u'Input/Output Inc.',
   0x0017D8: u'Magnum Semiconductor, Inc.',
   0x0017D9: u'AAI Corporation',
   0x0017DA: u'Spans Logic',
   0x0017DB: u'PRIVATE',
   0x0017DC: u'DAEMYUNG ZERO1',
   0x0017DD: u'Clipsal Australia',
   0x0017DE: u'Advantage Six Ltd',
   0x0017DF: u'Cisco Systems',
   0x0017E0: u'Cisco Systems',
   0x0017E1: u'DACOS Technologies Co., Ltd.',
   0x0017E2: u'Motorola Mobile Devices',
   0x0017E3: u'Texas Instruments',
   0x0017E4: u'Texas Instruments',
   0x0017E5: u'Texas Instruments',
   0x0017E6: u'Texas Instruments',
   0x0017E7: u'Texas Instruments',
   0x0017E8: u'Texas Instruments',
   0x0017E9: u'Texas Instruments',
   0x0017EA: u'Texas Instruments',
   0x0017EB: u'Texas Instruments',
   0x0017EC: u'Texas Instruments',
   0x0017ED: u'WooJooIT Ltd.',
   0x0017EE: u'Motorola CHS',
   0x0017EF: u'Blade Network Technologies, Inc.',
   0x0017F0: u'SZCOM Broadband Network Technology Co.,Ltd',
   0x0017F1: u'Renu Electronics Pvt Ltd',
   0x0017F2: u'Apple Computer',
   0x0017F3: u'M/A-COM Wireless Systems',
   0x0017F4: u'ZERON ALLIANCE',
   0x0017F5: u'NEOPTEK',
   0x0017F6: u'Pyramid Meriden Inc.',
   0x0017F7: u'CEM Solutions Pvt Ltd',
   0x0017F8: u'Motech Industries Inc.',
   0x0017F9: u'Forcom Sp. z o.o.',
   0x0017FA: u'Microsoft Corporation',
   0x0017FB: u'FA',
   0x0017FC: u'Suprema Inc.',
   0x0017FD: u'Amulet Hotkey',
   0x0017FE: u'TALOS SYSTEM INC.',
   0x0017FF: u'PLAYLINE Co.,Ltd.',
   0x001800: u'UNIGRAND LTD',
   0x001801: u'Actiontec Electronics, Inc',
   0x001802: u'Alpha Networks Inc.',
   0x001803: u'ArcSoft Shanghai Co. LTD',
   0x001804: u'E-TEK DIGITAL TECHNOLOGY LIMITED',
   0x001805: u'Beijing InHand Networking',
   0x001806: u'Hokkei Industries Co., Ltd.',
   0x001807: u'Fanstel Corp.',
   0x001808: u'SightLogix, Inc.',
   0x001809: u'CRESYN',
   0x00180A: u'Meraki Networks, Inc.',
   0x00180B: u'Brilliant Telecommunications',
   0x00180C: u'Optelian Access Networks Corporation',
   0x00180D: u'Terabytes Server Storage Tech Corp',
   0x00180E: u'Avega Systems',
   0x00180F: u'Nokia Danmark A/S',
   0x001810: u'IPTrade S.A.',
   0x001811: u'Neuros Technology International, LLC.',
   0x001812: u'Beijing Xinwei Telecom Technology Co., Ltd.',
   0x001813: u'Sony Ericsson Mobile Communications',
   0x001814: u'Mitutoyo Corporation',
   0x001815: u'GZ Technologies, Inc.',
   0x001816: u'Ubixon Co., Ltd.',
   0x001817: u'D. E. Shaw Research, LLC',
   0x001818: u'Cisco Systems',
   0x001819: u'Cisco Systems',
   0x00181A: u'AVerMedia Technologies Inc.',
   0x00181B: u'TaiJin Metal Co., Ltd.',
   0x00181C: u'Exterity Limited',
   0x00181D: u'ASIA ELECTRONICS CO.,LTD',
   0x00181E: u'GDX Technologies Ltd.',
   0x00181F: u'Palmmicro Communications',
   0x001820: u'w5networks',
   0x001821: u'SINDORICOH',
   0x001822: u'CEC TELECOM CO.,LTD.',
   0x001823: u'Delta Electronics, Inc.',
   0x001824: u'Kimaldi Electronics, S.L.',
   0x001825: u'Wavion LTD',
   0x001826: u'Cale Access AB',
   0x001827: u'NEC PHILIPS UNIFIED SOLUTIONS NEDERLAND BV',
   0x001828: u'e2v technologies (UK) ltd.',
   0x001829: u'Gatsometer',
   0x00182A: u'Taiwan Video & Monitor',
   0x00182B: u'Softier',
   0x00182C: u'Ascend Networks, Inc.',
   0x00182D: u'Artec Group OÜ',
   0x00182E: u'Wireless Ventures USA',
   0x00182F: u'Texas Instruments',
   0x001830: u'Texas Instruments',
   0x001831: u'Texas Instruments',
   0x001832: u'Texas Instruments',
   0x001833: u'Texas Instruments',
   0x001834: u'Texas Instruments',
   0x001835: u'ITC',
   0x001836: u'Reliance Electric Limited',
   0x001837: u'Universal ABIT Co., Ltd.',
   0x001838: u'PanAccess Communications,Inc.',
   0x001839: u'Cisco-Linksys LLC',
   0x00183A: u'Westell Technologies',
   0x00183B: u'CENITS Co., Ltd.',
   0x00183C: u'Encore Software Limited',
   0x00183D: u'Vertex Link Corporation',
   0x00183E: u'Digilent, Inc',
   0x00183F: u'2Wire, Inc',
   0x001840: u'3 Phoenix, Inc.',
   0x001841: u'High Tech Computer Corp',
   0x001842: u'Nokia Danmark A/S',
   0x001843: u'Dawevision Ltd',
   0x001844: u'Heads Up Technologies, Inc.',
   0x001845: u'NPL Pulsar Ltd.',
   0x001846: u'Crypto S.A.',
   0x001847: u'AceNet Technology Inc.',
   0x001848: u'Vecima Networks Inc.',
   0x001849: u'Pigeon Point Systems',
   0x00184A: u'Catcher, Inc.',
   0x00184B: u'Las Vegas Gaming, Inc.',
   0x00184C: u'Bogen Communications',
   0x00184D: u'Netgear Inc.',
   0x00184E: u'Lianhe Technologies, Inc.',
   0x00184F: u'8 Ways Technology Corp.',
   0x001850: u'Secfone Kft',
   0x001851: u'SWsoft',
   0x001852: u'StorLink Semiconductors, Inc.',
   0x001853: u'Atera Networks LTD.',
   0x001854: u'Argard Co., Ltd',
   0x001855: u'Aeromaritime Systembau GmbH',
   0x001856: u'EyeFi, Inc',
   0x001857: u'Unilever R&D',
   0x001858: u'TagMaster AB',
   0x001859: u'Strawberry Linux Co.,Ltd.',
   0x00185A: u'uControl, Inc.',
   0x00185B: u'Network Chemistry, Inc',
   0x00185C: u'EDS Lab Pte Ltd',
   0x00185D: u'TAIGUEN TECHNOLOGY (SHEN-ZHEN) CO., LTD.',
   0x00185E: u'Nexterm Inc.',
   0x00185F: u'TAC Inc.',
   0x001860: u'SIM Technology Group Shanghai Simcom Ltd.,',
   0x001861: u'Ooma, Inc.',
   0x001862: u'Seagate Technology',
   0x001863: u'Veritech Electronics Limited',
   0x001864: u'Cybectec Inc.',
   0x001865: u'Bayer Diagnostics Sudbury Ltd',
   0x001866: u'Leutron Vision',
   0x001867: u'Evolution Robotics Retail',
   0x001868: u'Scientific Atlanta, A Cisco Company',
   0x001869: u'KINGJIM',
   0x00186A: u'Global Link Digital Technology Co,.LTD',
   0x00186B: u'Sambu Communics CO., LTD.',
   0x00186C: u'Neonode AB',
   0x00186D: u'Zhenjiang Sapphire Electronic Industry CO.',
   0x00186E: u'3COM Europe Ltd',
   0x00186F: u'Setha Industria Eletronica LTDA',
   0x001870: u'E28 Shanghai Limited',
   0x001871: u'Global Data Services',
   0x001872: u'Expertise Engineering',
   0x001873: u'Cisco Systems',
   0x001874: u'Cisco Systems',
   0x001875: u'AnaCise Testnology Pte Ltd',
   0x001876: u'WowWee Ltd.',
   0x001877: u'Amplex A/S',
   0x001878: u'Mackware GmbH',
   0x001879: u'dSys',
   0x00187A: u'Wiremold',
   0x00187B: u'4NSYS Co. Ltd.',
   0x00187C: u'INTERCROSS, LLC',
   0x00187D: u'Armorlink shanghai Co. Ltd',
   0x00187E: u'RGB Spectrum',
   0x00187F: u'ZODIANET',
   0x001880: u'Mobilygen',
   0x001881: u'Buyang Electronics Industrial Co., Ltd',
   0x001882: u'Huawei Technologies Co., Ltd.',
   0x001883: u'FORMOSA21 INC.',
   0x001884: u'FON',
   0x001885: u'Avigilon Corporation',
   0x001886: u'EL-TECH, INC.',
   0x001887: u'Metasystem SpA',
   0x001888: u'GOTIVE a.s.',
   0x001889: u'WinNet Solutions Limited',
   0x00188A: u'Infinova LLC',
   0x00188B: u'Dell',
   0x00188C: u'Mobile Action Technology Inc.',
   0x00188D: u'Nokia Danmark A/S',
   0x00188E: u'Ekahau, Inc.',
   0x00188F: u'Montgomery Technology, Inc.',
   0x001890: u'RadioCOM, s.r.o.',
   0x001891: u'Zhongshan General K-mate Electronics Co., Ltd',
   0x001892: u'ads-tec GmbH',
   0x001893: u'SHENZHEN PHOTON BROADBAND TECHNOLOGY CO.,LTD',
   0x001894: u'zimocom',
   0x001895: u'Hansun Technologies Inc.',
   0x001896: u'Great Well Electronic LTD',
   0x001897: u'JESS-LINK PRODUCTS Co., LTD',
   0x001898: u'KINGSTATE ELECTRONICS CORPORATION',
   0x001899: u'ShenZhen jieshun Science&Technology Industry CO,LTD.',
   0x00189A: u'HANA Micron Inc.',
   0x00189B: u'Thomson Inc.',
   0x00189C: u'Weldex Corporation',
   0x00189D: u'Navcast Inc.',
   0x00189E: u'OMNIKEY GmbH.',
   0x00189F: u'Lenntek Corporation',
   0x0018A0: u'Cierma Ascenseurs',
   0x0018A1: u'Tiqit Computers, Inc.',
   0x0018A2: u'XIP Technology AB',
   0x0018A3: u'ZIPPY TECHNOLOGY CORP.',
   0x0018A4: u'Motorola Mobile Devices',
   0x0018A5: u'ADigit Technologies Corp.',
   0x0018A6: u'Persistent Systems, LLC',
   0x0018A7: u'Yoggie Security Systems LTD.',
   0x0018A8: u'AnNeal Technology Inc.',
   0x0018A9: u'Ethernet Direct Corporation',
   0x0018AA: u'PRIVATE',
   0x0018AB: u'BEIJING LHWT MICROELECTRONICS INC.',
   0x0018AC: u'Shanghai Jiao Da HISYS Technology Co. Ltd.',
   0x0018AD: u'NIDEC SANKYO CORPORATION',
   0x0018AE: u'Tongwei Video Technology CO.,LTD',
   0x0018AF: u'Samsung Electronics Co., Ltd.',
   0x0018B0: u'Nortel',
   0x0018B1: u'Blade Network Technologies',
   0x0018B2: u'ADEUNIS RF',
   0x0018B3: u'TEC WizHome Co., Ltd.',
   0x0018B4: u'Dawon Media Inc.',
   0x0018B5: u'Magna Carta',
   0x0018B6: u'S3C, Inc.',
   0x0018B7: u'D3 LED, LLC',
   0x0018B8: u'New Voice International AG',
   0x0018B9: u'Cisco Systems',
   0x0018BA: u'Cisco Systems',
   0x0018BB: u'Eliwell Controls srl',
   0x0018BC: u'ZAO NVP Bolid',
   0x0018BD: u'SHENZHEN DVBWORLD TECHNOLOGY CO., LTD.',
   0x0018BE: u'ANSA Corporation',
   0x0018BF: u'Essence Technology Solution, Inc.',
   0x0018C0: u'Motorola CHS',
   0x0018C1: u'Almitec Informática e Comércio Ltda.',
   0x0018C2: u'Firetide, Inc',
   0x0018C3: u'C&S Microwave',
   0x0018C4: u'Raba Technologies LLC',
   0x0018C5: u'Nokia Danmark A/S',
   0x0018C6: u'OPW Fuel Management Systems',
   0x0018C7: u'Real Time Automation',
   0x0018C8: u'ISONAS Inc.',
   0x0018C9: u'EOps Technology Limited',
   0x0018CA: u'Viprinet GmbH',
   0x0018CB: u'Tecobest Technology Limited',
   0x0018CC: u'AXIOHM SAS',
   0x0018CD: u'Erae Electronics Industry Co., Ltd',
   0x0018CE: u'Dreamtech Co., Ltd',
   0x0018CF: u'Baldor Electric Company',
   0x0018D0: u'@ROAD Inc',
   0x0018D1: u'Siemens Home & Office Comm. Devices',
   0x0018D2: u'High-Gain Antennas LLC',
   0x0018D3: u'TEAMCAST',
   0x0018D4: u'Unified Display Interface SIG',
   0x0018D5: u'REIGNCOM',
   0x0018D6: u'Swirlnet A/S',
   0x0018D7: u'Javad Navigation Systems Inc.',
   0x0018D8: u'ARCH METER Corporation',
   0x0018D9: u'Santosha Internatonal, Inc',
   0x0018DA: u'AMBER wireless GmbH',
   0x0018DB: u'EPL Technology Ltd',
   0x0018DC: u'Prostar Co., Ltd.',
   0x0018DD: u'Silicondust Engineering Ltd',
   0x0018DE: u'Intel Corporation',
   0x0018DF: u'The Morey Corporation',
   0x0018E0: u'ANAVEO',
   0x0018E1: u'Verkerk Service Systemen',
   0x0018E2: u'Topdata Sistemas de Automacao Ltda',
   0x0018E3: u'Visualgate Systems, Inc.',
   0x0018E4: u'YIGUANG',
   0x0018E5: u'Adhoco AG',
   0x0018E6: u'Computer Hardware Design SIA',
   0x0018E7: u'Cameo Communications, INC.',
   0x0018E8: u'Hacetron Corporation',
   0x0018E9: u'Numata Corporation',
   0x0018EA: u'Alltec GmbH',
   0x0018EB: u'BroVis Wireless Networks',
   0x0018EC: u'Welding Technology Corporation',
   0x0018ED: u'ACCUTECH INTERNATIONAL CO., LTD.',
   0x0018EE: u'Videology Imaging Solutions, Inc.',
   0x0018EF: u'Escape Communications, Inc.',
   0x0018F0: u'JOYTOTO Co., Ltd.',
   0x0018F1: u'Chunichi Denshi Co.,LTD.',
   0x0018F2: u'Beijing Tianyu Communication Equipment Co., Ltd',
   0x0018F3: u'ASUSTek COMPUTER INC.',
   0x0018F4: u'EO TECHNICS Co., Ltd.',
   0x0018F5: u'Shenzhen Streaming Video Technology Company Limited',
   0x0018F6: u'Thomson Telecom Belgium',
   0x0018F7: u'Kameleon Technologies',
   0x0018F8: u'Cisco-Linksys LLC',
   0x0018F9: u'VVOND, Inc.',
   0x0018FA: u'Yushin Precision Equipment Co.,Ltd.',
   0x0018FB: u'Compro Technology',
   0x0018FC: u'Altec Electronic AG',
   0x0018FD: u'Optimal Technologies International Inc.',
   0x0018FE: u'Hewlett Packard',
   0x0018FF: u'PowerQuattro Co.',
   0x001900: u'Intelliverese - DBA Voicecom',
   0x001901: u'F1MEDIA',
   0x001902: u'Cambridge Consultants Ltd',
   0x001903: u'Bigfoot Networks Inc',
   0x001904: u'WB Electronics Sp. z o.o.',
   0x001905: u'SCHRACK Seconet AG',
   0x001906: u'Cisco Systems',
   0x001907: u'Cisco Systems',
   0x001908: u'Duaxes Corporation',
   0x001909: u'Devi A/S',
   0x00190A: u'HASWARE INC.',
   0x00190B: u'Southern Vision Systems, Inc.',
   0x00190C: u'Encore Electronics, Inc.',
   0x00190D: u'IEEE 1394c',
   0x00190E: u'Atech Technology Co., Ltd.',
   0x00190F: u'Advansus Corp.',
   0x001910: u'Knick Elektronische Messgeraete GmbH & Co. KG',
   0x001911: u'Just In Mobile Information Technologies (Shanghai) Co., Ltd.',
   0x001912: u'Welcat Inc',
   0x001913: u'Chuang-Yi Network Equipment Co.Ltd.',
   0x001914: u'Winix Co., Ltd',
   0x001915: u'TECOM Co., Ltd.',
   0x001916: u'PayTec AG',
   0x001917: u'Posiflex Inc.',
   0x001918: u'Interactive Wear AG',
   0x001919: u'ASTEL Inc.',
   0x00191A: u'IRLINK',
   0x00191B: u'Sputnik Engineering AG',
   0x00191C: u'Sensicast Systems',
   0x00191D: u'Nintendo Co.,Ltd.',
   0x00191E: u'Beyondwiz Co., Ltd.',
   0x00191F: u'Microlink communications Inc.',
   0x001920: u'KUME electric Co.,Ltd.',
   0x001921: u'Elitegroup Computer System Co.',
   0x001922: u'CM Comandos Lineares',
   0x001923: u'Phonex Korea Co., LTD.',
   0x001924: u'LBNL  Engineering',
   0x001925: u'Intelicis Corporation',
   0x001926: u'BitsGen Co., Ltd.',
   0x001927: u'ImCoSys Ltd',
   0x001928: u'Siemens AG, Transportation Systems',
   0x001929: u'2M2B Montadora de Maquinas Bahia Brasil LTDA',
   0x00192A: u'Antiope Associates',
   0x00192B: u'Hexagram, Inc.',
   0x00192C: u'Motorola Mobile Devices',
   0x00192D: u'Nokia Corporation',
   0x00192E: u'Spectral Instruments, Inc.',
   0x00192F: u'Cisco Systems',
   0x001930: u'Cisco Systems',
   0x001931: u'Balluff GmbH',
   0x001932: u'Gude Analog- und Digialsysteme GmbH',
   0x001933: u'Strix Systems, Inc.',
   0x001934: u'TRENDON TOUCH TECHNOLOGY CORP.',
   0x001935: u'Duerr Dental GmbH & Co. KG',
   0x001936: u'STERLITE OPTICAL TECHNOLOGIES LIMITED',
   0x001937: u'CommerceGuard AB',
   0x001938: u'UMB Communications Co., Ltd.',
   0x001939: u'Gigamips',
   0x00193A: u'OESOLUTIONS',
   0x00193B: u'Deliberant LLC',
   0x00193C: u'HighPoint Technologies Incorporated',
   0x00193D: u'GMC Guardian Mobility Corp.',
   0x00193E: u'PIRELLI BROADBAND SOLUTIONS',
   0x00193F: u'RDI technology(Shenzhen) Co.,LTD',
   0x001940: u'Rackable Systems',
   0x001941: u'Pitney Bowes, Inc',
   0x001942: u'ON SOFTWARE INTERNATIONAL LIMITED',
   0x001943: u'Belden',
   0x001944: u'Fossil Partners, L.P.',
   0x001945: u'Ten-Tec Inc.',
   0x001946: u'Cianet Industria e Comercio S/A',
   0x001947: u'Scientific Atlanta, A Cisco Company',
   0x001948: u'AireSpider Networks',
   0x001949: u'TENTEL  COMTECH CO., LTD.',
   0x00194A: u'TESTO AG',
   0x00194B: u'SAGEM COMMUNICATION',
   0x00194C: u'Fujian Stelcom information & Technology CO.,Ltd',
   0x00194D: u'Avago Technologies Sdn Bhd',
   0x00194E: u'Ultra Electronics - TCS (Tactical Communication Systems)',
   0x00194F: u'Nokia Danmark A/S',
   0x001950: u'Harman Multimedia',
   0x001951: u'NETCONS, s.r.o.',
   0x001952: u'ACOGITO Co., Ltd',
   0x001953: u'Chainleader Communications Corp.',
   0x001954: u'Leaf Corporation.',
   0x001955: u'Cisco Systems',
   0x001956: u'Cisco Systems',
   0x001957: u'Saafnet Canada Inc.',
   0x001958: u'Bluetooth SIG, Inc.',
   0x001959: u'Staccato Communications Inc.',
   0x00195A: u'Jenaer Antriebstechnik GmbH',
   0x00195B: u'D-Link Corporation',
   0x00195C: u'Innotech Corporation',
   0x00195D: u'ShenZhen XinHuaTong Opto Electronics Co.,Ltd',
   0x00195E: u'Motorola CHS',
   0x00195F: u'Valemount Networks Corporation',
   0x001960: u'DoCoMo Systems, Inc.',
   0x001961: u'Blaupunkt GmbH',
   0x001962: u'Commerciant, LP',
   0x001963: u'Sony Ericsson Mobile Communications AB',
   0x001964: u'Doorking Inc.',
   0x001965: u'YuHua TelTech (ShangHai) Co., Ltd.',
   0x001966: u'Asiarock Technology Limited',
   0x001967: u'TELDAT Sp.J.',
   0x001968: u'Digital Video Networks(Shanghai) CO. LTD.',
   0x001969: u'Nortel',
   0x00196A: u'MikroM GmbH',
   0x00196B: u'Danpex Corporation',
   0x00196C: u'ETROVISION TECHNOLOGY',
   0x00196D: u'Raybit Systems Korea, Inc',
   0x00196E: u'Metacom (Pty) Ltd.',
   0x00196F: u'SensoPart GmbH',
   0x001970: u'Z-Com, Inc.',
   0x001971: u'Guangzhou Unicomp Technology Co.,Ltd',
   0x001972: u'Plexus (Xiamen) Co.,ltd',
   0x001973: u'Zeugma Systems',
   0x001974: u'AboCom Systems, Inc.',
   0x001975: u'Beijing Huisen networks technology Inc',
   0x001976: u'Xipher Technologies, LLC',
   0x001977: u'Aerohive Networks, Inc.',
   0x001978: u'Datum Systems, Inc.',
   0x001979: u'Nokia Danmark A/S',
   0x00197A: u'MAZeT GmbH',
   0x00197B: u'Picotest Corp.',
   0x00197C: u'Riedel Communications GmbH',
   0x00197D: u'Hon Hai Precision Ind. Co., Ltd',
   0x00197E: u'Hon Hai Precision Ind. Co., Ltd',
   0x00197F: u'PLANTRONICS, INC.',
   0x001980: u'Gridpoint Systems',
   0x001981: u'Vivox Inc',
   0x001982: u'SmarDTV',
   0x001983: u'CCT R&D Limited',
   0x001984: u'ESTIC Corporation',
   0x001985: u'IT Watchdogs, Inc',
   0x001986: u'Cheng Hongjian',
   0x001987: u'Panasonic Mobile Communications Co., Ltd.',
   0x001988: u'Wi2Wi, Inc',
   0x001989: u'Sonitrol Corporation',
   0x00198A: u'Northrop Grumman Systems Corp.',
   0x00198B: u'Novera Optics Korea, Inc.',
   0x00198C: u'iXSea',
   0x00198D: u'Ocean Optics, Inc.',
   0x00198E: u'Oticon A/S',
   0x00198F: u'Alcatel Bell N.V.',
   0x001990: u'ELM DATA Co., Ltd.',
   0x001991: u'avinfo',
   0x001992: u'Bluesocket, Inc',
   0x001993: u'Changshu Switchgear MFG. Co.,Ltd. (Former Changshu Switchgea',
   0x001994: u'Jorjin technologies inc.',
   0x001995: u'Jurong Hi-Tech (Suzhou)Co.ltd',
   0x001996: u'TurboChef Technologies Inc.',
   0x001997: u'Soft Device Sdn Bhd',
   0x001998: u'SATO CORPORATION',
   0x001999: u'Fujitsu Siemens Computers',
   0x00199A: u'EDO-EVI',
   0x00199B: u'Diversified Technical Systems, Inc.',
   0x00199C: u'CTRING',
   0x00199D: u'V, Inc.',
   0x00199E: u'SHOWADENSHI ELECTRONICS,INC.',
   0x00199F: u'DKT A/S',
   0x0019A0: u'NIHON DATA SYSTENS, INC.',
   0x0019A1: u'LG INFORMATION & COMM.',
   0x0019A2: u'ORION TELE-EQUIPMENTS PVT LTD',
   0x0019A3: u'asteel electronique atlantique',
   0x0019A4: u'Austar Technology (hang zhou) Co.,Ltd',
   0x0019A5: u'RadarFind Corporation',
   0x0019A6: u'Motorola CHS',
   0x0019A7: u'ITU-T',
   0x0019A8: u'WiQuest Communications, Inc',
   0x0019A9: u'Cisco Systems',
   0x0019AA: u'Cisco Systems',
   0x0019AB: u'Raycom CO ., LTD',
   0x0019AC: u'GSP SYSTEMS Inc.',
   0x0019AD: u'BOBST SA',
   0x0019AE: u'Hopling Technologies b.v.',
   0x0019AF: u'Rigol Technologies, Inc.',
   0x0019B0: u'HanYang System',
   0x0019B1: u'Arrow7 Corporation',
   0x0019B2: u'XYnetsoft Co.,Ltd',
   0x0019B3: u'Stanford Research Systems',
   0x0019B4: u'VideoCast Ltd.',
   0x0019B5: u'Famar Fueguina S.A.',
   0x0019B6: u'Euro Emme s.r.l.',
   0x0019B7: u'Nokia Danmark A/S',
   0x0019B8: u'Boundary Devices',
   0x0019B9: u'Dell Inc.',
   0x0019BA: u'Paradox Security Systems Ltd',
   0x0019BB: u'Hewlett Packard',
   0x0019BC: u'ELECTRO CHANCE SRL',
   0x0019BD: u'New Media Life',
   0x0019BE: u'Altai Technologies Limited',
   0x0019BF: u'Citiway technology Co.,ltd',
   0x0019C0: u'Motorola Mobile Devices',
   0x0019C1: u'Alps Electric Co., Ltd',
   0x0019C2: u'Equustek Solutions, Inc.',
   0x0019C3: u'Qualitrol',
   0x0019C4: u'Infocrypt Inc.',
   0x0019C5: u'SONY Computer Entertainment inc,',
   0x0019C6: u'ZTE Corporation',
   0x0019C7: u'Cambridge Industries(Group) Co.,Ltd.',
   0x0019C8: u'AnyDATA Corporation',
   0x0019C9: u'S&C ELECTRIC COMPANY',
   0x0019CA: u'Broadata Communications, Inc',
   0x0019CB: u'ZyXEL Communications Corporation',
   0x0019CC: u'RCG (HK) Ltd',
   0x0019CD: u'Chengdu ethercom information technology Ltd.',
   0x0019CE: u'Progressive Gaming International',
   0x0019CF: u'SALICRU, S.A.',
   0x0019D0: u'Cathexis',
   0x0019D1: u'Intel Corporation',
   0x0019D2: u'Intel Corporation',
   0x0019D3: u'TRAK Microwave',
   0x0019D4: u'ICX Technologies',
   0x0019D5: u'IP Innovations, Inc.',
   0x0019D6: u'LS Cable Ltd.',
   0x0019D7: u'FORTUNETEK CO., LTD',
   0x0019D8: u'MAXFOR',
   0x0019D9: u'Zeutschel GmbH',
   0x0019DA: u'Welltrans O&E Technology Co. , Ltd.',
   0x0019DB: u'MICRO-STAR INTERNATIONAL CO., LTD.',
   0x0019DC: u'ENENSYS Technologies',
   0x0019DD: u'FEI-Zyfer, Inc.',
   0x0019DE: u'MOBITEK',
   0x0019DF: u'THOMSON APDG',
   0x0019E0: u'TP-LINK Technologies Co., Ltd.',
   0x0019E1: u'Nortel',
   0x0019E2: u'Juniper Networks',
   0x0019E3: u'Apple Computers',
   0x0019E4: u'2Wire, Inc',
   0x0019E5: u'Lynx Studio Technology, Inc.',
   0x0019E6: u'TOYO MEDIC CO.,LTD.',
   0x0019E7: u'Cisco Systems',
   0x0019E8: u'Cisco Systems',
   0x0019E9: u'S-Information Technolgy, Co., Ltd.',
   0x0019EA: u'TeraMage Technologies Co., Ltd.',
   0x0019EB: u'Pyronix Ltd',
   0x0019EC: u'Sagamore Systems, Inc.',
   0x0019ED: u'Axesstel Inc.',
   0x0019EE: u'CARLO GAVAZZI CONTROLS SPA-Controls Division',
   0x0019EF: u'SHENZHEN LINNKING ELECTRONICS CO.,LTD',
   0x0019F0: u'UNIONMAN TECHNOLOGY CO.,LTD',
   0x0019F1: u'Star Communication Network Technology Co.,Ltd',
   0x0019F2: u'Teradyne K.K.',
   0x0019F3: u'Telematrix, Inc',
   0x0019F4: u'Convergens Oy Ltd',
   0x0019F5: u'Imagination Technologies Ltd',
   0x0019F6: u'Acconet (PTE) Ltd',
   0x0019F7: u'Onset Computer Corporation',
   0x0019F8: u'Embedded Systems Design, Inc.',
   0x0019F9: u'Lambda',
   0x0019FA: u'Cable Vision Electronics CO., LTD.',
   0x0019FB: u'AMSTRAD PLC',
   0x0019FC: u'PT. Ufoakses Sukses Luarbiasa',
   0x0019FD: u'Nintendo Co., Ltd.',
   0x0019FE: u'SHENZHEN SEECOMM TECHNOLOGY CO.,LTD.',
   0x0019FF: u'Finnzymes',
   0x001A00: u'MATRIX INC.',
   0x001A01: u'Smiths Medical',
   0x001A02: u'SECURE CARE PRODUCTS, INC',
   0x001A03: u'Angel Electronics Co., Ltd.',
   0x001A04: u'Interay Solutions BV',
   0x001A05: u'OPTIBASE LTD',
   0x001A06: u'OpVista, Inc.',
   0x001A07: u'Arecont Vision',
   0x001A08: u'Dalman Technical Services',
   0x001A09: u'Wayfarer Transit Systems Ltd',
   0x001A0A: u'Adaptive Micro-Ware Inc.',
   0x001A0B: u'BONA TECHNOLOGY INC.',
   0x001A0C: u'Swe-Dish Satellite Systems AB',
   0x001A0D: u'HandHeld entertainment, Inc.',
   0x001A0E: u'Cheng Uei Precision Industry Co.,Ltd',
   0x001A0F: u'Sistemas Avanzados de Control, S.A.',
   0x001A10: u'LUCENT TRANS ELECTRONICS CO.,LTD',
   0x001A11: u'Google Inc.',
   0x001A12: u'PRIVATE',
   0x001A13: u'Wanlida Group Co., LTD',
   0x001A14: u'Xin Hua Control Engineering Co.,Ltd.',
   0x001A15: u'gemalto e-Payment',
   0x001A16: u'Nokia Danmark A/S',
   0x001A17: u'Teak Technologies, Inc.',
   0x001A18: u'Advanced Simulation Technology inc.',
   0x001A19: u'Computer Engineering Limited',
   0x001A1A: u'Gentex Corporation/Electro-Acoustic Products',
   0x001A1B: u'Motorola Mobile Devices',
   0x001A1C: u'GT&T Engineering Pte Ltd',
   0x001A1D: u'PChome Online Inc.',
   0x001A1E: u'Aruba Networks',
   0x001A1F: u'Coastal Environmental Systems',
   0x001A20: u'CMOTECH Co. Ltd.',
   0x001A21: u'Indac B.V.',
   0x001A22: u'eq-3 GmbH',
   0x001A23: u'Ice Qube, Inc',
   0x001A24: u'Galaxy Telecom Technologies Ltd',
   0x001A25: u'DELTA DORE',
   0x001A26: u'Deltanode Solutions AB',
   0x001A27: u'Ubistar',
   0x001A28: u'ASWT Co., LTD. Taiwan Branch H.K.',
   0x001A29: u'Techsonic Industries d/b/a Humminbird',
   0x001A2A: u'Arcadyan Technology Corporation',
   0x001A2B: u'Ayecom Technology Co., Ltd.',
   0x001A2C: u'SATEC Co.,LTD',
   0x001A2D: u'The Navvo Group',
   0x001A2E: u'Ziova Coporation',
   0x001A2F: u'Cisco Systems',
   0x001A30: u'Cisco Systems',
   0x001A31: u'SCAN COIN Industries AB',
   0x001A32: u'ACTIVA MULTIMEDIA',
   0x001A33: u'ASI Communications, Inc.',
   0x001A34: u'Konka Group Co., Ltd.',
   0x001A35: u'BARTEC GmbH',
   0x001A36: u'Actimon GmbH & Co. KG',
   0x001A37: u'Lear Corporation',
   0x001A38: u'SCI Technology',
   0x001A39: u'Merten GmbH&CoKG',
   0x001A3A: u'Dongahelecomm',
   0x001A3B: u'Doah Elecom Inc.',
   0x001A3C: u'Technowave Ltd.',
   0x001A3D: u'Ajin Vision Co.,Ltd',
   0x001A3E: u'Faster Technology LLC',
   0x001A3F: u'intelbras',
   0x001A40: u'A-FOUR TECH CO., LTD.',
   0x001A41: u'INOCOVA Co.,Ltd',
   0x001A42: u'Techcity Technology co., Ltd.',
   0x001A43: u'Logical Link Communications',
   0x001A44: u'JWTrading Co., Ltd',
   0x001A45: u'GN Netcom as',
   0x001A46: u'Digital Multimedia Technology Co., Ltd',
   0x001A47: u'Agami Systems, Inc.',
   0x001A48: u'Takacom Corporation',
   0x001A49: u'Micro Vision Co.,LTD',
   0x001A4A: u'Qumranet Inc.',
   0x001A4B: u'Hewlett Packard',
   0x001A4C: u'Crossbow Technology, Inc',
   0x001A4D: u'GIGABYTE TECHNOLOGY CO.,LTD.',
   0x001A4E: u'NTI AG / LinMot',
   0x001A4F: u'AVM GmbH',
   0x001A50: u'PheeNet Technology Corp.',
   0x001A51: u'Alfred Mann Foundation',
   0x001A52: u'Meshlinx Wireless Inc.',
   0x001A53: u'Zylaya',
   0x001A54: u'Hip Shing Electronics Ltd.',
   0x001A55: u'ACA-Digital Corporation',
   0x001A56: u'ViewTel Co,. Ltd.',
   0x001A57: u'Matrix Design Group, LLC',
   0x001A58: u'Celectronic GmbH',
   0x001A59: u'Ircona',
   0x001A5A: u'Korea Electric Power Data Network  (KDN) Co., Ltd',
   0x001A5B: u'NetCare Service Co., Ltd.',
   0x001A5C: u'Euchner GmbH+Co. KG',
   0x001A5D: u'Mobinnova Corp.',
   0x001A5E: u'Thincom Technology Co.,Ltd',
   0x001A5F: u'KitWorks.fi Ltd.',
   0x001A60: u'Wave Electronics Co.,Ltd.',
   0x001A61: u'PacStar Corp.',
   0x001A62: u'trusted data',
   0x001A63: u'Elster Electricity, LLC',
   0x001A64: u'IBM Corp.',
   0x001A65: u'Seluxit',
   0x001A66: u'Motorola CHS',
   0x001A67: u'Infinite QL Sdn Bhd',
   0x001A68: u'Weltec Enterprise Co., Ltd.',
   0x001A69: u'Wuhan Yangtze Optical Technology CO.,Ltd.',
   0x001A6A: u'Tranzas, Inc.',
   0x001A6B: u'USI',
   0x001A6C: u'Cisco Systems',
   0x001A6D: u'Cisco Systems',
   0x001A6E: u'Impro Technologies',
   0x001A6F: u'MI.TEL s.r.l.',
   0x001A70: u'Cisco-Linksys, LLC',
   0x001A71: u'Diostech Co., Ltd.',
   0x001A72: u'Mosart Semiconductor Corp.',
   0x001A73: u'Gemtek Technology Co., Ltd.',
   0x001A74: u'Procare International Co',
   0x001A75: u'Sony Ericsson Mobile Communications',
   0x001A76: u'SDT information Technology Co.,LTD.',
   0x001A77: u'Motorola Mobile Devices',
   0x001A78: u'ubtos',
   0x001A79: u'TELECOMUNICATION TECHNOLOGIES LTD.',
   0x001A7A: u'Lismore Instruments Limited',
   0x001A7B: u'Teleco, Inc.',
   0x001A7C: u'Hirschmann Automation and Control B.V.',
   0x001A7D: u'cyber-blue(HK)Ltd',
   0x001A7E: u'LN Srithai Comm Ltd.',
   0x001A7F: u'GCI Science&Technology Co.,Ltd.',
   0x001A80: u'Sony Corporation',
   0x001A81: u'Zelax',
   0x001A82: u'PROBA Building Automation Co.,LTD',
   0x001A83: u'Pegasus Technologies Inc.',
   0x001A84: u'V One Multimedia Pte Ltd',
   0x001A85: u'NV Michel Van de Wiele',
   0x001A86: u'AdvancedIO Systems Inc',
   0x001A87: u'Canhold International Limited',
   0x001A88: u'Venergy,Co,Ltd',
   0x001A89: u'Nokia Danmark A/S',
   0x001A8A: u'Samsung Electronics Co., Ltd.',
   0x001A8B: u'CHUNIL ELECTRIC IND., CO.',
   0x001A8C: u'Astaro AG',
   0x001A8D: u'AVECS Bergen GmbH',
   0x001A8E: u'3Way Networks Ltd',
   0x001A8F: u'Nortel',
   0x001A90: u'Trópico Sistemas e Telecomunicações da Amazônia LTDA.',
   0x001A91: u'FusionDynamic Ltd.',
   0x001A92: u'ASUSTek COMPUTER INC.',
   0x001A93: u'ERCO Leuchten GmbH',
   0x001A94: u'Votronic GmbH',
   0x001A95: u'Hisense Mobile Communications Technoligy Co.,Ltd.',
   0x001A96: u'ECLER S.A.',
   0x001A97: u'fitivision technology Inc.',
   0x001A98: u'Asotel Communication Limited Taiwan Branch',
   0x001A99: u'Smarty (HZ) Information Electronics Co., Ltd',
   0x001A9A: u'Skyworth Digital technology(shenzhen)co.ltd.',
   0x001A9B: u'ADEC & Parter AG',
   0x001A9C: u'RightHand Technologies, Inc.',
   0x001A9D: u'Skipper Wireless, Inc.',
   0x001A9E: u'ICON Digital International Limited',
   0x001A9F: u'A-Link Europe Ltd',
   0x001AA0: u'Dell Inc',
   0x001AA1: u'Cisco Systems',
   0x001AA2: u'Cisco Systems',
   0x001AA3: u'DELORME',
   0x001AA4: u'Future University-Hakodate',
   0x001AA5: u'BRN Phoenix',
   0x001AA6: u'Telefunken Radio Communication Systems GmbH &CO.KG',
   0x001AA7: u'Torian Wireless',
   0x001AA8: u'Mamiya Digital Imaging Co., Ltd.',
   0x001AA9: u'FUJIAN STAR-NET COMMUNICATION CO.,LTD',
   0x001AAA: u'Analogic Corp.',
   0x001AAB: u'eWings s.r.l.',
   0x001AAC: u'Corelatus AB',
   0x001AAD: u'Motorola CHS',
   0x001AAE: u'Savant Systems LLC',
   0x001AAF: u'BLUSENS TECHNOLOGY',
   0x001AB0: u'Signal Networks Pvt. Ltd.,',
   0x001AB1: u'Asia Pacific Satellite Industries Co., Ltd.',
   0x001AB2: u'Cyber Solutions Inc.',
   0x001AB3: u'VISIONITE INC.',
   0x001AB4: u'FFEI Ltd.',
   0x001AB5: u'Home Network System',
   0x001AB6: u'Luminary Micro Inc',
   0x001AB7: u'Ethos Networks LTD.',
   0x001AB8: u'Anseri Corporation',
   0x001AB9: u'PMC',
   0x001ABA: u'Caton Overseas Limited',
   0x001ABB: u'Fontal Technology Incorporation',
   0x001ABC: u'U4EA Technologies Ltd',
   0x001ABD: u'Impatica Inc.',
   0x001ABE: u'COMPUTER HI-TECH INC.',
   0x001ABF: u'TRUMPF Laser Marking Systems AG',
   0x001AC0: u'JOYBIEN TECHNOLOGIES CO., LTD.',
   0x001AC1: u'3COM EUROPE',
   0x001AC2: u'YEC Co.,Ltd.',
   0x001AC3: u'Scientific-Atlanta, Inc',
   0x001AC4: u'2Wire, Inc',
   0x001AC5: u'BreakingPoint Systems, Inc.',
   0x001AC6: u'Micro Control Designs',
   0x001AC7: u'UNIPOINT',
   0x001AC8: u'ISL (Instrumentation Scientifique de Laboratoire)',
   0x001AC9: u'SUZUKEN CO.,LTD',
   0x001ACA: u'Tilera Corporation',
   0x001ACB: u'Autocom Products Ltd',
   0x001ACC: u'Celestial Semiconductor, Ltd',
   0x001ACD: u'Tidel Engineering LP',
   0x001ACE: u'YUPITERU INDUSTRIES CO., LTD.',
   0x001ACF: u'C.T. ELETTRONICA',
   0x001AD0: u'Siemens Schweiz AG',
   0x001AD1: u'FARGO CO., LTD.',
   0x001AD2: u'Eletronica Nitron Ltda',
   0x001AD3: u'Vamp Ltd.',
   0x001AD4: u'iPOX Technology Co., Ltd.',
   0x001AD5: u'KMC CHAIN INDUSTRIAL CO., LTD.',
   0x001AD6: u'JIAGNSU AETNA ELECTRIC CO.,LTD',
   0x001AD7: u'Christie Digital Systems, Inc.',
   0x001AD8: u'AlsterAero GmbH',
   0x001AD9: u'International Broadband Electric Communications, Inc.',
   0x001ADA: u'Biz-2-Me Inc.',
   0x001ADB: u'Motorola Mobile Devices',
   0x001ADC: u'Nokia Danmark A/S',
   0x001ADD: u'PePWave Ltd',
   0x001ADE: u'Motorola CHS',
   0x001ADF: u'Interactivetv Pty Limited',
   0x001AE0: u'Mythology Tech Express Inc.',
   0x001AE1: u'EDGE ACCESS INC',
   0x001AE2: u'Cisco Systems',
   0x001AE3: u'Cisco Systems',
   0x001AE4: u'Liposonix Inc,',
   0x001AE5: u'Mvox Technologies Inc.',
   0x001AE6: u'Atlanta Advanced Communications Holdings Limited',
   0x001AE7: u'Aztek Networks, Inc.',
   0x001AE8: u'Siemens Enterprise Communications GmbH & Co. KG',
   0x001AE9: u'Nintendo Co., Ltd.',
   0x001AEA: u'Radio Terminal Systems Pty Ltd',
   0x001AEB: u'Allied Telesis K.K.',
   0x001AEC: u'Keumbee Electronics Co.,Ltd.',
   0x001AED: u'INCOTEC GmbH',
   0x001AEE: u'Shenztech Ltd',
   0x001AEF: u'Loopcomm Technology, Inc.',
   0x001AF0: u'Alcatel - IPD',
   0x001AF1: u'Embedded Artists AB',
   0x001AF2: u'Dynavisions GmbH',
   0x001AF3: u'Samyoung Electronics',
   0x001AF4: u'Handreamnet',
   0x001AF5: u'PENTAONE. CO., LTD.',
   0x001AF6: u'Woven Systems, Inc.',
   0x001AF7: u'dataschalt e+a GmbH',
   0x001AF8: u'Copley Controls Corporation',
   0x001AF9: u'AeroVIronment (AV Inc)',
   0x001AFA: u'Welch Allyn, Inc.',
   0x001AFB: u'Joby Inc.',
   0x001AFC: u'ModusLink Corporation',
   0x001AFD: u'EVOLIS',
   0x001AFE: u'SOFACREAL',
   0x001AFF: u'Wizyoung Tech.',
   0x001B00: u'Neopost Technologies',
   0x001B01: u'Applied Radio Technologies',
   0x001B02: u'ED Co.Ltd',
   0x001B03: u'Action Technology (SZ) Co., Ltd',
   0x001B04: u'Affinity International S.p.a',
   0x001B05: u'Young Media Concepts GmbH',
   0x001B06: u'Ateliers R. LAUMONIER',
   0x001B07: u'Mendocino Software',
   0x001B08: u'Danfoss Drives A/S',
   0x001B09: u'Matrix Telecom Pvt. Ltd.',
   0x001B0A: u'Intelligent Distributed Controls Ltd',
   0x001B0B: u'Phidgets Inc.',
   0x001B0C: u'Cisco Systems',
   0x001B0D: u'Cisco Systems',
   0x001B0E: u'InoTec GmbH Organisationssysteme',
   0x001B0F: u'Petratec',
   0x001B10: u'ShenZhen Kang Hui Technology Co.,ltd',
   0x001B11: u'D-Link Corporation',
   0x001B12: u'Apprion',
   0x001B13: u'Icron Technologies Corporation',
   0x001B14: u'Carex Lighting Equipment Factory',
   0x001B15: u'Voxtel, Inc.',
   0x001B16: u'Celtro Ltd.',
   0x001B17: u'Palo Alto Networks',
   0x001B18: u'Tsuken Electric Ind. Co.,Ltd',
   0x001B19: u'IEEE 1588 Standard',
   0x001B1A: u'e-trees Japan, Inc.',
   0x001B1B: u'Siemens AG, A&D AS EWK PU1',
   0x001B1C: u'Coherent',
   0x001B1D: u'Phoenix International Co., Ltd',
   0x001B1E: u'HART Communication Foundation',
   0x001B1F: u'DELTA - Danish Electronics, Light & Acoustics',
   0x001B20: u'TPine Technology',
   0x001B21: u'Intel Corporate',
   0x001B22: u'Palit Microsystems ( H.K.) Ltd.',
   0x001B23: u'SimpleComTools',
   0x001B24: u'Quanta Computer Inc.',
   0x001B25: u'Nortel',
   0x001B26: u'RON-Telecom ZAO',
   0x001B27: u'Merlin CSI',
   0x001B28: u'POLYGON, JSC',
   0x001B29: u'Avantis.Co.,Ltd',
   0x001B2A: u'Cisco Systems',
   0x001B2B: u'Cisco Systems',
   0x001B2C: u'ATRON electronic GmbH',
   0x001B2D: u'PRIVATE',
   0x001B2E: u'Sinkyo Electron Inc',
   0x001B2F: u'NETGEAR Inc.',
   0x001B30: u'Solitech Inc.',
   0x001B31: u'Neural Image. Co. Ltd.',
   0x001B32: u'QLogic Corporation',
   0x001B33: u'Nokia Danmark A/S',
   0x001B34: u'Focus System Inc.',
   0x001B35: u'ChongQing JINOU Science & Technology Development CO.,Ltd',
   0x001B36: u'Tsubata Engineering Co.,Ltd. (Head Office)',
   0x001B37: u'Computec Oy',
   0x001B38: u'COMPAL ELECTRONICS TECHNOLOGIC CO., LTD.',
   0x001B39: u'Proxicast',
   0x001B3A: u'SIMS Corp.',
   0x001B3B: u'Yi-Qing CO., LTD',
   0x001B3C: u'Software Technologies Group,Inc.',
   0x001B3D: u'EuroTel Spa',
   0x001B3E: u'Curtis, Inc.',
   0x001B3F: u'ProCurve Networking by HP',
   0x001B40: u'Network Automation mxc AB',
   0x001B41: u'General Infinity Co.,Ltd.',
   0x001B42: u'Wise & Blue',
   0x001B43: u'Beijing DG Telecommunications equipment Co.,Ltd',
   0x001B44: u'SanDisk Corporation',
   0x001B45: u'ABB AS, Division Automation Products',
   0x001B46: u'Blueone Technology Co.,Ltd',
   0x001B47: u'Futarque A/S',
   0x001B48: u'Shenzhen Lantech Electronics Co., Ltd.',
   0x001B49: u'Roberts Radio limited',
   0x001B4A: u'W&W Communications, Inc.',
   0x001B4B: u'SANION Co., Ltd.',
   0x001B4C: u'Signtech',
   0x001B4D: u'Areca Technology Corporation',
   0x001B4E: u'Navman New Zealand',
   0x001B4F: u'Avaya Inc.',
   0x001B50: u'Nizhny Novgorod Factory named after M.Frunze, FSUE (NZiF)',
   0x001B51: u'Vector Technology Corp.',
   0x001B52: u'Motorola Mobile Devices',
   0x001B53: u'Cisco Systems',
   0x001B54: u'Cisco Systems',
   0x001B55: u'Hurco Automation Ltd.',
   0x001B56: u'Tehuti Networks Ltd.',
   0x001B57: u'SEMINDIA SYSTEMS PRIVATE LIMITED',
   0x001B58: u'PRIVATE',
   0x001B59: u'Sony Ericsson Mobile Communications AB',
   0x001B5A: u'Apollo Imaging Technologies, Inc.',
   0x001B5B: u'2Wire, Inc.',
   0x001B5C: u'Azuretec Co., Ltd.',
   0x001B5D: u'Vololink Pty Ltd',
   0x001B5E: u'BPL Limited',
   0x001B5F: u'Alien Technology',
   0x001B60: u'NAVIGON AG',
   0x001B61: u'Digital Acoustics, LLC',
   0x001B62: u'JHT Optoelectronics Co.,Ltd.',
   0x001B63: u'Apple Inc.',
   0x001B64: u'IsaacLandKorea',
   0x001B65: u'China Gridcom Co., Ltd',
   0x001B66: u'Sennheiser electronic GmbH & Co. KG',
   0x001B67: u'Ubiquisys Ltd',
   0x001B68: u'Modnnet Co., Ltd',
   0x001B69: u'Equaline Corporation',
   0x001B6A: u'Powerwave UK Ltd',
   0x001B6B: u'Swyx Solutions AG',
   0x001B6C: u'LookX Digital Media BV',
   0x001B6D: u'Midtronics, Inc.',
   0x001B6E: u'Anue Systems, Inc.',
   0x001B6F: u'Teletrak Ltd',
   0x001B70: u'IRI Ubiteq, INC.',
   0x001B71: u'Telular Corp.',
   0x001B72: u'Sicep s.p.a.',
   0x001B73: u'DTL Broadcast Ltd',
   0x001B74: u'MiraLink Corporation',
   0x001B75: u'Hypermedia Systems',
   0x001B76: u'Ripcode, Inc.',
   0x001B77: u'Intel Corporate',
   0x001B78: u'Hewlett Packard',
   0x001B79: u'FAIVELEY TRANSPORT',
   0x001B7A: u'Nintendo Co., Ltd.',
   0x001B7B: u'The Tintometer Ltd',
   0x001B7C: u'A & R Cambridge',
   0x001B7D: u'CXR Anderson Jacobson',
   0x001B7E: u'Beckmann GmbH',
   0x001B7F: u'TMN Technologies Telecomunicacoes Ltda',
   0x001B80: u'LORD Corporation',
   0x001B81: u'DATAQ Instruments, Inc.',
   0x001B82: u'Taiwan Semiconductor Co., Ltd.',
   0x001B83: u'Finsoft Ltd',
   0x001B84: u'Scan Engineering Telecom',
   0x001B85: u'MAN Diesel A/S',
   0x001B86: u'Bosch Access Systems GmbH',
   0x001B87: u'Deepsound Tech. Co., Ltd',
   0x001B88: u'Divinet Access Technologies Ltd',
   0x001B89: u'EMZA Visual Sense Ltd.',
   0x001B8A: u'2M Electronic A/S',
   0x001B8B: u'NEC AccessTechnica,Ltd.',
   0x001B8C: u'JMicron Technology Corp.',
   0x001B8D: u'Electronic Computer Systems, Inc.',
   0x001B8E: u'Hulu Sweden AB',
   0x001B8F: u'Cisco Systems',
   0x001B90: u'Cisco Systems',
   0x001B91: u'EFKON AG',
   0x001B92: u'l-acoustics',
   0x001B93: u'JC Decaux SA DNT',
   0x001B94: u'T.E.M.A. S.p.A.',
   0x001B95: u'VIDEO SYSTEMS SRL',
   0x001B96: u'Snif Labs, Inc.',
   0x001B97: u'Violin Technologies',
   0x001B98: u'Samsung Electronics Co., Ltd.',
   0x001B99: u'KS System GmbH',
   0x001B9A: u'Apollo Fire Detectors Ltd',
   0x001B9B: u'Hose-McCann Communications',
   0x001B9C: u'SATEL sp. z o.o.',
   0x001B9D: u'Novus Security Sp. z o.o.',
   0x001B9E: u'ASKEY  COMPUTER  CORP',
   0x001B9F: u'Calyptech Pty Ltd',
   0x001BA0: u'Awox',
   0x001BA1: u'Åmic AB',
   0x001BA2: u'IDS Imaging Development Systems GmbH',
   0x001BA3: u'Flexit Group GmbH',
   0x001BA4: u'S.A.E Afikim',
   0x001BA5: u'MyungMin Systems, Inc.',
   0x001BA6: u'intotech inc.',
   0x001BA7: u'Lorica Solutions',
   0x001BA8: u'UBI&MOBI,.Inc',
   0x001BA9: u'BROTHER INDUSTRIES, LTD. Printing & Solutions Company',
   0x001BAA: u'XenICs nv',
   0x001BAB: u'Telchemy, Incorporated',
   0x001BAC: u'Curtiss Wright Controls Embedded Computing',
   0x001BAD: u'iControl Incorporated',
   0x001BAE: u'Micro Control Systems, Inc',
   0x001BAF: u'Nokia Danmark A/S',
   0x001BB0: u'BHARAT ELECTRONICS',
   0x001BB1: u'Wistron Neweb Corp.',
   0x001BB2: u'Intellect International NV',
   0x001BB3: u'Condalo GmbH',
   0x001BB4: u'Airvod Limited',
   0x001BB5: u'Cherry GmbH',
   0x001BB6: u'Bird Electronic Corp.',
   0x001BB7: u'Alta Heights Technology Corp.',
   0x001BB8: u'BLUEWAY ELECTRONIC CO;LTD',
   0x001BB9: u'Elitegroup Computer System Co.',
   0x001C7C: u'PERQ SYSTEMS CORPORATION',
   0x002000: u'LEXMARK INTERNATIONAL, INC.',
   0x002001: u'DSP SOLUTIONS, INC.',
   0x002002: u'SERITECH ENTERPRISE CO., LTD.',
   0x002003: u'PIXEL POWER LTD.',
   0x002004: u'YAMATAKE-HONEYWELL CO., LTD.',
   0x002005: u'SIMPLE TECHNOLOGY',
   0x002006: u'GARRETT COMMUNICATIONS, INC.',
   0x002007: u'SFA, INC.',
   0x002008: u'CABLE & COMPUTER TECHNOLOGY',
   0x002009: u'PACKARD BELL ELEC., INC.',
   0x00200A: u'SOURCE-COMM CORP.',
   0x00200B: u'OCTAGON SYSTEMS CORP.',
   0x00200C: u'ADASTRA SYSTEMS CORP.',
   0x00200D: u'CARL ZEISS',
   0x00200E: u'SATELLITE TECHNOLOGY MGMT, INC',
   0x00200F: u'TANBAC CO., LTD.',
   0x002010: u'JEOL SYSTEM TECHNOLOGY CO. LTD',
   0x002011: u'CANOPUS CO., LTD.',
   0x002012: u'CAMTRONICS MEDICAL SYSTEMS',
   0x002013: u'DIVERSIFIED TECHNOLOGY, INC.',
   0x002014: u'GLOBAL VIEW CO., LTD.',
   0x002015: u'ACTIS COMPUTER SA',
   0x002016: u'SHOWA ELECTRIC WIRE & CABLE CO',
   0x002017: u'ORBOTECH',
   0x002018: u'CIS TECHNOLOGY INC.',
   0x002019: u'OHLER GmbH',
   0x00201A: u'MRV Communications, Inc.',
   0x00201B: u'NORTHERN TELECOM/NETWORK',
   0x00201C: u'EXCEL, INC.',
   0x00201D: u'KATANA PRODUCTS',
   0x00201E: u'NETQUEST CORPORATION',
   0x00201F: u'BEST POWER TECHNOLOGY, INC.',
   0x002020: u'MEGATRON COMPUTER INDUSTRIES PTY, LTD.',
   0x002021: u'ALGORITHMS SOFTWARE PVT. LTD.',
   0x002022: u'NMS Communications',
   0x002023: u'T.C. TECHNOLOGIES PTY. LTD',
   0x002024: u'PACIFIC COMMUNICATION SCIENCES',
   0x002025: u'CONTROL TECHNOLOGY, INC.',
   0x002026: u'AMKLY SYSTEMS, INC.',
   0x002027: u'MING FORTUNE INDUSTRY CO., LTD',
   0x002028: u'WEST EGG SYSTEMS, INC.',
   0x002029: u'TELEPROCESSING PRODUCTS, INC.',
   0x00202A: u'N.V. DZINE',
   0x00202B: u'ADVANCED TELECOMMUNICATIONS MODULES, LTD.',
   0x00202C: u'WELLTRONIX CO., LTD.',
   0x00202D: u'TAIYO CORPORATION',
   0x00202E: u'DAYSTAR DIGITAL',
   0x00202F: u'ZETA COMMUNICATIONS, LTD.',
   0x002030: u'ANALOG & DIGITAL SYSTEMS',
   0x002031: u'ERTEC GmbH',
   0x002032: u'ALCATEL TAISEL',
   0x002033: u'SYNAPSE TECHNOLOGIES, INC.',
   0x002034: u'ROTEC INDUSTRIEAUTOMATION GMBH',
   0x002035: u'IBM CORPORATION',
   0x002036: u'BMC SOFTWARE',
   0x002037: u'SEAGATE TECHNOLOGY',
   0x002038: u'VME MICROSYSTEMS INTERNATIONAL CORPORATION',
   0x002039: u'SCINETS',
   0x00203A: u'DIGITAL BI0METRICS INC.',
   0x00203B: u'WISDM LTD.',
   0x00203C: u'EUROTIME AB',
   0x00203D: u'NOVAR ELECTRONICS CORPORATION',
   0x00203E: u'LogiCan Technologies, Inc.',
   0x00203F: u'JUKI CORPORATION',
   0x002040: u'Motorola Broadband Communications Sector',
   0x002041: u'DATA NET',
   0x002042: u'DATAMETRICS CORP.',
   0x002043: u'NEURON COMPANY LIMITED',
   0x002044: u'GENITECH PTY LTD',
   0x002045: u'ION Networks, Inc.',
   0x002046: u'CIPRICO, INC.',
   0x002047: u'STEINBRECHER CORP.',
   0x002048: u'Marconi Communications',
   0x002049: u'COMTRON, INC.',
   0x00204A: u'PRONET GMBH',
   0x00204B: u'AUTOCOMPUTER CO., LTD.',
   0x00204C: u'MITRON COMPUTER PTE LTD.',
   0x00204D: u'INOVIS GMBH',
   0x00204E: u'NETWORK SECURITY SYSTEMS, INC.',
   0x00204F: u'DEUTSCHE AEROSPACE AG',
   0x002050: u'KOREA COMPUTER INC.',
   0x002051: u'Verilink Corporation',
   0x002052: u'RAGULA SYSTEMS',
   0x002053: u'HUNTSVILLE MICROSYSTEMS, INC.',
   0x002054: u'EASTERN RESEARCH, INC.',
   0x002055: u'ALTECH CO., LTD.',
   0x002056: u'NEOPRODUCTS',
   0x002057: u'TITZE DATENTECHNIK GmbH',
   0x002058: u'ALLIED SIGNAL INC.',
   0x002059: u'MIRO COMPUTER PRODUCTS AG',
   0x00205A: u'COMPUTER IDENTICS',
   0x00205B: u'Kentrox, LLC',
   0x00205C: u'InterNet Systems of Florida, Inc.',
   0x00205D: u'NANOMATIC OY',
   0x00205E: u'CASTLE ROCK, INC.',
   0x00205F: u'GAMMADATA COMPUTER GMBH',
   0x002060: u'ALCATEL ITALIA S.p.A.',
   0x002061: u'DYNATECH COMMUNICATIONS, INC.',
   0x002062: u'SCORPION LOGIC, LTD.',
   0x002063: u'WIPRO INFOTECH LTD.',
   0x002064: u'PROTEC MICROSYSTEMS, INC.',
   0x002065: u'SUPERNET NETWORKING INC.',
   0x002066: u'GENERAL MAGIC, INC.',
   0x002067: u'PRIVATE',
   0x002068: u'ISDYNE',
   0x002069: u'ISDN SYSTEMS CORPORATION',
   0x00206A: u'OSAKA COMPUTER CORP.',
   0x00206B: u'KONICA MINOLTA HOLDINGS, INC.',
   0x00206C: u'EVERGREEN TECHNOLOGY CORP.',
   0x00206D: u'DATA RACE, INC.',
   0x00206E: u'XACT, INC.',
   0x00206F: u'FLOWPOINT CORPORATION',
   0x002070: u'HYNET, LTD.',
   0x002071: u'IBR GMBH',
   0x002072: u'WORKLINK INNOVATIONS',
   0x002073: u'FUSION SYSTEMS CORPORATION',
   0x002074: u'SUNGWOON SYSTEMS',
   0x002075: u'MOTOROLA COMMUNICATION ISRAEL',
   0x002076: u'REUDO CORPORATION',
   0x002077: u'KARDIOS SYSTEMS CORP.',
   0x002078: u'RUNTOP, INC.',
   0x002079: u'MIKRON GMBH',
   0x00207A: u'WiSE Communications, Inc.',
   0x00207B: u'Intel Corporation',
   0x00207C: u'AUTEC GmbH',
   0x00207D: u'ADVANCED COMPUTER APPLICATIONS',
   0x00207E: u'FINECOM Co., Ltd.',
   0x00207F: u'KYOEI SANGYO CO., LTD.',
   0x002080: u'SYNERGY (UK) LTD.',
   0x002081: u'TITAN ELECTRONICS',
   0x002082: u'ONEAC CORPORATION',
   0x002083: u'PRESTICOM INCORPORATED',
   0x002084: u'OCE PRINTING SYSTEMS, GMBH',
   0x002085: u'EXIDE ELECTRONICS',
   0x002086: u'MICROTECH ELECTRONICS LIMITED',
   0x002087: u'MEMOTEC COMMUNICATIONS CORP.',
   0x002088: u'GLOBAL VILLAGE COMMUNICATION',
   0x002089: u'T3PLUS NETWORKING, INC.',
   0x00208A: u'SONIX COMMUNICATIONS, LTD.',
   0x00208B: u'LAPIS TECHNOLOGIES, INC.',
   0x00208C: u'GALAXY NETWORKS, INC.',
   0x00208D: u'CMD TECHNOLOGY',
   0x00208E: u'CHEVIN SOFTWARE ENG. LTD.',
   0x00208F: u'ECI TELECOM LTD.',
   0x002090: u'ADVANCED COMPRESSION TECHNOLOGY, INC.',
   0x002091: u'J125, NATIONAL SECURITY AGENCY',
   0x002092: u'CHESS ENGINEERING B.V.',
   0x002093: u'LANDINGS TECHNOLOGY CORP.',
   0x002094: u'CUBIX CORPORATION',
   0x002095: u'RIVA ELECTRONICS',
   0x002096: u'Invensys',
   0x002097: u'APPLIED SIGNAL TECHNOLOGY',
   0x002098: u'HECTRONIC AB',
   0x002099: u'BON ELECTRIC CO., LTD.',
   0x00209A: u'THE 3DO COMPANY',
   0x00209B: u'ERSAT ELECTRONIC GMBH',
   0x00209C: u'PRIMARY ACCESS CORP.',
   0x00209D: u'LIPPERT AUTOMATIONSTECHNIK',
   0x00209E: u'BROWN\'S OPERATING SYSTEM SERVICES, LTD.',
   0x00209F: u'MERCURY COMPUTER SYSTEMS, INC.',
   0x0020A0: u'OA LABORATORY CO., LTD.',
   0x0020A1: u'DOVATRON',
   0x0020A2: u'GALCOM NETWORKING LTD.',
   0x0020A3: u'DIVICOM INC.',
   0x0020A4: u'MULTIPOINT NETWORKS',
   0x0020A5: u'API ENGINEERING',
   0x0020A6: u'PROXIM, INC.',
   0x0020A7: u'PAIRGAIN TECHNOLOGIES, INC.',
   0x0020A8: u'SAST TECHNOLOGY CORP.',
   0x0020A9: u'WHITE HORSE INDUSTRIAL',
   0x0020AA: u'DIGIMEDIA VISION LTD.',
   0x0020AB: u'MICRO INDUSTRIES CORP.',
   0x0020AC: u'INTERFLEX DATENSYSTEME GMBH',
   0x0020AD: u'LINQ SYSTEMS',
   0x0020AE: u'ORNET DATA COMMUNICATION TECH.',
   0x0020AF: u'3COM CORPORATION',
   0x0020B0: u'GATEWAY DEVICES, INC.',
   0x0020B1: u'COMTECH RESEARCH INC.',
   0x0020B2: u'GKD Gesellschaft Fur Kommunikation Und Datentechnik',
   0x0020B3: u'SCLTEC COMMUNICATIONS SYSTEMS',
   0x0020B4: u'TERMA ELEKTRONIK AS',
   0x0020B5: u'YASKAWA ELECTRIC CORPORATION',
   0x0020B6: u'AGILE NETWORKS, INC.',
   0x0020B7: u'NAMAQUA COMPUTERWARE',
   0x0020B8: u'PRIME OPTION, INC.',
   0x0020B9: u'METRICOM, INC.',
   0x0020BA: u'CENTER FOR HIGH PERFORMANCE',
   0x0020BB: u'ZAX CORPORATION',
   0x0020BC: u'Long Reach Networks Pty Ltd',
   0x0020BD: u'NIOBRARA R & D CORPORATION',
   0x0020BE: u'LAN ACCESS CORP.',
   0x0020BF: u'AEHR TEST SYSTEMS',
   0x0020C0: u'PULSE ELECTRONICS, INC.',
   0x0020C1: u'SAXA, Inc.',
   0x0020C2: u'TEXAS MEMORY SYSTEMS, INC.',
   0x0020C3: u'COUNTER SOLUTIONS LTD.',
   0x0020C4: u'INET,INC.',
   0x0020C5: u'EAGLE TECHNOLOGY',
   0x0020C6: u'NECTEC',
   0x0020C7: u'AKAI Professional M.I. Corp.',
   0x0020C8: u'LARSCOM INCORPORATED',
   0x0020C9: u'VICTRON BV',
   0x0020CA: u'DIGITAL OCEAN',
   0x0020CB: u'PRETEC ELECTRONICS CORP.',
   0x0020CC: u'DIGITAL SERVICES, LTD.',
   0x0020CD: u'HYBRID NETWORKS, INC.',
   0x0020CE: u'LOGICAL DESIGN GROUP, INC.',
   0x0020CF: u'TEST & MEASUREMENT SYSTEMS INC',
   0x0020D0: u'VERSALYNX CORPORATION',
   0x0020D1: u'MICROCOMPUTER SYSTEMS (M) SDN.',
   0x0020D2: u'RAD DATA COMMUNICATIONS, LTD.',
   0x0020D3: u'OST (OUEST STANDARD TELEMATIQU',
   0x0020D4: u'CABLETRON - ZEITTNET INC.',
   0x0020D5: u'VIPA GMBH',
   0x0020D6: u'BREEZECOM',
   0x0020D7: u'JAPAN MINICOMPUTER SYSTEMS CO., Ltd.',
   0x0020D8: u'Nortel Networks',
   0x0020D9: u'PANASONIC TECHNOLOGIES, INC./MIECO-US',
   0x0020DA: u'Alcatel North America ESD',
   0x0020DB: u'XNET TECHNOLOGY, INC.',
   0x0020DC: u'DENSITRON TAIWAN LTD.',
   0x0020DD: u'Cybertec Pty Ltd',
   0x0020DE: u'JAPAN DIGITAL LABORAT\'Y CO.LTD',
   0x0020DF: u'KYOSAN ELECTRIC MFG. CO., LTD.',
   0x0020E0: u'Actiontec Electronics, Inc.',
   0x0020E1: u'ALAMAR ELECTRONICS',
   0x0020E2: u'INFORMATION RESOURCE ENGINEERING',
   0x0020E3: u'MCD KENCOM CORPORATION',
   0x0020E4: u'HSING TECH ENTERPRISE CO., LTD',
   0x0020E5: u'APEX DATA, INC.',
   0x0020E6: u'LIDKOPING MACHINE TOOLS AB',
   0x0020E7: u'B&W NUCLEAR SERVICE COMPANY',
   0x0020E8: u'DATATREK CORPORATION',
   0x0020E9: u'DANTEL',
   0x0020EA: u'EFFICIENT NETWORKS, INC.',
   0x0020EB: u'CINCINNATI MICROWAVE, INC.',
   0x0020EC: u'TECHWARE SYSTEMS CORP.',
   0x0020ED: u'GIGA-BYTE TECHNOLOGY CO., LTD.',
   0x0020EE: u'GTECH CORPORATION',
   0x0020EF: u'USC CORPORATION',
   0x0020F0: u'UNIVERSAL MICROELECTRONICS CO.',
   0x0020F1: u'ALTOS INDIA LIMITED',
   0x0020F2: u'SUN MICROSYSTEMS, INC.',
   0x0020F3: u'RAYNET CORPORATION',
   0x0020F4: u'SPECTRIX CORPORATION',
   0x0020F5: u'PANDATEL AG',
   0x0020F6: u'NET TEK  AND KARLNET, INC.',
   0x0020F7: u'CYBERDATA',
   0x0020F8: u'CARRERA COMPUTERS, INC.',
   0x0020F9: u'PARALINK NETWORKS, INC.',
   0x0020FA: u'GDE SYSTEMS, INC.',
   0x0020FB: u'OCTEL COMMUNICATIONS CORP.',
   0x0020FC: u'MATROX',
   0x0020FD: u'ITV TECHNOLOGIES, INC.',
   0x0020FE: u'TOPWARE INC. / GRAND COMPUTER',
   0x0020FF: u'SYMMETRICAL TECHNOLOGIES',
   0x002654: u'3Com Corporation',
   0x003000: u'ALLWELL TECHNOLOGY CORP.',
   0x003001: u'SMP',
   0x003002: u'Expand Networks',
   0x003003: u'Phasys Ltd.',
   0x003004: u'LEADTEK RESEARCH INC.',
   0x003005: u'Fujitsu Siemens Computers',
   0x003006: u'SUPERPOWER COMPUTER',
   0x003007: u'OPTI, INC.',
   0x003008: u'AVIO DIGITAL, INC.',
   0x003009: u'Tachion Networks, Inc.',
   0x00300A: u'AZTECH SYSTEMS LTD.',
   0x00300B: u'mPHASE Technologies, Inc.',
   0x00300C: u'CONGRUENCY, LTD.',
   0x00300D: u'MMC Technology, Inc.',
   0x00300E: u'Klotz Digital AG',
   0x00300F: u'IMT - Information Management T',
   0x003010: u'VISIONETICS INTERNATIONAL',
   0x003011: u'HMS FIELDBUS SYSTEMS AB',
   0x003012: u'DIGITAL ENGINEERING LTD.',
   0x003013: u'NEC Corporation',
   0x003014: u'DIVIO, INC.',
   0x003015: u'CP CLARE CORP.',
   0x003016: u'ISHIDA CO., LTD.',
   0x003017: u'BlueArc UK Ltd',
   0x003018: u'Jetway Information Co., Ltd.',
   0x003019: u'CISCO SYSTEMS, INC.',
   0x00301A: u'SMARTBRIDGES PTE. LTD.',
   0x00301B: u'SHUTTLE, INC.',
   0x00301C: u'ALTVATER AIRDATA SYSTEMS',
   0x00301D: u'SKYSTREAM, INC.',
   0x00301E: u'3COM Europe Ltd.',
   0x00301F: u'OPTICAL NETWORKS, INC.',
   0x003020: u'TSI, Inc..',
   0x003021: u'HSING TECH. ENTERPRISE CO.,LTD',
   0x003022: u'Fong Kai Industrial Co., Ltd.',
   0x003023: u'COGENT COMPUTER SYSTEMS, INC.',
   0x003024: u'CISCO SYSTEMS, INC.',
   0x003025: u'CHECKOUT COMPUTER SYSTEMS, LTD',
   0x003026: u'HeiTel Digital Video GmbH',
   0x003027: u'KERBANGO, INC.',
   0x003028: u'FASE Saldatura srl',
   0x003029: u'OPICOM',
   0x00302A: u'SOUTHERN INFORMATION',
   0x00302B: u'INALP NETWORKS, INC.',
   0x00302C: u'SYLANTRO SYSTEMS CORPORATION',
   0x00302D: u'QUANTUM BRIDGE COMMUNICATIONS',
   0x00302E: u'Hoft & Wessel AG',
   0x00302F: u'Smiths Industries',
   0x003030: u'HARMONIX CORPORATION',
   0x003031: u'LIGHTWAVE COMMUNICATIONS, INC.',
   0x003032: u'MagicRam, Inc.',
   0x003033: u'ORIENT TELECOM CO., LTD.',
   0x003034: u'SET ENGINEERING',
   0x003035: u'Corning Incorporated',
   0x003036: u'RMP ELEKTRONIKSYSTEME GMBH',
   0x003037: u'Packard Bell Nec Services',
   0x003038: u'XCP, INC.',
   0x003039: u'SOFTBOOK PRESS',
   0x00303A: u'MAATEL',
   0x00303B: u'PowerCom Technology',
   0x00303C: u'ONNTO CORP.',
   0x00303D: u'IVA CORPORATION',
   0x00303E: u'Radcom Ltd.',
   0x00303F: u'TurboComm Tech Inc.',
   0x003040: u'CISCO SYSTEMS, INC.',
   0x003041: u'SAEJIN T & M CO., LTD.',
   0x003042: u'DeTeWe-Deutsche Telephonwerke',
   0x003043: u'IDREAM TECHNOLOGIES, PTE. LTD.',
   0x003044: u'Portsmith LLC',
   0x003045: u'Village Networks, Inc. (VNI)',
   0x003046: u'Controlled Electronic Manageme',
   0x003047: u'NISSEI ELECTRIC CO., LTD.',
   0x003048: u'Supermicro Computer, Inc.',
   0x003049: u'BRYANT TECHNOLOGY, LTD.',
   0x00304A: u'Fraunhofer IPMS',
   0x00304B: u'ORBACOM SYSTEMS, INC.',
   0x00304C: u'APPIAN COMMUNICATIONS, INC.',
   0x00304D: u'ESI',
   0x00304E: u'BUSTEC PRODUCTION LTD.',
   0x00304F: u'PLANET Technology Corporation',
   0x003050: u'Versa Technology',
   0x003051: u'ORBIT AVIONIC & COMMUNICATION',
   0x003052: u'ELASTIC NETWORKS',
   0x003053: u'Basler AG',
   0x003054: u'CASTLENET TECHNOLOGY, INC.',
   0x003055: u'Hitachi Semiconductor America,',
   0x003056: u'Beck IPC GmbH',
   0x003057: u'QTelNet, Inc.',
   0x003058: u'API MOTION',
   0x003059: u'DIGITAL-LOGIC AG',
   0x00305A: u'TELGEN CORPORATION',
   0x00305B: u'MODULE DEPARTMENT',
   0x00305C: u'SMAR Laboratories Corp.',
   0x00305D: u'DIGITRA SYSTEMS, INC.',
   0x00305E: u'Abelko Innovation',
   0x00305F: u'IMACON APS',
   0x003060: u'Powerfile, Inc.',
   0x003061: u'MobyTEL',
   0x003062: u'PATH 1 NETWORK TECHNOL\'S INC.',
   0x003063: u'SANTERA SYSTEMS, INC.',
   0x003064: u'ADLINK TECHNOLOGY, INC.',
   0x003065: u'APPLE COMPUTER, INC.',
   0x003066: u'DIGITAL WIRELESS CORPORATION',
   0x003067: u'BIOSTAR MICROTECH INT\'L CORP.',
   0x003068: u'CYBERNETICS TECH. CO., LTD.',
   0x003069: u'IMPACCT TECHNOLOGY CORP.',
   0x00306A: u'PENTA MEDIA CO., LTD.',
   0x00306B: u'CMOS SYSTEMS, INC.',
   0x00306C: u'Hitex Holding GmbH',
   0x00306D: u'LUCENT TECHNOLOGIES',
   0x00306E: u'HEWLETT PACKARD',
   0x00306F: u'SEYEON TECH. CO., LTD.',
   0x003070: u'1Net Corporation',
   0x003071: u'Cisco Systems, Inc.',
   0x003072: u'INTELLIBYTE INC.',
   0x003073: u'International Microsystems, In',
   0x003074: u'EQUIINET LTD.',
   0x003075: u'ADTECH',
   0x003076: u'Akamba Corporation',
   0x003077: u'ONPREM NETWORKS',
   0x003078: u'Cisco Systems, Inc.',
   0x003079: u'CQOS, INC.',
   0x00307A: u'Advanced Technology & Systems',
   0x00307B: u'Cisco Systems, Inc.',
   0x00307C: u'ADID SA',
   0x00307D: u'GRE AMERICA, INC.',
   0x00307E: u'Redflex Communication Systems',
   0x00307F: u'IRLAN LTD.',
   0x003080: u'CISCO SYSTEMS, INC.',
   0x003081: u'ALTOS C&C',
   0x003082: u'TAIHAN ELECTRIC WIRE CO., LTD.',
   0x003083: u'Ivron Systems',
   0x003084: u'ALLIED TELESYN INTERNAIONAL',
   0x003085: u'CISCO SYSTEMS, INC.',
   0x003086: u'Transistor Devices, Inc.',
   0x003087: u'VEGA GRIESHABER KG',
   0x003088: u'Siara Systems, Inc.',
   0x003089: u'Spectrapoint Wireless, LLC',
   0x00308A: u'NICOTRA SISTEMI S.P.A',
   0x00308B: u'Brix Networks',
   0x00308C: u'ADVANCED DIGITAL INFORMATION',
   0x00308D: u'PINNACLE SYSTEMS, INC.',
   0x00308E: u'CROSS MATCH TECHNOLOGIES, INC.',
   0x00308F: u'MICRILOR, Inc.',
   0x003090: u'CYRA TECHNOLOGIES, INC.',
   0x003091: u'TAIWAN FIRST LINE ELEC. CORP.',
   0x003092: u'ModuNORM GmbH',
   0x003093: u'SONNET TECHNOLOGIES, INC.',
   0x003094: u'Cisco Systems, Inc.',
   0x003095: u'Procomp Informatics, Ltd.',
   0x003096: u'CISCO SYSTEMS, INC.',
   0x003097: u'EXOMATIC AB',
   0x003098: u'Global Converging Technologies',
   0x003099: u'BOENIG UND KALLENBACH OHG',
   0x00309A: u'ASTRO TERRA CORP.',
   0x00309B: u'Smartware',
   0x00309C: u'Timing Applications, Inc.',
   0x00309D: u'Nimble Microsystems, Inc.',
   0x00309E: u'WORKBIT CORPORATION.',
   0x00309F: u'AMBER NETWORKS',
   0x0030A0: u'TYCO SUBMARINE SYSTEMS, LTD.',
   0x0030A1: u'WEBGATE Inc.',
   0x0030A2: u'Lightner Engineering',
   0x0030A3: u'CISCO SYSTEMS, INC.',
   0x0030A4: u'Woodwind Communications System',
   0x0030A5: u'ACTIVE POWER',
   0x0030A6: u'VIANET TECHNOLOGIES, LTD.',
   0x0030A7: u'SCHWEITZER ENGINEERING',
   0x0030A8: u'OL\'E COMMUNICATIONS, INC.',
   0x0030A9: u'Netiverse, Inc.',
   0x0030AA: u'AXUS MICROSYSTEMS, INC.',
   0x0030AB: u'DELTA NETWORKS, INC.',
   0x0030AC: u'Systeme Lauer GmbH & Co., Ltd.',
   0x0030AD: u'SHANGHAI COMMUNICATION',
   0x0030AE: u'Times N System, Inc.',
   0x0030AF: u'Honeywell GmbH',
   0x0030B0: u'Convergenet Technologies',
   0x0030B1: u'aXess-pro networks GmbH',
   0x0030B2: u'L-3 Sonoma EO',
   0x0030B3: u'San Valley Systems, Inc.',
   0x0030B4: u'INTERSIL CORP.',
   0x0030B5: u'Tadiran Microwave Networks',
   0x0030B6: u'CISCO SYSTEMS, INC.',
   0x0030B7: u'Teletrol Systems, Inc.',
   0x0030B8: u'RiverDelta Networks',
   0x0030B9: u'ECTEL',
   0x0030BA: u'AC&T SYSTEM CO., LTD.',
   0x0030BB: u'CacheFlow, Inc.',
   0x0030BC: u'Optronic AG',
   0x0030BD: u'BELKIN COMPONENTS',
   0x0030BE: u'City-Net Technology, Inc.',
   0x0030BF: u'MULTIDATA GMBH',
   0x0030C0: u'Lara Technology, Inc.',
   0x0030C1: u'HEWLETT-PACKARD',
   0x0030C2: u'COMONE',
   0x0030C3: u'FLUECKIGER ELEKTRONIK AG',
   0x0030C4: u'Canon Imaging System Technologies, Inc.',
   0x0030C5: u'CADENCE DESIGN SYSTEMS',
   0x0030C6: u'CONTROL SOLUTIONS, INC.',
   0x0030C7: u'MACROMATE CORP.',
   0x0030C8: u'GAD LINE, LTD.',
   0x0030C9: u'LuxN, N',
   0x0030CA: u'Discovery Com',
   0x0030CB: u'OMNI FLOW COMPUTERS, INC.',
   0x0030CC: u'Tenor Networks, Inc.',
   0x0030CD: u'CONEXANT SYSTEMS, INC.',
   0x0030CE: u'Zaffire',
   0x0030CF: u'TWO TECHNOLOGIES, INC.',
   0x0030D0: u'Tellabs',
   0x0030D1: u'INOVA CORPORATION',
   0x0030D2: u'WIN TECHNOLOGIES, CO., LTD.',
   0x0030D3: u'Agilent Technologies',
   0x0030D4: u'AAE Systems, Inc',
   0x0030D5: u'DResearch GmbH',
   0x0030D6: u'MSC VERTRIEBS GMBH',
   0x0030D7: u'Innovative Systems, L.L.C.',
   0x0030D8: u'SITEK',
   0x0030D9: u'DATACORE SOFTWARE CORP.',
   0x0030DA: u'COMTREND CO.',
   0x0030DB: u'Mindready Solutions, Inc.',
   0x0030DC: u'RIGHTECH CORPORATION',
   0x0030DD: u'INDIGITA CORPORATION',
   0x0030DE: u'WAGO Kontakttechnik GmbH',
   0x0030DF: u'KB/TEL TELECOMUNICACIONES',
   0x0030E0: u'OXFORD SEMICONDUCTOR LTD.',
   0x0030E1: u'ACROTRON SYSTEMS, INC.',
   0x0030E2: u'GARNET SYSTEMS CO., LTD.',
   0x0030E3: u'SEDONA NETWORKS CORP.',
   0x0030E4: u'CHIYODA SYSTEM RIKEN',
   0x0030E5: u'Amper Datos S.A.',
   0x0030E6: u'Draeger Medical Systems, Inc.',
   0x0030E7: u'CNF MOBILE SOLUTIONS, INC.',
   0x0030E8: u'ENSIM CORP.',
   0x0030E9: u'GMA COMMUNICATION MANUFACT\'G',
   0x0030EA: u'TeraForce Technology Corporation',
   0x0030EB: u'TURBONET COMMUNICATIONS, INC.',
   0x0030EC: u'BORGARDT',
   0x0030ED: u'Expert Magnetics Corp.',
   0x0030EE: u'DSG Technology, Inc.',
   0x0030EF: u'NEON TECHNOLOGY, INC.',
   0x0030F0: u'Uniform Industrial Corp.',
   0x0030F1: u'Accton Technology Corp.',
   0x0030F2: u'CISCO SYSTEMS, INC.',
   0x0030F3: u'At Work Computers',
   0x0030F4: u'STARDOT TECHNOLOGIES',
   0x0030F5: u'Wild Lab. Ltd.',
   0x0030F6: u'SECURELOGIX CORPORATION',
   0x0030F7: u'RAMIX INC.',
   0x0030F8: u'Dynapro Systems, Inc.',
   0x0030F9: u'Sollae Systems Co., Ltd.',
   0x0030FA: u'TELICA, INC.',
   0x0030FB: u'AZS Technology AG',
   0x0030FC: u'Terawave Communications, Inc.',
   0x0030FD: u'INTEGRATED SYSTEMS DESIGN',
   0x0030FE: u'DSA GmbH',
   0x0030FF: u'DATAFAB SYSTEMS, INC.',
   0x004000: u'PCI COMPONENTES DA AMZONIA LTD',
   0x004001: u'ZYXEL COMMUNICATIONS, INC.',
   0x004002: u'PERLE SYSTEMS LIMITED',
   0x004003: u'Emerson Process Management Power & Water Solutions, Inc.',
   0x004004: u'ICM CO. LTD.',
   0x004005: u'ANI COMMUNICATIONS INC.',
   0x004006: u'SAMPO TECHNOLOGY CORPORATION',
   0x004007: u'TELMAT INFORMATIQUE',
   0x004008: u'A PLUS INFO CORPORATION',
   0x004009: u'TACHIBANA TECTRON CO., LTD.',
   0x00400A: u'PIVOTAL TECHNOLOGIES, INC.',
   0x00400B: u'CISCO SYSTEMS, INC.',
   0x00400C: u'GENERAL MICRO SYSTEMS, INC.',
   0x00400D: u'LANNET DATA COMMUNICATIONS,LTD',
   0x00400E: u'MEMOTEC COMMUNICATIONS, INC.',
   0x00400F: u'DATACOM TECHNOLOGIES',
   0x004010: u'SONIC SYSTEMS, INC.',
   0x004011: u'ANDOVER CONTROLS CORPORATION',
   0x004012: u'WINDATA, INC.',
   0x004013: u'NTT DATA COMM. SYSTEMS CORP.',
   0x004014: u'COMSOFT GMBH',
   0x004015: u'ASCOM INFRASYS AG',
   0x004016: u'HADAX ELECTRONICS, INC.',
   0x004017: u'Silex Technology America',
   0x004018: u'ADOBE SYSTEMS, INC.',
   0x004019: u'AEON SYSTEMS, INC.',
   0x00401A: u'FUJI ELECTRIC CO., LTD.',
   0x00401B: u'PRINTER SYSTEMS CORP.',
   0x00401C: u'AST RESEARCH, INC.',
   0x00401D: u'INVISIBLE SOFTWARE, INC.',
   0x00401E: u'ICC',
   0x00401F: u'COLORGRAPH LTD',
   0x004020: u'PINACL COMMUNICATION',
   0x004021: u'RASTER GRAPHICS',
   0x004022: u'KLEVER COMPUTERS, INC.',
   0x004023: u'LOGIC CORPORATION',
   0x004024: u'COMPAC INC.',
   0x004025: u'MOLECULAR DYNAMICS',
   0x004026: u'MELCO, INC.',
   0x004027: u'SMC MASSACHUSETTS, INC.',
   0x004028: u'NETCOMM LIMITED',
   0x004029: u'COMPEX',
   0x00402A: u'CANOGA-PERKINS',
   0x00402B: u'TRIGEM COMPUTER, INC.',
   0x00402C: u'ISIS DISTRIBUTED SYSTEMS, INC.',
   0x00402D: u'HARRIS ADACOM CORPORATION',
   0x00402E: u'PRECISION SOFTWARE, INC.',
   0x00402F: u'XLNT DESIGNS INC.',
   0x004030: u'GK COMPUTER',
   0x004031: u'KOKUSAI ELECTRIC CO., LTD',
   0x004032: u'DIGITAL COMMUNICATIONS',
   0x004033: u'ADDTRON TECHNOLOGY CO., LTD.',
   0x004034: u'BUSTEK CORPORATION',
   0x004035: u'OPCOM',
   0x004036: u'TRIBE COMPUTER WORKS, INC.',
   0x004037: u'SEA-ILAN, INC.',
   0x004038: u'TALENT ELECTRIC INCORPORATED',
   0x004039: u'OPTEC DAIICHI DENKO CO., LTD.',
   0x00403A: u'IMPACT TECHNOLOGIES',
   0x00403B: u'SYNERJET INTERNATIONAL CORP.',
   0x00403C: u'FORKS, INC.',
   0x00403D: u'TERADATA',
   0x00403E: u'RASTER OPS CORPORATION',
   0x00403F: u'SSANGYONG COMPUTER SYSTEMS',
   0x004040: u'RING ACCESS, INC.',
   0x004041: u'FUJIKURA LTD.',
   0x004042: u'N.A.T. GMBH',
   0x004043: u'NOKIA TELECOMMUNICATIONS',
   0x004044: u'QNIX COMPUTER CO., LTD.',
   0x004045: u'TWINHEAD CORPORATION',
   0x004046: u'UDC RESEARCH LIMITED',
   0x004047: u'WIND RIVER SYSTEMS',
   0x004048: u'SMD INFORMATICA S.A.',
   0x004049: u'TEGIMENTA AG',
   0x00404A: u'WEST AUSTRALIAN DEPARTMENT',
   0x00404B: u'MAPLE COMPUTER SYSTEMS',
   0x00404C: u'HYPERTEC PTY LTD.',
   0x00404D: u'TELECOMMUNICATIONS TECHNIQUES',
   0x00404E: u'FLUENT, INC.',
   0x00404F: u'SPACE & NAVAL WARFARE SYSTEMS',
   0x004050: u'IRONICS, INCORPORATED',
   0x004051: u'GRACILIS, INC.',
   0x004052: u'STAR TECHNOLOGIES, INC.',
   0x004053: u'AMPRO COMPUTERS',
   0x004054: u'CONNECTION MACHINES SERVICES',
   0x004055: u'METRONIX GMBH',
   0x004056: u'MCM JAPAN LTD.',
   0x004057: u'LOCKHEED - SANDERS',
   0x004058: u'KRONOS, INC.',
   0x004059: u'YOSHIDA KOGYO K. K.',
   0x00405A: u'GOLDSTAR INFORMATION & COMM.',
   0x00405B: u'FUNASSET LIMITED',
   0x00405C: u'FUTURE SYSTEMS, INC.',
   0x00405D: u'STAR-TEK, INC.',
   0x00405E: u'NORTH HILLS ISRAEL',
   0x00405F: u'AFE COMPUTERS LTD.',
   0x004060: u'COMENDEC LTD',
   0x004061: u'DATATECH ENTERPRISES CO., LTD.',
   0x004062: u'E-SYSTEMS, INC./GARLAND DIV.',
   0x004063: u'VIA TECHNOLOGIES, INC.',
   0x004064: u'KLA INSTRUMENTS CORPORATION',
   0x004065: u'GTE SPACENET',
   0x004066: u'HITACHI CABLE, LTD.',
   0x004067: u'OMNIBYTE CORPORATION',
   0x004068: u'EXTENDED SYSTEMS',
   0x004069: u'LEMCOM SYSTEMS, INC.',
   0x00406A: u'KENTEK INFORMATION SYSTEMS,INC',
   0x00406B: u'SYSGEN',
   0x00406C: u'COPERNIQUE',
   0x00406D: u'LANCO, INC.',
   0x00406E: u'COROLLARY, INC.',
   0x00406F: u'SYNC RESEARCH INC.',
   0x004070: u'INTERWARE CO., LTD.',
   0x004071: u'ATM COMPUTER GMBH',
   0x004072: u'Applied Innovation Inc.',
   0x004073: u'BASS ASSOCIATES',
   0x004074: u'CABLE AND WIRELESS',
   0x004075: u'M-TRADE (UK) LTD',
   0x004076: u'Sun Conversion Technologies',
   0x004077: u'MAXTON TECHNOLOGY CORPORATION',
   0x004078: u'WEARNES AUTOMATION PTE LTD',
   0x004079: u'JUKO MANUFACTURE COMPANY, LTD.',
   0x00407A: u'SOCIETE D\'EXPLOITATION DU CNIT',
   0x00407B: u'SCIENTIFIC ATLANTA',
   0x00407C: u'QUME CORPORATION',
   0x00407D: u'EXTENSION TECHNOLOGY CORP.',
   0x00407E: u'EVERGREEN SYSTEMS, INC.',
   0x00407F: u'FLIR Systems',
   0x004080: u'ATHENIX CORPORATION',
   0x004081: u'MANNESMANN SCANGRAPHIC GMBH',
   0x004082: u'LABORATORY EQUIPMENT CORP.',
   0x004083: u'TDA INDUSTRIA DE PRODUTOS',
   0x004084: u'HONEYWELL INC.',
   0x004085: u'SAAB INSTRUMENTS AB',
   0x004086: u'MICHELS & KLEBERHOFF COMPUTER',
   0x004087: u'UBITREX CORPORATION',
   0x004088: u'MOBIUS TECHNOLOGIES, INC.',
   0x004089: u'MEIDENSHA CORPORATION',
   0x00408A: u'TPS TELEPROCESSING SYS. GMBH',
   0x00408B: u'RAYLAN CORPORATION',
   0x00408C: u'AXIS COMMUNICATIONS AB',
   0x00408D: u'THE GOODYEAR TIRE & RUBBER CO.',
   0x00408E: u'DIGILOG, INC.',
   0x00408F: u'WM-DATA MINFO AB',
   0x004090: u'ANSEL COMMUNICATIONS',
   0x004091: u'PROCOMP INDUSTRIA ELETRONICA',
   0x004092: u'ASP COMPUTER PRODUCTS, INC.',
   0x004093: u'PAXDATA NETWORKS LTD.',
   0x004094: u'SHOGRAPHICS, INC.',
   0x004095: u'R.P.T. INTERGROUPS INT\'L LTD.',
   0x004096: u'Cisco Systems, Inc.',
   0x004097: u'DATEX DIVISION OF',
   0x004098: u'DRESSLER GMBH & CO.',
   0x004099: u'NEWGEN SYSTEMS CORP.',
   0x00409A: u'NETWORK EXPRESS, INC.',
   0x00409B: u'HAL COMPUTER SYSTEMS INC.',
   0x00409C: u'TRANSWARE',
   0x00409D: u'DIGIBOARD, INC.',
   0x00409E: u'CONCURRENT TECHNOLOGIES  LTD.',
   0x00409F: u'LANCAST/CASAT TECHNOLOGY, INC.',
   0x0040A0: u'GOLDSTAR CO., LTD.',
   0x0040A1: u'ERGO COMPUTING',
   0x0040A2: u'KINGSTAR TECHNOLOGY INC.',
   0x0040A3: u'MICROUNITY SYSTEMS ENGINEERING',
   0x0040A4: u'ROSE ELECTRONICS',
   0x0040A5: u'CLINICOMP INTL.',
   0x0040A6: u'Cray, Inc.',
   0x0040A7: u'ITAUTEC PHILCO S.A.',
   0x0040A8: u'IMF INTERNATIONAL LTD.',
   0x0040A9: u'DATACOM INC.',
   0x0040AA: u'VALMET AUTOMATION INC.',
   0x0040AB: u'ROLAND DG CORPORATION',
   0x0040AC: u'SUPER WORKSTATION, INC.',
   0x0040AD: u'SMA REGELSYSTEME GMBH',
   0x0040AE: u'DELTA CONTROLS, INC.',
   0x0040AF: u'DIGITAL PRODUCTS, INC.',
   0x0040B0: u'BYTEX CORPORATION, ENGINEERING',
   0x0040B1: u'CODONICS INC.',
   0x0040B2: u'SYSTEMFORSCHUNG',
   0x0040B3: u'PAR MICROSYSTEMS CORPORATION',
   0x0040B4: u'NEXTCOM K.K.',
   0x0040B5: u'VIDEO TECHNOLOGY COMPUTERS LTD',
   0x0040B6: u'COMPUTERM  CORPORATION',
   0x0040B7: u'STEALTH COMPUTER SYSTEMS',
   0x0040B8: u'IDEA ASSOCIATES',
   0x0040B9: u'MACQ ELECTRONIQUE SA',
   0x0040BA: u'ALLIANT COMPUTER SYSTEMS CORP.',
   0x0040BB: u'GOLDSTAR CABLE CO., LTD.',
   0x0040BC: u'ALGORITHMICS LTD.',
   0x0040BD: u'STARLIGHT NETWORKS, INC.',
   0x0040BE: u'BOEING DEFENSE & SPACE',
   0x0040BF: u'CHANNEL SYSTEMS INTERN\'L INC.',
   0x0040C0: u'VISTA CONTROLS CORPORATION',
   0x0040C1: u'BIZERBA-WERKE WILHEIM KRAUT',
   0x0040C2: u'APPLIED COMPUTING DEVICES',
   0x0040C3: u'FISCHER AND PORTER CO.',
   0x0040C4: u'KINKEI SYSTEM CORPORATION',
   0x0040C5: u'MICOM COMMUNICATIONS INC.',
   0x0040C6: u'FIBERNET RESEARCH, INC.',
   0x0040C7: u'RUBY TECH CORPORATION',
   0x0040C8: u'MILAN TECHNOLOGY CORPORATION',
   0x0040C9: u'NCUBE',
   0x0040CA: u'FIRST INTERNAT\'L COMPUTER, INC',
   0x0040CB: u'LANWAN TECHNOLOGIES',
   0x0040CC: u'SILCOM MANUF\'G TECHNOLOGY INC.',
   0x0040CD: u'TERA MICROSYSTEMS, INC.',
   0x0040CE: u'NET-SOURCE, INC.',
   0x0040CF: u'STRAWBERRY TREE, INC.',
   0x0040D0: u'MITAC INTERNATIONAL CORP.',
   0x0040D1: u'FUKUDA DENSHI CO., LTD.',
   0x0040D2: u'PAGINE CORPORATION',
   0x0040D3: u'KIMPSION INTERNATIONAL CORP.',
   0x0040D4: u'GAGE TALKER CORP.',
   0x0040D5: u'SARTORIUS AG',
   0x0040D6: u'LOCAMATION B.V.',
   0x0040D7: u'STUDIO GEN INC.',
   0x0040D8: u'OCEAN OFFICE AUTOMATION LTD.',
   0x0040D9: u'AMERICAN MEGATRENDS INC.',
   0x0040DA: u'TELSPEC LTD',
   0x0040DB: u'ADVANCED TECHNICAL SOLUTIONS',
   0x0040DC: u'TRITEC ELECTRONIC GMBH',
   0x0040DD: u'HONG TECHNOLOGIES',
   0x0040DE: u'ELETTRONICA SAN GIORGIO',
   0x0040DF: u'DIGALOG SYSTEMS, INC.',
   0x0040E0: u'ATOMWIDE LTD.',
   0x0040E1: u'MARNER INTERNATIONAL, INC.',
   0x0040E2: u'MESA RIDGE TECHNOLOGIES, INC.',
   0x0040E3: u'QUIN SYSTEMS LTD',
   0x0040E4: u'E-M TECHNOLOGY, INC.',
   0x0040E5: u'SYBUS CORPORATION',
   0x0040E6: u'C.A.E.N.',
   0x0040E7: u'ARNOS INSTRUMENTS & COMPUTER',
   0x0040E8: u'CHARLES RIVER DATA SYSTEMS,INC',
   0x0040E9: u'ACCORD SYSTEMS, INC.',
   0x0040EA: u'PLAIN TREE SYSTEMS INC',
   0x0040EB: u'MARTIN MARIETTA CORPORATION',
   0x0040EC: u'MIKASA SYSTEM ENGINEERING',
   0x0040ED: u'NETWORK CONTROLS INT\'NATL INC.',
   0x0040EE: u'OPTIMEM',
   0x0040EF: u'HYPERCOM, INC.',
   0x0040F0: u'MICRO SYSTEMS, INC.',
   0x0040F1: u'CHUO ELECTRONICS CO., LTD.',
   0x0040F2: u'JANICH & KLASS COMPUTERTECHNIK',
   0x0040F3: u'NETCOR',
   0x0040F4: u'CAMEO COMMUNICATIONS, INC.',
   0x0040F5: u'OEM ENGINES',
   0x0040F6: u'KATRON COMPUTERS INC.',
   0x0040F7: u'POLAROID MEDICAL IMAGING SYS.',
   0x0040F8: u'SYSTEMHAUS DISCOM',
   0x0040F9: u'COMBINET',
   0x0040FA: u'MICROBOARDS, INC.',
   0x0040FB: u'CASCADE COMMUNICATIONS CORP.',
   0x0040FC: u'IBR COMPUTER TECHNIK GMBH',
   0x0040FD: u'LXE',
   0x0040FE: u'SYMPLEX COMMUNICATIONS',
   0x0040FF: u'TELEBIT CORPORATION',
   0x004252: u'RLX Technologies',
   0x004501: u'Versus Technology, Inc.',
   0x005000: u'NEXO COMMUNICATIONS, INC.',
   0x005001: u'YAMASHITA SYSTEMS CORP.',
   0x005002: u'OMNISEC AG',
   0x005003: u'GRETAG MACBETH AG',
   0x005004: u'3COM CORPORATION',
   0x005006: u'TAC AB',
   0x005007: u'SIEMENS TELECOMMUNICATION SYSTEMS LIMITED',
   0x005008: u'TIVA MICROCOMPUTER CORP. (TMC)',
   0x005009: u'PHILIPS BROADBAND NETWORKS',
   0x00500A: u'IRIS TECHNOLOGIES, INC.',
   0x00500B: u'CISCO SYSTEMS, INC.',
   0x00500C: u'e-Tek Labs, Inc.',
   0x00500D: u'SATORI ELECTORIC CO., LTD.',
   0x00500E: u'CHROMATIS NETWORKS, INC.',
   0x00500F: u'CISCO SYSTEMS, INC.',
   0x005010: u'NovaNET Learning, Inc.',
   0x005012: u'CBL - GMBH',
   0x005013: u'Chaparral Network Storage',
   0x005014: u'CISCO SYSTEMS, INC.',
   0x005015: u'BRIGHT STAR ENGINEERING',
   0x005016: u'SST/WOODHEAD INDUSTRIES',
   0x005017: u'RSR S.R.L.',
   0x005018: u'AMIT, Inc.',
   0x005019: u'SPRING TIDE NETWORKS, INC.',
   0x00501A: u'UISIQN',
   0x00501B: u'ABL CANADA, INC.',
   0x00501C: u'JATOM SYSTEMS, INC.',
   0x00501E: u'Miranda Technologies, Inc.',
   0x00501F: u'MRG SYSTEMS, LTD.',
   0x005020: u'MEDIASTAR CO., LTD.',
   0x005021: u'EIS INTERNATIONAL, INC.',
   0x005022: u'ZONET TECHNOLOGY, INC.',
   0x005023: u'PG DESIGN ELECTRONICS, INC.',
   0x005024: u'NAVIC SYSTEMS, INC.',
   0x005026: u'COSYSTEMS, INC.',
   0x005027: u'GENICOM CORPORATION',
   0x005028: u'AVAL COMMUNICATIONS',
   0x005029: u'1394 PRINTER WORKING GROUP',
   0x00502A: u'CISCO SYSTEMS, INC.',
   0x00502B: u'GENRAD LTD.',
   0x00502C: u'SOYO COMPUTER, INC.',
   0x00502D: u'ACCEL, INC.',
   0x00502E: u'CAMBEX CORPORATION',
   0x00502F: u'TollBridge Technologies, Inc.',
   0x005030: u'FUTURE PLUS SYSTEMS',
   0x005031: u'AEROFLEX LABORATORIES, INC.',
   0x005032: u'PICAZO COMMUNICATIONS, INC.',
   0x005033: u'MAYAN NETWORKS',
   0x005036: u'NETCAM, LTD.',
   0x005037: u'KOGA ELECTRONICS CO.',
   0x005038: u'DAIN TELECOM CO., LTD.',
   0x005039: u'MARINER NETWORKS',
   0x00503A: u'DATONG ELECTRONICS LTD.',
   0x00503B: u'MEDIAFIRE CORPORATION',
   0x00503C: u'TSINGHUA NOVEL ELECTRONICS',
   0x00503E: u'CISCO SYSTEMS, INC.',
   0x00503F: u'ANCHOR GAMES',
   0x005040: u'Matsushita Electric Works, Ltd.',
   0x005041: u'Coretronic Corporation',
   0x005042: u'SCI MANUFACTURING SINGAPORE PTE, LTD.',
   0x005043: u'MARVELL SEMICONDUCTOR, INC.',
   0x005044: u'ASACA CORPORATION',
   0x005045: u'RIOWORKS SOLUTIONS, INC.',
   0x005046: u'MENICX INTERNATIONAL CO., LTD.',
   0x005047: u'PRIVATE',
   0x005048: u'INFOLIBRIA',
   0x005049: u'ELLACOYA NETWORKS, INC.',
   0x00504A: u'ELTECO A.S.',
   0x00504B: u'BARCONET N.V.',
   0x00504C: u'GALIL MOTION CONTROL, INC.',
   0x00504D: u'TOKYO ELECTRON DEVICE LTD.',
   0x00504E: u'SIERRA MONITOR CORP.',
   0x00504F: u'OLENCOM ELECTRONICS',
   0x005050: u'CISCO SYSTEMS, INC.',
   0x005051: u'IWATSU ELECTRIC CO., LTD.',
   0x005052: u'TIARA NETWORKS, INC.',
   0x005053: u'CISCO SYSTEMS, INC.',
   0x005054: u'CISCO SYSTEMS, INC.',
   0x005055: u'DOMS A/S',
   0x005056: u'VMWare, Inc.',
   0x005057: u'BROADBAND ACCESS SYSTEMS',
   0x005058: u'VegaStream Limted',
   0x005059: u'iBAHN',
   0x00505A: u'NETWORK ALCHEMY, INC.',
   0x00505B: u'KAWASAKI LSI U.S.A., INC.',
   0x00505C: u'TUNDO CORPORATION',
   0x00505E: u'DIGITEK MICROLOGIC S.A.',
   0x00505F: u'BRAND INNOVATORS',
   0x005060: u'TANDBERG TELECOM AS',
   0x005062: u'KOUWELL ELECTRONICS CORP.  **',
   0x005063: u'OY COMSEL SYSTEM AB',
   0x005064: u'CAE ELECTRONICS',
   0x005065: u'DENSEI-LAMBAD Co., Ltd.',
   0x005066: u'AtecoM GmbH advanced telecomunication modules',
   0x005067: u'AEROCOMM, INC.',
   0x005068: u'ELECTRONIC INDUSTRIES ASSOCIATION',
   0x005069: u'PixStream Incorporated',
   0x00506A: u'EDEVA, INC.',
   0x00506B: u'SPX-ATEG',
   0x00506C: u'G & L BEIJER ELECTRONICS AB',
   0x00506D: u'VIDEOJET SYSTEMS',
   0x00506E: u'CORDER ENGINEERING CORPORATION',
   0x00506F: u'G-CONNECT',
   0x005070: u'CHAINTECH COMPUTER CO., LTD.',
   0x005071: u'AIWA CO., LTD.',
   0x005072: u'CORVIS CORPORATION',
   0x005073: u'CISCO SYSTEMS, INC.',
   0x005074: u'ADVANCED HI-TECH CORP.',
   0x005075: u'KESTREL SOLUTIONS',
   0x005076: u'IBM',
   0x005077: u'PROLIFIC TECHNOLOGY, INC.',
   0x005078: u'MEGATON HOUSE, LTD.',
   0x005079: u'PRIVATE',
   0x00507A: u'XPEED, INC.',
   0x00507B: u'MERLOT COMMUNICATIONS',
   0x00507C: u'VIDEOCON AG',
   0x00507D: u'IFP',
   0x00507E: u'NEWER TECHNOLOGY',
   0x00507F: u'DrayTek Corp.',
   0x005080: u'CISCO SYSTEMS, INC.',
   0x005081: u'MURATA MACHINERY, LTD.',
   0x005082: u'FORESSON CORPORATION',
   0x005083: u'GILBARCO, INC.',
   0x005084: u'ATL PRODUCTS',
   0x005086: u'TELKOM SA, LTD.',
   0x005087: u'TERASAKI ELECTRIC CO., LTD.',
   0x005088: u'AMANO CORPORATION',
   0x005089: u'SAFETY MANAGEMENT SYSTEMS',
   0x00508B: u'COMPAQ COMPUTER CORPORATION',
   0x00508C: u'RSI SYSTEMS',
   0x00508D: u'ABIT COMPUTER CORPORATION',
   0x00508E: u'OPTIMATION, INC.',
   0x00508F: u'ASITA TECHNOLOGIES INT\'L LTD.',
   0x005090: u'DCTRI',
   0x005091: u'NETACCESS, INC.',
   0x005092: u'RIGAKU INDUSTRIAL CORPORATION',
   0x005093: u'BOEING',
   0x005094: u'PACE MICRO TECHNOLOGY PLC',
   0x005095: u'PERACOM NETWORKS',
   0x005096: u'SALIX TECHNOLOGIES, INC.',
   0x005097: u'MMC-EMBEDDED COMPUTERTECHNIK GmbH',
   0x005098: u'GLOBALOOP, LTD.',
   0x005099: u'3COM EUROPE, LTD.',
   0x00509A: u'TAG ELECTRONIC SYSTEMS',
   0x00509B: u'SWITCHCORE AB',
   0x00509C: u'BETA RESEARCH',
   0x00509D: u'THE INDUSTREE B.V.',
   0x00509E: u'Les Technologies SoftAcoustik Inc.',
   0x00509F: u'HORIZON COMPUTER',
   0x0050A0: u'DELTA COMPUTER SYSTEMS, INC.',
   0x0050A1: u'CARLO GAVAZZI, INC.',
   0x0050A2: u'CISCO SYSTEMS, INC.',
   0x0050A3: u'TransMedia Communications, Inc.',
   0x0050A4: u'IO TECH, INC.',
   0x0050A5: u'CAPITOL BUSINESS SYSTEMS, LTD.',
   0x0050A6: u'OPTRONICS',
   0x0050A7: u'CISCO SYSTEMS, INC.',
   0x0050A8: u'OpenCon Systems, Inc.',
   0x0050A9: u'MOLDAT WIRELESS TECHNOLGIES',
   0x0050AA: u'KONICA MINOLTA HOLDINGS, INC.',
   0x0050AB: u'NALTEC, INC.',
   0x0050AC: u'MAPLE COMPUTER CORPORATION',
   0x0050AD: u'CommUnique Wireless Corp.',
   0x0050AE: u'IWAKI ELECTRONICS CO., LTD.',
   0x0050AF: u'INTERGON, INC.',
   0x0050B0: u'TECHNOLOGY ATLANTA CORPORATION',
   0x0050B1: u'GIDDINGS & LEWIS',
   0x0050B2: u'BRODEL AUTOMATION',
   0x0050B3: u'VOICEBOARD CORPORATION',
   0x0050B4: u'SATCHWELL CONTROL SYSTEMS, LTD',
   0x0050B5: u'FICHET-BAUCHE',
   0x0050B6: u'GOOD WAY IND. CO., LTD.',
   0x0050B7: u'BOSER TECHNOLOGY CO., LTD.',
   0x0050B8: u'INOVA COMPUTERS GMBH & CO. KG',
   0x0050B9: u'XITRON TECHNOLOGIES, INC.',
   0x0050BA: u'D-LINK',
   0x0050BB: u'CMS TECHNOLOGIES',
   0x0050BC: u'HAMMER STORAGE SOLUTIONS',
   0x0050BD: u'CISCO SYSTEMS, INC.',
   0x0050BE: u'FAST MULTIMEDIA AG',
   0x0050BF: u'MOTOTECH INC.',
   0x0050C0: u'GATAN, INC.',
   0x0050C1: u'GEMFLEX NETWORKS, LTD.',
   0x0050C2: u'IEEE REGISTRATION AUTHORITY',
   0x0050C4: u'IMD',
   0x0050C5: u'ADS TECHNOLOGIES, INC.',
   0x0050C6: u'LOOP TELECOMMUNICATION INTERNATIONAL, INC.',
   0x0050C8: u'ADDONICS COMMUNICATIONS, INC.',
   0x0050C9: u'MASPRO DENKOH CORP.',
   0x0050CA: u'NET TO NET TECHNOLOGIES',
   0x0050CB: u'JETTER',
   0x0050CC: u'XYRATEX',
   0x0050CD: u'DIGIANSWER A/S',
   0x0050CE: u'LG INTERNATIONAL CORP.',
   0x0050CF: u'VANLINK COMMUNICATION TECHNOLOGY RESEARCH INSTITUTE',
   0x0050D0: u'MINERVA SYSTEMS',
   0x0050D1: u'CISCO SYSTEMS, INC.',
   0x0050D2: u'CMC Electronics Inc',
   0x0050D3: u'DIGITAL AUDIO PROCESSING PTY. LTD.',
   0x0050D4: u'JOOHONG INFORMATION &',
   0x0050D5: u'AD SYSTEMS CORP.',
   0x0050D6: u'ATLAS COPCO TOOLS AB',
   0x0050D7: u'TELSTRAT',
   0x0050D8: u'UNICORN COMPUTER CORP.',
   0x0050D9: u'ENGETRON-ENGENHARIA ELETRONICA IND. e COM. LTDA',
   0x0050DA: u'3COM CORPORATION',
   0x0050DB: u'CONTEMPORARY CONTROL',
   0x0050DC: u'TAS TELEFONBAU A. SCHWABE GMBH & CO. KG',
   0x0050DD: u'SERRA SOLDADURA, S.A.',
   0x0050DE: u'SIGNUM SYSTEMS CORP.',
   0x0050DF: u'AirFiber, Inc.',
   0x0050E1: u'NS TECH ELECTRONICS SDN BHD',
   0x0050E2: u'CISCO SYSTEMS, INC.',
   0x0050E3: u'Terayon Communications Systems',
   0x0050E4: u'APPLE COMPUTER, INC.',
   0x0050E6: u'HAKUSAN CORPORATION',
   0x0050E7: u'PARADISE INNOVATIONS (ASIA)',
   0x0050E8: u'NOMADIX INC.',
   0x0050EA: u'XEL COMMUNICATIONS, INC.',
   0x0050EB: u'ALPHA-TOP CORPORATION',
   0x0050EC: u'OLICOM A/S',
   0x0050ED: u'ANDA NETWORKS',
   0x0050EE: u'TEK DIGITEL CORPORATION',
   0x0050EF: u'SPE Systemhaus GmbH',
   0x0050F0: u'CISCO SYSTEMS, INC.',
   0x0050F1: u'LIBIT SIGNAL PROCESSING, LTD.',
   0x0050F2: u'MICROSOFT CORP.',
   0x0050F3: u'GLOBAL NET INFORMATION CO., Ltd.',
   0x0050F4: u'SIGMATEK GMBH & CO. KG',
   0x0050F6: u'PAN-INTERNATIONAL INDUSTRIAL CORP.',
   0x0050F7: u'VENTURE MANUFACTURING (SINGAPORE) LTD.',
   0x0050F8: u'ENTREGA TECHNOLOGIES, INC.',
   0x0050F9: u'SENSORMATIC ACD',
   0x0050FA: u'OXTEL, LTD.',
   0x0050FB: u'VSK ELECTRONICS',
   0x0050FC: u'EDIMAX TECHNOLOGY CO., LTD.',
   0x0050FD: u'VISIONCOMM CO., LTD.',
   0x0050FE: u'PCTVnet ASA',
   0x0050FF: u'HAKKO ELECTRONICS CO., LTD.',
   0x006000: u'XYCOM INC.',
   0x006001: u'InnoSys, Inc.',
   0x006002: u'SCREEN SUBTITLING SYSTEMS, LTD',
   0x006003: u'TERAOKA WEIGH SYSTEM PTE, LTD.',
   0x006004: u'COMPUTADORES MODULARES SA',
   0x006005: u'FEEDBACK DATA LTD.',
   0x006006: u'SOTEC CO., LTD',
   0x006007: u'ACRES GAMING, INC.',
   0x006008: u'3COM CORPORATION',
   0x006009: u'CISCO SYSTEMS, INC.',
   0x00600A: u'SORD COMPUTER CORPORATION',
   0x00600B: u'LOGWARE GmbH',
   0x00600C: u'APPLIED DATA SYSTEMS, INC.',
   0x00600D: u'Digital Logic GmbH',
   0x00600E: u'WAVENET INTERNATIONAL, INC.',
   0x00600F: u'WESTELL, INC.',
   0x006010: u'NETWORK MACHINES, INC.',
   0x006011: u'CRYSTAL SEMICONDUCTOR CORP.',
   0x006012: u'POWER COMPUTING CORPORATION',
   0x006013: u'NETSTAL MASCHINEN AG',
   0x006014: u'EDEC CO., LTD.',
   0x006015: u'NET2NET CORPORATION',
   0x006016: u'CLARIION',
   0x006017: u'TOKIMEC INC.',
   0x006018: u'STELLAR ONE CORPORATION',
   0x006019: u'Roche Diagnostics',
   0x00601A: u'KEITHLEY INSTRUMENTS',
   0x00601B: u'MESA ELECTRONICS',
   0x00601C: u'TELXON CORPORATION',
   0x00601D: u'LUCENT TECHNOLOGIES',
   0x00601E: u'SOFTLAB, INC.',
   0x00601F: u'STALLION TECHNOLOGIES',
   0x006020: u'PIVOTAL NETWORKING, INC.',
   0x006021: u'DSC CORPORATION',
   0x006022: u'VICOM SYSTEMS, INC.',
   0x006023: u'PERICOM SEMICONDUCTOR CORP.',
   0x006024: u'GRADIENT TECHNOLOGIES, INC.',
   0x006025: u'ACTIVE IMAGING PLC',
   0x006026: u'VIKING COMPONENTS, INC.',
   0x006027: u'Superior Modular Products',
   0x006028: u'MACROVISION CORPORATION',
   0x006029: u'CARY PERIPHERALS INC.',
   0x00602A: u'SYMICRON COMPUTER COMMUNICATIONS, LTD.',
   0x00602B: u'PEAK AUDIO',
   0x00602C: u'LINX Data Terminals, Inc.',
   0x00602D: u'ALERTON TECHNOLOGIES, INC.',
   0x00602E: u'CYCLADES CORPORATION',
   0x00602F: u'CISCO SYSTEMS, INC.',
   0x006030: u'VILLAGE TRONIC ENTWICKLUNG',
   0x006031: u'HRK SYSTEMS',
   0x006032: u'I-CUBE, INC.',
   0x006033: u'ACUITY IMAGING, INC.',
   0x006034: u'ROBERT BOSCH GmbH',
   0x006035: u'DALLAS SEMICONDUCTOR, INC.',
   0x006036: u'AUSTRIAN RESEARCH CENTER SEIBERSDORF',
   0x006037: u'NXP Semiconductors',
   0x006038: u'Nortel Networks',
   0x006039: u'SanCom Technology, Inc.',
   0x00603A: u'QUICK CONTROLS LTD.',
   0x00603B: u'AMTEC spa',
   0x00603C: u'HAGIWARA SYS-COM CO., LTD.',
   0x00603D: u'3CX',
   0x00603E: u'CISCO SYSTEMS, INC.',
   0x00603F: u'PATAPSCO DESIGNS',
   0x006040: u'NETRO CORP.',
   0x006041: u'Yokogawa Electric Corporation',
   0x006042: u'TKS (USA), INC.',
   0x006043: u'ComSoft Systems, Inc.',
   0x006044: u'LITTON/POLY-SCIENTIFIC',
   0x006045: u'PATHLIGHT TECHNOLOGIES',
   0x006046: u'VMETRO, INC.',
   0x006047: u'CISCO SYSTEMS, INC.',
   0x006048: u'EMC CORPORATION',
   0x006049: u'VINA TECHNOLOGIES',
   0x00604A: u'SAIC IDEAS GROUP',
   0x00604B: u'Safe-com GmbH & Co. KG',
   0x00604C: u'SAGEM SA',
   0x00604D: u'MMC NETWORKS, INC.',
   0x00604E: u'CYCLE COMPUTER CORPORATION, INC.',
   0x00604F: u'SUZUKI MFG. CO., LTD.',
   0x006050: u'INTERNIX INC.',
   0x006051: u'QUALITY SEMICONDUCTOR',
   0x006052: u'PERIPHERALS ENTERPRISE CO., Ltd.',
   0x006053: u'TOYODA MACHINE WORKS, LTD.',
   0x006054: u'CONTROLWARE GMBH',
   0x006055: u'CORNELL UNIVERSITY',
   0x006056: u'NETWORK TOOLS, INC.',
   0x006057: u'MURATA MANUFACTURING CO., LTD.',
   0x006058: u'COPPER MOUNTAIN COMMUNICATIONS, INC.',
   0x006059: u'TECHNICAL COMMUNICATIONS CORP.',
   0x00605A: u'CELCORE, INC.',
   0x00605B: u'IntraServer Technology, Inc.',
   0x00605C: u'CISCO SYSTEMS, INC.',
   0x00605D: u'SCANIVALVE CORP.',
   0x00605E: u'LIBERTY TECHNOLOGY NETWORKING',
   0x00605F: u'NIPPON UNISOFT CORPORATION',
   0x006060: u'DAWNING TECHNOLOGIES, INC.',
   0x006061: u'WHISTLE COMMUNICATIONS CORP.',
   0x006062: u'TELESYNC, INC.',
   0x006063: u'PSION DACOM PLC.',
   0x006064: u'NETCOMM LIMITED',
   0x006065: u'BERNECKER & RAINER INDUSTRIE-ELEKTRONIC GmbH',
   0x006066: u'LACROIX TECHNOLGIE',
   0x006067: u'ACER NETXUS INC.',
   0x006068: u'EICON TECHNOLOGY CORPORATION',
   0x006069: u'BROCADE COMMUNICATIONS SYSTEMS, Inc.',
   0x00606A: u'MITSUBISHI WIRELESS COMMUNICATIONS. INC.',
   0x00606B: u'Synclayer Inc.',
   0x00606C: u'ARESCOM',
   0x00606D: u'DIGITAL EQUIPMENT CORP.',
   0x00606E: u'DAVICOM SEMICONDUCTOR, INC.',
   0x00606F: u'CLARION CORPORATION OF AMERICA',
   0x006070: u'CISCO SYSTEMS, INC.',
   0x006071: u'MIDAS LAB, INC.',
   0x006072: u'VXL INSTRUMENTS, LIMITED',
   0x006073: u'REDCREEK COMMUNICATIONS, INC.',
   0x006074: u'QSC AUDIO PRODUCTS',
   0x006075: u'PENTEK, INC.',
   0x006076: u'SCHLUMBERGER TECHNOLOGIES RETAIL PETROLEUM SYSTEMS',
   0x006077: u'PRISA NETWORKS',
   0x006078: u'POWER MEASUREMENT LTD.',
   0x006079: u'Mainstream Data, Inc.',
   0x00607A: u'DVS GmbH',
   0x00607B: u'FORE SYSTEMS, INC.',
   0x00607C: u'WaveAccess, Ltd.',
   0x00607D: u'SENTIENT NETWORKS INC.',
   0x00607E: u'GIGALABS, INC.',
   0x00607F: u'AURORA TECHNOLOGIES, INC.',
   0x006080: u'MICROTRONIX DATACOM LTD.',
   0x006081: u'TV/COM INTERNATIONAL',
   0x006082: u'NOVALINK TECHNOLOGIES, INC.',
   0x006083: u'CISCO SYSTEMS, INC.',
   0x006084: u'DIGITAL VIDEO',
   0x006085: u'Storage Concepts',
   0x006086: u'LOGIC REPLACEMENT TECH. LTD.',
   0x006087: u'KANSAI ELECTRIC CO., LTD.',
   0x006088: u'WHITE MOUNTAIN DSP, INC.',
   0x006089: u'XATA',
   0x00608A: u'CITADEL COMPUTER',
   0x00608B: u'ConferTech International',
   0x00608C: u'3COM CORPORATION',
   0x00608D: u'UNIPULSE CORP.',
   0x00608E: u'HE ELECTRONICS, TECHNOLOGIE & SYSTEMTECHNIK GmbH',
   0x00608F: u'TEKRAM TECHNOLOGY CO., LTD.',
   0x006090: u'ABLE COMMUNICATIONS, INC.',
   0x006091: u'FIRST PACIFIC NETWORKS, INC.',
   0x006092: u'MICRO/SYS, INC.',
   0x006093: u'VARIAN',
   0x006094: u'IBM CORP.',
   0x006095: u'ACCU-TIME SYSTEMS, INC.',
   0x006096: u'T.S. MICROTECH INC.',
   0x006097: u'3COM CORPORATION',
   0x006098: u'HT COMMUNICATIONS',
   0x006099: u'SBE, Inc.',
   0x00609A: u'NJK TECHNO CO.',
   0x00609B: u'ASTRO-MED, INC.',
   0x00609C: u'Perkin-Elmer Incorporated',
   0x00609D: u'PMI FOOD EQUIPMENT GROUP',
   0x00609E: u'ASC X3 - INFORMATION TECHNOLOGY STANDARDS SECRETARIATS',
   0x00609F: u'PHAST CORPORATION',
   0x0060A0: u'SWITCHED NETWORK TECHNOLOGIES, INC.',
   0x0060A1: u'VPNet, Inc.',
   0x0060A2: u'NIHON UNISYS LIMITED CO.',
   0x0060A3: u'CONTINUUM TECHNOLOGY CORP.',
   0x0060A4: u'GRINAKER SYSTEM TECHNOLOGIES',
   0x0060A5: u'PERFORMANCE TELECOM CORP.',
   0x0060A6: u'PARTICLE MEASURING SYSTEMS',
   0x0060A7: u'MICROSENS GmbH & CO. KG',
   0x0060A8: u'TIDOMAT AB',
   0x0060A9: u'GESYTEC MbH',
   0x0060AA: u'INTELLIGENT DEVICES INC. (IDI)',
   0x0060AB: u'LARSCOM INCORPORATED',
   0x0060AC: u'RESILIENCE CORPORATION',
   0x0060AD: u'MegaChips Corporation',
   0x0060AE: u'TRIO INFORMATION SYSTEMS AB',
   0x0060AF: u'PACIFIC MICRO DATA, INC.',
   0x0060B0: u'HEWLETT-PACKARD CO.',
   0x0060B1: u'INPUT/OUTPUT, INC.',
   0x0060B2: u'PROCESS CONTROL CORP.',
   0x0060B3: u'Z-COM, INC.',
   0x0060B4: u'GLENAYRE R&D INC.',
   0x0060B5: u'KEBA GmbH',
   0x0060B6: u'LAND COMPUTER CO., LTD.',
   0x0060B7: u'CHANNELMATIC, INC.',
   0x0060B8: u'CORELIS INC.',
   0x0060B9: u'NITSUKO CORPORATION',
   0x0060BA: u'SAHARA NETWORKS, INC.',
   0x0060BB: u'CABLETRON - NETLINK, INC.',
   0x0060BC: u'KeunYoung Electronics & Communication Co., Ltd.',
   0x0060BD: u'HUBBELL-PULSECOM',
   0x0060BE: u'WEBTRONICS',
   0x0060BF: u'MACRAIGOR SYSTEMS, INC.',
   0x0060C0: u'NERA AS',
   0x0060C1: u'WaveSpan Corporation',
   0x0060C2: u'MPL AG',
   0x0060C3: u'NETVISION CORPORATION',
   0x0060C4: u'SOLITON SYSTEMS K.K.',
   0x0060C5: u'ANCOT CORP.',
   0x0060C6: u'DCS AG',
   0x0060C7: u'AMATI COMMUNICATIONS CORP.',
   0x0060C8: u'KUKA WELDING SYSTEMS & ROBOTS',
   0x0060C9: u'ControlNet, Inc.',
   0x0060CA: u'HARMONIC SYSTEMS INCORPORATED',
   0x0060CB: u'HITACHI ZOSEN CORPORATION',
   0x0060CC: u'EMTRAK, INCORPORATED',
   0x0060CD: u'VideoServer, Inc.',
   0x0060CE: u'ACCLAIM COMMUNICATIONS',
   0x0060CF: u'ALTEON NETWORKS, INC.',
   0x0060D0: u'SNMP RESEARCH INCORPORATED',
   0x0060D1: u'CASCADE COMMUNICATIONS',
   0x0060D2: u'LUCENT TECHNOLOGIES TAIWAN TELECOMMUNICATIONS CO., LTD.',
   0x0060D3: u'AT&T',
   0x0060D4: u'ELDAT COMMUNICATION LTD.',
   0x0060D5: u'MIYACHI TECHNOS CORP.',
   0x0060D6: u'NovAtel Wireless Technologies Ltd.',
   0x0060D7: u'ECOLE POLYTECHNIQUE FEDERALE DE LAUSANNE (EPFL)',
   0x0060D8: u'ELMIC SYSTEMS, INC.',
   0x0060D9: u'TRANSYS NETWORKS INC.',
   0x0060DA: u'JBM ELECTRONICS CO.',
   0x0060DB: u'NTP ELEKTRONIK A/S',
   0x0060DC: u'Toyo Network Systems Co, Ltd.',
   0x0060DD: u'MYRICOM, INC.',
   0x0060DE: u'KAYSER-THREDE GmbH',
   0x0060DF: u'CNT Corporation',
   0x0060E0: u'AXIOM TECHNOLOGY CO., LTD.',
   0x0060E1: u'ORCKIT COMMUNICATIONS LTD.',
   0x0060E2: u'QUEST ENGINEERING & DEVELOPMENT',
   0x0060E3: u'ARBIN INSTRUMENTS',
   0x0060E4: u'COMPUSERVE, INC.',
   0x0060E5: u'FUJI AUTOMATION CO., LTD.',
   0x0060E6: u'SHOMITI SYSTEMS INCORPORATED',
   0x0060E7: u'RANDATA',
   0x0060E8: u'HITACHI COMPUTER PRODUCTS (AMERICA), INC.',
   0x0060E9: u'ATOP TECHNOLOGIES, INC.',
   0x0060EA: u'StreamLogic',
   0x0060EB: u'FOURTHTRACK SYSTEMS',
   0x0060EC: u'HERMARY OPTO ELECTRONICS INC.',
   0x0060ED: u'RICARDO TEST AUTOMATION LTD.',
   0x0060EE: u'APOLLO',
   0x0060EF: u'FLYTECH TECHNOLOGY CO., LTD.',
   0x0060F0: u'JOHNSON & JOHNSON MEDICAL, INC',
   0x0060F1: u'EXP COMPUTER, INC.',
   0x0060F2: u'LASERGRAPHICS, INC.',
   0x0060F3: u'Performance Analysis Broadband, Spirent plc',
   0x0060F4: u'ADVANCED COMPUTER SOLUTIONS, Inc.',
   0x0060F5: u'ICON WEST, INC.',
   0x0060F6: u'NEXTEST COMMUNICATIONS PRODUCTS, INC.',
   0x0060F7: u'DATAFUSION SYSTEMS',
   0x0060F8: u'Loran International Technologies Inc.',
   0x0060F9: u'DIAMOND LANE COMMUNICATIONS',
   0x0060FA: u'EDUCATIONAL TECHNOLOGY RESOURCES, INC.',
   0x0060FB: u'PACKETEER, INC.',
   0x0060FC: u'CONSERVATION THROUGH INNOVATION LTD.',
   0x0060FD: u'NetICs, Inc.',
   0x0060FE: u'LYNX SYSTEM DEVELOPERS, INC.',
   0x0060FF: u'QuVis, Inc.',
   0x0070B0: u'M/A-COM INC. COMPANIES',
   0x0070B3: u'DATA RECALL LTD.',
   0x008000: u'MULTITECH SYSTEMS, INC.',
   0x008001: u'PERIPHONICS CORPORATION',
   0x008002: u'SATELCOM (UK) LTD',
   0x008003: u'HYTEC ELECTRONICS LTD.',
   0x008004: u'ANTLOW COMMUNICATIONS, LTD.',
   0x008005: u'CACTUS COMPUTER INC.',
   0x008006: u'COMPUADD CORPORATION',
   0x008007: u'DLOG NC-SYSTEME',
   0x008008: u'DYNATECH COMPUTER SYSTEMS',
   0x008009: u'JUPITER SYSTEMS, INC.',
   0x00800A: u'JAPAN COMPUTER CORP.',
   0x00800B: u'CSK CORPORATION',
   0x00800C: u'VIDECOM LIMITED',
   0x00800D: u'VOSSWINKEL F.U.',
   0x00800E: u'ATLANTIX CORPORATION',
   0x00800F: u'STANDARD MICROSYSTEMS',
   0x008010: u'COMMODORE INTERNATIONAL',
   0x008011: u'DIGITAL SYSTEMS INT\'L. INC.',
   0x008012: u'INTEGRATED MEASUREMENT SYSTEMS',
   0x008013: u'THOMAS-CONRAD CORPORATION',
   0x008014: u'ESPRIT SYSTEMS',
   0x008015: u'SEIKO SYSTEMS, INC.',
   0x008016: u'WANDEL AND GOLTERMANN',
   0x008017: u'PFU LIMITED',
   0x008018: u'KOBE STEEL, LTD.',
   0x008019: u'DAYNA COMMUNICATIONS, INC.',
   0x00801A: u'BELL ATLANTIC',
   0x00801B: u'KODIAK TECHNOLOGY',
   0x00801C: u'NEWPORT SYSTEMS SOLUTIONS',
   0x00801D: u'INTEGRATED INFERENCE MACHINES',
   0x00801E: u'XINETRON, INC.',
   0x00801F: u'KRUPP ATLAS ELECTRONIK GMBH',
   0x008020: u'NETWORK PRODUCTS',
   0x008021: u'Alcatel Canada Inc.',
   0x008022: u'SCAN-OPTICS',
   0x008023: u'INTEGRATED BUSINESS NETWORKS',
   0x008024: u'KALPANA, INC.',
   0x008025: u'STOLLMANN GMBH',
   0x008026: u'NETWORK PRODUCTS CORPORATION',
   0x008027: u'ADAPTIVE SYSTEMS, INC.',
   0x008028: u'TRADPOST (HK) LTD',
   0x008029: u'EAGLE TECHNOLOGY, INC.',
   0x00802A: u'TEST SYSTEMS & SIMULATIONS INC',
   0x00802B: u'INTEGRATED MARKETING CO',
   0x00802C: u'THE SAGE GROUP PLC',
   0x00802D: u'XYLOGICS INC',
   0x00802E: u'CASTLE ROCK COMPUTING',
   0x00802F: u'NATIONAL INSTRUMENTS CORP.',
   0x008030: u'NEXUS ELECTRONICS',
   0x008031: u'BASYS, CORP.',
   0x008032: u'ACCESS CO., LTD.',
   0x008033: u'FORMATION, INC.',
   0x008034: u'SMT GOUPIL',
   0x008035: u'TECHNOLOGY WORKS, INC.',
   0x008036: u'REFLEX MANUFACTURING SYSTEMS',
   0x008037: u'Ericsson Group',
   0x008038: u'DATA RESEARCH & APPLICATIONS',
   0x008039: u'ALCATEL STC AUSTRALIA',
   0x00803A: u'VARITYPER, INC.',
   0x00803B: u'APT COMMUNICATIONS, INC.',
   0x00803C: u'TVS ELECTRONICS LTD',
   0x00803D: u'SURIGIKEN CO.,  LTD.',
   0x00803E: u'SYNERNETICS',
   0x00803F: u'TATUNG COMPANY',
   0x008040: u'JOHN FLUKE MANUFACTURING CO.',
   0x008041: u'VEB KOMBINAT ROBOTRON',
   0x008042: u'FORCE COMPUTERS',
   0x008043: u'NETWORLD, INC.',
   0x008044: u'SYSTECH COMPUTER CORP.',
   0x008045: u'MATSUSHITA ELECTRIC IND. CO',
   0x008046: u'UNIVERSITY OF TORONTO',
   0x008047: u'IN-NET CORP.',
   0x008048: u'COMPEX INCORPORATED',
   0x008049: u'NISSIN ELECTRIC CO., LTD.',
   0x00804A: u'PRO-LOG',
   0x00804B: u'EAGLE TECHNOLOGIES PTY.LTD.',
   0x00804C: u'CONTEC CO., LTD.',
   0x00804D: u'CYCLONE MICROSYSTEMS, INC.',
   0x00804E: u'APEX COMPUTER COMPANY',
   0x00804F: u'DAIKIN INDUSTRIES, LTD.',
   0x008050: u'ZIATECH CORPORATION',
   0x008051: u'FIBERMUX',
   0x008052: u'TECHNICALLY ELITE CONCEPTS',
   0x008053: u'INTELLICOM, INC.',
   0x008054: u'FRONTIER TECHNOLOGIES CORP.',
   0x008055: u'FERMILAB',
   0x008056: u'SPHINX ELEKTRONIK GMBH',
   0x008057: u'ADSOFT, LTD.',
   0x008058: u'PRINTER SYSTEMS CORPORATION',
   0x008059: u'STANLEY ELECTRIC CO., LTD',
   0x00805A: u'TULIP COMPUTERS INTERNAT\'L B.V',
   0x00805B: u'CONDOR SYSTEMS, INC.',
   0x00805C: u'AGILIS CORPORATION',
   0x00805D: u'CANSTAR',
   0x00805E: u'LSI LOGIC CORPORATION',
   0x00805F: u'COMPAQ COMPUTER CORPORATION',
   0x008060: u'NETWORK INTERFACE CORPORATION',
   0x008061: u'LITTON SYSTEMS, INC.',
   0x008062: u'INTERFACE  CO.',
   0x008063: u'RICHARD HIRSCHMANN GMBH & CO.',
   0x008064: u'WYSE TECHNOLOGY',
   0x008065: u'CYBERGRAPHIC SYSTEMS PTY LTD.',
   0x008066: u'ARCOM CONTROL SYSTEMS, LTD.',
   0x008067: u'SQUARE D COMPANY',
   0x008068: u'YAMATECH SCIENTIFIC LTD.',
   0x008069: u'COMPUTONE SYSTEMS',
   0x00806A: u'ERI (EMPAC RESEARCH INC.)',
   0x00806B: u'SCHMID TELECOMMUNICATION',
   0x00806C: u'CEGELEC PROJECTS LTD',
   0x00806D: u'CENTURY SYSTEMS CORP.',
   0x00806E: u'NIPPON STEEL CORPORATION',
   0x00806F: u'ONELAN LTD.',
   0x008070: u'COMPUTADORAS MICRON',
   0x008071: u'SAI TECHNOLOGY',
   0x008072: u'MICROPLEX SYSTEMS LTD.',
   0x008073: u'DWB ASSOCIATES',
   0x008074: u'FISHER CONTROLS',
   0x008075: u'PARSYTEC GMBH',
   0x008076: u'MCNC',
   0x008077: u'BROTHER INDUSTRIES, LTD.',
   0x008078: u'PRACTICAL PERIPHERALS, INC.',
   0x008079: u'MICROBUS DESIGNS LTD.',
   0x00807A: u'AITECH SYSTEMS LTD.',
   0x00807B: u'ARTEL COMMUNICATIONS CORP.',
   0x00807C: u'FIBERCOM, INC.',
   0x00807D: u'EQUINOX SYSTEMS INC.',
   0x00807E: u'SOUTHERN PACIFIC LTD.',
   0x00807F: u'DY-4 INCORPORATED',
   0x008080: u'DATAMEDIA CORPORATION',
   0x008081: u'KENDALL SQUARE RESEARCH CORP.',
   0x008082: u'PEP MODULAR COMPUTERS GMBH',
   0x008083: u'AMDAHL',
   0x008084: u'THE CLOUD INC.',
   0x008085: u'H-THREE SYSTEMS CORPORATION',
   0x008086: u'COMPUTER GENERATION INC.',
   0x008087: u'OKI ELECTRIC INDUSTRY CO., LTD',
   0x008088: u'VICTOR COMPANY OF JAPAN, LTD.',
   0x008089: u'TECNETICS (PTY) LTD.',
   0x00808A: u'SUMMIT MICROSYSTEMS CORP.',
   0x00808B: u'DACOLL LIMITED',
   0x00808C: u'NetScout Systems, Inc.',
   0x00808D: u'WESTCOAST TECHNOLOGY B.V.',
   0x00808E: u'RADSTONE TECHNOLOGY',
   0x00808F: u'C. ITOH ELECTRONICS, INC.',
   0x008090: u'MICROTEK INTERNATIONAL, INC.',
   0x008091: u'TOKYO ELECTRIC CO.,LTD',
   0x008092: u'JAPAN COMPUTER INDUSTRY, INC.',
   0x008093: u'XYRON CORPORATION',
   0x008094: u'ALFA LAVAL AUTOMATION AB',
   0x008095: u'BASIC MERTON HANDELSGES.M.B.H.',
   0x008096: u'HUMAN DESIGNED SYSTEMS, INC.',
   0x008097: u'CENTRALP AUTOMATISMES',
   0x008098: u'TDK CORPORATION',
   0x008099: u'KLOCKNER MOELLER IPC',
   0x00809A: u'NOVUS NETWORKS LTD',
   0x00809B: u'JUSTSYSTEM CORPORATION',
   0x00809C: u'LUXCOM, INC.',
   0x00809D: u'Commscraft Ltd.',
   0x00809E: u'DATUS GMBH',
   0x00809F: u'ALCATEL BUSINESS SYSTEMS',
   0x0080A0: u'EDISA HEWLETT PACKARD S/A',
   0x0080A1: u'MICROTEST, INC.',
   0x0080A2: u'CREATIVE ELECTRONIC SYSTEMS',
   0x0080A3: u'LANTRONIX',
   0x0080A4: u'LIBERTY ELECTRONICS',
   0x0080A5: u'SPEED INTERNATIONAL',
   0x0080A6: u'REPUBLIC TECHNOLOGY, INC.',
   0x0080A7: u'MEASUREX CORP.',
   0x0080A8: u'VITACOM CORPORATION',
   0x0080A9: u'CLEARPOINT RESEARCH',
   0x0080AA: u'MAXPEED',
   0x0080AB: u'DUKANE NETWORK INTEGRATION',
   0x0080AC: u'IMLOGIX, DIVISION OF GENESYS',
   0x0080AD: u'CNET TECHNOLOGY, INC.',
   0x0080AE: u'HUGHES NETWORK SYSTEMS',
   0x0080AF: u'ALLUMER CO., LTD.',
   0x0080B0: u'ADVANCED INFORMATION',
   0x0080B1: u'SOFTCOM A/S',
   0x0080B2: u'NETWORK EQUIPMENT TECHNOLOGIES',
   0x0080B3: u'AVAL DATA CORPORATION',
   0x0080B4: u'SOPHIA SYSTEMS',
   0x0080B5: u'UNITED NETWORKS INC.',
   0x0080B6: u'THEMIS COMPUTER',
   0x0080B7: u'STELLAR COMPUTER',
   0x0080B8: u'BUG, INCORPORATED',
   0x0080B9: u'ARCHE TECHNOLIGIES INC.',
   0x0080BA: u'SPECIALIX (ASIA) PTE, LTD',
   0x0080BB: u'HUGHES LAN SYSTEMS',
   0x0080BC: u'HITACHI ENGINEERING CO., LTD',
   0x0080BD: u'THE FURUKAWA ELECTRIC CO., LTD',
   0x0080BE: u'ARIES RESEARCH',
   0x0080BF: u'TAKAOKA ELECTRIC MFG. CO. LTD.',
   0x0080C0: u'PENRIL DATACOMM',
   0x0080C1: u'LANEX CORPORATION',
   0x0080C2: u'IEEE 802.1 COMMITTEE',
   0x0080C3: u'BICC INFORMATION SYSTEMS & SVC',
   0x0080C4: u'DOCUMENT TECHNOLOGIES, INC.',
   0x0080C5: u'NOVELLCO DE MEXICO',
   0x0080C6: u'NATIONAL DATACOMM CORPORATION',
   0x0080C7: u'XIRCOM',
   0x0080C8: u'D-LINK SYSTEMS, INC.',
   0x0080C9: u'ALBERTA MICROELECTRONIC CENTRE',
   0x0080CA: u'NETCOM RESEARCH INCORPORATED',
   0x0080CB: u'FALCO DATA PRODUCTS',
   0x0080CC: u'MICROWAVE BYPASS SYSTEMS',
   0x0080CD: u'MICRONICS COMPUTER, INC.',
   0x0080CE: u'BROADCAST TELEVISION SYSTEMS',
   0x0080CF: u'EMBEDDED PERFORMANCE INC.',
   0x0080D0: u'COMPUTER PERIPHERALS, INC.',
   0x0080D1: u'KIMTRON CORPORATION',
   0x0080D2: u'SHINNIHONDENKO CO., LTD.',
   0x0080D3: u'SHIVA CORP.',
   0x0080D4: u'CHASE RESEARCH LTD.',
   0x0080D5: u'CADRE TECHNOLOGIES',
   0x0080D6: u'NUVOTECH, INC.',
   0x0080D7: u'Fantum Engineering',
   0x0080D8: u'NETWORK PERIPHERALS INC.',
   0x0080D9: u'EMK ELEKTRONIK',
   0x0080DA: u'BRUEL & KJAER',
   0x0080DB: u'GRAPHON CORPORATION',
   0x0080DC: u'PICKER INTERNATIONAL',
   0x0080DD: u'GMX INC/GIMIX',
   0x0080DE: u'GIPSI S.A.',
   0x0080DF: u'ADC CODENOLL TECHNOLOGY CORP.',
   0x0080E0: u'XTP SYSTEMS, INC.',
   0x0080E1: u'STMICROELECTRONICS',
   0x0080E2: u'T.D.I. CO., LTD.',
   0x0080E3: u'CORAL NETWORK CORPORATION',
   0x0080E4: u'NORTHWEST DIGITAL SYSTEMS, INC',
   0x0080E5: u'LSI Logic Corporation',
   0x0080E6: u'PEER NETWORKS, INC.',
   0x0080E7: u'LYNWOOD SCIENTIFIC DEV. LTD.',
   0x0080E8: u'CUMULUS CORPORATIION',
   0x0080E9: u'Madge Ltd.',
   0x0080EA: u'ADVA Optical Networking Ltd.',
   0x0080EB: u'COMPCONTROL B.V.',
   0x0080EC: u'SUPERCOMPUTING SOLUTIONS, INC.',
   0x0080ED: u'IQ TECHNOLOGIES, INC.',
   0x0080EE: u'THOMSON CSF',
   0x0080EF: u'RATIONAL',
   0x0080F0: u'Panasonic Communications Co., Ltd.',
   0x0080F1: u'OPUS SYSTEMS',
   0x0080F2: u'RAYCOM SYSTEMS INC',
   0x0080F3: u'SUN ELECTRONICS CORP.',
   0x0080F4: u'TELEMECANIQUE ELECTRIQUE',
   0x0080F5: u'QUANTEL LTD',
   0x0080F6: u'SYNERGY MICROSYSTEMS',
   0x0080F7: u'ZENITH ELECTRONICS',
   0x0080F8: u'MIZAR, INC.',
   0x0080F9: u'HEURIKON CORPORATION',
   0x0080FA: u'RWT GMBH',
   0x0080FB: u'BVM LIMITED',
   0x0080FC: u'AVATAR CORPORATION',
   0x0080FD: u'EXSCEED CORPRATION',
   0x0080FE: u'AZURE TECHNOLOGIES, INC.',
   0x0080FF: u'SOC. DE TELEINFORMATIQUE RTC',
   0x009000: u'DIAMOND MULTIMEDIA',
   0x009001: u'NISHIMU ELECTRONICS INDUSTRIES CO., LTD.',
   0x009002: u'ALLGON AB',
   0x009003: u'APLIO',
   0x009004: u'3COM EUROPE LTD.',
   0x009005: u'PROTECH SYSTEMS CO., LTD.',
   0x009006: u'HAMAMATSU PHOTONICS K.K.',
   0x009007: u'DOMEX TECHNOLOGY CORP.',
   0x009008: u'HanA Systems Inc.',
   0x009009: u'i Controls, Inc.',
   0x00900A: u'PROTON ELECTRONIC INDUSTRIAL CO., LTD.',
   0x00900B: u'LANNER ELECTRONICS, INC.',
   0x00900C: u'CISCO SYSTEMS, INC.',
   0x00900D: u'Overland Storage Inc.',
   0x00900E: u'HANDLINK TECHNOLOGIES, INC.',
   0x00900F: u'KAWASAKI HEAVY INDUSTRIES, LTD',
   0x009010: u'SIMULATION LABORATORIES, INC.',
   0x009011: u'WAVTrace, Inc.',
   0x009012: u'GLOBESPAN SEMICONDUCTOR, INC.',
   0x009013: u'SAMSAN CORP.',
   0x009014: u'ROTORK INSTRUMENTS, LTD.',
   0x009015: u'CENTIGRAM COMMUNICATIONS CORP.',
   0x009016: u'ZAC',
   0x009017: u'ZYPCOM, INC.',
   0x009018: u'ITO ELECTRIC INDUSTRY CO, LTD.',
   0x009019: u'HERMES ELECTRONICS CO., LTD.',
   0x00901A: u'UNISPHERE SOLUTIONS',
   0x00901B: u'DIGITAL CONTROLS',
   0x00901C: u'mps Software Gmbh',
   0x00901D: u'PEC (NZ) LTD.',
   0x00901E: u'SELESTA INGEGNE RIA S.P.A.',
   0x00901F: u'ADTEC PRODUCTIONS, INC.',
   0x009020: u'PHILIPS ANALYTICAL X-RAY B.V.',
   0x009021: u'CISCO SYSTEMS, INC.',
   0x009022: u'IVEX',
   0x009023: u'ZILOG INC.',
   0x009024: u'PIPELINKS, INC.',
   0x009025: u'VISION SYSTEMS LTD. PTY',
   0x009026: u'ADVANCED SWITCHING COMMUNICATIONS, INC.',
   0x009027: u'INTEL CORPORATION',
   0x009028: u'NIPPON SIGNAL CO., LTD.',
   0x009029: u'CRYPTO AG',
   0x00902A: u'COMMUNICATION DEVICES, INC.',
   0x00902B: u'CISCO SYSTEMS, INC.',
   0x00902C: u'DATA & CONTROL EQUIPMENT LTD.',
   0x00902D: u'DATA ELECTRONICS (AUST.) PTY, LTD.',
   0x00902E: u'NAMCO LIMITED',
   0x00902F: u'NETCORE SYSTEMS, INC.',
   0x009030: u'HONEYWELL-DATING',
   0x009031: u'MYSTICOM, LTD.',
   0x009032: u'PELCOMBE GROUP LTD.',
   0x009033: u'INNOVAPHONE AG',
   0x009034: u'IMAGIC, INC.',
   0x009035: u'ALPHA TELECOM, INC.',
   0x009036: u'ens, inc.',
   0x009037: u'ACUCOMM, INC.',
   0x009038: u'FOUNTAIN TECHNOLOGIES, INC.',
   0x009039: u'SHASTA NETWORKS',
   0x00903A: u'NIHON MEDIA TOOL INC.',
   0x00903B: u'TriEMS Research Lab, Inc.',
   0x00903C: u'ATLANTIC NETWORK SYSTEMS',
   0x00903D: u'BIOPAC SYSTEMS, INC.',
   0x00903E: u'N.V. PHILIPS INDUSTRIAL ACTIVITIES',
   0x00903F: u'AZTEC RADIOMEDIA',
   0x009040: u'Siemens Network Convergence LLC',
   0x009041: u'APPLIED DIGITAL ACCESS',
   0x009042: u'ECCS, Inc.',
   0x009043: u'NICHIBEI DENSHI CO., LTD.',
   0x009044: u'ASSURED DIGITAL, INC.',
   0x009045: u'Marconi Communications',
   0x009046: u'DEXDYNE, LTD.',
   0x009047: u'GIGA FAST E. LTD.',
   0x009048: u'ZEAL CORPORATION',
   0x009049: u'ENTRIDIA CORPORATION',
   0x00904A: u'CONCUR SYSTEM TECHNOLOGIES',
   0x00904B: u'GemTek Technology Co., Ltd.',
   0x00904C: u'EPIGRAM, INC.',
   0x00904D: u'SPEC S.A.',
   0x00904E: u'DELEM BV',
   0x00904F: u'ABB POWER T&D COMPANY, INC.',
   0x009050: u'TELESTE OY',
   0x009051: u'ULTIMATE TECHNOLOGY CORP.',
   0x009052: u'SELCOM ELETTRONICA S.R.L.',
   0x009053: u'DAEWOO ELECTRONICS CO., LTD.',
   0x009054: u'INNOVATIVE SEMICONDUCTORS, INC',
   0x009055: u'PARKER HANNIFIN CORPORATION COMPUMOTOR DIVISION',
   0x009056: u'TELESTREAM, INC.',
   0x009057: u'AANetcom, Inc.',
   0x009058: u'Ultra Electronics Ltd., Command and Control Systems',
   0x009059: u'TELECOM DEVICE K.K.',
   0x00905A: u'DEARBORN GROUP, INC.',
   0x00905B: u'RAYMOND AND LAE ENGINEERING',
   0x00905C: u'EDMI',
   0x00905D: u'NETCOM SICHERHEITSTECHNIK GmbH',
   0x00905E: u'RAULAND-BORG CORPORATION',
   0x00905F: u'CISCO SYSTEMS, INC.',
   0x009060: u'SYSTEM CREATE CORP.',
   0x009061: u'PACIFIC RESEARCH & ENGINEERING CORPORATION',
   0x009062: u'ICP VORTEX COMPUTERSYSTEME GmbH',
   0x009063: u'COHERENT COMMUNICATIONS SYSTEMS CORPORATION',
   0x009064: u'THOMSON BROADCAST SYSTEMS',
   0x009065: u'FINISAR CORPORATION',
   0x009066: u'Troika Networks, Inc.',
   0x009067: u'WalkAbout Computers, Inc.',
   0x009068: u'DVT CORP.',
   0x009069: u'JUNIPER NETWORKS, INC.',
   0x00906A: u'TURNSTONE SYSTEMS, INC.',
   0x00906B: u'APPLIED RESOURCES, INC.',
   0x00906C: u'Sartorius Hamburg GmbH',
   0x00906D: u'CISCO SYSTEMS, INC.',
   0x00906E: u'PRAXON, INC.',
   0x00906F: u'CISCO SYSTEMS, INC.',
   0x009070: u'NEO NETWORKS, INC.',
   0x009071: u'Applied Innovation Inc.',
   0x009072: u'SIMRAD AS',
   0x009073: u'GAIO TECHNOLOGY',
   0x009074: u'ARGON NETWORKS, INC.',
   0x009075: u'NEC DO BRASIL S.A.',
   0x009076: u'FMT AIRCRAFT GATE SUPPORT SYSTEMS AB',
   0x009077: u'ADVANCED FIBRE COMMUNICATIONS',
   0x009078: u'MER TELEMANAGEMENT SOLUTIONS, LTD.',
   0x009079: u'ClearOne, Inc.',
   0x00907A: u'SPECTRALINK CORP.',
   0x00907B: u'E-TECH, INC.',
   0x00907C: u'DIGITALCAST, INC.',
   0x00907D: u'Lake Communications',
   0x00907E: u'VETRONIX CORP.',
   0x00907F: u'WatchGuard Technologies, Inc.',
   0x009080: u'NOT LIMITED, INC.',
   0x009081: u'ALOHA NETWORKS, INC.',
   0x009082: u'FORCE INSTITUTE',
   0x009083: u'TURBO COMMUNICATION, INC.',
   0x009084: u'ATECH SYSTEM',
   0x009085: u'GOLDEN ENTERPRISES, INC.',
   0x009086: u'CISCO SYSTEMS, INC.',
   0x009087: u'ITIS',
   0x009088: u'BAXALL SECURITY LTD.',
   0x009089: u'SOFTCOM MICROSYSTEMS, INC.',
   0x00908A: u'BAYLY COMMUNICATIONS, INC.',
   0x00908B: u'PFU Systems, Inc.',
   0x00908C: u'ETREND ELECTRONICS, INC.',
   0x00908D: u'VICKERS ELECTRONICS SYSTEMS',
   0x00908E: u'Nortel Networks Broadband Access',
   0x00908F: u'AUDIO CODES LTD.',
   0x009090: u'I-BUS',
   0x009091: u'DigitalScape, Inc.',
   0x009092: u'CISCO SYSTEMS, INC.',
   0x009093: u'NANAO CORPORATION',
   0x009094: u'OSPREY TECHNOLOGIES, INC.',
   0x009095: u'UNIVERSAL AVIONICS',
   0x009096: u'ASKEY COMPUTER CORP.',
   0x009097: u'SYCAMORE NETWORKS',
   0x009098: u'SBC DESIGNS, INC.',
   0x009099: u'ALLIED TELESIS, K.K.',
   0x00909A: u'ONE WORLD SYSTEMS, INC.',
   0x00909B: u'MARKPOINT AB',
   0x00909C: u'Terayon Communications Systems',
   0x00909D: u'NovaTech Process Solutions, LLC',
   0x00909E: u'Critical IO, LLC',
   0x00909F: u'DIGI-DATA CORPORATION',
   0x0090A0: u'8X8 INC.',
   0x0090A1: u'FLYING PIG SYSTEMS, LTD.',
   0x0090A2: u'CYBERTAN TECHNOLOGY, INC.',
   0x0090A3: u'Corecess Inc.',
   0x0090A4: u'ALTIGA NETWORKS',
   0x0090A5: u'SPECTRA LOGIC',
   0x0090A6: u'CISCO SYSTEMS, INC.',
   0x0090A7: u'CLIENTEC CORPORATION',
   0x0090A8: u'NineTiles Networks, Ltd.',
   0x0090A9: u'WESTERN DIGITAL',
   0x0090AA: u'INDIGO ACTIVE VISION SYSTEMS LIMITED',
   0x0090AB: u'CISCO SYSTEMS, INC.',
   0x0090AC: u'OPTIVISION, INC.',
   0x0090AD: u'ASPECT ELECTRONICS, INC.',
   0x0090AE: u'ITALTEL S.p.A.',
   0x0090AF: u'J. MORITA MFG. CORP.',
   0x0090B0: u'VADEM',
   0x0090B1: u'CISCO SYSTEMS, INC.',
   0x0090B2: u'AVICI SYSTEMS INC.',
   0x0090B3: u'AGRANAT SYSTEMS',
   0x0090B4: u'WILLOWBROOK TECHNOLOGIES',
   0x0090B5: u'NIKON CORPORATION',
   0x0090B6: u'FIBEX SYSTEMS',
   0x0090B7: u'DIGITAL LIGHTWAVE, INC.',
   0x0090B8: u'ROHDE & SCHWARZ GMBH & CO. KG',
   0x0090B9: u'BERAN INSTRUMENTS LTD.',
   0x0090BA: u'VALID NETWORKS, INC.',
   0x0090BB: u'TAINET COMMUNICATION SYSTEM Corp.',
   0x0090BC: u'TELEMANN CO., LTD.',
   0x0090BD: u'OMNIA COMMUNICATIONS, INC.',
   0x0090BE: u'IBC/INTEGRATED BUSINESS COMPUTERS',
   0x0090BF: u'CISCO SYSTEMS, INC.',
   0x0090C0: u'K.J. LAW ENGINEERS, INC.',
   0x0090C1: u'Peco II, Inc.',
   0x0090C2: u'JK microsystems, Inc.',
   0x0090C3: u'TOPIC SEMICONDUCTOR CORP.',
   0x0090C4: u'JAVELIN SYSTEMS, INC.',
   0x0090C5: u'INTERNET MAGIC, INC.',
   0x0090C6: u'OPTIM SYSTEMS, INC.',
   0x0090C7: u'ICOM INC.',
   0x0090C8: u'WAVERIDER COMMUNICATIONS (CANADA) INC.',
   0x0090C9: u'DPAC Technologies',
   0x0090CA: u'ACCORD VIDEO TELECOMMUNICATIONS, LTD.',
   0x0090CB: u'Wireless OnLine, Inc.',
   0x0090CC: u'PLANET COMMUNICATIONS, INC.',
   0x0090CD: u'ENT-EMPRESA NACIONAL DE TELECOMMUNICACOES, S.A.',
   0x0090CE: u'TETRA GmbH',
   0x0090CF: u'NORTEL',
   0x0090D0: u'Thomson Telecom Belgium',
   0x0090D1: u'LEICHU ENTERPRISE CO., LTD.',
   0x0090D2: u'ARTEL VIDEO SYSTEMS',
   0x0090D3: u'GIESECKE & DEVRIENT GmbH',
   0x0090D4: u'BindView Development Corp.',
   0x0090D5: u'EUPHONIX, INC.',
   0x0090D6: u'CRYSTAL GROUP',
   0x0090D7: u'NetBoost Corp.',
   0x0090D8: u'WHITECROSS SYSTEMS',
   0x0090D9: u'CISCO SYSTEMS, INC.',
   0x0090DA: u'DYNARC, INC.',
   0x0090DB: u'NEXT LEVEL COMMUNICATIONS',
   0x0090DC: u'TECO INFORMATION SYSTEMS',
   0x0090DD: u'THE MIHARU COMMUNICATIONS CO., LTD.',
   0x0090DE: u'CARDKEY SYSTEMS, INC.',
   0x0090DF: u'MITSUBISHI CHEMICAL AMERICA, INC.',
   0x0090E0: u'SYSTRAN CORP.',
   0x0090E1: u'TELENA S.P.A.',
   0x0090E2: u'DISTRIBUTED PROCESSING TECHNOLOGY',
   0x0090E3: u'AVEX ELECTRONICS INC.',
   0x0090E4: u'NEC AMERICA, INC.',
   0x0090E5: u'TEKNEMA, INC.',
   0x0090E6: u'ACER LABORATORIES, INC.',
   0x0090E7: u'HORSCH ELEKTRONIK AG',
   0x0090E8: u'MOXA TECHNOLOGIES CORP., LTD.',
   0x0090E9: u'JANZ COMPUTER AG',
   0x0090EA: u'ALPHA TECHNOLOGIES, INC.',
   0x0090EB: u'SENTRY TELECOM SYSTEMS',
   0x0090EC: u'PYRESCOM',
   0x0090ED: u'CENTRAL SYSTEM RESEARCH CO., LTD.',
   0x0090EE: u'PERSONAL COMMUNICATIONS TECHNOLOGIES',
   0x0090EF: u'INTEGRIX, INC.',
   0x0090F0: u'Harmonic Video Systems Ltd.',
   0x0090F1: u'DOT HILL SYSTEMS CORPORATION',
   0x0090F2: u'CISCO SYSTEMS, INC.',
   0x0090F3: u'ASPECT COMMUNICATIONS',
   0x0090F4: u'LIGHTNING INSTRUMENTATION',
   0x0090F5: u'CLEVO CO.',
   0x0090F6: u'ESCALATE NETWORKS, INC.',
   0x0090F7: u'NBASE COMMUNICATIONS LTD.',
   0x0090F8: u'MEDIATRIX TELECOM',
   0x0090F9: u'LEITCH',
   0x0090FA: u'EMULEX Corp',
   0x0090FB: u'PORTWELL, INC.',
   0x0090FC: u'NETWORK COMPUTING DEVICES',
   0x0090FD: u'CopperCom, Inc.',
   0x0090FE: u'ELECOM CO., LTD.  (LANEED DIV.)',
   0x0090FF: u'TELLUS TECHNOLOGY INC.',
   0x0091D6: u'Crystal Group, Inc.',
   0x009D8E: u'CARDIAC RECORDERS, INC.',
   0x00A000: u'CENTILLION NETWORKS, INC.',
   0x00A001: u'DRS Signal Solutions',
   0x00A002: u'LEEDS & NORTHRUP AUSTRALIA PTY LTD',
   0x00A003: u'STAEFA CONTROL SYSTEM',
   0x00A004: u'NETPOWER, INC.',
   0x00A005: u'DANIEL INSTRUMENTS, LTD.',
   0x00A006: u'IMAGE DATA PROCESSING SYSTEM GROUP',
   0x00A007: u'APEXX TECHNOLOGY, INC.',
   0x00A008: u'NETCORP',
   0x00A009: u'WHITETREE NETWORK',
   0x00A00A: u'Airspan',
   0x00A00B: u'COMPUTEX CO., LTD.',
   0x00A00C: u'KINGMAX TECHNOLOGY, INC.',
   0x00A00D: u'THE PANDA PROJECT',
   0x00A00E: u'VISUAL NETWORKS, INC.',
   0x00A00F: u'Broadband Technologies',
   0x00A010: u'SYSLOGIC DATENTECHNIK AG',
   0x00A011: u'MUTOH INDUSTRIES LTD.',
   0x00A012: u'B.A.T.M. ADVANCED TECHNOLOGIES',
   0x00A013: u'TELTREND LTD.',
   0x00A014: u'CSIR',
   0x00A015: u'WYLE',
   0x00A016: u'MICROPOLIS CORP.',
   0x00A017: u'J B M CORPORATION',
   0x00A018: u'CREATIVE CONTROLLERS, INC.',
   0x00A019: u'NEBULA CONSULTANTS, INC.',
   0x00A01A: u'BINAR ELEKTRONIK AB',
   0x00A01B: u'PREMISYS COMMUNICATIONS, INC.',
   0x00A01C: u'NASCENT NETWORKS CORPORATION',
   0x00A01D: u'SIXNET',
   0x00A01E: u'EST CORPORATION',
   0x00A01F: u'TRICORD SYSTEMS, INC.',
   0x00A020: u'CITICORP/TTI',
   0x00A021: u'General Dynamics',
   0x00A022: u'CENTRE FOR DEVELOPMENT OF ADVANCED COMPUTING',
   0x00A023: u'APPLIED CREATIVE TECHNOLOGY, INC.',
   0x00A024: u'3COM CORPORATION',
   0x00A025: u'REDCOM LABS INC.',
   0x00A026: u'TELDAT, S.A.',
   0x00A027: u'FIREPOWER SYSTEMS, INC.',
   0x00A028: u'CONNER PERIPHERALS',
   0x00A029: u'COULTER CORPORATION',
   0x00A02A: u'TRANCELL SYSTEMS',
   0x00A02B: u'TRANSITIONS RESEARCH CORP.',
   0x00A02C: u'interWAVE Communications',
   0x00A02D: u'1394 Trade Association',
   0x00A02E: u'BRAND COMMUNICATIONS, LTD.',
   0x00A02F: u'PIRELLI CAVI',
   0x00A030: u'CAPTOR NV/SA',
   0x00A031: u'HAZELTINE CORPORATION, MS 1-17',
   0x00A032: u'GES SINGAPORE PTE. LTD.',
   0x00A033: u'imc MeBsysteme GmbH',
   0x00A034: u'AXEL',
   0x00A035: u'CYLINK CORPORATION',
   0x00A036: u'APPLIED NETWORK TECHNOLOGY',
   0x00A037: u'DATASCOPE CORPORATION',
   0x00A038: u'EMAIL ELECTRONICS',
   0x00A039: u'ROSS TECHNOLOGY, INC.',
   0x00A03A: u'KUBOTEK CORPORATION',
   0x00A03B: u'TOSHIN ELECTRIC CO., LTD.',
   0x00A03C: u'EG&G NUCLEAR INSTRUMENTS',
   0x00A03D: u'OPTO-22',
   0x00A03E: u'ATM FORUM',
   0x00A03F: u'COMPUTER SOCIETY MICROPROCESSOR & MICROPROCESSOR STANDARDS C',
   0x00A040: u'APPLE COMPUTER',
   0x00A041: u'INFICON',
   0x00A042: u'SPUR PRODUCTS CORP.',
   0x00A043: u'AMERICAN TECHNOLOGY LABS, INC.',
   0x00A044: u'NTT IT CO., LTD.',
   0x00A045: u'PHOENIX CONTACT GMBH & CO.',
   0x00A046: u'SCITEX CORP. LTD.',
   0x00A047: u'INTEGRATED FITNESS CORP.',
   0x00A048: u'QUESTECH, LTD.',
   0x00A049: u'DIGITECH INDUSTRIES, INC.',
   0x00A04A: u'NISSHIN ELECTRIC CO., LTD.',
   0x00A04B: u'TFL LAN INC.',
   0x00A04C: u'INNOVATIVE SYSTEMS & TECHNOLOGIES, INC.',
   0x00A04D: u'EDA INSTRUMENTS, INC.',
   0x00A04E: u'VOELKER TECHNOLOGIES, INC.',
   0x00A04F: u'AMERITEC CORP.',
   0x00A050: u'CYPRESS SEMICONDUCTOR',
   0x00A051: u'ANGIA COMMUNICATIONS. INC.',
   0x00A052: u'STANILITE ELECTRONICS PTY. LTD',
   0x00A053: u'COMPACT DEVICES, INC.',
   0x00A054: u'PRIVATE',
   0x00A055: u'Data Device Corporation',
   0x00A056: u'MICROPROSS',
   0x00A057: u'LANCOM Systems GmbH',
   0x00A058: u'GLORY, LTD.',
   0x00A059: u'HAMILTON HALLMARK',
   0x00A05A: u'KOFAX IMAGE PRODUCTS',
   0x00A05B: u'MARQUIP, INC.',
   0x00A05C: u'INVENTORY CONVERSION, INC./',
   0x00A05D: u'CS COMPUTER SYSTEME GmbH',
   0x00A05E: u'MYRIAD LOGIC INC.',
   0x00A05F: u'BTG ENGINEERING BV',
   0x00A060: u'ACER PERIPHERALS, INC.',
   0x00A061: u'PURITAN BENNETT',
   0x00A062: u'AES PRODATA',
   0x00A063: u'JRL SYSTEMS, INC.',
   0x00A064: u'KVB/ANALECT',
   0x00A065: u'Symantec Corporation',
   0x00A066: u'ISA CO., LTD.',
   0x00A067: u'NETWORK SERVICES GROUP',
   0x00A068: u'BHP LIMITED',
   0x00A069: u'Symmetricom, Inc.',
   0x00A06A: u'Verilink Corporation',
   0x00A06B: u'DMS DORSCH MIKROSYSTEM GMBH',
   0x00A06C: u'SHINDENGEN ELECTRIC MFG. CO., LTD.',
   0x00A06D: u'MANNESMANN TALLY CORPORATION',
   0x00A06E: u'AUSTRON, INC.',
   0x00A06F: u'THE APPCON GROUP, INC.',
   0x00A070: u'COASTCOM',
   0x00A071: u'VIDEO LOTTERY TECHNOLOGIES,INC',
   0x00A072: u'OVATION SYSTEMS LTD.',
   0x00A073: u'COM21, INC.',
   0x00A074: u'PERCEPTION TECHNOLOGY',
   0x00A075: u'MICRON TECHNOLOGY, INC.',
   0x00A076: u'CARDWARE LAB, INC.',
   0x00A077: u'FUJITSU NEXION, INC.',
   0x00A078: u'Marconi Communications',
   0x00A079: u'ALPS ELECTRIC (USA), INC.',
   0x00A07A: u'ADVANCED PERIPHERALS TECHNOLOGIES, INC.',
   0x00A07B: u'DAWN COMPUTER INCORPORATION',
   0x00A07C: u'TONYANG NYLON CO., LTD.',
   0x00A07D: u'SEEQ TECHNOLOGY, INC.',
   0x00A07E: u'AVID TECHNOLOGY, INC.',
   0x00A07F: u'GSM-SYNTEL, LTD.',
   0x00A080: u'SBE, Inc.',
   0x00A081: u'ALCATEL DATA NETWORKS',
   0x00A082: u'NKT ELEKTRONIK A/S',
   0x00A083: u'ASIMMPHONY TURKEY',
   0x00A084: u'DATAPLEX PTY. LTD.',
   0x00A085: u'PRIVATE',
   0x00A086: u'AMBER WAVE SYSTEMS, INC.',
   0x00A087: u'Zarlink Semiconductor Ltd.',
   0x00A088: u'ESSENTIAL COMMUNICATIONS',
   0x00A089: u'XPOINT TECHNOLOGIES, INC.',
   0x00A08A: u'BROOKTROUT TECHNOLOGY, INC.',
   0x00A08B: u'ASTON ELECTRONIC DESIGNS LTD.',
   0x00A08C: u'MultiMedia LANs, Inc.',
   0x00A08D: u'JACOMO CORPORATION',
   0x00A08E: u'Nokia Internet Communications',
   0x00A08F: u'DESKNET SYSTEMS, INC.',
   0x00A090: u'TimeStep Corporation',
   0x00A091: u'APPLICOM INTERNATIONAL',
   0x00A092: u'H. BOLLMANN MANUFACTURERS, LTD',
   0x00A093: u'B/E AEROSPACE, Inc.',
   0x00A094: u'COMSAT CORPORATION',
   0x00A095: u'ACACIA NETWORKS, INC.',
   0x00A096: u'MITUMI ELECTRIC CO., LTD.',
   0x00A097: u'JC INFORMATION SYSTEMS',
   0x00A098: u'NETWORK APPLIANCE CORP.',
   0x00A099: u'K-NET LTD.',
   0x00A09A: u'NIHON KOHDEN AMERICA',
   0x00A09B: u'QPSX COMMUNICATIONS, LTD.',
   0x00A09C: u'Xyplex, Inc.',
   0x00A09D: u'JOHNATHON FREEMAN TECHNOLOGIES',
   0x00A09E: u'ICTV',
   0x00A09F: u'COMMVISION CORP.',
   0x00A0A0: u'COMPACT DATA, LTD.',
   0x00A0A1: u'EPIC DATA INC.',
   0x00A0A2: u'DIGICOM S.P.A.',
   0x00A0A3: u'RELIABLE POWER METERS',
   0x00A0A4: u'MICROS SYSTEMS, INC.',
   0x00A0A5: u'TEKNOR MICROSYSTEME, INC.',
   0x00A0A6: u'M.I. SYSTEMS, K.K.',
   0x00A0A7: u'VORAX CORPORATION',
   0x00A0A8: u'RENEX CORPORATION',
   0x00A0A9: u'NAVTEL COMMUNICATIONS INC.',
   0x00A0AA: u'SPACELABS MEDICAL',
   0x00A0AB: u'NETCS INFORMATIONSTECHNIK GMBH',
   0x00A0AC: u'GILAT SATELLITE NETWORKS, LTD.',
   0x00A0AD: u'MARCONI SPA',
   0x00A0AE: u'NUCOM SYSTEMS, INC.',
   0x00A0AF: u'WMS INDUSTRIES',
   0x00A0B0: u'I-O DATA DEVICE, INC.',
   0x00A0B1: u'FIRST VIRTUAL CORPORATION',
   0x00A0B2: u'SHIMA SEIKI',
   0x00A0B3: u'ZYKRONIX',
   0x00A0B4: u'TEXAS MICROSYSTEMS, INC.',
   0x00A0B5: u'3H TECHNOLOGY',
   0x00A0B6: u'SANRITZ AUTOMATION CO., LTD.',
   0x00A0B7: u'CORDANT, INC.',
   0x00A0B8: u'SYMBIOS LOGIC INC.',
   0x00A0B9: u'EAGLE TECHNOLOGY, INC.',
   0x00A0BA: u'PATTON ELECTRONICS CO.',
   0x00A0BB: u'HILAN GMBH',
   0x00A0BC: u'VIASAT, INCORPORATED',
   0x00A0BD: u'I-TECH CORP.',
   0x00A0BE: u'INTEGRATED CIRCUIT SYSTEMS, INC. COMMUNICATIONS GROUP',
   0x00A0BF: u'WIRELESS DATA GROUP MOTOROLA',
   0x00A0C0: u'DIGITAL LINK CORP.',
   0x00A0C1: u'ORTIVUS MEDICAL AB',
   0x00A0C2: u'R.A. SYSTEMS CO., LTD.',
   0x00A0C3: u'UNICOMPUTER GMBH',
   0x00A0C4: u'CRISTIE ELECTRONICS LTD.',
   0x00A0C5: u'ZYXEL COMMUNICATION',
   0x00A0C6: u'QUALCOMM INCORPORATED',
   0x00A0C7: u'TADIRAN TELECOMMUNICATIONS',
   0x00A0C8: u'ADTRAN INC.',
   0x00A0C9: u'INTEL CORPORATION - HF1-06',
   0x00A0CA: u'FUJITSU DENSO LTD.',
   0x00A0CB: u'ARK TELECOMMUNICATIONS, INC.',
   0x00A0CC: u'LITE-ON COMMUNICATIONS, INC.',
   0x00A0CD: u'DR. JOHANNES HEIDENHAIN GmbH',
   0x00A0CE: u'ASTROCOM CORPORATION',
   0x00A0CF: u'SOTAS, INC.',
   0x00A0D0: u'TEN X TECHNOLOGY, INC.',
   0x00A0D1: u'INVENTEC CORPORATION',
   0x00A0D2: u'ALLIED TELESIS INTERNATIONAL CORPORATION',
   0x00A0D3: u'INSTEM COMPUTER SYSTEMS, LTD.',
   0x00A0D4: u'RADIOLAN,  INC.',
   0x00A0D5: u'SIERRA WIRELESS INC.',
   0x00A0D6: u'SBE, INC.',
   0x00A0D7: u'KASTEN CHASE APPLIED RESEARCH',
   0x00A0D8: u'SPECTRA - TEK',
   0x00A0D9: u'CONVEX COMPUTER CORPORATION',
   0x00A0DA: u'INTEGRATED SYSTEMS Technology, Inc.',
   0x00A0DB: u'FISHER & PAYKEL PRODUCTION',
   0x00A0DC: u'O.N. ELECTRONIC CO., LTD.',
   0x00A0DD: u'AZONIX CORPORATION',
   0x00A0DE: u'YAMAHA CORPORATION',
   0x00A0DF: u'STS TECHNOLOGIES, INC.',
   0x00A0E0: u'TENNYSON TECHNOLOGIES PTY LTD',
   0x00A0E1: u'WESTPORT RESEARCH ASSOCIATES, INC.',
   0x00A0E2: u'KEISOKU GIKEN CORP.',
   0x00A0E3: u'XKL SYSTEMS CORP.',
   0x00A0E4: u'OPTIQUEST',
   0x00A0E5: u'NHC COMMUNICATIONS',
   0x00A0E6: u'DIALOGIC CORPORATION',
   0x00A0E7: u'CENTRAL DATA CORPORATION',
   0x00A0E8: u'REUTERS HOLDINGS PLC',
   0x00A0E9: u'ELECTRONIC RETAILING SYSTEMS INTERNATIONAL',
   0x00A0EA: u'ETHERCOM CORP.',
   0x00A0EB: u'Encore Networks',
   0x00A0EC: u'TRANSMITTON LTD.',
   0x00A0ED: u'Brooks Automation, Inc.',
   0x00A0EE: u'NASHOBA NETWORKS',
   0x00A0EF: u'LUCIDATA LTD.',
   0x00A0F0: u'TORONTO MICROELECTRONICS INC.',
   0x00A0F1: u'MTI',
   0x00A0F2: u'INFOTEK COMMUNICATIONS, INC.',
   0x00A0F3: u'STAUBLI',
   0x00A0F4: u'GE',
   0x00A0F5: u'RADGUARD LTD.',
   0x00A0F6: u'AutoGas Systems Inc.',
   0x00A0F7: u'V.I COMPUTER CORP.',
   0x00A0F8: u'SYMBOL TECHNOLOGIES, INC.',
   0x00A0F9: u'BINTEC COMMUNICATIONS GMBH',
   0x00A0FA: u'Marconi Communication GmbH',
   0x00A0FB: u'TORAY ENGINEERING CO., LTD.',
   0x00A0FC: u'IMAGE SCIENCES, INC.',
   0x00A0FD: u'SCITEX DIGITAL PRINTING, INC.',
   0x00A0FE: u'BOSTON TECHNOLOGY, INC.',
   0x00A0FF: u'TELLABS OPERATIONS, INC.',
   0x00AA00: u'INTEL CORPORATION',
   0x00AA01: u'INTEL CORPORATION',
   0x00AA02: u'INTEL CORPORATION',
   0x00AA3C: u'OLIVETTI TELECOM SPA (OLTECO)',
   0x00B009: u'Grass Valley Group',
   0x00B017: u'InfoGear Technology Corp.',
   0x00B019: u'Casi-Rusco',
   0x00B01C: u'Westport Technologies',
   0x00B01E: u'Rantic Labs, Inc.',
   0x00B02A: u'ORSYS GmbH',
   0x00B02D: u'ViaGate Technologies, Inc.',
   0x00B03B: u'HiQ Networks',
   0x00B048: u'Marconi Communications Inc.',
   0x00B04A: u'Cisco Systems, Inc.',
   0x00B052: u'Intellon Corporation',
   0x00B064: u'Cisco Systems, Inc.',
   0x00B069: u'Honewell Oy',
   0x00B06D: u'Jones Futurex Inc.',
   0x00B080: u'Mannesmann Ipulsys B.V.',
   0x00B086: u'LocSoft Limited',
   0x00B08E: u'Cisco Systems, Inc.',
   0x00B091: u'Transmeta Corp.',
   0x00B094: u'Alaris, Inc.',
   0x00B09A: u'Morrow Technologies Corp.',
   0x00B09D: u'Point Grey Research Inc.',
   0x00B0AC: u'SIAE-Microelettronica S.p.A.',
   0x00B0AE: u'Symmetricom',
   0x00B0B3: u'Xstreamis PLC',
   0x00B0C2: u'Cisco Systems, Inc.',
   0x00B0C7: u'Tellabs Operations, Inc.',
   0x00B0CE: u'TECHNOLOGY RESCUE',
   0x00B0D0: u'Dell Computer Corp.',
   0x00B0DB: u'Nextcell, Inc.',
   0x00B0DF: u'Reliable Data Technology, Inc.',
   0x00B0E7: u'British Federal Ltd.',
   0x00B0EC: u'EACEM',
   0x00B0EE: u'Ajile Systems, Inc.',
   0x00B0F0: u'CALY NETWORKS',
   0x00B0F5: u'NetWorth Technologies, Inc.',
   0x00BAC0: u'Biometric Access Company',
   0x00BB01: u'OCTOTHORPE CORP.',
   0x00BBF0: u'UNGERMANN-BASS INC.',
   0x00C000: u'LANOPTICS, LTD.',
   0x00C001: u'DIATEK PATIENT MANAGMENT',
   0x00C002: u'SERCOMM CORPORATION',
   0x00C003: u'GLOBALNET COMMUNICATIONS',
   0x00C004: u'JAPAN BUSINESS COMPUTER CO.LTD',
   0x00C005: u'LIVINGSTON ENTERPRISES, INC.',
   0x00C006: u'NIPPON AVIONICS CO., LTD.',
   0x00C007: u'PINNACLE DATA SYSTEMS, INC.',
   0x00C008: u'SECO SRL',
   0x00C009: u'KT TECHNOLOGY (S) PTE LTD',
   0x00C00A: u'MICRO CRAFT',
   0x00C00B: u'NORCONTROL A.S.',
   0x00C00C: u'RELIA TECHNOLGIES',
   0x00C00D: u'ADVANCED LOGIC RESEARCH, INC.',
   0x00C00E: u'PSITECH, INC.',
   0x00C00F: u'QUANTUM SOFTWARE SYSTEMS LTD.',
   0x00C010: u'HIRAKAWA HEWTECH CORP.',
   0x00C011: u'INTERACTIVE COMPUTING DEVICES',
   0x00C012: u'NETSPAN CORPORATION',
   0x00C013: u'NETRIX',
   0x00C014: u'TELEMATICS CALABASAS INT\'L,INC',
   0x00C015: u'NEW MEDIA CORPORATION',
   0x00C016: u'ELECTRONIC THEATRE CONTROLS',
   0x00C017: u'FORTE NETWORKS',
   0x00C018: u'LANART CORPORATION',
   0x00C019: u'LEAP TECHNOLOGY, INC.',
   0x00C01A: u'COROMETRICS MEDICAL SYSTEMS',
   0x00C01B: u'SOCKET COMMUNICATIONS, INC.',
   0x00C01C: u'INTERLINK COMMUNICATIONS LTD.',
   0x00C01D: u'GRAND JUNCTION NETWORKS, INC.',
   0x00C01E: u'LA FRANCAISE DES JEUX',
   0x00C01F: u'S.E.R.C.E.L.',
   0x00C020: u'ARCO ELECTRONIC, CONTROL LTD.',
   0x00C021: u'NETEXPRESS',
   0x00C022: u'LASERMASTER TECHNOLOGIES, INC.',
   0x00C023: u'TUTANKHAMON ELECTRONICS',
   0x00C024: u'EDEN SISTEMAS DE COMPUTACAO SA',
   0x00C025: u'DATAPRODUCTS CORPORATION',
   0x00C026: u'LANS TECHNOLOGY CO., LTD.',
   0x00C027: u'CIPHER SYSTEMS, INC.',
   0x00C028: u'JASCO CORPORATION',
   0x00C029: u'Nexans Deutschland AG - ANS',
   0x00C02A: u'OHKURA ELECTRIC CO., LTD.',
   0x00C02B: u'GERLOFF GESELLSCHAFT FUR',
   0x00C02C: u'CENTRUM COMMUNICATIONS, INC.',
   0x00C02D: u'FUJI PHOTO FILM CO., LTD.',
   0x00C02E: u'NETWIZ',
   0x00C02F: u'OKUMA CORPORATION',
   0x00C030: u'INTEGRATED ENGINEERING B. V.',
   0x00C031: u'DESIGN RESEARCH SYSTEMS, INC.',
   0x00C032: u'I-CUBED LIMITED',
   0x00C033: u'TELEBIT COMMUNICATIONS APS',
   0x00C034: u'TRANSACTION NETWORK',
   0x00C035: u'QUINTAR COMPANY',
   0x00C036: u'RAYTECH ELECTRONIC CORP.',
   0x00C037: u'DYNATEM',
   0x00C038: u'RASTER IMAGE PROCESSING SYSTEM',
   0x00C039: u'Teridian Semiconductor Corporation',
   0x00C03A: u'MEN-MIKRO ELEKTRONIK GMBH',
   0x00C03B: u'MULTIACCESS COMPUTING CORP.',
   0x00C03C: u'TOWER TECH S.R.L.',
   0x00C03D: u'WIESEMANN & THEIS GMBH',
   0x00C03E: u'FA. GEBR. HELLER GMBH',
   0x00C03F: u'STORES AUTOMATED SYSTEMS, INC.',
   0x00C040: u'ECCI',
   0x00C041: u'DIGITAL TRANSMISSION SYSTEMS',
   0x00C042: u'DATALUX CORP.',
   0x00C043: u'STRATACOM',
   0x00C044: u'EMCOM CORPORATION',
   0x00C045: u'ISOLATION SYSTEMS, LTD.',
   0x00C046: u'KEMITRON LTD.',
   0x00C047: u'UNIMICRO SYSTEMS, INC.',
   0x00C048: u'BAY TECHNICAL ASSOCIATES',
   0x00C049: u'U.S. ROBOTICS, INC.',
   0x00C04A: u'GROUP 2000 AG',
   0x00C04B: u'CREATIVE MICROSYSTEMS',
   0x00C04C: u'DEPARTMENT OF FOREIGN AFFAIRS',
   0x00C04D: u'MITEC, INC.',
   0x00C04E: u'COMTROL CORPORATION',
   0x00C04F: u'DELL COMPUTER CORPORATION',
   0x00C050: u'TOYO DENKI SEIZO K.K.',
   0x00C051: u'ADVANCED INTEGRATION RESEARCH',
   0x00C052: u'BURR-BROWN',
   0x00C053: u'Concerto Software',
   0x00C054: u'NETWORK PERIPHERALS, LTD.',
   0x00C055: u'MODULAR COMPUTING TECHNOLOGIES',
   0x00C056: u'SOMELEC',
   0x00C057: u'MYCO ELECTRONICS',
   0x00C058: u'DATAEXPERT CORP.',
   0x00C059: u'NIPPON DENSO CO., LTD.',
   0x00C05A: u'SEMAPHORE COMMUNICATIONS CORP.',
   0x00C05B: u'NETWORKS NORTHWEST, INC.',
   0x00C05C: u'ELONEX PLC',
   0x00C05D: u'L&N TECHNOLOGIES',
   0x00C05E: u'VARI-LITE, INC.',
   0x00C05F: u'FINE-PAL COMPANY LIMITED',
   0x00C060: u'ID SCANDINAVIA AS',
   0x00C061: u'SOLECTEK CORPORATION',
   0x00C062: u'IMPULSE TECHNOLOGY',
   0x00C063: u'MORNING STAR TECHNOLOGIES, INC',
   0x00C064: u'GENERAL DATACOMM IND. INC.',
   0x00C065: u'SCOPE COMMUNICATIONS, INC.',
   0x00C066: u'DOCUPOINT, INC.',
   0x00C067: u'UNITED BARCODE INDUSTRIES',
   0x00C068: u'PHILIP DRAKE ELECTRONICS LTD.',
   0x00C069: u'Axxcelera Broadband Wireless',
   0x00C06A: u'ZAHNER-ELEKTRIK GMBH & CO. KG',
   0x00C06B: u'OSI PLUS CORPORATION',
   0x00C06C: u'SVEC COMPUTER CORP.',
   0x00C06D: u'BOCA RESEARCH, INC.',
   0x00C06E: u'HAFT TECHNOLOGY, INC.',
   0x00C06F: u'KOMATSU LTD.',
   0x00C070: u'SECTRA SECURE-TRANSMISSION AB',
   0x00C071: u'AREANEX COMMUNICATIONS, INC.',
   0x00C072: u'KNX LTD.',
   0x00C073: u'XEDIA CORPORATION',
   0x00C074: u'TOYODA AUTOMATIC LOOM',
   0x00C075: u'XANTE CORPORATION',
   0x00C076: u'I-DATA INTERNATIONAL A-S',
   0x00C077: u'DAEWOO TELECOM LTD.',
   0x00C078: u'COMPUTER SYSTEMS ENGINEERING',
   0x00C079: u'FONSYS CO.,LTD.',
   0x00C07A: u'PRIVA B.V.',
   0x00C07B: u'ASCEND COMMUNICATIONS, INC.',
   0x00C07C: u'HIGHTECH INFORMATION',
   0x00C07D: u'RISC DEVELOPMENTS LTD.',
   0x00C07E: u'KUBOTA CORPORATION ELECTRONIC',
   0x00C07F: u'NUPON COMPUTING CORP.',
   0x00C080: u'NETSTAR, INC.',
   0x00C081: u'METRODATA LTD.',
   0x00C082: u'MOORE PRODUCTS CO.',
   0x00C083: u'TRACE MOUNTAIN PRODUCTS, INC.',
   0x00C084: u'DATA LINK CORP. LTD.',
   0x00C085: u'ELECTRONICS FOR IMAGING, INC.',
   0x00C086: u'THE LYNK CORPORATION',
   0x00C087: u'UUNET TECHNOLOGIES, INC.',
   0x00C088: u'EKF ELEKTRONIK GMBH',
   0x00C089: u'TELINDUS DISTRIBUTION',
   0x00C08A: u'LAUTERBACH DATENTECHNIK GMBH',
   0x00C08B: u'RISQ MODULAR SYSTEMS, INC.',
   0x00C08C: u'PERFORMANCE TECHNOLOGIES, INC.',
   0x00C08D: u'TRONIX PRODUCT DEVELOPMENT',
   0x00C08E: u'NETWORK INFORMATION TECHNOLOGY',
   0x00C08F: u'Matsushita Electric Works, Ltd.',
   0x00C090: u'PRAIM S.R.L.',
   0x00C091: u'JABIL CIRCUIT, INC.',
   0x00C092: u'MENNEN MEDICAL INC.',
   0x00C093: u'ALTA RESEARCH CORP.',
   0x00C094: u'VMX INC.',
   0x00C095: u'ZNYX',
   0x00C096: u'TAMURA CORPORATION',
   0x00C097: u'ARCHIPEL SA',
   0x00C098: u'CHUNTEX ELECTRONIC CO., LTD.',
   0x00C099: u'YOSHIKI INDUSTRIAL CO.,LTD.',
   0x00C09A: u'PHOTONICS CORPORATION',
   0x00C09B: u'RELIANCE COMM/TEC, R-TEC',
   0x00C09C: u'TOA ELECTRONIC LTD.',
   0x00C09D: u'DISTRIBUTED SYSTEMS INT\'L, INC',
   0x00C09E: u'CACHE COMPUTERS, INC.',
   0x00C09F: u'QUANTA COMPUTER, INC.',
   0x00C0A0: u'ADVANCE MICRO RESEARCH, INC.',
   0x00C0A1: u'TOKYO DENSHI SEKEI CO.',
   0x00C0A2: u'INTERMEDIUM A/S',
   0x00C0A3: u'DUAL ENTERPRISES CORPORATION',
   0x00C0A4: u'UNIGRAF OY',
   0x00C0A5: u'DICKENS DATA SYSTEMS',
   0x00C0A6: u'EXICOM AUSTRALIA PTY. LTD',
   0x00C0A7: u'SEEL LTD.',
   0x00C0A8: u'GVC CORPORATION',
   0x00C0A9: u'BARRON MCCANN LTD.',
   0x00C0AA: u'SILICON VALLEY COMPUTER',
   0x00C0AB: u'Telco Systems, Inc.',
   0x00C0AC: u'GAMBIT COMPUTER COMMUNICATIONS',
   0x00C0AD: u'MARBEN COMMUNICATION SYSTEMS',
   0x00C0AE: u'TOWERCOM CO. INC. DBA PC HOUSE',
   0x00C0AF: u'TEKLOGIX INC.',
   0x00C0B0: u'GCC TECHNOLOGIES,INC.',
   0x00C0B1: u'GENIUS NET CO.',
   0x00C0B2: u'NORAND CORPORATION',
   0x00C0B3: u'COMSTAT DATACOMM CORPORATION',
   0x00C0B4: u'MYSON TECHNOLOGY, INC.',
   0x00C0B5: u'CORPORATE NETWORK SYSTEMS,INC.',
   0x00C0B6: u'Adaptec, Inc.',
   0x00C0B7: u'AMERICAN POWER CONVERSION CORP',
   0x00C0B8: u'FRASER\'S HILL LTD.',
   0x00C0B9: u'FUNK SOFTWARE, INC.',
   0x00C0BA: u'NETVANTAGE',
   0x00C0BB: u'FORVAL CREATIVE, INC.',
   0x00C0BC: u'TELECOM AUSTRALIA/CSSC',
   0x00C0BD: u'INEX TECHNOLOGIES, INC.',
   0x00C0BE: u'ALCATEL - SEL',
   0x00C0BF: u'TECHNOLOGY CONCEPTS, LTD.',
   0x00C0C0: u'SHORE MICROSYSTEMS, INC.',
   0x00C0C1: u'QUAD/GRAPHICS, INC.',
   0x00C0C2: u'INFINITE NETWORKS LTD.',
   0x00C0C3: u'ACUSON COMPUTED SONOGRAPHY',
   0x00C0C4: u'COMPUTER OPERATIONAL',
   0x00C0C5: u'SID INFORMATICA',
   0x00C0C6: u'PERSONAL MEDIA CORP.',
   0x00C0C7: u'SPARKTRUM MICROSYSTEMS, INC.',
   0x00C0C8: u'MICRO BYTE PTY. LTD.',
   0x00C0C9: u'ELSAG BAILEY PROCESS',
   0x00C0CA: u'ALFA, INC.',
   0x00C0CB: u'CONTROL TECHNOLOGY CORPORATION',
   0x00C0CC: u'TELESCIENCES CO SYSTEMS, INC.',
   0x00C0CD: u'COMELTA, S.A.',
   0x00C0CE: u'CEI SYSTEMS & ENGINEERING PTE',
   0x00C0CF: u'IMATRAN VOIMA OY',
   0x00C0D0: u'RATOC SYSTEM INC.',
   0x00C0D1: u'COMTREE TECHNOLOGY CORPORATION',
   0x00C0D2: u'SYNTELLECT, INC.',
   0x00C0D3: u'OLYMPUS IMAGE SYSTEMS, INC.',
   0x00C0D4: u'AXON NETWORKS, INC.',
   0x00C0D5: u'QUANCOM ELECTRONIC GMBH',
   0x00C0D6: u'J1 SYSTEMS, INC.',
   0x00C0D7: u'TAIWAN TRADING CENTER DBA',
   0x00C0D8: u'UNIVERSAL DATA SYSTEMS',
   0x00C0D9: u'QUINTE NETWORK CONFIDENTIALITY',
   0x00C0DA: u'NICE SYSTEMS LTD.',
   0x00C0DB: u'IPC CORPORATION (PTE) LTD.',
   0x00C0DC: u'EOS TECHNOLOGIES, INC.',
   0x00C0DD: u'QLogic Corporation',
   0x00C0DE: u'ZCOMM, INC.',
   0x00C0DF: u'KYE Systems Corp.',
   0x00C0E0: u'DSC COMMUNICATION CORP.',
   0x00C0E1: u'SONIC SOLUTIONS',
   0x00C0E2: u'CALCOMP, INC.',
   0x00C0E3: u'OSITECH COMMUNICATIONS, INC.',
   0x00C0E4: u'SIEMENS BUILDING',
   0x00C0E5: u'GESPAC, S.A.',
   0x00C0E6: u'Verilink Corporation',
   0x00C0E7: u'FIBERDATA AB',
   0x00C0E8: u'PLEXCOM, INC.',
   0x00C0E9: u'OAK SOLUTIONS, LTD.',
   0x00C0EA: u'ARRAY TECHNOLOGY LTD.',
   0x00C0EB: u'SEH COMPUTERTECHNIK GMBH',
   0x00C0EC: u'DAUPHIN TECHNOLOGY',
   0x00C0ED: u'US ARMY ELECTRONIC',
   0x00C0EE: u'KYOCERA CORPORATION',
   0x00C0EF: u'ABIT CORPORATION',
   0x00C0F0: u'KINGSTON TECHNOLOGY CORP.',
   0x00C0F1: u'SHINKO ELECTRIC CO., LTD.',
   0x00C0F2: u'TRANSITION NETWORKS',
   0x00C0F3: u'NETWORK COMMUNICATIONS CORP.',
   0x00C0F4: u'INTERLINK SYSTEM CO., LTD.',
   0x00C0F5: u'METACOMP, INC.',
   0x00C0F6: u'CELAN TECHNOLOGY INC.',
   0x00C0F7: u'ENGAGE COMMUNICATION, INC.',
   0x00C0F8: u'ABOUT COMPUTING INC.',
   0x00C0F9: u'Motorola Embedded Computing Group',
   0x00C0FA: u'CANARY COMMUNICATIONS, INC.',
   0x00C0FB: u'ADVANCED TECHNOLOGY LABS',
   0x00C0FC: u'ELASTIC REALITY, INC.',
   0x00C0FD: u'PROSUM',
   0x00C0FE: u'APTEC COMPUTER SYSTEMS, INC.',
   0x00C0FF: u'DOT HILL SYSTEMS CORPORATION',
   0x00CBBD: u'Cambridge Broadband Ltd.',
   0x00CF1C: u'COMMUNICATION MACHINERY CORP.',
   0x00D000: u'FERRAN SCIENTIFIC, INC.',
   0x00D001: u'VST TECHNOLOGIES, INC.',
   0x00D002: u'DITECH CORPORATION',
   0x00D003: u'COMDA ENTERPRISES CORP.',
   0x00D004: u'PENTACOM LTD.',
   0x00D005: u'ZHS ZEITMANAGEMENTSYSTEME',
   0x00D006: u'CISCO SYSTEMS, INC.',
   0x00D007: u'MIC ASSOCIATES, INC.',
   0x00D008: u'MACTELL CORPORATION',
   0x00D009: u'HSING TECH. ENTERPRISE CO. LTD',
   0x00D00A: u'LANACCESS TELECOM S.A.',
   0x00D00B: u'RHK TECHNOLOGY, INC.',
   0x00D00C: u'SNIJDER MICRO SYSTEMS',
   0x00D00D: u'MICROMERITICS INSTRUMENT',
   0x00D00E: u'PLURIS, INC.',
   0x00D00F: u'SPEECH DESIGN GMBH',
   0x00D010: u'CONVERGENT NETWORKS, INC.',
   0x00D011: u'PRISM VIDEO, INC.',
   0x00D012: u'GATEWORKS CORP.',
   0x00D013: u'PRIMEX AEROSPACE COMPANY',
   0x00D014: u'ROOT, INC.',
   0x00D015: u'UNIVEX MICROTECHNOLOGY CORP.',
   0x00D016: u'SCM MICROSYSTEMS, INC.',
   0x00D017: u'SYNTECH INFORMATION CO., LTD.',
   0x00D018: u'QWES. COM, INC.',
   0x00D019: u'DAINIPPON SCREEN CORPORATE',
   0x00D01A: u'URMET  TLC S.P.A.',
   0x00D01B: u'MIMAKI ENGINEERING CO., LTD.',
   0x00D01C: u'SBS TECHNOLOGIES,',
   0x00D01D: u'FURUNO ELECTRIC CO., LTD.',
   0x00D01E: u'PINGTEL CORP.',
   0x00D01F: u'CTAM PTY. LTD.',
   0x00D020: u'AIM SYSTEM, INC.',
   0x00D021: u'REGENT ELECTRONICS CORP.',
   0x00D022: u'INCREDIBLE TECHNOLOGIES, INC.',
   0x00D023: u'INFORTREND TECHNOLOGY, INC.',
   0x00D024: u'Cognex Corporation',
   0x00D025: u'XROSSTECH, INC.',
   0x00D026: u'HIRSCHMANN AUSTRIA GMBH',
   0x00D027: u'APPLIED AUTOMATION, INC.',
   0x00D028: u'OMNEON VIDEO NETWORKS',
   0x00D029: u'WAKEFERN FOOD CORPORATION',
   0x00D02A: u'Voxent Systems Ltd.',
   0x00D02B: u'JETCELL, INC.',
   0x00D02C: u'CAMPBELL SCIENTIFIC, INC.',
   0x00D02D: u'ADEMCO',
   0x00D02E: u'COMMUNICATION AUTOMATION CORP.',
   0x00D02F: u'VLSI TECHNOLOGY INC.',
   0x00D030: u'SAFETRAN SYSTEMS CORP.',
   0x00D031: u'INDUSTRIAL LOGIC CORPORATION',
   0x00D032: u'YANO ELECTRIC CO., LTD.',
   0x00D033: u'DALIAN DAXIAN NETWORK',
   0x00D034: u'ORMEC SYSTEMS CORP.',
   0x00D035: u'BEHAVIOR TECH. COMPUTER CORP.',
   0x00D036: u'TECHNOLOGY ATLANTA CORP.',
   0x00D037: u'PHILIPS-DVS-LO BDR',
   0x00D038: u'FIVEMERE, LTD.',
   0x00D039: u'UTILICOM, INC.',
   0x00D03A: u'ZONEWORX, INC.',
   0x00D03B: u'VISION PRODUCTS PTY. LTD.',
   0x00D03C: u'Vieo, Inc.',
   0x00D03D: u'GALILEO TECHNOLOGY, LTD.',
   0x00D03E: u'ROCKETCHIPS, INC.',
   0x00D03F: u'AMERICAN COMMUNICATION',
   0x00D040: u'SYSMATE CO., LTD.',
   0x00D041: u'AMIGO TECHNOLOGY CO., LTD.',
   0x00D042: u'MAHLO GMBH & CO. UG',
   0x00D043: u'ZONAL RETAIL DATA SYSTEMS',
   0x00D044: u'ALIDIAN NETWORKS, INC.',
   0x00D045: u'KVASER AB',
   0x00D046: u'DOLBY LABORATORIES, INC.',
   0x00D047: u'XN TECHNOLOGIES',
   0x00D048: u'ECTON, INC.',
   0x00D049: u'IMPRESSTEK CO., LTD.',
   0x00D04A: u'PRESENCE TECHNOLOGY GMBH',
   0x00D04B: u'LA CIE GROUP S.A.',
   0x00D04C: u'EUROTEL TELECOM LTD.',
   0x00D04D: u'DIV OF RESEARCH & STATISTICS',
   0x00D04E: u'LOGIBAG',
   0x00D04F: u'BITRONICS, INC.',
   0x00D050: u'ISKRATEL',
   0x00D051: u'O2 MICRO, INC.',
   0x00D052: u'ASCEND COMMUNICATIONS, INC.',
   0x00D053: u'CONNECTED SYSTEMS',
   0x00D054: u'SAS INSTITUTE INC.',
   0x00D055: u'KATHREIN-WERKE KG',
   0x00D056: u'SOMAT CORPORATION',
   0x00D057: u'ULTRAK, INC.',
   0x00D058: u'CISCO SYSTEMS, INC.',
   0x00D059: u'AMBIT MICROSYSTEMS CORP.',
   0x00D05A: u'SYMBIONICS, LTD.',
   0x00D05B: u'ACROLOOP MOTION CONTROL',
   0x00D05C: u'TECHNOTREND SYSTEMTECHNIK GMBH',
   0x00D05D: u'INTELLIWORXX, INC.',
   0x00D05E: u'STRATABEAM TECHNOLOGY, INC.',
   0x00D05F: u'VALCOM, INC.',
   0x00D060: u'PANASONIC EUROPEAN',
   0x00D061: u'TREMON ENTERPRISES CO., LTD.',
   0x00D062: u'DIGIGRAM',
   0x00D063: u'CISCO SYSTEMS, INC.',
   0x00D064: u'MULTITEL',
   0x00D065: u'TOKO ELECTRIC',
   0x00D066: u'WINTRISS ENGINEERING CORP.',
   0x00D067: u'CAMPIO COMMUNICATIONS',
   0x00D068: u'IWILL CORPORATION',
   0x00D069: u'TECHNOLOGIC SYSTEMS',
   0x00D06A: u'LINKUP SYSTEMS CORPORATION',
   0x00D06B: u'SR TELECOM INC.',
   0x00D06C: u'SHAREWAVE, INC.',
   0x00D06D: u'ACRISON, INC.',
   0x00D06E: u'TRENDVIEW RECORDERS LTD.',
   0x00D06F: u'KMC CONTROLS',
   0x00D070: u'LONG WELL ELECTRONICS CORP.',
   0x00D071: u'ECHELON CORP.',
   0x00D072: u'BROADLOGIC',
   0x00D073: u'ACN ADVANCED COMMUNICATIONS',
   0x00D074: u'TAQUA SYSTEMS, INC.',
   0x00D075: u'ALARIS MEDICAL SYSTEMS, INC.',
   0x00D076: u'Merrill Lynch & Co., Inc.',
   0x00D077: u'LUCENT TECHNOLOGIES',
   0x00D078: u'ELTEX OF SWEDEN AB',
   0x00D079: u'CISCO SYSTEMS, INC.',
   0x00D07A: u'AMAQUEST COMPUTER CORP.',
   0x00D07B: u'COMCAM INTERNATIONAL LTD.',
   0x00D07C: u'KOYO ELECTRONICS INC. CO.,LTD.',
   0x00D07D: u'COSINE COMMUNICATIONS',
   0x00D07E: u'KEYCORP LTD.',
   0x00D07F: u'STRATEGY & TECHNOLOGY, LIMITED',
   0x00D080: u'EXABYTE CORPORATION',
   0x00D081: u'REAL TIME DEVICES USA, INC.',
   0x00D082: u'IOWAVE INC.',
   0x00D083: u'INVERTEX, INC.',
   0x00D084: u'NEXCOMM SYSTEMS, INC.',
   0x00D085: u'OTIS ELEVATOR COMPANY',
   0x00D086: u'FOVEON, INC.',
   0x00D087: u'MICROFIRST INC.',
   0x00D088: u'Terayon Communications Systems',
   0x00D089: u'DYNACOLOR, INC.',
   0x00D08A: u'PHOTRON USA',
   0x00D08B: u'ADVA Limited',
   0x00D08C: u'GENOA TECHNOLOGY, INC.',
   0x00D08D: u'PHOENIX GROUP, INC.',
   0x00D08E: u'NVISION INC.',
   0x00D08F: u'ARDENT TECHNOLOGIES, INC.',
   0x00D090: u'CISCO SYSTEMS, INC.',
   0x00D091: u'SMARTSAN SYSTEMS, INC.',
   0x00D092: u'GLENAYRE WESTERN MULTIPLEX',
   0x00D093: u'TQ - COMPONENTS GMBH',
   0x00D094: u'TIMELINE VISTA, INC.',
   0x00D095: u'Alcatel North America ESD',
   0x00D096: u'3COM EUROPE LTD.',
   0x00D097: u'CISCO SYSTEMS, INC.',
   0x00D098: u'Photon Dynamics Canada Inc.',
   0x00D099: u'ELCARD OY',
   0x00D09A: u'FILANET CORPORATION',
   0x00D09B: u'SPECTEL LTD.',
   0x00D09C: u'KAPADIA COMMUNICATIONS',
   0x00D09D: u'VERIS INDUSTRIES',
   0x00D09E: u'2WIRE, INC.',
   0x00D09F: u'NOVTEK TEST SYSTEMS',
   0x00D0A0: u'MIPS DENMARK',
   0x00D0A1: u'OSKAR VIERLING GMBH + CO. KG',
   0x00D0A2: u'INTEGRATED DEVICE',
   0x00D0A3: u'VOCAL DATA, INC.',
   0x00D0A4: u'ALANTRO COMMUNICATIONS',
   0x00D0A5: u'AMERICAN ARIUM',
   0x00D0A6: u'LANBIRD TECHNOLOGY CO., LTD.',
   0x00D0A7: u'TOKYO SOKKI KENKYUJO CO., LTD.',
   0x00D0A8: u'NETWORK ENGINES, INC.',
   0x00D0A9: u'SHINANO KENSHI CO., LTD.',
   0x00D0AA: u'CHASE COMMUNICATIONS',
   0x00D0AB: u'DELTAKABEL TELECOM CV',
   0x00D0AC: u'GRAYSON WIRELESS',
   0x00D0AD: u'TL INDUSTRIES',
   0x00D0AE: u'ORESIS COMMUNICATIONS, INC.',
   0x00D0AF: u'CUTLER-HAMMER, INC.',
   0x00D0B0: u'BITSWITCH LTD.',
   0x00D0B1: u'OMEGA ELECTRONICS SA',
   0x00D0B2: u'XIOTECH CORPORATION',
   0x00D0B3: u'DRS FLIGHT SAFETY AND',
   0x00D0B4: u'KATSUJIMA CO., LTD.',
   0x00D0B5: u'IPricot formerly DotCom',
   0x00D0B6: u'CRESCENT NETWORKS, INC.',
   0x00D0B7: u'INTEL CORPORATION',
   0x00D0B8: u'Iomega Corporation',
   0x00D0B9: u'MICROTEK INTERNATIONAL, INC.',
   0x00D0BA: u'CISCO SYSTEMS, INC.',
   0x00D0BB: u'CISCO SYSTEMS, INC.',
   0x00D0BC: u'CISCO SYSTEMS, INC.',
   0x00D0BD: u'SICAN GMBH',
   0x00D0BE: u'EMUTEC INC.',
   0x00D0BF: u'PIVOTAL TECHNOLOGIES',
   0x00D0C0: u'CISCO SYSTEMS, INC.',
   0x00D0C1: u'HARMONIC DATA SYSTEMS, LTD.',
   0x00D0C2: u'BALTHAZAR TECHNOLOGY AB',
   0x00D0C3: u'VIVID TECHNOLOGY PTE, LTD.',
   0x00D0C4: u'TERATECH CORPORATION',
   0x00D0C5: u'COMPUTATIONAL SYSTEMS, INC.',
   0x00D0C6: u'THOMAS & BETTS CORP.',
   0x00D0C7: u'PATHWAY, INC.',
   0x00D0C8: u'I/O CONSULTING A/S',
   0x00D0C9: u'ADVANTECH CO., LTD.',
   0x00D0CA: u'INTRINSYC SOFTWARE INC.',
   0x00D0CB: u'DASAN CO., LTD.',
   0x00D0CC: u'TECHNOLOGIES LYRE INC.',
   0x00D0CD: u'ATAN TECHNOLOGY INC.',
   0x00D0CE: u'ASYST ELECTRONIC',
   0x00D0CF: u'MORETON BAY',
   0x00D0D0: u'ZHONGXING TELECOM LTD.',
   0x00D0D1: u'SIROCCO SYSTEMS, INC.',
   0x00D0D2: u'EPILOG CORPORATION',
   0x00D0D3: u'CISCO SYSTEMS, INC.',
   0x00D0D4: u'V-BITS, INC.',
   0x00D0D5: u'GRUNDIG AG',
   0x00D0D6: u'AETHRA TELECOMUNICAZIONI',
   0x00D0D7: u'B2C2, INC.',
   0x00D0D8: u'3Com Corporation',
   0x00D0D9: u'DEDICATED MICROCOMPUTERS',
   0x00D0DA: u'TAICOM DATA SYSTEMS CO., LTD.',
   0x00D0DB: u'MCQUAY INTERNATIONAL',
   0x00D0DC: u'MODULAR MINING SYSTEMS, INC.',
   0x00D0DD: u'SUNRISE TELECOM, INC.',
   0x00D0DE: u'PHILIPS MULTIMEDIA NETWORK',
   0x00D0DF: u'KUZUMI ELECTRONICS, INC.',
   0x00D0E0: u'DOOIN ELECTRONICS CO.',
   0x00D0E1: u'AVIONITEK ISRAEL INC.',
   0x00D0E2: u'MRT MICRO, INC.',
   0x00D0E3: u'ELE-CHEM ENGINEERING CO., LTD.',
   0x00D0E4: u'CISCO SYSTEMS, INC.',
   0x00D0E5: u'SOLIDUM SYSTEMS CORP.',
   0x00D0E6: u'IBOND INC.',
   0x00D0E7: u'VCON TELECOMMUNICATION LTD.',
   0x00D0E8: u'MAC SYSTEM CO., LTD.',
   0x00D0E9: u'ADVANTAGE CENTURY',
   0x00D0EA: u'NEXTONE COMMUNICATIONS, INC.',
   0x00D0EB: u'LIGHTERA NETWORKS, INC.',
   0x00D0EC: u'NAKAYO TELECOMMUNICATIONS, INC',
   0x00D0ED: u'XIOX',
   0x00D0EE: u'DICTAPHONE CORPORATION',
   0x00D0EF: u'IGT',
   0x00D0F0: u'CONVISION TECHNOLOGY GMBH',
   0x00D0F1: u'SEGA ENTERPRISES, LTD.',
   0x00D0F2: u'MONTEREY NETWORKS',
   0x00D0F3: u'SOLARI DI UDINE SPA',
   0x00D0F4: u'CARINTHIAN TECH INSTITUTE',
   0x00D0F5: u'ORANGE MICRO, INC.',
   0x00D0F6: u'Alcatel Canada',
   0x00D0F7: u'NEXT NETS CORPORATION',
   0x00D0F8: u'FUJIAN STAR TERMINAL',
   0x00D0F9: u'ACUTE COMMUNICATIONS CORP.',
   0x00D0FA: u'RACAL GUARDATA',
   0x00D0FB: u'TEK MICROSYSTEMS, INCORPORATED',
   0x00D0FC: u'GRANITE MICROSYSTEMS',
   0x00D0FD: u'OPTIMA TELE.COM, INC.',
   0x00D0FE: u'ASTRAL POINT',
   0x00D0FF: u'CISCO SYSTEMS, INC.',
   0x00DD00: u'UNGERMANN-BASS INC.',
   0x00DD01: u'UNGERMANN-BASS INC.',
   0x00DD02: u'UNGERMANN-BASS INC.',
   0x00DD03: u'UNGERMANN-BASS INC.',
   0x00DD04: u'UNGERMANN-BASS INC.',
   0x00DD05: u'UNGERMANN-BASS INC.',
   0x00DD06: u'UNGERMANN-BASS INC.',
   0x00DD07: u'UNGERMANN-BASS INC.',
   0x00DD08: u'UNGERMANN-BASS INC.',
   0x00DD09: u'UNGERMANN-BASS INC.',
   0x00DD0A: u'UNGERMANN-BASS INC.',
   0x00DD0B: u'UNGERMANN-BASS INC.',
   0x00DD0C: u'UNGERMANN-BASS INC.',
   0x00DD0D: u'UNGERMANN-BASS INC.',
   0x00DD0E: u'UNGERMANN-BASS INC.',
   0x00DD0F: u'UNGERMANN-BASS INC.',
   0x00E000: u'FUJITSU, LTD',
   0x00E001: u'STRAND LIGHTING LIMITED',
   0x00E002: u'CROSSROADS SYSTEMS, INC.',
   0x00E003: u'NOKIA WIRELESS BUSINESS COMMUN',
   0x00E004: u'PMC-SIERRA, INC.',
   0x00E005: u'TECHNICAL CORP.',
   0x00E006: u'SILICON INTEGRATED SYS. CORP.',
   0x00E007: u'NETWORK ALCHEMY LTD.',
   0x00E008: u'AMAZING CONTROLS! INC.',
   0x00E009: u'MARATHON TECHNOLOGIES CORP.',
   0x00E00A: u'DIBA, INC.',
   0x00E00B: u'ROOFTOP COMMUNICATIONS CORP.',
   0x00E00C: u'MOTOROLA',
   0x00E00D: u'RADIANT SYSTEMS',
   0x00E00E: u'AVALON IMAGING SYSTEMS, INC.',
   0x00E00F: u'SHANGHAI BAUD DATA',
   0x00E010: u'HESS SB-AUTOMATENBAU GmbH',
   0x00E011: u'UNIDEN SAN DIEGO R&D CENTER, INC.',
   0x00E012: u'PLUTO TECHNOLOGIES INTERNATIONAL INC.',
   0x00E013: u'EASTERN ELECTRONIC CO., LTD.',
   0x00E014: u'CISCO SYSTEMS, INC.',
   0x00E015: u'HEIWA CORPORATION',
   0x00E016: u'RAPID CITY COMMUNICATIONS',
   0x00E017: u'EXXACT GmbH',
   0x00E018: u'ASUSTEK COMPUTER INC.',
   0x00E019: u'ING. GIORDANO ELETTRONICA',
   0x00E01A: u'COMTEC SYSTEMS. CO., LTD.',
   0x00E01B: u'SPHERE COMMUNICATIONS, INC.',
   0x00E01C: u'MOBILITY ELECTRONICSY',
   0x00E01D: u'WebTV NETWORKS, INC.',
   0x00E01E: u'CISCO SYSTEMS, INC.',
   0x00E01F: u'AVIDIA Systems, Inc.',
   0x00E020: u'TECNOMEN OY',
   0x00E021: u'FREEGATE CORP.',
   0x00E022: u'Analog Devices Inc.',
   0x00E023: u'TELRAD',
   0x00E024: u'GADZOOX NETWORKS',
   0x00E025: u'dit CO., LTD.',
   0x00E026: u'Redlake MASD LLC',
   0x00E027: u'DUX, INC.',
   0x00E028: u'APTIX CORPORATION',
   0x00E029: u'STANDARD MICROSYSTEMS CORP.',
   0x00E02A: u'TANDBERG TELEVISION AS',
   0x00E02B: u'EXTREME NETWORKS',
   0x00E02C: u'AST COMPUTER',
   0x00E02D: u'InnoMediaLogic, Inc.',
   0x00E02E: u'SPC ELECTRONICS CORPORATION',
   0x00E02F: u'MCNS HOLDINGS, L.P.',
   0x00E030: u'MELITA INTERNATIONAL CORP.',
   0x00E031: u'HAGIWARA ELECTRIC CO., LTD.',
   0x00E032: u'MISYS FINANCIAL SYSTEMS, LTD.',
   0x00E033: u'E.E.P.D. GmbH',
   0x00E034: u'CISCO SYSTEMS, INC.',
   0x00E035: u'LOUGHBOROUGH SOUND IMAGES, PLC',
   0x00E036: u'PIONEER CORPORATION',
   0x00E037: u'CENTURY CORPORATION',
   0x00E038: u'PROXIMA CORPORATION',
   0x00E039: u'PARADYNE CORP.',
   0x00E03A: u'CABLETRON SYSTEMS, INC.',
   0x00E03B: u'PROMINET CORPORATION',
   0x00E03C: u'AdvanSys',
   0x00E03D: u'FOCON ELECTRONIC SYSTEMS A/S',
   0x00E03E: u'ALFATECH, INC.',
   0x00E03F: u'JATON CORPORATION',
   0x00E040: u'DeskStation Technology, Inc.',
   0x00E041: u'CSPI',
   0x00E042: u'Pacom Systems Ltd.',
   0x00E043: u'VitalCom',
   0x00E044: u'LSICS CORPORATION',
   0x00E045: u'TOUCHWAVE, INC.',
   0x00E046: u'BENTLY NEVADA CORP.',
   0x00E047: u'INFOCUS SYSTEMS',
   0x00E048: u'SDL COMMUNICATIONS, INC.',
   0x00E049: u'MICROWI ELECTRONIC GmbH',
   0x00E04A: u'ENHANCED MESSAGING SYSTEMS, INC',
   0x00E04B: u'JUMP INDUSTRIELLE COMPUTERTECHNIK GmbH',
   0x00E04C: u'REALTEK SEMICONDUCTOR CORP.',
   0x00E04D: u'INTERNET INITIATIVE JAPAN, INC',
   0x00E04E: u'SANYO DENKI CO., LTD.',
   0x00E04F: u'CISCO SYSTEMS, INC.',
   0x00E050: u'EXECUTONE INFORMATION SYSTEMS, INC.',
   0x00E051: u'TALX CORPORATION',
   0x00E052: u'FOUNDRY NETWORKS, INC.',
   0x00E053: u'CELLPORT LABS, INC.',
   0x00E054: u'KODAI HITEC CO., LTD.',
   0x00E055: u'INGENIERIA ELECTRONICA COMERCIAL INELCOM S.A.',
   0x00E056: u'HOLONTECH CORPORATION',
   0x00E057: u'HAN MICROTELECOM. CO., LTD.',
   0x00E058: u'PHASE ONE DENMARK A/S',
   0x00E059: u'CONTROLLED ENVIRONMENTS, LTD.',
   0x00E05A: u'GALEA NETWORK SECURITY',
   0x00E05B: u'WEST END SYSTEMS CORP.',
   0x00E05C: u'MATSUSHITA KOTOBUKI ELECTRONICS INDUSTRIES, LTD.',
   0x00E05D: u'UNITEC CO., LTD.',
   0x00E05E: u'JAPAN AVIATION ELECTRONICS INDUSTRY, LTD.',
   0x00E05F: u'e-Net, Inc.',
   0x00E060: u'SHERWOOD',
   0x00E061: u'EdgePoint Networks, Inc.',
   0x00E062: u'HOST ENGINEERING',
   0x00E063: u'CABLETRON - YAGO SYSTEMS, INC.',
   0x00E064: u'SAMSUNG ELECTRONICS',
   0x00E065: u'OPTICAL ACCESS INTERNATIONAL',
   0x00E066: u'ProMax Systems, Inc.',
   0x00E067: u'eac AUTOMATION-CONSULTING GmbH',
   0x00E068: u'MERRIMAC SYSTEMS INC.',
   0x00E069: u'JAYCOR',
   0x00E06A: u'KAPSCH AG',
   0x00E06B: u'W&G SPECIAL PRODUCTS',
   0x00E06C: u'AEP Systems International Ltd',
   0x00E06D: u'COMPUWARE CORPORATION',
   0x00E06E: u'FAR SYSTEMS S.p.A.',
   0x00E06F: u'Terayon Communications Systems',
   0x00E070: u'DH TECHNOLOGY',
   0x00E071: u'EPIS MICROCOMPUTER',
   0x00E072: u'LYNK',
   0x00E073: u'NATIONAL AMUSEMENT NETWORK, INC.',
   0x00E074: u'TIERNAN COMMUNICATIONS, INC.',
   0x00E075: u'Verilink Corporation',
   0x00E076: u'DEVELOPMENT CONCEPTS, INC.',
   0x00E077: u'WEBGEAR, INC.',
   0x00E078: u'BERKELEY NETWORKS',
   0x00E079: u'A.T.N.R.',
   0x00E07A: u'MIKRODIDAKT AB',
   0x00E07B: u'BAY NETWORKS',
   0x00E07C: u'METTLER-TOLEDO, INC.',
   0x00E07D: u'NETRONIX, INC.',
   0x00E07E: u'WALT DISNEY IMAGINEERING',
   0x00E07F: u'LOGISTISTEM s.r.l.',
   0x00E080: u'CONTROL RESOURCES CORPORATION',
   0x00E081: u'TYAN COMPUTER CORP.',
   0x00E082: u'ANERMA',
   0x00E083: u'JATO TECHNOLOGIES, INC.',
   0x00E084: u'COMPULITE R&D',
   0x00E085: u'GLOBAL MAINTECH, INC.',
   0x00E086: u'CYBEX COMPUTER PRODUCTS',
   0x00E087: u'LeCroy - Networking Productions Division',
   0x00E088: u'LTX CORPORATION',
   0x00E089: u'ION Networks, Inc.',
   0x00E08A: u'GEC AVERY, LTD.',
   0x00E08B: u'QLogic Corp.',
   0x00E08C: u'NEOPARADIGM LABS, INC.',
   0x00E08D: u'PRESSURE SYSTEMS, INC.',
   0x00E08E: u'UTSTARCOM',
   0x00E08F: u'CISCO SYSTEMS, INC.',
   0x00E090: u'BECKMAN LAB. AUTOMATION DIV.',
   0x00E091: u'LG ELECTRONICS, INC.',
   0x00E092: u'ADMTEK INCORPORATED',
   0x00E093: u'ACKFIN NETWORKS',
   0x00E094: u'OSAI SRL',
   0x00E095: u'ADVANCED-VISION TECHNOLGIES CORP.',
   0x00E096: u'SHIMADZU CORPORATION',
   0x00E097: u'CARRIER ACCESS CORPORATION',
   0x00E098: u'AboCom Systems, Inc.',
   0x00E099: u'SAMSON AG',
   0x00E09A: u'POSITRON INDUSTRIES, INC.',
   0x00E09B: u'ENGAGE NETWORKS, INC.',
   0x00E09C: u'MII',
   0x00E09D: u'SARNOFF CORPORATION',
   0x00E09E: u'QUANTUM CORPORATION',
   0x00E09F: u'PIXEL VISION',
   0x00E0A0: u'WILTRON CO.',
   0x00E0A1: u'HIMA PAUL HILDEBRANDT GmbH Co. KG',
   0x00E0A2: u'MICROSLATE INC.',
   0x00E0A3: u'CISCO SYSTEMS, INC.',
   0x00E0A4: u'ESAOTE S.p.A.',
   0x00E0A5: u'ComCore Semiconductor, Inc.',
   0x00E0A6: u'TELOGY NETWORKS, INC.',
   0x00E0A7: u'IPC INFORMATION SYSTEMS, INC.',
   0x00E0A8: u'SAT GmbH & Co.',
   0x00E0A9: u'FUNAI ELECTRIC CO., LTD.',
   0x00E0AA: u'ELECTROSONIC LTD.',
   0x00E0AB: u'DIMAT S.A.',
   0x00E0AC: u'MIDSCO, INC.',
   0x00E0AD: u'EES TECHNOLOGY, LTD.',
   0x00E0AE: u'XAQTI CORPORATION',
   0x00E0AF: u'GENERAL DYNAMICS INFORMATION SYSTEMS',
   0x00E0B0: u'CISCO SYSTEMS, INC.',
   0x00E0B1: u'Alcatel North America ESD',
   0x00E0B2: u'TELMAX COMMUNICATIONS CORP.',
   0x00E0B3: u'EtherWAN Systems, Inc.',
   0x00E0B4: u'TECHNO SCOPE CO., LTD.',
   0x00E0B5: u'ARDENT COMMUNICATIONS CORP.',
   0x00E0B6: u'Entrada Networks',
   0x00E0B7: u'PI GROUP, LTD.',
   0x00E0B8: u'GATEWAY 2000',
   0x00E0B9: u'BYAS SYSTEMS',
   0x00E0BA: u'BERGHOF AUTOMATIONSTECHNIK GmbH',
   0x00E0BB: u'NBX CORPORATION',
   0x00E0BC: u'SYMON COMMUNICATIONS, INC.',
   0x00E0BD: u'INTERFACE SYSTEMS, INC.',
   0x00E0BE: u'GENROCO INTERNATIONAL, INC.',
   0x00E0BF: u'TORRENT NETWORKING TECHNOLOGIES CORP.',
   0x00E0C0: u'SEIWA ELECTRIC MFG. CO., LTD.',
   0x00E0C1: u'MEMOREX TELEX JAPAN, LTD.',
   0x00E0C2: u'NECSY S.p.A.',
   0x00E0C3: u'SAKAI SYSTEM DEVELOPMENT CORP.',
   0x00E0C4: u'HORNER ELECTRIC, INC.',
   0x00E0C5: u'BCOM ELECTRONICS INC.',
   0x00E0C6: u'LINK2IT, L.L.C.',
   0x00E0C7: u'EUROTECH SRL',
   0x00E0C8: u'VIRTUAL ACCESS, LTD.',
   0x00E0C9: u'AutomatedLogic Corporation',
   0x00E0CA: u'BEST DATA PRODUCTS',
   0x00E0CB: u'RESON, INC.',
   0x00E0CC: u'HERO SYSTEMS, LTD.',
   0x00E0CD: u'SENSIS CORPORATION',
   0x00E0CE: u'ARN',
   0x00E0CF: u'INTEGRATED DEVICE TECHNOLOGY, INC.',
   0x00E0D0: u'NETSPEED, INC.',
   0x00E0D1: u'TELSIS LIMITED',
   0x00E0D2: u'VERSANET COMMUNICATIONS, INC.',
   0x00E0D3: u'DATENTECHNIK GmbH',
   0x00E0D4: u'EXCELLENT COMPUTER',
   0x00E0D5: u'ARCXEL TECHNOLOGIES, INC.',
   0x00E0D6: u'COMPUTER & COMMUNICATION RESEARCH LAB.',
   0x00E0D7: u'SUNSHINE ELECTRONICS, INC.',
   0x00E0D8: u'LANBit Computer, Inc.',
   0x00E0D9: u'TAZMO CO., LTD.',
   0x00E0DA: u'Alcatel North America ESD',
   0x00E0DB: u'ViaVideo Communications, Inc.',
   0x00E0DC: u'NEXWARE CORP.',
   0x00E0DD: u'ZENITH ELECTRONICS CORPORATION',
   0x00E0DE: u'DATAX NV',
   0x00E0DF: u'KE KOMMUNIKATIONS-ELECTRONIK',
   0x00E0E0: u'SI ELECTRONICS, LTD.',
   0x00E0E1: u'G2 NETWORKS, INC.',
   0x00E0E2: u'INNOVA CORP.',
   0x00E0E3: u'SK-ELEKTRONIK GmbH',
   0x00E0E4: u'FANUC ROBOTICS NORTH AMERICA, Inc.',
   0x00E0E5: u'CINCO NETWORKS, INC.',
   0x00E0E6: u'INCAA DATACOM B.V.',
   0x00E0E7: u'RAYTHEON E-SYSTEMS, INC.',
   0x00E0E8: u'GRETACODER Data Systems AG',
   0x00E0E9: u'DATA LABS, INC.',
   0x00E0EA: u'INNOVAT COMMUNICATIONS, INC.',
   0x00E0EB: u'DIGICOM SYSTEMS, INCORPORATED',
   0x00E0EC: u'CELESTICA INC.',
   0x00E0ED: u'SILICOM, LTD.',
   0x00E0EE: u'MAREL HF',
   0x00E0EF: u'DIONEX',
   0x00E0F0: u'ABLER TECHNOLOGY, INC.',
   0x00E0F1: u'THAT CORPORATION',
   0x00E0F2: u'ARLOTTO COMNET, INC.',
   0x00E0F3: u'WebSprint Communications, Inc.',
   0x00E0F4: u'INSIDE Technology A/S',
   0x00E0F5: u'TELES AG',
   0x00E0F6: u'DECISION EUROPE',
   0x00E0F7: u'CISCO SYSTEMS, INC.',
   0x00E0F8: u'DICNA CONTROL AB',
   0x00E0F9: u'CISCO SYSTEMS, INC.',
   0x00E0FA: u'TRL TECHNOLOGY, LTD.',
   0x00E0FB: u'LEIGHTRONIX, INC.',
   0x00E0FC: u'HUAWEI TECHNOLOGIES CO., LTD.',
   0x00E0FD: u'A-TREND TECHNOLOGY CO., LTD.',
   0x00E0FE: u'CISCO SYSTEMS, INC.',
   0x00E0FF: u'SECURITY DYNAMICS TECHNOLOGIES, Inc.',
   0x00E6D3: u'NIXDORF COMPUTER CORP.',
   0x020701: u'RACAL-DATACOM',
   0x021C7C: u'PERQ SYSTEMS CORPORATION',
   0x026086: u'LOGIC REPLACEMENT TECH. LTD.',
   0x02608C: u'3COM CORPORATION',
   0x027001: u'RACAL-DATACOM',
   0x0270B0: u'M/A-COM INC. COMPANIES',
   0x0270B3: u'DATA RECALL LTD',
   0x029D8E: u'CARDIAC RECORDERS INC.',
   0x02AA3C: u'OLIVETTI TELECOMM SPA (OLTECO)',
   0x02BB01: u'OCTOTHORPE CORP.',
   0x02C08C: u'3COM CORPORATION',
   0x02CF1C: u'COMMUNICATION MACHINERY CORP.',
   0x02E6D3: u'NIXDORF COMPUTER CORPORATION',
   0x040AE0: u'XMIT AG COMPUTER NETWORKS',
   0x04E0C4: u'TRIUMPH-ADLER AG',
   0x080001: u'COMPUTERVISION CORPORATION',
   0x080002: u'BRIDGE COMMUNICATIONS INC.',
   0x080003: u'ADVANCED COMPUTER COMM.',
   0x080004: u'CROMEMCO INCORPORATED',
   0x080005: u'SYMBOLICS INC.',
   0x080006: u'SIEMENS AG',
   0x080007: u'APPLE COMPUTER INC.',
   0x080008: u'BOLT BERANEK AND NEWMAN INC.',
   0x080009: u'HEWLETT PACKARD',
   0x08000A: u'NESTAR SYSTEMS INCORPORATED',
   0x08000B: u'UNISYS CORPORATION',
   0x08000C: u'MIKLYN DEVELOPMENT CO.',
   0x08000D: u'INTERNATIONAL COMPUTERS LTD.',
   0x08000E: u'NCR CORPORATION',
   0x08000F: u'MITEL CORPORATION',
   0x080011: u'TEKTRONIX INC.',
   0x080012: u'BELL ATLANTIC INTEGRATED SYST.',
   0x080013: u'EXXON',
   0x080014: u'EXCELAN',
   0x080015: u'STC BUSINESS SYSTEMS',
   0x080016: u'BARRISTER INFO SYS CORP',
   0x080017: u'NATIONAL SEMICONDUCTOR',
   0x080018: u'PIRELLI FOCOM NETWORKS',
   0x080019: u'GENERAL ELECTRIC CORPORATION',
   0x08001A: u'TIARA/ 10NET',
   0x08001B: u'DATA GENERAL',
   0x08001C: u'KDD-KOKUSAI DEBNSIN DENWA CO.',
   0x08001D: u'ABLE COMMUNICATIONS INC.',
   0x08001E: u'APOLLO COMPUTER INC.',
   0x08001F: u'SHARP CORPORATION',
   0x080020: u'SUN MICROSYSTEMS INC.',
   0x080021: u'3M COMPANY',
   0x080022: u'NBI INC.',
   0x080023: u'Panasonic Communications Co., Ltd.',
   0x080024: u'10NET COMMUNICATIONS/DCA',
   0x080025: u'CONTROL DATA',
   0x080026: u'NORSK DATA A.S.',
   0x080027: u'CADMUS COMPUTER SYSTEMS',
   0x080028: u'Texas Instruments',
   0x080029: u'MEGATEK CORPORATION',
   0x08002A: u'MOSAIC TECHNOLOGIES INC.',
   0x08002B: u'DIGITAL EQUIPMENT CORPORATION',
   0x08002C: u'BRITTON LEE INC.',
   0x08002D: u'LAN-TEC INC.',
   0x08002E: u'METAPHOR COMPUTER SYSTEMS',
   0x08002F: u'PRIME COMPUTER INC.',
   0x080030: u'CERN',
   0x080031: u'LITTLE MACHINES INC.',
   0x080032: u'TIGAN INCORPORATED',
   0x080033: u'BAUSCH & LOMB',
   0x080034: u'FILENET CORPORATION',
   0x080035: u'MICROFIVE CORPORATION',
   0x080036: u'INTERGRAPH CORPORATION',
   0x080037: u'FUJI-XEROX CO. LTD.',
   0x080038: u'CII HONEYWELL BULL',
   0x080039: u'SPIDER SYSTEMS LIMITED',
   0x08003A: u'ORCATECH INC.',
   0x08003B: u'TORUS SYSTEMS LIMITED',
   0x08003C: u'SCHLUMBERGER WELL SERVICES',
   0x08003D: u'CADNETIX CORPORATIONS',
   0x08003E: u'CODEX CORPORATION',
   0x08003F: u'FRED KOSCHARA ENTERPRISES',
   0x080040: u'FERRANTI COMPUTER SYS. LIMITED',
   0x080041: u'RACAL-MILGO INFORMATION SYS..',
   0x080042: u'JAPAN MACNICS CORP.',
   0x080043: u'PIXEL COMPUTER INC.',
   0x080044: u'DAVID SYSTEMS INC.',
   0x080045: u'CONCURRENT COMPUTER CORP.',
   0x080046: u'SONY CORPORATION LTD.',
   0x080047: u'SEQUENT COMPUTER SYSTEMS INC.',
   0x080048: u'EUROTHERM GAUGING SYSTEMS',
   0x080049: u'UNIVATION',
   0x08004A: u'BANYAN SYSTEMS INC.',
   0x08004B: u'PLANNING RESEARCH CORP.',
   0x08004C: u'HYDRA COMPUTER SYSTEMS INC.',
   0x08004D: u'CORVUS SYSTEMS INC.',
   0x08004E: u'3COM EUROPE LTD.',
   0x08004F: u'CYGNET SYSTEMS',
   0x080050: u'DAISY SYSTEMS CORP.',
   0x080051: u'EXPERDATA',
   0x080052: u'INSYSTEC',
   0x080053: u'MIDDLE EAST TECH. UNIVERSITY',
   0x080055: u'STANFORD TELECOMM. INC.',
   0x080056: u'STANFORD LINEAR ACCEL. CENTER',
   0x080057: u'EVANS & SUTHERLAND',
   0x080058: u'SYSTEMS CONCEPTS',
   0x080059: u'A/S MYCRON',
   0x08005A: u'IBM CORPORATION',
   0x08005B: u'VTA TECHNOLOGIES INC.',
   0x08005C: u'FOUR PHASE SYSTEMS',
   0x08005D: u'GOULD INC.',
   0x08005E: u'COUNTERPOINT COMPUTER INC.',
   0x08005F: u'SABER TECHNOLOGY CORP.',
   0x080060: u'INDUSTRIAL NETWORKING INC.',
   0x080061: u'JAROGATE LTD.',
   0x080062: u'GENERAL DYNAMICS',
   0x080063: u'PLESSEY',
   0x080064: u'AUTOPHON AG',
   0x080065: u'GENRAD INC.',
   0x080066: u'AGFA CORPORATION',
   0x080067: u'COMDESIGN',
   0x080068: u'RIDGE COMPUTERS',
   0x080069: u'SILICON GRAPHICS INC.',
   0x08006A: u'ATT BELL LABORATORIES',
   0x08006B: u'ACCEL TECHNOLOGIES INC.',
   0x08006C: u'SUNTEK TECHNOLOGY INT\'L',
   0x08006D: u'WHITECHAPEL COMPUTER WORKS',
   0x08006E: u'MASSCOMP',
   0x08006F: u'PHILIPS APELDOORN B.V.',
   0x080070: u'MITSUBISHI ELECTRIC CORP.',
   0x080071: u'MATRA (DSIE)',
   0x080072: u'XEROX CORP UNIV GRANT PROGRAM',
   0x080073: u'TECMAR INC.',
   0x080074: u'CASIO COMPUTER CO. LTD.',
   0x080075: u'DANSK DATA ELECTRONIK',
   0x080076: u'PC LAN TECHNOLOGIES',
   0x080077: u'TSL COMMUNICATIONS LTD.',
   0x080078: u'ACCELL CORPORATION',
   0x080079: u'THE DROID WORKS',
   0x08007A: u'INDATA',
   0x08007B: u'SANYO ELECTRIC CO. LTD.',
   0x08007C: u'VITALINK COMMUNICATIONS CORP.',
   0x08007E: u'AMALGAMATED WIRELESS(AUS) LTD',
   0x08007F: u'CARNEGIE-MELLON UNIVERSITY',
   0x080080: u'AES DATA INC.',
   0x080081: u'ASTECH INC.',
   0x080082: u'VERITAS SOFTWARE',
   0x080083: u'Seiko Instruments Inc.',
   0x080084: u'TOMEN ELECTRONICS CORP.',
   0x080085: u'ELXSI',
   0x080086: u'KONICA MINOLTA HOLDINGS, INC.',
   0x080087: u'XYPLEX',
   0x080088: u'MCDATA CORPORATION',
   0x080089: u'KINETICS',
   0x08008A: u'PERFORMANCE TECHNOLOGY',
   0x08008B: u'PYRAMID TECHNOLOGY CORP.',
   0x08008C: u'NETWORK RESEARCH CORPORATION',
   0x08008D: u'XYVISION INC.',
   0x08008E: u'TANDEM COMPUTERS',
   0x08008F: u'CHIPCOM CORPORATION',
   0x080090: u'SONOMA SYSTEMS',
   0x081443: u'UNIBRAIN S.A.',
   0x08BBCC: u'AK-NORD EDV VERTRIEBSGES. mbH',
   0x100000: u'PRIVATE',
   0x10005A: u'IBM CORPORATION',
   0x1000E8: u'NATIONAL SEMICONDUCTOR',
   0x1100AA: u'PRIVATE',
   0x800010: u'ATT BELL LABORATORIES',
   0xA06A00: u'Verilink Corporation',
   0xAA0000: u'DIGITAL EQUIPMENT CORPORATION',
   0xAA0001: u'DIGITAL EQUIPMENT CORPORATION',
   0xAA0002: u'DIGITAL EQUIPMENT CORPORATION',
   0xAA0003: u'DIGITAL EQUIPMENT CORPORATION',
   0xAA0004: u'DIGITAL EQUIPMENT CORPORATION',
   0xACDE48: u'PRIVATE',
}
