module Test.Data.Maybe where

import Control.Monad (guard, )
import Data.Maybe.HT (toMaybe, )

import Test.QuickCheck (quickCheck, )


toMaybeGuard :: Eq a => Bool -> Maybe a -> Bool
toMaybeGuard b x =
   (guard b >> x)   ==   (toMaybe b =<< x)


tests :: [(String, IO ())]
tests =
   ("toMaybeGuard", quickCheck (\b x -> toMaybeGuard b (x::Maybe Int))) :
   []
