/*
    This file is part of HelpViewer (http://www.roard.com/helpviewer)
    Copyright (C) 2003 Nicolas Roard (nicolas@roard.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "Legend.h"

@implementation Legend

+ (id) legendWithString: (NSMutableAttributedString*) str andPoint: (NSPoint) p
{
    Legend* ret = [[Legend alloc] initWithString: str andPoint: p];
    return AUTORELEASE (ret);
}

- (id) initWithString: (NSMutableAttributedString*) str andPoint: (NSPoint) p
{
    [super init];

    ASSIGN (legend, str);
    point = p;
    rightPos = NO;

    return self;
}

- (void) dealloc 
{
    RELEASE (legend);
}

- (NSComparisonResult) compareLegends: (id) sender
{
    NSComparisonResult ret = NSOrderedAscending;
    
    if ((int)point.y == (int)[sender point].y)
    {
        if (rightPos)
        {
            if (point.x < [sender point].x) ret = NSOrderedDescending;
        }    
        else if (point.x > [sender point].x) ret = NSOrderedDescending;
    }
    else if (point.y > [sender point].y) ret = NSOrderedDescending;
    return ret;
}

- (NSMutableAttributedString*) legend { return legend; }
- (NSPoint) point { return point; }
- (void) setPoint: (NSPoint) p { point = p; }
- (float) height { return height; }
- (void) setHeight: (float) h { height = h; }
- (void) setRightPos { rightPos = YES; }
- (BOOL) isRightPos { return rightPos; }
@end

