/* Autogenerated: ECCKiila https://gitlab.com/nisec/ecckiila */
/*-
 * MIT License
 * 
 * Copyright (c) 2020 Luis Rivera-Zamarripa, Jesús-Javier Chi-Domínguez, Billy Bob Brumley
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
#if defined(__SIZEOF_INT128__) && !defined(PEDANTIC)

#include <stdint.h>
#include <string.h>
#define LIMB_BITS 64
#define LIMB_CNT 4
/* Field elements */
typedef uint64_t fe_t[LIMB_CNT];
typedef uint64_t limb_t;

#ifdef OPENSSL_NO_ASM
#define FIAT_ID_GOSTR3410_2001_CRYPTOPRO_C_PARAMSET_NO_ASM
#endif

#define fe_copy(d, s) memcpy(d, s, sizeof(fe_t))
#define fe_set_zero(d) memset(d, 0, sizeof(fe_t))

/* Projective points */
typedef struct {
    fe_t X;
    fe_t Y;
    fe_t Z;
} pt_prj_t;

/* Affine points */
typedef struct {
    fe_t X;
    fe_t Y;
} pt_aff_t;

/* BEGIN verbatim fiat code https://github.com/mit-plv/fiat-crypto */
/*-
 * MIT License
 *
 * Copyright (c) 2020 the fiat-crypto authors (see the AUTHORS file)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/* Autogenerated: word_by_word_montgomery --static --use-value-barrier id_GostR3410_2001_CryptoPro_C_ParamSet 64 0x9B9F605F5A858107AB1EC85E6B41C8AACF846E86789051D37998F7B9022D759B */
/* curve description: id_GostR3410_2001_CryptoPro_C_ParamSet */
/* machine_wordsize = 64 (from "64") */
/* requested operations: (all) */
/* m = 0x9b9f605f5a858107ab1ec85e6b41c8aacf846e86789051d37998f7b9022d759b (from "0x9B9F605F5A858107AB1EC85E6B41C8AACF846E86789051D37998F7B9022D759B") */
/*                                                                    */
/* NOTE: In addition to the bounds specified above each function, all */
/*   functions synthesized for this Montgomery arithmetic require the */
/*   input to be strictly less than the prime modulus (m), and also   */
/*   require the input to be in the unique saturated representation.  */
/*   All functions also ensure that these two properties are true of  */
/*   return values.                                                   */
/*  */
/* Computed values: */
/* eval z = z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192) */
/* bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248) */

#include <stdint.h>
typedef unsigned char fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1;
typedef signed char fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_int1;
typedef signed __int128 fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_int128;
typedef unsigned __int128 fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint128;

#if (-1 & 3) != 3
#error "This code only works on a two's complement system"
#endif

#if !defined(FIAT_ID_GOSTR3410_2001_CRYPTOPRO_C_PARAMSET_NO_ASM) && \
    (defined(__GNUC__) || defined(__clang__))
static __inline__ uint64_t
fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_value_barrier_u64(uint64_t a) {
    __asm__("" : "+r"(a) : /* no inputs */);
    return a;
}
#else
#define fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_value_barrier_u64(x) (x)
#endif

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64 is an addition with carry.
 * Postconditions:
 *   out1 = (arg1 + arg2 + arg3) mod 2^64
 *   out2 = ⌊(arg1 + arg2 + arg3) / 2^64⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffffffffffff]
 *   arg3: [0x0 ~> 0xffffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(
    uint64_t *out1, fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 *out2,
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 arg1, uint64_t arg2,
    uint64_t arg3) {
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint128 x1;
    uint64_t x2;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x3;
    x1 = ((arg1 + (fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint128)arg2) +
          arg3);
    x2 = (uint64_t)(x1 & UINT64_C(0xffffffffffffffff));
    x3 = (fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1)(x1 >> 64);
    *out1 = x2;
    *out2 = x3;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64 is a subtraction with borrow.
 * Postconditions:
 *   out1 = (-arg1 + arg2 + -arg3) mod 2^64
 *   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^64⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffffffffffff]
 *   arg3: [0x0 ~> 0xffffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(
    uint64_t *out1, fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 *out2,
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 arg1, uint64_t arg2,
    uint64_t arg3) {
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_int128 x1;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_int1 x2;
    uint64_t x3;
    x1 = ((arg2 - (fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_int128)arg1) -
          arg3);
    x2 = (fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_int1)(x1 >> 64);
    x3 = (uint64_t)(x1 & UINT64_C(0xffffffffffffffff));
    *out1 = x3;
    *out2 = (fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1)(0x0 - x2);
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64 is a multiplication, returning the full double-width result.
 * Postconditions:
 *   out1 = (arg1 * arg2) mod 2^64
 *   out2 = ⌊arg1 * arg2 / 2^64⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0xffffffffffffffff]
 *   arg2: [0x0 ~> 0xffffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 *   out2: [0x0 ~> 0xffffffffffffffff]
 */
static void fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
    uint64_t *out1, uint64_t *out2, uint64_t arg1, uint64_t arg2) {
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint128 x1;
    uint64_t x2;
    uint64_t x3;
    x1 = ((fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint128)arg1 * arg2);
    x2 = (uint64_t)(x1 & UINT64_C(0xffffffffffffffff));
    x3 = (uint64_t)(x1 >> 64);
    *out1 = x2;
    *out2 = x3;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u64 is a single-word conditional move.
 * Postconditions:
 *   out1 = (if arg1 = 0 then arg2 else arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffffffffffff]
 *   arg3: [0x0 ~> 0xffffffffffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 */
static void fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u64(
    uint64_t *out1, fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 arg1,
    uint64_t arg2, uint64_t arg3) {
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x1;
    uint64_t x2;
    uint64_t x3;
    x1 = (!(!arg1));
    x2 = ((fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_int1)(0x0 - x1) &
          UINT64_C(0xffffffffffffffff));
    x3 =
        ((fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_value_barrier_u64(x2) &
          arg3) |
         (fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_value_barrier_u64((~x2)) &
          arg2));
    *out1 = x3;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul multiplies two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(
    uint64_t out1[4], const uint64_t arg1[4], const uint64_t arg2[4]) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint64_t x8;
    uint64_t x9;
    uint64_t x10;
    uint64_t x11;
    uint64_t x12;
    uint64_t x13;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x14;
    uint64_t x15;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x16;
    uint64_t x17;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x18;
    uint64_t x19;
    uint64_t x20;
    uint64_t x21;
    uint64_t x22;
    uint64_t x23;
    uint64_t x24;
    uint64_t x25;
    uint64_t x26;
    uint64_t x27;
    uint64_t x28;
    uint64_t x29;
    uint64_t x30;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x31;
    uint64_t x32;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x33;
    uint64_t x34;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x35;
    uint64_t x36;
    uint64_t x37;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x38;
    uint64_t x39;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x40;
    uint64_t x41;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x42;
    uint64_t x43;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x44;
    uint64_t x45;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x46;
    uint64_t x47;
    uint64_t x48;
    uint64_t x49;
    uint64_t x50;
    uint64_t x51;
    uint64_t x52;
    uint64_t x53;
    uint64_t x54;
    uint64_t x55;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x56;
    uint64_t x57;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x58;
    uint64_t x59;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x60;
    uint64_t x61;
    uint64_t x62;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x63;
    uint64_t x64;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x65;
    uint64_t x66;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x67;
    uint64_t x68;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x69;
    uint64_t x70;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x71;
    uint64_t x72;
    uint64_t x73;
    uint64_t x74;
    uint64_t x75;
    uint64_t x76;
    uint64_t x77;
    uint64_t x78;
    uint64_t x79;
    uint64_t x80;
    uint64_t x81;
    uint64_t x82;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x83;
    uint64_t x84;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x85;
    uint64_t x86;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x87;
    uint64_t x88;
    uint64_t x89;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x90;
    uint64_t x91;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x92;
    uint64_t x93;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x94;
    uint64_t x95;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x96;
    uint64_t x97;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x98;
    uint64_t x99;
    uint64_t x100;
    uint64_t x101;
    uint64_t x102;
    uint64_t x103;
    uint64_t x104;
    uint64_t x105;
    uint64_t x106;
    uint64_t x107;
    uint64_t x108;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x109;
    uint64_t x110;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x111;
    uint64_t x112;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x113;
    uint64_t x114;
    uint64_t x115;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x116;
    uint64_t x117;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x118;
    uint64_t x119;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x120;
    uint64_t x121;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x122;
    uint64_t x123;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x124;
    uint64_t x125;
    uint64_t x126;
    uint64_t x127;
    uint64_t x128;
    uint64_t x129;
    uint64_t x130;
    uint64_t x131;
    uint64_t x132;
    uint64_t x133;
    uint64_t x134;
    uint64_t x135;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x136;
    uint64_t x137;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x138;
    uint64_t x139;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x140;
    uint64_t x141;
    uint64_t x142;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x143;
    uint64_t x144;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x145;
    uint64_t x146;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x147;
    uint64_t x148;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x149;
    uint64_t x150;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x151;
    uint64_t x152;
    uint64_t x153;
    uint64_t x154;
    uint64_t x155;
    uint64_t x156;
    uint64_t x157;
    uint64_t x158;
    uint64_t x159;
    uint64_t x160;
    uint64_t x161;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x162;
    uint64_t x163;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x164;
    uint64_t x165;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x166;
    uint64_t x167;
    uint64_t x168;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x169;
    uint64_t x170;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x171;
    uint64_t x172;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x173;
    uint64_t x174;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x175;
    uint64_t x176;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x177;
    uint64_t x178;
    uint64_t x179;
    uint64_t x180;
    uint64_t x181;
    uint64_t x182;
    uint64_t x183;
    uint64_t x184;
    uint64_t x185;
    uint64_t x186;
    uint64_t x187;
    uint64_t x188;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x189;
    uint64_t x190;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x191;
    uint64_t x192;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x193;
    uint64_t x194;
    uint64_t x195;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x196;
    uint64_t x197;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x198;
    uint64_t x199;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x200;
    uint64_t x201;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x202;
    uint64_t x203;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x204;
    uint64_t x205;
    uint64_t x206;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x207;
    uint64_t x208;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x209;
    uint64_t x210;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x211;
    uint64_t x212;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x213;
    uint64_t x214;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x215;
    uint64_t x216;
    uint64_t x217;
    uint64_t x218;
    uint64_t x219;
    x1 = (arg1[1]);
    x2 = (arg1[2]);
    x3 = (arg1[3]);
    x4 = (arg1[0]);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(&x5, &x6, x4,
                                                         (arg2[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(&x7, &x8, x4,
                                                         (arg2[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(&x9, &x10, x4,
                                                         (arg2[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(&x11, &x12, x4,
                                                         (arg2[0]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x13, &x14, 0x0,
                                                              x12, x9);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x15, &x16, x14,
                                                              x10, x7);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x17, &x18, x16,
                                                              x8, x5);
    x19 = (x18 + x6);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x20, &x21, x11, UINT64_C(0xdf6e6c2c727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x22, &x23, x20, UINT64_C(0x9b9f605f5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x24, &x25, x20, UINT64_C(0xab1ec85e6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x26, &x27, x20, UINT64_C(0xcf846e86789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x28, &x29, x20, UINT64_C(0x7998f7b9022d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x30, &x31, 0x0,
                                                              x29, x26);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x32, &x33, x31,
                                                              x27, x24);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x34, &x35, x33,
                                                              x25, x22);
    x36 = (x35 + x23);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x37, &x38, 0x0,
                                                              x11, x28);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x39, &x40, x38,
                                                              x13, x30);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x41, &x42, x40,
                                                              x15, x32);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x43, &x44, x42,
                                                              x17, x34);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x45, &x46, x44,
                                                              x19, x36);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(&x47, &x48, x1,
                                                         (arg2[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(&x49, &x50, x1,
                                                         (arg2[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(&x51, &x52, x1,
                                                         (arg2[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(&x53, &x54, x1,
                                                         (arg2[0]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x55, &x56, 0x0,
                                                              x54, x51);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x57, &x58, x56,
                                                              x52, x49);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x59, &x60, x58,
                                                              x50, x47);
    x61 = (x60 + x48);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x62, &x63, 0x0,
                                                              x39, x53);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x64, &x65, x63,
                                                              x41, x55);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x66, &x67, x65,
                                                              x43, x57);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x68, &x69, x67,
                                                              x45, x59);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x70, &x71, x69,
                                                              x46, x61);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x72, &x73, x62, UINT64_C(0xdf6e6c2c727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x74, &x75, x72, UINT64_C(0x9b9f605f5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x76, &x77, x72, UINT64_C(0xab1ec85e6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x78, &x79, x72, UINT64_C(0xcf846e86789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x80, &x81, x72, UINT64_C(0x7998f7b9022d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x82, &x83, 0x0,
                                                              x81, x78);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x84, &x85, x83,
                                                              x79, x76);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x86, &x87, x85,
                                                              x77, x74);
    x88 = (x87 + x75);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x89, &x90, 0x0,
                                                              x62, x80);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x91, &x92, x90,
                                                              x64, x82);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x93, &x94, x92,
                                                              x66, x84);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x95, &x96, x94,
                                                              x68, x86);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x97, &x98, x96,
                                                              x70, x88);
    x99 = ((uint64_t)x98 + x71);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(&x100, &x101, x2,
                                                         (arg2[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(&x102, &x103, x2,
                                                         (arg2[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(&x104, &x105, x2,
                                                         (arg2[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(&x106, &x107, x2,
                                                         (arg2[0]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x108, &x109, 0x0,
                                                              x107, x104);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x110, &x111,
                                                              x109, x105, x102);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x112, &x113,
                                                              x111, x103, x100);
    x114 = (x113 + x101);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x115, &x116, 0x0,
                                                              x91, x106);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x117, &x118,
                                                              x116, x93, x108);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x119, &x120,
                                                              x118, x95, x110);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x121, &x122,
                                                              x120, x97, x112);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x123, &x124,
                                                              x122, x99, x114);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x125, &x126, x115, UINT64_C(0xdf6e6c2c727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x127, &x128, x125, UINT64_C(0x9b9f605f5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x129, &x130, x125, UINT64_C(0xab1ec85e6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x131, &x132, x125, UINT64_C(0xcf846e86789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x133, &x134, x125, UINT64_C(0x7998f7b9022d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x135, &x136, 0x0,
                                                              x134, x131);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x137, &x138,
                                                              x136, x132, x129);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x139, &x140,
                                                              x138, x130, x127);
    x141 = (x140 + x128);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x142, &x143, 0x0,
                                                              x115, x133);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x144, &x145,
                                                              x143, x117, x135);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x146, &x147,
                                                              x145, x119, x137);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x148, &x149,
                                                              x147, x121, x139);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x150, &x151,
                                                              x149, x123, x141);
    x152 = ((uint64_t)x151 + x124);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(&x153, &x154, x3,
                                                         (arg2[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(&x155, &x156, x3,
                                                         (arg2[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(&x157, &x158, x3,
                                                         (arg2[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(&x159, &x160, x3,
                                                         (arg2[0]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x161, &x162, 0x0,
                                                              x160, x157);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x163, &x164,
                                                              x162, x158, x155);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x165, &x166,
                                                              x164, x156, x153);
    x167 = (x166 + x154);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x168, &x169, 0x0,
                                                              x144, x159);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x170, &x171,
                                                              x169, x146, x161);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x172, &x173,
                                                              x171, x148, x163);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x174, &x175,
                                                              x173, x150, x165);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x176, &x177,
                                                              x175, x152, x167);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x178, &x179, x168, UINT64_C(0xdf6e6c2c727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x180, &x181, x178, UINT64_C(0x9b9f605f5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x182, &x183, x178, UINT64_C(0xab1ec85e6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x184, &x185, x178, UINT64_C(0xcf846e86789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x186, &x187, x178, UINT64_C(0x7998f7b9022d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x188, &x189, 0x0,
                                                              x187, x184);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x190, &x191,
                                                              x189, x185, x182);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x192, &x193,
                                                              x191, x183, x180);
    x194 = (x193 + x181);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x195, &x196, 0x0,
                                                              x168, x186);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x197, &x198,
                                                              x196, x170, x188);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x199, &x200,
                                                              x198, x172, x190);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x201, &x202,
                                                              x200, x174, x192);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x203, &x204,
                                                              x202, x176, x194);
    x205 = ((uint64_t)x204 + x177);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(
        &x206, &x207, 0x0, x197, UINT64_C(0x7998f7b9022d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(
        &x208, &x209, x207, x199, UINT64_C(0xcf846e86789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(
        &x210, &x211, x209, x201, UINT64_C(0xab1ec85e6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(
        &x212, &x213, x211, x203, UINT64_C(0x9b9f605f5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(&x214, &x215,
                                                               x213, x205, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u64(&x216, x215, x206,
                                                            x197);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u64(&x217, x215, x208,
                                                            x199);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u64(&x218, x215, x210,
                                                            x201);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u64(&x219, x215, x212,
                                                            x203);
    out1[0] = x216;
    out1[1] = x217;
    out1[2] = x218;
    out1[3] = x219;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square squares a field element in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(
    uint64_t out1[4], const uint64_t arg1[4]) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint64_t x8;
    uint64_t x9;
    uint64_t x10;
    uint64_t x11;
    uint64_t x12;
    uint64_t x13;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x14;
    uint64_t x15;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x16;
    uint64_t x17;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x18;
    uint64_t x19;
    uint64_t x20;
    uint64_t x21;
    uint64_t x22;
    uint64_t x23;
    uint64_t x24;
    uint64_t x25;
    uint64_t x26;
    uint64_t x27;
    uint64_t x28;
    uint64_t x29;
    uint64_t x30;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x31;
    uint64_t x32;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x33;
    uint64_t x34;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x35;
    uint64_t x36;
    uint64_t x37;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x38;
    uint64_t x39;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x40;
    uint64_t x41;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x42;
    uint64_t x43;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x44;
    uint64_t x45;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x46;
    uint64_t x47;
    uint64_t x48;
    uint64_t x49;
    uint64_t x50;
    uint64_t x51;
    uint64_t x52;
    uint64_t x53;
    uint64_t x54;
    uint64_t x55;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x56;
    uint64_t x57;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x58;
    uint64_t x59;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x60;
    uint64_t x61;
    uint64_t x62;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x63;
    uint64_t x64;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x65;
    uint64_t x66;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x67;
    uint64_t x68;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x69;
    uint64_t x70;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x71;
    uint64_t x72;
    uint64_t x73;
    uint64_t x74;
    uint64_t x75;
    uint64_t x76;
    uint64_t x77;
    uint64_t x78;
    uint64_t x79;
    uint64_t x80;
    uint64_t x81;
    uint64_t x82;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x83;
    uint64_t x84;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x85;
    uint64_t x86;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x87;
    uint64_t x88;
    uint64_t x89;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x90;
    uint64_t x91;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x92;
    uint64_t x93;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x94;
    uint64_t x95;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x96;
    uint64_t x97;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x98;
    uint64_t x99;
    uint64_t x100;
    uint64_t x101;
    uint64_t x102;
    uint64_t x103;
    uint64_t x104;
    uint64_t x105;
    uint64_t x106;
    uint64_t x107;
    uint64_t x108;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x109;
    uint64_t x110;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x111;
    uint64_t x112;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x113;
    uint64_t x114;
    uint64_t x115;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x116;
    uint64_t x117;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x118;
    uint64_t x119;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x120;
    uint64_t x121;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x122;
    uint64_t x123;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x124;
    uint64_t x125;
    uint64_t x126;
    uint64_t x127;
    uint64_t x128;
    uint64_t x129;
    uint64_t x130;
    uint64_t x131;
    uint64_t x132;
    uint64_t x133;
    uint64_t x134;
    uint64_t x135;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x136;
    uint64_t x137;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x138;
    uint64_t x139;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x140;
    uint64_t x141;
    uint64_t x142;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x143;
    uint64_t x144;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x145;
    uint64_t x146;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x147;
    uint64_t x148;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x149;
    uint64_t x150;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x151;
    uint64_t x152;
    uint64_t x153;
    uint64_t x154;
    uint64_t x155;
    uint64_t x156;
    uint64_t x157;
    uint64_t x158;
    uint64_t x159;
    uint64_t x160;
    uint64_t x161;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x162;
    uint64_t x163;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x164;
    uint64_t x165;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x166;
    uint64_t x167;
    uint64_t x168;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x169;
    uint64_t x170;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x171;
    uint64_t x172;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x173;
    uint64_t x174;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x175;
    uint64_t x176;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x177;
    uint64_t x178;
    uint64_t x179;
    uint64_t x180;
    uint64_t x181;
    uint64_t x182;
    uint64_t x183;
    uint64_t x184;
    uint64_t x185;
    uint64_t x186;
    uint64_t x187;
    uint64_t x188;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x189;
    uint64_t x190;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x191;
    uint64_t x192;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x193;
    uint64_t x194;
    uint64_t x195;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x196;
    uint64_t x197;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x198;
    uint64_t x199;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x200;
    uint64_t x201;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x202;
    uint64_t x203;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x204;
    uint64_t x205;
    uint64_t x206;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x207;
    uint64_t x208;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x209;
    uint64_t x210;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x211;
    uint64_t x212;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x213;
    uint64_t x214;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x215;
    uint64_t x216;
    uint64_t x217;
    uint64_t x218;
    uint64_t x219;
    x1 = (arg1[1]);
    x2 = (arg1[2]);
    x3 = (arg1[3]);
    x4 = (arg1[0]);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(&x5, &x6, x4,
                                                         (arg1[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(&x7, &x8, x4,
                                                         (arg1[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(&x9, &x10, x4,
                                                         (arg1[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(&x11, &x12, x4,
                                                         (arg1[0]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x13, &x14, 0x0,
                                                              x12, x9);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x15, &x16, x14,
                                                              x10, x7);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x17, &x18, x16,
                                                              x8, x5);
    x19 = (x18 + x6);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x20, &x21, x11, UINT64_C(0xdf6e6c2c727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x22, &x23, x20, UINT64_C(0x9b9f605f5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x24, &x25, x20, UINT64_C(0xab1ec85e6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x26, &x27, x20, UINT64_C(0xcf846e86789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x28, &x29, x20, UINT64_C(0x7998f7b9022d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x30, &x31, 0x0,
                                                              x29, x26);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x32, &x33, x31,
                                                              x27, x24);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x34, &x35, x33,
                                                              x25, x22);
    x36 = (x35 + x23);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x37, &x38, 0x0,
                                                              x11, x28);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x39, &x40, x38,
                                                              x13, x30);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x41, &x42, x40,
                                                              x15, x32);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x43, &x44, x42,
                                                              x17, x34);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x45, &x46, x44,
                                                              x19, x36);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(&x47, &x48, x1,
                                                         (arg1[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(&x49, &x50, x1,
                                                         (arg1[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(&x51, &x52, x1,
                                                         (arg1[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(&x53, &x54, x1,
                                                         (arg1[0]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x55, &x56, 0x0,
                                                              x54, x51);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x57, &x58, x56,
                                                              x52, x49);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x59, &x60, x58,
                                                              x50, x47);
    x61 = (x60 + x48);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x62, &x63, 0x0,
                                                              x39, x53);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x64, &x65, x63,
                                                              x41, x55);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x66, &x67, x65,
                                                              x43, x57);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x68, &x69, x67,
                                                              x45, x59);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x70, &x71, x69,
                                                              x46, x61);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x72, &x73, x62, UINT64_C(0xdf6e6c2c727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x74, &x75, x72, UINT64_C(0x9b9f605f5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x76, &x77, x72, UINT64_C(0xab1ec85e6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x78, &x79, x72, UINT64_C(0xcf846e86789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x80, &x81, x72, UINT64_C(0x7998f7b9022d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x82, &x83, 0x0,
                                                              x81, x78);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x84, &x85, x83,
                                                              x79, x76);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x86, &x87, x85,
                                                              x77, x74);
    x88 = (x87 + x75);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x89, &x90, 0x0,
                                                              x62, x80);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x91, &x92, x90,
                                                              x64, x82);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x93, &x94, x92,
                                                              x66, x84);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x95, &x96, x94,
                                                              x68, x86);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x97, &x98, x96,
                                                              x70, x88);
    x99 = ((uint64_t)x98 + x71);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(&x100, &x101, x2,
                                                         (arg1[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(&x102, &x103, x2,
                                                         (arg1[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(&x104, &x105, x2,
                                                         (arg1[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(&x106, &x107, x2,
                                                         (arg1[0]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x108, &x109, 0x0,
                                                              x107, x104);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x110, &x111,
                                                              x109, x105, x102);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x112, &x113,
                                                              x111, x103, x100);
    x114 = (x113 + x101);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x115, &x116, 0x0,
                                                              x91, x106);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x117, &x118,
                                                              x116, x93, x108);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x119, &x120,
                                                              x118, x95, x110);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x121, &x122,
                                                              x120, x97, x112);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x123, &x124,
                                                              x122, x99, x114);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x125, &x126, x115, UINT64_C(0xdf6e6c2c727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x127, &x128, x125, UINT64_C(0x9b9f605f5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x129, &x130, x125, UINT64_C(0xab1ec85e6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x131, &x132, x125, UINT64_C(0xcf846e86789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x133, &x134, x125, UINT64_C(0x7998f7b9022d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x135, &x136, 0x0,
                                                              x134, x131);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x137, &x138,
                                                              x136, x132, x129);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x139, &x140,
                                                              x138, x130, x127);
    x141 = (x140 + x128);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x142, &x143, 0x0,
                                                              x115, x133);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x144, &x145,
                                                              x143, x117, x135);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x146, &x147,
                                                              x145, x119, x137);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x148, &x149,
                                                              x147, x121, x139);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x150, &x151,
                                                              x149, x123, x141);
    x152 = ((uint64_t)x151 + x124);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(&x153, &x154, x3,
                                                         (arg1[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(&x155, &x156, x3,
                                                         (arg1[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(&x157, &x158, x3,
                                                         (arg1[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(&x159, &x160, x3,
                                                         (arg1[0]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x161, &x162, 0x0,
                                                              x160, x157);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x163, &x164,
                                                              x162, x158, x155);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x165, &x166,
                                                              x164, x156, x153);
    x167 = (x166 + x154);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x168, &x169, 0x0,
                                                              x144, x159);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x170, &x171,
                                                              x169, x146, x161);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x172, &x173,
                                                              x171, x148, x163);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x174, &x175,
                                                              x173, x150, x165);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x176, &x177,
                                                              x175, x152, x167);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x178, &x179, x168, UINT64_C(0xdf6e6c2c727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x180, &x181, x178, UINT64_C(0x9b9f605f5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x182, &x183, x178, UINT64_C(0xab1ec85e6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x184, &x185, x178, UINT64_C(0xcf846e86789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x186, &x187, x178, UINT64_C(0x7998f7b9022d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x188, &x189, 0x0,
                                                              x187, x184);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x190, &x191,
                                                              x189, x185, x182);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x192, &x193,
                                                              x191, x183, x180);
    x194 = (x193 + x181);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x195, &x196, 0x0,
                                                              x168, x186);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x197, &x198,
                                                              x196, x170, x188);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x199, &x200,
                                                              x198, x172, x190);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x201, &x202,
                                                              x200, x174, x192);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x203, &x204,
                                                              x202, x176, x194);
    x205 = ((uint64_t)x204 + x177);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(
        &x206, &x207, 0x0, x197, UINT64_C(0x7998f7b9022d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(
        &x208, &x209, x207, x199, UINT64_C(0xcf846e86789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(
        &x210, &x211, x209, x201, UINT64_C(0xab1ec85e6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(
        &x212, &x213, x211, x203, UINT64_C(0x9b9f605f5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(&x214, &x215,
                                                               x213, x205, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u64(&x216, x215, x206,
                                                            x197);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u64(&x217, x215, x208,
                                                            x199);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u64(&x218, x215, x210,
                                                            x201);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u64(&x219, x215, x212,
                                                            x203);
    out1[0] = x216;
    out1[1] = x217;
    out1[2] = x218;
    out1[3] = x219;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add adds two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(
    uint64_t out1[4], const uint64_t arg1[4], const uint64_t arg2[4]) {
    uint64_t x1;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x2;
    uint64_t x3;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x4;
    uint64_t x5;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x6;
    uint64_t x7;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x8;
    uint64_t x9;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x10;
    uint64_t x11;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x12;
    uint64_t x13;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x14;
    uint64_t x15;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x16;
    uint64_t x17;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x18;
    uint64_t x19;
    uint64_t x20;
    uint64_t x21;
    uint64_t x22;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(
        &x1, &x2, 0x0, (arg1[0]), (arg2[0]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(
        &x3, &x4, x2, (arg1[1]), (arg2[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(
        &x5, &x6, x4, (arg1[2]), (arg2[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(
        &x7, &x8, x6, (arg1[3]), (arg2[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(
        &x9, &x10, 0x0, x1, UINT64_C(0x7998f7b9022d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(
        &x11, &x12, x10, x3, UINT64_C(0xcf846e86789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(
        &x13, &x14, x12, x5, UINT64_C(0xab1ec85e6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(
        &x15, &x16, x14, x7, UINT64_C(0x9b9f605f5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(&x17, &x18, x16,
                                                               x8, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u64(&x19, x18, x9, x1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u64(&x20, x18, x11, x3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u64(&x21, x18, x13, x5);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u64(&x22, x18, x15, x7);
    out1[0] = x19;
    out1[1] = x20;
    out1[2] = x21;
    out1[3] = x22;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub subtracts two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(
    uint64_t out1[4], const uint64_t arg1[4], const uint64_t arg2[4]) {
    uint64_t x1;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x2;
    uint64_t x3;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x4;
    uint64_t x5;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x6;
    uint64_t x7;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x8;
    uint64_t x9;
    uint64_t x10;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x11;
    uint64_t x12;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x13;
    uint64_t x14;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x15;
    uint64_t x16;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x17;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(
        &x1, &x2, 0x0, (arg1[0]), (arg2[0]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(
        &x3, &x4, x2, (arg1[1]), (arg2[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(
        &x5, &x6, x4, (arg1[2]), (arg2[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(
        &x7, &x8, x6, (arg1[3]), (arg2[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u64(
        &x9, x8, 0x0, UINT64_C(0xffffffffffffffff));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(
        &x10, &x11, 0x0, x1, (x9 & UINT64_C(0x7998f7b9022d759b)));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(
        &x12, &x13, x11, x3, (x9 & UINT64_C(0xcf846e86789051d3)));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(
        &x14, &x15, x13, x5, (x9 & UINT64_C(0xab1ec85e6b41c8aa)));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(
        &x16, &x17, x15, x7, (x9 & UINT64_C(0x9b9f605f5a858107)));
    out1[0] = x10;
    out1[1] = x12;
    out1[2] = x14;
    out1[3] = x16;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_opp negates a field element in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_opp(
    uint64_t out1[4], const uint64_t arg1[4]) {
    uint64_t x1;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x2;
    uint64_t x3;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x4;
    uint64_t x5;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x6;
    uint64_t x7;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x8;
    uint64_t x9;
    uint64_t x10;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x11;
    uint64_t x12;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x13;
    uint64_t x14;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x15;
    uint64_t x16;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x17;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(&x1, &x2, 0x0,
                                                               0x0, (arg1[0]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(&x3, &x4, x2,
                                                               0x0, (arg1[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(&x5, &x6, x4,
                                                               0x0, (arg1[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(&x7, &x8, x6,
                                                               0x0, (arg1[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u64(
        &x9, x8, 0x0, UINT64_C(0xffffffffffffffff));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(
        &x10, &x11, 0x0, x1, (x9 & UINT64_C(0x7998f7b9022d759b)));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(
        &x12, &x13, x11, x3, (x9 & UINT64_C(0xcf846e86789051d3)));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(
        &x14, &x15, x13, x5, (x9 & UINT64_C(0xab1ec85e6b41c8aa)));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(
        &x16, &x17, x15, x7, (x9 & UINT64_C(0x9b9f605f5a858107)));
    out1[0] = x10;
    out1[1] = x12;
    out1[2] = x14;
    out1[3] = x16;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_from_montgomery translates a field element out of the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * ((2^64)⁻¹ mod m)^4) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_from_montgomery(
    uint64_t out1[4], const uint64_t arg1[4]) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint64_t x8;
    uint64_t x9;
    uint64_t x10;
    uint64_t x11;
    uint64_t x12;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x13;
    uint64_t x14;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x15;
    uint64_t x16;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x17;
    uint64_t x18;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x19;
    uint64_t x20;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x21;
    uint64_t x22;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x23;
    uint64_t x24;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x25;
    uint64_t x26;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x27;
    uint64_t x28;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x29;
    uint64_t x30;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x31;
    uint64_t x32;
    uint64_t x33;
    uint64_t x34;
    uint64_t x35;
    uint64_t x36;
    uint64_t x37;
    uint64_t x38;
    uint64_t x39;
    uint64_t x40;
    uint64_t x41;
    uint64_t x42;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x43;
    uint64_t x44;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x45;
    uint64_t x46;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x47;
    uint64_t x48;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x49;
    uint64_t x50;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x51;
    uint64_t x52;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x53;
    uint64_t x54;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x55;
    uint64_t x56;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x57;
    uint64_t x58;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x59;
    uint64_t x60;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x61;
    uint64_t x62;
    uint64_t x63;
    uint64_t x64;
    uint64_t x65;
    uint64_t x66;
    uint64_t x67;
    uint64_t x68;
    uint64_t x69;
    uint64_t x70;
    uint64_t x71;
    uint64_t x72;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x73;
    uint64_t x74;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x75;
    uint64_t x76;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x77;
    uint64_t x78;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x79;
    uint64_t x80;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x81;
    uint64_t x82;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x83;
    uint64_t x84;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x85;
    uint64_t x86;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x87;
    uint64_t x88;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x89;
    uint64_t x90;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x91;
    uint64_t x92;
    uint64_t x93;
    uint64_t x94;
    uint64_t x95;
    uint64_t x96;
    uint64_t x97;
    uint64_t x98;
    uint64_t x99;
    uint64_t x100;
    uint64_t x101;
    uint64_t x102;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x103;
    uint64_t x104;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x105;
    uint64_t x106;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x107;
    uint64_t x108;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x109;
    uint64_t x110;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x111;
    uint64_t x112;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x113;
    uint64_t x114;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x115;
    uint64_t x116;
    uint64_t x117;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x118;
    uint64_t x119;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x120;
    uint64_t x121;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x122;
    uint64_t x123;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x124;
    uint64_t x125;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x126;
    uint64_t x127;
    uint64_t x128;
    uint64_t x129;
    uint64_t x130;
    x1 = (arg1[0]);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x2, &x3, x1, UINT64_C(0xdf6e6c2c727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x4, &x5, x2, UINT64_C(0x9b9f605f5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x6, &x7, x2, UINT64_C(0xab1ec85e6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x8, &x9, x2, UINT64_C(0xcf846e86789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x10, &x11, x2, UINT64_C(0x7998f7b9022d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x12, &x13, 0x0,
                                                              x11, x8);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x14, &x15, x13,
                                                              x9, x6);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x16, &x17, x15,
                                                              x7, x4);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x18, &x19, 0x0,
                                                              x1, x10);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x20, &x21, x19,
                                                              0x0, x12);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x22, &x23, x21,
                                                              0x0, x14);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x24, &x25, x23,
                                                              0x0, x16);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x26, &x27, 0x0,
                                                              x20, (arg1[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x28, &x29, x27,
                                                              x22, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x30, &x31, x29,
                                                              x24, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x32, &x33, x26, UINT64_C(0xdf6e6c2c727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x34, &x35, x32, UINT64_C(0x9b9f605f5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x36, &x37, x32, UINT64_C(0xab1ec85e6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x38, &x39, x32, UINT64_C(0xcf846e86789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x40, &x41, x32, UINT64_C(0x7998f7b9022d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x42, &x43, 0x0,
                                                              x41, x38);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x44, &x45, x43,
                                                              x39, x36);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x46, &x47, x45,
                                                              x37, x34);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x48, &x49, 0x0,
                                                              x26, x40);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x50, &x51, x49,
                                                              x28, x42);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x52, &x53, x51,
                                                              x30, x44);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(
        &x54, &x55, x53, (x31 + (x25 + (x17 + x5))), x46);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x56, &x57, 0x0,
                                                              x50, (arg1[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x58, &x59, x57,
                                                              x52, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x60, &x61, x59,
                                                              x54, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x62, &x63, x56, UINT64_C(0xdf6e6c2c727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x64, &x65, x62, UINT64_C(0x9b9f605f5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x66, &x67, x62, UINT64_C(0xab1ec85e6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x68, &x69, x62, UINT64_C(0xcf846e86789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x70, &x71, x62, UINT64_C(0x7998f7b9022d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x72, &x73, 0x0,
                                                              x71, x68);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x74, &x75, x73,
                                                              x69, x66);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x76, &x77, x75,
                                                              x67, x64);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x78, &x79, 0x0,
                                                              x56, x70);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x80, &x81, x79,
                                                              x58, x72);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x82, &x83, x81,
                                                              x60, x74);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(
        &x84, &x85, x83, (x61 + (x55 + (x47 + x35))), x76);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x86, &x87, 0x0,
                                                              x80, (arg1[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x88, &x89, x87,
                                                              x82, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x90, &x91, x89,
                                                              x84, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x92, &x93, x86, UINT64_C(0xdf6e6c2c727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x94, &x95, x92, UINT64_C(0x9b9f605f5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x96, &x97, x92, UINT64_C(0xab1ec85e6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x98, &x99, x92, UINT64_C(0xcf846e86789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x100, &x101, x92, UINT64_C(0x7998f7b9022d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x102, &x103, 0x0,
                                                              x101, x98);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x104, &x105,
                                                              x103, x99, x96);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x106, &x107,
                                                              x105, x97, x94);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x108, &x109, 0x0,
                                                              x86, x100);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x110, &x111,
                                                              x109, x88, x102);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x112, &x113,
                                                              x111, x90, x104);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(
        &x114, &x115, x113, (x91 + (x85 + (x77 + x65))), x106);
    x116 = (x115 + (x107 + x95));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(
        &x117, &x118, 0x0, x110, UINT64_C(0x7998f7b9022d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(
        &x119, &x120, x118, x112, UINT64_C(0xcf846e86789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(
        &x121, &x122, x120, x114, UINT64_C(0xab1ec85e6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(
        &x123, &x124, x122, x116, UINT64_C(0x9b9f605f5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(&x125, &x126,
                                                               x124, 0x0, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u64(&x127, x126, x117,
                                                            x110);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u64(&x128, x126, x119,
                                                            x112);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u64(&x129, x126, x121,
                                                            x114);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u64(&x130, x126, x123,
                                                            x116);
    out1[0] = x127;
    out1[1] = x128;
    out1[2] = x129;
    out1[3] = x130;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_to_montgomery translates a field element into the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = eval arg1 mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_to_montgomery(
    uint64_t out1[4], const uint64_t arg1[4]) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint64_t x8;
    uint64_t x9;
    uint64_t x10;
    uint64_t x11;
    uint64_t x12;
    uint64_t x13;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x14;
    uint64_t x15;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x16;
    uint64_t x17;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x18;
    uint64_t x19;
    uint64_t x20;
    uint64_t x21;
    uint64_t x22;
    uint64_t x23;
    uint64_t x24;
    uint64_t x25;
    uint64_t x26;
    uint64_t x27;
    uint64_t x28;
    uint64_t x29;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x30;
    uint64_t x31;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x32;
    uint64_t x33;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x34;
    uint64_t x35;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x36;
    uint64_t x37;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x38;
    uint64_t x39;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x40;
    uint64_t x41;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x42;
    uint64_t x43;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x44;
    uint64_t x45;
    uint64_t x46;
    uint64_t x47;
    uint64_t x48;
    uint64_t x49;
    uint64_t x50;
    uint64_t x51;
    uint64_t x52;
    uint64_t x53;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x54;
    uint64_t x55;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x56;
    uint64_t x57;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x58;
    uint64_t x59;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x60;
    uint64_t x61;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x62;
    uint64_t x63;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x64;
    uint64_t x65;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x66;
    uint64_t x67;
    uint64_t x68;
    uint64_t x69;
    uint64_t x70;
    uint64_t x71;
    uint64_t x72;
    uint64_t x73;
    uint64_t x74;
    uint64_t x75;
    uint64_t x76;
    uint64_t x77;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x78;
    uint64_t x79;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x80;
    uint64_t x81;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x82;
    uint64_t x83;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x84;
    uint64_t x85;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x86;
    uint64_t x87;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x88;
    uint64_t x89;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x90;
    uint64_t x91;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x92;
    uint64_t x93;
    uint64_t x94;
    uint64_t x95;
    uint64_t x96;
    uint64_t x97;
    uint64_t x98;
    uint64_t x99;
    uint64_t x100;
    uint64_t x101;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x102;
    uint64_t x103;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x104;
    uint64_t x105;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x106;
    uint64_t x107;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x108;
    uint64_t x109;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x110;
    uint64_t x111;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x112;
    uint64_t x113;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x114;
    uint64_t x115;
    uint64_t x116;
    uint64_t x117;
    uint64_t x118;
    uint64_t x119;
    uint64_t x120;
    uint64_t x121;
    uint64_t x122;
    uint64_t x123;
    uint64_t x124;
    uint64_t x125;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x126;
    uint64_t x127;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x128;
    uint64_t x129;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x130;
    uint64_t x131;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x132;
    uint64_t x133;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x134;
    uint64_t x135;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x136;
    uint64_t x137;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x138;
    uint64_t x139;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x140;
    uint64_t x141;
    uint64_t x142;
    uint64_t x143;
    uint64_t x144;
    uint64_t x145;
    uint64_t x146;
    uint64_t x147;
    uint64_t x148;
    uint64_t x149;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x150;
    uint64_t x151;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x152;
    uint64_t x153;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x154;
    uint64_t x155;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x156;
    uint64_t x157;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x158;
    uint64_t x159;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x160;
    uint64_t x161;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x162;
    uint64_t x163;
    uint64_t x164;
    uint64_t x165;
    uint64_t x166;
    uint64_t x167;
    uint64_t x168;
    uint64_t x169;
    uint64_t x170;
    uint64_t x171;
    uint64_t x172;
    uint64_t x173;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x174;
    uint64_t x175;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x176;
    uint64_t x177;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x178;
    uint64_t x179;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x180;
    uint64_t x181;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x182;
    uint64_t x183;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x184;
    uint64_t x185;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x186;
    uint64_t x187;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x188;
    uint64_t x189;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x190;
    uint64_t x191;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x192;
    uint64_t x193;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x194;
    uint64_t x195;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x196;
    uint64_t x197;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x198;
    uint64_t x199;
    uint64_t x200;
    uint64_t x201;
    uint64_t x202;
    x1 = (arg1[1]);
    x2 = (arg1[2]);
    x3 = (arg1[3]);
    x4 = (arg1[0]);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x5, &x6, x4, UINT64_C(0x807a394ede097652));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x7, &x8, x4, UINT64_C(0x186304212849c07b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x9, &x10, x4, UINT64_C(0x1017bb39c2d346c5));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x11, &x12, x4, UINT64_C(0x409973b4c427fcea));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x13, &x14, 0x0,
                                                              x12, x9);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x15, &x16, x14,
                                                              x10, x7);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x17, &x18, x16,
                                                              x8, x5);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x19, &x20, x11, UINT64_C(0xdf6e6c2c727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x21, &x22, x19, UINT64_C(0x9b9f605f5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x23, &x24, x19, UINT64_C(0xab1ec85e6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x25, &x26, x19, UINT64_C(0xcf846e86789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x27, &x28, x19, UINT64_C(0x7998f7b9022d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x29, &x30, 0x0,
                                                              x28, x25);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x31, &x32, x30,
                                                              x26, x23);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x33, &x34, x32,
                                                              x24, x21);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x35, &x36, 0x0,
                                                              x11, x27);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x37, &x38, x36,
                                                              x13, x29);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x39, &x40, x38,
                                                              x15, x31);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x41, &x42, x40,
                                                              x17, x33);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(
        &x43, &x44, x42, (x18 + x6), (x34 + x22));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x45, &x46, x1, UINT64_C(0x807a394ede097652));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x47, &x48, x1, UINT64_C(0x186304212849c07b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x49, &x50, x1, UINT64_C(0x1017bb39c2d346c5));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x51, &x52, x1, UINT64_C(0x409973b4c427fcea));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x53, &x54, 0x0,
                                                              x52, x49);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x55, &x56, x54,
                                                              x50, x47);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x57, &x58, x56,
                                                              x48, x45);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x59, &x60, 0x0,
                                                              x37, x51);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x61, &x62, x60,
                                                              x39, x53);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x63, &x64, x62,
                                                              x41, x55);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x65, &x66, x64,
                                                              x43, x57);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x67, &x68, x59, UINT64_C(0xdf6e6c2c727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x69, &x70, x67, UINT64_C(0x9b9f605f5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x71, &x72, x67, UINT64_C(0xab1ec85e6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x73, &x74, x67, UINT64_C(0xcf846e86789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x75, &x76, x67, UINT64_C(0x7998f7b9022d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x77, &x78, 0x0,
                                                              x76, x73);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x79, &x80, x78,
                                                              x74, x71);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x81, &x82, x80,
                                                              x72, x69);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x83, &x84, 0x0,
                                                              x59, x75);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x85, &x86, x84,
                                                              x61, x77);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x87, &x88, x86,
                                                              x63, x79);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x89, &x90, x88,
                                                              x65, x81);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(
        &x91, &x92, x90, (((uint64_t)x66 + x44) + (x58 + x46)), (x82 + x70));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x93, &x94, x2, UINT64_C(0x807a394ede097652));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x95, &x96, x2, UINT64_C(0x186304212849c07b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x97, &x98, x2, UINT64_C(0x1017bb39c2d346c5));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x99, &x100, x2, UINT64_C(0x409973b4c427fcea));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x101, &x102, 0x0,
                                                              x100, x97);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x103, &x104,
                                                              x102, x98, x95);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x105, &x106,
                                                              x104, x96, x93);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x107, &x108, 0x0,
                                                              x85, x99);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x109, &x110,
                                                              x108, x87, x101);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x111, &x112,
                                                              x110, x89, x103);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x113, &x114,
                                                              x112, x91, x105);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x115, &x116, x107, UINT64_C(0xdf6e6c2c727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x117, &x118, x115, UINT64_C(0x9b9f605f5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x119, &x120, x115, UINT64_C(0xab1ec85e6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x121, &x122, x115, UINT64_C(0xcf846e86789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x123, &x124, x115, UINT64_C(0x7998f7b9022d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x125, &x126, 0x0,
                                                              x124, x121);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x127, &x128,
                                                              x126, x122, x119);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x129, &x130,
                                                              x128, x120, x117);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x131, &x132, 0x0,
                                                              x107, x123);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x133, &x134,
                                                              x132, x109, x125);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x135, &x136,
                                                              x134, x111, x127);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x137, &x138,
                                                              x136, x113, x129);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(
        &x139, &x140, x138, (((uint64_t)x114 + x92) + (x106 + x94)),
        (x130 + x118));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x141, &x142, x3, UINT64_C(0x807a394ede097652));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x143, &x144, x3, UINT64_C(0x186304212849c07b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x145, &x146, x3, UINT64_C(0x1017bb39c2d346c5));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x147, &x148, x3, UINT64_C(0x409973b4c427fcea));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x149, &x150, 0x0,
                                                              x148, x145);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x151, &x152,
                                                              x150, x146, x143);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x153, &x154,
                                                              x152, x144, x141);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x155, &x156, 0x0,
                                                              x133, x147);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x157, &x158,
                                                              x156, x135, x149);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x159, &x160,
                                                              x158, x137, x151);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x161, &x162,
                                                              x160, x139, x153);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x163, &x164, x155, UINT64_C(0xdf6e6c2c727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x165, &x166, x163, UINT64_C(0x9b9f605f5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x167, &x168, x163, UINT64_C(0xab1ec85e6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x169, &x170, x163, UINT64_C(0xcf846e86789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u64(
        &x171, &x172, x163, UINT64_C(0x7998f7b9022d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x173, &x174, 0x0,
                                                              x172, x169);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x175, &x176,
                                                              x174, x170, x167);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x177, &x178,
                                                              x176, x168, x165);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x179, &x180, 0x0,
                                                              x155, x171);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x181, &x182,
                                                              x180, x157, x173);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x183, &x184,
                                                              x182, x159, x175);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(&x185, &x186,
                                                              x184, x161, x177);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u64(
        &x187, &x188, x186, (((uint64_t)x162 + x140) + (x154 + x142)),
        (x178 + x166));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(
        &x189, &x190, 0x0, x181, UINT64_C(0x7998f7b9022d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(
        &x191, &x192, x190, x183, UINT64_C(0xcf846e86789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(
        &x193, &x194, x192, x185, UINT64_C(0xab1ec85e6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(
        &x195, &x196, x194, x187, UINT64_C(0x9b9f605f5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u64(&x197, &x198,
                                                               x196, x188, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u64(&x199, x198, x189,
                                                            x181);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u64(&x200, x198, x191,
                                                            x183);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u64(&x201, x198, x193,
                                                            x185);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u64(&x202, x198, x195,
                                                            x187);
    out1[0] = x199;
    out1[1] = x200;
    out1[2] = x201;
    out1[3] = x202;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_nonzero outputs a single non-zero word if the input is non-zero and zero otherwise.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffffffffffff]
 */
static void fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_nonzero(
    uint64_t *out1, const uint64_t arg1[4]) {
    uint64_t x1;
    x1 = ((arg1[0]) | ((arg1[1]) | ((arg1[2]) | (arg1[3]))));
    *out1 = x1;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz is a multi-limb conditional select.
 * Postconditions:
 *   eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 *   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(
    uint64_t out1[4], fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 arg1,
    const uint64_t arg2[4], const uint64_t arg3[4]) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u64(
        &x1, arg1, (arg2[0]), (arg3[0]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u64(
        &x2, arg1, (arg2[1]), (arg3[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u64(
        &x3, arg1, (arg2[2]), (arg3[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u64(
        &x4, arg1, (arg2[3]), (arg3[3]));
    out1[0] = x1;
    out1[1] = x2;
    out1[2] = x3;
    out1[3] = x4;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_to_bytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..31]
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_to_bytes(
    uint8_t out1[32], const uint64_t arg1[4]) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint8_t x5;
    uint64_t x6;
    uint8_t x7;
    uint64_t x8;
    uint8_t x9;
    uint64_t x10;
    uint8_t x11;
    uint64_t x12;
    uint8_t x13;
    uint64_t x14;
    uint8_t x15;
    uint64_t x16;
    uint8_t x17;
    uint8_t x18;
    uint8_t x19;
    uint64_t x20;
    uint8_t x21;
    uint64_t x22;
    uint8_t x23;
    uint64_t x24;
    uint8_t x25;
    uint64_t x26;
    uint8_t x27;
    uint64_t x28;
    uint8_t x29;
    uint64_t x30;
    uint8_t x31;
    uint8_t x32;
    uint8_t x33;
    uint64_t x34;
    uint8_t x35;
    uint64_t x36;
    uint8_t x37;
    uint64_t x38;
    uint8_t x39;
    uint64_t x40;
    uint8_t x41;
    uint64_t x42;
    uint8_t x43;
    uint64_t x44;
    uint8_t x45;
    uint8_t x46;
    uint8_t x47;
    uint64_t x48;
    uint8_t x49;
    uint64_t x50;
    uint8_t x51;
    uint64_t x52;
    uint8_t x53;
    uint64_t x54;
    uint8_t x55;
    uint64_t x56;
    uint8_t x57;
    uint64_t x58;
    uint8_t x59;
    uint8_t x60;
    x1 = (arg1[3]);
    x2 = (arg1[2]);
    x3 = (arg1[1]);
    x4 = (arg1[0]);
    x5 = (uint8_t)(x4 & UINT8_C(0xff));
    x6 = (x4 >> 8);
    x7 = (uint8_t)(x6 & UINT8_C(0xff));
    x8 = (x6 >> 8);
    x9 = (uint8_t)(x8 & UINT8_C(0xff));
    x10 = (x8 >> 8);
    x11 = (uint8_t)(x10 & UINT8_C(0xff));
    x12 = (x10 >> 8);
    x13 = (uint8_t)(x12 & UINT8_C(0xff));
    x14 = (x12 >> 8);
    x15 = (uint8_t)(x14 & UINT8_C(0xff));
    x16 = (x14 >> 8);
    x17 = (uint8_t)(x16 & UINT8_C(0xff));
    x18 = (uint8_t)(x16 >> 8);
    x19 = (uint8_t)(x3 & UINT8_C(0xff));
    x20 = (x3 >> 8);
    x21 = (uint8_t)(x20 & UINT8_C(0xff));
    x22 = (x20 >> 8);
    x23 = (uint8_t)(x22 & UINT8_C(0xff));
    x24 = (x22 >> 8);
    x25 = (uint8_t)(x24 & UINT8_C(0xff));
    x26 = (x24 >> 8);
    x27 = (uint8_t)(x26 & UINT8_C(0xff));
    x28 = (x26 >> 8);
    x29 = (uint8_t)(x28 & UINT8_C(0xff));
    x30 = (x28 >> 8);
    x31 = (uint8_t)(x30 & UINT8_C(0xff));
    x32 = (uint8_t)(x30 >> 8);
    x33 = (uint8_t)(x2 & UINT8_C(0xff));
    x34 = (x2 >> 8);
    x35 = (uint8_t)(x34 & UINT8_C(0xff));
    x36 = (x34 >> 8);
    x37 = (uint8_t)(x36 & UINT8_C(0xff));
    x38 = (x36 >> 8);
    x39 = (uint8_t)(x38 & UINT8_C(0xff));
    x40 = (x38 >> 8);
    x41 = (uint8_t)(x40 & UINT8_C(0xff));
    x42 = (x40 >> 8);
    x43 = (uint8_t)(x42 & UINT8_C(0xff));
    x44 = (x42 >> 8);
    x45 = (uint8_t)(x44 & UINT8_C(0xff));
    x46 = (uint8_t)(x44 >> 8);
    x47 = (uint8_t)(x1 & UINT8_C(0xff));
    x48 = (x1 >> 8);
    x49 = (uint8_t)(x48 & UINT8_C(0xff));
    x50 = (x48 >> 8);
    x51 = (uint8_t)(x50 & UINT8_C(0xff));
    x52 = (x50 >> 8);
    x53 = (uint8_t)(x52 & UINT8_C(0xff));
    x54 = (x52 >> 8);
    x55 = (uint8_t)(x54 & UINT8_C(0xff));
    x56 = (x54 >> 8);
    x57 = (uint8_t)(x56 & UINT8_C(0xff));
    x58 = (x56 >> 8);
    x59 = (uint8_t)(x58 & UINT8_C(0xff));
    x60 = (uint8_t)(x58 >> 8);
    out1[0] = x5;
    out1[1] = x7;
    out1[2] = x9;
    out1[3] = x11;
    out1[4] = x13;
    out1[5] = x15;
    out1[6] = x17;
    out1[7] = x18;
    out1[8] = x19;
    out1[9] = x21;
    out1[10] = x23;
    out1[11] = x25;
    out1[12] = x27;
    out1[13] = x29;
    out1[14] = x31;
    out1[15] = x32;
    out1[16] = x33;
    out1[17] = x35;
    out1[18] = x37;
    out1[19] = x39;
    out1[20] = x41;
    out1[21] = x43;
    out1[22] = x45;
    out1[23] = x46;
    out1[24] = x47;
    out1[25] = x49;
    out1[26] = x51;
    out1[27] = x53;
    out1[28] = x55;
    out1[29] = x57;
    out1[30] = x59;
    out1[31] = x60;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_from_bytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order.
 * Preconditions:
 *   0 ≤ bytes_eval arg1 < m
 * Postconditions:
 *   eval out1 mod m = bytes_eval arg1 mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_from_bytes(
    uint64_t out1[4], const uint8_t arg1[32]) {
    uint64_t x1;
    uint64_t x2;
    uint64_t x3;
    uint64_t x4;
    uint64_t x5;
    uint64_t x6;
    uint64_t x7;
    uint8_t x8;
    uint64_t x9;
    uint64_t x10;
    uint64_t x11;
    uint64_t x12;
    uint64_t x13;
    uint64_t x14;
    uint64_t x15;
    uint8_t x16;
    uint64_t x17;
    uint64_t x18;
    uint64_t x19;
    uint64_t x20;
    uint64_t x21;
    uint64_t x22;
    uint64_t x23;
    uint8_t x24;
    uint64_t x25;
    uint64_t x26;
    uint64_t x27;
    uint64_t x28;
    uint64_t x29;
    uint64_t x30;
    uint64_t x31;
    uint8_t x32;
    uint64_t x33;
    uint64_t x34;
    uint64_t x35;
    uint64_t x36;
    uint64_t x37;
    uint64_t x38;
    uint64_t x39;
    uint64_t x40;
    uint64_t x41;
    uint64_t x42;
    uint64_t x43;
    uint64_t x44;
    uint64_t x45;
    uint64_t x46;
    uint64_t x47;
    uint64_t x48;
    uint64_t x49;
    uint64_t x50;
    uint64_t x51;
    uint64_t x52;
    uint64_t x53;
    uint64_t x54;
    uint64_t x55;
    uint64_t x56;
    uint64_t x57;
    uint64_t x58;
    uint64_t x59;
    uint64_t x60;
    x1 = ((uint64_t)(arg1[31]) << 56);
    x2 = ((uint64_t)(arg1[30]) << 48);
    x3 = ((uint64_t)(arg1[29]) << 40);
    x4 = ((uint64_t)(arg1[28]) << 32);
    x5 = ((uint64_t)(arg1[27]) << 24);
    x6 = ((uint64_t)(arg1[26]) << 16);
    x7 = ((uint64_t)(arg1[25]) << 8);
    x8 = (arg1[24]);
    x9 = ((uint64_t)(arg1[23]) << 56);
    x10 = ((uint64_t)(arg1[22]) << 48);
    x11 = ((uint64_t)(arg1[21]) << 40);
    x12 = ((uint64_t)(arg1[20]) << 32);
    x13 = ((uint64_t)(arg1[19]) << 24);
    x14 = ((uint64_t)(arg1[18]) << 16);
    x15 = ((uint64_t)(arg1[17]) << 8);
    x16 = (arg1[16]);
    x17 = ((uint64_t)(arg1[15]) << 56);
    x18 = ((uint64_t)(arg1[14]) << 48);
    x19 = ((uint64_t)(arg1[13]) << 40);
    x20 = ((uint64_t)(arg1[12]) << 32);
    x21 = ((uint64_t)(arg1[11]) << 24);
    x22 = ((uint64_t)(arg1[10]) << 16);
    x23 = ((uint64_t)(arg1[9]) << 8);
    x24 = (arg1[8]);
    x25 = ((uint64_t)(arg1[7]) << 56);
    x26 = ((uint64_t)(arg1[6]) << 48);
    x27 = ((uint64_t)(arg1[5]) << 40);
    x28 = ((uint64_t)(arg1[4]) << 32);
    x29 = ((uint64_t)(arg1[3]) << 24);
    x30 = ((uint64_t)(arg1[2]) << 16);
    x31 = ((uint64_t)(arg1[1]) << 8);
    x32 = (arg1[0]);
    x33 = (x31 + (uint64_t)x32);
    x34 = (x30 + x33);
    x35 = (x29 + x34);
    x36 = (x28 + x35);
    x37 = (x27 + x36);
    x38 = (x26 + x37);
    x39 = (x25 + x38);
    x40 = (x23 + (uint64_t)x24);
    x41 = (x22 + x40);
    x42 = (x21 + x41);
    x43 = (x20 + x42);
    x44 = (x19 + x43);
    x45 = (x18 + x44);
    x46 = (x17 + x45);
    x47 = (x15 + (uint64_t)x16);
    x48 = (x14 + x47);
    x49 = (x13 + x48);
    x50 = (x12 + x49);
    x51 = (x11 + x50);
    x52 = (x10 + x51);
    x53 = (x9 + x52);
    x54 = (x7 + (uint64_t)x8);
    x55 = (x6 + x54);
    x56 = (x5 + x55);
    x57 = (x4 + x56);
    x58 = (x3 + x57);
    x59 = (x2 + x58);
    x60 = (x1 + x59);
    out1[0] = x39;
    out1[1] = x46;
    out1[2] = x53;
    out1[3] = x60;
}

/* END verbatim fiat code */

/*-
 * Finite field inversion via FLT.
 * NB: this is not a real Fiat function, just named that way for consistency.
 * Autogenerated: ecp/id_GostR3410_2001_CryptoPro_C_ParamSet/fe_inv.op3
 * sliding window w=5
 */
static void fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_inv(fe_t output,
                                                            const fe_t t1) {
    int i;
    /* temporary variables */
    fe_t acc, t11, t13, t15, t17, t19, t21, t23, t25, t27, t29, t3, t31, t5, t7,
        t9;

    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, t1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t3, t1, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t5, t3, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t7, t5, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t9, t7, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t11, t9, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t13, t11, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t15, t13, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t17, t15, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t19, t17, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t21, t19, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t23, t21, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t25, t23, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t27, t25, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t29, t27, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t31, t29, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, t9);
    for (i = 0; i < 4; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t23);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t7);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t27);
    for (i = 0; i < 7; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t1);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t15);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t21);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t21);
    for (i = 0; i < 8; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t11);
    for (i = 0; i < 7; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t1);
    for (i = 0; i < 6; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t1);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t29);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t11);
    for (i = 0; i < 7; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t15);
    for (i = 0; i < 6; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t25);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t1);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t15);
    for (i = 0; i < 6; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t13);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t13);
    for (i = 0; i < 6; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t1);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t25);
    for (i = 0; i < 8; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t21);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t11);
    for (i = 0; i < 7; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t31);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t1);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t3);
    for (i = 0; i < 6; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t29);
    for (i = 0; i < 6; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t3);
    for (i = 0; i < 6; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t15);
    for (i = 0; i < 7; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t9);
    for (i = 0; i < 8; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t5);
    for (i = 0; i < 6; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t7);
    for (i = 0; i < 6; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t19);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t15);
    for (i = 0; i < 7; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t25);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t17);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t29);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t29);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t25);
    for (i = 0; i < 7; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t1);
    for (i = 0; i < 7; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t11);
    for (i = 0; i < 6; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t23);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t11);
    for (i = 0; i < 7; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(output, acc, t25);
}

/* curve coefficient constants */

static const limb_t const_one[4] = {
    UINT64_C(0x86670846FDD28A65), UINT64_C(0x307B9179876FAE2C),
    UINT64_C(0x54E137A194BE3755), UINT64_C(0x64609FA0A57A7EF8)};

static const limb_t const_b[4] = {
    UINT64_C(0x4BE8A4E93BDA2ACF), UINT64_C(0x79CC0E3E90D382DD),
    UINT64_C(0x3BA4C8B01D9CC79B), UINT64_C(0x5CC73B5A966609E9)};

/* LUT for scalar multiplication by comb interleaving */
static const pt_aff_t lut_cmb[27][16] = {
    {
        {{UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000),
          UINT64_C(0x0000000000000000), UINT64_C(0x0000000000000000)},
         {UINT64_C(0xD082E00700254F12), UINT64_C(0xC5BA8184EB1F1421),
          UINT64_C(0x4EC9E7D0F010780D), UINT64_C(0x7846B5B72794C8D5)}},
        {{UINT64_C(0x870FB0417225A595), UINT64_C(0x6CAFAE705FD57F04),
          UINT64_C(0xFEC1C2AC2E7DB9BA), UINT64_C(0x9230823E127A5862)},
         {UINT64_C(0xF6CFDB6DE4464836), UINT64_C(0x3D79631B9A945AC0),
          UINT64_C(0xA1FCF2DF3D0C880D), UINT64_C(0x17C83E500EE6A611)}},
        {{UINT64_C(0x3C79C11AE42734FD), UINT64_C(0x1614B2BEAC4040C3),
          UINT64_C(0xDD1437252C3A23A5), UINT64_C(0x1A02DA838AF4F7CD)},
         {UINT64_C(0x23D588D6E7D6991A), UINT64_C(0x5F332676D2B3E364),
          UINT64_C(0x353826809134BA88), UINT64_C(0x08ECA826D27090E5)}},
        {{UINT64_C(0x231F8DC826761106), UINT64_C(0x7363050E3D78B14B),
          UINT64_C(0xC3B9A1B8C05C4381), UINT64_C(0x29727635B8ACD9AC)},
         {UINT64_C(0xDD416AE92ED54E6C), UINT64_C(0x546084350B48A87C),
          UINT64_C(0x2C8DEEA497093D22), UINT64_C(0x87D2924C0D716BAF)}},
        {{UINT64_C(0x43281D30619206D6), UINT64_C(0x4A8FFC8768744E44),
          UINT64_C(0xB1011A3D708208D5), UINT64_C(0x2FE86E7BA035B0B9)},
         {UINT64_C(0x82F43088A3762860), UINT64_C(0x67B5A303B33595D4),
          UINT64_C(0x262F16EBB477BECD), UINT64_C(0x1D38D4A723E2816A)}},
        {{UINT64_C(0x91BBA3C0AD83C032), UINT64_C(0x7DBC2EB6234F2FF3),
          UINT64_C(0xE2C00C156D18A737), UINT64_C(0x71D1AE8BCCF6DC2D)},
         {UINT64_C(0x6183816A2DB77239), UINT64_C(0xC545A5120E228C41),
          UINT64_C(0x3B96D6BC0F49A679), UINT64_C(0x9831D683E49E39C2)}},
        {{UINT64_C(0xEEAA17A920DA13D9), UINT64_C(0xEE3130FB8ABECADE),
          UINT64_C(0xBFB2CE6AA6E3D089), UINT64_C(0x22BCDCEEE627A07C)},
         {UINT64_C(0x86D7A50C955A1D9E), UINT64_C(0xCD60A425E4E00B9E),
          UINT64_C(0x5407A6F8615B9E91), UINT64_C(0x7F17B1714F1CA93D)}},
        {{UINT64_C(0xBC351DE00DB59F2C), UINT64_C(0x1470E6A19CDAF8AF),
          UINT64_C(0x461ED28960D3B27A), UINT64_C(0x122C8F4B49C7F789)},
         {UINT64_C(0xAB56E614069FC8CE), UINT64_C(0x9836B010C34E487C),
          UINT64_C(0x9EE067033FE009EB), UINT64_C(0x88C8DC64AA019563)}},
        {{UINT64_C(0xD0B4A99663DDBB1F), UINT64_C(0x483286E51D154696),
          UINT64_C(0xF0586DB89F0D6F4E), UINT64_C(0x38167987980446C8)},
         {UINT64_C(0x86A2ABACE4166B55), UINT64_C(0x4E7B4F96A8366C64),
          UINT64_C(0x20CF2108ED997D8E), UINT64_C(0x20EA98441D01C009)}},
        {{UINT64_C(0x028B520EB89CE05A), UINT64_C(0xEF41147D4FAAD420),
          UINT64_C(0xB280CCD3121A2A0A), UINT64_C(0x4C677C8386E8F591)},
         {UINT64_C(0xB42F67B2A390AA99), UINT64_C(0xC4EF553B19F8A01A),
          UINT64_C(0x867611396979027F), UINT64_C(0x6F17766382C202BE)}},
        {{UINT64_C(0xBEF6B99627C5C7CC), UINT64_C(0xB2D34F8B10799DB8),
          UINT64_C(0x132E1A3D48AD9B1E), UINT64_C(0x2971BFEDE68B9907)},
         {UINT64_C(0x312F6D31C6B743B5), UINT64_C(0xCF123317A718E0A8),
          UINT64_C(0xCF1E5266FD58637C), UINT64_C(0x56BA8362E046167C)}},
        {{UINT64_C(0xD680969D0E910D7F), UINT64_C(0x634FB3C28A4689F9),
          UINT64_C(0xA79A56DF09FDD299), UINT64_C(0x9065269E89411C3D)},
         {UINT64_C(0x5D22254E82C6076C), UINT64_C(0xDE7D78F081FEA171),
          UINT64_C(0xE136696410BCDA87), UINT64_C(0x98B58F5A97638B85)}},
        {{UINT64_C(0xA532DED4FB5EDF3F), UINT64_C(0x604E5631833A7E2F),
          UINT64_C(0x7C4051D33A09C74E), UINT64_C(0x51D1108AEDFBEB4B)},
         {UINT64_C(0x9AE61F9E4DF1AB4D), UINT64_C(0xFD4966F3163DB1A5),
          UINT64_C(0xF6C44E557075AD6D), UINT64_C(0x670D0D6F4AF24611)}},
        {{UINT64_C(0xD99925FFD369D301), UINT64_C(0xC17E97677665BCF4),
          UINT64_C(0xB5A908F1CB5A2128), UINT64_C(0x1981791D9C726C9F)},
         {UINT64_C(0xC4249418E0861F4E), UINT64_C(0x2A63399FEE045D5E),
          UINT64_C(0x246958FDA1B974FF), UINT64_C(0x668016A20FC6F7A0)}},
        {{UINT64_C(0xEB7018ADEDE07C08), UINT64_C(0xDF3C12592E33D1D9),
          UINT64_C(0xEE0913DADC24E3DE), UINT64_C(0x1C632D5B35EB6B0D)},
         {UINT64_C(0xC69396DD2C56E1B2), UINT64_C(0x01F0B034A837CE8F),
          UINT64_C(0x7842B98DB6882E32), UINT64_C(0x8FAC92309E61FCA6)}},
        {{UINT64_C(0x1DBB7D998A782CFE), UINT64_C(0xEB945B49C9322BE7),
          UINT64_C(0xDCCB4E6EE208123B), UINT64_C(0x1C7C265CFC024524)},
         {UINT64_C(0xAD000D8A6102BC63), UINT64_C(0x7D7F3C7B82575943),
          UINT64_C(0x8D2F08810D547A95), UINT64_C(0x7012377AD94FFA6D)}},
    },
    {
        {{UINT64_C(0xE3F78DE51EB6CBF7), UINT64_C(0xF4E08A6172FA65DB),
          UINT64_C(0x670B0E06502A247E), UINT64_C(0x7A45D73E9877E492)},
         {UINT64_C(0x5FD754AD3DD0CDBC), UINT64_C(0xA5C2B15E0125AB1F),
          UINT64_C(0xC503836FE614B7A9), UINT64_C(0x5548C4242C50DCFE)}},
        {{UINT64_C(0xCEE7BE65B9B38743), UINT64_C(0xD5E4171594BE028E),
          UINT64_C(0x08EC3CA3B5C45F7D), UINT64_C(0x1ACFAC17FB51261A)},
         {UINT64_C(0x45098D93A9C04381), UINT64_C(0x717FC0DCA5B45DC8),
          UINT64_C(0xF352A9C2EABEE4E5), UINT64_C(0x1964AF20F311B457)}},
        {{UINT64_C(0x8C2298080802A755), UINT64_C(0x46F0A7CA6140CDA7),
          UINT64_C(0xF0EEB7AEBC62603B), UINT64_C(0x8432E1524BF4B451)},
         {UINT64_C(0x3C31982563967F94), UINT64_C(0xF04EACB6A042AE13),
          UINT64_C(0xD7CB2DBC650A6ADB), UINT64_C(0x38A36EE378C9E166)}},
        {{UINT64_C(0x3527A5C5D3EE8657), UINT64_C(0xBAA0DE97101645F9),
          UINT64_C(0xC59C9803CE9D6A48), UINT64_C(0x43D12449F8F39FDF)},
         {UINT64_C(0x65B3AB988DF7A72B), UINT64_C(0xD225AF8EAFDA9048),
          UINT64_C(0x88C368B8338A3694), UINT64_C(0x4A5A3C24FBC813F1)}},
        {{UINT64_C(0xCBCB725A9E2118B5), UINT64_C(0x113F36C5CAA54794),
          UINT64_C(0x5900990E4A0A2267), UINT64_C(0x4E329EB10A9C1F11)},
         {UINT64_C(0xF47F4077CD8918A7), UINT64_C(0x18A3C0713877B404),
          UINT64_C(0xCDEF4FE3EFEB2B6B), UINT64_C(0x360982DBDE4D0540)}},
        {{UINT64_C(0x42AB64F2D5F8DACA), UINT64_C(0x604A9676EE88523D),
          UINT64_C(0xD430CCABAEFD1283), UINT64_C(0x3DA9D0E554465F7C)},
         {UINT64_C(0x5EC145DF41A4216B), UINT64_C(0x7C8F2C51F7E7FBD9),
          UINT64_C(0xA2E58A23BD483D26), UINT64_C(0x4739F7F9E4A908C8)}},
        {{UINT64_C(0x37DDF87279370382), UINT64_C(0x9D26A55F12C8E90E),
          UINT64_C(0xFC1FA6CDE8EB0CA4), UINT64_C(0x826A29E5C29DC4F9)},
         {UINT64_C(0x15ECB621AA29F814), UINT64_C(0x4C8A81289DF1DFF7),
          UINT64_C(0xBB22301966B549BB), UINT64_C(0x6CB21ACBB81A2863)}},
        {{UINT64_C(0xDD31ACC211DA6928), UINT64_C(0xF98867B0A903D58F),
          UINT64_C(0xAD283697D3679348), UINT64_C(0x67BFEFF9301C3571)},
         {UINT64_C(0xB745CAE6780BBBCE), UINT64_C(0x1A9C661862F2EC5D),
          UINT64_C(0xF9895684A1475BEB), UINT64_C(0x93E5ACE64731A11D)}},
        {{UINT64_C(0x0F6E94607539483E), UINT64_C(0x5728E6DD9EF4EF16),
          UINT64_C(0xE1DA86E1062E946E), UINT64_C(0x272EBC47F2E07759)},
         {UINT64_C(0xE5E688E3909A578F), UINT64_C(0x9F25D6D17CFD1B7D),
          UINT64_C(0xC582260FADE1E2A4), UINT64_C(0x2F50F74EA050071E)}},
        {{UINT64_C(0xE0A8FE3F2DF4D40D), UINT64_C(0xB126E4EF07791F88),
          UINT64_C(0x69759DB42A88D242), UINT64_C(0x52592A3BC9C1981C)},
         {UINT64_C(0xD0F4172872F649A1), UINT64_C(0x9FF19B2B0750EBAB),
          UINT64_C(0xEFC047F9E0D7D222), UINT64_C(0x81491CA12E8140AF)}},
        {{UINT64_C(0x2DA40FF1675F821B), UINT64_C(0x2C91A2879E2E0502),
          UINT64_C(0x993ECFF4077D81FE), UINT64_C(0x3ABA2F2C71CC3DAE)},
         {UINT64_C(0xED007670168413DB), UINT64_C(0xC07D61B5AFBD4E82),
          UINT64_C(0xF078262E6BBADA24), UINT64_C(0x0E0EDC629E6413CC)}},
        {{UINT64_C(0x6CD0451DB7D099F9), UINT64_C(0x8FB218E6F8B12C83),
          UINT64_C(0x4D8C3B26E55EE1E4), UINT64_C(0x949649064A6FCD90)},
         {UINT64_C(0x9ABB96854BEACA48), UINT64_C(0x6A749487868EFEC7),
          UINT64_C(0x46BB9B42C8D2932C), UINT64_C(0x82384321DE007BAC)}},
        {{UINT64_C(0xDBECB743A942DB71), UINT64_C(0x21B5211521A6BC46),
          UINT64_C(0xE49B689424C17D78), UINT64_C(0x737FD3F189A08E17)},
         {UINT64_C(0xF833E404C36E4E57), UINT64_C(0x512C114A01E17CE6),
          UINT64_C(0x65A23D7350D75050), UINT64_C(0x838CA746F2F2D438)}},
        {{UINT64_C(0x28F9220CA20632B7), UINT64_C(0x72D8C347642358D6),
          UINT64_C(0xAB15FE1BE89CAA6F), UINT64_C(0x2A09B1436E16374A)},
         {UINT64_C(0x4CED0986B983CFE8), UINT64_C(0xD9B067B697B84E88),
          UINT64_C(0x926FC5F5C2350F8F), UINT64_C(0x31D7735884E2078F)}},
        {{UINT64_C(0xA7815CE77FF17BA1), UINT64_C(0xBE80BB6CA26BBA1B),
          UINT64_C(0x66DAE535F86DF104), UINT64_C(0x72739199AB1B9C09)},
         {UINT64_C(0x8E93F3C854056E67), UINT64_C(0xDC5E3855EBF23595),
          UINT64_C(0x70D1033C78123000), UINT64_C(0x50874350F22DD2BD)}},
        {{UINT64_C(0x533F213BC2700468), UINT64_C(0x31E6AA9C11BEA732),
          UINT64_C(0xCB5E184E4491DC82), UINT64_C(0x8A68049A5BD63975)},
         {UINT64_C(0x1724AC47F86A41D1), UINT64_C(0xDF9A0CA3ECA0DA11),
          UINT64_C(0xE5E1489C71F0EA19), UINT64_C(0x0E20661AC9DC7BF2)}},
    },
    {
        {{UINT64_C(0x5EB4E319F86D9DA8), UINT64_C(0x3CBF130EE0A46703),
          UINT64_C(0x166D52DA00A4AB17), UINT64_C(0x27A80547B7030861)},
         {UINT64_C(0xA7601086399C32BA), UINT64_C(0x571E4E4BC2F0A5E5),
          UINT64_C(0x72D12F6B39BED44D), UINT64_C(0x8FDCCE3D1AF8F25F)}},
        {{UINT64_C(0x281F7AF97DFEB40D), UINT64_C(0x0CCE33B9D7F767D5),
          UINT64_C(0x3E8BF3F48818C1E6), UINT64_C(0x6D909D0D4BA4647A)},
         {UINT64_C(0x91D77BA0FAC574D1), UINT64_C(0xD259266168CA7FEC),
          UINT64_C(0xC4C7D6B5281F269C), UINT64_C(0x7A41CD78DA42CDDD)}},
        {{UINT64_C(0xBC8E0D27A3B8F255), UINT64_C(0xF5E2A8B11C3E5190),
          UINT64_C(0x8C38862BD609F668), UINT64_C(0x4E31C18E0631D50F)},
         {UINT64_C(0x9013EDDBF13E0CCD), UINT64_C(0x83B04E6841EFDAF7),
          UINT64_C(0x15EC4BB8DC82597F), UINT64_C(0x5059515056117705)}},
        {{UINT64_C(0xD25F244D1E0E0161), UINT64_C(0x6C975D7B1A437FBA),
          UINT64_C(0x305DB2DF95F2AD8C), UINT64_C(0x17D6E0053B9CC742)},
         {UINT64_C(0x6A849F76E60BC3C3), UINT64_C(0x35523E08BF8C3790),
          UINT64_C(0xF18B5335239140E2), UINT64_C(0x5E8570557CA5FF40)}},
        {{UINT64_C(0xB48F07A4A4250E95), UINT64_C(0x068735AEC7F17667),
          UINT64_C(0x30F8D31394771B24), UINT64_C(0x598EA397A495A064)},
         {UINT64_C(0xBF19252968B76855), UINT64_C(0x897E3CC6C7C0D2D6),
          UINT64_C(0xA2A4948F64EC9649), UINT64_C(0x1027891AAE7C8598)}},
        {{UINT64_C(0x0442E6CB04585685), UINT64_C(0x09BA61DA82A2D258),
          UINT64_C(0x7C5400B10AE5466D), UINT64_C(0x0A0B71B0C2133893)},
         {UINT64_C(0x04E3D98AD5EF6E93), UINT64_C(0x177EA5F8F332BDF2),
          UINT64_C(0xE7CF3F71C3FAE583), UINT64_C(0x40C451338AE0CFD7)}},
        {{UINT64_C(0x6BE94FC39B82E738), UINT64_C(0x212FB8048BC262E2),
          UINT64_C(0xE17F6A7AB22E21FF), UINT64_C(0x22B7BDAB15E960BB)},
         {UINT64_C(0xE154C945771350C2), UINT64_C(0x6505B8EB882DB07B),
          UINT64_C(0x149A0A16C7E3ABD3), UINT64_C(0x78F78ABF81C30AAE)}},
        {{UINT64_C(0x6ED81415C954BC0A), UINT64_C(0x316E801270E55349),
          UINT64_C(0xEC02323B50399C09), UINT64_C(0x963BA97B8559C3A9)},
         {UINT64_C(0x39FCE50E037EC345), UINT64_C(0x422A082DD5BF03FB),
          UINT64_C(0x59ED39E418DCC77E), UINT64_C(0x4CFC3F11A40AA978)}},
        {{UINT64_C(0x85A5692255D7C9B6), UINT64_C(0x5BC590E2B451111B),
          UINT64_C(0x3BCB23158782C71B), UINT64_C(0x1F3456C4632246A9)},
         {UINT64_C(0xEA577AD99CFBBE19), UINT64_C(0x051BEE4035CCE939),
          UINT64_C(0xDC3008991A0C589C), UINT64_C(0x14877ECED2095619)}},
        {{UINT64_C(0xB64D0EC695024C5E), UINT64_C(0xB0597195B94CDF74),
          UINT64_C(0x3B97B51316844010), UINT64_C(0x48799881CCBABC63)},
         {UINT64_C(0x0E3119AED9819075), UINT64_C(0xA5DCA9C1EB0299FD),
          UINT64_C(0x8063D7884A404D13), UINT64_C(0x974D2A1A8044EBE2)}},
        {{UINT64_C(0xB6589045B8E14640), UINT64_C(0xFAD60A435507B9BE),
          UINT64_C(0x9D540C1C56FF32BC), UINT64_C(0x47ECC24F74265A69)},
         {UINT64_C(0x0C829F18DB3E64C9), UINT64_C(0xF7C0C6D772E87B2B),
          UINT64_C(0xCB3FC51216B616CE), UINT64_C(0x549B9227B94F69B1)}},
        {{UINT64_C(0xB151DEE9DB235273), UINT64_C(0x2FD9496F6D65606C),
          UINT64_C(0x6A5E172DD62B5B0D), UINT64_C(0x181E605DEA0AE249)},
         {UINT64_C(0x66D7EB098911490A), UINT64_C(0x85E174A32E70DEF2),
          UINT64_C(0x2DA133544EF8CFA9), UINT64_C(0x1B87FE623E69BD22)}},
        {{UINT64_C(0x2DF420CA2BB09564), UINT64_C(0x1AC26F767ACEE4D4),
          UINT64_C(0x50C68E6F2BC7EF7A), UINT64_C(0x4730D654B445B2FE)},
         {UINT64_C(0x90C040D98B57D38D), UINT64_C(0x28793DB533CA2C77),
          UINT64_C(0x22D2B573AC6A4BE8), UINT64_C(0x68C0DBDDB72E7E01)}},
        {{UINT64_C(0xDF70BCDC09E2D3FF), UINT64_C(0xB6E599709F20F624),
          UINT64_C(0x5E04FDE76DE3119E), UINT64_C(0x1C9B43FFD5705A5D)},
         {UINT64_C(0x7C23A517681270B0), UINT64_C(0xDD7FC8339303BF40),
          UINT64_C(0x3028E496458EE80A), UINT64_C(0x0C72006352590EEF)}},
        {{UINT64_C(0x27B297102850A5AE), UINT64_C(0xD1E6FBBAAA3E0397),
          UINT64_C(0xCFB44044DF8FCBD6), UINT64_C(0x7CD86272C52B90FD)},
         {UINT64_C(0xB0E7FA93EBA52025), UINT64_C(0x6416630304084EF3),
          UINT64_C(0xD7C7DCBE43840178), UINT64_C(0x8BC7FF7722FB81A2)}},
        {{UINT64_C(0xABDC5206DAFCE699), UINT64_C(0x522A913783C5F3A3),
          UINT64_C(0xBAA936370E666E5C), UINT64_C(0x0FD813DAD2D33B62)},
         {UINT64_C(0x833919085D417354), UINT64_C(0xE5AADE1DA6B9B447),
          UINT64_C(0xBDE90A3CD68321B1), UINT64_C(0x43FF95140411531B)}},
    },
    {
        {{UINT64_C(0xD61DEE6439648345), UINT64_C(0xF8B3FA1C7FCB5B5E),
          UINT64_C(0xDD531CE124C29C71), UINT64_C(0x7A23608BFFB825FE)},
         {UINT64_C(0x8D607B82F0DE896D), UINT64_C(0x6E49733006EDDAFE),
          UINT64_C(0x8B49EFF0C935E754), UINT64_C(0x90D54646EE08BDBF)}},
        {{UINT64_C(0xF44FBB169044FD39), UINT64_C(0xA72128C4DFB38141),
          UINT64_C(0x8467F68801954CC0), UINT64_C(0x741C23EEB560B5C5)},
         {UINT64_C(0xA7F422019765CF34), UINT64_C(0xB26C97BF8A2AB61A),
          UINT64_C(0xAA948763CBD45AF3), UINT64_C(0x74C993C2E21479F5)}},
        {{UINT64_C(0xD968CE1ABFA717A5), UINT64_C(0x45C1103D48E92615),
          UINT64_C(0x4CCEBE85DD98207D), UINT64_C(0x8A75DF6EE65E5FE6)},
         {UINT64_C(0x9E582C40418C47C5), UINT64_C(0x2E9EE003A450009B),
          UINT64_C(0x7C079613DD60D3D2), UINT64_C(0x80A78C4A9935D8CA)}},
        {{UINT64_C(0xF6CDED58D3C9B903), UINT64_C(0x4F27927DEF455E7A),
          UINT64_C(0xF9DBBB9E833BB3C1), UINT64_C(0x4107CFBF6BA3770A)},
         {UINT64_C(0x61871175520FCB57), UINT64_C(0xEA3A307B47A12C8E),
          UINT64_C(0x940DDEE8C24E9E75), UINT64_C(0x8AE8F22CF33541BB)}},
        {{UINT64_C(0xE4C898703973DC0B), UINT64_C(0xCC3DD1AC55DFAAF0),
          UINT64_C(0xB63D596B27372EFE), UINT64_C(0x1B92A19245A33718)},
         {UINT64_C(0x0EABEBEE00607319), UINT64_C(0x69B7355E7C3E35EE),
          UINT64_C(0xF7354E352233C454), UINT64_C(0x1E2BAADA1E722C0A)}},
        {{UINT64_C(0xD0E47FE23B9FE86D), UINT64_C(0x878F403FDAA1C7BC),
          UINT64_C(0x5447AD5490F5DED7), UINT64_C(0x4E8A997B1E58B03B)},
         {UINT64_C(0x9AD0E4812E926FA8), UINT64_C(0x871EFB9E8D0EF3AA),
          UINT64_C(0xADD7DD147E714DF6), UINT64_C(0x9A30245A2308EE02)}},
        {{UINT64_C(0x44838B15904F0D11), UINT64_C(0x6177587A2A2A70FF),
          UINT64_C(0x402938502C2F7943), UINT64_C(0x8F85119167581701)},
         {UINT64_C(0x564383D1842E6434), UINT64_C(0x251AF59DAF2C0078),
          UINT64_C(0x8A81772D3354A264), UINT64_C(0x9AAFA350DFD2D0EA)}},
        {{UINT64_C(0x4739793235461CAD), UINT64_C(0x0F86BD4362C5BFFA),
          UINT64_C(0x5F166BC07785490D), UINT64_C(0x7DCCC9882BD61B3E)},
         {UINT64_C(0x44C3299A9394375B), UINT64_C(0x0C5F2803405A34BD),
          UINT64_C(0x3AD60F1D4237E728), UINT64_C(0x6E7E06D072EC2562)}},
        {{UINT64_C(0x44AD84713C5840A6), UINT64_C(0x40C3CE2B4752BC62),
          UINT64_C(0x94B14C21EC3FD75F), UINT64_C(0x65E0E6AF2629C0C0)},
         {UINT64_C(0xA3FE2F5555936454), UINT64_C(0x252AD743780E25E5),
          UINT64_C(0x22F9951BFF4E107A), UINT64_C(0x1B8A7DDE554CEA49)}},
        {{UINT64_C(0xBBDCC2C089F1C6FA), UINT64_C(0x548FEF29C360A51D),
          UINT64_C(0x094DAD451290EC92), UINT64_C(0x792F6FB9AF55BF30)},
         {UINT64_C(0x37EF4ABE707FBF4E), UINT64_C(0x0F43AB0DFC4B6BD0),
          UINT64_C(0x850015B72D6EE5D9), UINT64_C(0x09273F3535C1FD65)}},
        {{UINT64_C(0xCECF1B90A6C3209B), UINT64_C(0xFB4BC864ABD433C0),
          UINT64_C(0x38246AAA3EEEF8BA), UINT64_C(0x4BC7904E9ED13F88)},
         {UINT64_C(0xA61C369A8E783066), UINT64_C(0x496FB8314D1C832C),
          UINT64_C(0x1907687A03AD64D5), UINT64_C(0x49516EA583425766)}},
        {{UINT64_C(0x8108B704B1714E53), UINT64_C(0xB458CB4B82E39BE7),
          UINT64_C(0xFCBD51CC097049DE), UINT64_C(0x415F4079722E8CBA)},
         {UINT64_C(0xCDB06F5E342DF9C6), UINT64_C(0x64885CD11281AC74),
          UINT64_C(0x932A05E45366673D), UINT64_C(0x7333520BE83AD23D)}},
        {{UINT64_C(0xDAA0A1EFC54B523C), UINT64_C(0xA3E80053B3C261C8),
          UINT64_C(0x352CC612558FCFA5), UINT64_C(0x1B9B755D85852B14)},
         {UINT64_C(0x19EE2CB6A1B541FF), UINT64_C(0x2B531CE2D5786B4F),
          UINT64_C(0xEF5EA6DF08C3E15B), UINT64_C(0x82161B0487111129)}},
        {{UINT64_C(0x5AB533A5FCEABAED), UINT64_C(0x4C2147A54A4D8E44),
          UINT64_C(0xD8EEE795DA02D43D), UINT64_C(0x8CB648DFA15C1CD0)},
         {UINT64_C(0x4869FB6CA788DDDE), UINT64_C(0xF9554D1477C03759),
          UINT64_C(0x4D25B41A96187DB9), UINT64_C(0x662FBAB33FE0B3F3)}},
        {{UINT64_C(0xD3AF4D09A58A5B2E), UINT64_C(0x3C5DD2985CE88DBE),
          UINT64_C(0x89DDA42E7426C2A4), UINT64_C(0x2D832B0749095424)},
         {UINT64_C(0x24EFCC0362AA84CF), UINT64_C(0x348C19DEE86923D7),
          UINT64_C(0x453E928635DB5CB1), UINT64_C(0x03F48EEB8DB21CF3)}},
        {{UINT64_C(0xBCF9600FF4035856), UINT64_C(0xE77CEC83AF820E18),
          UINT64_C(0xC87D43C17F2FBCC1), UINT64_C(0x574C4CAE6290B18D)},
         {UINT64_C(0x8BD8AE45E56E1EFE), UINT64_C(0xB1EFD68475D6FCC9),
          UINT64_C(0x9829F227A361E753), UINT64_C(0x9A50B4255211B784)}},
    },
    {
        {{UINT64_C(0x26F1959036396F78), UINT64_C(0x350D1A769AD1982C),
          UINT64_C(0x33BDB4AB947F352E), UINT64_C(0x6CA38B05FFE1E1E1)},
         {UINT64_C(0x055364C26F2A8CA0), UINT64_C(0xAF15075D2969CA7E),
          UINT64_C(0x2916D58FC3B9CB70), UINT64_C(0x18D94A8BD7325693)}},
        {{UINT64_C(0x87C41809F36EB789), UINT64_C(0x8C3517F9A7436F54),
          UINT64_C(0xE7C02E1D3D785160), UINT64_C(0x5BAFE72E418C7ABF)},
         {UINT64_C(0xA00A8E76CD9B27C2), UINT64_C(0x667918087DA06823),
          UINT64_C(0x342A03D920EC00B4), UINT64_C(0x44502A7E6122589A)}},
        {{UINT64_C(0x3A492F735BDAE972), UINT64_C(0x5184D076126A07DE),
          UINT64_C(0xAE49313CB56A38F0), UINT64_C(0x66CCC24E9EC47E0A)},
         {UINT64_C(0xAE84941BC03CF3E1), UINT64_C(0x771AFC575A73440B),
          UINT64_C(0xABF93DC8C433E43C), UINT64_C(0x974EE822243C6828)}},
        {{UINT64_C(0x468D7FDBA7A5F66C), UINT64_C(0xBBB2C482B18DEFCC),
          UINT64_C(0x188B8CACFA2E7DEA), UINT64_C(0x7894BC93BE0200B9)},
         {UINT64_C(0xA31813386B84750E), UINT64_C(0x8B14BDB237356096),
          UINT64_C(0xA9200FE7D62F4813), UINT64_C(0x8DF664A36F7627CE)}},
        {{UINT64_C(0x39BF14DDDD996CF1), UINT64_C(0xD00B3BF5F7F42D26),
          UINT64_C(0xF1AF5A20017718A3), UINT64_C(0x34A1E94BABCAE05D)},
         {UINT64_C(0xAD75D1B5C635D333), UINT64_C(0x97E5BD3987210A5A),
          UINT64_C(0x11684CA6A0327BF4), UINT64_C(0x25C511179B8F0A46)}},
        {{UINT64_C(0x7E5CD79FA935A9B9), UINT64_C(0x15DC70C2A22DCD16),
          UINT64_C(0x5CDA47E678A420F4), UINT64_C(0x37E0364EEA631104)},
         {UINT64_C(0xE7C469565E47B630), UINT64_C(0x7BD4C4A7E42C4DCB),
          UINT64_C(0xA76B87A71C91117E), UINT64_C(0x2AA043DDADA4B5E1)}},
        {{UINT64_C(0x6BB06B5A875DED57), UINT64_C(0x89452B3BFEAD7B14),
          UINT64_C(0x0CBD5CA8A6E39E1F), UINT64_C(0x2DC5917C3BFA7A3D)},
         {UINT64_C(0x6395D5B8F840B6E8), UINT64_C(0xAEC9342FED8589EE),
          UINT64_C(0x8332A1B877979E67), UINT64_C(0x29B55822C59F97DB)}},
        {{UINT64_C(0xFD145FF77D65A8F4), UINT64_C(0x8FFF7EE0119C9AFC),
          UINT64_C(0x0100D0E9AFCD6214), UINT64_C(0x98DE55E5A3B988B3)},
         {UINT64_C(0x0BACCB2E00151BF2), UINT64_C(0x2B422D0966091583),
          UINT64_C(0xC4D15E1693C66A3B), UINT64_C(0x1C107559727DE9E6)}},
        {{UINT64_C(0xC019C7D73CB76EDF), UINT64_C(0x6456DD91151F5E14),
          UINT64_C(0x29E95B6657CC7078), UINT64_C(0x9193F4D9E9BDBCEC)},
         {UINT64_C(0x375837B04806F8CB), UINT64_C(0x52D5528AAA954620),
          UINT64_C(0xE71F9F601B9D6D34), UINT64_C(0x910E4FA1DF95759C)}},
        {{UINT64_C(0x8D31B2EEFCADB5EA), UINT64_C(0x0814FF77A63C7498),
          UINT64_C(0x236569C05E3D927E), UINT64_C(0x7F669DAD95BBB9D9)},
         {UINT64_C(0x29158C9A305B0347), UINT64_C(0x99B9B7E752D468EB),
          UINT64_C(0x6C4CABC3B4342443), UINT64_C(0x125AFBEA0A803ED4)}},
        {{UINT64_C(0x850A150B101FAA4E), UINT64_C(0xB586BCDA11ECDABC),
          UINT64_C(0x9692EF834DAD2264), UINT64_C(0x0951716ED2B67F5E)},
         {UINT64_C(0xA2295F20924DD16D), UINT64_C(0xD8327275D0CE88CD),
          UINT64_C(0x45F8DD0CC683ADA3), UINT64_C(0x4A798B3388C26024)}},
        {{UINT64_C(0x225395CFCAF71198), UINT64_C(0xEE223712CA3F67CF),
          UINT64_C(0x972B019981280061), UINT64_C(0x0CB20E7A280ECC12)},
         {UINT64_C(0x06F04DA870F54717), UINT64_C(0x5288425E410B9712),
          UINT64_C(0x6C29A51474CEFB4A), UINT64_C(0x4218ECCA849E2FD6)}},
        {{UINT64_C(0xD85663A3B33574B6), UINT64_C(0x7469CFB1FAF7D3A2),
          UINT64_C(0x9C587EC43CFA8876), UINT64_C(0x5DAE46AEDB24ED63)},
         {UINT64_C(0x66C8DA33C413E494), UINT64_C(0xB8B256B665942568),
          UINT64_C(0x0F09178EA7A4CAAD), UINT64_C(0x577D4ADCAFEBC90B)}},
        {{UINT64_C(0x49009BA692D6C3B4), UINT64_C(0xE9CF4915B884FAAC),
          UINT64_C(0xC12377D36F3DBE23), UINT64_C(0x2F6E0E86EA6B680C)},
         {UINT64_C(0x5DF2CD5AE6C5E24D), UINT64_C(0xAAE7E145EE608DD3),
          UINT64_C(0x5357CFF28A7ED956), UINT64_C(0x8377126C3912DBA4)}},
        {{UINT64_C(0x6E83A6C6F83BC3F6), UINT64_C(0x3633E1E4C0CC09C6),
          UINT64_C(0x0C2A268BBC4B73A5), UINT64_C(0x688369D3125688EB)},
         {UINT64_C(0x64EE03E173E75809), UINT64_C(0x21773EE98E110C46),
          UINT64_C(0xF0BC6BE9A6A648B1), UINT64_C(0x399121837E0041E7)}},
        {{UINT64_C(0xCC09774A26F5716E), UINT64_C(0x01CB17F9FDFB59E9),
          UINT64_C(0xA88D1269AE8938B4), UINT64_C(0x99A40D17D13047C9)},
         {UINT64_C(0xE469C9846FC672A3), UINT64_C(0xDA6534B65638B928),
          UINT64_C(0xC56EAB20CDE40C83), UINT64_C(0x2C1582B1BD93AF10)}},
    },
    {
        {{UINT64_C(0xE4C19851A3F45C37), UINT64_C(0xCA0FEFF2C7D78FE9),
          UINT64_C(0x027B41D89A7E444B), UINT64_C(0x1F1B242F15D38CBB)},
         {UINT64_C(0x1C6C132CF1F50AB9), UINT64_C(0x2A02A3A45DFE7530),
          UINT64_C(0x2B1EB8E26E29159F), UINT64_C(0x5F3F4AB72EEDE876)}},
        {{UINT64_C(0x362CE0130F2DF95C), UINT64_C(0x82E4E19226480BFA),
          UINT64_C(0x9AAC9A966BEFF080), UINT64_C(0x5A1636F68EE2B59C)},
         {UINT64_C(0x600E0339FA049CCB), UINT64_C(0x56680F80F2F57163),
          UINT64_C(0x2C395CC17B4240A7), UINT64_C(0x32EDFE4A9C86BB64)}},
        {{UINT64_C(0x8D9842AB711AEF69), UINT64_C(0x7A1C2429890831F0),
          UINT64_C(0x924478DF54CDA99A), UINT64_C(0x791A1D45E25A02E2)},
         {UINT64_C(0x1433F569170F4C21), UINT64_C(0x9F42C8C1CA5F8BD8),
          UINT64_C(0x377740F7067B3201), UINT64_C(0x75145FFF2ECE5D81)}},
        {{UINT64_C(0xCBFE782A39638F43), UINT64_C(0xB0C0EC09E07553D2),
          UINT64_C(0x8D1C41F7115C673A), UINT64_C(0x8510551AEB39E385)},
         {UINT64_C(0x92000181BA275803), UINT64_C(0x8AF63F4A27B9A42A),
          UINT64_C(0xD50ECF0F52297029), UINT64_C(0x1DCA33A566883C56)}},
        {{UINT64_C(0xB2C44933C51DF9D9), UINT64_C(0xCA6F9FB0E66D80AE),
          UINT64_C(0x78CD2EEB82839BA4), UINT64_C(0x8FF8BCC8F7AFBCF3)},
         {UINT64_C(0x5AD00C704164959B), UINT64_C(0xAD901C71E83ED8D5),
          UINT64_C(0x56FFC0A92B52650D), UINT64_C(0x0689B171780126A8)}},
        {{UINT64_C(0x2E902A395EAC1DD8), UINT64_C(0x7681EABA7CAC283F),
          UINT64_C(0x03608CD878525B7C), UINT64_C(0x09665B805EB95540)},
         {UINT64_C(0xF09F9805306EE831), UINT64_C(0xFB00B1C6E41D453A),
          UINT64_C(0xD8BB95597C93E727), UINT64_C(0x3B74FEE72CE63FD8)}},
        {{UINT64_C(0x73F48B330A22DABA), UINT64_C(0x797DE0FBC8FC3E20),
          UINT64_C(0x69C1BEE29E79222D), UINT64_C(0x3052F67A1DF4C549)},
         {UINT64_C(0xFE9128A9ED78B6FB), UINT64_C(0xD9460CFF29CCF94F),
          UINT64_C(0x53737484C1FD1DAA), UINT64_C(0x83ADCD011EDAEEB2)}},
        {{UINT64_C(0x189EC9AA2BA4195A), UINT64_C(0x61345757C522BE92),
          UINT64_C(0x35BAB72A39EFB05D), UINT64_C(0x82B27322AE0AC461)},
         {UINT64_C(0xFEBF0F8CC07F4382), UINT64_C(0x1CA2B3D7DAD2ED8E),
          UINT64_C(0x4800A0370A27F89C), UINT64_C(0x77D1B2FC9815D971)}},
        {{UINT64_C(0xF9F46089CA0FC66A), UINT64_C(0x5BC406DE8C23E4E1),
          UINT64_C(0x1D7F3BA98DBF6DD5), UINT64_C(0x685B9111679D5587)},
         {UINT64_C(0x93554084B85BE0D0), UINT64_C(0xB081E9CA7B9EB16C),
          UINT64_C(0x58C428DC60F0D0B0), UINT64_C(0x12442C1A30B3C6D9)}},
        {{UINT64_C(0x147B843C567226BE), UINT64_C(0x2B2BFFAB429A8FFA),
          UINT64_C(0x7A4678EBCD435C2F), UINT64_C(0x200E85133C0B887A)},
         {UINT64_C(0x9D457AAD90605CDD), UINT64_C(0x6736A242157F29A5),
          UINT64_C(0x779B0D25549FCA4D), UINT64_C(0x57477EE917FDB4D9)}},
        {{UINT64_C(0xD9B15FD1ECF06CDD), UINT64_C(0xECF75FC0C1CC2CFC),
          UINT64_C(0x273867C3A56B39E5), UINT64_C(0x72F3ED4579340B7D)},
         {UINT64_C(0xF31C9E4C55B6C9B9), UINT64_C(0xED96826E0448FE57),
          UINT64_C(0xE2DF54AD8BB7A02F), UINT64_C(0x945E7B6BD79D71CC)}},
        {{UINT64_C(0x32B6CE429270E878), UINT64_C(0x980C8F6ED6EEBEB9),
          UINT64_C(0xC5717C8555808237), UINT64_C(0x4469D0A0CCA3F298)},
         {UINT64_C(0x2B9DD7E91A18C0E8), UINT64_C(0xE9D124016A0EC412),
          UINT64_C(0xF889DE9831F44B32), UINT64_C(0x692EE1E678854A7F)}},
        {{UINT64_C(0xF2360597ADEECA22), UINT64_C(0x94623EBC99A4C198),
          UINT64_C(0x5A0D49C4E4169D20), UINT64_C(0x7BE2C5BBBF0384F0)},
         {UINT64_C(0x42DB0D408C537851), UINT64_C(0x198A09A465C50782),
          UINT64_C(0x72F80BB745AD7EE0), UINT64_C(0x4F83164B11FCED06)}},
        {{UINT64_C(0x54E5B07C95712AF0), UINT64_C(0x95E7F5D91E893387),
          UINT64_C(0x383BC5AEC61D7766), UINT64_C(0x09F626ED681C28DD)},
         {UINT64_C(0x0D32B726DF97E3C9), UINT64_C(0x2AC622387C7C4786),
          UINT64_C(0xECEA0C6AD3F5AD40), UINT64_C(0x0D26633EA870A132)}},
        {{UINT64_C(0x40A05A14C3D42D26), UINT64_C(0x06577CA1F3BDE0E3),
          UINT64_C(0x03DAA258418B73FB), UINT64_C(0x205E02E60EFDEB86)},
         {UINT64_C(0xF5479E4D99F90D56), UINT64_C(0x4E699BF3368CB6E3),
          UINT64_C(0x534F674362E4A879), UINT64_C(0x18473603A9D78191)}},
        {{UINT64_C(0xA23D79CF5C1ED4F9), UINT64_C(0xFADE1CF5F2248B01),
          UINT64_C(0xA3D528276F4D2164), UINT64_C(0x1F211C0310B731E5)},
         {UINT64_C(0x0B415884D97229E2), UINT64_C(0xCABB7D8980FCC283),
          UINT64_C(0xDB9BC75298EF388A), UINT64_C(0x50AF2A4A93E80262)}},
    },
    {
        {{UINT64_C(0xD11E80F1D57DD821), UINT64_C(0x11CAE463DDA2AB29),
          UINT64_C(0x21CAFD16E628F315), UINT64_C(0x296A84E97DF70CD4)},
         {UINT64_C(0x9ECF75136E9EF995), UINT64_C(0xAE87525706E28855),
          UINT64_C(0x78E1B7E95DED383C), UINT64_C(0x6C5D8ECC5E940F7F)}},
        {{UINT64_C(0xCBD3ACB9998EE9A3), UINT64_C(0x990CDFF6D0DCF584),
          UINT64_C(0x0FB4346CC7CE5DDA), UINT64_C(0x5EDEEF9B355E268F)},
         {UINT64_C(0xACD8B4A2C215036D), UINT64_C(0x70D3699591C7486B),
          UINT64_C(0x72D5243D52C6694B), UINT64_C(0x54163B48E5F8B99C)}},
        {{UINT64_C(0xD2AEA2FF1D76A94A), UINT64_C(0xC5B4FBF1379F780B),
          UINT64_C(0x700042F7B33AC708), UINT64_C(0x7DA790BF8183E0CA)},
         {UINT64_C(0x95681FE6EBA72FA8), UINT64_C(0x1F0A390EE22E254E),
          UINT64_C(0x465A58F8BF07A8A5), UINT64_C(0x840EA2E7FB1FCE40)}},
        {{UINT64_C(0xD955C5B544048484), UINT64_C(0x7107D5956935C5E4),
          UINT64_C(0xFC6574448A0FCE44), UINT64_C(0x97DF2B4D2800E517)},
         {UINT64_C(0x0B1BB3282C482414), UINT64_C(0x152614CC4E48CDBE),
          UINT64_C(0x48051FB642EDE4E0), UINT64_C(0x91125B933DBFFE52)}},
        {{UINT64_C(0xA2F526C7CF898F54), UINT64_C(0x8788CA1283080857),
          UINT64_C(0x2F4427234562F7B0), UINT64_C(0x837772ABC044560C)},
         {UINT64_C(0x51AD2F7131BCB2EA), UINT64_C(0x0F1D33FCAFC5C03D),
          UINT64_C(0xDBFE541F7BD352A4), UINT64_C(0x8B44139964B8343D)}},
        {{UINT64_C(0xFEB96B8C44DCD145), UINT64_C(0xEEB3007CEFF22D0D),
          UINT64_C(0xAF64DFC1252A8C8F), UINT64_C(0x5D9B0A05D131E0C5)},
         {UINT64_C(0x28C943EFABFED144), UINT64_C(0xDFBF730CB6A2273D),
          UINT64_C(0x6CC5BE44E2A1BFBD), UINT64_C(0x55FAC03309030FCD)}},
        {{UINT64_C(0xFAA58543728F39EC), UINT64_C(0x9B2F10BA40B37B15),
          UINT64_C(0x96505C7F7254A419), UINT64_C(0x04F4ACE5879C7FF9)},
         {UINT64_C(0xC0B4B576BC5FDA53), UINT64_C(0x12549929F7ABCD3C),
          UINT64_C(0x00F5631E313FEC34), UINT64_C(0x89EA4459798C7CFB)}},
        {{UINT64_C(0x671137B50E2020C1), UINT64_C(0x77727861A4DC66C3),
          UINT64_C(0x8CE05ED181492A26), UINT64_C(0x42BEA541A0C3F612)},
         {UINT64_C(0x6D39E3D1B0E461EB), UINT64_C(0x459A8E1309FA806F),
          UINT64_C(0xE2A185C1466CB93B), UINT64_C(0x17D131CEE21ECB34)}},
        {{UINT64_C(0x2141E262387A15BF), UINT64_C(0x675B5E7C6BE61C42),
          UINT64_C(0xEEC1BDD4F1CF93EF), UINT64_C(0x6ACF383823BAB1F9)},
         {UINT64_C(0xA2F84E23B0B39C86), UINT64_C(0xE955DBBCE244E0E3),
          UINT64_C(0xE0155980B7A8102A), UINT64_C(0x1E117DC8B23012FA)}},
        {{UINT64_C(0xC92A36AA6EB36280), UINT64_C(0x5AED3A1D5E906D78),
          UINT64_C(0x8D336221AE4E430A), UINT64_C(0x3F184F1DD3AA50AD)},
         {UINT64_C(0xD14810EC916D9741), UINT64_C(0x2900169F3322D9B3),
          UINT64_C(0xAFF1A06004728254), UINT64_C(0x89C4C67326F60B5F)}},
        {{UINT64_C(0x5216E0AEB7F0D157), UINT64_C(0x3B8D2226C9F38AAD),
          UINT64_C(0x283E3E3FBB34AA79), UINT64_C(0x94DA80FA565CAB83)},
         {UINT64_C(0xDDB51943E6ED4A46), UINT64_C(0xF3AFFA9A7CDD5FE6),
          UINT64_C(0x0AB493CCB648A84F), UINT64_C(0x128356B6F15EE45F)}},
        {{UINT64_C(0xD2AD34F4BD0F02C4), UINT64_C(0x3DC9B6D1719BCF1E),
          UINT64_C(0x11EDB8F112EB5AE8), UINT64_C(0x33AC71D871180F90)},
         {UINT64_C(0x0AE988FEB59621D7), UINT64_C(0x32042B528F348211),
          UINT64_C(0x7E6787C4EB0CEBD3), UINT64_C(0x8C4D254926B8A526)}},
        {{UINT64_C(0xA3B461544D40ED72), UINT64_C(0x3A096546F6CF3972),
          UINT64_C(0x9C7BC931B3E46D8C), UINT64_C(0x85B77BAD90486C75)},
         {UINT64_C(0x95B706E56EBD35E0), UINT64_C(0xC1E18243101E098E),
          UINT64_C(0xF17C23FFF01C17E1), UINT64_C(0x3223527285EC224E)}},
        {{UINT64_C(0xE816235DFD24FA16), UINT64_C(0x5306CBC30B3AEBD7),
          UINT64_C(0xDEF60A9A8BE25CB7), UINT64_C(0x4B889A0F512999C2)},
         {UINT64_C(0xAB86A7F867B29FD9), UINT64_C(0xB81C532DB5461BCB),
          UINT64_C(0x810E9A0CD34D9819), UINT64_C(0x1E3530093092515D)}},
        {{UINT64_C(0x4682633921FB0BD9), UINT64_C(0x9CCE9A43003BAE50),
          UINT64_C(0xCD2216C32EB45B4A), UINT64_C(0x13598548C7E0F2C3)},
         {UINT64_C(0x8B0BFD7254611984), UINT64_C(0x705CB52589C0B05A),
          UINT64_C(0xD9073D87CE880DD8), UINT64_C(0x1EA534CD003DCAEB)}},
        {{UINT64_C(0xC7AAC256C58B4413), UINT64_C(0x301109D6E8054F96),
          UINT64_C(0x0A1F44D29C7E7860), UINT64_C(0x55D122BB96F15424)},
         {UINT64_C(0x9A63098F1C14A8A9), UINT64_C(0x8E01A9DC4221CDFB),
          UINT64_C(0x11C91FCF357B360A), UINT64_C(0x70C47AEA036A3CF4)}},
    },
    {
        {{UINT64_C(0xC0457C4F036A843D), UINT64_C(0x6E3E0801F1F593CB),
          UINT64_C(0x1AADF2D88C53873B), UINT64_C(0x5CEC5C7B0D140C8D)},
         {UINT64_C(0x4341A9AB328002E4), UINT64_C(0x11F22331C410D034),
          UINT64_C(0x0FCF69EF5DB6A39D), UINT64_C(0x3DD32A53B84FDA1F)}},
        {{UINT64_C(0x19E52339AF8C811A), UINT64_C(0xC8B8380092D46C4F),
          UINT64_C(0x891C4185CA8463A3), UINT64_C(0x5B51651F98F3FF1B)},
         {UINT64_C(0x3D1496070FB39DCA), UINT64_C(0x39ECCDE2B1051394),
          UINT64_C(0x3633DE271A14522B), UINT64_C(0x5FE551147C59A9A5)}},
        {{UINT64_C(0x68C8E0C62F0B507F), UINT64_C(0xDABC8EEF05B62C5E),
          UINT64_C(0x297C943AE6165C1E), UINT64_C(0x337C6B947D7CA6D6)},
         {UINT64_C(0x66F98FE4D6066191), UINT64_C(0x745BFEBA58945DA9),
          UINT64_C(0x600447873B29A546), UINT64_C(0x2815651EE2D4EDF2)}},
        {{UINT64_C(0x54A3BE7463661218), UINT64_C(0x89C5636415E79415),
          UINT64_C(0xE03C6963405E4932), UINT64_C(0x86E101EA9A619956)},
         {UINT64_C(0x47BAF2F3400DC92B), UINT64_C(0x5C44512C291E4059),
          UINT64_C(0xD7F84B8EEC6D7BF9), UINT64_C(0x6CF4254025AB8D79)}},
        {{UINT64_C(0xD6E1B75DB885DAFC), UINT64_C(0x7A33CE4B6128014E),
          UINT64_C(0x80DF9948EA9FF260), UINT64_C(0x99E0A11CD2B5872B)},
         {UINT64_C(0x960BDC3DE2435510), UINT64_C(0x4B0ECC5314F7A99C),
          UINT64_C(0xE815DB8B5AC6170B), UINT64_C(0x3095615617D5F2DD)}},
        {{UINT64_C(0xA035E3CE57166FCE), UINT64_C(0x71AD409540A75B80),
          UINT64_C(0x639C4EA7DB7D0BFB), UINT64_C(0x7A90BE97B12DBE6B)},
         {UINT64_C(0x091AA30F75F86A60), UINT64_C(0x67C0F795509AEEFC),
          UINT64_C(0xF028C12A331629C5), UINT64_C(0x90D26B1C8A1F7478)}},
        {{UINT64_C(0x6F01554EB6AC2AD5), UINT64_C(0x9DD0576EBC9A48D6),
          UINT64_C(0xAB37201397AE2605), UINT64_C(0x1525D8B5BB83852B)},
         {UINT64_C(0xD50680C3E46E4C61), UINT64_C(0x29FBBA5CECB8F06F),
          UINT64_C(0x60A48AB4B16637A3), UINT64_C(0x8BB47967CD1490D3)}},
        {{UINT64_C(0xA35A01874B7C7EA6), UINT64_C(0xFE01521AB4D6409A),
          UINT64_C(0x57CECE628FDE1E30), UINT64_C(0x1A9A9B2DF4F51D55)},
         {UINT64_C(0x0D33556BE221AC58), UINT64_C(0x0A4A1A34152508AD),
          UINT64_C(0x1FD61DA10144AA33), UINT64_C(0x4804BE6AEDC7C5F8)}},
        {{UINT64_C(0x071EC8155B363A84), UINT64_C(0x359C2A9FFE11ED05),
          UINT64_C(0x0FDF80C9B8BBF9BD), UINT64_C(0x928E51A4103ACCBE)},
         {UINT64_C(0xD152B6E7D5E8A222), UINT64_C(0x6368E3A8CBE022C9),
          UINT64_C(0x2E5055DE3128B659), UINT64_C(0x51E23651D21F1062)}},
        {{UINT64_C(0x5CE999D734834BF7), UINT64_C(0xE386394C3DC831E9),
          UINT64_C(0x6DBD5ECA7FE48564), UINT64_C(0x804BC07F556841A5)},
         {UINT64_C(0x2A8B616C229A9175), UINT64_C(0xAEEB533AA1B3EF97),
          UINT64_C(0x9D858F9D6F145037), UINT64_C(0x247FFAB07F6A8EBB)}},
        {{UINT64_C(0xE616E779099EB4F3), UINT64_C(0x4F360D2EF1B1926C),
          UINT64_C(0x28EE1F9117055397), UINT64_C(0x9994D7FF844AFCF3)},
         {UINT64_C(0x8824A94912CBD801), UINT64_C(0xA3AFED4D6A4484DD),
          UINT64_C(0xCB16CD673B5E36A5), UINT64_C(0x5490C30DBC3BBEA9)}},
        {{UINT64_C(0xEA43CA5AD7601122), UINT64_C(0x9CF2A15BD248EB72),
          UINT64_C(0x4CE8AB75B71D18D0), UINT64_C(0x2576C5B1041A19A5)},
         {UINT64_C(0xDE20FD028CC1496E), UINT64_C(0xC9FE5B0C0BE51831),
          UINT64_C(0x9DC17E323A53ABBC), UINT64_C(0x94E24DD9F4C806FA)}},
        {{UINT64_C(0x2A9CF5F10DF1A4B3), UINT64_C(0xE019675415063C08),
          UINT64_C(0xCE9CF2C6CCF88F77), UINT64_C(0x51ACC7B5EFE91C6C)},
         {UINT64_C(0x0C2302EFA799FE2E), UINT64_C(0x5EE756A469C0D117),
          UINT64_C(0x7E907EC2F4EAB1A1), UINT64_C(0x19EEF95BD98022DD)}},
        {{UINT64_C(0xB170D483A8E7FFA5), UINT64_C(0x2052600A39180FAC),
          UINT64_C(0x8EAD52D4A68AF290), UINT64_C(0x01B88CFEFF9E3641)},
         {UINT64_C(0x3D9077F765BC2D0C), UINT64_C(0x2AF9CF673ABCDB1C),
          UINT64_C(0xEA104E747295DADA), UINT64_C(0x7DF23470EB1E5D6E)}},
        {{UINT64_C(0x0F54D98D8E53F40B), UINT64_C(0xBFC22E9BAF360481),
          UINT64_C(0x309973B6E132666B), UINT64_C(0x1F40D11F25E783E0)},
         {UINT64_C(0x8EEBC9D7F00AC3EB), UINT64_C(0xBD725D822F9ADCC7),
          UINT64_C(0x4776781066EFDDCC), UINT64_C(0x60B0B1004ECCAF67)}},
        {{UINT64_C(0x498E2074B98C7E96), UINT64_C(0xBEBF518308BF31A9),
          UINT64_C(0x00DD4AAD3894DBE7), UINT64_C(0x66C047A4429878F6)},
         {UINT64_C(0x16F2CB336D0F1AB1), UINT64_C(0x5FA2F18158669ACB),
          UINT64_C(0xFA4B2F49486F1BE7), UINT64_C(0x1ECAAF6B5698F41B)}},
    },
    {
        {{UINT64_C(0x2999C2124DCC455E), UINT64_C(0x83897E49BEF617B8),
          UINT64_C(0x6B49CE265A218E0F), UINT64_C(0x49A5C9EB88EF7EA7)},
         {UINT64_C(0xF0EDA5FFF63EC82C), UINT64_C(0x736D933DEAD471CD),
          UINT64_C(0x10E4431DDF8071C4), UINT64_C(0x8C59C10738E1523C)}},
        {{UINT64_C(0x569FB74E5A54A4AB), UINT64_C(0x72788868F3384C14),
          UINT64_C(0xBC840717107B417F), UINT64_C(0x6682C1077E13210C)},
         {UINT64_C(0xB3359FC277B20150), UINT64_C(0xEB923E66A9E03222),
          UINT64_C(0x490C39FCA10CF332), UINT64_C(0x69099C2D49BA035D)}},
        {{UINT64_C(0x6498672003CB2C6E), UINT64_C(0x994054A1328B22BA),
          UINT64_C(0x4155C6B96F0542DA), UINT64_C(0x216CF760A3B93FFB)},
         {UINT64_C(0x744861845C2AD753), UINT64_C(0xE517984EA0CD3660),
          UINT64_C(0x6530BC863D7DA8A1), UINT64_C(0x04328CF92E46CA79)}},
        {{UINT64_C(0x4100ADED4798CD35), UINT64_C(0xC832796D635BAECD),
          UINT64_C(0x7EF1EA955B80E18C), UINT64_C(0x6889A91B426B1AA9)},
         {UINT64_C(0xC40A0A870927C6F8), UINT64_C(0xD60CFD1C2B86ED45),
          UINT64_C(0x98731DFFD57350A1), UINT64_C(0x1C52EAE91DE4341F)}},
        {{UINT64_C(0xC287E33B23A40FAA), UINT64_C(0xB96D9F517A633BDC),
          UINT64_C(0xF6A5B779E6D0F326), UINT64_C(0x10203FE1F619DE4B)},
         {UINT64_C(0x011FB53EC4F18BF8), UINT64_C(0xAEBB82F6BCA32CA0),
          UINT64_C(0x06BF8ED5F881818D), UINT64_C(0x3A6A3E3518247E6A)}},
        {{UINT64_C(0x3BF2E96E00625DC1), UINT64_C(0xD81AD1565A288F80),
          UINT64_C(0x04C3269EB7CE9B13), UINT64_C(0x3E18EAFC2F9E2713)},
         {UINT64_C(0x20F0E05D9D0BC74A), UINT64_C(0xACDB4B75D8140790),
          UINT64_C(0x12918A7EF1B5B265), UINT64_C(0x22A70AF96896342E)}},
        {{UINT64_C(0x326A28A29C4B6B08), UINT64_C(0x21302F37A17D3D57),
          UINT64_C(0x181378E7CE36F438), UINT64_C(0x42B07EBAFED12DE1)},
         {UINT64_C(0x081DDD200468AD4C), UINT64_C(0x32822EC364DF34AE),
          UINT64_C(0xE9F8D7C204B2192D), UINT64_C(0x6ABC7220918666F8)}},
        {{UINT64_C(0x9333070104AF3956), UINT64_C(0xEEB7AA8E872BD30D),
          UINT64_C(0xFC96D106D0E67494), UINT64_C(0x516028CF3A918DFB)},
         {UINT64_C(0xFAF0B6F7FB27B6EC), UINT64_C(0x0FAD73AD515DA78D),
          UINT64_C(0x5F136068D8CF1934), UINT64_C(0x0A526E04B6052802)}},
        {{UINT64_C(0x20DF0DEBE4685212), UINT64_C(0x71D4BAC1A41B293F),
          UINT64_C(0xBCC32A2F2FA8BBAC), UINT64_C(0x32A8723AF30CC343)},
         {UINT64_C(0x71E6DAAFEF95ACFE), UINT64_C(0x27D158F69F445394),
          UINT64_C(0x2140F78DE186B246), UINT64_C(0x4CAF98C3CB1C83AD)}},
        {{UINT64_C(0x94E264FCB6F63AA9), UINT64_C(0xF4637B024D0FE485),
          UINT64_C(0xA4BC0A03069CCB4E), UINT64_C(0x99A81E379E25E817)},
         {UINT64_C(0xE3B804A78F4D37BB), UINT64_C(0x57F272A5E38E654C),
          UINT64_C(0x00D1852C05928F65), UINT64_C(0x3031B7134345DD06)}},
        {{UINT64_C(0x6E42AF1157536140), UINT64_C(0xDC5B7CDC005A403F),
          UINT64_C(0xE6EE185E26527417), UINT64_C(0x1003D0137C685BCF)},
         {UINT64_C(0xC2206BF6192979E6), UINT64_C(0xD1C370DB6FE38214),
          UINT64_C(0x78D105B792F3C044), UINT64_C(0x2F0DF6B8BFDF8DFA)}},
        {{UINT64_C(0xB02FCA3844D04C4A), UINT64_C(0x956A2F7CA44566C6),
          UINT64_C(0x60672DF39F1F09C6), UINT64_C(0x6459A9492160C362)},
         {UINT64_C(0xDAE5434108714451), UINT64_C(0x48B77A0DBFFD7CF6),
          UINT64_C(0x615ADBFE3EDBC8D4), UINT64_C(0x3338E55735B67D2F)}},
        {{UINT64_C(0x601D49D1DD24A0F0), UINT64_C(0x60A48DB748EF27B9),
          UINT64_C(0x97F2212C97A8BAC6), UINT64_C(0x376B0292155AB524)},
         {UINT64_C(0xA25881BA62E2A961), UINT64_C(0xEB74CC802B8C56F7),
          UINT64_C(0xBE5C5DD4DA57C41A), UINT64_C(0x53D0D0372D16AFA0)}},
        {{UINT64_C(0xE47C9EABCA291206), UINT64_C(0x25DADB6442D5C667),
          UINT64_C(0x8C154CB6D886993E), UINT64_C(0x11DEC39C806B932F)},
         {UINT64_C(0x51A4DCF313D4B4E5), UINT64_C(0xAA1DAD6D9D1D822A),
          UINT64_C(0x2BB2E14DCEEF2E29), UINT64_C(0x429C13C7B2343BE3)}},
        {{UINT64_C(0x4E8E953F297F709D), UINT64_C(0x23183A3D262D862A),
          UINT64_C(0xE164A10DEA12D93F), UINT64_C(0x386C2873FE703920)},
         {UINT64_C(0xD59E1582E5C51C7E), UINT64_C(0xA8C93B5B020F6A2E),
          UINT64_C(0x51518BD0160CD058), UINT64_C(0x3337801AB1D38AC7)}},
        {{UINT64_C(0x6E2515332F5D9E25), UINT64_C(0x88E76135B0D6B0DB),
          UINT64_C(0x5C1978329E6762D1), UINT64_C(0x1232677384E620AC)},
         {UINT64_C(0x3B88DF270E2694DD), UINT64_C(0x30FED9E330A23CAA),
          UINT64_C(0xE12DD93EA23DF142), UINT64_C(0x06778F512EA77C07)}},
    },
    {
        {{UINT64_C(0x5D5BE00E49E5F6B4), UINT64_C(0x2F47E7C7721EF9DC),
          UINT64_C(0x338F7B007EAFC098), UINT64_C(0x0F5F06E3AF8C2475)},
         {UINT64_C(0x2A4B845C63122B22), UINT64_C(0xED44006089A4CE9A),
          UINT64_C(0xC9EEB6409A86D9BC), UINT64_C(0x12C3E0F32F39B439)}},
        {{UINT64_C(0xB444B88B17766F6C), UINT64_C(0xF9B100E6A41FD692),
          UINT64_C(0x81EAFCD15C149B30), UINT64_C(0x37DD6F6E1D521A1E)},
         {UINT64_C(0x14DBE8C3389DCD6E), UINT64_C(0xCD24D6550DCBC7FC),
          UINT64_C(0x05F8D48EE00F9102), UINT64_C(0x403954E6509D18D4)}},
        {{UINT64_C(0xA04FDDDFE4FE16EC), UINT64_C(0xB9E7FA7390E15C0C),
          UINT64_C(0x7D6A7206C77FAB6B), UINT64_C(0x3FFDCCD13E221F12)},
         {UINT64_C(0x120C05B147B5BB7F), UINT64_C(0xFA3614C05B7E2B96),
          UINT64_C(0xF3A4F07F4A6AC6E0), UINT64_C(0x0324BF48C8AD4F23)}},
        {{UINT64_C(0x508A037055DF2F18), UINT64_C(0x1C6C91EAB872F209),
          UINT64_C(0xDC3F6C5A8E12F437), UINT64_C(0x65F5058FC91AFD75)},
         {UINT64_C(0x0C43613D5A859A1D), UINT64_C(0x83A2610E5BF96A6B),
          UINT64_C(0x1A98AA4C1496AEAD), UINT64_C(0x3AB1CE5EE6CAA901)}},
        {{UINT64_C(0x9420ABFEFFB3E411), UINT64_C(0xCE60976031404E74),
          UINT64_C(0x3D4C23C502C49837), UINT64_C(0x6B79FB14D0868A3C)},
         {UINT64_C(0xB4EEE8DB6B5861EA), UINT64_C(0x495E2B469D948195),
          UINT64_C(0x2BB0BD941CE15EC9), UINT64_C(0x6CE79F80DED25955)}},
        {{UINT64_C(0xA6B98C1D5820DF65), UINT64_C(0xE8284737909356B5),
          UINT64_C(0x38E8609A091340E1), UINT64_C(0x98EC077B10666012)},
         {UINT64_C(0xFB243B1EBF075DAE), UINT64_C(0x32312BACA270FE31),
          UINT64_C(0x214511200CAA5F8E), UINT64_C(0x8F60118F2A515015)}},
        {{UINT64_C(0x4F211C9ECBDEB88E), UINT64_C(0xF6D3CC3AB6D680FD),
          UINT64_C(0xE193829D8BF4B4A7), UINT64_C(0x3223EF4E2D620371)},
         {UINT64_C(0xC3E35420C0E5245A), UINT64_C(0xD3F4F894B4ADE2EA),
          UINT64_C(0x464FCB6CF2CE985E), UINT64_C(0x79CF596D7B987FA7)}},
        {{UINT64_C(0x0730748C0C0016FF), UINT64_C(0xD02115C5A2949069),
          UINT64_C(0xAA6F794D40E9C7F9), UINT64_C(0x9514FA7B79149C37)},
         {UINT64_C(0x6E2F27785A46BCE0), UINT64_C(0xF55D46C60837ACD5),
          UINT64_C(0xF965C4681E4223E6), UINT64_C(0x0BFF0A9185D90A07)}},
        {{UINT64_C(0x9ED903581923C8AF), UINT64_C(0xC425B633A470AE00),
          UINT64_C(0xF9F4B1621C50FDAD), UINT64_C(0x0999D072A8CA2BD5)},
         {UINT64_C(0xCB122FBDAF74D4C3), UINT64_C(0x372C13F02C283752),
          UINT64_C(0x9F42A90382138B19), UINT64_C(0x573A2CEE3EB8CB95)}},
        {{UINT64_C(0x6C3A6BE33AC2E191), UINT64_C(0x4149E0EB1B222DB2),
          UINT64_C(0x5BA91005A4AACC55), UINT64_C(0x176BD33D1BFADBD0)},
         {UINT64_C(0x4AEAF14EA8DA0FEA), UINT64_C(0xB12401F9A7FF8E1C),
          UINT64_C(0xF1EF39AE0F192414), UINT64_C(0x95D433D3416743C1)}},
        {{UINT64_C(0x29ECF54D9AA0C238), UINT64_C(0x3762F1D78FCA6419),
          UINT64_C(0x761D786A64D3AAA9), UINT64_C(0x7A8A677DDAEC7BF4)},
         {UINT64_C(0xC2829EAD324676F4), UINT64_C(0x4E504A474D0B291E),
          UINT64_C(0x360CE7FEF8C4F384), UINT64_C(0x33A577B578CDA37D)}},
        {{UINT64_C(0x1BBFC128333103FD), UINT64_C(0x3D36045CE45C9DBE),
          UINT64_C(0xA8D53F5A15C9013D), UINT64_C(0x99D62F8AA33FDCFD)},
         {UINT64_C(0x73E539610A81F581), UINT64_C(0xD01AD20ED00BC0D9),
          UINT64_C(0x59701F4D1F6D9B73), UINT64_C(0x0F4EBFBCE098E536)}},
        {{UINT64_C(0xBDB9368A91E3C062), UINT64_C(0xCD66A0B19B17AAE5),
          UINT64_C(0xB6636DD7B4537E05), UINT64_C(0x37D94B8E73B119CE)},
         {UINT64_C(0xA5F8E90FC7428FF9), UINT64_C(0xE7E5B2B7F8EA9F03),
          UINT64_C(0xB7F20FB85B3506DA), UINT64_C(0x0F4AB6D5E494FFDA)}},
        {{UINT64_C(0x3ACEE3BD85365933), UINT64_C(0x9D5223D3BF510114),
          UINT64_C(0xE0D7D9A7A08D01B0), UINT64_C(0x28FD329AB2F1F61F)},
         {UINT64_C(0x3E16A2E2A5909DD3), UINT64_C(0x284A8708B4FECB35),
          UINT64_C(0x190F7B3A73D5BFBA), UINT64_C(0x7E07982E92EE4BBE)}},
        {{UINT64_C(0xA30A4C2244945687), UINT64_C(0x657C0F2ED688A301),
          UINT64_C(0x9B558D4ABBB3E65A), UINT64_C(0x8044D57EA6E57844)},
         {UINT64_C(0xF202E50EE3957E21), UINT64_C(0x4957E651CE62FCC9),
          UINT64_C(0xF7B9EBA4C4ECE0B8), UINT64_C(0x29532CEC61167229)}},
        {{UINT64_C(0xE9DC8EA63EEF3D71), UINT64_C(0xEBF76BD43E8EC117),
          UINT64_C(0x48CEB78D2EA072B9), UINT64_C(0x82ECDFC473EFC32D)},
         {UINT64_C(0x51B02CB3E2C89E7D), UINT64_C(0xE9D0740CF4D9100F),
          UINT64_C(0xBB556EFE8A5E3F48), UINT64_C(0x864E52DA1D01B44E)}},
    },
    {
        {{UINT64_C(0x5A75E0BD14EA6DC5), UINT64_C(0x09F2AA76532EFED7),
          UINT64_C(0xE6DAE0A983CE5A18), UINT64_C(0x00F9BCB7CEB4E78D)},
         {UINT64_C(0x128FB51C71F79BF3), UINT64_C(0x78C7978880D5DBC3),
          UINT64_C(0x2752F02C9B816B9E), UINT64_C(0x88CFBA0CEB7622E2)}},
        {{UINT64_C(0x845AB940268432A3), UINT64_C(0xA8D0231B2F94F6D3),
          UINT64_C(0xBDFB3F91FEC02130), UINT64_C(0x07A61AE45F62419F)},
         {UINT64_C(0xD1C951DF192EBF1A), UINT64_C(0x22CDCFF5FA232E34),
          UINT64_C(0xDFDF121B3A7581DD), UINT64_C(0x9865ECA2710403A5)}},
        {{UINT64_C(0x609F4527F8180BAB), UINT64_C(0x93AB107250A6D914),
          UINT64_C(0x299D5013E2EEE3BD), UINT64_C(0x36EFCE5B42959C14)},
         {UINT64_C(0x49CDA60D1045FFCB), UINT64_C(0xA8B2492E45723371),
          UINT64_C(0xCB75789BF243FDBB), UINT64_C(0x8E1079D7871D500D)}},
        {{UINT64_C(0x69852694DB14298E), UINT64_C(0xBAA92A9541A56B6D),
          UINT64_C(0xC73718483DBFDBA4), UINT64_C(0x94B3155C947747F8)},
         {UINT64_C(0x97BCDD197552426B), UINT64_C(0x4FB3E76D32682121),
          UINT64_C(0x875AA0F78BC15FCA), UINT64_C(0x4065BCDFF1FD2315)}},
        {{UINT64_C(0x2D1C0519B7F1ED04), UINT64_C(0xED9A1BB7EA2535E1),
          UINT64_C(0xE4728CD6ABAE813E), UINT64_C(0x2CD7D44721A771D0)},
         {UINT64_C(0x88E2A78559B9E964), UINT64_C(0x2677FBD76F9B5374),
          UINT64_C(0x3967D6C52645B626), UINT64_C(0x8843F7DF5A1C315B)}},
        {{UINT64_C(0x673CD273C7055A4E), UINT64_C(0x052AC45CEE827873),
          UINT64_C(0xC26B9214CE1981F3), UINT64_C(0x3C39C13C2B8EEF59)},
         {UINT64_C(0xDD9E1B9B0B276D47), UINT64_C(0x6729A5347287F9A1),
          UINT64_C(0x43E1471C061DAD53), UINT64_C(0x6082FAD9118B56C8)}},
        {{UINT64_C(0x9C3872AAF99186D6), UINT64_C(0x1D9E8DB675AC99BF),
          UINT64_C(0x6FA7A0FFE338DBD3), UINT64_C(0x1EDF44ECD1FEF2F9)},
         {UINT64_C(0xBAF9D33A1F9114BF), UINT64_C(0x89AF08E53007B6A5),
          UINT64_C(0xAA04B1698436D917), UINT64_C(0x8381E76A6AFCF5E0)}},
        {{UINT64_C(0xC51848A4C1D799BA), UINT64_C(0x6C3D43A97F40B34B),
          UINT64_C(0xE8DAE074A5CB7B95), UINT64_C(0x5375B1EEBB5F8AEC)},
         {UINT64_C(0x461290EE507099E6), UINT64_C(0xB95934AA3BAD89AD),
          UINT64_C(0x9A6E5C22701A4D9C), UINT64_C(0x2CA791445E1389F6)}},
        {{UINT64_C(0xBF82F7860E5108FC), UINT64_C(0x3620CCC4644D06DE),
          UINT64_C(0xB65DE8538E5C4753), UINT64_C(0x6DAB72419FEDFD16)},
         {UINT64_C(0x4CECAC87546DCBA4), UINT64_C(0xA7BBE65D3E2D0684),
          UINT64_C(0x092AA490DA1E4FFA), UINT64_C(0x78F448BE41AD32AF)}},
        {{UINT64_C(0x321580FE4A33F071), UINT64_C(0xBEA845D15EE5E685),
          UINT64_C(0xC73CAECE47AC8ACF), UINT64_C(0x0E15E55DA9F65F05)},
         {UINT64_C(0x5FC47420A59506E7), UINT64_C(0x501417FF01DBD2DD),
          UINT64_C(0x8EF23280FB1205A6), UINT64_C(0x1AA26168E0F43AE8)}},
        {{UINT64_C(0xD41F73B18149EB2A), UINT64_C(0xC297AF04AD95D531),
          UINT64_C(0x2017176F749E415D), UINT64_C(0x5AF89C738357CE9A)},
         {UINT64_C(0x301F7C7908A0FF9C), UINT64_C(0x0C2999B598695C57),
          UINT64_C(0x856799576E4D8FF5), UINT64_C(0x2CC0FF3E6F493B1C)}},
        {{UINT64_C(0xFE90F9044AF481F5), UINT64_C(0x0562C78B31BC4919),
          UINT64_C(0xAA44AA5670E4F140), UINT64_C(0x1B61DEB4A175159A)},
         {UINT64_C(0x85315DE1A7A7E648), UINT64_C(0x4BC1F51D6C012B33),
          UINT64_C(0x40CB5DE3060CDEE6), UINT64_C(0x969F919632A1E138)}},
        {{UINT64_C(0x3B317508E05F23B5), UINT64_C(0x7B1A93AE512D1156),
          UINT64_C(0x3A283415CB58EC19), UINT64_C(0x193A53A18E27CAD9)},
         {UINT64_C(0xCF6BBEBA03DE1BA8), UINT64_C(0xFA5544CA47A02393),
          UINT64_C(0x8B3AAC1A8627F5EB), UINT64_C(0x02FAD2EC62EAF195)}},
        {{UINT64_C(0x4F8D8ADA259CCF0F), UINT64_C(0xE4E6786B562991D7),
          UINT64_C(0xA1C63473597C3FD3), UINT64_C(0x1F5B9017ACAB6F16)},
         {UINT64_C(0x95B201BD592D437A), UINT64_C(0x54432A75ED14F859),
          UINT64_C(0x67EF73FB0B551AC1), UINT64_C(0x0A48F0437F1AB9CA)}},
        {{UINT64_C(0xECEE508E4A35445C), UINT64_C(0x80BE9F07B3EA6F9B),
          UINT64_C(0xD914B25687E4B78E), UINT64_C(0x97F79CC9F89B8E4B)},
         {UINT64_C(0x6A5B4F2BC359FB12), UINT64_C(0x54E6E37A99CF6FFA),
          UINT64_C(0x1133C4B2F7C66CA8), UINT64_C(0x6F679B280345866B)}},
        {{UINT64_C(0x0006F7A144E77CDF), UINT64_C(0xD8077F9F42033333),
          UINT64_C(0x0414ECE521EAF35F), UINT64_C(0x1211576B5623803C)},
         {UINT64_C(0xEDADD215140309A7), UINT64_C(0xC349C6575EBAE3BB),
          UINT64_C(0xBD40427C821DE06B), UINT64_C(0x8949ACA33F5D2F97)}},
    },
    {
        {{UINT64_C(0xAC1F87E6022E3D44), UINT64_C(0xDFC17BEDB39F6B10),
          UINT64_C(0xEAAE416807119C4A), UINT64_C(0x8B3B40BCDBD47D36)},
         {UINT64_C(0x6683A561861B7B59), UINT64_C(0xF9BFFB1713A6C76D),
          UINT64_C(0xE4E72EA4A30A05AC), UINT64_C(0x77C219E8BA0D2AD6)}},
        {{UINT64_C(0x5019824E66BE6944), UINT64_C(0x811ACEBE7B131070),
          UINT64_C(0x9730DCF03BA34677), UINT64_C(0x5B9C5CF57BC9CFC8)},
         {UINT64_C(0x1CBD950FB283C8CC), UINT64_C(0xF66DBDDA3973A325),
          UINT64_C(0x4EC5EBC26FA60257), UINT64_C(0x0C01D57736FF26B3)}},
        {{UINT64_C(0xBB2219547CE2BE74), UINT64_C(0x23E44E0E841E6C0C),
          UINT64_C(0xE760D33D77C3824E), UINT64_C(0x5B656FBE7EB3CE34)},
         {UINT64_C(0xEC50E509C5F3D66E), UINT64_C(0x5326C2B8496EF8BA),
          UINT64_C(0x3F9485F63D4B20D4), UINT64_C(0x11B74A8551C21B0E)}},
        {{UINT64_C(0xC3EAEB0425E30336), UINT64_C(0xA9D6C70FA6E3637F),
          UINT64_C(0xF818C37E86F77F68), UINT64_C(0x786ED3C2C60DF35A)},
         {UINT64_C(0xACA70EA0D56D705A), UINT64_C(0xCE61608C7BF4EF10),
          UINT64_C(0x49AD1CD81722C179), UINT64_C(0x1B84FBE9687F3222)}},
        {{UINT64_C(0x8A0F4BF135EE0BA9), UINT64_C(0x42AD284603952A08),
          UINT64_C(0x1E0E1E3B3B60B4DD), UINT64_C(0x0DC1A947F5DCAD76)},
         {UINT64_C(0x054BECA41F496E03), UINT64_C(0x8F02FDAB3AE6E6F6),
          UINT64_C(0x8851CFF49B71C9F5), UINT64_C(0x6BD7271CA7441F87)}},
        {{UINT64_C(0xB019E3469EB6A2C3), UINT64_C(0x2B719034931E7550),
          UINT64_C(0x2B2CBEBD40698F1F), UINT64_C(0x375DB5914F1FC587)},
         {UINT64_C(0x09843166676A79A4), UINT64_C(0x91848967B416D657),
          UINT64_C(0xB49EA7219FED6B27), UINT64_C(0x1FAC5650D080C8AA)}},
        {{UINT64_C(0x205CD58858C4C2AA), UINT64_C(0xBEEE26F817F572EE),
          UINT64_C(0xE744AB674CB4DE3A), UINT64_C(0x37E34E18CBE989BD)},
         {UINT64_C(0x95D9118B767D31B5), UINT64_C(0x9A34DBEC83E7C03E),
          UINT64_C(0xCAFDBD1AB8F70DD3), UINT64_C(0x1E68A6813909BB51)}},
        {{UINT64_C(0xFE0A5DFF9FD96ABA), UINT64_C(0xBBFB1FDFD99B68DE),
          UINT64_C(0x5E232A4FE3F522BE), UINT64_C(0x768C2C54A6428D33)},
         {UINT64_C(0xE9CFEDF9DBF1A575), UINT64_C(0x841721F24B83F9AB),
          UINT64_C(0xFAD9650A80A85361), UINT64_C(0x3158921104979759)}},
        {{UINT64_C(0x1CF9F4B8EFBF2099), UINT64_C(0x63D5499BF571408B),
          UINT64_C(0x89C119FCEC3E74A6), UINT64_C(0x0525DDDF698E4DCD)},
         {UINT64_C(0x43FCDDE47333A38C), UINT64_C(0x2150EAD480A912DE),
          UINT64_C(0x4B3BD2230A19CC55), UINT64_C(0x3553EB4E238AC64C)}},
        {{UINT64_C(0x3A259F52FEC2371F), UINT64_C(0x8B03C50544863D3E),
          UINT64_C(0x1053E2D686BB6522), UINT64_C(0x400CE699F7086CBE)},
         {UINT64_C(0x695B1EA003ED78DE), UINT64_C(0x00AE6D0916500E1B),
          UINT64_C(0x9F29B08914B01815), UINT64_C(0x269692B4C218D892)}},
        {{UINT64_C(0x8660280DF0D44E79), UINT64_C(0x69D2968537C0F38F),
          UINT64_C(0x664B8146B9E24AD8), UINT64_C(0x277CB4DD1E695452)},
         {UINT64_C(0xB1A02D4EDFBF05EB), UINT64_C(0x3B3493084A1426C7),
          UINT64_C(0x13B7961222204FE7), UINT64_C(0x04F80867BCB5CD9F)}},
        {{UINT64_C(0x37BDBCAEE0852CBC), UINT64_C(0x2A6D7A23BE22764C),
          UINT64_C(0x4E0D43AC25AFD9FF), UINT64_C(0x1F6C9E14D16DD9EB)},
         {UINT64_C(0xE37E3AB3B4B0F47A), UINT64_C(0x09E046FB6C476C3A),
          UINT64_C(0xB8F649D9B75FA2DC), UINT64_C(0x7962A8C4FAB1AC41)}},
        {{UINT64_C(0x00E41470F6A1314A), UINT64_C(0x176380C3E4388464),
          UINT64_C(0xDB3405CD9B8A2B4D), UINT64_C(0x6299A1A67DE02ABC)},
         {UINT64_C(0x9F6B9DE77BBE7BFA), UINT64_C(0x59F16F549D3098DD),
          UINT64_C(0xFEC29C8D3B5767FE), UINT64_C(0x67711BC064955759)}},
        {{UINT64_C(0x34444EA3B1B07B5D), UINT64_C(0xB1D973B491FA2B4A),
          UINT64_C(0xEBEBEFB183403A0E), UINT64_C(0x56D520988E8A8EC6)},
         {UINT64_C(0x11C93529A7E82D55), UINT64_C(0x9230AE03D525C399),
          UINT64_C(0x74E1CBB28DB46C82), UINT64_C(0x4C3383CC40BE5E15)}},
        {{UINT64_C(0x33A52E73CDAD72F3), UINT64_C(0x1D2CCA33B9E77759),
          UINT64_C(0x26717716549406F5), UINT64_C(0x70DED57F5B3DB3E8)},
         {UINT64_C(0xBA38F81343C85A67), UINT64_C(0x956F2DD735422BB3),
          UINT64_C(0x52D9FA9907486F18), UINT64_C(0x655791BF75D1D2C4)}},
        {{UINT64_C(0xF434A9601FC9E0B3), UINT64_C(0x42A7B891BEDE92AD),
          UINT64_C(0x05A182D8A55A8009), UINT64_C(0x3404E08D38531612)},
         {UINT64_C(0x2B5B2766F07D76E3), UINT64_C(0x94B1A98D1D77B90C),
          UINT64_C(0xA86C0EC84B18BB9F), UINT64_C(0x6532770F526A81E3)}},
    },
    {
        {{UINT64_C(0x4429A4E861CFE04A), UINT64_C(0xEE8673862C9CA012),
          UINT64_C(0x237A3040C32D1969), UINT64_C(0x400AD5990AE2DFAE)},
         {UINT64_C(0x1603D10A213C0A18), UINT64_C(0x6EB8042D2B1E2A57),
          UINT64_C(0x4C9C1696C7CAF556), UINT64_C(0x79BE04A7E0C1A5A3)}},
        {{UINT64_C(0x161781E33FCB8B14), UINT64_C(0x1383E3B8B1384C3C),
          UINT64_C(0x5129EA19B566626C), UINT64_C(0x8A1F86E4551DE02A)},
         {UINT64_C(0x9C648CCEAEDBE04C), UINT64_C(0x0D4278ACFB200132),
          UINT64_C(0x466D452AC1E2D4A3), UINT64_C(0x832B0E6EB21B6E38)}},
        {{UINT64_C(0x20101D7CED1D76C7), UINT64_C(0xC3282661C110D85E),
          UINT64_C(0xB8026CE4FFCA2DD7), UINT64_C(0x73B4EBA58BA48211)},
         {UINT64_C(0xAB94FE21D8554E2C), UINT64_C(0x319E2FD781B2A181),
          UINT64_C(0x2C824DC537E8D3E2), UINT64_C(0x97CD457A09FCA0AB)}},
        {{UINT64_C(0x8E4B5FBDC50116CB), UINT64_C(0x3D20CECECA631A93),
          UINT64_C(0x5F80606C545575D8), UINT64_C(0x45ED55DEF91C7908)},
         {UINT64_C(0x91870A927CC1083C), UINT64_C(0xA3828E06D360FF5C),
          UINT64_C(0xFC9DFCDC84003D42), UINT64_C(0x0733C887FAC4667F)}},
        {{UINT64_C(0x6F1F771ACC2FC31B), UINT64_C(0xDA9351A1902E8176),
          UINT64_C(0xFB9395AFCE3FF045), UINT64_C(0x17C28CA213820DAB)},
         {UINT64_C(0xA1F596BCA684E6FA), UINT64_C(0x89228CC7DAD3995A),
          UINT64_C(0x5DBFD421C02E458B), UINT64_C(0x58C25045A2122AFE)}},
        {{UINT64_C(0x2906450F018EADB0), UINT64_C(0x88A7A2369030C84E),
          UINT64_C(0x492BA7A333308084), UINT64_C(0x321388B95605F371)},
         {UINT64_C(0x5F934C94626AE19A), UINT64_C(0xE2BD6C6701C7CCD9),
          UINT64_C(0xB07757B1EC0BBD52), UINT64_C(0x1E980338F9EDD2AC)}},
        {{UINT64_C(0x5A5370748831457C), UINT64_C(0x0E0E22FB47E7B9A9),
          UINT64_C(0x7BE70594A225A259), UINT64_C(0x433DB05530946816)},
         {UINT64_C(0x852EA9F9E2F2C3CB), UINT64_C(0xDC4E8E3A2D243848),
          UINT64_C(0x10F34AB81E887770), UINT64_C(0x29795D2CC89FC71B)}},
        {{UINT64_C(0xE046B04BCFEC2C6F), UINT64_C(0xA1D3B5A02CA8256E),
          UINT64_C(0x93F7FDFAE87F767F), UINT64_C(0x2DF5693E35FA3837)},
         {UINT64_C(0x71D9638C97884587), UINT64_C(0x175EA91F39E115EC),
          UINT64_C(0x14E16C31F41A27FC), UINT64_C(0x8B2682EAEB2F5913)}},
        {{UINT64_C(0x2BCC6853798C7F28), UINT64_C(0x2F985A59DD7D3615),
          UINT64_C(0xA66519E141D2257A), UINT64_C(0x18731D74021F719B)},
         {UINT64_C(0x7210472C360E9C20), UINT64_C(0x4FB48411329A9B35),
          UINT64_C(0xB33B6CB587D62CA5), UINT64_C(0x86226D9EFD0D7703)}},
        {{UINT64_C(0xDD133F8BF67CB77C), UINT64_C(0x381E4D62F6ABEE80),
          UINT64_C(0x3236F0057DF85AE5), UINT64_C(0x88EBB3864610BB0E)},
         {UINT64_C(0x895AA5398DB908D8), UINT64_C(0x848142E6104C4633),
          UINT64_C(0x467EE770B8012B2E), UINT64_C(0x193CBAED1B9210EE)}},
        {{UINT64_C(0x737CD32BC1F44FC1), UINT64_C(0xCDF82B1C522B6209),
          UINT64_C(0x08F4BB70E0017F2A), UINT64_C(0x1565BCEF64738F26)},
         {UINT64_C(0x0D2910B9684DCF67), UINT64_C(0x4ED1734BC6F3EB81),
          UINT64_C(0xCBEA79B6DA1D6BC8), UINT64_C(0x0470CE36EE6A41D6)}},
        {{UINT64_C(0xECFD5C66BA05AF3C), UINT64_C(0x421D5540EB9BFAA8),
          UINT64_C(0xFC0E5AF2526CFF85), UINT64_C(0x7E17F1E653DC49A6)},
         {UINT64_C(0x69BB1DFB1FAEB0A2), UINT64_C(0xDC95661AB3785ED4),
          UINT64_C(0x1F1D7395676D7CD0), UINT64_C(0x2C16BB9689C6412F)}},
        {{UINT64_C(0x2335F20EEE414CA6), UINT64_C(0x56E0DDB2FEF5E042),
          UINT64_C(0x942D4E35D9DE2966), UINT64_C(0x80E92B8CCF63D583)},
         {UINT64_C(0x158BE1B65D492C76), UINT64_C(0xFF096960C4F822D9),
          UINT64_C(0xC00FC7305AF79379), UINT64_C(0x07C49B0350D34E12)}},
        {{UINT64_C(0x64678B2EC34836C8), UINT64_C(0xCC280DCB615FF066),
          UINT64_C(0x86C3C7479131EC98), UINT64_C(0x35B008CC2D151FAD)},
         {UINT64_C(0x22C18852F8133FDC), UINT64_C(0x183BE4DC2FE8809D),
          UINT64_C(0x86589814CF98D56D), UINT64_C(0x52D8074D2F6E0DE4)}},
        {{UINT64_C(0x33FF9F41C9274AA6), UINT64_C(0xAC30ACB4CA854AF1),
          UINT64_C(0x87A7BE53FBC994B7), UINT64_C(0x6E7E8B2ADBCD717B)},
         {UINT64_C(0x3065A732CD494AB6), UINT64_C(0x6F977B8760FD7F57),
          UINT64_C(0x4C216EB4B74BAD54), UINT64_C(0x674F00F5F6061F7A)}},
        {{UINT64_C(0xA8C224813164AFBB), UINT64_C(0x4C9E2F1D72A7AC55),
          UINT64_C(0xE3DAC3E379DEFE94), UINT64_C(0x193A1E0BBB9D953F)},
         {UINT64_C(0x8852020C7E0957EE), UINT64_C(0xF7FD181EB62F8EF7),
          UINT64_C(0x0DE7EDDEE26B8860), UINT64_C(0x53A05575FD1B00DE)}},
    },
    {
        {{UINT64_C(0xE5D63E1B63E0C8FC), UINT64_C(0x6849B530C684016A),
          UINT64_C(0x4E89CB43009318AD), UINT64_C(0x1CDC5918EF571911)},
         {UINT64_C(0xA6596C03F389EAF3), UINT64_C(0x9282C1B3E88975F9),
          UINT64_C(0xD07A2AEF0D53D3F2), UINT64_C(0x3DA515D52B3B602C)}},
        {{UINT64_C(0xE42857818A5436EA), UINT64_C(0x047E305636D65626),
          UINT64_C(0x0016B568E16489A0), UINT64_C(0x4460319675A0209C)},
         {UINT64_C(0x2BE99A51BCC19754), UINT64_C(0xE02EAFD05ACFCDEF),
          UINT64_C(0xB0A1E300AECACABB), UINT64_C(0x0F39CBDEAC1860D9)}},
        {{UINT64_C(0x50DA53722099F08E), UINT64_C(0xAA6AAAD1CA4817B1),
          UINT64_C(0xA4DDC5FF57D73192), UINT64_C(0x046043AC7682D453)},
         {UINT64_C(0xC8EB178828CF3F48), UINT64_C(0x3967A02FDCA184D4),
          UINT64_C(0x0CE68B7986221941), UINT64_C(0x27BDCA48FD3A197A)}},
        {{UINT64_C(0xD774E33C563D7A91), UINT64_C(0x1C309DAE07AE1C92),
          UINT64_C(0xDABA89B457DBE6A8), UINT64_C(0x90C62517E5820FA4)},
         {UINT64_C(0x23C6460511371109), UINT64_C(0x1176AE7E15605666),
          UINT64_C(0xD71E9755DF040DCB), UINT64_C(0x5312A5B362ED515C)}},
        {{UINT64_C(0xB7AA3A117A5FB9E0), UINT64_C(0xA769BC7218E2CB32),
          UINT64_C(0x9D551B9B6B73E050), UINT64_C(0x0CE51DF0DB067CBC)},
         {UINT64_C(0x00BF90D54A0E06BE), UINT64_C(0xFEC6E7B37EE820E7),
          UINT64_C(0xDFBAC0833334937A), UINT64_C(0x46884935CE14CF46)}},
        {{UINT64_C(0xC3F31EAF902EF3A9), UINT64_C(0xF3B6E6FA5CCDF002),
          UINT64_C(0x5A9B532188CDDE0F), UINT64_C(0x00D99E43E8691FED)},
         {UINT64_C(0x8E786F52CFE02C8B), UINT64_C(0x587AA5374DD36F8E),
          UINT64_C(0xBCA91CAC425CC228), UINT64_C(0x80AA8AA9BFA9C36B)}},
        {{UINT64_C(0xAD4A2AD09B20505A), UINT64_C(0x6D70802916739066),
          UINT64_C(0x729001F389F73B52), UINT64_C(0x774803478073A428)},
         {UINT64_C(0x1AB38F07E84DB3B4), UINT64_C(0xE643D756A6655769),
          UINT64_C(0x5631359B46C19856), UINT64_C(0x82530A3201C3DCD1)}},
        {{UINT64_C(0x9250EC262DDDB968), UINT64_C(0x63D99CBF8D82A03E),
          UINT64_C(0x4FBFE78441349B60), UINT64_C(0x6977DD07A15BF2B7)},
         {UINT64_C(0x771917C668513C32), UINT64_C(0x026035188F0064F7),
          UINT64_C(0x45A5742951D78637), UINT64_C(0x56BF57CC87293790)}},
        {{UINT64_C(0xBAC94E24032E6426), UINT64_C(0x7D54AE34C2531B26),
          UINT64_C(0x4D6EF608CD688082), UINT64_C(0x736E7ACFF5AA4BEE)},
         {UINT64_C(0x41D5BF6C6AFB84E2), UINT64_C(0x40E12DA56E976E09),
          UINT64_C(0xCBF32FCB2235F7B9), UINT64_C(0x285DDF46A21BC0E0)}},
        {{UINT64_C(0x66C6A76ECE751632), UINT64_C(0xBD457D0E32A61A1D),
          UINT64_C(0xFA12A7C878191C57), UINT64_C(0x030ED98B06611B5E)},
         {UINT64_C(0x199F7756F4972FFD), UINT64_C(0x298D98E69C8AAB09),
          UINT64_C(0x2186054CC5B02158), UINT64_C(0x0736CE4CB9B1147A)}},
        {{UINT64_C(0x33E4A4CA19BFA57D), UINT64_C(0xF02F6D32AA70C35D),
          UINT64_C(0x9EA10B633CC082FD), UINT64_C(0x86104E8ED00E82A8)},
         {UINT64_C(0xACBA5E7387797E25), UINT64_C(0x24DD98A8EB85A796),
          UINT64_C(0x02748827C58AC480), UINT64_C(0x5B4480C76A932D80)}},
        {{UINT64_C(0xF9E210FB1992B174), UINT64_C(0x3CFA6EF1BE22636E),
          UINT64_C(0xA46F202B3BDFA2BD), UINT64_C(0x8C83B3DA441B96D2)},
         {UINT64_C(0x3BB2ED8B8AA39AB4), UINT64_C(0x4DB63B239CE53FB2),
          UINT64_C(0x24AC8A9846DC2104), UINT64_C(0x997BC4A768E20D1B)}},
        {{UINT64_C(0x4CDF8757D1C0D629), UINT64_C(0xBA155719A64B6058),
          UINT64_C(0x82FD0DA3BE3FB0B1), UINT64_C(0x12F5069403E34CB1)},
         {UINT64_C(0x8993EE3802E7DFEB), UINT64_C(0x2FC240C63D7A758E),
          UINT64_C(0x75CB6F62AFF7CC7B), UINT64_C(0x2D73F74D71B02A5B)}},
        {{UINT64_C(0x0B7B920A550ADA69), UINT64_C(0x87D29F08D2F1D5C2),
          UINT64_C(0x6E36EF9CEEA99A38), UINT64_C(0x624874C179D7626A)},
         {UINT64_C(0x9FCA1B2E17F026E0), UINT64_C(0xBDBE18E5A3A79C2E),
          UINT64_C(0x1506DE6A6E1B0C6D), UINT64_C(0x860CCD71AD2A2C5F)}},
        {{UINT64_C(0x00A15CB028715EF9), UINT64_C(0x71F337D8B1C0ED6D),
          UINT64_C(0xBD7E6892F998251E), UINT64_C(0x4C5AB31108E0A4E9)},
         {UINT64_C(0xDFD51293567342FB), UINT64_C(0xF202FCD15AE3193B),
          UINT64_C(0xE317C933AF59A5A2), UINT64_C(0x300FE0835055DE2A)}},
        {{UINT64_C(0x279A071AC58E7AE9), UINT64_C(0xCED1F2F44C718A8B),
          UINT64_C(0x3A8C0D1A5FE7F6E5), UINT64_C(0x789C9B04BB40DA93)},
         {UINT64_C(0xBB7EA922BF2A0B9B), UINT64_C(0x5DD7A04A3A484413),
          UINT64_C(0x3E1F49FBC5912F93), UINT64_C(0x4D8C07A561ECAB05)}},
    },
    {
        {{UINT64_C(0x7D3510079706D4CF), UINT64_C(0x3E2B3D2EB9BABB1F),
          UINT64_C(0xC73745BFA2E423EA), UINT64_C(0x0AB3940AF59601A0)},
         {UINT64_C(0x8881507A2A895C4F), UINT64_C(0xF27F6F4068652263),
          UINT64_C(0xCFD9181488A416BE), UINT64_C(0x13459BC31B4F51F6)}},
        {{UINT64_C(0x6D830E0C01C7C38A), UINT64_C(0xBA912BD4E27DA48A),
          UINT64_C(0x3828F4334AB8B5A6), UINT64_C(0x3F858E6CE35E88DA)},
         {UINT64_C(0x137F2E3A6E1C033C), UINT64_C(0xFC7C89537E670398),
          UINT64_C(0x6FF761CEF5C3D4DB), UINT64_C(0x53A02906EED1029B)}},
        {{UINT64_C(0x5C597BA656779C20), UINT64_C(0x366688CC43A87346),
          UINT64_C(0x19F6DA4AA55ACF91), UINT64_C(0x280ED592182DEC58)},
         {UINT64_C(0x0A1F3A7AA1D3EBDD), UINT64_C(0xD92B60780C9F474A),
          UINT64_C(0x38D0335E19AE00DD), UINT64_C(0x094A5772A97F33F7)}},
        {{UINT64_C(0x026A9029312D2694), UINT64_C(0x95408516AB5B34B8),
          UINT64_C(0x9FFA9AB1DED270EA), UINT64_C(0x1F9DDC52493E5935)},
         {UINT64_C(0xAC7F94C117244394), UINT64_C(0x18FC29C40F28C9DF),
          UINT64_C(0xEDE29238BD817BD9), UINT64_C(0x20DBF9AF8E2A7E40)}},
        {{UINT64_C(0x009365D97648CA5C), UINT64_C(0xB168191E2BF27488),
          UINT64_C(0x2481BFAAE3B91112), UINT64_C(0x744C505B3D6DB830)},
         {UINT64_C(0x21426D8F3C464704), UINT64_C(0x283F59EFDAF85A61),
          UINT64_C(0x278B5F8EF2716102), UINT64_C(0x95B80D820FE7E7EC)}},
        {{UINT64_C(0xD15ADA08F327664D), UINT64_C(0xF26E3232FE904AF8),
          UINT64_C(0x2763DBA6F99471C6), UINT64_C(0x4BC9713915F30827)},
         {UINT64_C(0x8523812E5F154BF9), UINT64_C(0x0839059FDE17F8F9),
          UINT64_C(0xEA151382BC16678D), UINT64_C(0x68D01E627890C4EF)}},
        {{UINT64_C(0x37FAC9FA9487556B), UINT64_C(0xB4DF5C53FB4DC83D),
          UINT64_C(0x1EF42D8C92969151), UINT64_C(0x6C0A9D188B0ED349)},
         {UINT64_C(0x63E91049946F31ED), UINT64_C(0x51E91DC6653F600B),
          UINT64_C(0xD7A582B153A29196), UINT64_C(0x0452F4AD31E1D843)}},
        {{UINT64_C(0x1224169D0DE8E344), UINT64_C(0x0F4AB4E7F329D30F),
          UINT64_C(0x12662965B525B6A4), UINT64_C(0x3142B612255F14B8)},
         {UINT64_C(0xEF6148B9BBF468A1), UINT64_C(0x3FC413B4144F8DFF),
          UINT64_C(0xA453D0759BF55B34), UINT64_C(0x857EC76386EBA319)}},
        {{UINT64_C(0x7FC22E26C16C1002), UINT64_C(0x2E34975EB0B186C3),
          UINT64_C(0xE11E36422FC79F85), UINT64_C(0x30FE5C0E9F981B5F)},
         {UINT64_C(0x73BD0FA631816247), UINT64_C(0x40FE16616906AF0A),
          UINT64_C(0x8D7109A3787BC7EE), UINT64_C(0x294520546FB9A590)}},
        {{UINT64_C(0x24654B9B4DFAAF93), UINT64_C(0x91CDEA8B9A450D29),
          UINT64_C(0xEE55420BE4874748), UINT64_C(0x01FAC14C6D03064C)},
         {UINT64_C(0x8A4EBDE2D93BD5BE), UINT64_C(0xCB2DF30749EF18A9),
          UINT64_C(0x36E6AC641A7B7F36), UINT64_C(0x301954234AC1CB8D)}},
        {{UINT64_C(0xD9970B1E34F5B3FF), UINT64_C(0x3CFEFC50587A9C5C),
          UINT64_C(0x8EC1C5DE7CCE631E), UINT64_C(0x92C93E2B52465AB8)},
         {UINT64_C(0x0104DF30257017CA), UINT64_C(0xF4E5E7798D8DB4CE),
          UINT64_C(0xE12A39DDFDC267F0), UINT64_C(0x683DEAFE27C73FDA)}},
        {{UINT64_C(0xD0840E81BBC70623), UINT64_C(0x03A93C164D23568E),
          UINT64_C(0xC52FF3D611A71BFF), UINT64_C(0x03C11FCE0875248E)},
         {UINT64_C(0xBC6F184B6C4AE445), UINT64_C(0xF52CC71F7698EE98),
          UINT64_C(0x4663193EEEA25223), UINT64_C(0x86CD1AB3031C68DC)}},
        {{UINT64_C(0x221C94EB21E04C02), UINT64_C(0xE96BB7B37B980F70),
          UINT64_C(0x60A7289724DC2BD1), UINT64_C(0x8C8E019F5621F475)},
         {UINT64_C(0xAE47B2F75CFA457A), UINT64_C(0x31B2F9E1F395C533),
          UINT64_C(0x7EEB5DDC82E75849), UINT64_C(0x4863A6A32A241E52)}},
        {{UINT64_C(0x806AC7F4914976EF), UINT64_C(0x5019261ECA42B875),
          UINT64_C(0x44F5C03D6EF2D82F), UINT64_C(0x24959F00690F2ACA)},
         {UINT64_C(0x4BDE211581F0BBB6), UINT64_C(0x01EB2C001F701A2D),
          UINT64_C(0x039F8910274FB05C), UINT64_C(0x57068F24C625EBCD)}},
        {{UINT64_C(0xB21B8C9367FF2575), UINT64_C(0xC7826C600C60B449),
          UINT64_C(0xD4D69A9FA98671BB), UINT64_C(0x95249276F5A2AB0C)},
         {UINT64_C(0x8F7007F02D1976DA), UINT64_C(0x846F2A92C011D54C),
          UINT64_C(0xFDBF81DFFA2076B1), UINT64_C(0x3349224F5583B46C)}},
        {{UINT64_C(0x624967467C854B4A), UINT64_C(0xF92BAE1D798B1395),
          UINT64_C(0x2EBE18E3D2F65638), UINT64_C(0x472FF6E58A068F49)},
         {UINT64_C(0x64BB0F33DA2030C2), UINT64_C(0x72C0D0C966F6C000),
          UINT64_C(0xEA837EE53194615E), UINT64_C(0x1B7B4849FA9A7903)}},
    },
    {
        {{UINT64_C(0x27AB780CCF9A0727), UINT64_C(0xD457A7BC9D7486CB),
          UINT64_C(0xFC57C335FE9F1A59), UINT64_C(0x269D8959D1D9F161)},
         {UINT64_C(0x06A32331B81605D5), UINT64_C(0x236963536F050BE0),
          UINT64_C(0xF9350879413E1C0D), UINT64_C(0x170195485761A8DF)}},
        {{UINT64_C(0x583D3D3F6765C6A2), UINT64_C(0x68BBA6F9BE9DF3AF),
          UINT64_C(0x7011E59485358B53), UINT64_C(0x3B2142E353A08874)},
         {UINT64_C(0x4AB6137E6F5C8641), UINT64_C(0x4955890E4FE9BCEB),
          UINT64_C(0xE2F732BA4D14DA01), UINT64_C(0x8CB285FCBEBD63D4)}},
        {{UINT64_C(0x5099551B6C74A0AA), UINT64_C(0xF04EB8F8BC2C8A61),
          UINT64_C(0xE169F49285983435), UINT64_C(0x764062A15B808C9E)},
         {UINT64_C(0x8C59A43F65B994FB), UINT64_C(0x2FB148B76068E685),
          UINT64_C(0x899D4FC554108A9F), UINT64_C(0x0469EA3E5B4D40FE)}},
        {{UINT64_C(0x15B613EA62A76AA8), UINT64_C(0x7E8E7D562FE2F179),
          UINT64_C(0x53160F65BE98EDC2), UINT64_C(0x258DA04E9810DC27)},
         {UINT64_C(0x4FEE19D0030D9C31), UINT64_C(0xFC2C57F8C29E300F),
          UINT64_C(0x00071F97C44458AE), UINT64_C(0x0AA2B911709727E1)}},
        {{UINT64_C(0x443F8B23A61166F8), UINT64_C(0x3E8F6278D685FCF1),
          UINT64_C(0xC930C1D1447433C6), UINT64_C(0x1245A867AED7D6EB)},
         {UINT64_C(0xC35986DDFA89945A), UINT64_C(0x89CE110926B0AFEE),
          UINT64_C(0x9C6A87CD17103D18), UINT64_C(0x811B2242CE338978)}},
        {{UINT64_C(0xC074AF660C293255), UINT64_C(0x982C23A95AEAC2E1),
          UINT64_C(0xDB14DE0CD39AC56C), UINT64_C(0x20263F3F47EBB839)},
         {UINT64_C(0x183EA578D10588DF), UINT64_C(0xB4D88EFB1EB69C36),
          UINT64_C(0xA79A1B4DDBF3BEE7), UINT64_C(0x650FC466E8159E0D)}},
        {{UINT64_C(0x9E6EE797F80D5744), UINT64_C(0xDFC3EBF5825949BD),
          UINT64_C(0x1083EC797EC9BD65), UINT64_C(0x62A45C5EB753499C)},
         {UINT64_C(0x9C135F802B6F42CF), UINT64_C(0xE39B0BA5C4B49041),
          UINT64_C(0x4D8385138D3B2D06), UINT64_C(0x696034DCD070754B)}},
        {{UINT64_C(0x06313D73B8E3BDD1), UINT64_C(0xC7BEC420E6968872),
          UINT64_C(0x740DD6D33A04B7F0), UINT64_C(0x98F2D0B72465BED2)},
         {UINT64_C(0x9F2984604043DBAD), UINT64_C(0x82D6991A01B5961F),
          UINT64_C(0xAAE7DF9D54DFAB8A), UINT64_C(0x5701E3351A07DD22)}},
        {{UINT64_C(0x5695A08EFCA398A2), UINT64_C(0xD29EBC1F0D76E8CF),
          UINT64_C(0x5AB17ABF24004EDB), UINT64_C(0x20C7761B0CC7A144)},
         {UINT64_C(0x6CAEE036285EA93C), UINT64_C(0xF9756E89F2B8BF23),
          UINT64_C(0x3CEA1C76B1AB91B7), UINT64_C(0x5D86860E3FB4F3B8)}},
        {{UINT64_C(0x835B023BFDC7DBC5), UINT64_C(0xF05C0676EEEDFD73),
          UINT64_C(0xF8325D64E52BFB27), UINT64_C(0x919D008DB5032CFF)},
         {UINT64_C(0xEF27862C4B130537), UINT64_C(0x616DF1545CE404DC),
          UINT64_C(0x182BA57E451ED033), UINT64_C(0x2EFEC0C7BD01F864)}},
        {{UINT64_C(0xDC84684545F3AF3C), UINT64_C(0x2D2BA0CD92A47B31),
          UINT64_C(0x9C806C7DE1AFE6EE), UINT64_C(0x28FE43FF4C6A4FEA)},
         {UINT64_C(0x2E028CD16C76C0F4), UINT64_C(0xC6FA5AD12AEFBDDA),
          UINT64_C(0xC8B5339BF63F1A35), UINT64_C(0x30C780A704523F02)}},
        {{UINT64_C(0x3D2DCA55D7E4F0CE), UINT64_C(0x8EEF918926616811),
          UINT64_C(0xB106642F3C0E5892), UINT64_C(0x4A96538589DB033E)},
         {UINT64_C(0x5A1CBEB6B3C2DD37), UINT64_C(0x5290C737156EAC75),
          UINT64_C(0x57AFD98AE32E40C7), UINT64_C(0x04A16164B3571868)}},
        {{UINT64_C(0x9AB8A3E91A673E1B), UINT64_C(0xC707ABBA0FC23483),
          UINT64_C(0x936C17839E0EA0BD), UINT64_C(0x1E4C2E7CF71F6F1D)},
         {UINT64_C(0x37904F636FB0926C), UINT64_C(0x9EC76DF7C51FEEA5),
          UINT64_C(0x2C60F7D64D103DAC), UINT64_C(0x7B451E0BF9DC2CC6)}},
        {{UINT64_C(0xD4F8526CB2A5F07F), UINT64_C(0x41303D42B0F4AE09),
          UINT64_C(0xAC79523F0C182FDC), UINT64_C(0x8D6A75C8AA0C5D6D)},
         {UINT64_C(0x4DD7FC953CDCE3F0), UINT64_C(0x4DDB39105BE6DA0F),
          UINT64_C(0xE34961F916F7E27D), UINT64_C(0x0C5CB76F5B3544EB)}},
        {{UINT64_C(0x324C95B5252C354C), UINT64_C(0x4648D87E8CC2C3BC),
          UINT64_C(0x6DDFDECD82BC8C80), UINT64_C(0x8C64CADEC069996E)},
         {UINT64_C(0x4E282E9640ED44AB), UINT64_C(0x70A1206779334507),
          UINT64_C(0x65CE5D385AB8902B), UINT64_C(0x56FE68F27C949D96)}},
        {{UINT64_C(0x1D55C87ECF9530AE), UINT64_C(0xD1CF73FFC147C2D5),
          UINT64_C(0x826031CDC1F44403), UINT64_C(0x3A06528F5EEF5BFB)},
         {UINT64_C(0xF220EAF35F84A7B1), UINT64_C(0xBC99C905350EBADE),
          UINT64_C(0x686A706E810A101C), UINT64_C(0x95E527131D92EAEA)}},
    },
    {
        {{UINT64_C(0xAAC634B3514D47C2), UINT64_C(0xD0C189B858B83B33),
          UINT64_C(0x633D59E358CA9A2F), UINT64_C(0x65965CE0838ACC80)},
         {UINT64_C(0xBB03F7EA9B512F6E), UINT64_C(0xB2F38B849EF17A82),
          UINT64_C(0xE8382E37E16A7A95), UINT64_C(0x28644EFE4D9EF607)}},
        {{UINT64_C(0x46F9115E040A515B), UINT64_C(0x4C7DBCFFFA59CD3E),
          UINT64_C(0xB4CE22B871BB543E), UINT64_C(0x58D935D8948F80BA)},
         {UINT64_C(0x33DC1D5B03683C8B), UINT64_C(0x25E6113A2D071D87),
          UINT64_C(0x44F962F8A7D59351), UINT64_C(0x6B818DDBBCF66B43)}},
        {{UINT64_C(0x363A63C7378C1098), UINT64_C(0xBEB2A7B6AC5C0C9E),
          UINT64_C(0x3F620D3F4361C8D4), UINT64_C(0x68EAD01A4E3D9686)},
         {UINT64_C(0x4361308545DB7208), UINT64_C(0x865A6DDE13B35D33),
          UINT64_C(0x4EAA166368DF09F5), UINT64_C(0x5FDCA83FBF02AA12)}},
        {{UINT64_C(0xC240FEAABFEFB3CB), UINT64_C(0x78E757D20EC6694F),
          UINT64_C(0xA11A82DF2413D6A2), UINT64_C(0x7BD656EEDBB7A220)},
         {UINT64_C(0x68C608736EB899A4), UINT64_C(0xAFFB9F1C318C72E8),
          UINT64_C(0xF16A443C9FB7619D), UINT64_C(0x2FC317E342C6E4D6)}},
        {{UINT64_C(0xAB56A87373F57A93), UINT64_C(0xE9BA24E2308F5224),
          UINT64_C(0x010281B911992077), UINT64_C(0x2CBCA7FE593EAD1A)},
         {UINT64_C(0xB400388A2A1D8318), UINT64_C(0xD470ABDA3C61A0AF),
          UINT64_C(0xF910272194BD2FAC), UINT64_C(0x222365D10FAC703C)}},
        {{UINT64_C(0x5C9021C49C2D1B2B), UINT64_C(0xB349DB18CAF0B562),
          UINT64_C(0x6DAF741291412CC3), UINT64_C(0x44E5E3E5CF6584D3)},
         {UINT64_C(0x1D1F4244E4C17B19), UINT64_C(0x4C663EE63787A38A),
          UINT64_C(0xA3261E22313A8581), UINT64_C(0x3AE1E1DB7A82C05A)}},
        {{UINT64_C(0x31AA2B293CD6A155), UINT64_C(0x0EB9527E3D078B12),
          UINT64_C(0x6785ABA2214FF1E2), UINT64_C(0x74974F84F111D572)},
         {UINT64_C(0x2199A753078C684B), UINT64_C(0xA0F1DE234B13A004),
          UINT64_C(0x3965AE1975BEBCBC), UINT64_C(0x22A8D7EE24562AA7)}},
        {{UINT64_C(0x0591965FBF268ADE), UINT64_C(0xF621B3649EE48F0E),
          UINT64_C(0x0AD981A95A3A3848), UINT64_C(0x1316675C9ECD72B7)},
         {UINT64_C(0x21A5CEB7F37C87E0), UINT64_C(0xEF864CF368D1AAFB),
          UINT64_C(0x5F340413D3C9A54F), UINT64_C(0x0C5DE1E6E00FD564)}},
        {{UINT64_C(0x439B2C0CB415D72C), UINT64_C(0x106AE2E063442E62),
          UINT64_C(0x8A9428C64A79E93B), UINT64_C(0x67FE6D6ECC2DF510)},
         {UINT64_C(0x407158BC655013B3), UINT64_C(0x3AAEAC1C2BC7E7CC),
          UINT64_C(0x399DB6EFEE8EC1F4), UINT64_C(0x1F7D0D17ECFF6657)}},
        {{UINT64_C(0x03039D18CB86639E), UINT64_C(0x586039099CDC3408),
          UINT64_C(0x52421109F1804B9E), UINT64_C(0x95502857ED126B9F)},
         {UINT64_C(0xC91842D9451B0539), UINT64_C(0x2B5B11EBE60AAE3B),
          UINT64_C(0xDB50F9EA44CB5A14), UINT64_C(0x4B5C982489E80A6E)}},
        {{UINT64_C(0x8EF3A1E569FC9F1A), UINT64_C(0xA4EAB6F47CCA576A),
          UINT64_C(0x955E1C89FBF1CD65), UINT64_C(0x3E3ACF6EF8CE13DB)},
         {UINT64_C(0x1FDB619058F31FC9), UINT64_C(0x10DB71B393B0D0D5),
          UINT64_C(0x900961439154B285), UINT64_C(0x37EEE1781C49EFF3)}},
        {{UINT64_C(0x609DE502BC198066), UINT64_C(0x075C863140722EF6),
          UINT64_C(0x121ACC9FFF0FA57D), UINT64_C(0x31E79AC5EC7DB1A0)},
         {UINT64_C(0x736EB95DF16FAE79), UINT64_C(0xFF963917815A14CB),
          UINT64_C(0xC6003E5D23AF0BC3), UINT64_C(0x0D1B035099AFCAAA)}},
        {{UINT64_C(0x8A1B6C971F0DF59D), UINT64_C(0x7DF81A7259C9CA8D),
          UINT64_C(0x74257F8E9602E8BE), UINT64_C(0x2FFBAD39A441657A)},
         {UINT64_C(0xB1B090DB048050A6), UINT64_C(0xD6144221741E7392),
          UINT64_C(0x63826973ECA1E2D6), UINT64_C(0x28EE60B8D287DE2F)}},
        {{UINT64_C(0x815042955DEE86CE), UINT64_C(0xFACCB61D73C03937),
          UINT64_C(0x9898F773299B96AF), UINT64_C(0x51552297488F95CD)},
         {UINT64_C(0x6170618C54F5E182), UINT64_C(0x9C11D666C2798401),
          UINT64_C(0x88225F4B3EAF3DDE), UINT64_C(0x20841538087F1185)}},
        {{UINT64_C(0x42BCEFFE14FA59EC), UINT64_C(0xC41CFCDA7D023F1E),
          UINT64_C(0xD7E4FDE77163E802), UINT64_C(0x54F4C7982E145BCE)},
         {UINT64_C(0xE4EA68C9F9162235), UINT64_C(0x4F7EAC6F458DEC24),
          UINT64_C(0x70100D2D845C6AD1), UINT64_C(0x67AC34CFF1EA21B2)}},
        {{UINT64_C(0x2BD49BDFAC21C728), UINT64_C(0x2D009B45EDA966DF),
          UINT64_C(0x0D4476BE4A9B9167), UINT64_C(0x340BD3BE95D2ACD2)},
         {UINT64_C(0xF8BACA2DB040FF50), UINT64_C(0x307BEA0DB91D47C1),
          UINT64_C(0x2EFDC81BB6B3A1E4), UINT64_C(0x3B2CD7D91595D6E2)}},
    },
    {
        {{UINT64_C(0x56254AE732A5A002), UINT64_C(0xE48A475C448B0A9F),
          UINT64_C(0x3B2DF6DF14EDBBA9), UINT64_C(0x911BE369F5E4CC81)},
         {UINT64_C(0x57D065C677CBB387), UINT64_C(0x7C1E0142527575FD),
          UINT64_C(0x2CA91EEF243B5C33), UINT64_C(0x7E54AF425C4700CC)}},
        {{UINT64_C(0xEF5ECAE55EEDF97F), UINT64_C(0x2D79312AC0D821AC),
          UINT64_C(0xD3817042A9EDBE8F), UINT64_C(0x7A3D537EAD924B1D)},
         {UINT64_C(0xD9923A20B26FFC3B), UINT64_C(0x651D22015B81EC12),
          UINT64_C(0xBDF7205A54C37FF0), UINT64_C(0x5562D2588C0D2E79)}},
        {{UINT64_C(0xE5BC2E1CFB4842F8), UINT64_C(0xCFE9782425B464C8),
          UINT64_C(0xD902A11A2FEA9ED3), UINT64_C(0x2FC360ED8D3DD0A4)},
         {UINT64_C(0xEC4E57FC9E5F7AE1), UINT64_C(0xF0F1FD9F79B8AF6C),
          UINT64_C(0x803F3ED6A9A283D0), UINT64_C(0x5F13000FADEEA78E)}},
        {{UINT64_C(0x3EBBBD161838B470), UINT64_C(0x934BA22AB2781680),
          UINT64_C(0xC9ED04FCC7210CD4), UINT64_C(0x716004A14615F186)},
         {UINT64_C(0xE7B36C21E894BBC3), UINT64_C(0x3F739857570AA9A8),
          UINT64_C(0x1707FBEE3063902B), UINT64_C(0x44FCB774155C9824)}},
        {{UINT64_C(0x30ECD772CDD8CEDB), UINT64_C(0x67BB36FDCA09BCD3),
          UINT64_C(0xD5AD0FAA9BC43B7B), UINT64_C(0x3962E5566A130895)},
         {UINT64_C(0x579282537F7A565A), UINT64_C(0xDE9D779255B911EE),
          UINT64_C(0xD5DBFDDE6984F326), UINT64_C(0x7CDF5E159FB51246)}},
        {{UINT64_C(0xD7FC427A89D24763), UINT64_C(0x50E627C9AD874362),
          UINT64_C(0x17A8F83B2069873A), UINT64_C(0x186952D7DB698BD1)},
         {UINT64_C(0x6C007EED38A2822C), UINT64_C(0x5F1870910C207073),
          UINT64_C(0xD0023B6308D245D2), UINT64_C(0x7A32C2A134544316)}},
        {{UINT64_C(0x8B99183A8C2635EC), UINT64_C(0xA00A94766F12B137),
          UINT64_C(0x9B5E2F57823DA313), UINT64_C(0x0F7CB4AF47B3CEB1)},
         {UINT64_C(0xC993AF7E67266D24), UINT64_C(0x8B60295EEBA985B8),
          UINT64_C(0x9AA596CBE41A6F69), UINT64_C(0x4D6CF5DF4B68507A)}},
        {{UINT64_C(0x3B8A3CBC6921DEFE), UINT64_C(0xB96D53900ED7B717),
          UINT64_C(0x6761E86A7DE65E54), UINT64_C(0x964460D6701CC1E4)},
         {UINT64_C(0x5C0A221326C82309), UINT64_C(0xF95F547220328C60),
          UINT64_C(0xB519B476FB49E3B5), UINT64_C(0x089D0AB6EE373756)}},
        {{UINT64_C(0x947DFCF0DC952768), UINT64_C(0xD8B5C61C3AB613AA),
          UINT64_C(0x146E83259A457DA4), UINT64_C(0x37E2F6D3F476945E)},
         {UINT64_C(0x5702A4413851A6F6), UINT64_C(0xB476560E8D67EF9C),
          UINT64_C(0xABA23F67F9D2AD96), UINT64_C(0x3CE30A4EDFBBB806)}},
        {{UINT64_C(0x64695640E5BAA662), UINT64_C(0x2A18979A0AAF3988),
          UINT64_C(0x605578FFDE0ED212), UINT64_C(0x52E604D530F2C13C)},
         {UINT64_C(0x2E9E2D83894AB3B9), UINT64_C(0x098B1FAA4BC33041),
          UINT64_C(0x01CF66060863AA3C), UINT64_C(0x7334879BD2951A60)}},
        {{UINT64_C(0xB080105CC51704F1), UINT64_C(0x1A5869B8EAEE29C4),
          UINT64_C(0xAD6AEF335FDD2FD3), UINT64_C(0x83E677C449C2B183)},
         {UINT64_C(0x757A4EFDDFA8B8F4), UINT64_C(0xFC8E7650E42F2C87),
          UINT64_C(0xD4A61A3E9C963D98), UINT64_C(0x3750289A45BC9044)}},
        {{UINT64_C(0x40A0620E40B1C72C), UINT64_C(0xAEE56EC7B2E44573),
          UINT64_C(0xE4E6EA3D60532553), UINT64_C(0x5BA50E80A0EB6014)},
         {UINT64_C(0x846429784378CC2F), UINT64_C(0xE322D1692A1C5FB4),
          UINT64_C(0x5000C9B16B91F82D), UINT64_C(0x32380CB87AA49F2D)}},
        {{UINT64_C(0x0A2F936AE18C4BD2), UINT64_C(0x7AEA56AAC3DB9AA5),
          UINT64_C(0x3A984E935DDF30CB), UINT64_C(0x36133D20904181C6)},
         {UINT64_C(0xA9A65593F62DFBF5), UINT64_C(0xB4AC06FD6808B883),
          UINT64_C(0x986797047A2FEDBB), UINT64_C(0x20E9E8E197880A72)}},
        {{UINT64_C(0x403A1ED1CEB26FAE), UINT64_C(0xAD13CD873CD622C9),
          UINT64_C(0xC1E03929CF45C32D), UINT64_C(0x4B50E4A9C3BE1A53)},
         {UINT64_C(0xCF10F3AFD0D7AFE3), UINT64_C(0x6A29B1731494A9B4),
          UINT64_C(0xB9DC9849D13B0495), UINT64_C(0x4C50794E9C05B110)}},
        {{UINT64_C(0xC3C97DED1427F71D), UINT64_C(0xC3CFB754966ECF33),
          UINT64_C(0x48E30FE11FBF30CD), UINT64_C(0x71C96E1C1E4B0998)},
         {UINT64_C(0x878D6305B92C4BF7), UINT64_C(0x14477130CCB5E4A1),
          UINT64_C(0x7C210767E3C00A19), UINT64_C(0x5546DBD5AB3CDBF0)}},
        {{UINT64_C(0xADEC875870857571), UINT64_C(0x0A52587CE70D07EC),
          UINT64_C(0xE6CEAF9EC731B9BC), UINT64_C(0x1D0FDE3F47143479)},
         {UINT64_C(0x2F3BE2CFC5B410CB), UINT64_C(0x576004BE4E64FD9B),
          UINT64_C(0x03F339517629820C), UINT64_C(0x7BD3296446A450E2)}},
    },
    {
        {{UINT64_C(0xD492D6B746CED42D), UINT64_C(0xC068D02D1F0092E3),
          UINT64_C(0x008ECBAD8D8A822A), UINT64_C(0x6B32686971045647)},
         {UINT64_C(0xFEE3237F523CBA58), UINT64_C(0x077B7F509C29059F),
          UINT64_C(0x42C308B3E72FBE6F), UINT64_C(0x3DD79D838E34148B)}},
        {{UINT64_C(0x3ED9DF47CAC24455), UINT64_C(0x7C8A7B31D8546306),
          UINT64_C(0x4CC432952AA02202), UINT64_C(0x5E8B4EA38598E028)},
         {UINT64_C(0x8A882F3F812B8070), UINT64_C(0x984BE5881DD374C0),
          UINT64_C(0x6FDA815916E133CF), UINT64_C(0x34FB92FA899920D0)}},
        {{UINT64_C(0x3BE0416FDA0B8D0E), UINT64_C(0x2CC846DB88C053D0),
          UINT64_C(0xC04C3A42B1A3A621), UINT64_C(0x35BC55508A9D9115)},
         {UINT64_C(0x7F8C9FE37FA72AFE), UINT64_C(0x488FA0B4D1E914FD),
          UINT64_C(0x8F5C2D6384F79359), UINT64_C(0x2BE80429FBC94785)}},
        {{UINT64_C(0x391794E06F67799A), UINT64_C(0xD9BF08AE0677A067),
          UINT64_C(0x716D5062DF61563C), UINT64_C(0x0ECB234AF590F3A3)},
         {UINT64_C(0xA5B91448FEA22392), UINT64_C(0xFAA294877E76FB8B),
          UINT64_C(0x3CC3A02A4B6CB375), UINT64_C(0x5C0B3B639022167A)}},
        {{UINT64_C(0xC5689CF34C576430), UINT64_C(0xF7B7B230C585F5A5),
          UINT64_C(0xB8DAADFBE4BFCEE7), UINT64_C(0x7B7D8A959CF4242F)},
         {UINT64_C(0xC1755F9B398FEEF6), UINT64_C(0x9B31CD4D5CC5C36E),
          UINT64_C(0x4D87AB9CF4C6B793), UINT64_C(0x673FD5B2F595EFA8)}},
        {{UINT64_C(0xA3836484E05E6B19), UINT64_C(0x090C14CFFCA7E6FB),
          UINT64_C(0xB7A27042FC717DBC), UINT64_C(0x56CD4AF138647882)},
         {UINT64_C(0xC2B56B50A43C453E), UINT64_C(0x0CD5E768982E7AED),
          UINT64_C(0xD5ABADF758474A8B), UINT64_C(0x68188A3899F500AC)}},
        {{UINT64_C(0x0683AC3E83B1F7BA), UINT64_C(0x6A4FC30C680568E9),
          UINT64_C(0x735F5E487F6256CF), UINT64_C(0x1240752D048DB831)},
         {UINT64_C(0x98B78A67868B8AD7), UINT64_C(0x9E32F2C1822EBA7D),
          UINT64_C(0xEAE28B1E8F37580F), UINT64_C(0x0D204CE0C72EDA86)}},
        {{UINT64_C(0x5E4EAA1C77E8C68C), UINT64_C(0x282ADFE9859A127B),
          UINT64_C(0x0C75AB7C14904910), UINT64_C(0x1794516A6E751062)},
         {UINT64_C(0x8D99D8913DE4A32A), UINT64_C(0x957AA80754EF2BF0),
          UINT64_C(0xBF20A9E00B109ECD), UINT64_C(0x7732F2B3A72268D3)}},
        {{UINT64_C(0xADB52E4348752F76), UINT64_C(0x01E9F4B1D6F7CCE8),
          UINT64_C(0x22702DA02E4BD9B5), UINT64_C(0x1BCC9C60B40BF9AB)},
         {UINT64_C(0xAB7746379F53B2B1), UINT64_C(0x9C5741518CB316D0),
          UINT64_C(0x231D5C45BECBEBED), UINT64_C(0x0BD2D5E7F0458638)}},
        {{UINT64_C(0xD2F5E0B54B946132), UINT64_C(0x200A8A30155AA2C8),
          UINT64_C(0x15473FD456A62CE7), UINT64_C(0x030EA71BB6689367)},
         {UINT64_C(0xD561432B0E315F29), UINT64_C(0x4155022E149E3A9E),
          UINT64_C(0xC77EF7E115841273), UINT64_C(0x890D9C8D52BA265A)}},
        {{UINT64_C(0xB72B5A6A5E62451A), UINT64_C(0xFDA85C175C61A183),
          UINT64_C(0xA4275361B7F36EB3), UINT64_C(0x53ADFAF394F4148D)},
         {UINT64_C(0x281D47F96A8467AE), UINT64_C(0x416A64B58474D3AD),
          UINT64_C(0x710D0E7AEC99480E), UINT64_C(0x2693A878819253FF)}},
        {{UINT64_C(0x4BE769041A2FE406), UINT64_C(0xB6FEED1D343F5B10),
          UINT64_C(0x36695C52D705E35C), UINT64_C(0x7DF6FA416BD3859F)},
         {UINT64_C(0x7B9B11F5C00E77EA), UINT64_C(0xC90411B8CA80F838),
          UINT64_C(0x8A9FAEF02908C694), UINT64_C(0x05F65AAAFF5B39B0)}},
        {{UINT64_C(0x823A0776D7F59CC5), UINT64_C(0xB9EBE15EC410DFD1),
          UINT64_C(0xC2374B5810A7FA3F), UINT64_C(0x1B912C84311660F2)},
         {UINT64_C(0x486A2607D5A175E6), UINT64_C(0x9B17D14D72B74EB7),
          UINT64_C(0x1069D5C41039CA77), UINT64_C(0x214605B33FEE08BB)}},
        {{UINT64_C(0xC25A7379F9D14E8D), UINT64_C(0x9D5FAFDA577D330E),
          UINT64_C(0xB9A0217DA4A9CEF0), UINT64_C(0x95AFC7F708252731)},
         {UINT64_C(0x14E53E9E8FC51680), UINT64_C(0x0AEA2428A8AC4E21),
          UINT64_C(0x6BC5E42C11CB2361), UINT64_C(0x3B205E45DCB52215)}},
        {{UINT64_C(0x8EDD4718C916CDE4), UINT64_C(0xBB08F27AD70D7130),
          UINT64_C(0x289A33C0ED9162CB), UINT64_C(0x97CEFA45FB69185B)},
         {UINT64_C(0x44DA25788B7797EE), UINT64_C(0x579B17F7148E9A75),
          UINT64_C(0x73EC1C23913C09AE), UINT64_C(0x3FAB86A40BAAA67D)}},
        {{UINT64_C(0x28E76C232DF7BE6D), UINT64_C(0x00526844500A844D),
          UINT64_C(0xB86FBB143CC748C2), UINT64_C(0x6D89BB8AEB5F6AC5)},
         {UINT64_C(0xF66159DF2327808C), UINT64_C(0x606F055329C5006C),
          UINT64_C(0xDAA1107F844B6CA4), UINT64_C(0x95D7686C63A8946C)}},
    },
    {
        {{UINT64_C(0x71438CEA07F7DCF5), UINT64_C(0xB3F59AFA0A1CCD55),
          UINT64_C(0x5A4396270E0071B4), UINT64_C(0x8694E3FAE93D5B8E)},
         {UINT64_C(0x21713A387D6550B0), UINT64_C(0x893BD9F706CFCD5B),
          UINT64_C(0xC3D2679CE7513FCE), UINT64_C(0x418AE7C82C451EF3)}},
        {{UINT64_C(0xADFAFF380B85E2A9), UINT64_C(0x6124E6272E244653),
          UINT64_C(0xF2C465AF375D1EE7), UINT64_C(0x5B2302D676E58455)},
         {UINT64_C(0x32938A0D7479F387), UINT64_C(0xF9A16A0DAAAB22A5),
          UINT64_C(0x65AF0E252AD65CAE), UINT64_C(0x2B5668668431EA40)}},
        {{UINT64_C(0xCA3ACC11DBCDAFAB), UINT64_C(0x0BBB5DBFBB7F218B),
          UINT64_C(0xD69E091ADB0ABBE2), UINT64_C(0x8AFFCE950B0B7B09)},
         {UINT64_C(0x0A5E6C81C7EC52C7), UINT64_C(0xABD60595896707CD),
          UINT64_C(0x4CE86506101E0F80), UINT64_C(0x9629A6C04ED01B2E)}},
        {{UINT64_C(0x1D740EACE15D82F4), UINT64_C(0x42F9801890A5D149),
          UINT64_C(0x1B8C8DC0903D6D28), UINT64_C(0x7BE2B91605BBDFF7)},
         {UINT64_C(0xFBACF878D8E41D96), UINT64_C(0x42E98BFBBE26EB56),
          UINT64_C(0x9EA73555F6DE1EB1), UINT64_C(0x5325DDDECF79A9EE)}},
        {{UINT64_C(0x44BE62C348E6A22F), UINT64_C(0xD0A3C0AD8DB35276),
          UINT64_C(0xB4C99306136FE9BA), UINT64_C(0x0F2987D7A44E491F)},
         {UINT64_C(0xA0965F74CCC77C2B), UINT64_C(0xE01AD644FE110072),
          UINT64_C(0x79528B9CC16B5E1E), UINT64_C(0x45AEEFF3F929BE4D)}},
        {{UINT64_C(0x46E95DF67F4DA458), UINT64_C(0x554C50C1A7AD579B),
          UINT64_C(0xF64F00A14316DBA1), UINT64_C(0x16C9851346D487BD)},
         {UINT64_C(0xECB197612C048A1B), UINT64_C(0x997AF3985373E5E6),
          UINT64_C(0x50E832D2FDF23B20), UINT64_C(0x1B358E0F7EF7E097)}},
        {{UINT64_C(0x7C6728AEACBC759C), UINT64_C(0x187588FBA156A466),
          UINT64_C(0xC2E550ED928F97BD), UINT64_C(0x8B595A3AAAE1C05A)},
         {UINT64_C(0xE36871E1D77C1125), UINT64_C(0x11E129780DBBD882),
          UINT64_C(0x3EF8268A5E77FB7E), UINT64_C(0x7BAEA9BA6B33C00C)}},
        {{UINT64_C(0x7C8512365925E5FE), UINT64_C(0xCED70AE5D8E1597B),
          UINT64_C(0x7A28BE1A6DCD112F), UINT64_C(0x1EB192683B8EAF6F)},
         {UINT64_C(0x7E6F1CF28AA902B9), UINT64_C(0x3DD9D59CA5A761D9),
          UINT64_C(0x8EF70BB448D9F52E), UINT64_C(0x96629C1ACDEE9658)}},
        {{UINT64_C(0xCA215EACB367C5B3), UINT64_C(0x36B22774A796338A),
          UINT64_C(0x71F9A61A26EBCDFE), UINT64_C(0x1B40580A35119BD3)},
         {UINT64_C(0x77169EF1431C78BD), UINT64_C(0x8197975E337022D5),
          UINT64_C(0x451127991D9A4742), UINT64_C(0x382750D619B6DB07)}},
        {{UINT64_C(0x740405EE9786AE0B), UINT64_C(0xF7F37C0F3ABA0481),
          UINT64_C(0x904FC60C51892307), UINT64_C(0x8405DF2AE891D639)},
         {UINT64_C(0x53D19AC5D9B432F8), UINT64_C(0xE8F1730F066CD97C),
          UINT64_C(0xC8740FEF0E95804B), UINT64_C(0x12EE433CEC242811)}},
        {{UINT64_C(0x6AF4B9B16153F4D4), UINT64_C(0x9CD8CD0CF84F0145),
          UINT64_C(0x6CABD4FCDCEB0F06), UINT64_C(0x036BF1460D134DCE)},
         {UINT64_C(0xCDEB18187EFFACAB), UINT64_C(0xB57A416252C987E7),
          UINT64_C(0xDD5104EBC647E82F), UINT64_C(0x389AA556F51B5270)}},
        {{UINT64_C(0xC450CAEA60108876), UINT64_C(0xF36B5B6AF48601A1),
          UINT64_C(0x257950D109128863), UINT64_C(0x7A592427A9F6A1B9)},
         {UINT64_C(0xBF1FF2B0ED12DE33), UINT64_C(0x4D542AC8E2141101),
          UINT64_C(0x998523C4E170F9CF), UINT64_C(0x629385CEFCEC0E2F)}},
        {{UINT64_C(0x951494EDB2677C49), UINT64_C(0xF1AE7138F9B648E8),
          UINT64_C(0x28B8749E63CFF359), UINT64_C(0x5AC4EC4C9A73272F)},
         {UINT64_C(0xC25ABB8721723271), UINT64_C(0x488EC9108B441AFD),
          UINT64_C(0x075183481B1DF775), UINT64_C(0x4662BBDAF1EB2FB4)}},
        {{UINT64_C(0xAE836F746DF9F64A), UINT64_C(0xF3CD6C9DA185ABE6),
          UINT64_C(0xAFA897A8C29A1C1A), UINT64_C(0x4BAFBB6911B2D6AC)},
         {UINT64_C(0x8040F9A3B6D971C7), UINT64_C(0x3B8920B700763EAF),
          UINT64_C(0x7A1655DA52E848B7), UINT64_C(0x03BC8B55703FA84D)}},
        {{UINT64_C(0xE6348C651F934416), UINT64_C(0xDBE59C03F82BBC4A),
          UINT64_C(0x51AEAD09EAD60547), UINT64_C(0x043A35C34F20111E)},
         {UINT64_C(0x0AA18326EC574F0A), UINT64_C(0x07E90D70FCADF79D),
          UINT64_C(0x3979D4CE201CD68B), UINT64_C(0x7FBF2C632C2734B1)}},
        {{UINT64_C(0x2E4513732656AF49), UINT64_C(0xCA86207DA432DE06),
          UINT64_C(0xC5F9262D12F20637), UINT64_C(0x7DD9CCDC26C0C745)},
         {UINT64_C(0x99276BDCA785ED89), UINT64_C(0x34B307A7374CFBE2),
          UINT64_C(0x916E9B061E8EE0C5), UINT64_C(0x4E8EB3C788A85C6A)}},
    },
    {
        {{UINT64_C(0x6F2433EF107F1CE0), UINT64_C(0x121DE13146D23AEF),
          UINT64_C(0x7AC50BE820DB44DE), UINT64_C(0x1E500A2BF6F41A1C)},
         {UINT64_C(0x8E5BAFCC27B0004C), UINT64_C(0x8538A5EDDB555C04),
          UINT64_C(0x00AEC8A7CE4ED544), UINT64_C(0x7C7301CC73B2DA91)}},
        {{UINT64_C(0x3E7E1E5C63284E3A), UINT64_C(0x145814001422D8EA),
          UINT64_C(0x5FE151BF7AAABD1D), UINT64_C(0x6716691F1533B371)},
         {UINT64_C(0xA592D53E22A8B7DF), UINT64_C(0x66991AFF51C97935),
          UINT64_C(0x8B10603DDE5429B6), UINT64_C(0x0002F6C6551F146B)}},
        {{UINT64_C(0xF641CBCB777A334C), UINT64_C(0xB45B21E1EEFBCA44),
          UINT64_C(0x7C2FCD6532F6E263), UINT64_C(0x05A21D80FEED8901)},
         {UINT64_C(0x2471B4865506CF47), UINT64_C(0x0FFAC1F77C9E62DE),
          UINT64_C(0xC4D321DF869D3BDC), UINT64_C(0x9AC035099512D0CA)}},
        {{UINT64_C(0x5A26E8F5352E0353), UINT64_C(0x965CF602BF6ABBAC),
          UINT64_C(0xDD8C4818E911C628), UINT64_C(0x132CA2D8DC2D04A0)},
         {UINT64_C(0x7641CFCE6C865C91), UINT64_C(0xDB5AB8F38E9965EF),
          UINT64_C(0x30030BCDDE0B7E90), UINT64_C(0x7BF444532320D3F1)}},
        {{UINT64_C(0xC006FA6DD8A99DAD), UINT64_C(0xC042F163B45E64A1),
          UINT64_C(0xB91C9CA474F4DBB1), UINT64_C(0x23BD5A29BE221E4E)},
         {UINT64_C(0x6B0591D73D1ECF78), UINT64_C(0x9E0ACF38AA5B771C),
          UINT64_C(0xC970F263796D4AA3), UINT64_C(0x370375027B5DD349)}},
        {{UINT64_C(0xE11DECDAFBC52541), UINT64_C(0xA49B8D39E7FE53A5),
          UINT64_C(0x3A08E9BB104A1F6E), UINT64_C(0x95444A15E0192BFB)},
         {UINT64_C(0xEF75B0621A97B875), UINT64_C(0x9FC8AE5EEA5FC457),
          UINT64_C(0x3A09FD1B47F73089), UINT64_C(0x096750ECE24516AB)}},
        {{UINT64_C(0xAA1800464A350C95), UINT64_C(0xA72F2B6758EA4195),
          UINT64_C(0xE0647945FD9A4F25), UINT64_C(0x4CF4136D22737E2D)},
         {UINT64_C(0xEE2532CEEFB2A96D), UINT64_C(0xB39DB1176C2F1471),
          UINT64_C(0xF7C6242B19935BDB), UINT64_C(0x98CA48D47A820092)}},
        {{UINT64_C(0xE9C1AD0AC3C938B0), UINT64_C(0xF7CC05C4CCDF3BC6),
          UINT64_C(0x3C21752B363A9CC6), UINT64_C(0x47996B875916BD59)},
         {UINT64_C(0x01EF895D98D17468), UINT64_C(0x9182F8825818F5D8),
          UINT64_C(0xCBD212A3E35E4BE7), UINT64_C(0x894E7F395EA16E55)}},
        {{UINT64_C(0xAC674AEE7C8FDD7E), UINT64_C(0xA23FA827EDB0FE30),
          UINT64_C(0x642BE06F745B3230), UINT64_C(0x7654C79BCB40941C)},
         {UINT64_C(0x4640C0C5D6A9E988), UINT64_C(0xA98AF66111A4EECB),
          UINT64_C(0xE1E827E3325D730E), UINT64_C(0x2342D8807D8A02DE)}},
        {{UINT64_C(0xE4101595715DB87E), UINT64_C(0x462718AB3C44A43A),
          UINT64_C(0xF414CBC7EFCBC0F7), UINT64_C(0x2A64DB21E5999AB3)},
         {UINT64_C(0xDAD841E19DA91E84), UINT64_C(0x5A28F6495F5C1CDD),
          UINT64_C(0x2F8C9DCAB8B41BDA), UINT64_C(0x259DC791029C3697)}},
        {{UINT64_C(0xD56F4EF45296BA38), UINT64_C(0x4A853BA102EC3100),
          UINT64_C(0xB0ED5F21C8AE4C47), UINT64_C(0x53D0DA0C61DF268E)},
         {UINT64_C(0xB6771DCB6DC06EB6), UINT64_C(0x30B07595BB0C457F),
          UINT64_C(0xC2FD08F3F174690D), UINT64_C(0x77000D6A87A5DC8E)}},
        {{UINT64_C(0x90DDAA616E1369AD), UINT64_C(0x3DD15EE7B6A5F225),
          UINT64_C(0x051AA9C427AEB0DC), UINT64_C(0x18712DBBE5372729)},
         {UINT64_C(0x13B3F9DFA23AFF5A), UINT64_C(0x34388CED703FBFF9),
          UINT64_C(0x0F390D6717D60129), UINT64_C(0x3F0CA25E4DAE9863)}},
        {{UINT64_C(0x6E0F5594903385DC), UINT64_C(0x47483889F8A815A9),
          UINT64_C(0x42AF320C23B70B1C), UINT64_C(0x4A27CA271A1AEA03)},
         {UINT64_C(0xFAAC21C866AF6F9D), UINT64_C(0x20849D90C9FBFD3E),
          UINT64_C(0x793F889FEE0A541C), UINT64_C(0x2555FC32ADA5D18F)}},
        {{UINT64_C(0x3F38F58CBA2BD509), UINT64_C(0x319A5F0D048F864B),
          UINT64_C(0xC4632F37D5900B1E), UINT64_C(0x3FAF2615F8519441)},
         {UINT64_C(0x6A4AA25DFE194D77), UINT64_C(0xB5A6464AD681409B),
          UINT64_C(0x1A9326EDB957523A), UINT64_C(0x7690EA4F27098B5B)}},
        {{UINT64_C(0x5530E91110F3FDE3), UINT64_C(0x9A40101F810E7853),
          UINT64_C(0x152704FC8F011C4E), UINT64_C(0x5B1702E4129B455F)},
         {UINT64_C(0x46A130BAE60F4D30), UINT64_C(0xA3D5741462BBE8B5),
          UINT64_C(0xA26238DA3CFAEFE3), UINT64_C(0x4E6141133175078E)}},
        {{UINT64_C(0x27BCCDFF992EE109), UINT64_C(0x79F88647FB45C6C3),
          UINT64_C(0x7FD5D73AC73F2829), UINT64_C(0x7EBE8E4E65A44CF1)},
         {UINT64_C(0xB9EC0B9437414B2C), UINT64_C(0x846AD1D136DED49D),
          UINT64_C(0x72AE106062F2FE87), UINT64_C(0x7F5AF329C032EEDD)}},
    },
    {
        {{UINT64_C(0x6C80B058C7A645A5), UINT64_C(0xF86341D2729066AC),
          UINT64_C(0xE4F366BD33FB5CE8), UINT64_C(0x6B79D63FC23A4751)},
         {UINT64_C(0xFAA0F994EC3F8686), UINT64_C(0x156A6E8EA9BA8F5E),
          UINT64_C(0xA46CA7D59F2FAE57), UINT64_C(0x84CB21966EFE66F2)}},
        {{UINT64_C(0xF9C1DECBED25185C), UINT64_C(0x6DC43F21B1FCFC82),
          UINT64_C(0x4A840262A954087B), UINT64_C(0x602308090A38F667)},
         {UINT64_C(0xBD3450061D9672B5), UINT64_C(0xE0FF804BF83361EF),
          UINT64_C(0x9DDC6CE1EF8E1598), UINT64_C(0x4419F705FBD9BD0E)}},
        {{UINT64_C(0xF171EDE43426122A), UINT64_C(0xEF6A1AE220A3963E),
          UINT64_C(0xD25AB7A2031647D0), UINT64_C(0x0FD7EC20CB4CA4E3)},
         {UINT64_C(0xC103969CB7D3A295), UINT64_C(0x4957509E34DBABA8),
          UINT64_C(0x8456DF6360BC0760), UINT64_C(0x02AF2033D63B49A9)}},
        {{UINT64_C(0x271966A00378E444), UINT64_C(0x673F057D5D15A0B7),
          UINT64_C(0xA55C44F9A0EFE59E), UINT64_C(0x2F602F87376119A6)},
         {UINT64_C(0x0A14907428981502), UINT64_C(0xDA0067748741D4F2),
          UINT64_C(0x8F982C81133F8479), UINT64_C(0x1ECAF17AF944319A)}},
        {{UINT64_C(0x281A234EA37F4FC2), UINT64_C(0xAFD847B2FD34FC11),
          UINT64_C(0x02CC08394683E11A), UINT64_C(0x71215DA93F65B844)},
         {UINT64_C(0xF9F41383EFE32AC9), UINT64_C(0x4AC3D91D1361FE53),
          UINT64_C(0x03C9FBAB1CC2E948), UINT64_C(0x9A9A4B9143379A4F)}},
        {{UINT64_C(0x8D37A10851BED5AC), UINT64_C(0x75D91890998E1C19),
          UINT64_C(0xE6C76B095D244730), UINT64_C(0x127147164CD555FF)},
         {UINT64_C(0xF2DCE85A29DDC669), UINT64_C(0x8914D13A8D622348),
          UINT64_C(0x9FE6B578DAE035E8), UINT64_C(0x21ECB251F41EEF19)}},
        {{UINT64_C(0xEAFF38627999064D), UINT64_C(0xB72BABEF96383204),
          UINT64_C(0x8E6C9E676BCCCB43), UINT64_C(0x320A7D787FD71298)},
         {UINT64_C(0x4081E38AB438A302), UINT64_C(0x0A15CBA7120E132D),
          UINT64_C(0x6D9123E1EC2E0939), UINT64_C(0x692D699CE0D6FEC5)}},
        {{UINT64_C(0xB639ADAEC8D5D361), UINT64_C(0xA8F742CCC60A078D),
          UINT64_C(0xE8D2CF929D740F0F), UINT64_C(0x6E8EEEF94DCE6A87)},
         {UINT64_C(0x54E194886A2E5164), UINT64_C(0x4372C6CF2430E4B9),
          UINT64_C(0xD58EA91B1C5B13B3), UINT64_C(0x796DCC45BB9F2911)}},
        {{UINT64_C(0xD8D4FAF0CBB267F9), UINT64_C(0xC2770DBE703F4011),
          UINT64_C(0x13739F020D651402), UINT64_C(0x7DE4E51E72D2B3F1)},
         {UINT64_C(0xB10F966E1FE00C7E), UINT64_C(0x5E9A15018F42B5F8),
          UINT64_C(0x6AFB1AD0D00437A3), UINT64_C(0x267D15361473D5AE)}},
        {{UINT64_C(0x1173B5DB4CAE118F), UINT64_C(0xC3A2EAFDCA749EE6),
          UINT64_C(0x64F738E64ED4FFF4), UINT64_C(0x47DDECB6B07860B6)},
         {UINT64_C(0xF5D627FCBD47A901), UINT64_C(0x6493BC28856C6903),
          UINT64_C(0x90280E4BEA63B675), UINT64_C(0x211C04A2C4148666)}},
        {{UINT64_C(0x0A5F0C276524BC38), UINT64_C(0x4B9D95FBBB3CBDB9),
          UINT64_C(0x5394ADC220507C82), UINT64_C(0x4C0C9167B4DBE448)},
         {UINT64_C(0xAC3E87CE303A5B11), UINT64_C(0xD31FB9C53251F4DF),
          UINT64_C(0x86C281DFE43CE799), UINT64_C(0x84E644D729FE09E4)}},
        {{UINT64_C(0x6D7B61DC43166C20), UINT64_C(0x54D6C035BD34F981),
          UINT64_C(0xB166769DC991096D), UINT64_C(0x51A47E3A3A4CF05C)},
         {UINT64_C(0x57CF9EFF14F5E7F1), UINT64_C(0xED3D4E9DE39FDA0D),
          UINT64_C(0xDF0176ECBAA7E93B), UINT64_C(0x6B2FEA1470935B9F)}},
        {{UINT64_C(0x19F9D59E709B70AE), UINT64_C(0xD850CA3270472149),
          UINT64_C(0x292CADD929EE6104), UINT64_C(0x870F7C998FD499F2)},
         {UINT64_C(0x200ECB1C415C6FFD), UINT64_C(0xEEA6107D35CB841B),
          UINT64_C(0x1CB06F8AF95DD333), UINT64_C(0x245712FDE498AA7B)}},
        {{UINT64_C(0x101665EAED4FBD78), UINT64_C(0xC6DDE1BB0E32D1B4),
          UINT64_C(0x3E79185E40150A9C), UINT64_C(0x49E2AE6B7DEF3607)},
         {UINT64_C(0xCCC9B0F6308B7F59), UINT64_C(0xB267008FCE922087),
          UINT64_C(0x46CF7F07CF2AABA6), UINT64_C(0x5A74C8A09954091F)}},
        {{UINT64_C(0x8F2871955240B5A0), UINT64_C(0x7AC7720F1845373D),
          UINT64_C(0xCF276B594E592274), UINT64_C(0x6BEBC284694C30B8)},
         {UINT64_C(0xDA0113D6677B16CD), UINT64_C(0xA221344645C9FA76),
          UINT64_C(0x2DEAF2ED66964ADB), UINT64_C(0x1977A8B3BC062240)}},
        {{UINT64_C(0xEEA2912680303DFD), UINT64_C(0x3E4A33ACE95BF6A1),
          UINT64_C(0x6BFE2D5D15DE0457), UINT64_C(0x407BF7E3AD0976D1)},
         {UINT64_C(0x04C1F61F306B415B), UINT64_C(0xC86A75D25F790D5F),
          UINT64_C(0x7B799EDEB7EAE07B), UINT64_C(0x9155A9A0B4A66839)}},
    },
    {
        {{UINT64_C(0x9745C6BB0DCE586B), UINT64_C(0x554C8313BE77B502),
          UINT64_C(0xF0F842A9A93962CF), UINT64_C(0x40862273AAA141BC)},
         {UINT64_C(0x926FFA4ABD62237B), UINT64_C(0xD4F1E4A17B942F48),
          UINT64_C(0x3A841EB7075684FD), UINT64_C(0x21F6EB39DD1807E1)}},
        {{UINT64_C(0x155DFD66BEDA4365), UINT64_C(0xDD575C8327F33BF9),
          UINT64_C(0x5907B08D3DFF83A1), UINT64_C(0x7E325357D6788D63)},
         {UINT64_C(0xF90BF447BAC74ED7), UINT64_C(0x2DE6C957EDA226CD),
          UINT64_C(0x678323021CA44607), UINT64_C(0x22ECBC1F56011C38)}},
        {{UINT64_C(0xF01279A9B663A46C), UINT64_C(0x07D74C5F7E3AAB83),
          UINT64_C(0xF20940B68C0DA43E), UINT64_C(0x57C6A735368AD991)},
         {UINT64_C(0x01E9B3665007E059), UINT64_C(0xFC38FC999614D480),
          UINT64_C(0x4A3AAA18FF7DA757), UINT64_C(0x4481B669B0CE1B03)}},
        {{UINT64_C(0x9CAA37A0B4A807FF), UINT64_C(0xBDEDEB49F9B269F3),
          UINT64_C(0xC5B76E57CB607AC3), UINT64_C(0x08AEFE669A322F48)},
         {UINT64_C(0x6919E40DD9261469), UINT64_C(0x1F0ADA81849718FA),
          UINT64_C(0xCD251B549D81628E), UINT64_C(0x6519C3C65505F9E1)}},
        {{UINT64_C(0x277591DC2F81C037), UINT64_C(0xD63AD35A76E0D41E),
          UINT64_C(0x682662B56EC063D3), UINT64_C(0x8210978B6762A0DB)},
         {UINT64_C(0x05085F68FE164B90), UINT64_C(0x50026ADC3D6FD0D1),
          UINT64_C(0x38CC9FA7B01A3791), UINT64_C(0x1E286652B376F83E)}},
        {{UINT64_C(0x8DFFDA1609759892), UINT64_C(0xE011DDDB9AC2CE5D),
          UINT64_C(0xDDC7670FBD71426B), UINT64_C(0x9722A23B19742F7C)},
         {UINT64_C(0x2EA99893DC4767D3), UINT64_C(0xCB68D6C211125BAE),
          UINT64_C(0xAC76953E307ED3B9), UINT64_C(0x0EDD0C17C366E9A2)}},
        {{UINT64_C(0x88B3DEC9484B5272), UINT64_C(0x0C848EA190380294),
          UINT64_C(0xDE187E83A01AC92C), UINT64_C(0x2A8801827A5D4D65)},
         {UINT64_C(0xD3C22C2BB3C3C7BB), UINT64_C(0xC485CE02DE7ECE33),
          UINT64_C(0xF22138C4A437071A), UINT64_C(0x23A55C890716DA53)}},
        {{UINT64_C(0x9533C4A3F6FE058E), UINT64_C(0x28753F87748E4A4F),
          UINT64_C(0x7814C50AEA404C70), UINT64_C(0x908D1C81E91B5EF3)},
         {UINT64_C(0xD827D3CE04094766), UINT64_C(0x7AE2FD260CE5C727),
          UINT64_C(0x016AC86FCDAD2BDD), UINT64_C(0x37C088B07A77C252)}},
        {{UINT64_C(0xABF4C1EF18A35CD3), UINT64_C(0x1F721491698A5A01),
          UINT64_C(0x79284A121A9E9A1F), UINT64_C(0x0457FF704D50DF40)},
         {UINT64_C(0x1D235814EC46ED07), UINT64_C(0xBD013752AE5E97C8),
          UINT64_C(0x0E085C88D9B100D4), UINT64_C(0x8AFA070A8858F9F3)}},
        {{UINT64_C(0x0F548BE3698D6A59), UINT64_C(0x5D7818A5BF2D0D94),
          UINT64_C(0x8E150DF1D80E620D), UINT64_C(0x4C3A5E64F857F167)},
         {UINT64_C(0x837D9A9861BD9152), UINT64_C(0x242CE5898D10687F),
          UINT64_C(0x9863EA4CB6B52BB7), UINT64_C(0x23665B46B7DD35FF)}},
        {{UINT64_C(0x3AA5432A73942AAF), UINT64_C(0xB0185DB40CEE83A9),
          UINT64_C(0x145372EEA83B907B), UINT64_C(0x609F1AD9BB6D341A)},
         {UINT64_C(0x28C2B37A864C92EE), UINT64_C(0xDD847239D4CC1158),
          UINT64_C(0xE5BD4FD28F2EAF0A), UINT64_C(0x04F43BC0D24950AB)}},
        {{UINT64_C(0x11DEFCED88DA3F20), UINT64_C(0xCA4CE370A407C4A2),
          UINT64_C(0xEA70BEDF2F8C5CFC), UINT64_C(0x08AC147D8214B7F7)},
         {UINT64_C(0xECAD0F77E260AA96), UINT64_C(0xA868AC63B56C30F7),
          UINT64_C(0xF0ACDE5A396F4815), UINT64_C(0x302F75B9ACDE6CD8)}},
        {{UINT64_C(0x2125D07DC5D14866), UINT64_C(0xFE563DE44AE3212D),
          UINT64_C(0x0FE787CBEE9CAA2B), UINT64_C(0x7D9B56A253802482)},
         {UINT64_C(0x128B4D378040D1A7), UINT64_C(0x5737129930ACA2F4),
          UINT64_C(0x5C443E357623D14A), UINT64_C(0x6436D3285FDB6310)}},
        {{UINT64_C(0x531486A4A8557B64), UINT64_C(0x3FAB4F219C5DE310),
          UINT64_C(0xD872282E260468D0), UINT64_C(0x04CD45682542CBA4)},
         {UINT64_C(0xACA0975A555B6E0C), UINT64_C(0xEE8C43B28B85132F),
          UINT64_C(0xC768808BB9DECE9D), UINT64_C(0x59EDEC60431AF98C)}},
        {{UINT64_C(0xC365E13331992E22), UINT64_C(0xB96C5FA00DC3A4C8),
          UINT64_C(0xDEB1C1DAA65761B0), UINT64_C(0x457676EEF4ACAB4C)},
         {UINT64_C(0xA0F95894E674FFAF), UINT64_C(0xFD099172D65CDAB7),
          UINT64_C(0x9383C2F854DA58A2), UINT64_C(0x0A4F4C110F24A07B)}},
        {{UINT64_C(0x9D7A80B3E380ABF3), UINT64_C(0xF0C6AC5A9E469F9F),
          UINT64_C(0xC87D57276BD0A324), UINT64_C(0x28138E377692B063)},
         {UINT64_C(0xE18C1F7DD67862CA), UINT64_C(0x4B6B723E1E07F928),
          UINT64_C(0xAAFE3FB0BBCF4125), UINT64_C(0x254003223B3AE714)}},
    },
    {
        {{UINT64_C(0xB89A2DCA63C295D8), UINT64_C(0x5CC03C6585041AA1),
          UINT64_C(0xFA9B4C5CC6514781), UINT64_C(0x578031A0D92388FF)},
         {UINT64_C(0xB0D5AE0AF92C2D77), UINT64_C(0x945A677E793D588A),
          UINT64_C(0x3722DE4434A190E0), UINT64_C(0x6EA90DB80C2B9975)}},
        {{UINT64_C(0xE987AA8584BA4F9B), UINT64_C(0xB2A77B9C0AB43BE6),
          UINT64_C(0xC4AD2AF6474D8841), UINT64_C(0x4ED7A82B5D4FA590)},
         {UINT64_C(0x9F39335E9977AC2B), UINT64_C(0x3CCD406D52E87607),
          UINT64_C(0x9D18CB3F71456060), UINT64_C(0x0FE4D8886A45D7D0)}},
        {{UINT64_C(0xAEA8A911F42D501A), UINT64_C(0x303E25D588F66FBA),
          UINT64_C(0x54213F2961740B85), UINT64_C(0x5BC13A30C0B4D835)},
         {UINT64_C(0x569AB9B84758EA28), UINT64_C(0xE2E49B28B796A794),
          UINT64_C(0x17787125320D54E2), UINT64_C(0x5A6A8EDEC54B4465)}},
        {{UINT64_C(0xC76C73D9870619DD), UINT64_C(0xF541440E84FE1078),
          UINT64_C(0x2082FE363B26A3DC), UINT64_C(0x3B896B29CC329B14)},
         {UINT64_C(0xB45028A9CAFCDC20), UINT64_C(0xA1B77C6F9C56757E),
          UINT64_C(0xDE50D86584802E47), UINT64_C(0x7DFBC0E8BA0892B0)}},
        {{UINT64_C(0xEBC505A947E702BB), UINT64_C(0x2329A41CDACFACFE),
          UINT64_C(0xEA11560351DDCE2F), UINT64_C(0x95BBC8072E9D855A)},
         {UINT64_C(0x454C6B88CFD33E9F), UINT64_C(0x993CF6DE4FFBB24A),
          UINT64_C(0xA8E22FF89B2144CD), UINT64_C(0x741066EE84943294)}},
        {{UINT64_C(0x2CEE0CFFF067E5B2), UINT64_C(0x1C1FD5A3CA95F1C5),
          UINT64_C(0xA0EB8E7DC07B97F1), UINT64_C(0x0F2A5D777457415E)},
         {UINT64_C(0xDFF92C5845D06291), UINT64_C(0x709EA0AC48ABABE8),
          UINT64_C(0xB3058FEB2FDC92F0), UINT64_C(0x55E9F86E5E5B169E)}},
        {{UINT64_C(0xEE5DF132EBF6AF2B), UINT64_C(0xC30DC3F1F642A206),
          UINT64_C(0xD7D8EC3E02C60CB6), UINT64_C(0x7C98946B3178F1BF)},
         {UINT64_C(0x816C2AA1A68799EB), UINT64_C(0x507FD5E92430F06B),
          UINT64_C(0x021FFF1CB9EBD4B7), UINT64_C(0x044365E68AECFEA4)}},
        {{UINT64_C(0xDC5F5EA621339693), UINT64_C(0x5BFD267690A448AD),
          UINT64_C(0xF712BA95A12A9D77), UINT64_C(0x7104735ABD8A6B5B)},
         {UINT64_C(0xD2ED8304A763BB99), UINT64_C(0x7AF040F011B91A05),
          UINT64_C(0xC545E8AEB61F3789), UINT64_C(0x582E9EEDBB386760)}},
        {{UINT64_C(0x0FCE5877CC099185), UINT64_C(0x0E148BB5CD681E67),
          UINT64_C(0xE9F9013EECB24ECE), UINT64_C(0x0090654B2A386485)},
         {UINT64_C(0x11BA700B0520BAE8), UINT64_C(0xFC93BE31D8E53123),
          UINT64_C(0x7DD7CB36E37948EE), UINT64_C(0x8689AE8F3FC23444)}},
        {{UINT64_C(0x2060F7DEAAC6616B), UINT64_C(0x372952C5DEAB3CC7),
          UINT64_C(0x715C4D27C2424ACD), UINT64_C(0x058468560308A009)},
         {UINT64_C(0x887BBD550B8B34E8), UINT64_C(0x949ACBD1B688C987),
          UINT64_C(0x3E774D49784C4C0E), UINT64_C(0x7AEA2D11B0F5F545)}},
        {{UINT64_C(0x5335BA6BE831E509), UINT64_C(0x8FC4B4AF739F332E),
          UINT64_C(0xB050246295993EAF), UINT64_C(0x7DA49F36A7CEB88B)},
         {UINT64_C(0x3BE0B74B029D0C8F), UINT64_C(0xBC07F18055611A8B),
          UINT64_C(0xC168CF416583F53F), UINT64_C(0x4256E8D2C34ADBC1)}},
        {{UINT64_C(0x313AFC75CE2FCD89), UINT64_C(0xEA27FDA4D3DA44F2),
          UINT64_C(0x9FABEA799063B0DC), UINT64_C(0x2DF7D966B3418884)},
         {UINT64_C(0x4329FD2480AF2EBD), UINT64_C(0x36F27FF79F095D30),
          UINT64_C(0x88FFB18FCC84C068), UINT64_C(0x976427A87B0A9906)}},
        {{UINT64_C(0xCFF828CCFAC21087), UINT64_C(0x6B6D348456863CB5),
          UINT64_C(0x14163A70C30879F3), UINT64_C(0x30E2A6338CA6FD5D)},
         {UINT64_C(0xC7FCEAD628A58783), UINT64_C(0x945F7B09EEFA1EAA),
          UINT64_C(0x98A503DB5CC66267), UINT64_C(0x83EE750E3780061B)}},
        {{UINT64_C(0x7061409AB8477D6B), UINT64_C(0xE47C779D2B7B54FA),
          UINT64_C(0x42F5EDF5F293166C), UINT64_C(0x73C3AC1B115D830F)},
         {UINT64_C(0xC30D346E4DEE0980), UINT64_C(0xEE0D9A29A62F0D09),
          UINT64_C(0xBBE8DC9EABCB7DAE), UINT64_C(0x4F0E78C068B78925)}},
        {{UINT64_C(0x25A0D4FFB4B14003), UINT64_C(0xA4C3AC55B8AB649C),
          UINT64_C(0x7D7EDE7227F9FDF5), UINT64_C(0x507EC83FBC2A46D4)},
         {UINT64_C(0x344577D9FAAFC26F), UINT64_C(0x77CBB7833EB30156),
          UINT64_C(0x3A846FFD1D5C9367), UINT64_C(0x5F0D280C9DF9F7BE)}},
        {{UINT64_C(0xCC8EAC0A77DF7F9F), UINT64_C(0x195BC6FFF33A62D4),
          UINT64_C(0x18A33FFA524D78FE), UINT64_C(0x10E589746603F9C0)},
         {UINT64_C(0x31AF4B460CDA2C3F), UINT64_C(0xDDBF00C8ADE169C3),
          UINT64_C(0xA169C3E371A7BC38), UINT64_C(0x3FC352FFA64B342E)}},
    },
    {
        {{UINT64_C(0x58848315EE73C673), UINT64_C(0x67D2F7C08ADB897E),
          UINT64_C(0xE8CD786DF0658115), UINT64_C(0x023D515AAC54D2AB)},
         {UINT64_C(0x0EDE61D867559911), UINT64_C(0xBC12B1063C2B78B5),
          UINT64_C(0xB5661A289E4707D8), UINT64_C(0x93FB4096ADC095A4)}},
        {{UINT64_C(0xEEB3810F33D5FA08), UINT64_C(0x8D8FC35433F4CAAF),
          UINT64_C(0xED87051629EB08A3), UINT64_C(0x89FD91CAD1D31EBC)},
         {UINT64_C(0xD2F1F832EDE2494B), UINT64_C(0xCFEE1D77FA8EEA95),
          UINT64_C(0x13603C4A3B0F005C), UINT64_C(0x6DF97F85D9EF68F4)}},
        {{UINT64_C(0x578FBC0A55410512), UINT64_C(0x1FA404F2DEC79EEE),
          UINT64_C(0x201FE21592B60820), UINT64_C(0x9A9B3CE80A56193A)},
         {UINT64_C(0x8A5ECCB910B49800), UINT64_C(0xA7373AEBBFDB1D8E),
          UINT64_C(0x8996BEFA4944B5DF), UINT64_C(0x3102D3C07B44246C)}},
        {{UINT64_C(0xD4A853B7449C09BE), UINT64_C(0x1F7080A451DDB7FE),
          UINT64_C(0x8A9DE52CE1C27FC1), UINT64_C(0x6585B54F0C58B99D)},
         {UINT64_C(0x8EEB0601B5A4AB53), UINT64_C(0x977D658D48C73AC6),
          UINT64_C(0xD5DA09033D9BD223), UINT64_C(0x881A5838BE115965)}},
        {{UINT64_C(0x8EB70B77EB3FC303), UINT64_C(0xED1C4DEF98BDB841),
          UINT64_C(0x13E6BE06997DE9E4), UINT64_C(0x4A94C0A19334D46D)},
         {UINT64_C(0x184C17C80F867DAF), UINT64_C(0x4A65802633A64148),
          UINT64_C(0xD177F0090AE3D4AA), UINT64_C(0x8134AC8F98ED12C0)}},
        {{UINT64_C(0x7A308A007A58DDEC), UINT64_C(0x74A15C5FFDF92DF2),
          UINT64_C(0x210D260E21B4E345), UINT64_C(0x6446715BC651E31E)},
         {UINT64_C(0xB1AF1F8410B905B6), UINT64_C(0xEF6CD0F2A62D366F),
          UINT64_C(0x77E47B01D1F6B7E3), UINT64_C(0x0F38B2802B95BD12)}},
        {{UINT64_C(0x52DA30E18CCCDAE6), UINT64_C(0x9F3D6636BD86A13A),
          UINT64_C(0xADFA00C5F4EA6151), UINT64_C(0x6B93BFA01EC37639)},
         {UINT64_C(0x443F0023F8FE22FC), UINT64_C(0xCB7848A4A81FEACC),
          UINT64_C(0xCE5E650A517E9E61), UINT64_C(0x5842DB7DA1968E3D)}},
        {{UINT64_C(0x61DDC69498C06F78), UINT64_C(0x680FEDE97985B1A2),
          UINT64_C(0x214CD2B8FB53A327), UINT64_C(0x98EAC0B3E425132B)},
         {UINT64_C(0x5EEDD76D33E5766D), UINT64_C(0x5B280618540000A3),
          UINT64_C(0x915D55CB65C894AE), UINT64_C(0x7B088A36D20D9523)}},
        {{UINT64_C(0x51A47312C28DA278), UINT64_C(0xE315CBA4EFE64521),
          UINT64_C(0x3EF70A1849D8D0FF), UINT64_C(0x0990CB92CABD48C5)},
         {UINT64_C(0x22ED6302A7C2FC76), UINT64_C(0xB50370EA2CB98186),
          UINT64_C(0xDEA88C65F3F2BA8B), UINT64_C(0x0906245109FEDEEA)}},
        {{UINT64_C(0x742F9A2EDAC0F222), UINT64_C(0xE2A8842B95C88A8E),
          UINT64_C(0x80C057659D817B14), UINT64_C(0x7ED0521A982D49AE)},
         {UINT64_C(0x047E49D4907B10F7), UINT64_C(0x8A3E23A7DE8AD4CD),
          UINT64_C(0xEBE8C13FEB5292B1), UINT64_C(0x048A6209A7EB70BD)}},
        {{UINT64_C(0xB51665A09AA34851), UINT64_C(0x4DD5AC1B7C4AFCEE),
          UINT64_C(0x00DEE7AB25A21937), UINT64_C(0x88E2681E80FAF232)},
         {UINT64_C(0x79ECD66AB5411EE2), UINT64_C(0x06008CE3F370BF53),
          UINT64_C(0xCFB1850EC9BBB64C), UINT64_C(0x5FBACB277149B14E)}},
        {{UINT64_C(0xA1F0EE079938AA0C), UINT64_C(0x6945E2BA74CCE9C4),
          UINT64_C(0x16689FCE46A98BEA), UINT64_C(0x8D71F405CF67DF91)},
         {UINT64_C(0x71E4CAC869621150), UINT64_C(0x518FA20089B380D8),
          UINT64_C(0x3B3B85F153F9E660), UINT64_C(0x02643303C6D9B022)}},
        {{UINT64_C(0xE8C478EC07660C3E), UINT64_C(0xA906C3A1EF41F1DA),
          UINT64_C(0xE918F16046699B71), UINT64_C(0x2B8A0B0EE5BE7B36)},
         {UINT64_C(0xC663F0EC889F50A0), UINT64_C(0x7413264BF9214F81),
          UINT64_C(0x2E9FA9A0421A9087), UINT64_C(0x85C59B7C83546DCD)}},
        {{UINT64_C(0xB4A6CF398D920A29), UINT64_C(0xC857AF481B3956A1),
          UINT64_C(0x519C7371DD794B23), UINT64_C(0x478462208EFBF8F9)},
         {UINT64_C(0x184C25E5617E4C6C), UINT64_C(0x218FCC23D2E51A5E),
          UINT64_C(0xB421971928FA0FFC), UINT64_C(0x6C0BCD71781A61D9)}},
        {{UINT64_C(0x440D6DDFDC7B5568), UINT64_C(0x64C7CC310DBBEC7C),
          UINT64_C(0x63D16D4EA2DC0CBA), UINT64_C(0x7BD9E0CC4504BE2C)},
         {UINT64_C(0x9C8828952DE780A8), UINT64_C(0x7C6685C2EF2B2486),
          UINT64_C(0xF1FB09E9957FA7D8), UINT64_C(0x20C6B5A546A77A98)}},
        {{UINT64_C(0x60C7757333C0F0C1), UINT64_C(0x40C93227CADDA5FE),
          UINT64_C(0xA48EBAA29DD41D5F), UINT64_C(0x4AAFBF3CEA9FD5AD)},
         {UINT64_C(0x7EB61836C5A287BA), UINT64_C(0x1D6A1BA2B31BA25E),
          UINT64_C(0x60507257AD186E52), UINT64_C(0x7FEC8EB02BAB7451)}},
    },
    {
        {{UINT64_C(0x500E2FDBB8DA5FFE), UINT64_C(0x6AE2D4EA8CDD1B39),
          UINT64_C(0x38D120251A5840CD), UINT64_C(0x8D3B20CBC214D26D)},
         {UINT64_C(0xEF6BB36CC041E874), UINT64_C(0x67660393450F2218),
          UINT64_C(0x1E1B7782A892BDFD), UINT64_C(0x2D69514C8D962E62)}},
        {{UINT64_C(0x9EDF5F789631B095), UINT64_C(0xAC7DD68745BF8F20),
          UINT64_C(0x257CCE28E3262EBC), UINT64_C(0x5D32EFCBE0E480A6)},
         {UINT64_C(0xED48E34C6FBB99E8), UINT64_C(0x50B1D58C23FDE9B7),
          UINT64_C(0xC5164C2A6B6927C8), UINT64_C(0x8A0BC6068906B705)}},
        {{UINT64_C(0x3FA3C7C92F747DA8), UINT64_C(0x2E8D2C2E14938E08),
          UINT64_C(0x155A8A5BB6A1C720), UINT64_C(0x6B4D8C9EB3133FD0)},
         {UINT64_C(0x079AC7F1CE131C1D), UINT64_C(0x9CF419AF815B7D2B),
          UINT64_C(0x569EB7BAE60B6245), UINT64_C(0x03C79E609A3DD94E)}},
        {{UINT64_C(0x328F5296B9CE9502), UINT64_C(0xCA44ADBDE45C3576),
          UINT64_C(0x669879526194AE2C), UINT64_C(0x5875F8EFBF9B8C49)},
         {UINT64_C(0x525A4D53DA51CAB8), UINT64_C(0x91A592DD9DC268B2),
          UINT64_C(0xD7EA7958E1E3C168), UINT64_C(0x0D1E20E0A999ED30)}},
        {{UINT64_C(0x55DA34E5FE8AD270), UINT64_C(0xB041289561EC55F6),
          UINT64_C(0x0D45670F534569C9), UINT64_C(0x5A7E6764E23F69FB)},
         {UINT64_C(0xBB6BBEC9A8B28676), UINT64_C(0x4F924558093B0D1D),
          UINT64_C(0xD4E4BF120C29D841), UINT64_C(0x67D2B4C8578A237A)}},
        {{UINT64_C(0x0BDF32D663EF2D73), UINT64_C(0x7248DD2D4AE4303C),
          UINT64_C(0xBB61BAB56CE1E92A), UINT64_C(0x126166E91D7B9A6C)},
         {UINT64_C(0x4CE7086A11CEBC3C), UINT64_C(0xE7ACB25E1C71426F),
          UINT64_C(0xBFB65EDC432CC4AF), UINT64_C(0x3BCA5202CB018CF7)}},
        {{UINT64_C(0xACF034F276430A87), UINT64_C(0xBFDF19B3534C42ED),
          UINT64_C(0x05654FE67946CB1A), UINT64_C(0x0DB07E7980F17880)},
         {UINT64_C(0xE6E93101FDCF8BC9), UINT64_C(0xF3198B87F798A8CD),
          UINT64_C(0xC05444EFC9683420), UINT64_C(0x56E9AA68915D1BF1)}},
        {{UINT64_C(0xF27B298B34000B11), UINT64_C(0x70ED8C95F4196E50),
          UINT64_C(0xF3E16608233C8764), UINT64_C(0x5B97655A41881557)},
         {UINT64_C(0x5BF11C1A128C195B), UINT64_C(0xFFB64333372C286D),
          UINT64_C(0x084D3EF77C83BB31), UINT64_C(0x8ECF6C01745B7D75)}},
        {{UINT64_C(0x3D6052B9C6F4FF82), UINT64_C(0x9305FE456607892F),
          UINT64_C(0x232FD87E5879425F), UINT64_C(0x4CAEDF73D6F47350)},
         {UINT64_C(0x889243D2032FC50D), UINT64_C(0xA6AF69D70C9C11AC),
          UINT64_C(0x43B5429D802E8E06), UINT64_C(0x38F1DEA8D70FC802)}},
        {{UINT64_C(0x54F24344C9595C08), UINT64_C(0x95A2E8FB0240AAB3),
          UINT64_C(0x07A5109DC3544985), UINT64_C(0x96F44213B5D30899)},
         {UINT64_C(0x03FAB192AA347497), UINT64_C(0x47FFD3DEC9CFC073),
          UINT64_C(0x283AD765D2C1D57F), UINT64_C(0x1FDFFBAC62DC271A)}},
        {{UINT64_C(0x2355C62995F80CA6), UINT64_C(0x90AE1DBBCD8D880A),
          UINT64_C(0x563CC122C54117E0), UINT64_C(0x1EF4991B813D7481)},
         {UINT64_C(0x8A310D77CCE9AEDE), UINT64_C(0xA401FAEF9318642E),
          UINT64_C(0xC1712A67CF9AFDCB), UINT64_C(0x8D97374CBE499DE5)}},
        {{UINT64_C(0x7437AA3B55A0BC07), UINT64_C(0x004946D0F726DD81),
          UINT64_C(0x33D41D1B0F341860), UINT64_C(0x2A009EB517840F0D)},
         {UINT64_C(0x158F59AEAA0DCDCF), UINT64_C(0xF686EF2DEAB42135),
          UINT64_C(0xFF6B8E827A80C670), UINT64_C(0x38646963A04DF944)}},
        {{UINT64_C(0x6BB2705E4B987E90), UINT64_C(0x2F5E2C4DD3C36316),
          UINT64_C(0x41B38905E5A9ECEC), UINT64_C(0x2C6BA68155BF8D1A)},
         {UINT64_C(0x1121B3B23C92B20B), UINT64_C(0x6DE41B12904305D5),
          UINT64_C(0xA0496CF4D569EAC4), UINT64_C(0x5C64A06C11E5CF90)}},
        {{UINT64_C(0xA65F12ABE28783DF), UINT64_C(0x2A891B0F37322285),
          UINT64_C(0xD6FF46049811C4EB), UINT64_C(0x7C960ED5A8505AC0)},
         {UINT64_C(0xE86893772FCA110D), UINT64_C(0x71AAE29260FD893E),
          UINT64_C(0x8ADE53177505671D), UINT64_C(0x721A07A58C508791)}},
        {{UINT64_C(0xC1AE9A50E5ECCA8C), UINT64_C(0x7528AEF507EB4329),
          UINT64_C(0x8F0D0E03D1297D88), UINT64_C(0x27C7BF76244BBC0C)},
         {UINT64_C(0x96EEDA7CC7E7E9BB), UINT64_C(0xC9749BF7F96C99B3),
          UINT64_C(0x44C852D2467B4D43), UINT64_C(0x1691D71D937FA21D)}},
        {{UINT64_C(0x8CAC092FF8058A68), UINT64_C(0x6B892BCFDAE38445),
          UINT64_C(0x82CBECE597D76059), UINT64_C(0x5AEB66463518F9E2)},
         {UINT64_C(0xA39C710C392080B4), UINT64_C(0x575DC5F41502DE54),
          UINT64_C(0xA465DD5E3A3D2B4D), UINT64_C(0x281AAE47638EAF45)}},
    },
    {
        {{UINT64_C(0xBE40C92BE955A145), UINT64_C(0xD464D6BC324234B5),
          UINT64_C(0xE8084747B09D4AF8), UINT64_C(0x939C70BF5268D6C3)},
         {UINT64_C(0x9C9C9D25D1DDBB48), UINT64_C(0x30D9EA7F790B5B42),
          UINT64_C(0x367FD79B4E3914B4), UINT64_C(0x27615F29826EE4D7)}},
        {{UINT64_C(0x09BB6F1650A41246), UINT64_C(0xC72BFF7AE5459A13),
          UINT64_C(0x0FC15846FF09B2F7), UINT64_C(0x6D90406209CB693A)},
         {UINT64_C(0x98A132F8F40FC67D), UINT64_C(0xC8B6573BDF37CBFA),
          UINT64_C(0xC9CF994899D7FC36), UINT64_C(0x0DD66ABAA7235DDB)}},
        {{UINT64_C(0x0180B525F96048BD), UINT64_C(0xEB566786544F1E70),
          UINT64_C(0x8BABBF9B8EF4373C), UINT64_C(0x509BA431D9E49178)},
         {UINT64_C(0xF961A6F565A4A201), UINT64_C(0xB6621DF98D44ED2D),
          UINT64_C(0xEADD3C0CD7B4D744), UINT64_C(0x75D27E990EAAB110)}},
        {{UINT64_C(0xEAC7AC7685DF5695), UINT64_C(0x02C26274DA7540A3),
          UINT64_C(0xDEC1BBC4C659B610), UINT64_C(0x54483C1B3AC61EEB)},
         {UINT64_C(0x8B91209A217E0283), UINT64_C(0x939FBDAF3A17DDFE),
          UINT64_C(0xA82C66D65BF98726), UINT64_C(0x2BA82FA0915AAC76)}},
        {{UINT64_C(0x99B324C1AF4542E8), UINT64_C(0x16EBC66FC0F225E0),
          UINT64_C(0xEAE6956327FEF57B), UINT64_C(0x2996FE3C961B03FA)},
         {UINT64_C(0x0835212E4F967A68), UINT64_C(0x0AAABD99F44352DC),
          UINT64_C(0x1874255F4B3A6B8D), UINT64_C(0x45F5D8B26D10B369)}},
        {{UINT64_C(0x603DD497F7B7644B), UINT64_C(0x369BE6762D1386AA),
          UINT64_C(0x08C1B76314C9FA94), UINT64_C(0x734921D9384AF696)},
         {UINT64_C(0xA1B5AF5BD76E8EEB), UINT64_C(0xB0EAE7A342F990E8),
          UINT64_C(0x59E7C515069ED81D), UINT64_C(0x2D1B5E62B5A50610)}},
        {{UINT64_C(0xDC32281085995BD3), UINT64_C(0x35A47B05873E7A09),
          UINT64_C(0x0CDFE9BBA70DE932), UINT64_C(0x049B899DD62FBC89)},
         {UINT64_C(0xF6BAA860652291DB), UINT64_C(0x58123B259AF7478F),
          UINT64_C(0xA05CCBC247B9F204), UINT64_C(0x8A0B479D82D999A7)}},
        {{UINT64_C(0xA72B9B522D0F619A), UINT64_C(0xE73B66F75919C420),
          UINT64_C(0x92319C86D21CFEFE), UINT64_C(0x58EEFC71F1635F0E)},
         {UINT64_C(0xDC481783DA909290), UINT64_C(0x144E7A9866316584),
          UINT64_C(0xBD7E657F45E1E3C8), UINT64_C(0x5C9FCD1CBD93938C)}},
        {{UINT64_C(0x2339E2FA436C1AB3), UINT64_C(0x69C22269C26768AA),
          UINT64_C(0x94DFCAF440FCBD90), UINT64_C(0x56235739C41D4F61)},
         {UINT64_C(0x6E50D4DB718468D3), UINT64_C(0xDEA80730CADCEC6C),
          UINT64_C(0x924FF97E63DC3C43), UINT64_C(0x1B6528256752EA6A)}},
        {{UINT64_C(0xAC2BDCDDF07BE4BB), UINT64_C(0xB46D8E968DB0A32D),
          UINT64_C(0xDD661C68B618488D), UINT64_C(0x8ED22D4B75E1E4BF)},
         {UINT64_C(0x5DD2E5DF3C177D80), UINT64_C(0x5049C01282803711),
          UINT64_C(0xFB243B3F73E0BA27), UINT64_C(0x0C756BA08C7810D5)}},
        {{UINT64_C(0xFC58F0BD6F16FBCA), UINT64_C(0xA855BB8CA5E33B36),
          UINT64_C(0xB9239EB499D08247), UINT64_C(0x27ABC78D49CAF40D)},
         {UINT64_C(0x88BE1595A1285278), UINT64_C(0x9D5AEE5B60F16638),
          UINT64_C(0x3F3815291FCE4327), UINT64_C(0x17206899F19CAA04)}},
        {{UINT64_C(0x586163489E047F55), UINT64_C(0x0D6098A5E991FC4C),
          UINT64_C(0x47760F9899A33914), UINT64_C(0x70C8F5D45608C80E)},
         {UINT64_C(0x405F119106036DBE), UINT64_C(0xBF62589580CC0A27),
          UINT64_C(0xFB8A0330389FA7BF), UINT64_C(0x22B0B9461FA0CBB4)}},
        {{UINT64_C(0x84AE19811B1E2ACD), UINT64_C(0xFA23C20563961891),
          UINT64_C(0xCF4C685E742C1653), UINT64_C(0x55BFC7444D303078)},
         {UINT64_C(0xEB131CBBBA03AAE4), UINT64_C(0xF338C0DB2C5B9EAB),
          UINT64_C(0xC1006396B7495209), UINT64_C(0x0FD928CFF7E6A4E6)}},
        {{UINT64_C(0xA6BAC9948633AB84), UINT64_C(0xC165BF5A75364642),
          UINT64_C(0xB70BEB478C57070D), UINT64_C(0x838158A0D416322E)},
         {UINT64_C(0x501D2BFDD4957751), UINT64_C(0xF1CDDF32C23AA730),
          UINT64_C(0xF64558A85458F1C6), UINT64_C(0x51B6DDE306E1209C)}},
        {{UINT64_C(0x0712C186CC31D6BE), UINT64_C(0x91C4064A33CD1D3F),
          UINT64_C(0xCADAE5B0C7C91F53), UINT64_C(0x52AA408FDEB2A2EE)},
         {UINT64_C(0x058675CC202719D5), UINT64_C(0x444F99F51D087D07),
          UINT64_C(0x4DB587E89D7A8AF4), UINT64_C(0x389376F5DA17095A)}},
        {{UINT64_C(0x8262D37048FED385), UINT64_C(0x3B1FB4661AE92689),
          UINT64_C(0xDA6F570F24242CF4), UINT64_C(0x0532FC9E0DEAC5E9)},
         {UINT64_C(0x5E8FB74020C5BD7B), UINT64_C(0x5AE99925002624B3),
          UINT64_C(0xAD44A4D57AFADC15), UINT64_C(0x6AECBC80DF409330)}},
    }};

/*-
 * Q := 2P, both projective, Q and P same pointers OK
 * Autogenerated: op3/dbl_proj.op3
 * https://eprint.iacr.org/2015/1060 Alg 6
 * ASSERT: a = -3
 */
static void point_double(pt_prj_t *Q, const pt_prj_t *P) {
    /* temporary variables */
    fe_t t0, t1, t2, t3, t4;
    /* constants */
    const limb_t *b = const_b;
    /* set pointers for legacy curve arith */
    const limb_t *X = P->X;
    const limb_t *Y = P->Y;
    const limb_t *Z = P->Z;
    limb_t *X3 = Q->X;
    limb_t *Y3 = Q->Y;
    limb_t *Z3 = Q->Z;

    /* the curve arith formula */
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(t0, X);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(t1, Y);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(t2, Z);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t3, X, Y);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t3, t3, t3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t4, Y, Z);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(Z3, X, Z);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Z3, Z3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(Y3, b, t2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(Y3, Y3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(X3, Y3, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Y3, X3, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(X3, t1, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Y3, t1, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(Y3, X3, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(X3, X3, t3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t3, t2, t2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t2, t2, t3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(Z3, b, Z3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(Z3, Z3, t2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(Z3, Z3, t0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t3, Z3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Z3, Z3, t3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t3, t0, t0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t0, t3, t0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(t0, t0, t2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t0, t0, Z3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Y3, Y3, t0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t0, t4, t4);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(Z3, t0, Z3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(X3, X3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(Z3, t0, t1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Z3, Z3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Z3, Z3, Z3);
}

/*-
 * R := Q + P where R and Q are projective, P affine.
 * R and Q same pointers OK
 * R and P same pointers not OK
 * Autogenerated: op3/add_mixed.op3
 * https://eprint.iacr.org/2015/1060 Alg 5
 * ASSERT: a = -3
 */
static void point_add_mixed(pt_prj_t *R, const pt_prj_t *Q, const pt_aff_t *P) {
    /* temporary variables */
    fe_t t0, t1, t2, t3, t4;
    /* constants */
    const limb_t *b = const_b;
    /* set pointers for legacy curve arith */
    const limb_t *X1 = Q->X;
    const limb_t *Y1 = Q->Y;
    const limb_t *Z1 = Q->Z;
    const limb_t *X2 = P->X;
    const limb_t *Y2 = P->Y;
    fe_t X3;
    fe_t Y3;
    fe_t Z3;
    limb_t nz;

    /* check P for affine inf */
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_nonzero(&nz, P->Y);

    /* the curve arith formula */
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t0, X1, X2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t1, Y1, Y2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t3, X2, Y2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t4, X1, Y1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t3, t3, t4);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t4, t0, t1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(t3, t3, t4);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t4, Y2, Z1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t4, t4, Y1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(Y3, X2, Z1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Y3, Y3, X1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(Z3, b, Z1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(X3, Y3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Z3, X3, X3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(X3, X3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(Z3, t1, X3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(X3, t1, X3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(Y3, b, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t1, Z1, Z1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t2, t1, Z1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(Y3, Y3, t2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(Y3, Y3, t0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t1, Y3, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Y3, t1, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t1, t0, t0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t0, t1, t0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(t0, t0, t2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t1, t4, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t2, t0, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(Y3, X3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Y3, Y3, t2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(X3, t3, X3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(X3, X3, t1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(Z3, t4, Z3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t1, t3, t0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Z3, Z3, t1);

    /* if P is inf, throw all that away and take Q */
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(R->X, nz, Q->X, X3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(R->Y, nz, Q->Y, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(R->Z, nz, Q->Z, Z3);
}

/*-
 * R := Q + P all projective.
 * R and Q same pointers OK
 * R and P same pointers not OK
 * Autogenerated: op3/add_proj.op3
 * https://eprint.iacr.org/2015/1060 Alg 4
 * ASSERT: a = -3
 */
static void point_add_proj(pt_prj_t *R, const pt_prj_t *Q, const pt_prj_t *P) {
    /* temporary variables */
    fe_t t0, t1, t2, t3, t4, t5;
    /* constants */
    const limb_t *b = const_b;
    /* set pointers for legacy curve arith */
    const limb_t *X1 = Q->X;
    const limb_t *Y1 = Q->Y;
    const limb_t *Z1 = Q->Z;
    const limb_t *X2 = P->X;
    const limb_t *Y2 = P->Y;
    const limb_t *Z2 = P->Z;
    limb_t *X3 = R->X;
    limb_t *Y3 = R->Y;
    limb_t *Z3 = R->Z;

    /* the curve arith formula */
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t0, X1, X2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t1, Y1, Y2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t2, Z1, Z2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t3, X1, Y1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t4, X2, Y2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t3, t3, t4);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t4, t0, t1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(t3, t3, t4);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t4, Y1, Z1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t5, Y2, Z2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t4, t4, t5);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t5, t1, t2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(t4, t4, t5);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(X3, X1, Z1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Y3, X2, Z2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(X3, X3, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Y3, t0, t2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(Y3, X3, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(Z3, b, t2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(X3, Y3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Z3, X3, X3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(X3, X3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(Z3, t1, X3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(X3, t1, X3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(Y3, b, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t1, t2, t2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t2, t1, t2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(Y3, Y3, t2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(Y3, Y3, t0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t1, Y3, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Y3, t1, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t1, t0, t0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t0, t1, t0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(t0, t0, t2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t1, t4, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t2, t0, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(Y3, X3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Y3, Y3, t2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(X3, t3, X3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(X3, X3, t1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(Z3, t4, Z3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t1, t3, t0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Z3, Z3, t1);
}

/* constants */
#define RADIX 5
#define DRADIX (1 << RADIX)
#define DRADIX_WNAF ((DRADIX) << 1)

/*-
 * precomp for wnaf scalar multiplication:
 * precomp[0] = 1P
 * precomp[1] = 3P
 * precomp[2] = 5P
 * precomp[3] = 7P
 * precomp[4] = 9P
 * ...
 */
static void precomp_wnaf(pt_prj_t precomp[DRADIX / 2], const pt_aff_t *P) {
    int i;

    fe_copy(precomp[0].X, P->X);
    fe_copy(precomp[0].Y, P->Y);
    fe_copy(precomp[0].Z, const_one);
    point_double(&precomp[DRADIX / 2 - 1], &precomp[0]);

    for (i = 1; i < DRADIX / 2; i++)
        point_add_proj(&precomp[i], &precomp[DRADIX / 2 - 1], &precomp[i - 1]);
}

/* fetch a scalar bit */
static int scalar_get_bit(const unsigned char in[32], int idx) {
    int widx, rshift;

    widx = idx >> 3;
    rshift = idx & 0x7;

    if (idx < 0 || widx >= 32) return 0;

    return (in[widx] >> rshift) & 0x1;
}

/*-
 * Compute "regular" wnaf representation of a scalar.
 * See "Exponent Recoding and Regular Exponentiation Algorithms",
 * Tunstall et al., AfricaCrypt 2009, Alg 6.
 * It forces an odd scalar and outputs digits in
 * {\pm 1, \pm 3, \pm 5, \pm 7, \pm 9, ...}
 * i.e. signed odd digits with _no zeroes_ -- that makes it "regular".
 */
static void scalar_rwnaf(int8_t out[52], const unsigned char in[32]) {
    int i;
    int8_t window, d;

    window = (in[0] & (DRADIX_WNAF - 1)) | 1;
    for (i = 0; i < 51; i++) {
        d = (window & (DRADIX_WNAF - 1)) - DRADIX;
        out[i] = d;
        window = (window - d) >> RADIX;
        window += scalar_get_bit(in, (i + 1) * RADIX + 1) << 1;
        window += scalar_get_bit(in, (i + 1) * RADIX + 2) << 2;
        window += scalar_get_bit(in, (i + 1) * RADIX + 3) << 3;
        window += scalar_get_bit(in, (i + 1) * RADIX + 4) << 4;
        window += scalar_get_bit(in, (i + 1) * RADIX + 5) << 5;
    }
    out[i] = window;
}

/*-
 * Compute "textbook" wnaf representation of a scalar.
 * NB: not constant time
 */
static void scalar_wnaf(int8_t out[257], const unsigned char in[32]) {
    int i;
    int8_t window, d;

    window = in[0] & (DRADIX_WNAF - 1);
    for (i = 0; i < 257; i++) {
        d = 0;
        if ((window & 1) && ((d = window & (DRADIX_WNAF - 1)) & DRADIX))
            d -= DRADIX_WNAF;
        out[i] = d;
        window = (window - d) >> 1;
        window += scalar_get_bit(in, i + 1 + RADIX) << RADIX;
    }
}

/*-
 * Simultaneous scalar multiplication: interleaved "textbook" wnaf.
 * NB: not constant time
 */
static void var_smul_wnaf_two(pt_aff_t *out, const unsigned char a[32],
                              const unsigned char b[32], const pt_aff_t *P) {
    int i, d, is_neg, is_inf = 1, flipped = 0;
    int8_t anaf[257] = {0};
    int8_t bnaf[257] = {0};
    pt_prj_t Q = {0};
    pt_prj_t precomp[DRADIX / 2];

    precomp_wnaf(precomp, P);
    scalar_wnaf(anaf, a);
    scalar_wnaf(bnaf, b);

    for (i = 256; i >= 0; i--) {
        if (!is_inf) point_double(&Q, &Q);
        if ((d = bnaf[i])) {
            if ((is_neg = d < 0) != flipped) {
                fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_opp(Q.Y, Q.Y);
                flipped ^= 1;
            }
            d = (is_neg) ? (-d - 1) >> 1 : (d - 1) >> 1;
            if (is_inf) {
                /* initialize accumulator */
                fe_copy(Q.X, &precomp[d].X);
                fe_copy(Q.Y, &precomp[d].Y);
                fe_copy(Q.Z, &precomp[d].Z);
                is_inf = 0;
            } else
                point_add_proj(&Q, &Q, &precomp[d]);
        }
        if ((d = anaf[i])) {
            if ((is_neg = d < 0) != flipped) {
                fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_opp(Q.Y, Q.Y);
                flipped ^= 1;
            }
            d = (is_neg) ? (-d - 1) >> 1 : (d - 1) >> 1;
            if (is_inf) {
                /* initialize accumulator */
                fe_copy(Q.X, &lut_cmb[0][d].X);
                fe_copy(Q.Y, &lut_cmb[0][d].Y);
                fe_copy(Q.Z, const_one);
                is_inf = 0;
            } else
                point_add_mixed(&Q, &Q, &lut_cmb[0][d]);
        }
    }

    if (is_inf) {
        /* initialize accumulator to inf: all-zero scalars */
        fe_set_zero(Q.X);
        fe_copy(Q.Y, const_one);
        fe_set_zero(Q.Z);
    }

    if (flipped) {
        /* correct sign */
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_opp(Q.Y, Q.Y);
    }

    /* convert to affine -- NB depends on coordinate system */
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_inv(Q.Z, Q.Z);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(out->X, Q.X, Q.Z);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(out->Y, Q.Y, Q.Z);
}

/*-
 * Variable point scalar multiplication with "regular" wnaf.
 */
static void var_smul_rwnaf(pt_aff_t *out, const unsigned char scalar[32],
                           const pt_aff_t *P) {
    int i, j, d, diff, is_neg;
    int8_t rnaf[52] = {0};
    pt_prj_t Q = {0}, lut = {0};
    pt_prj_t precomp[DRADIX / 2];

    precomp_wnaf(precomp, P);
    scalar_rwnaf(rnaf, scalar);

#if defined(_MSC_VER)
    /* result still unsigned: yes we know */
#pragma warning(push)
#pragma warning(disable : 4146)
#endif

    /* initialize accumulator to high digit */
    d = (rnaf[51] - 1) >> 1;
    for (j = 0; j < DRADIX / 2; j++) {
        diff = (1 - (-(d ^ j) >> (8 * sizeof(int) - 1))) & 1;
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(Q.X, diff, Q.X,
                                                              precomp[j].X);
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(Q.Y, diff, Q.Y,
                                                              precomp[j].Y);
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(Q.Z, diff, Q.Z,
                                                              precomp[j].Z);
    }

    for (i = 50; i >= 0; i--) {
        for (j = 0; j < RADIX; j++) point_double(&Q, &Q);
        d = rnaf[i];
        /* is_neg = (d < 0) ? 1 : 0 */
        is_neg = (d >> (8 * sizeof(int) - 1)) & 1;
        /* d = abs(d) */
        d = (d ^ -is_neg) + is_neg;
        d = (d - 1) >> 1;
        for (j = 0; j < DRADIX / 2; j++) {
            diff = (1 - (-(d ^ j) >> (8 * sizeof(int) - 1))) & 1;
            fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(
                lut.X, diff, lut.X, precomp[j].X);
            fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(
                lut.Y, diff, lut.Y, precomp[j].Y);
            fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(
                lut.Z, diff, lut.Z, precomp[j].Z);
        }
        /* negate lut point if digit is negative */
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_opp(out->Y, lut.Y);
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(lut.Y, is_neg,
                                                              lut.Y, out->Y);
        point_add_proj(&Q, &Q, &lut);
    }

#if defined(_MSC_VER)
#pragma warning(pop)
#endif

    /* conditionally subtract P if the scalar was even */
    fe_copy(lut.X, precomp[0].X);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_opp(lut.Y, precomp[0].Y);
    fe_copy(lut.Z, precomp[0].Z);
    point_add_proj(&lut, &lut, &Q);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(Q.X, scalar[0] & 1,
                                                          lut.X, Q.X);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(Q.Y, scalar[0] & 1,
                                                          lut.Y, Q.Y);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(Q.Z, scalar[0] & 1,
                                                          lut.Z, Q.Z);

    /* convert to affine -- NB depends on coordinate system */
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_inv(Q.Z, Q.Z);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(out->X, Q.X, Q.Z);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(out->Y, Q.Y, Q.Z);
}

/*-
 * Fixed scalar multiplication: comb with interleaving.
 */
static void fixed_smul_cmb(pt_aff_t *out, const unsigned char scalar[32]) {
    int i, j, k, d, diff, is_neg = 0;
    int8_t rnaf[52] = {0};
    pt_prj_t Q = {0}, R = {0};
    pt_aff_t lut = {0};

    scalar_rwnaf(rnaf, scalar);

    /* initalize accumulator to inf */
    fe_set_zero(Q.X);
    fe_copy(Q.Y, const_one);
    fe_set_zero(Q.Z);

#if defined(_MSC_VER)
    /* result still unsigned: yes we know */
#pragma warning(push)
#pragma warning(disable : 4146)
#endif

    for (i = 1; i >= 0; i--) {
        for (j = 0; i != 1 && j < RADIX; j++) point_double(&Q, &Q);
        for (j = 0; j < 27; j++) {
            if (j * 2 + i > 51) continue;
            d = rnaf[j * 2 + i];
            /* is_neg = (d < 0) ? 1 : 0 */
            is_neg = (d >> (8 * sizeof(int) - 1)) & 1;
            /* d = abs(d) */
            d = (d ^ -is_neg) + is_neg;
            d = (d - 1) >> 1;
            for (k = 0; k < DRADIX / 2; k++) {
                diff = (1 - (-(d ^ k) >> (8 * sizeof(int) - 1))) & 1;
                fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(
                    lut.X, diff, lut.X, lut_cmb[j][k].X);
                fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(
                    lut.Y, diff, lut.Y, lut_cmb[j][k].Y);
            }
            /* negate lut point if digit is negative */
            fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_opp(out->Y, lut.Y);
            fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(
                lut.Y, is_neg, lut.Y, out->Y);
            point_add_mixed(&Q, &Q, &lut);
        }
    }

#if defined(_MSC_VER)
#pragma warning(pop)
#endif

    /* conditionally subtract P if the scalar was even */
    fe_copy(lut.X, lut_cmb[0][0].X);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_opp(lut.Y, lut_cmb[0][0].Y);
    point_add_mixed(&R, &Q, &lut);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(Q.X, scalar[0] & 1,
                                                          R.X, Q.X);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(Q.Y, scalar[0] & 1,
                                                          R.Y, Q.Y);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(Q.Z, scalar[0] & 1,
                                                          R.Z, Q.Z);

    /* convert to affine -- NB depends on coordinate system */
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_inv(Q.Z, Q.Z);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(out->X, Q.X, Q.Z);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(out->Y, Q.Y, Q.Z);
}

/*-
 * Wrapper: simultaneous scalar mutiplication.
 * outx, outy := a * G + b * P
 * where P = (inx, iny).
 * Everything is LE byte ordering.
 */
static void point_mul_two(unsigned char outx[32], unsigned char outy[32],
                          const unsigned char a[32], const unsigned char b[32],
                          const unsigned char inx[32],
                          const unsigned char iny[32]) {
    pt_aff_t P;

    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_from_bytes(P.X, inx);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_from_bytes(P.Y, iny);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_to_montgomery(P.X, P.X);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_to_montgomery(P.Y, P.Y);
    /* simultaneous scalar multiplication */
    var_smul_wnaf_two(&P, a, b, &P);

    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_from_montgomery(P.X, P.X);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_from_montgomery(P.Y, P.Y);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_to_bytes(outx, P.X);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_to_bytes(outy, P.Y);
}

/*-
 * Wrapper: fixed scalar mutiplication.
 * outx, outy := scalar * G
 * Everything is LE byte ordering.
 */
static void point_mul_g(unsigned char outx[32], unsigned char outy[32],
                        const unsigned char scalar[32]) {
    pt_aff_t P;

    /* fixed scmul function */
    fixed_smul_cmb(&P, scalar);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_from_montgomery(P.X, P.X);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_from_montgomery(P.Y, P.Y);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_to_bytes(outx, P.X);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_to_bytes(outy, P.Y);
}

/*-
 * Wrapper: variable point scalar mutiplication.
 * outx, outy := scalar * P
 * where P = (inx, iny).
 * Everything is LE byte ordering.
 */
static void point_mul(unsigned char outx[32], unsigned char outy[32],
                      const unsigned char scalar[32],
                      const unsigned char inx[32],
                      const unsigned char iny[32]) {
    pt_aff_t P;

    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_from_bytes(P.X, inx);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_from_bytes(P.Y, iny);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_to_montgomery(P.X, P.X);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_to_montgomery(P.Y, P.Y);
    /* var scmul function */
    var_smul_rwnaf(&P, scalar, &P);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_from_montgomery(P.X, P.X);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_from_montgomery(P.Y, P.Y);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_to_bytes(outx, P.X);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_to_bytes(outy, P.Y);
}


#include <openssl/ec.h>

/* the zero field element */
static const unsigned char const_zb[32] = {0};

/*-
 * An OpenSSL wrapper for simultaneous scalar multiplication.
 * r := n * G + m * q
 */
    int
    point_mul_two_id_GostR3410_2001_CryptoPro_C_ParamSet(
        const EC_GROUP *group, EC_POINT *r, const BIGNUM *n, const EC_POINT *q,
        const BIGNUM *m, BN_CTX *ctx) {
    int ret = 0;
    unsigned char b_x[32];
    unsigned char b_y[32];
    unsigned char b_n[32];
    unsigned char b_m[32];
    BIGNUM *x = NULL, *y = NULL;

    BN_CTX_start(ctx);
    x = BN_CTX_get(ctx);
    if ((y = BN_CTX_get(ctx)) == NULL
        /* pull out coords as bytes */
        || !EC_POINT_get_affine_coordinates(group, q, x, y, ctx) ||
        BN_bn2lebinpad(x, b_x, 32) != 32 || BN_bn2lebinpad(y, b_y, 32) != 32 ||
        BN_bn2lebinpad(n, b_n, 32) != 32 || BN_bn2lebinpad(m, b_m, 32) != 32)
        goto err;
    /* do the simultaneous scalar multiplication */
    point_mul_two(b_x, b_y, b_n, b_m, b_x, b_y);
    /* check for infinity */
    if (CRYPTO_memcmp(const_zb, b_x, 32) == 0 &&
        CRYPTO_memcmp(const_zb, b_y, 32) == 0) {
        if (!EC_POINT_set_to_infinity(group, r)) goto err;
    } else {
        /* otherwise, pack the bytes into the result */
        if (BN_lebin2bn(b_x, 32, x) == NULL ||
            BN_lebin2bn(b_y, 32, y) == NULL ||
            !EC_POINT_set_affine_coordinates(group, r, x, y, ctx))
            goto err;
    }
    ret = 1;
err:
    BN_CTX_end(ctx);
    return ret;
}

/*-
 * An OpenSSL wrapper for variable point scalar multiplication.
 * r := m * q
 */
    int
    point_mul_id_GostR3410_2001_CryptoPro_C_ParamSet(const EC_GROUP *group,
                                                     EC_POINT *r,
                                                     const EC_POINT *q,
                                                     const BIGNUM *m,
                                                     BN_CTX *ctx) {
    int ret = 0;
    unsigned char b_x[32];
    unsigned char b_y[32];
    unsigned char b_m[32];
    BIGNUM *x = NULL, *y = NULL;

    BN_CTX_start(ctx);
    x = BN_CTX_get(ctx);
    if ((y = BN_CTX_get(ctx)) == NULL
        /* pull out coords as bytes */
        || !EC_POINT_get_affine_coordinates(group, q, x, y, ctx) ||
        BN_bn2lebinpad(x, b_x, 32) != 32 || BN_bn2lebinpad(y, b_y, 32) != 32 ||
        BN_bn2lebinpad(m, b_m, 32) != 32)
        goto err;
    /* do the variable scalar multiplication */
    point_mul(b_x, b_y, b_m, b_x, b_y);
    /* check for infinity */
    if (CRYPTO_memcmp(const_zb, b_x, 32) == 0 &&
        CRYPTO_memcmp(const_zb, b_y, 32) == 0) {
        if (!EC_POINT_set_to_infinity(group, r)) goto err;
    } else {
        /* otherwise, pack the bytes into the result */
        if (BN_lebin2bn(b_x, 32, x) == NULL ||
            BN_lebin2bn(b_y, 32, y) == NULL ||
            !EC_POINT_set_affine_coordinates(group, r, x, y, ctx))
            goto err;
    }
    ret = 1;
err:
    BN_CTX_end(ctx);
    return ret;
}

/*-
 * An OpenSSL wrapper for fixed scalar multiplication.
 * r := n * G
 */
    int
    point_mul_g_id_GostR3410_2001_CryptoPro_C_ParamSet(const EC_GROUP *group,
                                                       EC_POINT *r,
                                                       const BIGNUM *n,
                                                       BN_CTX *ctx) {
    int ret = 0;
    unsigned char b_x[32];
    unsigned char b_y[32];
    unsigned char b_n[32];
    BIGNUM *x = NULL, *y = NULL;

    BN_CTX_start(ctx);
    x = BN_CTX_get(ctx);
    if ((y = BN_CTX_get(ctx)) == NULL || BN_bn2lebinpad(n, b_n, 32) != 32)
        goto err;
    /* do the fixed scalar multiplication */
    point_mul_g(b_x, b_y, b_n);
    /* check for infinity */
    if (CRYPTO_memcmp(const_zb, b_x, 32) == 0 &&
        CRYPTO_memcmp(const_zb, b_y, 32) == 0) {
        if (!EC_POINT_set_to_infinity(group, r)) goto err;
    } else {
        /* otherwise, pack the bytes into the result */
        if (BN_lebin2bn(b_x, 32, x) == NULL ||
            BN_lebin2bn(b_y, 32, y) == NULL ||
            !EC_POINT_set_affine_coordinates(group, r, x, y, ctx))
            goto err;
    }
    ret = 1;
err:
    BN_CTX_end(ctx);
    return ret;
}



#else /* __SIZEOF_INT128__ */

#include <stdint.h>
#include <string.h>
#define LIMB_BITS 32
#define LIMB_CNT 8
/* Field elements */
typedef uint32_t fe_t[LIMB_CNT];
typedef uint32_t limb_t;

#ifdef OPENSSL_NO_ASM
#define FIAT_ID_GOSTR3410_2001_CRYPTOPRO_C_PARAMSET_NO_ASM
#endif

#define fe_copy(d, s) memcpy(d, s, sizeof(fe_t))
#define fe_set_zero(d) memset(d, 0, sizeof(fe_t))

/* Projective points */
typedef struct {
    fe_t X;
    fe_t Y;
    fe_t Z;
} pt_prj_t;

/* Affine points */
typedef struct {
    fe_t X;
    fe_t Y;
} pt_aff_t;

/* BEGIN verbatim fiat code https://github.com/mit-plv/fiat-crypto */
/*-
 * MIT License
 *
 * Copyright (c) 2020 the fiat-crypto authors (see the AUTHORS file)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/* Autogenerated: word_by_word_montgomery --static --use-value-barrier id_GostR3410_2001_CryptoPro_C_ParamSet 32 0x9B9F605F5A858107AB1EC85E6B41C8AACF846E86789051D37998F7B9022D759B */
/* curve description: id_GostR3410_2001_CryptoPro_C_ParamSet */
/* machine_wordsize = 32 (from "32") */
/* requested operations: (all) */
/* m = 0x9b9f605f5a858107ab1ec85e6b41c8aacf846e86789051d37998f7b9022d759b (from "0x9B9F605F5A858107AB1EC85E6B41C8AACF846E86789051D37998F7B9022D759B") */
/*                                                                    */
/* NOTE: In addition to the bounds specified above each function, all */
/*   functions synthesized for this Montgomery arithmetic require the */
/*   input to be strictly less than the prime modulus (m), and also   */
/*   require the input to be in the unique saturated representation.  */
/*   All functions also ensure that these two properties are true of  */
/*   return values.                                                   */
/*  */
/* Computed values: */
/* eval z = z[0] + (z[1] << 32) + (z[2] << 64) + (z[3] << 96) + (z[4] << 128) + (z[5] << 160) + (z[6] << 192) + (z[7] << 224) */
/* bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248) */

#include <stdint.h>
typedef unsigned char fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1;
typedef signed char fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_int1;

#if (-1 & 3) != 3
#error "This code only works on a two's complement system"
#endif

#if !defined(FIAT_ID_GOSTR3410_2001_CRYPTOPRO_C_PARAMSET_NO_ASM) && \
    (defined(__GNUC__) || defined(__clang__))
static __inline__ uint32_t
fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_value_barrier_u32(uint32_t a) {
    __asm__("" : "+r"(a) : /* no inputs */);
    return a;
}
#else
#define fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_value_barrier_u32(x) (x)
#endif

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32 is an addition with carry.
 * Postconditions:
 *   out1 = (arg1 + arg2 + arg3) mod 2^32
 *   out2 = ⌊(arg1 + arg2 + arg3) / 2^32⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
    uint32_t *out1, fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 *out2,
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 arg1, uint32_t arg2,
    uint32_t arg3) {
    uint64_t x1;
    uint32_t x2;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x3;
    x1 = ((arg1 + (uint64_t)arg2) + arg3);
    x2 = (uint32_t)(x1 & UINT32_C(0xffffffff));
    x3 = (fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1)(x1 >> 32);
    *out1 = x2;
    *out2 = x3;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32 is a subtraction with borrow.
 * Postconditions:
 *   out1 = (-arg1 + arg2 + -arg3) mod 2^32
 *   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^32⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [0x0 ~> 0x1]
 */
static void fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
    uint32_t *out1, fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 *out2,
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 arg1, uint32_t arg2,
    uint32_t arg3) {
    int64_t x1;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_int1 x2;
    uint32_t x3;
    x1 = ((arg2 - (int64_t)arg1) - arg3);
    x2 = (fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_int1)(x1 >> 32);
    x3 = (uint32_t)(x1 & UINT32_C(0xffffffff));
    *out1 = x3;
    *out2 = (fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1)(0x0 - x2);
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32 is a multiplication, returning the full double-width result.
 * Postconditions:
 *   out1 = (arg1 * arg2) mod 2^32
 *   out2 = ⌊arg1 * arg2 / 2^32⌋
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0xffffffff]
 *   arg2: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 *   out2: [0x0 ~> 0xffffffff]
 */
static void fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(
    uint32_t *out1, uint32_t *out2, uint32_t arg1, uint32_t arg2) {
    uint64_t x1;
    uint32_t x2;
    uint32_t x3;
    x1 = ((uint64_t)arg1 * arg2);
    x2 = (uint32_t)(x1 & UINT32_C(0xffffffff));
    x3 = (uint32_t)(x1 >> 32);
    *out1 = x2;
    *out2 = x3;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32 is a single-word conditional move.
 * Postconditions:
 *   out1 = (if arg1 = 0 then arg2 else arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [0x0 ~> 0xffffffff]
 *   arg3: [0x0 ~> 0xffffffff]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 */
static void fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(
    uint32_t *out1, fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 arg1,
    uint32_t arg2, uint32_t arg3) {
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x1;
    uint32_t x2;
    uint32_t x3;
    x1 = (!(!arg1));
    x2 = ((fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_int1)(0x0 - x1) &
          UINT32_C(0xffffffff));
    x3 =
        ((fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_value_barrier_u32(x2) &
          arg3) |
         (fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_value_barrier_u32((~x2)) &
          arg2));
    *out1 = x3;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul multiplies two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(
    uint32_t out1[8], const uint32_t arg1[8], const uint32_t arg2[8]) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    uint32_t x9;
    uint32_t x10;
    uint32_t x11;
    uint32_t x12;
    uint32_t x13;
    uint32_t x14;
    uint32_t x15;
    uint32_t x16;
    uint32_t x17;
    uint32_t x18;
    uint32_t x19;
    uint32_t x20;
    uint32_t x21;
    uint32_t x22;
    uint32_t x23;
    uint32_t x24;
    uint32_t x25;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x26;
    uint32_t x27;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x28;
    uint32_t x29;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x30;
    uint32_t x31;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x32;
    uint32_t x33;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x34;
    uint32_t x35;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x36;
    uint32_t x37;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x38;
    uint32_t x39;
    uint32_t x40;
    uint32_t x41;
    uint32_t x42;
    uint32_t x43;
    uint32_t x44;
    uint32_t x45;
    uint32_t x46;
    uint32_t x47;
    uint32_t x48;
    uint32_t x49;
    uint32_t x50;
    uint32_t x51;
    uint32_t x52;
    uint32_t x53;
    uint32_t x54;
    uint32_t x55;
    uint32_t x56;
    uint32_t x57;
    uint32_t x58;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x59;
    uint32_t x60;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x61;
    uint32_t x62;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x63;
    uint32_t x64;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x65;
    uint32_t x66;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x67;
    uint32_t x68;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x69;
    uint32_t x70;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x71;
    uint32_t x72;
    uint32_t x73;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x74;
    uint32_t x75;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x76;
    uint32_t x77;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x78;
    uint32_t x79;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x80;
    uint32_t x81;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x82;
    uint32_t x83;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x84;
    uint32_t x85;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x86;
    uint32_t x87;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x88;
    uint32_t x89;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x90;
    uint32_t x91;
    uint32_t x92;
    uint32_t x93;
    uint32_t x94;
    uint32_t x95;
    uint32_t x96;
    uint32_t x97;
    uint32_t x98;
    uint32_t x99;
    uint32_t x100;
    uint32_t x101;
    uint32_t x102;
    uint32_t x103;
    uint32_t x104;
    uint32_t x105;
    uint32_t x106;
    uint32_t x107;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x108;
    uint32_t x109;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x110;
    uint32_t x111;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x112;
    uint32_t x113;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x114;
    uint32_t x115;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x116;
    uint32_t x117;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x118;
    uint32_t x119;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x120;
    uint32_t x121;
    uint32_t x122;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x123;
    uint32_t x124;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x125;
    uint32_t x126;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x127;
    uint32_t x128;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x129;
    uint32_t x130;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x131;
    uint32_t x132;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x133;
    uint32_t x134;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x135;
    uint32_t x136;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x137;
    uint32_t x138;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x139;
    uint32_t x140;
    uint32_t x141;
    uint32_t x142;
    uint32_t x143;
    uint32_t x144;
    uint32_t x145;
    uint32_t x146;
    uint32_t x147;
    uint32_t x148;
    uint32_t x149;
    uint32_t x150;
    uint32_t x151;
    uint32_t x152;
    uint32_t x153;
    uint32_t x154;
    uint32_t x155;
    uint32_t x156;
    uint32_t x157;
    uint32_t x158;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x159;
    uint32_t x160;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x161;
    uint32_t x162;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x163;
    uint32_t x164;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x165;
    uint32_t x166;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x167;
    uint32_t x168;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x169;
    uint32_t x170;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x171;
    uint32_t x172;
    uint32_t x173;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x174;
    uint32_t x175;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x176;
    uint32_t x177;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x178;
    uint32_t x179;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x180;
    uint32_t x181;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x182;
    uint32_t x183;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x184;
    uint32_t x185;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x186;
    uint32_t x187;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x188;
    uint32_t x189;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x190;
    uint32_t x191;
    uint32_t x192;
    uint32_t x193;
    uint32_t x194;
    uint32_t x195;
    uint32_t x196;
    uint32_t x197;
    uint32_t x198;
    uint32_t x199;
    uint32_t x200;
    uint32_t x201;
    uint32_t x202;
    uint32_t x203;
    uint32_t x204;
    uint32_t x205;
    uint32_t x206;
    uint32_t x207;
    uint32_t x208;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x209;
    uint32_t x210;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x211;
    uint32_t x212;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x213;
    uint32_t x214;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x215;
    uint32_t x216;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x217;
    uint32_t x218;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x219;
    uint32_t x220;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x221;
    uint32_t x222;
    uint32_t x223;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x224;
    uint32_t x225;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x226;
    uint32_t x227;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x228;
    uint32_t x229;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x230;
    uint32_t x231;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x232;
    uint32_t x233;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x234;
    uint32_t x235;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x236;
    uint32_t x237;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x238;
    uint32_t x239;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x240;
    uint32_t x241;
    uint32_t x242;
    uint32_t x243;
    uint32_t x244;
    uint32_t x245;
    uint32_t x246;
    uint32_t x247;
    uint32_t x248;
    uint32_t x249;
    uint32_t x250;
    uint32_t x251;
    uint32_t x252;
    uint32_t x253;
    uint32_t x254;
    uint32_t x255;
    uint32_t x256;
    uint32_t x257;
    uint32_t x258;
    uint32_t x259;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x260;
    uint32_t x261;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x262;
    uint32_t x263;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x264;
    uint32_t x265;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x266;
    uint32_t x267;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x268;
    uint32_t x269;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x270;
    uint32_t x271;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x272;
    uint32_t x273;
    uint32_t x274;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x275;
    uint32_t x276;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x277;
    uint32_t x278;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x279;
    uint32_t x280;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x281;
    uint32_t x282;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x283;
    uint32_t x284;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x285;
    uint32_t x286;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x287;
    uint32_t x288;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x289;
    uint32_t x290;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x291;
    uint32_t x292;
    uint32_t x293;
    uint32_t x294;
    uint32_t x295;
    uint32_t x296;
    uint32_t x297;
    uint32_t x298;
    uint32_t x299;
    uint32_t x300;
    uint32_t x301;
    uint32_t x302;
    uint32_t x303;
    uint32_t x304;
    uint32_t x305;
    uint32_t x306;
    uint32_t x307;
    uint32_t x308;
    uint32_t x309;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x310;
    uint32_t x311;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x312;
    uint32_t x313;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x314;
    uint32_t x315;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x316;
    uint32_t x317;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x318;
    uint32_t x319;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x320;
    uint32_t x321;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x322;
    uint32_t x323;
    uint32_t x324;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x325;
    uint32_t x326;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x327;
    uint32_t x328;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x329;
    uint32_t x330;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x331;
    uint32_t x332;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x333;
    uint32_t x334;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x335;
    uint32_t x336;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x337;
    uint32_t x338;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x339;
    uint32_t x340;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x341;
    uint32_t x342;
    uint32_t x343;
    uint32_t x344;
    uint32_t x345;
    uint32_t x346;
    uint32_t x347;
    uint32_t x348;
    uint32_t x349;
    uint32_t x350;
    uint32_t x351;
    uint32_t x352;
    uint32_t x353;
    uint32_t x354;
    uint32_t x355;
    uint32_t x356;
    uint32_t x357;
    uint32_t x358;
    uint32_t x359;
    uint32_t x360;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x361;
    uint32_t x362;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x363;
    uint32_t x364;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x365;
    uint32_t x366;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x367;
    uint32_t x368;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x369;
    uint32_t x370;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x371;
    uint32_t x372;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x373;
    uint32_t x374;
    uint32_t x375;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x376;
    uint32_t x377;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x378;
    uint32_t x379;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x380;
    uint32_t x381;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x382;
    uint32_t x383;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x384;
    uint32_t x385;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x386;
    uint32_t x387;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x388;
    uint32_t x389;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x390;
    uint32_t x391;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x392;
    uint32_t x393;
    uint32_t x394;
    uint32_t x395;
    uint32_t x396;
    uint32_t x397;
    uint32_t x398;
    uint32_t x399;
    uint32_t x400;
    uint32_t x401;
    uint32_t x402;
    uint32_t x403;
    uint32_t x404;
    uint32_t x405;
    uint32_t x406;
    uint32_t x407;
    uint32_t x408;
    uint32_t x409;
    uint32_t x410;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x411;
    uint32_t x412;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x413;
    uint32_t x414;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x415;
    uint32_t x416;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x417;
    uint32_t x418;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x419;
    uint32_t x420;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x421;
    uint32_t x422;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x423;
    uint32_t x424;
    uint32_t x425;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x426;
    uint32_t x427;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x428;
    uint32_t x429;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x430;
    uint32_t x431;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x432;
    uint32_t x433;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x434;
    uint32_t x435;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x436;
    uint32_t x437;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x438;
    uint32_t x439;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x440;
    uint32_t x441;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x442;
    uint32_t x443;
    uint32_t x444;
    uint32_t x445;
    uint32_t x446;
    uint32_t x447;
    uint32_t x448;
    uint32_t x449;
    uint32_t x450;
    uint32_t x451;
    uint32_t x452;
    uint32_t x453;
    uint32_t x454;
    uint32_t x455;
    uint32_t x456;
    uint32_t x457;
    uint32_t x458;
    uint32_t x459;
    uint32_t x460;
    uint32_t x461;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x462;
    uint32_t x463;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x464;
    uint32_t x465;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x466;
    uint32_t x467;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x468;
    uint32_t x469;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x470;
    uint32_t x471;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x472;
    uint32_t x473;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x474;
    uint32_t x475;
    uint32_t x476;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x477;
    uint32_t x478;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x479;
    uint32_t x480;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x481;
    uint32_t x482;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x483;
    uint32_t x484;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x485;
    uint32_t x486;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x487;
    uint32_t x488;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x489;
    uint32_t x490;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x491;
    uint32_t x492;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x493;
    uint32_t x494;
    uint32_t x495;
    uint32_t x496;
    uint32_t x497;
    uint32_t x498;
    uint32_t x499;
    uint32_t x500;
    uint32_t x501;
    uint32_t x502;
    uint32_t x503;
    uint32_t x504;
    uint32_t x505;
    uint32_t x506;
    uint32_t x507;
    uint32_t x508;
    uint32_t x509;
    uint32_t x510;
    uint32_t x511;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x512;
    uint32_t x513;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x514;
    uint32_t x515;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x516;
    uint32_t x517;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x518;
    uint32_t x519;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x520;
    uint32_t x521;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x522;
    uint32_t x523;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x524;
    uint32_t x525;
    uint32_t x526;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x527;
    uint32_t x528;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x529;
    uint32_t x530;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x531;
    uint32_t x532;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x533;
    uint32_t x534;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x535;
    uint32_t x536;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x537;
    uint32_t x538;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x539;
    uint32_t x540;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x541;
    uint32_t x542;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x543;
    uint32_t x544;
    uint32_t x545;
    uint32_t x546;
    uint32_t x547;
    uint32_t x548;
    uint32_t x549;
    uint32_t x550;
    uint32_t x551;
    uint32_t x552;
    uint32_t x553;
    uint32_t x554;
    uint32_t x555;
    uint32_t x556;
    uint32_t x557;
    uint32_t x558;
    uint32_t x559;
    uint32_t x560;
    uint32_t x561;
    uint32_t x562;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x563;
    uint32_t x564;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x565;
    uint32_t x566;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x567;
    uint32_t x568;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x569;
    uint32_t x570;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x571;
    uint32_t x572;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x573;
    uint32_t x574;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x575;
    uint32_t x576;
    uint32_t x577;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x578;
    uint32_t x579;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x580;
    uint32_t x581;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x582;
    uint32_t x583;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x584;
    uint32_t x585;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x586;
    uint32_t x587;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x588;
    uint32_t x589;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x590;
    uint32_t x591;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x592;
    uint32_t x593;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x594;
    uint32_t x595;
    uint32_t x596;
    uint32_t x597;
    uint32_t x598;
    uint32_t x599;
    uint32_t x600;
    uint32_t x601;
    uint32_t x602;
    uint32_t x603;
    uint32_t x604;
    uint32_t x605;
    uint32_t x606;
    uint32_t x607;
    uint32_t x608;
    uint32_t x609;
    uint32_t x610;
    uint32_t x611;
    uint32_t x612;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x613;
    uint32_t x614;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x615;
    uint32_t x616;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x617;
    uint32_t x618;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x619;
    uint32_t x620;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x621;
    uint32_t x622;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x623;
    uint32_t x624;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x625;
    uint32_t x626;
    uint32_t x627;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x628;
    uint32_t x629;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x630;
    uint32_t x631;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x632;
    uint32_t x633;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x634;
    uint32_t x635;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x636;
    uint32_t x637;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x638;
    uint32_t x639;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x640;
    uint32_t x641;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x642;
    uint32_t x643;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x644;
    uint32_t x645;
    uint32_t x646;
    uint32_t x647;
    uint32_t x648;
    uint32_t x649;
    uint32_t x650;
    uint32_t x651;
    uint32_t x652;
    uint32_t x653;
    uint32_t x654;
    uint32_t x655;
    uint32_t x656;
    uint32_t x657;
    uint32_t x658;
    uint32_t x659;
    uint32_t x660;
    uint32_t x661;
    uint32_t x662;
    uint32_t x663;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x664;
    uint32_t x665;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x666;
    uint32_t x667;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x668;
    uint32_t x669;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x670;
    uint32_t x671;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x672;
    uint32_t x673;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x674;
    uint32_t x675;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x676;
    uint32_t x677;
    uint32_t x678;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x679;
    uint32_t x680;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x681;
    uint32_t x682;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x683;
    uint32_t x684;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x685;
    uint32_t x686;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x687;
    uint32_t x688;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x689;
    uint32_t x690;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x691;
    uint32_t x692;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x693;
    uint32_t x694;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x695;
    uint32_t x696;
    uint32_t x697;
    uint32_t x698;
    uint32_t x699;
    uint32_t x700;
    uint32_t x701;
    uint32_t x702;
    uint32_t x703;
    uint32_t x704;
    uint32_t x705;
    uint32_t x706;
    uint32_t x707;
    uint32_t x708;
    uint32_t x709;
    uint32_t x710;
    uint32_t x711;
    uint32_t x712;
    uint32_t x713;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x714;
    uint32_t x715;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x716;
    uint32_t x717;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x718;
    uint32_t x719;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x720;
    uint32_t x721;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x722;
    uint32_t x723;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x724;
    uint32_t x725;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x726;
    uint32_t x727;
    uint32_t x728;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x729;
    uint32_t x730;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x731;
    uint32_t x732;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x733;
    uint32_t x734;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x735;
    uint32_t x736;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x737;
    uint32_t x738;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x739;
    uint32_t x740;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x741;
    uint32_t x742;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x743;
    uint32_t x744;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x745;
    uint32_t x746;
    uint32_t x747;
    uint32_t x748;
    uint32_t x749;
    uint32_t x750;
    uint32_t x751;
    uint32_t x752;
    uint32_t x753;
    uint32_t x754;
    uint32_t x755;
    uint32_t x756;
    uint32_t x757;
    uint32_t x758;
    uint32_t x759;
    uint32_t x760;
    uint32_t x761;
    uint32_t x762;
    uint32_t x763;
    uint32_t x764;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x765;
    uint32_t x766;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x767;
    uint32_t x768;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x769;
    uint32_t x770;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x771;
    uint32_t x772;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x773;
    uint32_t x774;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x775;
    uint32_t x776;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x777;
    uint32_t x778;
    uint32_t x779;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x780;
    uint32_t x781;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x782;
    uint32_t x783;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x784;
    uint32_t x785;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x786;
    uint32_t x787;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x788;
    uint32_t x789;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x790;
    uint32_t x791;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x792;
    uint32_t x793;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x794;
    uint32_t x795;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x796;
    uint32_t x797;
    uint32_t x798;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x799;
    uint32_t x800;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x801;
    uint32_t x802;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x803;
    uint32_t x804;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x805;
    uint32_t x806;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x807;
    uint32_t x808;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x809;
    uint32_t x810;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x811;
    uint32_t x812;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x813;
    uint32_t x814;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x815;
    uint32_t x816;
    uint32_t x817;
    uint32_t x818;
    uint32_t x819;
    uint32_t x820;
    uint32_t x821;
    uint32_t x822;
    uint32_t x823;
    x1 = (arg1[1]);
    x2 = (arg1[2]);
    x3 = (arg1[3]);
    x4 = (arg1[4]);
    x5 = (arg1[5]);
    x6 = (arg1[6]);
    x7 = (arg1[7]);
    x8 = (arg1[0]);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x9, &x10, x8,
                                                         (arg2[7]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x11, &x12, x8,
                                                         (arg2[6]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x13, &x14, x8,
                                                         (arg2[5]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x15, &x16, x8,
                                                         (arg2[4]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x17, &x18, x8,
                                                         (arg2[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x19, &x20, x8,
                                                         (arg2[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x21, &x22, x8,
                                                         (arg2[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x23, &x24, x8,
                                                         (arg2[0]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x25, &x26, 0x0,
                                                              x24, x21);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x27, &x28, x26,
                                                              x22, x19);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x29, &x30, x28,
                                                              x20, x17);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x31, &x32, x30,
                                                              x18, x15);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x33, &x34, x32,
                                                              x16, x13);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x35, &x36, x34,
                                                              x14, x11);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x37, &x38, x36,
                                                              x12, x9);
    x39 = (x38 + x10);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x40, &x41, x23,
                                                         UINT32_C(0x727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x42, &x43, x40,
                                                         UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x44, &x45, x40,
                                                         UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x46, &x47, x40,
                                                         UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x48, &x49, x40,
                                                         UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x50, &x51, x40,
                                                         UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x52, &x53, x40,
                                                         UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x54, &x55, x40,
                                                         UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x56, &x57, x40,
                                                         UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x58, &x59, 0x0,
                                                              x57, x54);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x60, &x61, x59,
                                                              x55, x52);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x62, &x63, x61,
                                                              x53, x50);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x64, &x65, x63,
                                                              x51, x48);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x66, &x67, x65,
                                                              x49, x46);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x68, &x69, x67,
                                                              x47, x44);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x70, &x71, x69,
                                                              x45, x42);
    x72 = (x71 + x43);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x73, &x74, 0x0,
                                                              x23, x56);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x75, &x76, x74,
                                                              x25, x58);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x77, &x78, x76,
                                                              x27, x60);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x79, &x80, x78,
                                                              x29, x62);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x81, &x82, x80,
                                                              x31, x64);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x83, &x84, x82,
                                                              x33, x66);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x85, &x86, x84,
                                                              x35, x68);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x87, &x88, x86,
                                                              x37, x70);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x89, &x90, x88,
                                                              x39, x72);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x91, &x92, x1,
                                                         (arg2[7]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x93, &x94, x1,
                                                         (arg2[6]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x95, &x96, x1,
                                                         (arg2[5]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x97, &x98, x1,
                                                         (arg2[4]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x99, &x100, x1,
                                                         (arg2[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x101, &x102, x1,
                                                         (arg2[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x103, &x104, x1,
                                                         (arg2[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x105, &x106, x1,
                                                         (arg2[0]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x107, &x108, 0x0,
                                                              x106, x103);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x109, &x110,
                                                              x108, x104, x101);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x111, &x112,
                                                              x110, x102, x99);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x113, &x114,
                                                              x112, x100, x97);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x115, &x116,
                                                              x114, x98, x95);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x117, &x118,
                                                              x116, x96, x93);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x119, &x120,
                                                              x118, x94, x91);
    x121 = (x120 + x92);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x122, &x123, 0x0,
                                                              x75, x105);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x124, &x125,
                                                              x123, x77, x107);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x126, &x127,
                                                              x125, x79, x109);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x128, &x129,
                                                              x127, x81, x111);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x130, &x131,
                                                              x129, x83, x113);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x132, &x133,
                                                              x131, x85, x115);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x134, &x135,
                                                              x133, x87, x117);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x136, &x137,
                                                              x135, x89, x119);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x138, &x139,
                                                              x137, x90, x121);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x140, &x141, x122,
                                                         UINT32_C(0x727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x142, &x143, x140,
                                                         UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x144, &x145, x140,
                                                         UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x146, &x147, x140,
                                                         UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x148, &x149, x140,
                                                         UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x150, &x151, x140,
                                                         UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x152, &x153, x140,
                                                         UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x154, &x155, x140,
                                                         UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x156, &x157, x140,
                                                         UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x158, &x159, 0x0,
                                                              x157, x154);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x160, &x161,
                                                              x159, x155, x152);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x162, &x163,
                                                              x161, x153, x150);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x164, &x165,
                                                              x163, x151, x148);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x166, &x167,
                                                              x165, x149, x146);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x168, &x169,
                                                              x167, x147, x144);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x170, &x171,
                                                              x169, x145, x142);
    x172 = (x171 + x143);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x173, &x174, 0x0,
                                                              x122, x156);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x175, &x176,
                                                              x174, x124, x158);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x177, &x178,
                                                              x176, x126, x160);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x179, &x180,
                                                              x178, x128, x162);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x181, &x182,
                                                              x180, x130, x164);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x183, &x184,
                                                              x182, x132, x166);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x185, &x186,
                                                              x184, x134, x168);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x187, &x188,
                                                              x186, x136, x170);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x189, &x190,
                                                              x188, x138, x172);
    x191 = ((uint32_t)x190 + x139);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x192, &x193, x2,
                                                         (arg2[7]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x194, &x195, x2,
                                                         (arg2[6]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x196, &x197, x2,
                                                         (arg2[5]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x198, &x199, x2,
                                                         (arg2[4]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x200, &x201, x2,
                                                         (arg2[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x202, &x203, x2,
                                                         (arg2[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x204, &x205, x2,
                                                         (arg2[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x206, &x207, x2,
                                                         (arg2[0]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x208, &x209, 0x0,
                                                              x207, x204);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x210, &x211,
                                                              x209, x205, x202);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x212, &x213,
                                                              x211, x203, x200);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x214, &x215,
                                                              x213, x201, x198);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x216, &x217,
                                                              x215, x199, x196);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x218, &x219,
                                                              x217, x197, x194);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x220, &x221,
                                                              x219, x195, x192);
    x222 = (x221 + x193);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x223, &x224, 0x0,
                                                              x175, x206);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x225, &x226,
                                                              x224, x177, x208);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x227, &x228,
                                                              x226, x179, x210);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x229, &x230,
                                                              x228, x181, x212);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x231, &x232,
                                                              x230, x183, x214);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x233, &x234,
                                                              x232, x185, x216);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x235, &x236,
                                                              x234, x187, x218);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x237, &x238,
                                                              x236, x189, x220);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x239, &x240,
                                                              x238, x191, x222);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x241, &x242, x223,
                                                         UINT32_C(0x727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x243, &x244, x241,
                                                         UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x245, &x246, x241,
                                                         UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x247, &x248, x241,
                                                         UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x249, &x250, x241,
                                                         UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x251, &x252, x241,
                                                         UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x253, &x254, x241,
                                                         UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x255, &x256, x241,
                                                         UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x257, &x258, x241,
                                                         UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x259, &x260, 0x0,
                                                              x258, x255);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x261, &x262,
                                                              x260, x256, x253);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x263, &x264,
                                                              x262, x254, x251);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x265, &x266,
                                                              x264, x252, x249);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x267, &x268,
                                                              x266, x250, x247);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x269, &x270,
                                                              x268, x248, x245);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x271, &x272,
                                                              x270, x246, x243);
    x273 = (x272 + x244);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x274, &x275, 0x0,
                                                              x223, x257);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x276, &x277,
                                                              x275, x225, x259);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x278, &x279,
                                                              x277, x227, x261);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x280, &x281,
                                                              x279, x229, x263);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x282, &x283,
                                                              x281, x231, x265);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x284, &x285,
                                                              x283, x233, x267);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x286, &x287,
                                                              x285, x235, x269);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x288, &x289,
                                                              x287, x237, x271);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x290, &x291,
                                                              x289, x239, x273);
    x292 = ((uint32_t)x291 + x240);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x293, &x294, x3,
                                                         (arg2[7]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x295, &x296, x3,
                                                         (arg2[6]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x297, &x298, x3,
                                                         (arg2[5]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x299, &x300, x3,
                                                         (arg2[4]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x301, &x302, x3,
                                                         (arg2[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x303, &x304, x3,
                                                         (arg2[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x305, &x306, x3,
                                                         (arg2[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x307, &x308, x3,
                                                         (arg2[0]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x309, &x310, 0x0,
                                                              x308, x305);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x311, &x312,
                                                              x310, x306, x303);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x313, &x314,
                                                              x312, x304, x301);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x315, &x316,
                                                              x314, x302, x299);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x317, &x318,
                                                              x316, x300, x297);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x319, &x320,
                                                              x318, x298, x295);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x321, &x322,
                                                              x320, x296, x293);
    x323 = (x322 + x294);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x324, &x325, 0x0,
                                                              x276, x307);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x326, &x327,
                                                              x325, x278, x309);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x328, &x329,
                                                              x327, x280, x311);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x330, &x331,
                                                              x329, x282, x313);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x332, &x333,
                                                              x331, x284, x315);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x334, &x335,
                                                              x333, x286, x317);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x336, &x337,
                                                              x335, x288, x319);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x338, &x339,
                                                              x337, x290, x321);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x340, &x341,
                                                              x339, x292, x323);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x342, &x343, x324,
                                                         UINT32_C(0x727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x344, &x345, x342,
                                                         UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x346, &x347, x342,
                                                         UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x348, &x349, x342,
                                                         UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x350, &x351, x342,
                                                         UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x352, &x353, x342,
                                                         UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x354, &x355, x342,
                                                         UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x356, &x357, x342,
                                                         UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x358, &x359, x342,
                                                         UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x360, &x361, 0x0,
                                                              x359, x356);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x362, &x363,
                                                              x361, x357, x354);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x364, &x365,
                                                              x363, x355, x352);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x366, &x367,
                                                              x365, x353, x350);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x368, &x369,
                                                              x367, x351, x348);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x370, &x371,
                                                              x369, x349, x346);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x372, &x373,
                                                              x371, x347, x344);
    x374 = (x373 + x345);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x375, &x376, 0x0,
                                                              x324, x358);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x377, &x378,
                                                              x376, x326, x360);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x379, &x380,
                                                              x378, x328, x362);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x381, &x382,
                                                              x380, x330, x364);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x383, &x384,
                                                              x382, x332, x366);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x385, &x386,
                                                              x384, x334, x368);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x387, &x388,
                                                              x386, x336, x370);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x389, &x390,
                                                              x388, x338, x372);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x391, &x392,
                                                              x390, x340, x374);
    x393 = ((uint32_t)x392 + x341);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x394, &x395, x4,
                                                         (arg2[7]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x396, &x397, x4,
                                                         (arg2[6]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x398, &x399, x4,
                                                         (arg2[5]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x400, &x401, x4,
                                                         (arg2[4]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x402, &x403, x4,
                                                         (arg2[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x404, &x405, x4,
                                                         (arg2[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x406, &x407, x4,
                                                         (arg2[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x408, &x409, x4,
                                                         (arg2[0]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x410, &x411, 0x0,
                                                              x409, x406);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x412, &x413,
                                                              x411, x407, x404);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x414, &x415,
                                                              x413, x405, x402);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x416, &x417,
                                                              x415, x403, x400);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x418, &x419,
                                                              x417, x401, x398);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x420, &x421,
                                                              x419, x399, x396);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x422, &x423,
                                                              x421, x397, x394);
    x424 = (x423 + x395);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x425, &x426, 0x0,
                                                              x377, x408);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x427, &x428,
                                                              x426, x379, x410);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x429, &x430,
                                                              x428, x381, x412);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x431, &x432,
                                                              x430, x383, x414);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x433, &x434,
                                                              x432, x385, x416);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x435, &x436,
                                                              x434, x387, x418);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x437, &x438,
                                                              x436, x389, x420);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x439, &x440,
                                                              x438, x391, x422);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x441, &x442,
                                                              x440, x393, x424);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x443, &x444, x425,
                                                         UINT32_C(0x727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x445, &x446, x443,
                                                         UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x447, &x448, x443,
                                                         UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x449, &x450, x443,
                                                         UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x451, &x452, x443,
                                                         UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x453, &x454, x443,
                                                         UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x455, &x456, x443,
                                                         UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x457, &x458, x443,
                                                         UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x459, &x460, x443,
                                                         UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x461, &x462, 0x0,
                                                              x460, x457);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x463, &x464,
                                                              x462, x458, x455);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x465, &x466,
                                                              x464, x456, x453);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x467, &x468,
                                                              x466, x454, x451);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x469, &x470,
                                                              x468, x452, x449);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x471, &x472,
                                                              x470, x450, x447);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x473, &x474,
                                                              x472, x448, x445);
    x475 = (x474 + x446);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x476, &x477, 0x0,
                                                              x425, x459);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x478, &x479,
                                                              x477, x427, x461);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x480, &x481,
                                                              x479, x429, x463);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x482, &x483,
                                                              x481, x431, x465);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x484, &x485,
                                                              x483, x433, x467);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x486, &x487,
                                                              x485, x435, x469);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x488, &x489,
                                                              x487, x437, x471);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x490, &x491,
                                                              x489, x439, x473);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x492, &x493,
                                                              x491, x441, x475);
    x494 = ((uint32_t)x493 + x442);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x495, &x496, x5,
                                                         (arg2[7]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x497, &x498, x5,
                                                         (arg2[6]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x499, &x500, x5,
                                                         (arg2[5]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x501, &x502, x5,
                                                         (arg2[4]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x503, &x504, x5,
                                                         (arg2[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x505, &x506, x5,
                                                         (arg2[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x507, &x508, x5,
                                                         (arg2[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x509, &x510, x5,
                                                         (arg2[0]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x511, &x512, 0x0,
                                                              x510, x507);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x513, &x514,
                                                              x512, x508, x505);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x515, &x516,
                                                              x514, x506, x503);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x517, &x518,
                                                              x516, x504, x501);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x519, &x520,
                                                              x518, x502, x499);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x521, &x522,
                                                              x520, x500, x497);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x523, &x524,
                                                              x522, x498, x495);
    x525 = (x524 + x496);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x526, &x527, 0x0,
                                                              x478, x509);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x528, &x529,
                                                              x527, x480, x511);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x530, &x531,
                                                              x529, x482, x513);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x532, &x533,
                                                              x531, x484, x515);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x534, &x535,
                                                              x533, x486, x517);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x536, &x537,
                                                              x535, x488, x519);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x538, &x539,
                                                              x537, x490, x521);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x540, &x541,
                                                              x539, x492, x523);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x542, &x543,
                                                              x541, x494, x525);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x544, &x545, x526,
                                                         UINT32_C(0x727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x546, &x547, x544,
                                                         UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x548, &x549, x544,
                                                         UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x550, &x551, x544,
                                                         UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x552, &x553, x544,
                                                         UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x554, &x555, x544,
                                                         UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x556, &x557, x544,
                                                         UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x558, &x559, x544,
                                                         UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x560, &x561, x544,
                                                         UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x562, &x563, 0x0,
                                                              x561, x558);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x564, &x565,
                                                              x563, x559, x556);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x566, &x567,
                                                              x565, x557, x554);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x568, &x569,
                                                              x567, x555, x552);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x570, &x571,
                                                              x569, x553, x550);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x572, &x573,
                                                              x571, x551, x548);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x574, &x575,
                                                              x573, x549, x546);
    x576 = (x575 + x547);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x577, &x578, 0x0,
                                                              x526, x560);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x579, &x580,
                                                              x578, x528, x562);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x581, &x582,
                                                              x580, x530, x564);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x583, &x584,
                                                              x582, x532, x566);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x585, &x586,
                                                              x584, x534, x568);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x587, &x588,
                                                              x586, x536, x570);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x589, &x590,
                                                              x588, x538, x572);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x591, &x592,
                                                              x590, x540, x574);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x593, &x594,
                                                              x592, x542, x576);
    x595 = ((uint32_t)x594 + x543);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x596, &x597, x6,
                                                         (arg2[7]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x598, &x599, x6,
                                                         (arg2[6]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x600, &x601, x6,
                                                         (arg2[5]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x602, &x603, x6,
                                                         (arg2[4]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x604, &x605, x6,
                                                         (arg2[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x606, &x607, x6,
                                                         (arg2[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x608, &x609, x6,
                                                         (arg2[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x610, &x611, x6,
                                                         (arg2[0]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x612, &x613, 0x0,
                                                              x611, x608);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x614, &x615,
                                                              x613, x609, x606);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x616, &x617,
                                                              x615, x607, x604);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x618, &x619,
                                                              x617, x605, x602);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x620, &x621,
                                                              x619, x603, x600);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x622, &x623,
                                                              x621, x601, x598);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x624, &x625,
                                                              x623, x599, x596);
    x626 = (x625 + x597);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x627, &x628, 0x0,
                                                              x579, x610);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x629, &x630,
                                                              x628, x581, x612);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x631, &x632,
                                                              x630, x583, x614);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x633, &x634,
                                                              x632, x585, x616);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x635, &x636,
                                                              x634, x587, x618);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x637, &x638,
                                                              x636, x589, x620);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x639, &x640,
                                                              x638, x591, x622);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x641, &x642,
                                                              x640, x593, x624);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x643, &x644,
                                                              x642, x595, x626);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x645, &x646, x627,
                                                         UINT32_C(0x727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x647, &x648, x645,
                                                         UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x649, &x650, x645,
                                                         UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x651, &x652, x645,
                                                         UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x653, &x654, x645,
                                                         UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x655, &x656, x645,
                                                         UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x657, &x658, x645,
                                                         UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x659, &x660, x645,
                                                         UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x661, &x662, x645,
                                                         UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x663, &x664, 0x0,
                                                              x662, x659);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x665, &x666,
                                                              x664, x660, x657);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x667, &x668,
                                                              x666, x658, x655);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x669, &x670,
                                                              x668, x656, x653);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x671, &x672,
                                                              x670, x654, x651);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x673, &x674,
                                                              x672, x652, x649);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x675, &x676,
                                                              x674, x650, x647);
    x677 = (x676 + x648);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x678, &x679, 0x0,
                                                              x627, x661);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x680, &x681,
                                                              x679, x629, x663);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x682, &x683,
                                                              x681, x631, x665);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x684, &x685,
                                                              x683, x633, x667);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x686, &x687,
                                                              x685, x635, x669);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x688, &x689,
                                                              x687, x637, x671);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x690, &x691,
                                                              x689, x639, x673);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x692, &x693,
                                                              x691, x641, x675);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x694, &x695,
                                                              x693, x643, x677);
    x696 = ((uint32_t)x695 + x644);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x697, &x698, x7,
                                                         (arg2[7]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x699, &x700, x7,
                                                         (arg2[6]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x701, &x702, x7,
                                                         (arg2[5]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x703, &x704, x7,
                                                         (arg2[4]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x705, &x706, x7,
                                                         (arg2[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x707, &x708, x7,
                                                         (arg2[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x709, &x710, x7,
                                                         (arg2[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x711, &x712, x7,
                                                         (arg2[0]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x713, &x714, 0x0,
                                                              x712, x709);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x715, &x716,
                                                              x714, x710, x707);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x717, &x718,
                                                              x716, x708, x705);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x719, &x720,
                                                              x718, x706, x703);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x721, &x722,
                                                              x720, x704, x701);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x723, &x724,
                                                              x722, x702, x699);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x725, &x726,
                                                              x724, x700, x697);
    x727 = (x726 + x698);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x728, &x729, 0x0,
                                                              x680, x711);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x730, &x731,
                                                              x729, x682, x713);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x732, &x733,
                                                              x731, x684, x715);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x734, &x735,
                                                              x733, x686, x717);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x736, &x737,
                                                              x735, x688, x719);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x738, &x739,
                                                              x737, x690, x721);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x740, &x741,
                                                              x739, x692, x723);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x742, &x743,
                                                              x741, x694, x725);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x744, &x745,
                                                              x743, x696, x727);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x746, &x747, x728,
                                                         UINT32_C(0x727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x748, &x749, x746,
                                                         UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x750, &x751, x746,
                                                         UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x752, &x753, x746,
                                                         UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x754, &x755, x746,
                                                         UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x756, &x757, x746,
                                                         UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x758, &x759, x746,
                                                         UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x760, &x761, x746,
                                                         UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x762, &x763, x746,
                                                         UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x764, &x765, 0x0,
                                                              x763, x760);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x766, &x767,
                                                              x765, x761, x758);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x768, &x769,
                                                              x767, x759, x756);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x770, &x771,
                                                              x769, x757, x754);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x772, &x773,
                                                              x771, x755, x752);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x774, &x775,
                                                              x773, x753, x750);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x776, &x777,
                                                              x775, x751, x748);
    x778 = (x777 + x749);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x779, &x780, 0x0,
                                                              x728, x762);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x781, &x782,
                                                              x780, x730, x764);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x783, &x784,
                                                              x782, x732, x766);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x785, &x786,
                                                              x784, x734, x768);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x787, &x788,
                                                              x786, x736, x770);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x789, &x790,
                                                              x788, x738, x772);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x791, &x792,
                                                              x790, x740, x774);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x793, &x794,
                                                              x792, x742, x776);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x795, &x796,
                                                              x794, x744, x778);
    x797 = ((uint32_t)x796 + x745);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x798, &x799, 0x0, x781, UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x800, &x801, x799, x783, UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x802, &x803, x801, x785, UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x804, &x805, x803, x787, UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x806, &x807, x805, x789, UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x808, &x809, x807, x791, UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x810, &x811, x809, x793, UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x812, &x813, x811, x795, UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(&x814, &x815,
                                                               x813, x797, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x816, x815, x798,
                                                            x781);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x817, x815, x800,
                                                            x783);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x818, x815, x802,
                                                            x785);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x819, x815, x804,
                                                            x787);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x820, x815, x806,
                                                            x789);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x821, x815, x808,
                                                            x791);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x822, x815, x810,
                                                            x793);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x823, x815, x812,
                                                            x795);
    out1[0] = x816;
    out1[1] = x817;
    out1[2] = x818;
    out1[3] = x819;
    out1[4] = x820;
    out1[5] = x821;
    out1[6] = x822;
    out1[7] = x823;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square squares a field element in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(
    uint32_t out1[8], const uint32_t arg1[8]) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    uint32_t x9;
    uint32_t x10;
    uint32_t x11;
    uint32_t x12;
    uint32_t x13;
    uint32_t x14;
    uint32_t x15;
    uint32_t x16;
    uint32_t x17;
    uint32_t x18;
    uint32_t x19;
    uint32_t x20;
    uint32_t x21;
    uint32_t x22;
    uint32_t x23;
    uint32_t x24;
    uint32_t x25;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x26;
    uint32_t x27;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x28;
    uint32_t x29;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x30;
    uint32_t x31;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x32;
    uint32_t x33;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x34;
    uint32_t x35;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x36;
    uint32_t x37;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x38;
    uint32_t x39;
    uint32_t x40;
    uint32_t x41;
    uint32_t x42;
    uint32_t x43;
    uint32_t x44;
    uint32_t x45;
    uint32_t x46;
    uint32_t x47;
    uint32_t x48;
    uint32_t x49;
    uint32_t x50;
    uint32_t x51;
    uint32_t x52;
    uint32_t x53;
    uint32_t x54;
    uint32_t x55;
    uint32_t x56;
    uint32_t x57;
    uint32_t x58;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x59;
    uint32_t x60;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x61;
    uint32_t x62;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x63;
    uint32_t x64;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x65;
    uint32_t x66;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x67;
    uint32_t x68;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x69;
    uint32_t x70;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x71;
    uint32_t x72;
    uint32_t x73;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x74;
    uint32_t x75;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x76;
    uint32_t x77;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x78;
    uint32_t x79;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x80;
    uint32_t x81;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x82;
    uint32_t x83;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x84;
    uint32_t x85;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x86;
    uint32_t x87;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x88;
    uint32_t x89;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x90;
    uint32_t x91;
    uint32_t x92;
    uint32_t x93;
    uint32_t x94;
    uint32_t x95;
    uint32_t x96;
    uint32_t x97;
    uint32_t x98;
    uint32_t x99;
    uint32_t x100;
    uint32_t x101;
    uint32_t x102;
    uint32_t x103;
    uint32_t x104;
    uint32_t x105;
    uint32_t x106;
    uint32_t x107;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x108;
    uint32_t x109;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x110;
    uint32_t x111;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x112;
    uint32_t x113;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x114;
    uint32_t x115;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x116;
    uint32_t x117;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x118;
    uint32_t x119;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x120;
    uint32_t x121;
    uint32_t x122;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x123;
    uint32_t x124;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x125;
    uint32_t x126;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x127;
    uint32_t x128;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x129;
    uint32_t x130;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x131;
    uint32_t x132;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x133;
    uint32_t x134;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x135;
    uint32_t x136;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x137;
    uint32_t x138;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x139;
    uint32_t x140;
    uint32_t x141;
    uint32_t x142;
    uint32_t x143;
    uint32_t x144;
    uint32_t x145;
    uint32_t x146;
    uint32_t x147;
    uint32_t x148;
    uint32_t x149;
    uint32_t x150;
    uint32_t x151;
    uint32_t x152;
    uint32_t x153;
    uint32_t x154;
    uint32_t x155;
    uint32_t x156;
    uint32_t x157;
    uint32_t x158;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x159;
    uint32_t x160;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x161;
    uint32_t x162;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x163;
    uint32_t x164;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x165;
    uint32_t x166;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x167;
    uint32_t x168;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x169;
    uint32_t x170;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x171;
    uint32_t x172;
    uint32_t x173;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x174;
    uint32_t x175;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x176;
    uint32_t x177;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x178;
    uint32_t x179;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x180;
    uint32_t x181;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x182;
    uint32_t x183;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x184;
    uint32_t x185;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x186;
    uint32_t x187;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x188;
    uint32_t x189;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x190;
    uint32_t x191;
    uint32_t x192;
    uint32_t x193;
    uint32_t x194;
    uint32_t x195;
    uint32_t x196;
    uint32_t x197;
    uint32_t x198;
    uint32_t x199;
    uint32_t x200;
    uint32_t x201;
    uint32_t x202;
    uint32_t x203;
    uint32_t x204;
    uint32_t x205;
    uint32_t x206;
    uint32_t x207;
    uint32_t x208;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x209;
    uint32_t x210;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x211;
    uint32_t x212;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x213;
    uint32_t x214;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x215;
    uint32_t x216;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x217;
    uint32_t x218;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x219;
    uint32_t x220;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x221;
    uint32_t x222;
    uint32_t x223;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x224;
    uint32_t x225;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x226;
    uint32_t x227;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x228;
    uint32_t x229;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x230;
    uint32_t x231;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x232;
    uint32_t x233;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x234;
    uint32_t x235;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x236;
    uint32_t x237;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x238;
    uint32_t x239;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x240;
    uint32_t x241;
    uint32_t x242;
    uint32_t x243;
    uint32_t x244;
    uint32_t x245;
    uint32_t x246;
    uint32_t x247;
    uint32_t x248;
    uint32_t x249;
    uint32_t x250;
    uint32_t x251;
    uint32_t x252;
    uint32_t x253;
    uint32_t x254;
    uint32_t x255;
    uint32_t x256;
    uint32_t x257;
    uint32_t x258;
    uint32_t x259;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x260;
    uint32_t x261;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x262;
    uint32_t x263;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x264;
    uint32_t x265;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x266;
    uint32_t x267;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x268;
    uint32_t x269;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x270;
    uint32_t x271;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x272;
    uint32_t x273;
    uint32_t x274;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x275;
    uint32_t x276;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x277;
    uint32_t x278;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x279;
    uint32_t x280;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x281;
    uint32_t x282;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x283;
    uint32_t x284;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x285;
    uint32_t x286;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x287;
    uint32_t x288;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x289;
    uint32_t x290;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x291;
    uint32_t x292;
    uint32_t x293;
    uint32_t x294;
    uint32_t x295;
    uint32_t x296;
    uint32_t x297;
    uint32_t x298;
    uint32_t x299;
    uint32_t x300;
    uint32_t x301;
    uint32_t x302;
    uint32_t x303;
    uint32_t x304;
    uint32_t x305;
    uint32_t x306;
    uint32_t x307;
    uint32_t x308;
    uint32_t x309;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x310;
    uint32_t x311;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x312;
    uint32_t x313;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x314;
    uint32_t x315;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x316;
    uint32_t x317;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x318;
    uint32_t x319;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x320;
    uint32_t x321;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x322;
    uint32_t x323;
    uint32_t x324;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x325;
    uint32_t x326;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x327;
    uint32_t x328;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x329;
    uint32_t x330;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x331;
    uint32_t x332;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x333;
    uint32_t x334;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x335;
    uint32_t x336;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x337;
    uint32_t x338;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x339;
    uint32_t x340;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x341;
    uint32_t x342;
    uint32_t x343;
    uint32_t x344;
    uint32_t x345;
    uint32_t x346;
    uint32_t x347;
    uint32_t x348;
    uint32_t x349;
    uint32_t x350;
    uint32_t x351;
    uint32_t x352;
    uint32_t x353;
    uint32_t x354;
    uint32_t x355;
    uint32_t x356;
    uint32_t x357;
    uint32_t x358;
    uint32_t x359;
    uint32_t x360;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x361;
    uint32_t x362;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x363;
    uint32_t x364;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x365;
    uint32_t x366;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x367;
    uint32_t x368;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x369;
    uint32_t x370;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x371;
    uint32_t x372;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x373;
    uint32_t x374;
    uint32_t x375;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x376;
    uint32_t x377;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x378;
    uint32_t x379;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x380;
    uint32_t x381;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x382;
    uint32_t x383;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x384;
    uint32_t x385;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x386;
    uint32_t x387;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x388;
    uint32_t x389;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x390;
    uint32_t x391;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x392;
    uint32_t x393;
    uint32_t x394;
    uint32_t x395;
    uint32_t x396;
    uint32_t x397;
    uint32_t x398;
    uint32_t x399;
    uint32_t x400;
    uint32_t x401;
    uint32_t x402;
    uint32_t x403;
    uint32_t x404;
    uint32_t x405;
    uint32_t x406;
    uint32_t x407;
    uint32_t x408;
    uint32_t x409;
    uint32_t x410;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x411;
    uint32_t x412;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x413;
    uint32_t x414;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x415;
    uint32_t x416;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x417;
    uint32_t x418;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x419;
    uint32_t x420;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x421;
    uint32_t x422;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x423;
    uint32_t x424;
    uint32_t x425;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x426;
    uint32_t x427;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x428;
    uint32_t x429;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x430;
    uint32_t x431;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x432;
    uint32_t x433;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x434;
    uint32_t x435;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x436;
    uint32_t x437;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x438;
    uint32_t x439;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x440;
    uint32_t x441;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x442;
    uint32_t x443;
    uint32_t x444;
    uint32_t x445;
    uint32_t x446;
    uint32_t x447;
    uint32_t x448;
    uint32_t x449;
    uint32_t x450;
    uint32_t x451;
    uint32_t x452;
    uint32_t x453;
    uint32_t x454;
    uint32_t x455;
    uint32_t x456;
    uint32_t x457;
    uint32_t x458;
    uint32_t x459;
    uint32_t x460;
    uint32_t x461;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x462;
    uint32_t x463;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x464;
    uint32_t x465;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x466;
    uint32_t x467;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x468;
    uint32_t x469;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x470;
    uint32_t x471;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x472;
    uint32_t x473;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x474;
    uint32_t x475;
    uint32_t x476;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x477;
    uint32_t x478;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x479;
    uint32_t x480;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x481;
    uint32_t x482;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x483;
    uint32_t x484;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x485;
    uint32_t x486;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x487;
    uint32_t x488;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x489;
    uint32_t x490;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x491;
    uint32_t x492;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x493;
    uint32_t x494;
    uint32_t x495;
    uint32_t x496;
    uint32_t x497;
    uint32_t x498;
    uint32_t x499;
    uint32_t x500;
    uint32_t x501;
    uint32_t x502;
    uint32_t x503;
    uint32_t x504;
    uint32_t x505;
    uint32_t x506;
    uint32_t x507;
    uint32_t x508;
    uint32_t x509;
    uint32_t x510;
    uint32_t x511;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x512;
    uint32_t x513;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x514;
    uint32_t x515;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x516;
    uint32_t x517;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x518;
    uint32_t x519;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x520;
    uint32_t x521;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x522;
    uint32_t x523;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x524;
    uint32_t x525;
    uint32_t x526;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x527;
    uint32_t x528;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x529;
    uint32_t x530;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x531;
    uint32_t x532;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x533;
    uint32_t x534;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x535;
    uint32_t x536;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x537;
    uint32_t x538;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x539;
    uint32_t x540;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x541;
    uint32_t x542;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x543;
    uint32_t x544;
    uint32_t x545;
    uint32_t x546;
    uint32_t x547;
    uint32_t x548;
    uint32_t x549;
    uint32_t x550;
    uint32_t x551;
    uint32_t x552;
    uint32_t x553;
    uint32_t x554;
    uint32_t x555;
    uint32_t x556;
    uint32_t x557;
    uint32_t x558;
    uint32_t x559;
    uint32_t x560;
    uint32_t x561;
    uint32_t x562;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x563;
    uint32_t x564;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x565;
    uint32_t x566;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x567;
    uint32_t x568;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x569;
    uint32_t x570;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x571;
    uint32_t x572;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x573;
    uint32_t x574;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x575;
    uint32_t x576;
    uint32_t x577;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x578;
    uint32_t x579;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x580;
    uint32_t x581;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x582;
    uint32_t x583;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x584;
    uint32_t x585;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x586;
    uint32_t x587;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x588;
    uint32_t x589;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x590;
    uint32_t x591;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x592;
    uint32_t x593;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x594;
    uint32_t x595;
    uint32_t x596;
    uint32_t x597;
    uint32_t x598;
    uint32_t x599;
    uint32_t x600;
    uint32_t x601;
    uint32_t x602;
    uint32_t x603;
    uint32_t x604;
    uint32_t x605;
    uint32_t x606;
    uint32_t x607;
    uint32_t x608;
    uint32_t x609;
    uint32_t x610;
    uint32_t x611;
    uint32_t x612;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x613;
    uint32_t x614;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x615;
    uint32_t x616;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x617;
    uint32_t x618;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x619;
    uint32_t x620;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x621;
    uint32_t x622;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x623;
    uint32_t x624;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x625;
    uint32_t x626;
    uint32_t x627;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x628;
    uint32_t x629;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x630;
    uint32_t x631;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x632;
    uint32_t x633;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x634;
    uint32_t x635;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x636;
    uint32_t x637;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x638;
    uint32_t x639;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x640;
    uint32_t x641;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x642;
    uint32_t x643;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x644;
    uint32_t x645;
    uint32_t x646;
    uint32_t x647;
    uint32_t x648;
    uint32_t x649;
    uint32_t x650;
    uint32_t x651;
    uint32_t x652;
    uint32_t x653;
    uint32_t x654;
    uint32_t x655;
    uint32_t x656;
    uint32_t x657;
    uint32_t x658;
    uint32_t x659;
    uint32_t x660;
    uint32_t x661;
    uint32_t x662;
    uint32_t x663;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x664;
    uint32_t x665;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x666;
    uint32_t x667;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x668;
    uint32_t x669;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x670;
    uint32_t x671;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x672;
    uint32_t x673;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x674;
    uint32_t x675;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x676;
    uint32_t x677;
    uint32_t x678;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x679;
    uint32_t x680;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x681;
    uint32_t x682;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x683;
    uint32_t x684;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x685;
    uint32_t x686;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x687;
    uint32_t x688;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x689;
    uint32_t x690;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x691;
    uint32_t x692;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x693;
    uint32_t x694;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x695;
    uint32_t x696;
    uint32_t x697;
    uint32_t x698;
    uint32_t x699;
    uint32_t x700;
    uint32_t x701;
    uint32_t x702;
    uint32_t x703;
    uint32_t x704;
    uint32_t x705;
    uint32_t x706;
    uint32_t x707;
    uint32_t x708;
    uint32_t x709;
    uint32_t x710;
    uint32_t x711;
    uint32_t x712;
    uint32_t x713;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x714;
    uint32_t x715;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x716;
    uint32_t x717;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x718;
    uint32_t x719;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x720;
    uint32_t x721;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x722;
    uint32_t x723;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x724;
    uint32_t x725;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x726;
    uint32_t x727;
    uint32_t x728;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x729;
    uint32_t x730;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x731;
    uint32_t x732;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x733;
    uint32_t x734;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x735;
    uint32_t x736;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x737;
    uint32_t x738;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x739;
    uint32_t x740;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x741;
    uint32_t x742;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x743;
    uint32_t x744;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x745;
    uint32_t x746;
    uint32_t x747;
    uint32_t x748;
    uint32_t x749;
    uint32_t x750;
    uint32_t x751;
    uint32_t x752;
    uint32_t x753;
    uint32_t x754;
    uint32_t x755;
    uint32_t x756;
    uint32_t x757;
    uint32_t x758;
    uint32_t x759;
    uint32_t x760;
    uint32_t x761;
    uint32_t x762;
    uint32_t x763;
    uint32_t x764;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x765;
    uint32_t x766;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x767;
    uint32_t x768;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x769;
    uint32_t x770;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x771;
    uint32_t x772;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x773;
    uint32_t x774;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x775;
    uint32_t x776;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x777;
    uint32_t x778;
    uint32_t x779;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x780;
    uint32_t x781;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x782;
    uint32_t x783;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x784;
    uint32_t x785;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x786;
    uint32_t x787;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x788;
    uint32_t x789;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x790;
    uint32_t x791;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x792;
    uint32_t x793;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x794;
    uint32_t x795;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x796;
    uint32_t x797;
    uint32_t x798;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x799;
    uint32_t x800;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x801;
    uint32_t x802;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x803;
    uint32_t x804;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x805;
    uint32_t x806;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x807;
    uint32_t x808;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x809;
    uint32_t x810;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x811;
    uint32_t x812;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x813;
    uint32_t x814;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x815;
    uint32_t x816;
    uint32_t x817;
    uint32_t x818;
    uint32_t x819;
    uint32_t x820;
    uint32_t x821;
    uint32_t x822;
    uint32_t x823;
    x1 = (arg1[1]);
    x2 = (arg1[2]);
    x3 = (arg1[3]);
    x4 = (arg1[4]);
    x5 = (arg1[5]);
    x6 = (arg1[6]);
    x7 = (arg1[7]);
    x8 = (arg1[0]);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x9, &x10, x8,
                                                         (arg1[7]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x11, &x12, x8,
                                                         (arg1[6]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x13, &x14, x8,
                                                         (arg1[5]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x15, &x16, x8,
                                                         (arg1[4]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x17, &x18, x8,
                                                         (arg1[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x19, &x20, x8,
                                                         (arg1[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x21, &x22, x8,
                                                         (arg1[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x23, &x24, x8,
                                                         (arg1[0]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x25, &x26, 0x0,
                                                              x24, x21);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x27, &x28, x26,
                                                              x22, x19);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x29, &x30, x28,
                                                              x20, x17);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x31, &x32, x30,
                                                              x18, x15);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x33, &x34, x32,
                                                              x16, x13);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x35, &x36, x34,
                                                              x14, x11);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x37, &x38, x36,
                                                              x12, x9);
    x39 = (x38 + x10);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x40, &x41, x23,
                                                         UINT32_C(0x727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x42, &x43, x40,
                                                         UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x44, &x45, x40,
                                                         UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x46, &x47, x40,
                                                         UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x48, &x49, x40,
                                                         UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x50, &x51, x40,
                                                         UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x52, &x53, x40,
                                                         UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x54, &x55, x40,
                                                         UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x56, &x57, x40,
                                                         UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x58, &x59, 0x0,
                                                              x57, x54);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x60, &x61, x59,
                                                              x55, x52);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x62, &x63, x61,
                                                              x53, x50);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x64, &x65, x63,
                                                              x51, x48);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x66, &x67, x65,
                                                              x49, x46);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x68, &x69, x67,
                                                              x47, x44);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x70, &x71, x69,
                                                              x45, x42);
    x72 = (x71 + x43);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x73, &x74, 0x0,
                                                              x23, x56);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x75, &x76, x74,
                                                              x25, x58);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x77, &x78, x76,
                                                              x27, x60);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x79, &x80, x78,
                                                              x29, x62);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x81, &x82, x80,
                                                              x31, x64);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x83, &x84, x82,
                                                              x33, x66);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x85, &x86, x84,
                                                              x35, x68);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x87, &x88, x86,
                                                              x37, x70);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x89, &x90, x88,
                                                              x39, x72);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x91, &x92, x1,
                                                         (arg1[7]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x93, &x94, x1,
                                                         (arg1[6]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x95, &x96, x1,
                                                         (arg1[5]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x97, &x98, x1,
                                                         (arg1[4]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x99, &x100, x1,
                                                         (arg1[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x101, &x102, x1,
                                                         (arg1[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x103, &x104, x1,
                                                         (arg1[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x105, &x106, x1,
                                                         (arg1[0]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x107, &x108, 0x0,
                                                              x106, x103);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x109, &x110,
                                                              x108, x104, x101);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x111, &x112,
                                                              x110, x102, x99);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x113, &x114,
                                                              x112, x100, x97);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x115, &x116,
                                                              x114, x98, x95);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x117, &x118,
                                                              x116, x96, x93);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x119, &x120,
                                                              x118, x94, x91);
    x121 = (x120 + x92);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x122, &x123, 0x0,
                                                              x75, x105);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x124, &x125,
                                                              x123, x77, x107);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x126, &x127,
                                                              x125, x79, x109);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x128, &x129,
                                                              x127, x81, x111);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x130, &x131,
                                                              x129, x83, x113);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x132, &x133,
                                                              x131, x85, x115);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x134, &x135,
                                                              x133, x87, x117);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x136, &x137,
                                                              x135, x89, x119);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x138, &x139,
                                                              x137, x90, x121);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x140, &x141, x122,
                                                         UINT32_C(0x727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x142, &x143, x140,
                                                         UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x144, &x145, x140,
                                                         UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x146, &x147, x140,
                                                         UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x148, &x149, x140,
                                                         UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x150, &x151, x140,
                                                         UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x152, &x153, x140,
                                                         UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x154, &x155, x140,
                                                         UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x156, &x157, x140,
                                                         UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x158, &x159, 0x0,
                                                              x157, x154);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x160, &x161,
                                                              x159, x155, x152);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x162, &x163,
                                                              x161, x153, x150);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x164, &x165,
                                                              x163, x151, x148);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x166, &x167,
                                                              x165, x149, x146);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x168, &x169,
                                                              x167, x147, x144);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x170, &x171,
                                                              x169, x145, x142);
    x172 = (x171 + x143);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x173, &x174, 0x0,
                                                              x122, x156);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x175, &x176,
                                                              x174, x124, x158);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x177, &x178,
                                                              x176, x126, x160);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x179, &x180,
                                                              x178, x128, x162);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x181, &x182,
                                                              x180, x130, x164);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x183, &x184,
                                                              x182, x132, x166);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x185, &x186,
                                                              x184, x134, x168);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x187, &x188,
                                                              x186, x136, x170);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x189, &x190,
                                                              x188, x138, x172);
    x191 = ((uint32_t)x190 + x139);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x192, &x193, x2,
                                                         (arg1[7]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x194, &x195, x2,
                                                         (arg1[6]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x196, &x197, x2,
                                                         (arg1[5]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x198, &x199, x2,
                                                         (arg1[4]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x200, &x201, x2,
                                                         (arg1[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x202, &x203, x2,
                                                         (arg1[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x204, &x205, x2,
                                                         (arg1[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x206, &x207, x2,
                                                         (arg1[0]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x208, &x209, 0x0,
                                                              x207, x204);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x210, &x211,
                                                              x209, x205, x202);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x212, &x213,
                                                              x211, x203, x200);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x214, &x215,
                                                              x213, x201, x198);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x216, &x217,
                                                              x215, x199, x196);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x218, &x219,
                                                              x217, x197, x194);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x220, &x221,
                                                              x219, x195, x192);
    x222 = (x221 + x193);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x223, &x224, 0x0,
                                                              x175, x206);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x225, &x226,
                                                              x224, x177, x208);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x227, &x228,
                                                              x226, x179, x210);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x229, &x230,
                                                              x228, x181, x212);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x231, &x232,
                                                              x230, x183, x214);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x233, &x234,
                                                              x232, x185, x216);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x235, &x236,
                                                              x234, x187, x218);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x237, &x238,
                                                              x236, x189, x220);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x239, &x240,
                                                              x238, x191, x222);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x241, &x242, x223,
                                                         UINT32_C(0x727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x243, &x244, x241,
                                                         UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x245, &x246, x241,
                                                         UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x247, &x248, x241,
                                                         UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x249, &x250, x241,
                                                         UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x251, &x252, x241,
                                                         UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x253, &x254, x241,
                                                         UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x255, &x256, x241,
                                                         UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x257, &x258, x241,
                                                         UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x259, &x260, 0x0,
                                                              x258, x255);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x261, &x262,
                                                              x260, x256, x253);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x263, &x264,
                                                              x262, x254, x251);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x265, &x266,
                                                              x264, x252, x249);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x267, &x268,
                                                              x266, x250, x247);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x269, &x270,
                                                              x268, x248, x245);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x271, &x272,
                                                              x270, x246, x243);
    x273 = (x272 + x244);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x274, &x275, 0x0,
                                                              x223, x257);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x276, &x277,
                                                              x275, x225, x259);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x278, &x279,
                                                              x277, x227, x261);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x280, &x281,
                                                              x279, x229, x263);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x282, &x283,
                                                              x281, x231, x265);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x284, &x285,
                                                              x283, x233, x267);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x286, &x287,
                                                              x285, x235, x269);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x288, &x289,
                                                              x287, x237, x271);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x290, &x291,
                                                              x289, x239, x273);
    x292 = ((uint32_t)x291 + x240);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x293, &x294, x3,
                                                         (arg1[7]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x295, &x296, x3,
                                                         (arg1[6]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x297, &x298, x3,
                                                         (arg1[5]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x299, &x300, x3,
                                                         (arg1[4]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x301, &x302, x3,
                                                         (arg1[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x303, &x304, x3,
                                                         (arg1[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x305, &x306, x3,
                                                         (arg1[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x307, &x308, x3,
                                                         (arg1[0]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x309, &x310, 0x0,
                                                              x308, x305);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x311, &x312,
                                                              x310, x306, x303);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x313, &x314,
                                                              x312, x304, x301);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x315, &x316,
                                                              x314, x302, x299);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x317, &x318,
                                                              x316, x300, x297);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x319, &x320,
                                                              x318, x298, x295);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x321, &x322,
                                                              x320, x296, x293);
    x323 = (x322 + x294);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x324, &x325, 0x0,
                                                              x276, x307);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x326, &x327,
                                                              x325, x278, x309);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x328, &x329,
                                                              x327, x280, x311);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x330, &x331,
                                                              x329, x282, x313);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x332, &x333,
                                                              x331, x284, x315);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x334, &x335,
                                                              x333, x286, x317);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x336, &x337,
                                                              x335, x288, x319);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x338, &x339,
                                                              x337, x290, x321);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x340, &x341,
                                                              x339, x292, x323);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x342, &x343, x324,
                                                         UINT32_C(0x727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x344, &x345, x342,
                                                         UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x346, &x347, x342,
                                                         UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x348, &x349, x342,
                                                         UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x350, &x351, x342,
                                                         UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x352, &x353, x342,
                                                         UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x354, &x355, x342,
                                                         UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x356, &x357, x342,
                                                         UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x358, &x359, x342,
                                                         UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x360, &x361, 0x0,
                                                              x359, x356);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x362, &x363,
                                                              x361, x357, x354);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x364, &x365,
                                                              x363, x355, x352);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x366, &x367,
                                                              x365, x353, x350);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x368, &x369,
                                                              x367, x351, x348);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x370, &x371,
                                                              x369, x349, x346);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x372, &x373,
                                                              x371, x347, x344);
    x374 = (x373 + x345);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x375, &x376, 0x0,
                                                              x324, x358);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x377, &x378,
                                                              x376, x326, x360);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x379, &x380,
                                                              x378, x328, x362);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x381, &x382,
                                                              x380, x330, x364);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x383, &x384,
                                                              x382, x332, x366);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x385, &x386,
                                                              x384, x334, x368);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x387, &x388,
                                                              x386, x336, x370);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x389, &x390,
                                                              x388, x338, x372);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x391, &x392,
                                                              x390, x340, x374);
    x393 = ((uint32_t)x392 + x341);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x394, &x395, x4,
                                                         (arg1[7]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x396, &x397, x4,
                                                         (arg1[6]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x398, &x399, x4,
                                                         (arg1[5]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x400, &x401, x4,
                                                         (arg1[4]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x402, &x403, x4,
                                                         (arg1[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x404, &x405, x4,
                                                         (arg1[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x406, &x407, x4,
                                                         (arg1[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x408, &x409, x4,
                                                         (arg1[0]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x410, &x411, 0x0,
                                                              x409, x406);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x412, &x413,
                                                              x411, x407, x404);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x414, &x415,
                                                              x413, x405, x402);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x416, &x417,
                                                              x415, x403, x400);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x418, &x419,
                                                              x417, x401, x398);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x420, &x421,
                                                              x419, x399, x396);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x422, &x423,
                                                              x421, x397, x394);
    x424 = (x423 + x395);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x425, &x426, 0x0,
                                                              x377, x408);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x427, &x428,
                                                              x426, x379, x410);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x429, &x430,
                                                              x428, x381, x412);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x431, &x432,
                                                              x430, x383, x414);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x433, &x434,
                                                              x432, x385, x416);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x435, &x436,
                                                              x434, x387, x418);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x437, &x438,
                                                              x436, x389, x420);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x439, &x440,
                                                              x438, x391, x422);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x441, &x442,
                                                              x440, x393, x424);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x443, &x444, x425,
                                                         UINT32_C(0x727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x445, &x446, x443,
                                                         UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x447, &x448, x443,
                                                         UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x449, &x450, x443,
                                                         UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x451, &x452, x443,
                                                         UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x453, &x454, x443,
                                                         UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x455, &x456, x443,
                                                         UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x457, &x458, x443,
                                                         UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x459, &x460, x443,
                                                         UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x461, &x462, 0x0,
                                                              x460, x457);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x463, &x464,
                                                              x462, x458, x455);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x465, &x466,
                                                              x464, x456, x453);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x467, &x468,
                                                              x466, x454, x451);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x469, &x470,
                                                              x468, x452, x449);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x471, &x472,
                                                              x470, x450, x447);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x473, &x474,
                                                              x472, x448, x445);
    x475 = (x474 + x446);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x476, &x477, 0x0,
                                                              x425, x459);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x478, &x479,
                                                              x477, x427, x461);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x480, &x481,
                                                              x479, x429, x463);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x482, &x483,
                                                              x481, x431, x465);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x484, &x485,
                                                              x483, x433, x467);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x486, &x487,
                                                              x485, x435, x469);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x488, &x489,
                                                              x487, x437, x471);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x490, &x491,
                                                              x489, x439, x473);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x492, &x493,
                                                              x491, x441, x475);
    x494 = ((uint32_t)x493 + x442);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x495, &x496, x5,
                                                         (arg1[7]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x497, &x498, x5,
                                                         (arg1[6]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x499, &x500, x5,
                                                         (arg1[5]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x501, &x502, x5,
                                                         (arg1[4]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x503, &x504, x5,
                                                         (arg1[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x505, &x506, x5,
                                                         (arg1[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x507, &x508, x5,
                                                         (arg1[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x509, &x510, x5,
                                                         (arg1[0]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x511, &x512, 0x0,
                                                              x510, x507);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x513, &x514,
                                                              x512, x508, x505);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x515, &x516,
                                                              x514, x506, x503);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x517, &x518,
                                                              x516, x504, x501);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x519, &x520,
                                                              x518, x502, x499);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x521, &x522,
                                                              x520, x500, x497);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x523, &x524,
                                                              x522, x498, x495);
    x525 = (x524 + x496);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x526, &x527, 0x0,
                                                              x478, x509);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x528, &x529,
                                                              x527, x480, x511);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x530, &x531,
                                                              x529, x482, x513);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x532, &x533,
                                                              x531, x484, x515);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x534, &x535,
                                                              x533, x486, x517);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x536, &x537,
                                                              x535, x488, x519);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x538, &x539,
                                                              x537, x490, x521);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x540, &x541,
                                                              x539, x492, x523);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x542, &x543,
                                                              x541, x494, x525);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x544, &x545, x526,
                                                         UINT32_C(0x727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x546, &x547, x544,
                                                         UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x548, &x549, x544,
                                                         UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x550, &x551, x544,
                                                         UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x552, &x553, x544,
                                                         UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x554, &x555, x544,
                                                         UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x556, &x557, x544,
                                                         UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x558, &x559, x544,
                                                         UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x560, &x561, x544,
                                                         UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x562, &x563, 0x0,
                                                              x561, x558);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x564, &x565,
                                                              x563, x559, x556);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x566, &x567,
                                                              x565, x557, x554);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x568, &x569,
                                                              x567, x555, x552);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x570, &x571,
                                                              x569, x553, x550);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x572, &x573,
                                                              x571, x551, x548);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x574, &x575,
                                                              x573, x549, x546);
    x576 = (x575 + x547);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x577, &x578, 0x0,
                                                              x526, x560);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x579, &x580,
                                                              x578, x528, x562);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x581, &x582,
                                                              x580, x530, x564);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x583, &x584,
                                                              x582, x532, x566);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x585, &x586,
                                                              x584, x534, x568);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x587, &x588,
                                                              x586, x536, x570);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x589, &x590,
                                                              x588, x538, x572);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x591, &x592,
                                                              x590, x540, x574);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x593, &x594,
                                                              x592, x542, x576);
    x595 = ((uint32_t)x594 + x543);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x596, &x597, x6,
                                                         (arg1[7]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x598, &x599, x6,
                                                         (arg1[6]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x600, &x601, x6,
                                                         (arg1[5]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x602, &x603, x6,
                                                         (arg1[4]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x604, &x605, x6,
                                                         (arg1[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x606, &x607, x6,
                                                         (arg1[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x608, &x609, x6,
                                                         (arg1[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x610, &x611, x6,
                                                         (arg1[0]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x612, &x613, 0x0,
                                                              x611, x608);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x614, &x615,
                                                              x613, x609, x606);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x616, &x617,
                                                              x615, x607, x604);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x618, &x619,
                                                              x617, x605, x602);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x620, &x621,
                                                              x619, x603, x600);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x622, &x623,
                                                              x621, x601, x598);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x624, &x625,
                                                              x623, x599, x596);
    x626 = (x625 + x597);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x627, &x628, 0x0,
                                                              x579, x610);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x629, &x630,
                                                              x628, x581, x612);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x631, &x632,
                                                              x630, x583, x614);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x633, &x634,
                                                              x632, x585, x616);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x635, &x636,
                                                              x634, x587, x618);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x637, &x638,
                                                              x636, x589, x620);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x639, &x640,
                                                              x638, x591, x622);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x641, &x642,
                                                              x640, x593, x624);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x643, &x644,
                                                              x642, x595, x626);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x645, &x646, x627,
                                                         UINT32_C(0x727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x647, &x648, x645,
                                                         UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x649, &x650, x645,
                                                         UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x651, &x652, x645,
                                                         UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x653, &x654, x645,
                                                         UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x655, &x656, x645,
                                                         UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x657, &x658, x645,
                                                         UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x659, &x660, x645,
                                                         UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x661, &x662, x645,
                                                         UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x663, &x664, 0x0,
                                                              x662, x659);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x665, &x666,
                                                              x664, x660, x657);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x667, &x668,
                                                              x666, x658, x655);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x669, &x670,
                                                              x668, x656, x653);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x671, &x672,
                                                              x670, x654, x651);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x673, &x674,
                                                              x672, x652, x649);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x675, &x676,
                                                              x674, x650, x647);
    x677 = (x676 + x648);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x678, &x679, 0x0,
                                                              x627, x661);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x680, &x681,
                                                              x679, x629, x663);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x682, &x683,
                                                              x681, x631, x665);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x684, &x685,
                                                              x683, x633, x667);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x686, &x687,
                                                              x685, x635, x669);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x688, &x689,
                                                              x687, x637, x671);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x690, &x691,
                                                              x689, x639, x673);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x692, &x693,
                                                              x691, x641, x675);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x694, &x695,
                                                              x693, x643, x677);
    x696 = ((uint32_t)x695 + x644);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x697, &x698, x7,
                                                         (arg1[7]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x699, &x700, x7,
                                                         (arg1[6]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x701, &x702, x7,
                                                         (arg1[5]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x703, &x704, x7,
                                                         (arg1[4]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x705, &x706, x7,
                                                         (arg1[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x707, &x708, x7,
                                                         (arg1[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x709, &x710, x7,
                                                         (arg1[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x711, &x712, x7,
                                                         (arg1[0]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x713, &x714, 0x0,
                                                              x712, x709);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x715, &x716,
                                                              x714, x710, x707);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x717, &x718,
                                                              x716, x708, x705);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x719, &x720,
                                                              x718, x706, x703);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x721, &x722,
                                                              x720, x704, x701);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x723, &x724,
                                                              x722, x702, x699);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x725, &x726,
                                                              x724, x700, x697);
    x727 = (x726 + x698);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x728, &x729, 0x0,
                                                              x680, x711);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x730, &x731,
                                                              x729, x682, x713);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x732, &x733,
                                                              x731, x684, x715);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x734, &x735,
                                                              x733, x686, x717);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x736, &x737,
                                                              x735, x688, x719);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x738, &x739,
                                                              x737, x690, x721);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x740, &x741,
                                                              x739, x692, x723);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x742, &x743,
                                                              x741, x694, x725);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x744, &x745,
                                                              x743, x696, x727);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x746, &x747, x728,
                                                         UINT32_C(0x727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x748, &x749, x746,
                                                         UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x750, &x751, x746,
                                                         UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x752, &x753, x746,
                                                         UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x754, &x755, x746,
                                                         UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x756, &x757, x746,
                                                         UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x758, &x759, x746,
                                                         UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x760, &x761, x746,
                                                         UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x762, &x763, x746,
                                                         UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x764, &x765, 0x0,
                                                              x763, x760);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x766, &x767,
                                                              x765, x761, x758);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x768, &x769,
                                                              x767, x759, x756);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x770, &x771,
                                                              x769, x757, x754);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x772, &x773,
                                                              x771, x755, x752);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x774, &x775,
                                                              x773, x753, x750);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x776, &x777,
                                                              x775, x751, x748);
    x778 = (x777 + x749);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x779, &x780, 0x0,
                                                              x728, x762);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x781, &x782,
                                                              x780, x730, x764);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x783, &x784,
                                                              x782, x732, x766);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x785, &x786,
                                                              x784, x734, x768);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x787, &x788,
                                                              x786, x736, x770);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x789, &x790,
                                                              x788, x738, x772);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x791, &x792,
                                                              x790, x740, x774);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x793, &x794,
                                                              x792, x742, x776);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x795, &x796,
                                                              x794, x744, x778);
    x797 = ((uint32_t)x796 + x745);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x798, &x799, 0x0, x781, UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x800, &x801, x799, x783, UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x802, &x803, x801, x785, UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x804, &x805, x803, x787, UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x806, &x807, x805, x789, UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x808, &x809, x807, x791, UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x810, &x811, x809, x793, UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x812, &x813, x811, x795, UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(&x814, &x815,
                                                               x813, x797, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x816, x815, x798,
                                                            x781);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x817, x815, x800,
                                                            x783);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x818, x815, x802,
                                                            x785);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x819, x815, x804,
                                                            x787);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x820, x815, x806,
                                                            x789);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x821, x815, x808,
                                                            x791);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x822, x815, x810,
                                                            x793);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x823, x815, x812,
                                                            x795);
    out1[0] = x816;
    out1[1] = x817;
    out1[2] = x818;
    out1[3] = x819;
    out1[4] = x820;
    out1[5] = x821;
    out1[6] = x822;
    out1[7] = x823;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add adds two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(
    uint32_t out1[8], const uint32_t arg1[8], const uint32_t arg2[8]) {
    uint32_t x1;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x2;
    uint32_t x3;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x4;
    uint32_t x5;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x6;
    uint32_t x7;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x8;
    uint32_t x9;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x10;
    uint32_t x11;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x12;
    uint32_t x13;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x14;
    uint32_t x15;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x16;
    uint32_t x17;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x18;
    uint32_t x19;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x20;
    uint32_t x21;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x22;
    uint32_t x23;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x24;
    uint32_t x25;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x26;
    uint32_t x27;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x28;
    uint32_t x29;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x30;
    uint32_t x31;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x32;
    uint32_t x33;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x34;
    uint32_t x35;
    uint32_t x36;
    uint32_t x37;
    uint32_t x38;
    uint32_t x39;
    uint32_t x40;
    uint32_t x41;
    uint32_t x42;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x1, &x2, 0x0, (arg1[0]), (arg2[0]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x3, &x4, x2, (arg1[1]), (arg2[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x5, &x6, x4, (arg1[2]), (arg2[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x7, &x8, x6, (arg1[3]), (arg2[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x9, &x10, x8, (arg1[4]), (arg2[4]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x11, &x12, x10, (arg1[5]), (arg2[5]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x13, &x14, x12, (arg1[6]), (arg2[6]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x15, &x16, x14, (arg1[7]), (arg2[7]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x17, &x18, 0x0, x1, UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x19, &x20, x18, x3, UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x21, &x22, x20, x5, UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x23, &x24, x22, x7, UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x25, &x26, x24, x9, UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x27, &x28, x26, x11, UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x29, &x30, x28, x13, UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x31, &x32, x30, x15, UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(&x33, &x34, x32,
                                                               x16, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x35, x34, x17, x1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x36, x34, x19, x3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x37, x34, x21, x5);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x38, x34, x23, x7);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x39, x34, x25, x9);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x40, x34, x27,
                                                            x11);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x41, x34, x29,
                                                            x13);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x42, x34, x31,
                                                            x15);
    out1[0] = x35;
    out1[1] = x36;
    out1[2] = x37;
    out1[3] = x38;
    out1[4] = x39;
    out1[5] = x40;
    out1[6] = x41;
    out1[7] = x42;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub subtracts two field elements in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 *   0 ≤ eval arg2 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(
    uint32_t out1[8], const uint32_t arg1[8], const uint32_t arg2[8]) {
    uint32_t x1;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x2;
    uint32_t x3;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x4;
    uint32_t x5;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x6;
    uint32_t x7;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x8;
    uint32_t x9;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x10;
    uint32_t x11;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x12;
    uint32_t x13;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x14;
    uint32_t x15;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x16;
    uint32_t x17;
    uint32_t x18;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x19;
    uint32_t x20;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x21;
    uint32_t x22;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x23;
    uint32_t x24;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x25;
    uint32_t x26;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x27;
    uint32_t x28;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x29;
    uint32_t x30;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x31;
    uint32_t x32;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x33;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x1, &x2, 0x0, (arg1[0]), (arg2[0]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x3, &x4, x2, (arg1[1]), (arg2[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x5, &x6, x4, (arg1[2]), (arg2[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x7, &x8, x6, (arg1[3]), (arg2[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x9, &x10, x8, (arg1[4]), (arg2[4]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x11, &x12, x10, (arg1[5]), (arg2[5]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x13, &x14, x12, (arg1[6]), (arg2[6]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x15, &x16, x14, (arg1[7]), (arg2[7]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(
        &x17, x16, 0x0, UINT32_C(0xffffffff));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x18, &x19, 0x0, x1, (x17 & UINT32_C(0x22d759b)));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x20, &x21, x19, x3, (x17 & UINT32_C(0x7998f7b9)));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x22, &x23, x21, x5, (x17 & UINT32_C(0x789051d3)));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x24, &x25, x23, x7, (x17 & UINT32_C(0xcf846e86)));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x26, &x27, x25, x9, (x17 & UINT32_C(0x6b41c8aa)));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x28, &x29, x27, x11, (x17 & UINT32_C(0xab1ec85e)));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x30, &x31, x29, x13, (x17 & UINT32_C(0x5a858107)));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x32, &x33, x31, x15, (x17 & UINT32_C(0x9b9f605f)));
    out1[0] = x18;
    out1[1] = x20;
    out1[2] = x22;
    out1[3] = x24;
    out1[4] = x26;
    out1[5] = x28;
    out1[6] = x30;
    out1[7] = x32;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_opp negates a field element in the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_opp(
    uint32_t out1[8], const uint32_t arg1[8]) {
    uint32_t x1;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x2;
    uint32_t x3;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x4;
    uint32_t x5;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x6;
    uint32_t x7;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x8;
    uint32_t x9;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x10;
    uint32_t x11;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x12;
    uint32_t x13;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x14;
    uint32_t x15;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x16;
    uint32_t x17;
    uint32_t x18;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x19;
    uint32_t x20;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x21;
    uint32_t x22;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x23;
    uint32_t x24;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x25;
    uint32_t x26;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x27;
    uint32_t x28;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x29;
    uint32_t x30;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x31;
    uint32_t x32;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x33;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(&x1, &x2, 0x0,
                                                               0x0, (arg1[0]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(&x3, &x4, x2,
                                                               0x0, (arg1[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(&x5, &x6, x4,
                                                               0x0, (arg1[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(&x7, &x8, x6,
                                                               0x0, (arg1[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(&x9, &x10, x8,
                                                               0x0, (arg1[4]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(&x11, &x12, x10,
                                                               0x0, (arg1[5]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(&x13, &x14, x12,
                                                               0x0, (arg1[6]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(&x15, &x16, x14,
                                                               0x0, (arg1[7]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(
        &x17, x16, 0x0, UINT32_C(0xffffffff));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x18, &x19, 0x0, x1, (x17 & UINT32_C(0x22d759b)));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x20, &x21, x19, x3, (x17 & UINT32_C(0x7998f7b9)));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x22, &x23, x21, x5, (x17 & UINT32_C(0x789051d3)));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x24, &x25, x23, x7, (x17 & UINT32_C(0xcf846e86)));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x26, &x27, x25, x9, (x17 & UINT32_C(0x6b41c8aa)));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x28, &x29, x27, x11, (x17 & UINT32_C(0xab1ec85e)));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x30, &x31, x29, x13, (x17 & UINT32_C(0x5a858107)));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x32, &x33, x31, x15, (x17 & UINT32_C(0x9b9f605f)));
    out1[0] = x18;
    out1[1] = x20;
    out1[2] = x22;
    out1[3] = x24;
    out1[4] = x26;
    out1[5] = x28;
    out1[6] = x30;
    out1[7] = x32;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_from_montgomery translates a field element out of the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval out1 mod m = (eval arg1 * ((2^32)⁻¹ mod m)^8) mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_from_montgomery(
    uint32_t out1[8], const uint32_t arg1[8]) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    uint32_t x9;
    uint32_t x10;
    uint32_t x11;
    uint32_t x12;
    uint32_t x13;
    uint32_t x14;
    uint32_t x15;
    uint32_t x16;
    uint32_t x17;
    uint32_t x18;
    uint32_t x19;
    uint32_t x20;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x21;
    uint32_t x22;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x23;
    uint32_t x24;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x25;
    uint32_t x26;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x27;
    uint32_t x28;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x29;
    uint32_t x30;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x31;
    uint32_t x32;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x33;
    uint32_t x34;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x35;
    uint32_t x36;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x37;
    uint32_t x38;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x39;
    uint32_t x40;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x41;
    uint32_t x42;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x43;
    uint32_t x44;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x45;
    uint32_t x46;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x47;
    uint32_t x48;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x49;
    uint32_t x50;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x51;
    uint32_t x52;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x53;
    uint32_t x54;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x55;
    uint32_t x56;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x57;
    uint32_t x58;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x59;
    uint32_t x60;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x61;
    uint32_t x62;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x63;
    uint32_t x64;
    uint32_t x65;
    uint32_t x66;
    uint32_t x67;
    uint32_t x68;
    uint32_t x69;
    uint32_t x70;
    uint32_t x71;
    uint32_t x72;
    uint32_t x73;
    uint32_t x74;
    uint32_t x75;
    uint32_t x76;
    uint32_t x77;
    uint32_t x78;
    uint32_t x79;
    uint32_t x80;
    uint32_t x81;
    uint32_t x82;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x83;
    uint32_t x84;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x85;
    uint32_t x86;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x87;
    uint32_t x88;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x89;
    uint32_t x90;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x91;
    uint32_t x92;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x93;
    uint32_t x94;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x95;
    uint32_t x96;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x97;
    uint32_t x98;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x99;
    uint32_t x100;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x101;
    uint32_t x102;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x103;
    uint32_t x104;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x105;
    uint32_t x106;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x107;
    uint32_t x108;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x109;
    uint32_t x110;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x111;
    uint32_t x112;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x113;
    uint32_t x114;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x115;
    uint32_t x116;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x117;
    uint32_t x118;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x119;
    uint32_t x120;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x121;
    uint32_t x122;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x123;
    uint32_t x124;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x125;
    uint32_t x126;
    uint32_t x127;
    uint32_t x128;
    uint32_t x129;
    uint32_t x130;
    uint32_t x131;
    uint32_t x132;
    uint32_t x133;
    uint32_t x134;
    uint32_t x135;
    uint32_t x136;
    uint32_t x137;
    uint32_t x138;
    uint32_t x139;
    uint32_t x140;
    uint32_t x141;
    uint32_t x142;
    uint32_t x143;
    uint32_t x144;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x145;
    uint32_t x146;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x147;
    uint32_t x148;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x149;
    uint32_t x150;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x151;
    uint32_t x152;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x153;
    uint32_t x154;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x155;
    uint32_t x156;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x157;
    uint32_t x158;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x159;
    uint32_t x160;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x161;
    uint32_t x162;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x163;
    uint32_t x164;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x165;
    uint32_t x166;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x167;
    uint32_t x168;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x169;
    uint32_t x170;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x171;
    uint32_t x172;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x173;
    uint32_t x174;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x175;
    uint32_t x176;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x177;
    uint32_t x178;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x179;
    uint32_t x180;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x181;
    uint32_t x182;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x183;
    uint32_t x184;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x185;
    uint32_t x186;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x187;
    uint32_t x188;
    uint32_t x189;
    uint32_t x190;
    uint32_t x191;
    uint32_t x192;
    uint32_t x193;
    uint32_t x194;
    uint32_t x195;
    uint32_t x196;
    uint32_t x197;
    uint32_t x198;
    uint32_t x199;
    uint32_t x200;
    uint32_t x201;
    uint32_t x202;
    uint32_t x203;
    uint32_t x204;
    uint32_t x205;
    uint32_t x206;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x207;
    uint32_t x208;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x209;
    uint32_t x210;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x211;
    uint32_t x212;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x213;
    uint32_t x214;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x215;
    uint32_t x216;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x217;
    uint32_t x218;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x219;
    uint32_t x220;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x221;
    uint32_t x222;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x223;
    uint32_t x224;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x225;
    uint32_t x226;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x227;
    uint32_t x228;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x229;
    uint32_t x230;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x231;
    uint32_t x232;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x233;
    uint32_t x234;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x235;
    uint32_t x236;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x237;
    uint32_t x238;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x239;
    uint32_t x240;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x241;
    uint32_t x242;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x243;
    uint32_t x244;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x245;
    uint32_t x246;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x247;
    uint32_t x248;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x249;
    uint32_t x250;
    uint32_t x251;
    uint32_t x252;
    uint32_t x253;
    uint32_t x254;
    uint32_t x255;
    uint32_t x256;
    uint32_t x257;
    uint32_t x258;
    uint32_t x259;
    uint32_t x260;
    uint32_t x261;
    uint32_t x262;
    uint32_t x263;
    uint32_t x264;
    uint32_t x265;
    uint32_t x266;
    uint32_t x267;
    uint32_t x268;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x269;
    uint32_t x270;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x271;
    uint32_t x272;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x273;
    uint32_t x274;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x275;
    uint32_t x276;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x277;
    uint32_t x278;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x279;
    uint32_t x280;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x281;
    uint32_t x282;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x283;
    uint32_t x284;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x285;
    uint32_t x286;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x287;
    uint32_t x288;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x289;
    uint32_t x290;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x291;
    uint32_t x292;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x293;
    uint32_t x294;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x295;
    uint32_t x296;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x297;
    uint32_t x298;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x299;
    uint32_t x300;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x301;
    uint32_t x302;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x303;
    uint32_t x304;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x305;
    uint32_t x306;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x307;
    uint32_t x308;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x309;
    uint32_t x310;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x311;
    uint32_t x312;
    uint32_t x313;
    uint32_t x314;
    uint32_t x315;
    uint32_t x316;
    uint32_t x317;
    uint32_t x318;
    uint32_t x319;
    uint32_t x320;
    uint32_t x321;
    uint32_t x322;
    uint32_t x323;
    uint32_t x324;
    uint32_t x325;
    uint32_t x326;
    uint32_t x327;
    uint32_t x328;
    uint32_t x329;
    uint32_t x330;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x331;
    uint32_t x332;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x333;
    uint32_t x334;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x335;
    uint32_t x336;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x337;
    uint32_t x338;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x339;
    uint32_t x340;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x341;
    uint32_t x342;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x343;
    uint32_t x344;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x345;
    uint32_t x346;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x347;
    uint32_t x348;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x349;
    uint32_t x350;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x351;
    uint32_t x352;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x353;
    uint32_t x354;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x355;
    uint32_t x356;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x357;
    uint32_t x358;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x359;
    uint32_t x360;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x361;
    uint32_t x362;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x363;
    uint32_t x364;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x365;
    uint32_t x366;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x367;
    uint32_t x368;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x369;
    uint32_t x370;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x371;
    uint32_t x372;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x373;
    uint32_t x374;
    uint32_t x375;
    uint32_t x376;
    uint32_t x377;
    uint32_t x378;
    uint32_t x379;
    uint32_t x380;
    uint32_t x381;
    uint32_t x382;
    uint32_t x383;
    uint32_t x384;
    uint32_t x385;
    uint32_t x386;
    uint32_t x387;
    uint32_t x388;
    uint32_t x389;
    uint32_t x390;
    uint32_t x391;
    uint32_t x392;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x393;
    uint32_t x394;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x395;
    uint32_t x396;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x397;
    uint32_t x398;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x399;
    uint32_t x400;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x401;
    uint32_t x402;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x403;
    uint32_t x404;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x405;
    uint32_t x406;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x407;
    uint32_t x408;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x409;
    uint32_t x410;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x411;
    uint32_t x412;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x413;
    uint32_t x414;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x415;
    uint32_t x416;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x417;
    uint32_t x418;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x419;
    uint32_t x420;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x421;
    uint32_t x422;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x423;
    uint32_t x424;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x425;
    uint32_t x426;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x427;
    uint32_t x428;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x429;
    uint32_t x430;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x431;
    uint32_t x432;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x433;
    uint32_t x434;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x435;
    uint32_t x436;
    uint32_t x437;
    uint32_t x438;
    uint32_t x439;
    uint32_t x440;
    uint32_t x441;
    uint32_t x442;
    uint32_t x443;
    uint32_t x444;
    uint32_t x445;
    uint32_t x446;
    uint32_t x447;
    uint32_t x448;
    uint32_t x449;
    uint32_t x450;
    uint32_t x451;
    uint32_t x452;
    uint32_t x453;
    uint32_t x454;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x455;
    uint32_t x456;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x457;
    uint32_t x458;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x459;
    uint32_t x460;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x461;
    uint32_t x462;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x463;
    uint32_t x464;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x465;
    uint32_t x466;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x467;
    uint32_t x468;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x469;
    uint32_t x470;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x471;
    uint32_t x472;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x473;
    uint32_t x474;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x475;
    uint32_t x476;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x477;
    uint32_t x478;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x479;
    uint32_t x480;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x481;
    uint32_t x482;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x483;
    uint32_t x484;
    uint32_t x485;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x486;
    uint32_t x487;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x488;
    uint32_t x489;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x490;
    uint32_t x491;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x492;
    uint32_t x493;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x494;
    uint32_t x495;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x496;
    uint32_t x497;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x498;
    uint32_t x499;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x500;
    uint32_t x501;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x502;
    uint32_t x503;
    uint32_t x504;
    uint32_t x505;
    uint32_t x506;
    uint32_t x507;
    uint32_t x508;
    uint32_t x509;
    uint32_t x510;
    x1 = (arg1[0]);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x2, &x3, x1,
                                                         UINT32_C(0x727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x4, &x5, x2,
                                                         UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x6, &x7, x2,
                                                         UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x8, &x9, x2,
                                                         UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x10, &x11, x2,
                                                         UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x12, &x13, x2,
                                                         UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x14, &x15, x2,
                                                         UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x16, &x17, x2,
                                                         UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x18, &x19, x2,
                                                         UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x20, &x21, 0x0,
                                                              x19, x16);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x22, &x23, x21,
                                                              x17, x14);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x24, &x25, x23,
                                                              x15, x12);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x26, &x27, x25,
                                                              x13, x10);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x28, &x29, x27,
                                                              x11, x8);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x30, &x31, x29,
                                                              x9, x6);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x32, &x33, x31,
                                                              x7, x4);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x34, &x35, 0x0,
                                                              x1, x18);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x36, &x37, x35,
                                                              0x0, x20);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x38, &x39, x37,
                                                              0x0, x22);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x40, &x41, x39,
                                                              0x0, x24);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x42, &x43, x41,
                                                              0x0, x26);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x44, &x45, x43,
                                                              0x0, x28);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x46, &x47, x45,
                                                              0x0, x30);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x48, &x49, x47,
                                                              0x0, x32);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x50, &x51, 0x0,
                                                              x36, (arg1[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x52, &x53, x51,
                                                              x38, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x54, &x55, x53,
                                                              x40, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x56, &x57, x55,
                                                              x42, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x58, &x59, x57,
                                                              x44, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x60, &x61, x59,
                                                              x46, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x62, &x63, x61,
                                                              x48, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x64, &x65, x50,
                                                         UINT32_C(0x727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x66, &x67, x64,
                                                         UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x68, &x69, x64,
                                                         UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x70, &x71, x64,
                                                         UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x72, &x73, x64,
                                                         UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x74, &x75, x64,
                                                         UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x76, &x77, x64,
                                                         UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x78, &x79, x64,
                                                         UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x80, &x81, x64,
                                                         UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x82, &x83, 0x0,
                                                              x81, x78);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x84, &x85, x83,
                                                              x79, x76);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x86, &x87, x85,
                                                              x77, x74);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x88, &x89, x87,
                                                              x75, x72);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x90, &x91, x89,
                                                              x73, x70);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x92, &x93, x91,
                                                              x71, x68);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x94, &x95, x93,
                                                              x69, x66);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x96, &x97, 0x0,
                                                              x50, x80);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x98, &x99, x97,
                                                              x52, x82);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x100, &x101, x99,
                                                              x54, x84);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x102, &x103,
                                                              x101, x56, x86);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x104, &x105,
                                                              x103, x58, x88);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x106, &x107,
                                                              x105, x60, x90);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x108, &x109,
                                                              x107, x62, x92);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x110, &x111, x109, (x63 + (x49 + (x33 + x5))), x94);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x112, &x113, 0x0,
                                                              x98, (arg1[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x114, &x115,
                                                              x113, x100, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x116, &x117,
                                                              x115, x102, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x118, &x119,
                                                              x117, x104, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x120, &x121,
                                                              x119, x106, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x122, &x123,
                                                              x121, x108, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x124, &x125,
                                                              x123, x110, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x126, &x127, x112,
                                                         UINT32_C(0x727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x128, &x129, x126,
                                                         UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x130, &x131, x126,
                                                         UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x132, &x133, x126,
                                                         UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x134, &x135, x126,
                                                         UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x136, &x137, x126,
                                                         UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x138, &x139, x126,
                                                         UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x140, &x141, x126,
                                                         UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x142, &x143, x126,
                                                         UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x144, &x145, 0x0,
                                                              x143, x140);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x146, &x147,
                                                              x145, x141, x138);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x148, &x149,
                                                              x147, x139, x136);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x150, &x151,
                                                              x149, x137, x134);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x152, &x153,
                                                              x151, x135, x132);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x154, &x155,
                                                              x153, x133, x130);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x156, &x157,
                                                              x155, x131, x128);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x158, &x159, 0x0,
                                                              x112, x142);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x160, &x161,
                                                              x159, x114, x144);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x162, &x163,
                                                              x161, x116, x146);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x164, &x165,
                                                              x163, x118, x148);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x166, &x167,
                                                              x165, x120, x150);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x168, &x169,
                                                              x167, x122, x152);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x170, &x171,
                                                              x169, x124, x154);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x172, &x173, x171, (x125 + (x111 + (x95 + x67))), x156);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x174, &x175, 0x0,
                                                              x160, (arg1[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x176, &x177,
                                                              x175, x162, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x178, &x179,
                                                              x177, x164, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x180, &x181,
                                                              x179, x166, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x182, &x183,
                                                              x181, x168, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x184, &x185,
                                                              x183, x170, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x186, &x187,
                                                              x185, x172, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x188, &x189, x174,
                                                         UINT32_C(0x727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x190, &x191, x188,
                                                         UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x192, &x193, x188,
                                                         UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x194, &x195, x188,
                                                         UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x196, &x197, x188,
                                                         UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x198, &x199, x188,
                                                         UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x200, &x201, x188,
                                                         UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x202, &x203, x188,
                                                         UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x204, &x205, x188,
                                                         UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x206, &x207, 0x0,
                                                              x205, x202);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x208, &x209,
                                                              x207, x203, x200);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x210, &x211,
                                                              x209, x201, x198);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x212, &x213,
                                                              x211, x199, x196);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x214, &x215,
                                                              x213, x197, x194);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x216, &x217,
                                                              x215, x195, x192);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x218, &x219,
                                                              x217, x193, x190);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x220, &x221, 0x0,
                                                              x174, x204);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x222, &x223,
                                                              x221, x176, x206);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x224, &x225,
                                                              x223, x178, x208);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x226, &x227,
                                                              x225, x180, x210);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x228, &x229,
                                                              x227, x182, x212);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x230, &x231,
                                                              x229, x184, x214);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x232, &x233,
                                                              x231, x186, x216);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x234, &x235, x233, (x187 + (x173 + (x157 + x129))), x218);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x236, &x237, 0x0,
                                                              x222, (arg1[4]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x238, &x239,
                                                              x237, x224, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x240, &x241,
                                                              x239, x226, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x242, &x243,
                                                              x241, x228, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x244, &x245,
                                                              x243, x230, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x246, &x247,
                                                              x245, x232, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x248, &x249,
                                                              x247, x234, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x250, &x251, x236,
                                                         UINT32_C(0x727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x252, &x253, x250,
                                                         UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x254, &x255, x250,
                                                         UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x256, &x257, x250,
                                                         UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x258, &x259, x250,
                                                         UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x260, &x261, x250,
                                                         UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x262, &x263, x250,
                                                         UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x264, &x265, x250,
                                                         UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x266, &x267, x250,
                                                         UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x268, &x269, 0x0,
                                                              x267, x264);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x270, &x271,
                                                              x269, x265, x262);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x272, &x273,
                                                              x271, x263, x260);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x274, &x275,
                                                              x273, x261, x258);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x276, &x277,
                                                              x275, x259, x256);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x278, &x279,
                                                              x277, x257, x254);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x280, &x281,
                                                              x279, x255, x252);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x282, &x283, 0x0,
                                                              x236, x266);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x284, &x285,
                                                              x283, x238, x268);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x286, &x287,
                                                              x285, x240, x270);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x288, &x289,
                                                              x287, x242, x272);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x290, &x291,
                                                              x289, x244, x274);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x292, &x293,
                                                              x291, x246, x276);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x294, &x295,
                                                              x293, x248, x278);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x296, &x297, x295, (x249 + (x235 + (x219 + x191))), x280);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x298, &x299, 0x0,
                                                              x284, (arg1[5]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x300, &x301,
                                                              x299, x286, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x302, &x303,
                                                              x301, x288, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x304, &x305,
                                                              x303, x290, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x306, &x307,
                                                              x305, x292, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x308, &x309,
                                                              x307, x294, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x310, &x311,
                                                              x309, x296, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x312, &x313, x298,
                                                         UINT32_C(0x727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x314, &x315, x312,
                                                         UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x316, &x317, x312,
                                                         UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x318, &x319, x312,
                                                         UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x320, &x321, x312,
                                                         UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x322, &x323, x312,
                                                         UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x324, &x325, x312,
                                                         UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x326, &x327, x312,
                                                         UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x328, &x329, x312,
                                                         UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x330, &x331, 0x0,
                                                              x329, x326);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x332, &x333,
                                                              x331, x327, x324);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x334, &x335,
                                                              x333, x325, x322);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x336, &x337,
                                                              x335, x323, x320);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x338, &x339,
                                                              x337, x321, x318);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x340, &x341,
                                                              x339, x319, x316);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x342, &x343,
                                                              x341, x317, x314);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x344, &x345, 0x0,
                                                              x298, x328);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x346, &x347,
                                                              x345, x300, x330);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x348, &x349,
                                                              x347, x302, x332);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x350, &x351,
                                                              x349, x304, x334);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x352, &x353,
                                                              x351, x306, x336);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x354, &x355,
                                                              x353, x308, x338);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x356, &x357,
                                                              x355, x310, x340);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x358, &x359, x357, (x311 + (x297 + (x281 + x253))), x342);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x360, &x361, 0x0,
                                                              x346, (arg1[6]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x362, &x363,
                                                              x361, x348, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x364, &x365,
                                                              x363, x350, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x366, &x367,
                                                              x365, x352, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x368, &x369,
                                                              x367, x354, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x370, &x371,
                                                              x369, x356, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x372, &x373,
                                                              x371, x358, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x374, &x375, x360,
                                                         UINT32_C(0x727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x376, &x377, x374,
                                                         UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x378, &x379, x374,
                                                         UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x380, &x381, x374,
                                                         UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x382, &x383, x374,
                                                         UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x384, &x385, x374,
                                                         UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x386, &x387, x374,
                                                         UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x388, &x389, x374,
                                                         UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x390, &x391, x374,
                                                         UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x392, &x393, 0x0,
                                                              x391, x388);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x394, &x395,
                                                              x393, x389, x386);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x396, &x397,
                                                              x395, x387, x384);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x398, &x399,
                                                              x397, x385, x382);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x400, &x401,
                                                              x399, x383, x380);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x402, &x403,
                                                              x401, x381, x378);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x404, &x405,
                                                              x403, x379, x376);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x406, &x407, 0x0,
                                                              x360, x390);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x408, &x409,
                                                              x407, x362, x392);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x410, &x411,
                                                              x409, x364, x394);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x412, &x413,
                                                              x411, x366, x396);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x414, &x415,
                                                              x413, x368, x398);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x416, &x417,
                                                              x415, x370, x400);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x418, &x419,
                                                              x417, x372, x402);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x420, &x421, x419, (x373 + (x359 + (x343 + x315))), x404);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x422, &x423, 0x0,
                                                              x408, (arg1[7]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x424, &x425,
                                                              x423, x410, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x426, &x427,
                                                              x425, x412, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x428, &x429,
                                                              x427, x414, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x430, &x431,
                                                              x429, x416, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x432, &x433,
                                                              x431, x418, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x434, &x435,
                                                              x433, x420, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x436, &x437, x422,
                                                         UINT32_C(0x727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x438, &x439, x436,
                                                         UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x440, &x441, x436,
                                                         UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x442, &x443, x436,
                                                         UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x444, &x445, x436,
                                                         UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x446, &x447, x436,
                                                         UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x448, &x449, x436,
                                                         UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x450, &x451, x436,
                                                         UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x452, &x453, x436,
                                                         UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x454, &x455, 0x0,
                                                              x453, x450);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x456, &x457,
                                                              x455, x451, x448);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x458, &x459,
                                                              x457, x449, x446);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x460, &x461,
                                                              x459, x447, x444);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x462, &x463,
                                                              x461, x445, x442);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x464, &x465,
                                                              x463, x443, x440);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x466, &x467,
                                                              x465, x441, x438);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x468, &x469, 0x0,
                                                              x422, x452);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x470, &x471,
                                                              x469, x424, x454);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x472, &x473,
                                                              x471, x426, x456);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x474, &x475,
                                                              x473, x428, x458);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x476, &x477,
                                                              x475, x430, x460);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x478, &x479,
                                                              x477, x432, x462);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x480, &x481,
                                                              x479, x434, x464);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x482, &x483, x481, (x435 + (x421 + (x405 + x377))), x466);
    x484 = (x483 + (x467 + x439));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x485, &x486, 0x0, x470, UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x487, &x488, x486, x472, UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x489, &x490, x488, x474, UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x491, &x492, x490, x476, UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x493, &x494, x492, x478, UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x495, &x496, x494, x480, UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x497, &x498, x496, x482, UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x499, &x500, x498, x484, UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(&x501, &x502,
                                                               x500, 0x0, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x503, x502, x485,
                                                            x470);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x504, x502, x487,
                                                            x472);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x505, x502, x489,
                                                            x474);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x506, x502, x491,
                                                            x476);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x507, x502, x493,
                                                            x478);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x508, x502, x495,
                                                            x480);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x509, x502, x497,
                                                            x482);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x510, x502, x499,
                                                            x484);
    out1[0] = x503;
    out1[1] = x504;
    out1[2] = x505;
    out1[3] = x506;
    out1[4] = x507;
    out1[5] = x508;
    out1[6] = x509;
    out1[7] = x510;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_to_montgomery translates a field element into the Montgomery domain.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   eval (from_montgomery out1) mod m = eval arg1 mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_to_montgomery(
    uint32_t out1[8], const uint32_t arg1[8]) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    uint32_t x9;
    uint32_t x10;
    uint32_t x11;
    uint32_t x12;
    uint32_t x13;
    uint32_t x14;
    uint32_t x15;
    uint32_t x16;
    uint32_t x17;
    uint32_t x18;
    uint32_t x19;
    uint32_t x20;
    uint32_t x21;
    uint32_t x22;
    uint32_t x23;
    uint32_t x24;
    uint32_t x25;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x26;
    uint32_t x27;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x28;
    uint32_t x29;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x30;
    uint32_t x31;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x32;
    uint32_t x33;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x34;
    uint32_t x35;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x36;
    uint32_t x37;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x38;
    uint32_t x39;
    uint32_t x40;
    uint32_t x41;
    uint32_t x42;
    uint32_t x43;
    uint32_t x44;
    uint32_t x45;
    uint32_t x46;
    uint32_t x47;
    uint32_t x48;
    uint32_t x49;
    uint32_t x50;
    uint32_t x51;
    uint32_t x52;
    uint32_t x53;
    uint32_t x54;
    uint32_t x55;
    uint32_t x56;
    uint32_t x57;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x58;
    uint32_t x59;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x60;
    uint32_t x61;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x62;
    uint32_t x63;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x64;
    uint32_t x65;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x66;
    uint32_t x67;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x68;
    uint32_t x69;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x70;
    uint32_t x71;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x72;
    uint32_t x73;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x74;
    uint32_t x75;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x76;
    uint32_t x77;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x78;
    uint32_t x79;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x80;
    uint32_t x81;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x82;
    uint32_t x83;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x84;
    uint32_t x85;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x86;
    uint32_t x87;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x88;
    uint32_t x89;
    uint32_t x90;
    uint32_t x91;
    uint32_t x92;
    uint32_t x93;
    uint32_t x94;
    uint32_t x95;
    uint32_t x96;
    uint32_t x97;
    uint32_t x98;
    uint32_t x99;
    uint32_t x100;
    uint32_t x101;
    uint32_t x102;
    uint32_t x103;
    uint32_t x104;
    uint32_t x105;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x106;
    uint32_t x107;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x108;
    uint32_t x109;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x110;
    uint32_t x111;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x112;
    uint32_t x113;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x114;
    uint32_t x115;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x116;
    uint32_t x117;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x118;
    uint32_t x119;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x120;
    uint32_t x121;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x122;
    uint32_t x123;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x124;
    uint32_t x125;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x126;
    uint32_t x127;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x128;
    uint32_t x129;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x130;
    uint32_t x131;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x132;
    uint32_t x133;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x134;
    uint32_t x135;
    uint32_t x136;
    uint32_t x137;
    uint32_t x138;
    uint32_t x139;
    uint32_t x140;
    uint32_t x141;
    uint32_t x142;
    uint32_t x143;
    uint32_t x144;
    uint32_t x145;
    uint32_t x146;
    uint32_t x147;
    uint32_t x148;
    uint32_t x149;
    uint32_t x150;
    uint32_t x151;
    uint32_t x152;
    uint32_t x153;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x154;
    uint32_t x155;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x156;
    uint32_t x157;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x158;
    uint32_t x159;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x160;
    uint32_t x161;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x162;
    uint32_t x163;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x164;
    uint32_t x165;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x166;
    uint32_t x167;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x168;
    uint32_t x169;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x170;
    uint32_t x171;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x172;
    uint32_t x173;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x174;
    uint32_t x175;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x176;
    uint32_t x177;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x178;
    uint32_t x179;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x180;
    uint32_t x181;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x182;
    uint32_t x183;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x184;
    uint32_t x185;
    uint32_t x186;
    uint32_t x187;
    uint32_t x188;
    uint32_t x189;
    uint32_t x190;
    uint32_t x191;
    uint32_t x192;
    uint32_t x193;
    uint32_t x194;
    uint32_t x195;
    uint32_t x196;
    uint32_t x197;
    uint32_t x198;
    uint32_t x199;
    uint32_t x200;
    uint32_t x201;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x202;
    uint32_t x203;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x204;
    uint32_t x205;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x206;
    uint32_t x207;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x208;
    uint32_t x209;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x210;
    uint32_t x211;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x212;
    uint32_t x213;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x214;
    uint32_t x215;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x216;
    uint32_t x217;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x218;
    uint32_t x219;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x220;
    uint32_t x221;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x222;
    uint32_t x223;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x224;
    uint32_t x225;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x226;
    uint32_t x227;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x228;
    uint32_t x229;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x230;
    uint32_t x231;
    uint32_t x232;
    uint32_t x233;
    uint32_t x234;
    uint32_t x235;
    uint32_t x236;
    uint32_t x237;
    uint32_t x238;
    uint32_t x239;
    uint32_t x240;
    uint32_t x241;
    uint32_t x242;
    uint32_t x243;
    uint32_t x244;
    uint32_t x245;
    uint32_t x246;
    uint32_t x247;
    uint32_t x248;
    uint32_t x249;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x250;
    uint32_t x251;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x252;
    uint32_t x253;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x254;
    uint32_t x255;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x256;
    uint32_t x257;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x258;
    uint32_t x259;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x260;
    uint32_t x261;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x262;
    uint32_t x263;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x264;
    uint32_t x265;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x266;
    uint32_t x267;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x268;
    uint32_t x269;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x270;
    uint32_t x271;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x272;
    uint32_t x273;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x274;
    uint32_t x275;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x276;
    uint32_t x277;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x278;
    uint32_t x279;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x280;
    uint32_t x281;
    uint32_t x282;
    uint32_t x283;
    uint32_t x284;
    uint32_t x285;
    uint32_t x286;
    uint32_t x287;
    uint32_t x288;
    uint32_t x289;
    uint32_t x290;
    uint32_t x291;
    uint32_t x292;
    uint32_t x293;
    uint32_t x294;
    uint32_t x295;
    uint32_t x296;
    uint32_t x297;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x298;
    uint32_t x299;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x300;
    uint32_t x301;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x302;
    uint32_t x303;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x304;
    uint32_t x305;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x306;
    uint32_t x307;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x308;
    uint32_t x309;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x310;
    uint32_t x311;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x312;
    uint32_t x313;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x314;
    uint32_t x315;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x316;
    uint32_t x317;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x318;
    uint32_t x319;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x320;
    uint32_t x321;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x322;
    uint32_t x323;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x324;
    uint32_t x325;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x326;
    uint32_t x327;
    uint32_t x328;
    uint32_t x329;
    uint32_t x330;
    uint32_t x331;
    uint32_t x332;
    uint32_t x333;
    uint32_t x334;
    uint32_t x335;
    uint32_t x336;
    uint32_t x337;
    uint32_t x338;
    uint32_t x339;
    uint32_t x340;
    uint32_t x341;
    uint32_t x342;
    uint32_t x343;
    uint32_t x344;
    uint32_t x345;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x346;
    uint32_t x347;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x348;
    uint32_t x349;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x350;
    uint32_t x351;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x352;
    uint32_t x353;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x354;
    uint32_t x355;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x356;
    uint32_t x357;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x358;
    uint32_t x359;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x360;
    uint32_t x361;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x362;
    uint32_t x363;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x364;
    uint32_t x365;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x366;
    uint32_t x367;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x368;
    uint32_t x369;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x370;
    uint32_t x371;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x372;
    uint32_t x373;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x374;
    uint32_t x375;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x376;
    uint32_t x377;
    uint32_t x378;
    uint32_t x379;
    uint32_t x380;
    uint32_t x381;
    uint32_t x382;
    uint32_t x383;
    uint32_t x384;
    uint32_t x385;
    uint32_t x386;
    uint32_t x387;
    uint32_t x388;
    uint32_t x389;
    uint32_t x390;
    uint32_t x391;
    uint32_t x392;
    uint32_t x393;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x394;
    uint32_t x395;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x396;
    uint32_t x397;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x398;
    uint32_t x399;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x400;
    uint32_t x401;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x402;
    uint32_t x403;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x404;
    uint32_t x405;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x406;
    uint32_t x407;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x408;
    uint32_t x409;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x410;
    uint32_t x411;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x412;
    uint32_t x413;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x414;
    uint32_t x415;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x416;
    uint32_t x417;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x418;
    uint32_t x419;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x420;
    uint32_t x421;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x422;
    uint32_t x423;
    uint32_t x424;
    uint32_t x425;
    uint32_t x426;
    uint32_t x427;
    uint32_t x428;
    uint32_t x429;
    uint32_t x430;
    uint32_t x431;
    uint32_t x432;
    uint32_t x433;
    uint32_t x434;
    uint32_t x435;
    uint32_t x436;
    uint32_t x437;
    uint32_t x438;
    uint32_t x439;
    uint32_t x440;
    uint32_t x441;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x442;
    uint32_t x443;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x444;
    uint32_t x445;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x446;
    uint32_t x447;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x448;
    uint32_t x449;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x450;
    uint32_t x451;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x452;
    uint32_t x453;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x454;
    uint32_t x455;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x456;
    uint32_t x457;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x458;
    uint32_t x459;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x460;
    uint32_t x461;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x462;
    uint32_t x463;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x464;
    uint32_t x465;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x466;
    uint32_t x467;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x468;
    uint32_t x469;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x470;
    uint32_t x471;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x472;
    uint32_t x473;
    uint32_t x474;
    uint32_t x475;
    uint32_t x476;
    uint32_t x477;
    uint32_t x478;
    uint32_t x479;
    uint32_t x480;
    uint32_t x481;
    uint32_t x482;
    uint32_t x483;
    uint32_t x484;
    uint32_t x485;
    uint32_t x486;
    uint32_t x487;
    uint32_t x488;
    uint32_t x489;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x490;
    uint32_t x491;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x492;
    uint32_t x493;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x494;
    uint32_t x495;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x496;
    uint32_t x497;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x498;
    uint32_t x499;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x500;
    uint32_t x501;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x502;
    uint32_t x503;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x504;
    uint32_t x505;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x506;
    uint32_t x507;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x508;
    uint32_t x509;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x510;
    uint32_t x511;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x512;
    uint32_t x513;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x514;
    uint32_t x515;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x516;
    uint32_t x517;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x518;
    uint32_t x519;
    uint32_t x520;
    uint32_t x521;
    uint32_t x522;
    uint32_t x523;
    uint32_t x524;
    uint32_t x525;
    uint32_t x526;
    uint32_t x527;
    uint32_t x528;
    uint32_t x529;
    uint32_t x530;
    uint32_t x531;
    uint32_t x532;
    uint32_t x533;
    uint32_t x534;
    uint32_t x535;
    uint32_t x536;
    uint32_t x537;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x538;
    uint32_t x539;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x540;
    uint32_t x541;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x542;
    uint32_t x543;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x544;
    uint32_t x545;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x546;
    uint32_t x547;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x548;
    uint32_t x549;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x550;
    uint32_t x551;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x552;
    uint32_t x553;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x554;
    uint32_t x555;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x556;
    uint32_t x557;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x558;
    uint32_t x559;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x560;
    uint32_t x561;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x562;
    uint32_t x563;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x564;
    uint32_t x565;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x566;
    uint32_t x567;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x568;
    uint32_t x569;
    uint32_t x570;
    uint32_t x571;
    uint32_t x572;
    uint32_t x573;
    uint32_t x574;
    uint32_t x575;
    uint32_t x576;
    uint32_t x577;
    uint32_t x578;
    uint32_t x579;
    uint32_t x580;
    uint32_t x581;
    uint32_t x582;
    uint32_t x583;
    uint32_t x584;
    uint32_t x585;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x586;
    uint32_t x587;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x588;
    uint32_t x589;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x590;
    uint32_t x591;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x592;
    uint32_t x593;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x594;
    uint32_t x595;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x596;
    uint32_t x597;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x598;
    uint32_t x599;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x600;
    uint32_t x601;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x602;
    uint32_t x603;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x604;
    uint32_t x605;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x606;
    uint32_t x607;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x608;
    uint32_t x609;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x610;
    uint32_t x611;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x612;
    uint32_t x613;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x614;
    uint32_t x615;
    uint32_t x616;
    uint32_t x617;
    uint32_t x618;
    uint32_t x619;
    uint32_t x620;
    uint32_t x621;
    uint32_t x622;
    uint32_t x623;
    uint32_t x624;
    uint32_t x625;
    uint32_t x626;
    uint32_t x627;
    uint32_t x628;
    uint32_t x629;
    uint32_t x630;
    uint32_t x631;
    uint32_t x632;
    uint32_t x633;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x634;
    uint32_t x635;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x636;
    uint32_t x637;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x638;
    uint32_t x639;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x640;
    uint32_t x641;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x642;
    uint32_t x643;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x644;
    uint32_t x645;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x646;
    uint32_t x647;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x648;
    uint32_t x649;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x650;
    uint32_t x651;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x652;
    uint32_t x653;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x654;
    uint32_t x655;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x656;
    uint32_t x657;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x658;
    uint32_t x659;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x660;
    uint32_t x661;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x662;
    uint32_t x663;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x664;
    uint32_t x665;
    uint32_t x666;
    uint32_t x667;
    uint32_t x668;
    uint32_t x669;
    uint32_t x670;
    uint32_t x671;
    uint32_t x672;
    uint32_t x673;
    uint32_t x674;
    uint32_t x675;
    uint32_t x676;
    uint32_t x677;
    uint32_t x678;
    uint32_t x679;
    uint32_t x680;
    uint32_t x681;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x682;
    uint32_t x683;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x684;
    uint32_t x685;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x686;
    uint32_t x687;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x688;
    uint32_t x689;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x690;
    uint32_t x691;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x692;
    uint32_t x693;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x694;
    uint32_t x695;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x696;
    uint32_t x697;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x698;
    uint32_t x699;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x700;
    uint32_t x701;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x702;
    uint32_t x703;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x704;
    uint32_t x705;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x706;
    uint32_t x707;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x708;
    uint32_t x709;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x710;
    uint32_t x711;
    uint32_t x712;
    uint32_t x713;
    uint32_t x714;
    uint32_t x715;
    uint32_t x716;
    uint32_t x717;
    uint32_t x718;
    uint32_t x719;
    uint32_t x720;
    uint32_t x721;
    uint32_t x722;
    uint32_t x723;
    uint32_t x724;
    uint32_t x725;
    uint32_t x726;
    uint32_t x727;
    uint32_t x728;
    uint32_t x729;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x730;
    uint32_t x731;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x732;
    uint32_t x733;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x734;
    uint32_t x735;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x736;
    uint32_t x737;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x738;
    uint32_t x739;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x740;
    uint32_t x741;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x742;
    uint32_t x743;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x744;
    uint32_t x745;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x746;
    uint32_t x747;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x748;
    uint32_t x749;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x750;
    uint32_t x751;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x752;
    uint32_t x753;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x754;
    uint32_t x755;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x756;
    uint32_t x757;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x758;
    uint32_t x759;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x760;
    uint32_t x761;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x762;
    uint32_t x763;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x764;
    uint32_t x765;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x766;
    uint32_t x767;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x768;
    uint32_t x769;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x770;
    uint32_t x771;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x772;
    uint32_t x773;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x774;
    uint32_t x775;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x776;
    uint32_t x777;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 x778;
    uint32_t x779;
    uint32_t x780;
    uint32_t x781;
    uint32_t x782;
    uint32_t x783;
    uint32_t x784;
    uint32_t x785;
    uint32_t x786;
    x1 = (arg1[1]);
    x2 = (arg1[2]);
    x3 = (arg1[3]);
    x4 = (arg1[4]);
    x5 = (arg1[5]);
    x6 = (arg1[6]);
    x7 = (arg1[7]);
    x8 = (arg1[0]);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x9, &x10, x8,
                                                         UINT32_C(0x807a394e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x11, &x12, x8,
                                                         UINT32_C(0xde097652));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x13, &x14, x8,
                                                         UINT32_C(0x18630421));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x15, &x16, x8,
                                                         UINT32_C(0x2849c07b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x17, &x18, x8,
                                                         UINT32_C(0x1017bb39));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x19, &x20, x8,
                                                         UINT32_C(0xc2d346c5));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x21, &x22, x8,
                                                         UINT32_C(0x409973b4));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x23, &x24, x8,
                                                         UINT32_C(0xc427fcea));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x25, &x26, 0x0,
                                                              x24, x21);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x27, &x28, x26,
                                                              x22, x19);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x29, &x30, x28,
                                                              x20, x17);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x31, &x32, x30,
                                                              x18, x15);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x33, &x34, x32,
                                                              x16, x13);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x35, &x36, x34,
                                                              x14, x11);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x37, &x38, x36,
                                                              x12, x9);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x39, &x40, x23,
                                                         UINT32_C(0x727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x41, &x42, x39,
                                                         UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x43, &x44, x39,
                                                         UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x45, &x46, x39,
                                                         UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x47, &x48, x39,
                                                         UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x49, &x50, x39,
                                                         UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x51, &x52, x39,
                                                         UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x53, &x54, x39,
                                                         UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x55, &x56, x39,
                                                         UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x57, &x58, 0x0,
                                                              x56, x53);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x59, &x60, x58,
                                                              x54, x51);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x61, &x62, x60,
                                                              x52, x49);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x63, &x64, x62,
                                                              x50, x47);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x65, &x66, x64,
                                                              x48, x45);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x67, &x68, x66,
                                                              x46, x43);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x69, &x70, x68,
                                                              x44, x41);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x71, &x72, 0x0,
                                                              x23, x55);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x73, &x74, x72,
                                                              x25, x57);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x75, &x76, x74,
                                                              x27, x59);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x77, &x78, x76,
                                                              x29, x61);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x79, &x80, x78,
                                                              x31, x63);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x81, &x82, x80,
                                                              x33, x65);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x83, &x84, x82,
                                                              x35, x67);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x85, &x86, x84,
                                                              x37, x69);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x87, &x88, x86, (x38 + x10), (x70 + x42));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x89, &x90, x1,
                                                         UINT32_C(0x807a394e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x91, &x92, x1,
                                                         UINT32_C(0xde097652));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x93, &x94, x1,
                                                         UINT32_C(0x18630421));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x95, &x96, x1,
                                                         UINT32_C(0x2849c07b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x97, &x98, x1,
                                                         UINT32_C(0x1017bb39));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x99, &x100, x1,
                                                         UINT32_C(0xc2d346c5));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x101, &x102, x1,
                                                         UINT32_C(0x409973b4));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x103, &x104, x1,
                                                         UINT32_C(0xc427fcea));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x105, &x106, 0x0,
                                                              x104, x101);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x107, &x108,
                                                              x106, x102, x99);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x109, &x110,
                                                              x108, x100, x97);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x111, &x112,
                                                              x110, x98, x95);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x113, &x114,
                                                              x112, x96, x93);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x115, &x116,
                                                              x114, x94, x91);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x117, &x118,
                                                              x116, x92, x89);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x119, &x120, 0x0,
                                                              x73, x103);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x121, &x122,
                                                              x120, x75, x105);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x123, &x124,
                                                              x122, x77, x107);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x125, &x126,
                                                              x124, x79, x109);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x127, &x128,
                                                              x126, x81, x111);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x129, &x130,
                                                              x128, x83, x113);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x131, &x132,
                                                              x130, x85, x115);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x133, &x134,
                                                              x132, x87, x117);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x135, &x136, x119,
                                                         UINT32_C(0x727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x137, &x138, x135,
                                                         UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x139, &x140, x135,
                                                         UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x141, &x142, x135,
                                                         UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x143, &x144, x135,
                                                         UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x145, &x146, x135,
                                                         UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x147, &x148, x135,
                                                         UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x149, &x150, x135,
                                                         UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x151, &x152, x135,
                                                         UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x153, &x154, 0x0,
                                                              x152, x149);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x155, &x156,
                                                              x154, x150, x147);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x157, &x158,
                                                              x156, x148, x145);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x159, &x160,
                                                              x158, x146, x143);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x161, &x162,
                                                              x160, x144, x141);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x163, &x164,
                                                              x162, x142, x139);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x165, &x166,
                                                              x164, x140, x137);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x167, &x168, 0x0,
                                                              x119, x151);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x169, &x170,
                                                              x168, x121, x153);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x171, &x172,
                                                              x170, x123, x155);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x173, &x174,
                                                              x172, x125, x157);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x175, &x176,
                                                              x174, x127, x159);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x177, &x178,
                                                              x176, x129, x161);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x179, &x180,
                                                              x178, x131, x163);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x181, &x182,
                                                              x180, x133, x165);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x183, &x184, x182, (((uint32_t)x134 + x88) + (x118 + x90)),
        (x166 + x138));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x185, &x186, x2,
                                                         UINT32_C(0x807a394e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x187, &x188, x2,
                                                         UINT32_C(0xde097652));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x189, &x190, x2,
                                                         UINT32_C(0x18630421));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x191, &x192, x2,
                                                         UINT32_C(0x2849c07b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x193, &x194, x2,
                                                         UINT32_C(0x1017bb39));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x195, &x196, x2,
                                                         UINT32_C(0xc2d346c5));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x197, &x198, x2,
                                                         UINT32_C(0x409973b4));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x199, &x200, x2,
                                                         UINT32_C(0xc427fcea));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x201, &x202, 0x0,
                                                              x200, x197);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x203, &x204,
                                                              x202, x198, x195);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x205, &x206,
                                                              x204, x196, x193);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x207, &x208,
                                                              x206, x194, x191);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x209, &x210,
                                                              x208, x192, x189);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x211, &x212,
                                                              x210, x190, x187);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x213, &x214,
                                                              x212, x188, x185);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x215, &x216, 0x0,
                                                              x169, x199);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x217, &x218,
                                                              x216, x171, x201);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x219, &x220,
                                                              x218, x173, x203);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x221, &x222,
                                                              x220, x175, x205);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x223, &x224,
                                                              x222, x177, x207);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x225, &x226,
                                                              x224, x179, x209);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x227, &x228,
                                                              x226, x181, x211);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x229, &x230,
                                                              x228, x183, x213);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x231, &x232, x215,
                                                         UINT32_C(0x727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x233, &x234, x231,
                                                         UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x235, &x236, x231,
                                                         UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x237, &x238, x231,
                                                         UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x239, &x240, x231,
                                                         UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x241, &x242, x231,
                                                         UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x243, &x244, x231,
                                                         UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x245, &x246, x231,
                                                         UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x247, &x248, x231,
                                                         UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x249, &x250, 0x0,
                                                              x248, x245);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x251, &x252,
                                                              x250, x246, x243);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x253, &x254,
                                                              x252, x244, x241);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x255, &x256,
                                                              x254, x242, x239);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x257, &x258,
                                                              x256, x240, x237);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x259, &x260,
                                                              x258, x238, x235);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x261, &x262,
                                                              x260, x236, x233);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x263, &x264, 0x0,
                                                              x215, x247);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x265, &x266,
                                                              x264, x217, x249);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x267, &x268,
                                                              x266, x219, x251);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x269, &x270,
                                                              x268, x221, x253);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x271, &x272,
                                                              x270, x223, x255);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x273, &x274,
                                                              x272, x225, x257);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x275, &x276,
                                                              x274, x227, x259);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x277, &x278,
                                                              x276, x229, x261);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x279, &x280, x278, (((uint32_t)x230 + x184) + (x214 + x186)),
        (x262 + x234));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x281, &x282, x3,
                                                         UINT32_C(0x807a394e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x283, &x284, x3,
                                                         UINT32_C(0xde097652));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x285, &x286, x3,
                                                         UINT32_C(0x18630421));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x287, &x288, x3,
                                                         UINT32_C(0x2849c07b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x289, &x290, x3,
                                                         UINT32_C(0x1017bb39));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x291, &x292, x3,
                                                         UINT32_C(0xc2d346c5));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x293, &x294, x3,
                                                         UINT32_C(0x409973b4));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x295, &x296, x3,
                                                         UINT32_C(0xc427fcea));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x297, &x298, 0x0,
                                                              x296, x293);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x299, &x300,
                                                              x298, x294, x291);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x301, &x302,
                                                              x300, x292, x289);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x303, &x304,
                                                              x302, x290, x287);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x305, &x306,
                                                              x304, x288, x285);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x307, &x308,
                                                              x306, x286, x283);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x309, &x310,
                                                              x308, x284, x281);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x311, &x312, 0x0,
                                                              x265, x295);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x313, &x314,
                                                              x312, x267, x297);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x315, &x316,
                                                              x314, x269, x299);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x317, &x318,
                                                              x316, x271, x301);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x319, &x320,
                                                              x318, x273, x303);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x321, &x322,
                                                              x320, x275, x305);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x323, &x324,
                                                              x322, x277, x307);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x325, &x326,
                                                              x324, x279, x309);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x327, &x328, x311,
                                                         UINT32_C(0x727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x329, &x330, x327,
                                                         UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x331, &x332, x327,
                                                         UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x333, &x334, x327,
                                                         UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x335, &x336, x327,
                                                         UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x337, &x338, x327,
                                                         UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x339, &x340, x327,
                                                         UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x341, &x342, x327,
                                                         UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x343, &x344, x327,
                                                         UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x345, &x346, 0x0,
                                                              x344, x341);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x347, &x348,
                                                              x346, x342, x339);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x349, &x350,
                                                              x348, x340, x337);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x351, &x352,
                                                              x350, x338, x335);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x353, &x354,
                                                              x352, x336, x333);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x355, &x356,
                                                              x354, x334, x331);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x357, &x358,
                                                              x356, x332, x329);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x359, &x360, 0x0,
                                                              x311, x343);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x361, &x362,
                                                              x360, x313, x345);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x363, &x364,
                                                              x362, x315, x347);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x365, &x366,
                                                              x364, x317, x349);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x367, &x368,
                                                              x366, x319, x351);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x369, &x370,
                                                              x368, x321, x353);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x371, &x372,
                                                              x370, x323, x355);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x373, &x374,
                                                              x372, x325, x357);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x375, &x376, x374, (((uint32_t)x326 + x280) + (x310 + x282)),
        (x358 + x330));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x377, &x378, x4,
                                                         UINT32_C(0x807a394e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x379, &x380, x4,
                                                         UINT32_C(0xde097652));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x381, &x382, x4,
                                                         UINT32_C(0x18630421));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x383, &x384, x4,
                                                         UINT32_C(0x2849c07b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x385, &x386, x4,
                                                         UINT32_C(0x1017bb39));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x387, &x388, x4,
                                                         UINT32_C(0xc2d346c5));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x389, &x390, x4,
                                                         UINT32_C(0x409973b4));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x391, &x392, x4,
                                                         UINT32_C(0xc427fcea));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x393, &x394, 0x0,
                                                              x392, x389);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x395, &x396,
                                                              x394, x390, x387);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x397, &x398,
                                                              x396, x388, x385);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x399, &x400,
                                                              x398, x386, x383);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x401, &x402,
                                                              x400, x384, x381);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x403, &x404,
                                                              x402, x382, x379);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x405, &x406,
                                                              x404, x380, x377);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x407, &x408, 0x0,
                                                              x361, x391);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x409, &x410,
                                                              x408, x363, x393);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x411, &x412,
                                                              x410, x365, x395);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x413, &x414,
                                                              x412, x367, x397);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x415, &x416,
                                                              x414, x369, x399);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x417, &x418,
                                                              x416, x371, x401);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x419, &x420,
                                                              x418, x373, x403);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x421, &x422,
                                                              x420, x375, x405);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x423, &x424, x407,
                                                         UINT32_C(0x727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x425, &x426, x423,
                                                         UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x427, &x428, x423,
                                                         UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x429, &x430, x423,
                                                         UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x431, &x432, x423,
                                                         UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x433, &x434, x423,
                                                         UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x435, &x436, x423,
                                                         UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x437, &x438, x423,
                                                         UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x439, &x440, x423,
                                                         UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x441, &x442, 0x0,
                                                              x440, x437);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x443, &x444,
                                                              x442, x438, x435);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x445, &x446,
                                                              x444, x436, x433);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x447, &x448,
                                                              x446, x434, x431);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x449, &x450,
                                                              x448, x432, x429);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x451, &x452,
                                                              x450, x430, x427);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x453, &x454,
                                                              x452, x428, x425);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x455, &x456, 0x0,
                                                              x407, x439);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x457, &x458,
                                                              x456, x409, x441);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x459, &x460,
                                                              x458, x411, x443);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x461, &x462,
                                                              x460, x413, x445);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x463, &x464,
                                                              x462, x415, x447);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x465, &x466,
                                                              x464, x417, x449);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x467, &x468,
                                                              x466, x419, x451);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x469, &x470,
                                                              x468, x421, x453);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x471, &x472, x470, (((uint32_t)x422 + x376) + (x406 + x378)),
        (x454 + x426));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x473, &x474, x5,
                                                         UINT32_C(0x807a394e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x475, &x476, x5,
                                                         UINT32_C(0xde097652));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x477, &x478, x5,
                                                         UINT32_C(0x18630421));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x479, &x480, x5,
                                                         UINT32_C(0x2849c07b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x481, &x482, x5,
                                                         UINT32_C(0x1017bb39));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x483, &x484, x5,
                                                         UINT32_C(0xc2d346c5));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x485, &x486, x5,
                                                         UINT32_C(0x409973b4));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x487, &x488, x5,
                                                         UINT32_C(0xc427fcea));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x489, &x490, 0x0,
                                                              x488, x485);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x491, &x492,
                                                              x490, x486, x483);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x493, &x494,
                                                              x492, x484, x481);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x495, &x496,
                                                              x494, x482, x479);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x497, &x498,
                                                              x496, x480, x477);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x499, &x500,
                                                              x498, x478, x475);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x501, &x502,
                                                              x500, x476, x473);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x503, &x504, 0x0,
                                                              x457, x487);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x505, &x506,
                                                              x504, x459, x489);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x507, &x508,
                                                              x506, x461, x491);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x509, &x510,
                                                              x508, x463, x493);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x511, &x512,
                                                              x510, x465, x495);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x513, &x514,
                                                              x512, x467, x497);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x515, &x516,
                                                              x514, x469, x499);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x517, &x518,
                                                              x516, x471, x501);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x519, &x520, x503,
                                                         UINT32_C(0x727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x521, &x522, x519,
                                                         UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x523, &x524, x519,
                                                         UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x525, &x526, x519,
                                                         UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x527, &x528, x519,
                                                         UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x529, &x530, x519,
                                                         UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x531, &x532, x519,
                                                         UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x533, &x534, x519,
                                                         UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x535, &x536, x519,
                                                         UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x537, &x538, 0x0,
                                                              x536, x533);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x539, &x540,
                                                              x538, x534, x531);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x541, &x542,
                                                              x540, x532, x529);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x543, &x544,
                                                              x542, x530, x527);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x545, &x546,
                                                              x544, x528, x525);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x547, &x548,
                                                              x546, x526, x523);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x549, &x550,
                                                              x548, x524, x521);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x551, &x552, 0x0,
                                                              x503, x535);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x553, &x554,
                                                              x552, x505, x537);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x555, &x556,
                                                              x554, x507, x539);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x557, &x558,
                                                              x556, x509, x541);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x559, &x560,
                                                              x558, x511, x543);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x561, &x562,
                                                              x560, x513, x545);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x563, &x564,
                                                              x562, x515, x547);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x565, &x566,
                                                              x564, x517, x549);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x567, &x568, x566, (((uint32_t)x518 + x472) + (x502 + x474)),
        (x550 + x522));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x569, &x570, x6,
                                                         UINT32_C(0x807a394e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x571, &x572, x6,
                                                         UINT32_C(0xde097652));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x573, &x574, x6,
                                                         UINT32_C(0x18630421));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x575, &x576, x6,
                                                         UINT32_C(0x2849c07b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x577, &x578, x6,
                                                         UINT32_C(0x1017bb39));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x579, &x580, x6,
                                                         UINT32_C(0xc2d346c5));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x581, &x582, x6,
                                                         UINT32_C(0x409973b4));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x583, &x584, x6,
                                                         UINT32_C(0xc427fcea));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x585, &x586, 0x0,
                                                              x584, x581);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x587, &x588,
                                                              x586, x582, x579);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x589, &x590,
                                                              x588, x580, x577);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x591, &x592,
                                                              x590, x578, x575);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x593, &x594,
                                                              x592, x576, x573);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x595, &x596,
                                                              x594, x574, x571);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x597, &x598,
                                                              x596, x572, x569);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x599, &x600, 0x0,
                                                              x553, x583);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x601, &x602,
                                                              x600, x555, x585);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x603, &x604,
                                                              x602, x557, x587);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x605, &x606,
                                                              x604, x559, x589);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x607, &x608,
                                                              x606, x561, x591);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x609, &x610,
                                                              x608, x563, x593);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x611, &x612,
                                                              x610, x565, x595);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x613, &x614,
                                                              x612, x567, x597);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x615, &x616, x599,
                                                         UINT32_C(0x727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x617, &x618, x615,
                                                         UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x619, &x620, x615,
                                                         UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x621, &x622, x615,
                                                         UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x623, &x624, x615,
                                                         UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x625, &x626, x615,
                                                         UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x627, &x628, x615,
                                                         UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x629, &x630, x615,
                                                         UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x631, &x632, x615,
                                                         UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x633, &x634, 0x0,
                                                              x632, x629);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x635, &x636,
                                                              x634, x630, x627);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x637, &x638,
                                                              x636, x628, x625);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x639, &x640,
                                                              x638, x626, x623);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x641, &x642,
                                                              x640, x624, x621);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x643, &x644,
                                                              x642, x622, x619);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x645, &x646,
                                                              x644, x620, x617);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x647, &x648, 0x0,
                                                              x599, x631);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x649, &x650,
                                                              x648, x601, x633);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x651, &x652,
                                                              x650, x603, x635);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x653, &x654,
                                                              x652, x605, x637);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x655, &x656,
                                                              x654, x607, x639);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x657, &x658,
                                                              x656, x609, x641);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x659, &x660,
                                                              x658, x611, x643);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x661, &x662,
                                                              x660, x613, x645);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x663, &x664, x662, (((uint32_t)x614 + x568) + (x598 + x570)),
        (x646 + x618));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x665, &x666, x7,
                                                         UINT32_C(0x807a394e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x667, &x668, x7,
                                                         UINT32_C(0xde097652));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x669, &x670, x7,
                                                         UINT32_C(0x18630421));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x671, &x672, x7,
                                                         UINT32_C(0x2849c07b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x673, &x674, x7,
                                                         UINT32_C(0x1017bb39));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x675, &x676, x7,
                                                         UINT32_C(0xc2d346c5));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x677, &x678, x7,
                                                         UINT32_C(0x409973b4));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x679, &x680, x7,
                                                         UINT32_C(0xc427fcea));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x681, &x682, 0x0,
                                                              x680, x677);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x683, &x684,
                                                              x682, x678, x675);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x685, &x686,
                                                              x684, x676, x673);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x687, &x688,
                                                              x686, x674, x671);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x689, &x690,
                                                              x688, x672, x669);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x691, &x692,
                                                              x690, x670, x667);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x693, &x694,
                                                              x692, x668, x665);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x695, &x696, 0x0,
                                                              x649, x679);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x697, &x698,
                                                              x696, x651, x681);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x699, &x700,
                                                              x698, x653, x683);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x701, &x702,
                                                              x700, x655, x685);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x703, &x704,
                                                              x702, x657, x687);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x705, &x706,
                                                              x704, x659, x689);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x707, &x708,
                                                              x706, x661, x691);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x709, &x710,
                                                              x708, x663, x693);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x711, &x712, x695,
                                                         UINT32_C(0x727c176d));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x713, &x714, x711,
                                                         UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x715, &x716, x711,
                                                         UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x717, &x718, x711,
                                                         UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x719, &x720, x711,
                                                         UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x721, &x722, x711,
                                                         UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x723, &x724, x711,
                                                         UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x725, &x726, x711,
                                                         UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mulx_u32(&x727, &x728, x711,
                                                         UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x729, &x730, 0x0,
                                                              x728, x725);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x731, &x732,
                                                              x730, x726, x723);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x733, &x734,
                                                              x732, x724, x721);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x735, &x736,
                                                              x734, x722, x719);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x737, &x738,
                                                              x736, x720, x717);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x739, &x740,
                                                              x738, x718, x715);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x741, &x742,
                                                              x740, x716, x713);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x743, &x744, 0x0,
                                                              x695, x727);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x745, &x746,
                                                              x744, x697, x729);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x747, &x748,
                                                              x746, x699, x731);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x749, &x750,
                                                              x748, x701, x733);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x751, &x752,
                                                              x750, x703, x735);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x753, &x754,
                                                              x752, x705, x737);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x755, &x756,
                                                              x754, x707, x739);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(&x757, &x758,
                                                              x756, x709, x741);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_addcarryx_u32(
        &x759, &x760, x758, (((uint32_t)x710 + x664) + (x694 + x666)),
        (x742 + x714));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x761, &x762, 0x0, x745, UINT32_C(0x22d759b));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x763, &x764, x762, x747, UINT32_C(0x7998f7b9));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x765, &x766, x764, x749, UINT32_C(0x789051d3));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x767, &x768, x766, x751, UINT32_C(0xcf846e86));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x769, &x770, x768, x753, UINT32_C(0x6b41c8aa));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x771, &x772, x770, x755, UINT32_C(0xab1ec85e));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x773, &x774, x772, x757, UINT32_C(0x5a858107));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(
        &x775, &x776, x774, x759, UINT32_C(0x9b9f605f));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_subborrowx_u32(&x777, &x778,
                                                               x776, x760, 0x0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x779, x778, x761,
                                                            x745);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x780, x778, x763,
                                                            x747);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x781, x778, x765,
                                                            x749);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x782, x778, x767,
                                                            x751);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x783, x778, x769,
                                                            x753);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x784, x778, x771,
                                                            x755);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x785, x778, x773,
                                                            x757);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(&x786, x778, x775,
                                                            x759);
    out1[0] = x779;
    out1[1] = x780;
    out1[2] = x781;
    out1[3] = x782;
    out1[4] = x783;
    out1[5] = x784;
    out1[6] = x785;
    out1[7] = x786;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_nonzero outputs a single non-zero word if the input is non-zero and zero otherwise.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [0x0 ~> 0xffffffff]
 */
static void fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_nonzero(
    uint32_t *out1, const uint32_t arg1[8]) {
    uint32_t x1;
    x1 =
        ((arg1[0]) |
         ((arg1[1]) |
          ((arg1[2]) |
           ((arg1[3]) | ((arg1[4]) | ((arg1[5]) | ((arg1[6]) | (arg1[7]))))))));
    *out1 = x1;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz is a multi-limb conditional select.
 * Postconditions:
 *   eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)
 *
 * Input Bounds:
 *   arg1: [0x0 ~> 0x1]
 *   arg2: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 *   arg3: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(
    uint32_t out1[8], fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_uint1 arg1,
    const uint32_t arg2[8], const uint32_t arg3[8]) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(
        &x1, arg1, (arg2[0]), (arg3[0]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(
        &x2, arg1, (arg2[1]), (arg3[1]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(
        &x3, arg1, (arg2[2]), (arg3[2]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(
        &x4, arg1, (arg2[3]), (arg3[3]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(
        &x5, arg1, (arg2[4]), (arg3[4]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(
        &x6, arg1, (arg2[5]), (arg3[5]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(
        &x7, arg1, (arg2[6]), (arg3[6]));
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_cmovznz_u32(
        &x8, arg1, (arg2[7]), (arg3[7]));
    out1[0] = x1;
    out1[1] = x2;
    out1[2] = x3;
    out1[3] = x4;
    out1[4] = x5;
    out1[5] = x6;
    out1[6] = x7;
    out1[7] = x8;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_to_bytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order.
 * Preconditions:
 *   0 ≤ eval arg1 < m
 * Postconditions:
 *   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..31]
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_to_bytes(
    uint8_t out1[32], const uint32_t arg1[8]) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint32_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint32_t x8;
    uint8_t x9;
    uint32_t x10;
    uint8_t x11;
    uint32_t x12;
    uint8_t x13;
    uint8_t x14;
    uint8_t x15;
    uint32_t x16;
    uint8_t x17;
    uint32_t x18;
    uint8_t x19;
    uint8_t x20;
    uint8_t x21;
    uint32_t x22;
    uint8_t x23;
    uint32_t x24;
    uint8_t x25;
    uint8_t x26;
    uint8_t x27;
    uint32_t x28;
    uint8_t x29;
    uint32_t x30;
    uint8_t x31;
    uint8_t x32;
    uint8_t x33;
    uint32_t x34;
    uint8_t x35;
    uint32_t x36;
    uint8_t x37;
    uint8_t x38;
    uint8_t x39;
    uint32_t x40;
    uint8_t x41;
    uint32_t x42;
    uint8_t x43;
    uint8_t x44;
    uint8_t x45;
    uint32_t x46;
    uint8_t x47;
    uint32_t x48;
    uint8_t x49;
    uint8_t x50;
    uint8_t x51;
    uint32_t x52;
    uint8_t x53;
    uint32_t x54;
    uint8_t x55;
    uint8_t x56;
    x1 = (arg1[7]);
    x2 = (arg1[6]);
    x3 = (arg1[5]);
    x4 = (arg1[4]);
    x5 = (arg1[3]);
    x6 = (arg1[2]);
    x7 = (arg1[1]);
    x8 = (arg1[0]);
    x9 = (uint8_t)(x8 & UINT8_C(0xff));
    x10 = (x8 >> 8);
    x11 = (uint8_t)(x10 & UINT8_C(0xff));
    x12 = (x10 >> 8);
    x13 = (uint8_t)(x12 & UINT8_C(0xff));
    x14 = (uint8_t)(x12 >> 8);
    x15 = (uint8_t)(x7 & UINT8_C(0xff));
    x16 = (x7 >> 8);
    x17 = (uint8_t)(x16 & UINT8_C(0xff));
    x18 = (x16 >> 8);
    x19 = (uint8_t)(x18 & UINT8_C(0xff));
    x20 = (uint8_t)(x18 >> 8);
    x21 = (uint8_t)(x6 & UINT8_C(0xff));
    x22 = (x6 >> 8);
    x23 = (uint8_t)(x22 & UINT8_C(0xff));
    x24 = (x22 >> 8);
    x25 = (uint8_t)(x24 & UINT8_C(0xff));
    x26 = (uint8_t)(x24 >> 8);
    x27 = (uint8_t)(x5 & UINT8_C(0xff));
    x28 = (x5 >> 8);
    x29 = (uint8_t)(x28 & UINT8_C(0xff));
    x30 = (x28 >> 8);
    x31 = (uint8_t)(x30 & UINT8_C(0xff));
    x32 = (uint8_t)(x30 >> 8);
    x33 = (uint8_t)(x4 & UINT8_C(0xff));
    x34 = (x4 >> 8);
    x35 = (uint8_t)(x34 & UINT8_C(0xff));
    x36 = (x34 >> 8);
    x37 = (uint8_t)(x36 & UINT8_C(0xff));
    x38 = (uint8_t)(x36 >> 8);
    x39 = (uint8_t)(x3 & UINT8_C(0xff));
    x40 = (x3 >> 8);
    x41 = (uint8_t)(x40 & UINT8_C(0xff));
    x42 = (x40 >> 8);
    x43 = (uint8_t)(x42 & UINT8_C(0xff));
    x44 = (uint8_t)(x42 >> 8);
    x45 = (uint8_t)(x2 & UINT8_C(0xff));
    x46 = (x2 >> 8);
    x47 = (uint8_t)(x46 & UINT8_C(0xff));
    x48 = (x46 >> 8);
    x49 = (uint8_t)(x48 & UINT8_C(0xff));
    x50 = (uint8_t)(x48 >> 8);
    x51 = (uint8_t)(x1 & UINT8_C(0xff));
    x52 = (x1 >> 8);
    x53 = (uint8_t)(x52 & UINT8_C(0xff));
    x54 = (x52 >> 8);
    x55 = (uint8_t)(x54 & UINT8_C(0xff));
    x56 = (uint8_t)(x54 >> 8);
    out1[0] = x9;
    out1[1] = x11;
    out1[2] = x13;
    out1[3] = x14;
    out1[4] = x15;
    out1[5] = x17;
    out1[6] = x19;
    out1[7] = x20;
    out1[8] = x21;
    out1[9] = x23;
    out1[10] = x25;
    out1[11] = x26;
    out1[12] = x27;
    out1[13] = x29;
    out1[14] = x31;
    out1[15] = x32;
    out1[16] = x33;
    out1[17] = x35;
    out1[18] = x37;
    out1[19] = x38;
    out1[20] = x39;
    out1[21] = x41;
    out1[22] = x43;
    out1[23] = x44;
    out1[24] = x45;
    out1[25] = x47;
    out1[26] = x49;
    out1[27] = x50;
    out1[28] = x51;
    out1[29] = x53;
    out1[30] = x55;
    out1[31] = x56;
}

/*
 * The function fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_from_bytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order.
 * Preconditions:
 *   0 ≤ bytes_eval arg1 < m
 * Postconditions:
 *   eval out1 mod m = bytes_eval arg1 mod m
 *   0 ≤ eval out1 < m
 *
 * Input Bounds:
 *   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
 * Output Bounds:
 *   out1: [[0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff], [0x0 ~> 0xffffffff]]
 */
static void fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_from_bytes(
    uint32_t out1[8], const uint8_t arg1[32]) {
    uint32_t x1;
    uint32_t x2;
    uint32_t x3;
    uint8_t x4;
    uint32_t x5;
    uint32_t x6;
    uint32_t x7;
    uint8_t x8;
    uint32_t x9;
    uint32_t x10;
    uint32_t x11;
    uint8_t x12;
    uint32_t x13;
    uint32_t x14;
    uint32_t x15;
    uint8_t x16;
    uint32_t x17;
    uint32_t x18;
    uint32_t x19;
    uint8_t x20;
    uint32_t x21;
    uint32_t x22;
    uint32_t x23;
    uint8_t x24;
    uint32_t x25;
    uint32_t x26;
    uint32_t x27;
    uint8_t x28;
    uint32_t x29;
    uint32_t x30;
    uint32_t x31;
    uint8_t x32;
    uint32_t x33;
    uint32_t x34;
    uint32_t x35;
    uint32_t x36;
    uint32_t x37;
    uint32_t x38;
    uint32_t x39;
    uint32_t x40;
    uint32_t x41;
    uint32_t x42;
    uint32_t x43;
    uint32_t x44;
    uint32_t x45;
    uint32_t x46;
    uint32_t x47;
    uint32_t x48;
    uint32_t x49;
    uint32_t x50;
    uint32_t x51;
    uint32_t x52;
    uint32_t x53;
    uint32_t x54;
    uint32_t x55;
    uint32_t x56;
    x1 = ((uint32_t)(arg1[31]) << 24);
    x2 = ((uint32_t)(arg1[30]) << 16);
    x3 = ((uint32_t)(arg1[29]) << 8);
    x4 = (arg1[28]);
    x5 = ((uint32_t)(arg1[27]) << 24);
    x6 = ((uint32_t)(arg1[26]) << 16);
    x7 = ((uint32_t)(arg1[25]) << 8);
    x8 = (arg1[24]);
    x9 = ((uint32_t)(arg1[23]) << 24);
    x10 = ((uint32_t)(arg1[22]) << 16);
    x11 = ((uint32_t)(arg1[21]) << 8);
    x12 = (arg1[20]);
    x13 = ((uint32_t)(arg1[19]) << 24);
    x14 = ((uint32_t)(arg1[18]) << 16);
    x15 = ((uint32_t)(arg1[17]) << 8);
    x16 = (arg1[16]);
    x17 = ((uint32_t)(arg1[15]) << 24);
    x18 = ((uint32_t)(arg1[14]) << 16);
    x19 = ((uint32_t)(arg1[13]) << 8);
    x20 = (arg1[12]);
    x21 = ((uint32_t)(arg1[11]) << 24);
    x22 = ((uint32_t)(arg1[10]) << 16);
    x23 = ((uint32_t)(arg1[9]) << 8);
    x24 = (arg1[8]);
    x25 = ((uint32_t)(arg1[7]) << 24);
    x26 = ((uint32_t)(arg1[6]) << 16);
    x27 = ((uint32_t)(arg1[5]) << 8);
    x28 = (arg1[4]);
    x29 = ((uint32_t)(arg1[3]) << 24);
    x30 = ((uint32_t)(arg1[2]) << 16);
    x31 = ((uint32_t)(arg1[1]) << 8);
    x32 = (arg1[0]);
    x33 = (x31 + (uint32_t)x32);
    x34 = (x30 + x33);
    x35 = (x29 + x34);
    x36 = (x27 + (uint32_t)x28);
    x37 = (x26 + x36);
    x38 = (x25 + x37);
    x39 = (x23 + (uint32_t)x24);
    x40 = (x22 + x39);
    x41 = (x21 + x40);
    x42 = (x19 + (uint32_t)x20);
    x43 = (x18 + x42);
    x44 = (x17 + x43);
    x45 = (x15 + (uint32_t)x16);
    x46 = (x14 + x45);
    x47 = (x13 + x46);
    x48 = (x11 + (uint32_t)x12);
    x49 = (x10 + x48);
    x50 = (x9 + x49);
    x51 = (x7 + (uint32_t)x8);
    x52 = (x6 + x51);
    x53 = (x5 + x52);
    x54 = (x3 + (uint32_t)x4);
    x55 = (x2 + x54);
    x56 = (x1 + x55);
    out1[0] = x35;
    out1[1] = x38;
    out1[2] = x41;
    out1[3] = x44;
    out1[4] = x47;
    out1[5] = x50;
    out1[6] = x53;
    out1[7] = x56;
}

/* END verbatim fiat code */

/*-
 * Finite field inversion via FLT.
 * NB: this is not a real Fiat function, just named that way for consistency.
 * Autogenerated: ecp/id_GostR3410_2001_CryptoPro_C_ParamSet/fe_inv.op3
 * sliding window w=5
 */
static void fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_inv(fe_t output,
                                                            const fe_t t1) {
    int i;
    /* temporary variables */
    fe_t acc, t11, t13, t15, t17, t19, t21, t23, t25, t27, t29, t3, t31, t5, t7,
        t9;

    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, t1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t3, t1, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t5, t3, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t7, t5, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t9, t7, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t11, t9, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t13, t11, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t15, t13, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t17, t15, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t19, t17, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t21, t19, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t23, t21, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t25, t23, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t27, t25, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t29, t27, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t31, t29, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, t9);
    for (i = 0; i < 4; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t23);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t7);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t27);
    for (i = 0; i < 7; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t1);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t15);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t21);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t21);
    for (i = 0; i < 8; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t11);
    for (i = 0; i < 7; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t1);
    for (i = 0; i < 6; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t1);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t29);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t11);
    for (i = 0; i < 7; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t15);
    for (i = 0; i < 6; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t25);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t1);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t15);
    for (i = 0; i < 6; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t13);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t13);
    for (i = 0; i < 6; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t1);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t25);
    for (i = 0; i < 8; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t21);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t11);
    for (i = 0; i < 7; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t31);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t1);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t3);
    for (i = 0; i < 6; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t29);
    for (i = 0; i < 6; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t3);
    for (i = 0; i < 6; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t15);
    for (i = 0; i < 7; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t9);
    for (i = 0; i < 8; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t5);
    for (i = 0; i < 6; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t7);
    for (i = 0; i < 6; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t19);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t15);
    for (i = 0; i < 7; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t25);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t17);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t29);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t29);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t25);
    for (i = 0; i < 7; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t1);
    for (i = 0; i < 7; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t11);
    for (i = 0; i < 6; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t23);
    for (i = 0; i < 5; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(acc, acc, t11);
    for (i = 0; i < 7; i++)
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(acc, acc);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(output, acc, t25);
}

/* curve coefficient constants */

static const limb_t const_one[8] = {UINT32_C(0xFDD28A65), UINT32_C(0x86670846),
                                    UINT32_C(0x876FAE2C), UINT32_C(0x307B9179),
                                    UINT32_C(0x94BE3755), UINT32_C(0x54E137A1),
                                    UINT32_C(0xA57A7EF8), UINT32_C(0x64609FA0)};

static const limb_t const_b[8] = {UINT32_C(0x3BDA2ACF), UINT32_C(0x4BE8A4E9),
                                  UINT32_C(0x90D382DD), UINT32_C(0x79CC0E3E),
                                  UINT32_C(0x1D9CC79B), UINT32_C(0x3BA4C8B0),
                                  UINT32_C(0x966609E9), UINT32_C(0x5CC73B5A)};

/* LUT for scalar multiplication by comb interleaving */
static const pt_aff_t lut_cmb[27][16] = {
    {
        {{UINT32_C(0x00000000), UINT32_C(0x00000000), UINT32_C(0x00000000),
          UINT32_C(0x00000000), UINT32_C(0x00000000), UINT32_C(0x00000000),
          UINT32_C(0x00000000), UINT32_C(0x00000000)},
         {UINT32_C(0x00254F12), UINT32_C(0xD082E007), UINT32_C(0xEB1F1421),
          UINT32_C(0xC5BA8184), UINT32_C(0xF010780D), UINT32_C(0x4EC9E7D0),
          UINT32_C(0x2794C8D5), UINT32_C(0x7846B5B7)}},
        {{UINT32_C(0x7225A595), UINT32_C(0x870FB041), UINT32_C(0x5FD57F04),
          UINT32_C(0x6CAFAE70), UINT32_C(0x2E7DB9BA), UINT32_C(0xFEC1C2AC),
          UINT32_C(0x127A5862), UINT32_C(0x9230823E)},
         {UINT32_C(0xE4464836), UINT32_C(0xF6CFDB6D), UINT32_C(0x9A945AC0),
          UINT32_C(0x3D79631B), UINT32_C(0x3D0C880D), UINT32_C(0xA1FCF2DF),
          UINT32_C(0x0EE6A611), UINT32_C(0x17C83E50)}},
        {{UINT32_C(0xE42734FD), UINT32_C(0x3C79C11A), UINT32_C(0xAC4040C3),
          UINT32_C(0x1614B2BE), UINT32_C(0x2C3A23A5), UINT32_C(0xDD143725),
          UINT32_C(0x8AF4F7CD), UINT32_C(0x1A02DA83)},
         {UINT32_C(0xE7D6991A), UINT32_C(0x23D588D6), UINT32_C(0xD2B3E364),
          UINT32_C(0x5F332676), UINT32_C(0x9134BA88), UINT32_C(0x35382680),
          UINT32_C(0xD27090E5), UINT32_C(0x08ECA826)}},
        {{UINT32_C(0x26761106), UINT32_C(0x231F8DC8), UINT32_C(0x3D78B14B),
          UINT32_C(0x7363050E), UINT32_C(0xC05C4381), UINT32_C(0xC3B9A1B8),
          UINT32_C(0xB8ACD9AC), UINT32_C(0x29727635)},
         {UINT32_C(0x2ED54E6C), UINT32_C(0xDD416AE9), UINT32_C(0x0B48A87C),
          UINT32_C(0x54608435), UINT32_C(0x97093D22), UINT32_C(0x2C8DEEA4),
          UINT32_C(0x0D716BAF), UINT32_C(0x87D2924C)}},
        {{UINT32_C(0x619206D6), UINT32_C(0x43281D30), UINT32_C(0x68744E44),
          UINT32_C(0x4A8FFC87), UINT32_C(0x708208D5), UINT32_C(0xB1011A3D),
          UINT32_C(0xA035B0B9), UINT32_C(0x2FE86E7B)},
         {UINT32_C(0xA3762860), UINT32_C(0x82F43088), UINT32_C(0xB33595D4),
          UINT32_C(0x67B5A303), UINT32_C(0xB477BECD), UINT32_C(0x262F16EB),
          UINT32_C(0x23E2816A), UINT32_C(0x1D38D4A7)}},
        {{UINT32_C(0xAD83C032), UINT32_C(0x91BBA3C0), UINT32_C(0x234F2FF3),
          UINT32_C(0x7DBC2EB6), UINT32_C(0x6D18A737), UINT32_C(0xE2C00C15),
          UINT32_C(0xCCF6DC2D), UINT32_C(0x71D1AE8B)},
         {UINT32_C(0x2DB77239), UINT32_C(0x6183816A), UINT32_C(0x0E228C41),
          UINT32_C(0xC545A512), UINT32_C(0x0F49A679), UINT32_C(0x3B96D6BC),
          UINT32_C(0xE49E39C2), UINT32_C(0x9831D683)}},
        {{UINT32_C(0x20DA13D9), UINT32_C(0xEEAA17A9), UINT32_C(0x8ABECADE),
          UINT32_C(0xEE3130FB), UINT32_C(0xA6E3D089), UINT32_C(0xBFB2CE6A),
          UINT32_C(0xE627A07C), UINT32_C(0x22BCDCEE)},
         {UINT32_C(0x955A1D9E), UINT32_C(0x86D7A50C), UINT32_C(0xE4E00B9E),
          UINT32_C(0xCD60A425), UINT32_C(0x615B9E91), UINT32_C(0x5407A6F8),
          UINT32_C(0x4F1CA93D), UINT32_C(0x7F17B171)}},
        {{UINT32_C(0x0DB59F2C), UINT32_C(0xBC351DE0), UINT32_C(0x9CDAF8AF),
          UINT32_C(0x1470E6A1), UINT32_C(0x60D3B27A), UINT32_C(0x461ED289),
          UINT32_C(0x49C7F789), UINT32_C(0x122C8F4B)},
         {UINT32_C(0x069FC8CE), UINT32_C(0xAB56E614), UINT32_C(0xC34E487C),
          UINT32_C(0x9836B010), UINT32_C(0x3FE009EB), UINT32_C(0x9EE06703),
          UINT32_C(0xAA019563), UINT32_C(0x88C8DC64)}},
        {{UINT32_C(0x63DDBB1F), UINT32_C(0xD0B4A996), UINT32_C(0x1D154696),
          UINT32_C(0x483286E5), UINT32_C(0x9F0D6F4E), UINT32_C(0xF0586DB8),
          UINT32_C(0x980446C8), UINT32_C(0x38167987)},
         {UINT32_C(0xE4166B55), UINT32_C(0x86A2ABAC), UINT32_C(0xA8366C64),
          UINT32_C(0x4E7B4F96), UINT32_C(0xED997D8E), UINT32_C(0x20CF2108),
          UINT32_C(0x1D01C009), UINT32_C(0x20EA9844)}},
        {{UINT32_C(0xB89CE05A), UINT32_C(0x028B520E), UINT32_C(0x4FAAD420),
          UINT32_C(0xEF41147D), UINT32_C(0x121A2A0A), UINT32_C(0xB280CCD3),
          UINT32_C(0x86E8F591), UINT32_C(0x4C677C83)},
         {UINT32_C(0xA390AA99), UINT32_C(0xB42F67B2), UINT32_C(0x19F8A01A),
          UINT32_C(0xC4EF553B), UINT32_C(0x6979027F), UINT32_C(0x86761139),
          UINT32_C(0x82C202BE), UINT32_C(0x6F177663)}},
        {{UINT32_C(0x27C5C7CC), UINT32_C(0xBEF6B996), UINT32_C(0x10799DB8),
          UINT32_C(0xB2D34F8B), UINT32_C(0x48AD9B1E), UINT32_C(0x132E1A3D),
          UINT32_C(0xE68B9907), UINT32_C(0x2971BFED)},
         {UINT32_C(0xC6B743B5), UINT32_C(0x312F6D31), UINT32_C(0xA718E0A8),
          UINT32_C(0xCF123317), UINT32_C(0xFD58637C), UINT32_C(0xCF1E5266),
          UINT32_C(0xE046167C), UINT32_C(0x56BA8362)}},
        {{UINT32_C(0x0E910D7F), UINT32_C(0xD680969D), UINT32_C(0x8A4689F9),
          UINT32_C(0x634FB3C2), UINT32_C(0x09FDD299), UINT32_C(0xA79A56DF),
          UINT32_C(0x89411C3D), UINT32_C(0x9065269E)},
         {UINT32_C(0x82C6076C), UINT32_C(0x5D22254E), UINT32_C(0x81FEA171),
          UINT32_C(0xDE7D78F0), UINT32_C(0x10BCDA87), UINT32_C(0xE1366964),
          UINT32_C(0x97638B85), UINT32_C(0x98B58F5A)}},
        {{UINT32_C(0xFB5EDF3F), UINT32_C(0xA532DED4), UINT32_C(0x833A7E2F),
          UINT32_C(0x604E5631), UINT32_C(0x3A09C74E), UINT32_C(0x7C4051D3),
          UINT32_C(0xEDFBEB4B), UINT32_C(0x51D1108A)},
         {UINT32_C(0x4DF1AB4D), UINT32_C(0x9AE61F9E), UINT32_C(0x163DB1A5),
          UINT32_C(0xFD4966F3), UINT32_C(0x7075AD6D), UINT32_C(0xF6C44E55),
          UINT32_C(0x4AF24611), UINT32_C(0x670D0D6F)}},
        {{UINT32_C(0xD369D301), UINT32_C(0xD99925FF), UINT32_C(0x7665BCF4),
          UINT32_C(0xC17E9767), UINT32_C(0xCB5A2128), UINT32_C(0xB5A908F1),
          UINT32_C(0x9C726C9F), UINT32_C(0x1981791D)},
         {UINT32_C(0xE0861F4E), UINT32_C(0xC4249418), UINT32_C(0xEE045D5E),
          UINT32_C(0x2A63399F), UINT32_C(0xA1B974FF), UINT32_C(0x246958FD),
          UINT32_C(0x0FC6F7A0), UINT32_C(0x668016A2)}},
        {{UINT32_C(0xEDE07C08), UINT32_C(0xEB7018AD), UINT32_C(0x2E33D1D9),
          UINT32_C(0xDF3C1259), UINT32_C(0xDC24E3DE), UINT32_C(0xEE0913DA),
          UINT32_C(0x35EB6B0D), UINT32_C(0x1C632D5B)},
         {UINT32_C(0x2C56E1B2), UINT32_C(0xC69396DD), UINT32_C(0xA837CE8F),
          UINT32_C(0x01F0B034), UINT32_C(0xB6882E32), UINT32_C(0x7842B98D),
          UINT32_C(0x9E61FCA6), UINT32_C(0x8FAC9230)}},
        {{UINT32_C(0x8A782CFE), UINT32_C(0x1DBB7D99), UINT32_C(0xC9322BE7),
          UINT32_C(0xEB945B49), UINT32_C(0xE208123B), UINT32_C(0xDCCB4E6E),
          UINT32_C(0xFC024524), UINT32_C(0x1C7C265C)},
         {UINT32_C(0x6102BC63), UINT32_C(0xAD000D8A), UINT32_C(0x82575943),
          UINT32_C(0x7D7F3C7B), UINT32_C(0x0D547A95), UINT32_C(0x8D2F0881),
          UINT32_C(0xD94FFA6D), UINT32_C(0x7012377A)}},
    },
    {
        {{UINT32_C(0x1EB6CBF7), UINT32_C(0xE3F78DE5), UINT32_C(0x72FA65DB),
          UINT32_C(0xF4E08A61), UINT32_C(0x502A247E), UINT32_C(0x670B0E06),
          UINT32_C(0x9877E492), UINT32_C(0x7A45D73E)},
         {UINT32_C(0x3DD0CDBC), UINT32_C(0x5FD754AD), UINT32_C(0x0125AB1F),
          UINT32_C(0xA5C2B15E), UINT32_C(0xE614B7A9), UINT32_C(0xC503836F),
          UINT32_C(0x2C50DCFE), UINT32_C(0x5548C424)}},
        {{UINT32_C(0xB9B38743), UINT32_C(0xCEE7BE65), UINT32_C(0x94BE028E),
          UINT32_C(0xD5E41715), UINT32_C(0xB5C45F7D), UINT32_C(0x08EC3CA3),
          UINT32_C(0xFB51261A), UINT32_C(0x1ACFAC17)},
         {UINT32_C(0xA9C04381), UINT32_C(0x45098D93), UINT32_C(0xA5B45DC8),
          UINT32_C(0x717FC0DC), UINT32_C(0xEABEE4E5), UINT32_C(0xF352A9C2),
          UINT32_C(0xF311B457), UINT32_C(0x1964AF20)}},
        {{UINT32_C(0x0802A755), UINT32_C(0x8C229808), UINT32_C(0x6140CDA7),
          UINT32_C(0x46F0A7CA), UINT32_C(0xBC62603B), UINT32_C(0xF0EEB7AE),
          UINT32_C(0x4BF4B451), UINT32_C(0x8432E152)},
         {UINT32_C(0x63967F94), UINT32_C(0x3C319825), UINT32_C(0xA042AE13),
          UINT32_C(0xF04EACB6), UINT32_C(0x650A6ADB), UINT32_C(0xD7CB2DBC),
          UINT32_C(0x78C9E166), UINT32_C(0x38A36EE3)}},
        {{UINT32_C(0xD3EE8657), UINT32_C(0x3527A5C5), UINT32_C(0x101645F9),
          UINT32_C(0xBAA0DE97), UINT32_C(0xCE9D6A48), UINT32_C(0xC59C9803),
          UINT32_C(0xF8F39FDF), UINT32_C(0x43D12449)},
         {UINT32_C(0x8DF7A72B), UINT32_C(0x65B3AB98), UINT32_C(0xAFDA9048),
          UINT32_C(0xD225AF8E), UINT32_C(0x338A3694), UINT32_C(0x88C368B8),
          UINT32_C(0xFBC813F1), UINT32_C(0x4A5A3C24)}},
        {{UINT32_C(0x9E2118B5), UINT32_C(0xCBCB725A), UINT32_C(0xCAA54794),
          UINT32_C(0x113F36C5), UINT32_C(0x4A0A2267), UINT32_C(0x5900990E),
          UINT32_C(0x0A9C1F11), UINT32_C(0x4E329EB1)},
         {UINT32_C(0xCD8918A7), UINT32_C(0xF47F4077), UINT32_C(0x3877B404),
          UINT32_C(0x18A3C071), UINT32_C(0xEFEB2B6B), UINT32_C(0xCDEF4FE3),
          UINT32_C(0xDE4D0540), UINT32_C(0x360982DB)}},
        {{UINT32_C(0xD5F8DACA), UINT32_C(0x42AB64F2), UINT32_C(0xEE88523D),
          UINT32_C(0x604A9676), UINT32_C(0xAEFD1283), UINT32_C(0xD430CCAB),
          UINT32_C(0x54465F7C), UINT32_C(0x3DA9D0E5)},
         {UINT32_C(0x41A4216B), UINT32_C(0x5EC145DF), UINT32_C(0xF7E7FBD9),
          UINT32_C(0x7C8F2C51), UINT32_C(0xBD483D26), UINT32_C(0xA2E58A23),
          UINT32_C(0xE4A908C8), UINT32_C(0x4739F7F9)}},
        {{UINT32_C(0x79370382), UINT32_C(0x37DDF872), UINT32_C(0x12C8E90E),
          UINT32_C(0x9D26A55F), UINT32_C(0xE8EB0CA4), UINT32_C(0xFC1FA6CD),
          UINT32_C(0xC29DC4F9), UINT32_C(0x826A29E5)},
         {UINT32_C(0xAA29F814), UINT32_C(0x15ECB621), UINT32_C(0x9DF1DFF7),
          UINT32_C(0x4C8A8128), UINT32_C(0x66B549BB), UINT32_C(0xBB223019),
          UINT32_C(0xB81A2863), UINT32_C(0x6CB21ACB)}},
        {{UINT32_C(0x11DA6928), UINT32_C(0xDD31ACC2), UINT32_C(0xA903D58F),
          UINT32_C(0xF98867B0), UINT32_C(0xD3679348), UINT32_C(0xAD283697),
          UINT32_C(0x301C3571), UINT32_C(0x67BFEFF9)},
         {UINT32_C(0x780BBBCE), UINT32_C(0xB745CAE6), UINT32_C(0x62F2EC5D),
          UINT32_C(0x1A9C6618), UINT32_C(0xA1475BEB), UINT32_C(0xF9895684),
          UINT32_C(0x4731A11D), UINT32_C(0x93E5ACE6)}},
        {{UINT32_C(0x7539483E), UINT32_C(0x0F6E9460), UINT32_C(0x9EF4EF16),
          UINT32_C(0x5728E6DD), UINT32_C(0x062E946E), UINT32_C(0xE1DA86E1),
          UINT32_C(0xF2E07759), UINT32_C(0x272EBC47)},
         {UINT32_C(0x909A578F), UINT32_C(0xE5E688E3), UINT32_C(0x7CFD1B7D),
          UINT32_C(0x9F25D6D1), UINT32_C(0xADE1E2A4), UINT32_C(0xC582260F),
          UINT32_C(0xA050071E), UINT32_C(0x2F50F74E)}},
        {{UINT32_C(0x2DF4D40D), UINT32_C(0xE0A8FE3F), UINT32_C(0x07791F88),
          UINT32_C(0xB126E4EF), UINT32_C(0x2A88D242), UINT32_C(0x69759DB4),
          UINT32_C(0xC9C1981C), UINT32_C(0x52592A3B)},
         {UINT32_C(0x72F649A1), UINT32_C(0xD0F41728), UINT32_C(0x0750EBAB),
          UINT32_C(0x9FF19B2B), UINT32_C(0xE0D7D222), UINT32_C(0xEFC047F9),
          UINT32_C(0x2E8140AF), UINT32_C(0x81491CA1)}},
        {{UINT32_C(0x675F821B), UINT32_C(0x2DA40FF1), UINT32_C(0x9E2E0502),
          UINT32_C(0x2C91A287), UINT32_C(0x077D81FE), UINT32_C(0x993ECFF4),
          UINT32_C(0x71CC3DAE), UINT32_C(0x3ABA2F2C)},
         {UINT32_C(0x168413DB), UINT32_C(0xED007670), UINT32_C(0xAFBD4E82),
          UINT32_C(0xC07D61B5), UINT32_C(0x6BBADA24), UINT32_C(0xF078262E),
          UINT32_C(0x9E6413CC), UINT32_C(0x0E0EDC62)}},
        {{UINT32_C(0xB7D099F9), UINT32_C(0x6CD0451D), UINT32_C(0xF8B12C83),
          UINT32_C(0x8FB218E6), UINT32_C(0xE55EE1E4), UINT32_C(0x4D8C3B26),
          UINT32_C(0x4A6FCD90), UINT32_C(0x94964906)},
         {UINT32_C(0x4BEACA48), UINT32_C(0x9ABB9685), UINT32_C(0x868EFEC7),
          UINT32_C(0x6A749487), UINT32_C(0xC8D2932C), UINT32_C(0x46BB9B42),
          UINT32_C(0xDE007BAC), UINT32_C(0x82384321)}},
        {{UINT32_C(0xA942DB71), UINT32_C(0xDBECB743), UINT32_C(0x21A6BC46),
          UINT32_C(0x21B52115), UINT32_C(0x24C17D78), UINT32_C(0xE49B6894),
          UINT32_C(0x89A08E17), UINT32_C(0x737FD3F1)},
         {UINT32_C(0xC36E4E57), UINT32_C(0xF833E404), UINT32_C(0x01E17CE6),
          UINT32_C(0x512C114A), UINT32_C(0x50D75050), UINT32_C(0x65A23D73),
          UINT32_C(0xF2F2D438), UINT32_C(0x838CA746)}},
        {{UINT32_C(0xA20632B7), UINT32_C(0x28F9220C), UINT32_C(0x642358D6),
          UINT32_C(0x72D8C347), UINT32_C(0xE89CAA6F), UINT32_C(0xAB15FE1B),
          UINT32_C(0x6E16374A), UINT32_C(0x2A09B143)},
         {UINT32_C(0xB983CFE8), UINT32_C(0x4CED0986), UINT32_C(0x97B84E88),
          UINT32_C(0xD9B067B6), UINT32_C(0xC2350F8F), UINT32_C(0x926FC5F5),
          UINT32_C(0x84E2078F), UINT32_C(0x31D77358)}},
        {{UINT32_C(0x7FF17BA1), UINT32_C(0xA7815CE7), UINT32_C(0xA26BBA1B),
          UINT32_C(0xBE80BB6C), UINT32_C(0xF86DF104), UINT32_C(0x66DAE535),
          UINT32_C(0xAB1B9C09), UINT32_C(0x72739199)},
         {UINT32_C(0x54056E67), UINT32_C(0x8E93F3C8), UINT32_C(0xEBF23595),
          UINT32_C(0xDC5E3855), UINT32_C(0x78123000), UINT32_C(0x70D1033C),
          UINT32_C(0xF22DD2BD), UINT32_C(0x50874350)}},
        {{UINT32_C(0xC2700468), UINT32_C(0x533F213B), UINT32_C(0x11BEA732),
          UINT32_C(0x31E6AA9C), UINT32_C(0x4491DC82), UINT32_C(0xCB5E184E),
          UINT32_C(0x5BD63975), UINT32_C(0x8A68049A)},
         {UINT32_C(0xF86A41D1), UINT32_C(0x1724AC47), UINT32_C(0xECA0DA11),
          UINT32_C(0xDF9A0CA3), UINT32_C(0x71F0EA19), UINT32_C(0xE5E1489C),
          UINT32_C(0xC9DC7BF2), UINT32_C(0x0E20661A)}},
    },
    {
        {{UINT32_C(0xF86D9DA8), UINT32_C(0x5EB4E319), UINT32_C(0xE0A46703),
          UINT32_C(0x3CBF130E), UINT32_C(0x00A4AB17), UINT32_C(0x166D52DA),
          UINT32_C(0xB7030861), UINT32_C(0x27A80547)},
         {UINT32_C(0x399C32BA), UINT32_C(0xA7601086), UINT32_C(0xC2F0A5E5),
          UINT32_C(0x571E4E4B), UINT32_C(0x39BED44D), UINT32_C(0x72D12F6B),
          UINT32_C(0x1AF8F25F), UINT32_C(0x8FDCCE3D)}},
        {{UINT32_C(0x7DFEB40D), UINT32_C(0x281F7AF9), UINT32_C(0xD7F767D5),
          UINT32_C(0x0CCE33B9), UINT32_C(0x8818C1E6), UINT32_C(0x3E8BF3F4),
          UINT32_C(0x4BA4647A), UINT32_C(0x6D909D0D)},
         {UINT32_C(0xFAC574D1), UINT32_C(0x91D77BA0), UINT32_C(0x68CA7FEC),
          UINT32_C(0xD2592661), UINT32_C(0x281F269C), UINT32_C(0xC4C7D6B5),
          UINT32_C(0xDA42CDDD), UINT32_C(0x7A41CD78)}},
        {{UINT32_C(0xA3B8F255), UINT32_C(0xBC8E0D27), UINT32_C(0x1C3E5190),
          UINT32_C(0xF5E2A8B1), UINT32_C(0xD609F668), UINT32_C(0x8C38862B),
          UINT32_C(0x0631D50F), UINT32_C(0x4E31C18E)},
         {UINT32_C(0xF13E0CCD), UINT32_C(0x9013EDDB), UINT32_C(0x41EFDAF7),
          UINT32_C(0x83B04E68), UINT32_C(0xDC82597F), UINT32_C(0x15EC4BB8),
          UINT32_C(0x56117705), UINT32_C(0x50595150)}},
        {{UINT32_C(0x1E0E0161), UINT32_C(0xD25F244D), UINT32_C(0x1A437FBA),
          UINT32_C(0x6C975D7B), UINT32_C(0x95F2AD8C), UINT32_C(0x305DB2DF),
          UINT32_C(0x3B9CC742), UINT32_C(0x17D6E005)},
         {UINT32_C(0xE60BC3C3), UINT32_C(0x6A849F76), UINT32_C(0xBF8C3790),
          UINT32_C(0x35523E08), UINT32_C(0x239140E2), UINT32_C(0xF18B5335),
          UINT32_C(0x7CA5FF40), UINT32_C(0x5E857055)}},
        {{UINT32_C(0xA4250E95), UINT32_C(0xB48F07A4), UINT32_C(0xC7F17667),
          UINT32_C(0x068735AE), UINT32_C(0x94771B24), UINT32_C(0x30F8D313),
          UINT32_C(0xA495A064), UINT32_C(0x598EA397)},
         {UINT32_C(0x68B76855), UINT32_C(0xBF192529), UINT32_C(0xC7C0D2D6),
          UINT32_C(0x897E3CC6), UINT32_C(0x64EC9649), UINT32_C(0xA2A4948F),
          UINT32_C(0xAE7C8598), UINT32_C(0x1027891A)}},
        {{UINT32_C(0x04585685), UINT32_C(0x0442E6CB), UINT32_C(0x82A2D258),
          UINT32_C(0x09BA61DA), UINT32_C(0x0AE5466D), UINT32_C(0x7C5400B1),
          UINT32_C(0xC2133893), UINT32_C(0x0A0B71B0)},
         {UINT32_C(0xD5EF6E93), UINT32_C(0x04E3D98A), UINT32_C(0xF332BDF2),
          UINT32_C(0x177EA5F8), UINT32_C(0xC3FAE583), UINT32_C(0xE7CF3F71),
          UINT32_C(0x8AE0CFD7), UINT32_C(0x40C45133)}},
        {{UINT32_C(0x9B82E738), UINT32_C(0x6BE94FC3), UINT32_C(0x8BC262E2),
          UINT32_C(0x212FB804), UINT32_C(0xB22E21FF), UINT32_C(0xE17F6A7A),
          UINT32_C(0x15E960BB), UINT32_C(0x22B7BDAB)},
         {UINT32_C(0x771350C2), UINT32_C(0xE154C945), UINT32_C(0x882DB07B),
          UINT32_C(0x6505B8EB), UINT32_C(0xC7E3ABD3), UINT32_C(0x149A0A16),
          UINT32_C(0x81C30AAE), UINT32_C(0x78F78ABF)}},
        {{UINT32_C(0xC954BC0A), UINT32_C(0x6ED81415), UINT32_C(0x70E55349),
          UINT32_C(0x316E8012), UINT32_C(0x50399C09), UINT32_C(0xEC02323B),
          UINT32_C(0x8559C3A9), UINT32_C(0x963BA97B)},
         {UINT32_C(0x037EC345), UINT32_C(0x39FCE50E), UINT32_C(0xD5BF03FB),
          UINT32_C(0x422A082D), UINT32_C(0x18DCC77E), UINT32_C(0x59ED39E4),
          UINT32_C(0xA40AA978), UINT32_C(0x4CFC3F11)}},
        {{UINT32_C(0x55D7C9B6), UINT32_C(0x85A56922), UINT32_C(0xB451111B),
          UINT32_C(0x5BC590E2), UINT32_C(0x8782C71B), UINT32_C(0x3BCB2315),
          UINT32_C(0x632246A9), UINT32_C(0x1F3456C4)},
         {UINT32_C(0x9CFBBE19), UINT32_C(0xEA577AD9), UINT32_C(0x35CCE939),
          UINT32_C(0x051BEE40), UINT32_C(0x1A0C589C), UINT32_C(0xDC300899),
          UINT32_C(0xD2095619), UINT32_C(0x14877ECE)}},
        {{UINT32_C(0x95024C5E), UINT32_C(0xB64D0EC6), UINT32_C(0xB94CDF74),
          UINT32_C(0xB0597195), UINT32_C(0x16844010), UINT32_C(0x3B97B513),
          UINT32_C(0xCCBABC63), UINT32_C(0x48799881)},
         {UINT32_C(0xD9819075), UINT32_C(0x0E3119AE), UINT32_C(0xEB0299FD),
          UINT32_C(0xA5DCA9C1), UINT32_C(0x4A404D13), UINT32_C(0x8063D788),
          UINT32_C(0x8044EBE2), UINT32_C(0x974D2A1A)}},
        {{UINT32_C(0xB8E14640), UINT32_C(0xB6589045), UINT32_C(0x5507B9BE),
          UINT32_C(0xFAD60A43), UINT32_C(0x56FF32BC), UINT32_C(0x9D540C1C),
          UINT32_C(0x74265A69), UINT32_C(0x47ECC24F)},
         {UINT32_C(0xDB3E64C9), UINT32_C(0x0C829F18), UINT32_C(0x72E87B2B),
          UINT32_C(0xF7C0C6D7), UINT32_C(0x16B616CE), UINT32_C(0xCB3FC512),
          UINT32_C(0xB94F69B1), UINT32_C(0x549B9227)}},
        {{UINT32_C(0xDB235273), UINT32_C(0xB151DEE9), UINT32_C(0x6D65606C),
          UINT32_C(0x2FD9496F), UINT32_C(0xD62B5B0D), UINT32_C(0x6A5E172D),
          UINT32_C(0xEA0AE249), UINT32_C(0x181E605D)},
         {UINT32_C(0x8911490A), UINT32_C(0x66D7EB09), UINT32_C(0x2E70DEF2),
          UINT32_C(0x85E174A3), UINT32_C(0x4EF8CFA9), UINT32_C(0x2DA13354),
          UINT32_C(0x3E69BD22), UINT32_C(0x1B87FE62)}},
        {{UINT32_C(0x2BB09564), UINT32_C(0x2DF420CA), UINT32_C(0x7ACEE4D4),
          UINT32_C(0x1AC26F76), UINT32_C(0x2BC7EF7A), UINT32_C(0x50C68E6F),
          UINT32_C(0xB445B2FE), UINT32_C(0x4730D654)},
         {UINT32_C(0x8B57D38D), UINT32_C(0x90C040D9), UINT32_C(0x33CA2C77),
          UINT32_C(0x28793DB5), UINT32_C(0xAC6A4BE8), UINT32_C(0x22D2B573),
          UINT32_C(0xB72E7E01), UINT32_C(0x68C0DBDD)}},
        {{UINT32_C(0x09E2D3FF), UINT32_C(0xDF70BCDC), UINT32_C(0x9F20F624),
          UINT32_C(0xB6E59970), UINT32_C(0x6DE3119E), UINT32_C(0x5E04FDE7),
          UINT32_C(0xD5705A5D), UINT32_C(0x1C9B43FF)},
         {UINT32_C(0x681270B0), UINT32_C(0x7C23A517), UINT32_C(0x9303BF40),
          UINT32_C(0xDD7FC833), UINT32_C(0x458EE80A), UINT32_C(0x3028E496),
          UINT32_C(0x52590EEF), UINT32_C(0x0C720063)}},
        {{UINT32_C(0x2850A5AE), UINT32_C(0x27B29710), UINT32_C(0xAA3E0397),
          UINT32_C(0xD1E6FBBA), UINT32_C(0xDF8FCBD6), UINT32_C(0xCFB44044),
          UINT32_C(0xC52B90FD), UINT32_C(0x7CD86272)},
         {UINT32_C(0xEBA52025), UINT32_C(0xB0E7FA93), UINT32_C(0x04084EF3),
          UINT32_C(0x64166303), UINT32_C(0x43840178), UINT32_C(0xD7C7DCBE),
          UINT32_C(0x22FB81A2), UINT32_C(0x8BC7FF77)}},
        {{UINT32_C(0xDAFCE699), UINT32_C(0xABDC5206), UINT32_C(0x83C5F3A3),
          UINT32_C(0x522A9137), UINT32_C(0x0E666E5C), UINT32_C(0xBAA93637),
          UINT32_C(0xD2D33B62), UINT32_C(0x0FD813DA)},
         {UINT32_C(0x5D417354), UINT32_C(0x83391908), UINT32_C(0xA6B9B447),
          UINT32_C(0xE5AADE1D), UINT32_C(0xD68321B1), UINT32_C(0xBDE90A3C),
          UINT32_C(0x0411531B), UINT32_C(0x43FF9514)}},
    },
    {
        {{UINT32_C(0x39648345), UINT32_C(0xD61DEE64), UINT32_C(0x7FCB5B5E),
          UINT32_C(0xF8B3FA1C), UINT32_C(0x24C29C71), UINT32_C(0xDD531CE1),
          UINT32_C(0xFFB825FE), UINT32_C(0x7A23608B)},
         {UINT32_C(0xF0DE896D), UINT32_C(0x8D607B82), UINT32_C(0x06EDDAFE),
          UINT32_C(0x6E497330), UINT32_C(0xC935E754), UINT32_C(0x8B49EFF0),
          UINT32_C(0xEE08BDBF), UINT32_C(0x90D54646)}},
        {{UINT32_C(0x9044FD39), UINT32_C(0xF44FBB16), UINT32_C(0xDFB38141),
          UINT32_C(0xA72128C4), UINT32_C(0x01954CC0), UINT32_C(0x8467F688),
          UINT32_C(0xB560B5C5), UINT32_C(0x741C23EE)},
         {UINT32_C(0x9765CF34), UINT32_C(0xA7F42201), UINT32_C(0x8A2AB61A),
          UINT32_C(0xB26C97BF), UINT32_C(0xCBD45AF3), UINT32_C(0xAA948763),
          UINT32_C(0xE21479F5), UINT32_C(0x74C993C2)}},
        {{UINT32_C(0xBFA717A5), UINT32_C(0xD968CE1A), UINT32_C(0x48E92615),
          UINT32_C(0x45C1103D), UINT32_C(0xDD98207D), UINT32_C(0x4CCEBE85),
          UINT32_C(0xE65E5FE6), UINT32_C(0x8A75DF6E)},
         {UINT32_C(0x418C47C5), UINT32_C(0x9E582C40), UINT32_C(0xA450009B),
          UINT32_C(0x2E9EE003), UINT32_C(0xDD60D3D2), UINT32_C(0x7C079613),
          UINT32_C(0x9935D8CA), UINT32_C(0x80A78C4A)}},
        {{UINT32_C(0xD3C9B903), UINT32_C(0xF6CDED58), UINT32_C(0xEF455E7A),
          UINT32_C(0x4F27927D), UINT32_C(0x833BB3C1), UINT32_C(0xF9DBBB9E),
          UINT32_C(0x6BA3770A), UINT32_C(0x4107CFBF)},
         {UINT32_C(0x520FCB57), UINT32_C(0x61871175), UINT32_C(0x47A12C8E),
          UINT32_C(0xEA3A307B), UINT32_C(0xC24E9E75), UINT32_C(0x940DDEE8),
          UINT32_C(0xF33541BB), UINT32_C(0x8AE8F22C)}},
        {{UINT32_C(0x3973DC0B), UINT32_C(0xE4C89870), UINT32_C(0x55DFAAF0),
          UINT32_C(0xCC3DD1AC), UINT32_C(0x27372EFE), UINT32_C(0xB63D596B),
          UINT32_C(0x45A33718), UINT32_C(0x1B92A192)},
         {UINT32_C(0x00607319), UINT32_C(0x0EABEBEE), UINT32_C(0x7C3E35EE),
          UINT32_C(0x69B7355E), UINT32_C(0x2233C454), UINT32_C(0xF7354E35),
          UINT32_C(0x1E722C0A), UINT32_C(0x1E2BAADA)}},
        {{UINT32_C(0x3B9FE86D), UINT32_C(0xD0E47FE2), UINT32_C(0xDAA1C7BC),
          UINT32_C(0x878F403F), UINT32_C(0x90F5DED7), UINT32_C(0x5447AD54),
          UINT32_C(0x1E58B03B), UINT32_C(0x4E8A997B)},
         {UINT32_C(0x2E926FA8), UINT32_C(0x9AD0E481), UINT32_C(0x8D0EF3AA),
          UINT32_C(0x871EFB9E), UINT32_C(0x7E714DF6), UINT32_C(0xADD7DD14),
          UINT32_C(0x2308EE02), UINT32_C(0x9A30245A)}},
        {{UINT32_C(0x904F0D11), UINT32_C(0x44838B15), UINT32_C(0x2A2A70FF),
          UINT32_C(0x6177587A), UINT32_C(0x2C2F7943), UINT32_C(0x40293850),
          UINT32_C(0x67581701), UINT32_C(0x8F851191)},
         {UINT32_C(0x842E6434), UINT32_C(0x564383D1), UINT32_C(0xAF2C0078),
          UINT32_C(0x251AF59D), UINT32_C(0x3354A264), UINT32_C(0x8A81772D),
          UINT32_C(0xDFD2D0EA), UINT32_C(0x9AAFA350)}},
        {{UINT32_C(0x35461CAD), UINT32_C(0x47397932), UINT32_C(0x62C5BFFA),
          UINT32_C(0x0F86BD43), UINT32_C(0x7785490D), UINT32_C(0x5F166BC0),
          UINT32_C(0x2BD61B3E), UINT32_C(0x7DCCC988)},
         {UINT32_C(0x9394375B), UINT32_C(0x44C3299A), UINT32_C(0x405A34BD),
          UINT32_C(0x0C5F2803), UINT32_C(0x4237E728), UINT32_C(0x3AD60F1D),
          UINT32_C(0x72EC2562), UINT32_C(0x6E7E06D0)}},
        {{UINT32_C(0x3C5840A6), UINT32_C(0x44AD8471), UINT32_C(0x4752BC62),
          UINT32_C(0x40C3CE2B), UINT32_C(0xEC3FD75F), UINT32_C(0x94B14C21),
          UINT32_C(0x2629C0C0), UINT32_C(0x65E0E6AF)},
         {UINT32_C(0x55936454), UINT32_C(0xA3FE2F55), UINT32_C(0x780E25E5),
          UINT32_C(0x252AD743), UINT32_C(0xFF4E107A), UINT32_C(0x22F9951B),
          UINT32_C(0x554CEA49), UINT32_C(0x1B8A7DDE)}},
        {{UINT32_C(0x89F1C6FA), UINT32_C(0xBBDCC2C0), UINT32_C(0xC360A51D),
          UINT32_C(0x548FEF29), UINT32_C(0x1290EC92), UINT32_C(0x094DAD45),
          UINT32_C(0xAF55BF30), UINT32_C(0x792F6FB9)},
         {UINT32_C(0x707FBF4E), UINT32_C(0x37EF4ABE), UINT32_C(0xFC4B6BD0),
          UINT32_C(0x0F43AB0D), UINT32_C(0x2D6EE5D9), UINT32_C(0x850015B7),
          UINT32_C(0x35C1FD65), UINT32_C(0x09273F35)}},
        {{UINT32_C(0xA6C3209B), UINT32_C(0xCECF1B90), UINT32_C(0xABD433C0),
          UINT32_C(0xFB4BC864), UINT32_C(0x3EEEF8BA), UINT32_C(0x38246AAA),
          UINT32_C(0x9ED13F88), UINT32_C(0x4BC7904E)},
         {UINT32_C(0x8E783066), UINT32_C(0xA61C369A), UINT32_C(0x4D1C832C),
          UINT32_C(0x496FB831), UINT32_C(0x03AD64D5), UINT32_C(0x1907687A),
          UINT32_C(0x83425766), UINT32_C(0x49516EA5)}},
        {{UINT32_C(0xB1714E53), UINT32_C(0x8108B704), UINT32_C(0x82E39BE7),
          UINT32_C(0xB458CB4B), UINT32_C(0x097049DE), UINT32_C(0xFCBD51CC),
          UINT32_C(0x722E8CBA), UINT32_C(0x415F4079)},
         {UINT32_C(0x342DF9C6), UINT32_C(0xCDB06F5E), UINT32_C(0x1281AC74),
          UINT32_C(0x64885CD1), UINT32_C(0x5366673D), UINT32_C(0x932A05E4),
          UINT32_C(0xE83AD23D), UINT32_C(0x7333520B)}},
        {{UINT32_C(0xC54B523C), UINT32_C(0xDAA0A1EF), UINT32_C(0xB3C261C8),
          UINT32_C(0xA3E80053), UINT32_C(0x558FCFA5), UINT32_C(0x352CC612),
          UINT32_C(0x85852B14), UINT32_C(0x1B9B755D)},
         {UINT32_C(0xA1B541FF), UINT32_C(0x19EE2CB6), UINT32_C(0xD5786B4F),
          UINT32_C(0x2B531CE2), UINT32_C(0x08C3E15B), UINT32_C(0xEF5EA6DF),
          UINT32_C(0x87111129), UINT32_C(0x82161B04)}},
        {{UINT32_C(0xFCEABAED), UINT32_C(0x5AB533A5), UINT32_C(0x4A4D8E44),
          UINT32_C(0x4C2147A5), UINT32_C(0xDA02D43D), UINT32_C(0xD8EEE795),
          UINT32_C(0xA15C1CD0), UINT32_C(0x8CB648DF)},
         {UINT32_C(0xA788DDDE), UINT32_C(0x4869FB6C), UINT32_C(0x77C03759),
          UINT32_C(0xF9554D14), UINT32_C(0x96187DB9), UINT32_C(0x4D25B41A),
          UINT32_C(0x3FE0B3F3), UINT32_C(0x662FBAB3)}},
        {{UINT32_C(0xA58A5B2E), UINT32_C(0xD3AF4D09), UINT32_C(0x5CE88DBE),
          UINT32_C(0x3C5DD298), UINT32_C(0x7426C2A4), UINT32_C(0x89DDA42E),
          UINT32_C(0x49095424), UINT32_C(0x2D832B07)},
         {UINT32_C(0x62AA84CF), UINT32_C(0x24EFCC03), UINT32_C(0xE86923D7),
          UINT32_C(0x348C19DE), UINT32_C(0x35DB5CB1), UINT32_C(0x453E9286),
          UINT32_C(0x8DB21CF3), UINT32_C(0x03F48EEB)}},
        {{UINT32_C(0xF4035856), UINT32_C(0xBCF9600F), UINT32_C(0xAF820E18),
          UINT32_C(0xE77CEC83), UINT32_C(0x7F2FBCC1), UINT32_C(0xC87D43C1),
          UINT32_C(0x6290B18D), UINT32_C(0x574C4CAE)},
         {UINT32_C(0xE56E1EFE), UINT32_C(0x8BD8AE45), UINT32_C(0x75D6FCC9),
          UINT32_C(0xB1EFD684), UINT32_C(0xA361E753), UINT32_C(0x9829F227),
          UINT32_C(0x5211B784), UINT32_C(0x9A50B425)}},
    },
    {
        {{UINT32_C(0x36396F78), UINT32_C(0x26F19590), UINT32_C(0x9AD1982C),
          UINT32_C(0x350D1A76), UINT32_C(0x947F352E), UINT32_C(0x33BDB4AB),
          UINT32_C(0xFFE1E1E1), UINT32_C(0x6CA38B05)},
         {UINT32_C(0x6F2A8CA0), UINT32_C(0x055364C2), UINT32_C(0x2969CA7E),
          UINT32_C(0xAF15075D), UINT32_C(0xC3B9CB70), UINT32_C(0x2916D58F),
          UINT32_C(0xD7325693), UINT32_C(0x18D94A8B)}},
        {{UINT32_C(0xF36EB789), UINT32_C(0x87C41809), UINT32_C(0xA7436F54),
          UINT32_C(0x8C3517F9), UINT32_C(0x3D785160), UINT32_C(0xE7C02E1D),
          UINT32_C(0x418C7ABF), UINT32_C(0x5BAFE72E)},
         {UINT32_C(0xCD9B27C2), UINT32_C(0xA00A8E76), UINT32_C(0x7DA06823),
          UINT32_C(0x66791808), UINT32_C(0x20EC00B4), UINT32_C(0x342A03D9),
          UINT32_C(0x6122589A), UINT32_C(0x44502A7E)}},
        {{UINT32_C(0x5BDAE972), UINT32_C(0x3A492F73), UINT32_C(0x126A07DE),
          UINT32_C(0x5184D076), UINT32_C(0xB56A38F0), UINT32_C(0xAE49313C),
          UINT32_C(0x9EC47E0A), UINT32_C(0x66CCC24E)},
         {UINT32_C(0xC03CF3E1), UINT32_C(0xAE84941B), UINT32_C(0x5A73440B),
          UINT32_C(0x771AFC57), UINT32_C(0xC433E43C), UINT32_C(0xABF93DC8),
          UINT32_C(0x243C6828), UINT32_C(0x974EE822)}},
        {{UINT32_C(0xA7A5F66C), UINT32_C(0x468D7FDB), UINT32_C(0xB18DEFCC),
          UINT32_C(0xBBB2C482), UINT32_C(0xFA2E7DEA), UINT32_C(0x188B8CAC),
          UINT32_C(0xBE0200B9), UINT32_C(0x7894BC93)},
         {UINT32_C(0x6B84750E), UINT32_C(0xA3181338), UINT32_C(0x37356096),
          UINT32_C(0x8B14BDB2), UINT32_C(0xD62F4813), UINT32_C(0xA9200FE7),
          UINT32_C(0x6F7627CE), UINT32_C(0x8DF664A3)}},
        {{UINT32_C(0xDD996CF1), UINT32_C(0x39BF14DD), UINT32_C(0xF7F42D26),
          UINT32_C(0xD00B3BF5), UINT32_C(0x017718A3), UINT32_C(0xF1AF5A20),
          UINT32_C(0xABCAE05D), UINT32_C(0x34A1E94B)},
         {UINT32_C(0xC635D333), UINT32_C(0xAD75D1B5), UINT32_C(0x87210A5A),
          UINT32_C(0x97E5BD39), UINT32_C(0xA0327BF4), UINT32_C(0x11684CA6),
          UINT32_C(0x9B8F0A46), UINT32_C(0x25C51117)}},
        {{UINT32_C(0xA935A9B9), UINT32_C(0x7E5CD79F), UINT32_C(0xA22DCD16),
          UINT32_C(0x15DC70C2), UINT32_C(0x78A420F4), UINT32_C(0x5CDA47E6),
          UINT32_C(0xEA631104), UINT32_C(0x37E0364E)},
         {UINT32_C(0x5E47B630), UINT32_C(0xE7C46956), UINT32_C(0xE42C4DCB),
          UINT32_C(0x7BD4C4A7), UINT32_C(0x1C91117E), UINT32_C(0xA76B87A7),
          UINT32_C(0xADA4B5E1), UINT32_C(0x2AA043DD)}},
        {{UINT32_C(0x875DED57), UINT32_C(0x6BB06B5A), UINT32_C(0xFEAD7B14),
          UINT32_C(0x89452B3B), UINT32_C(0xA6E39E1F), UINT32_C(0x0CBD5CA8),
          UINT32_C(0x3BFA7A3D), UINT32_C(0x2DC5917C)},
         {UINT32_C(0xF840B6E8), UINT32_C(0x6395D5B8), UINT32_C(0xED8589EE),
          UINT32_C(0xAEC9342F), UINT32_C(0x77979E67), UINT32_C(0x8332A1B8),
          UINT32_C(0xC59F97DB), UINT32_C(0x29B55822)}},
        {{UINT32_C(0x7D65A8F4), UINT32_C(0xFD145FF7), UINT32_C(0x119C9AFC),
          UINT32_C(0x8FFF7EE0), UINT32_C(0xAFCD6214), UINT32_C(0x0100D0E9),
          UINT32_C(0xA3B988B3), UINT32_C(0x98DE55E5)},
         {UINT32_C(0x00151BF2), UINT32_C(0x0BACCB2E), UINT32_C(0x66091583),
          UINT32_C(0x2B422D09), UINT32_C(0x93C66A3B), UINT32_C(0xC4D15E16),
          UINT32_C(0x727DE9E6), UINT32_C(0x1C107559)}},
        {{UINT32_C(0x3CB76EDF), UINT32_C(0xC019C7D7), UINT32_C(0x151F5E14),
          UINT32_C(0x6456DD91), UINT32_C(0x57CC7078), UINT32_C(0x29E95B66),
          UINT32_C(0xE9BDBCEC), UINT32_C(0x9193F4D9)},
         {UINT32_C(0x4806F8CB), UINT32_C(0x375837B0), UINT32_C(0xAA954620),
          UINT32_C(0x52D5528A), UINT32_C(0x1B9D6D34), UINT32_C(0xE71F9F60),
          UINT32_C(0xDF95759C), UINT32_C(0x910E4FA1)}},
        {{UINT32_C(0xFCADB5EA), UINT32_C(0x8D31B2EE), UINT32_C(0xA63C7498),
          UINT32_C(0x0814FF77), UINT32_C(0x5E3D927E), UINT32_C(0x236569C0),
          UINT32_C(0x95BBB9D9), UINT32_C(0x7F669DAD)},
         {UINT32_C(0x305B0347), UINT32_C(0x29158C9A), UINT32_C(0x52D468EB),
          UINT32_C(0x99B9B7E7), UINT32_C(0xB4342443), UINT32_C(0x6C4CABC3),
          UINT32_C(0x0A803ED4), UINT32_C(0x125AFBEA)}},
        {{UINT32_C(0x101FAA4E), UINT32_C(0x850A150B), UINT32_C(0x11ECDABC),
          UINT32_C(0xB586BCDA), UINT32_C(0x4DAD2264), UINT32_C(0x9692EF83),
          UINT32_C(0xD2B67F5E), UINT32_C(0x0951716E)},
         {UINT32_C(0x924DD16D), UINT32_C(0xA2295F20), UINT32_C(0xD0CE88CD),
          UINT32_C(0xD8327275), UINT32_C(0xC683ADA3), UINT32_C(0x45F8DD0C),
          UINT32_C(0x88C26024), UINT32_C(0x4A798B33)}},
        {{UINT32_C(0xCAF71198), UINT32_C(0x225395CF), UINT32_C(0xCA3F67CF),
          UINT32_C(0xEE223712), UINT32_C(0x81280061), UINT32_C(0x972B0199),
          UINT32_C(0x280ECC12), UINT32_C(0x0CB20E7A)},
         {UINT32_C(0x70F54717), UINT32_C(0x06F04DA8), UINT32_C(0x410B9712),
          UINT32_C(0x5288425E), UINT32_C(0x74CEFB4A), UINT32_C(0x6C29A514),
          UINT32_C(0x849E2FD6), UINT32_C(0x4218ECCA)}},
        {{UINT32_C(0xB33574B6), UINT32_C(0xD85663A3), UINT32_C(0xFAF7D3A2),
          UINT32_C(0x7469CFB1), UINT32_C(0x3CFA8876), UINT32_C(0x9C587EC4),
          UINT32_C(0xDB24ED63), UINT32_C(0x5DAE46AE)},
         {UINT32_C(0xC413E494), UINT32_C(0x66C8DA33), UINT32_C(0x65942568),
          UINT32_C(0xB8B256B6), UINT32_C(0xA7A4CAAD), UINT32_C(0x0F09178E),
          UINT32_C(0xAFEBC90B), UINT32_C(0x577D4ADC)}},
        {{UINT32_C(0x92D6C3B4), UINT32_C(0x49009BA6), UINT32_C(0xB884FAAC),
          UINT32_C(0xE9CF4915), UINT32_C(0x6F3DBE23), UINT32_C(0xC12377D3),
          UINT32_C(0xEA6B680C), UINT32_C(0x2F6E0E86)},
         {UINT32_C(0xE6C5E24D), UINT32_C(0x5DF2CD5A), UINT32_C(0xEE608DD3),
          UINT32_C(0xAAE7E145), UINT32_C(0x8A7ED956), UINT32_C(0x5357CFF2),
          UINT32_C(0x3912DBA4), UINT32_C(0x8377126C)}},
        {{UINT32_C(0xF83BC3F6), UINT32_C(0x6E83A6C6), UINT32_C(0xC0CC09C6),
          UINT32_C(0x3633E1E4), UINT32_C(0xBC4B73A5), UINT32_C(0x0C2A268B),
          UINT32_C(0x125688EB), UINT32_C(0x688369D3)},
         {UINT32_C(0x73E75809), UINT32_C(0x64EE03E1), UINT32_C(0x8E110C46),
          UINT32_C(0x21773EE9), UINT32_C(0xA6A648B1), UINT32_C(0xF0BC6BE9),
          UINT32_C(0x7E0041E7), UINT32_C(0x39912183)}},
        {{UINT32_C(0x26F5716E), UINT32_C(0xCC09774A), UINT32_C(0xFDFB59E9),
          UINT32_C(0x01CB17F9), UINT32_C(0xAE8938B4), UINT32_C(0xA88D1269),
          UINT32_C(0xD13047C9), UINT32_C(0x99A40D17)},
         {UINT32_C(0x6FC672A3), UINT32_C(0xE469C984), UINT32_C(0x5638B928),
          UINT32_C(0xDA6534B6), UINT32_C(0xCDE40C83), UINT32_C(0xC56EAB20),
          UINT32_C(0xBD93AF10), UINT32_C(0x2C1582B1)}},
    },
    {
        {{UINT32_C(0xA3F45C37), UINT32_C(0xE4C19851), UINT32_C(0xC7D78FE9),
          UINT32_C(0xCA0FEFF2), UINT32_C(0x9A7E444B), UINT32_C(0x027B41D8),
          UINT32_C(0x15D38CBB), UINT32_C(0x1F1B242F)},
         {UINT32_C(0xF1F50AB9), UINT32_C(0x1C6C132C), UINT32_C(0x5DFE7530),
          UINT32_C(0x2A02A3A4), UINT32_C(0x6E29159F), UINT32_C(0x2B1EB8E2),
          UINT32_C(0x2EEDE876), UINT32_C(0x5F3F4AB7)}},
        {{UINT32_C(0x0F2DF95C), UINT32_C(0x362CE013), UINT32_C(0x26480BFA),
          UINT32_C(0x82E4E192), UINT32_C(0x6BEFF080), UINT32_C(0x9AAC9A96),
          UINT32_C(0x8EE2B59C), UINT32_C(0x5A1636F6)},
         {UINT32_C(0xFA049CCB), UINT32_C(0x600E0339), UINT32_C(0xF2F57163),
          UINT32_C(0x56680F80), UINT32_C(0x7B4240A7), UINT32_C(0x2C395CC1),
          UINT32_C(0x9C86BB64), UINT32_C(0x32EDFE4A)}},
        {{UINT32_C(0x711AEF69), UINT32_C(0x8D9842AB), UINT32_C(0x890831F0),
          UINT32_C(0x7A1C2429), UINT32_C(0x54CDA99A), UINT32_C(0x924478DF),
          UINT32_C(0xE25A02E2), UINT32_C(0x791A1D45)},
         {UINT32_C(0x170F4C21), UINT32_C(0x1433F569), UINT32_C(0xCA5F8BD8),
          UINT32_C(0x9F42C8C1), UINT32_C(0x067B3201), UINT32_C(0x377740F7),
          UINT32_C(0x2ECE5D81), UINT32_C(0x75145FFF)}},
        {{UINT32_C(0x39638F43), UINT32_C(0xCBFE782A), UINT32_C(0xE07553D2),
          UINT32_C(0xB0C0EC09), UINT32_C(0x115C673A), UINT32_C(0x8D1C41F7),
          UINT32_C(0xEB39E385), UINT32_C(0x8510551A)},
         {UINT32_C(0xBA275803), UINT32_C(0x92000181), UINT32_C(0x27B9A42A),
          UINT32_C(0x8AF63F4A), UINT32_C(0x52297029), UINT32_C(0xD50ECF0F),
          UINT32_C(0x66883C56), UINT32_C(0x1DCA33A5)}},
        {{UINT32_C(0xC51DF9D9), UINT32_C(0xB2C44933), UINT32_C(0xE66D80AE),
          UINT32_C(0xCA6F9FB0), UINT32_C(0x82839BA4), UINT32_C(0x78CD2EEB),
          UINT32_C(0xF7AFBCF3), UINT32_C(0x8FF8BCC8)},
         {UINT32_C(0x4164959B), UINT32_C(0x5AD00C70), UINT32_C(0xE83ED8D5),
          UINT32_C(0xAD901C71), UINT32_C(0x2B52650D), UINT32_C(0x56FFC0A9),
          UINT32_C(0x780126A8), UINT32_C(0x0689B171)}},
        {{UINT32_C(0x5EAC1DD8), UINT32_C(0x2E902A39), UINT32_C(0x7CAC283F),
          UINT32_C(0x7681EABA), UINT32_C(0x78525B7C), UINT32_C(0x03608CD8),
          UINT32_C(0x5EB95540), UINT32_C(0x09665B80)},
         {UINT32_C(0x306EE831), UINT32_C(0xF09F9805), UINT32_C(0xE41D453A),
          UINT32_C(0xFB00B1C6), UINT32_C(0x7C93E727), UINT32_C(0xD8BB9559),
          UINT32_C(0x2CE63FD8), UINT32_C(0x3B74FEE7)}},
        {{UINT32_C(0x0A22DABA), UINT32_C(0x73F48B33), UINT32_C(0xC8FC3E20),
          UINT32_C(0x797DE0FB), UINT32_C(0x9E79222D), UINT32_C(0x69C1BEE2),
          UINT32_C(0x1DF4C549), UINT32_C(0x3052F67A)},
         {UINT32_C(0xED78B6FB), UINT32_C(0xFE9128A9), UINT32_C(0x29CCF94F),
          UINT32_C(0xD9460CFF), UINT32_C(0xC1FD1DAA), UINT32_C(0x53737484),
          UINT32_C(0x1EDAEEB2), UINT32_C(0x83ADCD01)}},
        {{UINT32_C(0x2BA4195A), UINT32_C(0x189EC9AA), UINT32_C(0xC522BE92),
          UINT32_C(0x61345757), UINT32_C(0x39EFB05D), UINT32_C(0x35BAB72A),
          UINT32_C(0xAE0AC461), UINT32_C(0x82B27322)},
         {UINT32_C(0xC07F4382), UINT32_C(0xFEBF0F8C), UINT32_C(0xDAD2ED8E),
          UINT32_C(0x1CA2B3D7), UINT32_C(0x0A27F89C), UINT32_C(0x4800A037),
          UINT32_C(0x9815D971), UINT32_C(0x77D1B2FC)}},
        {{UINT32_C(0xCA0FC66A), UINT32_C(0xF9F46089), UINT32_C(0x8C23E4E1),
          UINT32_C(0x5BC406DE), UINT32_C(0x8DBF6DD5), UINT32_C(0x1D7F3BA9),
          UINT32_C(0x679D5587), UINT32_C(0x685B9111)},
         {UINT32_C(0xB85BE0D0), UINT32_C(0x93554084), UINT32_C(0x7B9EB16C),
          UINT32_C(0xB081E9CA), UINT32_C(0x60F0D0B0), UINT32_C(0x58C428DC),
          UINT32_C(0x30B3C6D9), UINT32_C(0x12442C1A)}},
        {{UINT32_C(0x567226BE), UINT32_C(0x147B843C), UINT32_C(0x429A8FFA),
          UINT32_C(0x2B2BFFAB), UINT32_C(0xCD435C2F), UINT32_C(0x7A4678EB),
          UINT32_C(0x3C0B887A), UINT32_C(0x200E8513)},
         {UINT32_C(0x90605CDD), UINT32_C(0x9D457AAD), UINT32_C(0x157F29A5),
          UINT32_C(0x6736A242), UINT32_C(0x549FCA4D), UINT32_C(0x779B0D25),
          UINT32_C(0x17FDB4D9), UINT32_C(0x57477EE9)}},
        {{UINT32_C(0xECF06CDD), UINT32_C(0xD9B15FD1), UINT32_C(0xC1CC2CFC),
          UINT32_C(0xECF75FC0), UINT32_C(0xA56B39E5), UINT32_C(0x273867C3),
          UINT32_C(0x79340B7D), UINT32_C(0x72F3ED45)},
         {UINT32_C(0x55B6C9B9), UINT32_C(0xF31C9E4C), UINT32_C(0x0448FE57),
          UINT32_C(0xED96826E), UINT32_C(0x8BB7A02F), UINT32_C(0xE2DF54AD),
          UINT32_C(0xD79D71CC), UINT32_C(0x945E7B6B)}},
        {{UINT32_C(0x9270E878), UINT32_C(0x32B6CE42), UINT32_C(0xD6EEBEB9),
          UINT32_C(0x980C8F6E), UINT32_C(0x55808237), UINT32_C(0xC5717C85),
          UINT32_C(0xCCA3F298), UINT32_C(0x4469D0A0)},
         {UINT32_C(0x1A18C0E8), UINT32_C(0x2B9DD7E9), UINT32_C(0x6A0EC412),
          UINT32_C(0xE9D12401), UINT32_C(0x31F44B32), UINT32_C(0xF889DE98),
          UINT32_C(0x78854A7F), UINT32_C(0x692EE1E6)}},
        {{UINT32_C(0xADEECA22), UINT32_C(0xF2360597), UINT32_C(0x99A4C198),
          UINT32_C(0x94623EBC), UINT32_C(0xE4169D20), UINT32_C(0x5A0D49C4),
          UINT32_C(0xBF0384F0), UINT32_C(0x7BE2C5BB)},
         {UINT32_C(0x8C537851), UINT32_C(0x42DB0D40), UINT32_C(0x65C50782),
          UINT32_C(0x198A09A4), UINT32_C(0x45AD7EE0), UINT32_C(0x72F80BB7),
          UINT32_C(0x11FCED06), UINT32_C(0x4F83164B)}},
        {{UINT32_C(0x95712AF0), UINT32_C(0x54E5B07C), UINT32_C(0x1E893387),
          UINT32_C(0x95E7F5D9), UINT32_C(0xC61D7766), UINT32_C(0x383BC5AE),
          UINT32_C(0x681C28DD), UINT32_C(0x09F626ED)},
         {UINT32_C(0xDF97E3C9), UINT32_C(0x0D32B726), UINT32_C(0x7C7C4786),
          UINT32_C(0x2AC62238), UINT32_C(0xD3F5AD40), UINT32_C(0xECEA0C6A),
          UINT32_C(0xA870A132), UINT32_C(0x0D26633E)}},
        {{UINT32_C(0xC3D42D26), UINT32_C(0x40A05A14), UINT32_C(0xF3BDE0E3),
          UINT32_C(0x06577CA1), UINT32_C(0x418B73FB), UINT32_C(0x03DAA258),
          UINT32_C(0x0EFDEB86), UINT32_C(0x205E02E6)},
         {UINT32_C(0x99F90D56), UINT32_C(0xF5479E4D), UINT32_C(0x368CB6E3),
          UINT32_C(0x4E699BF3), UINT32_C(0x62E4A879), UINT32_C(0x534F6743),
          UINT32_C(0xA9D78191), UINT32_C(0x18473603)}},
        {{UINT32_C(0x5C1ED4F9), UINT32_C(0xA23D79CF), UINT32_C(0xF2248B01),
          UINT32_C(0xFADE1CF5), UINT32_C(0x6F4D2164), UINT32_C(0xA3D52827),
          UINT32_C(0x10B731E5), UINT32_C(0x1F211C03)},
         {UINT32_C(0xD97229E2), UINT32_C(0x0B415884), UINT32_C(0x80FCC283),
          UINT32_C(0xCABB7D89), UINT32_C(0x98EF388A), UINT32_C(0xDB9BC752),
          UINT32_C(0x93E80262), UINT32_C(0x50AF2A4A)}},
    },
    {
        {{UINT32_C(0xD57DD821), UINT32_C(0xD11E80F1), UINT32_C(0xDDA2AB29),
          UINT32_C(0x11CAE463), UINT32_C(0xE628F315), UINT32_C(0x21CAFD16),
          UINT32_C(0x7DF70CD4), UINT32_C(0x296A84E9)},
         {UINT32_C(0x6E9EF995), UINT32_C(0x9ECF7513), UINT32_C(0x06E28855),
          UINT32_C(0xAE875257), UINT32_C(0x5DED383C), UINT32_C(0x78E1B7E9),
          UINT32_C(0x5E940F7F), UINT32_C(0x6C5D8ECC)}},
        {{UINT32_C(0x998EE9A3), UINT32_C(0xCBD3ACB9), UINT32_C(0xD0DCF584),
          UINT32_C(0x990CDFF6), UINT32_C(0xC7CE5DDA), UINT32_C(0x0FB4346C),
          UINT32_C(0x355E268F), UINT32_C(0x5EDEEF9B)},
         {UINT32_C(0xC215036D), UINT32_C(0xACD8B4A2), UINT32_C(0x91C7486B),
          UINT32_C(0x70D36995), UINT32_C(0x52C6694B), UINT32_C(0x72D5243D),
          UINT32_C(0xE5F8B99C), UINT32_C(0x54163B48)}},
        {{UINT32_C(0x1D76A94A), UINT32_C(0xD2AEA2FF), UINT32_C(0x379F780B),
          UINT32_C(0xC5B4FBF1), UINT32_C(0xB33AC708), UINT32_C(0x700042F7),
          UINT32_C(0x8183E0CA), UINT32_C(0x7DA790BF)},
         {UINT32_C(0xEBA72FA8), UINT32_C(0x95681FE6), UINT32_C(0xE22E254E),
          UINT32_C(0x1F0A390E), UINT32_C(0xBF07A8A5), UINT32_C(0x465A58F8),
          UINT32_C(0xFB1FCE40), UINT32_C(0x840EA2E7)}},
        {{UINT32_C(0x44048484), UINT32_C(0xD955C5B5), UINT32_C(0x6935C5E4),
          UINT32_C(0x7107D595), UINT32_C(0x8A0FCE44), UINT32_C(0xFC657444),
          UINT32_C(0x2800E517), UINT32_C(0x97DF2B4D)},
         {UINT32_C(0x2C482414), UINT32_C(0x0B1BB328), UINT32_C(0x4E48CDBE),
          UINT32_C(0x152614CC), UINT32_C(0x42EDE4E0), UINT32_C(0x48051FB6),
          UINT32_C(0x3DBFFE52), UINT32_C(0x91125B93)}},
        {{UINT32_C(0xCF898F54), UINT32_C(0xA2F526C7), UINT32_C(0x83080857),
          UINT32_C(0x8788CA12), UINT32_C(0x4562F7B0), UINT32_C(0x2F442723),
          UINT32_C(0xC044560C), UINT32_C(0x837772AB)},
         {UINT32_C(0x31BCB2EA), UINT32_C(0x51AD2F71), UINT32_C(0xAFC5C03D),
          UINT32_C(0x0F1D33FC), UINT32_C(0x7BD352A4), UINT32_C(0xDBFE541F),
          UINT32_C(0x64B8343D), UINT32_C(0x8B441399)}},
        {{UINT32_C(0x44DCD145), UINT32_C(0xFEB96B8C), UINT32_C(0xEFF22D0D),
          UINT32_C(0xEEB3007C), UINT32_C(0x252A8C8F), UINT32_C(0xAF64DFC1),
          UINT32_C(0xD131E0C5), UINT32_C(0x5D9B0A05)},
         {UINT32_C(0xABFED144), UINT32_C(0x28C943EF), UINT32_C(0xB6A2273D),
          UINT32_C(0xDFBF730C), UINT32_C(0xE2A1BFBD), UINT32_C(0x6CC5BE44),
          UINT32_C(0x09030FCD), UINT32_C(0x55FAC033)}},
        {{UINT32_C(0x728F39EC), UINT32_C(0xFAA58543), UINT32_C(0x40B37B15),
          UINT32_C(0x9B2F10BA), UINT32_C(0x7254A419), UINT32_C(0x96505C7F),
          UINT32_C(0x879C7FF9), UINT32_C(0x04F4ACE5)},
         {UINT32_C(0xBC5FDA53), UINT32_C(0xC0B4B576), UINT32_C(0xF7ABCD3C),
          UINT32_C(0x12549929), UINT32_C(0x313FEC34), UINT32_C(0x00F5631E),
          UINT32_C(0x798C7CFB), UINT32_C(0x89EA4459)}},
        {{UINT32_C(0x0E2020C1), UINT32_C(0x671137B5), UINT32_C(0xA4DC66C3),
          UINT32_C(0x77727861), UINT32_C(0x81492A26), UINT32_C(0x8CE05ED1),
          UINT32_C(0xA0C3F612), UINT32_C(0x42BEA541)},
         {UINT32_C(0xB0E461EB), UINT32_C(0x6D39E3D1), UINT32_C(0x09FA806F),
          UINT32_C(0x459A8E13), UINT32_C(0x466CB93B), UINT32_C(0xE2A185C1),
          UINT32_C(0xE21ECB34), UINT32_C(0x17D131CE)}},
        {{UINT32_C(0x387A15BF), UINT32_C(0x2141E262), UINT32_C(0x6BE61C42),
          UINT32_C(0x675B5E7C), UINT32_C(0xF1CF93EF), UINT32_C(0xEEC1BDD4),
          UINT32_C(0x23BAB1F9), UINT32_C(0x6ACF3838)},
         {UINT32_C(0xB0B39C86), UINT32_C(0xA2F84E23), UINT32_C(0xE244E0E3),
          UINT32_C(0xE955DBBC), UINT32_C(0xB7A8102A), UINT32_C(0xE0155980),
          UINT32_C(0xB23012FA), UINT32_C(0x1E117DC8)}},
        {{UINT32_C(0x6EB36280), UINT32_C(0xC92A36AA), UINT32_C(0x5E906D78),
          UINT32_C(0x5AED3A1D), UINT32_C(0xAE4E430A), UINT32_C(0x8D336221),
          UINT32_C(0xD3AA50AD), UINT32_C(0x3F184F1D)},
         {UINT32_C(0x916D9741), UINT32_C(0xD14810EC), UINT32_C(0x3322D9B3),
          UINT32_C(0x2900169F), UINT32_C(0x04728254), UINT32_C(0xAFF1A060),
          UINT32_C(0x26F60B5F), UINT32_C(0x89C4C673)}},
        {{UINT32_C(0xB7F0D157), UINT32_C(0x5216E0AE), UINT32_C(0xC9F38AAD),
          UINT32_C(0x3B8D2226), UINT32_C(0xBB34AA79), UINT32_C(0x283E3E3F),
          UINT32_C(0x565CAB83), UINT32_C(0x94DA80FA)},
         {UINT32_C(0xE6ED4A46), UINT32_C(0xDDB51943), UINT32_C(0x7CDD5FE6),
          UINT32_C(0xF3AFFA9A), UINT32_C(0xB648A84F), UINT32_C(0x0AB493CC),
          UINT32_C(0xF15EE45F), UINT32_C(0x128356B6)}},
        {{UINT32_C(0xBD0F02C4), UINT32_C(0xD2AD34F4), UINT32_C(0x719BCF1E),
          UINT32_C(0x3DC9B6D1), UINT32_C(0x12EB5AE8), UINT32_C(0x11EDB8F1),
          UINT32_C(0x71180F90), UINT32_C(0x33AC71D8)},
         {UINT32_C(0xB59621D7), UINT32_C(0x0AE988FE), UINT32_C(0x8F348211),
          UINT32_C(0x32042B52), UINT32_C(0xEB0CEBD3), UINT32_C(0x7E6787C4),
          UINT32_C(0x26B8A526), UINT32_C(0x8C4D2549)}},
        {{UINT32_C(0x4D40ED72), UINT32_C(0xA3B46154), UINT32_C(0xF6CF3972),
          UINT32_C(0x3A096546), UINT32_C(0xB3E46D8C), UINT32_C(0x9C7BC931),
          UINT32_C(0x90486C75), UINT32_C(0x85B77BAD)},
         {UINT32_C(0x6EBD35E0), UINT32_C(0x95B706E5), UINT32_C(0x101E098E),
          UINT32_C(0xC1E18243), UINT32_C(0xF01C17E1), UINT32_C(0xF17C23FF),
          UINT32_C(0x85EC224E), UINT32_C(0x32235272)}},
        {{UINT32_C(0xFD24FA16), UINT32_C(0xE816235D), UINT32_C(0x0B3AEBD7),
          UINT32_C(0x5306CBC3), UINT32_C(0x8BE25CB7), UINT32_C(0xDEF60A9A),
          UINT32_C(0x512999C2), UINT32_C(0x4B889A0F)},
         {UINT32_C(0x67B29FD9), UINT32_C(0xAB86A7F8), UINT32_C(0xB5461BCB),
          UINT32_C(0xB81C532D), UINT32_C(0xD34D9819), UINT32_C(0x810E9A0C),
          UINT32_C(0x3092515D), UINT32_C(0x1E353009)}},
        {{UINT32_C(0x21FB0BD9), UINT32_C(0x46826339), UINT32_C(0x003BAE50),
          UINT32_C(0x9CCE9A43), UINT32_C(0x2EB45B4A), UINT32_C(0xCD2216C3),
          UINT32_C(0xC7E0F2C3), UINT32_C(0x13598548)},
         {UINT32_C(0x54611984), UINT32_C(0x8B0BFD72), UINT32_C(0x89C0B05A),
          UINT32_C(0x705CB525), UINT32_C(0xCE880DD8), UINT32_C(0xD9073D87),
          UINT32_C(0x003DCAEB), UINT32_C(0x1EA534CD)}},
        {{UINT32_C(0xC58B4413), UINT32_C(0xC7AAC256), UINT32_C(0xE8054F96),
          UINT32_C(0x301109D6), UINT32_C(0x9C7E7860), UINT32_C(0x0A1F44D2),
          UINT32_C(0x96F15424), UINT32_C(0x55D122BB)},
         {UINT32_C(0x1C14A8A9), UINT32_C(0x9A63098F), UINT32_C(0x4221CDFB),
          UINT32_C(0x8E01A9DC), UINT32_C(0x357B360A), UINT32_C(0x11C91FCF),
          UINT32_C(0x036A3CF4), UINT32_C(0x70C47AEA)}},
    },
    {
        {{UINT32_C(0x036A843D), UINT32_C(0xC0457C4F), UINT32_C(0xF1F593CB),
          UINT32_C(0x6E3E0801), UINT32_C(0x8C53873B), UINT32_C(0x1AADF2D8),
          UINT32_C(0x0D140C8D), UINT32_C(0x5CEC5C7B)},
         {UINT32_C(0x328002E4), UINT32_C(0x4341A9AB), UINT32_C(0xC410D034),
          UINT32_C(0x11F22331), UINT32_C(0x5DB6A39D), UINT32_C(0x0FCF69EF),
          UINT32_C(0xB84FDA1F), UINT32_C(0x3DD32A53)}},
        {{UINT32_C(0xAF8C811A), UINT32_C(0x19E52339), UINT32_C(0x92D46C4F),
          UINT32_C(0xC8B83800), UINT32_C(0xCA8463A3), UINT32_C(0x891C4185),
          UINT32_C(0x98F3FF1B), UINT32_C(0x5B51651F)},
         {UINT32_C(0x0FB39DCA), UINT32_C(0x3D149607), UINT32_C(0xB1051394),
          UINT32_C(0x39ECCDE2), UINT32_C(0x1A14522B), UINT32_C(0x3633DE27),
          UINT32_C(0x7C59A9A5), UINT32_C(0x5FE55114)}},
        {{UINT32_C(0x2F0B507F), UINT32_C(0x68C8E0C6), UINT32_C(0x05B62C5E),
          UINT32_C(0xDABC8EEF), UINT32_C(0xE6165C1E), UINT32_C(0x297C943A),
          UINT32_C(0x7D7CA6D6), UINT32_C(0x337C6B94)},
         {UINT32_C(0xD6066191), UINT32_C(0x66F98FE4), UINT32_C(0x58945DA9),
          UINT32_C(0x745BFEBA), UINT32_C(0x3B29A546), UINT32_C(0x60044787),
          UINT32_C(0xE2D4EDF2), UINT32_C(0x2815651E)}},
        {{UINT32_C(0x63661218), UINT32_C(0x54A3BE74), UINT32_C(0x15E79415),
          UINT32_C(0x89C56364), UINT32_C(0x405E4932), UINT32_C(0xE03C6963),
          UINT32_C(0x9A619956), UINT32_C(0x86E101EA)},
         {UINT32_C(0x400DC92B), UINT32_C(0x47BAF2F3), UINT32_C(0x291E4059),
          UINT32_C(0x5C44512C), UINT32_C(0xEC6D7BF9), UINT32_C(0xD7F84B8E),
          UINT32_C(0x25AB8D79), UINT32_C(0x6CF42540)}},
        {{UINT32_C(0xB885DAFC), UINT32_C(0xD6E1B75D), UINT32_C(0x6128014E),
          UINT32_C(0x7A33CE4B), UINT32_C(0xEA9FF260), UINT32_C(0x80DF9948),
          UINT32_C(0xD2B5872B), UINT32_C(0x99E0A11C)},
         {UINT32_C(0xE2435510), UINT32_C(0x960BDC3D), UINT32_C(0x14F7A99C),
          UINT32_C(0x4B0ECC53), UINT32_C(0x5AC6170B), UINT32_C(0xE815DB8B),
          UINT32_C(0x17D5F2DD), UINT32_C(0x30956156)}},
        {{UINT32_C(0x57166FCE), UINT32_C(0xA035E3CE), UINT32_C(0x40A75B80),
          UINT32_C(0x71AD4095), UINT32_C(0xDB7D0BFB), UINT32_C(0x639C4EA7),
          UINT32_C(0xB12DBE6B), UINT32_C(0x7A90BE97)},
         {UINT32_C(0x75F86A60), UINT32_C(0x091AA30F), UINT32_C(0x509AEEFC),
          UINT32_C(0x67C0F795), UINT32_C(0x331629C5), UINT32_C(0xF028C12A),
          UINT32_C(0x8A1F7478), UINT32_C(0x90D26B1C)}},
        {{UINT32_C(0xB6AC2AD5), UINT32_C(0x6F01554E), UINT32_C(0xBC9A48D6),
          UINT32_C(0x9DD0576E), UINT32_C(0x97AE2605), UINT32_C(0xAB372013),
          UINT32_C(0xBB83852B), UINT32_C(0x1525D8B5)},
         {UINT32_C(0xE46E4C61), UINT32_C(0xD50680C3), UINT32_C(0xECB8F06F),
          UINT32_C(0x29FBBA5C), UINT32_C(0xB16637A3), UINT32_C(0x60A48AB4),
          UINT32_C(0xCD1490D3), UINT32_C(0x8BB47967)}},
        {{UINT32_C(0x4B7C7EA6), UINT32_C(0xA35A0187), UINT32_C(0xB4D6409A),
          UINT32_C(0xFE01521A), UINT32_C(0x8FDE1E30), UINT32_C(0x57CECE62),
          UINT32_C(0xF4F51D55), UINT32_C(0x1A9A9B2D)},
         {UINT32_C(0xE221AC58), UINT32_C(0x0D33556B), UINT32_C(0x152508AD),
          UINT32_C(0x0A4A1A34), UINT32_C(0x0144AA33), UINT32_C(0x1FD61DA1),
          UINT32_C(0xEDC7C5F8), UINT32_C(0x4804BE6A)}},
        {{UINT32_C(0x5B363A84), UINT32_C(0x071EC815), UINT32_C(0xFE11ED05),
          UINT32_C(0x359C2A9F), UINT32_C(0xB8BBF9BD), UINT32_C(0x0FDF80C9),
          UINT32_C(0x103ACCBE), UINT32_C(0x928E51A4)},
         {UINT32_C(0xD5E8A222), UINT32_C(0xD152B6E7), UINT32_C(0xCBE022C9),
          UINT32_C(0x6368E3A8), UINT32_C(0x3128B659), UINT32_C(0x2E5055DE),
          UINT32_C(0xD21F1062), UINT32_C(0x51E23651)}},
        {{UINT32_C(0x34834BF7), UINT32_C(0x5CE999D7), UINT32_C(0x3DC831E9),
          UINT32_C(0xE386394C), UINT32_C(0x7FE48564), UINT32_C(0x6DBD5ECA),
          UINT32_C(0x556841A5), UINT32_C(0x804BC07F)},
         {UINT32_C(0x229A9175), UINT32_C(0x2A8B616C), UINT32_C(0xA1B3EF97),
          UINT32_C(0xAEEB533A), UINT32_C(0x6F145037), UINT32_C(0x9D858F9D),
          UINT32_C(0x7F6A8EBB), UINT32_C(0x247FFAB0)}},
        {{UINT32_C(0x099EB4F3), UINT32_C(0xE616E779), UINT32_C(0xF1B1926C),
          UINT32_C(0x4F360D2E), UINT32_C(0x17055397), UINT32_C(0x28EE1F91),
          UINT32_C(0x844AFCF3), UINT32_C(0x9994D7FF)},
         {UINT32_C(0x12CBD801), UINT32_C(0x8824A949), UINT32_C(0x6A4484DD),
          UINT32_C(0xA3AFED4D), UINT32_C(0x3B5E36A5), UINT32_C(0xCB16CD67),
          UINT32_C(0xBC3BBEA9), UINT32_C(0x5490C30D)}},
        {{UINT32_C(0xD7601122), UINT32_C(0xEA43CA5A), UINT32_C(0xD248EB72),
          UINT32_C(0x9CF2A15B), UINT32_C(0xB71D18D0), UINT32_C(0x4CE8AB75),
          UINT32_C(0x041A19A5), UINT32_C(0x2576C5B1)},
         {UINT32_C(0x8CC1496E), UINT32_C(0xDE20FD02), UINT32_C(0x0BE51831),
          UINT32_C(0xC9FE5B0C), UINT32_C(0x3A53ABBC), UINT32_C(0x9DC17E32),
          UINT32_C(0xF4C806FA), UINT32_C(0x94E24DD9)}},
        {{UINT32_C(0x0DF1A4B3), UINT32_C(0x2A9CF5F1), UINT32_C(0x15063C08),
          UINT32_C(0xE0196754), UINT32_C(0xCCF88F77), UINT32_C(0xCE9CF2C6),
          UINT32_C(0xEFE91C6C), UINT32_C(0x51ACC7B5)},
         {UINT32_C(0xA799FE2E), UINT32_C(0x0C2302EF), UINT32_C(0x69C0D117),
          UINT32_C(0x5EE756A4), UINT32_C(0xF4EAB1A1), UINT32_C(0x7E907EC2),
          UINT32_C(0xD98022DD), UINT32_C(0x19EEF95B)}},
        {{UINT32_C(0xA8E7FFA5), UINT32_C(0xB170D483), UINT32_C(0x39180FAC),
          UINT32_C(0x2052600A), UINT32_C(0xA68AF290), UINT32_C(0x8EAD52D4),
          UINT32_C(0xFF9E3641), UINT32_C(0x01B88CFE)},
         {UINT32_C(0x65BC2D0C), UINT32_C(0x3D9077F7), UINT32_C(0x3ABCDB1C),
          UINT32_C(0x2AF9CF67), UINT32_C(0x7295DADA), UINT32_C(0xEA104E74),
          UINT32_C(0xEB1E5D6E), UINT32_C(0x7DF23470)}},
        {{UINT32_C(0x8E53F40B), UINT32_C(0x0F54D98D), UINT32_C(0xAF360481),
          UINT32_C(0xBFC22E9B), UINT32_C(0xE132666B), UINT32_C(0x309973B6),
          UINT32_C(0x25E783E0), UINT32_C(0x1F40D11F)},
         {UINT32_C(0xF00AC3EB), UINT32_C(0x8EEBC9D7), UINT32_C(0x2F9ADCC7),
          UINT32_C(0xBD725D82), UINT32_C(0x66EFDDCC), UINT32_C(0x47767810),
          UINT32_C(0x4ECCAF67), UINT32_C(0x60B0B100)}},
        {{UINT32_C(0xB98C7E96), UINT32_C(0x498E2074), UINT32_C(0x08BF31A9),
          UINT32_C(0xBEBF5183), UINT32_C(0x3894DBE7), UINT32_C(0x00DD4AAD),
          UINT32_C(0x429878F6), UINT32_C(0x66C047A4)},
         {UINT32_C(0x6D0F1AB1), UINT32_C(0x16F2CB33), UINT32_C(0x58669ACB),
          UINT32_C(0x5FA2F181), UINT32_C(0x486F1BE7), UINT32_C(0xFA4B2F49),
          UINT32_C(0x5698F41B), UINT32_C(0x1ECAAF6B)}},
    },
    {
        {{UINT32_C(0x4DCC455E), UINT32_C(0x2999C212), UINT32_C(0xBEF617B8),
          UINT32_C(0x83897E49), UINT32_C(0x5A218E0F), UINT32_C(0x6B49CE26),
          UINT32_C(0x88EF7EA7), UINT32_C(0x49A5C9EB)},
         {UINT32_C(0xF63EC82C), UINT32_C(0xF0EDA5FF), UINT32_C(0xEAD471CD),
          UINT32_C(0x736D933D), UINT32_C(0xDF8071C4), UINT32_C(0x10E4431D),
          UINT32_C(0x38E1523C), UINT32_C(0x8C59C107)}},
        {{UINT32_C(0x5A54A4AB), UINT32_C(0x569FB74E), UINT32_C(0xF3384C14),
          UINT32_C(0x72788868), UINT32_C(0x107B417F), UINT32_C(0xBC840717),
          UINT32_C(0x7E13210C), UINT32_C(0x6682C107)},
         {UINT32_C(0x77B20150), UINT32_C(0xB3359FC2), UINT32_C(0xA9E03222),
          UINT32_C(0xEB923E66), UINT32_C(0xA10CF332), UINT32_C(0x490C39FC),
          UINT32_C(0x49BA035D), UINT32_C(0x69099C2D)}},
        {{UINT32_C(0x03CB2C6E), UINT32_C(0x64986720), UINT32_C(0x328B22BA),
          UINT32_C(0x994054A1), UINT32_C(0x6F0542DA), UINT32_C(0x4155C6B9),
          UINT32_C(0xA3B93FFB), UINT32_C(0x216CF760)},
         {UINT32_C(0x5C2AD753), UINT32_C(0x74486184), UINT32_C(0xA0CD3660),
          UINT32_C(0xE517984E), UINT32_C(0x3D7DA8A1), UINT32_C(0x6530BC86),
          UINT32_C(0x2E46CA79), UINT32_C(0x04328CF9)}},
        {{UINT32_C(0x4798CD35), UINT32_C(0x4100ADED), UINT32_C(0x635BAECD),
          UINT32_C(0xC832796D), UINT32_C(0x5B80E18C), UINT32_C(0x7EF1EA95),
          UINT32_C(0x426B1AA9), UINT32_C(0x6889A91B)},
         {UINT32_C(0x0927C6F8), UINT32_C(0xC40A0A87), UINT32_C(0x2B86ED45),
          UINT32_C(0xD60CFD1C), UINT32_C(0xD57350A1), UINT32_C(0x98731DFF),
          UINT32_C(0x1DE4341F), UINT32_C(0x1C52EAE9)}},
        {{UINT32_C(0x23A40FAA), UINT32_C(0xC287E33B), UINT32_C(0x7A633BDC),
          UINT32_C(0xB96D9F51), UINT32_C(0xE6D0F326), UINT32_C(0xF6A5B779),
          UINT32_C(0xF619DE4B), UINT32_C(0x10203FE1)},
         {UINT32_C(0xC4F18BF8), UINT32_C(0x011FB53E), UINT32_C(0xBCA32CA0),
          UINT32_C(0xAEBB82F6), UINT32_C(0xF881818D), UINT32_C(0x06BF8ED5),
          UINT32_C(0x18247E6A), UINT32_C(0x3A6A3E35)}},
        {{UINT32_C(0x00625DC1), UINT32_C(0x3BF2E96E), UINT32_C(0x5A288F80),
          UINT32_C(0xD81AD156), UINT32_C(0xB7CE9B13), UINT32_C(0x04C3269E),
          UINT32_C(0x2F9E2713), UINT32_C(0x3E18EAFC)},
         {UINT32_C(0x9D0BC74A), UINT32_C(0x20F0E05D), UINT32_C(0xD8140790),
          UINT32_C(0xACDB4B75), UINT32_C(0xF1B5B265), UINT32_C(0x12918A7E),
          UINT32_C(0x6896342E), UINT32_C(0x22A70AF9)}},
        {{UINT32_C(0x9C4B6B08), UINT32_C(0x326A28A2), UINT32_C(0xA17D3D57),
          UINT32_C(0x21302F37), UINT32_C(0xCE36F438), UINT32_C(0x181378E7),
          UINT32_C(0xFED12DE1), UINT32_C(0x42B07EBA)},
         {UINT32_C(0x0468AD4C), UINT32_C(0x081DDD20), UINT32_C(0x64DF34AE),
          UINT32_C(0x32822EC3), UINT32_C(0x04B2192D), UINT32_C(0xE9F8D7C2),
          UINT32_C(0x918666F8), UINT32_C(0x6ABC7220)}},
        {{UINT32_C(0x04AF3956), UINT32_C(0x93330701), UINT32_C(0x872BD30D),
          UINT32_C(0xEEB7AA8E), UINT32_C(0xD0E67494), UINT32_C(0xFC96D106),
          UINT32_C(0x3A918DFB), UINT32_C(0x516028CF)},
         {UINT32_C(0xFB27B6EC), UINT32_C(0xFAF0B6F7), UINT32_C(0x515DA78D),
          UINT32_C(0x0FAD73AD), UINT32_C(0xD8CF1934), UINT32_C(0x5F136068),
          UINT32_C(0xB6052802), UINT32_C(0x0A526E04)}},
        {{UINT32_C(0xE4685212), UINT32_C(0x20DF0DEB), UINT32_C(0xA41B293F),
          UINT32_C(0x71D4BAC1), UINT32_C(0x2FA8BBAC), UINT32_C(0xBCC32A2F),
          UINT32_C(0xF30CC343), UINT32_C(0x32A8723A)},
         {UINT32_C(0xEF95ACFE), UINT32_C(0x71E6DAAF), UINT32_C(0x9F445394),
          UINT32_C(0x27D158F6), UINT32_C(0xE186B246), UINT32_C(0x2140F78D),
          UINT32_C(0xCB1C83AD), UINT32_C(0x4CAF98C3)}},
        {{UINT32_C(0xB6F63AA9), UINT32_C(0x94E264FC), UINT32_C(0x4D0FE485),
          UINT32_C(0xF4637B02), UINT32_C(0x069CCB4E), UINT32_C(0xA4BC0A03),
          UINT32_C(0x9E25E817), UINT32_C(0x99A81E37)},
         {UINT32_C(0x8F4D37BB), UINT32_C(0xE3B804A7), UINT32_C(0xE38E654C),
          UINT32_C(0x57F272A5), UINT32_C(0x05928F65), UINT32_C(0x00D1852C),
          UINT32_C(0x4345DD06), UINT32_C(0x3031B713)}},
        {{UINT32_C(0x57536140), UINT32_C(0x6E42AF11), UINT32_C(0x005A403F),
          UINT32_C(0xDC5B7CDC), UINT32_C(0x26527417), UINT32_C(0xE6EE185E),
          UINT32_C(0x7C685BCF), UINT32_C(0x1003D013)},
         {UINT32_C(0x192979E6), UINT32_C(0xC2206BF6), UINT32_C(0x6FE38214),
          UINT32_C(0xD1C370DB), UINT32_C(0x92F3C044), UINT32_C(0x78D105B7),
          UINT32_C(0xBFDF8DFA), UINT32_C(0x2F0DF6B8)}},
        {{UINT32_C(0x44D04C4A), UINT32_C(0xB02FCA38), UINT32_C(0xA44566C6),
          UINT32_C(0x956A2F7C), UINT32_C(0x9F1F09C6), UINT32_C(0x60672DF3),
          UINT32_C(0x2160C362), UINT32_C(0x6459A949)},
         {UINT32_C(0x08714451), UINT32_C(0xDAE54341), UINT32_C(0xBFFD7CF6),
          UINT32_C(0x48B77A0D), UINT32_C(0x3EDBC8D4), UINT32_C(0x615ADBFE),
          UINT32_C(0x35B67D2F), UINT32_C(0x3338E557)}},
        {{UINT32_C(0xDD24A0F0), UINT32_C(0x601D49D1), UINT32_C(0x48EF27B9),
          UINT32_C(0x60A48DB7), UINT32_C(0x97A8BAC6), UINT32_C(0x97F2212C),
          UINT32_C(0x155AB524), UINT32_C(0x376B0292)},
         {UINT32_C(0x62E2A961), UINT32_C(0xA25881BA), UINT32_C(0x2B8C56F7),
          UINT32_C(0xEB74CC80), UINT32_C(0xDA57C41A), UINT32_C(0xBE5C5DD4),
          UINT32_C(0x2D16AFA0), UINT32_C(0x53D0D037)}},
        {{UINT32_C(0xCA291206), UINT32_C(0xE47C9EAB), UINT32_C(0x42D5C667),
          UINT32_C(0x25DADB64), UINT32_C(0xD886993E), UINT32_C(0x8C154CB6),
          UINT32_C(0x806B932F), UINT32_C(0x11DEC39C)},
         {UINT32_C(0x13D4B4E5), UINT32_C(0x51A4DCF3), UINT32_C(0x9D1D822A),
          UINT32_C(0xAA1DAD6D), UINT32_C(0xCEEF2E29), UINT32_C(0x2BB2E14D),
          UINT32_C(0xB2343BE3), UINT32_C(0x429C13C7)}},
        {{UINT32_C(0x297F709D), UINT32_C(0x4E8E953F), UINT32_C(0x262D862A),
          UINT32_C(0x23183A3D), UINT32_C(0xEA12D93F), UINT32_C(0xE164A10D),
          UINT32_C(0xFE703920), UINT32_C(0x386C2873)},
         {UINT32_C(0xE5C51C7E), UINT32_C(0xD59E1582), UINT32_C(0x020F6A2E),
          UINT32_C(0xA8C93B5B), UINT32_C(0x160CD058), UINT32_C(0x51518BD0),
          UINT32_C(0xB1D38AC7), UINT32_C(0x3337801A)}},
        {{UINT32_C(0x2F5D9E25), UINT32_C(0x6E251533), UINT32_C(0xB0D6B0DB),
          UINT32_C(0x88E76135), UINT32_C(0x9E6762D1), UINT32_C(0x5C197832),
          UINT32_C(0x84E620AC), UINT32_C(0x12326773)},
         {UINT32_C(0x0E2694DD), UINT32_C(0x3B88DF27), UINT32_C(0x30A23CAA),
          UINT32_C(0x30FED9E3), UINT32_C(0xA23DF142), UINT32_C(0xE12DD93E),
          UINT32_C(0x2EA77C07), UINT32_C(0x06778F51)}},
    },
    {
        {{UINT32_C(0x49E5F6B4), UINT32_C(0x5D5BE00E), UINT32_C(0x721EF9DC),
          UINT32_C(0x2F47E7C7), UINT32_C(0x7EAFC098), UINT32_C(0x338F7B00),
          UINT32_C(0xAF8C2475), UINT32_C(0x0F5F06E3)},
         {UINT32_C(0x63122B22), UINT32_C(0x2A4B845C), UINT32_C(0x89A4CE9A),
          UINT32_C(0xED440060), UINT32_C(0x9A86D9BC), UINT32_C(0xC9EEB640),
          UINT32_C(0x2F39B439), UINT32_C(0x12C3E0F3)}},
        {{UINT32_C(0x17766F6C), UINT32_C(0xB444B88B), UINT32_C(0xA41FD692),
          UINT32_C(0xF9B100E6), UINT32_C(0x5C149B30), UINT32_C(0x81EAFCD1),
          UINT32_C(0x1D521A1E), UINT32_C(0x37DD6F6E)},
         {UINT32_C(0x389DCD6E), UINT32_C(0x14DBE8C3), UINT32_C(0x0DCBC7FC),
          UINT32_C(0xCD24D655), UINT32_C(0xE00F9102), UINT32_C(0x05F8D48E),
          UINT32_C(0x509D18D4), UINT32_C(0x403954E6)}},
        {{UINT32_C(0xE4FE16EC), UINT32_C(0xA04FDDDF), UINT32_C(0x90E15C0C),
          UINT32_C(0xB9E7FA73), UINT32_C(0xC77FAB6B), UINT32_C(0x7D6A7206),
          UINT32_C(0x3E221F12), UINT32_C(0x3FFDCCD1)},
         {UINT32_C(0x47B5BB7F), UINT32_C(0x120C05B1), UINT32_C(0x5B7E2B96),
          UINT32_C(0xFA3614C0), UINT32_C(0x4A6AC6E0), UINT32_C(0xF3A4F07F),
          UINT32_C(0xC8AD4F23), UINT32_C(0x0324BF48)}},
        {{UINT32_C(0x55DF2F18), UINT32_C(0x508A0370), UINT32_C(0xB872F209),
          UINT32_C(0x1C6C91EA), UINT32_C(0x8E12F437), UINT32_C(0xDC3F6C5A),
          UINT32_C(0xC91AFD75), UINT32_C(0x65F5058F)},
         {UINT32_C(0x5A859A1D), UINT32_C(0x0C43613D), UINT32_C(0x5BF96A6B),
          UINT32_C(0x83A2610E), UINT32_C(0x1496AEAD), UINT32_C(0x1A98AA4C),
          UINT32_C(0xE6CAA901), UINT32_C(0x3AB1CE5E)}},
        {{UINT32_C(0xFFB3E411), UINT32_C(0x9420ABFE), UINT32_C(0x31404E74),
          UINT32_C(0xCE609760), UINT32_C(0x02C49837), UINT32_C(0x3D4C23C5),
          UINT32_C(0xD0868A3C), UINT32_C(0x6B79FB14)},
         {UINT32_C(0x6B5861EA), UINT32_C(0xB4EEE8DB), UINT32_C(0x9D948195),
          UINT32_C(0x495E2B46), UINT32_C(0x1CE15EC9), UINT32_C(0x2BB0BD94),
          UINT32_C(0xDED25955), UINT32_C(0x6CE79F80)}},
        {{UINT32_C(0x5820DF65), UINT32_C(0xA6B98C1D), UINT32_C(0x909356B5),
          UINT32_C(0xE8284737), UINT32_C(0x091340E1), UINT32_C(0x38E8609A),
          UINT32_C(0x10666012), UINT32_C(0x98EC077B)},
         {UINT32_C(0xBF075DAE), UINT32_C(0xFB243B1E), UINT32_C(0xA270FE31),
          UINT32_C(0x32312BAC), UINT32_C(0x0CAA5F8E), UINT32_C(0x21451120),
          UINT32_C(0x2A515015), UINT32_C(0x8F60118F)}},
        {{UINT32_C(0xCBDEB88E), UINT32_C(0x4F211C9E), UINT32_C(0xB6D680FD),
          UINT32_C(0xF6D3CC3A), UINT32_C(0x8BF4B4A7), UINT32_C(0xE193829D),
          UINT32_C(0x2D620371), UINT32_C(0x3223EF4E)},
         {UINT32_C(0xC0E5245A), UINT32_C(0xC3E35420), UINT32_C(0xB4ADE2EA),
          UINT32_C(0xD3F4F894), UINT32_C(0xF2CE985E), UINT32_C(0x464FCB6C),
          UINT32_C(0x7B987FA7), UINT32_C(0x79CF596D)}},
        {{UINT32_C(0x0C0016FF), UINT32_C(0x0730748C), UINT32_C(0xA2949069),
          UINT32_C(0xD02115C5), UINT32_C(0x40E9C7F9), UINT32_C(0xAA6F794D),
          UINT32_C(0x79149C37), UINT32_C(0x9514FA7B)},
         {UINT32_C(0x5A46BCE0), UINT32_C(0x6E2F2778), UINT32_C(0x0837ACD5),
          UINT32_C(0xF55D46C6), UINT32_C(0x1E4223E6), UINT32_C(0xF965C468),
          UINT32_C(0x85D90A07), UINT32_C(0x0BFF0A91)}},
        {{UINT32_C(0x1923C8AF), UINT32_C(0x9ED90358), UINT32_C(0xA470AE00),
          UINT32_C(0xC425B633), UINT32_C(0x1C50FDAD), UINT32_C(0xF9F4B162),
          UINT32_C(0xA8CA2BD5), UINT32_C(0x0999D072)},
         {UINT32_C(0xAF74D4C3), UINT32_C(0xCB122FBD), UINT32_C(0x2C283752),
          UINT32_C(0x372C13F0), UINT32_C(0x82138B19), UINT32_C(0x9F42A903),
          UINT32_C(0x3EB8CB95), UINT32_C(0x573A2CEE)}},
        {{UINT32_C(0x3AC2E191), UINT32_C(0x6C3A6BE3), UINT32_C(0x1B222DB2),
          UINT32_C(0x4149E0EB), UINT32_C(0xA4AACC55), UINT32_C(0x5BA91005),
          UINT32_C(0x1BFADBD0), UINT32_C(0x176BD33D)},
         {UINT32_C(0xA8DA0FEA), UINT32_C(0x4AEAF14E), UINT32_C(0xA7FF8E1C),
          UINT32_C(0xB12401F9), UINT32_C(0x0F192414), UINT32_C(0xF1EF39AE),
          UINT32_C(0x416743C1), UINT32_C(0x95D433D3)}},
        {{UINT32_C(0x9AA0C238), UINT32_C(0x29ECF54D), UINT32_C(0x8FCA6419),
          UINT32_C(0x3762F1D7), UINT32_C(0x64D3AAA9), UINT32_C(0x761D786A),
          UINT32_C(0xDAEC7BF4), UINT32_C(0x7A8A677D)},
         {UINT32_C(0x324676F4), UINT32_C(0xC2829EAD), UINT32_C(0x4D0B291E),
          UINT32_C(0x4E504A47), UINT32_C(0xF8C4F384), UINT32_C(0x360CE7FE),
          UINT32_C(0x78CDA37D), UINT32_C(0x33A577B5)}},
        {{UINT32_C(0x333103FD), UINT32_C(0x1BBFC128), UINT32_C(0xE45C9DBE),
          UINT32_C(0x3D36045C), UINT32_C(0x15C9013D), UINT32_C(0xA8D53F5A),
          UINT32_C(0xA33FDCFD), UINT32_C(0x99D62F8A)},
         {UINT32_C(0x0A81F581), UINT32_C(0x73E53961), UINT32_C(0xD00BC0D9),
          UINT32_C(0xD01AD20E), UINT32_C(0x1F6D9B73), UINT32_C(0x59701F4D),
          UINT32_C(0xE098E536), UINT32_C(0x0F4EBFBC)}},
        {{UINT32_C(0x91E3C062), UINT32_C(0xBDB9368A), UINT32_C(0x9B17AAE5),
          UINT32_C(0xCD66A0B1), UINT32_C(0xB4537E05), UINT32_C(0xB6636DD7),
          UINT32_C(0x73B119CE), UINT32_C(0x37D94B8E)},
         {UINT32_C(0xC7428FF9), UINT32_C(0xA5F8E90F), UINT32_C(0xF8EA9F03),
          UINT32_C(0xE7E5B2B7), UINT32_C(0x5B3506DA), UINT32_C(0xB7F20FB8),
          UINT32_C(0xE494FFDA), UINT32_C(0x0F4AB6D5)}},
        {{UINT32_C(0x85365933), UINT32_C(0x3ACEE3BD), UINT32_C(0xBF510114),
          UINT32_C(0x9D5223D3), UINT32_C(0xA08D01B0), UINT32_C(0xE0D7D9A7),
          UINT32_C(0xB2F1F61F), UINT32_C(0x28FD329A)},
         {UINT32_C(0xA5909DD3), UINT32_C(0x3E16A2E2), UINT32_C(0xB4FECB35),
          UINT32_C(0x284A8708), UINT32_C(0x73D5BFBA), UINT32_C(0x190F7B3A),
          UINT32_C(0x92EE4BBE), UINT32_C(0x7E07982E)}},
        {{UINT32_C(0x44945687), UINT32_C(0xA30A4C22), UINT32_C(0xD688A301),
          UINT32_C(0x657C0F2E), UINT32_C(0xBBB3E65A), UINT32_C(0x9B558D4A),
          UINT32_C(0xA6E57844), UINT32_C(0x8044D57E)},
         {UINT32_C(0xE3957E21), UINT32_C(0xF202E50E), UINT32_C(0xCE62FCC9),
          UINT32_C(0x4957E651), UINT32_C(0xC4ECE0B8), UINT32_C(0xF7B9EBA4),
          UINT32_C(0x61167229), UINT32_C(0x29532CEC)}},
        {{UINT32_C(0x3EEF3D71), UINT32_C(0xE9DC8EA6), UINT32_C(0x3E8EC117),
          UINT32_C(0xEBF76BD4), UINT32_C(0x2EA072B9), UINT32_C(0x48CEB78D),
          UINT32_C(0x73EFC32D), UINT32_C(0x82ECDFC4)},
         {UINT32_C(0xE2C89E7D), UINT32_C(0x51B02CB3), UINT32_C(0xF4D9100F),
          UINT32_C(0xE9D0740C), UINT32_C(0x8A5E3F48), UINT32_C(0xBB556EFE),
          UINT32_C(0x1D01B44E), UINT32_C(0x864E52DA)}},
    },
    {
        {{UINT32_C(0x14EA6DC5), UINT32_C(0x5A75E0BD), UINT32_C(0x532EFED7),
          UINT32_C(0x09F2AA76), UINT32_C(0x83CE5A18), UINT32_C(0xE6DAE0A9),
          UINT32_C(0xCEB4E78D), UINT32_C(0x00F9BCB7)},
         {UINT32_C(0x71F79BF3), UINT32_C(0x128FB51C), UINT32_C(0x80D5DBC3),
          UINT32_C(0x78C79788), UINT32_C(0x9B816B9E), UINT32_C(0x2752F02C),
          UINT32_C(0xEB7622E2), UINT32_C(0x88CFBA0C)}},
        {{UINT32_C(0x268432A3), UINT32_C(0x845AB940), UINT32_C(0x2F94F6D3),
          UINT32_C(0xA8D0231B), UINT32_C(0xFEC02130), UINT32_C(0xBDFB3F91),
          UINT32_C(0x5F62419F), UINT32_C(0x07A61AE4)},
         {UINT32_C(0x192EBF1A), UINT32_C(0xD1C951DF), UINT32_C(0xFA232E34),
          UINT32_C(0x22CDCFF5), UINT32_C(0x3A7581DD), UINT32_C(0xDFDF121B),
          UINT32_C(0x710403A5), UINT32_C(0x9865ECA2)}},
        {{UINT32_C(0xF8180BAB), UINT32_C(0x609F4527), UINT32_C(0x50A6D914),
          UINT32_C(0x93AB1072), UINT32_C(0xE2EEE3BD), UINT32_C(0x299D5013),
          UINT32_C(0x42959C14), UINT32_C(0x36EFCE5B)},
         {UINT32_C(0x1045FFCB), UINT32_C(0x49CDA60D), UINT32_C(0x45723371),
          UINT32_C(0xA8B2492E), UINT32_C(0xF243FDBB), UINT32_C(0xCB75789B),
          UINT32_C(0x871D500D), UINT32_C(0x8E1079D7)}},
        {{UINT32_C(0xDB14298E), UINT32_C(0x69852694), UINT32_C(0x41A56B6D),
          UINT32_C(0xBAA92A95), UINT32_C(0x3DBFDBA4), UINT32_C(0xC7371848),
          UINT32_C(0x947747F8), UINT32_C(0x94B3155C)},
         {UINT32_C(0x7552426B), UINT32_C(0x97BCDD19), UINT32_C(0x32682121),
          UINT32_C(0x4FB3E76D), UINT32_C(0x8BC15FCA), UINT32_C(0x875AA0F7),
          UINT32_C(0xF1FD2315), UINT32_C(0x4065BCDF)}},
        {{UINT32_C(0xB7F1ED04), UINT32_C(0x2D1C0519), UINT32_C(0xEA2535E1),
          UINT32_C(0xED9A1BB7), UINT32_C(0xABAE813E), UINT32_C(0xE4728CD6),
          UINT32_C(0x21A771D0), UINT32_C(0x2CD7D447)},
         {UINT32_C(0x59B9E964), UINT32_C(0x88E2A785), UINT32_C(0x6F9B5374),
          UINT32_C(0x2677FBD7), UINT32_C(0x2645B626), UINT32_C(0x3967D6C5),
          UINT32_C(0x5A1C315B), UINT32_C(0x8843F7DF)}},
        {{UINT32_C(0xC7055A4E), UINT32_C(0x673CD273), UINT32_C(0xEE827873),
          UINT32_C(0x052AC45C), UINT32_C(0xCE1981F3), UINT32_C(0xC26B9214),
          UINT32_C(0x2B8EEF59), UINT32_C(0x3C39C13C)},
         {UINT32_C(0x0B276D47), UINT32_C(0xDD9E1B9B), UINT32_C(0x7287F9A1),
          UINT32_C(0x6729A534), UINT32_C(0x061DAD53), UINT32_C(0x43E1471C),
          UINT32_C(0x118B56C8), UINT32_C(0x6082FAD9)}},
        {{UINT32_C(0xF99186D6), UINT32_C(0x9C3872AA), UINT32_C(0x75AC99BF),
          UINT32_C(0x1D9E8DB6), UINT32_C(0xE338DBD3), UINT32_C(0x6FA7A0FF),
          UINT32_C(0xD1FEF2F9), UINT32_C(0x1EDF44EC)},
         {UINT32_C(0x1F9114BF), UINT32_C(0xBAF9D33A), UINT32_C(0x3007B6A5),
          UINT32_C(0x89AF08E5), UINT32_C(0x8436D917), UINT32_C(0xAA04B169),
          UINT32_C(0x6AFCF5E0), UINT32_C(0x8381E76A)}},
        {{UINT32_C(0xC1D799BA), UINT32_C(0xC51848A4), UINT32_C(0x7F40B34B),
          UINT32_C(0x6C3D43A9), UINT32_C(0xA5CB7B95), UINT32_C(0xE8DAE074),
          UINT32_C(0xBB5F8AEC), UINT32_C(0x5375B1EE)},
         {UINT32_C(0x507099E6), UINT32_C(0x461290EE), UINT32_C(0x3BAD89AD),
          UINT32_C(0xB95934AA), UINT32_C(0x701A4D9C), UINT32_C(0x9A6E5C22),
          UINT32_C(0x5E1389F6), UINT32_C(0x2CA79144)}},
        {{UINT32_C(0x0E5108FC), UINT32_C(0xBF82F786), UINT32_C(0x644D06DE),
          UINT32_C(0x3620CCC4), UINT32_C(0x8E5C4753), UINT32_C(0xB65DE853),
          UINT32_C(0x9FEDFD16), UINT32_C(0x6DAB7241)},
         {UINT32_C(0x546DCBA4), UINT32_C(0x4CECAC87), UINT32_C(0x3E2D0684),
          UINT32_C(0xA7BBE65D), UINT32_C(0xDA1E4FFA), UINT32_C(0x092AA490),
          UINT32_C(0x41AD32AF), UINT32_C(0x78F448BE)}},
        {{UINT32_C(0x4A33F071), UINT32_C(0x321580FE), UINT32_C(0x5EE5E685),
          UINT32_C(0xBEA845D1), UINT32_C(0x47AC8ACF), UINT32_C(0xC73CAECE),
          UINT32_C(0xA9F65F05), UINT32_C(0x0E15E55D)},
         {UINT32_C(0xA59506E7), UINT32_C(0x5FC47420), UINT32_C(0x01DBD2DD),
          UINT32_C(0x501417FF), UINT32_C(0xFB1205A6), UINT32_C(0x8EF23280),
          UINT32_C(0xE0F43AE8), UINT32_C(0x1AA26168)}},
        {{UINT32_C(0x8149EB2A), UINT32_C(0xD41F73B1), UINT32_C(0xAD95D531),
          UINT32_C(0xC297AF04), UINT32_C(0x749E415D), UINT32_C(0x2017176F),
          UINT32_C(0x8357CE9A), UINT32_C(0x5AF89C73)},
         {UINT32_C(0x08A0FF9C), UINT32_C(0x301F7C79), UINT32_C(0x98695C57),
          UINT32_C(0x0C2999B5), UINT32_C(0x6E4D8FF5), UINT32_C(0x85679957),
          UINT32_C(0x6F493B1C), UINT32_C(0x2CC0FF3E)}},
        {{UINT32_C(0x4AF481F5), UINT32_C(0xFE90F904), UINT32_C(0x31BC4919),
          UINT32_C(0x0562C78B), UINT32_C(0x70E4F140), UINT32_C(0xAA44AA56),
          UINT32_C(0xA175159A), UINT32_C(0x1B61DEB4)},
         {UINT32_C(0xA7A7E648), UINT32_C(0x85315DE1), UINT32_C(0x6C012B33),
          UINT32_C(0x4BC1F51D), UINT32_C(0x060CDEE6), UINT32_C(0x40CB5DE3),
          UINT32_C(0x32A1E138), UINT32_C(0x969F9196)}},
        {{UINT32_C(0xE05F23B5), UINT32_C(0x3B317508), UINT32_C(0x512D1156),
          UINT32_C(0x7B1A93AE), UINT32_C(0xCB58EC19), UINT32_C(0x3A283415),
          UINT32_C(0x8E27CAD9), UINT32_C(0x193A53A1)},
         {UINT32_C(0x03DE1BA8), UINT32_C(0xCF6BBEBA), UINT32_C(0x47A02393),
          UINT32_C(0xFA5544CA), UINT32_C(0x8627F5EB), UINT32_C(0x8B3AAC1A),
          UINT32_C(0x62EAF195), UINT32_C(0x02FAD2EC)}},
        {{UINT32_C(0x259CCF0F), UINT32_C(0x4F8D8ADA), UINT32_C(0x562991D7),
          UINT32_C(0xE4E6786B), UINT32_C(0x597C3FD3), UINT32_C(0xA1C63473),
          UINT32_C(0xACAB6F16), UINT32_C(0x1F5B9017)},
         {UINT32_C(0x592D437A), UINT32_C(0x95B201BD), UINT32_C(0xED14F859),
          UINT32_C(0x54432A75), UINT32_C(0x0B551AC1), UINT32_C(0x67EF73FB),
          UINT32_C(0x7F1AB9CA), UINT32_C(0x0A48F043)}},
        {{UINT32_C(0x4A35445C), UINT32_C(0xECEE508E), UINT32_C(0xB3EA6F9B),
          UINT32_C(0x80BE9F07), UINT32_C(0x87E4B78E), UINT32_C(0xD914B256),
          UINT32_C(0xF89B8E4B), UINT32_C(0x97F79CC9)},
         {UINT32_C(0xC359FB12), UINT32_C(0x6A5B4F2B), UINT32_C(0x99CF6FFA),
          UINT32_C(0x54E6E37A), UINT32_C(0xF7C66CA8), UINT32_C(0x1133C4B2),
          UINT32_C(0x0345866B), UINT32_C(0x6F679B28)}},
        {{UINT32_C(0x44E77CDF), UINT32_C(0x0006F7A1), UINT32_C(0x42033333),
          UINT32_C(0xD8077F9F), UINT32_C(0x21EAF35F), UINT32_C(0x0414ECE5),
          UINT32_C(0x5623803C), UINT32_C(0x1211576B)},
         {UINT32_C(0x140309A7), UINT32_C(0xEDADD215), UINT32_C(0x5EBAE3BB),
          UINT32_C(0xC349C657), UINT32_C(0x821DE06B), UINT32_C(0xBD40427C),
          UINT32_C(0x3F5D2F97), UINT32_C(0x8949ACA3)}},
    },
    {
        {{UINT32_C(0x022E3D44), UINT32_C(0xAC1F87E6), UINT32_C(0xB39F6B10),
          UINT32_C(0xDFC17BED), UINT32_C(0x07119C4A), UINT32_C(0xEAAE4168),
          UINT32_C(0xDBD47D36), UINT32_C(0x8B3B40BC)},
         {UINT32_C(0x861B7B59), UINT32_C(0x6683A561), UINT32_C(0x13A6C76D),
          UINT32_C(0xF9BFFB17), UINT32_C(0xA30A05AC), UINT32_C(0xE4E72EA4),
          UINT32_C(0xBA0D2AD6), UINT32_C(0x77C219E8)}},
        {{UINT32_C(0x66BE6944), UINT32_C(0x5019824E), UINT32_C(0x7B131070),
          UINT32_C(0x811ACEBE), UINT32_C(0x3BA34677), UINT32_C(0x9730DCF0),
          UINT32_C(0x7BC9CFC8), UINT32_C(0x5B9C5CF5)},
         {UINT32_C(0xB283C8CC), UINT32_C(0x1CBD950F), UINT32_C(0x3973A325),
          UINT32_C(0xF66DBDDA), UINT32_C(0x6FA60257), UINT32_C(0x4EC5EBC2),
          UINT32_C(0x36FF26B3), UINT32_C(0x0C01D577)}},
        {{UINT32_C(0x7CE2BE74), UINT32_C(0xBB221954), UINT32_C(0x841E6C0C),
          UINT32_C(0x23E44E0E), UINT32_C(0x77C3824E), UINT32_C(0xE760D33D),
          UINT32_C(0x7EB3CE34), UINT32_C(0x5B656FBE)},
         {UINT32_C(0xC5F3D66E), UINT32_C(0xEC50E509), UINT32_C(0x496EF8BA),
          UINT32_C(0x5326C2B8), UINT32_C(0x3D4B20D4), UINT32_C(0x3F9485F6),
          UINT32_C(0x51C21B0E), UINT32_C(0x11B74A85)}},
        {{UINT32_C(0x25E30336), UINT32_C(0xC3EAEB04), UINT32_C(0xA6E3637F),
          UINT32_C(0xA9D6C70F), UINT32_C(0x86F77F68), UINT32_C(0xF818C37E),
          UINT32_C(0xC60DF35A), UINT32_C(0x786ED3C2)},
         {UINT32_C(0xD56D705A), UINT32_C(0xACA70EA0), UINT32_C(0x7BF4EF10),
          UINT32_C(0xCE61608C), UINT32_C(0x1722C179), UINT32_C(0x49AD1CD8),
          UINT32_C(0x687F3222), UINT32_C(0x1B84FBE9)}},
        {{UINT32_C(0x35EE0BA9), UINT32_C(0x8A0F4BF1), UINT32_C(0x03952A08),
          UINT32_C(0x42AD2846), UINT32_C(0x3B60B4DD), UINT32_C(0x1E0E1E3B),
          UINT32_C(0xF5DCAD76), UINT32_C(0x0DC1A947)},
         {UINT32_C(0x1F496E03), UINT32_C(0x054BECA4), UINT32_C(0x3AE6E6F6),
          UINT32_C(0x8F02FDAB), UINT32_C(0x9B71C9F5), UINT32_C(0x8851CFF4),
          UINT32_C(0xA7441F87), UINT32_C(0x6BD7271C)}},
        {{UINT32_C(0x9EB6A2C3), UINT32_C(0xB019E346), UINT32_C(0x931E7550),
          UINT32_C(0x2B719034), UINT32_C(0x40698F1F), UINT32_C(0x2B2CBEBD),
          UINT32_C(0x4F1FC587), UINT32_C(0x375DB591)},
         {UINT32_C(0x676A79A4), UINT32_C(0x09843166), UINT32_C(0xB416D657),
          UINT32_C(0x91848967), UINT32_C(0x9FED6B27), UINT32_C(0xB49EA721),
          UINT32_C(0xD080C8AA), UINT32_C(0x1FAC5650)}},
        {{UINT32_C(0x58C4C2AA), UINT32_C(0x205CD588), UINT32_C(0x17F572EE),
          UINT32_C(0xBEEE26F8), UINT32_C(0x4CB4DE3A), UINT32_C(0xE744AB67),
          UINT32_C(0xCBE989BD), UINT32_C(0x37E34E18)},
         {UINT32_C(0x767D31B5), UINT32_C(0x95D9118B), UINT32_C(0x83E7C03E),
          UINT32_C(0x9A34DBEC), UINT32_C(0xB8F70DD3), UINT32_C(0xCAFDBD1A),
          UINT32_C(0x3909BB51), UINT32_C(0x1E68A681)}},
        {{UINT32_C(0x9FD96ABA), UINT32_C(0xFE0A5DFF), UINT32_C(0xD99B68DE),
          UINT32_C(0xBBFB1FDF), UINT32_C(0xE3F522BE), UINT32_C(0x5E232A4F),
          UINT32_C(0xA6428D33), UINT32_C(0x768C2C54)},
         {UINT32_C(0xDBF1A575), UINT32_C(0xE9CFEDF9), UINT32_C(0x4B83F9AB),
          UINT32_C(0x841721F2), UINT32_C(0x80A85361), UINT32_C(0xFAD9650A),
          UINT32_C(0x04979759), UINT32_C(0x31589211)}},
        {{UINT32_C(0xEFBF2099), UINT32_C(0x1CF9F4B8), UINT32_C(0xF571408B),
          UINT32_C(0x63D5499B), UINT32_C(0xEC3E74A6), UINT32_C(0x89C119FC),
          UINT32_C(0x698E4DCD), UINT32_C(0x0525DDDF)},
         {UINT32_C(0x7333A38C), UINT32_C(0x43FCDDE4), UINT32_C(0x80A912DE),
          UINT32_C(0x2150EAD4), UINT32_C(0x0A19CC55), UINT32_C(0x4B3BD223),
          UINT32_C(0x238AC64C), UINT32_C(0x3553EB4E)}},
        {{UINT32_C(0xFEC2371F), UINT32_C(0x3A259F52), UINT32_C(0x44863D3E),
          UINT32_C(0x8B03C505), UINT32_C(0x86BB6522), UINT32_C(0x1053E2D6),
          UINT32_C(0xF7086CBE), UINT32_C(0x400CE699)},
         {UINT32_C(0x03ED78DE), UINT32_C(0x695B1EA0), UINT32_C(0x16500E1B),
          UINT32_C(0x00AE6D09), UINT32_C(0x14B01815), UINT32_C(0x9F29B089),
          UINT32_C(0xC218D892), UINT32_C(0x269692B4)}},
        {{UINT32_C(0xF0D44E79), UINT32_C(0x8660280D), UINT32_C(0x37C0F38F),
          UINT32_C(0x69D29685), UINT32_C(0xB9E24AD8), UINT32_C(0x664B8146),
          UINT32_C(0x1E695452), UINT32_C(0x277CB4DD)},
         {UINT32_C(0xDFBF05EB), UINT32_C(0xB1A02D4E), UINT32_C(0x4A1426C7),
          UINT32_C(0x3B349308), UINT32_C(0x22204FE7), UINT32_C(0x13B79612),
          UINT32_C(0xBCB5CD9F), UINT32_C(0x04F80867)}},
        {{UINT32_C(0xE0852CBC), UINT32_C(0x37BDBCAE), UINT32_C(0xBE22764C),
          UINT32_C(0x2A6D7A23), UINT32_C(0x25AFD9FF), UINT32_C(0x4E0D43AC),
          UINT32_C(0xD16DD9EB), UINT32_C(0x1F6C9E14)},
         {UINT32_C(0xB4B0F47A), UINT32_C(0xE37E3AB3), UINT32_C(0x6C476C3A),
          UINT32_C(0x09E046FB), UINT32_C(0xB75FA2DC), UINT32_C(0xB8F649D9),
          UINT32_C(0xFAB1AC41), UINT32_C(0x7962A8C4)}},
        {{UINT32_C(0xF6A1314A), UINT32_C(0x00E41470), UINT32_C(0xE4388464),
          UINT32_C(0x176380C3), UINT32_C(0x9B8A2B4D), UINT32_C(0xDB3405CD),
          UINT32_C(0x7DE02ABC), UINT32_C(0x6299A1A6)},
         {UINT32_C(0x7BBE7BFA), UINT32_C(0x9F6B9DE7), UINT32_C(0x9D3098DD),
          UINT32_C(0x59F16F54), UINT32_C(0x3B5767FE), UINT32_C(0xFEC29C8D),
          UINT32_C(0x64955759), UINT32_C(0x67711BC0)}},
        {{UINT32_C(0xB1B07B5D), UINT32_C(0x34444EA3), UINT32_C(0x91FA2B4A),
          UINT32_C(0xB1D973B4), UINT32_C(0x83403A0E), UINT32_C(0xEBEBEFB1),
          UINT32_C(0x8E8A8EC6), UINT32_C(0x56D52098)},
         {UINT32_C(0xA7E82D55), UINT32_C(0x11C93529), UINT32_C(0xD525C399),
          UINT32_C(0x9230AE03), UINT32_C(0x8DB46C82), UINT32_C(0x74E1CBB2),
          UINT32_C(0x40BE5E15), UINT32_C(0x4C3383CC)}},
        {{UINT32_C(0xCDAD72F3), UINT32_C(0x33A52E73), UINT32_C(0xB9E77759),
          UINT32_C(0x1D2CCA33), UINT32_C(0x549406F5), UINT32_C(0x26717716),
          UINT32_C(0x5B3DB3E8), UINT32_C(0x70DED57F)},
         {UINT32_C(0x43C85A67), UINT32_C(0xBA38F813), UINT32_C(0x35422BB3),
          UINT32_C(0x956F2DD7), UINT32_C(0x07486F18), UINT32_C(0x52D9FA99),
          UINT32_C(0x75D1D2C4), UINT32_C(0x655791BF)}},
        {{UINT32_C(0x1FC9E0B3), UINT32_C(0xF434A960), UINT32_C(0xBEDE92AD),
          UINT32_C(0x42A7B891), UINT32_C(0xA55A8009), UINT32_C(0x05A182D8),
          UINT32_C(0x38531612), UINT32_C(0x3404E08D)},
         {UINT32_C(0xF07D76E3), UINT32_C(0x2B5B2766), UINT32_C(0x1D77B90C),
          UINT32_C(0x94B1A98D), UINT32_C(0x4B18BB9F), UINT32_C(0xA86C0EC8),
          UINT32_C(0x526A81E3), UINT32_C(0x6532770F)}},
    },
    {
        {{UINT32_C(0x61CFE04A), UINT32_C(0x4429A4E8), UINT32_C(0x2C9CA012),
          UINT32_C(0xEE867386), UINT32_C(0xC32D1969), UINT32_C(0x237A3040),
          UINT32_C(0x0AE2DFAE), UINT32_C(0x400AD599)},
         {UINT32_C(0x213C0A18), UINT32_C(0x1603D10A), UINT32_C(0x2B1E2A57),
          UINT32_C(0x6EB8042D), UINT32_C(0xC7CAF556), UINT32_C(0x4C9C1696),
          UINT32_C(0xE0C1A5A3), UINT32_C(0x79BE04A7)}},
        {{UINT32_C(0x3FCB8B14), UINT32_C(0x161781E3), UINT32_C(0xB1384C3C),
          UINT32_C(0x1383E3B8), UINT32_C(0xB566626C), UINT32_C(0x5129EA19),
          UINT32_C(0x551DE02A), UINT32_C(0x8A1F86E4)},
         {UINT32_C(0xAEDBE04C), UINT32_C(0x9C648CCE), UINT32_C(0xFB200132),
          UINT32_C(0x0D4278AC), UINT32_C(0xC1E2D4A3), UINT32_C(0x466D452A),
          UINT32_C(0xB21B6E38), UINT32_C(0x832B0E6E)}},
        {{UINT32_C(0xED1D76C7), UINT32_C(0x20101D7C), UINT32_C(0xC110D85E),
          UINT32_C(0xC3282661), UINT32_C(0xFFCA2DD7), UINT32_C(0xB8026CE4),
          UINT32_C(0x8BA48211), UINT32_C(0x73B4EBA5)},
         {UINT32_C(0xD8554E2C), UINT32_C(0xAB94FE21), UINT32_C(0x81B2A181),
          UINT32_C(0x319E2FD7), UINT32_C(0x37E8D3E2), UINT32_C(0x2C824DC5),
          UINT32_C(0x09FCA0AB), UINT32_C(0x97CD457A)}},
        {{UINT32_C(0xC50116CB), UINT32_C(0x8E4B5FBD), UINT32_C(0xCA631A93),
          UINT32_C(0x3D20CECE), UINT32_C(0x545575D8), UINT32_C(0x5F80606C),
          UINT32_C(0xF91C7908), UINT32_C(0x45ED55DE)},
         {UINT32_C(0x7CC1083C), UINT32_C(0x91870A92), UINT32_C(0xD360FF5C),
          UINT32_C(0xA3828E06), UINT32_C(0x84003D42), UINT32_C(0xFC9DFCDC),
          UINT32_C(0xFAC4667F), UINT32_C(0x0733C887)}},
        {{UINT32_C(0xCC2FC31B), UINT32_C(0x6F1F771A), UINT32_C(0x902E8176),
          UINT32_C(0xDA9351A1), UINT32_C(0xCE3FF045), UINT32_C(0xFB9395AF),
          UINT32_C(0x13820DAB), UINT32_C(0x17C28CA2)},
         {UINT32_C(0xA684E6FA), UINT32_C(0xA1F596BC), UINT32_C(0xDAD3995A),
          UINT32_C(0x89228CC7), UINT32_C(0xC02E458B), UINT32_C(0x5DBFD421),
          UINT32_C(0xA2122AFE), UINT32_C(0x58C25045)}},
        {{UINT32_C(0x018EADB0), UINT32_C(0x2906450F), UINT32_C(0x9030C84E),
          UINT32_C(0x88A7A236), UINT32_C(0x33308084), UINT32_C(0x492BA7A3),
          UINT32_C(0x5605F371), UINT32_C(0x321388B9)},
         {UINT32_C(0x626AE19A), UINT32_C(0x5F934C94), UINT32_C(0x01C7CCD9),
          UINT32_C(0xE2BD6C67), UINT32_C(0xEC0BBD52), UINT32_C(0xB07757B1),
          UINT32_C(0xF9EDD2AC), UINT32_C(0x1E980338)}},
        {{UINT32_C(0x8831457C), UINT32_C(0x5A537074), UINT32_C(0x47E7B9A9),
          UINT32_C(0x0E0E22FB), UINT32_C(0xA225A259), UINT32_C(0x7BE70594),
          UINT32_C(0x30946816), UINT32_C(0x433DB055)},
         {UINT32_C(0xE2F2C3CB), UINT32_C(0x852EA9F9), UINT32_C(0x2D243848),
          UINT32_C(0xDC4E8E3A), UINT32_C(0x1E887770), UINT32_C(0x10F34AB8),
          UINT32_C(0xC89FC71B), UINT32_C(0x29795D2C)}},
        {{UINT32_C(0xCFEC2C6F), UINT32_C(0xE046B04B), UINT32_C(0x2CA8256E),
          UINT32_C(0xA1D3B5A0), UINT32_C(0xE87F767F), UINT32_C(0x93F7FDFA),
          UINT32_C(0x35FA3837), UINT32_C(0x2DF5693E)},
         {UINT32_C(0x97884587), UINT32_C(0x71D9638C), UINT32_C(0x39E115EC),
          UINT32_C(0x175EA91F), UINT32_C(0xF41A27FC), UINT32_C(0x14E16C31),
          UINT32_C(0xEB2F5913), UINT32_C(0x8B2682EA)}},
        {{UINT32_C(0x798C7F28), UINT32_C(0x2BCC6853), UINT32_C(0xDD7D3615),
          UINT32_C(0x2F985A59), UINT32_C(0x41D2257A), UINT32_C(0xA66519E1),
          UINT32_C(0x021F719B), UINT32_C(0x18731D74)},
         {UINT32_C(0x360E9C20), UINT32_C(0x7210472C), UINT32_C(0x329A9B35),
          UINT32_C(0x4FB48411), UINT32_C(0x87D62CA5), UINT32_C(0xB33B6CB5),
          UINT32_C(0xFD0D7703), UINT32_C(0x86226D9E)}},
        {{UINT32_C(0xF67CB77C), UINT32_C(0xDD133F8B), UINT32_C(0xF6ABEE80),
          UINT32_C(0x381E4D62), UINT32_C(0x7DF85AE5), UINT32_C(0x3236F005),
          UINT32_C(0x4610BB0E), UINT32_C(0x88EBB386)},
         {UINT32_C(0x8DB908D8), UINT32_C(0x895AA539), UINT32_C(0x104C4633),
          UINT32_C(0x848142E6), UINT32_C(0xB8012B2E), UINT32_C(0x467EE770),
          UINT32_C(0x1B9210EE), UINT32_C(0x193CBAED)}},
        {{UINT32_C(0xC1F44FC1), UINT32_C(0x737CD32B), UINT32_C(0x522B6209),
          UINT32_C(0xCDF82B1C), UINT32_C(0xE0017F2A), UINT32_C(0x08F4BB70),
          UINT32_C(0x64738F26), UINT32_C(0x1565BCEF)},
         {UINT32_C(0x684DCF67), UINT32_C(0x0D2910B9), UINT32_C(0xC6F3EB81),
          UINT32_C(0x4ED1734B), UINT32_C(0xDA1D6BC8), UINT32_C(0xCBEA79B6),
          UINT32_C(0xEE6A41D6), UINT32_C(0x0470CE36)}},
        {{UINT32_C(0xBA05AF3C), UINT32_C(0xECFD5C66), UINT32_C(0xEB9BFAA8),
          UINT32_C(0x421D5540), UINT32_C(0x526CFF85), UINT32_C(0xFC0E5AF2),
          UINT32_C(0x53DC49A6), UINT32_C(0x7E17F1E6)},
         {UINT32_C(0x1FAEB0A2), UINT32_C(0x69BB1DFB), UINT32_C(0xB3785ED4),
          UINT32_C(0xDC95661A), UINT32_C(0x676D7CD0), UINT32_C(0x1F1D7395),
          UINT32_C(0x89C6412F), UINT32_C(0x2C16BB96)}},
        {{UINT32_C(0xEE414CA6), UINT32_C(0x2335F20E), UINT32_C(0xFEF5E042),
          UINT32_C(0x56E0DDB2), UINT32_C(0xD9DE2966), UINT32_C(0x942D4E35),
          UINT32_C(0xCF63D583), UINT32_C(0x80E92B8C)},
         {UINT32_C(0x5D492C76), UINT32_C(0x158BE1B6), UINT32_C(0xC4F822D9),
          UINT32_C(0xFF096960), UINT32_C(0x5AF79379), UINT32_C(0xC00FC730),
          UINT32_C(0x50D34E12), UINT32_C(0x07C49B03)}},
        {{UINT32_C(0xC34836C8), UINT32_C(0x64678B2E), UINT32_C(0x615FF066),
          UINT32_C(0xCC280DCB), UINT32_C(0x9131EC98), UINT32_C(0x86C3C747),
          UINT32_C(0x2D151FAD), UINT32_C(0x35B008CC)},
         {UINT32_C(0xF8133FDC), UINT32_C(0x22C18852), UINT32_C(0x2FE8809D),
          UINT32_C(0x183BE4DC), UINT32_C(0xCF98D56D), UINT32_C(0x86589814),
          UINT32_C(0x2F6E0DE4), UINT32_C(0x52D8074D)}},
        {{UINT32_C(0xC9274AA6), UINT32_C(0x33FF9F41), UINT32_C(0xCA854AF1),
          UINT32_C(0xAC30ACB4), UINT32_C(0xFBC994B7), UINT32_C(0x87A7BE53),
          UINT32_C(0xDBCD717B), UINT32_C(0x6E7E8B2A)},
         {UINT32_C(0xCD494AB6), UINT32_C(0x3065A732), UINT32_C(0x60FD7F57),
          UINT32_C(0x6F977B87), UINT32_C(0xB74BAD54), UINT32_C(0x4C216EB4),
          UINT32_C(0xF6061F7A), UINT32_C(0x674F00F5)}},
        {{UINT32_C(0x3164AFBB), UINT32_C(0xA8C22481), UINT32_C(0x72A7AC55),
          UINT32_C(0x4C9E2F1D), UINT32_C(0x79DEFE94), UINT32_C(0xE3DAC3E3),
          UINT32_C(0xBB9D953F), UINT32_C(0x193A1E0B)},
         {UINT32_C(0x7E0957EE), UINT32_C(0x8852020C), UINT32_C(0xB62F8EF7),
          UINT32_C(0xF7FD181E), UINT32_C(0xE26B8860), UINT32_C(0x0DE7EDDE),
          UINT32_C(0xFD1B00DE), UINT32_C(0x53A05575)}},
    },
    {
        {{UINT32_C(0x63E0C8FC), UINT32_C(0xE5D63E1B), UINT32_C(0xC684016A),
          UINT32_C(0x6849B530), UINT32_C(0x009318AD), UINT32_C(0x4E89CB43),
          UINT32_C(0xEF571911), UINT32_C(0x1CDC5918)},
         {UINT32_C(0xF389EAF3), UINT32_C(0xA6596C03), UINT32_C(0xE88975F9),
          UINT32_C(0x9282C1B3), UINT32_C(0x0D53D3F2), UINT32_C(0xD07A2AEF),
          UINT32_C(0x2B3B602C), UINT32_C(0x3DA515D5)}},
        {{UINT32_C(0x8A5436EA), UINT32_C(0xE4285781), UINT32_C(0x36D65626),
          UINT32_C(0x047E3056), UINT32_C(0xE16489A0), UINT32_C(0x0016B568),
          UINT32_C(0x75A0209C), UINT32_C(0x44603196)},
         {UINT32_C(0xBCC19754), UINT32_C(0x2BE99A51), UINT32_C(0x5ACFCDEF),
          UINT32_C(0xE02EAFD0), UINT32_C(0xAECACABB), UINT32_C(0xB0A1E300),
          UINT32_C(0xAC1860D9), UINT32_C(0x0F39CBDE)}},
        {{UINT32_C(0x2099F08E), UINT32_C(0x50DA5372), UINT32_C(0xCA4817B1),
          UINT32_C(0xAA6AAAD1), UINT32_C(0x57D73192), UINT32_C(0xA4DDC5FF),
          UINT32_C(0x7682D453), UINT32_C(0x046043AC)},
         {UINT32_C(0x28CF3F48), UINT32_C(0xC8EB1788), UINT32_C(0xDCA184D4),
          UINT32_C(0x3967A02F), UINT32_C(0x86221941), UINT32_C(0x0CE68B79),
          UINT32_C(0xFD3A197A), UINT32_C(0x27BDCA48)}},
        {{UINT32_C(0x563D7A91), UINT32_C(0xD774E33C), UINT32_C(0x07AE1C92),
          UINT32_C(0x1C309DAE), UINT32_C(0x57DBE6A8), UINT32_C(0xDABA89B4),
          UINT32_C(0xE5820FA4), UINT32_C(0x90C62517)},
         {UINT32_C(0x11371109), UINT32_C(0x23C64605), UINT32_C(0x15605666),
          UINT32_C(0x1176AE7E), UINT32_C(0xDF040DCB), UINT32_C(0xD71E9755),
          UINT32_C(0x62ED515C), UINT32_C(0x5312A5B3)}},
        {{UINT32_C(0x7A5FB9E0), UINT32_C(0xB7AA3A11), UINT32_C(0x18E2CB32),
          UINT32_C(0xA769BC72), UINT32_C(0x6B73E050), UINT32_C(0x9D551B9B),
          UINT32_C(0xDB067CBC), UINT32_C(0x0CE51DF0)},
         {UINT32_C(0x4A0E06BE), UINT32_C(0x00BF90D5), UINT32_C(0x7EE820E7),
          UINT32_C(0xFEC6E7B3), UINT32_C(0x3334937A), UINT32_C(0xDFBAC083),
          UINT32_C(0xCE14CF46), UINT32_C(0x46884935)}},
        {{UINT32_C(0x902EF3A9), UINT32_C(0xC3F31EAF), UINT32_C(0x5CCDF002),
          UINT32_C(0xF3B6E6FA), UINT32_C(0x88CDDE0F), UINT32_C(0x5A9B5321),
          UINT32_C(0xE8691FED), UINT32_C(0x00D99E43)},
         {UINT32_C(0xCFE02C8B), UINT32_C(0x8E786F52), UINT32_C(0x4DD36F8E),
          UINT32_C(0x587AA537), UINT32_C(0x425CC228), UINT32_C(0xBCA91CAC),
          UINT32_C(0xBFA9C36B), UINT32_C(0x80AA8AA9)}},
        {{UINT32_C(0x9B20505A), UINT32_C(0xAD4A2AD0), UINT32_C(0x16739066),
          UINT32_C(0x6D708029), UINT32_C(0x89F73B52), UINT32_C(0x729001F3),
          UINT32_C(0x8073A428), UINT32_C(0x77480347)},
         {UINT32_C(0xE84DB3B4), UINT32_C(0x1AB38F07), UINT32_C(0xA6655769),
          UINT32_C(0xE643D756), UINT32_C(0x46C19856), UINT32_C(0x5631359B),
          UINT32_C(0x01C3DCD1), UINT32_C(0x82530A32)}},
        {{UINT32_C(0x2DDDB968), UINT32_C(0x9250EC26), UINT32_C(0x8D82A03E),
          UINT32_C(0x63D99CBF), UINT32_C(0x41349B60), UINT32_C(0x4FBFE784),
          UINT32_C(0xA15BF2B7), UINT32_C(0x6977DD07)},
         {UINT32_C(0x68513C32), UINT32_C(0x771917C6), UINT32_C(0x8F0064F7),
          UINT32_C(0x02603518), UINT32_C(0x51D78637), UINT32_C(0x45A57429),
          UINT32_C(0x87293790), UINT32_C(0x56BF57CC)}},
        {{UINT32_C(0x032E6426), UINT32_C(0xBAC94E24), UINT32_C(0xC2531B26),
          UINT32_C(0x7D54AE34), UINT32_C(0xCD688082), UINT32_C(0x4D6EF608),
          UINT32_C(0xF5AA4BEE), UINT32_C(0x736E7ACF)},
         {UINT32_C(0x6AFB84E2), UINT32_C(0x41D5BF6C), UINT32_C(0x6E976E09),
          UINT32_C(0x40E12DA5), UINT32_C(0x2235F7B9), UINT32_C(0xCBF32FCB),
          UINT32_C(0xA21BC0E0), UINT32_C(0x285DDF46)}},
        {{UINT32_C(0xCE751632), UINT32_C(0x66C6A76E), UINT32_C(0x32A61A1D),
          UINT32_C(0xBD457D0E), UINT32_C(0x78191C57), UINT32_C(0xFA12A7C8),
          UINT32_C(0x06611B5E), UINT32_C(0x030ED98B)},
         {UINT32_C(0xF4972FFD), UINT32_C(0x199F7756), UINT32_C(0x9C8AAB09),
          UINT32_C(0x298D98E6), UINT32_C(0xC5B02158), UINT32_C(0x2186054C),
          UINT32_C(0xB9B1147A), UINT32_C(0x0736CE4C)}},
        {{UINT32_C(0x19BFA57D), UINT32_C(0x33E4A4CA), UINT32_C(0xAA70C35D),
          UINT32_C(0xF02F6D32), UINT32_C(0x3CC082FD), UINT32_C(0x9EA10B63),
          UINT32_C(0xD00E82A8), UINT32_C(0x86104E8E)},
         {UINT32_C(0x87797E25), UINT32_C(0xACBA5E73), UINT32_C(0xEB85A796),
          UINT32_C(0x24DD98A8), UINT32_C(0xC58AC480), UINT32_C(0x02748827),
          UINT32_C(0x6A932D80), UINT32_C(0x5B4480C7)}},
        {{UINT32_C(0x1992B174), UINT32_C(0xF9E210FB), UINT32_C(0xBE22636E),
          UINT32_C(0x3CFA6EF1), UINT32_C(0x3BDFA2BD), UINT32_C(0xA46F202B),
          UINT32_C(0x441B96D2), UINT32_C(0x8C83B3DA)},
         {UINT32_C(0x8AA39AB4), UINT32_C(0x3BB2ED8B), UINT32_C(0x9CE53FB2),
          UINT32_C(0x4DB63B23), UINT32_C(0x46DC2104), UINT32_C(0x24AC8A98),
          UINT32_C(0x68E20D1B), UINT32_C(0x997BC4A7)}},
        {{UINT32_C(0xD1C0D629), UINT32_C(0x4CDF8757), UINT32_C(0xA64B6058),
          UINT32_C(0xBA155719), UINT32_C(0xBE3FB0B1), UINT32_C(0x82FD0DA3),
          UINT32_C(0x03E34CB1), UINT32_C(0x12F50694)},
         {UINT32_C(0x02E7DFEB), UINT32_C(0x8993EE38), UINT32_C(0x3D7A758E),
          UINT32_C(0x2FC240C6), UINT32_C(0xAFF7CC7B), UINT32_C(0x75CB6F62),
          UINT32_C(0x71B02A5B), UINT32_C(0x2D73F74D)}},
        {{UINT32_C(0x550ADA69), UINT32_C(0x0B7B920A), UINT32_C(0xD2F1D5C2),
          UINT32_C(0x87D29F08), UINT32_C(0xEEA99A38), UINT32_C(0x6E36EF9C),
          UINT32_C(0x79D7626A), UINT32_C(0x624874C1)},
         {UINT32_C(0x17F026E0), UINT32_C(0x9FCA1B2E), UINT32_C(0xA3A79C2E),
          UINT32_C(0xBDBE18E5), UINT32_C(0x6E1B0C6D), UINT32_C(0x1506DE6A),
          UINT32_C(0xAD2A2C5F), UINT32_C(0x860CCD71)}},
        {{UINT32_C(0x28715EF9), UINT32_C(0x00A15CB0), UINT32_C(0xB1C0ED6D),
          UINT32_C(0x71F337D8), UINT32_C(0xF998251E), UINT32_C(0xBD7E6892),
          UINT32_C(0x08E0A4E9), UINT32_C(0x4C5AB311)},
         {UINT32_C(0x567342FB), UINT32_C(0xDFD51293), UINT32_C(0x5AE3193B),
          UINT32_C(0xF202FCD1), UINT32_C(0xAF59A5A2), UINT32_C(0xE317C933),
          UINT32_C(0x5055DE2A), UINT32_C(0x300FE083)}},
        {{UINT32_C(0xC58E7AE9), UINT32_C(0x279A071A), UINT32_C(0x4C718A8B),
          UINT32_C(0xCED1F2F4), UINT32_C(0x5FE7F6E5), UINT32_C(0x3A8C0D1A),
          UINT32_C(0xBB40DA93), UINT32_C(0x789C9B04)},
         {UINT32_C(0xBF2A0B9B), UINT32_C(0xBB7EA922), UINT32_C(0x3A484413),
          UINT32_C(0x5DD7A04A), UINT32_C(0xC5912F93), UINT32_C(0x3E1F49FB),
          UINT32_C(0x61ECAB05), UINT32_C(0x4D8C07A5)}},
    },
    {
        {{UINT32_C(0x9706D4CF), UINT32_C(0x7D351007), UINT32_C(0xB9BABB1F),
          UINT32_C(0x3E2B3D2E), UINT32_C(0xA2E423EA), UINT32_C(0xC73745BF),
          UINT32_C(0xF59601A0), UINT32_C(0x0AB3940A)},
         {UINT32_C(0x2A895C4F), UINT32_C(0x8881507A), UINT32_C(0x68652263),
          UINT32_C(0xF27F6F40), UINT32_C(0x88A416BE), UINT32_C(0xCFD91814),
          UINT32_C(0x1B4F51F6), UINT32_C(0x13459BC3)}},
        {{UINT32_C(0x01C7C38A), UINT32_C(0x6D830E0C), UINT32_C(0xE27DA48A),
          UINT32_C(0xBA912BD4), UINT32_C(0x4AB8B5A6), UINT32_C(0x3828F433),
          UINT32_C(0xE35E88DA), UINT32_C(0x3F858E6C)},
         {UINT32_C(0x6E1C033C), UINT32_C(0x137F2E3A), UINT32_C(0x7E670398),
          UINT32_C(0xFC7C8953), UINT32_C(0xF5C3D4DB), UINT32_C(0x6FF761CE),
          UINT32_C(0xEED1029B), UINT32_C(0x53A02906)}},
        {{UINT32_C(0x56779C20), UINT32_C(0x5C597BA6), UINT32_C(0x43A87346),
          UINT32_C(0x366688CC), UINT32_C(0xA55ACF91), UINT32_C(0x19F6DA4A),
          UINT32_C(0x182DEC58), UINT32_C(0x280ED592)},
         {UINT32_C(0xA1D3EBDD), UINT32_C(0x0A1F3A7A), UINT32_C(0x0C9F474A),
          UINT32_C(0xD92B6078), UINT32_C(0x19AE00DD), UINT32_C(0x38D0335E),
          UINT32_C(0xA97F33F7), UINT32_C(0x094A5772)}},
        {{UINT32_C(0x312D2694), UINT32_C(0x026A9029), UINT32_C(0xAB5B34B8),
          UINT32_C(0x95408516), UINT32_C(0xDED270EA), UINT32_C(0x9FFA9AB1),
          UINT32_C(0x493E5935), UINT32_C(0x1F9DDC52)},
         {UINT32_C(0x17244394), UINT32_C(0xAC7F94C1), UINT32_C(0x0F28C9DF),
          UINT32_C(0x18FC29C4), UINT32_C(0xBD817BD9), UINT32_C(0xEDE29238),
          UINT32_C(0x8E2A7E40), UINT32_C(0x20DBF9AF)}},
        {{UINT32_C(0x7648CA5C), UINT32_C(0x009365D9), UINT32_C(0x2BF27488),
          UINT32_C(0xB168191E), UINT32_C(0xE3B91112), UINT32_C(0x2481BFAA),
          UINT32_C(0x3D6DB830), UINT32_C(0x744C505B)},
         {UINT32_C(0x3C464704), UINT32_C(0x21426D8F), UINT32_C(0xDAF85A61),
          UINT32_C(0x283F59EF), UINT32_C(0xF2716102), UINT32_C(0x278B5F8E),
          UINT32_C(0x0FE7E7EC), UINT32_C(0x95B80D82)}},
        {{UINT32_C(0xF327664D), UINT32_C(0xD15ADA08), UINT32_C(0xFE904AF8),
          UINT32_C(0xF26E3232), UINT32_C(0xF99471C6), UINT32_C(0x2763DBA6),
          UINT32_C(0x15F30827), UINT32_C(0x4BC97139)},
         {UINT32_C(0x5F154BF9), UINT32_C(0x8523812E), UINT32_C(0xDE17F8F9),
          UINT32_C(0x0839059F), UINT32_C(0xBC16678D), UINT32_C(0xEA151382),
          UINT32_C(0x7890C4EF), UINT32_C(0x68D01E62)}},
        {{UINT32_C(0x9487556B), UINT32_C(0x37FAC9FA), UINT32_C(0xFB4DC83D),
          UINT32_C(0xB4DF5C53), UINT32_C(0x92969151), UINT32_C(0x1EF42D8C),
          UINT32_C(0x8B0ED349), UINT32_C(0x6C0A9D18)},
         {UINT32_C(0x946F31ED), UINT32_C(0x63E91049), UINT32_C(0x653F600B),
          UINT32_C(0x51E91DC6), UINT32_C(0x53A29196), UINT32_C(0xD7A582B1),
          UINT32_C(0x31E1D843), UINT32_C(0x0452F4AD)}},
        {{UINT32_C(0x0DE8E344), UINT32_C(0x1224169D), UINT32_C(0xF329D30F),
          UINT32_C(0x0F4AB4E7), UINT32_C(0xB525B6A4), UINT32_C(0x12662965),
          UINT32_C(0x255F14B8), UINT32_C(0x3142B612)},
         {UINT32_C(0xBBF468A1), UINT32_C(0xEF6148B9), UINT32_C(0x144F8DFF),
          UINT32_C(0x3FC413B4), UINT32_C(0x9BF55B34), UINT32_C(0xA453D075),
          UINT32_C(0x86EBA319), UINT32_C(0x857EC763)}},
        {{UINT32_C(0xC16C1002), UINT32_C(0x7FC22E26), UINT32_C(0xB0B186C3),
          UINT32_C(0x2E34975E), UINT32_C(0x2FC79F85), UINT32_C(0xE11E3642),
          UINT32_C(0x9F981B5F), UINT32_C(0x30FE5C0E)},
         {UINT32_C(0x31816247), UINT32_C(0x73BD0FA6), UINT32_C(0x6906AF0A),
          UINT32_C(0x40FE1661), UINT32_C(0x787BC7EE), UINT32_C(0x8D7109A3),
          UINT32_C(0x6FB9A590), UINT32_C(0x29452054)}},
        {{UINT32_C(0x4DFAAF93), UINT32_C(0x24654B9B), UINT32_C(0x9A450D29),
          UINT32_C(0x91CDEA8B), UINT32_C(0xE4874748), UINT32_C(0xEE55420B),
          UINT32_C(0x6D03064C), UINT32_C(0x01FAC14C)},
         {UINT32_C(0xD93BD5BE), UINT32_C(0x8A4EBDE2), UINT32_C(0x49EF18A9),
          UINT32_C(0xCB2DF307), UINT32_C(0x1A7B7F36), UINT32_C(0x36E6AC64),
          UINT32_C(0x4AC1CB8D), UINT32_C(0x30195423)}},
        {{UINT32_C(0x34F5B3FF), UINT32_C(0xD9970B1E), UINT32_C(0x587A9C5C),
          UINT32_C(0x3CFEFC50), UINT32_C(0x7CCE631E), UINT32_C(0x8EC1C5DE),
          UINT32_C(0x52465AB8), UINT32_C(0x92C93E2B)},
         {UINT32_C(0x257017CA), UINT32_C(0x0104DF30), UINT32_C(0x8D8DB4CE),
          UINT32_C(0xF4E5E779), UINT32_C(0xFDC267F0), UINT32_C(0xE12A39DD),
          UINT32_C(0x27C73FDA), UINT32_C(0x683DEAFE)}},
        {{UINT32_C(0xBBC70623), UINT32_C(0xD0840E81), UINT32_C(0x4D23568E),
          UINT32_C(0x03A93C16), UINT32_C(0x11A71BFF), UINT32_C(0xC52FF3D6),
          UINT32_C(0x0875248E), UINT32_C(0x03C11FCE)},
         {UINT32_C(0x6C4AE445), UINT32_C(0xBC6F184B), UINT32_C(0x7698EE98),
          UINT32_C(0xF52CC71F), UINT32_C(0xEEA25223), UINT32_C(0x4663193E),
          UINT32_C(0x031C68DC), UINT32_C(0x86CD1AB3)}},
        {{UINT32_C(0x21E04C02), UINT32_C(0x221C94EB), UINT32_C(0x7B980F70),
          UINT32_C(0xE96BB7B3), UINT32_C(0x24DC2BD1), UINT32_C(0x60A72897),
          UINT32_C(0x5621F475), UINT32_C(0x8C8E019F)},
         {UINT32_C(0x5CFA457A), UINT32_C(0xAE47B2F7), UINT32_C(0xF395C533),
          UINT32_C(0x31B2F9E1), UINT32_C(0x82E75849), UINT32_C(0x7EEB5DDC),
          UINT32_C(0x2A241E52), UINT32_C(0x4863A6A3)}},
        {{UINT32_C(0x914976EF), UINT32_C(0x806AC7F4), UINT32_C(0xCA42B875),
          UINT32_C(0x5019261E), UINT32_C(0x6EF2D82F), UINT32_C(0x44F5C03D),
          UINT32_C(0x690F2ACA), UINT32_C(0x24959F00)},
         {UINT32_C(0x81F0BBB6), UINT32_C(0x4BDE2115), UINT32_C(0x1F701A2D),
          UINT32_C(0x01EB2C00), UINT32_C(0x274FB05C), UINT32_C(0x039F8910),
          UINT32_C(0xC625EBCD), UINT32_C(0x57068F24)}},
        {{UINT32_C(0x67FF2575), UINT32_C(0xB21B8C93), UINT32_C(0x0C60B449),
          UINT32_C(0xC7826C60), UINT32_C(0xA98671BB), UINT32_C(0xD4D69A9F),
          UINT32_C(0xF5A2AB0C), UINT32_C(0x95249276)},
         {UINT32_C(0x2D1976DA), UINT32_C(0x8F7007F0), UINT32_C(0xC011D54C),
          UINT32_C(0x846F2A92), UINT32_C(0xFA2076B1), UINT32_C(0xFDBF81DF),
          UINT32_C(0x5583B46C), UINT32_C(0x3349224F)}},
        {{UINT32_C(0x7C854B4A), UINT32_C(0x62496746), UINT32_C(0x798B1395),
          UINT32_C(0xF92BAE1D), UINT32_C(0xD2F65638), UINT32_C(0x2EBE18E3),
          UINT32_C(0x8A068F49), UINT32_C(0x472FF6E5)},
         {UINT32_C(0xDA2030C2), UINT32_C(0x64BB0F33), UINT32_C(0x66F6C000),
          UINT32_C(0x72C0D0C9), UINT32_C(0x3194615E), UINT32_C(0xEA837EE5),
          UINT32_C(0xFA9A7903), UINT32_C(0x1B7B4849)}},
    },
    {
        {{UINT32_C(0xCF9A0727), UINT32_C(0x27AB780C), UINT32_C(0x9D7486CB),
          UINT32_C(0xD457A7BC), UINT32_C(0xFE9F1A59), UINT32_C(0xFC57C335),
          UINT32_C(0xD1D9F161), UINT32_C(0x269D8959)},
         {UINT32_C(0xB81605D5), UINT32_C(0x06A32331), UINT32_C(0x6F050BE0),
          UINT32_C(0x23696353), UINT32_C(0x413E1C0D), UINT32_C(0xF9350879),
          UINT32_C(0x5761A8DF), UINT32_C(0x17019548)}},
        {{UINT32_C(0x6765C6A2), UINT32_C(0x583D3D3F), UINT32_C(0xBE9DF3AF),
          UINT32_C(0x68BBA6F9), UINT32_C(0x85358B53), UINT32_C(0x7011E594),
          UINT32_C(0x53A08874), UINT32_C(0x3B2142E3)},
         {UINT32_C(0x6F5C8641), UINT32_C(0x4AB6137E), UINT32_C(0x4FE9BCEB),
          UINT32_C(0x4955890E), UINT32_C(0x4D14DA01), UINT32_C(0xE2F732BA),
          UINT32_C(0xBEBD63D4), UINT32_C(0x8CB285FC)}},
        {{UINT32_C(0x6C74A0AA), UINT32_C(0x5099551B), UINT32_C(0xBC2C8A61),
          UINT32_C(0xF04EB8F8), UINT32_C(0x85983435), UINT32_C(0xE169F492),
          UINT32_C(0x5B808C9E), UINT32_C(0x764062A1)},
         {UINT32_C(0x65B994FB), UINT32_C(0x8C59A43F), UINT32_C(0x6068E685),
          UINT32_C(0x2FB148B7), UINT32_C(0x54108A9F), UINT32_C(0x899D4FC5),
          UINT32_C(0x5B4D40FE), UINT32_C(0x0469EA3E)}},
        {{UINT32_C(0x62A76AA8), UINT32_C(0x15B613EA), UINT32_C(0x2FE2F179),
          UINT32_C(0x7E8E7D56), UINT32_C(0xBE98EDC2), UINT32_C(0x53160F65),
          UINT32_C(0x9810DC27), UINT32_C(0x258DA04E)},
         {UINT32_C(0x030D9C31), UINT32_C(0x4FEE19D0), UINT32_C(0xC29E300F),
          UINT32_C(0xFC2C57F8), UINT32_C(0xC44458AE), UINT32_C(0x00071F97),
          UINT32_C(0x709727E1), UINT32_C(0x0AA2B911)}},
        {{UINT32_C(0xA61166F8), UINT32_C(0x443F8B23), UINT32_C(0xD685FCF1),
          UINT32_C(0x3E8F6278), UINT32_C(0x447433C6), UINT32_C(0xC930C1D1),
          UINT32_C(0xAED7D6EB), UINT32_C(0x1245A867)},
         {UINT32_C(0xFA89945A), UINT32_C(0xC35986DD), UINT32_C(0x26B0AFEE),
          UINT32_C(0x89CE1109), UINT32_C(0x17103D18), UINT32_C(0x9C6A87CD),
          UINT32_C(0xCE338978), UINT32_C(0x811B2242)}},
        {{UINT32_C(0x0C293255), UINT32_C(0xC074AF66), UINT32_C(0x5AEAC2E1),
          UINT32_C(0x982C23A9), UINT32_C(0xD39AC56C), UINT32_C(0xDB14DE0C),
          UINT32_C(0x47EBB839), UINT32_C(0x20263F3F)},
         {UINT32_C(0xD10588DF), UINT32_C(0x183EA578), UINT32_C(0x1EB69C36),
          UINT32_C(0xB4D88EFB), UINT32_C(0xDBF3BEE7), UINT32_C(0xA79A1B4D),
          UINT32_C(0xE8159E0D), UINT32_C(0x650FC466)}},
        {{UINT32_C(0xF80D5744), UINT32_C(0x9E6EE797), UINT32_C(0x825949BD),
          UINT32_C(0xDFC3EBF5), UINT32_C(0x7EC9BD65), UINT32_C(0x1083EC79),
          UINT32_C(0xB753499C), UINT32_C(0x62A45C5E)},
         {UINT32_C(0x2B6F42CF), UINT32_C(0x9C135F80), UINT32_C(0xC4B49041),
          UINT32_C(0xE39B0BA5), UINT32_C(0x8D3B2D06), UINT32_C(0x4D838513),
          UINT32_C(0xD070754B), UINT32_C(0x696034DC)}},
        {{UINT32_C(0xB8E3BDD1), UINT32_C(0x06313D73), UINT32_C(0xE6968872),
          UINT32_C(0xC7BEC420), UINT32_C(0x3A04B7F0), UINT32_C(0x740DD6D3),
          UINT32_C(0x2465BED2), UINT32_C(0x98F2D0B7)},
         {UINT32_C(0x4043DBAD), UINT32_C(0x9F298460), UINT32_C(0x01B5961F),
          UINT32_C(0x82D6991A), UINT32_C(0x54DFAB8A), UINT32_C(0xAAE7DF9D),
          UINT32_C(0x1A07DD22), UINT32_C(0x5701E335)}},
        {{UINT32_C(0xFCA398A2), UINT32_C(0x5695A08E), UINT32_C(0x0D76E8CF),
          UINT32_C(0xD29EBC1F), UINT32_C(0x24004EDB), UINT32_C(0x5AB17ABF),
          UINT32_C(0x0CC7A144), UINT32_C(0x20C7761B)},
         {UINT32_C(0x285EA93C), UINT32_C(0x6CAEE036), UINT32_C(0xF2B8BF23),
          UINT32_C(0xF9756E89), UINT32_C(0xB1AB91B7), UINT32_C(0x3CEA1C76),
          UINT32_C(0x3FB4F3B8), UINT32_C(0x5D86860E)}},
        {{UINT32_C(0xFDC7DBC5), UINT32_C(0x835B023B), UINT32_C(0xEEEDFD73),
          UINT32_C(0xF05C0676), UINT32_C(0xE52BFB27), UINT32_C(0xF8325D64),
          UINT32_C(0xB5032CFF), UINT32_C(0x919D008D)},
         {UINT32_C(0x4B130537), UINT32_C(0xEF27862C), UINT32_C(0x5CE404DC),
          UINT32_C(0x616DF154), UINT32_C(0x451ED033), UINT32_C(0x182BA57E),
          UINT32_C(0xBD01F864), UINT32_C(0x2EFEC0C7)}},
        {{UINT32_C(0x45F3AF3C), UINT32_C(0xDC846845), UINT32_C(0x92A47B31),
          UINT32_C(0x2D2BA0CD), UINT32_C(0xE1AFE6EE), UINT32_C(0x9C806C7D),
          UINT32_C(0x4C6A4FEA), UINT32_C(0x28FE43FF)},
         {UINT32_C(0x6C76C0F4), UINT32_C(0x2E028CD1), UINT32_C(0x2AEFBDDA),
          UINT32_C(0xC6FA5AD1), UINT32_C(0xF63F1A35), UINT32_C(0xC8B5339B),
          UINT32_C(0x04523F02), UINT32_C(0x30C780A7)}},
        {{UINT32_C(0xD7E4F0CE), UINT32_C(0x3D2DCA55), UINT32_C(0x26616811),
          UINT32_C(0x8EEF9189), UINT32_C(0x3C0E5892), UINT32_C(0xB106642F),
          UINT32_C(0x89DB033E), UINT32_C(0x4A965385)},
         {UINT32_C(0xB3C2DD37), UINT32_C(0x5A1CBEB6), UINT32_C(0x156EAC75),
          UINT32_C(0x5290C737), UINT32_C(0xE32E40C7), UINT32_C(0x57AFD98A),
          UINT32_C(0xB3571868), UINT32_C(0x04A16164)}},
        {{UINT32_C(0x1A673E1B), UINT32_C(0x9AB8A3E9), UINT32_C(0x0FC23483),
          UINT32_C(0xC707ABBA), UINT32_C(0x9E0EA0BD), UINT32_C(0x936C1783),
          UINT32_C(0xF71F6F1D), UINT32_C(0x1E4C2E7C)},
         {UINT32_C(0x6FB0926C), UINT32_C(0x37904F63), UINT32_C(0xC51FEEA5),
          UINT32_C(0x9EC76DF7), UINT32_C(0x4D103DAC), UINT32_C(0x2C60F7D6),
          UINT32_C(0xF9DC2CC6), UINT32_C(0x7B451E0B)}},
        {{UINT32_C(0xB2A5F07F), UINT32_C(0xD4F8526C), UINT32_C(0xB0F4AE09),
          UINT32_C(0x41303D42), UINT32_C(0x0C182FDC), UINT32_C(0xAC79523F),
          UINT32_C(0xAA0C5D6D), UINT32_C(0x8D6A75C8)},
         {UINT32_C(0x3CDCE3F0), UINT32_C(0x4DD7FC95), UINT32_C(0x5BE6DA0F),
          UINT32_C(0x4DDB3910), UINT32_C(0x16F7E27D), UINT32_C(0xE34961F9),
          UINT32_C(0x5B3544EB), UINT32_C(0x0C5CB76F)}},
        {{UINT32_C(0x252C354C), UINT32_C(0x324C95B5), UINT32_C(0x8CC2C3BC),
          UINT32_C(0x4648D87E), UINT32_C(0x82BC8C80), UINT32_C(0x6DDFDECD),
          UINT32_C(0xC069996E), UINT32_C(0x8C64CADE)},
         {UINT32_C(0x40ED44AB), UINT32_C(0x4E282E96), UINT32_C(0x79334507),
          UINT32_C(0x70A12067), UINT32_C(0x5AB8902B), UINT32_C(0x65CE5D38),
          UINT32_C(0x7C949D96), UINT32_C(0x56FE68F2)}},
        {{UINT32_C(0xCF9530AE), UINT32_C(0x1D55C87E), UINT32_C(0xC147C2D5),
          UINT32_C(0xD1CF73FF), UINT32_C(0xC1F44403), UINT32_C(0x826031CD),
          UINT32_C(0x5EEF5BFB), UINT32_C(0x3A06528F)},
         {UINT32_C(0x5F84A7B1), UINT32_C(0xF220EAF3), UINT32_C(0x350EBADE),
          UINT32_C(0xBC99C905), UINT32_C(0x810A101C), UINT32_C(0x686A706E),
          UINT32_C(0x1D92EAEA), UINT32_C(0x95E52713)}},
    },
    {
        {{UINT32_C(0x514D47C2), UINT32_C(0xAAC634B3), UINT32_C(0x58B83B33),
          UINT32_C(0xD0C189B8), UINT32_C(0x58CA9A2F), UINT32_C(0x633D59E3),
          UINT32_C(0x838ACC80), UINT32_C(0x65965CE0)},
         {UINT32_C(0x9B512F6E), UINT32_C(0xBB03F7EA), UINT32_C(0x9EF17A82),
          UINT32_C(0xB2F38B84), UINT32_C(0xE16A7A95), UINT32_C(0xE8382E37),
          UINT32_C(0x4D9EF607), UINT32_C(0x28644EFE)}},
        {{UINT32_C(0x040A515B), UINT32_C(0x46F9115E), UINT32_C(0xFA59CD3E),
          UINT32_C(0x4C7DBCFF), UINT32_C(0x71BB543E), UINT32_C(0xB4CE22B8),
          UINT32_C(0x948F80BA), UINT32_C(0x58D935D8)},
         {UINT32_C(0x03683C8B), UINT32_C(0x33DC1D5B), UINT32_C(0x2D071D87),
          UINT32_C(0x25E6113A), UINT32_C(0xA7D59351), UINT32_C(0x44F962F8),
          UINT32_C(0xBCF66B43), UINT32_C(0x6B818DDB)}},
        {{UINT32_C(0x378C1098), UINT32_C(0x363A63C7), UINT32_C(0xAC5C0C9E),
          UINT32_C(0xBEB2A7B6), UINT32_C(0x4361C8D4), UINT32_C(0x3F620D3F),
          UINT32_C(0x4E3D9686), UINT32_C(0x68EAD01A)},
         {UINT32_C(0x45DB7208), UINT32_C(0x43613085), UINT32_C(0x13B35D33),
          UINT32_C(0x865A6DDE), UINT32_C(0x68DF09F5), UINT32_C(0x4EAA1663),
          UINT32_C(0xBF02AA12), UINT32_C(0x5FDCA83F)}},
        {{UINT32_C(0xBFEFB3CB), UINT32_C(0xC240FEAA), UINT32_C(0x0EC6694F),
          UINT32_C(0x78E757D2), UINT32_C(0x2413D6A2), UINT32_C(0xA11A82DF),
          UINT32_C(0xDBB7A220), UINT32_C(0x7BD656EE)},
         {UINT32_C(0x6EB899A4), UINT32_C(0x68C60873), UINT32_C(0x318C72E8),
          UINT32_C(0xAFFB9F1C), UINT32_C(0x9FB7619D), UINT32_C(0xF16A443C),
          UINT32_C(0x42C6E4D6), UINT32_C(0x2FC317E3)}},
        {{UINT32_C(0x73F57A93), UINT32_C(0xAB56A873), UINT32_C(0x308F5224),
          UINT32_C(0xE9BA24E2), UINT32_C(0x11992077), UINT32_C(0x010281B9),
          UINT32_C(0x593EAD1A), UINT32_C(0x2CBCA7FE)},
         {UINT32_C(0x2A1D8318), UINT32_C(0xB400388A), UINT32_C(0x3C61A0AF),
          UINT32_C(0xD470ABDA), UINT32_C(0x94BD2FAC), UINT32_C(0xF9102721),
          UINT32_C(0x0FAC703C), UINT32_C(0x222365D1)}},
        {{UINT32_C(0x9C2D1B2B), UINT32_C(0x5C9021C4), UINT32_C(0xCAF0B562),
          UINT32_C(0xB349DB18), UINT32_C(0x91412CC3), UINT32_C(0x6DAF7412),
          UINT32_C(0xCF6584D3), UINT32_C(0x44E5E3E5)},
         {UINT32_C(0xE4C17B19), UINT32_C(0x1D1F4244), UINT32_C(0x3787A38A),
          UINT32_C(0x4C663EE6), UINT32_C(0x313A8581), UINT32_C(0xA3261E22),
          UINT32_C(0x7A82C05A), UINT32_C(0x3AE1E1DB)}},
        {{UINT32_C(0x3CD6A155), UINT32_C(0x31AA2B29), UINT32_C(0x3D078B12),
          UINT32_C(0x0EB9527E), UINT32_C(0x214FF1E2), UINT32_C(0x6785ABA2),
          UINT32_C(0xF111D572), UINT32_C(0x74974F84)},
         {UINT32_C(0x078C684B), UINT32_C(0x2199A753), UINT32_C(0x4B13A004),
          UINT32_C(0xA0F1DE23), UINT32_C(0x75BEBCBC), UINT32_C(0x3965AE19),
          UINT32_C(0x24562AA7), UINT32_C(0x22A8D7EE)}},
        {{UINT32_C(0xBF268ADE), UINT32_C(0x0591965F), UINT32_C(0x9EE48F0E),
          UINT32_C(0xF621B364), UINT32_C(0x5A3A3848), UINT32_C(0x0AD981A9),
          UINT32_C(0x9ECD72B7), UINT32_C(0x1316675C)},
         {UINT32_C(0xF37C87E0), UINT32_C(0x21A5CEB7), UINT32_C(0x68D1AAFB),
          UINT32_C(0xEF864CF3), UINT32_C(0xD3C9A54F), UINT32_C(0x5F340413),
          UINT32_C(0xE00FD564), UINT32_C(0x0C5DE1E6)}},
        {{UINT32_C(0xB415D72C), UINT32_C(0x439B2C0C), UINT32_C(0x63442E62),
          UINT32_C(0x106AE2E0), UINT32_C(0x4A79E93B), UINT32_C(0x8A9428C6),
          UINT32_C(0xCC2DF510), UINT32_C(0x67FE6D6E)},
         {UINT32_C(0x655013B3), UINT32_C(0x407158BC), UINT32_C(0x2BC7E7CC),
          UINT32_C(0x3AAEAC1C), UINT32_C(0xEE8EC1F4), UINT32_C(0x399DB6EF),
          UINT32_C(0xECFF6657), UINT32_C(0x1F7D0D17)}},
        {{UINT32_C(0xCB86639E), UINT32_C(0x03039D18), UINT32_C(0x9CDC3408),
          UINT32_C(0x58603909), UINT32_C(0xF1804B9E), UINT32_C(0x52421109),
          UINT32_C(0xED126B9F), UINT32_C(0x95502857)},
         {UINT32_C(0x451B0539), UINT32_C(0xC91842D9), UINT32_C(0xE60AAE3B),
          UINT32_C(0x2B5B11EB), UINT32_C(0x44CB5A14), UINT32_C(0xDB50F9EA),
          UINT32_C(0x89E80A6E), UINT32_C(0x4B5C9824)}},
        {{UINT32_C(0x69FC9F1A), UINT32_C(0x8EF3A1E5), UINT32_C(0x7CCA576A),
          UINT32_C(0xA4EAB6F4), UINT32_C(0xFBF1CD65), UINT32_C(0x955E1C89),
          UINT32_C(0xF8CE13DB), UINT32_C(0x3E3ACF6E)},
         {UINT32_C(0x58F31FC9), UINT32_C(0x1FDB6190), UINT32_C(0x93B0D0D5),
          UINT32_C(0x10DB71B3), UINT32_C(0x9154B285), UINT32_C(0x90096143),
          UINT32_C(0x1C49EFF3), UINT32_C(0x37EEE178)}},
        {{UINT32_C(0xBC198066), UINT32_C(0x609DE502), UINT32_C(0x40722EF6),
          UINT32_C(0x075C8631), UINT32_C(0xFF0FA57D), UINT32_C(0x121ACC9F),
          UINT32_C(0xEC7DB1A0), UINT32_C(0x31E79AC5)},
         {UINT32_C(0xF16FAE79), UINT32_C(0x736EB95D), UINT32_C(0x815A14CB),
          UINT32_C(0xFF963917), UINT32_C(0x23AF0BC3), UINT32_C(0xC6003E5D),
          UINT32_C(0x99AFCAAA), UINT32_C(0x0D1B0350)}},
        {{UINT32_C(0x1F0DF59D), UINT32_C(0x8A1B6C97), UINT32_C(0x59C9CA8D),
          UINT32_C(0x7DF81A72), UINT32_C(0x9602E8BE), UINT32_C(0x74257F8E),
          UINT32_C(0xA441657A), UINT32_C(0x2FFBAD39)},
         {UINT32_C(0x048050A6), UINT32_C(0xB1B090DB), UINT32_C(0x741E7392),
          UINT32_C(0xD6144221), UINT32_C(0xECA1E2D6), UINT32_C(0x63826973),
          UINT32_C(0xD287DE2F), UINT32_C(0x28EE60B8)}},
        {{UINT32_C(0x5DEE86CE), UINT32_C(0x81504295), UINT32_C(0x73C03937),
          UINT32_C(0xFACCB61D), UINT32_C(0x299B96AF), UINT32_C(0x9898F773),
          UINT32_C(0x488F95CD), UINT32_C(0x51552297)},
         {UINT32_C(0x54F5E182), UINT32_C(0x6170618C), UINT32_C(0xC2798401),
          UINT32_C(0x9C11D666), UINT32_C(0x3EAF3DDE), UINT32_C(0x88225F4B),
          UINT32_C(0x087F1185), UINT32_C(0x20841538)}},
        {{UINT32_C(0x14FA59EC), UINT32_C(0x42BCEFFE), UINT32_C(0x7D023F1E),
          UINT32_C(0xC41CFCDA), UINT32_C(0x7163E802), UINT32_C(0xD7E4FDE7),
          UINT32_C(0x2E145BCE), UINT32_C(0x54F4C798)},
         {UINT32_C(0xF9162235), UINT32_C(0xE4EA68C9), UINT32_C(0x458DEC24),
          UINT32_C(0x4F7EAC6F), UINT32_C(0x845C6AD1), UINT32_C(0x70100D2D),
          UINT32_C(0xF1EA21B2), UINT32_C(0x67AC34CF)}},
        {{UINT32_C(0xAC21C728), UINT32_C(0x2BD49BDF), UINT32_C(0xEDA966DF),
          UINT32_C(0x2D009B45), UINT32_C(0x4A9B9167), UINT32_C(0x0D4476BE),
          UINT32_C(0x95D2ACD2), UINT32_C(0x340BD3BE)},
         {UINT32_C(0xB040FF50), UINT32_C(0xF8BACA2D), UINT32_C(0xB91D47C1),
          UINT32_C(0x307BEA0D), UINT32_C(0xB6B3A1E4), UINT32_C(0x2EFDC81B),
          UINT32_C(0x1595D6E2), UINT32_C(0x3B2CD7D9)}},
    },
    {
        {{UINT32_C(0x32A5A002), UINT32_C(0x56254AE7), UINT32_C(0x448B0A9F),
          UINT32_C(0xE48A475C), UINT32_C(0x14EDBBA9), UINT32_C(0x3B2DF6DF),
          UINT32_C(0xF5E4CC81), UINT32_C(0x911BE369)},
         {UINT32_C(0x77CBB387), UINT32_C(0x57D065C6), UINT32_C(0x527575FD),
          UINT32_C(0x7C1E0142), UINT32_C(0x243B5C33), UINT32_C(0x2CA91EEF),
          UINT32_C(0x5C4700CC), UINT32_C(0x7E54AF42)}},
        {{UINT32_C(0x5EEDF97F), UINT32_C(0xEF5ECAE5), UINT32_C(0xC0D821AC),
          UINT32_C(0x2D79312A), UINT32_C(0xA9EDBE8F), UINT32_C(0xD3817042),
          UINT32_C(0xAD924B1D), UINT32_C(0x7A3D537E)},
         {UINT32_C(0xB26FFC3B), UINT32_C(0xD9923A20), UINT32_C(0x5B81EC12),
          UINT32_C(0x651D2201), UINT32_C(0x54C37FF0), UINT32_C(0xBDF7205A),
          UINT32_C(0x8C0D2E79), UINT32_C(0x5562D258)}},
        {{UINT32_C(0xFB4842F8), UINT32_C(0xE5BC2E1C), UINT32_C(0x25B464C8),
          UINT32_C(0xCFE97824), UINT32_C(0x2FEA9ED3), UINT32_C(0xD902A11A),
          UINT32_C(0x8D3DD0A4), UINT32_C(0x2FC360ED)},
         {UINT32_C(0x9E5F7AE1), UINT32_C(0xEC4E57FC), UINT32_C(0x79B8AF6C),
          UINT32_C(0xF0F1FD9F), UINT32_C(0xA9A283D0), UINT32_C(0x803F3ED6),
          UINT32_C(0xADEEA78E), UINT32_C(0x5F13000F)}},
        {{UINT32_C(0x1838B470), UINT32_C(0x3EBBBD16), UINT32_C(0xB2781680),
          UINT32_C(0x934BA22A), UINT32_C(0xC7210CD4), UINT32_C(0xC9ED04FC),
          UINT32_C(0x4615F186), UINT32_C(0x716004A1)},
         {UINT32_C(0xE894BBC3), UINT32_C(0xE7B36C21), UINT32_C(0x570AA9A8),
          UINT32_C(0x3F739857), UINT32_C(0x3063902B), UINT32_C(0x1707FBEE),
          UINT32_C(0x155C9824), UINT32_C(0x44FCB774)}},
        {{UINT32_C(0xCDD8CEDB), UINT32_C(0x30ECD772), UINT32_C(0xCA09BCD3),
          UINT32_C(0x67BB36FD), UINT32_C(0x9BC43B7B), UINT32_C(0xD5AD0FAA),
          UINT32_C(0x6A130895), UINT32_C(0x3962E556)},
         {UINT32_C(0x7F7A565A), UINT32_C(0x57928253), UINT32_C(0x55B911EE),
          UINT32_C(0xDE9D7792), UINT32_C(0x6984F326), UINT32_C(0xD5DBFDDE),
          UINT32_C(0x9FB51246), UINT32_C(0x7CDF5E15)}},
        {{UINT32_C(0x89D24763), UINT32_C(0xD7FC427A), UINT32_C(0xAD874362),
          UINT32_C(0x50E627C9), UINT32_C(0x2069873A), UINT32_C(0x17A8F83B),
          UINT32_C(0xDB698BD1), UINT32_C(0x186952D7)},
         {UINT32_C(0x38A2822C), UINT32_C(0x6C007EED), UINT32_C(0x0C207073),
          UINT32_C(0x5F187091), UINT32_C(0x08D245D2), UINT32_C(0xD0023B63),
          UINT32_C(0x34544316), UINT32_C(0x7A32C2A1)}},
        {{UINT32_C(0x8C2635EC), UINT32_C(0x8B99183A), UINT32_C(0x6F12B137),
          UINT32_C(0xA00A9476), UINT32_C(0x823DA313), UINT32_C(0x9B5E2F57),
          UINT32_C(0x47B3CEB1), UINT32_C(0x0F7CB4AF)},
         {UINT32_C(0x67266D24), UINT32_C(0xC993AF7E), UINT32_C(0xEBA985B8),
          UINT32_C(0x8B60295E), UINT32_C(0xE41A6F69), UINT32_C(0x9AA596CB),
          UINT32_C(0x4B68507A), UINT32_C(0x4D6CF5DF)}},
        {{UINT32_C(0x6921DEFE), UINT32_C(0x3B8A3CBC), UINT32_C(0x0ED7B717),
          UINT32_C(0xB96D5390), UINT32_C(0x7DE65E54), UINT32_C(0x6761E86A),
          UINT32_C(0x701CC1E4), UINT32_C(0x964460D6)},
         {UINT32_C(0x26C82309), UINT32_C(0x5C0A2213), UINT32_C(0x20328C60),
          UINT32_C(0xF95F5472), UINT32_C(0xFB49E3B5), UINT32_C(0xB519B476),
          UINT32_C(0xEE373756), UINT32_C(0x089D0AB6)}},
        {{UINT32_C(0xDC952768), UINT32_C(0x947DFCF0), UINT32_C(0x3AB613AA),
          UINT32_C(0xD8B5C61C), UINT32_C(0x9A457DA4), UINT32_C(0x146E8325),
          UINT32_C(0xF476945E), UINT32_C(0x37E2F6D3)},
         {UINT32_C(0x3851A6F6), UINT32_C(0x5702A441), UINT32_C(0x8D67EF9C),
          UINT32_C(0xB476560E), UINT32_C(0xF9D2AD96), UINT32_C(0xABA23F67),
          UINT32_C(0xDFBBB806), UINT32_C(0x3CE30A4E)}},
        {{UINT32_C(0xE5BAA662), UINT32_C(0x64695640), UINT32_C(0x0AAF3988),
          UINT32_C(0x2A18979A), UINT32_C(0xDE0ED212), UINT32_C(0x605578FF),
          UINT32_C(0x30F2C13C), UINT32_C(0x52E604D5)},
         {UINT32_C(0x894AB3B9), UINT32_C(0x2E9E2D83), UINT32_C(0x4BC33041),
          UINT32_C(0x098B1FAA), UINT32_C(0x0863AA3C), UINT32_C(0x01CF6606),
          UINT32_C(0xD2951A60), UINT32_C(0x7334879B)}},
        {{UINT32_C(0xC51704F1), UINT32_C(0xB080105C), UINT32_C(0xEAEE29C4),
          UINT32_C(0x1A5869B8), UINT32_C(0x5FDD2FD3), UINT32_C(0xAD6AEF33),
          UINT32_C(0x49C2B183), UINT32_C(0x83E677C4)},
         {UINT32_C(0xDFA8B8F4), UINT32_C(0x757A4EFD), UINT32_C(0xE42F2C87),
          UINT32_C(0xFC8E7650), UINT32_C(0x9C963D98), UINT32_C(0xD4A61A3E),
          UINT32_C(0x45BC9044), UINT32_C(0x3750289A)}},
        {{UINT32_C(0x40B1C72C), UINT32_C(0x40A0620E), UINT32_C(0xB2E44573),
          UINT32_C(0xAEE56EC7), UINT32_C(0x60532553), UINT32_C(0xE4E6EA3D),
          UINT32_C(0xA0EB6014), UINT32_C(0x5BA50E80)},
         {UINT32_C(0x4378CC2F), UINT32_C(0x84642978), UINT32_C(0x2A1C5FB4),
          UINT32_C(0xE322D169), UINT32_C(0x6B91F82D), UINT32_C(0x5000C9B1),
          UINT32_C(0x7AA49F2D), UINT32_C(0x32380CB8)}},
        {{UINT32_C(0xE18C4BD2), UINT32_C(0x0A2F936A), UINT32_C(0xC3DB9AA5),
          UINT32_C(0x7AEA56AA), UINT32_C(0x5DDF30CB), UINT32_C(0x3A984E93),
          UINT32_C(0x904181C6), UINT32_C(0x36133D20)},
         {UINT32_C(0xF62DFBF5), UINT32_C(0xA9A65593), UINT32_C(0x6808B883),
          UINT32_C(0xB4AC06FD), UINT32_C(0x7A2FEDBB), UINT32_C(0x98679704),
          UINT32_C(0x97880A72), UINT32_C(0x20E9E8E1)}},
        {{UINT32_C(0xCEB26FAE), UINT32_C(0x403A1ED1), UINT32_C(0x3CD622C9),
          UINT32_C(0xAD13CD87), UINT32_C(0xCF45C32D), UINT32_C(0xC1E03929),
          UINT32_C(0xC3BE1A53), UINT32_C(0x4B50E4A9)},
         {UINT32_C(0xD0D7AFE3), UINT32_C(0xCF10F3AF), UINT32_C(0x1494A9B4),
          UINT32_C(0x6A29B173), UINT32_C(0xD13B0495), UINT32_C(0xB9DC9849),
          UINT32_C(0x9C05B110), UINT32_C(0x4C50794E)}},
        {{UINT32_C(0x1427F71D), UINT32_C(0xC3C97DED), UINT32_C(0x966ECF33),
          UINT32_C(0xC3CFB754), UINT32_C(0x1FBF30CD), UINT32_C(0x48E30FE1),
          UINT32_C(0x1E4B0998), UINT32_C(0x71C96E1C)},
         {UINT32_C(0xB92C4BF7), UINT32_C(0x878D6305), UINT32_C(0xCCB5E4A1),
          UINT32_C(0x14477130), UINT32_C(0xE3C00A19), UINT32_C(0x7C210767),
          UINT32_C(0xAB3CDBF0), UINT32_C(0x5546DBD5)}},
        {{UINT32_C(0x70857571), UINT32_C(0xADEC8758), UINT32_C(0xE70D07EC),
          UINT32_C(0x0A52587C), UINT32_C(0xC731B9BC), UINT32_C(0xE6CEAF9E),
          UINT32_C(0x47143479), UINT32_C(0x1D0FDE3F)},
         {UINT32_C(0xC5B410CB), UINT32_C(0x2F3BE2CF), UINT32_C(0x4E64FD9B),
          UINT32_C(0x576004BE), UINT32_C(0x7629820C), UINT32_C(0x03F33951),
          UINT32_C(0x46A450E2), UINT32_C(0x7BD32964)}},
    },
    {
        {{UINT32_C(0x46CED42D), UINT32_C(0xD492D6B7), UINT32_C(0x1F0092E3),
          UINT32_C(0xC068D02D), UINT32_C(0x8D8A822A), UINT32_C(0x008ECBAD),
          UINT32_C(0x71045647), UINT32_C(0x6B326869)},
         {UINT32_C(0x523CBA58), UINT32_C(0xFEE3237F), UINT32_C(0x9C29059F),
          UINT32_C(0x077B7F50), UINT32_C(0xE72FBE6F), UINT32_C(0x42C308B3),
          UINT32_C(0x8E34148B), UINT32_C(0x3DD79D83)}},
        {{UINT32_C(0xCAC24455), UINT32_C(0x3ED9DF47), UINT32_C(0xD8546306),
          UINT32_C(0x7C8A7B31), UINT32_C(0x2AA02202), UINT32_C(0x4CC43295),
          UINT32_C(0x8598E028), UINT32_C(0x5E8B4EA3)},
         {UINT32_C(0x812B8070), UINT32_C(0x8A882F3F), UINT32_C(0x1DD374C0),
          UINT32_C(0x984BE588), UINT32_C(0x16E133CF), UINT32_C(0x6FDA8159),
          UINT32_C(0x899920D0), UINT32_C(0x34FB92FA)}},
        {{UINT32_C(0xDA0B8D0E), UINT32_C(0x3BE0416F), UINT32_C(0x88C053D0),
          UINT32_C(0x2CC846DB), UINT32_C(0xB1A3A621), UINT32_C(0xC04C3A42),
          UINT32_C(0x8A9D9115), UINT32_C(0x35BC5550)},
         {UINT32_C(0x7FA72AFE), UINT32_C(0x7F8C9FE3), UINT32_C(0xD1E914FD),
          UINT32_C(0x488FA0B4), UINT32_C(0x84F79359), UINT32_C(0x8F5C2D63),
          UINT32_C(0xFBC94785), UINT32_C(0x2BE80429)}},
        {{UINT32_C(0x6F67799A), UINT32_C(0x391794E0), UINT32_C(0x0677A067),
          UINT32_C(0xD9BF08AE), UINT32_C(0xDF61563C), UINT32_C(0x716D5062),
          UINT32_C(0xF590F3A3), UINT32_C(0x0ECB234A)},
         {UINT32_C(0xFEA22392), UINT32_C(0xA5B91448), UINT32_C(0x7E76FB8B),
          UINT32_C(0xFAA29487), UINT32_C(0x4B6CB375), UINT32_C(0x3CC3A02A),
          UINT32_C(0x9022167A), UINT32_C(0x5C0B3B63)}},
        {{UINT32_C(0x4C576430), UINT32_C(0xC5689CF3), UINT32_C(0xC585F5A5),
          UINT32_C(0xF7B7B230), UINT32_C(0xE4BFCEE7), UINT32_C(0xB8DAADFB),
          UINT32_C(0x9CF4242F), UINT32_C(0x7B7D8A95)},
         {UINT32_C(0x398FEEF6), UINT32_C(0xC1755F9B), UINT32_C(0x5CC5C36E),
          UINT32_C(0x9B31CD4D), UINT32_C(0xF4C6B793), UINT32_C(0x4D87AB9C),
          UINT32_C(0xF595EFA8), UINT32_C(0x673FD5B2)}},
        {{UINT32_C(0xE05E6B19), UINT32_C(0xA3836484), UINT32_C(0xFCA7E6FB),
          UINT32_C(0x090C14CF), UINT32_C(0xFC717DBC), UINT32_C(0xB7A27042),
          UINT32_C(0x38647882), UINT32_C(0x56CD4AF1)},
         {UINT32_C(0xA43C453E), UINT32_C(0xC2B56B50), UINT32_C(0x982E7AED),
          UINT32_C(0x0CD5E768), UINT32_C(0x58474A8B), UINT32_C(0xD5ABADF7),
          UINT32_C(0x99F500AC), UINT32_C(0x68188A38)}},
        {{UINT32_C(0x83B1F7BA), UINT32_C(0x0683AC3E), UINT32_C(0x680568E9),
          UINT32_C(0x6A4FC30C), UINT32_C(0x7F6256CF), UINT32_C(0x735F5E48),
          UINT32_C(0x048DB831), UINT32_C(0x1240752D)},
         {UINT32_C(0x868B8AD7), UINT32_C(0x98B78A67), UINT32_C(0x822EBA7D),
          UINT32_C(0x9E32F2C1), UINT32_C(0x8F37580F), UINT32_C(0xEAE28B1E),
          UINT32_C(0xC72EDA86), UINT32_C(0x0D204CE0)}},
        {{UINT32_C(0x77E8C68C), UINT32_C(0x5E4EAA1C), UINT32_C(0x859A127B),
          UINT32_C(0x282ADFE9), UINT32_C(0x14904910), UINT32_C(0x0C75AB7C),
          UINT32_C(0x6E751062), UINT32_C(0x1794516A)},
         {UINT32_C(0x3DE4A32A), UINT32_C(0x8D99D891), UINT32_C(0x54EF2BF0),
          UINT32_C(0x957AA807), UINT32_C(0x0B109ECD), UINT32_C(0xBF20A9E0),
          UINT32_C(0xA72268D3), UINT32_C(0x7732F2B3)}},
        {{UINT32_C(0x48752F76), UINT32_C(0xADB52E43), UINT32_C(0xD6F7CCE8),
          UINT32_C(0x01E9F4B1), UINT32_C(0x2E4BD9B5), UINT32_C(0x22702DA0),
          UINT32_C(0xB40BF9AB), UINT32_C(0x1BCC9C60)},
         {UINT32_C(0x9F53B2B1), UINT32_C(0xAB774637), UINT32_C(0x8CB316D0),
          UINT32_C(0x9C574151), UINT32_C(0xBECBEBED), UINT32_C(0x231D5C45),
          UINT32_C(0xF0458638), UINT32_C(0x0BD2D5E7)}},
        {{UINT32_C(0x4B946132), UINT32_C(0xD2F5E0B5), UINT32_C(0x155AA2C8),
          UINT32_C(0x200A8A30), UINT32_C(0x56A62CE7), UINT32_C(0x15473FD4),
          UINT32_C(0xB6689367), UINT32_C(0x030EA71B)},
         {UINT32_C(0x0E315F29), UINT32_C(0xD561432B), UINT32_C(0x149E3A9E),
          UINT32_C(0x4155022E), UINT32_C(0x15841273), UINT32_C(0xC77EF7E1),
          UINT32_C(0x52BA265A), UINT32_C(0x890D9C8D)}},
        {{UINT32_C(0x5E62451A), UINT32_C(0xB72B5A6A), UINT32_C(0x5C61A183),
          UINT32_C(0xFDA85C17), UINT32_C(0xB7F36EB3), UINT32_C(0xA4275361),
          UINT32_C(0x94F4148D), UINT32_C(0x53ADFAF3)},
         {UINT32_C(0x6A8467AE), UINT32_C(0x281D47F9), UINT32_C(0x8474D3AD),
          UINT32_C(0x416A64B5), UINT32_C(0xEC99480E), UINT32_C(0x710D0E7A),
          UINT32_C(0x819253FF), UINT32_C(0x2693A878)}},
        {{UINT32_C(0x1A2FE406), UINT32_C(0x4BE76904), UINT32_C(0x343F5B10),
          UINT32_C(0xB6FEED1D), UINT32_C(0xD705E35C), UINT32_C(0x36695C52),
          UINT32_C(0x6BD3859F), UINT32_C(0x7DF6FA41)},
         {UINT32_C(0xC00E77EA), UINT32_C(0x7B9B11F5), UINT32_C(0xCA80F838),
          UINT32_C(0xC90411B8), UINT32_C(0x2908C694), UINT32_C(0x8A9FAEF0),
          UINT32_C(0xFF5B39B0), UINT32_C(0x05F65AAA)}},
        {{UINT32_C(0xD7F59CC5), UINT32_C(0x823A0776), UINT32_C(0xC410DFD1),
          UINT32_C(0xB9EBE15E), UINT32_C(0x10A7FA3F), UINT32_C(0xC2374B58),
          UINT32_C(0x311660F2), UINT32_C(0x1B912C84)},
         {UINT32_C(0xD5A175E6), UINT32_C(0x486A2607), UINT32_C(0x72B74EB7),
          UINT32_C(0x9B17D14D), UINT32_C(0x1039CA77), UINT32_C(0x1069D5C4),
          UINT32_C(0x3FEE08BB), UINT32_C(0x214605B3)}},
        {{UINT32_C(0xF9D14E8D), UINT32_C(0xC25A7379), UINT32_C(0x577D330E),
          UINT32_C(0x9D5FAFDA), UINT32_C(0xA4A9CEF0), UINT32_C(0xB9A0217D),
          UINT32_C(0x08252731), UINT32_C(0x95AFC7F7)},
         {UINT32_C(0x8FC51680), UINT32_C(0x14E53E9E), UINT32_C(0xA8AC4E21),
          UINT32_C(0x0AEA2428), UINT32_C(0x11CB2361), UINT32_C(0x6BC5E42C),
          UINT32_C(0xDCB52215), UINT32_C(0x3B205E45)}},
        {{UINT32_C(0xC916CDE4), UINT32_C(0x8EDD4718), UINT32_C(0xD70D7130),
          UINT32_C(0xBB08F27A), UINT32_C(0xED9162CB), UINT32_C(0x289A33C0),
          UINT32_C(0xFB69185B), UINT32_C(0x97CEFA45)},
         {UINT32_C(0x8B7797EE), UINT32_C(0x44DA2578), UINT32_C(0x148E9A75),
          UINT32_C(0x579B17F7), UINT32_C(0x913C09AE), UINT32_C(0x73EC1C23),
          UINT32_C(0x0BAAA67D), UINT32_C(0x3FAB86A4)}},
        {{UINT32_C(0x2DF7BE6D), UINT32_C(0x28E76C23), UINT32_C(0x500A844D),
          UINT32_C(0x00526844), UINT32_C(0x3CC748C2), UINT32_C(0xB86FBB14),
          UINT32_C(0xEB5F6AC5), UINT32_C(0x6D89BB8A)},
         {UINT32_C(0x2327808C), UINT32_C(0xF66159DF), UINT32_C(0x29C5006C),
          UINT32_C(0x606F0553), UINT32_C(0x844B6CA4), UINT32_C(0xDAA1107F),
          UINT32_C(0x63A8946C), UINT32_C(0x95D7686C)}},
    },
    {
        {{UINT32_C(0x07F7DCF5), UINT32_C(0x71438CEA), UINT32_C(0x0A1CCD55),
          UINT32_C(0xB3F59AFA), UINT32_C(0x0E0071B4), UINT32_C(0x5A439627),
          UINT32_C(0xE93D5B8E), UINT32_C(0x8694E3FA)},
         {UINT32_C(0x7D6550B0), UINT32_C(0x21713A38), UINT32_C(0x06CFCD5B),
          UINT32_C(0x893BD9F7), UINT32_C(0xE7513FCE), UINT32_C(0xC3D2679C),
          UINT32_C(0x2C451EF3), UINT32_C(0x418AE7C8)}},
        {{UINT32_C(0x0B85E2A9), UINT32_C(0xADFAFF38), UINT32_C(0x2E244653),
          UINT32_C(0x6124E627), UINT32_C(0x375D1EE7), UINT32_C(0xF2C465AF),
          UINT32_C(0x76E58455), UINT32_C(0x5B2302D6)},
         {UINT32_C(0x7479F387), UINT32_C(0x32938A0D), UINT32_C(0xAAAB22A5),
          UINT32_C(0xF9A16A0D), UINT32_C(0x2AD65CAE), UINT32_C(0x65AF0E25),
          UINT32_C(0x8431EA40), UINT32_C(0x2B566866)}},
        {{UINT32_C(0xDBCDAFAB), UINT32_C(0xCA3ACC11), UINT32_C(0xBB7F218B),
          UINT32_C(0x0BBB5DBF), UINT32_C(0xDB0ABBE2), UINT32_C(0xD69E091A),
          UINT32_C(0x0B0B7B09), UINT32_C(0x8AFFCE95)},
         {UINT32_C(0xC7EC52C7), UINT32_C(0x0A5E6C81), UINT32_C(0x896707CD),
          UINT32_C(0xABD60595), UINT32_C(0x101E0F80), UINT32_C(0x4CE86506),
          UINT32_C(0x4ED01B2E), UINT32_C(0x9629A6C0)}},
        {{UINT32_C(0xE15D82F4), UINT32_C(0x1D740EAC), UINT32_C(0x90A5D149),
          UINT32_C(0x42F98018), UINT32_C(0x903D6D28), UINT32_C(0x1B8C8DC0),
          UINT32_C(0x05BBDFF7), UINT32_C(0x7BE2B916)},
         {UINT32_C(0xD8E41D96), UINT32_C(0xFBACF878), UINT32_C(0xBE26EB56),
          UINT32_C(0x42E98BFB), UINT32_C(0xF6DE1EB1), UINT32_C(0x9EA73555),
          UINT32_C(0xCF79A9EE), UINT32_C(0x5325DDDE)}},
        {{UINT32_C(0x48E6A22F), UINT32_C(0x44BE62C3), UINT32_C(0x8DB35276),
          UINT32_C(0xD0A3C0AD), UINT32_C(0x136FE9BA), UINT32_C(0xB4C99306),
          UINT32_C(0xA44E491F), UINT32_C(0x0F2987D7)},
         {UINT32_C(0xCCC77C2B), UINT32_C(0xA0965F74), UINT32_C(0xFE110072),
          UINT32_C(0xE01AD644), UINT32_C(0xC16B5E1E), UINT32_C(0x79528B9C),
          UINT32_C(0xF929BE4D), UINT32_C(0x45AEEFF3)}},
        {{UINT32_C(0x7F4DA458), UINT32_C(0x46E95DF6), UINT32_C(0xA7AD579B),
          UINT32_C(0x554C50C1), UINT32_C(0x4316DBA1), UINT32_C(0xF64F00A1),
          UINT32_C(0x46D487BD), UINT32_C(0x16C98513)},
         {UINT32_C(0x2C048A1B), UINT32_C(0xECB19761), UINT32_C(0x5373E5E6),
          UINT32_C(0x997AF398), UINT32_C(0xFDF23B20), UINT32_C(0x50E832D2),
          UINT32_C(0x7EF7E097), UINT32_C(0x1B358E0F)}},
        {{UINT32_C(0xACBC759C), UINT32_C(0x7C6728AE), UINT32_C(0xA156A466),
          UINT32_C(0x187588FB), UINT32_C(0x928F97BD), UINT32_C(0xC2E550ED),
          UINT32_C(0xAAE1C05A), UINT32_C(0x8B595A3A)},
         {UINT32_C(0xD77C1125), UINT32_C(0xE36871E1), UINT32_C(0x0DBBD882),
          UINT32_C(0x11E12978), UINT32_C(0x5E77FB7E), UINT32_C(0x3EF8268A),
          UINT32_C(0x6B33C00C), UINT32_C(0x7BAEA9BA)}},
        {{UINT32_C(0x5925E5FE), UINT32_C(0x7C851236), UINT32_C(0xD8E1597B),
          UINT32_C(0xCED70AE5), UINT32_C(0x6DCD112F), UINT32_C(0x7A28BE1A),
          UINT32_C(0x3B8EAF6F), UINT32_C(0x1EB19268)},
         {UINT32_C(0x8AA902B9), UINT32_C(0x7E6F1CF2), UINT32_C(0xA5A761D9),
          UINT32_C(0x3DD9D59C), UINT32_C(0x48D9F52E), UINT32_C(0x8EF70BB4),
          UINT32_C(0xCDEE9658), UINT32_C(0x96629C1A)}},
        {{UINT32_C(0xB367C5B3), UINT32_C(0xCA215EAC), UINT32_C(0xA796338A),
          UINT32_C(0x36B22774), UINT32_C(0x26EBCDFE), UINT32_C(0x71F9A61A),
          UINT32_C(0x35119BD3), UINT32_C(0x1B40580A)},
         {UINT32_C(0x431C78BD), UINT32_C(0x77169EF1), UINT32_C(0x337022D5),
          UINT32_C(0x8197975E), UINT32_C(0x1D9A4742), UINT32_C(0x45112799),
          UINT32_C(0x19B6DB07), UINT32_C(0x382750D6)}},
        {{UINT32_C(0x9786AE0B), UINT32_C(0x740405EE), UINT32_C(0x3ABA0481),
          UINT32_C(0xF7F37C0F), UINT32_C(0x51892307), UINT32_C(0x904FC60C),
          UINT32_C(0xE891D639), UINT32_C(0x8405DF2A)},
         {UINT32_C(0xD9B432F8), UINT32_C(0x53D19AC5), UINT32_C(0x066CD97C),
          UINT32_C(0xE8F1730F), UINT32_C(0x0E95804B), UINT32_C(0xC8740FEF),
          UINT32_C(0xEC242811), UINT32_C(0x12EE433C)}},
        {{UINT32_C(0x6153F4D4), UINT32_C(0x6AF4B9B1), UINT32_C(0xF84F0145),
          UINT32_C(0x9CD8CD0C), UINT32_C(0xDCEB0F06), UINT32_C(0x6CABD4FC),
          UINT32_C(0x0D134DCE), UINT32_C(0x036BF146)},
         {UINT32_C(0x7EFFACAB), UINT32_C(0xCDEB1818), UINT32_C(0x52C987E7),
          UINT32_C(0xB57A4162), UINT32_C(0xC647E82F), UINT32_C(0xDD5104EB),
          UINT32_C(0xF51B5270), UINT32_C(0x389AA556)}},
        {{UINT32_C(0x60108876), UINT32_C(0xC450CAEA), UINT32_C(0xF48601A1),
          UINT32_C(0xF36B5B6A), UINT32_C(0x09128863), UINT32_C(0x257950D1),
          UINT32_C(0xA9F6A1B9), UINT32_C(0x7A592427)},
         {UINT32_C(0xED12DE33), UINT32_C(0xBF1FF2B0), UINT32_C(0xE2141101),
          UINT32_C(0x4D542AC8), UINT32_C(0xE170F9CF), UINT32_C(0x998523C4),
          UINT32_C(0xFCEC0E2F), UINT32_C(0x629385CE)}},
        {{UINT32_C(0xB2677C49), UINT32_C(0x951494ED), UINT32_C(0xF9B648E8),
          UINT32_C(0xF1AE7138), UINT32_C(0x63CFF359), UINT32_C(0x28B8749E),
          UINT32_C(0x9A73272F), UINT32_C(0x5AC4EC4C)},
         {UINT32_C(0x21723271), UINT32_C(0xC25ABB87), UINT32_C(0x8B441AFD),
          UINT32_C(0x488EC910), UINT32_C(0x1B1DF775), UINT32_C(0x07518348),
          UINT32_C(0xF1EB2FB4), UINT32_C(0x4662BBDA)}},
        {{UINT32_C(0x6DF9F64A), UINT32_C(0xAE836F74), UINT32_C(0xA185ABE6),
          UINT32_C(0xF3CD6C9D), UINT32_C(0xC29A1C1A), UINT32_C(0xAFA897A8),
          UINT32_C(0x11B2D6AC), UINT32_C(0x4BAFBB69)},
         {UINT32_C(0xB6D971C7), UINT32_C(0x8040F9A3), UINT32_C(0x00763EAF),
          UINT32_C(0x3B8920B7), UINT32_C(0x52E848B7), UINT32_C(0x7A1655DA),
          UINT32_C(0x703FA84D), UINT32_C(0x03BC8B55)}},
        {{UINT32_C(0x1F934416), UINT32_C(0xE6348C65), UINT32_C(0xF82BBC4A),
          UINT32_C(0xDBE59C03), UINT32_C(0xEAD60547), UINT32_C(0x51AEAD09),
          UINT32_C(0x4F20111E), UINT32_C(0x043A35C3)},
         {UINT32_C(0xEC574F0A), UINT32_C(0x0AA18326), UINT32_C(0xFCADF79D),
          UINT32_C(0x07E90D70), UINT32_C(0x201CD68B), UINT32_C(0x3979D4CE),
          UINT32_C(0x2C2734B1), UINT32_C(0x7FBF2C63)}},
        {{UINT32_C(0x2656AF49), UINT32_C(0x2E451373), UINT32_C(0xA432DE06),
          UINT32_C(0xCA86207D), UINT32_C(0x12F20637), UINT32_C(0xC5F9262D),
          UINT32_C(0x26C0C745), UINT32_C(0x7DD9CCDC)},
         {UINT32_C(0xA785ED89), UINT32_C(0x99276BDC), UINT32_C(0x374CFBE2),
          UINT32_C(0x34B307A7), UINT32_C(0x1E8EE0C5), UINT32_C(0x916E9B06),
          UINT32_C(0x88A85C6A), UINT32_C(0x4E8EB3C7)}},
    },
    {
        {{UINT32_C(0x107F1CE0), UINT32_C(0x6F2433EF), UINT32_C(0x46D23AEF),
          UINT32_C(0x121DE131), UINT32_C(0x20DB44DE), UINT32_C(0x7AC50BE8),
          UINT32_C(0xF6F41A1C), UINT32_C(0x1E500A2B)},
         {UINT32_C(0x27B0004C), UINT32_C(0x8E5BAFCC), UINT32_C(0xDB555C04),
          UINT32_C(0x8538A5ED), UINT32_C(0xCE4ED544), UINT32_C(0x00AEC8A7),
          UINT32_C(0x73B2DA91), UINT32_C(0x7C7301CC)}},
        {{UINT32_C(0x63284E3A), UINT32_C(0x3E7E1E5C), UINT32_C(0x1422D8EA),
          UINT32_C(0x14581400), UINT32_C(0x7AAABD1D), UINT32_C(0x5FE151BF),
          UINT32_C(0x1533B371), UINT32_C(0x6716691F)},
         {UINT32_C(0x22A8B7DF), UINT32_C(0xA592D53E), UINT32_C(0x51C97935),
          UINT32_C(0x66991AFF), UINT32_C(0xDE5429B6), UINT32_C(0x8B10603D),
          UINT32_C(0x551F146B), UINT32_C(0x0002F6C6)}},
        {{UINT32_C(0x777A334C), UINT32_C(0xF641CBCB), UINT32_C(0xEEFBCA44),
          UINT32_C(0xB45B21E1), UINT32_C(0x32F6E263), UINT32_C(0x7C2FCD65),
          UINT32_C(0xFEED8901), UINT32_C(0x05A21D80)},
         {UINT32_C(0x5506CF47), UINT32_C(0x2471B486), UINT32_C(0x7C9E62DE),
          UINT32_C(0x0FFAC1F7), UINT32_C(0x869D3BDC), UINT32_C(0xC4D321DF),
          UINT32_C(0x9512D0CA), UINT32_C(0x9AC03509)}},
        {{UINT32_C(0x352E0353), UINT32_C(0x5A26E8F5), UINT32_C(0xBF6ABBAC),
          UINT32_C(0x965CF602), UINT32_C(0xE911C628), UINT32_C(0xDD8C4818),
          UINT32_C(0xDC2D04A0), UINT32_C(0x132CA2D8)},
         {UINT32_C(0x6C865C91), UINT32_C(0x7641CFCE), UINT32_C(0x8E9965EF),
          UINT32_C(0xDB5AB8F3), UINT32_C(0xDE0B7E90), UINT32_C(0x30030BCD),
          UINT32_C(0x2320D3F1), UINT32_C(0x7BF44453)}},
        {{UINT32_C(0xD8A99DAD), UINT32_C(0xC006FA6D), UINT32_C(0xB45E64A1),
          UINT32_C(0xC042F163), UINT32_C(0x74F4DBB1), UINT32_C(0xB91C9CA4),
          UINT32_C(0xBE221E4E), UINT32_C(0x23BD5A29)},
         {UINT32_C(0x3D1ECF78), UINT32_C(0x6B0591D7), UINT32_C(0xAA5B771C),
          UINT32_C(0x9E0ACF38), UINT32_C(0x796D4AA3), UINT32_C(0xC970F263),
          UINT32_C(0x7B5DD349), UINT32_C(0x37037502)}},
        {{UINT32_C(0xFBC52541), UINT32_C(0xE11DECDA), UINT32_C(0xE7FE53A5),
          UINT32_C(0xA49B8D39), UINT32_C(0x104A1F6E), UINT32_C(0x3A08E9BB),
          UINT32_C(0xE0192BFB), UINT32_C(0x95444A15)},
         {UINT32_C(0x1A97B875), UINT32_C(0xEF75B062), UINT32_C(0xEA5FC457),
          UINT32_C(0x9FC8AE5E), UINT32_C(0x47F73089), UINT32_C(0x3A09FD1B),
          UINT32_C(0xE24516AB), UINT32_C(0x096750EC)}},
        {{UINT32_C(0x4A350C95), UINT32_C(0xAA180046), UINT32_C(0x58EA4195),
          UINT32_C(0xA72F2B67), UINT32_C(0xFD9A4F25), UINT32_C(0xE0647945),
          UINT32_C(0x22737E2D), UINT32_C(0x4CF4136D)},
         {UINT32_C(0xEFB2A96D), UINT32_C(0xEE2532CE), UINT32_C(0x6C2F1471),
          UINT32_C(0xB39DB117), UINT32_C(0x19935BDB), UINT32_C(0xF7C6242B),
          UINT32_C(0x7A820092), UINT32_C(0x98CA48D4)}},
        {{UINT32_C(0xC3C938B0), UINT32_C(0xE9C1AD0A), UINT32_C(0xCCDF3BC6),
          UINT32_C(0xF7CC05C4), UINT32_C(0x363A9CC6), UINT32_C(0x3C21752B),
          UINT32_C(0x5916BD59), UINT32_C(0x47996B87)},
         {UINT32_C(0x98D17468), UINT32_C(0x01EF895D), UINT32_C(0x5818F5D8),
          UINT32_C(0x9182F882), UINT32_C(0xE35E4BE7), UINT32_C(0xCBD212A3),
          UINT32_C(0x5EA16E55), UINT32_C(0x894E7F39)}},
        {{UINT32_C(0x7C8FDD7E), UINT32_C(0xAC674AEE), UINT32_C(0xEDB0FE30),
          UINT32_C(0xA23FA827), UINT32_C(0x745B3230), UINT32_C(0x642BE06F),
          UINT32_C(0xCB40941C), UINT32_C(0x7654C79B)},
         {UINT32_C(0xD6A9E988), UINT32_C(0x4640C0C5), UINT32_C(0x11A4EECB),
          UINT32_C(0xA98AF661), UINT32_C(0x325D730E), UINT32_C(0xE1E827E3),
          UINT32_C(0x7D8A02DE), UINT32_C(0x2342D880)}},
        {{UINT32_C(0x715DB87E), UINT32_C(0xE4101595), UINT32_C(0x3C44A43A),
          UINT32_C(0x462718AB), UINT32_C(0xEFCBC0F7), UINT32_C(0xF414CBC7),
          UINT32_C(0xE5999AB3), UINT32_C(0x2A64DB21)},
         {UINT32_C(0x9DA91E84), UINT32_C(0xDAD841E1), UINT32_C(0x5F5C1CDD),
          UINT32_C(0x5A28F649), UINT32_C(0xB8B41BDA), UINT32_C(0x2F8C9DCA),
          UINT32_C(0x029C3697), UINT32_C(0x259DC791)}},
        {{UINT32_C(0x5296BA38), UINT32_C(0xD56F4EF4), UINT32_C(0x02EC3100),
          UINT32_C(0x4A853BA1), UINT32_C(0xC8AE4C47), UINT32_C(0xB0ED5F21),
          UINT32_C(0x61DF268E), UINT32_C(0x53D0DA0C)},
         {UINT32_C(0x6DC06EB6), UINT32_C(0xB6771DCB), UINT32_C(0xBB0C457F),
          UINT32_C(0x30B07595), UINT32_C(0xF174690D), UINT32_C(0xC2FD08F3),
          UINT32_C(0x87A5DC8E), UINT32_C(0x77000D6A)}},
        {{UINT32_C(0x6E1369AD), UINT32_C(0x90DDAA61), UINT32_C(0xB6A5F225),
          UINT32_C(0x3DD15EE7), UINT32_C(0x27AEB0DC), UINT32_C(0x051AA9C4),
          UINT32_C(0xE5372729), UINT32_C(0x18712DBB)},
         {UINT32_C(0xA23AFF5A), UINT32_C(0x13B3F9DF), UINT32_C(0x703FBFF9),
          UINT32_C(0x34388CED), UINT32_C(0x17D60129), UINT32_C(0x0F390D67),
          UINT32_C(0x4DAE9863), UINT32_C(0x3F0CA25E)}},
        {{UINT32_C(0x903385DC), UINT32_C(0x6E0F5594), UINT32_C(0xF8A815A9),
          UINT32_C(0x47483889), UINT32_C(0x23B70B1C), UINT32_C(0x42AF320C),
          UINT32_C(0x1A1AEA03), UINT32_C(0x4A27CA27)},
         {UINT32_C(0x66AF6F9D), UINT32_C(0xFAAC21C8), UINT32_C(0xC9FBFD3E),
          UINT32_C(0x20849D90), UINT32_C(0xEE0A541C), UINT32_C(0x793F889F),
          UINT32_C(0xADA5D18F), UINT32_C(0x2555FC32)}},
        {{UINT32_C(0xBA2BD509), UINT32_C(0x3F38F58C), UINT32_C(0x048F864B),
          UINT32_C(0x319A5F0D), UINT32_C(0xD5900B1E), UINT32_C(0xC4632F37),
          UINT32_C(0xF8519441), UINT32_C(0x3FAF2615)},
         {UINT32_C(0xFE194D77), UINT32_C(0x6A4AA25D), UINT32_C(0xD681409B),
          UINT32_C(0xB5A6464A), UINT32_C(0xB957523A), UINT32_C(0x1A9326ED),
          UINT32_C(0x27098B5B), UINT32_C(0x7690EA4F)}},
        {{UINT32_C(0x10F3FDE3), UINT32_C(0x5530E911), UINT32_C(0x810E7853),
          UINT32_C(0x9A40101F), UINT32_C(0x8F011C4E), UINT32_C(0x152704FC),
          UINT32_C(0x129B455F), UINT32_C(0x5B1702E4)},
         {UINT32_C(0xE60F4D30), UINT32_C(0x46A130BA), UINT32_C(0x62BBE8B5),
          UINT32_C(0xA3D57414), UINT32_C(0x3CFAEFE3), UINT32_C(0xA26238DA),
          UINT32_C(0x3175078E), UINT32_C(0x4E614113)}},
        {{UINT32_C(0x992EE109), UINT32_C(0x27BCCDFF), UINT32_C(0xFB45C6C3),
          UINT32_C(0x79F88647), UINT32_C(0xC73F2829), UINT32_C(0x7FD5D73A),
          UINT32_C(0x65A44CF1), UINT32_C(0x7EBE8E4E)},
         {UINT32_C(0x37414B2C), UINT32_C(0xB9EC0B94), UINT32_C(0x36DED49D),
          UINT32_C(0x846AD1D1), UINT32_C(0x62F2FE87), UINT32_C(0x72AE1060),
          UINT32_C(0xC032EEDD), UINT32_C(0x7F5AF329)}},
    },
    {
        {{UINT32_C(0xC7A645A5), UINT32_C(0x6C80B058), UINT32_C(0x729066AC),
          UINT32_C(0xF86341D2), UINT32_C(0x33FB5CE8), UINT32_C(0xE4F366BD),
          UINT32_C(0xC23A4751), UINT32_C(0x6B79D63F)},
         {UINT32_C(0xEC3F8686), UINT32_C(0xFAA0F994), UINT32_C(0xA9BA8F5E),
          UINT32_C(0x156A6E8E), UINT32_C(0x9F2FAE57), UINT32_C(0xA46CA7D5),
          UINT32_C(0x6EFE66F2), UINT32_C(0x84CB2196)}},
        {{UINT32_C(0xED25185C), UINT32_C(0xF9C1DECB), UINT32_C(0xB1FCFC82),
          UINT32_C(0x6DC43F21), UINT32_C(0xA954087B), UINT32_C(0x4A840262),
          UINT32_C(0x0A38F667), UINT32_C(0x60230809)},
         {UINT32_C(0x1D9672B5), UINT32_C(0xBD345006), UINT32_C(0xF83361EF),
          UINT32_C(0xE0FF804B), UINT32_C(0xEF8E1598), UINT32_C(0x9DDC6CE1),
          UINT32_C(0xFBD9BD0E), UINT32_C(0x4419F705)}},
        {{UINT32_C(0x3426122A), UINT32_C(0xF171EDE4), UINT32_C(0x20A3963E),
          UINT32_C(0xEF6A1AE2), UINT32_C(0x031647D0), UINT32_C(0xD25AB7A2),
          UINT32_C(0xCB4CA4E3), UINT32_C(0x0FD7EC20)},
         {UINT32_C(0xB7D3A295), UINT32_C(0xC103969C), UINT32_C(0x34DBABA8),
          UINT32_C(0x4957509E), UINT32_C(0x60BC0760), UINT32_C(0x8456DF63),
          UINT32_C(0xD63B49A9), UINT32_C(0x02AF2033)}},
        {{UINT32_C(0x0378E444), UINT32_C(0x271966A0), UINT32_C(0x5D15A0B7),
          UINT32_C(0x673F057D), UINT32_C(0xA0EFE59E), UINT32_C(0xA55C44F9),
          UINT32_C(0x376119A6), UINT32_C(0x2F602F87)},
         {UINT32_C(0x28981502), UINT32_C(0x0A149074), UINT32_C(0x8741D4F2),
          UINT32_C(0xDA006774), UINT32_C(0x133F8479), UINT32_C(0x8F982C81),
          UINT32_C(0xF944319A), UINT32_C(0x1ECAF17A)}},
        {{UINT32_C(0xA37F4FC2), UINT32_C(0x281A234E), UINT32_C(0xFD34FC11),
          UINT32_C(0xAFD847B2), UINT32_C(0x4683E11A), UINT32_C(0x02CC0839),
          UINT32_C(0x3F65B844), UINT32_C(0x71215DA9)},
         {UINT32_C(0xEFE32AC9), UINT32_C(0xF9F41383), UINT32_C(0x1361FE53),
          UINT32_C(0x4AC3D91D), UINT32_C(0x1CC2E948), UINT32_C(0x03C9FBAB),
          UINT32_C(0x43379A4F), UINT32_C(0x9A9A4B91)}},
        {{UINT32_C(0x51BED5AC), UINT32_C(0x8D37A108), UINT32_C(0x998E1C19),
          UINT32_C(0x75D91890), UINT32_C(0x5D244730), UINT32_C(0xE6C76B09),
          UINT32_C(0x4CD555FF), UINT32_C(0x12714716)},
         {UINT32_C(0x29DDC669), UINT32_C(0xF2DCE85A), UINT32_C(0x8D622348),
          UINT32_C(0x8914D13A), UINT32_C(0xDAE035E8), UINT32_C(0x9FE6B578),
          UINT32_C(0xF41EEF19), UINT32_C(0x21ECB251)}},
        {{UINT32_C(0x7999064D), UINT32_C(0xEAFF3862), UINT32_C(0x96383204),
          UINT32_C(0xB72BABEF), UINT32_C(0x6BCCCB43), UINT32_C(0x8E6C9E67),
          UINT32_C(0x7FD71298), UINT32_C(0x320A7D78)},
         {UINT32_C(0xB438A302), UINT32_C(0x4081E38A), UINT32_C(0x120E132D),
          UINT32_C(0x0A15CBA7), UINT32_C(0xEC2E0939), UINT32_C(0x6D9123E1),
          UINT32_C(0xE0D6FEC5), UINT32_C(0x692D699C)}},
        {{UINT32_C(0xC8D5D361), UINT32_C(0xB639ADAE), UINT32_C(0xC60A078D),
          UINT32_C(0xA8F742CC), UINT32_C(0x9D740F0F), UINT32_C(0xE8D2CF92),
          UINT32_C(0x4DCE6A87), UINT32_C(0x6E8EEEF9)},
         {UINT32_C(0x6A2E5164), UINT32_C(0x54E19488), UINT32_C(0x2430E4B9),
          UINT32_C(0x4372C6CF), UINT32_C(0x1C5B13B3), UINT32_C(0xD58EA91B),
          UINT32_C(0xBB9F2911), UINT32_C(0x796DCC45)}},
        {{UINT32_C(0xCBB267F9), UINT32_C(0xD8D4FAF0), UINT32_C(0x703F4011),
          UINT32_C(0xC2770DBE), UINT32_C(0x0D651402), UINT32_C(0x13739F02),
          UINT32_C(0x72D2B3F1), UINT32_C(0x7DE4E51E)},
         {UINT32_C(0x1FE00C7E), UINT32_C(0xB10F966E), UINT32_C(0x8F42B5F8),
          UINT32_C(0x5E9A1501), UINT32_C(0xD00437A3), UINT32_C(0x6AFB1AD0),
          UINT32_C(0x1473D5AE), UINT32_C(0x267D1536)}},
        {{UINT32_C(0x4CAE118F), UINT32_C(0x1173B5DB), UINT32_C(0xCA749EE6),
          UINT32_C(0xC3A2EAFD), UINT32_C(0x4ED4FFF4), UINT32_C(0x64F738E6),
          UINT32_C(0xB07860B6), UINT32_C(0x47DDECB6)},
         {UINT32_C(0xBD47A901), UINT32_C(0xF5D627FC), UINT32_C(0x856C6903),
          UINT32_C(0x6493BC28), UINT32_C(0xEA63B675), UINT32_C(0x90280E4B),
          UINT32_C(0xC4148666), UINT32_C(0x211C04A2)}},
        {{UINT32_C(0x6524BC38), UINT32_C(0x0A5F0C27), UINT32_C(0xBB3CBDB9),
          UINT32_C(0x4B9D95FB), UINT32_C(0x20507C82), UINT32_C(0x5394ADC2),
          UINT32_C(0xB4DBE448), UINT32_C(0x4C0C9167)},
         {UINT32_C(0x303A5B11), UINT32_C(0xAC3E87CE), UINT32_C(0x3251F4DF),
          UINT32_C(0xD31FB9C5), UINT32_C(0xE43CE799), UINT32_C(0x86C281DF),
          UINT32_C(0x29FE09E4), UINT32_C(0x84E644D7)}},
        {{UINT32_C(0x43166C20), UINT32_C(0x6D7B61DC), UINT32_C(0xBD34F981),
          UINT32_C(0x54D6C035), UINT32_C(0xC991096D), UINT32_C(0xB166769D),
          UINT32_C(0x3A4CF05C), UINT32_C(0x51A47E3A)},
         {UINT32_C(0x14F5E7F1), UINT32_C(0x57CF9EFF), UINT32_C(0xE39FDA0D),
          UINT32_C(0xED3D4E9D), UINT32_C(0xBAA7E93B), UINT32_C(0xDF0176EC),
          UINT32_C(0x70935B9F), UINT32_C(0x6B2FEA14)}},
        {{UINT32_C(0x709B70AE), UINT32_C(0x19F9D59E), UINT32_C(0x70472149),
          UINT32_C(0xD850CA32), UINT32_C(0x29EE6104), UINT32_C(0x292CADD9),
          UINT32_C(0x8FD499F2), UINT32_C(0x870F7C99)},
         {UINT32_C(0x415C6FFD), UINT32_C(0x200ECB1C), UINT32_C(0x35CB841B),
          UINT32_C(0xEEA6107D), UINT32_C(0xF95DD333), UINT32_C(0x1CB06F8A),
          UINT32_C(0xE498AA7B), UINT32_C(0x245712FD)}},
        {{UINT32_C(0xED4FBD78), UINT32_C(0x101665EA), UINT32_C(0x0E32D1B4),
          UINT32_C(0xC6DDE1BB), UINT32_C(0x40150A9C), UINT32_C(0x3E79185E),
          UINT32_C(0x7DEF3607), UINT32_C(0x49E2AE6B)},
         {UINT32_C(0x308B7F59), UINT32_C(0xCCC9B0F6), UINT32_C(0xCE922087),
          UINT32_C(0xB267008F), UINT32_C(0xCF2AABA6), UINT32_C(0x46CF7F07),
          UINT32_C(0x9954091F), UINT32_C(0x5A74C8A0)}},
        {{UINT32_C(0x5240B5A0), UINT32_C(0x8F287195), UINT32_C(0x1845373D),
          UINT32_C(0x7AC7720F), UINT32_C(0x4E592274), UINT32_C(0xCF276B59),
          UINT32_C(0x694C30B8), UINT32_C(0x6BEBC284)},
         {UINT32_C(0x677B16CD), UINT32_C(0xDA0113D6), UINT32_C(0x45C9FA76),
          UINT32_C(0xA2213446), UINT32_C(0x66964ADB), UINT32_C(0x2DEAF2ED),
          UINT32_C(0xBC062240), UINT32_C(0x1977A8B3)}},
        {{UINT32_C(0x80303DFD), UINT32_C(0xEEA29126), UINT32_C(0xE95BF6A1),
          UINT32_C(0x3E4A33AC), UINT32_C(0x15DE0457), UINT32_C(0x6BFE2D5D),
          UINT32_C(0xAD0976D1), UINT32_C(0x407BF7E3)},
         {UINT32_C(0x306B415B), UINT32_C(0x04C1F61F), UINT32_C(0x5F790D5F),
          UINT32_C(0xC86A75D2), UINT32_C(0xB7EAE07B), UINT32_C(0x7B799EDE),
          UINT32_C(0xB4A66839), UINT32_C(0x9155A9A0)}},
    },
    {
        {{UINT32_C(0x0DCE586B), UINT32_C(0x9745C6BB), UINT32_C(0xBE77B502),
          UINT32_C(0x554C8313), UINT32_C(0xA93962CF), UINT32_C(0xF0F842A9),
          UINT32_C(0xAAA141BC), UINT32_C(0x40862273)},
         {UINT32_C(0xBD62237B), UINT32_C(0x926FFA4A), UINT32_C(0x7B942F48),
          UINT32_C(0xD4F1E4A1), UINT32_C(0x075684FD), UINT32_C(0x3A841EB7),
          UINT32_C(0xDD1807E1), UINT32_C(0x21F6EB39)}},
        {{UINT32_C(0xBEDA4365), UINT32_C(0x155DFD66), UINT32_C(0x27F33BF9),
          UINT32_C(0xDD575C83), UINT32_C(0x3DFF83A1), UINT32_C(0x5907B08D),
          UINT32_C(0xD6788D63), UINT32_C(0x7E325357)},
         {UINT32_C(0xBAC74ED7), UINT32_C(0xF90BF447), UINT32_C(0xEDA226CD),
          UINT32_C(0x2DE6C957), UINT32_C(0x1CA44607), UINT32_C(0x67832302),
          UINT32_C(0x56011C38), UINT32_C(0x22ECBC1F)}},
        {{UINT32_C(0xB663A46C), UINT32_C(0xF01279A9), UINT32_C(0x7E3AAB83),
          UINT32_C(0x07D74C5F), UINT32_C(0x8C0DA43E), UINT32_C(0xF20940B6),
          UINT32_C(0x368AD991), UINT32_C(0x57C6A735)},
         {UINT32_C(0x5007E059), UINT32_C(0x01E9B366), UINT32_C(0x9614D480),
          UINT32_C(0xFC38FC99), UINT32_C(0xFF7DA757), UINT32_C(0x4A3AAA18),
          UINT32_C(0xB0CE1B03), UINT32_C(0x4481B669)}},
        {{UINT32_C(0xB4A807FF), UINT32_C(0x9CAA37A0), UINT32_C(0xF9B269F3),
          UINT32_C(0xBDEDEB49), UINT32_C(0xCB607AC3), UINT32_C(0xC5B76E57),
          UINT32_C(0x9A322F48), UINT32_C(0x08AEFE66)},
         {UINT32_C(0xD9261469), UINT32_C(0x6919E40D), UINT32_C(0x849718FA),
          UINT32_C(0x1F0ADA81), UINT32_C(0x9D81628E), UINT32_C(0xCD251B54),
          UINT32_C(0x5505F9E1), UINT32_C(0x6519C3C6)}},
        {{UINT32_C(0x2F81C037), UINT32_C(0x277591DC), UINT32_C(0x76E0D41E),
          UINT32_C(0xD63AD35A), UINT32_C(0x6EC063D3), UINT32_C(0x682662B5),
          UINT32_C(0x6762A0DB), UINT32_C(0x8210978B)},
         {UINT32_C(0xFE164B90), UINT32_C(0x05085F68), UINT32_C(0x3D6FD0D1),
          UINT32_C(0x50026ADC), UINT32_C(0xB01A3791), UINT32_C(0x38CC9FA7),
          UINT32_C(0xB376F83E), UINT32_C(0x1E286652)}},
        {{UINT32_C(0x09759892), UINT32_C(0x8DFFDA16), UINT32_C(0x9AC2CE5D),
          UINT32_C(0xE011DDDB), UINT32_C(0xBD71426B), UINT32_C(0xDDC7670F),
          UINT32_C(0x19742F7C), UINT32_C(0x9722A23B)},
         {UINT32_C(0xDC4767D3), UINT32_C(0x2EA99893), UINT32_C(0x11125BAE),
          UINT32_C(0xCB68D6C2), UINT32_C(0x307ED3B9), UINT32_C(0xAC76953E),
          UINT32_C(0xC366E9A2), UINT32_C(0x0EDD0C17)}},
        {{UINT32_C(0x484B5272), UINT32_C(0x88B3DEC9), UINT32_C(0x90380294),
          UINT32_C(0x0C848EA1), UINT32_C(0xA01AC92C), UINT32_C(0xDE187E83),
          UINT32_C(0x7A5D4D65), UINT32_C(0x2A880182)},
         {UINT32_C(0xB3C3C7BB), UINT32_C(0xD3C22C2B), UINT32_C(0xDE7ECE33),
          UINT32_C(0xC485CE02), UINT32_C(0xA437071A), UINT32_C(0xF22138C4),
          UINT32_C(0x0716DA53), UINT32_C(0x23A55C89)}},
        {{UINT32_C(0xF6FE058E), UINT32_C(0x9533C4A3), UINT32_C(0x748E4A4F),
          UINT32_C(0x28753F87), UINT32_C(0xEA404C70), UINT32_C(0x7814C50A),
          UINT32_C(0xE91B5EF3), UINT32_C(0x908D1C81)},
         {UINT32_C(0x04094766), UINT32_C(0xD827D3CE), UINT32_C(0x0CE5C727),
          UINT32_C(0x7AE2FD26), UINT32_C(0xCDAD2BDD), UINT32_C(0x016AC86F),
          UINT32_C(0x7A77C252), UINT32_C(0x37C088B0)}},
        {{UINT32_C(0x18A35CD3), UINT32_C(0xABF4C1EF), UINT32_C(0x698A5A01),
          UINT32_C(0x1F721491), UINT32_C(0x1A9E9A1F), UINT32_C(0x79284A12),
          UINT32_C(0x4D50DF40), UINT32_C(0x0457FF70)},
         {UINT32_C(0xEC46ED07), UINT32_C(0x1D235814), UINT32_C(0xAE5E97C8),
          UINT32_C(0xBD013752), UINT32_C(0xD9B100D4), UINT32_C(0x0E085C88),
          UINT32_C(0x8858F9F3), UINT32_C(0x8AFA070A)}},
        {{UINT32_C(0x698D6A59), UINT32_C(0x0F548BE3), UINT32_C(0xBF2D0D94),
          UINT32_C(0x5D7818A5), UINT32_C(0xD80E620D), UINT32_C(0x8E150DF1),
          UINT32_C(0xF857F167), UINT32_C(0x4C3A5E64)},
         {UINT32_C(0x61BD9152), UINT32_C(0x837D9A98), UINT32_C(0x8D10687F),
          UINT32_C(0x242CE589), UINT32_C(0xB6B52BB7), UINT32_C(0x9863EA4C),
          UINT32_C(0xB7DD35FF), UINT32_C(0x23665B46)}},
        {{UINT32_C(0x73942AAF), UINT32_C(0x3AA5432A), UINT32_C(0x0CEE83A9),
          UINT32_C(0xB0185DB4), UINT32_C(0xA83B907B), UINT32_C(0x145372EE),
          UINT32_C(0xBB6D341A), UINT32_C(0x609F1AD9)},
         {UINT32_C(0x864C92EE), UINT32_C(0x28C2B37A), UINT32_C(0xD4CC1158),
          UINT32_C(0xDD847239), UINT32_C(0x8F2EAF0A), UINT32_C(0xE5BD4FD2),
          UINT32_C(0xD24950AB), UINT32_C(0x04F43BC0)}},
        {{UINT32_C(0x88DA3F20), UINT32_C(0x11DEFCED), UINT32_C(0xA407C4A2),
          UINT32_C(0xCA4CE370), UINT32_C(0x2F8C5CFC), UINT32_C(0xEA70BEDF),
          UINT32_C(0x8214B7F7), UINT32_C(0x08AC147D)},
         {UINT32_C(0xE260AA96), UINT32_C(0xECAD0F77), UINT32_C(0xB56C30F7),
          UINT32_C(0xA868AC63), UINT32_C(0x396F4815), UINT32_C(0xF0ACDE5A),
          UINT32_C(0xACDE6CD8), UINT32_C(0x302F75B9)}},
        {{UINT32_C(0xC5D14866), UINT32_C(0x2125D07D), UINT32_C(0x4AE3212D),
          UINT32_C(0xFE563DE4), UINT32_C(0xEE9CAA2B), UINT32_C(0x0FE787CB),
          UINT32_C(0x53802482), UINT32_C(0x7D9B56A2)},
         {UINT32_C(0x8040D1A7), UINT32_C(0x128B4D37), UINT32_C(0x30ACA2F4),
          UINT32_C(0x57371299), UINT32_C(0x7623D14A), UINT32_C(0x5C443E35),
          UINT32_C(0x5FDB6310), UINT32_C(0x6436D328)}},
        {{UINT32_C(0xA8557B64), UINT32_C(0x531486A4), UINT32_C(0x9C5DE310),
          UINT32_C(0x3FAB4F21), UINT32_C(0x260468D0), UINT32_C(0xD872282E),
          UINT32_C(0x2542CBA4), UINT32_C(0x04CD4568)},
         {UINT32_C(0x555B6E0C), UINT32_C(0xACA0975A), UINT32_C(0x8B85132F),
          UINT32_C(0xEE8C43B2), UINT32_C(0xB9DECE9D), UINT32_C(0xC768808B),
          UINT32_C(0x431AF98C), UINT32_C(0x59EDEC60)}},
        {{UINT32_C(0x31992E22), UINT32_C(0xC365E133), UINT32_C(0x0DC3A4C8),
          UINT32_C(0xB96C5FA0), UINT32_C(0xA65761B0), UINT32_C(0xDEB1C1DA),
          UINT32_C(0xF4ACAB4C), UINT32_C(0x457676EE)},
         {UINT32_C(0xE674FFAF), UINT32_C(0xA0F95894), UINT32_C(0xD65CDAB7),
          UINT32_C(0xFD099172), UINT32_C(0x54DA58A2), UINT32_C(0x9383C2F8),
          UINT32_C(0x0F24A07B), UINT32_C(0x0A4F4C11)}},
        {{UINT32_C(0xE380ABF3), UINT32_C(0x9D7A80B3), UINT32_C(0x9E469F9F),
          UINT32_C(0xF0C6AC5A), UINT32_C(0x6BD0A324), UINT32_C(0xC87D5727),
          UINT32_C(0x7692B063), UINT32_C(0x28138E37)},
         {UINT32_C(0xD67862CA), UINT32_C(0xE18C1F7D), UINT32_C(0x1E07F928),
          UINT32_C(0x4B6B723E), UINT32_C(0xBBCF4125), UINT32_C(0xAAFE3FB0),
          UINT32_C(0x3B3AE714), UINT32_C(0x25400322)}},
    },
    {
        {{UINT32_C(0x63C295D8), UINT32_C(0xB89A2DCA), UINT32_C(0x85041AA1),
          UINT32_C(0x5CC03C65), UINT32_C(0xC6514781), UINT32_C(0xFA9B4C5C),
          UINT32_C(0xD92388FF), UINT32_C(0x578031A0)},
         {UINT32_C(0xF92C2D77), UINT32_C(0xB0D5AE0A), UINT32_C(0x793D588A),
          UINT32_C(0x945A677E), UINT32_C(0x34A190E0), UINT32_C(0x3722DE44),
          UINT32_C(0x0C2B9975), UINT32_C(0x6EA90DB8)}},
        {{UINT32_C(0x84BA4F9B), UINT32_C(0xE987AA85), UINT32_C(0x0AB43BE6),
          UINT32_C(0xB2A77B9C), UINT32_C(0x474D8841), UINT32_C(0xC4AD2AF6),
          UINT32_C(0x5D4FA590), UINT32_C(0x4ED7A82B)},
         {UINT32_C(0x9977AC2B), UINT32_C(0x9F39335E), UINT32_C(0x52E87607),
          UINT32_C(0x3CCD406D), UINT32_C(0x71456060), UINT32_C(0x9D18CB3F),
          UINT32_C(0x6A45D7D0), UINT32_C(0x0FE4D888)}},
        {{UINT32_C(0xF42D501A), UINT32_C(0xAEA8A911), UINT32_C(0x88F66FBA),
          UINT32_C(0x303E25D5), UINT32_C(0x61740B85), UINT32_C(0x54213F29),
          UINT32_C(0xC0B4D835), UINT32_C(0x5BC13A30)},
         {UINT32_C(0x4758EA28), UINT32_C(0x569AB9B8), UINT32_C(0xB796A794),
          UINT32_C(0xE2E49B28), UINT32_C(0x320D54E2), UINT32_C(0x17787125),
          UINT32_C(0xC54B4465), UINT32_C(0x5A6A8EDE)}},
        {{UINT32_C(0x870619DD), UINT32_C(0xC76C73D9), UINT32_C(0x84FE1078),
          UINT32_C(0xF541440E), UINT32_C(0x3B26A3DC), UINT32_C(0x2082FE36),
          UINT32_C(0xCC329B14), UINT32_C(0x3B896B29)},
         {UINT32_C(0xCAFCDC20), UINT32_C(0xB45028A9), UINT32_C(0x9C56757E),
          UINT32_C(0xA1B77C6F), UINT32_C(0x84802E47), UINT32_C(0xDE50D865),
          UINT32_C(0xBA0892B0), UINT32_C(0x7DFBC0E8)}},
        {{UINT32_C(0x47E702BB), UINT32_C(0xEBC505A9), UINT32_C(0xDACFACFE),
          UINT32_C(0x2329A41C), UINT32_C(0x51DDCE2F), UINT32_C(0xEA115603),
          UINT32_C(0x2E9D855A), UINT32_C(0x95BBC807)},
         {UINT32_C(0xCFD33E9F), UINT32_C(0x454C6B88), UINT32_C(0x4FFBB24A),
          UINT32_C(0x993CF6DE), UINT32_C(0x9B2144CD), UINT32_C(0xA8E22FF8),
          UINT32_C(0x84943294), UINT32_C(0x741066EE)}},
        {{UINT32_C(0xF067E5B2), UINT32_C(0x2CEE0CFF), UINT32_C(0xCA95F1C5),
          UINT32_C(0x1C1FD5A3), UINT32_C(0xC07B97F1), UINT32_C(0xA0EB8E7D),
          UINT32_C(0x7457415E), UINT32_C(0x0F2A5D77)},
         {UINT32_C(0x45D06291), UINT32_C(0xDFF92C58), UINT32_C(0x48ABABE8),
          UINT32_C(0x709EA0AC), UINT32_C(0x2FDC92F0), UINT32_C(0xB3058FEB),
          UINT32_C(0x5E5B169E), UINT32_C(0x55E9F86E)}},
        {{UINT32_C(0xEBF6AF2B), UINT32_C(0xEE5DF132), UINT32_C(0xF642A206),
          UINT32_C(0xC30DC3F1), UINT32_C(0x02C60CB6), UINT32_C(0xD7D8EC3E),
          UINT32_C(0x3178F1BF), UINT32_C(0x7C98946B)},
         {UINT32_C(0xA68799EB), UINT32_C(0x816C2AA1), UINT32_C(0x2430F06B),
          UINT32_C(0x507FD5E9), UINT32_C(0xB9EBD4B7), UINT32_C(0x021FFF1C),
          UINT32_C(0x8AECFEA4), UINT32_C(0x044365E6)}},
        {{UINT32_C(0x21339693), UINT32_C(0xDC5F5EA6), UINT32_C(0x90A448AD),
          UINT32_C(0x5BFD2676), UINT32_C(0xA12A9D77), UINT32_C(0xF712BA95),
          UINT32_C(0xBD8A6B5B), UINT32_C(0x7104735A)},
         {UINT32_C(0xA763BB99), UINT32_C(0xD2ED8304), UINT32_C(0x11B91A05),
          UINT32_C(0x7AF040F0), UINT32_C(0xB61F3789), UINT32_C(0xC545E8AE),
          UINT32_C(0xBB386760), UINT32_C(0x582E9EED)}},
        {{UINT32_C(0xCC099185), UINT32_C(0x0FCE5877), UINT32_C(0xCD681E67),
          UINT32_C(0x0E148BB5), UINT32_C(0xECB24ECE), UINT32_C(0xE9F9013E),
          UINT32_C(0x2A386485), UINT32_C(0x0090654B)},
         {UINT32_C(0x0520BAE8), UINT32_C(0x11BA700B), UINT32_C(0xD8E53123),
          UINT32_C(0xFC93BE31), UINT32_C(0xE37948EE), UINT32_C(0x7DD7CB36),
          UINT32_C(0x3FC23444), UINT32_C(0x8689AE8F)}},
        {{UINT32_C(0xAAC6616B), UINT32_C(0x2060F7DE), UINT32_C(0xDEAB3CC7),
          UINT32_C(0x372952C5), UINT32_C(0xC2424ACD), UINT32_C(0x715C4D27),
          UINT32_C(0x0308A009), UINT32_C(0x05846856)},
         {UINT32_C(0x0B8B34E8), UINT32_C(0x887BBD55), UINT32_C(0xB688C987),
          UINT32_C(0x949ACBD1), UINT32_C(0x784C4C0E), UINT32_C(0x3E774D49),
          UINT32_C(0xB0F5F545), UINT32_C(0x7AEA2D11)}},
        {{UINT32_C(0xE831E509), UINT32_C(0x5335BA6B), UINT32_C(0x739F332E),
          UINT32_C(0x8FC4B4AF), UINT32_C(0x95993EAF), UINT32_C(0xB0502462),
          UINT32_C(0xA7CEB88B), UINT32_C(0x7DA49F36)},
         {UINT32_C(0x029D0C8F), UINT32_C(0x3BE0B74B), UINT32_C(0x55611A8B),
          UINT32_C(0xBC07F180), UINT32_C(0x6583F53F), UINT32_C(0xC168CF41),
          UINT32_C(0xC34ADBC1), UINT32_C(0x4256E8D2)}},
        {{UINT32_C(0xCE2FCD89), UINT32_C(0x313AFC75), UINT32_C(0xD3DA44F2),
          UINT32_C(0xEA27FDA4), UINT32_C(0x9063B0DC), UINT32_C(0x9FABEA79),
          UINT32_C(0xB3418884), UINT32_C(0x2DF7D966)},
         {UINT32_C(0x80AF2EBD), UINT32_C(0x4329FD24), UINT32_C(0x9F095D30),
          UINT32_C(0x36F27FF7), UINT32_C(0xCC84C068), UINT32_C(0x88FFB18F),
          UINT32_C(0x7B0A9906), UINT32_C(0x976427A8)}},
        {{UINT32_C(0xFAC21087), UINT32_C(0xCFF828CC), UINT32_C(0x56863CB5),
          UINT32_C(0x6B6D3484), UINT32_C(0xC30879F3), UINT32_C(0x14163A70),
          UINT32_C(0x8CA6FD5D), UINT32_C(0x30E2A633)},
         {UINT32_C(0x28A58783), UINT32_C(0xC7FCEAD6), UINT32_C(0xEEFA1EAA),
          UINT32_C(0x945F7B09), UINT32_C(0x5CC66267), UINT32_C(0x98A503DB),
          UINT32_C(0x3780061B), UINT32_C(0x83EE750E)}},
        {{UINT32_C(0xB8477D6B), UINT32_C(0x7061409A), UINT32_C(0x2B7B54FA),
          UINT32_C(0xE47C779D), UINT32_C(0xF293166C), UINT32_C(0x42F5EDF5),
          UINT32_C(0x115D830F), UINT32_C(0x73C3AC1B)},
         {UINT32_C(0x4DEE0980), UINT32_C(0xC30D346E), UINT32_C(0xA62F0D09),
          UINT32_C(0xEE0D9A29), UINT32_C(0xABCB7DAE), UINT32_C(0xBBE8DC9E),
          UINT32_C(0x68B78925), UINT32_C(0x4F0E78C0)}},
        {{UINT32_C(0xB4B14003), UINT32_C(0x25A0D4FF), UINT32_C(0xB8AB649C),
          UINT32_C(0xA4C3AC55), UINT32_C(0x27F9FDF5), UINT32_C(0x7D7EDE72),
          UINT32_C(0xBC2A46D4), UINT32_C(0x507EC83F)},
         {UINT32_C(0xFAAFC26F), UINT32_C(0x344577D9), UINT32_C(0x3EB30156),
          UINT32_C(0x77CBB783), UINT32_C(0x1D5C9367), UINT32_C(0x3A846FFD),
          UINT32_C(0x9DF9F7BE), UINT32_C(0x5F0D280C)}},
        {{UINT32_C(0x77DF7F9F), UINT32_C(0xCC8EAC0A), UINT32_C(0xF33A62D4),
          UINT32_C(0x195BC6FF), UINT32_C(0x524D78FE), UINT32_C(0x18A33FFA),
          UINT32_C(0x6603F9C0), UINT32_C(0x10E58974)},
         {UINT32_C(0x0CDA2C3F), UINT32_C(0x31AF4B46), UINT32_C(0xADE169C3),
          UINT32_C(0xDDBF00C8), UINT32_C(0x71A7BC38), UINT32_C(0xA169C3E3),
          UINT32_C(0xA64B342E), UINT32_C(0x3FC352FF)}},
    },
    {
        {{UINT32_C(0xEE73C673), UINT32_C(0x58848315), UINT32_C(0x8ADB897E),
          UINT32_C(0x67D2F7C0), UINT32_C(0xF0658115), UINT32_C(0xE8CD786D),
          UINT32_C(0xAC54D2AB), UINT32_C(0x023D515A)},
         {UINT32_C(0x67559911), UINT32_C(0x0EDE61D8), UINT32_C(0x3C2B78B5),
          UINT32_C(0xBC12B106), UINT32_C(0x9E4707D8), UINT32_C(0xB5661A28),
          UINT32_C(0xADC095A4), UINT32_C(0x93FB4096)}},
        {{UINT32_C(0x33D5FA08), UINT32_C(0xEEB3810F), UINT32_C(0x33F4CAAF),
          UINT32_C(0x8D8FC354), UINT32_C(0x29EB08A3), UINT32_C(0xED870516),
          UINT32_C(0xD1D31EBC), UINT32_C(0x89FD91CA)},
         {UINT32_C(0xEDE2494B), UINT32_C(0xD2F1F832), UINT32_C(0xFA8EEA95),
          UINT32_C(0xCFEE1D77), UINT32_C(0x3B0F005C), UINT32_C(0x13603C4A),
          UINT32_C(0xD9EF68F4), UINT32_C(0x6DF97F85)}},
        {{UINT32_C(0x55410512), UINT32_C(0x578FBC0A), UINT32_C(0xDEC79EEE),
          UINT32_C(0x1FA404F2), UINT32_C(0x92B60820), UINT32_C(0x201FE215),
          UINT32_C(0x0A56193A), UINT32_C(0x9A9B3CE8)},
         {UINT32_C(0x10B49800), UINT32_C(0x8A5ECCB9), UINT32_C(0xBFDB1D8E),
          UINT32_C(0xA7373AEB), UINT32_C(0x4944B5DF), UINT32_C(0x8996BEFA),
          UINT32_C(0x7B44246C), UINT32_C(0x3102D3C0)}},
        {{UINT32_C(0x449C09BE), UINT32_C(0xD4A853B7), UINT32_C(0x51DDB7FE),
          UINT32_C(0x1F7080A4), UINT32_C(0xE1C27FC1), UINT32_C(0x8A9DE52C),
          UINT32_C(0x0C58B99D), UINT32_C(0x6585B54F)},
         {UINT32_C(0xB5A4AB53), UINT32_C(0x8EEB0601), UINT32_C(0x48C73AC6),
          UINT32_C(0x977D658D), UINT32_C(0x3D9BD223), UINT32_C(0xD5DA0903),
          UINT32_C(0xBE115965), UINT32_C(0x881A5838)}},
        {{UINT32_C(0xEB3FC303), UINT32_C(0x8EB70B77), UINT32_C(0x98BDB841),
          UINT32_C(0xED1C4DEF), UINT32_C(0x997DE9E4), UINT32_C(0x13E6BE06),
          UINT32_C(0x9334D46D), UINT32_C(0x4A94C0A1)},
         {UINT32_C(0x0F867DAF), UINT32_C(0x184C17C8), UINT32_C(0x33A64148),
          UINT32_C(0x4A658026), UINT32_C(0x0AE3D4AA), UINT32_C(0xD177F009),
          UINT32_C(0x98ED12C0), UINT32_C(0x8134AC8F)}},
        {{UINT32_C(0x7A58DDEC), UINT32_C(0x7A308A00), UINT32_C(0xFDF92DF2),
          UINT32_C(0x74A15C5F), UINT32_C(0x21B4E345), UINT32_C(0x210D260E),
          UINT32_C(0xC651E31E), UINT32_C(0x6446715B)},
         {UINT32_C(0x10B905B6), UINT32_C(0xB1AF1F84), UINT32_C(0xA62D366F),
          UINT32_C(0xEF6CD0F2), UINT32_C(0xD1F6B7E3), UINT32_C(0x77E47B01),
          UINT32_C(0x2B95BD12), UINT32_C(0x0F38B280)}},
        {{UINT32_C(0x8CCCDAE6), UINT32_C(0x52DA30E1), UINT32_C(0xBD86A13A),
          UINT32_C(0x9F3D6636), UINT32_C(0xF4EA6151), UINT32_C(0xADFA00C5),
          UINT32_C(0x1EC37639), UINT32_C(0x6B93BFA0)},
         {UINT32_C(0xF8FE22FC), UINT32_C(0x443F0023), UINT32_C(0xA81FEACC),
          UINT32_C(0xCB7848A4), UINT32_C(0x517E9E61), UINT32_C(0xCE5E650A),
          UINT32_C(0xA1968E3D), UINT32_C(0x5842DB7D)}},
        {{UINT32_C(0x98C06F78), UINT32_C(0x61DDC694), UINT32_C(0x7985B1A2),
          UINT32_C(0x680FEDE9), UINT32_C(0xFB53A327), UINT32_C(0x214CD2B8),
          UINT32_C(0xE425132B), UINT32_C(0x98EAC0B3)},
         {UINT32_C(0x33E5766D), UINT32_C(0x5EEDD76D), UINT32_C(0x540000A3),
          UINT32_C(0x5B280618), UINT32_C(0x65C894AE), UINT32_C(0x915D55CB),
          UINT32_C(0xD20D9523), UINT32_C(0x7B088A36)}},
        {{UINT32_C(0xC28DA278), UINT32_C(0x51A47312), UINT32_C(0xEFE64521),
          UINT32_C(0xE315CBA4), UINT32_C(0x49D8D0FF), UINT32_C(0x3EF70A18),
          UINT32_C(0xCABD48C5), UINT32_C(0x0990CB92)},
         {UINT32_C(0xA7C2FC76), UINT32_C(0x22ED6302), UINT32_C(0x2CB98186),
          UINT32_C(0xB50370EA), UINT32_C(0xF3F2BA8B), UINT32_C(0xDEA88C65),
          UINT32_C(0x09FEDEEA), UINT32_C(0x09062451)}},
        {{UINT32_C(0xDAC0F222), UINT32_C(0x742F9A2E), UINT32_C(0x95C88A8E),
          UINT32_C(0xE2A8842B), UINT32_C(0x9D817B14), UINT32_C(0x80C05765),
          UINT32_C(0x982D49AE), UINT32_C(0x7ED0521A)},
         {UINT32_C(0x907B10F7), UINT32_C(0x047E49D4), UINT32_C(0xDE8AD4CD),
          UINT32_C(0x8A3E23A7), UINT32_C(0xEB5292B1), UINT32_C(0xEBE8C13F),
          UINT32_C(0xA7EB70BD), UINT32_C(0x048A6209)}},
        {{UINT32_C(0x9AA34851), UINT32_C(0xB51665A0), UINT32_C(0x7C4AFCEE),
          UINT32_C(0x4DD5AC1B), UINT32_C(0x25A21937), UINT32_C(0x00DEE7AB),
          UINT32_C(0x80FAF232), UINT32_C(0x88E2681E)},
         {UINT32_C(0xB5411EE2), UINT32_C(0x79ECD66A), UINT32_C(0xF370BF53),
          UINT32_C(0x06008CE3), UINT32_C(0xC9BBB64C), UINT32_C(0xCFB1850E),
          UINT32_C(0x7149B14E), UINT32_C(0x5FBACB27)}},
        {{UINT32_C(0x9938AA0C), UINT32_C(0xA1F0EE07), UINT32_C(0x74CCE9C4),
          UINT32_C(0x6945E2BA), UINT32_C(0x46A98BEA), UINT32_C(0x16689FCE),
          UINT32_C(0xCF67DF91), UINT32_C(0x8D71F405)},
         {UINT32_C(0x69621150), UINT32_C(0x71E4CAC8), UINT32_C(0x89B380D8),
          UINT32_C(0x518FA200), UINT32_C(0x53F9E660), UINT32_C(0x3B3B85F1),
          UINT32_C(0xC6D9B022), UINT32_C(0x02643303)}},
        {{UINT32_C(0x07660C3E), UINT32_C(0xE8C478EC), UINT32_C(0xEF41F1DA),
          UINT32_C(0xA906C3A1), UINT32_C(0x46699B71), UINT32_C(0xE918F160),
          UINT32_C(0xE5BE7B36), UINT32_C(0x2B8A0B0E)},
         {UINT32_C(0x889F50A0), UINT32_C(0xC663F0EC), UINT32_C(0xF9214F81),
          UINT32_C(0x7413264B), UINT32_C(0x421A9087), UINT32_C(0x2E9FA9A0),
          UINT32_C(0x83546DCD), UINT32_C(0x85C59B7C)}},
        {{UINT32_C(0x8D920A29), UINT32_C(0xB4A6CF39), UINT32_C(0x1B3956A1),
          UINT32_C(0xC857AF48), UINT32_C(0xDD794B23), UINT32_C(0x519C7371),
          UINT32_C(0x8EFBF8F9), UINT32_C(0x47846220)},
         {UINT32_C(0x617E4C6C), UINT32_C(0x184C25E5), UINT32_C(0xD2E51A5E),
          UINT32_C(0x218FCC23), UINT32_C(0x28FA0FFC), UINT32_C(0xB4219719),
          UINT32_C(0x781A61D9), UINT32_C(0x6C0BCD71)}},
        {{UINT32_C(0xDC7B5568), UINT32_C(0x440D6DDF), UINT32_C(0x0DBBEC7C),
          UINT32_C(0x64C7CC31), UINT32_C(0xA2DC0CBA), UINT32_C(0x63D16D4E),
          UINT32_C(0x4504BE2C), UINT32_C(0x7BD9E0CC)},
         {UINT32_C(0x2DE780A8), UINT32_C(0x9C882895), UINT32_C(0xEF2B2486),
          UINT32_C(0x7C6685C2), UINT32_C(0x957FA7D8), UINT32_C(0xF1FB09E9),
          UINT32_C(0x46A77A98), UINT32_C(0x20C6B5A5)}},
        {{UINT32_C(0x33C0F0C1), UINT32_C(0x60C77573), UINT32_C(0xCADDA5FE),
          UINT32_C(0x40C93227), UINT32_C(0x9DD41D5F), UINT32_C(0xA48EBAA2),
          UINT32_C(0xEA9FD5AD), UINT32_C(0x4AAFBF3C)},
         {UINT32_C(0xC5A287BA), UINT32_C(0x7EB61836), UINT32_C(0xB31BA25E),
          UINT32_C(0x1D6A1BA2), UINT32_C(0xAD186E52), UINT32_C(0x60507257),
          UINT32_C(0x2BAB7451), UINT32_C(0x7FEC8EB0)}},
    },
    {
        {{UINT32_C(0xB8DA5FFE), UINT32_C(0x500E2FDB), UINT32_C(0x8CDD1B39),
          UINT32_C(0x6AE2D4EA), UINT32_C(0x1A5840CD), UINT32_C(0x38D12025),
          UINT32_C(0xC214D26D), UINT32_C(0x8D3B20CB)},
         {UINT32_C(0xC041E874), UINT32_C(0xEF6BB36C), UINT32_C(0x450F2218),
          UINT32_C(0x67660393), UINT32_C(0xA892BDFD), UINT32_C(0x1E1B7782),
          UINT32_C(0x8D962E62), UINT32_C(0x2D69514C)}},
        {{UINT32_C(0x9631B095), UINT32_C(0x9EDF5F78), UINT32_C(0x45BF8F20),
          UINT32_C(0xAC7DD687), UINT32_C(0xE3262EBC), UINT32_C(0x257CCE28),
          UINT32_C(0xE0E480A6), UINT32_C(0x5D32EFCB)},
         {UINT32_C(0x6FBB99E8), UINT32_C(0xED48E34C), UINT32_C(0x23FDE9B7),
          UINT32_C(0x50B1D58C), UINT32_C(0x6B6927C8), UINT32_C(0xC5164C2A),
          UINT32_C(0x8906B705), UINT32_C(0x8A0BC606)}},
        {{UINT32_C(0x2F747DA8), UINT32_C(0x3FA3C7C9), UINT32_C(0x14938E08),
          UINT32_C(0x2E8D2C2E), UINT32_C(0xB6A1C720), UINT32_C(0x155A8A5B),
          UINT32_C(0xB3133FD0), UINT32_C(0x6B4D8C9E)},
         {UINT32_C(0xCE131C1D), UINT32_C(0x079AC7F1), UINT32_C(0x815B7D2B),
          UINT32_C(0x9CF419AF), UINT32_C(0xE60B6245), UINT32_C(0x569EB7BA),
          UINT32_C(0x9A3DD94E), UINT32_C(0x03C79E60)}},
        {{UINT32_C(0xB9CE9502), UINT32_C(0x328F5296), UINT32_C(0xE45C3576),
          UINT32_C(0xCA44ADBD), UINT32_C(0x6194AE2C), UINT32_C(0x66987952),
          UINT32_C(0xBF9B8C49), UINT32_C(0x5875F8EF)},
         {UINT32_C(0xDA51CAB8), UINT32_C(0x525A4D53), UINT32_C(0x9DC268B2),
          UINT32_C(0x91A592DD), UINT32_C(0xE1E3C168), UINT32_C(0xD7EA7958),
          UINT32_C(0xA999ED30), UINT32_C(0x0D1E20E0)}},
        {{UINT32_C(0xFE8AD270), UINT32_C(0x55DA34E5), UINT32_C(0x61EC55F6),
          UINT32_C(0xB0412895), UINT32_C(0x534569C9), UINT32_C(0x0D45670F),
          UINT32_C(0xE23F69FB), UINT32_C(0x5A7E6764)},
         {UINT32_C(0xA8B28676), UINT32_C(0xBB6BBEC9), UINT32_C(0x093B0D1D),
          UINT32_C(0x4F924558), UINT32_C(0x0C29D841), UINT32_C(0xD4E4BF12),
          UINT32_C(0x578A237A), UINT32_C(0x67D2B4C8)}},
        {{UINT32_C(0x63EF2D73), UINT32_C(0x0BDF32D6), UINT32_C(0x4AE4303C),
          UINT32_C(0x7248DD2D), UINT32_C(0x6CE1E92A), UINT32_C(0xBB61BAB5),
          UINT32_C(0x1D7B9A6C), UINT32_C(0x126166E9)},
         {UINT32_C(0x11CEBC3C), UINT32_C(0x4CE7086A), UINT32_C(0x1C71426F),
          UINT32_C(0xE7ACB25E), UINT32_C(0x432CC4AF), UINT32_C(0xBFB65EDC),
          UINT32_C(0xCB018CF7), UINT32_C(0x3BCA5202)}},
        {{UINT32_C(0x76430A87), UINT32_C(0xACF034F2), UINT32_C(0x534C42ED),
          UINT32_C(0xBFDF19B3), UINT32_C(0x7946CB1A), UINT32_C(0x05654FE6),
          UINT32_C(0x80F17880), UINT32_C(0x0DB07E79)},
         {UINT32_C(0xFDCF8BC9), UINT32_C(0xE6E93101), UINT32_C(0xF798A8CD),
          UINT32_C(0xF3198B87), UINT32_C(0xC9683420), UINT32_C(0xC05444EF),
          UINT32_C(0x915D1BF1), UINT32_C(0x56E9AA68)}},
        {{UINT32_C(0x34000B11), UINT32_C(0xF27B298B), UINT32_C(0xF4196E50),
          UINT32_C(0x70ED8C95), UINT32_C(0x233C8764), UINT32_C(0xF3E16608),
          UINT32_C(0x41881557), UINT32_C(0x5B97655A)},
         {UINT32_C(0x128C195B), UINT32_C(0x5BF11C1A), UINT32_C(0x372C286D),
          UINT32_C(0xFFB64333), UINT32_C(0x7C83BB31), UINT32_C(0x084D3EF7),
          UINT32_C(0x745B7D75), UINT32_C(0x8ECF6C01)}},
        {{UINT32_C(0xC6F4FF82), UINT32_C(0x3D6052B9), UINT32_C(0x6607892F),
          UINT32_C(0x9305FE45), UINT32_C(0x5879425F), UINT32_C(0x232FD87E),
          UINT32_C(0xD6F47350), UINT32_C(0x4CAEDF73)},
         {UINT32_C(0x032FC50D), UINT32_C(0x889243D2), UINT32_C(0x0C9C11AC),
          UINT32_C(0xA6AF69D7), UINT32_C(0x802E8E06), UINT32_C(0x43B5429D),
          UINT32_C(0xD70FC802), UINT32_C(0x38F1DEA8)}},
        {{UINT32_C(0xC9595C08), UINT32_C(0x54F24344), UINT32_C(0x0240AAB3),
          UINT32_C(0x95A2E8FB), UINT32_C(0xC3544985), UINT32_C(0x07A5109D),
          UINT32_C(0xB5D30899), UINT32_C(0x96F44213)},
         {UINT32_C(0xAA347497), UINT32_C(0x03FAB192), UINT32_C(0xC9CFC073),
          UINT32_C(0x47FFD3DE), UINT32_C(0xD2C1D57F), UINT32_C(0x283AD765),
          UINT32_C(0x62DC271A), UINT32_C(0x1FDFFBAC)}},
        {{UINT32_C(0x95F80CA6), UINT32_C(0x2355C629), UINT32_C(0xCD8D880A),
          UINT32_C(0x90AE1DBB), UINT32_C(0xC54117E0), UINT32_C(0x563CC122),
          UINT32_C(0x813D7481), UINT32_C(0x1EF4991B)},
         {UINT32_C(0xCCE9AEDE), UINT32_C(0x8A310D77), UINT32_C(0x9318642E),
          UINT32_C(0xA401FAEF), UINT32_C(0xCF9AFDCB), UINT32_C(0xC1712A67),
          UINT32_C(0xBE499DE5), UINT32_C(0x8D97374C)}},
        {{UINT32_C(0x55A0BC07), UINT32_C(0x7437AA3B), UINT32_C(0xF726DD81),
          UINT32_C(0x004946D0), UINT32_C(0x0F341860), UINT32_C(0x33D41D1B),
          UINT32_C(0x17840F0D), UINT32_C(0x2A009EB5)},
         {UINT32_C(0xAA0DCDCF), UINT32_C(0x158F59AE), UINT32_C(0xEAB42135),
          UINT32_C(0xF686EF2D), UINT32_C(0x7A80C670), UINT32_C(0xFF6B8E82),
          UINT32_C(0xA04DF944), UINT32_C(0x38646963)}},
        {{UINT32_C(0x4B987E90), UINT32_C(0x6BB2705E), UINT32_C(0xD3C36316),
          UINT32_C(0x2F5E2C4D), UINT32_C(0xE5A9ECEC), UINT32_C(0x41B38905),
          UINT32_C(0x55BF8D1A), UINT32_C(0x2C6BA681)},
         {UINT32_C(0x3C92B20B), UINT32_C(0x1121B3B2), UINT32_C(0x904305D5),
          UINT32_C(0x6DE41B12), UINT32_C(0xD569EAC4), UINT32_C(0xA0496CF4),
          UINT32_C(0x11E5CF90), UINT32_C(0x5C64A06C)}},
        {{UINT32_C(0xE28783DF), UINT32_C(0xA65F12AB), UINT32_C(0x37322285),
          UINT32_C(0x2A891B0F), UINT32_C(0x9811C4EB), UINT32_C(0xD6FF4604),
          UINT32_C(0xA8505AC0), UINT32_C(0x7C960ED5)},
         {UINT32_C(0x2FCA110D), UINT32_C(0xE8689377), UINT32_C(0x60FD893E),
          UINT32_C(0x71AAE292), UINT32_C(0x7505671D), UINT32_C(0x8ADE5317),
          UINT32_C(0x8C508791), UINT32_C(0x721A07A5)}},
        {{UINT32_C(0xE5ECCA8C), UINT32_C(0xC1AE9A50), UINT32_C(0x07EB4329),
          UINT32_C(0x7528AEF5), UINT32_C(0xD1297D88), UINT32_C(0x8F0D0E03),
          UINT32_C(0x244BBC0C), UINT32_C(0x27C7BF76)},
         {UINT32_C(0xC7E7E9BB), UINT32_C(0x96EEDA7C), UINT32_C(0xF96C99B3),
          UINT32_C(0xC9749BF7), UINT32_C(0x467B4D43), UINT32_C(0x44C852D2),
          UINT32_C(0x937FA21D), UINT32_C(0x1691D71D)}},
        {{UINT32_C(0xF8058A68), UINT32_C(0x8CAC092F), UINT32_C(0xDAE38445),
          UINT32_C(0x6B892BCF), UINT32_C(0x97D76059), UINT32_C(0x82CBECE5),
          UINT32_C(0x3518F9E2), UINT32_C(0x5AEB6646)},
         {UINT32_C(0x392080B4), UINT32_C(0xA39C710C), UINT32_C(0x1502DE54),
          UINT32_C(0x575DC5F4), UINT32_C(0x3A3D2B4D), UINT32_C(0xA465DD5E),
          UINT32_C(0x638EAF45), UINT32_C(0x281AAE47)}},
    },
    {
        {{UINT32_C(0xE955A145), UINT32_C(0xBE40C92B), UINT32_C(0x324234B5),
          UINT32_C(0xD464D6BC), UINT32_C(0xB09D4AF8), UINT32_C(0xE8084747),
          UINT32_C(0x5268D6C3), UINT32_C(0x939C70BF)},
         {UINT32_C(0xD1DDBB48), UINT32_C(0x9C9C9D25), UINT32_C(0x790B5B42),
          UINT32_C(0x30D9EA7F), UINT32_C(0x4E3914B4), UINT32_C(0x367FD79B),
          UINT32_C(0x826EE4D7), UINT32_C(0x27615F29)}},
        {{UINT32_C(0x50A41246), UINT32_C(0x09BB6F16), UINT32_C(0xE5459A13),
          UINT32_C(0xC72BFF7A), UINT32_C(0xFF09B2F7), UINT32_C(0x0FC15846),
          UINT32_C(0x09CB693A), UINT32_C(0x6D904062)},
         {UINT32_C(0xF40FC67D), UINT32_C(0x98A132F8), UINT32_C(0xDF37CBFA),
          UINT32_C(0xC8B6573B), UINT32_C(0x99D7FC36), UINT32_C(0xC9CF9948),
          UINT32_C(0xA7235DDB), UINT32_C(0x0DD66ABA)}},
        {{UINT32_C(0xF96048BD), UINT32_C(0x0180B525), UINT32_C(0x544F1E70),
          UINT32_C(0xEB566786), UINT32_C(0x8EF4373C), UINT32_C(0x8BABBF9B),
          UINT32_C(0xD9E49178), UINT32_C(0x509BA431)},
         {UINT32_C(0x65A4A201), UINT32_C(0xF961A6F5), UINT32_C(0x8D44ED2D),
          UINT32_C(0xB6621DF9), UINT32_C(0xD7B4D744), UINT32_C(0xEADD3C0C),
          UINT32_C(0x0EAAB110), UINT32_C(0x75D27E99)}},
        {{UINT32_C(0x85DF5695), UINT32_C(0xEAC7AC76), UINT32_C(0xDA7540A3),
          UINT32_C(0x02C26274), UINT32_C(0xC659B610), UINT32_C(0xDEC1BBC4),
          UINT32_C(0x3AC61EEB), UINT32_C(0x54483C1B)},
         {UINT32_C(0x217E0283), UINT32_C(0x8B91209A), UINT32_C(0x3A17DDFE),
          UINT32_C(0x939FBDAF), UINT32_C(0x5BF98726), UINT32_C(0xA82C66D6),
          UINT32_C(0x915AAC76), UINT32_C(0x2BA82FA0)}},
        {{UINT32_C(0xAF4542E8), UINT32_C(0x99B324C1), UINT32_C(0xC0F225E0),
          UINT32_C(0x16EBC66F), UINT32_C(0x27FEF57B), UINT32_C(0xEAE69563),
          UINT32_C(0x961B03FA), UINT32_C(0x2996FE3C)},
         {UINT32_C(0x4F967A68), UINT32_C(0x0835212E), UINT32_C(0xF44352DC),
          UINT32_C(0x0AAABD99), UINT32_C(0x4B3A6B8D), UINT32_C(0x1874255F),
          UINT32_C(0x6D10B369), UINT32_C(0x45F5D8B2)}},
        {{UINT32_C(0xF7B7644B), UINT32_C(0x603DD497), UINT32_C(0x2D1386AA),
          UINT32_C(0x369BE676), UINT32_C(0x14C9FA94), UINT32_C(0x08C1B763),
          UINT32_C(0x384AF696), UINT32_C(0x734921D9)},
         {UINT32_C(0xD76E8EEB), UINT32_C(0xA1B5AF5B), UINT32_C(0x42F990E8),
          UINT32_C(0xB0EAE7A3), UINT32_C(0x069ED81D), UINT32_C(0x59E7C515),
          UINT32_C(0xB5A50610), UINT32_C(0x2D1B5E62)}},
        {{UINT32_C(0x85995BD3), UINT32_C(0xDC322810), UINT32_C(0x873E7A09),
          UINT32_C(0x35A47B05), UINT32_C(0xA70DE932), UINT32_C(0x0CDFE9BB),
          UINT32_C(0xD62FBC89), UINT32_C(0x049B899D)},
         {UINT32_C(0x652291DB), UINT32_C(0xF6BAA860), UINT32_C(0x9AF7478F),
          UINT32_C(0x58123B25), UINT32_C(0x47B9F204), UINT32_C(0xA05CCBC2),
          UINT32_C(0x82D999A7), UINT32_C(0x8A0B479D)}},
        {{UINT32_C(0x2D0F619A), UINT32_C(0xA72B9B52), UINT32_C(0x5919C420),
          UINT32_C(0xE73B66F7), UINT32_C(0xD21CFEFE), UINT32_C(0x92319C86),
          UINT32_C(0xF1635F0E), UINT32_C(0x58EEFC71)},
         {UINT32_C(0xDA909290), UINT32_C(0xDC481783), UINT32_C(0x66316584),
          UINT32_C(0x144E7A98), UINT32_C(0x45E1E3C8), UINT32_C(0xBD7E657F),
          UINT32_C(0xBD93938C), UINT32_C(0x5C9FCD1C)}},
        {{UINT32_C(0x436C1AB3), UINT32_C(0x2339E2FA), UINT32_C(0xC26768AA),
          UINT32_C(0x69C22269), UINT32_C(0x40FCBD90), UINT32_C(0x94DFCAF4),
          UINT32_C(0xC41D4F61), UINT32_C(0x56235739)},
         {UINT32_C(0x718468D3), UINT32_C(0x6E50D4DB), UINT32_C(0xCADCEC6C),
          UINT32_C(0xDEA80730), UINT32_C(0x63DC3C43), UINT32_C(0x924FF97E),
          UINT32_C(0x6752EA6A), UINT32_C(0x1B652825)}},
        {{UINT32_C(0xF07BE4BB), UINT32_C(0xAC2BDCDD), UINT32_C(0x8DB0A32D),
          UINT32_C(0xB46D8E96), UINT32_C(0xB618488D), UINT32_C(0xDD661C68),
          UINT32_C(0x75E1E4BF), UINT32_C(0x8ED22D4B)},
         {UINT32_C(0x3C177D80), UINT32_C(0x5DD2E5DF), UINT32_C(0x82803711),
          UINT32_C(0x5049C012), UINT32_C(0x73E0BA27), UINT32_C(0xFB243B3F),
          UINT32_C(0x8C7810D5), UINT32_C(0x0C756BA0)}},
        {{UINT32_C(0x6F16FBCA), UINT32_C(0xFC58F0BD), UINT32_C(0xA5E33B36),
          UINT32_C(0xA855BB8C), UINT32_C(0x99D08247), UINT32_C(0xB9239EB4),
          UINT32_C(0x49CAF40D), UINT32_C(0x27ABC78D)},
         {UINT32_C(0xA1285278), UINT32_C(0x88BE1595), UINT32_C(0x60F16638),
          UINT32_C(0x9D5AEE5B), UINT32_C(0x1FCE4327), UINT32_C(0x3F381529),
          UINT32_C(0xF19CAA04), UINT32_C(0x17206899)}},
        {{UINT32_C(0x9E047F55), UINT32_C(0x58616348), UINT32_C(0xE991FC4C),
          UINT32_C(0x0D6098A5), UINT32_C(0x99A33914), UINT32_C(0x47760F98),
          UINT32_C(0x5608C80E), UINT32_C(0x70C8F5D4)},
         {UINT32_C(0x06036DBE), UINT32_C(0x405F1191), UINT32_C(0x80CC0A27),
          UINT32_C(0xBF625895), UINT32_C(0x389FA7BF), UINT32_C(0xFB8A0330),
          UINT32_C(0x1FA0CBB4), UINT32_C(0x22B0B946)}},
        {{UINT32_C(0x1B1E2ACD), UINT32_C(0x84AE1981), UINT32_C(0x63961891),
          UINT32_C(0xFA23C205), UINT32_C(0x742C1653), UINT32_C(0xCF4C685E),
          UINT32_C(0x4D303078), UINT32_C(0x55BFC744)},
         {UINT32_C(0xBA03AAE4), UINT32_C(0xEB131CBB), UINT32_C(0x2C5B9EAB),
          UINT32_C(0xF338C0DB), UINT32_C(0xB7495209), UINT32_C(0xC1006396),
          UINT32_C(0xF7E6A4E6), UINT32_C(0x0FD928CF)}},
        {{UINT32_C(0x8633AB84), UINT32_C(0xA6BAC994), UINT32_C(0x75364642),
          UINT32_C(0xC165BF5A), UINT32_C(0x8C57070D), UINT32_C(0xB70BEB47),
          UINT32_C(0xD416322E), UINT32_C(0x838158A0)},
         {UINT32_C(0xD4957751), UINT32_C(0x501D2BFD), UINT32_C(0xC23AA730),
          UINT32_C(0xF1CDDF32), UINT32_C(0x5458F1C6), UINT32_C(0xF64558A8),
          UINT32_C(0x06E1209C), UINT32_C(0x51B6DDE3)}},
        {{UINT32_C(0xCC31D6BE), UINT32_C(0x0712C186), UINT32_C(0x33CD1D3F),
          UINT32_C(0x91C4064A), UINT32_C(0xC7C91F53), UINT32_C(0xCADAE5B0),
          UINT32_C(0xDEB2A2EE), UINT32_C(0x52AA408F)},
         {UINT32_C(0x202719D5), UINT32_C(0x058675CC), UINT32_C(0x1D087D07),
          UINT32_C(0x444F99F5), UINT32_C(0x9D7A8AF4), UINT32_C(0x4DB587E8),
          UINT32_C(0xDA17095A), UINT32_C(0x389376F5)}},
        {{UINT32_C(0x48FED385), UINT32_C(0x8262D370), UINT32_C(0x1AE92689),
          UINT32_C(0x3B1FB466), UINT32_C(0x24242CF4), UINT32_C(0xDA6F570F),
          UINT32_C(0x0DEAC5E9), UINT32_C(0x0532FC9E)},
         {UINT32_C(0x20C5BD7B), UINT32_C(0x5E8FB740), UINT32_C(0x002624B3),
          UINT32_C(0x5AE99925), UINT32_C(0x7AFADC15), UINT32_C(0xAD44A4D5),
          UINT32_C(0xDF409330), UINT32_C(0x6AECBC80)}},
    }};

/*-
 * Q := 2P, both projective, Q and P same pointers OK
 * Autogenerated: op3/dbl_proj.op3
 * https://eprint.iacr.org/2015/1060 Alg 6
 * ASSERT: a = -3
 */
static void point_double(pt_prj_t *Q, const pt_prj_t *P) {
    /* temporary variables */
    fe_t t0, t1, t2, t3, t4;
    /* constants */
    const limb_t *b = const_b;
    /* set pointers for legacy curve arith */
    const limb_t *X = P->X;
    const limb_t *Y = P->Y;
    const limb_t *Z = P->Z;
    limb_t *X3 = Q->X;
    limb_t *Y3 = Q->Y;
    limb_t *Z3 = Q->Z;

    /* the curve arith formula */
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(t0, X);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(t1, Y);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_square(t2, Z);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t3, X, Y);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t3, t3, t3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t4, Y, Z);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(Z3, X, Z);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Z3, Z3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(Y3, b, t2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(Y3, Y3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(X3, Y3, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Y3, X3, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(X3, t1, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Y3, t1, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(Y3, X3, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(X3, X3, t3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t3, t2, t2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t2, t2, t3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(Z3, b, Z3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(Z3, Z3, t2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(Z3, Z3, t0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t3, Z3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Z3, Z3, t3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t3, t0, t0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t0, t3, t0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(t0, t0, t2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t0, t0, Z3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Y3, Y3, t0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t0, t4, t4);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(Z3, t0, Z3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(X3, X3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(Z3, t0, t1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Z3, Z3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Z3, Z3, Z3);
}

/*-
 * R := Q + P where R and Q are projective, P affine.
 * R and Q same pointers OK
 * R and P same pointers not OK
 * Autogenerated: op3/add_mixed.op3
 * https://eprint.iacr.org/2015/1060 Alg 5
 * ASSERT: a = -3
 */
static void point_add_mixed(pt_prj_t *R, const pt_prj_t *Q, const pt_aff_t *P) {
    /* temporary variables */
    fe_t t0, t1, t2, t3, t4;
    /* constants */
    const limb_t *b = const_b;
    /* set pointers for legacy curve arith */
    const limb_t *X1 = Q->X;
    const limb_t *Y1 = Q->Y;
    const limb_t *Z1 = Q->Z;
    const limb_t *X2 = P->X;
    const limb_t *Y2 = P->Y;
    fe_t X3;
    fe_t Y3;
    fe_t Z3;
    limb_t nz;

    /* check P for affine inf */
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_nonzero(&nz, P->Y);

    /* the curve arith formula */
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t0, X1, X2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t1, Y1, Y2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t3, X2, Y2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t4, X1, Y1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t3, t3, t4);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t4, t0, t1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(t3, t3, t4);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t4, Y2, Z1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t4, t4, Y1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(Y3, X2, Z1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Y3, Y3, X1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(Z3, b, Z1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(X3, Y3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Z3, X3, X3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(X3, X3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(Z3, t1, X3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(X3, t1, X3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(Y3, b, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t1, Z1, Z1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t2, t1, Z1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(Y3, Y3, t2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(Y3, Y3, t0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t1, Y3, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Y3, t1, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t1, t0, t0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t0, t1, t0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(t0, t0, t2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t1, t4, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t2, t0, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(Y3, X3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Y3, Y3, t2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(X3, t3, X3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(X3, X3, t1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(Z3, t4, Z3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t1, t3, t0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Z3, Z3, t1);

    /* if P is inf, throw all that away and take Q */
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(R->X, nz, Q->X, X3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(R->Y, nz, Q->Y, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(R->Z, nz, Q->Z, Z3);
}

/*-
 * R := Q + P all projective.
 * R and Q same pointers OK
 * R and P same pointers not OK
 * Autogenerated: op3/add_proj.op3
 * https://eprint.iacr.org/2015/1060 Alg 4
 * ASSERT: a = -3
 */
static void point_add_proj(pt_prj_t *R, const pt_prj_t *Q, const pt_prj_t *P) {
    /* temporary variables */
    fe_t t0, t1, t2, t3, t4, t5;
    /* constants */
    const limb_t *b = const_b;
    /* set pointers for legacy curve arith */
    const limb_t *X1 = Q->X;
    const limb_t *Y1 = Q->Y;
    const limb_t *Z1 = Q->Z;
    const limb_t *X2 = P->X;
    const limb_t *Y2 = P->Y;
    const limb_t *Z2 = P->Z;
    limb_t *X3 = R->X;
    limb_t *Y3 = R->Y;
    limb_t *Z3 = R->Z;

    /* the curve arith formula */
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t0, X1, X2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t1, Y1, Y2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t2, Z1, Z2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t3, X1, Y1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t4, X2, Y2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t3, t3, t4);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t4, t0, t1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(t3, t3, t4);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t4, Y1, Z1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t5, Y2, Z2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t4, t4, t5);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t5, t1, t2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(t4, t4, t5);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(X3, X1, Z1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Y3, X2, Z2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(X3, X3, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Y3, t0, t2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(Y3, X3, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(Z3, b, t2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(X3, Y3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Z3, X3, X3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(X3, X3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(Z3, t1, X3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(X3, t1, X3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(Y3, b, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t1, t2, t2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t2, t1, t2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(Y3, Y3, t2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(Y3, Y3, t0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t1, Y3, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Y3, t1, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t1, t0, t0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(t0, t1, t0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(t0, t0, t2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t1, t4, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t2, t0, Y3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(Y3, X3, Z3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Y3, Y3, t2);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(X3, t3, X3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_sub(X3, X3, t1);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(Z3, t4, Z3);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(t1, t3, t0);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_add(Z3, Z3, t1);
}

/* constants */
#define RADIX 5
#define DRADIX (1 << RADIX)
#define DRADIX_WNAF ((DRADIX) << 1)

/*-
 * precomp for wnaf scalar multiplication:
 * precomp[0] = 1P
 * precomp[1] = 3P
 * precomp[2] = 5P
 * precomp[3] = 7P
 * precomp[4] = 9P
 * ...
 */
static void precomp_wnaf(pt_prj_t precomp[DRADIX / 2], const pt_aff_t *P) {
    int i;

    fe_copy(precomp[0].X, P->X);
    fe_copy(precomp[0].Y, P->Y);
    fe_copy(precomp[0].Z, const_one);
    point_double(&precomp[DRADIX / 2 - 1], &precomp[0]);

    for (i = 1; i < DRADIX / 2; i++)
        point_add_proj(&precomp[i], &precomp[DRADIX / 2 - 1], &precomp[i - 1]);
}

/* fetch a scalar bit */
static int scalar_get_bit(const unsigned char in[32], int idx) {
    int widx, rshift;

    widx = idx >> 3;
    rshift = idx & 0x7;

    if (idx < 0 || widx >= 32) return 0;

    return (in[widx] >> rshift) & 0x1;
}

/*-
 * Compute "regular" wnaf representation of a scalar.
 * See "Exponent Recoding and Regular Exponentiation Algorithms",
 * Tunstall et al., AfricaCrypt 2009, Alg 6.
 * It forces an odd scalar and outputs digits in
 * {\pm 1, \pm 3, \pm 5, \pm 7, \pm 9, ...}
 * i.e. signed odd digits with _no zeroes_ -- that makes it "regular".
 */
static void scalar_rwnaf(int8_t out[52], const unsigned char in[32]) {
    int i;
    int8_t window, d;

    window = (in[0] & (DRADIX_WNAF - 1)) | 1;
    for (i = 0; i < 51; i++) {
        d = (window & (DRADIX_WNAF - 1)) - DRADIX;
        out[i] = d;
        window = (window - d) >> RADIX;
        window += scalar_get_bit(in, (i + 1) * RADIX + 1) << 1;
        window += scalar_get_bit(in, (i + 1) * RADIX + 2) << 2;
        window += scalar_get_bit(in, (i + 1) * RADIX + 3) << 3;
        window += scalar_get_bit(in, (i + 1) * RADIX + 4) << 4;
        window += scalar_get_bit(in, (i + 1) * RADIX + 5) << 5;
    }
    out[i] = window;
}

/*-
 * Compute "textbook" wnaf representation of a scalar.
 * NB: not constant time
 */
static void scalar_wnaf(int8_t out[257], const unsigned char in[32]) {
    int i;
    int8_t window, d;

    window = in[0] & (DRADIX_WNAF - 1);
    for (i = 0; i < 257; i++) {
        d = 0;
        if ((window & 1) && ((d = window & (DRADIX_WNAF - 1)) & DRADIX))
            d -= DRADIX_WNAF;
        out[i] = d;
        window = (window - d) >> 1;
        window += scalar_get_bit(in, i + 1 + RADIX) << RADIX;
    }
}

/*-
 * Simultaneous scalar multiplication: interleaved "textbook" wnaf.
 * NB: not constant time
 */
static void var_smul_wnaf_two(pt_aff_t *out, const unsigned char a[32],
                              const unsigned char b[32], const pt_aff_t *P) {
    int i, d, is_neg, is_inf = 1, flipped = 0;
    int8_t anaf[257] = {0};
    int8_t bnaf[257] = {0};
    pt_prj_t Q = {0};
    pt_prj_t precomp[DRADIX / 2];

    precomp_wnaf(precomp, P);
    scalar_wnaf(anaf, a);
    scalar_wnaf(bnaf, b);

    for (i = 256; i >= 0; i--) {
        if (!is_inf) point_double(&Q, &Q);
        if ((d = bnaf[i])) {
            if ((is_neg = d < 0) != flipped) {
                fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_opp(Q.Y, Q.Y);
                flipped ^= 1;
            }
            d = (is_neg) ? (-d - 1) >> 1 : (d - 1) >> 1;
            if (is_inf) {
                /* initialize accumulator */
                fe_copy(Q.X, &precomp[d].X);
                fe_copy(Q.Y, &precomp[d].Y);
                fe_copy(Q.Z, &precomp[d].Z);
                is_inf = 0;
            } else
                point_add_proj(&Q, &Q, &precomp[d]);
        }
        if ((d = anaf[i])) {
            if ((is_neg = d < 0) != flipped) {
                fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_opp(Q.Y, Q.Y);
                flipped ^= 1;
            }
            d = (is_neg) ? (-d - 1) >> 1 : (d - 1) >> 1;
            if (is_inf) {
                /* initialize accumulator */
                fe_copy(Q.X, &lut_cmb[0][d].X);
                fe_copy(Q.Y, &lut_cmb[0][d].Y);
                fe_copy(Q.Z, const_one);
                is_inf = 0;
            } else
                point_add_mixed(&Q, &Q, &lut_cmb[0][d]);
        }
    }

    if (is_inf) {
        /* initialize accumulator to inf: all-zero scalars */
        fe_set_zero(Q.X);
        fe_copy(Q.Y, const_one);
        fe_set_zero(Q.Z);
    }

    if (flipped) {
        /* correct sign */
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_opp(Q.Y, Q.Y);
    }

    /* convert to affine -- NB depends on coordinate system */
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_inv(Q.Z, Q.Z);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(out->X, Q.X, Q.Z);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(out->Y, Q.Y, Q.Z);
}

/*-
 * Variable point scalar multiplication with "regular" wnaf.
 */
static void var_smul_rwnaf(pt_aff_t *out, const unsigned char scalar[32],
                           const pt_aff_t *P) {
    int i, j, d, diff, is_neg;
    int8_t rnaf[52] = {0};
    pt_prj_t Q = {0}, lut = {0};
    pt_prj_t precomp[DRADIX / 2];

    precomp_wnaf(precomp, P);
    scalar_rwnaf(rnaf, scalar);

#if defined(_MSC_VER)
    /* result still unsigned: yes we know */
#pragma warning(push)
#pragma warning(disable : 4146)
#endif

    /* initialize accumulator to high digit */
    d = (rnaf[51] - 1) >> 1;
    for (j = 0; j < DRADIX / 2; j++) {
        diff = (1 - (-(d ^ j) >> (8 * sizeof(int) - 1))) & 1;
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(Q.X, diff, Q.X,
                                                              precomp[j].X);
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(Q.Y, diff, Q.Y,
                                                              precomp[j].Y);
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(Q.Z, diff, Q.Z,
                                                              precomp[j].Z);
    }

    for (i = 50; i >= 0; i--) {
        for (j = 0; j < RADIX; j++) point_double(&Q, &Q);
        d = rnaf[i];
        /* is_neg = (d < 0) ? 1 : 0 */
        is_neg = (d >> (8 * sizeof(int) - 1)) & 1;
        /* d = abs(d) */
        d = (d ^ -is_neg) + is_neg;
        d = (d - 1) >> 1;
        for (j = 0; j < DRADIX / 2; j++) {
            diff = (1 - (-(d ^ j) >> (8 * sizeof(int) - 1))) & 1;
            fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(
                lut.X, diff, lut.X, precomp[j].X);
            fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(
                lut.Y, diff, lut.Y, precomp[j].Y);
            fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(
                lut.Z, diff, lut.Z, precomp[j].Z);
        }
        /* negate lut point if digit is negative */
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_opp(out->Y, lut.Y);
        fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(lut.Y, is_neg,
                                                              lut.Y, out->Y);
        point_add_proj(&Q, &Q, &lut);
    }

#if defined(_MSC_VER)
#pragma warning(pop)
#endif

    /* conditionally subtract P if the scalar was even */
    fe_copy(lut.X, precomp[0].X);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_opp(lut.Y, precomp[0].Y);
    fe_copy(lut.Z, precomp[0].Z);
    point_add_proj(&lut, &lut, &Q);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(Q.X, scalar[0] & 1,
                                                          lut.X, Q.X);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(Q.Y, scalar[0] & 1,
                                                          lut.Y, Q.Y);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(Q.Z, scalar[0] & 1,
                                                          lut.Z, Q.Z);

    /* convert to affine -- NB depends on coordinate system */
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_inv(Q.Z, Q.Z);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(out->X, Q.X, Q.Z);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(out->Y, Q.Y, Q.Z);
}

/*-
 * Fixed scalar multiplication: comb with interleaving.
 */
static void fixed_smul_cmb(pt_aff_t *out, const unsigned char scalar[32]) {
    int i, j, k, d, diff, is_neg = 0;
    int8_t rnaf[52] = {0};
    pt_prj_t Q = {0}, R = {0};
    pt_aff_t lut = {0};

    scalar_rwnaf(rnaf, scalar);

    /* initalize accumulator to inf */
    fe_set_zero(Q.X);
    fe_copy(Q.Y, const_one);
    fe_set_zero(Q.Z);

#if defined(_MSC_VER)
    /* result still unsigned: yes we know */
#pragma warning(push)
#pragma warning(disable : 4146)
#endif

    for (i = 1; i >= 0; i--) {
        for (j = 0; i != 1 && j < RADIX; j++) point_double(&Q, &Q);
        for (j = 0; j < 27; j++) {
            if (j * 2 + i > 51) continue;
            d = rnaf[j * 2 + i];
            /* is_neg = (d < 0) ? 1 : 0 */
            is_neg = (d >> (8 * sizeof(int) - 1)) & 1;
            /* d = abs(d) */
            d = (d ^ -is_neg) + is_neg;
            d = (d - 1) >> 1;
            for (k = 0; k < DRADIX / 2; k++) {
                diff = (1 - (-(d ^ k) >> (8 * sizeof(int) - 1))) & 1;
                fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(
                    lut.X, diff, lut.X, lut_cmb[j][k].X);
                fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(
                    lut.Y, diff, lut.Y, lut_cmb[j][k].Y);
            }
            /* negate lut point if digit is negative */
            fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_opp(out->Y, lut.Y);
            fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(
                lut.Y, is_neg, lut.Y, out->Y);
            point_add_mixed(&Q, &Q, &lut);
        }
    }

#if defined(_MSC_VER)
#pragma warning(pop)
#endif

    /* conditionally subtract P if the scalar was even */
    fe_copy(lut.X, lut_cmb[0][0].X);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_opp(lut.Y, lut_cmb[0][0].Y);
    point_add_mixed(&R, &Q, &lut);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(Q.X, scalar[0] & 1,
                                                          R.X, Q.X);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(Q.Y, scalar[0] & 1,
                                                          R.Y, Q.Y);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_selectznz(Q.Z, scalar[0] & 1,
                                                          R.Z, Q.Z);

    /* convert to affine -- NB depends on coordinate system */
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_inv(Q.Z, Q.Z);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(out->X, Q.X, Q.Z);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_mul(out->Y, Q.Y, Q.Z);
}

/*-
 * Wrapper: simultaneous scalar mutiplication.
 * outx, outy := a * G + b * P
 * where P = (inx, iny).
 * Everything is LE byte ordering.
 */
static void point_mul_two(unsigned char outx[32], unsigned char outy[32],
                          const unsigned char a[32], const unsigned char b[32],
                          const unsigned char inx[32],
                          const unsigned char iny[32]) {
    pt_aff_t P;

    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_from_bytes(P.X, inx);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_from_bytes(P.Y, iny);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_to_montgomery(P.X, P.X);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_to_montgomery(P.Y, P.Y);
    /* simultaneous scalar multiplication */
    var_smul_wnaf_two(&P, a, b, &P);

    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_from_montgomery(P.X, P.X);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_from_montgomery(P.Y, P.Y);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_to_bytes(outx, P.X);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_to_bytes(outy, P.Y);
}

/*-
 * Wrapper: fixed scalar mutiplication.
 * outx, outy := scalar * G
 * Everything is LE byte ordering.
 */
static void point_mul_g(unsigned char outx[32], unsigned char outy[32],
                        const unsigned char scalar[32]) {
    pt_aff_t P;

    /* fixed scmul function */
    fixed_smul_cmb(&P, scalar);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_from_montgomery(P.X, P.X);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_from_montgomery(P.Y, P.Y);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_to_bytes(outx, P.X);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_to_bytes(outy, P.Y);
}

/*-
 * Wrapper: variable point scalar mutiplication.
 * outx, outy := scalar * P
 * where P = (inx, iny).
 * Everything is LE byte ordering.
 */
static void point_mul(unsigned char outx[32], unsigned char outy[32],
                      const unsigned char scalar[32],
                      const unsigned char inx[32],
                      const unsigned char iny[32]) {
    pt_aff_t P;

    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_from_bytes(P.X, inx);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_from_bytes(P.Y, iny);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_to_montgomery(P.X, P.X);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_to_montgomery(P.Y, P.Y);
    /* var scmul function */
    var_smul_rwnaf(&P, scalar, &P);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_from_montgomery(P.X, P.X);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_from_montgomery(P.Y, P.Y);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_to_bytes(outx, P.X);
    fiat_id_GostR3410_2001_CryptoPro_C_ParamSet_to_bytes(outy, P.Y);
}


#include <openssl/ec.h>

/* the zero field element */
static const unsigned char const_zb[32] = {0};

/*-
 * An OpenSSL wrapper for simultaneous scalar multiplication.
 * r := n * G + m * q
 */
    int
    point_mul_two_id_GostR3410_2001_CryptoPro_C_ParamSet(
        const EC_GROUP *group, EC_POINT *r, const BIGNUM *n, const EC_POINT *q,
        const BIGNUM *m, BN_CTX *ctx) {
    int ret = 0;
    unsigned char b_x[32];
    unsigned char b_y[32];
    unsigned char b_n[32];
    unsigned char b_m[32];
    BIGNUM *x = NULL, *y = NULL;

    BN_CTX_start(ctx);
    x = BN_CTX_get(ctx);
    if ((y = BN_CTX_get(ctx)) == NULL
        /* pull out coords as bytes */
        || !EC_POINT_get_affine_coordinates(group, q, x, y, ctx) ||
        BN_bn2lebinpad(x, b_x, 32) != 32 || BN_bn2lebinpad(y, b_y, 32) != 32 ||
        BN_bn2lebinpad(n, b_n, 32) != 32 || BN_bn2lebinpad(m, b_m, 32) != 32)
        goto err;
    /* do the simultaneous scalar multiplication */
    point_mul_two(b_x, b_y, b_n, b_m, b_x, b_y);
    /* check for infinity */
    if (CRYPTO_memcmp(const_zb, b_x, 32) == 0 &&
        CRYPTO_memcmp(const_zb, b_y, 32) == 0) {
        if (!EC_POINT_set_to_infinity(group, r)) goto err;
    } else {
        /* otherwise, pack the bytes into the result */
        if (BN_lebin2bn(b_x, 32, x) == NULL ||
            BN_lebin2bn(b_y, 32, y) == NULL ||
            !EC_POINT_set_affine_coordinates(group, r, x, y, ctx))
            goto err;
    }
    ret = 1;
err:
    BN_CTX_end(ctx);
    return ret;
}

/*-
 * An OpenSSL wrapper for variable point scalar multiplication.
 * r := m * q
 */
    int
    point_mul_id_GostR3410_2001_CryptoPro_C_ParamSet(const EC_GROUP *group,
                                                     EC_POINT *r,
                                                     const EC_POINT *q,
                                                     const BIGNUM *m,
                                                     BN_CTX *ctx) {
    int ret = 0;
    unsigned char b_x[32];
    unsigned char b_y[32];
    unsigned char b_m[32];
    BIGNUM *x = NULL, *y = NULL;

    BN_CTX_start(ctx);
    x = BN_CTX_get(ctx);
    if ((y = BN_CTX_get(ctx)) == NULL
        /* pull out coords as bytes */
        || !EC_POINT_get_affine_coordinates(group, q, x, y, ctx) ||
        BN_bn2lebinpad(x, b_x, 32) != 32 || BN_bn2lebinpad(y, b_y, 32) != 32 ||
        BN_bn2lebinpad(m, b_m, 32) != 32)
        goto err;
    /* do the variable scalar multiplication */
    point_mul(b_x, b_y, b_m, b_x, b_y);
    /* check for infinity */
    if (CRYPTO_memcmp(const_zb, b_x, 32) == 0 &&
        CRYPTO_memcmp(const_zb, b_y, 32) == 0) {
        if (!EC_POINT_set_to_infinity(group, r)) goto err;
    } else {
        /* otherwise, pack the bytes into the result */
        if (BN_lebin2bn(b_x, 32, x) == NULL ||
            BN_lebin2bn(b_y, 32, y) == NULL ||
            !EC_POINT_set_affine_coordinates(group, r, x, y, ctx))
            goto err;
    }
    ret = 1;
err:
    BN_CTX_end(ctx);
    return ret;
}

/*-
 * An OpenSSL wrapper for fixed scalar multiplication.
 * r := n * G
 */
    int
    point_mul_g_id_GostR3410_2001_CryptoPro_C_ParamSet(const EC_GROUP *group,
                                                       EC_POINT *r,
                                                       const BIGNUM *n,
                                                       BN_CTX *ctx) {
    int ret = 0;
    unsigned char b_x[32];
    unsigned char b_y[32];
    unsigned char b_n[32];
    BIGNUM *x = NULL, *y = NULL;

    BN_CTX_start(ctx);
    x = BN_CTX_get(ctx);
    if ((y = BN_CTX_get(ctx)) == NULL || BN_bn2lebinpad(n, b_n, 32) != 32)
        goto err;
    /* do the fixed scalar multiplication */
    point_mul_g(b_x, b_y, b_n);
    /* check for infinity */
    if (CRYPTO_memcmp(const_zb, b_x, 32) == 0 &&
        CRYPTO_memcmp(const_zb, b_y, 32) == 0) {
        if (!EC_POINT_set_to_infinity(group, r)) goto err;
    } else {
        /* otherwise, pack the bytes into the result */
        if (BN_lebin2bn(b_x, 32, x) == NULL ||
            BN_lebin2bn(b_y, 32, y) == NULL ||
            !EC_POINT_set_affine_coordinates(group, r, x, y, ctx))
            goto err;
    }
    ret = 1;
err:
    BN_CTX_end(ctx);
    return ret;
}



#endif /* __SIZEOF_INT128__ */
