/**
 * \file pappsomspp/core/processing/cbor/mzcbor/cvparam.h
 * \date 23/11/2025
 * \author Olivier Langella
 * \brief PSI cvParam object for mzML/mzCBOR
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/


#pragma once
#include <QString>
#include <QXmlStreamWriter>
#include <QCborStreamReader>
#include <qjsonobject.h>
#include "pappsomspp/core/processing/cbor/cborstreamreader.h"
#include "pappsomspp/core/processing/cbor/cborstreamwriter.h"

namespace pappso
{
namespace cbor
{
namespace mzcbor
{
/**
 * @todo write docs
 */
struct CvParam
{
  void fromCbor(CborStreamReader &reader);
  void toCbor(CborStreamWriter &writer);

  /** @brief reads the XML attributes of the cvParam element
   * Inside the cvParam XML element, reads the attributes and go to next XML element
   * @param reader XML stream reader
   */
  void fromMzml(QXmlStreamReader &reader);
  void toMzml(QXmlStreamWriter &writer);


  /** @brief write the structure to a JSON object
   * @result QJsonObject
   */
  QJsonObject toJsonObject() const;


  void xmlValueToCbor(CborStreamWriter &writer, const QStringView &value_str);

  void setValue(const QString &value_str);

  std::uint8_t getExpectedUint8() const;
  double getExpectedDouble() const;
  qint64 getExpectedQint64() const;

  QString cvRef;
  QString accession;
  double valueDouble = nan("");
  qint64 valueInt    = std::numeric_limits<qint64>::max();
  QString valueStr;
  QString name;
  QString unitAccession;
  QString unitName;
  QString unitCvRef;

  QCborStreamReader::Type cborType = QCborStreamReader::Type::Invalid;
};
} // namespace mzcbor
} // namespace cbor
} // namespace pappso
