#include "MsXpS/libXpertMassGui/XpertMassGuiJavaScript.hpp"

namespace MsXpS
{
namespace libXpertMassGui
{

// This function needs to be called this way:
// MsXpS::libXpertMassGui::registerEnumsToQJSEngine(engine_p)
// in the program or library linking to this library.
void
registerEnumsToQJSEngine(QJSEngine *engine)
{
  Q_UNUSED(engine)

#if 0

  At present there are no global enums in libXpertMassGui.

  // qDebug() << "Now registering the Enums:: enums for libXpertMassGui";
  using namespace MsXpS::libXpertMassGui::Enums;

  // Create a JS object for libXpertMass
  QJSValue libraryJsInterface = engine->newObject();

  // Create a nested JS object for Enums
  QJSValue all_js_enums = engine->newObject();

  // Get the meta-object for the namespace (generated by Q_NAMESPACE)
  const QMetaObject *metaObject = &staticMetaObject;

  // Loop through all enums and populate jsEnums
  for(int i = 0; i < metaObject->enumeratorCount(); ++i)
    {
      QMetaEnum iter_meta_enum = metaObject->enumerator(i);

      // qDebug() << "Now iterating in enum:" << iter_meta_enum.enumName();

      QJSValue single_js_enum = engine->newObject();

      for(int j = 0; j < iter_meta_enum.keyCount(); ++j)
        {
          // qDebug() << "Now iterating in new key:" << iter_meta_enum.key(j)
          //          << "with value:" << iter_meta_enum.value(j);

          // key() would be "LEFT", with value() = 1
          single_js_enum.setProperty(iter_meta_enum.key(j),
                                     iter_meta_enum.value(j));
        }

      // name would be CapType
      all_js_enums.setProperty(iter_meta_enum.name(), single_js_enum);
    }

  // Attach Enums to libXpertMassGui
  libraryJsInterface.setProperty("Enums", all_js_enums);

  engine->globalObject().setProperty("libXpertMassGui", libraryJsInterface);

#ifdef QT_DEBUG

  qDebug()
    << "Now checking for correct exposition of Enums::enum::<key/value> pairs.";

  QJSValue jsEnums =
    engine->globalObject().property("libXpertMassGui").property("Enums");

  if(jsEnums.isUndefined())
    {
      qDebug() << "Error: libXpertMassGui.Enums not found!";
      return;
    }
  else
    {
      qDebug() << "libXpertMassGui.Enums JS object exists";

      // Get all enum names (properties of the Enums object)
      QJSValue propNames =
        engine->evaluate("Object.getOwnPropertyNames(libXpertMassGui.Enums)");

      if(propNames.isError())
        {
          qDebug() << "JS Error:" << propNames.toString();
          return;
        }

      // Iterate through each enum
      QStringList enumNames = propNames.toVariant().toStringList();
      for(const QString &enumName : enumNames)
        {
          QJSValue jsEnum = jsEnums.property(enumName);

          if(!jsEnum.isObject())
            {
              qDebug() << "Skipping non-object property:" << enumName;
              continue;
            }

          qDebug() << "\nChecking enum:" << enumName;

          // Get all keys of the iterated enum
          QJSValue enumKeys = engine->evaluate(
            QString("Object.getOwnPropertyNames(libXpertMassGui.Enums.%1)")
              .arg(enumName));

          if(enumKeys.isError())
            {
              qDebug() << "  JS Error:" << enumKeys.toString();
              continue;
            }

          // Print key-value pairs for the iterated enum
          QStringList keys = enumKeys.toVariant().toStringList();
          for(const QString &key : keys)
            {
              QJSValue value = jsEnum.property(key);
              qDebug() << "  " << key << "=" << value.toInt();
            }
        }
    }
#endif // #ifdef QT_DEBUG
#endif // #if 0
}

// This function needs to be called this way:
// MsXpS::libXpertMassGui::registerGlobalsToQJSEngine(engine_p)
// in the program or library that links to this library.
void
registerGlobalsToQJSEngine(QJSEngine *engine)
{
  // Create a JS object for the library
  QJSValue libraryJsInterface = engine->newObject();

  // Create a nested JS object for Globals
  QJSValue js_globals = engine->newObject();

#if 0

  js_globals.setProperty("ATOM_DEC_PLACES", ATOM_DEC_PLACES);
  js_globals.setProperty("OLIGOMER_DEC_PLACES", OLIGOMER_DEC_PLACES);
  js_globals.setProperty("POLYMER_DEC_PLACES", POLYMER_DEC_PLACES);
  js_globals.setProperty("PKA_PH_PI_DEC_PLACES", PKA_PH_PI_DEC_PLACES);

#endif

  libraryJsInterface.setProperty("Globals", js_globals);

  engine->globalObject().setProperty("libXpertMassGui", libraryJsInterface);
}

} // namespace libXpertMassGui
} // namespace MsXpS
