///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
// Source code for "Creating Efficient Triangle Strips"
// (C) 2000, Pierre Terdiman (p.terdiman@wanadoo.fr)
//
// Version is 2.0.
//
// Following adjacency structures have been successfully used to implement:
//				- a triangle striper
//				- a silhouette tracker [used for shadow volumes, occlusion culling, and glow!]
//				- local search for collision detection on terrains
//				- subdivision surfaces
//
//	So that one IS useful....
//
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef __ADJACENCY_H__
#define __ADJACENCY_H__

	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//
	//																Class Adjacencies
	//
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// MACROS
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	#define		MAKE_ADJ_TRI(x)			(x&0x3fffffff)
	#define		GET_EDGE_NB(x)			(x>>30)
	#define		IS_BOUNDARY(x)			(x==0xffffffff)

	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Structures
	///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	struct AdjTriangle{									// Should be derived from a triangle structure
				udword					VRef[3];		// Vertex-references
				udword					ATri[3];		// Links/References of adjacent triangles. The 2 most significant bits contains
														// the counterpart edge in the adjacent triangle.
				ubyte					FindEdge(udword vref0, udword vref1);
				udword					OppositeVertex(udword vref0, udword vref1);
	};

	struct AdjEdge{
				udword					Ref0;			// Vertex reference
				udword					Ref1;			// Vertex reference
				udword					FaceNb;			// Owner face
	};

	struct ADJACENCIESCREATE{
				ADJACENCIESCREATE()		{ DFaces = null; WFaces = null; NbFaces = 0; }
				udword					NbFaces;		// #faces in source topo
				udword*					DFaces;			// list of faces (dwords) or null
				uword*					WFaces;			// list of faces (words) or null
	};

	class Adjacencies
	{
	private:
				udword					mNbEdges;
				udword					mCurrentNbFaces;
				AdjEdge*				mEdges;

				bool					AddTriangle(udword ref0, udword ref1, udword ref2);
				bool					AddEdge(udword ref0, udword ref1, udword face);
				bool					UpdateLink(udword firsttri, udword secondtri, udword ref0, udword ref1);
				ubyte					FindEdge(AdjTriangle* tri, udword vref0, udword vref1);
	public:
				Adjacencies();
				~Adjacencies();

				udword					mNbFaces;
				AdjTriangle*			mFaces;

				bool					Init(ADJACENCIESCREATE& create);
				bool					CreateDatabase();
	};

#endif // __ADJACENCY_H__
