%feature("docstring") OT::JacobiFactory
R"RAW(Jacobi specific orthonormal univariate polynomial family.

For the :class:`~openturns.Beta` distribution.

Parameters
----------
arg1 : float
    If `parameters_set == ot.JacobiFactory.PROBABILITY`: default shape
    parameter :math:`r > 0` of the :class:`~openturns.Beta` distribution.

    If `parameters_set == ot.JacobiFactory.ANALYSIS`: alternative shape
    parameter :math:`\alpha = t - r - 1 > -1` of the :class:`~openturns.Beta`
    distribution.
arg2 : float
    If `parameters_set == ot.JacobiFactory.PROBABILITY`: default shape
    parameter :math:`t > r` of the :class:`~openturns.Beta` distribution.

    If `parameters_set == ot.JacobiFactory.ANALYSIS`: alternative shape
    parameter :math:`\beta = r - 1` of the :class:`~openturns.Beta`
    distribution.
parameters_set : int, optional
    Integer telling which parameters set is used for defining the distribution
    (amongst `ot.JacobiFactory.ANALYSIS, ot.JacobiFactory.PROBABILITY`).

Notes
-----
Any sequence of orthogonal polynomials has a recurrence formula relating any
three consecutive polynomials as follows:

.. math::

    P_{i + 1} = (a_i x + b_i) P_i + c_i P_{i - 1}, \quad 1 < i

The recurrence coefficients for the Jacobi polynomials come analytically and
read:

.. math::

    \begin{array}{rcl}
        a_i & = & \displaystyle K_{2,i} (2 i + \alpha + \beta + 2) \\
        b_i & = & \displaystyle K_{2,i} \frac{(\alpha - \beta)(\alpha + \beta)}
                                             {2 i + \alpha + \beta} \\
        c_i & = & \displaystyle - \frac{2 i + \alpha + \beta + 2}
                                       {2 i + \alpha + \beta}
                                \left[(i + \alpha) (i + \beta)
                                      (i + \alpha + \beta) i
                                      \frac{K_{1,i}}
                                           {2 i + \alpha + \beta - 1}
                                      \right]^{1/2}
    \end{array}, \quad 1 < i

where :math:`\alpha` and :math:`\beta` are the alternative shape parameters
of the :class:`~openturns.Beta` distribution, and:

.. math::

    \begin{array}{rcl}
        K_{1,i} & = & \displaystyle \frac{2 i + \alpha + \beta + 3}
                                         {(i + 1) (i + \alpha + 1)
                                          (i + \beta + 1)
                                          (i + \alpha + \beta + 1)} \\
        K_{2,i} & = & \displaystyle \frac{1}{2}
                                    \sqrt{(2 i + \alpha + \beta + 1) K_{1,i}}
    \end{array}, \quad i > 1

See also
--------
StandardDistributionPolynomialFactory

Examples
--------
>>> import openturns as ot
>>> polynomial_factory = ot.JacobiFactory()
>>> for i in range(3):
...     print(polynomial_factory.build(i))
1
2.23607 * X
-0.935414 + 4.67707 * X^2)RAW"

// ---------------------------------------------------------------------

%feature("docstring") OT::JacobiFactory::getAlpha
R"RAW(Accessor to the alternative shape parameter :math:`\alpha`.

Of the :class:`~openturns.Beta` distribution.

Returns
-------
alpha : float
    Alternative shape parameter :math:`\alpha = r - 1` of the
    :class:`~openturns.Beta` distribution.)RAW"

// ---------------------------------------------------------------------

%feature("docstring") OT::JacobiFactory::getBeta
R"RAW(Accessor to the alternative shape parameter :math:`\beta`.

Of the :class:`~openturns.Beta` distribution.

Returns
-------
beta : float
    Alternative shape parameter :math:`\beta = t - r - 1` of the
    :class:`~openturns.Beta` distribution.)RAW"
