% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildExhaustive.R
\name{buildExhaustive}
\alias{buildExhaustive}
\title{Prepare data for an exhaustive search}
\usage{
buildExhaustive(X, transposed = FALSE, distance = c("Euclidean", "Manhattan"))
}
\arguments{
\item{X}{A numeric matrix where rows correspond to data points 
and columns correspond to variables (i.e., dimensions).}

\item{transposed}{Logical scalar indicating whether \code{X} is transposed, 
i.e., rows are variables and columns are data points.}

\item{distance}{String specifying the type of distance to use.}
}
\value{
An \linkS4class{ExhaustiveIndex} object containing:
\itemize{
\item \code{data}, a numeric matrix with points in the \emph{columns} and dimensions in the rows, 
i.e., transposed relative to the input.
\item \code{NAMES}, a character vector or \code{NULL} equal to \code{rownames(X)}.
\item \code{distance}, a string specifying the distance metric used.
}
}
\description{
Transform data in preparation for an exhaustive (i.e., brute-force) search.
}
\examples{
Y <- matrix(rnorm(100000), ncol=20)
out <- buildExhaustive(Y)
out

}
