!-------------------------------------------------------------------------
! Copyright (c) 2005-2011 SPMODEL Development Group. All rights reserved.!
!-------------------------------------------------------------------------
!
!ɽ  et_module ƥȥץ (䥳ӥ׻)
!
!  2005/07/19  ݹ
!      2007/11/13  ݹ  顼åɲ
!      2011/03/06  ʿ dc_test Ȥ褦˽
!
program et_test_jacobian

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use et_module
  implicit none

 !---- ֲ ----
  integer, parameter :: im=32, jm=32              ! ʻ(X,Y)
  integer, parameter :: km=10, lm=21              ! ȿ(X,Y)

 !---- ѿ ----
  real(8)            :: yx_A(0:jm,0:im-1)     ! ʻҥǡ
  real(8)            :: yx_B(0:jm,0:im-1)     ! ʻҥǡ
  real(8)            :: yx_Jacob(0:jm,0:im-1)  ! ʻҥǡ

  integer            :: k=3
  integer            :: l=2

 !---- ɸѿʤ ----
  real(8), parameter :: xmin = -1.0d0, xmax=1.0d0
  real(8), parameter :: ymin = -1.0d0, ymax=1.0d0

  real(8), parameter :: pi=3.1415926535897932385D0
  ! Ƚ
  integer, parameter :: check_digits = 10
  integer, parameter :: ignore = -11

  call MessageNotify('M','et_test_jacobian', &
       'ee_module jacobian function tests')

 !---------------- ɸͤ ---------------------
  call et_initial(im,jm,km,lm,xmin,xmax,ymin,ymax)    ! ڥȥ

  yx_A = sin(k*pi*yx_Y)
  yx_B = sin(l*pi*yx_Y)
  yx_Jacob = 0.0D0

  call check2d(yx_et(et_Jacobian_et_et(et_yx(yx_A),et_yx(yx_B))), yx_Jacob, &
    'Jacob(sin(k*pi*X),sin(l*pi*Y))')

  yx_A = sin(k*pi*yx_X)*yx_Y
  yx_B = cos(k*pi*yx_X)*yx_Y**2
  yx_Jacob = k*pi*(1+cos(k*pi*yx_X)**2) *yx_Y**2

  call check2d(yx_et(et_Jacobian_et_et(et_yx(yx_A),et_yx(yx_B))), yx_Jacob, &
    'Jacob(sin(k*pi*X)*yx_Y,cos(k*pi*yx_X)*Y**2')

  yx_A = cos(k*pi*yx_X)*yx_Y
  yx_B = yx_Y**3
  yx_Jacob = -3*k*pi* sin(k*pi*yx_X)*yx_Y**3

  call check2d(yx_et(et_Jacobian_et_et(et_yx(yx_A),et_yx(yx_B))), yx_Jacob, &
    'Jacob(cos(k*pi*X)*Y,Y**3))')

  yx_A = yx_Y**4
  yx_B = sin(l*pi*yx_X)
  yx_Jacob = -4.0D0*l*pi * yx_Y**3*cos(l*pi*yx_X)

  call check2d(yx_et(et_Jacobian_et_et(et_yx(yx_A),et_yx(yx_B))), yx_Jacob, &
    'Jacob(Y**4,sin(l*pi*X))')

  call MessageNotify('M','et_test_jacobian', &
       'et_module jacobian function tests succeeded!')

contains

  subroutine check2d(var,ans,funcname)
    real(8) :: var(:,:)
    real(8) :: ans(:,:)
    character(len=*)  :: funcname

    call AssertEqual(                                           &
      message=funcname,                                         &
      answer = ans,                                             &
      check = var,                                              &
      significant_digits = check_digits, ignore_digits = ignore &
      )
  end subroutine check2d

end program et_test_jacobian
