!----------------------------------------------------------------------
!     Copyright (c) 2011--2012 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  wq_module ƥȥץ
!      ʬʿѷ׻
!
!  2011/09/09  ݹ  wq_module_integral_test.f90  MPI Ѥ˲¤
!      2011/09/12  ݹ  wtq_mpi_module Ѥ˲¤
!      2012/04/02  ݹ  wtq_mpi_module_sjpack Ѥ˲¤
!      2012/04/03  ݹ  wtq_module_sjpack Ѥ˲¤
!      2012/04/03  ݹ  wtq_module Ѥ˲¤
!
program wtq_module_integral_wq_test

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use wtq_module
  implicit none

  integer,parameter  :: im=32, jm=16         ! ʻ(, , ư)
  integer,parameter  :: kmo=16, kmi=10       ! ʻ(ư, ư)
  integer,parameter  :: nm=10                ! ȿ(ʿ)
  integer,parameter  :: lmo=10, lmi=16       ! ȿ(ư, ư)
  real(8),parameter  :: ri=0.5, ro=1.5       ! ⳰Ⱦ

  real(8), dimension(0:im-1,1:jm,kmi)       :: xyr_Data
  real(8), dimension(0:im-1,1:jm)          :: xy_Data
  real(8), dimension(1:jm,kmi)              :: yr_Data
  real(8), dimension(0:im-1,kmi)            :: xr_Data
  real(8), dimension(0:im-1)               :: x_Data
  real(8), dimension(1:jm)                 :: y_Data
  real(8), dimension(kmi)                   :: r_Data

  real(8), parameter  :: pi=3.1415926535897932385D0

  ! Ƚ
  integer, parameter :: check_digits = 4
  integer, parameter :: ignore = -5

  call MessageNotify('M','wtq_module_integral_wq_test', &
       'wtq_module wq-integration functions tests')

  call wtq_Initial(im,jm,kmi,kmo,nm,lmi,lmo,ri,ro)

 !============================ ʬ(xyr) =============================
 ! 
  xyr_Data = 1.0D0

  yr_Data = 2*pi
  call AssertEqual(&
       message='yr_IntLon_xyr with constant field',                &
       answer = yr_Data,                                           &
       check = yr_IntLon_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xr_Data = 2.0D0
  call AssertEqual(&
       message='xr_IntLat_xyr with constant field',                &
       answer = xr_Data,                                           &
       check = xr_IntLat_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xy_Data = 1/3.0D0*ri**3
  call AssertEqual(&
       message='xy_IntRad_xyr with constant field',                &
       answer = xy_Data,                                           &
       check = xy_IntRad_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  r_Data = 4*pi
  call AssertEqual(&
       message='r_IntLonLat_xyr with constant field',              &
       answer = r_Data,                                            &
       check = r_IntLonLat_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 2/3.0D0*ri**3
  call AssertEqual(&
       message='x_IntLatRad_xyr with constant field',              &
       answer = x_Data,                                            &
       check = x_IntLatRad_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = 2*pi/3.0D0*ri**3
  call AssertEqual(&
       message='y_IntLonRad_xyr with constant field',              &
       answer = y_Data,                                            &
       check = y_IntLonRad_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLonLatRad_xyr with constant field',             &
       answer = 4*pi/3*ri**3,                                      &
       check = IntLonLatRad_xyr(xyr_Data),                         &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 ! r^2 
  xyr_Data = xyr_Rad**2

  yr_Data = 2*pi* xyr_Rad(1,:,:)**2
  call AssertEqual(&
       message='yr_IntLon_xyr with r^2',                           &
       answer = yr_Data,                                           &
       check = yr_IntLon_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xr_Data = 2.0D0 * xyr_Data(:,1,:)
  call AssertEqual(&
       message='xr_IntLat_xyr with r^2',                           &
       answer = xr_Data,                                           &
       check = xr_IntLat_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xy_Data = 1/5.0D0*ri**5
  call AssertEqual(&
       message='xy_IntRad_xyr with r^2',                           &
       answer = xy_Data,                                           &
       check = xy_IntRad_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  r_Data = 4*pi * xyr_Data(1,1,:)
  call AssertEqual(&
       message='r_IntLonLat_xyr with r^2',                         &
       answer = r_Data,                                            &
       check = r_IntLonLat_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 2/5.0D0*ri**5
  call AssertEqual(&
       message='x_IntLatRad_xyr with r^2',                         &
       answer = x_Data,                                            &
       check = x_IntLatRad_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = 2*pi/5.0D0*ri**5
  call AssertEqual(&
       message='y_IntLonRad_xyr with r^2',                         &
       answer = y_Data,                                            &
       check = y_IntLonRad_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLonLatRad_xyr with r^2',                        &
       answer = 4*pi/5*ri**5,                                      &
       check = IntLonLatRad_xyr(xyr_Data),                         &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(phi)**2 
  xyr_Data = sin(xyr_Lat)**2

  yr_Data = 2*pi* xyr_Data(1,:,:)
  call AssertEqual(&
       message='yr_IntLon_xyr with sin(phi)**2',                   &
       answer = yr_Data,                                           &
       check = yr_IntLon_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xr_Data = 2.0D0/3.0D0
  call AssertEqual(&
       message='xr_IntLat_xyr with sin(phi)**2',                   &
       answer = xr_Data,                                           &
       check = xr_IntLat_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xy_Data = 1/3.0D0*ri**3 * xyr_Data(:,:,1)
  call AssertEqual(&
       message='xy_IntRad_xyr with sin(phi)**2',                   &
       answer = xy_Data,                                           &
       check = xy_IntRad_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  r_Data = 4*pi/3.0
  call AssertEqual(&
       message='r_IntLonLat_xyr with sin(phi)**2',                 &
       answer = r_Data,                                            &
       check = r_IntLonLat_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 2/9.0D0*ri**3
  call AssertEqual(&
       message='x_IntLatRad_xyr with sin(phi)**2',                 &
       answer = x_Data,                                            &
       check = x_IntLatRad_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = 2*pi/3.0D0*ri**3 * xyr_Data(1,:,1)
  call AssertEqual(&
       message='y_IntLonRad_xyr with sin(phi)**2',                 &
       answer = y_Data,                                            &
       check = y_IntLonRad_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLonLatRad_xyr with sin(phi)**2',                &
       answer = 4*pi/9*ri**3,                                      &
       check = IntLonLatRad_xyr(xyr_Data),                         &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(lambda)**2
  xyr_Data = sin(xyr_Lon)**2

  yr_Data = pi
  call AssertEqual(&
       message='yr_IntLon_xyr with sin(lambda)**2',                &
       answer = yr_Data,                                           &
       check = yr_IntLon_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xr_Data = 2.0D0 * xyr_Data(:,1,:)
  call AssertEqual(&
       message='xr_IntLat_xyr with sin(lambda)**2',                &
       answer = xr_Data,                                           &
       check = xr_IntLat_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xy_Data = 1/3.0D0*ri**3 * xyr_Data(:,:,1)
  call AssertEqual(&
       message='xy_IntRad_xyr with sin(lambda)**2',                &
       answer = xy_Data,                                           &
       check = xy_IntRad_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  r_Data = 2*pi
  call AssertEqual(&
       message='r_IntLonLat_xyr with sin(lambda)**2',              &
       answer = r_Data,                                            &
       check = r_IntLonLat_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 2.0D0/3.0D0*ri**3 * xyr_Data(:,1,1)
  call AssertEqual(&
       message='x_IntLatRad_xyr with sin(lambda)**2',              &
       answer = x_Data,                                            &
       check = x_IntLatRad_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = pi/3.0D0*ri**3
  call AssertEqual(&
       message='y_IntLonRad_xyr with sin(lambda)**2',              &
       answer = y_Data,                                            &
       check = y_IntLonRad_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLonLatRad_xyr with sin(lambda)**2',             &
       answer = 2*pi/3*ri**3,                                      &
       check = IntLonLatRad_xyr(xyr_Data),                         &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʬ(xy) =============================
  ! 
  xy_Data = 1.0D0

  y_Data = 2*pi
  call AssertEqual(&
       message='y_IntLon_xy with constant field',                  &
       answer = y_Data,                                            &
       check = y_IntLon_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 2.0D0
  call AssertEqual(&
       message='x_IntLat_xy with constant field',                  &
       answer = x_Data,                                            &
       check = x_IntLat_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLonLat_xy with constant field',                 &
       answer = 4*pi,                                              &
       check = IntLonLat_xy(xy_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(lambda)**2
  xy_Data = sin(xy_Lon)**2

  y_Data = pi 
  call AssertEqual(&
       message='y_IntLon_xy with sin(lambda)**2',                  &
       answer = y_Data,                                            &
       check = y_IntLon_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 2.0d0 * xy_Data(:,1)
  call AssertEqual(&
       message='x_IntLat_xy with sin(lambda)**2',                  &
       answer = x_Data,                                            &
       check = x_IntLat_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLonLat_xy with sin(lambda)**2',                 &
       answer = 2*pi,                                              &
       check = IntLonLat_xy(xy_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(phi)**2 
  xy_Data = sin(xy_Lat)**2

  y_Data = 2*pi* xy_Data(1,:)
  call AssertEqual(&
       message='y_IntLon_xy with sin(phi)**2',                     &
       answer = y_Data,                                            &
       check = y_IntLon_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 2.0D0/3.0D0
  call AssertEqual(&
       message='x_IntLat_xy with sin(phi)**2',                     &
       answer = x_Data,                                            &
       check = x_IntLat_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLonLat_xy with sin(phi)**2',                    &
       answer = 4*pi/3.0,                                          &
       check = IntLonLat_xy(xy_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʬ(yr) =============================
  ! 
  yr_Data = 1.0D0

  r_Data = 2.0D0
  call AssertEqual(&
       message='r_IntLat_yr with constant field',                  &
       answer = r_Data,                                            &
       check = r_IntLat_yr(yr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = 1/3.0D0*ri**3
  call AssertEqual(&
       message='y_IntRad_yr with constant field',                  &
       answer = y_Data,                                            &
       check = y_IntRad_yr(yr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLatRad_yr with constant field',                 &
       answer = 2/3.0D0*ri**3,                                     &
       check = IntLatRad_yr(yr_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! r^2 
  yr_Data = xyr_Rad(0,:,:)**2

  r_Data = 2.0D0 * yr_Data(1,:)
  call AssertEqual(&
       message='r_IntLat_yr with r^2',                             &
       answer = r_Data,                                            &
       check = r_IntLat_yr(yr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = 1/5.0D0*ri**5
  call AssertEqual(&
       message='y_IntRad_yr with r^2',                             &
       answer = y_Data,                                            &
       check = y_IntRad_yr(yr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLatRad_yr with r^2',                            &
       answer = 2/5.0D0*ri**5,                                     &
       check = IntLatRad_yr(yr_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(phi)**2 
  yr_Data = sin(xyr_Lat(0,:,:))**2

  r_Data = 2.0D0/3.0D0
  call AssertEqual(&
       message='r_IntLat_yr with sin(phi)**2',                     &
       answer = r_Data,                                            &
       check = r_IntLat_yr(yr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = 1/3.0D0*ri**3 * yr_Data(:,1)
  call AssertEqual(&
       message='y_IntRad_yr with sin(phi)**2',                     &
       answer = y_Data,                                            &
       check = y_IntRad_yr(yr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLatRad_yr with sin(phi)**2',                    &
       answer = 2/9.0D0*ri**3,                                     &
       check = IntLatRad_yr(yr_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʬ(xr) =============================
  ! 
  xr_Data = 1.0D0

  r_Data = 2*pi
  call AssertEqual(&
       message='r_IntLon_xr with constant field',                  &
       answer = r_Data,                                            &
       check = r_IntLon_xr(xr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 1/3.0D0*ri**3
  call AssertEqual(&
       message='x_IntRad_xr with constant field',                  &
       answer = x_Data,                                            &
       check = x_IntRad_xr(xr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLonRad_xr with constant field',                 &
       answer = 2*pi/3.0D0*ri**3,                                  &
       check = IntLonRad_xr(xr_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(lambda)**2
  xr_Data = sin(xyr_Lon(:,1,:))**2

  r_Data = pi
  call AssertEqual(&
       message='r_IntLon_xr with sin(lambda)**2',                  &
       answer = r_Data,                                            &
       check = r_IntLon_xr(xr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 1/3.0D0*ri**3 * xr_Data(:,1)
  call AssertEqual(&
       message='x_IntRad_xr with sin(lambda)**2',                  &
       answer = x_Data,                                            &
       check = x_IntRad_xr(xr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLonRad_xr with sin(lambda)**2',                 &
       answer = pi/3.0D0*ri**3 ,                                   &
       check = IntLonRad_xr(xr_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! r^2 
  xr_Data = xyr_Rad(:,1,:)**2

  r_Data = 2*pi* r_Rad**2
  call AssertEqual(&
       message='r_IntLon_xr with r^2',                             &
       answer = r_Data,                                            &
       check = r_IntLon_xr(xr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 1/5.0D0*ri**5
  call AssertEqual(&
       message='x_IntRad_xr with r^2',                             &
       answer = x_Data,                                            &
       check = x_IntRad_xr(xr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='IntLonRad_xr with r^2',                            &
       answer = 2*pi/5.0D0*ri**5,                                  &
       check = IntLonRad_xr(xr_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʬ(x) =============================
  ! 
  x_Data = 1.0D0

  call AssertEqual(&
       message='IntLon_x with constant field',                     &
       answer = 2*pi,                                              &
       check = IntLon_x(x_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(lambda)**2
  x_Data = sin(x_Lon)**2

  call AssertEqual(&
       message='IntLon_x with sin(lambda)**2',                     &
       answer = pi,                                                &
       check = IntLon_x(x_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʬ(y) =============================
  ! 
  y_Data = 1.0D0

  xr_Data = 2.0D0
  call AssertEqual(&
       message='IntLat_y with constant field',                     &
       answer = 2.0D0,                                             &
       check = IntLat_y(y_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(phi)**2 
  y_Data = sin(y_Lat)**2

  call AssertEqual(&
       message='IntLat_y with sin(phi)**2',                        &
       answer = 2.0D0/3.0D0,                                       &
       check = IntLat_y(y_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʬ(r) =============================
  ! 
  r_Data = 1.0D0

  call AssertEqual(&
       message='IntRad_r with constant field',                     &
       answer = 1/3.0D0*ri**3,                                     &
       check = IntRad_r(r_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! r^2 
  r_Data = r_Rad**2

  call AssertEqual(&
       message='IntRad_r with r^2',                                &
       answer = 1/5.0D0*ri**5,                                     &
       check = IntRad_r(r_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !=========================== ʿ(xyr) =============================

  call MessageNotify('M','wtq_module_wq_integral_test', &
       'wtq_module wq-averaging functions tests')

 ! 
  xyr_Data = 1.0

  yr_Data = 1.0D0
  call AssertEqual(&
       message='yr_AvrLon_xyr with constant field',                &
       answer = yr_Data,                                           &
       check = yr_AvrLon_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xr_Data = 1.0D0
  call AssertEqual(&
       message='xr_AvrLat_xyr with constant field',                &
       answer = xr_Data,                                           &
       check = xr_AvrLat_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xy_Data = 1.0D0
  call AssertEqual(&
       message='xy_AvrRad_xyr with constant field',                &
       answer = xy_Data,                                           &
       check = xy_AvrRad_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  r_Data = r_AvrLonLat_xyr(xyr_Data)
  call AssertEqual(&
       message='r_AvrLonLat_xyr with constant field',              &
       answer = r_Data,                                            &
       check = r_AvrLonLat_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 1.0D0
  call AssertEqual(&
       message='x_AvrLatRad_xyr with constant field',              &
       answer = x_Data,                                            &
       check = x_AvrLatRad_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = 1.0D0
  call AssertEqual(&
       message='y_AvrLonRad_xyr with constant field',              &
       answer = y_Data,                                            &
       check = y_AvrLonRad_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLonLatRad_xyr with constant field',             &
       answer = 1.0D0,                                             &
       check = AvrLonLatRad_xyr(xyr_Data),                         &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 ! r 
  xyr_Data = xyr_Rad 

  yr_Data = xyr_Data(1,:,:)
  call AssertEqual(&
       message='yr_AvrLon_xyr with r',                             &
       answer = yr_Data,                                           &
       check = yr_AvrLon_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xr_Data = xyr_Data(:,1,:)
  call AssertEqual(&
       message='xr_AvrLat_xyr with r',                             &
       answer = xr_Data,                                           &
       check = xr_AvrLat_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xy_Data = 1.0D0/4.0D0*ri**4/(1.0D0/3.0D0*ri**3)
  call AssertEqual(&
       message='xy_AvrRad_xyr with r',                             &
       answer = xy_Data,                                           &
       check = xy_AvrRad_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  r_Data = xyr_Data(1,1,:)
  call AssertEqual(&
       message='r_AvrLonLat_xyr with r',                           &
       answer = r_Data,                                            &
       check = r_AvrLonLat_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 1/2.0D0*ri**4/(2/3.0D0*ri**3)
  call AssertEqual(&
       message='x_AvrLatRad_xyr with r',                           &
       answer = x_Data,                                            &
       check = x_AvrLatRad_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = pi/2.0D0*ri**4/(2*pi/3.0D0*ri**3)
  call AssertEqual(&
       message='y_AvrLonRad_xyr with r',                           &
       answer = y_Data,                                            &
       check = y_AvrLonRad_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLonLatRad_xyr with r',                          &
       answer = pi*ri**4/(4*pi/3*ri**3),                           &
       check = AvrLonLatRad_xyr(xyr_Data),                         &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(phi)**2
  xyr_Data = sin(xyr_Lat)**2

  yr_Data = xyr_Data(1,:,:)
  call AssertEqual(&
       message='yr_AvrLon_xyr with sin(phi)**2',                   &
       answer = yr_Data,                                           &
       check = yr_AvrLon_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xr_Data = 1.0D0/3.0D0
  call AssertEqual(&
       message='xr_AvrLat_xyr with sin(phi)**2',                   &
       answer = xr_Data,                                           &
       check = xr_AvrLat_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xy_Data = xyr_Data(:,:,1)
  call AssertEqual(&
       message='xy_AvrRad_xyr with sin(phi)**2',                   &
       answer = xy_Data,                                           &
       check = xy_AvrRad_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  r_Data = 1.0D0/3.0D0
  call AssertEqual(&
       message='r_AvrLonLat_xyr with sin(phi)**2',                 &
       answer = r_Data,                                            &
       check = r_AvrLonLat_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 1.0D0/3.0D0
  call AssertEqual(&
       message='x_AvrLatRad_xyr with sin(phi)**2',                 &
       answer = x_Data,                                            &
       check = x_AvrLatRad_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = xyr_Data(1,:,1)
  call AssertEqual(&
       message='y_AvrLonRad_xyr with sin(phi)**2',                 &
       answer = y_Data,                                            &
       check = y_AvrLonRad_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLonLatRad_xyr with sin(phi)**2',                &
       answer = 1.0D0/3D0,                                         &
       check = AvrLonLatRad_xyr(xyr_Data),                         &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(lambda)**2
  xyr_Data = sin(xyr_Lon)**2

  yr_Data = 0.5D0
  call AssertEqual(&
       message='yr_AvrLon_xyr with sin(lambda)**2',                &
       answer = yr_Data,                                           &
       check = yr_AvrLon_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xr_Data = xyr_Data(:,1,:)
  call AssertEqual(&
       message='xr_AvrLat_xyr with sin(lambda)**2',                &
       answer = xr_Data,                                           &
       check = xr_AvrLat_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  xy_Data = xyr_Data(:,:,1)
  call AssertEqual(&
       message='xy_AvrRad_xyr with sin(lambda)**2',                &
       answer = xy_Data,                                           &
       check = xy_AvrRad_xyr(xyr_Data),                            &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  r_Data = 0.5D0
  call AssertEqual(&
       message='r_AvrLonLat_xyr with sin(lambda)**2',              &
       answer = r_Data,                                            &
       check = r_AvrLonLat_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = xyr_Data(:,1,1)
  call AssertEqual(&
       message='x_AvrLatRad_xyr with sin(lambda)**2',              &
       answer = x_Data,                                            &
       check = x_AvrLatRad_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = 0.5D0
  call AssertEqual(&
       message='y_AvrLonRad_xyr with sin(lambda)**2',              &
       answer = y_Data,                                            &
       check = y_AvrLonRad_xyr(xyr_Data),                          &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLonLatRad_xyr with sin(lambda)**2',             &
       answer = 0.5D0,                                             &
       check = AvrLonLatRad_xyr(xyr_Data),                         &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʿ(xy) =============================
  ! 
  xy_Data = 1.0D0

  y_Data = 1.0D0
  call AssertEqual(&
       message='y_AvrLon_xy with constant field',                  &
       answer = y_Data,                                            &
       check = y_AvrLon_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 1.0D0
  call AssertEqual(&
       message='x_AvrLat_xy with constant field',                  &
       answer = x_Data,                                            &
       check = x_AvrLat_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLonLat_xy with constant field',                 &
       answer = 1.0D0,                                             &
       check = AvrLonLat_xy(xy_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(lambda)**2
  xy_Data = sin(xy_Lon)**2

  y_Data = 0.5D0
  call AssertEqual(&
       message='y_AvrLon_xy with sin(lambda)**2',                  &
       answer = y_Data,                                            &
       check = y_AvrLon_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = xy_Data(:,1)
  call AssertEqual(&
       message='x_AvrLat_xy with sin(lambda)**2',                  &
       answer = x_Data,                                            &
       check = x_AvrLat_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLonLat_xy with sin(lambda)**2',                 &
       answer = 0.5D0,                                             &
       check = AvrLonLat_xy(xy_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(phi)**2 
  xy_Data = sin(xy_Lat)**2

  y_Data = xy_Data(1,:)
  call AssertEqual(&
       message='y_AvrLon_xy with sin(phi)**2',                     &
       answer = y_Data,                                            &
       check = y_AvrLon_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 1.0D0/3.0D0
  call AssertEqual(&
       message='x_AvrLat_xy with sin(phi)**2',                     &
       answer = x_Data,                                            &
       check = x_AvrLat_xy(xy_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLonLat_xy with sin(phi)**2',                    &
       answer = 1.0D0/3.0D0,                                       &
       check = AvrLonLat_xy(xy_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʿ(yr) =============================
  ! 
  yr_Data = 1.0D0

  r_Data = 1.0D0
  call AssertEqual(&
       message='r_AvrLat_yr with constant field',                  &
       answer = r_Data,                                            &
       check = r_AvrLat_yr(yr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = 1.0D0
  call AssertEqual(&
       message='y_AvrRad_yr with constant field',                  &
       answer = y_Data,                                            &
       check = y_AvrRad_yr(yr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLatRad_yr with constant field',                 &
       answer = 1.0D0,                                             &
       check = AvrLatRad_yr(yr_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! r^2 
  yr_Data = xyr_Rad(0,:,:)**2

  r_Data = yr_Data(1,:)
  call AssertEqual(&
       message='r_AvrLat_yr with r^2',                             &
       answer = r_Data,                                            &
       check = r_AvrLat_yr(yr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = 3.0D0/5.0D0*ri**2
  call AssertEqual(&
       message='y_AvrRad_yr with r^2',                             &
       answer = y_Data,                                            &
       check = y_AvrRad_yr(yr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLatRad_yr with r^2',                            &
       answer = 3.0D0/5.0D0*ri**2,                                 &
       check = AvrLatRad_yr(yr_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(phi)**2 
  yr_Data = sin(xyr_Lat(0,:,:))**2

  r_Data = 1.0D0/3.0D0
  call AssertEqual(&
       message='r_AvrLat_yr with sin(phi)**2',                     &
       answer = r_Data,                                            &
       check = r_AvrLat_yr(yr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  y_Data = yr_Data(:,1)
  call AssertEqual(&
       message='y_AvrRad_yr with sin(phi)**2',                     &
       answer = y_Data,                                            &
       check = y_AvrRad_yr(yr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLatRad_yr with sin(phi)**2',                    &
       answer = 1.0D0/3.0D0,                                       &
       check = AvrLatRad_yr(yr_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʿ(xr) =============================
  ! 
  xr_Data = 1.0D0

  r_Data = 1.0D0
  call AssertEqual(&
       message='r_AvrLon_xr with constant field',                  &
       answer = r_Data,                                            &
       check = r_AvrLon_xr(xr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 1.0D0
  call AssertEqual(&
       message='x_AvrRad_xr with constant field',                  &
       answer = x_Data,                                            &
       check = x_AvrRad_xr(xr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLonRad_xr with constant field',                 &
       answer = 1.0D0,                                             &
       check = AvrLonRad_xr(xr_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(lambda)**2
  xr_Data = sin(xyr_Lon(:,1,:))**2

  r_Data = 0.5D0
  call AssertEqual(&
       message='r_AvrLon_xr with sin(lambda)**2',                  &
       answer = r_Data,                                            &
       check = r_AvrLon_xr(xr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = xr_Data(:,1)
  call AssertEqual(&
       message='x_AvrRad_xr with sin(lambda)**2',                  &
       answer = x_Data,                                            &
       check = x_AvrRad_xr(xr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLonRad_xr with sin(lambda)**2',                 &
       answer = 0.5D0,                                             &
       check = AvrLonRad_xr(xr_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! r^2 
  xr_Data = xyr_Rad(:,1,:)**2

  r_Data = r_Rad**2
  call AssertEqual(&
       message='r_AvrLon_xr with r^2',                             &
       answer = r_Data,                                            &
       check = r_AvrLon_xr(xr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  x_Data = 3.0D0/5.0D0*ri**2
  call AssertEqual(&
       message='x_AvrRad_xr with r^2',                             &
       answer = x_Data,                                            &
       check = x_AvrRad_xr(xr_Data),                               &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call AssertEqual(&
       message='AvrLonRad_xr with r^2',                            &
       answer = 3.0D0/5.0D0*ri**2,                                 &
       check = AvrLonRad_xr(xr_Data),                              &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʿ(x) =============================
  ! 
  x_Data = 1.0D0

  call AssertEqual(&
       message='AvrLon_x with constant field',                     &
       answer = 1.0D0,                                             &
       check = AvrLon_x(x_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(lambda)**2
  x_Data = sin(x_Lon)**2

  call AssertEqual(&
       message='AvrLon_x with sin(lambda)**2',                     &
       answer = 0.5D0,                                             &
       check = AvrLon_x(x_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʿ(y) =============================
  ! 
  y_Data = 1.0D0

  xr_Data = 1.0D0
  call AssertEqual(&
       message='AvrLat_y with constant field',                     &
       answer = 1.0D0,                                             &
       check = AvrLat_y(y_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! sin(phi)**2 
  y_Data = sin(y_Lat)**2

  call AssertEqual(&
       message='AvrLat_y with sin(phi)**2',                        &
       answer = 1.0D0/3.0D0,                                       &
       check = AvrLat_y(y_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

 !============================ ʿ(r) =============================
  ! 
  r_Data = 1.0D0

  call AssertEqual(&
       message='AvrRad_r with constant field',                     &
       answer = 1.0D0,                                             &
       check = AvrRad_r(r_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  ! r^2 
  r_Data = r_Rad**2

  call AssertEqual(&
       message='AvrRad_r with r^2',                                &
       answer = 3.0D0/5.0D0*ri**2,                                 &
       check = AvrRad_r(r_Data),                                   &
       significant_digits = check_digits, ignore_digits = ignore   &
       )

  call MessageNotify('M','wtq_module_integral_wq_test', &
       'wtq_module wq-integration/averaging function tests succeeded!')

end program wtq_module_integral_wq_test

