require "numru/gphys/gphys"
require "numru/gphys/gphys_io"
require "test/unit"
include NumRu

class GPhysTest < Test::Unit::TestCase
  def setup
    begin
      @T = GPhys::IO.open("testdata/T.jan.nc","T")      # NetCDF data
      @Tgd = GPhys::IO.open("testdata/T.jan.ctl","T")   # GrADS data
    rescue NetcdfSyserr
      @T = GPhys::IO.open("../testdata/T.jan.nc","T")      # NetCDF data
      @Tgd = GPhys::IO.open("../testdata/T.jan.ctl","T")   # GrADS data
    end
  end

  def test_cyclic_ext
    te = @T.cyclic_ext(0)
    assert_equal( te.shape[0], @T.shape[0]+1 )      # to make sure it is extened
    assert_equal( te.axis(0).pos.max.to_f, 360.0 )  # to make sure it is extened
    te = @Tgd.cyclic_ext(0)
    assert_equal( te.axis(0).pos.max.to_f, 360.0 )  # to make sure it is extened
  end
end
