/* Database of special points in Brillouin zones
 * Indexation is by real space lattice
 *
 * Real space fcc -> reciprocal space bcc, and vice versa
 * Real space hex (120 deg) -> recip. space hex (60 deg) and vice versa
 */


#define MAX_SPECIALS 12

struct pt {char *l; double k[3];};

struct special {char *lat; char *eq; struct pt pts[MAX_SPECIALS+1];};

struct special specials[]={{"cub","111",
			    {{"R",{0.5,0.5,0.5}},
			     {"X",{0.5,0,0}},
			     {"M",{0.5,0.5,0}},
			     {"",{0,0,0}}}},
			   {"hex60","112",
			    {{"A",{0,0,0.5}},
			     {"M",{0.5,0,0}},
			     {"M",{0.5,0.5,0}},
			     {"K",{2./3.,1./3.,0}},
			     {"L",{0.5,0,0.5}},
			     {"L",{0.5,0.5,0.5}},
			     {"H",{2./3.,1./3.,0.5}},
			     {"",{0,0,0}}}},
			   {"hex","112",
			    {{"A",{0,0,0.5}},
			     {"M",{0.5,0,0}},
			     {"M",{0.5,0.5,0}},
			     {"K",{1./3.,1./3.,0}},
			     {"K",{2./3.,2./3.,0}},
			     {"L",{0.5,0,0.5}},
			     {"L",{0.5,0.5,0.5}},
			     {"H",{1./3.,1./3.,0.5}},
			     {"H",{2./3.,2./3.,0.5}},
			     {"",{0,0,0}}}},
			   {"tet","112",
			    {{"A",{0.5,0.5,0.5}},
			     {"X",{0.5,0,0}},
			     {"M",{0.5,0.5,0}},
			     {"R",{0.5,0,0.5}},
			     {"Z",{0,0,0.5}},
			     {"",{0,0,0}}}},
			   {"mono","123",
			    {{"A",{0.5,0.5,0}},
			     {"B",{0.5,0,0}},
			     {"Y",{0,0.5,0}},
			     {"Z",{0,0,0.5}},
			     {"C",{0,0.5,0.5}},
			     {"D",{0.5,0,0.5}},
			     {"E",{0.5,0.5,0.5}},
			     {"",{0,0,0}}}},
			   {"orth","123",
			    {{"R",{0.5,0.5,0.5}},
			     {"X",{0.5,0,0}},
			     {"Y",{0,0.5,0}},
			     {"Z",{0,0,0.5}},
			     {"S",{0.5,0.5,0}},
			     {"T",{0,0.5,0.5}},
			     {"U",{0.5,0,0.5}},
			     {"",{0,0,0}}}},
			   {"rhom","111",
			    {{"Z",{0.5,0.5,0.5}},
			     {"L",{0.5,0,0}},
			     {"F",{0.5,0.5,0}},
			     {"",{0,0,0}}}},
			   {"bcc","111",
			    {{"P",{0.25,0.25,0.25}},
			     {"H",{0.5,0.5,0.5}},
			     {"N",{0,0.5,0}},
			     {"",{0,0,0}}}},
			   {"fcc","111",
			    {{"X",{0,0.5,0.5}},
			     {"L",{0.5,0.5,0.5}},
			     {"W",{0.25,0.75,0.5}},
			     {"U",{0.25,0.625,0.625}},
			     {"K",{0.375,0.75,0.375}},
			     {"",{0,0,0}}}},
			   {"","",{{"",{0,0,0}}}}};



  
