set(BINGO_DEFAULT_VERSION "1.9.1.r0" CACHE INTERNAL "versions" FORCE)
set(BINGO_MAX_REVISION 500)

find_package(Git)
if(GIT_EXECUTABLE)
    EXECUTE_PROCESS(COMMAND ${GIT_EXECUTABLE} describe --long --tags --match "bingo-*"
                    OUTPUT_VARIABLE BINGO_FULL_VERSION
                    OUTPUT_STRIP_TRAILING_WHITESPACE
                    WORKING_DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR})
    if(NOT ${BINGO_FULL_VERSION} STREQUAL "")
        string(REGEX REPLACE "bingo-(.+)-(.+)-(.+)" "\\2" BINGO_REVISION ${BINGO_FULL_VERSION})
        if(${BINGO_REVISION} GREATER ${BINGO_MAX_REVISION})
            message(SEND_ERROR "Bingo revision ${BINGO_REVISION} is greater than max revision ${BINGO_MAX_REVISION}. Please create appropriate version tag")
        endif()
        string(REGEX REPLACE "bingo-(.+)-(.+)-(.+)" "\\1.r\\2-\\3" BINGO_FULL_VERSION ${BINGO_FULL_VERSION})
        string(REGEX REPLACE "(.+)-(.+)" "\\1" BINGO_VERSION ${BINGO_FULL_VERSION})
        set(BINGO_VERSION "${BINGO_VERSION}" CACHE INTERNAL "versions" FORCE)
        set(BINGO_FULL_VERSION "${BINGO_FULL_VERSION}" CACHE INTERNAL "versions" FORCE)
    else()
        set(BINGO_VERSION "${BINGO_DEFAULT_VERSION}" CACHE INTERNAL "versions" FORCE)
        set(BINGO_FULL_VERSION "${BINGO_DEFAULT_VERSION}-00000000" CACHE INTERNAL "versions" FORCE)
    endif()
else()
    set(BINGO_VERSION "${BINGO_DEFAULT_VERSION}" CACHE INTERNAL "versions" FORCE)
    set(BINGO_FULL_VERSION "${BINGO_DEFAULT_VERSION}-00000000" CACHE INTERNAL "versions" FORCE)
endif()

CMAKE_POLICY(SET CMP0012 NEW)
if($ENV{BUILD_NUMBER})
    set(BINGO_BUILD_VERSION $ENV{BUILD_NUMBER})
else()
    set(BINGO_BUILD_VERSION 0)
endif()

set(BINGO_VERSION_EXT "${BINGO_FULL_VERSION} ${PACKAGE_SUFFIX}" CACHE INTERNAL "versions" FORCE)


