# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.abstract_mapper3d import AbstractMapper3D


class Mapper(AbstractMapper3D):
    r"""
    Mapper - abstract class specifies interface to map data to
    graphics primitives
    
    Superclass: AbstractMapper3D
    
    Mapper is an abstract class to specify interface between data and
    graphics primitives. Subclasses of Mapper map data through a
    lookuptable and control the creation of rendering primitives that
    interface to the graphics library. The mapping can be controlled by
    supplying a lookup table and specifying a scalar range to map data
    through.
    
    There are several important control mechanisms affecting the behavior
    of this object. The scalar_visibility flag controls whether scalar
    data (if any) controls the color of the associated actor(s) that
    refer to the mapper. The scalar_mode ivar is used to determine whether
    scalar point data or cell data is used to color the object. By
    default, point data scalars are used unless there are none, in which
    cell scalars are used. Or you can explicitly control whether to use
    point or cell scalar data. Finally, the mapping of scalars through
    the lookup table varies depending on the setting of the color_mode
    flag. See the documentation for the appropriate methods for an
    explanation.
    
    Another important feature of the mapper is the ability to shift the
    z-buffer to resolve coincident topology. For example, if you'd like
    to draw a mesh with some edges a different color, and the edges lie
    on the mesh, this feature can be useful to get nice looking lines.
    (See the resolve_coincident_topology-related methods.)
    
    @sa
    DataSetMapper PolyDataMapper
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkMapper, obj, update, **traits)
    
    interpolate_scalars_before_mapping = tvtk_base.false_bool_trait(desc=\
        r"""
        By default, vertex color is used to map colors to a surface.
        Colors are interpolated after being mapped. This option avoids
        color interpolation by using a one dimensional texture map for
        the colors.
        """
    )

    def _interpolate_scalars_before_mapping_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetInterpolateScalarsBeforeMapping,
                        self.interpolate_scalars_before_mapping_)

    scalar_visibility = tvtk_base.true_bool_trait(desc=\
        r"""
        Turn on/off flag to control whether scalar data is used to color
        objects.
        """
    )

    def _scalar_visibility_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetScalarVisibility,
                        self.scalar_visibility_)

    static = tvtk_base.false_bool_trait(desc=\
        r"""
        Turn on/off flag to control whether the mapper's data is static.
        Static data means that the mapper does not propagate updates down
        the pipeline, greatly decreasing the time it takes to update many
        mappers. This should only be used if the data never changes.
        """
    )

    def _static_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetStatic,
                        self.static_)

    use_lookup_table_scalar_range = tvtk_base.false_bool_trait(desc=\
        r"""
        Control whether the mapper sets the lookuptable range based on
        its own scalar_range, or whether it will use the lookup_table
        scalar_range regardless of it's own setting. By default the Mapper
        is allowed to set the lookup_table range, but users who are
        sharing lookup_tables between mappers/actors will probably wish to
        force the mapper to use the lookup_table unchanged.
        """
    )

    def _use_lookup_table_scalar_range_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseLookupTableScalarRange,
                        self.use_lookup_table_scalar_range_)

    color_mode = tvtk_base.RevPrefixMap({'default': 0, 'direct_scalars': 2, 'map_scalars': 1}, default_value='default', desc=\
        r"""
        default (color_mode_to_default), unsigned char scalars are treated
        as colors, and NOT mapped through the lookup table, while
        everything else is.  color_mode_to_direct_scalar extends
        color_mode_to_default such that all integer types are treated as
        colors with values in the range 0-255 and floating types are
        treated as colors with values in the range 0.0-1.0.  Setting
        color_mode_to_map_scalars means that all scalar data will be mapped
        through the lookup table.  (Note that for multi-component
        scalars, the particular component to use for mapping can be
        specified using the select_color_array() method.)
        """
    )

    def _color_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetColorMode,
                        self.color_mode_)

    resolve_coincident_topology = tvtk_base.RevPrefixMap({'polygon_offset': 1, 'default': 0, 'off': 0, 'shift_z_buffer': 2}, default_value='polygon_offset', desc=\
        r"""
        Set/Get a global flag that controls whether coincident topology
        (e.g., a line on top of a polygon) is shifted to avoid z-buffer
        resolution (and hence rendering problems). If not off, there are
        two methods to choose from. polygon_offset uses graphics systems
        calls to shift polygons, lines and points from each other.
        shift_z_buffer is a legacy method that used to remap the z-buffer
        to distinguish vertices, lines, and polygons, but does not always
        produce acceptable results. You should only use the polygon_offset
        method (or none) at this point.
        """
    )

    def _resolve_coincident_topology_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetResolveCoincidentTopology,
                        self.resolve_coincident_topology_)

    scalar_mode = tvtk_base.RevPrefixMap({'default': 0, 'use_cell_data': 2, 'use_cell_field_data': 4, 'use_field_data': 5, 'use_point_data': 1, 'use_point_field_data': 3}, default_value='default', desc=\
        r"""
        Control how the filter works with scalar point data and cell
        attribute data.  By default (scalar_mode_to_default), the filter
        will use point data, and if no point data is available, then cell
        data is used. Alternatively you can explicitly set the filter to
        use point data (scalar_mode_to_use_point_data) or cell data
        (scalar_mode_to_use_cell_data). You can also choose to get the scalars
        from an array in point field data (scalar_mode_to_use_point_field_data)
        or cell field data (scalar_mode_to_use_cell_field_data).  If scalars
        are coming from a field data array, you must call
        select_color_array before you call get_colors.
        """
    )

    def _scalar_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetScalarMode,
                        self.scalar_mode_)

    array_access_mode = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _array_access_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetArrayAccessMode,
                        self.array_access_mode)

    array_component = traits.Int(0, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _array_component_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetArrayComponent,
                        self.array_component)

    array_id = traits.Int(-1, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _array_id_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetArrayId,
                        self.array_id)

    array_name = traits.String('', enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _array_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetArrayName,
                        self.array_name)

    field_data_tuple_id = traits.Int(-1, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _field_data_tuple_id_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFieldDataTupleId,
                        self.field_data_tuple_id)

    def _get_lookup_table(self):
        return wrap_vtk(self._vtk_obj.GetLookupTable())
    def _set_lookup_table(self, arg):
        old_val = self._get_lookup_table()
        self._wrap_call(self._vtk_obj.SetLookupTable,
                        deref_vtk(arg))
        self.trait_property_changed('lookup_table', old_val, arg)
    lookup_table = traits.Property(_get_lookup_table, _set_lookup_table, desc=\
        r"""
        
        """
    )

    def _get_relative_coincident_topology_line_offset_parameters(self):
        return self._vtk_obj.GetRelativeCoincidentTopologyLineOffsetParameters()
    def _set_relative_coincident_topology_line_offset_parameters(self, arg):
        old_val = self._get_relative_coincident_topology_line_offset_parameters()
        self._wrap_call(self._vtk_obj.SetRelativeCoincidentTopologyLineOffsetParameters,
                        arg)
        self.trait_property_changed('relative_coincident_topology_line_offset_parameters', old_val, arg)
    relative_coincident_topology_line_offset_parameters = traits.Property(_get_relative_coincident_topology_line_offset_parameters, _set_relative_coincident_topology_line_offset_parameters, desc=\
        r"""
        
        """
    )

    def _get_relative_coincident_topology_point_offset_parameter(self):
        return self._vtk_obj.GetRelativeCoincidentTopologyPointOffsetParameter()
    def _set_relative_coincident_topology_point_offset_parameter(self, arg):
        old_val = self._get_relative_coincident_topology_point_offset_parameter()
        self._wrap_call(self._vtk_obj.SetRelativeCoincidentTopologyPointOffsetParameter,
                        arg)
        self.trait_property_changed('relative_coincident_topology_point_offset_parameter', old_val, arg)
    relative_coincident_topology_point_offset_parameter = traits.Property(_get_relative_coincident_topology_point_offset_parameter, _set_relative_coincident_topology_point_offset_parameter, desc=\
        r"""
        
        """
    )

    def _get_relative_coincident_topology_polygon_offset_parameters(self):
        return self._vtk_obj.GetRelativeCoincidentTopologyPolygonOffsetParameters()
    def _set_relative_coincident_topology_polygon_offset_parameters(self, arg):
        old_val = self._get_relative_coincident_topology_polygon_offset_parameters()
        self._wrap_call(self._vtk_obj.SetRelativeCoincidentTopologyPolygonOffsetParameters,
                        arg)
        self.trait_property_changed('relative_coincident_topology_polygon_offset_parameters', old_val, arg)
    relative_coincident_topology_polygon_offset_parameters = traits.Property(_get_relative_coincident_topology_polygon_offset_parameters, _set_relative_coincident_topology_polygon_offset_parameters, desc=\
        r"""
        
        """
    )

    render_time = traits.Float(0.0, enter_set=True, auto_set=False, desc=\
        r"""
        This instance variable is used by LODActor to determine which
        mapper to use.  It is an estimate of the time necessary to
        render. Setting the render time does not modify the mapper.
        """
    )

    def _render_time_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRenderTime,
                        self.render_time)

    def get_resolve_coincident_topology_line_offset_parameters(self, *args):
        """
        get_resolve_coincident_topology_line_offset_parameters(factor:float,
            units:float) -> None
        C++: static void get_resolve_coincident_topology_line_offset_parameters(
            double &factor, double &units)"""
        ret = self._wrap_call(self._vtk_obj.GetResolveCoincidentTopologyLineOffsetParameters, *args)
        return ret

    def set_resolve_coincident_topology_line_offset_parameters(self, *args):
        """
        set_resolve_coincident_topology_line_offset_parameters(factor:float,
            units:float) -> None
        C++: static void set_resolve_coincident_topology_line_offset_parameters(
            double factor, double units)
        Used to set the line offset scale factor and units. Used when
        resolve_coincident_topology is set to polygon_offset. These are
        global variables.
        """
        ret = self._wrap_call(self._vtk_obj.SetResolveCoincidentTopologyLineOffsetParameters, *args)
        return ret

    def get_resolve_coincident_topology_point_offset_parameter(self, *args):
        """
        get_resolve_coincident_topology_point_offset_parameter(units:float)
            -> None
        C++: static void get_resolve_coincident_topology_point_offset_parameter(
            double &units)"""
        ret = self._wrap_call(self._vtk_obj.GetResolveCoincidentTopologyPointOffsetParameter, *args)
        return ret

    def set_resolve_coincident_topology_point_offset_parameter(self, *args):
        """
        set_resolve_coincident_topology_point_offset_parameter(units:float)
            -> None
        C++: static void set_resolve_coincident_topology_point_offset_parameter(
            double units)
        Used to set the point offset value Used when
        resolve_coincident_topology is set to polygon_offset. These are
        global variables.
        """
        ret = self._wrap_call(self._vtk_obj.SetResolveCoincidentTopologyPointOffsetParameter, *args)
        return ret

    resolve_coincident_topology_polygon_offset_faces = traits.Int(1, enter_set=True, auto_set=False, desc=\
        r"""
        Used when resolve_coincident_topology is set to polygon_offset. The
        polygon offset can be applied either to the solid polygonal faces
        or the lines/vertices. When set (default), the offset is applied
        to the faces otherwise it is applied to lines and vertices. This
        is a global variable.
        """
    )

    def _resolve_coincident_topology_polygon_offset_faces_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetResolveCoincidentTopologyPolygonOffsetFaces,
                        self.resolve_coincident_topology_polygon_offset_faces)

    def get_resolve_coincident_topology_polygon_offset_parameters(self, *args):
        """
        get_resolve_coincident_topology_polygon_offset_parameters(factor:float,
            units:float) -> None
        C++: static void get_resolve_coincident_topology_polygon_offset_parameters(
            double &factor, double &units)"""
        ret = self._wrap_call(self._vtk_obj.GetResolveCoincidentTopologyPolygonOffsetParameters, *args)
        return ret

    def set_resolve_coincident_topology_polygon_offset_parameters(self, *args):
        """
        set_resolve_coincident_topology_polygon_offset_parameters(factor:float,
            units:float) -> None
        C++: static void set_resolve_coincident_topology_polygon_offset_parameters(
            double factor, double units)
        Used to set the polygon offset scale factor and units. Used when
        resolve_coincident_topology is set to polygon_offset. These are
        global variables.
        """
        ret = self._wrap_call(self._vtk_obj.SetResolveCoincidentTopologyPolygonOffsetParameters, *args)
        return ret

    resolve_coincident_topology_z_shift = traits.Float(0.01, enter_set=True, auto_set=False, desc=\
        r"""
        Used to set the z-shift if resolve_coincident_topology is set to
        shift_z_buffer. This is a global variable.
        """
    )

    def _resolve_coincident_topology_z_shift_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetResolveCoincidentTopologyZShift,
                        self.resolve_coincident_topology_z_shift)

    scalar_range = traits.Array(enter_set=True, auto_set=False, shape=(2,), dtype="float", value=(0.0, 1.0), cols=2, desc=\
        r"""
        Specify range in terms of scalar minimum and maximum (smin,smax).
        These values are used to map scalars into lookup table. Has no
        effect when use_lookup_table_scalar_range is true.
        """
    )

    def _scalar_range_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetScalarRange,
                        self.scalar_range)

    def _get_selection(self):
        return wrap_vtk(self._vtk_obj.GetSelection())
    def _set_selection(self, arg):
        old_val = self._get_selection()
        self._wrap_call(self._vtk_obj.SetSelection,
                        deref_vtk(arg))
        self.trait_property_changed('selection', old_val, arg)
    selection = traits.Property(_get_selection, _set_selection, desc=\
        r"""
        Set/Get selection used to display particular points or cells in a
        second pass. This can be use to efficiently display a selection.
        """
    )

    def get_coincident_topology_line_offset_parameters(self, *args):
        """
        get_coincident_topology_line_offset_parameters(self, factor:float,
            units:float) -> None
        C++: void get_coincident_topology_line_offset_parameters(
            double &factor, double &units)"""
        ret = self._wrap_call(self._vtk_obj.GetCoincidentTopologyLineOffsetParameters, *args)
        return ret

    def get_coincident_topology_point_offset_parameter(self, *args):
        """
        get_coincident_topology_point_offset_parameter(self, units:float)
            -> None
        C++: void get_coincident_topology_point_offset_parameter(double &units)"""
        ret = self._wrap_call(self._vtk_obj.GetCoincidentTopologyPointOffsetParameter, *args)
        return ret

    def get_coincident_topology_polygon_offset_parameters(self, *args):
        """
        get_coincident_topology_polygon_offset_parameters(self, factor:float,
            units:float) -> None
        C++: void get_coincident_topology_polygon_offset_parameters(
            double &factor, double &units)
        Get the net parameters for handling coincident topology obtained
        by summing the global values with the relative values.
        """
        ret = self._wrap_call(self._vtk_obj.GetCoincidentTopologyPolygonOffsetParameters, *args)
        return ret

    def _get_color_coordinates(self):
        return wrap_vtk(self._vtk_obj.GetColorCoordinates())
    color_coordinates = traits.Property(_get_color_coordinates, desc=\
        r"""
        Provide read access to the color texture coordinate array
        """
    )

    def _get_color_map_colors(self):
        return wrap_vtk(self._vtk_obj.GetColorMapColors())
    color_map_colors = traits.Property(_get_color_map_colors, desc=\
        r"""
        Provide read access to the color array
        """
    )

    def _get_color_texture_map(self):
        return wrap_vtk(self._vtk_obj.GetColorTextureMap())
    color_texture_map = traits.Property(_get_color_texture_map, desc=\
        r"""
        Provide read access to the color texture array
        """
    )

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        r"""
        Get the input as a DataSet.  This method is overridden in the
        specialized mapper classes to return more specific data types.
        """
    )

    def _get_input_as_data_set(self):
        return wrap_vtk(self._vtk_obj.GetInputAsDataSet())
    input_as_data_set = traits.Property(_get_input_as_data_set, desc=\
        r"""
        Get the input to this mapper as a DataSet, instead of as a
        more specialized data type that the subclass may return from
        get_input().  This method is provided for use in the wrapper
        languages, C++ programmers should use get_input() instead.
        """
    )

    def _get_supports_selection(self):
        return self._vtk_obj.GetSupportsSelection()
    supports_selection = traits.Property(_get_supports_selection, desc=\
        r"""
        WARNING: INTERNAL METHOD - NOT INTENDED FOR GENERAL USE DO NOT
        USE THIS METHOD OUTSIDE OF THE RENDERING PROCESS Used by
        HardwareSelector to determine if the prop supports hardware
        selection.
        """
    )

    def can_use_texture_map_for_coloring(self, *args):
        """
        can_use_texture_map_for_coloring(self, input:DataObject) -> int
        C++: virtual int can_use_texture_map_for_coloring(DataObject *input)
        Returns if we can use texture maps for scalar coloring. Note this
        doesn't say we "will" use scalar coloring. It says, if we do use
        scalar coloring, we will use a texture. When rendering multiblock
        datasets, if any 2 blocks provide different lookup tables for the
        scalars, then also we cannot use textures. This case can be
        handled if required.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.CanUseTextureMapForColoring, *my_args)
        return ret

    def clear_color_arrays(self):
        """
        clear_color_arrays(self) -> None
        C++: void clear_color_arrays()
        Call to force a rebuild of color result arrays on next
        map_scalars. Necessary when using arrays in the case of multiblock
        data.
        """
        ret = self._vtk_obj.ClearColorArrays()
        return ret
        

    def color_by_array_component(self, *args):
        """
        color_by_array_component(self, arrayNum:int, component:int) -> None
        C++: void color_by_array_component(int arrayNum, int component)
        color_by_array_component(self, arrayName:str, component:int) -> None
        C++: void color_by_array_component(const char *arrayName,
            int component)
        Legacy: These methods used to be used to specify the array
        component. It is better to do this in the lookup table.
        """
        ret = self._wrap_call(self._vtk_obj.ColorByArrayComponent, *args)
        return ret

    def create_default_lookup_table(self):
        """
        create_default_lookup_table(self) -> None
        C++: virtual void create_default_lookup_table()
        Create default lookup table. Generally used to create one when
        none is available with the scalar data.
        """
        ret = self._vtk_obj.CreateDefaultLookupTable()
        return ret
        

    def has_opaque_geometry(self):
        """
        has_opaque_geometry(self) -> bool
        C++: virtual bool has_opaque_geometry()
        Some introspection on the type of data the mapper will render
        used by props to determine if they should invoke the mapper on a
        specific rendering pass.
        """
        ret = self._vtk_obj.HasOpaqueGeometry()
        return ret
        

    def has_translucent_polygonal_geometry(self):
        """
        has_translucent_polygonal_geometry(self) -> bool
        C++: virtual bool has_translucent_polygonal_geometry()"""
        ret = self._vtk_obj.HasTranslucentPolygonalGeometry()
        return ret
        

    def map_scalars(self, *args):
        """
        map_scalars(self, alpha:float) -> UnsignedCharArray
        C++: virtual UnsignedCharArray *map_scalars(double alpha)
        map_scalars(self, alpha:float, cellFlag:int)
            -> UnsignedCharArray
        C++: virtual UnsignedCharArray *map_scalars(double alpha,
            int &cellFlag)
        map_scalars(self, input:DataSet, alpha:float)
            -> UnsignedCharArray
        C++: virtual UnsignedCharArray *map_scalars(DataSet *input,
            double alpha)
        map_scalars(self, input:DataSet, alpha:float, cellFlag:int)
            -> UnsignedCharArray
        C++: virtual UnsignedCharArray *map_scalars(DataSet *input,
            double alpha, int &cellFlag)
        Map the scalars (if there are any scalars and scalar_visibility is
        on) through the lookup table, returning an unsigned char RGBA
        array. This is typically done as part of the rendering process.
        The alpha parameter allows the blending of the scalars with an
        additional alpha (typically which comes from a Actor, etc.)
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.MapScalars, *my_args)
        return wrap_vtk(ret)

    def process_selector_pixel_buffers(self, *args):
        """
        process_selector_pixel_buffers(self, __a:HardwareSelector,
            __b:[int, ...], __c:Prop) -> None
        C++: virtual void process_selector_pixel_buffers(
            HardwareSelector *, std::vector<unsigned int> &, Prop *)
        allows a mapper to update a selections color buffers Called from
        a prop which in turn is called from the selector
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.ProcessSelectorPixelBuffers, *my_args)
        return ret

    def render(self, *args):
        """
        render(self, ren:Renderer, a:Actor) -> None
        C++: virtual void render(Renderer *ren, Actor *a)
        Method initiates the mapping process. Generally sent by the actor
        as each frame is rendered.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Render, *my_args)
        return ret

    def select_color_array(self, *args):
        """
        select_color_array(self, arrayNum:int) -> None
        C++: void select_color_array(int arrayNum)
        select_color_array(self, arrayName:str) -> None
        C++: void select_color_array(const char *arrayName)
        When scalar_mode is set to use_point_field_data or use_cell_field_data,
        you can specify which array to use for coloring using these
        methods. The lookup table will decide how to convert vectors to
        colors.
        """
        ret = self._wrap_call(self._vtk_obj.SelectColorArray, *args)
        return ret

    _updateable_traits_ = \
    (('interpolate_scalars_before_mapping',
    'GetInterpolateScalarsBeforeMapping'), ('scalar_visibility',
    'GetScalarVisibility'), ('static', 'GetStatic'),
    ('use_lookup_table_scalar_range', 'GetUseLookupTableScalarRange'),
    ('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('color_mode',
    'GetColorMode'), ('resolve_coincident_topology',
    'GetResolveCoincidentTopology'), ('scalar_mode', 'GetScalarMode'),
    ('array_access_mode', 'GetArrayAccessMode'), ('array_component',
    'GetArrayComponent'), ('array_id', 'GetArrayId'), ('array_name',
    'GetArrayName'), ('field_data_tuple_id', 'GetFieldDataTupleId'),
    ('render_time', 'GetRenderTime'),
    ('resolve_coincident_topology_polygon_offset_faces',
    'GetResolveCoincidentTopologyPolygonOffsetFaces'),
    ('resolve_coincident_topology_z_shift',
    'GetResolveCoincidentTopologyZShift'), ('scalar_range',
    'GetScalarRange'), ('progress', 'GetProgress'), ('progress_text',
    'GetProgressText'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'interpolate_scalars_before_mapping', 'release_data_flag',
    'scalar_visibility', 'static', 'use_lookup_table_scalar_range',
    'color_mode', 'resolve_coincident_topology', 'scalar_mode',
    'array_access_mode', 'array_component', 'array_id', 'array_name',
    'field_data_tuple_id', 'progress_text', 'render_time',
    'resolve_coincident_topology_polygon_offset_faces',
    'resolve_coincident_topology_z_shift', 'scalar_range'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(Mapper, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit Mapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['interpolate_scalars_before_mapping', 'scalar_visibility',
            'static', 'use_lookup_table_scalar_range'], ['color_mode',
            'resolve_coincident_topology', 'scalar_mode'], ['array_access_mode',
            'array_component', 'array_id', 'array_name', 'field_data_tuple_id',
            'render_time', 'resolve_coincident_topology_polygon_offset_faces',
            'resolve_coincident_topology_z_shift', 'scalar_range']),
            title='Edit Mapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit Mapper properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

