#include <stdlib.h>
#include <stdio.h>
#include <math.h>

struct {
  char symbol[5];
  int Z,ion_charge;
  double ab[8];
  double c;
} form_factor_low_q_data[]={/*{{{*/
  {"H", 1, 0, 0.493002, 10.5109, 0.322912, 26.1257, 0.140191, 3.14236, 0.040810, 57.7997, 0.003038},
  {"H1-", 1, -1, 0.897661, 53.1368, 0.565616, 15.1870, 0.415815, 186.576, 0.116973, 3.56709, 0.002389},
  {"He", 2, 0, 0.873400, 9.10370, 0.630900, 3.35680, 0.311200, 22.9276, 0.178000, 0.982100, 0.006400},
  {"Li", 3, 0, 1.12820, 3.95460, 0.750800, 1.05240, 0.617500, 85.3905, 0.465300, 168.261, 0.037700},
  {"Li1+", 3, +1, 0.696800, 4.62370, 0.788800, 1.95570, 0.341400, 0.631600, 0.156300, 10.0953, 0.016700},
  {"Be", 4, 0, 1.59190, 43.6427, 1.12780, 1.86230, 0.539100, 103.483, 0.702900, 0.542000, 0.038500},
  {"Be2+", 4, +2, 6.26030, 0.002700, 0.884900, 0.831300, 0.799300, 2.27580, 0.164700, 5.11460, -6.1092},
  {"B", 5, 0, 2.05450, 23.2185, 1.33260, 1.02100, 1.09790, 60.3498, 0.706800, 0.140300, -0.19320},
  {"C", 6, 0, 2.26069, 22.6907, 1.56165, 0.656665, 1.05075, 9.75618, 0.839259, 55.5949, 0.286977},
  {"N", 7, 0, 12.2126, 0.005700, 3.13220, 9.89330, 2.01250, 28.9975, 1.16630, 0.582600, -11.529},
  {"O", 8, 0, 3.04850, 13.2771, 2.28680, 5.70110, 1.54630, 0.323900, 0.867000, 32.9089, 0.250800},
  {"O1-", 8, -1, 4.19160, 12.8573, 1.63969, 4.17236, 1.52673, 47.0179, -20.307, -0.01404, 21.9412},
  {"F", 9, 0, 3.53920, 10.2825, 2.64120, 4.29440, 1.51700, 0.261500, 1.02430, 26.1476, 0.277600},
  {"F1-", 9, -1, 3.63220, 5.27756, 3.51057, 14.7353, 1.26064, 0.442258, 0.940706, 47.3437, 0.653396},
  {"Ne", 10, 0, 3.95530, 8.40420, 3.11250, 3.42620, 1.45460, 0.230600, 1.12510, 21.7184, 0.351500},
  {"Na", 11, 0, 4.76260, 3.28500, 3.17360, 8.84220, 1.26740, 0.313600, 1.11280, 129.424, 0.676000},
  {"Na1+", 11, +1, 3.25650, 2.66710, 3.93620, 6.11530, 1.39980, 0.200100, 1.00320, 14.0390, 0.404000},
  {"Mg", 12, 0, 5.42040, 2.82750, 2.17350, 79.2611, 1.22690, 0.380800, 2.30730, 7.19370, 0.858400},
  {"Mg2+", 12, +2, 3.49880, 2.16760, 3.83780, 4.75420, 1.32840, 0.185000, 0.849700, 10.1411, 0.485300},
  {"Al", 13, 0, 6.42020, 3.03870, 1.90020, 0.742600, 1.59360, 31.5472, 1.96460, 85.0886, 1.11510},
  {"Al3+", 13, +3, 4.17448, 1.93816, 3.38760, 4.14553, 1.20296, 0.228753, 0.528137, 8.28524, 0.706786},
  {"Si", 14, 0, 5.66269, 2.66520, 3.07164, 38.6634, 2.62446, 0.916946, 1.39320, 93.5458, 1.24707},
  {"Si4+", 14, +4, 4.43918, 1.64167, 3.20345, 3.43757, 1.19453, 0.214900, 0.416530, 6.65365, 0.746297},
  {"P", 15, 0, 6.43450, 1.90670, 4.17910, 27.1570, 1.78000, 0.526000, 1.49080, 68.1645, 1.11490},
  {"S", 16, 0, 6.90530, 1.46790, 5.20340, 22.2151, 1.43790, 0.253600, 1.58630, 56.1720, 0.866900},
  {"Cl", 17, 0, 11.4604, 0.010400, 7.19640, 1.16620, 6.25560, 18.5194, 1.64550, 47.7784, -9.5574},
  {"Cl1-", 17, -1, 18.2915, 0.006600, 7.20840, 1.17170, 6.53370, 19.5424, 2.33860, 60.4486, -16.378},
  {"Ar", 18, 0, 7.48450, 0.907200, 6.77230, 14.8407, 0.653900, 43.8983, 1.64420, 33.3929, 1.44450},
  {"K", 19, 0, 8.21860, 12.7949, 7.43980, 0.774800, 1.05190, 213.187, 0.865900, 41.6841, 1.42280},
  {"K1+", 19, +1, 7.95780, 12.6331, 7.49170, 0.767400, 6.35900, -0.00200, 1.19150, 31.9128, -4.9978},
  {"Ca", 20, 0, 8.62660, 10.4421, 7.38730, 0.659900, 1.58990, 85.7484, 1.02110, 178.437, 1.37510},
  {"Ca2+", 20, +2, 15.6348, -0.00740, 7.95180, 0.608900, 8.43720, 10.3116, 0.853700, 25.9905, -14.875},
  {"Sc", 21, 0, 9.18900, 9.02130, 7.36790, 0.572900, 1.64090, 136.108, 1.46800, 51.3531, 1.33290},
  {"Sc3+", 21, +3, 13.4008, 0.298540, 8.02730, 7.96290, 1.65943, -0.28604, 1.57936, 16.0662, -6.6667},
  {"Ti", 22, 0, 9.75950, 7.85080, 7.35580, 0.500000, 1.69910, 35.6338, 1.90210, 116.105, 1.28070},
  {"Ti2+", 22, +2, 9.11423, 7.52430, 7.62174, 0.457585, 2.27930, 19.5361, 0.087899, 61.6558, 0.897155},
  {"Ti3+", 22, +3, 17.7344, 0.220610, 8.73816, 7.04716, 5.25691, -0.15762, 1.92134, 15.9768, -14.652},
  {"Ti4+", 22, +4, 19.5114, 0.178847, 8.23473, 6.67018, 2.01341, -0.29263, 1.52080, 12.9464, -13.280},
  {"V", 23, 0, 10.2971, 6.86570, 7.35110, 0.438500, 2.07030, 26.8938, 2.05710, 102.478, 1.21990},
  {"V2+", 23, +2, 10.1060, 6.88180, 7.35410, 0.440900, 2.28840, 20.3004, 0.022300, 115.122, 1.22980},
  {"V3+", 23, +3, 9.43141, 6.39535, 7.74190, 0.383349, 2.15343, 15.1908, 0.016865, 63.9690, 0.656565},
  {"V5+", 23, +5, 15.6887, 0.679003, 8.14208, 5.40135, 2.03081, 9.97278, -9.5760, 0.940464, 1.71430},
  {"Cr", 24, 0, 10.6406, 6.10380, 7.35370, 0.392000, 3.32400, 20.2626, 1.49220, 98.7399, 1.18320},
  {"Cr2+", 24, +2, 9.54034, 5.66078, 7.75090, 0.344261, 3.58274, 13.3075, 0.509107, 32.4224, 0.616898},
  {"Cr3+", 24, +3, 9.68090, 5.59463, 7.81136, 0.334393, 2.87603, 12.8288, 0.113575, 32.8761, 0.518275},
  {"Mn", 25, 0, 11.2819, 5.34090, 7.35730, 0.343200, 3.01930, 17.8674, 2.24410, 83.7543, 1.08960},
  {"Mn2+", 25, +2, 10.8061, 5.27960, 7.36200, 0.343500, 3.52680, 14.3430, 0.218400, 41.3235, 1.08740},
  {"Mn3+", 25, +3, 9.84521, 4.91797, 7.87194, 0.294393, 3.56531, 10.8171, 0.323613, 24.1281, 0.393974},
  {"Mn4+", 25, +4, 9.96253, 4.84850, 7.97057, 0.283303, 2.76067, 10.4852, 0.054447, 27.5730, 0.251877},
  {"Fe", 26, 0, 11.7695, 4.76110, 7.35730, 0.307200, 3.52220, 15.3535, 2.30450, 76.8805, 1.03690},
  {"Fe2+", 26, +2, 11.0424, 4.65380, 7.37400, 0.305300, 4.13460, 12.0546, 0.439900, 31.2809, 1.00970},
  {"Fe3+", 26, +3, 11.1764, 4.61470, 7.38630, 0.300500, 3.39480, 11.6729, 0.072400, 38.5566, 0.970700},
  {"Co", 27, 0, 12.2841, 4.27910, 7.34090, 0.278400, 4.00340, 13.5359, 2.34880, 71.1692, 1.01180},
  {"Co2+", 27, +2, 11.2296, 4.12310, 7.38830, 0.272600, 4.73930, 10.2443, 0.710800, 25.6466, 0.932400},
  {"Co3+", 27, +3, 10.3380, 3.90969, 7.88173, 0.238668, 4.76795, 8.35583, 0.725591, 18.3491, 0.286667},
  {"Ni", 28, 0, 12.8376, 3.87850, 7.29200, 0.256500, 4.44380, 12.1763, 2.38000, 66.3421, 1.0341},
  {"Ni2+", 28, +2, 11.4166, 3.67660, 7.40050, 0.244900, 5.34420, 8.87300, 0.977300, 22.1626, 0.861400},
  {"Ni3+", 28, +3, 10.7806, 3.54770, 7.75868, 0.223140, 5.22746, 7.64468, 0.847114, 16.9673, 0.386044},
  {"Cu", 29, 0, 13.3380, 3.58280, 7.16760, 0.247000, 5.61580, 11.3966, 1.67350, 64.8126, 1.19100},
  {"Cu1+", 29, +1, 11.9475, 3.36690, 7.35730, 0.227400, 6.24550, 8.66250, 1.55780, 25.8487, 0.89000},
  {"Cu2+", 29, +2, 11.8168, 3.37484, 7.11181, 0.244078, 5.78135, 7.98760, 1.14523, 19.8970, 1.14431},
  {"Zn", 30, 0, 14.0743, 3.26550, 7.03180, 0.233300, 5.16520, 10.3163, 2.41000, 58.7097, 1.30410},
  {"Zn2+", 30, +2, 11.9719, 2.99460, 7.38620, 0.203100, 6.46680, 7.08260, 1.39400, 18.0995, 0.780700},
  {"Ga", 31, 0, 15.2354, 3.06690, 6.70060, 0.241200, 4.35910, 10.7805, 2.96230, 61.4135, 1.71890},
  {"Ga3+", 31, +3, 12.6920, 2.81262, 6.69883, 0.227890, 6.06692, 6.36441, 1.00660, 14.4122, 1.53545},
  {"Ge", 32, 0, 16.0816, 2.85090, 6.37470, 0.251600, 3.70680, 11.4468, 3.68300, 54.7625, 2.13130},
  {"Ge4+", 32, +4, 12.9172, 2.53718, 6.70003, 0.205855, 6.06791, 5.47913, 0.859041, 11.6030, 1.45572},
  {"As", 33, 0, 16.6723, 2.63450, 6.07010, 0.264700, 3.43130, 12.9479, 4.27790, 47.7972, 2.53100},
  {"Se", 34, 0, 17.0006, 2.40980, 5.81960, 0.272600, 3.97310, 15.2372, 4.35430, 43.8163, 2.84090},
  {"Br", 35, 0, 17.1789, 2.17230, 5.23580, 16.5796, 5.63770, 0.260900, 3.98510, 41.4328, 2.95570},
  {"Br1-", 35, -1, 17.1718, 2.20590, 6.33380, 19.3345, 5.57540, 0.287100, 3.72720, 58.1535, 3.17760},
  {"Kr", 36, 0, 17.3555, 1.93840, 6.72860, 16.5623, 5.54930, 0.226100, 3.53750, 39.3972, 2.82500},
  {"Rb", 37, 0, 17.1784, 1.78880, 9.64350, 17.3151, 5.13990, 0.274800, 1.52920, 164.934, 3.48730},
  {"Rb1+", 37, +1, 17.5816, 1.71390, 7.65980, 14.7957, 5.89810, 0.160300, 2.78170, 31.2087, 2.07820},
  {"Sr", 38, 0, 17.5663, 1.55640, 9.81840, 14.0988, 5.42200, 0.166400, 2.66940, 132.376, 2.50640},
  {"Sr2+", 38, +2, 18.0874, 1.49070, 8.13730, 12.6963, 2.56540, 24.5651, -34.193, -0.01380, 41.4025},
  {"Y", 39, 0, 17.7760, 1.40290, 10.2946, 12.8006, 5.72629, 0.125599, 3.26588, 104.354, 1.91213},
  {"Y3+", 39, +3, 17.9268, 1.35417, 9.15310, 11.2145, 1.76795, 22.6599, -33.108, -0.01319, 40.2602},
  {"Zr", 40, 0, 17.8765, 1.27618, 10.9480, 11.9160, 5.41732, 0.117622, 3.65721, 87.6627, 2.06929},
  {"Zr4+", 40, +4, 18.1668, 1.21480, 10.0562, 10.1483, 1.01118, 21.6054, -2.6479, -0.10276, 9.41454},
  {"Nb", 41, 0, 17.6142, 1.18865, 12.0144, 11.7660, 4.04183, 0.204785, 3.53346, 69.7957, 3.75591},
  {"Nb3+", 41, +3, 19.8812, 0.019175, 18.0653, 1.13305, 11.0177, 10.1621, 1.94715, 28.3389, -12.912},
  {"Nb5+", 41, +5, 17.9163, 1.12446, 13.3417, 0.028781, 10.7990, 9.28206, 0.337905, 25.7228, -6.3934},
  {"Mo", 42, 0, 3.70250, 0.277200, 17.2356, 1.09580, 12.8876, 11.0040, 3.74290, 61.6584, 4.38750},
  {"Mo3+", 42, +3, 21.1664, 0.014734, 18.2017, 1.03031, 11.7423, 9.53659, 2.30951, 26.6307, -14.421},
  {"Mo5+", 42, +5, 21.0149, 0.014345, 18.0992, 1.02238, 11.4632, 8.78809, 0.740625, 23.3452, -14.316},
  {"Mo6+", 42, +6, 17.8871, 1.03649, 11.1750, 8.48061, 6.57891, 0.058881, 0.000000, 0.000000, 0.344941},
  {"Tc", 43, 0, 19.1301, 0.864132, 11.0948, 8.14487, 4.64901, 21.5707, 2.71263, 86.8472, 5.40428},
  {"Ru", 44, 0, 19.2674, 0.808520, 12.9182, 8.43467, 4.86337, 24.7997, 1.56756, 94.2928, 5.37874},
  {"Ru3+", 44, +3, 18.5638, 0.847329, 13.2885, 8.37164, 9.32602, 0.017662, 3.00964, 22.8870, -3.1892},
  {"Ru4+", 44, +4, 18.5003, 0.844582, 13.1787, 8.12534, 4.71304, 0.36495, 2.18535, 20.8504, 1.42357},
  {"Rh", 45, 0, 19.2957, 0.751536, 14.3501, 8.21758, 4.73425, 25.8749, 1.28918, 98.6062, 5.32800},
  {"Rh3+", 45, +3, 18.8785, 0.764252, 14.1259, 7.84438, 3.32515, 21.2487, -6.1989, -0.01036, 11.8678},
  {"Rh4+", 45, +4, 18.8545, 0.760825, 13.9806, 7.62436, 2.53464, 19.3317, -5.6526, -0.01020, 11.2835},
  {"Pd", 46, 0, 19.3319, 0.698655, 15.5017, 7.98929, 5.29537, 25.2052, 0.605844, 76.8986, 5.26593},
  {"Pd2+", 46, +2, 19.1701, 0.696219, 15.2096, 7.55573, 4.32234, 22.5057, 0.000000, 0.000000, 5.29160},
  {"Pd4+", 46, +4, 19.2493, 0.683839, 14.7900, 7.14833, 2.89289, 17.9144, -7.9492, 0.005127, 13.0174},
  {"Ag", 47, 0, 19.2808, 0.644600, 16.6885, 7.47260, 4.80450, 24.6605, 1.04630, 99.8156, 5.17900},
  {"Ag1+", 47, +1, 19.1812, 0.646179, 15.9719, 7.19123, 5.27475, 21.7326, 0.357534, 66.1147, 5.21572},
  {"Ag2+", 47, +2, 19.1643, 0.645643, 16.2456, 7.18544, 4.37090, 21.4072, 0.000000, 0.000000, 5.21404},
  {"Cd", 48, 0, 19.2214, 0.594600, 17.6444, 6.90890, 4.46100, 24.7008, 1.60290, 87.4825, 5.06940},
  {"Cd2+", 48, +2, 19.1514, 0.597922, 17.2535, 6.80639, 4.47128, 20.2521, 0.000000, 0.000000, 5.11937},
  {"In", 49, 0, 19.1624, 0.547600, 18.5596, 6.37760, 4.29480, 25.8499, 2.03960, 92.8029, 4.93910},
  {"In3+", 49, +3, 19.1045, 0.551522, 18.1108, 6.32470, 3.78897, 17.3595, 0.000000, 0.000000, 4.99635},
  {"Sn", 50, 0, 19.1889, 5.83030, 19.1005, 0.503100, 4.45850, 26.8909, 2.46630, 83.9571, 4.78210},
  {"Sn2+", 50, +2, 19.1094, 0.503600, 19.0548, 5.83780, 4.56480, 23.3752, 0.487000, 62.2061, 4.78610},
  {"Sn4+", 50, +4, 18.9333, 5.76400, 19.7131, 0.465500, 3.41820, 14.0049, 0.019300, -0.75830, 3.91820},
  {"Sb", 51, 0, 19.6418, 5.30340, 19.0455, 0.460700, 5.03710, 27.9074, 2.68270, 75.2825, 4.59090},
  {"Sb3+", 51, +3, 18.9755, 0.467196, 18.9330, 5.22126, 5.10789, 19.5902, 0.288753, 55.5113, 4.69626},
  {"Sb5+", 51, +5, 19.8685, 5.44853, 19.0302, 0.467973, 2.41253, 14.1259, 0.000000, 0.000000, 4.69263},
  {"Te", 52, 0, 19.9644, 4.81742, 19.0138, 0.420885, 6.14487, 28.5284, 2.52390, 70.8403, 4.35200},
  {"I", 53, 0, 20.1472, 4.34700, 18.9949, 0.381400, 7.51380, 27.7660, 2.27350, 66.8776, 4.07120},
  {"I1-", 53, -1, 20.2332, 4.35790, 18.9970, 0.381500, 7.80690, 29.5259, 2.88680, 84.9304, 4.07140},
  {"Xe", 54, 0, 20.2933, 3.92820, 19.0298, 0.344000, 8.97670, 26.4659, 1.99000, 64.2658, 3.71180},
  {"Cs", 55, 0, 20.3892, 3.56900, 19.1062, 0.310700, 10.6620, 24.3879, 1.49530, 213.904, 3.33520},
  {"Cs1+", 55, +1, 20.3524, 3.55200, 19.1278, 0.308600, 10.2821, 23.7128, 0.961500, 59.4565, 3.27910},
  {"Ba", 56, 0, 20.3361, 3.21600, 19.2970, 0.275600, 10.8880, 20.2073, 2.69590, 167.202, 2.77310},
  {"Ba2+", 56, +2, 20.1807, 3.21367, 19.1136, 0.283310, 10.9054, 20.0558, 0.77634, 51.7460, 3.02902},
  {"La", 57, 0, 20.5780, 2.94817, 19.5990, 0.244475, 11.3727, 18.7726, 3.28719, 133.124, 2.14678},
  {"La3+", 57, +3, 20.2489, 2.92070, 19.3763, 0.250698, 11.6323, 17.8211, 0.336048, 54.9453, 2.40860},
  {"Ce", 58, 0, 21.1671, 2.81219, 19.7695, 0.226836, 11.8513, 17.6083, 3.33049, 127.113, 1.86264},
  {"Ce3+", 58, +3, 20.8036, 2.77691, 19.5590, 0.231540, 11.9369, 16.5408, 0.612376, 43.1692, 2.09013},
  {"Ce4+", 58, +4, 20.3235, 2.65941, 19.8186, 0.218850, 12.1233, 15.7992, 0.144583, 62.2355, 1.59180},
  {"Pr", 59, 0, 22.0440, 2.77393, 19.6697, 0.222087, 12.3856, 16.7669, 2.82428, 143.644, 2.05830},
  {"Pr3+", 59, +3, 21.3727, 2.64520, 19.7491, 0.214299, 12.1329, 15.3230, 0.975180, 36.4065, 1.77132},
  {"Pr4+", 59, +4, 20.9413, 2.54467, 20.0539, 0.202481, 12.4668, 14.8137, 0.296689, 45.4643, 1.24285},
  {"Nd", 60, 0, 22.6845, 2.66248, 19.6847, 0.210628, 12.7740, 15.8850, 2.85137, 137.903, 1.98486},
  {"Nd3+", 60, +3, 21.9610, 2.52722, 19.9339, 0.199237, 12.1200, 14.1783, 1.51031, 30.8717, 1.47588},
  {"Pm", 61, 0, 23.3405, 2.56270, 19.6095, 0.202088, 13.1235, 15.1009, 2.87516, 132.721, 2.02876},
  {"Pm3+", 61, +3, 22.5527, 2.41740, 20.1108, 0.185769, 12.0671, 13.1275, 2.07492, 27.4491, 1.19499},
  {"Sm", 62, 0, 24.0042, 2.47274, 19.4258, 0.196451, 13.4396, 14.3996, 2.89604, 128.007, 2.20963},
  {"Sm3+", 62, +3, 23.1504, 2.31641, 20.2599, 0.174081, 11.9202, 12.1571, 2.71488, 24.8242, 0.954586},
  {"Eu", 63, 0, 24.6274, 2.38790, 19.0886, 0.194200, 13.7603, 13.7546, 2.92270, 123.174, 2.57450},
  {"Eu2+", 63, +2, 24.0063, 2.27783, 19.9504, 0.173530, 11.8034, 11.6096, 3.87243, 26.5156, 1.36389},
  {"Eu3+", 63, +3, 23.7497, 2.22258, 20.3745, 0.163940, 11.8509, 11.3110, 3.26503, 22.9966, 0.759344},
  {"Gd", 64, 0, 25.0709, 2.25341, 19.0798, 0.181951, 13.8518, 12.9331, 3.54545, 101.398, 2.41960},
  {"Gd3+", 64, +3, 24.3466, 2.13553, 20.4208, 0.155525, 11.8708, 10.5782, 3.71490, 21.7029, 0.645089},
  {"Tb", 65, 0, 25.8976, 2.24256, 18.2185, 0.196143, 14.3167, 12.6648, 2.95354, 115.362, 3.58324},
  {"Tb3+", 65, +3, 24.9559, 2.05601, 20.3271, 0.149525, 12.2471, 10.0499, 3.77300, 21.2773, 0.691967},
  {"Dy", 66, 0, 26.5070, 2.18020, 17.6383, 0.202172, 14.5596, 12.1899, 2.96577, 111.874, 4.29728},
  {"Dy3+", 66, +3, 25.5395, 1.98040, 20.2861, 0.143384, 11.9812, 9.34972, 4.50073, 19.5810, 0.689690},
  {"Ho", 67, 0, 26.9049, 2.07051, 17.2940, 0.197940, 14.5583, 11.4407, 3.63837, 92.6566, 4.56796},
  {"Ho3+", 67, +3, 26.1296, 1.91072, 20.0994, 0.139358, 11.9788, 8.80018, 4.93676, 18.5908, 0.852795},
  {"Er", 68, 0, 27.6563, 2.07356, 16.4285, 0.223545, 14.9779, 11.3604, 2.98233, 105.703, 5.92046},
  {"Er3+", 68, +3, 26.7220, 1.84659, 19.7748, 0.137290, 12.1506, 8.36225, 5.17379, 17.8974, 1.17613},
  {"Tm", 69, 0, 28.1819, 2.02859, 15.8851, 0.238849, 15.1542, 10.9975, 2.98706, 102.961, 6.75621},
  {"Tm3+", 69, +3, 27.3083, 1.78711, 19.3320, 0.136974, 12.3339, 7.96778, 5.38348, 17.2922, 1.63929},
  {"Yb", 70, 0, 28.6641, 1.98890, 15.4345, 0.257119, 15.3087, 10.6647, 2.98963, 100.417, 7.56672},
  {"Yb2+", 70, +2, 28.1209, 1.78503, 17.6817, 0.159970, 13.3335, 8.18304, 5.14657, 20.3900, 3.70983},
  {"Yb3+", 70, +3, 27.8917, 1.73272, 18.7614, 0.138790, 12.6072, 7.64412, 5.47647, 16.8153, 2.26001},
  {"Lu", 71, 0, 28.9476, 1.90182, 15.2208, 9.98519, 15.1000, 0.261033, 3.71601, 84.3298, 7.97628},
  {"Lu3+", 71, +3, 28.4628, 1.68216, 18.1210, 0.142292, 12.8429, 7.33727, 5.59415, 16.3535, 2.97573},
  {"Hf", 72, 0, 29.1440, 1.83262, 15.1726, 9.59990, 14.7586, 0.275116, 4.30013, 72.0290, 8.58154},
  {"Hf4+", 72, +4, 28.8131, 1.59136, 18.4601, 0.128903, 12.7285, 6.76232, 5.59927, 14.0366, 2.39699},
  {"Ta", 73, 0, 29.2024, 1.77333, 15.2293, 9.37046, 14.5135, 0.295977, 4.76492, 63.3644, 9.24354},
  {"Ta5+", 73, +5, 29.1587, 1.50711, 18.8407, 0.116741, 12.8268, 6.31524, 5.38695, 12.4244, 1.78555},
  {"W", 74, 0, 29.0818, 1.72029, 15.4300, 9.22590, 14.4327, 0.321703, 5.11982, 57.0560, 9.88750},
  {"W6+", 74, +6, 29.4936, 1.42755, 19.3763, 0.104621, 13.0544, 5.93667, 5.06412, 11.1972, 1.01074},
  {"Re", 75, 0, 28.7621, 1.67191, 15.7189, 9.09227, 14.5564, 0.350500, 5.44174, 52.0861, 10.4720},
  {"Os", 76, 0, 28.1894, 1.62903, 16.1550, 8.97948, 14.9305, 0.382661, 5.67589, 48.1647, 11.0005},
  {"Os4+", 76, +4, 30.4190, 1.37113, 15.2637, 6.84706, 14.7458, 0.165191, 5.06795, 18.0030, 6.49804},
  {"Ir", 77, 0, 27.3049, 1.59279, 16.7296, 8.86553, 15.6115, 0.417916, 5.83377, 45.0011, 11.4722},
  {"Ir3+", 77, +3, 30.4156, 1.34323, 15.8620, 7.10909, 13.6145, 0.204633, 5.82008, 20.3254, 8.27903},
  {"Ir4+", 77, +4, 30.7058, 1.30923, 15.5512, 6.71983, 14.2326, 0.167252, 5.53672, 17.4911, 6.96824},
  {"Pt", 78, 0, 27.0059, 1.51293, 17.7639, 8.81174, 15.7131, 0.424593, 5.78370, 38.6103, 11.6883},
  {"Pt2+", 78, +2, 29.8429, 1.32927, 16.7224, 7.38979, 13.2153, 0.263297, 6.35234, 22.9426, 9.85329},
  {"Pt4+", 78, +4, 30.9612, 1.24813, 15.9829, 6.60834, 13.7348, 0.168640, 5.92034, 16.9392, 7.39534},
  {"Au", 79, 0, 16.8819, 0.461100, 18.5913, 8.62160, 25.5582, 1.48260, 5.86000, 36.3956, 12.0658},
  {"Au1+", 79, +1, 28.0109, 1.35321, 17.8204, 7.73950, 14.3359, 0.356752, 6.58077, 26.4043, 11.2299},
  {"Au3+", 79, +3, 30.6886, 1.21990, 16.9029, 6.82872, 12.7801, 0.212867, 6.52354, 18.6590, 9.09680},
  {"Hg", 80, 0, 20.6809, 0.545000, 19.0417, 8.44840, 21.6575, 1.57290, 5.96760, 38.3246, 12.6089},
  {"Hg1+", 80, +1, 25.0853, 1.39507, 18.4973, 7.65105, 16.8883, 0.443378, 6.48216, 28.2262, 12.0205},
  {"Hg2+", 80, +2, 29.5641, 1.21152, 18.0600, 7.05639, 12.8374, 0.284738, 6.89912, 20.7482, 10.6268},
  {"Tl", 81, 0, 27.5446, 0.655150, 19.1584, 8.70751, 15.5380, 1.96347, 5.52593, 45.8149, 13.1746},
  {"Tl1+", 81, +1, 21.3985, 1.47110, 20.4723, 0.517394, 18.7478, 7.43463, 6.82847, 28.8482, 12.5258},
  {"Tl3+", 81, +3, 30.8695, 1.10080, 18.3481, 6.53852, 11.9328, 0.219074, 7.00574, 17.2114, 9.80270},
  {"Pb", 82, 0, 31.0617, 0.690200, 13.0637, 2.35760, 18.4420, 8.61800, 5.96960, 47.2579, 13.4118},
  {"Pb2+", 82, +2, 21.7886, 1.33660, 19.5682, 0.488383, 19.1406, 6.77270, 7.01107, 23.8132, 12.4734},
  {"Pb4+", 82, +4, 32.1244, 1.00566, 18.8003, 6.10926, 12.0175, 0.147041, 6.96886, 14.7140, 8.08428},
  {"Bi", 83, 0, 33.3689, 0.704000, 12.9510, 2.92380, 16.5877, 8.79370, 6.46920, 48.0093, 13.5782},
  {"Bi3+", 83, +3, 21.8053, 1.23560, 19.5026, 6.24149, 19.1053, 0.469999, 7.10295, 20.3185, 12.4711},
  {"Bi5+", 83, +5, 33.5364, 0.916540, 25.0946, 0.39042, 19.2497, 5.71414, 6.91555, 12.8285, -6.7994},
  {"Po", 84, 0, 34.6726, 0.700999, 15.4733, 3.55078, 13.1138, 9.55642, 7.02588, 47.0045, 13.6770},
  {"At", 85, 0, 35.3163, 0.685870, 19.0211, 3.97458, 9.49887, 11.3824, 7.42518, 45.4715, 13.7108},
  {"Rn", 86, 0, 35.5631, 0.663100, 21.2816, 4.06910, 8.00370, 14.0422, 7.44330, 44.2473, 13.6905},
  {"Fr", 87, 0, 35.9299, 0.646453, 23.0547, 4.17619, 12.1439, 23.1052, 2.11253, 150.645, 13.7247},
  {"Ra", 88, 0, 35.7630, 0.616341, 22.9064, 3.87135, 12.4739, 19.9887, 3.21097, 142.325, 13.6211},
  {"Ra2+", 88, +2, 35.2150, 0.604909, 21.6700, 3.57670, 7.91342, 12.6010, 7.65078, 29.8436, 13.5431},
  {"Ac", 89, 0, 35.6597, 0.589092, 23.1032, 3.65155, 12.5977, 18.5990, 4.08655, 117.020, 13.5266},
  {"Ac3+", 89, +3, 35.1736, 0.579689, 22.1112, 3.41437, 8.19216, 12.9187, 7.05545, 25.9443, 13.4637},
  {"Th", 90, 0, 35.5645, 0.563359, 23.4219, 3.46204, 12.7473, 17.8309, 4.80703, 99.1722, 13.4314},
  {"Th4+", 90, +4, 35.1007, 0.555054, 22.4418, 3.24498, 9.78554, 13.4661, 5.29444, 23.9533, 13.3760},
  {"Pa", 91, 0, 35.8847, 0.547751, 23.2948, 3.41519, 14.1891, 16.9235, 4.17287, 105.251, 13.4287},
  {"U", 92, 0, 36.0228, 0.529300, 23.4128, 3.32530, 14.9491, 16.0927, 4.18800, 100.613, 13.3966},
  {"U3+", 92, +3, 35.5747, 0.520480, 22.5259, 3.12293, 12.2165, 12.7148, 5.37073, 26.3394, 13.3092},
  {"U4+", 92, +4, 35.3715, 0.516598, 22.5326, 3.05053, 12.0291, 12.5723, 4.79840, 23.4582, 13.2671},
  {"U6+", 92, +6, 34.8509, 0.507079, 22.7584, 2.89030, 14.0099, 13.1767, 1.21457, 25.2017, 13.1665},
  {"Np", 93, 0, 36.1874, 0.511929, 23.5964, 3.25396, 15.6402, 15.3622, 4.18550, 97.4908, 13.3573},
  {"Np3+", 93, +3, 35.7074, 0.502322, 22.6130, 3.03807, 12.9898, 12.1449, 5.43227, 25.4928, 13.2544},
  {"Np4+", 93, +4, 35.5103, 0.498626, 22.5787, 2.96627, 12.7766, 11.9484, 4.92159, 22.7502, 13.2116},
  {"Np6+", 93, +6, 35.0136, 0.489810, 22.7286, 2.81099, 14.3884, 12.3300, 1.75669, 22.6581, 13.1130},
  {"Pu", 94, 0, 36.5254, 0.499384, 23.8083, 3.26371, 16.7707, 14.9455, 3.47947, 105.980, 13.3812},
  {"Pu3+", 94, +3, 35.8400, 0.484938, 22.7169, 2.96118, 13.5807, 11.5331, 5.66016, 24.3992, 13.1991},
  {"Pu4+", 94, +4, 35.6493, 0.481422, 22.6460, 2.89020, 13.3595, 11.3160, 5.18831, 21.8301, 13.1555},
  {"Pu6+", 94, +6, 35.1736, 0.473204, 22.7181, 2.73848, 14.7635, 11.5530, 2.28678, 20.9303, 13.0582},
  {"Am", 95, 0, 36.6706, 0.483629, 24.0992, 3.20647, 17.3415, 14.3136, 3.49331, 102.273, 13.3592},
  {"Cm", 96, 0, 36.6488, 0.465154, 24.4096, 3.08997, 17.3990, 13.4346, 4.21665, 88.4834, 13.2887},
  {"Bk", 97, 0, 36.7881, 0.451018, 24.7736, 3.04619, 17.8919, 12.8946, 4.23284, 86.0030, 13.2754},
  {"Cf", 98, 0, 36.9185, 0.437533, 25.1995, 3.00775, 18.3317, 12.4044, 4.24391, 83.7881, 13.2674},
};/*}}}*/

struct {
  char symbol[2];
  int Z,ion_charge;
  double a[4];
} form_factor_hi_q_data[]={/*{{{*/
  {"H", 1, 0, 0, 0, 0, 0},
  {"He", 2, 0,  0.52543, -3.43300, 4.80070, -2.54760},
  {"Li", 3, 0,  0.89463, -2.43660, 2.32500, -0.71949},
  {"Be", 4, 0,  1.25840, -1.94590, 1.30460, -0.04297},
  {"B", 5, 0,  1.66720, -1.85560, 1.60440, -0.65981},
  {"C", 6, 0,  1.70560, -1.56760, 1.18930, -0.42715},
  {"N", 7, 0,  1.54940, -1.20190, 0.51064, 0.02472},
  {"O", 8, 0,  1.30530, -0.83742, -0.16738, 0.47500},
  {"F", 9, 0,  1.16710, -0.63203, -0.40207, 0.54352},
  {"Ne", 10, 0,  1.09310, -0.50221, -0.53648, 0.60957},
  {"Na", 11, 0,  0.84558, -0.26294, -0.87884, 0.76974},
  {"Mg", 12, 0,  0.71877, -0.13144, -1.20900, 0.82738},
  {"Al", 13, 0,  0.67975, -0.08756, -0.95431, 0.72294},
  {"Si", 14, 0,  0.70683, -0.09888, -0.98356, 0.55631},
  {"P", 15, 0,  0.85532, -0.21262, -0.37390, 0.20731},
  {"S", 16, 0,  1.10400, -0.40325, 0.20094, -0.26058},
  {"Cl", 17, 0,  1.42320, -0.63936, 0.84722, -0.76135},
  {"Ar", 18, 0,  1.82020, -0.92776, 1.59220, -1.32510},
  {"K", 19, 0,  2.26550, -1.24530, 2.38330, -1.91290},
  {"Ca", 20, 0,  2.71740, -1.55670, 3.13170, -2.45670},
  {"Sc", 21, 0,  3.11730, -1.81380, 3.71390, -2.85330},
  {"Ti", 22, 0,  3.45360, -2.01150, 4.13170, -3.11710},
  {"V", 23, 0,  3.71270, -2.13920, 4.34610, -3.22040},
  {"Cr", 24, 0,  3.87870, -2.19000, 4.38670, -3.17520},
  {"Mn", 25, 0,  3.98550, -2.18850, 4.27960, -3.02150},
  {"Fe", 26, 0,  3.99790, -2.11080, 3.98170, -2.71990},
  {"Co", 27, 0,  3.95900, -1.99650, 3.60630, -2.37050},
  {"Ni", 28, 0,  3.86070, -1.88690, 3.12390, -1.94290},
  {"Cu", 29, 0,  3.72510, -1.65500, 2.60290, -1.49760},
  {"Zn", 30, 0,  3.55950, -1.45100, 2.03390, -1.02160},
  {"Ga", 31, 0,  3.37560, -1.23910, 1.46160, -0.55471},
  {"Ge", 32, 0,  3.17800, -1.02230, 0.89119, -0.09884},
  {"As", 33, 0,  2.97740, -0.81038, 0.34861, 0.32231},
  {"Se", 34, 0,  2.78340, -0.61110, -0.14731, 0.69837},
  {"Br", 35, 0,  2.60610, -0.43308, -0.57381, 1.00950},
  {"Kr", 36, 0,  2.44280, -0.27244, -0.95570, 1.27070},
  {"Rb", 37, 0,  2.30990, -0.14328, -1.22600, 1.45320},
  {"Sr", 38, 0,  2.21070, -0.04770, -1.41100, 1.55410},
  {"Y", 39, 0,  2.14220, 0.01935, -1.52240, 1.59630},
  {"Zr", 40, 0,  2.12690, 0.08618, -1.49190, 1.51820},
  {"Nb", 41, 0,  2.12120, 0.05381, -1.50070, 1.50150},
  {"Mo", 42, 0,  2.18870, -0.00655, -1.25340, 1.24010},
  {"Tc", 43, 0,  2.25730, -0.05737, -1.07450, 1.06630},
  {"Ru", 44, 0,  2.37300, -0.15040, -0.77694, 0.79060},
  {"Rh", 45, 0,  2.50990, -0.25906, -0.44719, 0.49443},
  {"Pd", 46, 0,  2.67520, -0.39137, -0.05894, 0.15404},
  {"Ag", 47, 0,  2.88690, -0.56119, 0.42189, -0.25659},
  {"Cd", 48, 0,  3.08430, -0.71450, 0.84482, -0.60990},
  {"In", 49, 0,  3.31400, -0.89697, 1.35030, -1.03910},
  {"Sn", 50, 0,  3.49840, -1.02990, 1.68990, -1.29860},
  {"Sb", 51, 0,  3.70410, -1.18270, 2.08920, -1.61640},
  {"Te", 52, 0,  3.88240, -1.30980, 2.41170, -1.86420},
  {"I", 53, 0,  4.08010, -1.45080, 2.76730, -2.13920},
  {"Xe", 54, 0,  4.24610, -1.56330, 3.04200, -2.34290},
  {"Cs", 55, 0,  4.38910, -1.65420, 3.25450, -2.49220},
  {"Ba", 56, 0,  4.51070, -1.72570, 3.41320, -2.59590},
  {"La", 57, 0,  4.60250, -1.77070, 3.49970, -2.64050},
  {"Ce", 58, 0,  4.69060, -1.81790, 3.60280, -2.70670},
  {"Pr", 59, 0,  4.72150, -1.81390, 3.56480, -2.65180},
  {"Nd", 60, 0,  4.75090, -1.80800, 3.51970, -2.59010},
  {"Pm", 61, 0,  4.74070, -1.76600, 3.37430, -2.44210},
  {"Sm", 62, 0,  4.71700, -1.71410, 3.20800, -2.28170},
  {"Eu", 63, 0,  4.66940, -1.64140, 2.98580, -2.07460},
  {"Gd", 64, 0,  4.61010, -1.55750, 2.73190, -1.84040},
  {"Tb", 65, 0,  4.52550, -1.45520, 2.43770, -1.57950},
  {"Dy", 66, 0,  4.45230, -1.36440, 2.17540, -1.34550},
  {"Ho", 67, 0,  4.37660, -1.27460, 1.92540, -1.13090},
  {"Er", 68, 0,  4.29460, -1.18170, 1.67060, -0.91467},
  {"Tm", 69, 0,  4.21330, -1.09060, 1.42390, -0.70804},
  {"Yb", 70, 0,  4.13430, -1.00310, 1.18810, -0.51120},
  {"Lu", 71, 0,  4.04230, -0.90518, 0.92889, -0.29820},
  {"Hf", 72, 0,  3.95160, -0.80978, 0.68951, -0.09620},
  {"Ta", 73, 0,  3.85000, -0.70599, 0.41103, 0.11842},
  {"W", 74, 0,  3.76510, -0.61807, 0.18568, 0.29787},
  {"Re", 75, 0,  3.67600, -0.52688, -0.04706, 0.48180},
  {"Os", 76, 0,  3.60530, -0.45420, -0.22529, 0.61700},
  {"Ir", 77, 0,  3.53130, -0.37856, -0.41174, 0.75967},
  {"Pt", 78, 0,  3.47070, -0.31534, -0.56487, 0.87492},
  {"Au", 79, 0,  3.41630, -0.25987, -0.69030, 0.96224},
  {"Hg", 80, 0,  3.37350, -0.21428, -0.79013, 1.02850},
  {"Tl", 81, 0,  3.34590, -0.18322, -0.84911, 1.05970},
  {"Pb", 82, 0,  3.32330, -0.15596, -0.89878, 1.08380},
  {"Bi", 83, 0,  3.31880, -0.14554, -0.90198, 1.06850},
  {"Po", 84, 0,  3.32030, -0.13999, -0.89333, 1.04380},
  {"At", 85, 0,  3.34250, -0.15317, -0.83350, 0.97641},
  {"Rn", 86, 0,  3.37780, -0.17800, -0.74320, 0.88510},
  {"Fr", 87, 0,  3.41990, -0.20823, -0.64000, 0.78354},
  {"Ra", 88, 0,  3.47530, -0.25005, -0.50660, 0.65836},
  {"Ac", 89, 0,  3.49020, -0.25109, -0.49651, 0.64340},
  {"Th", 90, 0,  3.61060, -0.35409, -0.18926, 0.36849},
  {"Pa", 91, 0,  3.68630, -0.41329, -0.01192, 0.20878},
  {"U", 92, 0,  3.76650, -0.47542, 0.16850, 0.05060},
  {"Np", 93, 0,  3.82870, -0.51955, 0.29804, -0.06566},
  {"Pu", 94, 0,  3.88970, -0.56296, 0.42597, -0.18080},
  {"Am", 95, 0,  3.95060, -0.60554, 0.54967, -0.29112},
  {"Cm", 96, 0,  4.01470, -0.65062, 0.67922, -0.40588},
  {"Bk", 97, 0,  4.07780, -0.69476, 0.80547, -0.51729},
  {"Cf", 98, 0,  4.14210, -0.73977, 0.93342, -0.62981},
};/*}}}*/

double atomic_form_factor_low_q(int j, double s){
  int i;
  double f=form_factor_low_q_data[j].c;
  double s2=pow(s,2.0);
  for (i=0;i<8;i+=2){
    f+=form_factor_low_q_data[j].ab[i]*exp(-form_factor_low_q_data[j].ab[i+1]*s2);
  }
  return f;
}

double atomic_form_factor_hi_q(int j, double s){
  if (j==0){
    /*this is a hydrogen atom, use the value for s=2 (very small) as this model won't work here*/
    return atomic_form_factor_low_q(0.0, s);
  }else{
    int i;
    double f;
    f=form_factor_hi_q_data[j].a[0] + form_factor_hi_q_data[j].a[1]*s + form_factor_hi_q_data[j].a[2]*0.1*s*s + form_factor_hi_q_data[j].a[3]*0.01*s*s*s;
    return exp(f);
  }
}

double atomic_form_factor(int Z, int ion_charge, double q){
  double s=q/(4*M_PI);
  if(s<2&& s>=0){
    int j=Z-1;
    while (form_factor_low_q_data[j].Z!=Z || form_factor_low_q_data[j].ion_charge!=ion_charge){
      j++;
    }
    if (j==131) return 0;/*not found - should drop an error*/
    return atomic_form_factor_low_q(j,s);
  }else if (s<6.0){
    return atomic_form_factor_hi_q(Z-1,s);
  }else{
    return 0;
  }
}

double atomic_form_factor_by_sym(char *sym, double q){
  if(q<2.0&& q>=0){
    int j=0;
    while (strcmp(form_factor_low_q_data[j].symbol,sym)) j++;
    if (j==131) return 0;/*not found - should drop an error*/
    return atomic_form_factor_low_q(j,q);
  }else if (q<6.0){
    int j=0;
    while (strncmp(form_factor_hi_q_data[j].symbol, sym, 2)) j++;
    if (j==98) return 0;/*not found - should drop an error*/
    return atomic_form_factor_hi_q(j,q);
  }else{
    return 0;
  }
}

