.\"                              hey, Emacs:   -*- nroff -*-
.\" multispeech is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This program is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program; see the file COPYING.  If not, write to
.\" the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
.\"
.TH MULTISPEECH.CONF 5 "March 2, 2010"
.\" Please update the above date whenever this man page is modified.
.\"
.\" Some roff macros, for reference:
.\" .nh        disable hyphenation
.\" .hy        enable hyphenation
.\" .ad l      left justify
.\" .ad b      justify to both left and right margins (default)
.\" .nf        disable filling
.\" .fi        enable filling
.\" .br        insert line break
.\" .sp <n>    insert n+1 empty lines
.\" for manpage-specific macros, see man(7)
.SH NAME
multispeech.conf \- Multispeech configuration file
.SH DESCRIPTION
On startup \fBmultispeech\fP expects to find it's configuration
in \fI<sysconfdir>/multispeech.conf\fP and \fI~/.multispeechrc\fP.
The user settings provided by \fI~/.multispeechrc\fP
always take precedence over the system\-wide ones
from \fI<sysconfdir>/multispeech.conf\fP. And all these settings in turn
can be overridden by an extra configuration file specified via the
command line. Being started as \fBSpeech Dispatcher\fP module,
\fBmultispeech\fP treats the file specified in command line
as an extension of global configuration. Options specified there
override ones from the main system configuration file, but
\fI~/.multispeechrc takes precedence over the\fP both.
 Some configuration options are mandatory, so at least
one of these files must exist.
.SH "SYNTAX"
The syntax is quite simple.
.PP
Lines started from the \(oq#\(cq character are treated as comments.
Blank lines are ignored. Each option entry looks like follows:
.PP
keyword = value
.PP
Case is significant.
.PP
All options are logically grouped by sections.
Each section is started by its name in square brackets on a separate
line.
.SH "CLIENT INTERACTION CONTROL OPTIONS"
These options are grouped in the section named \(oqfrontend\(cq. These
options are as follows:
.TP
.B charset
.br
Input charset should be specified by its name. Available names
can be found in \fI/usr/share/i18n/SUPPORTED\fP or wherever else
it is on your system. By default this option is not set
so current locale setting is used.
.TP
.B native_voices
.br
Enable native voice control embedded commands.
.TP
.B dtk_voices
.br
Enable DECtalk voice control embedded commands.
.PP
These two options control inline parameters parsing. In the default
state only native voices are enabled, so \fBmultispeech\fP behaves as
it used to and accepts only special inline commands formed by
\fBemacspeak\fP. When dtk voices are enabled, \fBmultispeech\fP
recognizes DECtalk inline commands and tries to emulate some subset of
the DECtalk voice control capabilities. Use the word \(oqyes\(cq or
\(oqon\(cq to enable and the word \(oqno\(cq or \(oqoff\(cq to disable
the option. Nothing prevents to keep both options enabled
simultaneously. In this case DECtalk inline commands will be accepted
as well as the native ones. If both options are disabled, then inline
commands detection and parsing will not be performed at all.
.SH "GENERAL AUDIO OUTPUT CONTROL OPTIONS"
Section name is \(oqaudio\(cq. It contains following options:
.TP
.B device
.br
Default device for all audio output (speech, sounds and tones).
If it is not specified explicitly, then system default will be used.
The DSP device specifications (such as \(oq/dev/dsp\(cq)
are allowed here as well as the ALSA ones. Invoke \(oqmultispeech \-l\(cq
to get list of all available devices on your system.
.TP
.B general_volume
.br
Volume level applied to all audio output in general.
It should be in the range of (0.0..1.0]. When this option is not
specified the default value 0.8 is used.
.TP
.B latency
.br
Audio output latency in seconds. Special value 0.0 implies
that reasonable latency will be chosen automatically by system.
Normally this option should not be set up explicitly.
Do it only if you are pretty unsatisfied by the default.
.TP
.B async_operation
.br
This option enables truly asynchronous audio stream operation.
Normally it is absolutely not necessary, thus, disabled by default,
but theoretically there can be some circumstances where it would be
preferable. Use the word \(oqyes\(cq or \(oqon\(cq to enable and the word
\(oqno\(cq or \(oqoff\(cq to disable.
.TP
.B pulseaudio_direct
.br
This option allows direct usage of PulseAudio API for \(oqpulse\(cq and
\(oqdefault\(cq devices when \(oqpulse\(cq device is present in the system.
If it is disabled, these devices will be accessed via native host
API bridge. Use the word \(oqyes\(cq or \(oqon\(cq to enable and the word
\(oqno\(cq or \(oqoff\(cq to disable.
.SH "SOUNDS PLAYING CONTROL OPTIONS"
Section name is \(oqsounds\(cq. It contains several options that
affect sound file playing capability:
.TP
.B device
.br
Sound files playing device. This setting overwrites general default
and allows one to play sound files on a separate audio device.
The DSP device specifications (such as \(oq/dev/dsp\(cq)
are accepted here as well as the ALSA ones. Invoke \(oqmultispeech \-l\(cq
to get list of all available devices on your system.
.TP
.B volume
.br
Relative volume level for sound files playing. It is 1.0
by default.
.TP
.B asynchronous
.br
This option enables or disables to play sound files
simultaneously with other audio activities, such as
speech and tone signals producing. It is enabled by default.
Use the word \(oqyes\(cq or \(oqon\(cq to enable and the word
\(oqno\(cq or \(oqoff\(cq to disable.
.SH "TONE SIGNALS PRODUCING CONTROL OPTIONS"
Section name is \(oqtones\(cq. It consists of the following options:
.TP
.B device
.br
Tones producing device. This setting overwrites general default
and allows one to use a separate device for tone signals.
The DSP device specifications (such as \(oq/dev/dsp\(cq)
are accepted here as well as the ALSA ones. Invoke \(oqmultispeech \-l\(cq
to get list of all available devices on your system.
.TP
.B volume
.br
Relative volume level for tone signals producing. It is 1.0
by default.
.TP
.B sampling
.br
Sampling frequency for generated tone signals. It is 44100
by default.
.TP
.B asynchronous
.br
This option enables or disables to produce tone signals
simultaneously with other audio activities, such as
speech and sound files playing. It is enabled by default.
Use the word \(oqyes\(cq or \(oqon\(cq to enable and the word
\(oqno\(cq or \(oqoff\(cq to disable.
.SH "GENERAL SPEECH CONTROL OPTIONS"
Section name is \(oqspeech\(cq. These options affect speech output in
general:
.TP
.B device
.br
Speech output device. This setting overwrites general default
and allows one to produce speech on a separate audio device.
The DSP device specifications (such as \(oq/dev/dsp\(cq)
are accepted here as well as the ALSA ones. Invoke \(oqmultispeech \-l\(cq
to get list of all available devices on your system.
.TP
.B volume
.br
Relative volume level for speech output. It is 1.0 by default.
.TP
.B language
.br
This option specifies the language to speak. Allowed values are:
\(oqen\(cq for English, \(oqru\(cq for Russian, \(oqde\(cq for German,
\(oqfr\(cq for French, \(oqes\(cq for Spanish, \(oqpt\(cq for
Portuguese, \(oqit\(cq for Italian or \(oqautodetect\(cq for automatic
detection from the text nature. By default language is
autodetected. The language then may be changed on the fly during
runtime by respective commands.
.TP
.B fallback
.br
This option specifies the language that will be chosen when it should
be changed, but autodetection fails. Any supported language may be
specified here, of course, except of \(oqautodetect\(cq. Of course,
the language declared as a fallback must be available itself. See
below about language related options.
.SH "LANGUAGE RELATED SPEECH CONTROL OPTIONS"
There is a separate section for each supported language named
\(oqen\(cq for English, \(oqru\(cq for Russian, \(oqde\(cq for German,
\(oqfr\(cq for French, \(oqes\(cq for Spanish, \(oqpt\(cq for
Portuguese and \(oqit\(cq for Italian. These sections contain quite the
same collection of options that affect speech on a specific
language. Actual speech engine is chosen by the key option
\(oqengine\(cq. By default it is \(oqespeak\(cq for all languages.
If it is explicitly not set or set as \(oqdisabled\(cq then
the language will not be available in Multispeech and no resources
will be spent for it. Actual choice vary from language to language,
but these two values are always legitimate. It is not necessary to
define speech engine for each language, but at least one must be
defined. It is wise to define speech engine for only those languages
that are actually to be used or define speech engine for all languages
in global configuration and then locally disable some of them that are
not needed.
.PP
Each language specific section consists of the following options:
.TP
.B engine
.br
TTS engine specification. Allowed values are as follows:
.PP
\fBfreephone\fP \- English speech with Freephone and Mbrola voice
\(oqen1\(cq;
.br
\fBru_tts\fP \- Russian speech with Ru_tts speech synthesizer;
.br
\fBespeak\fP \- all supported languages with Espeak TTS engine;
.br
\fBmbrola\fP \- English, German, French, Spanish, Portuguese and
Italian speech produced by Mbrola in conjunction with Espeak as a
preprocessor;
.br
\fBuser\fP \- user defined TTS engine.
.TP
.B priority
.br
Language detection priority. Any integer value is allowed.
During autodetection languages are probed in the ascending order
of their priority values. It is 0 by default.
.TP
.B volume
.br
Specific voice loudness relatively to the general speech volume
level. It is 1.0 by default.
.TP
.B pitch
.br
Specific voice pitch adjustment relative to it's normal level.
It is 1.0 by default. Greater value causes higher pitch.
.TP
.B rate
.br
Relative speech rate for specific voice. It is 1.0 by default.
Higher value causes quicker speech.
.TP
.B acceleration
.br
Apply additional speech tempo acceleration. Speech rate
will be changed by specified difference in percents
compared to the original tempo. Positive values cause
speech acceleration while the negative ones actually imply
slowing it down. Default value is 0 so no additional
tempo change is applied.
.TP
.B char_pitch
.br
Relative voice pitch control applied to the single
letters pronunciation. By default 1.0 is suggested.
.TP
.B char_rate
.br
Relative speech rate control applied to the single
letters pronunciation. By default 1.0 is suggested.
.TP
.B caps_factor
.br
Voice pitch factor for capital letters. By default it is 1.2
so capital letters are pronounced by slightly higher pitch.
.TP
.B speak_numbers
.br
This option affects numbers speaking. When it is \(oqyes\(cq or
\(oqon\(cq, digits are treated as if they belong to the native
alphabet and, therefore, do not cause language switching. When it is
\(oqno\(cq or \(oqoff\(cq, digits are treated as foreign symbols
causing switch to another language that will be the fallback one or
some other according to the language priority settings. It is
\(oqyes\(cq by default.
.SH "MBROLA RELATED OPTIONS"
Section named \(oqmbrola\(cq contains some options affecting
\fBmultispeech\fP interaction with \fBmbrola\fP speech engine:
.TP
.B executable
.br
Path to the Mbrola executable. If only program name is specified
(as it is by default) then environment variable \fBPATH\fP
will be examined and all paths mentioned there will be searched.
.TP
.B voices
.br
Path to the directory where Mbrola voice files are stored.
By default \(oq<datadir>/mbrola\(cq is suggested.
.SH "MBROLA VOICES ASSIGNMENT"
These voices are used by Mbrola backend in conjunction with Espeak.
To see the list of the voices supported by Espeak try to invoke
\(oqespeak \-\-voices\(cq. Only Mbrola voices are allowed here. Also
make sure that you have corresponding Mbrola voices itself.
See Espeak documentation for further details.
.TP
.B en
.br
English voice. By default \(oqen1\(cq is used.
.TP
.B de
.br
German voice. By default \(oqde6\(cq is used.
.TP
.B fr
.br
French voice. By default \(oqfr4\(cq is used.
.TP
.B es
.br
Spanish voice. By default \(oqes1\(cq is used.
.TP
.B pt
.br
Portuguese voice. By default \(oqbr3\(cq is used.
.TP
.B it
.br
Italian voice. By default \(oqit3\(cq is used.
.SH "FREEPHONE RELATED OPTIONS"
Section named \(oqfreephone\(cq is devoted to \fBfreephone\fP speech
backend. Here are the following options:
.TP
.B executable
.br
Path to the Freephone executable. If only program name is specified
(as it is by default) then environment variable \fBPATH\fP
will be examined and all paths mentioned there will be searched.
.TP
.B lexicon
.br
Path to the lexical database. By default
\(oq<datadir>/freespeech/enlex.db\(cq is suggested.
.SH "RU TTS RELATED OPTIONS"
Section named \(oqru_tts\(cq consists of options that control
\fBmultispeech\fP interaction with \fBru_tts\fP speech synthesizer:
.TP
.B executable
.br
Path to the Ru_tts executable. If only program name is specified
(as it is by default) then environment variable \fBPATH\fP
will be examined and all paths mentioned there will be searched.
.TP
.B lexicon
.br
Path to the lexical database. By default
\(oq<datadir>/freespeech/rulex.db\(cq is suggested.
.TP
.B log
.br
Optional file to collect unknown words. This file must be writable
for the Multispeech user. The collected data can be used later
to improve lexical database. No such file is suggested by default
so unknown words are not stored.
.TP
.B expressiveness
.br
Relative voice pitch variation level. The default value is 1.0.
It is the normal intonation. Value 0.0 causes absolutely monotonic
speech.
.TP
.B female_voice
.br
When this option is \(oqyes\(cq the alternative female voice is used
instead of the default (male) one.
.TP
.B decimal_point
.TQ
.B decimal_comma
.br
These options enable or disable treating point and comma
inside a number as decimal separator. By default both are enabled.
Use \(oqyes\(cq or \(oqon\(cq to enable and \(oqno\(cq or \(oqoff\(cq
to disable.
.TP
.B interclause_gap_factor
.br
The factor applied to all interclause gap durations.
.TP
.B comma_gap_factor
.TQ
.B dot_gap_factor
.TQ
.B semicolon_gap_factor
.TQ
.B colon_gap_factor
.TQ
.B question_gap_factor
.TQ
.B exclamation_gap_factor
.br
the factors applied to the durations of the gaps
implied by the corresponding punctuations.
.TP
.B intonational_gap_factor
.br
The factor applied to the duration of intonational gaps
not caused by punctuations.
.SH "ESPEAK RELATED OPTIONS"
Interaction with \fBespeak\fP TTS engine is controlled by the options
grouped in section \(oqespeak\(cq:
.TP
.B executable
.br
Path to the Espeak executable. If only program name is specified
(as it is by default) then environment variable \fBPATH\fP
will be examined and all paths mentioned there will be searched.
.TP
.B en
.br
English voice specification. By default \(oqen\(cq is
suggested. Invoke \(oqespeak \-\-voices\(cq to see all available
alternatives.
.TP
.B ru
.br
Russian voice specification. By default \(oqru\(cq is
suggested. Invoke \(oqespeak \-\-voices\(cq to see all available
alternatives.
.TP
.B de
.br
German voice specification. By default \(oqde\(cq is
suggested. Invoke \(oqespeak \-\-voices\(cq to see all available
alternatives.
.TP
.B fr
.br
French voice specification. By default \(oqfr\(cq is
suggested. Invoke \(oqespeak \-\-voices\(cq to see all available
alternatives.
.TP
.B es
.br
Spanish voice specification. By default \(oqes\(cq is
suggested. Invoke \(oqespeak \-\-voices\(cq to see all available
alternatives.
.TP
.B pt
.br
Portuguese voice specification. By default \(oqpt\(cq is
suggested. Invoke \(oqespeak \-\-voices\(cq to see all available
alternatives.
.TP
.B it
.br
Italian voice specification. By default \(oqit\(cq is
suggested. Invoke \(oqespeak \-\-voices\(cq to see all available
alternatives.
.SH "USER DEFINED TTS BACKEND OPTIONS"
The section name is \(oquser\(cq. The following options are grouped
here:
.TP
.B command
.br
Shell command to perform TTS transformation. This command
must accept text on the standard input and produce sound
stream on the standard output. It should be a simple command,
pipes or other shell complications are not allowed here,
but command line arguments may be specified. Moreover, there are
several special keywords recognized by Multispeech and replaced
by actual values internally just before execution. This mechanism
allows Multispeech to pass current speech parameters to the TTS
engine. These keywords are as follows:
.PP
\fB%lang\fP \- replaced by the language id string;
.br
\fB%pitch\fP \- replaced by relative voice pitch value;
.br
\fB%rate\fP \- replaced by relative speech rate value;
.br
\fB%freq\fP \- replaced by the sampling frequency value.
.PP
The last keyword is replaced only when freq_control is enabled
(see below).
.TP
.B format
.br
Produced sound stream sample format. The following values
are allowed here:
.PP
\fBs8\fP \- signed 8 bits;
.br
\fBu8\fP \- unsigned 8 bits;
.br
\fBs16\fP \- signed 16 bits.
.PP
Leave this option commented out if sound stream is produced
in a format that can be detected automatically, such as wave file
for instance.
.TP
.B sampling
.br
Produced sound stream sampling frequency in Hz. Assumed 22050
by default. This option is ignored when sound stream format
is autodetected.
.TP
.B stereo
.br
Set to \(oqyes\(cq if produced sound stream is stereo. By default it is
assumed mono. This option is ignored when sound stream format is
autodetected.
.TP
.B freq_control
.br
Set this option to \(oqyes\(cq if TTS engine accepts sampling frequency
specification (as \fBmbrola\fP does, for instance) and you wish
to make use of this capability. This option allows \(oq%freq\(cq
keyword replacement in command line. Leave commented out if unsure.
.TP
.B charset
.br
Character set in which the TTS engine accepts  it's input.
Available charset names can be found in \fI/usr/share/i18n/SUPPORTED\fP
or wherever else it is on your system. By default this option
is not set so current locale setting is used.
.SH "SPEECH DISPATCHER MODULE RELATED OPTIONS"
The section name is \(oqspd\(cq. The following options are grouped
here:
.TP
.B version
.br
\fBSpeech Dispatcher\fP version. Usually it is correctly guessed
automatically, but you can specify it explicitly
when compatibility issues take place.
.TP
.B sound_icons
.br
Path to the directory where \fBmultispeech\fP will search sound icon
files when acting as \fBSpeech Dispatcher\fP module.
By default \(oq<datadir>/sounds/sound\-icons\(cq is suggested.
.TP
.B use_voice_language
.br
This option defines \fBmultispeech\fP behaviour when
\fBsynthesis_voice\fP and \fBlanguage\fP settings are passed by
 \fBSpeech Dispatcher\fP in a single request. If it is \(oqyes\(cq
or \(oqon\(cq, language will be chosen according to the specified
voice, otherwise, when it is \(oqno\(cq or \(oqoff\(cq, the last
setting in packet will take precedence. By default this option
is \(oqyes\(cq.
.TP
.B accept_explicit_language
.br
This option enables or disables explicit language choice by
\fBSpeech Dispatcher\fP. When disabled, language can be chosen only
via \fBsynthesis_voice\fP. Use the word \(oqyes\(cq or \(oqon\(cq
to enable and the word \(oqno\(cq or \(oqoff\(cq to disable.
By default this option is enabled.
.TP
.B ignore_unknown_voice
.br
When this option is \(oqyes\(cq or \(oqon\(cq, \fBSpeech Dispatcher\fP
 requests to set \fBsynthesis_voice\fP with unknown name are ignored.
Otherwise, when it is \(oqno\(cq or \(oqoff\(cq, such requests are
treated as if the voice name was \(oqNULL\(cq. This special name
is used for so-called default voice that allows \fBmultispeech\fP
to utilize language autodetection mechanism. Though language still
can be changed explicitly by \fBSpeech Dispatcher\fP if enabled.
This option is \(oqno\(cq by default.
.TP
.B index_marks
.br
This option enables or disables index marks support.
When it is \(oqyes\(cq or \(oqon\(cq, index marks are reported
correctly, but it is necessary to split message at the point of index
mark. If such side effect is somewhat inconvenient, it may be better
to turn off index marks support by setting this option to \(oqno\(cq
or \(oqoff\(cq. By default index marks support is enabled.
.SH "SEE ALSO"
.BR espeak(1),
.BR freephone(1),
.BR mbrola(1),
.BR multispeech(1),
.BR ru_tts(1),
.BR speech-dispatcher(1).
.SH AUTHOR
Igor B. Poretsky <poretsky@mlbox.ru>.
