import sys
from _typeshed import Self
from collections.abc import Callable
from decimal import Decimal
from numbers import Integral, Rational, Real
from typing import Any, overload
from typing_extensions import Literal, SupportsIndex, TypeAlias

_ComparableNum: TypeAlias = int | float | Decimal | Real

if sys.version_info >= (3, 9):
    __all__ = ["Fraction"]
else:
    __all__ = ["Fraction", "gcd"]
    @overload
    def gcd(a: int, b: int) -> int: ...
    @overload
    def gcd(a: Integral, b: int) -> Integral: ...
    @overload
    def gcd(a: int, b: Integral) -> Integral: ...
    @overload
    def gcd(a: Integral, b: Integral) -> Integral: ...

class Fraction(Rational):
    @overload
    def __new__(
        cls: type[Self], numerator: int | Rational = ..., denominator: int | Rational | None = ..., *, _normalize: bool = ...
    ) -> Self: ...
    @overload
    def __new__(cls: type[Self], __value: float | Decimal | str, *, _normalize: bool = ...) -> Self: ...
    @classmethod
    def from_float(cls: type[Self], f: float) -> Self: ...
    @classmethod
    def from_decimal(cls: type[Self], dec: Decimal) -> Self: ...
    def limit_denominator(self, max_denominator: int = ...) -> Fraction: ...
    if sys.version_info >= (3, 8):
        def as_integer_ratio(self) -> tuple[int, int]: ...

    @property
    def numerator(a) -> int: ...
    @property
    def denominator(a) -> int: ...
    @overload
    def __add__(a, b: int | Fraction) -> Fraction: ...
    @overload
    def __add__(a, b: float) -> float: ...
    @overload
    def __add__(a, b: complex) -> complex: ...
    @overload
    def __radd__(b, a: int | Fraction) -> Fraction: ...
    @overload
    def __radd__(b, a: float) -> float: ...
    @overload
    def __radd__(b, a: complex) -> complex: ...
    @overload
    def __sub__(a, b: int | Fraction) -> Fraction: ...
    @overload
    def __sub__(a, b: float) -> float: ...
    @overload
    def __sub__(a, b: complex) -> complex: ...
    @overload
    def __rsub__(b, a: int | Fraction) -> Fraction: ...
    @overload
    def __rsub__(b, a: float) -> float: ...
    @overload
    def __rsub__(b, a: complex) -> complex: ...
    @overload
    def __mul__(a, b: int | Fraction) -> Fraction: ...
    @overload
    def __mul__(a, b: float) -> float: ...
    @overload
    def __mul__(a, b: complex) -> complex: ...
    @overload
    def __rmul__(b, a: int | Fraction) -> Fraction: ...
    @overload
    def __rmul__(b, a: float) -> float: ...
    @overload
    def __rmul__(b, a: complex) -> complex: ...
    @overload
    def __truediv__(a, b: int | Fraction) -> Fraction: ...
    @overload
    def __truediv__(a, b: float) -> float: ...
    @overload
    def __truediv__(a, b: complex) -> complex: ...
    @overload
    def __rtruediv__(b, a: int | Fraction) -> Fraction: ...
    @overload
    def __rtruediv__(b, a: float) -> float: ...
    @overload
    def __rtruediv__(b, a: complex) -> complex: ...
    @overload
    def __floordiv__(a, b: int | Fraction) -> int: ...
    @overload
    def __floordiv__(a, b: float) -> float: ...
    @overload
    def __rfloordiv__(b, a: int | Fraction) -> int: ...
    @overload
    def __rfloordiv__(b, a: float) -> float: ...
    @overload
    def __mod__(a, b: int | Fraction) -> Fraction: ...
    @overload
    def __mod__(a, b: float) -> float: ...
    @overload
    def __rmod__(b, a: int | Fraction) -> Fraction: ...
    @overload
    def __rmod__(b, a: float) -> float: ...
    @overload
    def __divmod__(a, b: int | Fraction) -> tuple[int, Fraction]: ...
    @overload
    def __divmod__(a, b: float) -> tuple[float, Fraction]: ...
    @overload
    def __rdivmod__(b, a: int | Fraction) -> tuple[int, Fraction]: ...
    @overload
    def __rdivmod__(b, a: float) -> tuple[float, Fraction]: ...
    @overload
    def __pow__(a, b: int) -> Fraction: ...
    @overload
    def __pow__(a, b: float | Fraction) -> float: ...
    @overload
    def __pow__(a, b: complex) -> complex: ...
    @overload
    def __rpow__(b, a: float | Fraction) -> float: ...
    @overload
    def __rpow__(b, a: complex) -> complex: ...
    def __pos__(a) -> Fraction: ...
    def __neg__(a) -> Fraction: ...
    def __abs__(a) -> Fraction: ...
    def __trunc__(a) -> int: ...
    def __floor__(a) -> int: ...
    def __ceil__(a) -> int: ...
    @overload
    def __round__(self, ndigits: None = ...) -> int: ...
    @overload
    def __round__(self, ndigits: int) -> Fraction: ...
    def __hash__(self) -> int: ...
    def __eq__(a, b: object) -> bool: ...
    def __lt__(a, b: _ComparableNum) -> bool: ...
    def __gt__(a, b: _ComparableNum) -> bool: ...
    def __le__(a, b: _ComparableNum) -> bool: ...
    def __ge__(a, b: _ComparableNum) -> bool: ...
    def __bool__(a) -> bool: ...
    def __copy__(self: Self) -> Self: ...
    def __deepcopy__(self: Self, memo: Any) -> Self: ...
    if sys.version_info >= (3, 11):
        def __int__(a, _index: Callable[[SupportsIndex], int] = ...) -> int: ...
    # Not actually defined within fractions.py, but provides more useful
    # overrides
    @property
    def real(self) -> Fraction: ...
    @property
    def imag(self) -> Literal[0]: ...
    def conjugate(self) -> Fraction: ...
