/* NVTV Chrontel chip data header -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id: data_ch.h,v 1.21 2004/01/30 08:47:02 dthierbach Exp $
 *
 * Contents:
 *
 * Header: Data tables and setup routines for the Chrontel chip.
 */ 

#ifndef _DATA_CH_H
#define _DATA_CH_H

#include "tv_chip.h"
#include "data.h"

void data_init_ch1 (TVSystem system, TVChRegs *r);
void data_init_ch2 (TVSystem system, TVChRegs *r);
void data_default_ch (TVSettings *s);
void data_clamp_ch (TVSettings *s, TVRegs *r);
void data_setup_ch1 (TVSettings *s, TVRegs *r);
void data_setup_ch2 (TVSettings *s, TVRegs *r);

/* ---- CH1 ---- */

extern TVChRegs ch1_ntsc_huge_a;      /* Mode 16: 640x480 1:1  */
extern TVChRegs ch1_ntsc_small_a;     /* Mode 17: 640x480 7:8  */
extern TVChRegs ch1_ntsc_tiny_a;      /* Mode 18: 640x480 5:6  */
extern TVChRegs ch1_ntsc_huge_b;      /* Mode 22: 800x600 5:6  */
extern TVChRegs ch1_ntsc_large_b;     /* Mode 23: 800x600 3:4  */
extern TVChRegs ch1_ntsc_small_b;     /* Mode 24: 800x600 7:10 */
extern TVChRegs ch1_ntsc_huge_c;      /* Mode 10: 640x400 5:4  */
extern TVChRegs ch1_ntsc_small_c;     /* Mode 11: 640x400 1:1  */
extern TVChRegs ch1_ntsc_tiny_c;      /* Mode 12: 640x400 7:8  */
extern TVChRegs ch1_ntsc_huge_d;      /* Mode  6: 720x400 5:4  */
extern TVChRegs ch1_ntsc_small_d;     /* Mode  7: 720x400 1:1  */
extern TVChRegs ch1_ntsc_large_e;     /* Mode  2: 512x384 5:4  */
extern TVChRegs ch1_ntsc_small_e;     /* Mode  3: 512x384 1:1  */
extern TVChRegs ch1_ntsc_large_f;     /* Mode 23: 800x600 3:4  */
extern TVChRegs ch1_ntsc_large_g;     /* Mode 23: 800x600 3:4  */
extern TVChRegs ch1_ntsc_interl_dvd;  /* Mode 26: 720x480 IL   */

extern unsigned long ch1_fsci_ntsc_huge_a [];
extern unsigned long ch1_fsci_ntsc_small_a [];
extern unsigned long ch1_fsci_ntsc_tiny_a  [];
extern unsigned long ch1_fsci_ntsc_huge_b  [];
extern unsigned long ch1_fsci_ntsc_large_b [];
extern unsigned long ch1_fsci_ntsc_small_b [];
extern unsigned long ch1_fsci_ntsc_huge_c [];
extern unsigned long ch1_fsci_ntsc_small_c [];
extern unsigned long ch1_fsci_ntsc_tiny_c  [];
extern unsigned long ch1_fsci_ntsc_huge_d [];
extern unsigned long ch1_fsci_ntsc_small_d [];
extern unsigned long ch1_fsci_ntsc_large_e [];
extern unsigned long ch1_fsci_ntsc_small_e [];

extern TVChRegs ch1_pal_huge_a;     /* Mode 13: 640x480 5:4  */
extern TVChRegs ch1_pal_small_a;    /* Mode 14: 640x480 1:1  */
extern TVChRegs ch1_pal_tiny_a;     /* Mode 15: 640x480 5:6  */
extern TVChRegs ch1_pal_huge_b;     /* Mode 19: 800x600 1:1  */
extern TVChRegs ch1_pal_small_b;    /* Mode 20: 800x600 5:6  */
extern TVChRegs ch1_pal_tiny_b;     /* Mode 21: 800x600 3:4  */
extern TVChRegs ch1_pal_small_c;    /* Mode  8: 640x400 5:4  */
extern TVChRegs ch1_pal_tiny_c;     /* Mode  9: 640x400 1:1  */
extern TVChRegs ch1_pal_small_d;    /* Mode  4: 720x400 5:4  */
extern TVChRegs ch1_pal_tiny_d;     /* Mode  5: 720x400 1:1  */
extern TVChRegs ch1_pal_small_e;    /* Mode  0: 512x384 5:4  */
extern TVChRegs ch1_pal_tiny_e;     /* Mode  1: 512x384 1:1  */
extern TVChRegs ch1_pal_large_f;    /* Mode 19: 800x600 1:1  */
extern TVChRegs ch1_pal_large_g;    /* Mode 19: 800x600 1:1  */
extern TVChRegs ch1_pal_small_f;    /* Mode 20: 800x600 5:6  */
extern TVChRegs ch1_pal_small_g;    /* Mode 20: 800x600 5:6  */
extern TVChRegs ch1_pal_interl_dvd; /* Mode 25: 720x576 IL   */

extern unsigned long ch1_fsci_pal_huge_a [];
extern unsigned long ch1_fsci_pal_small_a [];
extern unsigned long ch1_fsci_pal_tiny_a  [];
extern unsigned long ch1_fsci_pal_huge_b [];
extern unsigned long ch1_fsci_pal_small_b [];
extern unsigned long ch1_fsci_pal_tiny_b  [];
extern unsigned long ch1_fsci_pal_small_c [];
extern unsigned long ch1_fsci_pal_tiny_c  [];
extern unsigned long ch1_fsci_pal_small_d [];
extern unsigned long ch1_fsci_pal_tiny_d  [];
extern unsigned long ch1_fsci_pal_small_e [];
extern unsigned long ch1_fsci_pal_tiny_e  [];

/* ---- CH2 ---- */

extern TVChRegs ch2_ntsc_huge_c;   /* Mode 19:  720x480 /   882x525  1:1 */
extern TVChRegs ch2_ntsc_small_c;  /* Mode 20:  720x480 /   882x600  7:8 */
extern TVChRegs ch2_ntsc_tiny_c;   /* Mode 21:  720x480 /   900x630  5:6 */
extern TVChRegs ch2_ntsc_large_b;  /* Mode 28:  800x600 /  1040x700  3:4 */
extern TVChRegs ch2_ntsc_small_b;  /* Mode 29:  800x600 /  1064x750  7:10 */
extern TVChRegs ch2_ntsc_tiny_b;   /* Mode 30:  800x600 /  1040x840  5:8 */
extern TVChRegs ch2_ntsc_huge_a;   /* Mode 34: 1024x768 /  1160x840  5:8 */
extern TVChRegs ch2_ntsc_large_a;  /* Mode 35: 1024x768 /  1160x945  5:9 */
extern TVChRegs ch2_ntsc_tiny_a;   /* Mode 36: 1024x768 / 1168x1050  1:2 */
extern TVChRegs ch2_ntsc_dvd;      /* Mode 38:  720x480 /   858x525  1:1 */
									 
extern TVChRegs ch2_pal_huge_d;    /* Mode 22:  720x576 /   882x625  1:1 */
extern TVChRegs ch2_pal_small_d;   /* Mode 23:  720x576 /   900x750  5:6 */
extern TVChRegs ch2_pal_tiny_d;    /* Mode 24:  720x576 /   900x875  5:7 */ 
extern TVChRegs ch2_pal_huge_b;    /* Mode 25:  800x600 /   944x625  1:1 */
extern TVChRegs ch2_pal_small_b;   /* Mode 26:  800x600 /   960x750  5:6 */
extern TVChRegs ch2_pal_tiny_b;    /* Mode 27:  800x600 /   960x875  5:7 */
extern TVChRegs ch2_pal_huge_a;    /* Mode 31: 1024x768 /  1400x875  5:7 */
extern TVChRegs ch2_pal_small_a;   /* Mode 32: 1024x768 / 1400x1000  5:8 */
extern TVChRegs ch2_pal_tiny_a;    /* Mode 33: 1024x768 / 1400x1125  5:9 */
extern TVChRegs ch2_pal_dvd;       /* Mode 37:  720x576 /   864x625  1:1 */

extern unsigned long ch2_fsci_ntsc_huge_c  []; /* 19 */
extern unsigned long ch2_fsci_ntsc_small_c []; /* 20 */
extern unsigned long ch2_fsci_ntsc_tiny_c  []; /* 21 */
extern unsigned long ch2_fsci_ntsc_large_b []; /* 28 */
extern unsigned long ch2_fsci_ntsc_small_b []; /* 29 */
extern unsigned long ch2_fsci_ntsc_tiny_b  []; /* 30 */
extern unsigned long ch2_fsci_ntsc_huge_a  []; /* 34 */
extern unsigned long ch2_fsci_ntsc_large_a []; /* 35 */
extern unsigned long ch2_fsci_ntsc_tiny_a  []; /* 36 */
extern unsigned long ch2_fsci_ntsc_dvd     []; /* 38 */

extern unsigned long ch2_fsci_pal_huge_d   []; /* 22 */
extern unsigned long ch2_fsci_pal_small_d  []; /* 23 */
extern unsigned long ch2_fsci_pal_tiny_d   []; /* 24 */
extern unsigned long ch2_fsci_pal_huge_b   []; /* 25 */
extern unsigned long ch2_fsci_pal_small_b  []; /* 26 */
extern unsigned long ch2_fsci_pal_tiny_b   []; /* 27 */
extern unsigned long ch2_fsci_pal_huge_a   []; /* 31 */
extern unsigned long ch2_fsci_pal_small_a  []; /* 32 */
extern unsigned long ch2_fsci_pal_tiny_a   []; /* 33 */
extern unsigned long ch2_fsci_pal_dvd      []; /* 37 */

#endif /* _DATA_CH_H */
