# Announce: Rakudo compiler, Release #143 (2021.02)

On behalf of the Rakudo development team, I’m very happy to announce the
February 2021 release of Rakudo #143. Rakudo is an implementation of
the Raku[^1] language.

The source tarball for this release is available from
<https://rakudo.org/files/rakudo>.
Pre-compiled archives will be available shortly.

New in 2021.02:

  + Additions:
    + Add support of the `is implementation-detail` trait
      for classes and roles [4384fc5c]
    + Introduce support for passing multiple time units
      to `earlier` and `later` methods on `Dateish` [8a1f8f6f][10dea6ef]
    + Add "Solaris" option to the list returned by `KERNELnames`
      method on `$*RAKU` [f918f0fd]
    + Introduce the `slice` method on `Seq` accepting indices
      (e.g. `@a.Seq.slice(0, 2 ... *)`) [63be83d3]
    + Implement `Map` method on `QuantHash` [110343d2]
  + Changes:
    + Add a way to set `arg0` (when specified, passed as first argument
      to the process instead of the program name) for `Proc` objects [ce124551]
    + Return to REPL implementation prior to 2020.12 release [d53a9273][39103199]
    + Move to CentOS 7 in binary release GNU/Linux build [38e69d87]
    + Provide single argument semantics for assigning
      a `QuantHash` to an `Array` object [6cd50ab2]
    + Conversion of a `Str` object to Enum now returns a
      `Failure` object wrapping an `X::Enum::NoValue` instead
      of returning the enum's type object
      [e3a0c32d][28b95813][184079c9][5bc394f6][bcb9a2c9][e44b524e]
    + Module installing at sorting now prefers API sorting over version sorting [43613ac5]
    + Implement the `item` method for `QuantHash` and `Capture` types [8f6c7fe7]
    + Throw a proper NYI error on attempt to parametrize a Hash with native types [5aec4aaa]
  + Efficiency:
    + Makes `DateTime.new(y,m,d,h,m,s)` about 25% faster [0c8d238a]
    + Make `>>.` faster [8c3795e0]
    + Make the `truncated-to` method implementation for `DateTime` and `Date`
      a lot faster [e6c0b5e9][c9ac5d90]
    + Improve startup time
      [39d3f136][f993b345][43ccad29][82314883][7be4f5ef][d53d0308]
    + Make `Array.ASSIGN-POS` about 15% faster [f623f1b6]
    + Make `Hash` slice assignment about 2x as fast
      [75c58168][09552ab5][281d9f3c]
    + Make array slices on a `Hash` about 40% faster [c039b28f]
    + Re-imagine array slicing, fixing issues, between 2x and 10x faster [ca7bc91e]
    + Makes slice assignment on a native array from an `Iterable`
      about 15x as fast [4d40e23e]
    + Optimize (AT|ASSIGN|BIND|EXISTS|DELETE)-POS methods [4c91d743]
    + Speedup the basic @a[*] (Whatever slice) [9ad80af2]
  + Fixes:
    + Fix segfault caused by repossession of native call site [8c63c54c]
    + Make sure that calling `new` on a shaped array works correctly [623d4c12]
    + Fix deleting colonpair with R-metaop in value by the Optimizer [18ae0df3]
    + Improve error message on operation on closed handle [3865f1ca]
    + Provide a more accurate implementation of `**` infix operator on `Complex` [12b49b83]
    + Make sure that `.of` method of various types works on type objects [790240f6]
    + Fix potential deadlock on specialization of roles [65a5cce1]
    + Fix native `@a[*-4 .. *..2]` (Callable candidates of subscription taking
      more than a single argument, and the ones returning something else than an Int) [8150a286]
    + Throw on non-Int result in `Iterable` index on native array [8a3e983c]
    + Throw on non-Int result in `Iterable` index on native array assignment [5eb55076]
    + Fixes for building and testing on Solaris platform [ac10a7a8]
    + Fix problem in `Compiler.verbose-config` [ed6e2c8b]
    + Fix an obscure error in `&Perl6::Actions::lower_signature` [bef6b4f6]
    + Fix calling programs with spaces in their path on Windows [570372f1][c3d3027d]
    + Fix passing tests for `X::Adverb` on JVM backend [e6f49356]
  + Internal:
    + No longer use Travis for CI [53da2061]
    + Add `MoarVM::SIL` helper module for developers to have better
      interface to spesh results [7f90c71c][c8647ad4][b01320ad]
      [1a03ce06][6793c551][842bbae3][842bbae3][1b45d0ad][7e970626]
      [98b91f43][dfd604d8][1fb8caf3][3235f3e4]
    + Resurrect `make test` on the JVM backend
      [bad3621c][5dfdd35c][0b4332dd][3f1607f8]
    + Make `Rakudo:Internals` method `SHORT-STRING` handle null str correctly [f2e324d5]
    + Introduce `Rakudo::Internals.TARGET`, `Rakudo::Internals.E`,
      `Rakudo::Internals.RERUN-WITH` methods [025448a6][467a931d][116c8e8e][164815f6]
    + Implement the `repo-chain` method on `$*REPO` iteratively,
      rather than recursively [50d1d86c]
    + Make `RAKUDO_SCHEDULER_DEBUG_STATUS` logging leaner [aa9e849a]
    + Remove a now unneeded `unimatch` method multi [6306f1e0]
    + Improve the internal subroutine `proclaim` of `Test` module
      [5133103d][297cba1a][446caae3]
    + Implement `sec`, `asec` and `sech` in terms of other NQP trigonometric functions [c9d69dc6]
    + Add support for native BOOT arrays for the `dd` routine [4e645ee5]
    + Fix individual running of some test files [74e5212f]
    + Add tests for inlining
      [1fb058e6][87d7c5a3][5a402a14][d94d07e6][0536d039][a3c7d00d][9c7b5561]
    + Various cleanup and micro-optimization changes
      [336a2170][e14833bd][3c79db6c][e5f94a15][620fa7ad][fa648a59]

The following people contributed to this release:

Elizabeth Mattijsen, Stoned Elipot, Stefan Seifert, Juan Julián Merelo Guervós, Patrick Böker,
Will "Coke" Coleda, Alexander Kiryuhin, Timo Paulssen, Nicholas Clark, Daniel Green,
Vadim Belman, Christian Bartolomäus, Jan-Olof Hendig, Richard Hainsworth,
JustThisGuyAZ, stoned, Ben Davies, Daniel Sockwell, Jonathan Worthington,
Mikhail Khorkov, Brian Duggan, Fernando Santagata, Luis F. Uceta,
Moritz Lenz, Nick Logan, Stéphane Payrard, alanrocker, tony-o

This release implements 6.c and 6.d versions of the Raku specification.
6.c version of the language is available if you use the `use v6.c`
version pragma, otherwise 6.d is the default.

Upcoming releases in 2021 will include new functionality that is not
part of 6.c or 6.d specifications, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of
6.c and 6.d specifications will continue to work unchanged. There may
be incremental spec releases this year as well.

If you would like to contribute or get more information, visit
<https://raku.org>, <https://rakudo.org/community>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #raku on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Raku development: <https://donate.perlfoundation.org/>
(put “Raku Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#144), is tentatively scheduled for 2021-03-20.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <https://raku.org/>
