---
myst:
  html_meta:
    keywords: LaTeX, composition, illustrations, inclure une image, centrage, 
              image trop grande
---

# Comment centrer une illustration très large ?

Vous disposez d'une grande image et vous souhaitez l'afficher dans toute sa
splendeur, centrée. Mais voici que vous obtenez une image qui s'étale 
dans la marge de droite. 

L'exemple ci-dessous simule ce comportement : nous avons en effet demandé 
une taille de page assez réduite avec l'extension <ctanpkg:geometry> afin que 
notre image déborde.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{mwe}            % Quelques images factices
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage[body={9cm,15cm}]{geometry}

\begin{document}
Comme promis, vous trouverez ci-dessous mon projet de nouveau caractère, 
agrandi, afin que vous puissez en admirer les magnifiques détails. Notez
son admirable symétrie.

\begin{figure}[h!]
\centering
\includegraphics{example-image-a}
\caption{Mon projet}
\end{figure}
\end{document}
```

Une première idée consisterait évidemment à réduire la figure, ou la découper.
En effet, même lorsque vous aurez réussi à la centrer, le résultat 
ne sera pas très esthétique (pour de l'édition formelle), l'image débordant 
dans les marges. Dans le cas présent, cela reviendrait à inclure la figure 
avec, par exemple, une largement réduite à 0,9 fois la largeur du texte.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{mwe}            % Quelques images factices
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage[body={9cm,15cm}]{geometry}

\begin{document}
Comme promis, vous trouverez ci-dessous mon projet de nouveau caractère, 
agrandi, afin que vous puissez en admirer les magnifiques détails. Notez
son admirable symétrie.

\begin{figure}[h!]
\centering
\includegraphics[width=0.9\linewidth]{example-image-a}
\caption{Mon projet}
\end{figure}
\end{document}
```

Si la réponse précédente ne convient pas, vous pourrez utiliser 
la commande `\centerline`, en lui passant en argument la commande qui inclut
la figure problématique.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{mwe}            % Quelques images factices
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage[body={9cm,15cm}]{geometry}

\begin{document}
Comme promis, vous trouverez ci-dessous mon projet de nouveau caractère, 
agrandi, afin que vous puissez en admirer les magnifiques détails. Notez
son admirable symétrie.

\begin{figure}[h!]
\centering
\centerline{\includegraphics[width=1.2\linewidth]{example-image-a}}
\caption{Mon projet}
\end{figure}
\end{document}
```

La solution suivante se base sur une commande écrite par 
[Le TeXnicien de surface](https://yvon-henel.fr/texnicien/index.html). 
Elle permet d'inclure une image pouvant être plus large que le texte. 
Elle tient compte d'une largeur et d'une hauteur maximale, à fixer, 
pour réduire l'image si nécessaire.


```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \usepackage{mwe}            % Quelques images factices
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage[body={9cm,15cm}]{geometry}

  % Code pour la commande \CentrerImage
  \usepackage{etoolbox}
  \dimdef{\LargeurDisponible}{19cm}% à modifier en fonction des besoins
  \dimdef{\HauteurDisponible}{10cm}% idem
  \newbox{\limage}% nom de la boite avec laquelle se mesurent les
                  % dimensions de l'image

  \newcommand{\CentrerImage}[1]{%
    \begingroup
    % tout se passe dans un groupe qui finit avec le \endgroup
    % essentiellement pour limiter l'effet du \centering
    \sbox{\limage}{\includegraphics{#1}}% l'image est placée dans une boite
    \dimdef{\LargeurImage}{\wd\limage}%
    \dimdef{\HauteurImage}{\ht\limage + \dp\limage}%
    % les dimensions sont calculées grâce aux commandes fournies par etoolbox
    \par\noindent\centering% le paragraphe est centré sans retrait
    % l'image est placée dans une boite de largeur 0pt
    \makebox[0pt]{%
      \ifdimcomp{\LargeurImage}{>}{\HauteurImage}%
      {% plus large que haut, la largeur disponible est limitée
        \ifdimcomp{\LargeurImage}{>}{\LargeurDisponible}%
        % uniquement si l'image est trop large
        {\includegraphics[width=\LargeurDisponible]{#1}}%
        % sinon les dimensions naturelles sont conservées
        {\includegraphics{#1}}}%
      {% plus haut que large, la hauteur disponible est limitée
        \ifdimcomp{\HauteurImage}{>}{\HauteurDisponible}%
        % uniquement si l'image est trop haute
        {\includegraphics[height=\HauteurDisponible]{#1}}%
        % sinon les dimensions naturelles sont conservées
        {\includegraphics{#1}}}}\par
    % il faut un saut de paragraphe pour que \centering soit utile
    \endgroup}

\begin{document}
Comme promis, vous trouverez ci-dessous mon projet de nouveau caractère, 
agrandi, afin que vous puissez en admirer les magnifiques détails. Notez
son admirable symétrie.

\begin{figure}[h!]
\centering
\CentrerImage{example-image-a}
\caption{Mon projet}
\end{figure}
\end{document}
```