/**
 * Copyright (C) 2018 Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA.
**/

#include "touchscreenset.h"

#include <QMutex>

TouchScreenSet* TouchScreenSet::instance(QObject *parent)
{
    static TouchScreenSet* _instance = nullptr;
    QMutex mutex;
    mutex.lock();
    if(!_instance)
        _instance = new TouchScreenSet(parent);
    mutex.unlock();
    return _instance;
}

TouchScreenSet::TouchScreenSet(QObject *parent):
    QObject(parent)
{
    init();
}

void TouchScreenSet::init()
{

}

int TouchScreenSet::getTouchScreenID()
{

}
