!------------------------------------------------------------------------
! Copyright (c) 2011 SPMODEL Development Group. All rights reserved.
!------------------------------------------------------------------------
!
!ɽ  eea_module_fftj ƥȥץ (Ѵ)
!
!  2011/12/10  ݹ
!
program eea_module_fftj_transform_test

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use eea_module_fftj
  implicit none

 !---- ֲ ----
  integer, parameter :: im=32, jm=32              ! ʻ(X,Y)
  integer, parameter :: km=10, lm=10              ! ȿ(X,Y)

 !---- ѿ ----
  real(8)            :: yxa_Data(0:jm-1,0:im-1,2)    ! ʻҥǡ
  real(8)            :: xya_Data(0:jm-1,0:im-1,2)    ! ʻҥǡ
  real(8)            :: eea_Data(-lm:lm,-km:km,2)    ! ڥȥǡ

  integer            :: k=2,l=5

 !---- ɸѿʤ ----
  real(8), parameter :: xmin = 0.0d0, xmax=2.0d0
  real(8), parameter :: ymin = 0.0d0, ymax=2.0d0

  real(8), parameter :: pi=3.1415926535897932385D0
  ! Ƚ
  integer, parameter :: check_digits = 10
  integer, parameter :: ignore = -11

  call MessageNotify('M','eea_module_fftj_transform_test', &
       'eea_module_fftj transform function tests')

 !---------------- ɸͤ ---------------------
  call eea_initial(im,jm,km,lm,xmin,xmax,ymin,ymax)    ! ڥȥ

 !-------------------  ----------------------
  yxa_Data(:,:,1) = sin(k*pi*yx_X) * sin(l*pi*yx_Y)
  eea_Data(:,:,1) = 0.0 ; eea_Data(-l,k,1) = 0.25  ; eea_Data(l,k,1) = -0.25

  yxa_Data(:,:,2) = cos(k*pi*yx_X) * cos(l*pi*yx_Y)
  eea_Data(:,:,2) = 0.0 ; eea_Data(l,k,2) = 0.25  ; eea_Data(-l,k,2) = 0.25

  call check(eea_yxa(yxa_Data), eea_Data, &
       'Transform sin(k*pi*X)*sin(l*pi*Y),cos(k*pi*X)*cos(l*pi*Y)')
  call check(yxa_eea(eea_yxa(yxa_Data)), yxa_Data, &
       'Inverse transform sin(k*pi*X)*sin(l*pi*Y),cos(k*pi*X)*cos(l*pi*Y)')

  yxa_Data(:,:,1) = sin(k*pi*yx_X) * cos(l*pi*yx_Y)
  eea_Data(:,:,1) = 0.0 ; eea_Data(-l,-k,1) = -0.25  ; eea_Data(l,-k,1) = - 0.25
  yxa_Data(:,:,2) = cos(k*pi*yx_X) * sin(l*pi*yx_Y)
  eea_Data(:,:,2) = 0.0 ; eea_Data(-l,-k,2) = -0.25  ; eea_Data(l,-k,2) = 0.25
  call check(eea_yxa(yxa_Data), eea_Data, &
       'Transform sin(k*pi*X)*cos(l*pi*Y),cos(k*pi*X)*sin(l*pi*Y)')
  call check(yxa_eea(eea_yxa(yxa_Data)), yxa_Data, &
       'Inverse transform sin(k*pi*X)*cos(l*pi*Y),cos(k*pi*X)*sin(l*pi*Y)')

  call MessageNotify('M','eea_module_fftj_transform_test', &
       'eea_module_fftj transform function tests succeeded!')

  yxa_Data(:,:,1) = sin(k*pi*yx_X) * sin(l*pi*yx_Y)
  xya_Data(:,:,1) = sin(k*pi*xy_X) * sin(l*pi*xy_Y)

  yxa_Data(:,:,2) = cos(k*pi*yx_X) * cos(l*pi*yx_Y)
  xya_Data(:,:,2) = cos(k*pi*xy_X) * cos(l*pi*xy_Y)

  call check(xya_yxa(yxa_Data), xya_Data, &
       'Shape transform sin(k*pi*X)*cos(l*pi*Y),cos(k*pi*X)*sin(l*pi*Y)')
  call check(yxa_xya(xya_yxa(yxa_Data)), yxa_Data, &
       'Inverse shape transform sin(k*pi*X)*cos(l*pi*Y),cos(k*pi*X)*sin(l*pi*Y)')

contains

  subroutine check(var,sol,funcname)
    real(8) :: var(:,:,:)                ! Ƚꤹ
    real(8) :: sol(:,:,:)                ! 
    character(len=*) :: funcname

    call AssertEqual(     &
      message = funcname, &
      answer = sol,       &
      check = var,        &
      significant_digits = check_digits, ignore_digits = ignore     )

  end subroutine check

end program eea_module_fftj_transform_test

