!----------------------------------------------------------------------
!     Copyright (c) 2013 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  w_base_mpi_module_sjpack ƥȥץ :: ٥ȥѥ֥롼Υƥ
!
!  2013/02/15  ݹ
!
program w_base_mpi_module_sjpack_vector

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use w_mpi_module_sjpack
  use mpi
  implicit none

  integer, parameter :: im=128, jm=64, nm=42

  real(8), allocatable ::  xv_U(:,:)              ! ®ٷʬ
  real(8), allocatable ::  xv_V(:,:)              ! ®ٰʬ

  real(8), allocatable ::  xv_UCosLat(:,:)        ! ®ٷʬ
  real(8), allocatable ::  xv_VCosLat(:,:)        ! ®ٰʬ

  real(8), allocatable ::  xv_Uans(:,:)           ! ®ٷʬ
  real(8), allocatable ::  xv_Vans(:,:)           ! ®ٰʬ

  real(8), allocatable ::  xv_Psi(:,:)            ! ήؿ
  real(8), allocatable ::  xv_Chi(:,:)            ! ®٥ݥƥ󥷥

  real(8), allocatable ::  w_Vor(:)               ! 
  real(8), allocatable ::  w_Div(:)               ! ȯ

  real(8), allocatable ::  xv_Vorans(:,:)         ! 
  real(8), allocatable ::  xv_Divans(:,:)         ! ȯ


  ! Ƚ
  integer, parameter :: check_digits = 9
  integer, parameter :: ignore = -10

  integer :: iproc, np, ierr

  call MessageNotify('M','w_base_mpi_module_vector_sjpack_test', &
                         'w_base_mpi_module_sjpack subroutine tests') 

 !---------------- MPI  ---------------------
  call MPI_INIT(IERR)
  call MPI_COMM_RANK(MPI_COMM_WORLD,IPROC,IERR)
  call MPI_COMM_SIZE(MPI_COMM_WORLD,NP,IERR)

  call w_mpi_Initial( nm, im, jm )

  allocate(xv_U(0:im-1,jc))
  allocate(xv_V(0:im-1,jc))
  allocate(xv_UCosLat(0:im-1,jc))
  allocate(xv_VCosLat(0:im-1,jc))
  allocate(xv_Uans(0:im-1,jc))
  allocate(xv_Vans(0:im-1,jc))
  allocate(xv_Psi(0:im-1,jc))
  allocate(xv_Chi(0:im-1,jc))
  allocate(xv_Vorans(0:im-1,jc))
  allocate(xv_Divans(0:im-1,jc))

  allocate(w_Vor((nm+1)**2))
  allocate(w_Div((nm+1)**2))

  !---- Y_1^{-1} Υƥ ----
  xv_Psi = cos(xv_Lat)*sin(xv_Lon)       ! Y_1^{-1}
  xv_Chi = 0.0D0

  xv_Uans = sin(xv_Lat)*sin(xv_Lon)
  xv_Vans = cos(xv_Lon)

  xv_Vorans = -2*cos(xv_Lat)*sin(xv_Lon)
  xv_Divans = 0.0D0

  call w_StreamPotential2VectorMPI( w_xv(xv_Psi), w_xv(xv_Chi), xv_U, xv_V )

  call AssertEqual(&
    message='Psi = Y_1^-1 test of w_StreamPotential2VectorMPI(U)',   &
    answer = xv_Uans,                                             &
    check  = xv_U,                                                &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Psi = Y_1^-1 test of w_StreamPotential2VectorMPI(V)',   &
    answer = xv_Vans,                                             &
    check  = xv_V,                                                &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call w_Vector2VorDivMPI( xv_U, xv_V, w_Vor, w_Div )

  call AssertEqual(&
    message='Psi = Y_1^-1 test of w_Vector2VorDivMPI(Vor)',          &
    answer = xv_Vorans,                                           &
    check  = xv_w(w_Vor),                                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Psi = Y_1^-1 test of w_Vector2VorDivMPI(Div)',          &
    answer = xv_Divans,                                           &
    check  = xv_w(w_Div),                                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xv_UCosLat = xv_U * cos(xv_Lat) ; xv_VCosLat = xv_V * cos(xv_Lat)

  call w_VectorCosLat2VorDivMPI( xv_UCosLat, xv_VCosLat, w_Vor, w_Div )

  call AssertEqual(&
    message='Psi = Y_1^-1 test of w_VectorCosLat2VorDivMPI(Vor)', &
    answer = xv_Vorans,                                           &
    check  = xv_w(w_Vor),                                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Psi = Y_1^-1 test of w_VectorCosLat2VorDivMPI(Div)', &
    answer = xv_Divans,                                           &
    check  = xv_w(w_Div),                                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xv_Psi = 0.0D0
  xv_Chi = cos(xv_Lat)*sin(xv_Lon)       ! Y_1^{-1}

  xv_Uans = cos(xv_Lon)
  xv_Vans = - sin(xv_Lat)*sin(xv_Lon)

  xv_Vorans = 0.0D0
  xv_Divans = -2*cos(xv_Lat)*sin(xv_Lon)

  call w_StreamPotential2VectorMPI( w_xv(xv_Psi), w_xv(xv_Chi), xv_U, xv_V )

  call AssertEqual(&
    message='Chi = Y_1^-1 test of w_StreamPotential2VectorMPI(U)',   &
    answer = xv_Uans,                                             &
    check  = xv_U,                                                &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Chi = Y_1^-1 test of w_StreamPotential2VectorMPI(V)',   &
    answer = xv_Vans,                                             &
    check  = xv_V,                                                &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call w_Vector2VorDivMPI( xv_U, xv_V, w_Vor, w_Div )

  call AssertEqual(&
    message='Chi = Y_1^-1 test of w_Vector2VorDivMPI(Vor)',          &
    answer = xv_Vorans,                                           &
    check  = xv_w(w_Vor),                                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Chi = Y_1^-1 test of w_Vector2VorDivMPI(Div)',          &
    answer = xv_Divans,                                           &
    check  = xv_w(w_Div),                                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xv_UCosLat = xv_U * cos(xv_Lat) ; xv_VCosLat = xv_V * cos(xv_Lat)

  call w_VectorCosLat2VorDivMPI( xv_UCosLat, xv_VCosLat, w_Vor, w_Div )

  call AssertEqual(&
    message='Chi = Y_1^-1 test of w_VectorCosLat2VorDivMPI(Vor)', &
    answer = xv_Vorans,                                           &
    check  = xv_w(w_Vor),                                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Chi = Y_1^-1 test of w_VectorCosLat2VorDivMPI(Div)', &
    answer = xv_Divans,                                           &
    check  = xv_w(w_Div),                                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- Y_2^1 Υƥ ----
  xv_Psi = sin(xv_Lat)*cos(xv_Lat) * cos(xv_Lon)       ! Y_2^1
  xv_Chi = 0.0D0

  xv_Uans = - cos(2*xv_Lat)*cos(xv_Lon)
  xv_Vans = - sin(xv_Lat)*sin(xv_Lon)

  xv_Vorans = -6*sin(xv_Lat)*cos(xv_Lat) * cos(xv_Lon)       ! Y_2^1
  xv_Divans = 0.0D0

  call w_StreamPotential2VectorMPI( w_xv(xv_Psi), w_xv(xv_Chi), xv_U, xv_V )

  call AssertEqual(&
    message='Psi = Y_2^1 test of w_StreamPotential2VectorMPI(U)',    &
    answer = xv_Uans,                                             &
    check  = xv_U,                                                &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Psi = Y_2^1 test of w_StreamPotential2VectorMPI(V)',    &
    answer = xv_Vans,                                             &
    check  = xv_V,                                                &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call w_Vector2VorDivMPI( xv_U, xv_V, w_Vor, w_Div )

  call AssertEqual(&
    message='Psi = Y_2^1 test of w_Vector2VorDivMPI(Vor)',           &
    answer = xv_Vorans,                                           &
    check  = xv_w(w_Vor),                                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Psi = Y_2^1 test of w_Vector2VorDivMPI(Div)',           &
    answer = xv_Divans,                                           &
    check  = xv_w(w_Div),                                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xv_UCosLat = xv_U * cos(xv_Lat) ; xv_VCosLat = xv_V * cos(xv_Lat)

  call w_VectorCosLat2VorDivMPI( xv_UCosLat, xv_VCosLat, w_Vor, w_Div )

  call AssertEqual(&
    message='Psi = Y_2^1 test of w_VectorCosLat2VorDivMPI(Vor)', &
    answer = xv_Vorans,                                           &
    check  = xv_w(w_Vor),                                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Psi = Y_2^1 test of w_VectorCosLat2VorDivMPI(Div)', &
    answer = xv_Divans,                                           &
    check  = xv_w(w_Div),                                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xv_Psi = 0.0D0
  xv_Chi = sin(xv_Lat)*cos(xv_Lat) * cos(xv_Lon)       ! Y_2^1

  xv_Uans = - sin(xv_Lat)*sin(xv_Lon)
  xv_Vans =   cos(2*xv_Lat)*cos(xv_Lon)

  xv_Vorans = 0.0D0
  xv_Divans = -6*sin(xv_Lat)*cos(xv_Lat) * cos(xv_Lon)       ! Y_2^1

  call w_StreamPotential2VectorMPI( w_xv(xv_Psi), w_xv(xv_Chi), xv_U, xv_V )

  call AssertEqual(&
    message='Chi = Y_2^1 test of w_StreamPotential2VectorMPI(U)',    &
    answer = xv_Uans,                                             &
    check  = xv_U,                                                &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Chi = Y_2^1 test of w_StreamPotential2VectorMPI(V)',    &
    answer = xv_Vans,                                             &
    check  = xv_V,                                                &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call w_Vector2VorDivMPI( xv_U, xv_V, w_Vor, w_Div )

  call AssertEqual(&
    message='Chi = Y_2^1 test of w_Vector2VorDivMPI(Vor)',           &
    answer = xv_Vorans,                                           &
    check  = xv_w(w_Vor),                                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Chi = Y_2^1 test of w_Vector2VorDivMPI(Div)',           &
    answer = xv_Divans,                                           &
    check  = xv_w(w_Div),                                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xv_UCosLat = xv_U * cos(xv_Lat) ; xv_VCosLat = xv_V * cos(xv_Lat)

  call w_VectorCosLat2VorDivMPI( xv_UCosLat, xv_VCosLat, w_Vor, w_Div )

  call AssertEqual(&
    message='Chi = Y_2^1 test of w_VectorCosLat2VorDivMPI(Vor)', &
    answer = xv_Vorans,                                           &
    check  = xv_w(w_Vor),                                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Chi = Y_2^1 test of w_VectorCosLat2VorDivMPI(Div)', &
    answer = xv_Divans,                                           &
    check  = xv_w(w_Div),                                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- Y_1^-1, Y_2^1 Υƥ ----
  xv_Psi = sin(xv_Lat)*cos(xv_Lat) * cos(xv_Lon)       ! Y_2^1
  xv_Chi = cos(xv_Lat)*sin(xv_Lon)                     ! Y_1^{-1}

  xv_Uans = - cos(2*xv_Lat)*cos(xv_Lon) + cos(xv_Lon)
  xv_Vans = - sin(xv_Lat)*sin(xv_Lon) - sin(xv_Lat)*sin(xv_Lon)

  xv_Vorans = -6*sin(xv_Lat)*cos(xv_Lat) * cos(xv_Lon)       ! Y_2^1
  xv_Divans = -2*cos(xv_Lat)*sin(xv_Lon)                     ! Y_1^{-1}

  call w_StreamPotential2VectorMPI( w_xv(xv_Psi), w_xv(xv_Chi), xv_U, xv_V )

  call AssertEqual(&
    message='Psi = Y_2^1, Chi = Y_1^-1 test of w_StreamPotential2VectorMPI(U)',     &
    answer = xv_Uans,                                             &
    check  = xv_U,                                                &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Psi = Y_2^1, Chi = Y_1^-1 test of w_StreamPotential2VectorMPI(V)',     &
    answer = xv_Vans,                                             &
    check  = xv_V,                                                &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call w_Vector2VorDivMPI( xv_U, xv_V, w_Vor, w_Div )

  call AssertEqual(&
    message='Psi = Y_2^1, Chi=Y_1^-1 test of w_Vector2VorDivMPI(Vor)',&
    answer = xv_Vorans,                                           &
    check  = xv_w(w_Vor),                                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Psi = Y_2^1, Chi=Y_1^-1 test of w_Vector2VorDivMPI(Div)',&
    answer = xv_Divans,                                           &
    check  = xv_w(w_Div),                                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xv_UCosLat = xv_U * cos(xv_Lat) ; xv_VCosLat = xv_V * cos(xv_Lat)

  call w_VectorCosLat2VorDivMPI( xv_UCosLat, xv_VCosLat, w_Vor, w_Div )

  call AssertEqual(&
    message='Psi = Y_2^1, Chi = Y_1^-1 test of w_VectorCosLat2VorDivMPI(Vor)',&
    answer = xv_Vorans,                                           &
    check  = xv_w(w_Vor),                                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Psi = Y_2^1, Chi = Y_1^-1 test of w_VectorCosLat2VorDivMPI(Div)',&
    answer = xv_Divans,                                           &
    check  = xv_w(w_Div),                                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xv_Psi = cos(xv_Lat)*sin(xv_Lon)                     ! Y_1^{-1}
  xv_Chi = sin(xv_Lat)*cos(xv_Lat) * cos(xv_Lon)       ! Y_2^1

  xv_Uans = 0.0D0
  xv_Vans = cos(2*xv_Lat)*cos(xv_Lon) + cos(xv_Lon)

  xv_Vorans = -2*cos(xv_Lat)*sin(xv_Lon)                     ! Y_1^{-1}
  xv_Divans = -6*sin(xv_Lat)*cos(xv_Lat) * cos(xv_Lon)       ! Y_2^1

  call w_StreamPotential2VectorMPI( w_xv(xv_Psi), w_xv(xv_Chi), xv_U, xv_V )

  call AssertEqual(&
    message='Psi = Y_1^-1, Chi = Y_2^1 test of w_StreamPotential2VectorMPI(U)',     &
    answer = xv_Uans,                                             &
    check  = xv_U,                                                &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Psi = Y_1^-1, Chi = Y_2^1 test of w_StreamPotential2VectorMPI(V)',     &
    answer = xv_Vans,                                             &
    check  = xv_V,                                                &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call w_Vector2VorDivMPI( xv_U, xv_V, w_Vor, w_Div )

  call AssertEqual(&
    message='Psi = Y_1^-1, Chi=Y_2^1 test of w_Vector2VorDivMPI(Vor)',&
    answer = xv_Vorans,                                           &
    check  = xv_w(w_Vor),                                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Psi = Y_1^-1, Chi=Y_2^1 test of w_Vector2VorDivMPI(Div)',&
    answer = xv_Divans,                                           &
    check  = xv_w(w_Div),                                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xv_UCosLat = xv_U * cos(xv_Lat) ; xv_VCosLat = xv_V * cos(xv_Lat)

  call w_VectorCosLat2VorDivMPI( xv_UCosLat, xv_VCosLat, w_Vor, w_Div )

  call AssertEqual(&
    message='Psi = Y_1^-1, Chi = Y_2^1 test of w_VectorCosLat2VorDivMPI(Vor)',&
    answer = xv_Vorans,                                           &
    check  = xv_w(w_Vor),                                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='Psi = Y_1^-1, Chi = Y_2^1 test of w_VectorCosLat2VorDivMPI(Div)',&
    answer = xv_Divans,                                           &
    check  = xv_w(w_Div),                                         &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

 !------ MPIνλ ------

  call MPI_FINALIZE(IERR)

  call MessageNotify('M','w_base_mpi_module_vector sjpack_test', &
                         'w_base_mpi_module_sjpack subroutine tests succeeded!') 

end program w_base_mpi_module_sjpack_vector
