!----------------------------------------------------------------------
!     Copyright (c) 2012--2013 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!ɽ  w_deriv_mpi_module_sjpack
!
!  spml/w_deriv_mpi_module_sjpack ⥸塼ϵ̾Ǥ 2 ήαư
!  ĴȡѤڥȥˡ MPI ˤäƿͷ׻뤿 
!  ⥸塼 w_mpi_module_sjpack β⥸塼Ǥ, ڥȥˡ
!  ʬ׻Τ Fortran90 ؿ󶡤. 
!
!   ISPACK  SJPACK-MPI  Fortran77 ֥롼ƤǤ. 
!  ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
!  ĤƤ ISPACK/SJPACK-MPI Υޥ˥奢򻲾Ȥ줿.
!
!
!  2012/03/31  ݹ  w_deriv_mpi_module  sjpack 
!      2013/02/23  ݹ  w_deriv_mpi_Finalize Ƴ
!
module w_deriv_mpi_module_sjpack
  !
  ! w_deriv_mpi_module_sjpack
  !
  !  spml/w_deriv_mpi_module_sjpack ⥸塼ϵ̾Ǥ 2 ήαư
  !  ĴȡѤڥȥˡ MPI ˤäƿͷ׻뤿 
  !  ⥸塼 w_mpi_module_sjpack β⥸塼Ǥ, ڥȥˡ
  !  ʬ׻Τ Fortran90 ؿ󶡤. 
  !
  !   ISPACK  SJPACK-MPI  Fortran77 ֥롼ƤǤ. 
  !  ڥȥǡӳʻǡγǼˡѴξܤ׻ˡ
  !  ĤƤ ISPACK/SJPACK Υޥ˥奢򻲾Ȥ줿.
  !
  use dc_message, only : MessageNotify
  use w_base_module_sjpack, only : im, jm, nm=>nn
  use w_base_mpi_module_sjpack, only : jc, xv_w, w_xv
  use w_deriv_module_sjpack, only : w_DLon_w
  implicit none
  private im, jm, nm                          ! Intel Fortran к

  private

  public w_deriv_mpi_Initial                  ! 
  public w_deriv_mpi_Finalize                 ! λ

  public xv_GradLon_w, xv_GradLat_w           ! ۷ʬ
  public w_DivLon_xv, w_DivLat_xv             ! ȯʬ
  public w_Div_xv_xv                          ! ȯʬ
  public w_JacobianMPI_w_w                    ! 䥳ӥ
  public xv_GradLambda_w, xv_GradMu_w         ! ۷ʬ(,̺ɸ)
  public w_DivLambda_xv, w_DivMu_xv           ! ȯʬ(,̺ɸ)

  contains

  !---------------  -----------------
    subroutine w_deriv_mpi_initial
      !
      ! 롼. w_deriv_mpi_module ȸߴݤĤѰդƤ
      !
      call MessageNotify('M','w_deriv_mpi_initial', &
           'w_deriv_mpi_module_sjpack is initialized (dummy)')

    end subroutine w_deriv_mpi_initial

  !--------------- ʬ׻ -----------------
    function xv_GradLon_w(w_data)
      !
      ! ڥȥǡ˸۷ʬ 1/cosա/ߦ 
      ! Ѥʻǡ֤(1 ).
      !
      real(8)              :: xv_GradLon_w(0:im-1,jc)
      !(out) ڥȥǡ۷ʬʻǡ

      real(8), intent(in)  :: w_data((nm+1)*(nm+1))
      !(in) ϥڥȥǡ

      xv_GradLon_w = xv_w(w_data,ipow=1,iflag=-1)
    end function xv_GradLon_w

    function xv_GradLat_w(w_data)
      !
      ! ڥȥǡ˸۷ʬ /ߦ Ѥ
      ! ʻǡѴ֤(1 ).
      !
      real(8)              :: xv_GradLat_w(0:im-1,jc)
      !(out) ڥȥǡ۷ʬʻǡ

      real(8), intent(in)  :: w_data((nm+1)*(nm+1))
      !(in) ϥڥȥǡ

      xv_GradLat_w = xv_w(w_data,ipow=1,iflag=1)
    end function xv_GradLat_w

    function w_DivLon_xv(xv_data)
      !
      ! ʻǡȯʬ 1/cosա/ߦ Ѥ
      ! ڥȥǡѴ֤(1 ).
      !
      real(8)              :: w_DivLon_xv((nm+1)*(nm+1))
      !(out) ʻǡȯʬڥȥǡ
      
      real(8), intent(in)  :: xv_data(0:im-1,jc)
      !(in) ϳʻǡ

      w_DivLon_xv = w_xv(xv_data,ipow=1,iflag=-1)
    end function w_DivLon_xv

    function w_DivLat_xv(xv_data)
      !
      ! ʻǡȯʬ 1/cosա(f cos)/ߦ Ѥ
      ! ڥȥǡѴ֤(1 ).
      !
      real(8)              :: w_DivLat_xv((nm+1)*(nm+1))
      !(out) ʻǡȯʬڥȥǡ

      real(8), intent(in)  :: xv_data(0:im-1,jc)
      !(in) ϳʻǡ

      w_DivLat_xv = w_xv(xv_data,ipow=1,iflag=1)
    end function w_DivLat_xv

    function w_Div_xv_xv(xv_u,xv_v)
      !
      ! 2 Ĥϳʻǡ٥ȥʬȤȯ׻, 
      ! ڥȥǡȤ֤(1 ).
      !
      real(8)              :: w_Div_xv_xv((nm+1)*(nm+1))
      !(out) 2 Ĥϳʻǡ٥ȥʬȤȯΥڥȥǡ

      real(8), intent(in)  :: xv_u(0:im-1,jc)
      !(in) ٥ȥʬγʻǡ

      real(8), intent(in)  :: xv_v(0:im-1,jc)
      !(in) ٥ȥʬγʻǡ

      w_Div_xv_xv = w_Divlon_xv(xv_u) + w_Divlat_xv(xv_v)
    end function w_Div_xv_xv

    function w_JacobianMPI_w_w(w_a,w_b)
      ! 2 ĤΥڥȥǡ˥䥳ӥ
      !
      !   J(f,g) = f/ߦˡg/ߦ - g/ߦˡf/ߦ
      !          = f/ߦˡ1/cosաg/ߦ
      !             - g/ߦˡ1/cosաf/ߦ
      !
      ! Ѥ(1 ).

      real(8)             :: w_JacobianMPI_w_w((nm+1)*(nm+1))
      !(out) 2 ĤΥڥȥǡΥ䥳ӥ

      real(8), intent(in) :: w_a((nm+1)*(nm+1))
      !(in) 1ܤϥڥȥǡ
      
      real(8), intent(in) :: w_b((nm+1)*(nm+1))
      !(in) 2ܤϥڥȥǡ

      w_JacobianMPI_w_w = w_xv( &
                  xv_w(w_DLon_w(w_a))*xv_w(w_b,ipow=2,iflag=1) &
                - xv_w(w_DLon_w(w_b))*xv_w(w_a,ipow=2,iflag=1) )

    end function w_JacobianMPI_w_w

  !--------------- ʬ׻ (,̺ɸ) -----------------
    function xv_GradLambda_w(w_data)
      !
      ! ڥȥǡ˸۷ʬ /ߦ Ѥ(1 ).
      !
      real(8)              :: xv_GradLambda_w(0:im-1,jc)
      !(out) ڥȥǡ۷ʬʻǡ

      real(8), intent(in)  :: w_data((nm+1)*(nm+1))
      !(in) ϥڥȥǡ
      
      xv_GradLambda_w = xv_w(w_data,ipow=0,iflag=-1)
    end function xv_GradLambda_w

    function xv_GradMu_w(w_data)
      !
      ! ڥȥǡ˸۷ʬ (1-^2)/ߦ  (=sin)
      ! ѤƳʻǡѴ֤(1 ).
      !
      real(8)              :: xv_GradMu_w(0:im-1,jc)
      !(out) ڥȥǡ۷ʬʻǡ

      real(8), intent(in)  :: w_data((nm+1)*(nm+1))
      !(in) ϥڥȥǡ

      xv_GradMu_w = xv_w(w_data,ipow=0,iflag=1)
    end function xv_GradMu_w

    function w_DivLambda_xv(xv_data)
      !
      ! ʻǡȯʬ 1/(1-^2)/ߦ (=sin) 
      ! ѤƥڥȥǡѴ֤(1 ).
      !
      real(8)              :: w_DivLambda_xv((nm+1)*(nm+1))
      !(out) ʻǡȯʬڥȥǡ

      real(8), intent(in)  :: xv_data(0:im-1,jc)
      !(in) ϳʻǡ

      w_DivLambda_xv = w_xv(xv_data,ipow=2,iflag=-1)
    end function w_DivLambda_xv

    function w_DivMu_xv(xv_data)
      !
      ! ʻǡȯʬ /ߦ (=sin)Ѥ
      ! ڥȥǡѴ֤(1 ).
      !
      real(8)              :: w_DivMu_xv((nm+1)*(nm+1))
      !(out) ʻǡȯʬڥȥǡ

      real(8), intent(in)  :: xv_data(0:im-1,jc)
      !(in) ϳʻǡ

      w_DivMu_xv = w_xv(xv_data,ipow=2,iflag=1)
    end function w_DivMu_xv

    subroutine w_deriv_mpi_finalize
      !
      ! ⥸塼νλ(դβ)򤪤ʤ. 
      !
      ! Υ֥롼ñȤѤΤǤʤ, 
      ! ̥֥롼 w_mpi_Finalize Ѥ뤳.
      !
      call MessageNotify('M','w_deriv_mpi_Finalize',&
        'No need to finalize w_deriv_mpi_module_sjpack')

      call MessageNotify('M','w_deriv_mpi_Finalize',&
           'w_deriv_mpi_module_sjpack is finalized (dummy, 20013/02/23)')

    end subroutine w_deriv_mpi_finalize

end module w_deriv_mpi_module_sjpack
