!= ȳɹˤ륢٥Ѳ
!
!= modification of surface albedo on the snow covered ground and on the sea ice
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: modify_albedo_snowseaice.f90,v 1.1 2009-08-09 12:36:24 yot Exp $
! Tag Name::  $Name: dcpam5-20100224 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module modify_albedo_snowseaice

  ! ⥸塼 ; USE statements
  !

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision.
    &                 STRING     ! ʸ.       Strings.


  ! ʻ
  ! Grid points settings

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  ! ³
  ! Public procedure
  !
  public:: ModAlbedoDueToSnowSeaIce

  ! ѿ
  ! Public variables
  !
  logical, save, public:: modify_albedo_snowseaice_inited = .false.
                              ! ե饰.
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !

  character(*), parameter:: module_name = 'modify_albedo_snowseaice'
                              ! ⥸塼̾.
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20100224 $' // &
    & '$Id: modify_albedo_snowseaice.f90,v 1.1 2009-08-09 12:36:24 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version

  ! INTERFACE ʸ ; INTERFACE statements
  !

contains

  !-------------------------------------------------------------------

  subroutine ModAlbedoDueToSnowSeaIce(          &
    & xy_SurfCond,                              &
    & xy_SurfSnow, xy_SeaIceConc,               & ! (in   ) optional
    & xy_SurfAlbedo                             & ! (inout)
    )

    ! ʻ
    ! Grid points settings
    !
    use gridset, only: imax, & ! ٳʻ.
                               ! Number of grid points in longitude
      &                jmax, & ! ٳʻ.
                               ! Number of grid points in latitude
      &                kmax    ! ľؿ.
                               ! Number of vertical level

    ! ȳɹ
    ! Setting constants of snow and sea ice
    !
    use constants_snowseaice, only:            &
      & SnowThreshold => ThresholdSurfSnow,    &
      & SnowAlbedo,                            &
      & SeaIceThreshold,                       &
      & SeaIceAlbedo

    integer , intent(in   )           :: xy_SurfCond  ( 0:imax-1, 1:jmax )
    real(DP), intent(in   ), optional :: xy_SurfSnow  ( 0:imax-1, 1:jmax )
    real(DP), intent(in   ), optional :: xy_SeaIceConc( 0:imax-1, 1:jmax )
    real(DP), intent(inout)           :: xy_SurfAlbedo( 0:imax-1, 1:jmax )


    ! ѿ
    ! Work variables
    !
    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude

    ! 
    ! Initialization
    !
    if ( .not. modify_albedo_snowseaice_inited ) call ModAlbedoSnowSeaIceInit

    if ( present( xy_SurfSnow ) ) then
      ! modify surface albedo on the snow covered ground
      !
      do j = 1, jmax
        do i = 0, imax-1
          if ( xy_SurfCond(i,j) > 0 .and. xy_SurfSnow(i,j) > SnowThreshold ) then
            xy_SurfAlbedo(i,j) = SnowAlbedo
          end if
        end do
      end do
    end if

    if ( present( xy_SeaIceConc ) ) then
      ! modify surface albedo on the sea ice
      !
      do j = 1, jmax
        do i = 0, imax-1
          if ( xy_SurfCond(i,j) == 0 .and. xy_SeaIceConc(i,j) > SeaIceThreshold ) then
            xy_SurfAlbedo(i,j) = SeaIceAlbedo
          end if
        end do
      end do
    end if


  end subroutine ModAlbedoDueToSnowSeaIce

  !**************************************************************************************

  subroutine ModAlbedoSnowSeaIceInit

    ! ѿ
    ! Work variables
    !


    modify_albedo_snowseaice_inited = .true.

  end subroutine ModAlbedoSnowSeaIceInit

  !**************************************************************************************

end module modify_albedo_snowseaice
