!= Chou and Kouvaris (1991) ˤĹͥǥ
!
!= Long radiation model described by Chou and Kouvaris (1991)
!
! Authors::   Yoshiyuki O. TAKAHASHI
! Version::   $Id: radiation_CK1991.f90,v 1.3 2011-02-21 12:15:37 yot Exp $
! Tag Name::  $Name: dcpam5-20110228-4 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module radiation_CK1991
  !
  != Chou and Kouvaris (1991) ˤĹͥǥ
  !
  != Long radiation model described by Chou and Kouvaris (1991)
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! Ĺͥǥ.
  !
  ! This is a model of long wave radiation. 
  !
  !== References
  !
  !  Chou, M.-D., and L. Kouvaris, 
  !    Calculations of transmittion functions in the infrared CO2 and O3 bands, 
  !    J. Geophys. Res., 96, 9003-9012, 1991.
  !
  !== Procedures List
  !
!!$  ! RadiationFluxDennouAGCM :: ͥեåη׻
!!$  ! RadiationDTempDt        :: ͥեåˤ벹Ѳη׻
!!$  ! RadiationFluxOutput     :: ͥեåν
!!$  ! RadiationFinalize       :: λ (⥸塼ѿγդ)
!!$  ! ------------            :: ------------
!!$  ! RadiationFluxDennouAGCM :: Calculate radiation flux
!!$  ! RadiationDTempDt        :: Calculate temperature tendency with radiation flux
!!$  ! RadiationFluxOutput     :: Output radiation fluxes
!!$  ! RadiationFinalize       :: Termination (deallocate variables in this module)
  !
  !== NAMELIST
  !
!!$  ! NAMELIST#radiation_DennouAGCM_nml
  !

  ! USE statements
  !

  ! 
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! Double precision.
    &                 STRING, &  ! Strings.
    &                 TOKEN      ! Keywords.

  !
  ! Grid points settings
  !
  use gridset, only: imax, & ! 
                             ! Number of grid points in longitude
    &                jmax, & ! 
                             ! Number of grid points in latitude
    &                kmax    ! 
                             ! Number of vertical level

  ! Declaration statements
  !
  implicit none
  private


  integer , parameter :: NTabPress = 26
  real(DP), save      :: a_TabLog10Press (NTabPress)

  integer , parameter :: NCO2TabAbsAmt = 21
  real(DP), save      :: a_CO2TabLog10AbsAmt(NCO2TabAbsAmt)
  real(DP), save      :: aa_CO2TabAlpha     (NCO2TabAbsAmt, NTabPress)
  real(DP), save      :: aa_CO2TabBeta      (NCO2TabAbsAmt, NTabPress)
  real(DP), save      :: aa_CO2TabAbs       (NCO2TabAbsAmt, NTabPress)

  integer , parameter :: NO3TabAbsAmt = 21
  real(DP), save      :: a_O3TabLog10AbsAmt(NO3TabAbsAmt)
  real(DP), save      :: aa_O3TabAlpha     (NO3TabAbsAmt, NTabPress)
  real(DP), save      :: aa_O3TabBeta      (NO3TabAbsAmt, NTabPress)
  real(DP), save      :: aa_O3TabAbs       (NO3TabAbsAmt, NTabPress)



  data a_TabLog10Press &
    & / &
    & -2.0, -1.8, -1.6, -1.4, -1.2, -1.0, -0.8, -0.6, -0.4, -0.2,  0.0,  0.2,  0.4,  &
    &        0.6,  0.8,  1.0,  1.2,  1.4,  1.6,  1.8,  2.0,  2.2,  2.4,  2.6,  2.8,  3.0 &
    & /

  data a_CO2TabLog10AbsAmt &
    & / &
    & -3.0, -2.7, -2.4, -2.1, -1.8, -1.5, -1.2, -0.9, -0.6, -0.3,  0.0,  0.3,  0.6,  &
    &        0.9,  1.2,  1.5,  1.8,  2.1,  2.4,  2.7,  3.0 &
    &/

  data aa_CO2TabAlpha &
    & / &
    ! -3.0 -2.7 -2.4 -2.1 -1.8 -1.5 -1.2 -0.9 -0.6 -0.3 0.0 0.3 0.6 0.9 1.2 1.5 1.8 2.1 2.4 2.7 3.0
    &  43, 53, 60, 65, 67, 67, 68, 70, 74, 77, 79, 81, 82, 82, 82, 81, 79, 77, 74, 72, 68, & ! -2.0
    &  43, 53, 60, 65, 66, 67, 68, 70, 72, 75, 77, 79, 79, 80, 79, 77, 76, 73, 71, 68, 64, & ! -1.8
    &  43, 53, 60, 64, 66, 66, 67, 69, 71, 73, 75, 76, 76, 76, 76, 74, 72, 70, 67, 64, 60, & ! -1.6
    &  43, 52, 60, 64, 65, 65, 66, 67, 69, 71, 72, 73, 73, 73, 72, 70, 68, 66, 63, 60, 57, & ! -1.4
    &  42, 52, 59, 63, 64, 64, 64, 65, 66, 68, 69, 69, 69, 69, 68, 66, 64, 61, 59, 56, 53, & ! -1.2
    &  42, 51, 58, 62, 63, 62, 62, 62, 63, 64, 65, 65, 65, 65, 64, 62, 60, 57, 55, 52, 50, & ! -1.0
    &  41, 50, 57, 60, 60, 59, 59, 59, 59, 60, 61, 61, 61, 61, 60, 58, 56, 54, 51, 49, 47, & ! -0.8
    &  40, 48, 54, 57, 57, 56, 55, 55, 55, 56, 57, 57, 57, 56, 55, 54, 52, 50, 48, 46, 44, & ! -0.6
    &  38, 46, 51, 54, 54, 52, 51, 51, 51, 52, 53, 53, 53, 52, 52, 50, 48, 47, 45, 43, 42, & ! -0.4
    &  36, 43, 48, 50, 49, 48, 47, 46, 47, 48, 49, 49, 49, 49, 48, 47, 45, 44, 42, 41, 40, & ! -0.2
    &  33, 39, 43, 45, 45, 43, 42, 43, 43, 44, 45, 46, 46, 46, 45, 44, 43, 42, 40, 40, 39, & !  0.0
    &  29, 34, 38, 40, 40, 39, 39, 39, 40, 41, 42, 43, 43, 43, 42, 42, 41, 40, 39, 38, 38, & !  0.2
    &  24, 29, 32, 35, 36, 36, 36, 36, 37, 39, 40, 40, 40, 40, 40, 40, 39, 38, 38, 37, 37, & !  0.4
    &  19, 24, 27, 30, 32, 33, 33, 34, 35, 36, 37, 38, 38, 39, 38, 38, 38, 37, 37, 37, 36, & !  0.6
    &  15, 19, 23, 26, 29, 30, 31, 32, 33, 35, 36, 36, 37, 37, 37, 37, 37, 36, 36, 36, 36, & !  0.8
    &  11, 15, 19, 23, 26, 29, 30, 31, 32, 33, 34, 35, 36, 36, 36, 37, 37, 37, 37, 36, 35, & !  1.0
    &   8, 11, 15, 20, 24, 27, 29, 30, 31, 32, 33, 34, 35, 36, 36, 36, 37, 37, 37, 36, 34, & !  1.2
    &   6,  9, 13, 17, 21, 25, 28, 29, 30, 31, 32, 32, 33, 33, 33, 33, 33, 33, 33, 32, 31, & !  1.4
    &   4,  7, 10, 14, 19, 23, 26, 28, 29, 30, 30, 31, 31, 32, 32, 32, 33, 33, 33, 32, 30, & !  1.6
    &   3,  5,  8, 12, 17, 21, 24, 27, 28, 29, 29, 30, 30, 31, 32, 32, 33, 33, 32, 31, 30, & !  1.8
    &   2,  4,  7, 11, 14, 18, 22, 25, 27, 28, 28, 28, 29, 30, 31, 32, 32, 32, 32, 30, 29, & !  2.0
    &   2,  4,  6,  9, 12, 16, 19, 22, 25, 26, 27, 27, 28, 29, 30, 32, 32, 32, 30, 29, 27, & !  2.2
    &   2,  3,  6,  8, 11, 13, 16, 20, 23, 25, 26, 27, 28, 29, 30, 31, 31, 31, 29, 27, 26, & !  2.4
    &   2,  3,  5,  7,  9, 11, 14, 17, 20, 23, 25, 27, 28, 29, 30, 30, 30, 29, 28, 26, 25, & !  2.6
    &   1,  2,  4,  6,  8,  9, 11, 14, 17, 20, 23, 26, 28, 30, 30, 30, 29, 28, 26, 25, 25, & !  2.8
    &   1,  2,  3,  5,  6,  7,  9, 11, 15, 18, 22, 26, 29, 31, 30, 29, 28, 26, 25, 25, 25  & !  3.0
    & / 

  data aa_CO2TabBeta &
    & / &
    ! -3.0 -2.7 -2.4 -2.1 -1.8 -1.5 -1.2 -0.9 -0.6 -0.3 0.0 0.3 0.6 0.9 1.2 1.5 1.8 2.1 2.4 2.7 3.0
    &    6,  9, 11, 12, 12, 13, 16, 19, 22, 23, 24, 25, 26, 27, 27, 25, 24, 22, 21, 19, 17, & ! -2.0
    &    6,  9, 11, 12, 12, 13, 16, 19, 22, 23, 23, 24, 25, 26, 26, 24, 22, 21, 19, 18, 16, & ! -1.8
    &    6,  9, 11, 12, 12, 13, 16, 19, 21, 22, 23, 23, 24, 25, 24, 23, 21, 20, 18, 16, 14, & ! -1.6
    &    6,  9, 11, 12, 12, 13, 16, 19, 21, 22, 22, 22, 23, 23, 23, 21, 20, 18, 17, 15, 13, & ! -1.4
    &    6,  9, 11, 12, 12, 13, 16, 18, 20, 21, 21, 21, 21, 22, 21, 20, 18, 17, 15, 14, 12, & ! -1.2
    &    6,  9, 11, 12, 12, 13, 15, 18, 19, 20, 19, 19, 20, 20, 20, 18, 17, 15, 14, 13, 11, & ! -1.0
    &    6,  9, 11, 12, 12, 13, 15, 17, 18, 18, 18, 18, 18, 18, 18, 17, 15, 14, 13, 11, 10, & ! -0.8
    &    6,  9, 11, 12, 12, 12, 14, 16, 17, 17, 16, 16, 17, 17, 17, 16, 15, 14, 12, 11, 10, & ! -0.6
    &    6,  9, 11, 11, 11, 12, 13, 14, 15, 15, 15, 15, 15, 15, 15, 14, 13, 12, 11, 10,  9, & ! -0.4
    &    6,  9, 11, 11, 11, 11, 12, 13, 14, 14, 13, 13, 14, 14, 14, 13, 12, 12, 11, 10,  8, & ! -0.2
    &    6,  8, 10, 10, 10, 10, 10, 12, 12, 12, 12, 12, 13, 13, 13, 12, 12, 11, 10,  9,  7, & !  0.0
    &    6,  8,  9, 10,  9,  9,  9, 10, 11, 11, 11, 11, 12, 12, 12, 11, 11, 10,  9,  8,  6, & !  0.2
    &    6,  8,  9,  9,  8,  7,  8,  9, 10, 10, 10, 10, 11, 11, 11, 11, 10,  9,  8,  6,  4, & !  0.4
    &    5,  7,  8,  8,  7,  7,  7,  8,  9,  9, 10, 10, 10, 10, 10, 10, 10,  8,  7,  5,  3, & !  0.6
    &    5,  6,  7,  7,  7,  6,  6,  7,  8,  9,  9, 10, 10, 10, 10, 10,  9,  7,  6,  4,  2, & !  0.8
    &    4,  5,  6,  6,  6,  6,  5,  6,  7,  8,  8,  9,  9,  9,  9,  9,  8,  6,  4,  2,  1, & !  1.0
    &    3,  4,  5,  6,  6,  6,  5,  5,  6,  7,  8,  8,  8,  9,  8,  8,  6,  4,  2,  1,  0, & !  1.2
    &    2,  3,  4,  5,  5,  5,  5,  5,  5,  6,  6,  6,  6,  6,  6,  5,  4,  2,  1,  0,  0, & !  1.4
    &    2,  2,  3,  4,  5,  5,  5,  5,  4,  4,  5,  5,  5,  5,  4,  3,  1,  0,  0, -1, -2, & !  1.6
    &    1,  2,  2,  3,  4,  5,  5,  5,  4,  4,  4,  4,  5,  4,  3,  2,  0,  0, -1, -2, -3, & !  1.8
    &    1,  1,  1,  2,  3,  4,  5,  5,  5,  4,  3,  3,  3,  3,  2,  1,  0, -1, -2, -3, -3, & !  2.0
    &    0,  0,  1,  1,  3,  4,  5,  5,  5,  4,  3,  3,  2,  2,  1,  0,  0, -1, -2, -3, -3, & !  2.2
    &    0,  0,  0,  1,  2,  3,  4,  5,  5,  4,  3,  2,  1,  1,  0,  0, -1, -2, -3, -3, -2, & !  2.4
    &    0,  0,  0,  1,  2,  2,  3,  4,  5,  4,  3,  2,  1,  0, -1, -1, -2, -2, -3, -2, -1, & !  2.6
    &    0,  0,  0,  1,  1,  2,  3,  4,  4,  4,  3,  2,  0, -1, -2, -2, -2, -2, -2, -1,  0, & !  2.8
    &    0,  0,  0,  1,  1,  2,  2,  3,  3,  3,  2,  1,  0, -1, -3, -4, -3, -3, -1,  0,  0  & !  3.0
    & /

  ! The value at log10(p) = 0.4, log10(w) = 2.1 is deduced to be 685 by interpolating with 3rd order 
  ! Lagrange interpoation in direction of w, since that in the paper by Chou and Kouvaris (1991) is a BLANK. 
  data aa_CO2TabAbs &
    & / &
    ! -3.0  -2.7  -2.4  -2.1  -1.8  -1.5  -1.2  -0.9  -0.6  -0.3   0.0   0.3   0.6   0.9   1.2   1.5   1.8   2.1   2.4   2.7   3.0
    & 3241, 3099, 2956, 2810, 2667, 2532, 2407, 2290, 2177, 2067, 1959, 1852, 1747, &
    &       1643, 1540, 1439, 1341, 1247, 1154, 1063,  973, & ! -2.0
    & 3241, 3099, 2955, 2809, 2666, 2531, 2405, 2287, 2173, 2061, 1951, 1842, 1735, &
    &       1628, 1523, 1420, 1320, 1222, 1127, 1033,  940, & ! -1.8
    & 3240, 3098, 2954, 2808, 2664, 2528, 2401, 2282, 2166, 2052, 1940, 1828, 1718, &
    &       1609, 1501, 1396, 1293, 1193, 1095,  998,  902, & ! -1.6
    & 3239, 3096, 2952, 2805, 2661, 2524, 2396, 2274, 2156, 2040, 1924, 1810, 1698, &
    &       1586, 1475, 1367, 1262, 1159, 1057,  958,  860, & ! -1.4
    & 3238, 3094, 2949, 2802, 2656, 2518, 2387, 2263, 2143, 2023, 1904, 1787, 1672, &
    &       1557, 1444, 1334, 1225, 1119, 1015,  913,  815, & ! -1.2
    & 3235, 3091, 2945, 2796, 2649, 2508, 2375, 2248, 2124, 2001, 1879, 1759, 1640, &
    &       1523, 1407, 1294, 1183, 1074,  968,  865,  767, & ! -1.0
    & 3231, 3085, 2938, 2788, 2638, 2495, 2358, 2227, 2099, 1972, 1847, 1724, 1603, &
    &       1483, 1365, 1249, 1135, 1024,  917,  815,  718, & ! -0.8
    & 3225, 3078, 2928, 2775, 2623, 2476, 2335, 2200, 2068, 1938, 1809, 1683, 1559, &
    &       1438, 1317, 1199, 1084,  972,  866,  765,  673, & ! -0.6
    & 3216, 3066, 2913, 2757, 2601, 2450, 2305, 2165, 2030, 1896, 1765, 1636, 1510, &
    &       1386, 1263, 1144, 1027,  916,  811,  713,  625, & ! -0.4
    & 3202, 3048, 2892, 2731, 2571, 2415, 2266, 2123, 1984, 1847, 1713, 1582, 1454, &
    &       1328, 1205, 1084,  968,  858,  755,  662,  579, & ! -0.2
    & 3183, 3023, 2862, 2697, 2533, 2372, 2219, 2073, 1930, 1791, 1656, 1523, 1394, &
    &       1266, 1142, 1021,  906,  799,  701,  613,  535, & !  0.0
    & 3156, 2990, 2823, 2655, 2486, 2321, 2165, 2015, 1871, 1730, 1593, 1459, 1329, &
    &       1200, 1076,  956,  844,  741,  648,  566,  494, & !  0.2
    & 3120, 2948, 2776, 2603, 2431, 2263, 2104, 1952, 1806, 1664, 1526, 1392, 1260, &
    &       1132, 1008,  892,  783,  685,  598,  522,  456, & !  0.4
    & 3078, 2897, 2720, 2544, 2369, 2200, 2038, 1884, 1737, 1595, 1456, 1321, 1189, &
    &       1062,  941,  828,  725,  632,  552,  482,  421, & !  0.6
    & 3029, 2840, 2658, 2480, 2303, 2132, 1969, 1814, 1666, 1524, 1385, 1249, 1118, &
    &        993,  875,  766,  669,  583,  509,  445,  389, & !  0.8
    & 2978, 2779, 2593, 2412, 2235, 2063, 1899, 1743, 1595, 1451, 1311, 1176, 1046, &
    &        923,  809,  706,  614,  533,  463,  401,  348, & !  1.0
    & 2927, 2717, 2525, 2343, 2166, 1995, 1831, 1674, 1524, 1379, 1239, 1104,  976, &
    &        856,  747,  649,  562,  485,  418,  358,  307, & !  1.2
    & 2883, 2662, 2461, 2275, 2098, 1927, 1762, 1603, 1450, 1303, 1161, 1026,  898, &
    &        780,  672,  576,  493,  422,  362,  311,  266, & !  1.4
    & 2846, 2612, 2401, 2210, 2031, 1861, 1696, 1535, 1379, 1228, 1085,  950,  824, &
    &        709,  605,  516,  440,  377,  323,  276,  233, & !  1.6
    & 2817, 2572, 2350, 2150, 1968, 1797, 1632, 1469, 1310, 1157, 1013,  880,  758, &
    &        648,  552,  470,  402,  344,  293,  247,  206, & !  1.8
    & 2796, 2541, 2308, 2098, 1910, 1736, 1569, 1405, 1243, 1089,  944,  812,  694, &
    &        591,  503,  430,  368,  314,  266,  222,  183, & !  2.0
    & 2781, 2519, 2275, 2055, 1857, 1677, 1507, 1341, 1179, 1024,  880,  750,  637, &
    &        542,  462,  397,  340,  288,  241,  200,  165, & !  2.2
    & 2772, 2504, 2252, 2022, 1813, 1624, 1448, 1280, 1118,  963,  821,  695,  588, &
    &        500,  428,  368,  314,  264,  220,  181,  150, & !  2.4
    & 2766, 2494, 2236, 1997, 1778, 1577, 1393, 1221, 1058,  906,  767,  647,  546, &
    &        465,  399,  342,  290,  243,  201,  166,  138, & !  2.6
    & 2762, 2486, 2224, 1977, 1749, 1538, 1343, 1164, 1001,  852,  719,  605,  511, &
    &        436,  373,  318,  269,  225,  186,  155,  128, & !  2.8
    & 2759, 2480, 2213, 1961, 1725, 1505, 1299, 1113,  947,  801,  675,  570,  485, &
    &        414,  352,  298,  250,  209,  175,  147,  121  & !  3.0
    & /

  data a_O3TabLog10AbsAmt &
    & / &
    & -4.0, -3.8, -3.6, -3.4, -3.2, -3.0, -2.8, -2.6, -2.4, -2.2, -2.0, -1.8, -1.6, -1.4, -1.2, -1.0, -0.8, -0.6, -0.4, -0.2,  0.0 &
    &/

  data aa_O3TabAlpha &
    & / &
    !     -4.0 -3.8 -3.6 -3.4 -3.2 -3.0 -2.8 -2.6 -2.4 -2.2 -2.0 -1.8 -1.6 -1.4 -1.2 -1.0 -0.8 -0.6 -0.4 -0.2 0.0
    &    1,  2,  4,  6,  9, 13, 17, 22, 28, 33, 37, 42, 45, 49, 51, 54, 55, 55, 55, 53, 52, & ! -2.0
    &    1,  2,  4,  6,  9, 13, 17, 22, 28, 33, 37, 42, 45, 49, 51, 53, 55, 55, 54, 53, 51, & ! -1.8
    &    1,  2,  4,  6,  9, 13, 17, 22, 27, 33, 37, 41, 45, 48, 51, 53, 54, 54, 54, 52, 51, & ! -1.6
    &    1,  2,  4,  6,  9, 13, 17, 22, 27, 32, 37, 41, 45, 48, 51, 53, 54, 54, 53, 52, 50, & ! -1.4
    &    1,  2,  4,  6,  9, 13, 17, 22, 27, 32, 37, 41, 45, 48, 50, 52, 53, 53, 52, 50, 48, & ! -1.2
    &    1,  2,  4,  6,  9, 13, 17, 22, 27, 32, 37, 41, 44, 47, 50, 51, 52, 52, 51, 49, 46, & ! -1.0
    &    1,  2,  4,  6,  9, 13, 17, 22, 27, 32, 36, 40, 43, 46, 48, 50, 50, 50, 48, 46, 44, & ! -0.8
    &    1,  2,  4,  6,  9, 12, 16, 21, 26, 31, 35, 39, 42, 45, 47, 48, 48, 47, 46, 44, 41, & ! -0.6
    &    1,  2,  4,  6,  9, 12, 16, 21, 25, 30, 34, 38, 41, 43, 45, 45, 45, 44, 42, 40, 38, & ! -0.4
    &    1,  2,  4,  6,  8, 11, 15, 20, 24, 29, 32, 36, 38, 40, 41, 42, 42, 40, 39, 37, 34, & ! -0.2
    &    1,  2,  3,  5,  7, 11, 14, 18, 23, 27, 30, 33, 35, 37, 38, 38, 38, 36, 35, 33, 31, & !  0.0
    &    0,  1,  3,  4,  7,  9, 13, 17, 20, 24, 27, 30, 32, 33, 34, 34, 33, 33, 31, 30, 28, & !  0.2
    &    0,  1,  2,  4,  6,  8, 11, 14, 18, 21, 24, 26, 27, 28, 29, 30, 29, 29, 28, 27, 25, & !  0.4
    &    0,  1,  1,  3,  4,  6,  9, 11, 14, 17, 20, 22, 23, 24, 25, 26, 26, 26, 25, 24, 23, & !  0.6
    &    0,  0,  1,  2,  3,  4,  6,  9, 11, 14, 16, 18, 19, 21, 22, 22, 23, 23, 23, 22, 22, & !  0.8
    &    0,  0,  0,  1,  2,  3,  4,  6,  8, 10, 12, 14, 16, 17, 19, 20, 21, 21, 21, 21, 20, & !  1.0
    &    0,  0,  0,  0,  1,  2,  3,  4,  6,  7,  9, 11, 13, 15, 16, 18, 19, 20, 20, 20, 19, & !  1.2
    &    0,  0,  0,  0,  0,  1,  1,  2,  4,  5,  7,  9, 11, 12, 14, 16, 17, 18, 19, 19, 19, & !  1.4
    &    0,  0,  0,  0,  0,  0,  1,  1,  2,  4,  5,  7,  9, 11, 12, 14, 16, 17, 18, 18, 18, & !  1.6
    &    0,  0,  0,  0,  0,  0,  0,  1,  1,  2,  4,  5,  7,  9, 11, 13, 14, 16, 17, 17, 17, & !  1.8
    &    0, -1,  0,  0,  0,  0,  0,  0,  1,  2,  3,  4,  6,  8, 10, 12, 13, 15, 16, 17, 17, & !  2.0
    &   -1, -1,  0,  0,  0,  0,  0,  0,  0,  1,  2,  3,  5,  7,  9, 11, 13, 14, 15, 16, 16, & !  2.2
    &   -1, -1, -1,  0,  0,  0,  0,  0,  0,  1,  1,  3,  4,  6,  8, 10, 12, 14, 15, 16, 16, & !  2.4
    &   -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  1,  2,  4,  5,  7,  9, 11, 13, 15, 16, 16, & !  2.6
    &   -1, -1,  0,  0,  0,  0,  0,  0,  0,  0,  1,  2,  3,  5,  7,  9, 11, 13, 15, 16, 16, & !  2.8
    &    0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  2,  3,  5,  7,  9, 11, 13, 15, 16, 16  & !  3.0
    & /

  data aa_O3TabBeta &
    & / &
    ! -4.0 -3.8 -3.6 -3.4 -3.2 -3.0 -2.8 -2.6 -2.4 -2.2 -2.0 -1.8 -1.6 -1.4 -1.2 -1.0 -0.8 -0.6 -0.4 -0.2 0.0
    &   -3, -3, -4, -4, -5, -5, -5, -5, -4, -3, -1,  0,  1,  2,  3,  3,  2,  1,  0, -1, -3, & ! -2.0
    &   -3, -3, -3, -4, -5, -5, -5, -5, -4, -3, -1,  0,  1,  2,  3,  3,  2,  1,  0, -1, -3, & ! -1.8
    &   -3, -3, -4, -4, -5, -5, -5, -5, -4, -3, -1,  0,  1,  2,  3,  3,  2,  1,  0, -1, -3, & ! -1.6
    &   -3, -3, -4, -4, -5, -5, -5, -5, -4, -3, -1,  0,  1,  2,  3,  3,  2,  1,  0, -1, -3, & ! -1.4
    &   -3, -3, -4, -4, -5, -5, -5, -5, -4, -3, -1,  0,  1,  2,  3,  3,  2,  1,  0, -1, -3, & ! -1.2
    &   -2, -3, -4, -4, -5, -5, -5, -5, -4, -3, -1,  0,  1,  2,  3,  3,  3,  1,  0, -1, -2, & ! -1.0
    &   -2, -3, -4, -4, -5, -5, -5, -5, -4, -3, -1,  0,  1,  2,  3,  3,  3,  2,  0, -1, -2, & ! -0.8
    &   -3, -3, -4, -4, -4, -5, -5, -5, -4, -3, -1,  0,  1,  2,  3,  3,  3,  2,  0, -1, -2, & ! -0.6
    &   -2, -3, -3, -4, -4, -5, -5, -5, -4, -2, -1,  0,  1,  2,  3,  3,  3,  2,  0, -1, -2, & ! -0.4
    &   -3, -3, -4, -4, -4, -4, -5, -4, -3, -2, -1,  0,  1,  2,  3,  3,  3,  1,  0, -1, -2, & ! -0.2
    &   -2, -3, -3, -3, -4, -4, -4, -4, -3, -2,  0,  0,  1,  2,  3,  3,  2,  1,  0, -1, -2, & !  0.0
    &   -3, -3, -3, -3, -3, -4, -4, -3, -3, -2,  0,  0,  1,  2,  2,  2,  2,  1,  0, -1, -3, & !  0.2
    &   -2, -2, -2, -3, -3, -3, -3, -3, -2, -1,  0,  0,  1,  2,  2,  2,  1,  0,  0, -1, -3, & !  0.4
    &   -1, -2, -2, -2, -2, -3, -3, -2, -2, -1,  0,  0,  1,  1,  1,  1,  1,  0,  0, -2, -3, & !  0.6
    &   -1, -2, -2, -2, -2, -2, -2, -2, -2, -1,  0,  0,  0,  0,  1,  0,  0,  0, -1, -2, -3, & !  0.8
    &   -1, -1, -2, -2, -2, -2, -2, -2, -1, -1, -1,  0,  0,  0,  0,  0,  0,  0, -1, -2, -3, & !  1.0
    &   -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1,  0,  0,  0,  0,  0,  0,  0, -1, -2, -3, & !  1.2
    &   -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1,  0,  0,  0,  0,  0, -1, -2, -2, & !  1.4
    &   -1, -2, -2, -2, -1, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1,  0,  0, -1, -1, -1, -2, & !  1.6
    &   -1, -1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -1, -1, -1, -2, & !  1.8
    &   -2, -2, -1, -2, -1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -1, -2, -2, & !  2.0
    &   -1, -2, -2, -1, -2, -1, -1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -1, -1, -1, -2, -2, & !  2.2
    &   -1, -2, -1, -1, -2, -1, -1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, & !  2.4
    &   -1, -2, -2, -2, -2, -1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -3, & !  2.6
    &   -1, -2, -2, -1, -2, -1, -1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -3, & !  2.8
    &   -2, -1, -2, -1, -2, -2, -1, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -3  & !  3.0
    & /

  data aa_O3TabAbs &
    & / &
    ! -4.0, -3.8, -3.6, -3.4, -3.2, -3.0, -2.8, -2.6, -2.4, -2.2, -2.0, -1.8, -1.6, -1.4, -1.2, -1.0, -0.8, -0.6, -0.4, -0.2,  0.0
    & 3186, 2996, 2811, 2632, 2460, 2297, 2145, 2007, 1881, 1768, 1665, 1569, 1478, &
    &       1389, 1302, 1216, 1132, 1051,  974,  901,  834, & ! -2.0
    & 3186, 2996, 2811, 2632, 2460, 2297, 2145, 2007, 1881, 1768, 1665, 1569, 1478, &
    &       1389, 1301, 1215, 1131, 1050,  972,  899,  832, & ! -1.8
    & 3186, 2996, 2811, 2632, 2460, 2297, 2145, 2006, 1881, 1768, 1665, 1568, 1477, &
    &       1388, 1300, 1214, 1130, 1048,  970,  897,  829, & ! -1.6
    & 3186, 2996, 2811, 2632, 2459, 2297, 2145, 2006, 1880, 1767, 1664, 1568, 1476, &
    &       1387, 1299, 1212, 1127, 1045,  967,  893,  824, & ! -1.4
    & 3186, 2996, 2811, 2631, 2459, 2296, 2145, 2005, 1880, 1766, 1663, 1566, 1474, &
    &       1385, 1296, 1209, 1124, 1041,  962,  887,  816, & ! -1.2
    & 3186, 2996, 2811, 2631, 2459, 2296, 2144, 2005, 1879, 1765, 1661, 1464, 1471, &
    &       1381, 1292, 1205, 1118, 1035,  954,  878,  806, & ! -1.0
    & 3186, 2996, 2811, 2631, 2458, 2295, 2143, 2003, 1877, 1763, 1658, 1561, 1467, &
    &       1376, 1287, 1198, 1110, 1025,  943,  864,  790, & ! -0.8
    & 3185, 2996, 2810, 2630, 2458, 2294, 2141, 2001, 1874, 1759, 1654, 1555, 1461, &
    &       1369, 1278, 1187, 1098, 1011,  927,  846,  770, & ! -0.6
    & 3185, 2996, 2810, 2629, 2456, 2292, 2139, 1998, 1870, 1754, 1647, 1547, 1451, &
    &       1357, 1264, 1172, 1080,  991,  904,  821,  743, & ! -0.4
    & 3185, 2995, 2809, 2628, 2454, 2289, 2135, 1993, 1863, 1746, 1637, 1535, 1437, &
    &       1341, 1245, 1150, 1056,  964,  875,  790,  709, & ! -0.2
    & 3185, 2994, 2807, 2626, 2451, 2285, 2129, 1985, 1854, 1733, 1622, 1518, 1417, &
    &       1317, 1219, 1121, 1024,  930,  838,  751,  669, & !  0.0
    & 3183, 2993, 2805, 2623, 2447, 2279, 2121, 1974, 1840, 1716, 1602, 1493, 1389, &
    &       1286, 1184, 1083,  984,  888,  795,  706,  623, & !  0.2
    & 3183, 2991, 2802, 2619, 2441, 2270, 2110, 1959, 1821, 1693, 1574, 1461, 1352, &
    &       1246, 1141, 1038,  937,  839,  745,  656,  572, & !  0.4
    & 3181, 2988, 2799, 2613, 2433, 2260, 2095, 1940, 1796, 1662, 1538, 1420, 1307, &
    &       1198, 1090,  985,  883,  784,  690,  602,  520, & !  0.6
    & 3179, 2985, 2794, 2606, 2424, 2247, 2077, 1917, 1767, 1627, 1496, 1373, 1256, &
    &       1143, 1033,  927,  824,  726,  633,  546,  467, & !  0.8
    & 3177, 2982, 2789, 2599, 2413, 2232, 2058, 1892, 1734, 1587, 1450, 1322, 1200, &
    &       1084,  973,  867,  764,  667,  576,  492,  416, & !  1.0
    & 3167, 2971, 2777, 2585, 2396, 2211, 2033, 1861, 1698, 1544, 1400, 1267, 1141, &
    &       1023,  911,  804,  702,  607,  518,  437,  364, & !  1.2
    & 3169, 2972, 2776, 2582, 2390, 2203, 2019, 1841, 1671, 1510, 1358, 1217, 1086, &
    &        964,  850,  743,  643,  551,  465,  389,  321, & !  1.4
    & 3170, 2972, 2775, 2580, 2386, 2195, 2008, 1826, 1650, 1481, 1322, 1174, 1036, &
    &        910,  794,  687,  589,  499,  418,  346,  284, & !  1.6
    & 3171, 2972, 2774, 2578, 2382, 2189, 1999, 1813, 1633, 1459, 1293, 1138,  994, &
    &        862,  743,  636,  540,  454,  377,  311,  253, & !  1.8
    & 3170, 2971, 2773, 2576, 2379, 2185, 1993, 1804, 1620, 1441, 1271, 1110,  960, &
    &        823,  701,  592,  497,  414,  343,  281,  229, & !  2.0
    & 3170, 2971, 2772, 2574, 2377, 2182, 1988, 1798, 1611, 1430, 1255, 1089,  934, &
    &        793,  667,  556,  462,  382,  315,  258,  211, & !  2.2
    & 3170, 2971, 2772, 2573, 2376, 2180, 1985, 1793, 1605, 1421, 1244, 1075,  916, &
    &        771,  641,  529,  434,  356,  293,  241,  197, & !  2.4
    & 3170, 2971, 2771, 2573, 2375, 2178, 1983, 1791, 1601, 1416, 1237, 1065,  904, &
    &        756,  623,  509,  414,  338,  278,  229,  188, & !  2.6
    & 3171, 2971, 2772, 2573, 2375, 2178, 1983, 1790, 1600, 1414, 1233, 1060,  897, &
    &        747,  612,  496,  401,  326,  268,  222,  183, & !  2.8
    & 3172, 2973, 2773, 2575, 2376, 2179, 1984, 1790, 1600, 1413, 1232, 1058,  893, &
    &        742,  606,  489,  394,  319,  262,  217,  179  & !  3.0
    & /


  ! ѿ
  ! Public variables
  !
  logical, save, public:: radiation_ck1991_inited = .false.
                              ! ե饰.
                              ! Initialization flag

  ! 
  ! Public procedure
  !
  public :: RadiationCK1991CalcTrans
  public :: RadiationCK1991Interpolate


  character(*), parameter:: module_name = 'radiation_CK1991'
                              ! ⥸塼̾.
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20110228-4 $' // &
    & '$Id: radiation_CK1991.f90,v 1.3 2011-02-21 12:15:37 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version


contains


  !--------------------------------------------------------------------------------------

  subroutine RadiationCK1991CalcTrans(          &
    & xyr_Press, xyz_Press, xyz_Temp, xyz_QMix, & ! (in)
    & Spec,                                     & ! (in)
    & xyrr_Trans                                & ! (out)
    & )

    ! USE statements
    !

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    real(DP)        , intent(in ) :: xyr_Press       (0:imax-1, 1:jmax, 0:kmax)
    real(DP)        , intent(in ) :: xyz_Press       (0:imax-1, 1:jmax, 1:kmax)
    real(DP)        , intent(in ) :: xyz_Temp        (0:imax-1, 1:jmax, 1:kmax)
    real(DP)        , intent(in ) :: xyz_QMix        (0:imax-1, 1:jmax, 1:kmax)
    character(len=*), intent(in ) :: Spec
    real(DP)        , intent(out) :: xyrr_Trans      (0:imax-1, 1:jmax, 0:kmax, 0:kmax)


    if ( .not. radiation_ck1991_inited ) then
      call RadiationCK1991Init
    end if


    if ( Spec == 'CO2' ) then
      call RadiationCK1991CalcTransCore(               &
        & NTabPress, NCO2TabAbsAmt,                    & ! (in)
        & a_TabLog10Press, a_CO2TabLog10AbsAmt,        & ! (in)
        & aa_CO2TabAlpha, aa_CO2TabBeta, aa_CO2TabAbs, & ! (in)
        & xyr_Press, xyz_Press, xyz_Temp, xyz_QMix,    & ! (in)
        & xyrr_Trans                                   & ! (out)
        & )
    else if ( Spec == 'O3' ) then
      call RadiationCK1991CalcTransCore(            &
        & NTabPress, NO3TabAbsAmt,                  & ! (in)
        & a_TabLog10Press, a_O3TabLog10AbsAmt,      & ! (in)
        & aa_O3TabAlpha, aa_O3TabBeta, aa_O3TabAbs, & ! (in)
        & xyr_Press, xyz_Press, xyz_Temp, xyz_QMix, & ! (in)
        & xyrr_Trans                                & ! (out)
        & )
    else
      call MessageNotify( 'E', module_name, &
        & 'Specified composition, %c, is inappropriate', c1 = trim(Spec) )
    end if


  end subroutine RadiationCK1991CalcTrans

  !--------------------------------------------------------------------------------------

  subroutine RadiationCK1991CalcTransCore(      &
    & NTabPress, NTabAbsAmt,                    & ! (in)
    & a_TabLog10Press, a_TabLog10AbsAmt,        & ! (in)
    & aa_TabAlpha, aa_TabBeta, aa_TabAbs,       & ! (in)
    & xyr_Press, xyz_Press, xyz_Temp, xyz_QMix, & ! (in)
    & xyrr_Trans                                & ! (out)
    & )

    ! USE statements
    !

    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! 
    ! Physical constants settings
    !
    use constants, only: Grav    ! $ g $ [m s-2].
                                 ! 
                                 ! Gravitational acceleration

    integer , intent(in ) :: NTabPress
    integer , intent(in ) :: NTabAbsAmt
    real(DP), intent(in ) :: a_TabLog10Press (NTabPress )
    real(DP), intent(in ) :: a_TabLog10AbsAmt(NTabAbsAmt)
    real(DP), intent(in ) :: aa_TabAlpha     (NTabAbsAmt, NTabPress)
    real(DP), intent(in ) :: aa_TabBeta      (NTabAbsAmt, NTabPress)
    real(DP), intent(in ) :: aa_TabAbs       (NTabAbsAmt, NTabPress)
    real(DP), intent(in ) :: xyr_Press       (0:imax-1, 1:jmax, 0:kmax)
    real(DP), intent(in ) :: xyz_Press       (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in ) :: xyz_Temp        (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(in ) :: xyz_QMix        (0:imax-1, 1:jmax, 1:kmax)
    real(DP), intent(out) :: xyrr_Trans      (0:imax-1, 1:jmax, 0:kmax, 0:kmax)

    !
    ! Work variables
    !
    real(DP), parameter :: RefTemp = 250.0_DP

    real(DP) :: xyz_DelAbsAmt   (0:imax-1, 1:jmax, 1:kmax)
    real(DP) :: xy_EffTemp      (0:imax-1, 1:jmax)
    real(DP) :: xy_EffPress     (0:imax-1, 1:jmax)
    real(DP) :: xy_AbsAmt       (0:imax-1, 1:jmax)
    real(DP) :: xy_Log10EffPress(0:imax-1, 1:jmax)
    real(DP) :: xy_Log10AbsAmt  (0:imax-1, 1:jmax)
    integer  :: xy_IndexPress   (0:imax-1, 1:jmax)
    integer  :: xy_IndexAbsAmt  (0:imax-1, 1:jmax)

    real(DP) :: xy_Alpha        (0:imax-1, 1:jmax)
    real(DP) :: xy_Beta         (0:imax-1, 1:jmax)
    real(DP) :: xy_AbsAtRefTemp (0:imax-1, 1:jmax)

    real(DP) :: xy_Abs          (0:imax-1, 1:jmax)

    integer :: i
    integer :: j
    integer :: k
    integer :: kk
    integer :: l



    do k = 1, kmax
      xyz_DelAbsAmt(:,:,k) =                                 &
        &   ( xyr_Press(:,:,k-1) - xyr_Press(:,:,k) ) / Grav &
        & * xyz_QMix(:,:,k)
    end do


    do k = 0, kmax
      do kk = k+1, kmax

        xy_EffTemp  = 0.0_DP
        xy_EffPress = 0.0_DP
        xy_AbsAmt   = 0.0_DP
        do l = k+1, kk
          xy_EffTemp  = xy_EffTemp  + xyz_Temp (:,:,l) * xyz_DelAbsAmt(:,:,l)
          xy_EffPress = xy_EffPress + xyz_Press(:,:,l) * xyz_DelAbsAmt(:,:,l)
          xy_AbsAmt   = xy_AbsAmt   +                    xyz_DelAbsAmt(:,:,l)
        end do
        xy_EffTemp  = xy_EffTemp  / ( xy_AbsAmt + 1.0d-100 )
        xy_EffPress = xy_EffPress / ( xy_AbsAmt + 1.0d-100 )


        xy_Log10EffPress = log10( xy_EffPress + 1.0d-100 )
        xy_Log10AbsAmt   = log10( xy_AbsAmt   + 1.0d-100 )


        do j = 1, jmax
          do i = 0, imax-1

            if ( xy_Log10EffPress(i,j) < a_TabLog10Press (1) ) then
!!$              call MessageNotify( 'E', module_name, &
!!$                & 'at k = %d and kk = %d, Log10EffPress(%d,%d) = %f < %f. too small', &
!!$                & i = (/k, kk, i, j/), &
!!$                & d = (/xy_Log10EffPress(i,j), a_TabLog10Press(1)/) )

              xy_IndexPress(i,j) = 2

            else

              Loop_Search_Press  : do l = 1+1, NTabPress
                if ( a_TabLog10Press (l) > xy_Log10EffPress(i,j) ) then
                  exit Loop_Search_Press
                end if
              end do Loop_Search_Press
              if ( l > NTabPress ) then
                l = NTabPress

!!$                call MessageNotify( 'E', module_name, &
!!$                  & 'at k = %d and kk = %d, Log10EffPress(%d,%d) = %f > %f. too large', &
!!$                  & i = (/k, kk, i, j/), &
!!$                  & d = (/xy_Log10EffPress(i,j), a_TabLog10Press(NTabPress)/) )

              end if

              xy_IndexPress(i,j) = l

            end if


            if ( xy_Log10AbsAmt(i,j) < a_TabLog10AbsAmt(1) ) then
!!$              call MessageNotify( 'E', module_name, &
!!$                & 'at k = %d and kk = %d, Log10AbsAmt(%d,%d) = %f < %f. too small', &
!!$                & i = (/k, kk, i, j/), &
!!$                & d = (/xy_Log10AbsAmt(i,j), a_TabLog10AbsAmt(1)/) )

              xy_IndexAbsAmt(i,j) = 2
            else

              Loop_Search_AbsAmt : do l = 1+1, NTabAbsAmt
                if ( a_TabLog10AbsAmt(l) > xy_Log10AbsAmt(i,j) ) then
                  exit Loop_Search_AbsAmt
                end if
              end do Loop_Search_AbsAmt
              if ( l > NTabAbsAmt ) then
                call MessageNotify( 'E', module_name, &
                  & 'at k = %d and kk = %d, Log10AbsAmt(%d,%d) = %f > %f. too large', &
                  & i = (/k, kk, i, j/), &
                  & d = (/xy_Log10AbsAmt(i,j), a_TabLog10AbsAmt(NTabAbsAmt)/) )
              end if

              xy_IndexAbsAmt(i,j) = l

            end if

          end do
        end do


        call RadiationCK1991Interpolate(                                     &
          & NTabPress, NTabAbsAmt,                                           & ! (in)
          & a_TabLog10Press, a_TabLog10AbsAmt, aa_TabAlpha,                  & ! (in)
          & xy_IndexPress, xy_IndexAbsAmt, xy_Log10EffPress, xy_Log10AbsAmt, & ! (in)
          & xy_Alpha                                                         & ! (out)
          & )
        call RadiationCK1991Interpolate(                                     &
          & NTabPress, NTabAbsAmt,                                           & ! (in)
          & a_TabLog10Press, a_TabLog10AbsAmt, aa_TabBeta,                   & ! (in)
          & xy_IndexPress, xy_IndexAbsAmt, xy_Log10EffPress, xy_Log10AbsAmt, & ! (in)
          & xy_Beta                                                          & ! (out)
          & )
        call RadiationCK1991Interpolate(                                     &
          & NTabPress, NTabAbsAmt,                                           & ! (in)
          & a_TabLog10Press, a_TabLog10AbsAmt, aa_TabAbs,                    & ! (in)
          & xy_IndexPress, xy_IndexAbsAmt, xy_Log10EffPress, xy_Log10AbsAmt, & ! (in)
          & xy_AbsAtRefTemp                                                  & ! (out)
          & )

        xy_AbsAtRefTemp = 10.0d0**xy_AbsAtRefTemp
        xy_Abs = xy_AbsAtRefTemp                                  &
          & * ( 1.0_DP + xy_Alpha * ( xy_EffTemp - RefTemp )      &
          &            + xy_Beta  * ( xy_EffTemp - RefTemp )**2 )

        xyrr_Trans(:,:,k,kk) = 1.0_DP - xy_Abs
      end do
    end do
    !
    ! correction
    !
    do k = 0, kmax
      do kk = k+2, kmax
        do j = 1, jmax
          do i = 0, imax-1
            if ( xyrr_Trans(i,j,k,kk) > xyrr_Trans(i,j,k,kk-1) ) then
              xyrr_Trans(i,j,k,kk) = xyrr_Trans(i,j,k,kk-1)
            end if
          end do
        end do
      end do
    end do

    do k = 0, kmax
      do kk = 0, k-1
        xyrr_Trans(:,:,k,kk) = xyrr_Trans(:,:,kk,k)
      end do
      kk = k
      xyrr_Trans(:,:,k,kk) = 1.0_DP
    end do


  end subroutine RadiationCK1991CalcTransCore

  !--------------------------------------------------------------------------------------

  subroutine RadiationCK1991Interpolate(                            &
    & NTabPress, NTabAbsAmt,                                        & ! (in)
    & a_TabLog10Press, a_TabLog10AbsAmt, aa_Tab,                    & ! (in)
    & xy_IndexPress, xy_IndexAbsAmt, xy_Log10Press, xy_Log10AbsAmt, & ! (in)
    & xy_Array                                                      & ! (out)
    & )

    ! USE statements
    !


    integer , intent(in ) :: NTabPress
    integer , intent(in ) :: NTabAbsAmt
    real(DP), intent(in ) :: a_TabLog10Press (NTabPress )
    real(DP), intent(in ) :: a_TabLog10AbsAmt(NTabAbsAmt)
    real(DP), intent(in ) :: aa_Tab          (NTabAbsAmt, NTabPress)
    integer , intent(in ) :: xy_IndexPress   (0:imax-1, 1:jmax)
    integer , intent(in ) :: xy_IndexAbsAmt  (0:imax-1, 1:jmax)
    real(DP), intent(in ) :: xy_Log10Press   (0:imax-1, 1:jmax)
    real(DP), intent(in ) :: xy_Log10AbsAmt  (0:imax-1, 1:jmax)
    real(DP), intent(out) :: xy_Array        (0:imax-1, 1:jmax)

    !
    ! Work variables
    !
    real(DP) :: val1
    real(DP) :: val2
    integer  :: ip1
    integer  :: ip2
    integer  :: iw1
    integer  :: iw2
    integer  :: i
    integer  :: j


    do j = 1, jmax
      do i = 0, imax-1

        ip1 = xy_IndexPress (i,j) - 1
        ip2 = xy_IndexPress (i,j)
        iw1 = xy_IndexAbsAmt(i,j) - 1
        iw2 = xy_IndexAbsAmt(i,j)

        val1 =                                                          &
          &   ( aa_Tab          (iw2,ip1) - aa_Tab          (iw1,ip1) ) &
          & / ( a_TabLog10AbsAmt(iw2)     - a_TabLog10AbsAmt(iw1)     ) &
          & * ( xy_Log10AbsAmt  (i,j)     - a_TabLog10AbsAmt(iw1)     ) &
          & + aa_Tab            (iw1,ip1)
        val2 =                                                          &
          &   ( aa_Tab          (iw2,ip2) - aa_Tab          (iw1,ip2) ) &
          & / ( a_TabLog10AbsAmt(iw2)     - a_TabLog10AbsAmt(iw1)     ) &
          & * ( xy_Log10AbsAmt  (i,j)     - a_TabLog10AbsAmt(iw1)     ) &
          & + aa_Tab            (iw1,ip2)

        xy_Array(i,j) =                                       &
          &   ( val2                 - val1                 ) &
          & / ( a_TabLog10Press(ip2) - a_TabLog10Press(ip1) ) &
          & * ( xy_Log10Press  (i,j) - a_TabLog10Press(ip1) ) &
          & + val1

      end do
    end do

  end subroutine RadiationCK1991Interpolate

  !--------------------------------------------------------------------------------------

  subroutine RadiationCK1991Init


    ! å
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid


!!$    integer:: unit_nml        ! NAMELIST ե륪ץֹ.
!!$                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT.
!!$                              ! IOSTAT of NAMELIST read


!!$    namelist /radiation_RL78_nml/ &
!!$      & VMRCO2,                   &
!!$      & DelTimeCalcTransValue,    &
!!$      & DelTimeCalcTransUnit,     &
!!$      & flag_save_time


    if ( radiation_CK1991_inited ) return

!!$
!!$    VMRCO2                = 382.0d-6
!!$
!!$    DelTimeCalcTransValue = 3.0
!!$    DelTimeCalcTransUnit  = 'hrs'
!!$    flag_save_time        = .false.
!!$
!!$
!!$    ! NAMELIST is input
!!$    !
!!$    if ( trim(namelist_filename) /= '' ) then
!!$      call FileOpen( unit_nml, &          ! (out)
!!$        & namelist_filename, mode = 'r' ) ! (in)
!!$
!!$      rewind( unit_nml )
!!$      read( unit_nml,                     & ! (in)
!!$        & nml = radiation_RL78_nml,       & ! (out)
!!$        & iostat = iostat_nml )             ! (out)
!!$      close( unit_nml )
!!$
!!$      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$    end if


    ! Convert unit of pressure from mbar to Pa
    !
    a_TabLog10Press = 10.0d0**a_TabLog10Press
    a_TabLog10Press = a_TabLog10Press * 1.0d2
    a_TabLog10Press = log10( a_TabLog10Press )

    ! Convert unit of absorber amount from (atm cm)_{STP} to kg m-2
    !   To convert from (atm cm)_{STP} to kg m-2, the value is divided by
    !   1.0d2 / 101325.0d0 * 8.31432d0 / ( 44.0d-3 ) * 273.15d0, and
    !   1.0d2 / 101325.0d0 * 8.31432d0 / ( 48.0d-3 ) * 273.15d0, 
    !   for CO2 and O3, respectively.
    !
    a_CO2TabLog10AbsAmt = 10.0d0**a_CO2TabLog10AbsAmt
    a_CO2TabLog10AbsAmt = a_CO2TabLog10AbsAmt &
      & / ( 1.0d2 / 101325.0d0 * 8.31432d0 / ( 44.0d-3 ) * 273.15d0 )
    a_CO2TabLog10AbsAmt = log10( a_CO2TabLog10AbsAmt )
    !
    a_O3TabLog10AbsAmt  = 10.0d0**a_O3TabLog10AbsAmt
    a_O3TabLog10AbsAmt  = a_O3TabLog10AbsAmt &
      & / ( 1.0d2 / 101325.0d0 * 8.31432d0 / ( 48.0d-3 ) * 273.15d0 )
    a_O3TabLog10AbsAmt  = log10( a_O3TabLog10AbsAmt )
    !
    ! Convert values absorptance from -1e3 * log10(A) to log10(A)
    !
    aa_CO2TabAbs = 10.0d0**( aa_CO2TabAbs / ( -1.0d3 ) )
    aa_CO2TabAbs = log10( aa_CO2TabAbs )
    !
    aa_O3TabAbs  = 10.0d0**( aa_O3TabAbs / ( -1.0d3 ) )
    aa_O3TabAbs  = log10( aa_O3TabAbs )
    !
    ! Convert values of alpha absorptance from 1e4 * alpha to alpha
    !
    aa_CO2TabAlpha = aa_CO2TabAlpha / ( 1.0d4 )
    !
    aa_O3TabAlpha  = aa_O3TabAlpha  / ( 1.0d4 )
    !
    ! Convert values of beta absorptance from 1e6 * beta to beta
    !
    aa_CO2TabBeta  = aa_CO2TabBeta  / ( 1.0d6 )
    !
    aa_O3TabBeta   = aa_O3TabBeta   / ( 1.0d6 )



    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
!!$    call MessageNotify( 'M', module_name, '  DelTimeCalcTrans  = %f [%c]', &
!!$      & d = (/ DelTimeCalcTransValue /), c1 = trim( DelTimeCalcTransUnit ) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    radiation_ck1991_inited = .true.

  end subroutine RadiationCK1991Init


  !--------------------------------------------------------------------------------------

end module radiation_CK1991
