!= CO2 Ѳ (׻)
!
!= Phase change of CO2 (for the use in Mars calculation)
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: co2_phase_change.f90,v 1.1 2010-09-18 01:46:54 yot Exp $ 
! Tag Name::  $Name: dcpam5-20110228-4 $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module co2_phase_change
  !
  != CO2 Ѳ
  !
  != Phase change of CO2
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  !== Procedures List
  ! 
!!$  ! DryConvAdjust :: ήĴ
!!$  ! ------------  :: ------------
!!$  ! DryConvAdjust :: Dry convective adjustment
  !
  !== NAMELIST
  !
  ! NAMELIST#dry_conv_adjust_nml
  !

  ! ⥸塼 ; USE statements
  !

  ! ʻ
  ! Grid points settings
  !
  use gridset, only: imax, & ! ٳʻ. 
                             ! Number of grid points in longitude
    &                jmax, & ! ٳʻ. 
                             ! Number of grid points in latitude
    &                kmax    ! ľؿ. 
                             ! Number of vertical level

  ! ̷ѥ᥿
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! ټ¿. Double precision. 
    &                 STRING     ! ʸ.       Strings. 

  ! NAMELIST եϤ˴ؤ桼ƥƥ
  ! Utilities for NAMELIST file input
  !
  use namelist_util, only: MaxNmlArySize
                              ! NAMELIST ɤ߹κ祵. 
                              ! Maximum size of arrays loaded from NAMELIST

  ! å
  ! Message output
  !
  use dc_message, only: MessageNotify

  ! ʸ ; Declaration statements
  !
  implicit none
  private

  logical, save:: FlagUse
                              ! ѥե饰
                              ! flag for use of this scheme

  ! ³
  ! Public procedure
  !
  public:: CO2PhaseChangeLimitTemp

  ! ѿ
  ! Public variables
  !
  logical, save, public:: co2_phase_change_inited = .false.
                              ! ե饰. 
                              ! Initialization flag

  ! ѿ
  ! Private variables
  !

  character(*), parameter:: module_name = 'co2_phase_change'
                              ! ⥸塼̾. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name: dcpam5-20110228-4 $' // &
    & '$Id: co2_phase_change.f90,v 1.1 2010-09-18 01:46:54 yot Exp $'
                              ! ⥸塼ΥС
                              ! Module version


contains

  subroutine CO2PhaseChangeLimitTemp( &
    & xyr_Press, xyz_Press,  &  ! (in)
    & xy_SurfTemp, xyz_Temp  &  ! (inout)
    & )
    !
    ! CO2 Ѳ
    !
    ! CO2 phase change
    !

    ! ⥸塼 ; USE statements
    !

    ! 
    ! Time control
    !
    use timeset, only: &
      & DelTime, &            ! $ \Delta t $
      & TimeN, &              ! ƥå $ t $ λ. Time of step $ t $. 
      & TimesetClockStart, TimesetClockStop

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoPut


    ! ʸ ; Declaration statements
    !
    implicit none

    real(DP), intent(in   ):: xyr_Press (0:imax-1, 1:jmax, 0:kmax)
                              ! $ \hat{p} $ .  (Ⱦ٥). 
                              ! Air pressure (half level)
    real(DP), intent(in   ):: xyz_Press (0:imax-1, 1:jmax, 1:kmax)
                              ! $ p $ .  (٥). 
                              ! Air pressure (full level)
    real(DP), intent(inout):: xy_SurfTemp(0:imax-1, 1:jmax)
                              ! $ T_s $ .   ɽ̲. Surface temperature
    real(DP), intent(inout):: xyz_Temp   (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ .     . Temperature

    ! ѿ
    ! Work variables
    !
    real(DP):: xy_SurfTempB  (0:imax-1, 1:jmax)
                              ! Ĵɽ̲. 
                              ! Surface temperature before adjustment
    real(DP):: xyz_TempB     (0:imax-1, 1:jmax, 1:kmax)
                              ! Ĵβ. 
                              ! Temperature before adjustment
    real(DP):: xy_DSurfTempDt(0:imax-1, 1:jmax)
                              ! ɽ̲ѲΨ. 
                              ! Surface temperature tendency
    real(DP):: xyz_DTempDt   (0:imax-1, 1:jmax, 1:kmax)
                              ! ѲΨ. 
                              ! Temperature tendency

    real(DP):: xy_SurfTempCond(0:imax-1, 1:jmax)
    real(DP):: xyz_TempCond   (0:imax-1, 1:jmax, 1:kmax)

    integer:: i               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in longitude
    integer:: j               ! ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in latitude
    integer:: k               ! ľ˲ DO 롼Ѻѿ
                              ! Work variables for DO loop in vertical direction

    logical :: FlagCheckPs


    ! ¹ʸ ; Executable statement
    !

    ! ׻ַ¬
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )

    ! 
    ! Initialization
    !
    if ( .not. co2_phase_change_inited ) call CO2PhaseChangeInit

    if ( .not. FlagUse ) return


    FlagCheckPs = .false.
    do j = 1, jmax
      do i = 0, imax-1
        if ( xyr_Press(i,j,0) > 1.0d4 ) then
          FlagCheckPs = .true.
        end if
      end do
    end do
    if ( FlagCheckPs ) then
      call MessageNotify( 'W', module_name, 'Surface pressure is greater than 10000 Pa.' )
    end if


    ! Ĵ "Temp" ¸
    ! Store "Temp" before adjustment
    !
    xy_SurfTempB = xy_SurfTemp
    xyz_TempB    = xyz_Temp


    do j = 1, jmax
      do i = 0, imax-1
        xy_SurfTempCond(i,j) = &
          & 149.2d0 + 6.48d0 * log( 0.135d0 * xyr_Press(i,j,0) * 1.0d-2 )
      end do
    end do
    do k = 1, kmax
      do j = 1, jmax
        do i = 0, imax-1
          xyz_TempCond(i,j,k) = &
            & 149.2d0 + 6.48d0 * log( 0.135d0 * xyz_Press(i,j,k) * 1.0d-2 )
        end do
      end do
    end do

    do j = 1, jmax
      do i = 0, imax-1
        if ( xy_SurfTemp(i,j) < xy_SurfTempCond(i,j) ) then
          xy_SurfTemp(i,j) = xy_SurfTempCond(i,j)
        end if
      end do
    end do
    do k = 1, kmax
      do j = 1, jmax
        do i = 0, imax-1
          if ( xyz_Temp(i,j,k) < xyz_TempCond(i,j,k) ) then
            xyz_Temp(i,j,k) = xyz_TempCond(i,j,k)
          end if
        end do
      end do
    end do


    ! ѲΨ
    ! Calculate temperature tendency
    !
    xy_DSurfTempDt = ( xy_SurfTemp - xy_SurfTempB ) / ( 2.0_DP * DelTime )
    xyz_DTempDt    = ( xyz_Temp    - xyz_TempB    ) / ( 2.0_DP * DelTime )


    ! ҥȥǡ
    ! History data output
    !
    call HistoryAutoPut( TimeN, 'DSurfTempDtCO2PhaseChange', xy_DSurfTempDt )
    call HistoryAutoPut( TimeN, 'DTempDtCO2PhaseChange'    , xyz_DTempDt    )


    ! ׻ַ¬
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine CO2PhaseChangeLimitTemp

  !-------------------------------------------------------------------

  subroutine CO2PhaseChangeInit
    !
    ! co2_phase_change ⥸塼νԤޤ. 
    ! NAMELIST#co2_phase_change_nml ɤ߹ߤϤμ³ǹԤޤ. 
    !
    ! "co2_phase_change" module is initialized. 
    ! "NAMELIST#co2_phase_change_nml" is loaded in this procedure. 
    !

    ! ⥸塼 ; USE statements
    !

    ! NAMELIST եϤ˴ؤ桼ƥƥ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ե
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! ̷ѥ᥿
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! ɸϤֹ. Unit number of standard output

    ! ʸ
    ! Character handling
    !
    use dc_string, only: StoA

    ! ҥȥǡ
    ! History data output
    !
    use gtool_historyauto, only: HistoryAutoAddVariable

    ! ʸ ; Declaration statements
    !
    implicit none

    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST ѿ
    ! NAMELIST group name
    !
    namelist /co2_phase_change_nml/ &
      & FlagUse

          ! ǥեͤˤĤƤϽ³ "co2_phase_change#CO2PhaseChangeInit" 
          ! Υɤ򻲾ȤΤ. 
          !
          ! Refer to source codes in the initialization procedure
          ! "co2_phase_change#CO2PhaseChangeInit" for the default values. 
          !

    ! ¹ʸ ; Executable statement
    !

    if ( co2_phase_change_inited ) return

    ! ǥեͤ
    ! Default values settings
    !
    FlagUse = .false.

    ! NAMELIST ɤ߹
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml,                &  ! (in)
        & nml = co2_phase_change_nml, &  ! (out)
        & iostat = iostat_nml )         ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
!!$      if ( iostat_nml == 0 ) write( STDOUT, nml = cumulus_adjust_nml )
    end if


    ! ҥȥǡϤΤΤؤѿϿ
    ! Register of variables for history data output
    !
    call HistoryAutoAddVariable( 'DSurfTempDtCO2PhaseChange', &
      & (/ 'lon ', 'lat ', 'time' /),                         &
      & 'heating by CO2 phase change', 'K s-1' )
    call HistoryAutoAddVariable( 'DTempDtCO2PhaseChange',     &
      & (/ 'lon ', 'lat ', 'sig ', 'time' /),                 &
      & 'heating by CO2 phase change', 'K s-1' )

    !  ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )
    call MessageNotify( 'M', module_name, '  FlagUse              = %b', l = (/ FlagUse /) )
    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    co2_phase_change_inited = .true.

  end subroutine CO2PhaseChangeInit

  !-------------------------------------------------------------------

end module co2_phase_change
