module PSPACK

  interface
    subroutine Z1DOPN [C,ALIAS:'_z1dopn_'] &
      &        (width, height, lcolor, lsep, lprint,  cmap, file, title, com)
      integer(4) :: width [reference] , height[reference]
      logical(4) :: lcolor[reference],  lsep[reference],  lprint[reference]
      character(len=*) :: cmap[reference], file[reference], &
                       & title[reference], com[reference]
    end subroutine

   !  lcolor : color ps
   !  lsep   : 1 ページづつ
   !  lprint : 直接プリント
   !  file   : ファイル名.ps
   !  title  : ps のコメント
   !  com    : print コマンド

    subroutine Z1DCLS [C,ALIAS:'_z1dcls_']()
    end subroutine

    !----------------- page --------------------

    subroutine Z1POPN [C,ALIAS:'_z1popn_']()
    end subroutine

    subroutine Z1PCLS [C,ALIAS:'_z1pcls_']()
    end subroutine

    !---------------- object -------------------

    subroutine Z1OOPN [C,ALIAS:'_z1oopn_'](objname, comment, Lobj, Lcom)
      character(len=*) :: objname[reference], comment[reference]
      integer(4)       :: Lobj[value], Lcom[value]
    end subroutine

    subroutine Z1OCLS [C,ALIAS:'_z1ocls_'](objname, Lobj)
      character(len=*) :: objname[reference]
      integer(4)       :: Lobj[value]
    end subroutine

    !----------------- line --------------------

    subroutine Z1SWDI [C,ALIAS:'_z1swdi_'](iwdidx)
      integer(4) :: iwdidx[reference]
    end subroutine

    subroutine Z1SCLI [C,ALIAS:'_z1scli_'](iclidx)
      integer(4) :: iclidx[reference]
    end subroutine

    subroutine Z1GOPN [C,ALIAS:'_z1gopn_']()
    end subroutine

    subroutine Z1GMOV [C,ALIAS:'_z1gmov_'](wx, wy)
       real ::  wx[reference], wy[reference]
    end subroutine

    subroutine Z1GPLT [C,ALIAS:'_z1gplt_'](wx, wy)
      real ::  wx[reference], wy[reference]
    end subroutine

    subroutine Z1GCLS [C,ALIAS:'_z1gcls_']()
    end subroutine

    !----------------- tone --------------------

    subroutine Z1GTON [C,ALIAS:'_z1gton_'](np, wpx, wpy, itpat)
      integer(4)            :: np[reference], itpat[reference]
      real(4), dimension(*) :: wpx[reference], wpy[reference]
    end subroutine

    subroutine Z1CLINI [C,ALIAS:'_z1clini_'](cmap)
      character(len=*) :: cmap[reference]
    end subroutine

    !----------------- image -------------------

    subroutine Z1IOPN [C,ALIAS:'_z1iopn_'](iwx, iwy, iwidth, iheight)
      integer(4) :: iwx[reference],    iwy[reference], &
                  & iwidth[reference], iheight[reference]
    end subroutine

    subroutine Z1IDAT [C,ALIAS:'_z1idat_'](image, nlen)
      integer(4)               :: nlen[reference]
      integer(4), dimension(*) :: image[reference]
    end subroutine

    subroutine Z1ICLS [C,ALIAS:'_z1icls_']()
    end subroutine

    !----------------- mouse -------------------

    subroutine Z1QPNT [C,ALIAS:'_z1qpnt_'](wx, wy, mb)
      real(4)    :: wx[reference], wy[reference]
      integer(4) :: mb[reference];
    end subroutine

    !------------- transformation --------------

    subroutine Z1FINT [C,ALIAS:'_z1fint_'](wx, wy, iwx, iwy)
      real(4)    ::  wx[reference],  wy[reference]
      integer(4) :: iwx[reference], iwy[reference]
    end subroutine

    subroutine Z1IINT [C,ALIAS:'_z1iint_'](iwx, iwy, wx, wy)
      real(4)    ::  wx[reference],  wy[reference]
      integer(4) :: iwx[reference], iwy[reference]
    end subroutine

    !------------------ inquiry ----------------

    subroutine Z1QWDC [C,ALIAS:'_z1qwdc_'](lwdatr)
      logical :: lwdatr[reference]
    end subroutine

    subroutine Z1QCLC [C,ALIAS:'_z1qclc_'](lclatr)
      logical :: lclatr[reference]
    end subroutine

    subroutine Z1QTNC [C,ALIAS:'_z1qtnc_'](ltnatr)
      logical :: ltnatr[reference]
    end subroutine

    subroutine Z1QIMC [C,ALIAS:'_z1qimc_'](limatr)
      logical :: limatr[reference]
    end subroutine

    subroutine Z1QPTC [C,ALIAS:'_z1qptc_'](lptatr)
      logical :: lptatr[reference]
    end subroutine

    subroutine Z1QRCT [C,ALIAS:'_z1qrct_'](wsxmn, wsxmx, wsymn, wsymx, fact)
      real ::  wsxmn[reference], wsxmx[reference], wsymn[reference], wsymx[reference], fact[reference]
    end subroutine

    subroutine Z1SROT [C,ALIAS:'_z1srot_'](iwtrot)
    integer(4) :: iwtrot[reference]
    end subroutine

    !------------- FullColor --------------

    subroutine Z1ICLR [C,ALIAS:'_z1iclr_'](image,nlen)
      integer(4),DIMENSION(*) :: image[reference]
      integer(4) :: nlen[reference]
    end subroutine

    subroutine Z1SLCL [C,ALIAS:'_z1slcl_'](icolor)
      integer(4) :: icolor[reference]
    end subroutine

    subroutine Z1STCL [C,ALIAS:'_z1stcl_'](icolor)
      integer(4) :: icolor[reference]
    end subroutine

    subroutine Z1SFCM [C,ALIAS:'_z1sfcm_'](lfc)
      logical :: lfc[reference]
    end subroutine

    subroutine Z1FCLS [C,ALIAS:'_z1fcls_']()
    end subroutine

  end interface
end module
