*-----------------------------------------------------------------------
*     USPACK DRAW Y-AXIS (LOG)                        S.Sakai  90/02/26
*                                                              92/02/22
*-----------------------------------------------------------------------

      SUBROUTINE USYAXL(CYS, NLBL, NTICKS, IYTYPE, YFAC, CUNIT)
      CHARACTER CYS*(*), CUNIT*(*), CYSUB*32, CSBLBL*32, CPOS*1, CP*8
      LOGICAL LAB1
      EXTERNAL CSBLBL, LENZ

      CALL ULIGET('IYTYPE', IT)
      CALL ULISET('IYTYPE', IYTYPE)

      CALL SGQTRN(ITR)
      IF(.NOT.(ITR.EQ.2 .OR. ITR.EQ.4))
     &   CALL MSGDMP('E', 'USXAXL', 'INVALID TRANSFORMATION NUMBER.')
      CALL SGQWND(XMIN, XMAX, YMIN, YMAX)

      YMINA = YMIN/YFAC
      YMAXA = YMAX/YFAC
      CALL SGSWND(XMIN, XMAX, YMINA, YMAXA)
      CALL SGSTRN(ITR)
      CALL SGSTRF

*---------------------------- Y-AXIS -----------------------------------

      NYS = MIN(LEN(CYS), 2)
      DO 100 I=1, NYS
        CALL ULYLOG(CYS(I:I), NLBL, NTICKS)
        CP = 'LABELY'//CYS(I:I)
        CALL UZLGET(CP, LAB1)
        IF(LAB1) THEN
          CYSUB = CSBLBL(YFAC, 0., CUNIT)
          IF(LENZ(CYSUB).NE.0) THEN
            CALL USCGET('CYSPOS', CPOS)
            CALL USYSUB(CYS(I:I), CPOS, CYSUB, 3.)
          ENDIF
        ENDIF
  100 CONTINUE

*-----------------------------------------------------------------------

      CALL SGSWND(XMIN, XMAX, YMIN, YMAX)
      CALL SGSTRN(ITR)
      CALL SGSTRF
      CALL ULISET('IYTYPE', IT)

      RETURN
      END
