*-----------------------------------------------------------------------
*     INTEGER PARAMATER CONTROL
*-----------------------------------------------------------------------
      SUBROUTINE SGIQNP(NCP)

      CHARACTER CP*(*)

      PARAMETER (NPARA = 21)

      INTEGER   IX(NPARA)
      LOGICAL   LCHREQ, LFIRST
      CHARACTER CPARAS(NPARA)*8
      CHARACTER CPARAL(NPARA)*40
      CHARACTER CMSG*80

      EXTERNAL  LCHREQ,LENC

      SAVE

*     / SHORT NAME /

      DATA      CPARAS( 1)/'IRMODE  '/, IX( 1) / 0 /
      DATA      CPARAS( 2)/'MOVE    '/, IX( 2) / 1 /
      DATA      CPARAS( 3)/'NBITS   '/, IX( 3) / 16 /
      DATA      CPARAS( 4)/'ISUP    '/, IX( 4) / 124 /
      DATA      CPARAS( 5)/'ISUB    '/, IX( 5) / 95 /
      DATA      CPARAS( 6)/'IRST    '/, IX( 6) / 34 /
      DATA      CPARAS( 7)/'NPMSKIP '/, IX( 7) / 1 /
      DATA      CPARAS( 8)/'IFONT   '/, IX( 8) / 1 /
      DATA      CPARAS( 9)/'IROT    '/, IX( 9) / 0 /
      DATA      CPARAS(10)/'INDEXC  '/, IX(10) / 0 /
      DATA      CPARAS(11)/'NBUFF   '/, IX(11) / 20 /
      DATA      CPARAS(12)/'IATONE  '/, IX(12) / 999 /
      DATA      CPARAS(13)/'IWS     '/, IX(13) / 1 /
      DATA      CPARAS(14)/'ITR     '/, IX(14) / 1 /
      DATA      CPARAS(15)/'NFRAME  '/, IX(15) / 0 /
      DATA      CPARAS(16)/'NPAGE   '/, IX(16) / 0 /
      DATA      CPARAS(17)/'NLEVEL  '/, IX(17) / 0 /
      DATA      CPARAS(18)/'INDEX   '/, IX(18) / 1 /
      DATA      CPARAS(19)/'ITR3    '/, IX(19) / 1 /
      DATA      CPARAS(20)/'IXC3    '/, IX(20) / 1 /
      DATA      CPARAS(21)/'IYC3    '/, IX(21) / 2 /

*     / LONG  NAME /

      DATA      CPARAL( 1) / 'BOUNDARY_DIRECTION' /
      DATA      CPARAL( 2) / 'LINE_RESUME_MODE' /
      DATA      CPARAL( 3) / 'PATTERN_BIT_LENGTH' /
      DATA      CPARAL( 4) / 'BEGIN_SUPERSCRIPT' /
      DATA      CPARAL( 5) / 'BEGIN_SUBSCRIPT' /
      DATA      CPARAL( 6) / 'END_SCRIPT' /
      DATA      CPARAL( 7) / 'POLIMARKER_INTERVAL' /
      DATA      CPARAL( 8) / '++++IFONT   ' /
      DATA      CPARAL( 9) / 'LINE_LABEL_ROTATION_ANGLE' /
      DATA      CPARAL(10) / 'LABEL_CHAR_INDEX' /
      DATA      CPARAL(11) / 'LINE_BUFFERING_LENGTH' /
      DATA      CPARAL(12) / 'ARROWHEAD_SHADE_PATTERN' /
      DATA      CPARAL(13) / '++++IWS     ' /
      DATA      CPARAL(14) / '++++ITR     ' /
      DATA      CPARAL(15) / '****NFRAME  ' /
      DATA      CPARAL(16) / '****NPAGE   ' /
      DATA      CPARAL(17) / '****NLEVEL  ' /
      DATA      CPARAL(18) / 'CORNERMARK_INDEX' /
      DATA      CPARAL(19) / '++++ITR3    ' /
      DATA      CPARAL(20) / '++++IXC3    ' /
      DATA      CPARAL(21) / '++++IYC3    ' /

      DATA      LFIRST / .TRUE. /


      NCP = NPARA

      RETURN
*-----------------------------------------------------------------------
      ENTRY SGIQID(CP, IDX)

      DO 10 N = 1, NPARA
        IF (LCHREQ(CP, CPARAS(N)) .OR. LCHREQ(CP, CPARAL(N))) THEN
          IDX = N
          RETURN
        END IF
   10 CONTINUE
      CMSG = 'PARAMETER '''//CP(1:LENC(CP))//''' IS NOT DEFINED.'
      CALL MSGDMP('E','SGIQID',CMSG)

      RETURN
*-----------------------------------------------------------------------
      ENTRY SGIQCP(IDX, CP)

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        CP = CPARAS(IDX)
      ELSE
        CALL MSGDMP('E','SGIQCP','IDX IS OUT OF RANGE.')
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY SGIQCL(IDX, CP)

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        CP = CPARAL(IDX)
      ELSE
        CALL MSGDMP('E','SGIQCL','IDX IS OUT OF RANGE.')
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY SGIQVL(IDX, IPARA)

      IF (LFIRST) THEN
        CALL RTIGET('SG', CPARAS, IX, NPARA)
        CALL RLIGET(CPARAL, IX, NPARA)
        LFIRST = .FALSE.
      END IF

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        IPARA = IX(IDX)
      ELSE
        CALL MSGDMP('E','SGIQVL','IDX IS OUT OF RANGE.')
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY SGISVL(IDX, IPARA)

      IF (LFIRST) THEN
        CALL RTIGET('SG', CPARAS, IX, NPARA)
        CALL RLIGET(CPARAL, IX, NPARA)
        LFIRST = .FALSE.
      END IF

      IF (1.LE.IDX .AND. IDX.LE.NPARA) THEN
        IX(IDX) = IPARA
      ELSE
        CALL MSGDMP('E','SGISVL','IDX IS OUT OF RANGE.')
      END IF

      RETURN
*-----------------------------------------------------------------------
      ENTRY SGIQIN(CP, IN)

      DO 20 N = 1, NPARA
        IF (LCHREQ(CP, CPARAS(N)) .OR. LCHREQ(CP, CPARAL(N))) THEN
          IN = N
          RETURN
        END IF
   20 CONTINUE

      IN = 0

      RETURN
      END
