# -*- coding: japanese-cp932 -*-
require "virtual_data"
require "narray"

require "numru/gfdnavi_data/local_cache"

require "numru/gfdnavi_data/array_local"
require "numru/gfdnavi_data/directory_local"
require "numru/gfdnavi_data/variable_local"
require "numru/gfdnavi_data/image_local"
require "numru/gfdnavi_data/knowledge_local"
require "numru/gfdnavi_data/function_local"
require "numru/gfdnavi_data/draw_method_local"

require "forwardable"


module NumRu::GfdnaviData
  module Local
    extend Forwardable

    @@local_cache_path = LocalCache.new
    @@local_cache_gphys = LocalCache.new
    @@alias = Hash.new

    # module functions

    def self.parse_path(path, user=nil)
      $descriptions = ::Array.new
      $i=1
      path_org = path
      if pa = @@alias[path]
        path = pa
      end
      if lc = @@local_cache_path.get([path,user])
        return lc
      end
      methods = ::Array.new
      if /\A(.+)\[([\d,])\]\z/ =~ path
        path = $1
        index = $2
        methods.unshift(["[]",index.split(",").collect{|c|c.to_i}])
      end
      while /\A(.+)\/?(find|analysis|plot|cut)+\(([^\)]+)\)(?:\[([\d,]+)\])?\z/ =~ path
        path = $1
        unless path == ("/" || "nil")
          path= path.chop 
        end
        index = $4
        method = $2
        opts = $3
        unless method == ("cut" || "find")
          opts = opts.split(";")
          # add cut for the compatibility with the previous URL format
          cut = nil
          while /axes\[([^\]]+)\]\[([^\]]+)\]=([^,]*)/ =~ opts[1]
            cut ||= Hash.new
            cut[$1] ||= Hash.new
            cut[$1][$2] = $3
            opts[1] = opts[1].gsub("axes[#{$1}][#{$2}]=#{$3}","")
          end
          opts[1] = opts[1].gsub(/,+/,",").gsub(/^,/,"").gsub(/,$/,"") if opts[1]
          if cut
            cut = cut.map{|k,v|
              if v["max"]
                k.to_s + "=>" + v["min"].to_s + ".." + v["max"].to_s
              else
                k.to_s + "=>" + v["min"].to_s
              end
            }
            path << "/cut(#{cut.join(",")})"
          end
        end
        methods.unshift(["[]",index.split(",").collect{|c|c.to_i}]) if index
        methods.unshift [method,opts]
      end
      unless (path == "/") || path.nil?
        $descriptions.push("path="+ path)
      end 
      operation = nil
      if /\A(.*)\/(variables|images)\z/ =~ path
        path = $1
        operation =  $2
      end
      if /\A\/?\[(.+)\]\z/ =~ path # [...]
        path = $1
        ary = ::Array.new
        # parse "[/url1,/url2],/url3" or "/url1,/url2,/url3", not "[url1,url2]/operation"
        while (/\A(\/?\[.+,.+\][^\(,]+(?:\([^\)]+\))?(?:\[[^\]]+\])?),(\/.+)/ =~ path\
               || (!(/\A(\/?\[.+,.+\][^\(,]+(?:\([^\)]+\))?(?:\[[^\]]+\])?)/ =~ path)\
                   && /\A(\/.+?),(\/.+)\z/ =~ path))
#                   && /\A((?:[^\(,]+(?:\([^\)]+\))?(?:\[[^\]]+\])?)+),(\/.+)/ =~ path))
          path = $2
          ary.push NumRu::GfdnaviData::Local.parse_path($1, user)
        end
        ary.push NumRu::GfdnaviData::Local.parse_path(path, user)
        obj = VirtualData.new(ary)
      else
        obj = Node.find(:first, :conditions => ["path=?", path], :user => user)
        unless obj
          raise "path is invalid: #{path_org}, (#{path}), user=#{user.inspect}"
        end
      end
      gd = NumRu::GfdnaviData::Local.create(user, obj)
      gd = gd.send(operation) if operation
      methods.each do |method, params|
        gd = gd.send(method, *params)
      end
      unless method=="find"
        path = gd.path
        unless path == path_org
          @@alias[path_org] = path unless @@alias.has_key?(path_org)
        end
        @@local_cache_path.push([path,user], gd)
       
      end
      return gd
    end

    def self.create(user, object)
      object = object.entity if Node === object
      hash = {"user"=>user, "object"=>object}
      case object
      when NodeEntityAbstract
        obj = NumRu::GfdnaviData.const_get(Node::NODE_TYPES[object.node_type].camelcase+"Local").new(hash)
      when VirtualData
        if object.array?
          obj = NumRu::GfdnaviData::ArrayLocal.new(hash)
        else
          if object.type == "draw"
            obj = NumRu::GfdnaviData::ImageLocal.new(hash)
          else
            obj = NumRu::GfdnaviData::VariableLocal.new(hash)
          end
        end
      when ::Array, ActiveRecord::Associations::AssociationCollection
        obj = NumRu::GfdnaviData::ArrayLocal.new(hash)
      else
        raise "type (#{object.class}) is invalid"
      end
      return obj
    end

    def self.get_variable_nodes(obj)
      if obj.respond_to?(:virtual_nodes)
        return obj.virtual_nodes
      end
      variables = ::Array.new
      if obj.is_a?(::Variable)
        variables << obj
      elsif obj.respond_to?(:each)
        obj.each do |v|
          if v.is_a?(::Variable)
            variables << v
          elsif v.is_a?(Node) && v.variable?
            variables << v.entity
          elsif v.respond_to?(:virtual_nodes)
            variables += v.virtual_nodes
          else
            raise "#{v.class.to_s} is not supported"
          end
        end
      else
        raise "#{obj.class.to_s} is not supported"
      end
      return variables.uniq
    end


    # instance methods

    def init(hash)
      @user = User.find(:first, :conditions => ["login=?",user]) if String === @user
      unless @object
      
        @object = eval("::#{self.class.const_get(:OBJECT_CLASS).name}").new
        @new_data = true
      else
        @new_data = false
      end
    end

    def local?
      true
    end

    def remote?
      false
    end

    def get_object
      return @object
    end


    def to_hash(opts={})
      @object.to_hash(opts)
    end

    def to_rb(opts={})
      if @object.respond_to?(:to_rb)
        @object.to_rb(opts)
      else
        uri_prefix = opts[:uri_prefix]
        pa = @object.path
        pa = File.join(uri_prefix, "data", pa) if uri_prefix
        code = <<-EOF
require "numru/gfdnavi_data"
include NumRu

data = GfdnaviData.open("#{pa}")
        EOF
      end
    end

    def user=(user)
      @user = user
    end

    def virtual_nodes
      NumRu::GfdnaviData::Local.get_variable_nodes(@object)
    end

    %w(name path mtime owner other_mode rgroups wgroups size guest_owner file other_readable groups_readable title description).each do |me|
      def_delegator :@object, me+"="
      def_delegator :@object, me
    end

    def save_as(path, user=nil)
      unless NumRu::GfdnaviData::Variable === self || NumRu::GfdnaviData::Image === self || NumRu::GfdnaviData::Knowledge === self
        raise "saving is not supported for array"
      end
      user ||= @user
      unless user
        raise "user must be specified"
      end
      @object.save_as(path, user)
    end

    def delete
      unless @user
        raise "user must be specified"
      end
      unless NodeEntityAbstract === @object && !(::Variable  === @object)
        raise "cannot delete this data: #{@object.class}"
      end
      if @user.super_user? || @object.owner == @user
        @object.destroy_all
      else
        raise "cannot delete: Permission denied"
      end
    end

    private
    def str_to_hash(hash, key, val)
      if /\A([^\[]+)\[(.+)\]\z/ =~ key
        key = $1
        keys = $2.split("][")
        keys.unshift key
        keys[0..-2].each do |k|
          hash = (hash[k] ||= Hash.new)
        end
        hash[keys[-1]] = val
      else
        hash[key] = val
      end
    end

    def str_to_options(str)
      opts = Hash.new
      while /\A([^=]+)=(.*)\z/ =~ str
        key = $1
        val = $2
        if /\A([^=]*),([^,=]+=.*)\z/ =~ val
          val = $1
          str = $2
        else
          str = ""
        end
        val = val.split(",") if /,/ =~ val
        str_to_hash(opts, key, val)
      end
      return opts
    end

    def get_attribute(name)
      #    get_object(path, @user)
      case name
      when /\A(?:variable|image)_nodes\z/
        @object.send(name, :user => @user)
      when "children"
        @object.send(name, false, :user => @user)
      else
        @object.send(name)
      end
    end

    def create(obj)
      NumRu::GfdnaviData::Local.create(@user, obj)
    end

  end
end
