!== dcpam ץץ 
!
!== dcpam sample main program
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: dcpam_hs94.f90,v 1.39 2008-04-21 10:36:20 morikawa Exp $
! Tag Name::  $Name: dcpam4-20080427 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
program dcpam_hs94
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! dcpam ΥᥤץΥץǤ.
  ! Held and Suarez (1994) ٥ޡƥȤԤʤޤ.
  !
  ! This is sample main program of dcpam.
  ! Held and Suarez (1994) benchmark test is performed.
  !

  !---------------------------------------------------------
  !  
  !  Generate initial data
  !---------------------------------------------------------
  use initial_data, only: INIDAT, IniDataCreate, IniDataGetAxes, &
    & IniDataGet, IniDataClose, IniDataPutLine

  !---------------------------------------------------------
  !  ϳز
  !  Dynamical core
  !---------------------------------------------------------
  use dyn_spectral_as83, only: DYNSPAS83, &
    & DynSpAsCreate, Dynamics, VorDiv2UV, UV2VorDiv, &
    & DynSpAsClose, DynSpAsEqualAxes, DynSpAsGetAxes, DynSpAsPutLine

  !---------------------------------------------------------
  !  ʪ
  !  Physical processes
  !---------------------------------------------------------

  !-------------------------------------
  !  Held and Suarez (1994)
  use phy_hs94, only: PHYHS94, PhyHsCreate, PhyHsClose, &
    & PhyHsForcing, PhyHsPutLine

  !---------------------------------------------------------
  !  GCM ѥ桼ƥƥ
  !  Utilities for GCM
  !---------------------------------------------------------

  !-------------------------------------
  !  ʪ
  !  Physical constants
  use constants, only: CONST, Create, Get, PutLine

  !-------------------------------------
  !  ե륿
  !  Time filter
  use timefilter, only: TFILTER, Create, Filter, Progress, PutLine

  !---------------------------------------------------------
  !  ǡ I/O
  !  Data I/O
  !---------------------------------------------------------
  use gt4_history_nmlinfo, only: GTHST_NMLINFO, HstNmlInfoPutLine
  use gt4_history, only: GT_HISTORY, HistoryGet

  !---------------------------------------------------------
  !  ѥ桼ƥƥ
  !  Common utilities
  !---------------------------------------------------------
  use dc_types, only: DP, STRING, TOKEN, STDOUT
  use dc_args, only: ARGS, DCArgsOpen, DCArgsHelpMsg, DCArgsOption, &
    & DCArgsDebug, DCArgsHelp, DCArgsStrict, DCArgsClose
  use dc_trace, only: DbgMessage, BeginSub, EndSub
  use dc_message,only: MessageNotify
  use dc_string, only: toChar, Printf, StoA, PutLine
  use dc_date, only: DCDiffTimeCreate, EvalSec, EvalByUnit, mod, toChar, &
    & operator(*), operator(==), operator(<), operator(>), &
    & operator(/), operator(+), operator(-)
  use dc_date_types, only: DC_DIFFTIME
  use dc_clock, only: CLOCK, DCClockCreate, DCClockClose, &
    & DCClockStart, DCClockStop, DCClockResult, DCClockPredict, operator(+)
  use dc_iounit, only: FileOpen
  use dc_hash, only: HASH, DCHashPut, DCHashRewind, DCHashNext, DCHashDelete
  implicit none


  !-------------------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !-------------------------------------------------------------------
  character(*), parameter:: title = &
    & 'dcpam_hs94 $Name: dcpam4-20080427 $ :: ' // &
    & 'DCPAM sample program: Held and Suarez (1994) benchmark test'
  character(*), parameter:: source = &
    & 'dcpam4 (See http://www.gfd-dennou.org/library/dcpam)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

  !-------------------------------------------------------------------
  !  ʻȿ
  !  Grid points and maximum truncated wavenumber
  !-------------------------------------------------------------------
  integer:: nmax = 10         ! ȿ. 
                              ! Maximum truncated wavenumber
  integer:: imax = 32         ! ٳʻ. 
                              ! Number of grid points in longitude
  integer:: jmax = 16         ! ٳʻ. 
                              ! Number of grid points in latitude
  integer:: kmax = 20         ! ľؿ. 
                              ! Number of vertical level

  namelist /dcpam_hs94_grid_nml/ &
    & nmax, imax, jmax, kmax
                              ! ʻ, ȿ. 
                              !
                              ! Configure grid points and maximum truncated wavenumber

  !---------------------------------------------------------
  !  ʪ
  !  Physical constants
  !---------------------------------------------------------
  real(DP):: PI               ! $ \pi $ .    ߼Ψ.         Circular constant

  real(DP):: RPlanet          ! $ a $ .      Ⱦ.       Radius of planet
  real(DP):: Omega            ! $ \Omega $ . ž®.     Angular velocity
  real(DP):: Grav             ! $ g $ .      ϲ®.     Gravitational acceleration
  real(DP):: Cp               ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
  real(DP):: RAir             ! $ R $ .      絤.   Gas constant of air
  real(DP):: EpsV             ! $ \epsilon_v $ .        ʬ. Molecular weight ratio of water vapor
  integer:: VisOrder          ! ĶǴμ.  Order of hyper-viscosity
  real(DP):: EFoldTime        ! ȿФ e-folding time. E-folding time for maximum wavenumber

  !---------------------------------------------------------
  !  ͥǡ (ꥹȥǡ)
  !  Initial data (Restart data)
  !---------------------------------------------------------
  logical:: initial_data_prepared = .false.
                              ! ͥǡ (ꥹȥǡ) 
                              ! ե̵ͭ. 
                              ! Presence or absence of 
                              ! initial data (restart data) file. 
  character(STRING):: init_nc = 'dcpam_hs94_restart.nc'
                              ! ͥǡ (ꥹȥǡ) 
                              ! netCDF ե̾. 
                              ! NetCDF filename for 
                              ! initial data (restart data) file. 
  character(TOKEN):: init_nc_time_varname = 'time'
                              ! ѿ̾. 
                              ! ˤ, ǡϻ˻
                              ! Ԥޤ.
                              ! 
                              ! Variable name of time. 
                              ! If this variable is null character, 
                              ! time is not specified when data is input.
                              ! 
  real(DP):: init_nc_timeB = -90.0_DP
                              ! ͥǡ ( $ t-\Delta t $ ) λ. 
                              ! Time of initial data ( $ t-\Delta t $ )
  real(DP):: init_nc_timeN = 0.0_DP
                              ! ͥǡ ( $ t $ ) λ. 
                              ! Time of initial data ( $ t $ )

  namelist /dcpam_hs94_initdata_nml/ &
    & initial_data_prepared, init_nc, init_nc_time_varname, &
    & init_nc_timeB, init_nc_timeN
                 ! ͥǡ, ꥹȥǡ. 
                 !
                 ! Configure initial data or restart data

  type(INIDAT):: ini_dat

  !---------------------------------------------------------
  !  Ϸǡ  (ɽ $ \Phi $ )
  !  Geography data (surface $ \Phi $ )
  !---------------------------------------------------------
  logical:: geography_data_prepared = .false.
                              ! Ϸǡ (ɽ $ \Phi $ ) ̵ͭ. 
                              ! Presence or absence of geography data (surface $ \Phi $ )

  character(STRING):: geo_nc = 'geo.nc'
                              ! Ϸǡ netCDF ե. 
                              ! NetCDF file for geography data

  character(TOKEN):: geo_varname = 'Phis'
                              ! Ϸǡѿ̾. 
                              ! Variable name of geography data

  namelist /dcpam_hs94_geodata_nml/ &
    & geography_data_prepared, geo_nc, geo_varname
                 ! Ϸǡ. 
                 !
                 ! Configure geography data

  !---------------------------------------------------------
  !  OPENMP ˤ׻
  !  Parallel computing with OPENMP
  !---------------------------------------------------------
  integer:: openmp_threads = 1 ! OPENMP Ǥκ祹åɿ. 
                               ! Maximum number of threads in OPENMP

  !-------------------------------------------------------------------
  !  ߻, ֥ƥå $ \Delta t $ , 
  !  ʬλ, ͽ¬ɽ
  !  Configure current time, time step $ \Delta t $ , 
  !  finish time of integral, predicted CPU time
  !-------------------------------------------------------------------
  type(DC_DIFFTIME):: current_time
                              ! ߻. Current time.
  type(DC_DIFFTIME):: start_time
                              ! ϻ. Current time.
  real(DP):: start_time_value = 0.0_DP
                              ! ϻ. Value of start time
  character(TOKEN):: start_time_unit = 'min'
                              ! ϻñ. Unit of start time
  type(DC_DIFFTIME):: delta_time
                              ! $ \Delta t $ . ॹƥå. Time step
  real(DP):: delta_time_value = 90.0_DP
                              ! $ \Delta t $ . ॹƥåפ. Value of time step
  character(TOKEN):: delta_time_unit = 'min'
                              ! ॹƥåפñ. Unit of time step
  type(DC_DIFFTIME):: total_time
                              ! ʬλ. Finish time of integral
  real(DP):: total_time_value = 7.0_DP
                              ! ʬλ. Value of finish time of integral
  character(TOKEN):: total_time_unit = 'days'
                              ! ʬλñ. Unit of finish time of integral

  type(DC_DIFFTIME):: predict_show_interval_time
                              ! λͽ¬ɽֳ. 
                              ! Interval of predicted date output
  real(DP):: predict_show_interval_value = 1.0_DP
                              ! λͽ¬ɽֳ. 
                              ! Interval of predicted date output
  character(TOKEN):: predict_show_interval_unit = 'days'
                              ! λͽ¬ɽֳ (ñ). 
                              ! Unit for interval of predicted date output

  namelist /dcpam_hs94_time_nml/ &
    & start_time_value, start_time_unit, &
    & delta_time_value, delta_time_unit, &
    & total_time_value, total_time_unit, &
    & predict_show_interval_value, predict_show_interval_unit
                 ! 
                 !
                 ! Configure time

  !---------------------------------------------------------
  !  ҥȥեؤΥǡ
  !  Configure the settings for history data output
  !---------------------------------------------------------
  real:: history_interval_value = 0.125
                              ! ҥȥǡνϴֳ֤ο. 
                              ! Numerical value for interval of history data output
  character(TOKEN):: history_interval_unit = 'days'
                              ! ҥȥǡνϴֳ֤ñ. 
                              ! Unit for interval of history data output

  character(TOKEN):: history_precision = 'float'
                              ! ҥȥǡ. 
                              ! Precision of history data

  character(STRING):: history_fileprefix = ''
                              ! ҥȥǡΥե̾Ƭ. 
                              ! Prefix of history data filenames

  character(STRING):: history_varlist = 'U, V, Temp, Ps, SigmaDot'
                              ! ҥȥǡνѿꥹ. 
                              ! ޤǶڤä¤٤. 
                              ! (: "U, V, Temp, QVap, Ps" ). 
                              ! 
                              ! List of variables output to history data. 
                              ! Delimiter is comma. 
                              ! (exp. "U, V, Temp, QVap, Ps" ). 

  !---------------------------------------------------------
  !  ꥹȥեؤΥǡ
  !  Configure the settings for restart data output
  !---------------------------------------------------------
  real:: restart_interval_value = 1440.0_DP
                              ! ꥹȥǡνϴֳ֤ο. 
                              ! Numerical value for interval of restart data output
  character(TOKEN):: restart_interval_unit = 'min'
                              ! ꥹȥǡνϴֳ֤ñ. 
                              ! Unit for interval of restart data output

  character(STRING):: restart_filename = 'dcpam_hs94_restart.nc'
                              ! ꥹȥǡΥե̾
                              ! filename of restart data

  !---------------------------------------------------------
  !  
  !  Declaration of array
  !---------------------------------------------------------

  !-------------------------------------
  !  ɸѿ
  !  Coordinate variables
  real(DP), allocatable:: x_Lon (:) ! . Longitude
  real(DP), allocatable:: x_Lon_Weight (:)
                                    ! ʬѺɸŤ. 
                                    ! Weight for integration in longitude
  real(DP), allocatable:: y_Lat (:) ! . Latitude
  real(DP), allocatable:: y_Lat_Weight (:)
                                    ! ʬѺɸŤ. 
                                    ! Weight for integration in latitude
  real(DP), allocatable:: z_Sigma (:)
                              ! $ \sigma $ ٥ (). 
                              ! Full $ \sigma $ level
  real(DP), allocatable:: r_Sigma (:)
                              ! $ \sigma $ ٥ (Ⱦ). 
                              ! Half $ \sigma $ level
  real(DP), allocatable:: z_DelSigma (:)
                              ! $ \Delta \sigma $ (). 
                              ! $ \Delta \sigma $ (Full)

  !-------------------------------------
  !  ͽѿ
  !  Prediction variables
  real(DP), allocatable:: xyz_UB (:,:,:)
                              ! $ U (t-\Delta t) $ .     ®. Zonal wind
  real(DP), allocatable:: xyz_VB (:,:,:)
                              ! $ V (t-\Delta t) $ .     ®. Meridional wind
  real(DP), allocatable:: xyz_VorB (:,:,:)
                              ! $ \zeta (t-\Delta t) $ . . Vorticity
  real(DP), allocatable:: xyz_DivB (:,:,:)
                              ! $ D (t-\Delta t) $ .     ȯ. Divergence
  real(DP), allocatable:: xyz_TempB (:,:,:)
                              ! $ T (t-\Delta t) $ .     . Temperature
  real(DP), allocatable:: xyz_QVapB (:,:,:)
                              ! $ q (t-\Delta t) $ .     漾. Specific humidity
  real(DP), allocatable:: xy_PsB (:,:)
                              ! $ p_s (t-\Delta t) $ .   ɽ̵. Surface pressure

  real(DP), allocatable:: xyz_UN (:,:,:)
                              ! $ U (t) $ .     ®. Zonal wind
  real(DP), allocatable:: xyz_VN (:,:,:)
                              ! $ V (t) $ .     ®. Meridional wind
  real(DP), allocatable:: xyz_VorN (:,:,:)
                              ! $ \zeta (t) $ . . Vorticity
  real(DP), allocatable:: xyz_DivN (:,:,:)
                              ! $ D (t) $ .     ȯ. Divergence
  real(DP), allocatable:: xyz_TempN (:,:,:)
                              ! $ T (t) $ .     . Temperature
  real(DP), allocatable:: xyz_QVapN (:,:,:)
                              ! $ q (t) $ .     漾. Specific humidity
  real(DP), allocatable:: xy_PsN (:,:)
                              ! $ p_s (t) $ .   ɽ̵. Surface pressure

  real(DP), allocatable:: xyz_UA (:,:,:)
                              ! $ U (t+\Delta t) $ .     ®. Zonal wind
  real(DP), allocatable:: xyz_VA (:,:,:)
                              ! $ V (t+\Delta t) $ .     ®. Meridional wind
  real(DP), allocatable:: xyz_VorA (:,:,:)
                              ! $ \zeta (t+\Delta t) $ . . Vorticity
  real(DP), allocatable:: xyz_DivA (:,:,:)
                              ! $ D (t+\Delta t) $ .     ȯ. Divergence
  real(DP), allocatable:: xyz_TempA (:,:,:)
                              ! $ T (t+\Delta t) $ .     . Temperature
  real(DP), allocatable:: xyz_QVapA (:,:,:)
                              ! $ q (t+\Delta t) $ .     漾. Specific humidity
  real(DP), allocatable:: xy_PsA (:,:)
                              ! $ p_s (t+\Delta t) $ .   ɽ̵. Surface pressure

  !-------------------------------------
  !  Held and Suarez (1994) ˤѲ
  !  Tendency by Held and Suarez (1994)
  real(DP), allocatable:: xyz_DUDtHS94 (:,:,:)
                              ! $ \DP{U}{t} $ . 
                              ! Held and Suarez (1994) Υ쥤꡼໤ˤ®Ѳ. 
                              ! Zonal wind tendency due to Rayleigh damping of Held and Suarez (1994)
  real(DP), allocatable:: xyz_DVDtHS94 (:,:,:)
                              ! $ \DP{V}{t} $ . 
                              ! Held and Suarez (1994) Υ쥤꡼໤ˤ®Ѳ. 
                              ! Meridional wind tendency due to Rayleigh damping of Held and Suarez (1994)
  real(DP), allocatable:: xyz_DVorDtHS94 (:,:,:)
                              ! $ \DP{\zeta}{t} $ . 
                              ! Held and Suarez (1994) Υ쥤꡼໤ˤ뱲Ѳ. 
                              ! Vorticity tendency due to Rayleigh damping of Held and Suarez (1994)
  real(DP), allocatable:: xyz_DDivDtHS94 (:,:,:)
                              ! $ \DP{D}{t} $ . 
                              ! Held and Suarez (1994) Υ쥤꡼໤ˤȯѲ. 
                              ! Divergence tendency due to Rayleigh damping of Held and Suarez (1994)
  real(DP), allocatable:: xyz_DTempDtHS94 (:,:,:)
                              ! $ \DP{T}{t} $ . 
                              ! Held and Suarez (1994) Υ˥塼ȥѤˤ벹Ѳ. 
                              ! Temperature tendency due to Newtonian relaxation of Held and Suarez (1994)

  !-------------------------------------
  !  Ϸǡ (ɽ $ \Phi $ ) ѿ
  !  Geography data (surface $ \Phi $ ) variables
  real(DP), allocatable:: xy_Phis (:,:)
                              ! $ \Phi_s $ . ɽݥƥ󥷥. 
                              ! Surface geo-potential

  !-----------------------------------------------------------------
  !  ǡ
  !  Configure the settings for data output
  !-----------------------------------------------------------------
  type(GTHST_NMLINFO), pointer:: gthstnml =>null()
                              ! ̤ΥǡϾ. 
                              ! 
                              ! Individual data output information
  type(GT_HISTORY), pointer:: gthist =>null()
                              ! gt4_history#GT_HISTORY ѿ. 
                              ! "gt4_history#GT_HISTORY" variable
  type(HASH):: registered_varnames
                              ! ҥȥǡȤƽϤǤѿ̾Υꥹ.
                              ! 
                              ! List of names of variables that can be output 
                              ! as history data

  !---------------------------
  !  ҥȥեؤΥǡ
  !  Configure the settings for history data output
  type(GTHST_NMLINFO), pointer:: gthstnml_history =>null()
                              ! ̤ΥǡϾ. 
                              ! 
                              ! Individual data output information

  !---------------------------
  !  ꥹȥեؤΥǡ
  !  Configure the settings for restart data output
  type(GTHST_NMLINFO), pointer:: gthstnml_restart =>null()
                              ! ̤ΥǡϾ. 
                              ! 
                              ! Individual data output information

  !---------------------------
  !  ǡϤ˴ؤѿ
  !  Work variables for data output
  character(STRING):: name = ''
                              ! ѿ̾. Variable identifier
  character(STRING):: longname = ''
                              ! ѿεŪ̾. Descriptive name of variables
  character(STRING), allocatable:: dims(:)
                              ! ɸ̾. Name of axes
  character(STRING):: units = ''
                              ! ñ. Units
  character(TOKEN):: precision
                              ! ҥȥǡ. 
                              ! Precision of history data
  logical:: average
                              ! ϥǡʿѲե饰. 
                              ! Flag for average of output data
  real:: time
                              ! . Time

  !---------------------------------------------------------
  !  ѿ
  !  Work variables
  !---------------------------------------------------------
  type(ARGS):: arg            ! ޥɥ饤. 
                              ! Command line options
  logical:: OPT_namelist      ! -N, --namelist ץ̵ͭ. 
                              ! Existence of '-N', '--namelist' option
  character(STRING):: VAL_namelist
                              ! -N, --namelist ץ. 
                              ! Value of '-N', '--namelist' option
  integer:: unit_nml          ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
  integer:: iostat_nml        ! NAMELIST ɤ߹߻ IOSTAT. 
                              ! IOSTAT of NAMELIST read
  character(STRING):: init_nc_rangeB
                              ! ϤκݤڤФ ( $ t-\Delta t $ ). 
                              ! Range of initial data input ( $ t-\Delta t $ )
  character(STRING):: init_nc_rangeN
                              ! ϤκݤڤФ ( $ t $ ). 
                              ! Range of initial data input ( $ t $ )
  type(CONST):: const_earth   ! ʪ. Physical constants.

  type(DYNSPAS83):: dyn       ! ϳز. 
                              ! Dynamical core
  type(PHYHS94):: phy_hs      ! ʪ (Held and Suarez (1994))
                              ! Physical process (Held and Suarez (1994))
  type(TFILTER):: tfilt       ! ե륿. 
                              ! Time filter

  type(CLOCK):: clk_setup, clk_histget, clk_histput, &
    & clk_dyn, clk_phy, clk_tfilt
                              ! CPU ֥˥. 
                              ! CPU time monitor

  logical:: wa_module_initialized = .false.
                              ! wa_module (SPMODEL 饤֥) ե饰. 
                              ! "wa_module" (SPMODEL library) 
                              ! initialization flag. 

  character(*), parameter:: version = &
    & '$Name: dcpam4-20080427 $' // &
    & '$Id: dcpam_hs94.f90,v 1.39 2008-04-21 10:36:20 morikawa Exp $'
  character(*), parameter:: subname = 'dcpam_hs94'

continue
  !---------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line options handling
  !---------------------------------------------------------
  call cmdline_optparse  ! ֥롼. This is an internal subroutine

  call BeginSub( subname, version=version )

  !-------------------------------------------------------------------
  !  CPU ֥˥ν
  !  Configure the settings for CPU time monitor
  !-------------------------------------------------------------------
  call DCClockCreate(  clk = clk_setup, &    ! (out)
    &                 name = 'Setup' )       ! (in)
  call DCClockCreate(  clk = clk_histget, &  ! (out)
    &                 name = 'HistoryGet' )  ! (in)
  call DCClockCreate(  clk = clk_histput, &  ! (out)
    &                 name = 'HistoryPut' )  ! (in)
  call DCClockCreate(  clk = clk_dyn, &      ! (out)
    &                 name = 'Dynamics' )    ! (in)
  call DCClockCreate(  clk = clk_phy, &      ! (out)
    &                 name = 'Phyisics' )    ! (in)
  call DCClockCreate(  clk = clk_tfilt, &    ! (out)
    &                 name = 'TimeFilter' )  ! (in)

  !-------------------------------------------------------------------
  !  ʻȿ
  !  Configure the grid points and maximum truncated wavenumber
  !-------------------------------------------------------------------
  call DCClockStart( clk = clk_setup ) ! (inout)

  !-------------------------
  !  NAMELIST ɤ߹
  !  Load NAMELIST
  if ( .not. trim(VAL_namelist) == '' ) then
    call FileOpen( unit = unit_nml, &      ! (out)
      & file = VAL_namelist, mode = 'r' )  ! (in)
    read( unit = unit_nml, &                             ! (in)
      & nml = dcpam_hs94_grid_nml, iostat = iostat_nml ) ! (out)
    if ( iostat_nml == 0 ) then
      call MessageNotify( 'M', subname, &
        & 'NAMELIST group "%c" is loaded from "%c".', &
        & c1='dcpam_hs94_grid_nml', c2=trim(VAL_namelist) )
      write(STDOUT, nml = dcpam_hs94_grid_nml)
    else
      call MessageNotify( 'W', subname, &
        & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
        & c1='dcpam_hs94_grid_nml', c2=trim(VAL_namelist), &
        & i=(/iostat_nml/) )
    end if
    close( unit_nml )
  end if


  !-------------------------------------------------------------------
  !  ߻, ֥ƥå $ \Delta t $ , 
  !  ʬλ, ͽ¬ɽ
  !  Configure current time, time step $ \Delta t $ , 
  !  finish time of integral, predicted CPU time
  !-------------------------------------------------------------------

  !-------------------------
  !  NAMELIST ɤ߹
  !  Load NAMELIST
  if ( .not. trim(VAL_namelist) == '' ) then
    call FileOpen( unit = unit_nml, &      ! (out)
      & file = VAL_namelist, mode = 'r' )  ! (in)
    read( unit = unit_nml, & ! (in)
      & nml = dcpam_hs94_time_nml, iostat = iostat_nml ) ! (out)
    if ( iostat_nml == 0 ) then
      call MessageNotify( 'M', subname, &
        & 'NAMELIST group "%c" is loaded from "%c".', &
        & c1='dcpam_hs94_time_nml', c2=trim(VAL_namelist) )
      write(STDOUT, nml = dcpam_hs94_time_nml)
    else
      call MessageNotify( 'W', subname, &
        & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
        & c1='dcpam_hs94_time_nml', c2=trim(VAL_namelist), &
        & i=(/iostat_nml/) )
    end if
    close( unit_nml )
  end if

  !-------------------------
  !  DC_DIFFTIME ѿ
  !  Configure DC_DIFFTIME type variables
  call DCDiffTimeCreate( &
    &  diff = current_time, &                            ! (out)
    & value = start_time_value, unit = start_time_unit ) ! (in)
  call DCDiffTimeCreate( &
    &  diff = start_time, &                              ! (out)
    & value = start_time_value, unit = start_time_unit ) ! (in)
  call DCDiffTimeCreate( &
    &  diff = delta_time, &                              ! (out)
    & value = delta_time_value, unit = delta_time_unit ) ! (in)
  call DCDiffTimeCreate( &
    &  diff = total_time, &                              ! (out)
    & value = total_time_value, unit = total_time_unit ) ! (in)
  call DCDiffTimeCreate( &
    &  diff = predict_show_interval_time, &  ! (out)
    & value = predict_show_interval_value, & ! (in)
    &  unit = predict_show_interval_unit)    ! (in)

  !-------------------------------------------------------------------
  !  Ϸǡ (ɽ $ \Phi $ ) μ
  !  Get geography data (surface $ \Phi $ )
  !-------------------------------------------------------------------

  !-------------------------
  !  NAMELIST ɤ߹
  !  Load NAMELIST
  if ( .not. trim(VAL_namelist) == '' ) then
    call FileOpen( unit = unit_nml, &      ! (out)
      & file = VAL_namelist, mode = 'r' )  ! (in)
    read( unit = unit_nml, & ! (in)
      & nml = dcpam_hs94_geodata_nml, iostat = iostat_nml ) ! (out)
    if ( iostat_nml == 0 ) then
      call MessageNotify( 'M', subname, &
        & 'NAMELIST group "%c" is loaded from "%c".', &
        & c1='dcpam_hs94_geodata_nml', c2=trim(VAL_namelist) )
      write(STDOUT, nml = dcpam_hs94_geodata_nml)
    else
      call MessageNotify( 'W', subname, &
        & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
        & c1='dcpam_hs94_geodata_nml', c2=trim(VAL_namelist), &
        & i=(/iostat_nml/) )
    end if
    close( unit_nml )
  end if

  !-------------------------
  !  եɤ߹
  !  Load a file
  allocate( xy_Phis(0:imax-1, 0:jmax-1) )
  if ( geography_data_prepared ) then
    call HistoryGet( &
      &  file = geo_nc, varname = geo_varname, &  ! (in)
      & array = xy_Phis )                         ! (out)
  else
    xy_Phis = 0.0_DP
  end if

  !-------------------------------------------------------------------
  !  ʪ
  !  Configure the physical constants
  !-------------------------------------------------------------------
  call Create( constant = const_earth, &  ! (out)
    & Cp = 1004.6_DP, RAir = 287.04_DP, & ! (in)
    & VisOrder = 8, &                     ! (in)
    & EFoldTime = 8640.0_DP, &            ! (in)
    & nmlfile = VAL_namelist )            ! (in)
  call Printf( STDOUT, 'constant=' )
  call PutLine( &
    & constant = const_earth, & ! (in)
    &     unit = STDOUT, &      ! (in)
    &   indent = ' ' )          ! (in)

  call Get( constant = const_earth, &  ! (in)
    & PI = PI, RPlanet = RPlanet, &    ! (out)
    & Grav = Grav, Omega = Omega, &    ! (out)
    & Cp = Cp, RAir = RAir, &          ! (out)
    & EpsV = EpsV, &                   ! (out)
    & VisOrder = VisOrder, &           ! (out)
    & EFoldTime = EFoldTime )          ! (out)

  !-------------------------------------------------------------------
  !  ե륿
  !  Configure the settings for time filter
  !-------------------------------------------------------------------
  call Create( tfilt = tfilt, &      ! (out)
    & filter_param = 0.05_DP, &      ! (in)
    &     int_time = delta_time, &   ! (in)
    &     cur_time = current_time, & ! (in)
    &      nmlfile = VAL_namelist )  ! (in)

  call Printf( STDOUT, 'tfilt=' )
  call PutLine( &
    &  tfilt = tfilt, &  ! (in)
    &   unit = STDOUT, & ! (in)
    & indent = ' ' )     ! (in)

  !-------------------------------------------------------------------
  !  ٷѿ, ľ٥ѿγ
  !  (ꥹȥե, ҥȥե)
  !  Allocate variablesa of latitude and longitude and vertical level
  !  for output of restart file and history files
  !-------------------------------------------------------------------
  allocate( x_Lon(0:imax-1) )
  allocate( x_Lon_Weight (0:imax-1) )
  allocate( y_Lat(0:jmax-1) )
  allocate( y_Lat_Weight (0:jmax-1) )
  allocate( z_Sigma(0:kmax-1) )
  allocate( r_Sigma(0:kmax) )
  allocate( z_DelSigma(0:kmax-1) )

  !-------------------------------------------------------------------
  !  ͽѿγ
  !  Allocate prediction variables
  !-------------------------------------------------------------------
  allocate( xyz_UB(0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyz_VB(0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyz_VorB(0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyz_DivB(0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyz_TempB(0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyz_QVapB(0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xy_PsB(0:imax-1, 0:jmax-1) )

  allocate( xyz_UN(0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyz_VN(0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyz_VorN(0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyz_DivN(0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyz_TempN(0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyz_QVapN(0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xy_PsN(0:imax-1, 0:jmax-1) )

  allocate( xyz_UA(0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyz_VA(0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyz_VorA(0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyz_DivA(0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyz_TempA(0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyz_QVapA(0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xy_PsA(0:imax-1, 0:jmax-1) )

  allocate( xyz_DUDtHS94(0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyz_DVDtHS94(0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyz_DTempDtHS94(0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyz_DVorDtHS94(0:imax-1, 0:jmax-1, 0:kmax-1) )
  allocate( xyz_DDivDtHS94(0:imax-1, 0:jmax-1, 0:kmax-1) )

  call DCClockStop( clk = clk_setup )   ! (inout)

  !-------------------------------------------------------------------
  !  ǡӽͥǡμ⤷
  !  Get or generate axes data and initial data
  !-------------------------------------------------------------------
  call DCClockStart( clk = clk_histget )   ! (inout)

  !-------------------------
  !  NAMELIST ɤ߹
  !  Load NAMELIST
  if ( .not. trim(VAL_namelist) == '' ) then
    call FileOpen( unit = unit_nml, &      ! (out)
      & file = VAL_namelist, mode = 'r' )  ! (in)
    read( unit = unit_nml, & ! (in)
      & nml = dcpam_hs94_initdata_nml, iostat = iostat_nml ) ! (out)
    if ( iostat_nml == 0 ) then
      call MessageNotify( 'M', subname, &
        & 'NAMELIST group "%c" is loaded from "%c".', &
        & c1='dcpam_hs94_initdata_nml', c2=trim(VAL_namelist) )
      write(STDOUT, nml = dcpam_hs94_initdata_nml)
    else
      call MessageNotify( 'W', subname, &
        & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
        & c1='dcpam_hs94_initdata_nml', c2=trim(VAL_namelist), &
        & i=(/iostat_nml/) )
    end if
    close( unit_nml )
  end if

  !-------------------------
  !  եɤ߹
  !  Load a file
  if ( initial_data_prepared ) then

    !-------------------------
    !  ɸɤ߹
    !  Load axes
    call HistoryGet( &
      & file = init_nc, varname = 'lon', &  ! (in)
      & array = x_Lon )                     ! (out)
    x_Lon = x_Lon * PI / 180.0_DP !   units = 'degree' ᤷʤ...
    call HistoryGet( &
      & file = init_nc, varname = 'lon_weight', & ! (in)
      & array = x_Lon_Weight )                    ! (out)
    call HistoryGet( &
      & file = init_nc, varname = 'lat', &  ! (in)
      & array = y_Lat )                     ! (out)
    y_Lat = y_Lat * PI / 180.0_DP !   units = 'degree' ᤷʤ...
    call HistoryGet( &
      & file = init_nc, varname = 'lat_weight', & ! (in)
      & array = y_Lat_Weight )                    ! (out)
    call HistoryGet( &
      & file = init_nc, varname = 'sig', &  ! (in)
      & array = z_Sigma )                   ! (out)
    call HistoryGet( &
      & file = init_nc, varname = 'sigm', &  ! (in)
      & array = r_Sigma )                    ! (out)

    !-------------------------
    !  ǡɤ߹
    !  Load data
    if ( .not. trim(init_nc_time_varname) == '' ) then
      init_nc_rangeB = trim(init_nc_time_varname) // '=' // &
        &              trim(toChar(init_nc_timeB))
      init_nc_rangeN = trim(init_nc_time_varname) // '=' // &
        &              trim(toChar(init_nc_timeN))
    else
      init_nc_rangeB = ''
      init_nc_rangeN = ''
    end if

    call HistoryGet( &
      & file = init_nc, varname = 'U', &  ! (in)
      & array = xyz_UB, &                 ! (out)
      & range = init_nc_rangeB )          ! (in)
    call HistoryGet( &
      & file = init_nc, varname = 'U', &  ! (in) 
      & array = xyz_UN, &                 ! (out)
      & range = init_nc_rangeN )          ! (in) 
    call HistoryGet( &
      & file = init_nc, varname = 'V', &  ! (in) 
      & array = xyz_VB, &                 ! (out)
      & range = init_nc_rangeB )          ! (in) 
    call HistoryGet( &
      & file = init_nc, varname = 'V', &  ! (in) 
      & array = xyz_VN, &                 ! (out)
      & range = init_nc_rangeN )          ! (in) 
!!$    call HistoryGet( &
!!$      & file = init_nc, varname = 'Vor', &  ! (in)
!!$      & array = xyz_VorB, &                 ! (out)
!!$      & range = init_nc_rangeB )            ! (in)
!!$    call HistoryGet( &
!!$      & file = init_nc, varname = 'Vor', &  ! (in) 
!!$      & array = xyz_VorN, &                 ! (out)
!!$      & range = init_nc_rangeN )            ! (in) 
!!$    call HistoryGet( &
!!$      & file = init_nc, varname = 'Div', &  ! (in) 
!!$      & array = xyz_DivB, &                 ! (out)
!!$      & range = init_nc_rangeB )            ! (in) 
!!$    call HistoryGet( &
!!$      & file = init_nc, varname = 'Div', &  ! (in) 
!!$      & array = xyz_DivN, &                 ! (out)
!!$      & range = init_nc_rangeN )            ! (in) 
    call HistoryGet( &
      & file = init_nc, varname = 'Temp', & ! (in) 
      & array = xyz_TempB, &                ! (out)
      & range = init_nc_rangeB )            ! (in) 
    call HistoryGet( &
      & file = init_nc, varname = 'Temp', & ! (in) 
      & array = xyz_TempN, &                ! (out)
      & range = init_nc_rangeN )            ! (in) 
    call HistoryGet( &
      & file = init_nc, varname = 'QVap', & ! (in) 
      & array = xyz_QVapB, &                ! (out)
      & range = init_nc_rangeB )            ! (in) 
    call HistoryGet( &
      & file = init_nc, varname = 'QVap', & ! (in) 
      & array = xyz_QVapN, &                ! (out)
      & range = init_nc_rangeN )            ! (in) 
    call HistoryGet( &
      & file = init_nc, varname = 'Ps', &   ! (in) 
      & array = xy_PsB, &                   ! (out)
      & range = init_nc_rangeB )            ! (in) 
    call HistoryGet( &
      & file = init_nc, varname = 'Ps', &   ! (in) 
      & array = xy_PsN, &                   ! (out)
      & range = init_nc_rangeN )            ! (in) 
  else
    call IniDataCreate( ini_dat = ini_dat, &                  ! (inout)
      & nmax = nmax, imax = imax, jmax = jmax, kmax = kmax, & ! (in)
      & Cp = Cp, RAir = RAir, &                               ! (in)
      & r_SigmaSet = (/ &
      &   1.00_DP, 0.95_DP, 0.90_DP, 0.85_DP, 0.80_DP, &
      &   0.75_DP, 0.70_DP, 0.65_DP, 0.60_DP, 0.55_DP, &
      &   0.50_DP, 0.45_DP, 0.40_DP, 0.35_DP, 0.30_DP, &
      &   0.25_DP, 0.20_DP, 0.15_DP, 0.10_DP, 0.05_DP, &
      &   0.0_DP /), &                                        ! (in)
      & nmlfile = VAL_namelist )                              ! (in)
    wa_module_initialized = .true.
    call IniDataGetAxes( ini_dat = ini_dat, &  ! (inout)
      & x_Lon = x_Lon, &                       ! (out)
      & x_Lon_Weight = x_Lon_Weight, &         ! (out)
      & y_Lat = y_Lat, &                       ! (out)
      & y_Lat_Weight = y_Lat_Weight, &         ! (out)
      & z_Sigma = z_Sigma, r_Sigma = r_Sigma ) ! (out)
    call IniDataGet( ini_dat = ini_dat, &              ! (inout)
      &     xyz_U = xyz_UB,       xyz_V = xyz_VB, &    ! (out)
!!$      &   xyz_Vor = xyz_VorB,   xyz_Div = xyz_DivB, &  ! (out)
      &  xyz_Temp = xyz_TempB, xyz_QVap = xyz_QVapB, & ! (out)
      &     xy_Ps = xy_PsB )                           ! (out)
    call IniDataGet( ini_dat = ini_dat, &              ! (inout)
      &     xyz_U = xyz_UN,       xyz_V = xyz_VN, &    ! (out)
!!$      &   xyz_Vor = xyz_VorN,   xyz_Div = xyz_DivN, &  ! (out)
      &  xyz_Temp = xyz_TempN, xyz_QVap = xyz_QVapN, & ! (out)
      &     xy_Ps = xy_PsN )                           ! (out)
    call IniDataClose( ini_dat )                       ! (inout)
  end if

  call DCClockStop( clk = clk_histget )   ! (inout)

  !----------------------------------------------------------------
  !  ǡ
  !  Configure the settings for data output
  !----------------------------------------------------------------
  !---------------------------
  !  ҥȥեؤΥǡ
  !  Configure the settings for history data output
  call history_output_init ! ֥롼. This is an internal subroutine

  call Printf( STDOUT, 'gthstnml_history=' )
  call HstNmlInfoPutLine( &
    & gthstnml = gthstnml_history, & ! (in)
    &     unit = STDOUT, &           ! (in)
    &   indent = ' ' )               ! (in)

  !---------------------------
  !  ꥹȥեؤΥǡ
  !  Configure the settings for restart data output
  call restart_output_init ! ֥롼. This is an internal subroutine

  call Printf( STDOUT, 'gthstnml_restart=' )
  call HstNmlInfoPutLine( &
    & gthstnml = gthstnml_restart, & ! (in)
    &     unit = STDOUT, &           ! (in)
    &   indent = ' ' )               ! (in)

  !-------------------------------------------------------------------
  !  ϳز
  !  Configure the settings for dynamical core
  !-------------------------------------------------------------------
  call DCClockStart( clk = clk_setup ) ! (inout)

  !-------------------------
  !  dyn_spectral_as83 
  !  Configure 'dyn_spectral_as83'
  call DynSpAsCreate( dyn_sp_as = dyn, &                     ! (inout)
    &  nmax = nmax, imax = imax, jmax = jmax, kmax = kmax, & ! (in)
    &  PI = PI, RPlanet = RPlanet, &                         ! (in)
    &  Omega = Omega, &                                      ! (in)
    &  Cp = Cp, RAir = RAir, &                               ! (in)
    &  EpsV = EpsV, &                                        ! (in)
    &  VisOrder = VisOrder, &                                ! (in)
    &  EFoldTime = EFoldTime, &                              ! (in)
    &  DelTime = EvalSec(delta_time), &                      ! (in)
    &  xy_Phis = xy_Phis, &                                  ! (in)
    &  current_time_value = real( start_time_value ), &      ! (in)
    &  current_time_unit = start_time_unit, &                ! (in)
    &  history_varlist = 'SigmaDot', &                       ! (in)
    &  history_interval_value = history_interval_value, &    ! (in)
    &  history_interval_unit = history_interval_unit, &      ! (in)
    &  history_precision = history_precision, &              ! (in)
    &  history_fileprefix = history_fileprefix, &            ! (in)
    &  openmp_threads = openmp_threads, &                    ! (in)
    &  wa_module_initialized = wa_module_initialized, &      ! (in)
    &  nmlfile = VAL_namelist )                              ! (in)

  call Printf( STDOUT, 'dyn_sp_as=' )
  call DynSpAsPutLine( &
    & dyn_sp_as = dyn, &    ! (in)
    &      unit = STDOUT, & ! (in)
    &    indent = ' ' )     ! (in)

  call DynSpAsEqualAxes( dyn_sp_as = dyn, &        ! (inout)
    & x_Lon = x_Lon,     y_Lat = y_Lat, &          ! (in)
    & z_Sigma = z_Sigma, r_Sigma = r_Sigma )       ! (in)

  !---------------------------------------------------------
  !  ʪ
  !  Configure the settings for physical processes
  !---------------------------------------------------------
  !-------------------------------------
  !  Held and Suarez (1994)
  call PhyHsCreate( phy_hs = phy_hs, &          ! (inout)
    &  imax = imax, jmax = jmax, kmax = kmax, & ! (in)
    &  x_Lon = x_Lon, y_Lat = y_Lat, &          ! (in)
    &  z_Sigma = z_Sigma, &                     ! (in)
    &  DelTime = EvalSec(delta_time), &         ! (in)
    &  Cp = Cp, RAir = RAir, &                  ! (in)
    &  history_varlist = '', &                          ! (in)
    &  current_time_value = real( start_time_value ), & ! (in)
    &  current_time_unit = start_time_unit, &           ! (in)
    &  history_interval_value = history_interval_value, &    ! (in)
    &  history_interval_unit = history_interval_unit, &      ! (in)
    &  history_precision = history_precision, &              ! (in)
    &  history_fileprefix = history_fileprefix, &            ! (in)
    &  nmlfile = VAL_namelist )                 ! (in)

  call Printf( STDOUT, 'phy_hs=' )
  call PhyHsPutLine( &
    & phy_hs = phy_hs, & ! (in)
    &   unit = STDOUT, & ! (in)
    & indent = ' ' )     ! (in)

  !----------------------------------------------------------------
  !  ǡν
  !  Output initial data
  !----------------------------------------------------------------
  !-------------------------
  !  ®®鱲٤ȯ׻
  !  Calculate vorticity and divergence from 
  !  zonal and meridional wind at step $ t $
  call UV2VorDiv( dyn_sp_as = dyn, &            ! (inout)
    & xyz_U   = xyz_UB,   xyz_V   = xyz_VB, &   ! (in)
    & xyz_Vor = xyz_VorB, xyz_Div = xyz_DivB )  ! (out)

  call UV2VorDiv( dyn_sp_as = dyn, &            ! (inout)
    & xyz_U   = xyz_UN,   xyz_V   = xyz_VN, &   ! (in)
    & xyz_Vor = xyz_VorN, xyz_Div = xyz_DivN )  ! (out)

!!$  !-------------------------
!!$  !  ٤ȯ®®׻ (ƥå $ t $ )
!!$  !  Calculate zonal and meridional wind from vorticity and divergence
!!$  !  at step $ t $
!!$  call VorDiv2UV( dyn_sp_as = dyn, &            ! (inout)
!!$    & xyz_Vor = xyz_VorN, xyz_Div = xyz_DivN, & ! (in)
!!$    & xyz_U   = xyz_UN,   xyz_V   = xyz_VN )    ! (out)

  call history_output_inidata ! ֥롼. This is an internal subroutine

  call DCClockStop( clk = clk_setup ) ! (inout)

  MainLoop : do while ( current_time < total_time )

    !----------------------------------------------------------------
    !  ʪ
    !  Physical processes
    !----------------------------------------------------------------
    !-----------------------------------
    !  Held and Suarez(1994) βǮ
    !  Heating and dissipation by Held and Suarez(1994)
    call DCClockStart( clk = clk_phy )   ! (inout)

    call PhyHsForcing( phy_hs = phy_hs, &                        ! (inout)
      &       xyz_U = xyz_UB,            xyz_V = xyz_VB, &       ! (in)
      &    xyz_Temp = xyz_TempB,         xy_Ps = xy_PsB, &       ! (in)
      &    xyz_DUDt = xyz_DUDtHS94,   xyz_DVDt = xyz_DVDtHS94, & ! (out)
      & xyz_DTempDt = xyz_DTempDtHS94 )                          ! (out)

    !-------------------------
    !  ®®鱲٤ȯ׻
    !  Calculate vorticity and divergence from 
    !  zonal and meridional wind at step $ t $
    call UV2VorDiv( dyn_sp_as = dyn, &                        ! (inout)
      &   xyz_U = xyz_DUDtHS94,     xyz_V = xyz_DVDtHS94, &   ! (in)
      & xyz_Vor = xyz_DVorDtHS94, xyz_Div = xyz_DDivDtHS94 )  ! (out)

    call UV2VorDiv( dyn_sp_as = dyn, &            ! (inout)
      & xyz_U   = xyz_UB,   xyz_V   = xyz_VB, &   ! (in)
      & xyz_Vor = xyz_VorB, xyz_Div = xyz_DivB )  ! (out)

    call UV2VorDiv( dyn_sp_as = dyn, &            ! (inout)
      & xyz_U   = xyz_UN,   xyz_V   = xyz_VN, &   ! (in)
      & xyz_Vor = xyz_VorN, xyz_Div = xyz_DivN )  ! (out)

    call DCClockStop( clk = clk_phy )   ! (inout)

    !----------------------------------------------------------------
    !  ϳز黻
    !  Dynamical core
    !----------------------------------------------------------------
    call DCClockStart( clk = clk_dyn )   ! (inout)
    call Dynamics( dyn_sp_as = dyn, &                     ! (inout)
      &    xyz_VorB = xyz_VorB,   xyz_DivB = xyz_DivB, &  ! (in)
      &   xyz_TempB = xyz_TempB, xyz_QVapB = xyz_QVapB, & ! (in)
      &      xy_PsB = xy_PsB, &                           ! (in)
!
      &    xyz_VorN = xyz_VorN,   xyz_DivN = xyz_DivN, &  ! (in)
      &   xyz_TempN = xyz_TempN, xyz_QVapN = xyz_QVapN, & ! (in)
      &      xy_PsN = xy_PsN, &                           ! (in)
!
      &  xyz_DVorDt = xyz_DVorDtHS94, &                   ! (in)
      &  xyz_DDivDt = xyz_DDivDtHS94, &                   ! (in)
      & xyz_DTempDt = xyz_DTempDtHS94, &                  ! (in)
!
      &    xyz_VorA = xyz_VorA,  xyz_DivA  = xyz_DivA, &  ! (out)
      &   xyz_TempA = xyz_TempA, xyz_QVapA = xyz_QVapA, & ! (out)
      &      xy_PsA = xy_PsA )                            ! (out)

    call DCClockStop( clk = clk_dyn )   ! (inout)

    !----------------------------------------------------------------
    !  ե륿
    !  Time filter
    !----------------------------------------------------------------
    call DCClockStart( clk = clk_tfilt )   ! (inout)

    call Filter( &
      &  tfilt = tfilt, &      ! (in)
      & before = xyz_VorB, &   ! (in)
      &    now = xyz_VorN, &   ! (inout)
      &  after = xyz_VorA )    ! (in)

    call Filter( &
      &  tfilt = tfilt, &      ! (in)
      & before = xyz_DivB, &   ! (in)
      &    now = xyz_DivN, &   ! (inout)
      &  after = xyz_DivA )    ! (in)

    call Filter( &
      &  tfilt = tfilt, &      ! (in)
      & before = xyz_TempB, &  ! (in)
      &    now = xyz_TempN, &  ! (inout)
      &  after = xyz_TempA )   ! (in)

    call Filter( &
      &  tfilt = tfilt, &      ! (in)
      & before = xyz_QVapB, &  ! (in)
      &    now = xyz_QVapN, &  ! (inout)
      &  after = xyz_QVapA )   ! (in)

    call Filter( &
      &  tfilt = tfilt, &      ! (in)
      & before = xy_PsB, &     ! (in)
      &    now = xy_PsN, &     ! (inout)
      &  after = xy_PsA )      ! (in)

    call Progress( &
      &  tfilt = tfilt, &      ! (inout)
      &   time = delta_time )  ! (in)

    call DCClockStop( clk = clk_tfilt )   ! (inout)

    !----------------------------------------------------------------
    !  ǡ
    !  Output data
    !----------------------------------------------------------------
    call DCClockStart( clk = clk_histput )   ! (inout)
    !-------------------------
    !  ٤ȯ®®׻
    !  Calculate zonal and meridional wind from vorticity and divergence
    !  at step
    call VorDiv2UV( dyn_sp_as = dyn, &            ! (inout)
      & xyz_Vor = xyz_VorN, xyz_Div = xyz_DivN, & ! (in)
      & xyz_U   = xyz_UN,   xyz_V   = xyz_VN )    ! (out)
    call VorDiv2UV( dyn_sp_as = dyn, &            ! (inout)
      & xyz_Vor = xyz_VorA, xyz_Div = xyz_DivA, & ! (in)
      & xyz_U   = xyz_UA,   xyz_V   = xyz_VA )    ! (out)

    !-------------------------
    !  ҥȥեؤΥǡ
    !  Output history data
    call history_output ! ֥롼. This is an internal subroutine

    !-------------------------
    !  ꥹȥեؤΥǡ
    !  Output restart data
    call restart_output ! ֥롼. This is an internal subroutine

    call DCClockStop( clk = clk_histput )   ! (inout)

    !-----------------------------------------------------------------
    !  ץཪλޤǤͽ¬ CPU ֤ͽ¬ɽ
    !  Print predicted CPU time and date to finish of program
    !-----------------------------------------------------------------
    if ( mod(current_time + delta_time, predict_show_interval_time) == 0 ) then
      call DCClockPredict( &
        & clk  = clk_setup + clk_histget + clk_histput &
        &        + clk_dyn + clk_phy + clk_tfilt, &           ! (in)
        & progress = &
        &  real( ( current_time + delta_time - start_time ) &
        &          / ( total_time - start_time ) ) )          ! (in)
    end if

    !----------------------------------------------------------------
    !  ͽ¬ѿλդؤ
    !  Exchange time of prediction variables
    !----------------------------------------------------------------
    xyz_UB = xyz_UN
    xyz_UN = xyz_UA
    xyz_UA = 0.0_DP

    xyz_VB = xyz_VN
    xyz_VN = xyz_VA
    xyz_VA = 0.0_DP

    xyz_TempB = xyz_TempN
    xyz_TempN = xyz_TempA
    xyz_TempA = 0.0_DP

    xyz_QVapB = xyz_QVapN
    xyz_QVapN = xyz_QVapA
    xyz_QVapA = 0.0_DP

    xy_PsB = xy_PsN
    xy_PsN = xy_PsA
    xy_PsA = 0.0_DP

    !----------------------------------------------------------------
    !  ߻ι
    !  Update current time
    !----------------------------------------------------------------
    current_time = current_time + delta_time
  enddo MainLoop

  !----------------------------------------------------------------
  !  ҥȥեؤΥǡϤνλ
  !  Terminate history data output
  !----------------------------------------------------------------
  call history_output_close ! ֥롼. This is an internal subroutine

  !----------------------------------------------------------------
  !  ꥹȥեؤΥǡϤνλ
  !  Terminate restart data output
  !----------------------------------------------------------------
  call restart_output_close ! ֥롼. This is an internal subroutine

  !----------------------------------------------------------------
  !  CPU ֤פɽ
  !  Print total CPU time
  !----------------------------------------------------------------
  call DCClockResult( &
    & clks = (/clk_setup, clk_histget, clk_histput, &
    &          clk_dyn, clk_phy, clk_tfilt/), &       ! (in)
    & total_auto = .true.)                            ! (in)

  call EndSub( subname )

contains

  subroutine cmdline_optparse
    !
    ! ޥɥ饤νԤޤ
    !
    ! Handle command line options
    !
    call DCArgsOpen( arg = arg )               ! (out)

    call DCArgsHelpMsg( arg = arg, &           ! (inout)
      & category = 'Title', msg = title )      ! (in)
    call DCArgsHelpMsg( arg = arg, &           ! (inout)
      & category = 'Usage', &                  ! (in)
      & msg = './' // trim(subname) // &
      &       ' [Options]' )                   ! (in)
    call DCArgsHelpMsg( arg = arg, &           ! (inout)
      & category = 'Description', &            ! (in)
      & msg = &                                ! (in)
      &   'This program runs Held and Suarez (1994) benchmark test. ' // &
      &   'By default, ' // &
      &   'the resolution is T' // trim(toChar(nmax)) // 'L' // trim(toChar(kmax)) // '. ' // &
      &   'For details, see below. ' // &
      &   'In order to change the settings, use NAMELIST file. ' // &
      &   'Some samples are prepared as dcpam_hs94_***.nml .' )

    call DCArgsHelpMsg( arg = arg, &        ! (inout)
      & category = 'Details about time', &  ! (in)
      & msg = &                             ! (in)
      &   'By default, integration time is ' // &
      &   trim(toChar(total_time_value)) // ' ' // trim(total_time_unit) // ', ' // &
      &   'time step is ' // &
      &   trim(toChar(delta_time_value)) // ' ' // trim(delta_time_unit) // '. ' )
    call DCArgsHelpMsg( arg = arg, &                       ! (inout)
      & category = 'Details about an initial data file', & ! (in)
      & msg = &                                            ! (in)
      &   'By default, no initial data file is needed. ' // &
      &   'Initial data is generated internally.' )
    call DCArgsHelpMsg( arg = arg, &               ! (inout)
      & category = 'Details about output files', & ! (in)
      & msg = &                                    ! (in)
      &   'By default, a restart file is "' // & 
      &   trim(restart_filename) // '", ' // &
      &   'and history data are "' // trim(history_varlist) // '". ' // &
      &   'All variables that can be output are displayed ' // &
      &   'in messages when the program is executed. ' )

    call DCArgsHelpMsg( arg = arg, &           ! (inout)
      & category = 'Source', msg = source )    ! (in)
    call DCArgsHelpMsg( arg = arg, &           ! (inout)
      & category = 'Institution', &            ! (in)
      & msg = institution )                    ! (in)
    call DCArgsOption( arg = arg, &           ! (inout)
      & options = StoA('-N', '--namelist'), & ! (in)
      & flag = OPT_namelist, &                ! (out)
      & value = VAL_namelist, &               ! (out)
      & help = "NAMELIST filename")           ! (in)

    call DCArgsDebug( arg = arg )  ! (inout)
    call DCArgsHelp( arg = arg )   ! (inout)
    call DCArgsStrict( arg = arg ) ! (inout)

    call DCArgsClose( arg = arg )  ! (inout)

  end subroutine cmdline_optparse

  subroutine history_output_init
    !
    ! ҥȥǡϤνԤޤ. 
    ! 
    ! History data output is initialized. 
    !
    use dc_present, only: present_and_true, present_and_not_empty
    use dc_date, only: DCDiffTimeCreate, EvalSec, EvalByUnit
    use gt4_history_nmlinfo, only: HstNmlInfoCreate, &
      & HstNmlInfoAdd, HstNmlInfoPutLine, HstNmlInfoEndDefine, &
      & HstNmlInfoInquire
    use gt4_history, only: GT_HISTORY, &
      & HistoryCreate, HistoryAddVariable, HistoryPut, &
      & HistoryAddAttr, HistoryInitialized

    !-----------------------------------
    !  ѿ
    !  Work variables
    logical:: end
    interface 
      subroutine GTHistNmlRead( nmlfile, gthstnml, err )
        use gt4_history_nmlinfo, only: GTHST_NMLINFO
        character(*), intent(in):: nmlfile
        type(GTHST_NMLINFO), intent(inout):: gthstnml
        logical, intent(out), optional:: err
      end subroutine GTHistNmlRead
    end interface

  continue

    !-----------------------------------------------------------------
    !  ǥեͤ
    !  Configure default values
    !-----------------------------------------------------------------
    allocate( gthstnml_history )
    gthstnml => gthstnml_history
    call HstNmlInfoCreate( gthstnml = gthstnml ) ! (out)

    call HstNmlInfoAdd( &
      & gthstnml = gthstnml, &                     ! (inout)
      & name = '', &                               ! (in)
      & interval_value = history_interval_value, & ! (in)
      & interval_unit = history_interval_unit, &   ! (in)
      & precision = history_precision, &           ! (in)
      & average = .false., &                       ! (in)
      & fileprefix = '' )                          ! (in)

    !-------------------------
    !  ǥեȤǽϤѿΥꥹ
    !  List of variables that are output by default
    call HstNmlInfoAdd( &
      & gthstnml = gthstnml, &   ! (inout)
      & name = history_varlist ) ! (in)

    !-----------------------------------------------------------------
    !  NAMELIST ͤɤ߹
    !  Load values from NAMELIST
    !-----------------------------------------------------------------
    if ( present_and_not_empty(VAL_namelist) ) then
      call MessageNotify( 'M', subname, &
        & 'Loading NAMELIST file "%c" ...', &
        & c1 = trim(VAL_namelist) )
      call GTHistNmlRead ( nmlfile = VAL_namelist, & ! (in)
        & gthstnml = gthstnml )                      ! (inout)
    end if

    call HstNmlInfoEndDefine( gthstnml = gthstnml ) ! (inout)

    !-----------------------------------------------------------------
    !  ץΥҥȥǡϴϢι
    !  Update history data output information on the main program
    !-----------------------------------------------------------------
    call HstNmlInfoInquire( gthstnml = gthstnml, & ! (in)
      & interval_value = history_interval_value, & ! (out)
      & interval_unit = history_interval_unit, &   ! (out)
      & precision = history_precision, &           ! (out)
      & fileprefix = history_fileprefix )          ! (out)

    !-----------------------------------------------------------------
    !  ǡϤν
    !  Initialize data output
    !-----------------------------------------------------------------

    !-------------------------
    !  xyz_U ν
    !  Configure the settings for "xyz_U" output
    name = 'U'
    longname = 'eastward wind'
    units = 'm s-1'
    allocate( dims(4) )
    dims = StoA( 'lon', 'lat', 'sig', 'time' )

    ! ϥեν.
    !   * gthist (gt4_history#GT_HISTORY) ꤵ.
    ! Initialize output file.
    !   * "gthist" (gt4_history#GT_HISTORY) is configured.
    call output_init  ! ֥롼. This is an internal subroutine

    ! °ղäʤɤԤˤϰʲΤ褦ˤ. 
    ! Describe codes as follows in order to add attributes etc.
    if ( associated( gthist ) ) then
      call HistoryAddAttr( &
        & history = gthist, &                           ! (inout)
        & varname = name, attrname = 'standard_name', & ! (in)
        & value = 'eastward_wind' )                     ! (in)
    end if
    deallocate( dims )


    !-------------------------
    !  xyz_V ν
    !  Configure the settings for "xyz_V" output
    name = 'V'
    longname = 'northward wind'
    units = 'm s-1'
    allocate( dims(4) )
    dims = StoA( 'lon', 'lat', 'sig', 'time' )

    ! ϥեν.
    !   * gthist (gt4_history#GT_HISTORY) ꤵ.
    ! Initialize output file.
    !   * "gthist" (gt4_history#GT_HISTORY) is configured.
    call output_init  ! ֥롼. This is an internal subroutine

    ! °ղäʤɤԤˤϰʲΤ褦ˤ. 
    ! Describe codes as follows in order to add attributes etc.
    if ( associated( gthist ) ) then
      call HistoryAddAttr( &
        & history = gthist, &                           ! (inout)
        & varname = name, attrname = 'standard_name', & ! (in)
        & value = 'northward_wind' )                    ! (in)
    end if
    deallocate( dims )


    !-------------------------
    !  xyz_Vor ν
    !  Configure the settings for "xyz_Vor" output
    name = 'Vor'
    longname = 'vorticity'
    units = 's-1'
    allocate( dims(4) )
    dims = StoA( 'lon', 'lat', 'sig', 'time' )

    ! ϥեν.
    !   * gthist (gt4_history#GT_HISTORY) ꤵ.
    ! Initialize output file.
    !   * "gthist" (gt4_history#GT_HISTORY) is configured.
    call output_init  ! ֥롼. This is an internal subroutine

    ! °ղäʤɤԤˤϰʲΤ褦ˤ. 
    ! Describe codes as follows in order to add attributes etc.
    if ( associated( gthist ) ) then
      call HistoryAddAttr( &
        & history = gthist, &                           ! (inout)
        & varname = name, attrname = 'standard_name', & ! (in)
        & value = 'atmosphere_relative_vorticity' )     ! (in)
    end if
    deallocate( dims )


    !-------------------------
    !  xyz_Div ν
    !  Configure the settings for "xyz_Div" output
    name = 'Div'
    longname = 'divergence'
    units = 's-1'
    allocate( dims(4) )
    dims = StoA( 'lon', 'lat', 'sig', 'time' )

    ! ϥեν.
    !   * gthist (gt4_history#GT_HISTORY) ꤵ.
    ! Initialize output file.
    !   * "gthist" (gt4_history#GT_HISTORY) is configured.
    call output_init  ! ֥롼. This is an internal subroutine

    ! °ղäʤɤԤˤϰʲΤ褦ˤ. 
    ! Describe codes as follows in order to add attributes etc.
    if ( associated( gthist ) ) then
      call HistoryAddAttr( &
        & history = gthist, &                           ! (inout)
        & varname = name, attrname = 'standard_name', & ! (in)
        & value = 'divergence_of_wind' )                ! (in)
    end if
    deallocate( dims )


    !-------------------------
    !  xyz_Temp ν
    !  Configure the settings for "xyz_Temp" output
    name = 'Temp'
    longname = 'temperature'
    units = 'K'
    allocate( dims(4) )
    dims = StoA( 'lon', 'lat', 'sig', 'time' )

    ! ϥեν.
    !   * gthist (gt4_history#GT_HISTORY) ꤵ.
    ! Initialize output file.
    !   * "gthist" (gt4_history#GT_HISTORY) is configured.
    call output_init  ! ֥롼. This is an internal subroutine

    ! °ղäʤɤԤˤϰʲΤ褦ˤ. 
    ! Describe codes as follows in order to add attributes etc.
    if ( associated( gthist ) ) then
      call HistoryAddAttr( &
        & history = gthist, &                           ! (inout)
        & varname = name, attrname = 'standard_name', & ! (in)
        & value = 'air_temperature' )                   ! (in)
    end if
    deallocate( dims )


    !-------------------------
    !  xyz_QVap ν
    !  Configure the settings for "xyz_QVap" output
    name = 'QVap'
    longname = 'specific humidity'
    units = 'kg kg-1'
    allocate( dims(4) )
    dims = StoA( 'lon', 'lat', 'sig', 'time' )

    ! ϥեν.
    !   * gthist (gt4_history#GT_HISTORY) ꤵ.
    ! Initialize output file.
    !   * "gthist" (gt4_history#GT_HISTORY) is configured.
    call output_init  ! ֥롼. This is an internal subroutine

    ! °ղäʤɤԤˤϰʲΤ褦ˤ. 
    ! Describe codes as follows in order to add attributes etc.
    if ( associated( gthist ) ) then
      call HistoryAddAttr( &
        & history = gthist, &                           ! (inout)
        & varname = name, attrname = 'standard_name', & ! (in)
        & value = 'specific_humidity' )                 ! (in)
    end if
    deallocate( dims )


    !-------------------------
    !  xyz_Ps ν
    !  Configure the settings for "xyz_Ps" output
    name = 'Ps'
    longname = 'surface pressure'
    units = 'Pa'
    allocate( dims(3) )
    dims = StoA( 'lon', 'lat', 'time' )

    ! ϥեν.
    !   * gthist (gt4_history#GT_HISTORY) ꤵ.
    ! Initialize output file.
    !   * "gthist" (gt4_history#GT_HISTORY) is configured.
    call output_init  ! ֥롼. This is an internal subroutine

    ! °ղäʤɤԤˤϰʲΤ褦ˤ. 
    ! Describe codes as follows in order to add attributes etc.
    if ( associated( gthist ) ) then
      call HistoryAddAttr( &
        & history = gthist, &                           ! (inout)
        & varname = name, attrname = 'standard_name', & ! (in)
        & value = 'surface_air_pressure' )              ! (in)
    end if
    deallocate( dims )


    !-----------------------------------------------------------------
    !  Υ⥸塼뤫Ϥѿ̾ΥꥹȤɽ
    !  Print list of names of variables output from this module
    !-----------------------------------------------------------------
    call Printf( STDOUT, &
      & ' *** MESSAGE *** +---- "%c" output varnames list -----', &
      & c1 = subname )
    call DCHashRewind( hashv = registered_varnames ) ! (inout)
    do
      call DCHashNext( hashv = registered_varnames, & ! (inout)
        & key = name, value = longname, end = end )   ! (out)
      if ( end ) exit
      call Printf( STDOUT, &
        & ' *** MESSAGE *** |      "%c" (%c)', &
        & c1 = trim(name), c2 = trim(longname) )
    enddo
    call DCHashDelete( hashv = registered_varnames ) ! (inout)
    call Printf( STDOUT, &
      & ' *** MESSAGE *** `----------------------------------------' )


    nullify( gthstnml )
  end subroutine history_output_init

  subroutine restart_output_init
    !
    ! ꥹȥǡϤνԤޤ. 
    ! 
    ! Restart data output is initialized. 
    !
    use dc_date, only: DCDiffTimeCreate, EvalSec, EvalByUnit
    use gt4_history_nmlinfo, only: HstNmlInfoCreate, &
      & HstNmlInfoAdd, HstNmlInfoPutLine, HstNmlInfoEndDefine
    use gt4_history, only: GT_HISTORY, &
      & HistoryCreate, HistoryAddVariable, HistoryPut, &
      & HistoryAddAttr, HistoryInitialized

    namelist /dcpam_hs94_restart_nml/ &
      & restart_interval_value, restart_interval_unit, &
      & restart_filename
                 ! ꥹȥեؤΥǡ
                 !
                 ! Configure the settings for restart data output
  continue

    !-----------------------------------------------------------------
    !  ǥեͤ
    !  Configure default values
    !-----------------------------------------------------------------
    allocate( gthstnml_restart )
    gthstnml => gthstnml_restart
    call HstNmlInfoCreate( gthstnml = gthstnml ) ! (out)

    !-----------------------------------------------------------------
    !  NAMELIST ɤ߹
    !  Load NAMELIST
    !-----------------------------------------------------------------
    if ( .not. trim(VAL_namelist) == '' ) then
      call FileOpen( unit = unit_nml, &      ! (out)
        & file = VAL_namelist, mode = 'r' )  ! (in)
      read( unit = unit_nml, & ! (in)
        & nml = dcpam_hs94_restart_nml, iostat = iostat_nml ) ! (out)
      if ( iostat_nml == 0 ) then
        call MessageNotify( 'M', subname, &
          & 'NAMELIST group "%c" is loaded from "%c".', &
          & c1='dcpam_hs94_restart_nml', c2=trim(VAL_namelist) )
        write(STDOUT, nml = dcpam_hs94_restart_nml)
      else
        call MessageNotify( 'W', subname, &
          & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
          & c1='dcpam_hs94_restart_nml', c2=trim(VAL_namelist), &
          & i=(/iostat_nml/) )
      end if
      close( unit_nml )
    end if

    !-----------------------------------------------------------------
    !  ϤѿϿ
    !  Register variables that are output
    !-----------------------------------------------------------------
    call HstNmlInfoAdd( &
      & gthstnml = gthstnml, &                     ! (in)
      & name = '', &                               ! (in)
      & file = restart_filename, &                 ! (in)
      & interval_value = restart_interval_value, & ! (in)
      & interval_unit = restart_interval_unit, &   ! (in)
      & precision = 'double', &                    ! (in)
      & average = .false., &                       ! (in)
      & fileprefix = '' )                          ! (in)

    call HstNmlInfoAdd( &
      & gthstnml = gthstnml, &     ! (inout)
      & name = 'U, V, Temp, QVap, Ps', & ! (in)
      & file = restart_filename )  ! (in)

    call HstNmlInfoEndDefine( gthstnml = gthstnml ) ! (inout)

    !-----------------------------------------------------------------
    !  ǡϤν
    !  Initialize data output
    !-----------------------------------------------------------------

    !-------------------------
    !  xyz_U ν
    !  Configure the settings for "xyz_U" output
    name = 'U'
    longname = 'eastward wind'
    units = 'm s-1'
    allocate( dims(4) )
    dims = StoA( 'lon', 'lat', 'sig', 'time' )

    ! ϥեν.
    !   * gthist (gt4_history#GT_HISTORY) ꤵ.
    ! Initialize output file.
    !   * "gthist" (gt4_history#GT_HISTORY) is configured.
    call output_init  ! ֥롼. This is an internal subroutine

    ! °ղäʤɤԤˤϰʲΤ褦ˤ. 
    ! Describe codes as follows in order to add attributes etc.
    if ( associated( gthist ) ) then
      call HistoryAddAttr( &
        & history = gthist, &                           ! (inout)
        & varname = name, attrname = 'standard_name', & ! (in)
        & value = 'eastward_wind' )                     ! (in)
    end if
    deallocate( dims )


    !-------------------------
    !  xyz_V ν
    !  Configure the settings for "xyz_V" output
    name = 'V'
    longname = 'northward wind'
    units = 'm s-1'
    allocate( dims(4) )
    dims = StoA( 'lon', 'lat', 'sig', 'time' )

    ! ϥեν.
    !   * gthist (gt4_history#GT_HISTORY) ꤵ.
    ! Initialize output file.
    !   * "gthist" (gt4_history#GT_HISTORY) is configured.
    call output_init  ! ֥롼. This is an internal subroutine

    ! °ղäʤɤԤˤϰʲΤ褦ˤ. 
    ! Describe codes as follows in order to add attributes etc.
    if ( associated( gthist ) ) then
      call HistoryAddAttr( &
        & history = gthist, &                           ! (inout)
        & varname = name, attrname = 'standard_name', & ! (in)
        & value = 'northward_wind' )                    ! (in)
    end if
    deallocate( dims )


    !-------------------------
    !  xyz_Temp ν
    !  Configure the settings for "xyz_Temp" output
    name = 'Temp'
    longname = 'temperature'
    units = 'K'
    allocate( dims(4) )
    dims = StoA( 'lon', 'lat', 'sig', 'time' )

    ! ϥեν.
    !   * gthist (gt4_history#GT_HISTORY) ꤵ.
    ! Initialize output file.
    !   * "gthist" (gt4_history#GT_HISTORY) is configured.
    call output_init  ! ֥롼. This is an internal subroutine

    ! °ղäʤɤԤˤϰʲΤ褦ˤ. 
    ! Describe codes as follows in order to add attributes etc.
    if ( associated( gthist ) ) then
      call HistoryAddAttr( &
        & history = gthist, &                           ! (inout)
        & varname = name, attrname = 'standard_name', & ! (in)
        & value = 'air_temperature' )                   ! (in)
    end if
    deallocate( dims )


    !-------------------------
    !  xyz_QVap ν
    !  Configure the settings for "xyz_QVap" output
    name = 'QVap'
    longname = 'specific humidity'
    units = 'kg kg-1'
    allocate( dims(4) )
    dims = StoA( 'lon', 'lat', 'sig', 'time' )

    ! ϥեν.
    !   * gthist (gt4_history#GT_HISTORY) ꤵ.
    ! Initialize output file.
    !   * "gthist" (gt4_history#GT_HISTORY) is configured.
    call output_init  ! ֥롼. This is an internal subroutine

    ! °ղäʤɤԤˤϰʲΤ褦ˤ. 
    ! Describe codes as follows in order to add attributes etc.
    if ( associated( gthist ) ) then
      call HistoryAddAttr( &
        & history = gthist, &                           ! (inout)
        & varname = name, attrname = 'standard_name', & ! (in)
        & value = 'specific_humidity' )                 ! (in)
    end if
    deallocate( dims )


    !-------------------------
    !  xyz_Ps ν
    !  Configure the settings for "xyz_Ps" output
    name = 'Ps'
    longname = 'surface pressure'
    units = 'Pa'
    allocate( dims(3) )
    dims = StoA( 'lon', 'lat', 'time' )

    ! ϥեν.
    !   * gthist (gt4_history#GT_HISTORY) ꤵ.
    ! Initialize output file.
    !   * "gthist" (gt4_history#GT_HISTORY) is configured.
    call output_init  ! ֥롼. This is an internal subroutine

    ! °ղäʤɤԤˤϰʲΤ褦ˤ. 
    ! Describe codes as follows in order to add attributes etc.
    if ( associated( gthist ) ) then
      call HistoryAddAttr( &
        & history = gthist, &                           ! (inout)
        & varname = name, attrname = 'standard_name', & ! (in)
        & value = 'surface_air_pressure' )              ! (in)
    end if
    deallocate( dims )

    nullify( gthstnml )
  end subroutine restart_output_init

  subroutine output_init
    !
    ! ѿ *name* ˴ؤƽϥեνԤޤ. 
    ! ϥե̾ϴֳ֤ʤɤξ gthstnml 
    ! Фޤ. 
    ! 
    ! ѿ *name* ˴ؤƽϤԤˤ, 
    ! *gthist* ˽ե gt4_history#GT_HISTORY
    ! ѿ礵ޤ. Ǥʤ, *gthist* ֤ˤޤ. 
    !
    ! ޤ, ϥǡ٤ precision , 
    ! ϥǡʿѲβݤ average ꤷޤ. 
    ! 
    ! ɸϤɽѿꥹ *registered_varnames* 
    ! *name*, *longname*, *dims*, *units* Ͽޤ. 
    !
    ! An output file is initialized for a variable *name*. 
    ! Information such as the output filename and output intervals 
    ! is taken out of "gthstnml". 
    !
    ! When output is done for the variable *name*, *gthist* is 
    ! associated with the "gt4_history#GT_HISTORY" variable of 
    ! the output file. Otherwise, *gthist* is nullified. 
    !
    ! Moreover, the accuracy of output data is set to *precision*, and 
    ! right or wrong of averaging the output data is set to *average*. 
    !
    ! *name*, *longname*, *dims*, *units* are registered to 
    ! a list of variables *registered_varnames* that is printed to 
    ! standard output. 
    !
    use dc_date, only: DCDiffTimeCreate, EvalSec, EvalByUnit
    use dc_string, only: JoinChar
    use gt4_history_nmlinfo, only: HstNmlInfoOutputValid, &
      & HstNmlInfoInquire, HstNmlInfoAssocGtHist, HstNmlInfoPutLine
    use gt4_history, only: GT_HISTORY, &
      & HistoryCreate, HistoryAddVariable, HistoryPut, &
      & HistoryAddAttr, HistoryInitialized

    !-----------------------------------
    !  ѿ
    !  Work variables
    character(STRING):: file
                              ! ҥȥǡΥե̾. 
                              ! History data filenames
    character(STRING):: dims_str
                              ! ɸΥꥹ. 
                              ! List of axes
    real:: interval_value
                              ! ҥȥǡνϴֳ֤ο. 
                              ! Numerical value for interval of history data output
    character(TOKEN):: interval_unit
                              ! ҥȥǡνϴֳ֤ñ. 
                              ! Unit for interval of history data output
    real(DP), parameter:: PI = 3.1415926535897930_DP
                              ! $ \pi $ . ߼Ψ. Circular constant
  continue
    !-----------------------------------------------------------------
    !  ɸϤɽѿϿ
    !  Register a variable name for print to standard output
    !-----------------------------------------------------------------
    if ( allocated(dims) ) then
      dims_str = JoinChar( dims, ',' )
    else
      dims_str = ''
    end if
    call DCHashPut( hashv = registered_varnames, &     ! (inout)
      & key = name, &                                  ! (in)
      & value = trim( longname ) // ' [' // &
      &         trim( units ) // '] {' // &
      &         trim( dims_str ) // '}' ) ! (in)

    !-----------------------------------------------------------------
    !  ѿν
    !  Initialize variable
    !-----------------------------------------------------------------
    nullify( gthist )
    precision = 'float'
    average = .false.

    !-----------------------------------------------------------------
    !  Ϥͭɤǧ
    !  Confirm whether the output is effective
    !-----------------------------------------------------------------
    if ( .not. HstNmlInfoOutputValid( gthstnml, name ) ) then
      return
    end if

    !-----------------------------------------------------------------
    !  GT_HISTORY ѿμ
    !  Get "GT_HISTORY" variable
    !-----------------------------------------------------------------
    call HstNmlInfoAssocGtHist( &
      & gthstnml = gthstnml, &   ! (in)
      & name = name, &           ! (in)
      & history = gthist )       ! (out)

    call HstNmlInfoInquire( &
      & gthstnml = gthstnml, &   ! (in)
      & name = name, &           ! (in)
      & precision = precision, & ! (out)
      & average = average )      ! (out)

    !-----------------------------------------------------------------
    !  GT_HISTORY ѿνγǧ
    !  Check initialization of "GT_HISTORY" variable
    !-----------------------------------------------------------------
    if ( HistoryInitialized( gthist ) ) then

      !---------------------------------------------------------------
      !  HistoryAddVariable ˤѿ
      !  A variable is created by "HistoryAddVariable"
      !---------------------------------------------------------------
      call HistoryAddVariable( &
        &  history = gthist, &                       ! (inout)
        &  varname = name,         dims = dims, &    ! (in)
        & longname = longname,    units = units, &   ! (in)
        &    xtype = precision, average = average )  ! (in)
      return
    end if

    !-----------------------------------------------------------------
    !  HistoryCreate Τͤμ
    !  Get the settings for "HistoryCreate"
    !-----------------------------------------------------------------
    call HstNmlInfoInquire( &
      & gthstnml = gthstnml, &               ! (in)
      & name = name, &                       ! (in)
      & file = file, &                       ! (out)
      & interval_unit = interval_unit, &     ! (out)
      & interval_value = interval_value )    ! (out)

    !-----------------------------------------------------------------
    !  HistoryCreate ˤե
    !  Files are created by "HistoryCreate"
    !-----------------------------------------------------------------
    call HistoryCreate( &
      &   history = gthist, &                                      ! (inout)
      &      file = file,         title = title, &                 ! (in)
      &    source = source, institution = institution, &           ! (in)
      &      dims = StoA( 'lon', 'lat', 'sig', 'sigm', 'time' ), & ! (in)
      &  dimsizes = (/ imax, jmax, kmax, kmax + 1, 0 /), &         ! (in)
      & longnames = StoA( 'longitude', 'latitude', &
      &                   'sigma at layer midpoints', &
      &                   'sigma at layer end-points (half level)', &
      &                   'time' ), &                              ! (in)
      &     units = StoA( 'degree_east', 'degree_north', &
      &                   '1', '1', interval_unit ), &             ! (in)
      &    origin = real( EvalbyUnit( current_time, &
      &                               interval_unit) ), &          ! (in)
      &  interval = interval_value )                               ! (in)

    call HistoryAddAttr( &
      & history = gthist, &                              ! (inout)
      & varname = 'lon', attrname = 'standard_name', &   ! (in)
      & value = 'longitude' )                            ! (in)
    call HistoryAddAttr( &
      & history = gthist, &                              ! (inout)
      & varname = 'lat', attrname = 'standard_name', &   ! (in)
      & value = 'latitude' )                             ! (in)
    call HistoryAddAttr( &
      & history = gthist, &                              ! (inout)
      & varname = 'sig', attrname = 'standard_name', &   ! (in)
      & value = 'atmosphere_sigma_coordinate' )          ! (in)
    call HistoryAddAttr( &
      & history = gthist, &                              ! (inout)
      & varname = 'sigm', attrname = 'standard_name', &  ! (in)
      & value = 'atmosphere_sigma_coordinate' )          ! (in)
    call HistoryAddAttr( &
      & history = gthist, &                              ! (inout)
      & varname = 'time', attrname = 'standard_name', &  ! (in)
      & value = 'time' )                                 ! (in)
    call HistoryAddAttr( &
      & history = gthist, &                              ! (inout)
      & varname = 'sig', attrname = 'positive', &        ! (in)
      & value = 'down' )                                 ! (in)
    call HistoryAddAttr( &
      & history = gthist, &                              ! (inout)
      & varname = 'sigm', attrname = 'positive', &       ! (in)
      & value = 'down' )                                 ! (in)

    call HistoryPut( &
      & history = gthist, &             ! (inout)
      & varname = 'lon', &              ! (in)
      & array = x_Lon / PI * 180.0_DP ) ! (in)
    call HistoryPut( &
      & history = gthist, &             ! (inout)
      & varname = 'lat', &              ! (in)
      & array = y_Lat / PI * 180.0_DP ) ! (in)
    call HistoryPut( &
      & history = gthist, &             ! (inout)
      & varname = 'sig', &              ! (in)
      & array = z_Sigma )               ! (in)
    call HistoryPut( & 
      & history = gthist, &             ! (inout)
      & varname = 'sigm', &             ! (in)
      & array = r_Sigma )               ! (in)

    call HistoryAddVariable( &
      & history = gthist, &                                 ! (inout)
      & varname = 'lon_weight', &                           ! (in)
      & dims = StoA('lon'), &                               ! (in)
      & longname = 'weight for integration in longitude', & ! (in)
      & units = 'radian', xtype = 'double' )                ! (in)
    call HistoryAddAttr( &
      & history = gthist, &                                 ! (inout)
      & varname = 'lon', attrname = 'gt_calc_weight', &     ! (in)
      & value = 'lon_weight' )                              ! (in)
    call HistoryPut( &
      & history = gthist, &                                 ! (inout)
      & varname = 'lon_weight', array = x_Lon_Weight )      ! (in)

    call HistoryAddVariable( &
      & history = gthist, &                                 ! (inout)
      & varname = 'lat_weight', &                           ! (in)
      & dims = StoA('lat'), &                               ! (in)
      & longname = 'weight for integration in latitude', &  ! (in)
      & units = 'radian', xtype = 'double' )                ! (in)
    call HistoryAddAttr( &
      & history = gthist, &                                 ! (inout)
      & varname = 'lat', attrname = 'gt_calc_weight', &     ! (in)
      & value = 'lat_weight' )                              ! (in)
    call HistoryPut( &
      & history = gthist, &                                 ! (inout)
      & varname = 'lat_weight', array = y_Lat_Weight )      ! (in)

    !-----------------------------------------------------------------
    !  HistoryAddVariable ˤѿ
    !  A variable is created by "HistoryAddVariable"
    !-----------------------------------------------------------------
    if ( HistoryInitialized( gthist ) ) then
      call HistoryAddVariable( &
        &  history = gthist, &                       ! (inout)
        &  varname = name,         dims = dims, &    ! (in)
        & longname = longname,    units = units, &   ! (in)
        &    xtype = precision, average = average )  ! (in)
    else
      nullify( gthist )
    end if

  end subroutine output_init

  subroutine history_output_inidata
    !
    ! ҥȥǡ () Ϥޤ. 
    !
    ! Output history data (initial). 
    !
    use gt4_history, only: HistoryPut
  continue

    gthstnml => gthstnml_history

    !-------------------------
    !  xyz_U ν
    !  Output "xyz_U"
    name = 'U'

    ! ϤΥå. 
    !   * gthist (gt4_history#GT_HISTORY), time (ñټ¿) ꤵ.
    ! Check for output.
    !   * "gthist" (gt4_history#GT_HISTORY), time (real) are configured.
    call output_check ! ֥롼. This is an internal subroutine

    if ( associated( gthist ) ) then
      call HistoryPut( &
        & history = gthist, &                   ! (inout)
        & varname = name, array = xyz_UN, &     ! (in)
        &    time = real( start_time_value ), & ! (in)
        &   quiet = .false. )                   ! (in)
    end if


    !-------------------------
    !  xyz_V ν
    !  Output "xyz_V"
    name = 'V'

    ! ϤΥå. 
    !   * gthist (gt4_history#GT_HISTORY), time (ñټ¿) ꤵ.
    ! Check for output.
    !   * "gthist" (gt4_history#GT_HISTORY), time (real) are configured.
    call output_check ! ֥롼. This is an internal subroutine

    if ( associated( gthist ) ) then
      call HistoryPut( &
        & history = gthist, &                   ! (inout)
        & varname = name, array = xyz_VN, &     ! (in)
        &    time = real( start_time_value ), & ! (in)
        &   quiet = .false. )                   ! (in)
    end if


    !-------------------------
    !  xyz_Vor ν
    !  Output "xyz_Vor"
    name = 'Vor'

    ! ϤΥå. 
    !   * gthist (gt4_history#GT_HISTORY), time (ñټ¿) ꤵ.
    ! Check for output.
    !   * "gthist" (gt4_history#GT_HISTORY), time (real) are configured.
    call output_check ! ֥롼. This is an internal subroutine

    if ( associated( gthist ) ) then
      call HistoryPut( &
        & history = gthist, &                   ! (inout)
        & varname = name, array = xyz_VorN, &   ! (in)
        &    time = real( start_time_value ), & ! (in)
        &   quiet = .false. )                   ! (in)
    end if


    !-------------------------
    !  xyz_Div ν
    !  Output "xyz_Div"
    name = 'Div'

    ! ϤΥå. 
    !   * gthist (gt4_history#GT_HISTORY), time (ñټ¿) ꤵ.
    ! Check for output.
    !   * "gthist" (gt4_history#GT_HISTORY), time (real) are configured.
    call output_check ! ֥롼. This is an internal subroutine

    if ( associated( gthist ) ) then
      call HistoryPut( &
        & history = gthist, &                   ! (inout)
        & varname = name, array = xyz_DivN, &   ! (in)
        &    time = real( start_time_value ), & ! (in)
        &   quiet = .false. )                   ! (in)
    end if


    !-------------------------
    !  xyz_Temp ν
    !  Output "xyz_Temp"
    name = 'Temp'

    ! ϤΥå. 
    !   * gthist (gt4_history#GT_HISTORY), time (ñټ¿) ꤵ.
    ! Check for output.
    !   * "gthist" (gt4_history#GT_HISTORY), time (real) are configured.
    call output_check ! ֥롼. This is an internal subroutine

    if ( associated( gthist ) ) then
      call HistoryPut( &
        & history = gthist, &                   ! (inout)
        & varname = name, array = xyz_TempN, &  ! (in)
        &    time = real( start_time_value ), & ! (in)
        &   quiet = .false. )                   ! (in)
    end if


    !-------------------------
    !  xyz_QVap ν
    !  Output "xyz_QVap"
    name = 'QVap'

    ! ϤΥå. 
    !   * gthist (gt4_history#GT_HISTORY), time (ñټ¿) ꤵ.
    ! Check for output.
    !   * "gthist" (gt4_history#GT_HISTORY), time (real) are configured.
    call output_check ! ֥롼. This is an internal subroutine

    if ( associated( gthist ) ) then
      call HistoryPut( &
        & history = gthist, &                   ! (inout)
        & varname = name, array = xyz_QVapN, &  ! (in)
        &    time = real( start_time_value ), & ! (in)
        &   quiet = .false. )                   ! (in)
    end if


    !-------------------------
    !  xyz_Ps ν
    !  Output "xyz_Ps"
    name = 'Ps'

    ! ϤΥå. 
    !   * gthist (gt4_history#GT_HISTORY), time (ñټ¿) ꤵ.
    ! Check for output.
    !   * "gthist" (gt4_history#GT_HISTORY), time (real) are configured.
    call output_check ! ֥롼. This is an internal subroutine

    if ( associated( gthist ) ) then
      call HistoryPut( &
        & history = gthist, &                   ! (inout)
        & varname = name, array = xy_PsN, &     ! (in)
        &    time = real( start_time_value ), & ! (in)
        &   quiet = .false. )                   ! (in)
    end if

    nullify( gthstnml )
  end subroutine history_output_inidata

  subroutine history_output
    !
    ! ҥȥǡϤޤ. 
    !
    ! Output history data. 
    !
    use gt4_history, only: HistoryPut
  continue

    gthstnml => gthstnml_history

    !-------------------------
    !  xyz_U ν
    !  Output "xyz_U"
    name = 'U'

    ! ϤΥå. 
    !   * gthist (gt4_history#GT_HISTORY), time (ñټ¿) ꤵ.
    ! Check for output.
    !   * "gthist" (gt4_history#GT_HISTORY), time (real) are configured.
    call output_check ! ֥롼. This is an internal subroutine

    if ( associated( gthist ) ) then
      call HistoryPut( &
        & history = gthist, &               ! (inout)
        & varname = name, array = xyz_UA, & ! (in)
        & time = time, quiet = .false. )    ! (in)
    end if


    !-------------------------
    !  xyz_V ν
    !  Output "xyz_V"
    name = 'V'

    ! ϤΥå. 
    !   * gthist (gt4_history#GT_HISTORY), time (ñټ¿) ꤵ.
    ! Check for output.
    !   * "gthist" (gt4_history#GT_HISTORY), time (real) are configured.
    call output_check ! ֥롼. This is an internal subroutine

    if ( associated( gthist ) ) then
      call HistoryPut( &
        & history = gthist, &               ! (inout)
        & varname = name, array = xyz_VA, & ! (in)
        & time = time, quiet = .false. )    ! (in)
    end if


    !-------------------------
    !  xyz_Vor ν
    !  Output "xyz_Vor"
    name = 'Vor'

    ! ϤΥå. 
    !   * gthist (gt4_history#GT_HISTORY), time (ñټ¿) ꤵ.
    ! Check for output.
    !   * "gthist" (gt4_history#GT_HISTORY), time (real) are configured.
    call output_check ! ֥롼. This is an internal subroutine

    if ( associated( gthist ) ) then
      call HistoryPut( &
        & history = gthist, &                 ! (inout)
        & varname = name, array = xyz_VorA, & ! (in)
        & time = time, quiet = .false. )      ! (in)
    end if


    !-------------------------
    !  xyz_Div ν
    !  Output "xyz_Div"
    name = 'Div'

    ! ϤΥå. 
    !   * gthist (gt4_history#GT_HISTORY), time (ñټ¿) ꤵ.
    ! Check for output.
    !   * "gthist" (gt4_history#GT_HISTORY), time (real) are configured.
    call output_check ! ֥롼. This is an internal subroutine

    if ( associated( gthist ) ) then
      call HistoryPut( &
        & history = gthist, &                 ! (inout)
        & varname = name, array = xyz_DivA, & ! (in)
        & time = time, quiet = .false. )      ! (in)
    end if


    !-------------------------
    !  xyz_Temp ν
    !  Output "xyz_Temp"
    name = 'Temp'

    ! ϤΥå. 
    !   * gthist (gt4_history#GT_HISTORY), time (ñټ¿) ꤵ.
    ! Check for output.
    !   * "gthist" (gt4_history#GT_HISTORY), time (real) are configured.
    call output_check ! ֥롼. This is an internal subroutine

    if ( associated( gthist ) ) then
      call HistoryPut( &
        & history = gthist, &                  ! (inout)
        & varname = name, array = xyz_TempA, & ! (in)
        & time = time, quiet = .false. )       ! (in)
    end if


    !-------------------------
    !  xyz_QVap ν
    !  Output "xyz_QVap"
    name = 'QVap'

    ! ϤΥå. 
    !   * gthist (gt4_history#GT_HISTORY), time (ñټ¿) ꤵ.
    ! Check for output.
    !   * "gthist" (gt4_history#GT_HISTORY), time (real) are configured.
    call output_check ! ֥롼. This is an internal subroutine

    if ( associated( gthist ) ) then
      call HistoryPut( &
        & history = gthist, &                  ! (inout)
        & varname = name, array = xyz_QVapA, & ! (in)
        & time = time, quiet = .false. )       ! (in)
    end if


    !-------------------------
    !  xyz_Ps ν
    !  Output "xyz_Ps"
    name = 'Ps'

    ! ϤΥå. 
    !   * gthist (gt4_history#GT_HISTORY), time (ñټ¿) ꤵ.
    ! Check for output.
    !   * "gthist" (gt4_history#GT_HISTORY), time (real) are configured.
    call output_check ! ֥롼. This is an internal subroutine

    if ( associated( gthist ) ) then
      call HistoryPut( &
        & history = gthist, &               ! (inout)
        & varname = name, array = xy_PsA, & ! (in)
        & time = time, quiet = .false. )    ! (in)
    end if

    nullify( gthstnml )
  end subroutine history_output

  subroutine restart_output
    !
    ! ꥹȥǡϤޤ. 
    !
    ! Output restart data. 
    !
    use gt4_history_nmlinfo, only: HstNmlInfoAssocGtHist
    use gt4_history, only: HistoryPut, HistorySetTime
    type(DC_DIFFTIME):: restart_interval_time
                              ! ꥹȥǡνϴֳ. 
                              ! Interval of restart data output
  continue
    nullify( gthist )
    gthstnml => gthstnml_restart
    name = 'Temp'

    !-----------------------------------------------------------------
    !  ϥƥåפΥå
    !  Check output step
    !-----------------------------------------------------------------
    call DCDiffTimeCreate( &
      &  diff = restart_interval_time, &              ! (out)
      & value = real( restart_interval_value, DP ), & ! (in)
      &  unit = restart_interval_unit)                ! (in)

    if ( .not. mod( current_time + delta_time, &
      &             restart_interval_time     ) == 0 ) then
      return
    end if

    call HstNmlInfoAssocGtHist( &
      & gthstnml = gthstnml, &   ! (in)
      & name = name, &           ! (in)
      & history = gthist )       ! (out)

    !-----------------------------------------------------------------
    !  ƥå $ t $ ν
    !  Output at step $ t $
    !-----------------------------------------------------------------
    call HistorySetTime( &
      & history = gthist, &                                ! (inout)
      & time = real( EvalbyUnit(current_time, &
      &                         restart_interval_unit) ) ) ! (in)

    call HistoryPut( &
      & history = gthist, &                   ! (inout)
      & varname = 'U', array = xyz_UN )       ! (in)
    call HistoryPut( &
      & history = gthist, &                   ! (inout)
      & varname = 'V', array = xyz_VN )       ! (in)
    call HistoryPut( &
      & history = gthist, &                   ! (inout)
      & varname = 'Temp', array = xyz_TempN ) ! (in)
    call HistoryPut( &
      & history = gthist, &                   ! (inout)
      & varname = 'QVap', array = xyz_QVapN ) ! (in)
    call HistoryPut( &
      & history = gthist, &                   ! (inout)
      & varname = 'Ps', array = xy_PsN )      ! (in)

    !-----------------------------------------------------------------
    !  ƥå $ t + \Delta t $ ν
    !  Output at step $ t + \Delta t $
    !-----------------------------------------------------------------
    call HistorySetTime( &
      & history = gthist, &                                ! (inout)
      & time = real( EvalbyUnit(current_time + delta_time, &
      &                         restart_interval_unit) ) ) ! (in)

    call HistoryPut( &
      & history = gthist, &                   ! (inout)
      & varname = 'U', array = xyz_UA )       ! (in)
    call HistoryPut( &
      & history = gthist, &                   ! (inout)
      & varname = 'V', array = xyz_VA )       ! (in)
    call HistoryPut( &
      & history = gthist, &                   ! (inout)
      & varname = 'Temp', array = xyz_TempA ) ! (in)
    call HistoryPut( &
      & history = gthist, &                   ! (inout)
      & varname = 'QVap', array = xyz_QVapA ) ! (in)
    call HistoryPut( &
      & history = gthist, &                   ! (inout)
      & varname = 'Ps', array = xy_PsA )      ! (in)

    nullify( gthstnml )
    nullify( gthist )

    !-----------------------------------------------------------------
    !  եϤ˴ؤƥåɽ
    !  Print message of file output
    !-----------------------------------------------------------------
    call MessageNotify( 'M', subname, &
      & 'Restart data => "%c" (time=%f, %f %a)', &
      & d=(/ EvalbyUnit(current_time, &
      &                 restart_interval_unit), &
      &      EvalbyUnit(current_time + delta_time, &
      &                 restart_interval_unit) /), &
      & ca=StoA( trim(restart_interval_unit) ), &
      & c1=trim(restart_filename) )
  end subroutine restart_output

  subroutine output_check
    !
    ! ѿ *name* Ϥ뤫ɤåޤ. 
    ! Ϥ˴ؤ gthstnml Фޤ. 
    !
    ! ѿ *name* ˴ؤƽϤ褦ꤵƤˤ, 
    ! *gthist* ˽ե gt4_history#GT_HISTORY
    ! ѿ礵ޤ. Ǥʤ, *gthist* ֤ˤޤ. 
    !
    ! ޤ, ߻ *time* ꤷޤ. 
    !
    ! Check whether to output variable *name*. 
    ! Information about output is taken out of "gthstnml". 
    !
    ! When output is done for the variable *name*, *gthist* is 
    ! associated with "gt4_history#GT_HISTORY" variable of
    ! the output file. Otherwise, *gthist* is nullified. 
    !
    ! Moreover, current time is set to *time*. 
    !
    use gt4_history_nmlinfo, only: HstNmlInfoOutputValid, HstNmlInfoInquire, &
      & HstNmlInfoAssocGtHist
    use gt4_history, only: HistoryInitialized
    character(TOKEN):: interval_unit
                              ! ҥȥǡνϴֳ֤ñ. 
                              ! Unit for interval of history data output
  continue

    nullify( gthist )
    time = 0.0

    if ( HstNmlInfoOutputValid( gthstnml, name ) ) then
      call HstNmlInfoInquire( &
        & gthstnml = gthstnml, & ! (in)
        & name = name, &                           ! (in)
        & interval_unit = interval_unit )          ! (out)

      time = real( EvalbyUnit( current_time + delta_time, interval_unit ) )

      call HstNmlInfoAssocGtHist( & 
        & gthstnml = gthstnml, &  ! (in)
        & name = name, &          ! (in)
        & history = gthist )      ! (out)

      if ( .not. HistoryInitialized( gthist ) ) nullify( gthist )
    end if

  end subroutine output_check


  subroutine history_output_close
    !
    ! ҥȥǡϤνλԤޤ. 
    ! 
    ! History data output is terminated.
    !
    use gt4_history_nmlinfo, only: HstNmlInfoClose, HstNmlInfoNames, &
      & HstNmlInfoAssocGtHist, HstNmlInfoPutLine
    use gt4_history, only: HistoryInitialized, HistoryClose
    use dc_string, only: Split
    character(STRING):: varnames
                              ! ѿ̾ꥹ. 
                              ! List of variables
    character(TOKEN), pointer:: varnames_array(:) =>null()
                              ! ѿ̾ꥹ. 
                              ! List of variables (array) 
    integer:: i, vnmax
  continue
    gthstnml => gthstnml_history
    varnames = HstNmlInfoNames( gthstnml )
    call Split( str = varnames, sep = ',', & ! (in)
      & carray = varnames_array )            ! (out)
    vnmax = size( varnames_array )

    do i = 1, vnmax
      name = varnames_array(i)
      if ( trim( name ) == '' ) exit
      nullify( gthist )
      call HstNmlInfoAssocGtHist( & 
        & gthstnml = gthstnml, & ! (in)
        & name = name, &         ! (in)
        & history = gthist )     ! (out)
      if ( HistoryInitialized( gthist ) ) then

        call HistoryClose( history = gthist ) ! (inout)

        nullify( gthist )
      end if
    end do

    nullify( gthstnml )
  end subroutine history_output_close

  subroutine restart_output_close
    !
    ! ꥹȥǡϤνλԤޤ. 
    ! 
    ! Restart data output is terminated.
    !
    use gt4_history_nmlinfo, only: HstNmlInfoClose, HstNmlInfoNames, &
      & HstNmlInfoAssocGtHist, HstNmlInfoPutLine
    use gt4_history, only: HistoryInitialized, HistoryClose
    use dc_string, only: Split
    character(STRING):: varnames
                              ! ѿ̾ꥹ. 
                              ! List of variables
    character(TOKEN), pointer:: varnames_array(:) =>null()
                              ! ѿ̾ꥹ. 
                              ! List of variables (array) 
    integer:: i, vnmax
  continue
    gthstnml => gthstnml_restart
    varnames = HstNmlInfoNames( gthstnml )
    call Split( str = varnames, sep = ',', & ! (in)
      & carray = varnames_array )            ! (out)
    vnmax = size( varnames_array )

    do i = 1, vnmax
      name = varnames_array(i)
      if ( trim( name ) == '' ) exit
      nullify( gthist )
      call HstNmlInfoAssocGtHist( & 
        & gthstnml = gthstnml, & ! (in)
        & name = name, &         ! (in)
        & history = gthist )     ! (out)
      if ( HistoryInitialized( gthist ) ) then

        call HistoryClose( history = gthist ) ! (inout)

        nullify( gthist )
      end if
    end do

    nullify( gthstnml )
  end subroutine restart_output_close

end program dcpam_hs94

subroutine GTHistNmlRead( nmlfile, &
  & gthstnml, &
  & err )
  !
  ! NAMELIST ե *nmlfile* ͤϤ뤿
  ! ֥롼Ǥ. ꤷƤޤ. 
  !
  ! ͤ NAMELIST եǻꤵƤʤˤ, 
  ! Ϥ줿ͤΤޤ֤ޤ. 
  !
  ! ʤ, *nmlfile* ˶ʸͿ줿, ޤ
  ! Ϳ줿 *nmlfile* ɤ߹ळȤǤʤ, 
  ! ץϥ顼ȯޤ. 
  !
  ! This is a subroutine to input values from 
  ! NAMELIST file *nmlfile*. 
  !
  ! A value not specified in NAMELIST file is returned 
  ! without change. 
  !
  ! If *nmlfile* is empty, or *nmlfile* can not be read, 
  ! error is occurred. 
  !
  use dc_trace, only: BeginSub, EndSub
  use dc_string, only: PutLine, Printf, Split, StrInclude, StoA, JoinChar
  use dc_types, only: DP, STRING, TOKEN, STDOUT
  use dc_iounit, only: FileOpen
  use dc_message, only: MessageNotify
  use dc_present, only: present_and_true
  use dc_date, only: DCDiffTimeCreate
  use dc_error, only: StoreError, DC_NOERR, DC_ENOFILEREAD, DC_ENOTINIT
  use gt4_history_nmlinfo, only: GTHST_NMLINFO, HstNmlInfoAdd, &
    & HstNmlInfoInquire, HstNmlInfoInitialized, HstNmlInfoPutLine
  implicit none
  character(*), intent(in):: nmlfile
                            ! NAMELIST ե̾. 
                            ! NAMELIST file name

  type(GTHST_NMLINFO), intent(inout):: gthstnml
                            ! NAMELIST#dcpam_hs94_history_nml 
                            ! ꤵ̤ΥǡϾ. 
                            ! 
                            ! ǥեͤʤɤ
                            ! ԤäͿ뤳. 
                            ! 
                            ! Individual data output information from 
                            ! "NAMELIST#dcpam_hs94_history_nml". 
                            ! 
                            ! Before this argument is given to 
                            ! this procedure, initialize and 
                            ! configure the defaut settings. 
  logical, intent(out), optional:: err
                            ! 㳰ѥե饰. 
                            ! ǥեȤǤ, μ³ǥ顼
                            ! , ץ϶λޤ. 
                            !  *err* Ϳ, 
                            ! ץ϶λ, 
                            ! *err*  .true. ޤ. 
                            !
                            ! Exception handling flag. 
                            ! By default, when error occur in 
                            ! this procedure, the program aborts. 
                            ! If this *err* argument is given, 
                            ! .true. is substituted to *err* and 
                            ! the program does not abort. 

  character(STRING):: name
                            ! ѿ̾. 
                            ! ξˤ, ¾ͤ
                            ! dcmodel_sample_code ⥸塼ˤ
                            ! ϤǡƤ
                            ! ǥեͤȤʤޤ. 
                            ! 
                            ! "Data1,Data2" Τ褦˥ޤǶڤäʣ
                            ! ѿꤹ뤳ȤǽǤ. 
                            ! 
                            ! Variable identifier. 
                            ! If blank is given, other values are 
                            ! used as default values of output data 
                            ! in "dcmodel_sample_code". 
                            ! 
                            ! Multiple variables can be specified 
                            ! as "Data1,Data2" too. Delimiter is comma. 
  character(STRING):: file
                            ! ϥե̾. 
                            ! ϥǥեͤȤƤϻѤޤ. 
                            ! *name* ͤꤵƤΤͭǤ. 
                            ! 
                            ! Output file name. 
                            ! This is not used as default value. 
                            ! This value is valid only when *name* is 
                            ! specified. 

  real:: interval_value
                            ! ҥȥǡνϴֳ֤ο. 
                            ! ͤͿ, Ϥ޻ߤޤ. 
                            ! Numerical value for interval of history data output
                            ! Negative values suppresses output.
  character(TOKEN):: interval_unit
                            ! ҥȥǡνϴֳ֤ñ. 
                            ! Unit for interval of history data output
  character(TOKEN):: precision
                            ! ҥȥǡ. 
                            ! Precision of history data
  logical:: average
                            ! ϥǡʿѲե饰. 
                            ! Flag for average of output data
  character(STRING):: fileprefix
                            ! ҥȥǡΥե̾Ƭ. 
                            ! Prefixes of history data filenames

  namelist /dcpam_hs94_history_nml/ &
    & name, &
    & file, &
    & interval_value, &
    & interval_unit, &
    & precision, &
    & fileprefix, &
    & average
                            ! ҥȥǡ NAMELIST ѿ̾. 
                            !
                            ! ץμ¹Ի˥ޥɥ饤
                            ! -N ޤ --namelist ˥ե̾
                            ! ꤹ뤳Ȥ, Υե뤫
                            !  NAMELIST ѿɤ߹ߤޤ. 
                            !
                            ! NAMELIST group name for history data. 
                            ! 
                            ! If a NAMELIST filename is specified to 
                            ! command line options '-N' or '--namelist' 
                            ! this NAMELIST group is loaded from 
                            ! the file. 

  !-----------------------------------
  !  ѿ
  !  Work variables
  integer:: stat
  character(STRING):: cause_c
  integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                            ! Unit number for NAMELIST file open
  integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
                            ! IOSTAT of NAMELIST read
  character(TOKEN):: pos_nml
                            ! NAMELIST ɤ߹߻Υե. 
                            ! File position of NAMELIST read
  character(*), parameter:: subname = 'GTHistNmlRead'
continue
  call BeginSub( subname )
  stat = DC_NOERR
  cause_c = ''

  !-----------------------------------------------------------------
  !  Υå
  !  Check initialization
  !-----------------------------------------------------------------

  !----------------------------------------------------------------
  !  NAMELIST եΥץ
  !  Open NAMELIST file
  !----------------------------------------------------------------
  call FileOpen( unit = unit_nml, & ! (out)
    & file = nmlfile, mode = 'r', & ! (in)
    & err = err )                   ! (out)
  if ( present_and_true(err) ) then
    stat = DC_ENOFILEREAD
    cause_c = nmlfile
    goto 999
  end if

  !-----------------------------------------------------------------
  !  NAMELIST ѿμ
  !  Get NAMELIST group
  !-----------------------------------------------------------------

  !-------------------------
  !  ϥǡθ̾μ
  !  Get individual information of output data
  rewind( unit_nml )
  iostat_nml = 0
  pos_nml = ''
  do while ( trim(pos_nml) /= 'APPEND' .and. iostat_nml == 0 )

    name                   = ''
    file                   = ''
    call HstNmlInfoInquire( &
      & gthstnml = gthstnml, &             ! (in)
      & interval_value = interval_value, & ! (out)
      & interval_unit = interval_unit, &   ! (out)
      & precision = precision, &           ! (out)
      & average = average, &               ! (out)
      & fileprefix = fileprefix )          ! (out)

    read( unit = unit_nml, & ! (in)
      & nml = dcpam_hs94_history_nml, iostat = iostat_nml ) ! (out)
    inquire( unit_nml, &     ! (in)
      & position = pos_nml ) ! (out)

    if ( iostat_nml == 0 ) then
      call MessageNotify( 'M', subname, &
        & 'NAMELIST group "%c" is loaded from "%c".', &
        & c1='dcpam_hs94_history_nml', c2=trim(nmlfile) )
      write(STDOUT, nml = dcpam_hs94_history_nml)

      call HstNmlInfoAdd( &
        & gthstnml = gthstnml, &             ! (in)
        & name = name, &                     ! (in)
        & file = file, &                     ! (in)
        & interval_value = interval_value, & ! (in)
        & interval_unit = interval_unit, &   ! (in)
        & precision = precision, &           ! (in)
        & average = average, &               ! (in)
        & fileprefix = fileprefix )          ! (in)

    else
      call MessageNotify( 'W', subname, &
        & 'NAMELIST group "%c" is not found in "%c" any more (iostat=%d).', &
        & c1='dcpam_hs94_history_nml', c2=trim(nmlfile), &
        & i = (/iostat_nml/) )
    end if
  end do

  close( unit_nml )

  !-----------------------------------------------------------------
  !  λ, 㳰
  !  Termination and Exception handling
  !-----------------------------------------------------------------
999 continue
  call StoreError( stat, subname, err, cause_c )
  call EndSub( subname )

end subroutine GTHistNmlRead

