!= ˡˤʬ
!
!= Time integration with implicit scheme
!
! Authors::   Yukiko YAMADA, Yasuhiro MORIKAWA
! Version::   $Id: phy_implicit.f90,v 1.6 2007-10-12 01:01:55 morikawa Exp $
! Tag Name::  $Name: dcpam4-20080427 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]   
!

module phy_implicit
  !
  != ˡˤʬ
  !
  != Time integration with implicit scheme
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  !== Procedures List
  !
  ! Create        :: PHYIMPL ѿν
  ! Close         :: PHYIMPL ѿνλ
  ! PutLine       :: PHYIMPL ѿ˳ǼƤΰ
  ! initialized   :: PHYIMPL ѿꤵƤ뤫ݤ
  ! GetMatrices   :: κȼ
  ! Integrate     :: ѲΨη׻
  ! ------------  :: ------------
  ! Create        :: Constructor of "PHYIMPL"
  ! Close         :: Deconstructor of "PHYIMPL"
  ! PutLine       :: Print information of "PHYIMPL"
  ! initialized   :: Check initialization of "PHYIMPL"
  ! GetMatrices   :: Create and get implicit matrices
  ! Integrate     :: Calculate tendency
  !
  !== Usage
  !
  ! Ϥ, PHYIMPL ѿ, Create ǽԤޤ.
  ! GetMatrices ѤƱκȼԤ, 
  ! Integrate ǻѲΨη׻Ԥޤ. 
  ! PHYIMPL ѿνλˤ Close ѤƤ.
  !
  ! First, initialize "PHYIMPL" by "Create".
  ! Create and get implicit matrices by "GetMatrices", 
  ! and calculate tendency by "Integrate".
  ! In order to terminate "PHYIMPL", use "Close".
  !

  use dc_types, only: DP, TOKEN
  implicit none
  private
  public:: PHYIMPL, Create, Close, PutLine, initialized
  public:: GetMatrices, Integrate

  type PHYIMPL
    !
    ! ޤ, Create  "PHYIMPL" ѿꤷƲ.
    ! ꤵ줿 "PHYIMPL" ѿѤݤˤ,
    ! Close ˤäƽλԤäƤ.
    !
    ! Initialize "PHYIMPL" variable by "Create" before usage.
    ! If you reuse "PHYIMPL" variable again for another application, 
    ! terminate by "Close".
    !
    logical:: initialized = .false.     ! ե饰. 
                                        ! Initialization flag
    integer:: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer:: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level
    real(DP):: Grav      ! $ g $ .      ϲ®.     Gravitational acceleration
    real(DP):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP):: EL        ! $ L $ .      ζŷǮ. Latent heat of condensation of water vapor
    real(DP):: DelTime    ! $ \Delta t $ . ॹƥå. Time step
    real(DP), pointer:: xy_SurfHeatCapacity (:,:) =>null()
                              ! ɽǮ. 
                              ! Surface heat capacity
    integer, pointer:: xy_SurfCondition (:,:) =>null()
                              ! ɽ. 
                              ! Surface condition

    real(DP), pointer:: xy_GroundTempFlux (:,:) =>null()
                              ! Ǯեå. 
                              ! Ground temperature flux

  end type PHYIMPL

  character(*), parameter:: version = &
    & '$Name: dcpam4-20080427 $' // &
    & '$Id: phy_implicit.f90,v 1.6 2007-10-12 01:01:55 morikawa Exp $'

  interface Create
    module procedure PhyImplicitCreate
  end interface

  interface Close
    module procedure PhyImplicitClose
  end interface

  interface PutLine
    module procedure PhyImplicitPutLine
  end interface

  interface initialized
    module procedure PhyImplicitInitialized
  end interface

  interface NmlRead
    module procedure PhyImplicitNmlRead
  end interface

  interface GetMatrices
    module procedure PhyImplicitGetMatrices
  end interface

  interface Integrate
    module procedure PhyImplicitIntegrate
  end interface

!!$  interface LUDecomp3
!!$    module procedure PhyImplicitLUDecomp3
!!$  end interface
!!$
!!$  interface LUSolve3
!!$    module procedure PhyImplicitLUSolve3
!!$  end interface

!!$  interface Sample
!!$    module procedure PhyImplicitSample
!!$  end interface

contains

  subroutine PhyImplicitCreate( phy_impl, &
    & imax, jmax, kmax, &
    & Grav, Cp, EL, &
    & DelTime, &
    & xy_SurfHeatCapacity, &
    & xy_SurfCondition, &
    & xy_GroundTempFlux, &
    & nmlfile, err )
    !
    ! PHYIMPL ѿνԤޤ.
    ! ¾Υ֥롼ѤɬΥ֥롼ˤä
    ! PHYIMPL ѿꤷƤ.
    !
    ! ʤ, Ϳ줿 *phy_impl* ˽ꤵƤ,
    ! ץϥ顼ȯޤ.
    !
    ! NAMELIST Ѥˤϰ *nmlfile*  NAMELIST ե̾
    ! ͿƤ. NAMELIST ѿξܺ٤˴ؤƤ 
    ! NAMELIST#phy_implicit_nml 򻲾ȤƤ. 
    !
    ! Constructor of "PHYIMPL".
    ! Initialize *phy_impl* by this subroutine, 
    ! before other procedures are used, 
    !
    ! Note that if *phy_impl* is already initialized 
    ! by this procedure, error is occurred.
    !
    ! In order to use NAMELIST, specify a NAMELIST filename to 
    ! argument *nmlfile*. See "NAMELIST#phy_implicit_nml"
    ! for details about a NAMELIST group.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_present, only: present_and_not_empty, present_and_true
    use dc_message, only: MessageNotify
    use dc_error, only: StoreError, DC_NOERR, DC_EALREADYINIT, &
      & DC_EARGLACK, DC_ENEGATIVE, DC_ENOFILEREAD
    implicit none
    type(PHYIMPL), intent(inout):: phy_impl
    integer, intent(in):: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer, intent(in):: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    integer, intent(in):: kmax ! ľؿ. 
                   ! Number of vertical level
    real(DP), intent(in):: Grav      ! $ g $ .      ϲ®.     Gravitational acceleration
    real(DP), intent(in):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP), intent(in):: EL        ! $ L $ .      ζŷǮ. Latent heat of condensation of water vapor
    real(DP), intent(in):: DelTime    ! $ \Delta t $ . ॹƥå. Time step
    real(DP), intent(in):: xy_SurfHeatCapacity (0:imax-1, 0:jmax-1)
                              ! ɽǮ. 
                              ! Surface heat capacity
    integer, intent(in):: xy_SurfCondition (0:imax-1, 0:jmax-1)
                              ! ɽ. 
                              ! Surface condition
    real(DP), intent(in):: xy_GroundTempFlux (0:imax-1, 0:jmax-1)
                              ! Ǯեå. 
                              ! Ground temperature flux
    character(*), intent(in), optional:: nmlfile
                              ! NAMELIST ե̾. 
                              ! ΰ˶ʸʳͿ, 
                              ! ꤵ줿ե뤫 
                              ! NAMELIST ѿɤ߹ߤޤ. 
                              ! եɤ߹ʤˤϥ顼
                              ! ޤ.
                              !
                              ! NAMELIST ѿξܺ٤˴ؤƤ 
                              ! NAMELIST#phy_implicit_nml 
                              ! 򻲾ȤƤ. 
                              !
                              ! NAMELIST file name. 
                              ! If nonnull character is specified to
                              ! this argument, 
                              ! NAMELIST group name is loaded from the 
                              ! file. 
                              ! If the file can not be read, 
                              ! an error occurs.
                              ! 
                              ! See "NAMELIST#phy_implicit_nml" 
                              ! for details about a NAMELIST group.
                              ! 
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyImplicitCreate'
  continue
    call BeginSub( subname, version )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( phy_impl % initialized ) then
      stat = DC_EALREADYINIT
      cause_c = 'PHYIMPL'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  Υå
    !  Validate arguments
    !-----------------------------------------------------------------
    if (imax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'imax'
      goto 999
    end if
    if (jmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'jmax'
      goto 999
    end if
    if (kmax < 1) then
      stat = DC_ENEGATIVE
      cause_c = 'kmax'
      goto 999
    end if
    if (DelTime < 0.0_DP) then
      stat = DC_ENEGATIVE
      cause_c = 'DelTime'
      goto 999
    end if

    
    !-----------------------------------------------------------------
    !  "PHYIMPL" 
    !  Configure the settings for "PHYIMPL"
    !-----------------------------------------------------------------
    phy_impl % imax    = imax   
    phy_impl % jmax    = jmax   
    phy_impl % kmax    = kmax   
    phy_impl % Grav    = Grav   
    phy_impl % Cp      = Cp     
    phy_impl % EL      = EL     
    phy_impl % DelTime = DelTime

    allocate( phy_impl % xy_SurfHeatCapacity (0:imax-1, 0:jmax-1) )
    allocate( phy_impl % xy_SurfCondition (0:imax-1, 0:jmax-1) )
    allocate( phy_impl % xy_GroundTempFlux (0:imax-1, 0:jmax-1) )
    phy_impl % xy_SurfHeatCapacity = xy_SurfHeatCapacity
    phy_impl % xy_SurfCondition = xy_SurfCondition
    phy_impl % xy_GroundTempFlux = xy_GroundTempFlux

    !-------------------------
    !  ǥե
    !  Default values
!!$    phy_impl % param_r = 0.0_DP
!!$    phy_impl % param_c = 'hogehoge'

    !-------------------------
    !  ץʥ
    !  Values from optional arguments
!!$    phy_impl % param_i = param_i
!!$    if ( present(param_r) )  phy_impl % param_r = param_r
!!$    if ( present(param_c) )  phy_impl % param_c = param_c

    !-------------------------
    !  NAMELIST 
    !  Values from NAMELIST

!!$    if ( present_and_not_empty(nmlfile) ) then
!!$      call MessageNotify( 'M', subname, &
!!$        & 'Loading NAMELIST file "%c" ...', &
!!$        & c1 = trim(nmlfile) )
!!$      call NmlRead ( nmlfile = nmlfile, &      ! (in)
!!$        & param_i = phy_impl % param_i, &   ! (inout)
!!$        & param_r = phy_impl % param_r, &   ! (inout)
!!$        & param_c_ = phy_impl % param_c, &  ! (inout)
!!$        & err = err )                          ! (out)
!!$      if ( present_and_true(err) ) then
!!$        call MessageNotify( 'W', subname, &
!!$          & '"%c" can not be read.', &
!!$          & c1 = trim(nmlfile) )
!!$        stat = DC_ENOFILEREAD
!!$        cause_c = nmlfile
!!$        goto 999
!!$      end if
!!$    end if

    !-----------------------------------------------------------------
    !  ͤΥå
    !  Validate setting values
    !-----------------------------------------------------------------
!!$    if ( phy_impl % param_i < 0 ) then
!!$      stat = DC_ENEGATIVE
!!$      cause_c = 'param_i'
!!$      goto 999
!!$    end if


    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    phy_impl % initialized = .true.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyImplicitCreate

  subroutine PhyImplicitClose( phy_impl, err )
    !
    ! PHYIMPL ѿνλԤޤ.
    ! ʤ, Ϳ줿 *phy_impl*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Deconstructor of "PHYIMPL".
    ! Note that if *phy_impl* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYIMPL), intent(inout):: phy_impl
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyImplicitClose'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_impl % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYIMPL'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  "PHYIMPL" ξõ
    !  Clear the settings for "PHYIMPL"
    !-----------------------------------------------------------------
    deallocate( phy_impl % xy_SurfHeatCapacity )
    deallocate( phy_impl % xy_SurfCondition )
    deallocate( phy_impl % xy_GroundTempFlux )

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    phy_impl % initialized = .false.
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyImplicitClose

  subroutine PhyImplicitPutLine( phy_impl, unit, indent, err )
    !
    !  *phy_impl* ꤵƤޤ.
    ! ǥեȤǤϥåɸϤ˽Ϥޤ. 
    ! *unit* ֹꤹ뤳Ȥ, ѹ뤳ȤǽǤ.
    !
    ! Print information of *phy_impl*.
    ! By default messages are output to standard output.
    ! Unit number for output can be changed by *unit* argument.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYIMPL), intent(in):: phy_impl
    integer, intent(in), optional:: unit
                              ! ֹ.
                              ! ǥեȤνɸ.
                              !
                              ! Unit number for output.
                              ! Default value is standard output.
    character(*), intent(in), optional:: indent
                              ! ɽåλ.
                              !
                              ! Indent of displayed messages.
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: out_unit
    integer:: indent_len
    character(STRING):: indent_str
    character(*), parameter:: subname = 'PhyImplicitPutLine'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( present(unit) ) then
      out_unit = unit
    else
      out_unit = STDOUT
    end if

    indent_len = 0
    indent_str = ''
    if ( present(indent) ) then
      if ( len(indent) /= 0 ) then
        indent_len = len(indent)
        indent_str(1:indent_len) = indent
      end if
    end if


    !-----------------------------------------------------------------
    !  "PHYIMPL" ΰ
    !  Print the settings for "PHYIMPL"
    !-----------------------------------------------------------------
    if ( phy_impl % initialized ) then
      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '#<PHYIMPL:: @initialized=%y', &
        & l = (/phy_impl % initialized/) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @imax=%d @jmax=%d @kmax=%d', &
        & i = (/phy_impl % imax, phy_impl % jmax, phy_impl % kmax/) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @Grav=%f @Cp=%f @EL=%f', &
        & d = (/ phy_impl % Grav, phy_impl % Cp, phy_impl % EL /) )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & ' @DelTime=%f', &
        & d = (/ phy_impl % DelTime /) )

      call PutLine( phy_impl % xy_SurfHeatCapacity, unit = out_unit, &
        & lbounds = lbound(phy_impl % xy_SurfHeatCapacity), &
        & ubounds = ubound(phy_impl % xy_SurfHeatCapacity), &
        & indent = indent_str(1:indent_len) // &
        & ' @xy_SurfHeatCapacity=' )

      call PutLine( phy_impl % xy_SurfCondition, unit = out_unit, &
        & lbounds = lbound(phy_impl % xy_SurfCondition), &
        & ubounds = ubound(phy_impl % xy_SurfCondition), &
        & indent = indent_str(1:indent_len) // &
        & ' @xy_SurfCondition=' )

      call PutLine( phy_impl % xy_GroundTempFlux, unit = out_unit, &
        & lbounds = lbound(phy_impl % xy_GroundTempFlux), &
        & ubounds = ubound(phy_impl % xy_GroundTempFlux), &
        & indent = indent_str(1:indent_len) // &
        & ' @xy_GroundTempFlux=' )

      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '>' )
    else
      call Printf( out_unit, &
        & indent_str(1:indent_len) // &
        & '#<PHYIMPL:: @initialized=%y>', &
        & l = (/phy_impl % initialized/) )
    end if

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyImplicitPutLine

  logical function PhyImplicitInitialized( phy_impl ) result(result)
    !
    ! *phy_impl* ꤵƤˤ .true. ,
    ! ꤵƤʤˤ .false. ֤ޤ.
    !
    ! If *phy_impl* is initialized, .true. is returned.
    ! If *phy_impl* is not initialized, .false. is returned.
    !
    implicit none
    type(PHYIMPL), intent(in):: phy_impl
  continue
    result = phy_impl % initialized
  end function PhyImplicitInitialized

  subroutine PhyImplicitNmlRead( nmlfile, &
!!$    & param_i, param_r, param_c_, &
    & err )
    !
    ! NAMELIST ե *nmlfile* ͤϤ뤿
    ! ֥롼Ǥ. Create ǸƤӽФ뤳Ȥ
    ! ꤷƤޤ.
    !
    ! ͤ NAMELIST եǻꤵƤʤˤ,
    ! Ϥ줿ͤΤޤ֤ޤ.
    !
    ! ʤ, *nmlfile* ˶ʸͿ줿, ޤ
    ! Ϳ줿 *nmlfile* ɤ߹ळȤǤʤ, 
    ! ץϥ顼ȯޤ.
    !
    ! This is an internal subroutine to input values from 
    ! NAMELIST file *nmlfile*. This subroutine is expected to be
    ! called by "Create".
    !
    ! A value not specified in NAMELIST file is returned
    ! without change.
    !
    ! If *nmlfile* is empty, or *nmlfile* can not be read, 
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_iounit, only: FileOpen
    use dc_message, only: MessageNotify
    use dc_present, only: present_and_true
    use dc_error, only: StoreError, DC_NOERR, DC_ENOFILEREAD
    implicit none
    character(*), intent(in):: nmlfile
                              ! NAMELIST ե̾. 
                              ! NAMELIST file name
!!$    integer, intent(inout):: param_i
!!$    real(DP), intent(inout):: param_r
!!$    character(*), intent(inout):: param_c_
!!$    character(TOKEN):: param_c
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

!!$    namelist /phy_implicit_nml/ &
!!$      & param_i, param_r, param_c
                              ! phy_implicit ⥸塼
                              ! NAMELIST ѿ̾.
                              !
                              ! phy_implicit#Create Ѥݤ, 
                              ! ץʥ *nmlfile*  NAMELIST 
                              ! ե̾ꤹ뤳Ȥ, Υե뤫
                              !  NAMELIST ѿɤ߹ߤޤ.
                              !
                              ! NAMELIST group name for 
                              ! "phy_implicit" module.
                              ! 
                              ! If a NAMELIST filename is specified to 
                              ! an optional argument *nmlfile* 
                              ! when "phy_implicit#Create" is used, 
                              ! this NAMELIST group is loaded from 
                              ! the file.

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: stat
    character(STRING):: cause_c
    integer:: unit_nml        ! NAMELIST ե륪ץֹ. 
                              ! Unit number for NAMELIST file open
!!$    integer:: iostat_nml      ! NAMELIST ɤ߹߻ IOSTAT. 
!!$                              ! IOSTAT of NAMELIST read
    character(*), parameter:: subname = 'PhyImplicitNmlRead'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''



    !-----------------------------------------------------------------
    !  ʸ NAMELIST ѿ
    !  Substitute character arguments to NAMELIST group
    !-----------------------------------------------------------------
!!$    param_c = param_c_

    !----------------------------------------------------------------
    !  NAMELIST եΥץ
    !  Open NAMELIST file
    !----------------------------------------------------------------
    call FileOpen( unit = unit_nml, & ! (out)
      & file = nmlfile, mode = 'r', & ! (in)
      & err = err )                   ! (out)
    if ( present_and_true(err) ) then
      stat = DC_ENOFILEREAD
      cause_c = nmlfile
      goto 999
    end if


    !-----------------------------------------------------------------
    !  NAMELIST ѿμ
    !  Get NAMELIST group
    !-----------------------------------------------------------------
!!$    read( unit = unit_nml, & ! (in)
!!$      & nml = phy_implicit_nml, iostat = iostat_nml ) ! (out)
!!$    if ( iostat_nml == 0 ) then
!!$      call MessageNotify( 'M', subname, &
!!$        & 'NAMELIST group "%c" is loaded from "%c".', &
!!$        & c1 = 'phy_implicit_nml', c2 = trim(nmlfile) )
!!$      write(STDOUT, nml = phy_implicit_nml)
!!$    else
!!$      call MessageNotify( 'W', subname, &
!!$        & 'NAMELIST group "%c" is not found in "%c" (iostat=%d).', &
!!$        & c1 = 'phy_implicit_nml', c2 = trim(nmlfile), &
!!$        & i = (/iostat_nml/) )
!!$    end if

    close( unit_nml )

    !-----------------------------------------------------------------
    !  NAMELIST ѿʸ
    !  Substitute NAMELIST group to character arguments
    !-----------------------------------------------------------------
!!$    param_c_ = param_c

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyImplicitNmlRead

  subroutine PhyImplicitGetMatrices( phy_impl, &
    & xyr_Press, &
    & xyr_UFlux, xyr_VFlux, &
    & xyr_TempFlux, xyr_QVapFlux, &
    & xyza_UVMatrix, xyza_TempMatrix, xyza_QVapMatrix, &
    & err )
    !
    ! κȼԤޤ.
    !
    ! ʤ, Ϳ줿 *phy_impl*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Create and get implicit matrices. 
    !
    ! If *phy_impl* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYIMPL), intent(inout):: phy_impl
    real(DP), intent(in):: xyr_Press (0:phy_impl%imax-1, 0:phy_impl%jmax-1, 0:phy_impl%kmax)
                              ! $ P_s $ . ɽ̵ (Ⱦ٥). 
                              ! Surface pressure (half level)
    real(DP), intent(out):: xyr_UFlux (0:phy_impl%imax-1, 0:phy_impl%jmax-1, 0:phy_impl%kmax)
                              ! ®եå. 
                              ! Zonal wind flux
    real(DP), intent(out):: xyr_VFlux (0:phy_impl%imax-1, 0:phy_impl%jmax-1, 0:phy_impl%kmax)
                              ! ®եå. 
                              ! Meridional wind flux
    real(DP), intent(out):: xyr_TempFlux (0:phy_impl%imax-1, 0:phy_impl%jmax-1, 0:phy_impl%kmax)
                              ! ٥եå. 
                              ! Temperature flux
    real(DP), intent(out):: xyr_QVapFlux (0:phy_impl%imax-1, 0:phy_impl%jmax-1, 0:phy_impl%kmax)
                              ! 漾եå. 
                              ! Specific humidity flux
    real(DP), intent(out):: xyza_UVMatrix (0:phy_impl%imax-1, 0:phy_impl%jmax-1, 0:phy_impl%kmax-1, -1:1)
                              ! ®ٱ. 
                              ! Implicit matrix about velocity 
    real(DP), intent(out):: xyza_TempMatrix  (0:phy_impl%imax-1, 0:phy_impl%jmax-1, -1:phy_impl%kmax-1, -1:1)
                              ! ٱ. 
                              ! Implicit matrix about temperature
    real(DP), intent(out):: xyza_QVapMatrix (0:phy_impl%imax-1, 0:phy_impl%jmax-1, 0:phy_impl%kmax-1, -1:1)
                              ! 漾. 
                              ! Implicit matrix about specific humidity
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer:: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level

    real(DP):: Grav      ! $ g $ .      ϲ®.     Gravitational acceleration
    real(DP):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP):: DelTime    ! $ \Delta t $ . ॹƥå. Time step

    real(DP):: xy_SurfHeatCapacity (0:phy_impl%imax-1, 0:phy_impl%jmax-1)
                              ! ɽǮ. 
                              ! Surface heat capacity
    integer:: xy_SurfCondition (0:phy_impl%imax-1, 0:phy_impl%jmax-1)
                              ! ɽ. 
                              ! Surface condition

    integer:: i, j, k         ! DO 롼Ѻѿ
                              ! Work variables for DO loop

    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyImplicitGetMatrices'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_impl % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYIMPL'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *phy_impl* ˳ǼƤͤμФ
    !  Fetch setting values stored in *phy_impl*
    !-----------------------------------------------------------------
    imax    = phy_impl % imax   
    jmax    = phy_impl % jmax   
    kmax    = phy_impl % kmax   
    Grav    = phy_impl % Grav   
    Cp      = phy_impl % Cp     
    DelTime = phy_impl % DelTime

    xy_SurfHeatCapacity = phy_impl % xy_SurfHeatCapacity
    xy_SurfCondition    = phy_impl % xy_SurfCondition

    !----------------------------------------------------------------
    !  
    !  Create implicit matrices
    !----------------------------------------------------------------

    !-----------------------------------
    !  , Ǯ̤ι
    !  Mass and heat capacity terms
    xyza_UVMatrix  = 0.0_DP
    xyza_TempMatrix = 0.0_DP
    xyza_QVapMatrix = 0.0_DP

    do k = 0, kmax-1
      xyza_UVMatrix(:,:,k,0)  = &
        & ( xyr_Press(:,:,k) - xyr_Press(:,:,k+1) ) &
        &    / Grav / ( 2.0_DP * DelTime )
      xyza_TempMatrix(:,:,k,0) = xyza_UVMatrix(:,:,k,0) * Cp
      xyza_QVapMatrix(:,:,k,0) = xyza_UVMatrix(:,:,k,0) * Cp
    end do

    do j = 0, jmax-1
      do i = 0, imax-1
        if ( xy_SurfCondition(i,j) >= 1 ) then 
          xyza_TempMatrix(i,j,-1,0) = &
            & xy_SurfHeatCapacity(i,j) / ( 2.0_DP * DelTime )
        else
          xyza_TempMatrix(i,j,-1,0) = 1.0_DP
        end if
      end do
    end do

    !-----------------------------------
    !  եåꥻå
    !  Reset fluxes
    xyr_UFlux    = 0.0_DP
    xyr_VFlux    = 0.0_DP
    xyr_TempFlux = 0.0_DP
    xyr_QVapFlux = 0.0_DP

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyImplicitGetMatrices

  subroutine PhyImplicitIntegrate( phy_impl, &
    & xyr_UFlux, xyr_VFlux, &
    & xyr_TempFlux, &
    & xy_SurfRadSFlux, &
    & xy_SurfRadLFlux, &
    & xyr_QVapFlux, &
    & xyza_UVMatrix, &
    & xyza_TempMatrix, &
    & xyza_QVapMatrix, &
    & xy_SurfUVMatrix, &
    & xyaa_SurfTempMatrix, &
    & xyaa_SurfQVapMatrix, &
    & xya_SurfRadLMatrix, &
    & xyz_DVerdiffUDt, &
    & xyz_DVerdiffVDt, &
    & xyz_DVerdiffTempDt, &
    & xy_DVerdiffSurfTempDt, &
    & xyz_DVerdiffQVapDt, &
    & err )
    !
    ! κȼԤޤ.
    !
    ! ʤ, Ϳ줿 *phy_impl*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! Create and get implicit matrices. 
    !
    ! If *phy_impl* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    type(PHYIMPL), intent(inout):: phy_impl
    real(DP), intent(in):: xyr_UFlux (0:phy_impl%imax-1, 0:phy_impl%jmax-1, 0:phy_impl%kmax)
                              ! ®եå. 
                              ! Zonal wind flux
    real(DP), intent(in):: xyr_VFlux (0:phy_impl%imax-1, 0:phy_impl%jmax-1, 0:phy_impl%kmax)
                              ! ®եå. 
                              ! Meridional wind flux
    real(DP), intent(in):: xyr_TempFlux (0:phy_impl%imax-1, 0:phy_impl%jmax-1, 0:phy_impl%kmax)
                              ! ٥եå. 
                              ! Temperature flux
    real(DP), intent(in):: xy_SurfRadSFlux (0:phy_impl%imax-1, 0:phy_impl%jmax-1)
                              ! û () եå (ɽ). 
                              ! Short wave (insolation) flux on surface
    real(DP), intent(in):: xy_SurfRadLFlux (0:phy_impl%imax-1, 0:phy_impl%jmax-1)
                              ! Ĺȥեå (ɽ). 
                              ! Long wave flux on surface
    real(DP), intent(in):: xyr_QVapFlux (0:phy_impl%imax-1, 0:phy_impl%jmax-1, 0:phy_impl%kmax)
                              ! 漾եå. 
                              ! Specific humidity flux
    real(DP), intent(in):: xyza_UVMatrix (0:phy_impl%imax-1, 0:phy_impl%jmax-1, 0:phy_impl%kmax-1, -1:1)
                              ! ®ٱ. 
                              ! Implicit matrix about velocity 
    real(DP), intent(in):: xyza_TempMatrix  (0:phy_impl%imax-1, 0:phy_impl%jmax-1, -1:phy_impl%kmax-1, -1:1)
                              ! ٱ. 
                              ! Implicit matrix about temperature
    real(DP), intent(in):: xyza_QVapMatrix (0:phy_impl%imax-1, 0:phy_impl%jmax-1, 0:phy_impl%kmax-1, -1:1)
                              ! 漾. 
                              ! Implicit matrix about specific humidity
    real(DP), intent(in):: xy_SurfUVMatrix (0:phy_impl%imax-1, 0:phy_impl%jmax-1)
                              !  ®ٱ: ɽ. 
                              ! Implicit matrix about velocity: surface
    real(DP), intent(in):: xyaa_SurfTempMatrix (0:phy_impl%imax-1, 0:phy_impl%jmax-1, 0:1, -1:1)

                              ! ٱ: ɽ. 
                              ! Implicit matrix about temperature: surface
    real(DP), intent(in):: xyaa_SurfQVapMatrix (0:phy_impl%imax-1, 0:phy_impl%jmax-1, 0:1, -1:1)
                              ! 漾: ɽ. 
                              ! Implicit matrix about specific humidity: surface
    real(DP), intent(in):: xya_SurfRadLMatrix (0:phy_impl%imax-1, 0:phy_impl%jmax-1, -1:1)
                              ! $ T $ : ɽ. 
                              ! $ T $ implicit matrix: surface
    real(DP), intent(out):: xyz_DVerdiffUDt (0:phy_impl%imax-1, 0:phy_impl%jmax-1, 0:phy_impl%kmax-1)
                              ! ʬ ľȻ®. 
                              ! Zonal acceleration by vertical diffusion
    real(DP), intent(out):: xyz_DVerdiffVDt (0:phy_impl%imax-1, 0:phy_impl%jmax-1, 0:phy_impl%kmax-1)
                              ! ʬ ľȻ®. 
                              ! Meridional acceleration by vertical diffusion
    real(DP), intent(out):: xyz_DVerdiffTempDt (0:phy_impl%imax-1, 0:phy_impl%jmax-1, 0:phy_impl%kmax-1)
                              ! ľȻǮΨ. 
                              ! Temperature tendency by vertical diffusion
    real(DP), intent(out):: xy_DVerdiffSurfTempDt (0:phy_impl%imax-1, 0:phy_impl%jmax-1)
                              ! ɽ ľȻǮΨ. 
                              ! Surface temperature tendency by vertical diffusion
    real(DP), intent(out):: xyz_DVerdiffQVapDt (0:phy_impl%imax-1, 0:phy_impl%jmax-1, 0:phy_impl%kmax-1)
                              ! ľȻüΨ. 
                              ! Specific humidity tendency by vertical diffusion
    logical, intent(out), optional:: err
                              ! 㳰ѥե饰.
                              ! ǥեȤǤ, μ³ǥ顼
                              ! , ץ϶λޤ.
                              !  *err* Ϳ,
                              ! ץ϶λ, 
                              ! *err*  .true. ޤ.
                              !
                              ! Exception handling flag. 
                              ! By default, when error occur in 
                              ! this procedure, the program aborts. 
                              ! If this *err* argument is given, 
                              ! .true. is substituted to *err* and 
                              ! the program does not abort. 

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: imax ! ٳʻ. 
                   ! Number of grid points in longitude
    integer:: jmax ! ٳʻ. 
                   ! Number of grid points in latitude
    integer:: kmax ! ľؿ. 
                   ! Number of vertical level

    real(DP):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure
    real(DP):: EL        ! $ L $ .      ζŷǮ. Latent heat of condensation of water vapor
    real(DP):: DelTime    ! $ \Delta t $ . ॹƥå. Time step

    integer:: xy_SurfCondition (0:phy_impl%imax-1, 0:phy_impl%jmax-1)
                              ! ɽ. 
                              ! Surface condition
    real(DP):: xy_GroundTempFlux (0:phy_impl%imax-1, 0:phy_impl%jmax-1)
                              ! Ǯեå. 
                              ! Ground temperature flux

    real(DP):: xyz_DelTempQVap (0:phy_impl%imax-1, 0:phy_impl%jmax-1, -phy_impl%kmax:phy_impl%kmax)
                              ! $ T q $ λѲ. 
                              ! Tendency of $ T q $ 
    real(DP):: xyza_TempQVapLUMatrix (0:phy_impl%imax-1, 0:phy_impl%jmax-1, -phy_impl%kmax:phy_impl%kmax, -1:1)
                              ! LU . 
                              ! LU matrix
    real(DP):: xyza_UVLUMatrix (0:phy_impl%imax-1, 0:phy_impl%jmax-1, 0:phy_impl%kmax-1,-1:1)
                              ! LU . 
                              ! LU matrix

    integer:: i, j, k, l      ! DO 롼Ѻѿ
                              ! Work variables for DO loop

    integer:: stat
    character(STRING):: cause_c
    character(*), parameter:: subname = 'PhyImplicitIntegrate'
  continue
    call BeginSub( subname )
    stat = DC_NOERR
    cause_c = ''

    !-----------------------------------------------------------------
    !  Υå
    !  Check initialization
    !-----------------------------------------------------------------
    if ( .not. phy_impl % initialized ) then
      stat = DC_ENOTINIT
      cause_c = 'PHYIMPL'
      goto 999
    end if

    !-----------------------------------------------------------------
    !  *phy_impl* ˳ǼƤͤμФ
    !  Fetch setting values stored in *phy_impl*
    !-----------------------------------------------------------------
    imax    = phy_impl % imax   
    jmax    = phy_impl % jmax   
    kmax    = phy_impl % kmax   
    Cp      = phy_impl % Cp     
    EL      = phy_impl % EL     
    DelTime = phy_impl % DelTime

    xy_SurfCondition    = phy_impl % xy_SurfCondition
    xy_GroundTempFlux   = phy_impl % xy_GroundTempFlux

    !----------------------------------------------------------------
    !  ®, ®η׻
    !  Calculate zonal and meridional wind
    !----------------------------------------------------------------
    xyza_UVLUMatrix = xyza_UVMatrix
    xyza_UVLUMatrix(:,:,0,0)  = xyza_UVLUMatrix(:,:,0,0) + xy_SurfUVMatrix
    
    call PhyImplicitLUDecomp3( &
      & xyza_UVLUMatrix, &  ! (inout)
      & imax * jmax, kmax ) ! (in)
    
    do k = 0, kmax - 1
      xyz_DVerdiffUDt(:,:,k) = xyr_UFlux(:,:,k) - xyr_UFlux(:,:,k+1)
      xyz_DVerdiffVDt(:,:,k) = xyr_VFlux(:,:,k) - xyr_VFlux(:,:,k+1)
    end do

    call PhyImplicitLUSolve3( &
      & xyz_DVerdiffUDt, &     ! (inout)
      & xyza_UVLUMatrix, &     ! (in)
      & 1, imax * jmax, kmax ) ! (in)
    
    call PhyImplicitLUSolve3( &
      & xyz_DVerdiffVDt, &     ! (inout)
      & xyza_UVLUMatrix, &     ! (in)
      & 1, imax * jmax, kmax ) ! (in)
    
    !----------------------------------------------------------------
    !  ٤漾η׻
    !  Calculate temperature and specific humidity
    !----------------------------------------------------------------
    do l = -1, 1
      
      do k = 1, kmax
        xyza_TempQVapLUMatrix(:,:,k,l)   = xyza_TempMatrix(:,:,k-1,l)
        xyza_TempQVapLUMatrix(:,:,-k,-l) = xyza_QVapMatrix(:,:,k-1,l)
      end do
      
      xyza_TempQVapLUMatrix(:,:,1,l) = &
        &   xyza_TempMatrix(:,:,0,l) &
        & + xyaa_SurfTempMatrix(:,:,1,l)

      xyza_TempQVapLUMatrix(:,:,-1,-l) = &
        &   xyza_QVapMatrix(:,:,0,l) &
        & + xyaa_SurfQVapMatrix(:,:,1,l)
      
    end do
    
    xyza_TempQVapLUMatrix(:,:,0,0) = &
      &   xyza_TempMatrix(:,:,-1,0) &
      & + xyaa_SurfTempMatrix(:,:,0,0) + xyaa_SurfQVapMatrix(:,:,0,0) &
      & + xya_SurfRadLMatrix(:,:,0)
    
    xyza_TempQVapLUMatrix(:,:,0,1) = &
      & xyaa_SurfTempMatrix(:,:,0,1) + xya_SurfRadLMatrix(:,:,1)
    
    xyza_TempQVapLUMatrix(:,:,0,-1) =  xyaa_SurfQVapMatrix(:,:,0,1) 
    
    call PhyImplicitLUDecomp3( &
      & xyza_TempQVapLUMatrix, &      ! (inout)
      & imax * jmax, (2 * kmax) + 1 ) ! (in)
    
    do k = 1, kmax
      xyz_DelTempQVap(:,:,k)  = xyr_TempFlux(:,:,k-1) - xyr_TempFlux(:,:,k)
      xyz_DelTempQVap(:,:,-k) = xyr_QVapFlux(:,:,k-1) - xyr_QVapFlux(:,:,k)
    end do
    
    xyz_DelTempQVap(:,:,0) = &
      & - xy_SurfRadSFlux - xy_SurfRadLFlux  &
      & - xyr_TempFlux(:,:,0) - xyr_QVapFlux(:,:,0) &
      & + xy_GroundTempFlux
    
    call PhyImplicitLUSolve3( &
      & xyz_DelTempQVap, &                ! (inout)
      & xyza_TempQVapLUMatrix, &          ! (in)
      & 1, imax * jmax , (2 * kmax) + 1 ) ! (in)
    
    !----------------------------------------------------------------
    !  ѲΨη׻
    !  Calculate tendency
    !----------------------------------------------------------------
    do k = 1, kmax
      xyz_DVerdiffUDt(:,:,k-1) = xyz_DVerdiffUDt(:,:,k-1) / ( 2.0_DP * DelTime )
      xyz_DVerdiffVDt(:,:,k-1) = xyz_DVerdiffVDt(:,:,k-1) / ( 2.0_DP * DelTime )
      xyz_DVerdiffTempDt(:,:,k-1) = xyz_DelTempQVap(:,:,k) / ( 2.0_DP * DelTime )
      xyz_DVerdiffQVapDt(:,:,k-1) = xyz_DelTempQVap(:,:,-k) / ( 2.0_DP * DelTime ) / EL * Cp
    end do

    do j = 0, jmax-1
      do i = 0, imax-1
        if ( xy_SurfCondition(i,j) >= 1 ) then
          xy_DVerdiffSurfTempDt(i,j) = &
            &   xyz_DelTempQVap(i,j,0) / ( 2.0_DP * DelTime )
        else
          xy_DVerdiffSurfTempDt(i,j) = 0.0_DP
        end if
      end do
    end do

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
999 continue
    call StoreError( stat, subname, err, cause_c )
    call EndSub( subname )
  end subroutine PhyImplicitIntegrate

  subroutine PhyImplicitLUDecomp3( &
    & jna_LUMatrix, JDimMax, NDimMax )
    !
    ! 3 гѹ LU ʬԤޤ. 
    !
    ! ʤ, Ϳ줿 *phy_impl*  Create ˤäƽ
    ! Ƥʤ, ץϥ顼ȯޤ.
    !
    ! LU decomposition of triple diagonal matrix.
    !
    ! If *phy_impl* is not initialized by "Create" yet,
    ! error is occurred.
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    integer, intent(in):: JDimMax
    integer, intent(in):: NDimMax
    real(DP), intent(inout):: jna_LUMatrix(JDimMax, NDimMax, -1:1)
                              ! LU . 
                              ! LU matrix

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: j, n            ! DO 롼Ѻѿ
                              ! Work variables for DO loop

    character(*), parameter:: subname = 'PhyImplicitLUDecomp3'
  continue
    call BeginSub( subname )

    !----------------------------------------------------------------
    !  LU ʬ
    !  LU decomposition
    !----------------------------------------------------------------
    do j = 1, JDimMax
      jna_LUMatrix(j,1,1) = jna_LUMatrix(j,1,1) / jna_LUMatrix(j,1,0)
    end do

    do n = 2, NDimMax-1
      do j = 1, JDimMax
        jna_LUMatrix(j,n,0) = &
          &   jna_LUMatrix(j,n,0) &
          & - jna_LUMatrix(j,n,-1) * jna_LUMatrix(j,n-1,1)

        jna_LUMatrix(j,n,1) = jna_LUMatrix(j,n,1) /jna_LUMatrix(j,n,0)
      end do
    end do

    do j = 1, JDimMax
      jna_LUMatrix(j,NDimMax,0) = &
        &   jna_LUMatrix(j,NDimMax,0) &
        & - jna_LUMatrix(j,NDimMax,-1) * jna_LUMatrix(j,NDimMax-1,1)
    end do

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    call EndSub( subname )
  end subroutine PhyImplicitLUDecomp3

  subroutine PhyImplicitLUSolve3( &
    & ijn_Vector, &
    & jna_LUMatrix, &
    & IDimMax, JDimMax, NDimMax )
    !
    ! LU ʬˤη׻ (3гѹ)
    !
    ! Solve with LU decomposition (For triple diagonal matrix). 
    !
    use dc_trace, only: BeginSub, EndSub
    use dc_string, only: PutLine, Printf
    use dc_types, only: DP, STRING, TOKEN, STDOUT
    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
    implicit none
    integer, intent(in):: IDimMax
    integer, intent(in):: JDimMax
    integer, intent(in):: NDimMax
    real(DP), intent(in):: jna_LUMatrix(JDimMax, NDimMax, -1:1)
                              ! LU . 
                              ! LU matrix
    real(DP), intent(inout):: ijn_Vector(IDimMax, JDimMax, NDimMax)
                              ! ե٥ȥ / 
                              ! Right-hand side vector / solution

    !-----------------------------------
    !  ѿ
    !  Work variables
    integer:: i, j, n         ! DO 롼Ѻѿ
                              ! Work variables for DO loop

    character(*), parameter:: subname = 'PhyImplicitLUSolve3'
  continue
    call BeginSub( subname )

    !-----------------------------------------------------------------
    !  
    !  Forward substitution
    !-----------------------------------------------------------------
    do i = 1, IDimMax
      do j = 1, JDimMax
        ijn_Vector(i,j,1) = ijn_Vector(i,j,1) / jna_LUMatrix(j,1,0)
      end do
    end do

    do n = 2, NDimMax
      do i = 1, IDimMax
        do j = 1, JDimMax
          ijn_Vector(i,j,n) = &
            & (   ijn_Vector(i,j,n) &
            &   - ijn_Vector(i,j,n-1) * jna_LUMatrix(j,n,-1) ) &
            & / jna_LUMatrix(j,n,0)
        end do
      end do
    end do

    !-----------------------------------------------------------------
    !  
    !  Backward substitution
    !-----------------------------------------------------------------
    do n = NDimMax-1, 1, -1
      do i = 1, IDimMax
        do j = 1, JDimMax
          ijn_Vector(i,j,n) = &
            &   ijn_Vector(i,j,n) &
            & - ijn_Vector(i,j,n+1) * jna_LUMatrix(j,n,1)
        end do
      end do
    end do

    !-----------------------------------------------------------------
    !  λ, 㳰
    !  Termination and Exception handling
    !-----------------------------------------------------------------
    call EndSub( subname )
  end subroutine PhyImplicitLUSolve3

!!$  subroutine PhyImplicitSample( phy_impl, err )
!!$    !--
!!$    ! PhyImplicitSample 򵭽ҤƤ.
!!$    !++
!!$    ! ʤ, Ϳ줿 *phy_impl*  Create ˤäƽ
!!$    ! Ƥʤ, ץϥ顼ȯޤ.
!!$    !--
!!$    ! Describe brief of PhyImplicitSample
!!$    !++
!!$    ! If *phy_impl* is not initialized by "Create" yet,
!!$    ! error is occurred.
!!$    !
!!$    use dc_trace, only: BeginSub, EndSub
!!$    use dc_string, only: PutLine, Printf
!!$    use dc_types, only: DP, STRING, TOKEN, STDOUT
!!$    use dc_error, only: StoreError, DC_NOERR, DC_ENOTINIT
!!$    implicit none
!!$    type(PHYIMPL), intent(inout):: phy_impl
!!$    logical, intent(out), optional:: err
!!$                              ! 㳰ѥե饰.
!!$                              ! ǥեȤǤ, μ³ǥ顼
!!$                              ! , ץ϶λޤ.
!!$                              !  *err* Ϳ,
!!$                              ! ץ϶λ, 
!!$                              ! *err*  .true. ޤ.
!!$                              !
!!$                              ! Exception handling flag. 
!!$                              ! By default, when error occur in 
!!$                              ! this procedure, the program aborts. 
!!$                              ! If this *err* argument is given, 
!!$                              ! .true. is substituted to *err* and 
!!$                              ! the program does not abort. 
!!$
!!$!!$    integer:: param_i
!!$!!$    real(DP):: param_r
!!$!!$    character(STRING):: param_c
!!$
!!$    !-----------------------------------
!!$    !  ѿ
!!$    !  Work variables
!!$    integer:: stat
!!$    character(STRING):: cause_c
!!$    character(*), parameter:: subname = 'PhyImplicitSample'
!!$  continue
!!$    call BeginSub( subname )
!!$    stat = DC_NOERR
!!$    cause_c = ''
!!$
!!$    !-----------------------------------------------------------------
!!$    !  Υå
!!$    !  Check initialization
!!$    !-----------------------------------------------------------------
!!$    if ( .not. phy_impl % initialized ) then
!!$      stat = DC_ENOTINIT
!!$      cause_c = 'PHYIMPL'
!!$      goto 999
!!$    end if
!!$
!!$    !-----------------------------------------------------------------
!!$    !  *phy_impl* ˳ǼƤͤμФ
!!$    !  Fetch setting values stored in *phy_impl*
!!$    !-----------------------------------------------------------------
!!$!!$    param_i = phy_impl % param_i
!!$!!$    param_r = phy_impl % param_r
!!$!!$    param_c = phy_impl % param_c
!!$
!!$
!!$    !-----------------------------------------------------------------
!!$    !  λ, 㳰
!!$    !  Termination and Exception handling
!!$    !-----------------------------------------------------------------
!!$999 continue
!!$    call StoreError( stat, subname, err, cause_c )
!!$    call EndSub( subname )
!!$  end subroutine PhyImplicitSample

end module phy_implicit
