!= phy_radiation_flux ⥸塼Υƥȥץ
!
!= Test program for "phy_radiation_flux"
!
! Authors::   Yukiko YAMADA, Yasuhiro MORIKAWA
! Version::   $Id: phy_radiation_flux_test.f90,v 1.6 2008-03-02 22:43:55 morikawa Exp $
! Tag Name::  $Name: dcpam4-20080427 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! phy_radiation_flux ⥸塼ưƥȤԤΥץǤ.
! ΥץबѥǤ뤳, Ӽ¹Ի
! ץबｪλ뤳ȤǧƤ.
!
! This program checks the operation of "phy_radiation_flux" module.
! Confirm compilation and execution of this program.
!

program phy_radiation_flux_test
  use phy_radiation_flux, only: PHYRADFLX, PhyRadFluxCreate, &
    & PhyRadFluxClose, PhyRadFluxPutLine, PhyRadFluxInitialized, &
    & RadiationFlux, RadiationDTempDt
  use constants, only: CONST, Create, Get
  use dc_test, only: AssertEqual, AssertGreaterThan, AssertLessThan
  use dc_types, only: DP, STRING, TOKEN
  use dc_string, only: StoA, PutLine, Printf, toChar
  use dc_message, only: MessageNotify
  use dc_args, only: ARGS, DCArgsOpen, DCArgsHelpMsg, DCArgsOption, &
    & DCArgsDebug, DCArgsHelp, DCArgsStrict, DCArgsClose
  use dc_date_types, only: DC_DIFFTIME
  use dc_date, only: DCDiffTimeCreate, EvalSec, EvalMin
  use gt4_history, only: HistoryGet, HistoryCreate, HistoryAddVariable, &
    & HistoryAddAttr, HistoryPut, HistoryClose
  implicit none

  !---------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !---------------------------------------------------------
  character(*), parameter:: title = &
    & 'phy_radiation_flux_test $Name: dcpam4-20080427 $ :: ' // &
    & 'Test program of "phy_radiation_flux" module'
  character(*), parameter:: source = &
    & 'dcpam4 ' // &
    & '(See http://www.gfd-dennou.org/library/dcpam)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

  !-------------------------------------------------------------------
  !  ʻȿ
  !  Grid points and maximum truncated wavenumber
  !-------------------------------------------------------------------
  integer, parameter:: imax = 32
                              ! ٳʻ. 
                              ! Number of grid points in longitude
  integer, parameter:: jmax = 16
                              ! ٳʻ. 
                              ! Number of grid points in latitude
  integer, parameter:: kmax = 12
                              ! ľؿ. 
                              ! Number of vertical level

  !-----------------------------------------------------------------
  !  ʪ
  !  Configure physical constants etc.
  !-----------------------------------------------------------------
  type(CONST):: const_earth
  real(DP):: PI        ! $ \pi $ .    ߼Ψ.         Circular constant
  real(DP):: Grav      ! $ g $ .      ϲ®.     Gravitational acceleration
  real(DP):: Cp        ! $ C_p $ .    絤갵Ǯ.   Specific heat of air at constant pressure

  real(DP):: StB       ! $ \sigma_{SB} $ .       ƥեܥĥޥ. Stefan-Boltzmann constant

  !---------------------------------------------------------
  !  ǡ
  !  Axes data
  !---------------------------------------------------------
  real(DP):: x_Lon (0:imax-1)
                            ! . Longitude
  real(DP):: y_Lat (0:jmax-1)
                            ! . Latitude
  real(DP):: z_Sigma (0:kmax-1)
                            ! $ \sigma $ ٥ (). 
                            ! Full $ \sigma $ level
  real(DP):: r_Sigma (0:kmax)
                            ! $ \sigma $ ٥ (Ⱦ). 
                            ! Half $ \sigma $ level

  !---------------------------------------------------------
  !  
  !  Time
  !---------------------------------------------------------
  type(DC_DIFFTIME):: delta_time
                            ! $ \Delta t$ . . Time
  character(TOKEN):: time_range

  !---------------------------------------------------------
  !  ʪ
  !  Physical values
  !---------------------------------------------------------
  real(DP):: xy_SurfTemp (0:imax-1, 0:jmax-1)
                              ! ɽ̲. 
                              ! Surface temperature
  real(DP):: xy_SurfAlbedo (0:imax-1, 0:jmax-1)
                              ! ɽ٥. 
                              ! Surface albedo
  real(DP):: xyz_Temp (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ T $ .     . Temperature
  real(DP):: xyz_QVap (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! $ q $ .     漾. Specific humidity
  real(DP):: xyr_Press (0:imax-1, 0:jmax-1, 0:kmax)
                              ! $ P_s $ . ɽ̵ (Ⱦ٥). 
                              ! Surface pressure (half level)

  !-----------------------------------
  !  եå
  !  Fluxes
  real(DP):: xyr_RadLFlux (0:imax-1, 0:jmax-1, 0:kmax)
                              ! Ĺȥեå. 
                              ! Long wave flux
  real(DP):: xya_SurfRadLMatrix (0:imax-1, 0:jmax-1, -1:1)
                              ! $ T $ : ɽ. 
                              ! $ T $ implicit matrix: surface
  real(DP):: xyra_DelRadLFlux (0:imax-1, 0:jmax-1, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Surface temperature tendency with long wave
  real(DP):: xyr_RadSFlux (0:imax-1, 0:jmax-1, 0:kmax)
                              ! û () եå. 
                              ! Short wave (insolation) flux

  real(DP):: xyr_RadLFluxAns (0:imax-1, 0:jmax-1, 0:kmax)
                              ! Ĺȥեå. 
                              ! Long wave flux
  real(DP):: xya_SurfRadLMatrixAns (0:imax-1, 0:jmax-1, -1:1)
                              ! $ T $ : ɽ. 
                              ! $ T $ implicit matrix: surface
  real(DP):: xyra_DelRadLFluxAns (0:imax-1, 0:jmax-1, 0:kmax, 0:1)
                              ! ĹɽѲ. 
                              ! Surface temperature tendency with long wave
  real(DP):: xyr_RadSFluxAns (0:imax-1, 0:jmax-1, 0:kmax)
                              ! û () եå. 
                              ! Short wave (insolation) flux

  !-----------------------------------
  !  ѴΨ
  !  Temperature tendency
  real(DP):: xyz_DRadLTempDt (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! ĹȲǮΨ. 
                              ! Temperature tendency with long wave
  real(DP):: xyz_DRadSTempDt (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! ûȲǮΨ. 
                              ! Temperature tendency with short wave

  real(DP):: xyz_DRadLTempDtAns (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! ĹȲǮΨ. 
                              ! Temperature tendency with long wave
  real(DP):: xyz_DRadSTempDtAns (0:imax-1, 0:jmax-1, 0:kmax-1)
                              ! ûȲǮΨ. 
                              ! Temperature tendency with short wave

  !---------------------------------------------------------
  !  ѿ
  !  Work variables
  !---------------------------------------------------------
  type(ARGS):: arg            ! ޥɥ饤. 
                              ! Command line options
  logical:: OPT_namelist      ! -N, --namelist ץ̵ͭ. 
                              ! Existence of '-N', '--namelist' option
  character(STRING):: VAL_namelist
                              ! -N, --namelist ץ. 
                              ! Value of '-N', '--namelist' option
  type(PHYRADFLX):: phy_radflx00, phy_radflx01, phy_radflx02, phy_radflx03
  logical:: err

  integer:: i                 ! DO 롼Ѻѿ
                              ! Work variables for DO loop

  character(*), parameter:: subname = 'phy_radiation_flux_test'
continue

  !---------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line options handling
  !---------------------------------------------------------
  call cmdline_optparse ! ֥롼. This is an internal subroutine

  !---------------------------------------------------------
  !  ʪν
  !  Prepare physical constants
  !---------------------------------------------------------
  call Create( const_earth ) ! (inout)

  call Get( constant = const_earth, &            ! (inout)
    & PI = PI, Grav = Grav, Cp = Cp, StB = StB ) ! (out)

  !---------------------------------------------------------
  !  ٥ǡν
  !  Prepare latitude data
  !---------------------------------------------------------
  call HistoryGet( &
    & file = 'phy_radiation_flux_test00.nc', & ! (in)
    & varname = 'lon', &                       ! (in)
    & array = x_Lon )                          ! (out)
  x_Lon = x_Lon * PI / 180.0_DP

  call HistoryGet( &
    & file = 'phy_radiation_flux_test00.nc', & ! (in)
    & varname = 'lat', &                       ! (in)
    & array = y_Lat )                          ! (out)
  y_Lat = y_Lat * PI / 180.0_DP

  call HistoryGet( &
    & file = 'phy_radiation_flux_test00.nc', & ! (in)
    & varname = 'sig', &                       ! (in)
    & array = z_Sigma )                        ! (out)

  call HistoryGet( &
    & file = 'phy_radiation_flux_test00.nc', & ! (in)
    & varname = 'sigm', &                      ! (in)
    & array = r_Sigma )                        ! (out)

  !---------------------------------------------------------
  !  ɽ̥ǡν
  !  Prepare surface data
  !---------------------------------------------------------
  xy_SurfTemp = 273.0_DP
  xy_SurfAlbedo = 0.3_DP

  !---------------------------------------------------------
  !  
  !  Time control
  !---------------------------------------------------------
  call DCDiffTimeCreate( &
    &  diff = delta_time, & ! (out)
    & value = 10.0_DP, &    ! (in)
    &  unit = 'min' )       ! (in)

  !---------------------------------------------------------
  !  ƥ
  !  Initialization test
  !---------------------------------------------------------
  call PhyRadFluxCreate( phy_radflx = phy_radflx00, &          ! (inout)
    & imax = imax, jmax = jmax, kmax = kmax, &                 ! (in)
    & y_Lat = y_Lat, &                                         ! (in)
    & Grav = Grav, Cp = Cp, StB = StB, &                       ! (in)
    & xy_SurfTemp = xy_SurfTemp, &                             ! (in)
    & xy_SurfAlbedo = xy_SurfAlbedo, &                         ! (in)
    & current_time_value = 0.0_DP, &                           ! (in)
    & current_time_unit = 'sec', &                             ! (in)
    & delta_time_value = EvalMin( delta_time ), &              ! (in)
    & delta_time_unit = 'min', &                               ! (in)
    & delta_time_value_RadLong = EvalMin( delta_time ) * 3, &  ! (in)
    & delta_time_unit_RadLong = 'min', &                       ! (in)
    & delta_time_value_RadShort = EvalMin( delta_time ) * 2, & ! (in)
    & delta_time_unit_RadShort = 'min' )                       ! (in)
  call AssertEqual( 'initialization test 1', &
    & answer = .true., check = PhyRadFluxInitialized(phy_radflx00) )
  call PhyRadFluxPutLine( phy_radflx = phy_radflx00 ) ! (in)

  !---------------------------------------------------------
  !  RadiationFlux, RadiationDelTemp ƥ
  !  RadiationFlux, RadiationDelTemp test
  !---------------------------------------------------------
  call HistoryGet( &
    & file = 'phy_radiation_flux_test00.nc', & ! (in)
    & varname = 'Temp', &                      ! (in)
    & array = xyz_Temp )                       ! (out)

  call HistoryGet( &
    & file = 'phy_radiation_flux_test00.nc', & ! (in)
    & varname = 'QVap', &                      ! (in)
    & array = xyz_QVap )                       ! (out)

  call HistoryGet( &
    & file = 'phy_radiation_flux_test00.nc', & ! (in)
    & varname = 'PressM', &                    ! (in)
    & array = xyr_Press )                      ! (out)

!!$  call output_init ! ֥롼. This is an internal subroutine

  do i = 1, 4
    call RadiationFlux( phy_radflx = phy_radflx00, & ! (inout)
      & xyz_Temp = xyz_Temp, &                       ! (in)
      & xyz_QVap = xyz_QVap, &                       ! (in)
      & xyr_Press = xyr_Press, &                     ! (in)
      & xyr_RadLFlux = xyr_RadLFlux, &               ! (out)
      & xya_SurfRadLMatrix = xya_SurfRadLMatrix, &   ! (out)
      & xyra_DelRadLFlux = xyra_DelRadLFlux, &       ! (out)
      & xyr_RadSFlux = xyr_RadSFlux )                ! (out)

    call Printf(fmt = '')
    call MessageNotify('M', subname, 'current_time=%d min', &
      & i = (/ i * 10 /) )
    call PhyRadFluxPutLine( phy_radflx = phy_radflx00 ) ! (in)
    call Printf(fmt = '')

    call RadiationDTempDt( phy_radflx = phy_radflx00, & ! (inout)
      & xyr_RadLFlux = xyr_RadLFlux, &                  ! (in)
      & xyr_RadSFlux = xyr_RadSFlux, &                  ! (in)
      & xyr_Press = xyr_Press, &                        ! (in)
      & xyz_DRadLTempDt = xyz_DRadLTempDt, &            ! (out)
      & xyz_DRadSTempDt = xyz_DRadSTempDt )             ! (out)

    xyz_Temp = xyz_Temp &
      &          * (   1.0_DP &
      &              + EvalSec ( delta_time ) &
      &                * ( xyz_DRadLTempDt + xyz_DRadLTempDt ) )

    xyz_QVap = xyz_QVap * 5.0_DP

!!$    call output_put ! ֥롼. This is an internal subroutine

    time_range = 'time=' // toChar( EvalMin( delta_time ) * ( i - 1 ) )

    call HistoryGet( &
      & file = 'phy_radiation_flux_test01.nc', & ! (in)
      & varname = 'RadLFlux', &                  ! (in)
      & range = time_range, &                    ! (in)
      & array = xyr_RadLFluxAns )                ! (out)
    call AssertEqual( 'RadLFlux test 1-' // toChar( i ), &
      & answer = xyr_RadLFluxAns, check = xyr_RadLFlux, &
      & significant_digits = 13, ignore_digits = -15 )

    call HistoryGet( &
      & file = 'phy_radiation_flux_test01.nc', & ! (in)
      & varname = 'SurfRadLMatrix', &            ! (in)
      & range = time_range, &                    ! (in)
      & array = xya_SurfRadLMatrixAns )          ! (out)
    call AssertEqual( 'SurfRadLMatrix test 1-' // toChar( i ), &
      & answer = xya_SurfRadLMatrixAns, check = xya_SurfRadLMatrix, &
      & significant_digits = 13, ignore_digits = -15 )

    call HistoryGet( &
      & file = 'phy_radiation_flux_test01.nc', & ! (in)
      & varname = 'DelRadLFlux', &               ! (in)
      & range = time_range, &                    ! (in)
      & array = xyra_DelRadLFluxAns )           ! (out)
    call AssertEqual( 'DelRadLFlux test 1-' // toChar( i ), &
      & answer = xyra_DelRadLFluxAns, check = xyra_DelRadLFlux, &
      & significant_digits = 13, ignore_digits = -15 )

    call HistoryGet( &
      & file = 'phy_radiation_flux_test01.nc', & ! (in)
      & varname = 'RadSFlux', &                  ! (in)
      & range = time_range, &                    ! (in)
      & array = xyr_RadSFluxAns )                ! (out)
    call AssertEqual( 'RadSFlux test 1-' // toChar( i ), &
      & answer = xyr_RadSFluxAns, check = xyr_RadSFlux, &
      & significant_digits = 14, ignore_digits = -15 )

    call HistoryGet( &
      & file = 'phy_radiation_flux_test01.nc', & ! (in)
      & varname = 'DRadLTempDt', &               ! (in)
      & range = time_range, &                    ! (in)
      & array = xyz_DRadLTempDtAns )             ! (out)
    call AssertEqual( 'DRadLTempDt test 1-' // toChar( i ), &
      & answer = xyz_DRadLTempDtAns, check = xyz_DRadLTempDt, &
      & significant_digits = 14, ignore_digits = -15 )

    call HistoryGet( &
      & file = 'phy_radiation_flux_test01.nc', & ! (in)
      & varname = 'DRadSTempDt', &               ! (in)
      & range = time_range, &                    ! (in)
      & array = xyz_DRadSTempDtAns )             ! (out)
    call AssertEqual( 'DRadSTempDt test 1-' // toChar( i ), &
      & answer = xyz_DRadSTempDtAns, check = xyz_DRadSTempDt, &
      & significant_digits = 14, ignore_digits = -15 )

  end do

!!$  call output_close ! ֥롼. This is an internal subroutine

  !---------------------------------------------------------
  !  NAMELIST ɤ߹ߥƥ
  !  NAMELIST loading test
  !---------------------------------------------------------
  call PhyRadFluxCreate( phy_radflx = phy_radflx01, &          ! (inout)
    & imax = imax, jmax = jmax, kmax = kmax, &                 ! (in)
    & y_Lat = y_Lat, &                                         ! (in)
    & Grav = Grav, Cp = Cp, StB = StB, &                       ! (in)
    & xy_SurfTemp = xy_SurfTemp, &                             ! (in)
    & xy_SurfAlbedo = xy_SurfAlbedo, &                         ! (in)
    & current_time_value = 0.0_DP, &                           ! (in)
    & current_time_unit = 'sec', &                             ! (in)
    & delta_time_value = EvalMin( delta_time ), &              ! (in)
    & delta_time_unit = 'min', &                               ! (in)
    & nmlfile = VAL_namelist )                                 ! (in)
  call AssertEqual( 'initialization test 2', &
    & answer = .true., check = PhyRadFluxInitialized(phy_radflx01) )
  call PhyRadFluxPutLine( phy_radflx = phy_radflx01 ) ! (in)

  !---------------------------------------------------------
  !  λƥ
  !  Termination test
  !---------------------------------------------------------
  call PhyRadFluxClose( phy_radflx = phy_radflx00 ) ! (inout)
  call AssertEqual( 'termination test 1', &
    & answer = .false., check = PhyRadFluxInitialized(phy_radflx00) )
  call PhyRadFluxPutLine( phy_radflx = phy_radflx00 ) ! (in)

  call PhyRadFluxClose( phy_radflx = phy_radflx02, & ! (inout)
    & err = err )                            ! (out)
  call AssertEqual( 'termination test 2', &
    & answer = .true., check = err )


  !---------------------------------------------------------
  !  򥼥Ȥݤ̵å
  !  Check nullification by zeroing coefficient
  !---------------------------------------------------------
  call PhyRadFluxCreate( phy_radflx = phy_radflx03, & ! (inout)
    & imax = imax, jmax = jmax, kmax = kmax, &        ! (in)
    & y_Lat = y_Lat, &                                ! (in)
    & Grav = Grav, Cp = Cp, StB = StB, &              ! (in)
    & xy_SurfTemp = xy_SurfTemp, &                    ! (in)
    & xy_SurfAlbedo = xy_SurfAlbedo, &                ! (in)
    & LongBandNumber = 1, &                           ! (in)
    & LongAbsorpCoeffQVap = (/ 0.0_DP /), &           ! (in)
    & LongAbsorpCoeffDryAir = (/ 0.0_DP /), &         ! (in)
    & LongBandWeight = (/ 1.0_DP /), &                ! (in)
    & ShortBandNumber = 1 , &                         ! (in)
    & ShortAbsorpCoeffQVap = (/ 0.0_DP /), &          ! (in)
    & ShortAbsorpCoeffDryAir = (/ 0.0_DP /), &        ! (in)
    & ShortBandWeight = (/ 1.0_DP /), &               ! (in)
    & SolarCoeff = 0.0_DP )                           ! (in)

  call RadiationFlux( phy_radflx = phy_radflx03, & ! (inout)
    & xyz_Temp = xyz_Temp, &                       ! (in)
    & xyz_QVap = xyz_QVap, &                       ! (in)
    & xyr_Press = xyr_Press, &                     ! (in)
    & xyr_RadLFlux = xyr_RadLFlux, &               ! (out)
    & xya_SurfRadLMatrix = xya_SurfRadLMatrix, &   ! (out)
    & xyra_DelRadLFlux = xyra_DelRadLFlux, &       ! (out)
    & xyr_RadSFlux = xyr_RadSFlux )                ! (out)

  call RadiationDTempDt( phy_radflx = phy_radflx03, & ! (inout)
    & xyr_RadLFlux = xyr_RadLFlux, &                  ! (in)
    & xyr_RadSFlux = xyr_RadSFlux, &                  ! (in)
    & xyr_Press = xyr_Press, &                        ! (in)
    & xyz_DRadLTempDt = xyz_DRadLTempDt, &            ! (out)
    & xyz_DRadSTempDt = xyz_DRadSTempDt )             ! (out)

  xyz_DRadLTempDtAns = 0.0_DP
  call AssertEqual( 'DRadLTempDt test 2', &
    & answer = xyz_DRadLTempDtAns, check = xyz_DRadLTempDt, &
    & significant_digits = 15, ignore_digits = -15 )

  xyz_DRadSTempDtAns = 0.0_DP
  call AssertEqual( 'DRadSTempDt test 2', &
    & answer = xyz_DRadSTempDtAns, check = xyz_DRadSTempDt, &
    & significant_digits = 15, ignore_digits = -15 )

  call PhyRadFluxClose( phy_radflx = phy_radflx03 ) ! (out)

contains

  subroutine output_init
    call HistoryCreate( &
      & file = 'phy_radiation_flux_test01.nc', &                 ! (in)
      & title = 'Radiation flux module test', &                  ! (in)
      & source = 'dcpam4 (see http://www.gfd-dennou.org) ' , &   ! (in)
      & institution = 'GFD Dennou Club', &                       ! (in)
      & dims = StoA('lon', 'lat', 'sig', 'sigm', &
      &             'd1', 'd2', 'time'), &                       ! (in)
      & dimsizes = (/imax, jmax, kmax, kmax + 1, 3, 2, 0/), &    ! (in)
      & longnames = StoA('longitude', 'latitude', &
      &                  'sigma at layer midpoints', &
      &                  'sigma at layer end-points (half level)', &
      &                  'dimension for SurfRadLMatrix', &
      &                  'dimension for DelRadLFlux', &
      &                  'time'), &                              ! (in)
      & units = StoA('degree_east', 'degree_north', &
      &              '1', '1', '1', '1', 'min'), &               ! (in)
      & origin = 0.0 , &                                         ! (in)
      & interval = real( EvalMin( delta_time ) ) )               ! (in)

    call HistoryAddAttr( &
      & varname = 'lon', attrname = 'standard_name', & ! (in)
      & value = 'longitude' )                          ! (in)
    call HistoryAddAttr( &
      & varname = 'lat', attrname = 'standard_name', & ! (in)
      & value = 'latitude' )                           ! (in)
    call HistoryAddAttr( &
      & varname = 'sig', attrname = 'standard_name', &   ! (in)
      & value = 'atmosphere_sigma_coordinate' )          ! (in)
    call HistoryAddAttr( &
      & varname = 'sigm', attrname = 'standard_name', &  ! (in)
      & value = 'atmosphere_sigma_coordinate' )          ! (in)
    call HistoryAddAttr( &
      & varname = 'time', attrname = 'standard_name', & ! (in)
      & value = 'time' )                                ! (in)
    call HistoryAddAttr( &
      & varname = 'sig', attrname = 'positive', &   ! (in)
      & value = 'down' )                            ! (in)
    call HistoryAddAttr( &
      & varname = 'sigm', attrname = 'positive', &  ! (in)
      & value = 'down' )                            ! (in)

    call HistoryPut( &
      & varname = 'lon', &              ! (in)
      & array = x_Lon / PI * 180.0_DP ) ! (in)
    call HistoryPut( &
      & varname = 'lat', &              ! (in)
      & array = y_Lat / PI * 180.0_DP ) ! (in)
    call HistoryPut( &
      & varname = 'sig', array = z_Sigma ) ! (in)
    call HistoryPut( &
      & varname = 'sigm', array = r_Sigma ) ! (in)
    call HistoryPut( &
      & varname = 'd1', array = (/-1, 0, 1/) ) ! (in)
    call HistoryPut( &
      & varname = 'd2', array = (/0, 1/) ) ! (in)

    call HistoryAddVariable( &
      &  varname = 'RadLFlux',  &                        ! (in)
      &     dims = StoA('lon', 'lat', 'sigm', 'time'), & ! (in)
      & longname = 'long wave flux',  &                  ! (in)
      &    units = '?', &                                ! (in)
      &    xtype = 'double' )                            ! (in)

    call HistoryAddVariable( &
      &  varname = 'RadSFlux',  &                        ! (in)
      &     dims = StoA('lon', 'lat', 'sigm', 'time'), & ! (in)
      & longname = 'short wave flux',  &                 ! (in)
      &    units = '?', &                                ! (in)
      &    xtype = 'double' )                            ! (in)

    call HistoryAddVariable( &
      &  varname = 'SurfRadLMatrix',  &                  ! (in)
      &     dims = StoA('lon', 'lat', 'd1', 'time'), &   ! (in)
      & longname = 'T implicit matrix: surface',  &      ! (in)
      &    units = '?', &                                ! (in)
      &    xtype = 'double' )                            ! (in)

    call HistoryAddVariable( &
      &  varname = 'DelRadLFlux',  &                         ! (in)
      &     dims = StoA('lon', 'lat', 'sigm', 'd2', 'time'), & ! (in)
      & longname = 'surface temperature tendency with long wave',  & ! (in)
      &    units = '?', &                                    ! (in)
      &    xtype = 'double' )                                ! (in)

    call HistoryAddVariable( &
      &  varname = 'DRadLTempDt',  &                         ! (in)
      &     dims = StoA('lon', 'lat', 'sig', 'time'), &      ! (in)
      & longname = 'temperature tendency with long wave', &  ! (in)
      &    units = 'K s-1', &                                ! (in)
      &    xtype = 'double' )                                ! (in)

    call HistoryAddVariable( &
      &  varname = 'DRadSTempDt',  &                         ! (in)
      &     dims = StoA('lon', 'lat', 'sig', 'time'), &      ! (in)
      & longname = 'temperature tendency with short wave', & ! (in)
      &    units = 'K s-1', &                                ! (in)
      &    xtype = 'double' )                                ! (in)

  end subroutine output_init

  subroutine output_put
    call HistoryPut( &
      & varname = 'RadLFlux', array = xyr_RadLFlux ) ! (in)
    call HistoryPut( &
      & varname = 'SurfRadLMatrix', array = xya_SurfRadLMatrix ) ! (in)
    call HistoryPut( &
      & varname = 'DelRadLFlux', array = xyra_DelRadLFlux ) ! (in)
    call HistoryPut( &
      & varname = 'RadSFlux', array = xyr_RadSFlux ) ! (in)
    call HistoryPut( &
      & varname = 'DRadLTempDt', array = xyz_DRadLTempDt ) ! (in)
    call HistoryPut( &
      & varname = 'DRadSTempDt', array = xyz_DRadSTempDt ) ! (in)
  end subroutine output_put

  subroutine output_close
     call HistoryClose
  end subroutine output_close

  subroutine cmdline_optparse
    !
    ! ޥɥ饤νԤޤ
    !
    ! Handle command line options
    !
    call DCArgsOpen( arg = arg )               ! (out)

    call DCArgsHelpMsg( arg = arg, &           ! (inout)
      & category = 'Title', msg = title )      ! (in)
    call DCArgsHelpMsg( arg = arg, &           ! (inout)
      & category = 'Usage', &                  ! (in)
      & msg = './' // trim(subname) // &
      &       ' [Options]' )                   ! (in)
    call DCArgsHelpMsg( arg = arg, &           ! (inout)
      & category = 'Source', msg = source )    ! (in)
    call DCArgsHelpMsg( arg = arg, &           ! (inout)
      & category = 'Institution', &            ! (in)
      & msg = institution )                    ! (in)

    call DCArgsOption( arg = arg, &           ! (inout)
      & options = StoA('-N', '--namelist'), & ! (in)
      & flag = OPT_namelist, &                ! (out)
      & value = VAL_namelist, &               ! (out)
      & help = "Namelist filename")           ! (in)

    call DCArgsDebug( arg = arg )  ! (inout)
    call DCArgsHelp( arg = arg )   ! (inout)
    call DCArgsStrict( arg = arg ) ! (inout)

    call DCArgsClose( arg = arg )  ! (inout)
  end subroutine cmdline_optparse

end program phy_radiation_flux_test
