!= surface_data_test  netCDF եץ
!
!= NetCDF file generation program for "surface_data_test"
!
! Authors::   Yasuhiro MORIKAWA
! Version::   $Id: surface_data_test_prepnc00.f90,v 1.4 2007-09-19 09:36:19 morikawa Exp $
! Tag Name::  $Name: dcpam4-20080427 $
! Copyright:: Copyright (C) GFD Dennou Club, 2007. All rights reserved.
! License::   See COPYRIGHT[link:../../COPYRIGHT]
!
! <b>Note that Japanese and English are described in parallel.</b>
!
! surface_data_test ǻѤ netCDF ե볫ȯ
! ץǤ. 
!
! This is a program for developers that generates 
! netCDF data for "surface_data_test"
!

program surface_data_test_prepnc00
  use constants, only: CONST, Create, Get
  use surface_data, only: SRFDAT, Create, Close, &
    & PutLine, initialized, GetAxes, GetData
  use dc_test, only: AssertEqual
  use dc_types, only: DP, STRING
  use dc_string, only: StoA
  use dc_args, only: ARGS, Open, HelpMsg, Option, Debug, Help, Strict, Close
  use gt4_history, only: GT_HISTORY, &
    & HistoryCreate, HistoryAddVariable, HistoryPut, HistoryClose, &
    & HistoryAddAttr
  implicit none

  !---------------------------------------------------------
  !  ¸ɽ, ǥ̾, °̾
  !  Title of a experiment, name of model, sub-organ
  !---------------------------------------------------------
  character(*), parameter:: title = &
    & 'surface_data_test_prepnc00 $Name: dcpam4-20080427 $ :: ' // &
    & 'NetCDF file generation program for "surface_data_test"'
  character(*), parameter:: source = &
    & 'dcpam4 ' // &
    & '(See http://www.gfd-dennou.org/library/dcpam)'
  character(*), parameter:: institution = &
    & 'GFD Dennou Club (See http://www.gfd-dennou.org)'

  !-------------------------------------------------------------------
  !  ʻȿ
  !  Grid points and maximum truncated wavenumber
  !-------------------------------------------------------------------
  integer:: nmax = 10         ! ȿ. 
                              ! Maximum truncated wavenumber
  integer:: imax = 32         ! ٳʻ. 
                              ! Number of grid points in longitude
  integer:: jmax = 16         ! ٳʻ. 
                              ! Number of grid points in latitude

  !---------------------------------------------------------
  !  ǡ
  !  Axes data
  !---------------------------------------------------------
  real(DP), allocatable:: x_Lon (:) ! . Longitude
  real(DP), allocatable:: x_Lon_Weight (:)
                                    ! ʬѺɸŤ. 
                                    ! Weight for integration in longitude
  real(DP), allocatable:: y_Lat (:) ! . Latitude
  real(DP), allocatable:: y_Lat_Weight (:)
                                    ! ʬѺɸŤ. 
                                    ! Weight for integration in latitude

  !---------------------------------------------------------
  !  ɽ̥ǡ
  !  surface data
  !---------------------------------------------------------
  real(DP), allocatable:: xy_SurfTemp (:,:)
                              ! ɽ̲. 
                              ! Surface temperature

  !---------------------------------------------------------
  !  ǡ
  !  Data I/O
  !---------------------------------------------------------
  type(GT_HISTORY):: gthist_surface
  character(STRING):: default_output_file = 'surface_data_test00.nc'
  character(STRING):: output_file

  !---------------------------------------------------------
  !  ѿ
  !  Work variables
  !---------------------------------------------------------
  type(ARGS):: arg            ! ޥɥ饤. 
                              ! Command line arguments
  logical:: OPT_output        ! -o, --output ץ̵ͭ. 
                              ! Existence of '-o', '--output' option
  character(STRING):: VAL_output
                              ! -o, --output ץ. 
                              ! Value of '-o', '--output' option

  type(CONST):: const_earth
  real(DP):: PI  ! $ \pi $ .    ߼Ψ.         Circular constant
  type(SRFDAT):: srf_dat00
continue

  !---------------------------------------------------------
  !  ޥɥ饤ν
  !  Command line arguments handling
  !---------------------------------------------------------
  call Open( arg )
  call HelpMsg( arg, 'Title', title )
  call HelpMsg( arg, 'Usage', &
    & './surface_data_test_prepnc00 [Options]' )
  call HelpMsg( arg, 'Source', source )
  call HelpMsg( arg, 'Institution', institution )
  call Option( arg, StoA('-o', '--output'), &
    & OPT_output, VAL_output, &
    & help = 'Output filename (default: ' // trim(default_output_file) // ' )' )
  call Debug( arg ) ; call Help( arg ) ; call Strict( arg, severe = .true. )
  call Close( arg )

  if ( VAL_output == '' ) then
    output_file = default_output_file
  else
    output_file = VAL_output
  end if

  !---------------------------------------------------------
  !  ʪ
  !  Configure a physical constant
  !---------------------------------------------------------
  call Create( constant = const_earth ) ! (inout)
  call Get( constant = const_earth, & ! (inout)
    & PI = PI ) ! (out)

  !---------------------------------------------------------
  !  
  !  Initialization
  !---------------------------------------------------------
  call Create( srf_dat = srf_dat00, & ! (inout)
    & nmax = nmax, imax = imax, jmax = jmax, & ! (in)
    & PI = PI ) ! (in)

  !---------------------------------------------------------
  !  ǡ
  !  Get data
  !---------------------------------------------------------
  allocate( x_Lon (0:imax-1) )
  allocate( x_Lon_Weight (0:imax-1) )
  allocate( y_Lat (0:jmax-1) )
  allocate( y_Lat_Weight (0:jmax-1) )
  allocate( xy_SurfTemp(0:imax-1, 0:jmax-1) )
  call GetAxes( srf_dat = srf_dat00, &              ! (inout)
    & x_Lon = x_Lon, x_Lon_Weight = x_Lon_Weight, & ! (out)
    & y_Lat = y_Lat, y_Lat_Weight = y_Lat_Weight )  ! (out)
  call GetData( srf_dat = srf_dat00, & ! (inout)
    & xy_SurfTemp = xy_SurfTemp )      ! (out)

  !----------------------------------------------------------------
  !  ǡ
  !  Output data
  !----------------------------------------------------------------
  call HistoryCreate( &
    & history = gthist_surface, &                         ! (out)
    & file = output_file, title = title, &                ! (in)
    & source = source, institution = institution, &       ! (in)
    & dims = StoA('lon', 'lat'), &                        ! (in)
    & dimsizes = (/imax, jmax/), &                        ! (in)
    & longnames = StoA('longitude', 'latitude'), &        ! (in)
    & units = StoA('degree_east', 'degree_north') )       ! (in)

  call HistoryPut( &
    & history = gthist_surface, &                      ! (inout)
    & varname = 'lon', array = x_Lon / PI * 180.0_DP ) ! (in)
  call HistoryPut( &
    & history = gthist_surface, &                      ! (inout)
    & varname = 'lat', array = y_Lat / PI * 180.0_DP ) ! (in)

  call HistoryAddAttr( &
    & history = gthist_surface, &                    ! (inout)
    & varname = 'lon', attrname = 'standard_name', & ! (in)
    & value = 'longitude' )                          ! (in)
  call HistoryAddAttr( &
    & history = gthist_surface, &                    ! (inout)
    & varname = 'lat', attrname = 'standard_name', & ! (in)
    & value = 'latitude' )                           ! (in)


  call HistoryAddVariable( &
    & history = gthist_surface, &                         ! (inout)
    & varname = 'lon_weight', &                           ! (in)
    & dims = StoA('lon'), &                               ! (in)
    & longname = 'weight for integration in longitude', & ! (in)
    & units = 'radian', xtype = 'double' )                ! (in)
  call HistoryAddAttr( &
    & history = gthist_surface, &                     ! (inout)
    & varname = 'lon', attrname = 'gt_calc_weight', & ! (in)
    & value = 'lon_weight' )                          ! (in)
  call HistoryPut( &
    & history = gthist_surface, &                    ! (inout)
    & varname = 'lon_weight', array = x_Lon_Weight ) ! (in)

  call HistoryAddVariable( &
    & history = gthist_surface, &                        ! (inout)
    & varname = 'lat_weight', &                          ! (in)
    & dims = StoA('lat'), &                              ! (in)
    & longname = 'weight for integration in latitude', & ! (in)
    & units = 'radian', xtype = 'double' )               ! (in)
  call HistoryAddAttr( &
    & history = gthist_surface, &                     ! (inout)
    & varname = 'lat', attrname = 'gt_calc_weight', & ! (in)
    & value = 'lat_weight' )                          ! (in)
  call HistoryPut( &
    & history = gthist_surface, &                    ! (inout)
    & varname = 'lat_weight', array = y_Lat_Weight ) ! (in)

  call HistoryAddVariable( &
    & history = gthist_surface, &                  ! (inout)
    & varname = 'SurfTemp', &                      ! (in)
    & dims = StoA('lon', 'lat'), &                 ! (in)
    & longname = 'Surface Temperature', &          ! (in)
    & units = 'K', xtype = 'double' )              ! (in)
  call HistoryAddAttr( &
    & history = gthist_surface, &                         ! (inout)
    & varname = 'SurfTemp', attrname = 'standard_name', & ! (in)
    & value = 'surface_temperature' )                     ! (in)

  call HistoryPut( &
    & history = gthist_surface, &                 ! (inout)
    & varname = 'SurfTemp', array = xy_SurfTemp ) ! (in)

  call HistoryClose( history = gthist_surface ) ! (out)

end program surface_data_test_prepnc00
