#!/bin/bash

export MPIFLAG='no'
#export MPIFLAG='yes'

if [ $MPIFLAG == 'yes' ] ; then
    export FC=mpispmfrt
    export MPISYM='-mpi'
else
    export FC=spmfrt
    export MPISYM=''
fi

# check
which dpkg-architecture >& /dev/null
if [ $? == 1 ] ; then
    echo "dpkg-architecture does not exist."
    exit
fi
which bc >& /dev/null
if [ $? == 1 ] ; then
    echo "bc does not exist."
    exit
fi


export FFLAGS="-O3 -pedantic -DSJPACK -DSLTT2D1DMONOTONIC"
#export FFLAGS="-O3 -pedantic -DSJPACK -DSLTT2D1DMONOTONIC -DINCLUDE_TIME_ORIGIN"
#export FFLAGS="-std=f95 -pedantic -DSJPACK -DSLTT2D1DMONOTONIC"
#export FFLAGS="-pedantic -DSJPACK -DSLTT2D1DMONOTONIC -DINCLUDE_TIME_ORIGIN"
#export FFLAGS="-pedantic -DSJPACK -DSLTT2D1DMONOTONIC -DAXISYMMETRY"
#export FFLAGS="-pedantic -DSJPACK -DSLTT2D1DMONOTONIC -DRRTMG"
#export FFLAGS="-pedantic -DSJPACK -DSLTT2D1DMONOTONIC -DJMAVDIFF"
#export FFLAGS="-pedantic -fopenmp -fno-var-tracking-assignments -DSJPACK -DSLTT2D1DMONOTONIC"
export FFLAGS="-Ofast -g -fopenmp -fbacktrace -ffpe-trap=invalid,zero,overflow -fbounds-check -Wall -DSJPACK -DSLTT2D1DMONOTONIC"
export FFLAGS="-Ofast -g -fopenmp -fbacktrace -ffpe-trap=invalid,zero,overflow -fbounds-check -Wall -DSJPACK -DSLTT2D1DMONOTONIC -DKDONLY"
export FFLAGS="-O2 -g -fopenmp -fbacktrace -ffpe-trap=invalid,zero,overflow -fbounds-check -Wall -DSJPACK -DSLTT2D1DMONOTONIC -DKDONLY"

DEB_HOST_MULTIARCH=`dpkg-architecture -qDEB_HOST_MULTIARCH`

debian_version=`cat /etc/debian_version`
version9="9.0"

export path_ispack="/usr/lib/$DEB_HOST_MULTIARCH/libispack"$MPISYM".a"
export path_gtool5="/usr/lib/$DEB_HOST_MULTIARCH/gtool5"$MPISYM"/lib/libgtool5.a"
export path_spml="/usr/lib/$DEB_HOST_MULTIARCH/spml"$MPISYM"/lib/libspml-lapack-lapack.a"
if [ `echo "$debian_version >= $version9" | bc` == 1 ] ; then
    export path_netcdfc="/usr/lib/$DEB_HOST_MULTIARCH/libnetcdf.so"
    export path_netcdff="/usr/lib/$DEB_HOST_MULTIARCH/libnetcdff.a"
    export path_netcdf="/usr/include"
else
    export path_netcdfc="/usr/lib/libnetcdf.a"
    export path_netcdff="/usr/lib/libnetcdff.a"
    export path_netcdf="/usr/include/netcdf"
fi

./configure \
    --with-netcdf=$path_netcdfc \
    --with-netcdff=$path_netcdff \
    --with-netcdf-include=$path_netcdf \
    --with-ispack=$path_ispack \
    --with-gtool5=$path_gtool5 \
    --with-spml=$path_spml

make

