#!/usr/bin/env ruby
#
#= Remove Preamble from Latex Format
#
#  Developers :: Yasuhiro MORIKAWA
#  Version    :: $Id: latex2body.rb,v 1.1 2008/07/30 08:41:32 morikawa Exp $
#
#== Overview
#
#Remove Preamble from Latex Format Contents. Input data is STDIN.
#And Output to STDOUT.
#
#
#= Operation Environment
#
#This program is operated in ruby 1.8.2 (2005-01-10) [i386-linux].
#
#== Usage
#
#   $ latex2body.rb < latex > body
#
#== Desctiption
#
#None
#
#== Future Plans
#
#None
#
#== Notes
#
#None
#
#== Acknowledgements
#
#None
#
#== History
#
#These entries is generated by CVS automatically.
#So do not add new information manually.
#(But please adjust old log format to latest log format manually,
#if format gap between them causes).
#
#$Log: latex2body.rb,v $
#Revision 1.1  2008/07/30 08:41:32  morikawa
#Initial revision
#
#Revision 1.1.1.1  2007/06/21 03:23:59  morikawa
#DCPAM (Dennou Club Planetary Atmosphere Model) Version 4
#
#Revision 1.1.1.1  2005/11/08 14:10:22  morikawa
#dcpam (Dennou Club Planetary Atmospheric Model) version 3
#
#Revision 1.1  2005/05/16 14:09:46  morikawa
#* This script output latex body (without preamble) from entire latex
#  format.
#
#
##################################################

require "kconv"

##################################################

#
#== Latex2Body
#
module Latex2Body

  #
  # 定数の誓瀋
  
  衷顆咏艾  地俎夘波督 偵銕阨 柱
  本文始まりのマーカ
  BEGINDOC = '\begin{document}'

  # 本文終わりのマーカ
  ENDDOC = '\end{document}'

  # CVSHOST
  CVS_HOST       = "www.gfd-dennou.org"

  # CVSROOT
  CVS_ROOT       = "/GFD_Dennou_Club/ftp/arch/dcpam/cvsroot"

  # CVS のプロジェクト名
  CVS_PROJECT    = "dcpam2"

  # バージョンナンバー (CVS により自動管理)
  VER = "$Revision: 1.1 $"

  #
  # これを呼ぶことで、引数から \begin{document} より前と
  # \end{document} より後ろを除いて返す。
  #
  def remove_preamble(all=nil)
    return nil    unless str_and_notspace?(all)

    begindoc = Regexp.quote(BEGINDOC)
    enddoc   = Regexp.quote(ENDDOC)

    latex_body_each_line = all.split(/\n/)
    debug(latex_body_each_line)

    latex_body = ""
    bodyflag = false
    latex_body_each_line.each{ |line|
      if /#{begindoc}/ =~ line then
        bodyflag  = true
        next
      elsif /#{enddoc}/ =~ line
        bodyflag  = false
      else
        latex_body << line + "\n" if bodyflag
      end
    }

    debug(latex_body)
    return latex_body
  end

  #
  # デバッグ出力用メソッド。組み込み関数 $DEBUG が真の場合 (つまり、
  # プログラムを $ ruby -d ./xxxxxx.rb として呼び出した場合) に
  # debug メソッドに代入された変数を出力する。
  #
  def debug(*args)
    p [caller.first, *args] if $DEBUG
  end
  private :debug

  #
  # 警告またはエラー。
  # err が nil や false の場合、mes に与えられたメッセージを
  # 警告として表示する。err が真の場合はそのメッセージの出力
  # と同時にエラーを発誓犬気察▲廛蹈哀薀爐鮟擦気擦襦
  纈鴟癇 に変数を与えると、エラーの種類を指定できる。
  # quiet を true にすると、err が nil の場合、何も動作しなくなる。
  #
  def warn_or_err(mes=nil, err=nil, quiet=nil, errvar=nil)
    return nil if !mes

    errvar = RuntimeError if !errvar

    if err then
      raise errvar, "Error: #{mes}"
    elsif !quiet
      $stdout.print "[#{caller.first}] \n     Warning: #{mes}"
      return nil
    end
  end
  private :warn_or_err

  #
  # 代入された変数が、文字列で、且つ空白文字のみではないことを
  # 調べるメソッド。日本語であっても、文字列が入っていれば true を返す。
  #
  def str_and_notspace?(obj)
    debug(obj)

    if !obj.instance_of?(String) then
      return false
    end

    # 日本語の文字列も対応できるように
    Kconv::toeuc(obj)

    if /\S+/e =~ obj.chomp.strip then
      return true
    else
      return false
    end
  end
  private :str_and_notspace?

end

######################################################
if $0 == __FILE__
  include Latex2Body

  body = remove_preamble($stdin.read)

  $stdout.print body
end
