# -*- coding: euc-jp -*-
require "numru/ggraph"
include NumRu
include NMath

$itr = 2
virafn = "../../../../data_Venus/Venus_VIRA+GasVMR+CldMMR+UVabsMMR_H2O_CO2_CO_SO2_HF_OCS_N2.nc"

label = ["VIRA", "DCPAM", "px2", "px4", "px8", "px16", "tx2", "b064", "filter", "radeq"]
dira = [
#  "",
]
ncfna = [virafn]
for idir in 0..(dira.size-1)
  ncfna << Dir.glob(dira[idir]+"/profile*.nc").sort[-1]
end

ncfna << "out/Temp.nc"

for ifile in 0..(ncfna.size-1)
  print ifile, ":", ncfna[ifile], "\n"
end

vara = ['Temp', 'VMR', 'VMR']
vara = ['Temp']
vara = ['Temp', 'Temp', 'Temp']

for ivar in 0..(vara.size)-1
  for ifile in 0..ncfna.size-1

    ncfn = ncfna[ifile]
    var  = vara[ivar]

    gp  = GPhys::IO.open( ncfn, var )

    if ifile == 1 then
      gp = gp.cut('lat'=>0).mean('lon').mean('time')
    elsif ifile == 2 then
      gp = gp.cut('lat'=>30).mean('lon').mean('time')
    elsif ifile == 3 then
      gp = gp.cut('lat'=>60).mean('lon').mean('time')
    elsif ifile == 4 then
      gp = gp.cut('lat'=>90).mean('lon').mean('time')
    end

#    gp = gp.copy
#    z = gp.axis('Press').pos.convert_units( Units['hPa'] )
#    z.units = 'hPa'
#    gp.axis('Press').set_pos(z)

#    if ivar > 0 then
#      gp = gp.cut('MolNum'=>ivar-1)
#    end

    gpp = gp.coord('Press')


#    puts var
#    for k in 0..gp.val.size-1
#      puts gpp.val[k].to_s + ', ' + gp.val[k].to_s
#    end


    if ( ivar == 0 ) && ( ifile == 0 ) then

      print "1: Display,  2: File\n"
      citr = gets
      citr = citr.chomp!
      DCL.gropn(citr.to_i)
#      DCL.gropn(1)
      DCL.sldiv('y',3,1)           # 2x2˲ʬ, 'y'=yoko: 墪墪...
#      DCL.sldiv('y',2,1)           # 2x2˲ʬ, 'y'=yoko: 墪墪...
      DCL.sgpset('lcntl', false)   # ʸᤷʤ
      DCL.sgpset('lfull',true)     # ɽ
      DCL.uzfact(0.7)             # ɸʸ󥵥 0.75 
      DCL.sgpset('lfprop',true)    # ץݡʥեȤȤ

      DCL.sgpset('lclip', true)

      DCL.glpset('lmiss',true)
      #DCL.glpset('rmiss',rmiss)
    end

    if ifile == 0 then
      case ivar
      when 0 then
#        x1 = 150; x2 = 350
        x1 = 120; x2 = 260
        x1 = 120; x2 = 350
        x1 = 120; x2 = 500
        x1 = 120; x2 = 800
        itr = 2
        itr = $itr
      when 1 then
#        x1 = 1e-6; x2 = 1.0e-1
#        x1 = 1e-6; x2 = 1.0e0
#        itr = 4
        x1 = -50; x2 = 50
        itr = 2
        itr = $itr
      when 2 then
#        x1 = 1e-8; x2 = 1.0e-4
#        itr = 4
        x1 = -1e-2; x2 = 1e-2
        itr = 2
        itr = $itr
      end
      #< GGraph ˤ  >
      vpx1 = 0.1; vpx2 = 0.4; vpy1 = 0.15; vpy2 = 0.9
#      vpx1 = 0.1; vpx2 = 0.65; vpy1 = 0.15; vpy2 = 0.8
#      y1 = 1050.0; y2 = 1.0e-4
#      y1 = 1050.0; y2 = 1.0e-1
      y1 = 100.0e5; y2 = 1.0e0
      #
      GGraph.set_fig 'itr'=>itr, 'viewport'=>[vpx1,vpx2,vpy1,vpy2], 'yrev'=>'units:Pa', 'window'=>[x1,x2,y1,y2]
      #GGraph.set_axes('xlabelint'=>30)
    end
    if ifile == 0 then
      flag_first = true
    else
      flag_first = false
    end
    line_index = (ifile+1) * 10 + 1
    line_type  = 1
#    case ifile
#    when 0 then
#      line_index = ifile * 100 + 1
#    when 1 then
#      line_index = 9 * 100 + 1 # red
#    when 2 then
#      line_index = 5 * 100 + 1 # green
#    when 3 then
#      line_index = 2 * 100 + 1 # blue
#    when 4 then
#      line_index = 1 * 100 + 1 # pink
#    when 5 then
#      line_index = 0 * 100 + 1 # black
#      line_type  = 2
#    end
#    if ( ifile <= 1 ) || ( 5 <= ifile ) then
    #    if ifile >= 1 then
    case ivar
    when 0 then
      GGraph.line( gp, flag_first, 'annotate'=>false, 'exchange'=>true, 'title'=>"", 'index'=>line_index, 'type'=>line_type, 'legend'=>label[ifile], 'legend_vx'=>0.2 )
    when 1 then
      if ifile == 0 then
        gp0 = gp.copy
        #
        na_ss    = NArray.to_na([0.0,0.0])
        na_press = NArray.to_na([gp.coord('Press').val[0],gp.coord('Press').val[-1]*0.1])
        va_press = VArray.new( na_press,
                               {"long_name"=>"pressure", "units"=>"Pa"},
                               "press" )
        ax_press = Axis.new.set_pos(va_press)
        va_ss = VArray.new( na_ss,
                            {"long_name"=>"Temperature difference", "units"=>"K"},
                            "ss" )
        gpss = GPhys.new( Grid.new(ax_press), va_ss )
        GGraph.line( gpss, flag_first, 'annotate'=>false, 'exchange'=>true, 'title'=>"", 'index'=>line_index, 'type'=>2 )
      else
        GGraph.line( gp-gp0, flag_first, 'annotate'=>false, 'exchange'=>true, 'title'=>"", 'index'=>line_index, 'type'=>line_type )
      end
    when 2 then
      if ifile == 0 then
        na_ss    = NArray.to_na([0.0,0.0])
        na_press = NArray.to_na([gp.coord('Press').val[0],gp.coord('Press').val[-1]*0.1])
        va_press = VArray.new( na_press,
                               {"long_name"=>"pressure", "units"=>"Pa"},
                               "press" )
        ax_press = Axis.new.set_pos(va_press)
        va_ss = VArray.new( na_ss,
                            {"long_name"=>"Static stability", "units"=>"s-2"},
                            "ss" )
        gpss = GPhys.new( Grid.new(ax_press), va_ss )
        GGraph.line( gpss, flag_first, 'annotate'=>false, 'exchange'=>true, 'title'=>"", 'index'=>line_index, 'type'=>2 )
      end

      # dT/dz = dT/dp dp/dz = -rho g 1/p dT/dlnp = -p/(RT) g 1/p dT/dlnp
      #       = -p/(RT) g 1/p dT/dlnp = = -g/(RT) dT/dlnp
      grav = 8.9
      cp   = 837.6
      gasc = 8.314/43.45e-3
      nn = gp.val.size
      na_temp  = gp.val
      na_press = gp.coord('Press').val
      na_ss = ( na_temp[1..nn-1] - na_temp[0..nn-2] ) / log( na_press[1..nn-1] / na_press[0..nn-2] )
      na_ss = na_ss * ( - grav / ( gasc * na_temp[0..nn-2] ) )
      na_ss = na_ss + grav / cp
      #
      na_ss = na_temp[1..nn-1] - na_temp[0..nn-2]
      na_ss = na_ss / ( - ( gasc * na_temp[0..nn-2] ) / grav * log( na_press[1..nn-1] / na_press[0..nn-2] ) )
      na_ss = na_ss + grav / cp
      #
      va_press = VArray.new( na_press[0..nn-2],
                             {"long_name"=>"pressure", "units"=>"Pa"},
                             "press" )
      ax_press = Axis.new.set_pos(va_press)
      va_ss = VArray.new( na_ss,
                             {"long_name"=>"static stability", "units"=>"s-2"},
                             "ss" )
      gpss = GPhys.new( Grid.new(ax_press), va_ss )
      GGraph.line( gpss, false, 'annotate'=>false, 'exchange'=>true, 'title'=>"", 'index'=>line_index, 'type'=>line_type )
    end
  end

end

DCL.grcls
