!= コマンドライン引数解析処理
!
!= Command line option parser
!
! Authors::   Yoshiyuki O. Takahashi, Yasuhiro MORIKAWA
! Version::   $Id: option_parser.f90,v 1.3 2010/08/30 01:54:45 yot Exp $ 
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module option_parser
  !
  != コマンドライン引数解析処理
  !
  != Command line option parser
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! コマンドライン引数の解析処理を行います. 
  !
  ! Command line options are parsed
  !
  !== Procedures List
  !
  ! OptParseInit  :: コマンドライン引数の解析処理
  ! ------------  :: ------------
  ! OptParseInit  :: Parse of command line options

  ! モジュール引用 ; USE statements
  !

  ! 種別型パラメタ
  ! Kind type parameter
  !
  use dc_types, only: STRING  ! 文字列. Strings. 

  ! 宣言文 ; Declaration statements
  !
  implicit none
  private

  ! 公開手続き
  ! Public procedure
  !
  public:: OptParseInit

  ! 公開変数
  ! Public variables
  !
  logical, save, public:: option_parser_inited = .false.
                              ! 初期設定フラグ. 
                              ! Initialization flag
  logical, save:: namelist_flag = .false.
                              ! NAMELIST ファイル指定の有無を示すフラグ. 
                              ! Flag of NAMELIST file specification

  ! 非公開変数
  ! Private variables
  !
  character(*), parameter:: module_name = 'option_parser'
                              ! モジュールの名称. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: option_parser.f90,v 1.3 2010/08/30 01:54:45 yot Exp $'
                              ! モジュールのバージョン
                              ! Module version

contains

  subroutine OptParseInit( &
    & namelist_filename,   & ! (out)
    & exec_name, brief     & ! (in ) optional
    & )
    !
    ! option_parser モジュールの初期設定を行います. 
    !
    ! Initialize "option_parser" module. 
    !

    ! モジュール引用 ; USE statements
    !

    ! 文字列操作
    ! Character handling
    !
    use dc_string, only: StoA

    ! コマンドライン引数処理下請け
    ! Command line option parser subcontractor
    !
    use dc_args, only: ARGS, &
      & DCArgsOpen,  DCArgsHelpMsg, DCArgsOption, &
      & DCArgsDebug, DCArgsHelp,    DCArgsStrict, DCArgsClose

    ! 組み込み関数 PRESENT の拡張版関数
    ! Extended functions of intrinsic function "PRESENT"
    !
    use dc_present, only: present_and_not_empty

    ! 宣言文 ; Declaration statements
    !
    implicit none
    character(*), intent(out)          :: namelist_filename
                              ! NAMELIST ファイルの名称. 
                              ! NAMELIST file name
    character(*), intent(in ), optional:: exec_name
                              ! 実行ファイル名. 
                              ! Executable file name
    character(*), intent(in ), optional:: brief
                              ! 実行ファイルの簡潔な説明
                              ! Brief account of executable file

    character(STRING):: ename
                              ! 実行ファイル名. 
                              ! Executable file name
    character(STRING):: brief_msg
                              ! 実行ファイルの簡潔な説明
                              ! Brief account of executable file

    type(ARGS):: arg          ! コマンドライン引数. 
                              ! Command line options

    ! 実行文 ; Executable statement
    !

    if ( option_parser_inited ) return
    call InitCheck

    ! オプショナル引数の処理. 
    ! Handling of optional arguments 
    !
    if ( present_and_not_empty(exec_name) ) then
      ename = exec_name
    else
      ename = 'dcpam'
    end if

    if ( present_and_not_empty(brief) ) then
      brief_msg = brief
    else
      brief_msg = 'dcpam main program'
    end if

    ! コマンドライン引数の解析処理
    ! Parse command line arguments
    !
    call DCArgsOpen( arg )               ! (out)

    call DCArgsHelpMsg( arg, &                          ! (inout)
      & category = 'Title', &                           ! (in)
      & msg = trim(ename) // ': ' // trim(brief_msg) )  ! (in)
    call DCArgsHelpMsg( arg, &                      ! (inout)
      & category = 'Usage', &                       ! (in)
      & msg = './' // trim(ename) // ' [Options]' ) ! (in)

    call DCArgsOption( arg, &                 ! (inout)
      & options = StoA('-N', '--namelist'), & ! (in)
      & flag = namelist_flag, &               ! (out)
      & value = namelist_filename, &          ! (out)
      & help = "Namelist filename")           ! (in)

    call DCArgsDebug( arg )  ! (inout)
    call DCArgsHelp( arg )   ! (inout)
    call DCArgsStrict( arg ) ! (inout)

    call DCArgsClose( arg )  ! (inout)

    option_parser_inited = .true.
  end subroutine OptParseInit

  subroutine InitCheck
    !
    ! 依存モジュールの初期化チェック
    !
    ! Check initialization of dependency modules

    ! 実行文 ; Executable statement
    !


  end subroutine InitCheck


end module option_parser
