!= 予報変数の値の確認
!
!= Check values of prognostic variables
!
! Authors::   Yoshiyuki O. Takahashi
! Version::   $Id: check_prog_vars.f90,v 1.5 2013/02/19 01:33:12 yot Exp $ 
! Tag Name::  $Name:  $
! Copyright:: Copyright (C) GFD Dennou Club, 2008-2009. All rights reserved.
! License::   See COPYRIGHT[link:../../../COPYRIGHT]
!

module check_prog_vars
  !
  != 予報変数の値の確認
  !
  != Check values of prognostic variables
  !
  ! <b>Note that Japanese and English are described in parallel.</b>
  !
  ! 予報変数の値の確認
  !
  ! Check values of prognostic variables
  !
  !== Procedures List
  !
!!$  ! SurfaceFlux       :: 地表面フラックスの計算
!!$  ! SurfaceFluxOutput :: 地表面フラックスの出力
!!$  ! ------------      :: ------------
!!$  ! SurfaceFlux       :: Calculate surface fluxes
!!$  ! SurfaceFluxOutput :: Output surface fluxes
  !
  !== NAMELIST
  !
  ! NAMELIST#check_prog_vars_nml
  !

  ! モジュール引用 ; USE statements
  !

  ! 種別型パラメタ
  ! Kind type parameter
  !
  use dc_types, only: DP, &      ! 倍精度実数型. Double precision. 
    &                 STRING     ! 文字列.       Strings. 


  ! 宣言文 ; Declaration statements
  !
  implicit none
  private

  ! 公開手続き
  ! Public procedure
  !
  public :: CheckProgVars
  public :: CheckProgVarsInit

  ! 公開変数
  ! Public variables
  !

  ! 非公開変数
  ! Private variables
  !
  logical, save :: check_prog_vars_inited = .false.
                              ! 初期設定フラグ. 
                              ! Initialization flag

  real(DP), save:: TempMin
                            ! 温度最小値
                            ! Minimum value of temperature
  real(DP), save:: TempMax
                            ! 温度最大値
                            ! Maximum value of temperature
  real(DP), save:: VelMin
                            ! 風速最小値
                            ! Minimum value of wind velocity
  real(DP), save:: VelMax
                            ! 風速最大値
                            ! Maximum value of wind velocity

  character(*), parameter:: module_name = 'check_prog_vars'
                              ! モジュールの名称. 
                              ! Module name
  character(*), parameter:: version = &
    & '$Name:  $' // &
    & '$Id: check_prog_vars.f90,v 1.5 2013/02/19 01:33:12 yot Exp $'
                              ! モジュールのバージョン
                              ! Module version

  ! INTERFACE 文 ; INTERFACE statements
  !
!!$  interface SurfaceFlux
!!$    module procedure SurfaceFlux
!!$  end interface
!!$
!!$  interface SurfaceFluxOutput
!!$    module procedure SurfaceFluxOutput
!!$  end interface

contains

  subroutine CheckProgVars( &
    & xy_Ps, xyz_U, xyz_V, xyz_Temp, xyzf_QMix   & ! (in)
    & )
    !
    ! 予報変数の値の確認
    !
    ! Check values of prognostic variables
    !

    ! モジュール引用 ; USE statements
    !

    ! 格子点設定
    ! Grid points settings
    !
    use gridset, only: imax, & ! 経度格子点数. 
                               ! Number of grid points in longitude
      &                jmax, & ! 緯度格子点数. 
                               ! Number of grid points in latitude
      &                kmax    ! 鉛直層数. 
                               ! Number of vertical level

    ! 座標データ設定
    ! Axes data settings
    !
    use axesset, only: &
      & x_Lon,   & ! $ \lambda $ [rad.] . 経度. Longitude
      & y_Lat,   & ! $ \varphi $ [rad.] . 緯度. Latitude
      & z_Sigma    ! $ \sigma $ レベル (整数).  Full $ \sigma $ level

    ! 組成に関わる配列の設定
    ! Settings of array for atmospheric composition
    !
    use composition, only: ncmax

    ! メッセージ出力
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! 時刻管理
    ! Time control
    !
    use timeset, only: &
      & TimesetClockStart, TimesetClockStop

    ! デバッグ用ユーティリティ
    ! Utilities for debug
    !
    use dc_trace, only: DbgMessage, BeginSub, EndSub

    ! 物理・数学定数設定
    ! Physical and mathematical constants settings
    !
    use constants0, only: &
      & PI                    ! $ \pi $ .
                              ! Circular constant

    ! 宣言文 ; Declaration statements
    !
    implicit none
    real(DP), intent(in):: xy_Ps (0:imax-1, 1:jmax)
                              ! $ p_s (t-\Delta t) $ . 地表面気圧. Surface pressure (Pa)
    real(DP), intent(in):: xyz_U (0:imax-1, 1:jmax, 1:kmax)
                              ! $ u $ . 東西風速. Eastward wind
    real(DP), intent(in):: xyz_V (0:imax-1, 1:jmax, 1:kmax)
                              ! $ v $ . 南北風速. Northward wind
    real(DP), intent(in):: xyz_Temp (0:imax-1, 1:jmax, 1:kmax)
                              ! $ T $ . 温度 (整数レベル). 
                              ! Temperature (full level)
    real(DP), intent(in):: xyzf_QMix(0:imax-1, 1:jmax, 1:kmax, 1:ncmax)
                              ! $ q $ .     比湿. Specific humidity

    ! 作業変数
    ! Work variables
    !
    integer:: i               ! 経度方向に回る DO ループ用作業変数
                              ! Work variables for DO loop in longitude
    integer:: j               ! 緯度方向に回る DO ループ用作業変数
                              ! Work variables for DO loop in latitude
    integer:: k               ! 鉛直方向に回る DO ループ用作業変数
                              ! Work variables for DO loop in vertical direction

    real(DP) :: minval, maxval
    integer  :: mini, minj, mink
    integer  :: maxi, maxj, maxk


    ! 実行文 ; Executable statement
    !

    ! 初期化確認
    ! Initialization check
    !
    if ( .not. check_prog_vars_inited ) then
      call MessageNotify( 'E', module_name, 'This module has not been initialized.' )
    end if


    ! 計算時間計測開始
    ! Start measurement of computation time
    !
    call TimesetClockStart( module_name )



    i = 0
    j = 1
    k = 1
    minval = xyz_U(i,j,k)
    maxval = xyz_U(i,j,k)
    mini   = i
    minj   = j
    mink   = k
    maxi   = i
    maxj   = j
    maxk   = k
    do k = 1, kmax
      do j = 1, jmax
        do i = 0, imax-1
          if ( xyz_U   (i,j,k) < minval ) then
            minval = xyz_U   (i,j,k)
            mini   = i
            minj   = j
            mink   = k
          end if
          if ( maxval < xyz_U   (i,j,k) ) then
            maxval = xyz_U   (i,j,k)
            maxi   = i
            maxj   = j
            maxk   = k
          end if
        end do
      end do
    end do
    if ( minval  < VelMin  ) then
      call MessageNotify( 'M', module_name, 'Min value : U(%f,%f,%f) = %f.', &
        & d = (/ x_Lon(mini)*180.0_DP/PI, y_Lat(minj)*180.0_DP/PI, z_Sigma(mink), minval /) )
    end if
    if ( VelMax  < maxval  ) then
      call MessageNotify( 'M', module_name, 'Max value : U(%f,%f,%f) = %f.', &
        & d = (/ x_Lon(maxi)*180.0_DP/PI, y_Lat(maxj)*180.0_DP/PI, z_Sigma(maxk), maxval /) )
    end if

    i = 0
    j = 1
    k = 1
    minval = xyz_V(i,j,k)
    maxval = xyz_V(i,j,k)
    mini   = i
    minj   = j
    mink   = k
    maxi   = i
    maxj   = j
    maxk   = k
    do k = 1, kmax
      do j = 1, jmax
        do i = 0, imax-1
          if ( xyz_V   (i,j,k) < minval ) then
            minval = xyz_V   (i,j,k)
            mini   = i
            minj   = j
            mink   = k
          end if
          if ( maxval < xyz_V   (i,j,k) ) then
            maxval = xyz_V   (i,j,k)
            maxi   = i
            maxj   = j
            maxk   = k
          end if
        end do
      end do
    end do
    if ( minval  < VelMin  ) then
      call MessageNotify( 'M', module_name, 'Min value : V(%f,%f,%f) = %f.', &
        & d = (/ x_Lon(mini)*180.0_DP/PI, y_Lat(minj)*180.0_DP/PI, z_Sigma(mink), minval /) )
    end if
    if ( VelMax  < maxval  ) then
      call MessageNotify( 'M', module_name, 'Max value : V(%f,%f,%f) = %f.', &
        & d = (/ x_Lon(maxi)*180.0_DP/PI, y_Lat(maxj)*180.0_DP/PI, z_Sigma(maxk), maxval /) )
    end if

    i = 0
    j = 1
    k = 1
    minval = xyz_Temp(i,j,k)
    maxval = xyz_Temp(i,j,k)
    mini   = i
    minj   = j
    mink   = k
    maxi   = i
    maxj   = j
    maxk   = k
    do k = 1, kmax
      do j = 1, jmax
        do i = 0, imax-1
          if ( xyz_Temp(i,j,k) < minval ) then
            minval = xyz_Temp(i,j,k)
            mini   = i
            minj   = j
            mink   = k
          end if
          if ( maxval < xyz_Temp(i,j,k) ) then
            maxval = xyz_Temp(i,j,k)
            maxi   = i
            maxj   = j
            maxk   = k
          end if
        end do
      end do
    end do
    if ( minval  < TempMin ) then
      call MessageNotify( 'M', module_name, 'Min value : T(%f,%f,%f) = %f.', &
        & d = (/ x_Lon(mini)*180.0_DP/PI, y_Lat(minj)*180.0_DP/PI, z_Sigma(mink), minval /) )
    end if
    if ( TempMax < maxval  ) then
      call MessageNotify( 'M', module_name, 'Max value : T(%f,%f,%f) = %f.', &
        & d = (/ x_Lon(maxi)*180.0_DP/PI, y_Lat(maxj)*180.0_DP/PI, z_Sigma(maxk), maxval /) )
    end if


    ! ヒストリデータ出力
    ! History data output
    !

    ! 計算時間計測一時停止
    ! Pause measurement of computation time
    !
    call TimesetClockStop( module_name )

  end subroutine CheckProgVars

  !-------------------------------------------------------------------

  subroutine CheckProgVarsInit
    !
    ! check_prog_vars モジュールの初期化を行います. 
    ! NAMELIST#check_prog_vars_nml の読み込みはこの手続きで行われます. 
    !
    ! "check_prog_vars" module is initialized. 
    ! "NAMELIST#check_prog_vars_nml" is loaded in this procedure. 
    !

    ! モジュール引用 ; USE statements
    !

    ! NAMELIST ファイル入力に関するユーティリティ
    ! Utilities for NAMELIST file input
    !
    use namelist_util, only: namelist_filename, NmlutilMsg, NmlutilAryValid

    ! ファイル入出力補助
    ! File I/O support
    !
    use dc_iounit, only: FileOpen

    ! 種別型パラメタ
    ! Kind type parameter
    !
    use dc_types, only: STDOUT ! 標準出力の装置番号. Unit number of standard output

    ! 文字列操作
    ! Character handling
    !
    use dc_string, only: StoA

    ! メッセージ出力
    ! Message output
    !
    use dc_message, only: MessageNotify

    ! 宣言文 ; Declaration statements
    !
    implicit none

    integer:: unit_nml        ! NAMELIST ファイルオープン用装置番号. 
                              ! Unit number for NAMELIST file open
    integer:: iostat_nml      ! NAMELIST 読み込み時の IOSTAT. 
                              ! IOSTAT of NAMELIST read

    ! NAMELIST 変数群
    ! NAMELIST group name
    !
    namelist /check_prog_vars_nml/ &
      & VelMin, VelMax, TempMin, TempMax
          !
          ! デフォルト値については初期化手続 "check_prog_vars#CheckProgVarsInit" 
          ! のソースコードを参照のこと. 
          !
          ! Refer to source codes in the initialization procedure
          ! "check_prog_vars#CheckProgVarsInit" for the default values. 
          !

    ! 実行文 ; Executable statement
    !

    if ( check_prog_vars_inited ) return
!!$    call InitCheck

    ! デフォルト値の設定
    ! Default values settings
    !
    VelMin  = -300.0_DP
    VelMax  =  300.0_DP
    TempMin =   50.0_DP
    TempMax =  330.0_DP

    ! NAMELIST の読み込み
    ! NAMELIST is input
    !
    if ( trim(namelist_filename) /= '' ) then
      call FileOpen( unit_nml, &          ! (out)
        & namelist_filename, mode = 'r' ) ! (in)

      rewind( unit_nml )
      read( unit_nml, &                ! (in)
        & nml = check_prog_vars_nml, &  ! (out)
        & iostat = iostat_nml )        ! (out)
      close( unit_nml )

      call NmlutilMsg( iostat_nml, module_name ) ! (in)
    end if


    ! 印字 ; Print
    !
    call MessageNotify( 'M', module_name, '----- Initialization Messages -----' )

    call MessageNotify( 'M', module_name, '  VelMin  = %f', d = (/ VelMin  /) )
    call MessageNotify( 'M', module_name, '  VelMax  = %f', d = (/ VelMax  /) )
    call MessageNotify( 'M', module_name, '  TempMin = %f', d = (/ TempMin /) )
    call MessageNotify( 'M', module_name, '  TempMax = %f', d = (/ TempMax /) )

    call MessageNotify( 'M', module_name, '-- version = %c', c1 = trim(version) )

    check_prog_vars_inited = .true.

  end subroutine CheckProgVarsInit

  !--------------------------------------------------------------------------------------

end module check_prog_vars
